from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from witsml20.dimensionless_measure import DimensionlessMeasure
from witsml20.extension_name_value import ExtensionNameValue
from witsml20.force_per_volume_measure import ForcePerVolumeMeasure
from witsml20.length_measure import LengthMeasure
from witsml20.permeability_rock_measure import PermeabilityRockMeasure
from witsml20.pressure_measure import PressureMeasure
from witsml20.stim_fet_test_analysis_method import StimFetTestAnalysisMethod
from witsml20.time_measure import TimeMeasure
from witsml20.volume_per_volume_measure import VolumePerVolumeMeasure

__NAMESPACE__ = "http://www.energistics.org/energyml/data/witsmlv2"


@dataclass
class StimFetTest:
    """A diagnostic test that determines fluid efficiency.

    Fluid efficiency test (FET).

    :ivar analysis_method: An analysis method used for this FET.
    :ivar dtim_start: Start time for the FET.
    :ivar dtim_end: End time for the FET.
    :ivar end_pdl_duration: The end of the pressure-dependent leak-off
        portion of the FET.
    :ivar fluid_efficiency: A measurement, derived from a data frac, of
        the efficiency of a particular fluid in creating fracture area
        on a particular formation at a set of conditions.
    :ivar fracture_close_duration: The time at which the fracture
        effectively closes without proppant in place.
    :ivar fracture_close_pres: The pressure at which the fracture
        effectively closes without proppant in place.
    :ivar fracture_extension_pres: The fracture pressure limit for an
        unfractured formation is the fracture initiation pressure. This
        is typically considered the upper bound for the minimum
        horizontal stress or closure pressure. A step-rate test is used
        to determine the fracture extension pressure.
    :ivar fracture_gradient: The fracture gradient.
    :ivar fracture_length: The length of the fracture tip to tip;
        fracture half length is the length of one wing of a fracture
        from the wellbore to the tip.
    :ivar fracture_width: The width of a fracture at the wellbore.
        Hydraulic frac width is generated by frac fluid viscosity and/or
        pump rate (i.e., horsepower).
    :ivar net_pres: The difference between the fracture extension
        pressure and the pressure that exists in the fracture.
    :ivar pdl_coef: The pressure dependent leak-off coefficient.
    :ivar pore_pres: The pressure of the liquids in the formation pores.
    :ivar pseudo_radial_pres: The Horner plot is used to determine if
        pseudo-radial flow developed during pressure decline. If a semi-
        log straight line is observed and the line can be extrapolated
        to a reasonable value of reservoir pressure, then radial or
        pseudo-radial flow may be affecting the decline behavior. This
        suggests that the fracture is already closed and that data
        beyond the point of influence need not be considered in the
        evaluation of closure.
    :ivar residual_permeability: That permeability which remains after a
        fractured formation has closed, allowing the the formation
        fracture face to be pressurized before the fracture is
        mechanically reopened.
    :ivar extension_name_value: Extensions to the schema based on a
        name-value construct.
    :ivar uid: Unique identifier for this instance of StimFetTest.
    """
    analysis_method: List[StimFetTestAnalysisMethod] = field(
        default_factory=list,
        metadata={
            "name": "AnalysisMethod",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    dtim_start: Optional[str] = field(
        default=None,
        metadata={
            "name": "DTimStart",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
            "pattern": r".+T.+[Z+\-].*",
        }
    )
    dtim_end: Optional[str] = field(
        default=None,
        metadata={
            "name": "DTimEnd",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
            "pattern": r".+T.+[Z+\-].*",
        }
    )
    end_pdl_duration: Optional[TimeMeasure] = field(
        default=None,
        metadata={
            "name": "EndPdlDuration",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fluid_efficiency: Optional[VolumePerVolumeMeasure] = field(
        default=None,
        metadata={
            "name": "FluidEfficiency",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_close_duration: Optional[TimeMeasure] = field(
        default=None,
        metadata={
            "name": "FractureCloseDuration",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_close_pres: Optional[PressureMeasure] = field(
        default=None,
        metadata={
            "name": "FractureClosePres",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_extension_pres: Optional[PressureMeasure] = field(
        default=None,
        metadata={
            "name": "FractureExtensionPres",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_gradient: Optional[ForcePerVolumeMeasure] = field(
        default=None,
        metadata={
            "name": "FractureGradient",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_length: Optional[LengthMeasure] = field(
        default=None,
        metadata={
            "name": "FractureLength",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    fracture_width: Optional[LengthMeasure] = field(
        default=None,
        metadata={
            "name": "FractureWidth",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    net_pres: Optional[PressureMeasure] = field(
        default=None,
        metadata={
            "name": "NetPres",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    pdl_coef: Optional[DimensionlessMeasure] = field(
        default=None,
        metadata={
            "name": "PdlCoef",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    pore_pres: Optional[PressureMeasure] = field(
        default=None,
        metadata={
            "name": "PorePres",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    pseudo_radial_pres: Optional[PressureMeasure] = field(
        default=None,
        metadata={
            "name": "PseudoRadialPres",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    residual_permeability: Optional[PermeabilityRockMeasure] = field(
        default=None,
        metadata={
            "name": "ResidualPermeability",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    extension_name_value: List[ExtensionNameValue] = field(
        default_factory=list,
        metadata={
            "name": "ExtensionNameValue",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/witsmlv2",
        }
    )
    uid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
            "required": True,
            "max_length": 64,
        }
    )
