from __future__ import annotations
from enum import Enum

__NAMESPACE__ = "http://www.energistics.org/energyml/data/witsmlv2"


class PrincipalMeridian(Enum):
    """
    Specifies values for the principal meridians for the United States Public
    Land Surveys.

    :cvar VALUE_1ST_PRINCIPAL_MERIDIAN: Indiana, Ohio
    :cvar VALUE_2ND_PRINCIPAL_MERIDIAN: Indiana
    :cvar VALUE_3RD_PRINCIPAL_MERIDIAN: Illinois
    :cvar VALUE_4TH_PRINCIPAL_MERIDIAN: Illinois, Wisconsin
    :cvar VALUE_5TH_PRINCIPAL_MERIDIAN: Iowa, Missouri, Arkansas
    :cvar VALUE_6TH_PRINCIPAL_MERIDIAN: Kansas, Nebraska
    :cvar BLACK_HILLS_MERIDIAN: South Dakota
    :cvar BOISE_MERIDIAN: Idaho
    :cvar CHICKASAW_MERIDIAN: Mississippi
    :cvar CHOCTAW_MERIDIAN: Mississippi
    :cvar CIMARRON_MERIDIAN: Texas
    :cvar COPPER_RIVER_MERIDIAN: Alaska
    :cvar FAIRBANKS_MERIDIAN: Alaska
    :cvar GILA_AND_SALT_RIVER_MERIDIAN: Arizona
    :cvar HUMBOLDT_MERIDIAN: California
    :cvar HUNTSVILLE_MERIDIAN: Alabama
    :cvar INDIAN_MERIDIAN: Oklahome
    :cvar KATEEL_RIVER_MERIDIAN: Alaska
    :cvar LOUSIANA_MERIDIAN: Lousiana
    :cvar MICHIGAN_MERIDIAN: Michigan
    :cvar MONTANA_MERIDIAN: Montana
    :cvar MOUNT_DIABLO_MERIDIAN: California
    :cvar NAVAJO_MERIDIAN: Arizona portion of Navajo nation
    :cvar NEW_MEXICO_MERIDIAN: New Mexico
    :cvar SAINT_HELENA_MERIDIAN: Louisiana
    :cvar SAINT_STEPHENS_MERIDIAN: Alabama
    :cvar SALT_LAKE_MERIDIAN: Utah
    :cvar SAN_BERNARDO_MERIDIAN: California
    :cvar SEWARD_MERIDIAN: Alaska
    :cvar TALLAHASSEE_MERIDIAN: Floridia
    :cvar UINTAH_MERIDIAN: Utah
    :cvar UMIAT_MERIDIAN: Alaska
    :cvar UTE_MERIDIAN: Colorado
    :cvar WASHINGTON_MERIDIAN: Mississippi
    :cvar WILLIAMETTE_MERIDIAN: Washington
    :cvar WIND_RIVER_MERIDIAN: Wyoming
    """
    VALUE_1ST_PRINCIPAL_MERIDIAN = "1st Principal Meridian"
    VALUE_2ND_PRINCIPAL_MERIDIAN = "2nd Principal Meridian"
    VALUE_3RD_PRINCIPAL_MERIDIAN = "3rd Principal Meridian"
    VALUE_4TH_PRINCIPAL_MERIDIAN = "4th Principal Meridian"
    VALUE_5TH_PRINCIPAL_MERIDIAN = "5th Principal Meridian"
    VALUE_6TH_PRINCIPAL_MERIDIAN = "6th Principal Meridian"
    BLACK_HILLS_MERIDIAN = "Black Hills Meridian"
    BOISE_MERIDIAN = "Boise Meridian"
    CHICKASAW_MERIDIAN = "Chickasaw Meridian"
    CHOCTAW_MERIDIAN = "Choctaw Meridian"
    CIMARRON_MERIDIAN = "Cimarron Meridian"
    COPPER_RIVER_MERIDIAN = "Copper River Meridian"
    FAIRBANKS_MERIDIAN = "Fairbanks Meridian"
    GILA_AND_SALT_RIVER_MERIDIAN = "Gila and Salt River Meridian"
    HUMBOLDT_MERIDIAN = "Humboldt Meridian"
    HUNTSVILLE_MERIDIAN = "Huntsville Meridian"
    INDIAN_MERIDIAN = "Indian Meridian"
    KATEEL_RIVER_MERIDIAN = "Kateel River Meridian"
    LOUSIANA_MERIDIAN = "Lousiana Meridian"
    MICHIGAN_MERIDIAN = "Michigan Meridian"
    MONTANA_MERIDIAN = "Montana Meridian"
    MOUNT_DIABLO_MERIDIAN = "Mount Diablo Meridian"
    NAVAJO_MERIDIAN = "Navajo Meridian"
    NEW_MEXICO_MERIDIAN = "New Mexico Meridian"
    SAINT_HELENA_MERIDIAN = "Saint Helena Meridian"
    SAINT_STEPHENS_MERIDIAN = "Saint Stephens Meridian"
    SALT_LAKE_MERIDIAN = "Salt Lake Meridian"
    SAN_BERNARDO_MERIDIAN = "San Bernardo Meridian"
    SEWARD_MERIDIAN = "Seward Meridian"
    TALLAHASSEE_MERIDIAN = "Tallahassee Meridian"
    UINTAH_MERIDIAN = "Uintah Meridian"
    UMIAT_MERIDIAN = "Umiat Meridian"
    UTE_MERIDIAN = "Ute Meridian"
    WASHINGTON_MERIDIAN = "Washington Meridian"
    WILLIAMETTE_MERIDIAN = "Williamette Meridian"
    WIND_RIVER_MERIDIAN = "Wind River Meridian"
