from __future__ import annotations
from enum import Enum

__NAMESPACE__ = "http://www.energistics.org/energyml/data/commonv2"


class MeasureType(Enum):
    """Measure class values.

    The list of standard values is contained in the WITSML
    enumValues.xml file.
    """
    ABSORBED_DOSE = "absorbed dose"
    ACTIVITY_OF_RADIOACTIVITY = "activity of radioactivity"
    AMOUNT_OF_SUBSTANCE = "amount of substance"
    AMOUNT_OF_SUBSTANCE_PER_AMOUNT_OF_SUBSTANCE = "amount of substance per amount of substance"
    AMOUNT_OF_SUBSTANCE_PER_AREA = "amount of substance per area"
    AMOUNT_OF_SUBSTANCE_PER_TIME = "amount of substance per time"
    AMOUNT_OF_SUBSTANCE_PER_TIME_PER_AREA = "amount of substance per time per area"
    AMOUNT_OF_SUBSTANCE_PER_VOLUME = "amount of substance per volume"
    ANGLE_PER_LENGTH = "angle per length"
    ANGLE_PER_VOLUME = "angle per volume"
    ANGULAR_ACCELERATION = "angular acceleration"
    ANGULAR_VELOCITY = "angular velocity"
    API_GAMMA_RAY = "api gamma ray"
    API_GRAVITY = "api gravity"
    API_NEUTRON = "api neutron"
    AREA = "area"
    AREA_PER_AMOUNT_OF_SUBSTANCE = "area per amount of substance"
    AREA_PER_AREA = "area per area"
    AREA_PER_COUNT = "area per count"
    AREA_PER_MASS = "area per mass"
    AREA_PER_TIME = "area per time"
    AREA_PER_VOLUME = "area per volume"
    ATTENUATION_PER_FREQUENCY_INTERVAL = "attenuation per frequency interval"
    CAPACITANCE = "capacitance"
    CATION_EXCHANGE_CAPACITY = "cation exchange capacity"
    DATA_TRANSFER_SPEED = "data transfer speed"
    DIFFUSION_COEFFICIENT = "diffusion coefficient"
    DIFFUSIVE_TIME_OF_FLIGHT = "diffusive time of flight"
    DIGITAL_STORAGE = "digital storage"
    DIMENSIONLESS = "dimensionless"
    DIPOLE_MOMENT = "dipole moment"
    DOSE_EQUIVALENT = "dose equivalent"
    DYNAMIC_VISCOSITY = "dynamic viscosity"
    ELECTRIC_CHARGE = "electric charge"
    ELECTRIC_CHARGE_PER_AREA = "electric charge per area"
    ELECTRIC_CHARGE_PER_MASS = "electric charge per mass"
    ELECTRIC_CHARGE_PER_VOLUME = "electric charge per volume"
    ELECTRIC_CONDUCTANCE = "electric conductance"
    ELECTRIC_CONDUCTIVITY = "electric conductivity"
    ELECTRIC_CURRENT = "electric current"
    ELECTRIC_CURRENT_DENSITY = "electric current density"
    ELECTRIC_FIELD_STRENGTH = "electric field strength"
    ELECTRIC_POTENTIAL_DIFFERENCE = "electric potential difference"
    ELECTRIC_RESISTANCE = "electric resistance"
    ELECTRIC_RESISTANCE_PER_LENGTH = "electric resistance per length"
    ELECTRICAL_RESISTIVITY = "electrical resistivity"
    ELECTROMAGNETIC_MOMENT = "electromagnetic moment"
    ENERGY = "energy"
    ENERGY_LENGTH_PER_AREA = "energy length per area"
    ENERGY_LENGTH_PER_TIME_AREA_TEMPERATURE = "energy length per time area temperature"
    ENERGY_PER_AREA = "energy per area"
    ENERGY_PER_LENGTH = "energy per length"
    ENERGY_PER_MASS = "energy per mass"
    ENERGY_PER_MASS_PER_TIME = "energy per mass per time"
    ENERGY_PER_VOLUME = "energy per volume"
    FORCE = "force"
    FORCE_AREA = "force area"
    FORCE_LENGTH_PER_LENGTH = "force length per length"
    FORCE_PER_FORCE = "force per force"
    FORCE_PER_LENGTH = "force per length"
    FORCE_PER_VOLUME = "force per volume"
    FREQUENCY = "frequency"
    FREQUENCY_INTERVAL = "frequency interval"
    HEAT_CAPACITY = "heat capacity"
    HEAT_FLOW_RATE = "heat flow rate"
    HEAT_TRANSFER_COEFFICIENT = "heat transfer coefficient"
    ILLUMINANCE = "illuminance"
    INDUCTANCE = "inductance"
    ISOTHERMAL_COMPRESSIBILITY = "isothermal compressibility"
    KINEMATIC_VISCOSITY = "kinematic viscosity"
    LENGTH = "length"
    LENGTH_PER_LENGTH = "length per length"
    LENGTH_PER_MASS = "length per mass"
    LENGTH_PER_PRESSURE = "length per pressure"
    LENGTH_PER_TEMPERATURE = "length per temperature"
    LENGTH_PER_TIME = "length per time"
    LENGTH_PER_VOLUME = "length per volume"
    LIGHT_EXPOSURE = "light exposure"
    LINEAR_ACCELERATION = "linear acceleration"
    LINEAR_THERMAL_EXPANSION = "linear thermal expansion"
    LOGARITHMIC_POWER_RATIO = "logarithmic power ratio"
    LOGARITHMIC_POWER_RATIO_PER_LENGTH = "logarithmic power ratio per length"
    LUMINANCE = "luminance"
    LUMINOUS_EFFICACY = "luminous efficacy"
    LUMINOUS_FLUX = "luminous flux"
    LUMINOUS_INTENSITY = "luminous intensity"
    MAGNETIC_DIPOLE_MOMENT = "magnetic dipole moment"
    MAGNETIC_FIELD_STRENGTH = "magnetic field strength"
    MAGNETIC_FLUX = "magnetic flux"
    MAGNETIC_FLUX_DENSITY = "magnetic flux density"
    MAGNETIC_FLUX_DENSITY_PER_LENGTH = "magnetic flux density per length"
    MAGNETIC_PERMEABILITY = "magnetic permeability"
    MAGNETIC_VECTOR_POTENTIAL = "magnetic vector potential"
    MASS = "mass"
    MASS_LENGTH = "mass length"
    MASS_PER_AREA = "mass per area"
    MASS_PER_ENERGY = "mass per energy"
    MASS_PER_LENGTH = "mass per length"
    MASS_PER_MASS = "mass per mass"
    MASS_PER_TIME = "mass per time"
    MASS_PER_TIME_PER_AREA = "mass per time per area"
    MASS_PER_TIME_PER_LENGTH = "mass per time per length"
    MASS_PER_VOLUME = "mass per volume"
    MASS_PER_VOLUME_PER_LENGTH = "mass per volume per length"
    MASS_PER_VOLUME_PER_PRESSURE = "mass per volume per pressure"
    MASS_PER_VOLUME_PER_TEMPERATURE = "mass per volume per temperature"
    MOBILITY = "mobility"
    MOLAR_ENERGY = "molar energy"
    MOLAR_HEAT_CAPACITY = "molar heat capacity"
    MOLAR_VOLUME = "molar volume"
    MOLECULAR_WEIGHT = "molecular weight"
    MOMENT_OF_FORCE = "moment of force"
    MOMENT_OF_INERTIA = "moment of inertia"
    MOMENTUM = "momentum"
    NORMALIZED_POWER = "normalized power"
    PERMEABILITY_LENGTH = "permeability length"
    PERMEABILITY_ROCK = "permeability rock"
    PERMITTIVITY = "permittivity"
    PLANE_ANGLE = "plane angle"
    POTENTIAL_DIFFERENCE_PER_POWER_DROP = "potential difference per power drop"
    POWER = "power"
    POWER_PER_AREA = "power per area"
    POWER_PER_POWER = "power per power"
    POWER_PER_VOLUME = "power per volume"
    PRESSURE = "pressure"
    PRESSURE_PER_PRESSURE = "pressure per pressure"
    PRESSURE_PER_TIME = "pressure per time"
    PRESSURE_PER_VOLUME = "pressure per volume"
    PRESSURE_SQUARED = "pressure squared"
    PRESSURE_SQUARED_PER_FORCE_TIME_PER_AREA = "pressure squared per force time per area"
    PRESSURE_TIME_PER_VOLUME = "pressure time per volume"
    QUANTITY_OF_LIGHT = "quantity of light"
    RADIANCE = "radiance"
    RADIANT_INTENSITY = "radiant intensity"
    RECIPROCAL_AREA = "reciprocal area"
    RECIPROCAL_ELECTRIC_POTENTIAL_DIFFERENCE = "reciprocal electric potential difference"
    RECIPROCAL_FORCE = "reciprocal force"
    RECIPROCAL_LENGTH = "reciprocal length"
    RECIPROCAL_MASS = "reciprocal mass"
    RECIPROCAL_MASS_TIME = "reciprocal mass time"
    RECIPROCAL_PRESSURE = "reciprocal pressure"
    RECIPROCAL_TIME = "reciprocal time"
    RECIPROCAL_VOLUME = "reciprocal volume"
    RELUCTANCE = "reluctance"
    SECOND_MOMENT_OF_AREA = "second moment of area"
    SIGNALING_EVENT_PER_TIME = "signaling event per time"
    SOLID_ANGLE = "solid angle"
    SPECIFIC_HEAT_CAPACITY = "specific heat capacity"
    TEMPERATURE_INTERVAL = "temperature interval"
    TEMPERATURE_INTERVAL_PER_LENGTH = "temperature interval per length"
    TEMPERATURE_INTERVAL_PER_PRESSURE = "temperature interval per pressure"
    TEMPERATURE_INTERVAL_PER_TIME = "temperature interval per time"
    THERMAL_CONDUCTANCE = "thermal conductance"
    THERMAL_CONDUCTIVITY = "thermal conductivity"
    THERMAL_DIFFUSIVITY = "thermal diffusivity"
    THERMAL_INSULANCE = "thermal insulance"
    THERMAL_RESISTANCE = "thermal resistance"
    THERMODYNAMIC_TEMPERATURE = "thermodynamic temperature"
    THERMODYNAMIC_TEMPERATURE_PER_THERMODYNAMIC_TEMPERATURE = "thermodynamic temperature per thermodynamic temperature"
    TIME = "time"
    TIME_PER_LENGTH = "time per length"
    TIME_PER_MASS = "time per mass"
    TIME_PER_TIME = "time per time"
    TIME_PER_VOLUME = "time per volume"
    VERTICAL_COORDINATE = "vertical coordinate"
    VOLUME = "volume"
    VOLUME_FLOW_RATE_PER_VOLUME_FLOW_RATE = "volume flow rate per volume flow rate"
    VOLUME_PER_AREA = "volume per area"
    VOLUME_PER_LENGTH = "volume per length"
    VOLUME_PER_MASS = "volume per mass"
    VOLUME_PER_PRESSURE = "volume per pressure"
    VOLUME_PER_ROTATION = "volume per rotation"
    VOLUME_PER_TIME = "volume per time"
    VOLUME_PER_TIME_LENGTH = "volume per time length"
    VOLUME_PER_TIME_PER_AREA = "volume per time per area"
    VOLUME_PER_TIME_PER_LENGTH = "volume per time per length"
    VOLUME_PER_TIME_PER_PRESSURE = "volume per time per pressure"
    VOLUME_PER_TIME_PER_PRESSURE_LENGTH = "volume per time per pressure length"
    VOLUME_PER_TIME_PER_TIME = "volume per time per time"
    VOLUME_PER_TIME_PER_VOLUME = "volume per time per volume"
    VOLUME_PER_VOLUME = "volume per volume"
    VOLUMETRIC_HEAT_TRANSFER_COEFFICIENT = "volumetric heat transfer coefficient"
    VOLUMETRIC_THERMAL_EXPANSION = "volumetric thermal expansion"
    UNITLESS = "unitless"
