from __future__ import annotations
from enum import Enum

__NAMESPACE__ = "http://www.energistics.org/energyml/data/commonv2"


class LithologyKind(Enum):
    """
    A description of minerals or accessories that constitute a fractional part
    of a lithology description.
    """
    ALKALI_FELDSPAR_RHYOLITE = "alkali feldspar rhyolite"
    ALKALI_OLIVINE_BASALT = "alkali olivine basalt"
    AMPHIBOLITE = "amphibolite"
    ANDESITE = "andesite"
    ANHYDRITE = "anhydrite"
    ANORTHOSITIC_ROCK = "anorthositic rock"
    ANTHRACITE = "anthracite"
    APLITE = "aplite"
    ARENITE = "arenite"
    ARGILLACEOUS = "argillaceous"
    ARKOSE = "arkose"
    BASALT = "basalt"
    BASANITE = "basanite"
    BAUXITE = "bauxite"
    BITUMINOUS_COAL = "bituminous coal"
    BLUESCHIST_METAMORPHIC_ROCK = "blueschist metamorphic rock"
    BONINITE = "boninite"
    BRECCIA = "breccia"
    CARBONATE_OOZE = "carbonate ooze"
    CARBONATITE = "carbonatite"
    CHALK = "chalk"
    CHERT = "chert"
    CLAY = "clay"
    CLAYSTONE = "claystone"
    COAL = "coal"
    CONGLOMERATE = "conglomerate"
    DACITE = "dacite"
    DIABASE = "diabase"
    DIAMICTITE = "diamictite"
    DIORITE = "diorite"
    DIORITOID = "dioritoid"
    DOLERITIC_ROCK = "doleritic rock"
    DOLOMITE = "dolomite"
    DOLOMITIC = "dolomitic"
    ECLOGITE = "eclogite"
    EXOTIC_ALKALINE_ROCK = "exotic alkaline rock"
    FELDSPAR = "feldspar"
    FELDSPATHIC_ARENITE = "feldspathic arenite"
    FINE_GRAINED_IGNEOUS_ROCK = "fine grained igneous rock"
    FOID_DIORITOID = "foid dioritoid"
    FOID_GABBROID = "foid gabbroid"
    FOID_SYENITOID = "foid syenitoid"
    FOIDITE = "foidite"
    FOIDITOID = "foiditoid"
    FOIDOLITE = "foidolite"
    FOLIATED_METAMORPHIC_ROCK = "foliated metamorphic rock"
    FRAGMENTAL_IGNEOUS_ROCK = "fragmental igneous rock"
    GABBRO = "gabbro"
    GABBROIC_ROCK = "gabbroic rock"
    GABBROID = "gabbroid"
    GLAUCONITE = "glauconite"
    GNEISS = "gneiss"
    GRANITE = "granite"
    GRANODIORITE = "granodiorite"
    GRANOFELS = "granofels"
    GRANULITE = "granulite"
    GRAVEL = "gravel"
    GREENSTONE = "greenstone"
    GUMBO = "gumbo"
    GYPSUM = "gypsum"
    HALITE = "halite"
    HORNFELS = "hornfels"
    IGNEOUS_ROCK = "igneous rock"
    IMPACT_GENERATED_MATERIAL = "impact generated material"
    IMPURE_DOLOMITE = "impure dolomite"
    IMPURE_LIMESTONE = "impure limestone"
    INTRUSIVE_ROCK_PLUTONIC = "intrusive rock (plutonic)"
    IRON_RICH_SEDIMENTARY_ROCK = "iron rich sedimentary rock"
    KALSILITIC_AND_MELILITIC_ROCKS = "kalsilitic and melilitic rocks"
    KOMATIITIC_ROCK = "komatiitic rock"
    LATITIC_ROCK = "latitic rock"
    LIGNITE = "lignite"
    LIME_BOUNDSTONE = "lime boundstone"
    LIME_FRAMESTONE = "lime framestone"
    LIME_GRAINSTONE = "lime grainstone"
    LIME_MUDSTONE = "lime mudstone"
    LIME_PACKSTONE = "lime packstone"
    LIME_WACKESTONE = "lime wackestone"
    LIMESTONE = "limestone"
    MARBLE = "marble"
    MARL = "marl"
    METAMORPHIC_ROCK = "metamorphic rock"
    MICA_SCHIST = "mica schist"
    MIGMATITE = "migmatite"
    MONZOGABBRO = "monzogabbro"
    MUD = "mud"
    MUDSTONE = "mudstone"
    MYLONITIC_ROCK = "mylonitic rock"
    NO_DESCRIPTION = "no description"
    NO_SAMPLE = "no sample"
    OOZE = "ooze"
    OPHIOLITE = "ophiolite"
    ORGANIC_BEARING_MUDSTONE = "organic bearing mudstone"
    PEAT = "peat"
    PEGMATITE = "pegmatite"
    PERIDOTITE = "peridotite"
    PHANERITIC_IGNEOUS_ROCK = "phaneritic igneous rock"
    PHONOLITE = "phonolite"
    PHONOLITOID = "phonolitoid"
    PHOSPHATE = "phosphate"
    PHOSPHATE_ROCK = "phosphate rock"
    PHYLLITE = "phyllite"
    PORPHYRY = "porphyry"
    POTASSIUM_AND_MAGNESIUM_SALTS = "potassium and magnesium salts"
    PYROCLASTIC_BRECCIA = "pyroclastic breccia"
    PYROCLASTIC_ROCK = "pyroclastic rock"
    PYROXENITE = "pyroxenite"
    QUARTZ_ARENITE = "quartz arenite"
    QUARTZITE = "quartzite"
    RHYOLITE = "rhyolite"
    ROCK_SALT = "rock salt"
    SAND = "sand"
    SANDSTONE = "sandstone"
    SANDY = "sandy"
    SAPROPEL = "sapropel"
    SCHIST = "schist"
    SERPENTINITE = "serpentinite"
    SHALE = "shale"
    SILICEOUS_OOZE = "siliceous ooze"
    SILT = "silt"
    SILTSTONE = "siltstone"
    SKARN = "skarn"
    SLATE = "slate"
    SPILITE = "spilite"
    SYENITE = "syenite"
    SYENITOID = "syenitoid"
    SYLVITE = "sylvite"
    TEPHRITE = "tephrite"
    TEPHRITOID = "tephritoid"
    THOLEIITIC_BASALT = "tholeiitic basalt"
    TONALITE = "tonalite"
    TRACHYTE = "trachyte"
    TRACHYTIC_ROCK = "trachytic rock"
    TRACHYTOID = "trachytoid"
    TRAVERTINE = "travertine"
    TUFF = "tuff"
    TUFFITE = "tuffite"
    ULTRABASIC = "ultrabasic"
    UNDIFFERENTIATED = "undifferentiated"
    UNKNOWN = "unknown"
    WACKE = "wacke"
