from __future__ import annotations
from enum import Enum

__NAMESPACE__ = "http://www.energistics.org/energyml/data/witsmlv2"


class DrillActivityCode(Enum):
    """
    A code to specify the drilling activity.
    """
    ABANDONMENT = "abandonment"
    ABANDONMENT_LOG_PLUGS = "abandonment -- log plugs"
    ABANDONMENT_RUN_PLUGS = "abandonment -- run plugs"
    ABANDONMENT_WAIT_ON_CEMENT = "abandonment -- wait on cement"
    CASING = "casing"
    CEMENT = "cement"
    CEMENT_CIRCULATE = "cement -- circulate"
    CEMENT_OTHER = "cement -- other"
    CEMENT_RIG_UP = "cement -- rig up"
    CEMENT_WAIT_ON_CEMENT = "cement -- wait on cement"
    CIRCULATE = "circulate"
    CIRCULATE_BOULDER_OR_GRAVEL = "circulate -- boulder or gravel"
    CIRCULATE_CASING = "circulate -- casing"
    CIRCULATE_CEMENTING = "circulate -- cementing"
    CIRCULATE_CIRCULATE_SAMPLES = "circulate -- circulate samples"
    CIRCULATE_CORING = "circulate -- coring"
    CIRCULATE_DRILLING = "circulate -- drilling"
    CIRCULATE_FISHING = "circulate -- fishing"
    CIRCULATE_GUMBO_ATTACK = "circulate -- gumbo attack"
    CIRCULATE_LOGGING = "circulate -- logging"
    CIRCULATE_LOST_CIRCULATION = "circulate -- lost circulation"
    CIRCULATE_WELL_CONTROL = "circulate -- well control"
    COMPLETION_OPERATIONS = "completion operations"
    COMPLETION_OPERATIONS_GRAVEL_PACKING = "completion operations -- gravel packing"
    COMPLETION_OPERATIONS_LOGGING = "completion operations -- logging"
    COMPLETION_OPERATIONS_RIG_UP = "completion operations -- rig up"
    COMPLETION_OPERATIONS_RUNNING_LINER = "completion operations -- running liner"
    COMPLETION_OPERATIONS_TEAR_DOWN = "completion operations -- tear down"
    COMPLETION_OPERATIONS_TESTING = "completion operations -- testing"
    COND_MUD = "cond mud"
    CORING = "coring"
    CORING_CONVENTIONAL = "coring -- conventional"
    CORING_FLOW_CHECK = "coring -- flow check"
    CORING_LAYDOWN_BARREL = "coring -- laydown barrel"
    CORING_ORIENTED = "coring -- oriented"
    CORING_PLASTIC_SLEEVE = "coring -- plastic sleeve"
    CORING_RIG_UP_CORE_BARREL = "coring -- rig up core barrel"
    CORING_SPONGE = "coring -- sponge"
    CUT = "cut"
    DEVIATION_SURVEY = "deviation survey"
    DEVIATION_SURVEY_DIR_MULTI_SHOT = "deviation survey -- dir multi-shot"
    DEVIATION_SURVEY_DIR_SINGLE_SHOT = "deviation survey -- dir single shot"
    DEVIATION_SURVEY_DRIFT = "deviation survey -- drift"
    DEVIATION_SURVEY_GYRO = "deviation survey -- gyro"
    DEVIATION_SURVEY_MWD = "deviation survey -- MWD"
    DIR_WORK = "dir work"
    DIR_WORK_HORIZONTAL_DRILLING = "dir work -- horizontal drilling"
    DIR_WORK_MOTOR_DRILLING = "dir work -- motor drilling"
    DIR_WORK_ORIENT = "dir work -- orient"
    DIR_WORK_ROTARY_DRILLING = "dir work -- rotary drilling"
    DIR_WORK_SLANT_DRILLING = "dir work -- slant drilling"
    DRILLING = "drilling"
    DRILLING_CASING = "drilling -- casing"
    DRILLING_CONNECTION = "drilling -- connection"
    DRILLING_DRILL_CEMENT = "drilling -- drill cement"
    DRILLING_FLOW_CHECK = "drilling -- flow check"
    DRILLING_HOLE_OPENING = "drilling -- hole opening"
    DRILLING_NEW_HOLE = "drilling -- new hole"
    DRILLING_SIDETRACKING = "drilling -- sidetracking"
    DRILLING_UNDER_REAMING = "drilling -- under-reaming"
    DST = "DST"
    DST_CASED_HOLE = "DST -- cased hole"
    DST_LAY_DOWN_TOOLS = "DST -- lay down tools"
    DST_OPEN_HOLE = "DST -- open hole"
    DST_OPEN_HOLE_CLOSED_CHAMBER = "DST -- open hole closed chamber"
    DST_RIG_UP_TOOLS = "DST -- rig up tools"
    FISHING = "fishing"
    FISHING_BHA = "fishing -- BHA"
    FISHING_CASING = "fishing -- casing"
    FISHING_CONES = "fishing -- cones"
    FISHING_OTHER = "fishing -- other"
    FISHING_STUCK_PIPE = "fishing -- stuck pipe"
    FISHING_WIRELINE_TOOLS = "fishing -- wireline tools"
    FLOAT_EQUIP = "float equip"
    HSE = "HSE"
    HSE_HOLD_DRILL = "HSE -- hold drill"
    HSE_INCIDENT = "HSE -- incident"
    HSE_SAFETY_MEETING = "HSE -- safety meeting"
    MILL = "mill"
    MILL_CUT_CASING_OR_TUBING = "mill -- cut casing or tubing"
    MILL_MILLING = "mill -- milling"
    MISCELLANEOUS = "miscellaneous"
    NIPPLE_UP_BOP = "nipple up BOP"
    NIPPLE_UP_BOP_DIVERTER = "nipple up BOP -- diverter"
    NIPPLE_UP_BOP_MANIFOLD = "nipple up BOP -- manifold"
    NIPPLE_UP_BOP_OTHER = "nipple up BOP -- other"
    NIPPLE_UP_BOP_PVT_SYSTEM = "nipple up BOP -- PVT system"
    NIPPLE_UP_BOP_STACK = "nipple up BOP -- stack"
    PLUG_BACK = "plug back"
    PLUG_BACK_ABANDONMENT = "plug back -- abandonment"
    PLUG_BACK_KICK_OFF_PLUG = "plug back -- kick off plug"
    PLUG_BACK_LOST_CIRCULATION = "plug back -- lost circulation"
    PLUG_BACK_WAIT_ON_CEMENT = "plug back -- wait on cement"
    PLUG_BACK_WELL_CONTROL = "plug back -- well control"
    PRESSURE_TEST = "pressure test"
    PRESSURE_TEST_BOP_MANIFOLD = "pressure test -- BOP manifold"
    PRESSURE_TEST_BOP_STACK = "pressure test -- BOP stack"
    PRESSURE_TEST_FORM_INTEGRITY_TEST = "pressure test -- form integrity test"
    PRESSURE_TEST_FORM_LEAK_OFF_TEST = "pressure test -- form leak off test"
    PRESSURE_TEST_PACKER = "pressure test -- packer"
    PRESSURE_TEST_PIT = "pressure test -- PIT"
    REAMING = "reaming"
    REAMING_BACK_REAMING = "reaming -- back reaming"
    REAMING_CORING = "reaming -- coring"
    REAMING_DRILL = "reaming -- drill"
    REAMING_LOGGING = "reaming -- logging"
    REAMING_UNDER_REAMING = "reaming -- under-reaming"
    RIG_MOVE = "rig move"
    RIG_MOVE_ANCHOR_HANDLING = "rig move -- anchor handling"
    RIG_MOVE_INTER_PAD_MOVE = "rig move -- inter-pad move"
    RIG_MOVE_INTER_WELL_MOVE = "rig move -- inter-well move"
    RIG_MOVE_JACK_UP_OR_DOWN = "rig move -- jack up or down"
    RIG_MOVE_OTHER = "rig move -- other"
    RIG_MOVE_POSITION_RIG = "rig move -- position rig"
    RIG_MOVE_SKID_RIG = "rig move -- skid rig"
    RIG_RELEASE = "rig release"
    RIG_RELEASE_CUT_CASING = "rig release -- cut casing"
    RIG_RELEASE_INSTALL_CAPPING_ASSEMBLY = "rig release -- install capping assembly"
    RIG_RELEASE_MOB_OR_DE_MOB = "rig release -- MOB or DE-MOB"
    RIG_REPAIRS = "rig repairs"
    RIG_REPAIRS_DRAWWORKS = "rig repairs -- drawworks"
    RIG_REPAIRS_ELECTRICAL = "rig repairs -- electrical"
    RIG_REPAIRS_MUD_SYSTEM = "rig repairs -- mud system"
    RIG_REPAIRS_OTHER = "rig repairs -- other"
    RIG_REPAIRS_ROTARY = "rig repairs -- rotary"
    RIG_REPAIRS_SUBSEA_EQUIPMENT = "rig repairs -- subsea equipment"
    RIG_REPAIRS_WELL_CONTROL_EQUIPMENT = "rig repairs -- well control equipment"
    RIG_SERVICE = "rig service"
    RIG_SERVICE_LUBRICATE_RIG = "rig service -- lubricate rig"
    RIG_SERVICE_TEST_EQUIPMENT = "rig service -- test equipment"
    RIG_UP_OR_TEAR_DOWN = "rig up or tear down"
    RIG_UP_OR_TEAR_DOWN_RIG_UP = "rig up or tear down -- rig up"
    RIG_UP_OR_TEAR_DOWN_SITE_WORK = "rig up or tear down -- site work"
    RIG_UP_OR_TEAR_DOWN_TEAR_DOWN = "rig up or tear down -- tear down"
    RUN_CASING = "run casing"
    RUN_LINER = "run liner"
    RUN_OR_PULL_RISER = "run or pull riser"
    RUN_OR_PULL_RISER_OTHER = "run or pull riser -- other"
    RUN_OR_PULL_RISER_RUN_OR_PULL_RISER = "run or pull riser -- run or pull riser"
    SET = "set"
    SLIP_DRILLING_LINE = "slip drilling line"
    SQUEEZE_CEMENT = "squeeze cement"
    SQUEEZE_CEMENT_CASING_REPAIR = "squeeze cement -- casing repair"
    SQUEEZE_CEMENT_CASING_SHOE = "squeeze cement -- casing shoe"
    SQUEEZE_CEMENT_PARTED_CASING = "squeeze cement -- parted casing"
    SQUEEZE_CEMENT_PERFORATIONS_DST = "squeeze cement -- perforations DST"
    STUCK_PIPE = "stuck pipe"
    SURFACE_STRING_HANDLING = "surface string handling"
    TEST_COMPLETION = "test completion"
    TESTING_GENERAL = "testing general"
    TESTING_GENERAL_EQUIPMENT = "testing general -- equipment"
    TESTING_GENERAL_FLOW = "testing general -- flow"
    TRIPPING = "tripping"
    TRIPPING_BACK_REAMING = "tripping -- back-reaming"
    TRIPPING_FLOW_CHECK = "tripping -- flow check"
    TRIPPING_SHORT_TRIP_IN = "tripping -- short trip in"
    TRIPPING_SHORT_TRIP_OUT = "tripping -- short trip out"
    TRIPPING_TRIP_IN_FROM_SURFACE = "tripping -- trip in (from surface)"
    TRIPPING_TRIP_OUT_TO_SURFACE = "tripping -- trip out (to surface)"
    WAIT = "wait"
    WAIT_DAYLIGHT = "wait -- daylight"
    WAIT_ENVIRONMENTAL_OR_REGULATORY = "wait -- environmental or regulatory"
    WAIT_EQUIPMENT = "wait -- equipment"
    WAIT_HOLIDAY = "wait -- holiday"
    WAIT_ICE = "wait -- ice"
    WAIT_ON_ORDERS = "wait -- on orders"
    WAIT_OPERATOR = "wait -- operator"
    WAIT_OTHER = "wait -- other"
    WAIT_PARTNERS = "wait -- partners"
    WAIT_SERVICE_COMPANY = "wait -- service company"
    WAIT_WEATHER = "wait -- weather"
    WELL_CONTROL = "well control"
    WELL_CONTROL_MIX = "well control -- mix"
    WELL_CONTROL_SHUT_IN = "well control -- shut in"
    WELL_CONTROL_STRIP = "well control -- strip"
    WELL_CONTROL_WELL_KILL = "well control -- well kill"
    WELL_SRVC = "well srvc"
    WELL_SRVC_CASING_REPAIR = "well srvc -- casing repair"
    WELL_SRVC_CLEAN_WELL_TO_COMPL_FLUID = "well srvc -- clean well to compl fluid"
    WELL_SRVC_COILED_TUBING_WORK = "well srvc -- coiled tubing work"
    WELL_SRVC_GRAVEL_PACK = "well srvc -- gravel pack"
    WELL_SRVC_INSTALL_OR_TEST_XMAS_TREE = "well srvc -- install or test xmas tree"
    WELL_SRVC_KILL_WELL = "well srvc -- kill well"
    WELL_SRVC_LAND = "well srvc -- land"
    WELL_SRVC_PERFORATE = "well srvc -- perforate"
    WELL_SRVC_PULL_COMPLETION = "well srvc -- pull completion"
    WELL_SRVC_PULL_SUSPENSION_PLUGS = "well srvc -- pull suspension plugs"
    WELL_SRVC_RUN_COMPLETION = "well srvc -- run completion"
    WELL_SRVC_RUN_SCREENS = "well srvc -- run screens"
    WELL_SRVC_SAND_CONTROL = "well srvc -- sand control"
    WELL_SRVC_STIMULATION = "well srvc -- stimulation"
    WELL_SRVC_SUBSEA_WORK = "well srvc -- subsea work"
    WELL_SRVC_SURFACE_LINE_WORK = "well srvc -- surface line work"
    WELL_SRVC_SUSPEND_WELL_OR_PULL_BOPS = "well srvc -- suspend well or pull BOPs"
    WELL_SRVC_TEST_WELL = "well srvc -- test well"
    WELL_SRVC_WASH = "well srvc -- wash"
    WELL_SRVC_WIRELINE_WORK = "well srvc -- wireline work"
    WELL_SRVC_WORK_TUBULARS = "well srvc -- work tubulars"
    WELL_SRVC_WORKSTRING_RUN = "well srvc -- workstring run"
    WIRELINE_LOGS = "wireline logs"
    WIRELINE_LOGS_ABANDONMENT = "wireline logs -- abandonment"
    WIRELINE_LOGS_EVALUATION = "wireline logs -- evaluation"
    WIRELINE_LOGS_FORM_TESTER = "wireline logs -- form tester"
    WIRELINE_LOGS_OTHER = "wireline logs -- other"
    WIRELINE_LOGS_SIDE_WALL_CORES = "wireline logs -- side wall cores"
    WIRELINE_LOGS_VELOCITY = "wireline logs -- velocity"
