from __future__ import annotations
from dataclasses import dataclass
from witsml20.coordinate_system_axis_property_type import CoordinateSystemAxisPropertyType

__NAMESPACE__ = "http://www.opengis.net/gml/3.2"


@dataclass
class Axis(CoordinateSystemAxisPropertyType):
    """The gml:axis property is an association role (ordered sequence) to the
    coordinate system axes included in this coordinate system.

    The coordinate values in a coordinate tuple shall be recorded in the
    order in which the coordinate system axes associations are recorded,
    whenever those coordinates use a coordinate reference system that
    uses this coordinate system. The gml:AggregationAttributeGroup
    should be used to specify that the axis objects are ordered.
    """
    class Meta:
        name = "axis"
        namespace = "http://www.opengis.net/gml/3.2"
