# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['custom_user', 'custom_user.migrations']

package_data = \
{'': ['*']}

install_requires = \
['Django>=3.2']

extras_require = \
{u'mysql': ['mysqlclient>=2.1.0,<3.0.0'],
 u'postgres': ['psycopg2>=2.9.0,<3.0.0']}

setup_kwargs = {
    'name': 'django-custom-user',
    'version': '1.0',
    'description': 'Custom user model for Django with the same behaviour as the default User class but with email instead of username.',
    'long_description': 'Django Custom User\n==================\n\n.. image:: https://img.shields.io/pypi/v/django-custom-user.svg\n   :target: https://pypi.org/project/django-custom-user/\n   :alt: PyPI version\n\n.. image:: https://github.com/jcugat/django-custom-user/actions/workflows/ci.yml/badge.svg\n   :target: https://github.com/jcugat/django-custom-user/actions/workflows/ci.yml\n   :alt: GitHub Actions Workflow Status (main branch)\n\n.. image:: https://img.shields.io/pypi/dm/django-custom-user.svg\n   :target: https://pypi.python.org/pypi/django-custom-user\n\n\nCustom user model for Django with the same behaviour as the default User class but without a username field. Uses email as the USERNAME_FIELD for authentication.\n\n\nQuick start\n-----------\n\n1. Install django-custom-user with your favorite Python package manager:\n\n.. code-block::\n\n    pip install django-custom-user\n\n\n2. Add ``\'custom_user\'`` to your ``INSTALLED_APPS`` setting:\n\n.. code-block:: python\n\n    INSTALLED_APPS = (\n        # other apps\n        \'custom_user\',\n    )\n\n\n3. Set your ``AUTH_USER_MODEL`` setting to use ``EmailUser``:\n\n.. code-block:: python\n\n    AUTH_USER_MODEL = \'custom_user.EmailUser\'\n\n\n4. Create the database tables:\n\n.. code-block::\n\n    python manage.py migrate\n\n\nUsage\n-----\n\nInstead of referring to ``EmailUser`` directly, you should reference the user model using ``get_user_model()`` as explained in the `Django documentation`_. For example:\n\n.. _Django documentation: https://docs.djangoproject.com/en/dev/topics/auth/customizing/#referencing-the-user-model\n\n.. code-block:: python\n\n    from django.contrib.auth import get_user_model\n\n    user = get_user_model().objects.get(email="user@example.com")\n\n\nWhen you define a foreign key or many-to-many relations to the ``EmailUser`` model, you should specify the custom model using the ``AUTH_USER_MODEL`` setting. For example:\n\n.. code-block:: python\n\n    from django.conf import settings\n    from django.db import models\n\n    class Article(models.Model):\n        author = models.ForeignKey(settings.AUTH_USER_MODEL)\n\n\nExtending EmailUser model\n-------------------------\n\nYou can easily extend ``EmailUser`` by inheriting from ``AbstractEmailUser``. For example:\n\n.. code-block:: python\n\n    from custom_user.models import AbstractEmailUser\n\n    class MyCustomEmailUser(AbstractEmailUser):\n        """\n        Example of an EmailUser with a new field date_of_birth\n        """\n        date_of_birth = models.DateField()\n\nRemember to change the ``AUTH_USER_MODEL`` setting to your new class:\n\n.. code-block:: python\n\n    AUTH_USER_MODEL = \'my_app.MyCustomEmailUser\'\n\nIf you use the AdminSite, add the following code to your ``my_app/admin.py`` file:\n\n.. code-block:: python\n\n    from django.contrib import admin\n    from custom_user.admin import EmailUserAdmin\n    from .models import MyCustomEmailUser\n\n\n    class MyCustomEmailUserAdmin(EmailUserAdmin):\n        """\n        You can customize the interface of your model here.\n        """\n        pass\n\n    # Register your models here.\n    admin.site.register(MyCustomEmailUser, MyCustomEmailUserAdmin)\n\n\nSupported versions\n------------------\n\nDjango:\n\n- 3.2 LTS\n- 4.0\n\nPython:\n\n- 3.7\n- 3.8\n- 3.9\n- 3.10\n\n\nChangelog\n---------\n\nVersion 1.0 (2022-03-29)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\nAfter a long hiatus, this new version brings compatibility with the latest Django and Python versions, among lots of small improvements and cleanups.\n\n- Supported versions:\n\n  - Django: 3.2 LTS, 4.0\n\n  - Python: 3.7, 3.8, 3.9, 3.10\n\n- Import latest code changes from Django 4.0 (`#65 <https://github.com/jcugat/django-custom-user/pull/65>`_):\n\n  - ``EmailUserCreationForm`` does not strip whitespaces in the password fields, to match Django\'s behavior.\n\n  - ``EmailUserCreationForm`` supports custom password validators configured by ``AUTH_PASSWORD_VALIDATORS``.\n\n  - ``EmailUser.objects.create_superuser()`` allows empty passwords. It will also check that both ``is_staff`` and ``is_superuser`` parameters are ``True`` (if passed). Otherwise, it would create an invalid superuser.\n\n- Internal changes:\n\n  - Moved away from Travis CI to Github Actions.\n\n  - Build system and dependencies managed with `Poetry <https://python-poetry.org/>`_.\n\n  - Code formatted with `black <https://github.com/psf/black>`_ and `isort <https://pycqa.github.io/isort/>`_.\n\nNote that older versions of Django are not supported, but you can use the previous version 0.7 if you need it.\n\nVersion 0.7 (2017-01-12)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- Fixed change password link in EmailUserChangeForm (thanks to Igor Gai and rubengrill)\n\nVersion 0.6 (2016-04-03)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- Added migrations (thanks to everybody for the help).\n\nHow to apply the migrations after upgrading:\n\nDjango 1.7\n++++++++++\n\nFor this version just run the following commands.\n\n.. code-block::\n\n    python manage.py migrate custom_user 0001_initial_django17 --fake\n    python manage.py migrate custom_user\n\nDjango 1.8\n++++++++++\n\nThis version didn\'t work without migrations, which means that your migrations will conflict with the new ones included in this version.\n\nIf you added the migrations with Django\'s `MIGRATION_MODULES <https://docs.djangoproject.com/en/1.7/ref/settings/#std:setting-MIGRATION_MODULES>`_ setting, delete the folder containing the migration modules and remove the setting from your config.\n\nIf you just ran ``python manage.py makemigrations``, the migrations are located inside your system\'s or virtualenv\'s ``site-packages`` folder. You can check the location running this command, and then delete the folder ``migrations`` that is inside:\n\n.. code-block::\n\n    python -c "import os; import custom_user; print(os.path.dirname(custom_user.__file__))"\n\nYou can check if you have removed the migrations successfully running this command, you shouldn\'t see the section ``custom_user`` anymore:\n\n.. code-block::\n\n    python manage.py migrate --list\n\nOnce the old migrations are gone, run the following command to finish:\n\n.. code-block::\n\n    python manage.py migrate custom_user 0002_initial_django18 --fake\n\nVersion 0.5 (2014-09-20)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- Django 1.7 compatible (thanks to j0hnsmith).\n- Custom application verbose_name in AdminSite with AppConfig.\n\nVersion 0.4 (2014-03-06)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- The create_user() and create_superuser() manager methods now accept is_active and is_staff as parameters (thanks to Edil Kratskih).\n\nVersion 0.3 (2014-01-17)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- AdminSite now works when subclassing AbstractEmailUser (thanks to Ivan Virabyan).\n- Updated model changes from Django 1.6.1.\n\nVersion 0.2 (2013-11-24)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- Django 1.6 compatible (thanks to Simon Luijk).\n\nVersion 0.1 (2013-04-09)\n~~~~~~~~~~~~~~~~~~~~~~~~\n\n- Initial release.\n\n',
    'author': 'Josep Cugat',
    'author_email': 'jcugat@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jcugat/django-custom-user',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
