import java.lang
import org.joda.time
import org.joda.time.format
import typing



class PrimitiveNumber:
    def getNumberValue(self) -> java.lang.Number: ...

_PrimitiveType__T = typing.TypeVar('_PrimitiveType__T')  # <T>
class PrimitiveType(typing.Generic[_PrimitiveType__T]):
    def equals(self, object: typing.Any) -> bool: ...
    def getValue(self) -> _PrimitiveType__T: ...
    def toString(self) -> java.lang.String: ...

class Color(PrimitiveType[int]):
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @typing.overload
    def __init__(self, integer: int): ...
    def getAlpha(self) -> int: ...
    def getBlue(self) -> int: ...
    def getGreen(self) -> int: ...
    def getRed(self) -> int: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'Color': ...

class NonNegativeFloat(PrimitiveType[float], PrimitiveNumber):
    def __init__(self, double: float): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'NonNegativeFloat': ...

class NonNegativeInteger(PrimitiveType[int], PrimitiveNumber):
    def __init__(self, integer: int): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'NonNegativeInteger': ...

class NonNegativeLong(PrimitiveType[int], PrimitiveNumber):
    def __init__(self, long: int): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'NonNegativeLong': ...

class PercentFraction(PrimitiveType[float], PrimitiveNumber):
    def __init__(self, float: float): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PercentFraction': ...

class Timestamp(PrimitiveType[java.lang.String]):
    ISO8601_FORMAT_MS: typing.ClassVar[java.lang.String] = ...
    ISO8601_FORMAT_S: typing.ClassVar[java.lang.String] = ...
    ISO8601_PARSER: typing.ClassVar[org.joda.time.format.DateTimeFormatter] = ...
    ISO8601_FORMATTER_MS: typing.ClassVar[org.joda.time.format.DateTimeFormatter] = ...
    ISO8601_FORMATTER_S: typing.ClassVar[org.joda.time.format.DateTimeFormatter] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, dateTime: org.joda.time.DateTime): ...
    @typing.overload
    def __init__(self, instant: org.joda.time.Instant): ...
    def asDateTime(self, dateTimeZone: org.joda.time.DateTimeZone) -> org.joda.time.DateTime: ...
    def asInstant(self) -> org.joda.time.Instant: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'Timestamp': ...

class PositiveFloat(NonNegativeFloat):
    def __init__(self, double: float): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> NonNegativeFloat: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PositiveFloat': ...

class PositiveInteger(NonNegativeInteger):
    def __init__(self, integer: int): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> NonNegativeInteger: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PositiveInteger': ...

class PositiveLong(NonNegativeLong):
    def __init__(self, long: int): ...
    def getNumberValue(self) -> java.lang.Number: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> NonNegativeLong: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PositiveLong': ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("ome.xml.model.primitives")``.

    Color: typing.Type[Color]
    NonNegativeFloat: typing.Type[NonNegativeFloat]
    NonNegativeInteger: typing.Type[NonNegativeInteger]
    NonNegativeLong: typing.Type[NonNegativeLong]
    PercentFraction: typing.Type[PercentFraction]
    PositiveFloat: typing.Type[PositiveFloat]
    PositiveInteger: typing.Type[PositiveInteger]
    PositiveLong: typing.Type[PositiveLong]
    PrimitiveNumber: typing.Type[PrimitiveNumber]
    PrimitiveType: typing.Type[PrimitiveType]
    Timestamp: typing.Type[Timestamp]
