import java.lang
import java.util
import bioformats_jar._ome.units.quantity
import bioformats_jar._ome.xml.model.enums
import bioformats_jar._ome.xml.model.primitives
import org.w3c.dom
import typing



class MapPair:
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, mapPair: 'MapPair'): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getName(self) -> java.lang.String: ...
    def getValue(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class OMEModel:
    def addModelObject(self, string: typing.Union[java.lang.String, str], oMEModelObject: 'OMEModelObject') -> 'OMEModelObject': ...
    def addReference(self, oMEModelObject: 'OMEModelObject', reference: 'Reference') -> bool: ...
    def getModelObject(self, string: typing.Union[java.lang.String, str]) -> 'OMEModelObject': ...
    def getModelObjects(self) -> java.util.Map[java.lang.String, 'OMEModelObject']: ...
    def getReferences(self) -> java.util.Map['OMEModelObject', java.util.List['Reference']]: ...
    def removeModelObject(self, string: typing.Union[java.lang.String, str]) -> 'OMEModelObject': ...
    def resolveReferences(self) -> int: ...

class OMEModelObject:
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def link(self, reference: 'Reference', oMEModelObject: 'OMEModelObject') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

_ReferenceList__T = typing.TypeVar('_ReferenceList__T')  # <T>
class ReferenceList(java.util.ArrayList[_ReferenceList__T], typing.Generic[_ReferenceList__T]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, collection: typing.Union[java.util.Collection[_ReferenceList__T], typing.Sequence[_ReferenceList__T]]): ...
    @typing.overload
    def add(self, t: _ReferenceList__T) -> bool: ...
    @typing.overload
    def add(self, int: int, t: _ReferenceList__T) -> None: ...
    @typing.overload
    def addAll(self, int: int, collection: typing.Union[java.util.Collection[_ReferenceList__T], typing.Sequence[_ReferenceList__T]]) -> bool: ...
    @typing.overload
    def addAll(self, collection: typing.Union[java.util.Collection[_ReferenceList__T], typing.Sequence[_ReferenceList__T]]) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: typing.Any) -> bool: ...
    def containsAll(self, collection: typing.Union[java.util.Collection[typing.Any], typing.Sequence[typing.Any]]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def removeAll(self, collection: typing.Union[java.util.Collection[typing.Any], typing.Sequence[typing.Any]]) -> bool: ...
    def retainAll(self, collection: typing.Union[java.util.Collection[typing.Any], typing.Sequence[typing.Any]]) -> bool: ...
    def set(self, int: int, t: _ReferenceList__T) -> _ReferenceList__T: ...

class AbstractOMEModelObject(OMEModelObject):
    def __init__(self): ...
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @staticmethod
    def getChildrenByTagName(element: org.w3c.dom.Element, string: typing.Union[java.lang.String, str]) -> java.util.List[org.w3c.dom.Element]: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    @staticmethod
    def stripNamespacePrefix(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class OMEModelImpl(OMEModel):
    def __init__(self): ...
    def addModelObject(self, string: typing.Union[java.lang.String, str], oMEModelObject: OMEModelObject) -> OMEModelObject: ...
    def addReference(self, oMEModelObject: OMEModelObject, reference: 'Reference') -> bool: ...
    def getModelObject(self, string: typing.Union[java.lang.String, str]) -> OMEModelObject: ...
    def getModelObjects(self) -> java.util.Map[java.lang.String, OMEModelObject]: ...
    def getReferences(self) -> java.util.Map[OMEModelObject, java.util.List['Reference']]: ...
    def removeModelObject(self, string: typing.Union[java.lang.String, str]) -> OMEModelObject: ...
    def resolveReferences(self) -> int: ...

class AffineTransform(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, affineTransform: 'AffineTransform'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    @staticmethod
    def createRotationTransform(double: float) -> 'AffineTransform': ...
    def getA00(self) -> float: ...
    def getA01(self) -> float: ...
    def getA02(self) -> float: ...
    def getA10(self) -> float: ...
    def getA11(self) -> float: ...
    def getA12(self) -> float: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setA00(self, double: float) -> None: ...
    def setA01(self, double: float) -> None: ...
    def setA02(self, double: float) -> None: ...
    def setA10(self, double: float) -> None: ...
    def setA11(self, double: float) -> None: ...
    def setA12(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Annotation(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, annotation: 'Annotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List['Annotation']: ...
    def copyLinkedChannelList(self) -> java.util.List['Channel']: ...
    def copyLinkedDatasetList(self) -> java.util.List['Dataset']: ...
    def copyLinkedDetectorList(self) -> java.util.List['Detector']: ...
    def copyLinkedDichroicList(self) -> java.util.List['Dichroic']: ...
    def copyLinkedExperimenterGroupList(self) -> java.util.List['ExperimenterGroup']: ...
    def copyLinkedExperimenterList(self) -> java.util.List['Experimenter']: ...
    def copyLinkedFilterList(self) -> java.util.List['Filter']: ...
    def copyLinkedFolderList(self) -> java.util.List['Folder']: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyLinkedInstrumentList(self) -> java.util.List['Instrument']: ...
    def copyLinkedLightPathList(self) -> java.util.List['LightPath']: ...
    def copyLinkedLightSourceList(self) -> java.util.List['LightSource']: ...
    def copyLinkedObjectiveList(self) -> java.util.List['Objective']: ...
    def copyLinkedPlaneList(self) -> java.util.List['Plane']: ...
    def copyLinkedPlateAcquisitionList(self) -> java.util.List['PlateAcquisition']: ...
    def copyLinkedPlateList(self) -> java.util.List['Plate']: ...
    def copyLinkedProjectList(self) -> java.util.List['Project']: ...
    def copyLinkedROIList(self) -> java.util.List['ROI']: ...
    def copyLinkedReagentList(self) -> java.util.List['Reagent']: ...
    def copyLinkedScreenList(self) -> java.util.List['Screen']: ...
    def copyLinkedShapeList(self) -> java.util.List['Shape']: ...
    def copyLinkedWellList(self) -> java.util.List['Well']: ...
    def getAnnotator(self) -> java.lang.String: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> 'Annotation': ...
    def getLinkedChannel(self, int: int) -> 'Channel': ...
    def getLinkedDataset(self, int: int) -> 'Dataset': ...
    def getLinkedDetector(self, int: int) -> 'Detector': ...
    def getLinkedDichroic(self, int: int) -> 'Dichroic': ...
    def getLinkedExperimenter(self, int: int) -> 'Experimenter': ...
    def getLinkedExperimenterGroup(self, int: int) -> 'ExperimenterGroup': ...
    def getLinkedFilter(self, int: int) -> 'Filter': ...
    def getLinkedFolder(self, int: int) -> 'Folder': ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getLinkedInstrument(self, int: int) -> 'Instrument': ...
    def getLinkedLightPath(self, int: int) -> 'LightPath': ...
    def getLinkedLightSource(self, int: int) -> 'LightSource': ...
    def getLinkedObjective(self, int: int) -> 'Objective': ...
    def getLinkedPlane(self, int: int) -> 'Plane': ...
    def getLinkedPlate(self, int: int) -> 'Plate': ...
    def getLinkedPlateAcquisition(self, int: int) -> 'PlateAcquisition': ...
    def getLinkedProject(self, int: int) -> 'Project': ...
    def getLinkedROI(self, int: int) -> 'ROI': ...
    def getLinkedReagent(self, int: int) -> 'Reagent': ...
    def getLinkedScreen(self, int: int) -> 'Screen': ...
    def getLinkedShape(self, int: int) -> 'Shape': ...
    def getLinkedWell(self, int: int) -> 'Well': ...
    def getNamespace(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: 'Annotation') -> bool: ...
    def linkChannel(self, channel: 'Channel') -> bool: ...
    def linkDataset(self, dataset: 'Dataset') -> bool: ...
    def linkDetector(self, detector: 'Detector') -> bool: ...
    def linkDichroic(self, dichroic: 'Dichroic') -> bool: ...
    def linkExperimenter(self, experimenter: 'Experimenter') -> bool: ...
    def linkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> bool: ...
    def linkFilter(self, filter: 'Filter') -> bool: ...
    def linkFolder(self, folder: 'Folder') -> bool: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def linkInstrument(self, instrument: 'Instrument') -> bool: ...
    def linkLightPath(self, lightPath: 'LightPath') -> bool: ...
    def linkLightSource(self, lightSource: 'LightSource') -> bool: ...
    def linkObjective(self, objective: 'Objective') -> bool: ...
    def linkPlane(self, plane: 'Plane') -> bool: ...
    def linkPlate(self, plate: 'Plate') -> bool: ...
    def linkPlateAcquisition(self, plateAcquisition: 'PlateAcquisition') -> bool: ...
    def linkProject(self, project: 'Project') -> bool: ...
    def linkROI(self, rOI: 'ROI') -> bool: ...
    def linkReagent(self, reagent: 'Reagent') -> bool: ...
    def linkScreen(self, screen: 'Screen') -> bool: ...
    def linkShape(self, shape: 'Shape') -> bool: ...
    def linkWell(self, well: 'Well') -> bool: ...
    def setAnnotator(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: 'Annotation') -> 'Annotation': ...
    def setLinkedChannel(self, int: int, channel: 'Channel') -> 'Channel': ...
    def setLinkedDataset(self, int: int, dataset: 'Dataset') -> 'Dataset': ...
    def setLinkedDetector(self, int: int, detector: 'Detector') -> 'Detector': ...
    def setLinkedDichroic(self, int: int, dichroic: 'Dichroic') -> 'Dichroic': ...
    def setLinkedExperimenter(self, int: int, experimenter: 'Experimenter') -> 'Experimenter': ...
    def setLinkedExperimenterGroup(self, int: int, experimenterGroup: 'ExperimenterGroup') -> 'ExperimenterGroup': ...
    def setLinkedFilter(self, int: int, filter: 'Filter') -> 'Filter': ...
    def setLinkedFolder(self, int: int, folder: 'Folder') -> 'Folder': ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setLinkedInstrument(self, int: int, instrument: 'Instrument') -> 'Instrument': ...
    def setLinkedLightPath(self, int: int, lightPath: 'LightPath') -> 'LightPath': ...
    def setLinkedLightSource(self, int: int, lightSource: 'LightSource') -> 'LightSource': ...
    def setLinkedObjective(self, int: int, objective: 'Objective') -> 'Objective': ...
    def setLinkedPlane(self, int: int, plane: 'Plane') -> 'Plane': ...
    def setLinkedPlate(self, int: int, plate: 'Plate') -> 'Plate': ...
    def setLinkedPlateAcquisition(self, int: int, plateAcquisition: 'PlateAcquisition') -> 'PlateAcquisition': ...
    def setLinkedProject(self, int: int, project: 'Project') -> 'Project': ...
    def setLinkedROI(self, int: int, rOI: 'ROI') -> 'ROI': ...
    def setLinkedReagent(self, int: int, reagent: 'Reagent') -> 'Reagent': ...
    def setLinkedScreen(self, int: int, screen: 'Screen') -> 'Screen': ...
    def setLinkedShape(self, int: int, shape: 'Shape') -> 'Shape': ...
    def setLinkedWell(self, int: int, well: 'Well') -> 'Well': ...
    def setNamespace(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedChannelList(self) -> int: ...
    def sizeOfLinkedDatasetList(self) -> int: ...
    def sizeOfLinkedDetectorList(self) -> int: ...
    def sizeOfLinkedDichroicList(self) -> int: ...
    def sizeOfLinkedExperimenterGroupList(self) -> int: ...
    def sizeOfLinkedExperimenterList(self) -> int: ...
    def sizeOfLinkedFilterList(self) -> int: ...
    def sizeOfLinkedFolderList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedInstrumentList(self) -> int: ...
    def sizeOfLinkedLightPathList(self) -> int: ...
    def sizeOfLinkedLightSourceList(self) -> int: ...
    def sizeOfLinkedObjectiveList(self) -> int: ...
    def sizeOfLinkedPlaneList(self) -> int: ...
    def sizeOfLinkedPlateAcquisitionList(self) -> int: ...
    def sizeOfLinkedPlateList(self) -> int: ...
    def sizeOfLinkedProjectList(self) -> int: ...
    def sizeOfLinkedROIList(self) -> int: ...
    def sizeOfLinkedReagentList(self) -> int: ...
    def sizeOfLinkedScreenList(self) -> int: ...
    def sizeOfLinkedShapeList(self) -> int: ...
    def sizeOfLinkedWellList(self) -> int: ...
    def unlinkAnnotation(self, annotation: 'Annotation') -> bool: ...
    def unlinkChannel(self, channel: 'Channel') -> bool: ...
    def unlinkDataset(self, dataset: 'Dataset') -> bool: ...
    def unlinkDetector(self, detector: 'Detector') -> bool: ...
    def unlinkDichroic(self, dichroic: 'Dichroic') -> bool: ...
    def unlinkExperimenter(self, experimenter: 'Experimenter') -> bool: ...
    def unlinkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> bool: ...
    def unlinkFilter(self, filter: 'Filter') -> bool: ...
    def unlinkFolder(self, folder: 'Folder') -> bool: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def unlinkInstrument(self, instrument: 'Instrument') -> bool: ...
    def unlinkLightPath(self, lightPath: 'LightPath') -> bool: ...
    def unlinkLightSource(self, lightSource: 'LightSource') -> bool: ...
    def unlinkObjective(self, objective: 'Objective') -> bool: ...
    def unlinkPlane(self, plane: 'Plane') -> bool: ...
    def unlinkPlate(self, plate: 'Plate') -> bool: ...
    def unlinkPlateAcquisition(self, plateAcquisition: 'PlateAcquisition') -> bool: ...
    def unlinkProject(self, project: 'Project') -> bool: ...
    def unlinkROI(self, rOI: 'ROI') -> bool: ...
    def unlinkReagent(self, reagent: 'Reagent') -> bool: ...
    def unlinkScreen(self, screen: 'Screen') -> bool: ...
    def unlinkShape(self, shape: 'Shape') -> bool: ...
    def unlinkWell(self, well: 'Well') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class BinData(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, binData: 'BinData'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getBase64Binary(self) -> typing.List[int]: ...
    def getBigEndian(self) -> bool: ...
    def getCompression(self) -> bioformats_jar._ome.xml.model.enums.Compression: ...
    def getLength(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeLong: ...
    def getPixels(self) -> 'Pixels': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setBase64Binary(self, byteArray: typing.List[int]) -> None: ...
    def setBigEndian(self, boolean: bool) -> None: ...
    def setCompression(self, compression: bioformats_jar._ome.xml.model.enums.Compression) -> None: ...
    def setLength(self, nonNegativeLong: bioformats_jar._ome.xml.model.primitives.NonNegativeLong) -> None: ...
    def setPixels(self, pixels: 'Pixels') -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class BinaryFile(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, binaryFile: 'BinaryFile'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getBinData(self) -> BinData: ...
    def getExternal(self) -> 'External': ...
    def getFileName(self) -> java.lang.String: ...
    def getMIMEType(self) -> java.lang.String: ...
    def getSize(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeLong: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setBinData(self, binData: BinData) -> None: ...
    def setExternal(self, external: 'External') -> None: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMIMEType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSize(self, nonNegativeLong: bioformats_jar._ome.xml.model.primitives.NonNegativeLong) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class BinaryOnly(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, binaryOnly: 'BinaryOnly'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getMetadataFile(self) -> java.lang.String: ...
    def getUUID(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setMetadataFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUUID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Channel(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, channel: 'Channel'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getAcquisitionMode(self) -> bioformats_jar._ome.xml.model.enums.AcquisitionMode: ...
    def getColor(self) -> bioformats_jar._ome.xml.model.primitives.Color: ...
    def getContrastMethod(self) -> bioformats_jar._ome.xml.model.enums.ContrastMethod: ...
    def getDetectorSettings(self) -> 'DetectorSettings': ...
    def getEmissionWavelength(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getEmissionWavelengthUnitXsdDefault() -> java.lang.String: ...
    def getExcitationWavelength(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getExcitationWavelengthUnitXsdDefault() -> java.lang.String: ...
    def getFluor(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getIlluminationType(self) -> bioformats_jar._ome.xml.model.enums.IlluminationType: ...
    def getLightPath(self) -> 'LightPath': ...
    def getLightSourceSettings(self) -> 'LightSourceSettings': ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedFilterSet(self) -> 'FilterSet': ...
    def getNDFilter(self) -> float: ...
    def getName(self) -> java.lang.String: ...
    def getPinholeSize(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPinholeSizeUnitXsdDefault() -> java.lang.String: ...
    def getPixels(self) -> 'Pixels': ...
    def getPockelCellSetting(self) -> int: ...
    def getSamplesPerPixel(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkFilterSet(self, filterSet: 'FilterSet') -> None: ...
    def setAcquisitionMode(self, acquisitionMode: bioformats_jar._ome.xml.model.enums.AcquisitionMode) -> None: ...
    def setColor(self, color: bioformats_jar._ome.xml.model.primitives.Color) -> None: ...
    def setContrastMethod(self, contrastMethod: bioformats_jar._ome.xml.model.enums.ContrastMethod) -> None: ...
    def setDetectorSettings(self, detectorSettings: 'DetectorSettings') -> None: ...
    def setEmissionWavelength(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setExcitationWavelength(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setFluor(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setIlluminationType(self, illuminationType: bioformats_jar._ome.xml.model.enums.IlluminationType) -> None: ...
    def setLightPath(self, lightPath: 'LightPath') -> None: ...
    def setLightSourceSettings(self, lightSourceSettings: 'LightSourceSettings') -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setNDFilter(self, double: float) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPinholeSize(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPixels(self, pixels: 'Pixels') -> None: ...
    def setPockelCellSetting(self, integer: int) -> None: ...
    def setSamplesPerPixel(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkFilterSet(self, filterSet: 'FilterSet') -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Dataset(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, dataset: 'Dataset'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyLinkedProjectList(self) -> java.util.List['Project']: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedExperimenter(self) -> 'Experimenter': ...
    def getLinkedExperimenterGroup(self) -> 'ExperimenterGroup': ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getLinkedProject(self, int: int) -> 'Project': ...
    def getName(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkExperimenter(self, experimenter: 'Experimenter') -> None: ...
    def linkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> None: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def linkProject(self, project: 'Project') -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setLinkedProject(self, int: int, project: 'Project') -> 'Project': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedProjectList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkExperimenter(self, experimenter: 'Experimenter') -> None: ...
    def unlinkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> None: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def unlinkProject(self, project: 'Project') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Experiment(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experiment: 'Experiment'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyMicrobeamManipulationList(self) -> java.util.List['MicrobeamManipulation']: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedExperimenter(self) -> 'Experimenter': ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getMicrobeamManipulation(self, int: int) -> 'MicrobeamManipulation': ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.ExperimentType: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkExperimenter(self, experimenter: 'Experimenter') -> None: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def removeMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setMicrobeamManipulation(self, int: int, microbeamManipulation: 'MicrobeamManipulation') -> 'MicrobeamManipulation': ...
    def setType(self, experimentType: bioformats_jar._ome.xml.model.enums.ExperimentType) -> None: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfMicrobeamManipulationList(self) -> int: ...
    def unlinkExperimenter(self, experimenter: 'Experimenter') -> None: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Experimenter(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experimenter: 'Experimenter'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedDatasetList(self) -> java.util.List[Dataset]: ...
    def copyLinkedExperimentList(self) -> java.util.List[Experiment]: ...
    def copyLinkedExperimenterGroupList(self) -> java.util.List['ExperimenterGroup']: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyLinkedMicrobeamManipulationList(self) -> java.util.List['MicrobeamManipulation']: ...
    def copyLinkedProjectList(self) -> java.util.List['Project']: ...
    def getEmail(self) -> java.lang.String: ...
    def getFirstName(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getInstitution(self) -> java.lang.String: ...
    def getLastName(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedDataset(self, int: int) -> Dataset: ...
    def getLinkedExperiment(self, int: int) -> Experiment: ...
    def getLinkedExperimenterGroup(self, int: int) -> 'ExperimenterGroup': ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getLinkedMicrobeamManipulation(self, int: int) -> 'MicrobeamManipulation': ...
    def getLinkedProject(self, int: int) -> 'Project': ...
    def getMiddleName(self) -> java.lang.String: ...
    def getUserName(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkDataset(self, dataset: Dataset) -> bool: ...
    def linkExperiment(self, experiment: Experiment) -> bool: ...
    def linkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> bool: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def linkMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> bool: ...
    def linkProject(self, project: 'Project') -> bool: ...
    def setEmail(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFirstName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstitution(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLastName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedDataset(self, int: int, dataset: Dataset) -> Dataset: ...
    def setLinkedExperiment(self, int: int, experiment: Experiment) -> Experiment: ...
    def setLinkedExperimenterGroup(self, int: int, experimenterGroup: 'ExperimenterGroup') -> 'ExperimenterGroup': ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setLinkedMicrobeamManipulation(self, int: int, microbeamManipulation: 'MicrobeamManipulation') -> 'MicrobeamManipulation': ...
    def setLinkedProject(self, int: int, project: 'Project') -> 'Project': ...
    def setMiddleName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUserName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedDatasetList(self) -> int: ...
    def sizeOfLinkedExperimentList(self) -> int: ...
    def sizeOfLinkedExperimenterGroupList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedMicrobeamManipulationList(self) -> int: ...
    def sizeOfLinkedProjectList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkDataset(self, dataset: Dataset) -> bool: ...
    def unlinkExperiment(self, experiment: Experiment) -> bool: ...
    def unlinkExperimenterGroup(self, experimenterGroup: 'ExperimenterGroup') -> bool: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def unlinkMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> bool: ...
    def unlinkProject(self, project: 'Project') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ExperimenterGroup(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experimenterGroup: 'ExperimenterGroup'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedDatasetList(self) -> java.util.List[Dataset]: ...
    def copyLinkedExperimenterList(self) -> java.util.List[Experimenter]: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyLinkedLeaderList(self) -> java.util.List[Experimenter]: ...
    def copyLinkedProjectList(self) -> java.util.List['Project']: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedDataset(self, int: int) -> Dataset: ...
    def getLinkedExperimenter(self, int: int) -> Experimenter: ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getLinkedLeader(self, int: int) -> Experimenter: ...
    def getLinkedProject(self, int: int) -> 'Project': ...
    def getName(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkDataset(self, dataset: Dataset) -> bool: ...
    def linkExperimenter(self, experimenter: Experimenter) -> bool: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def linkLeader(self, experimenter: Experimenter) -> bool: ...
    def linkProject(self, project: 'Project') -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedDataset(self, int: int, dataset: Dataset) -> Dataset: ...
    def setLinkedExperimenter(self, int: int, experimenter: Experimenter) -> Experimenter: ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setLinkedLeader(self, int: int, experimenter: Experimenter) -> Experimenter: ...
    def setLinkedProject(self, int: int, project: 'Project') -> 'Project': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedDatasetList(self) -> int: ...
    def sizeOfLinkedExperimenterList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedLeaderList(self) -> int: ...
    def sizeOfLinkedProjectList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkDataset(self, dataset: Dataset) -> bool: ...
    def unlinkExperimenter(self, experimenter: Experimenter) -> bool: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def unlinkLeader(self, experimenter: Experimenter) -> bool: ...
    def unlinkProject(self, project: 'Project') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class External(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, external: 'External'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getCompression(self) -> bioformats_jar._ome.xml.model.enums.Compression: ...
    def getSHA1(self) -> java.lang.String: ...
    def gethref(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setCompression(self, compression: bioformats_jar._ome.xml.model.enums.Compression) -> None: ...
    def setSHA1(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sethref(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Folder(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, folder: 'Folder'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedChildFolderList(self) -> java.util.List['Folder']: ...
    def copyLinkedFolderList(self) -> java.util.List['Folder']: ...
    def copyLinkedImageList(self) -> java.util.List['Image']: ...
    def copyLinkedROIList(self) -> java.util.List['ROI']: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedChildFolder(self, int: int) -> 'Folder': ...
    def getLinkedFolder(self, int: int) -> 'Folder': ...
    def getLinkedImage(self, int: int) -> 'Image': ...
    def getLinkedROI(self, int: int) -> 'ROI': ...
    def getName(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkChildFolder(self, folder: 'Folder') -> bool: ...
    def linkFolder(self, folder: 'Folder') -> bool: ...
    def linkImage(self, image: 'Image') -> bool: ...
    def linkROI(self, rOI: 'ROI') -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedChildFolder(self, int: int, folder: 'Folder') -> 'Folder': ...
    def setLinkedFolder(self, int: int, folder: 'Folder') -> 'Folder': ...
    def setLinkedImage(self, int: int, image: 'Image') -> 'Image': ...
    def setLinkedROI(self, int: int, rOI: 'ROI') -> 'ROI': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedChildFolderList(self) -> int: ...
    def sizeOfLinkedFolderList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedROIList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkChildFolder(self, folder: 'Folder') -> bool: ...
    def unlinkFolder(self, folder: 'Folder') -> bool: ...
    def unlinkImage(self, image: 'Image') -> bool: ...
    def unlinkROI(self, rOI: 'ROI') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Image(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, image: 'Image'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedDatasetList(self) -> java.util.List[Dataset]: ...
    def copyLinkedFolderList(self) -> java.util.List[Folder]: ...
    def copyLinkedMicrobeamManipulationList(self) -> java.util.List['MicrobeamManipulation']: ...
    def copyLinkedROIList(self) -> java.util.List['ROI']: ...
    def copyLinkedWellSampleList(self) -> java.util.List['WellSample']: ...
    def getAcquisitionDate(self) -> bioformats_jar._ome.xml.model.primitives.Timestamp: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getImagingEnvironment(self) -> 'ImagingEnvironment': ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedDataset(self, int: int) -> Dataset: ...
    def getLinkedExperiment(self) -> Experiment: ...
    def getLinkedExperimenter(self) -> Experimenter: ...
    def getLinkedExperimenterGroup(self) -> ExperimenterGroup: ...
    def getLinkedFolder(self, int: int) -> Folder: ...
    def getLinkedInstrument(self) -> 'Instrument': ...
    def getLinkedMicrobeamManipulation(self, int: int) -> 'MicrobeamManipulation': ...
    def getLinkedROI(self, int: int) -> 'ROI': ...
    def getLinkedWellSample(self, int: int) -> 'WellSample': ...
    def getName(self) -> java.lang.String: ...
    def getObjectiveSettings(self) -> 'ObjectiveSettings': ...
    def getPixels(self) -> 'Pixels': ...
    def getStageLabel(self) -> 'StageLabel': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkDataset(self, dataset: Dataset) -> bool: ...
    def linkExperiment(self, experiment: Experiment) -> None: ...
    def linkExperimenter(self, experimenter: Experimenter) -> None: ...
    def linkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def linkFolder(self, folder: Folder) -> bool: ...
    def linkInstrument(self, instrument: 'Instrument') -> None: ...
    def linkMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> bool: ...
    def linkROI(self, rOI: 'ROI') -> bool: ...
    def linkWellSample(self, wellSample: 'WellSample') -> bool: ...
    def setAcquisitionDate(self, timestamp: bioformats_jar._ome.xml.model.primitives.Timestamp) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setImagingEnvironment(self, imagingEnvironment: 'ImagingEnvironment') -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedDataset(self, int: int, dataset: Dataset) -> Dataset: ...
    def setLinkedFolder(self, int: int, folder: Folder) -> Folder: ...
    def setLinkedMicrobeamManipulation(self, int: int, microbeamManipulation: 'MicrobeamManipulation') -> 'MicrobeamManipulation': ...
    def setLinkedROI(self, int: int, rOI: 'ROI') -> 'ROI': ...
    def setLinkedWellSample(self, int: int, wellSample: 'WellSample') -> 'WellSample': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setObjectiveSettings(self, objectiveSettings: 'ObjectiveSettings') -> None: ...
    def setPixels(self, pixels: 'Pixels') -> None: ...
    def setStageLabel(self, stageLabel: 'StageLabel') -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedDatasetList(self) -> int: ...
    def sizeOfLinkedFolderList(self) -> int: ...
    def sizeOfLinkedMicrobeamManipulationList(self) -> int: ...
    def sizeOfLinkedROIList(self) -> int: ...
    def sizeOfLinkedWellSampleList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkDataset(self, dataset: Dataset) -> bool: ...
    def unlinkExperiment(self, experiment: Experiment) -> None: ...
    def unlinkExperimenter(self, experimenter: Experimenter) -> None: ...
    def unlinkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def unlinkFolder(self, folder: Folder) -> bool: ...
    def unlinkInstrument(self, instrument: 'Instrument') -> None: ...
    def unlinkMicrobeamManipulation(self, microbeamManipulation: 'MicrobeamManipulation') -> bool: ...
    def unlinkROI(self, rOI: 'ROI') -> bool: ...
    def unlinkWellSample(self, wellSample: 'WellSample') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ImagingEnvironment(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, imagingEnvironment: 'ImagingEnvironment'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getAirPressure(self) -> bioformats_jar._ome.units.quantity.Pressure: ...
    @staticmethod
    def getAirPressureUnitXsdDefault() -> java.lang.String: ...
    def getCO2Percent(self) -> bioformats_jar._ome.xml.model.primitives.PercentFraction: ...
    def getHumidity(self) -> bioformats_jar._ome.xml.model.primitives.PercentFraction: ...
    def getMap(self) -> java.util.List[MapPair]: ...
    def getTemperature(self) -> bioformats_jar._ome.units.quantity.Temperature: ...
    @staticmethod
    def getTemperatureUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setAirPressure(self, pressure: bioformats_jar._ome.units.quantity.Pressure) -> None: ...
    def setCO2Percent(self, percentFraction: bioformats_jar._ome.xml.model.primitives.PercentFraction) -> None: ...
    def setHumidity(self, percentFraction: bioformats_jar._ome.xml.model.primitives.PercentFraction) -> None: ...
    def setMap(self, list: java.util.List[MapPair]) -> None: ...
    def setTemperature(self, temperature: bioformats_jar._ome.units.quantity.Temperature) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Instrument(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, instrument: 'Instrument'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addDetector(self, detector: 'Detector') -> None: ...
    def addDichroic(self, dichroic: 'Dichroic') -> None: ...
    def addFilter(self, filter: 'Filter') -> None: ...
    def addFilterSet(self, filterSet: 'FilterSet') -> None: ...
    def addLightSource(self, lightSource: 'LightSource') -> None: ...
    def addObjective(self, objective: 'Objective') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyDetectorList(self) -> java.util.List['Detector']: ...
    def copyDichroicList(self) -> java.util.List['Dichroic']: ...
    def copyFilterList(self) -> java.util.List['Filter']: ...
    def copyFilterSetList(self) -> java.util.List['FilterSet']: ...
    def copyLightSourceList(self) -> java.util.List['LightSource']: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedImageList(self) -> java.util.List[Image]: ...
    def copyObjectiveList(self) -> java.util.List['Objective']: ...
    def getDetector(self, int: int) -> 'Detector': ...
    def getDichroic(self, int: int) -> 'Dichroic': ...
    def getFilter(self, int: int) -> 'Filter': ...
    def getFilterSet(self, int: int) -> 'FilterSet': ...
    def getID(self) -> java.lang.String: ...
    def getLightSource(self, int: int) -> 'LightSource': ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedImage(self, int: int) -> Image: ...
    def getMicroscope(self) -> 'Microscope': ...
    def getObjective(self, int: int) -> 'Objective': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkImage(self, image: Image) -> bool: ...
    def removeDetector(self, detector: 'Detector') -> None: ...
    def removeDichroic(self, dichroic: 'Dichroic') -> None: ...
    def removeFilter(self, filter: 'Filter') -> None: ...
    def removeFilterSet(self, filterSet: 'FilterSet') -> None: ...
    def removeLightSource(self, lightSource: 'LightSource') -> None: ...
    def removeObjective(self, objective: 'Objective') -> None: ...
    def setDetector(self, int: int, detector: 'Detector') -> 'Detector': ...
    def setDichroic(self, int: int, dichroic: 'Dichroic') -> 'Dichroic': ...
    def setFilter(self, int: int, filter: 'Filter') -> 'Filter': ...
    def setFilterSet(self, int: int, filterSet: 'FilterSet') -> 'FilterSet': ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLightSource(self, int: int, lightSource: 'LightSource') -> 'LightSource': ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedImage(self, int: int, image: Image) -> Image: ...
    def setMicroscope(self, microscope: 'Microscope') -> None: ...
    def setObjective(self, int: int, objective: 'Objective') -> 'Objective': ...
    def sizeOfDetectorList(self) -> int: ...
    def sizeOfDichroicList(self) -> int: ...
    def sizeOfFilterList(self) -> int: ...
    def sizeOfFilterSetList(self) -> int: ...
    def sizeOfLightSourceList(self) -> int: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfObjectiveList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkImage(self, image: Image) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class LightPath(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, lightPath: 'LightPath'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedEmissionFilterList(self) -> java.util.List['Filter']: ...
    def copyLinkedExcitationFilterList(self) -> java.util.List['Filter']: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedDichroic(self) -> 'Dichroic': ...
    def getLinkedEmissionFilter(self, int: int) -> 'Filter': ...
    def getLinkedExcitationFilter(self, int: int) -> 'Filter': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkDichroic(self, dichroic: 'Dichroic') -> None: ...
    def linkEmissionFilter(self, filter: 'Filter') -> bool: ...
    def linkExcitationFilter(self, filter: 'Filter') -> bool: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedEmissionFilter(self, int: int, filter: 'Filter') -> 'Filter': ...
    def setLinkedExcitationFilter(self, int: int, filter: 'Filter') -> 'Filter': ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedEmissionFilterList(self) -> int: ...
    def sizeOfLinkedExcitationFilterList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkDichroic(self, dichroic: 'Dichroic') -> None: ...
    def unlinkEmissionFilter(self, filter: 'Filter') -> bool: ...
    def unlinkExcitationFilter(self, filter: 'Filter') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ManufacturerSpec(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, manufacturerSpec: 'ManufacturerSpec'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getLotNumber(self) -> java.lang.String: ...
    def getManufacturer(self) -> java.lang.String: ...
    def getModel(self) -> java.lang.String: ...
    def getSerialNumber(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setLotNumber(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setManufacturer(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSerialNumber(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class MetadataOnly(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, metadataOnly: 'MetadataOnly'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class MicrobeamManipulation(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, microbeamManipulation: 'MicrobeamManipulation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addLightSourceSettings(self, lightSourceSettings: 'LightSourceSettings') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLightSourceSettingsList(self) -> java.util.List['LightSourceSettings']: ...
    def copyLinkedImageList(self) -> java.util.List[Image]: ...
    def copyLinkedROIList(self) -> java.util.List['ROI']: ...
    def getDescription(self) -> java.lang.String: ...
    def getExperiment(self) -> Experiment: ...
    def getID(self) -> java.lang.String: ...
    def getLightSourceSettings(self, int: int) -> 'LightSourceSettings': ...
    def getLinkedExperimenter(self) -> Experimenter: ...
    def getLinkedImage(self, int: int) -> Image: ...
    def getLinkedROI(self, int: int) -> 'ROI': ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.MicrobeamManipulationType: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkExperimenter(self, experimenter: Experimenter) -> None: ...
    def linkImage(self, image: Image) -> bool: ...
    def linkROI(self, rOI: 'ROI') -> bool: ...
    def removeLightSourceSettings(self, lightSourceSettings: 'LightSourceSettings') -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setExperiment(self, experiment: Experiment) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLightSourceSettings(self, int: int, lightSourceSettings: 'LightSourceSettings') -> 'LightSourceSettings': ...
    def setLinkedImage(self, int: int, image: Image) -> Image: ...
    def setLinkedROI(self, int: int, rOI: 'ROI') -> 'ROI': ...
    def setType(self, microbeamManipulationType: bioformats_jar._ome.xml.model.enums.MicrobeamManipulationType) -> None: ...
    def sizeOfLightSourceSettingsList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedROIList(self) -> int: ...
    def unlinkExperimenter(self, experimenter: Experimenter) -> None: ...
    def unlinkImage(self, image: Image) -> bool: ...
    def unlinkROI(self, rOI: 'ROI') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class OME(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, oME: 'OME'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addDataset(self, dataset: Dataset) -> None: ...
    def addExperiment(self, experiment: Experiment) -> None: ...
    def addExperimenter(self, experimenter: Experimenter) -> None: ...
    def addExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def addFolder(self, folder: Folder) -> None: ...
    def addImage(self, image: Image) -> None: ...
    def addInstrument(self, instrument: Instrument) -> None: ...
    def addPlate(self, plate: 'Plate') -> None: ...
    def addProject(self, project: 'Project') -> None: ...
    def addROI(self, rOI: 'ROI') -> None: ...
    def addScreen(self, screen: 'Screen') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyDatasetList(self) -> java.util.List[Dataset]: ...
    def copyExperimentList(self) -> java.util.List[Experiment]: ...
    def copyExperimenterGroupList(self) -> java.util.List[ExperimenterGroup]: ...
    def copyExperimenterList(self) -> java.util.List[Experimenter]: ...
    def copyFolderList(self) -> java.util.List[Folder]: ...
    def copyImageList(self) -> java.util.List[Image]: ...
    def copyInstrumentList(self) -> java.util.List[Instrument]: ...
    def copyPlateList(self) -> java.util.List['Plate']: ...
    def copyProjectList(self) -> java.util.List['Project']: ...
    def copyROIList(self) -> java.util.List['ROI']: ...
    def copyScreenList(self) -> java.util.List['Screen']: ...
    def getBinaryOnly(self) -> BinaryOnly: ...
    def getCreator(self) -> java.lang.String: ...
    def getDataset(self, int: int) -> Dataset: ...
    def getExperiment(self, int: int) -> Experiment: ...
    def getExperimenter(self, int: int) -> Experimenter: ...
    def getExperimenterGroup(self, int: int) -> ExperimenterGroup: ...
    def getFolder(self, int: int) -> Folder: ...
    def getImage(self, int: int) -> Image: ...
    def getInstrument(self, int: int) -> Instrument: ...
    def getPlate(self, int: int) -> 'Plate': ...
    def getProject(self, int: int) -> 'Project': ...
    def getROI(self, int: int) -> 'ROI': ...
    def getRights(self) -> 'Rights': ...
    def getScreen(self, int: int) -> 'Screen': ...
    def getStructuredAnnotations(self) -> 'StructuredAnnotations': ...
    def getUUID(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def removeDataset(self, dataset: Dataset) -> None: ...
    def removeExperiment(self, experiment: Experiment) -> None: ...
    def removeExperimenter(self, experimenter: Experimenter) -> None: ...
    def removeExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def removeFolder(self, folder: Folder) -> None: ...
    def removeImage(self, image: Image) -> None: ...
    def removeInstrument(self, instrument: Instrument) -> None: ...
    def removePlate(self, plate: 'Plate') -> None: ...
    def removeProject(self, project: 'Project') -> None: ...
    def removeROI(self, rOI: 'ROI') -> None: ...
    def removeScreen(self, screen: 'Screen') -> None: ...
    def setBinaryOnly(self, binaryOnly: BinaryOnly) -> None: ...
    def setCreator(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDataset(self, int: int, dataset: Dataset) -> Dataset: ...
    def setExperiment(self, int: int, experiment: Experiment) -> Experiment: ...
    def setExperimenter(self, int: int, experimenter: Experimenter) -> Experimenter: ...
    def setExperimenterGroup(self, int: int, experimenterGroup: ExperimenterGroup) -> ExperimenterGroup: ...
    def setFolder(self, int: int, folder: Folder) -> Folder: ...
    def setImage(self, int: int, image: Image) -> Image: ...
    def setInstrument(self, int: int, instrument: Instrument) -> Instrument: ...
    def setPlate(self, int: int, plate: 'Plate') -> 'Plate': ...
    def setProject(self, int: int, project: 'Project') -> 'Project': ...
    def setROI(self, int: int, rOI: 'ROI') -> 'ROI': ...
    def setRights(self, rights: 'Rights') -> None: ...
    def setScreen(self, int: int, screen: 'Screen') -> 'Screen': ...
    def setStructuredAnnotations(self, structuredAnnotations: 'StructuredAnnotations') -> None: ...
    def setUUID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfDatasetList(self) -> int: ...
    def sizeOfExperimentList(self) -> int: ...
    def sizeOfExperimenterGroupList(self) -> int: ...
    def sizeOfExperimenterList(self) -> int: ...
    def sizeOfFolderList(self) -> int: ...
    def sizeOfImageList(self) -> int: ...
    def sizeOfInstrumentList(self) -> int: ...
    def sizeOfPlateList(self) -> int: ...
    def sizeOfProjectList(self) -> int: ...
    def sizeOfROIList(self) -> int: ...
    def sizeOfScreenList(self) -> int: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Pixels(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pixels: 'Pixels'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addBinData(self, binData: BinData) -> None: ...
    def addChannel(self, channel: Channel) -> None: ...
    def addPlane(self, plane: 'Plane') -> None: ...
    def addTiffData(self, tiffData: 'TiffData') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyBinDataList(self) -> java.util.List[BinData]: ...
    def copyChannelList(self) -> java.util.List[Channel]: ...
    def copyPlaneList(self) -> java.util.List['Plane']: ...
    def copyTiffDataList(self) -> java.util.List['TiffData']: ...
    def getBigEndian(self) -> bool: ...
    def getBinData(self, int: int) -> BinData: ...
    def getChannel(self, int: int) -> Channel: ...
    def getDimensionOrder(self) -> bioformats_jar._ome.xml.model.enums.DimensionOrder: ...
    def getID(self) -> java.lang.String: ...
    def getInterleaved(self) -> bool: ...
    def getMetadataOnly(self) -> MetadataOnly: ...
    def getPhysicalSizeX(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPhysicalSizeXUnitXsdDefault() -> java.lang.String: ...
    def getPhysicalSizeY(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPhysicalSizeYUnitXsdDefault() -> java.lang.String: ...
    def getPhysicalSizeZ(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPhysicalSizeZUnitXsdDefault() -> java.lang.String: ...
    def getPlane(self, int: int) -> 'Plane': ...
    def getSignificantBits(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getSizeC(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getSizeT(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getSizeX(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getSizeY(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getSizeZ(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getTiffData(self, int: int) -> 'TiffData': ...
    def getTimeIncrement(self) -> bioformats_jar._ome.units.quantity.Time: ...
    @staticmethod
    def getTimeIncrementUnitXsdDefault() -> java.lang.String: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.PixelType: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def removeBinData(self, binData: BinData) -> None: ...
    def removeChannel(self, channel: Channel) -> None: ...
    def removePlane(self, plane: 'Plane') -> None: ...
    def removeTiffData(self, tiffData: 'TiffData') -> None: ...
    def setBigEndian(self, boolean: bool) -> None: ...
    def setBinData(self, int: int, binData: BinData) -> BinData: ...
    def setChannel(self, int: int, channel: Channel) -> Channel: ...
    def setDimensionOrder(self, dimensionOrder: bioformats_jar._ome.xml.model.enums.DimensionOrder) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInterleaved(self, boolean: bool) -> None: ...
    def setMetadataOnly(self, metadataOnly: MetadataOnly) -> None: ...
    def setPhysicalSizeX(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPhysicalSizeY(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPhysicalSizeZ(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPlane(self, int: int, plane: 'Plane') -> 'Plane': ...
    def setSignificantBits(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setSizeC(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setSizeT(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setSizeX(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setSizeY(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setSizeZ(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setTiffData(self, int: int, tiffData: 'TiffData') -> 'TiffData': ...
    def setTimeIncrement(self, time: bioformats_jar._ome.units.quantity.Time) -> None: ...
    def setType(self, pixelType: bioformats_jar._ome.xml.model.enums.PixelType) -> None: ...
    def sizeOfBinDataList(self) -> int: ...
    def sizeOfChannelList(self) -> int: ...
    def sizeOfPlaneList(self) -> int: ...
    def sizeOfTiffDataList(self) -> int: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Plane(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, plane: 'Plane'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getDeltaT(self) -> bioformats_jar._ome.units.quantity.Time: ...
    @staticmethod
    def getDeltaTUnitXsdDefault() -> java.lang.String: ...
    def getExposureTime(self) -> bioformats_jar._ome.units.quantity.Time: ...
    @staticmethod
    def getExposureTimeUnitXsdDefault() -> java.lang.String: ...
    def getHashSHA1(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getPixels(self) -> Pixels: ...
    def getPositionX(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPositionXUnitXsdDefault() -> java.lang.String: ...
    def getPositionY(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPositionYUnitXsdDefault() -> java.lang.String: ...
    def getPositionZ(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPositionZUnitXsdDefault() -> java.lang.String: ...
    def getTheC(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getTheT(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getTheZ(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def setDeltaT(self, time: bioformats_jar._ome.units.quantity.Time) -> None: ...
    def setExposureTime(self, time: bioformats_jar._ome.units.quantity.Time) -> None: ...
    def setHashSHA1(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setPixels(self, pixels: Pixels) -> None: ...
    def setPositionX(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPositionY(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPositionZ(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setTheC(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setTheT(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setTheZ(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Plate(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, plate: 'Plate'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addPlateAcquisition(self, plateAcquisition: 'PlateAcquisition') -> None: ...
    def addWell(self, well: 'Well') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedScreenList(self) -> java.util.List['Screen']: ...
    def copyPlateAcquisitionList(self) -> java.util.List['PlateAcquisition']: ...
    def copyWellList(self) -> java.util.List['Well']: ...
    def getColumnNamingConvention(self) -> bioformats_jar._ome.xml.model.enums.NamingConvention: ...
    def getColumns(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getDescription(self) -> java.lang.String: ...
    def getExternalIdentifier(self) -> java.lang.String: ...
    def getFieldIndex(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedScreen(self, int: int) -> 'Screen': ...
    def getName(self) -> java.lang.String: ...
    def getPlateAcquisition(self, int: int) -> 'PlateAcquisition': ...
    def getRowNamingConvention(self) -> bioformats_jar._ome.xml.model.enums.NamingConvention: ...
    def getRows(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getStatus(self) -> java.lang.String: ...
    def getWell(self, int: int) -> 'Well': ...
    def getWellOriginX(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getWellOriginXUnitXsdDefault() -> java.lang.String: ...
    def getWellOriginY(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getWellOriginYUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkScreen(self, screen: 'Screen') -> bool: ...
    def removePlateAcquisition(self, plateAcquisition: 'PlateAcquisition') -> None: ...
    def removeWell(self, well: 'Well') -> None: ...
    def setColumnNamingConvention(self, namingConvention: bioformats_jar._ome.xml.model.enums.NamingConvention) -> None: ...
    def setColumns(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setExternalIdentifier(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFieldIndex(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedScreen(self, int: int, screen: 'Screen') -> 'Screen': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPlateAcquisition(self, int: int, plateAcquisition: 'PlateAcquisition') -> 'PlateAcquisition': ...
    def setRowNamingConvention(self, namingConvention: bioformats_jar._ome.xml.model.enums.NamingConvention) -> None: ...
    def setRows(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setStatus(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setWell(self, int: int, well: 'Well') -> 'Well': ...
    def setWellOriginX(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setWellOriginY(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedScreenList(self) -> int: ...
    def sizeOfPlateAcquisitionList(self) -> int: ...
    def sizeOfWellList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkScreen(self, screen: 'Screen') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class PlateAcquisition(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, plateAcquisition: 'PlateAcquisition'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedWellSampleList(self) -> java.util.List['WellSample']: ...
    def getDescription(self) -> java.lang.String: ...
    def getEndTime(self) -> bioformats_jar._ome.xml.model.primitives.Timestamp: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedWellSample(self, int: int) -> 'WellSample': ...
    def getMaximumFieldCount(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getName(self) -> java.lang.String: ...
    def getPlate(self) -> Plate: ...
    def getStartTime(self) -> bioformats_jar._ome.xml.model.primitives.Timestamp: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkWellSample(self, wellSample: 'WellSample') -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setEndTime(self, timestamp: bioformats_jar._ome.xml.model.primitives.Timestamp) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedWellSample(self, int: int, wellSample: 'WellSample') -> 'WellSample': ...
    def setMaximumFieldCount(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPlate(self, plate: Plate) -> None: ...
    def setStartTime(self, timestamp: bioformats_jar._ome.xml.model.primitives.Timestamp) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedWellSampleList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkWellSample(self, wellSample: 'WellSample') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Project(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, project: 'Project'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedDatasetList(self) -> java.util.List[Dataset]: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedDataset(self, int: int) -> Dataset: ...
    def getLinkedExperimenter(self) -> Experimenter: ...
    def getLinkedExperimenterGroup(self) -> ExperimenterGroup: ...
    def getName(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkDataset(self, dataset: Dataset) -> bool: ...
    def linkExperimenter(self, experimenter: Experimenter) -> None: ...
    def linkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedDataset(self, int: int, dataset: Dataset) -> Dataset: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedDatasetList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkDataset(self, dataset: Dataset) -> bool: ...
    def unlinkExperimenter(self, experimenter: Experimenter) -> None: ...
    def unlinkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ROI(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, rOI: 'ROI'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedFolderList(self) -> java.util.List[Folder]: ...
    def copyLinkedImageList(self) -> java.util.List[Image]: ...
    def copyLinkedMicrobeamManipulationList(self) -> java.util.List[MicrobeamManipulation]: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedFolder(self, int: int) -> Folder: ...
    def getLinkedImage(self, int: int) -> Image: ...
    def getLinkedMicrobeamManipulation(self, int: int) -> MicrobeamManipulation: ...
    def getName(self) -> java.lang.String: ...
    def getUnion(self) -> 'Union': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkFolder(self, folder: Folder) -> bool: ...
    def linkImage(self, image: Image) -> bool: ...
    def linkMicrobeamManipulation(self, microbeamManipulation: MicrobeamManipulation) -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedFolder(self, int: int, folder: Folder) -> Folder: ...
    def setLinkedImage(self, int: int, image: Image) -> Image: ...
    def setLinkedMicrobeamManipulation(self, int: int, microbeamManipulation: MicrobeamManipulation) -> MicrobeamManipulation: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUnion(self, union: 'Union') -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedFolderList(self) -> int: ...
    def sizeOfLinkedImageList(self) -> int: ...
    def sizeOfLinkedMicrobeamManipulationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkFolder(self, folder: Folder) -> bool: ...
    def unlinkImage(self, image: Image) -> bool: ...
    def unlinkMicrobeamManipulation(self, microbeamManipulation: MicrobeamManipulation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Reagent(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, reagent: 'Reagent'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedWellList(self) -> java.util.List['Well']: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedWell(self, int: int) -> 'Well': ...
    def getName(self) -> java.lang.String: ...
    def getReagentIdentifier(self) -> java.lang.String: ...
    def getScreen(self) -> 'Screen': ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkWell(self, well: 'Well') -> bool: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedWell(self, int: int, well: 'Well') -> 'Well': ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReagentIdentifier(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setScreen(self, screen: 'Screen') -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedWellList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkWell(self, well: 'Well') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Reference(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, reference: 'Reference'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: 'Reference', oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Rights(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, rights: 'Rights'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getRightsHeld(self) -> java.lang.String: ...
    def getRightsHolder(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setRightsHeld(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setRightsHolder(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Screen(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, screen: 'Screen'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addReagent(self, reagent: Reagent) -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedPlateList(self) -> java.util.List[Plate]: ...
    def copyReagentList(self) -> java.util.List[Reagent]: ...
    def getDescription(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedPlate(self, int: int) -> Plate: ...
    def getName(self) -> java.lang.String: ...
    def getProtocolDescription(self) -> java.lang.String: ...
    def getProtocolIdentifier(self) -> java.lang.String: ...
    def getReagent(self, int: int) -> Reagent: ...
    def getReagentSetDescription(self) -> java.lang.String: ...
    def getReagentSetIdentifier(self) -> java.lang.String: ...
    def getType(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkPlate(self, plate: Plate) -> bool: ...
    def removeReagent(self, reagent: Reagent) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedPlate(self, int: int, plate: Plate) -> Plate: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setProtocolDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setProtocolIdentifier(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReagent(self, int: int, reagent: Reagent) -> Reagent: ...
    def setReagentSetDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReagentSetIdentifier(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedPlateList(self) -> int: ...
    def sizeOfReagentList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkPlate(self, plate: Plate) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Shape(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, shape: 'Shape'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getFillColor(self) -> bioformats_jar._ome.xml.model.primitives.Color: ...
    def getFillRule(self) -> bioformats_jar._ome.xml.model.enums.FillRule: ...
    def getFontFamily(self) -> bioformats_jar._ome.xml.model.enums.FontFamily: ...
    def getFontSize(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getFontSizeUnitXsdDefault() -> java.lang.String: ...
    def getFontStyle(self) -> bioformats_jar._ome.xml.model.enums.FontStyle: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLocked(self) -> bool: ...
    def getStrokeColor(self) -> bioformats_jar._ome.xml.model.primitives.Color: ...
    def getStrokeDashArray(self) -> java.lang.String: ...
    def getStrokeWidth(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getStrokeWidthUnitXsdDefault() -> java.lang.String: ...
    def getText(self) -> java.lang.String: ...
    def getTheC(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getTheT(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getTheZ(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getTransform(self) -> AffineTransform: ...
    def getUnion(self) -> 'Union': ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def setFillColor(self, color: bioformats_jar._ome.xml.model.primitives.Color) -> None: ...
    def setFillRule(self, fillRule: bioformats_jar._ome.xml.model.enums.FillRule) -> None: ...
    def setFontFamily(self, fontFamily: bioformats_jar._ome.xml.model.enums.FontFamily) -> None: ...
    def setFontSize(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setFontStyle(self, fontStyle: bioformats_jar._ome.xml.model.enums.FontStyle) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLocked(self, boolean: bool) -> None: ...
    def setStrokeColor(self, color: bioformats_jar._ome.xml.model.primitives.Color) -> None: ...
    def setStrokeDashArray(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStrokeWidth(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTheC(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setTheT(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setTheZ(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setTransform(self, affineTransform: AffineTransform) -> None: ...
    def setUnion(self, union: 'Union') -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class StageLabel(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, stageLabel: 'StageLabel'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getName(self) -> java.lang.String: ...
    def getX(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getXUnitXsdDefault() -> java.lang.String: ...
    def getY(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getYUnitXsdDefault() -> java.lang.String: ...
    def getZ(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getZUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setX(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setY(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setZ(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class StructuredAnnotations(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, structuredAnnotations: 'StructuredAnnotations'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addBooleanAnnotation(self, booleanAnnotation: 'BooleanAnnotation') -> None: ...
    def addCommentAnnotation(self, commentAnnotation: 'CommentAnnotation') -> None: ...
    def addDoubleAnnotation(self, doubleAnnotation: 'DoubleAnnotation') -> None: ...
    def addFileAnnotation(self, fileAnnotation: 'FileAnnotation') -> None: ...
    def addListAnnotation(self, listAnnotation: 'ListAnnotation') -> None: ...
    def addLongAnnotation(self, longAnnotation: 'LongAnnotation') -> None: ...
    def addMapAnnotation(self, mapAnnotation: 'MapAnnotation') -> None: ...
    def addTagAnnotation(self, tagAnnotation: 'TagAnnotation') -> None: ...
    def addTermAnnotation(self, termAnnotation: 'TermAnnotation') -> None: ...
    def addTimestampAnnotation(self, timestampAnnotation: 'TimestampAnnotation') -> None: ...
    def addXMLAnnotation(self, xMLAnnotation: 'XMLAnnotation') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyBooleanAnnotationList(self) -> java.util.List['BooleanAnnotation']: ...
    def copyCommentAnnotationList(self) -> java.util.List['CommentAnnotation']: ...
    def copyDoubleAnnotationList(self) -> java.util.List['DoubleAnnotation']: ...
    def copyFileAnnotationList(self) -> java.util.List['FileAnnotation']: ...
    def copyListAnnotationList(self) -> java.util.List['ListAnnotation']: ...
    def copyLongAnnotationList(self) -> java.util.List['LongAnnotation']: ...
    def copyMapAnnotationList(self) -> java.util.List['MapAnnotation']: ...
    def copyTagAnnotationList(self) -> java.util.List['TagAnnotation']: ...
    def copyTermAnnotationList(self) -> java.util.List['TermAnnotation']: ...
    def copyTimestampAnnotationList(self) -> java.util.List['TimestampAnnotation']: ...
    def copyXMLAnnotationList(self) -> java.util.List['XMLAnnotation']: ...
    def getBooleanAnnotation(self, int: int) -> 'BooleanAnnotation': ...
    def getCommentAnnotation(self, int: int) -> 'CommentAnnotation': ...
    def getDoubleAnnotation(self, int: int) -> 'DoubleAnnotation': ...
    def getFileAnnotation(self, int: int) -> 'FileAnnotation': ...
    def getListAnnotation(self, int: int) -> 'ListAnnotation': ...
    def getLongAnnotation(self, int: int) -> 'LongAnnotation': ...
    def getMapAnnotation(self, int: int) -> 'MapAnnotation': ...
    def getTagAnnotation(self, int: int) -> 'TagAnnotation': ...
    def getTermAnnotation(self, int: int) -> 'TermAnnotation': ...
    def getTimestampAnnotation(self, int: int) -> 'TimestampAnnotation': ...
    def getXMLAnnotation(self, int: int) -> 'XMLAnnotation': ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def removeBooleanAnnotation(self, booleanAnnotation: 'BooleanAnnotation') -> None: ...
    def removeCommentAnnotation(self, commentAnnotation: 'CommentAnnotation') -> None: ...
    def removeDoubleAnnotation(self, doubleAnnotation: 'DoubleAnnotation') -> None: ...
    def removeFileAnnotation(self, fileAnnotation: 'FileAnnotation') -> None: ...
    def removeListAnnotation(self, listAnnotation: 'ListAnnotation') -> None: ...
    def removeLongAnnotation(self, longAnnotation: 'LongAnnotation') -> None: ...
    def removeMapAnnotation(self, mapAnnotation: 'MapAnnotation') -> None: ...
    def removeTagAnnotation(self, tagAnnotation: 'TagAnnotation') -> None: ...
    def removeTermAnnotation(self, termAnnotation: 'TermAnnotation') -> None: ...
    def removeTimestampAnnotation(self, timestampAnnotation: 'TimestampAnnotation') -> None: ...
    def removeXMLAnnotation(self, xMLAnnotation: 'XMLAnnotation') -> None: ...
    def setBooleanAnnotation(self, int: int, booleanAnnotation: 'BooleanAnnotation') -> 'BooleanAnnotation': ...
    def setCommentAnnotation(self, int: int, commentAnnotation: 'CommentAnnotation') -> 'CommentAnnotation': ...
    def setDoubleAnnotation(self, int: int, doubleAnnotation: 'DoubleAnnotation') -> 'DoubleAnnotation': ...
    def setFileAnnotation(self, int: int, fileAnnotation: 'FileAnnotation') -> 'FileAnnotation': ...
    def setListAnnotation(self, int: int, listAnnotation: 'ListAnnotation') -> 'ListAnnotation': ...
    def setLongAnnotation(self, int: int, longAnnotation: 'LongAnnotation') -> 'LongAnnotation': ...
    def setMapAnnotation(self, int: int, mapAnnotation: 'MapAnnotation') -> 'MapAnnotation': ...
    def setTagAnnotation(self, int: int, tagAnnotation: 'TagAnnotation') -> 'TagAnnotation': ...
    def setTermAnnotation(self, int: int, termAnnotation: 'TermAnnotation') -> 'TermAnnotation': ...
    def setTimestampAnnotation(self, int: int, timestampAnnotation: 'TimestampAnnotation') -> 'TimestampAnnotation': ...
    def setXMLAnnotation(self, int: int, xMLAnnotation: 'XMLAnnotation') -> 'XMLAnnotation': ...
    def sizeOfBooleanAnnotationList(self) -> int: ...
    def sizeOfCommentAnnotationList(self) -> int: ...
    def sizeOfDoubleAnnotationList(self) -> int: ...
    def sizeOfFileAnnotationList(self) -> int: ...
    def sizeOfListAnnotationList(self) -> int: ...
    def sizeOfLongAnnotationList(self) -> int: ...
    def sizeOfMapAnnotationList(self) -> int: ...
    def sizeOfTagAnnotationList(self) -> int: ...
    def sizeOfTermAnnotationList(self) -> int: ...
    def sizeOfTimestampAnnotationList(self) -> int: ...
    def sizeOfXMLAnnotationList(self) -> int: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TiffData(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, tiffData: 'TiffData'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getFirstC(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getFirstT(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getFirstZ(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getIFD(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getPixels(self) -> Pixels: ...
    def getPlaneCount(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getUUID(self) -> 'UUID': ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setFirstC(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setFirstT(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setFirstZ(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setIFD(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setPixels(self, pixels: Pixels) -> None: ...
    def setPlaneCount(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setUUID(self, uUID: 'UUID') -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TransmittanceRange(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, transmittanceRange: 'TransmittanceRange'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getCutIn(self) -> bioformats_jar._ome.units.quantity.Length: ...
    def getCutInTolerance(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getCutInToleranceUnitXsdDefault() -> java.lang.String: ...
    @staticmethod
    def getCutInUnitXsdDefault() -> java.lang.String: ...
    def getCutOut(self) -> bioformats_jar._ome.units.quantity.Length: ...
    def getCutOutTolerance(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getCutOutToleranceUnitXsdDefault() -> java.lang.String: ...
    @staticmethod
    def getCutOutUnitXsdDefault() -> java.lang.String: ...
    def getTransmittance(self) -> bioformats_jar._ome.xml.model.primitives.PercentFraction: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setCutIn(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setCutInTolerance(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setCutOut(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setCutOutTolerance(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setTransmittance(self, percentFraction: bioformats_jar._ome.xml.model.primitives.PercentFraction) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class UUID(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, uUID: 'UUID'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getFileName(self) -> java.lang.String: ...
    def getValue(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Union(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, union: 'Union'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addShape(self, shape: Shape) -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyShapeList(self) -> java.util.List[Shape]: ...
    def getShape(self, int: int) -> Shape: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def removeShape(self, shape: Shape) -> None: ...
    def setShape(self, int: int, shape: Shape) -> Shape: ...
    def sizeOfShapeList(self) -> int: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Well(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, well: 'Well'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    def addWellSample(self, wellSample: 'WellSample') -> None: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyWellSampleList(self) -> java.util.List['WellSample']: ...
    def getColor(self) -> bioformats_jar._ome.xml.model.primitives.Color: ...
    def getColumn(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getExternalDescription(self) -> java.lang.String: ...
    def getExternalIdentifier(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedReagent(self) -> Reagent: ...
    def getPlate(self) -> Plate: ...
    def getRow(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getType(self) -> java.lang.String: ...
    def getWellSample(self, int: int) -> 'WellSample': ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkReagent(self, reagent: Reagent) -> None: ...
    def removeWellSample(self, wellSample: 'WellSample') -> None: ...
    def setColor(self, color: bioformats_jar._ome.xml.model.primitives.Color) -> None: ...
    def setColumn(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setExternalDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setExternalIdentifier(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setPlate(self, plate: Plate) -> None: ...
    def setRow(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setWellSample(self, int: int, wellSample: 'WellSample') -> 'WellSample': ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfWellSampleList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkReagent(self, reagent: Reagent) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class WellSample(AbstractOMEModelObject):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, wellSample: 'WellSample'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedPlateAcquisitionList(self) -> java.util.List[PlateAcquisition]: ...
    def getID(self) -> java.lang.String: ...
    def getIndex(self) -> bioformats_jar._ome.xml.model.primitives.NonNegativeInteger: ...
    def getLinkedImage(self) -> Image: ...
    def getLinkedPlateAcquisition(self, int: int) -> PlateAcquisition: ...
    def getPositionX(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPositionXUnitXsdDefault() -> java.lang.String: ...
    def getPositionY(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getPositionYUnitXsdDefault() -> java.lang.String: ...
    def getTimepoint(self) -> bioformats_jar._ome.xml.model.primitives.Timestamp: ...
    def getWell(self) -> Well: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkImage(self, image: Image) -> None: ...
    def linkPlateAcquisition(self, plateAcquisition: PlateAcquisition) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setIndex(self, nonNegativeInteger: bioformats_jar._ome.xml.model.primitives.NonNegativeInteger) -> None: ...
    def setLinkedPlateAcquisition(self, int: int, plateAcquisition: PlateAcquisition) -> PlateAcquisition: ...
    def setPositionX(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setPositionY(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def setTimepoint(self, timestamp: bioformats_jar._ome.xml.model.primitives.Timestamp) -> None: ...
    def setWell(self, well: Well) -> None: ...
    def sizeOfLinkedPlateAcquisitionList(self) -> int: ...
    def unlinkImage(self, image: Image) -> None: ...
    def unlinkPlateAcquisition(self, plateAcquisition: PlateAcquisition) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class AnnotationRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, annotationRef: 'AnnotationRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class BasicAnnotation(Annotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, basicAnnotation: 'BasicAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ChannelRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, channelRef: 'ChannelRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class DatasetRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, datasetRef: 'DatasetRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Detector(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, detector: 'Detector'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getAmplificationGain(self) -> float: ...
    def getGain(self) -> float: ...
    def getID(self) -> java.lang.String: ...
    def getInstrument(self) -> Instrument: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getOffset(self) -> float: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.DetectorType: ...
    def getVoltage(self) -> bioformats_jar._ome.units.quantity.ElectricPotential: ...
    @staticmethod
    def getVoltageUnitXsdDefault() -> java.lang.String: ...
    def getZoom(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def setAmplificationGain(self, double: float) -> None: ...
    def setGain(self, double: float) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setOffset(self, double: float) -> None: ...
    def setType(self, detectorType: bioformats_jar._ome.xml.model.enums.DetectorType) -> None: ...
    def setVoltage(self, electricPotential: bioformats_jar._ome.units.quantity.ElectricPotential) -> None: ...
    def setZoom(self, double: float) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Dichroic(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, dichroic: 'Dichroic'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedFilterSetList(self) -> java.util.List['FilterSet']: ...
    def copyLinkedLightPathList(self) -> java.util.List[LightPath]: ...
    def getID(self) -> java.lang.String: ...
    def getInstrument(self) -> Instrument: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedFilterSet(self, int: int) -> 'FilterSet': ...
    def getLinkedLightPath(self, int: int) -> LightPath: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkFilterSet(self, filterSet: 'FilterSet') -> bool: ...
    def linkLightPath(self, lightPath: LightPath) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedFilterSet(self, int: int, filterSet: 'FilterSet') -> 'FilterSet': ...
    def setLinkedLightPath(self, int: int, lightPath: LightPath) -> LightPath: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedFilterSetList(self) -> int: ...
    def sizeOfLinkedLightPathList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkFilterSet(self, filterSet: 'FilterSet') -> bool: ...
    def unlinkLightPath(self, lightPath: LightPath) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class DichroicRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, dichroicRef: 'DichroicRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Ellipse(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, ellipse: 'Ellipse'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getRadiusX(self) -> float: ...
    def getRadiusY(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setRadiusX(self, double: float) -> None: ...
    def setRadiusY(self, double: float) -> None: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ExperimentRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experimentRef: 'ExperimentRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ExperimenterGroupRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experimenterGroupRef: 'ExperimenterGroupRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ExperimenterRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, experimenterRef: 'ExperimenterRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Filter(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, filter: 'Filter'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def copyLinkedFilterSetEmissionFilterList(self) -> java.util.List['FilterSet']: ...
    def copyLinkedFilterSetExcitationFilterList(self) -> java.util.List['FilterSet']: ...
    def copyLinkedLightPathEmissionFilterList(self) -> java.util.List[LightPath]: ...
    def copyLinkedLightPathExcitationFilterList(self) -> java.util.List[LightPath]: ...
    def getFilterWheel(self) -> java.lang.String: ...
    def getID(self) -> java.lang.String: ...
    def getInstrument(self) -> Instrument: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getLinkedFilterSetEmissionFilter(self, int: int) -> 'FilterSet': ...
    def getLinkedFilterSetExcitationFilter(self, int: int) -> 'FilterSet': ...
    def getLinkedLightPathEmissionFilter(self, int: int) -> LightPath: ...
    def getLinkedLightPathExcitationFilter(self, int: int) -> LightPath: ...
    def getTransmittanceRange(self) -> TransmittanceRange: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.FilterType: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def linkFilterSetEmissionFilter(self, filterSet: 'FilterSet') -> bool: ...
    def linkFilterSetExcitationFilter(self, filterSet: 'FilterSet') -> bool: ...
    def linkLightPathEmissionFilter(self, lightPath: LightPath) -> bool: ...
    def linkLightPathExcitationFilter(self, lightPath: LightPath) -> bool: ...
    def setFilterWheel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setLinkedFilterSetEmissionFilter(self, int: int, filterSet: 'FilterSet') -> 'FilterSet': ...
    def setLinkedFilterSetExcitationFilter(self, int: int, filterSet: 'FilterSet') -> 'FilterSet': ...
    def setLinkedLightPathEmissionFilter(self, int: int, lightPath: LightPath) -> LightPath: ...
    def setLinkedLightPathExcitationFilter(self, int: int, lightPath: LightPath) -> LightPath: ...
    def setTransmittanceRange(self, transmittanceRange: TransmittanceRange) -> None: ...
    def setType(self, filterType: bioformats_jar._ome.xml.model.enums.FilterType) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def sizeOfLinkedFilterSetEmissionFilterList(self) -> int: ...
    def sizeOfLinkedFilterSetExcitationFilterList(self) -> int: ...
    def sizeOfLinkedLightPathEmissionFilterList(self) -> int: ...
    def sizeOfLinkedLightPathExcitationFilterList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def unlinkFilterSetEmissionFilter(self, filterSet: 'FilterSet') -> bool: ...
    def unlinkFilterSetExcitationFilter(self, filterSet: 'FilterSet') -> bool: ...
    def unlinkLightPathEmissionFilter(self, lightPath: LightPath) -> bool: ...
    def unlinkLightPathExcitationFilter(self, lightPath: LightPath) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class FilterRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, filterRef: 'FilterRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class FilterSet(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, filterSet: 'FilterSet'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedChannelList(self) -> java.util.List[Channel]: ...
    def copyLinkedEmissionFilterList(self) -> java.util.List[Filter]: ...
    def copyLinkedExcitationFilterList(self) -> java.util.List[Filter]: ...
    def getID(self) -> java.lang.String: ...
    def getInstrument(self) -> Instrument: ...
    def getLinkedChannel(self, int: int) -> Channel: ...
    def getLinkedDichroic(self) -> Dichroic: ...
    def getLinkedEmissionFilter(self, int: int) -> Filter: ...
    def getLinkedExcitationFilter(self, int: int) -> Filter: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkChannel(self, channel: Channel) -> bool: ...
    def linkDichroic(self, dichroic: Dichroic) -> None: ...
    def linkEmissionFilter(self, filter: Filter) -> bool: ...
    def linkExcitationFilter(self, filter: Filter) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setLinkedChannel(self, int: int, channel: Channel) -> Channel: ...
    def setLinkedEmissionFilter(self, int: int, filter: Filter) -> Filter: ...
    def setLinkedExcitationFilter(self, int: int, filter: Filter) -> Filter: ...
    def sizeOfLinkedChannelList(self) -> int: ...
    def sizeOfLinkedEmissionFilterList(self) -> int: ...
    def sizeOfLinkedExcitationFilterList(self) -> int: ...
    def unlinkChannel(self, channel: Channel) -> bool: ...
    def unlinkDichroic(self, dichroic: Dichroic) -> None: ...
    def unlinkEmissionFilter(self, filter: Filter) -> bool: ...
    def unlinkExcitationFilter(self, filter: Filter) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class FilterSetRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, filterSetRef: 'FilterSetRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class FolderRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, folderRef: 'FolderRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ImageRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, imageRef: 'ImageRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class InstrumentRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, instrumentRef: 'InstrumentRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Label(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, label: 'Label'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Leader(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, leader: 'Leader'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedExperimenterGroupList(self) -> java.util.List[ExperimenterGroup]: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedExperimenterGroup(self, int: int) -> ExperimenterGroup: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedExperimenterGroup(self, int: int, experimenterGroup: ExperimenterGroup) -> ExperimenterGroup: ...
    def sizeOfLinkedExperimenterGroupList(self) -> int: ...
    def unlinkExperimenterGroup(self, experimenterGroup: ExperimenterGroup) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class LightSource(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, lightSource: 'LightSource'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getID(self) -> java.lang.String: ...
    def getInstrument(self) -> Instrument: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getPower(self) -> bioformats_jar._ome.units.quantity.Power: ...
    @staticmethod
    def getPowerUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setPower(self, power: bioformats_jar._ome.units.quantity.Power) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Line(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, line: 'Line'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getMarkerEnd(self) -> bioformats_jar._ome.xml.model.enums.Marker: ...
    def getMarkerStart(self) -> bioformats_jar._ome.xml.model.enums.Marker: ...
    def getX1(self) -> float: ...
    def getX2(self) -> float: ...
    def getY1(self) -> float: ...
    def getY2(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setMarkerEnd(self, marker: bioformats_jar._ome.xml.model.enums.Marker) -> None: ...
    def setMarkerStart(self, marker: bioformats_jar._ome.xml.model.enums.Marker) -> None: ...
    def setX1(self, double: float) -> None: ...
    def setX2(self, double: float) -> None: ...
    def setY1(self, double: float) -> None: ...
    def setY2(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ListAnnotation(Annotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, listAnnotation: 'ListAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class MapAnnotation(Annotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, mapAnnotation: 'MapAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> java.util.List[MapPair]: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, list: java.util.List[MapPair]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Mask(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, mask: 'Mask'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getBinData(self) -> BinData: ...
    def getHeight(self) -> float: ...
    def getWidth(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setBinData(self, binData: BinData) -> None: ...
    def setHeight(self, double: float) -> None: ...
    def setWidth(self, double: float) -> None: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class MicrobeamManipulationRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, microbeamManipulationRef: 'MicrobeamManipulationRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Microscope(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, microscope: 'Microscope'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.MicroscopeType: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setType(self, microscopeType: bioformats_jar._ome.xml.model.enums.MicroscopeType) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Objective(ManufacturerSpec):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, objective: 'Objective'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedAnnotationList(self) -> java.util.List[Annotation]: ...
    def getCalibratedMagnification(self) -> float: ...
    def getCorrection(self) -> bioformats_jar._ome.xml.model.enums.Correction: ...
    def getID(self) -> java.lang.String: ...
    def getImmersion(self) -> bioformats_jar._ome.xml.model.enums.Immersion: ...
    def getInstrument(self) -> Instrument: ...
    def getIris(self) -> bool: ...
    def getLensNA(self) -> float: ...
    def getLinkedAnnotation(self, int: int) -> Annotation: ...
    def getNominalMagnification(self) -> float: ...
    def getWorkingDistance(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getWorkingDistanceUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkAnnotation(self, annotation: Annotation) -> bool: ...
    def setCalibratedMagnification(self, double: float) -> None: ...
    def setCorrection(self, correction: bioformats_jar._ome.xml.model.enums.Correction) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setImmersion(self, immersion: bioformats_jar._ome.xml.model.enums.Immersion) -> None: ...
    def setInstrument(self, instrument: Instrument) -> None: ...
    def setIris(self, boolean: bool) -> None: ...
    def setLensNA(self, double: float) -> None: ...
    def setLinkedAnnotation(self, int: int, annotation: Annotation) -> Annotation: ...
    def setNominalMagnification(self, double: float) -> None: ...
    def setWorkingDistance(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def sizeOfLinkedAnnotationList(self) -> int: ...
    def unlinkAnnotation(self, annotation: Annotation) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class PlateRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, plateRef: 'PlateRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Point(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, point: 'Point'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Polygon(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, polygon: 'Polygon'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getPoints(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setPoints(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Polyline(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, polyline: 'Polyline'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getMarkerEnd(self) -> bioformats_jar._ome.xml.model.enums.Marker: ...
    def getMarkerStart(self) -> bioformats_jar._ome.xml.model.enums.Marker: ...
    def getPoints(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setMarkerEnd(self, marker: bioformats_jar._ome.xml.model.enums.Marker) -> None: ...
    def setMarkerStart(self, marker: bioformats_jar._ome.xml.model.enums.Marker) -> None: ...
    def setPoints(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ProjectRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, projectRef: 'ProjectRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Pump(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pump: 'Pump'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def copyLinkedLaserList(self) -> java.util.List['Laser']: ...
    def getID(self) -> java.lang.String: ...
    def getLinkedLaser(self, int: int) -> 'Laser': ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkLaser(self, laser: 'Laser') -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLinkedLaser(self, int: int, laser: 'Laser') -> 'Laser': ...
    def sizeOfLinkedLaserList(self) -> int: ...
    def unlinkLaser(self, laser: 'Laser') -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ROIRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, rOIRef: 'ROIRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ReagentRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, reagentRef: 'ReagentRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Rectangle(Shape):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, rectangle: 'Rectangle'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getHeight(self) -> float: ...
    def getWidth(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setHeight(self, double: float) -> None: ...
    def setWidth(self, double: float) -> None: ...
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Settings(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, settings: 'Settings'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TextAnnotation(Annotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, textAnnotation: 'TextAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TypeAnnotation(Annotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, typeAnnotation: 'TypeAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class WellSampleRef(Reference):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, wellSampleRef: 'WellSampleRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getID(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Arc(LightSource):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arc: 'Arc'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.ArcType: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setType(self, arcType: bioformats_jar._ome.xml.model.enums.ArcType) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class BooleanAnnotation(BasicAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, booleanAnnotation: 'BooleanAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> bool: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, boolean: bool) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class CommentAnnotation(TextAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, commentAnnotation: 'CommentAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class DetectorSettings(Settings):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, detectorSettings: 'DetectorSettings'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getBinning(self) -> bioformats_jar._ome.xml.model.enums.Binning: ...
    def getDetector(self) -> Detector: ...
    def getGain(self) -> float: ...
    def getID(self) -> java.lang.String: ...
    def getIntegration(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getOffset(self) -> float: ...
    def getReadOutRate(self) -> bioformats_jar._ome.units.quantity.Frequency: ...
    @staticmethod
    def getReadOutRateUnitXsdDefault() -> java.lang.String: ...
    def getVoltage(self) -> bioformats_jar._ome.units.quantity.ElectricPotential: ...
    @staticmethod
    def getVoltageUnitXsdDefault() -> java.lang.String: ...
    def getZoom(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setBinning(self, binning: bioformats_jar._ome.xml.model.enums.Binning) -> None: ...
    def setDetector(self, detector: Detector) -> None: ...
    def setGain(self, double: float) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setIntegration(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setOffset(self, double: float) -> None: ...
    def setReadOutRate(self, frequency: bioformats_jar._ome.units.quantity.Frequency) -> None: ...
    def setVoltage(self, electricPotential: bioformats_jar._ome.units.quantity.ElectricPotential) -> None: ...
    def setZoom(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class EmissionFilterRef(FilterRef):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, emissionFilterRef: 'EmissionFilterRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ExcitationFilterRef(FilterRef):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, excitationFilterRef: 'ExcitationFilterRef'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Filament(LightSource):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, filament: 'Filament'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.FilamentType: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setType(self, filamentType: bioformats_jar._ome.xml.model.enums.FilamentType) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class FileAnnotation(TypeAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, fileAnnotation: 'FileAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getBinaryFile(self) -> BinaryFile: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setBinaryFile(self, binaryFile: BinaryFile) -> None: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class GenericExcitationSource(LightSource):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, genericExcitationSource: 'GenericExcitationSource'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getMap(self) -> java.util.List[MapPair]: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setMap(self, list: java.util.List[MapPair]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class Laser(LightSource):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, laser: 'Laser'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getFrequencyMultiplication(self) -> bioformats_jar._ome.xml.model.primitives.PositiveInteger: ...
    def getLaserMedium(self) -> bioformats_jar._ome.xml.model.enums.LaserMedium: ...
    def getLinkedPump(self) -> LightSource: ...
    def getPockelCell(self) -> bool: ...
    def getPulse(self) -> bioformats_jar._ome.xml.model.enums.Pulse: ...
    def getRepetitionRate(self) -> bioformats_jar._ome.units.quantity.Frequency: ...
    @staticmethod
    def getRepetitionRateUnitXsdDefault() -> java.lang.String: ...
    def getTuneable(self) -> bool: ...
    def getType(self) -> bioformats_jar._ome.xml.model.enums.LaserType: ...
    def getWavelength(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getWavelengthUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def linkPump(self, lightSource: LightSource) -> None: ...
    def setFrequencyMultiplication(self, positiveInteger: bioformats_jar._ome.xml.model.primitives.PositiveInteger) -> None: ...
    def setLaserMedium(self, laserMedium: bioformats_jar._ome.xml.model.enums.LaserMedium) -> None: ...
    def setPockelCell(self, boolean: bool) -> None: ...
    def setPulse(self, pulse: bioformats_jar._ome.xml.model.enums.Pulse) -> None: ...
    def setRepetitionRate(self, frequency: bioformats_jar._ome.units.quantity.Frequency) -> None: ...
    def setTuneable(self, boolean: bool) -> None: ...
    def setType(self, laserType: bioformats_jar._ome.xml.model.enums.LaserType) -> None: ...
    def setWavelength(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def unlinkPump(self, lightSource: LightSource) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class LightEmittingDiode(LightSource):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, lightEmittingDiode: 'LightEmittingDiode'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class LightSourceSettings(Settings):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, lightSourceSettings: 'LightSourceSettings'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getAttenuation(self) -> bioformats_jar._ome.xml.model.primitives.PercentFraction: ...
    def getID(self) -> java.lang.String: ...
    def getLightSource(self) -> LightSource: ...
    def getMicrobeamManipulation(self) -> MicrobeamManipulation: ...
    def getWavelength(self) -> bioformats_jar._ome.units.quantity.Length: ...
    @staticmethod
    def getWavelengthUnitXsdDefault() -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setAttenuation(self, percentFraction: bioformats_jar._ome.xml.model.primitives.PercentFraction) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLightSource(self, lightSource: LightSource) -> None: ...
    def setMicrobeamManipulation(self, microbeamManipulation: MicrobeamManipulation) -> None: ...
    def setWavelength(self, length: bioformats_jar._ome.units.quantity.Length) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class NumericAnnotation(BasicAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, numericAnnotation: 'NumericAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class ObjectiveSettings(Settings):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, objectiveSettings: 'ObjectiveSettings'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getCorrectionCollar(self) -> float: ...
    def getID(self) -> java.lang.String: ...
    def getMedium(self) -> bioformats_jar._ome.xml.model.enums.Medium: ...
    def getObjective(self) -> Objective: ...
    def getRefractiveIndex(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setCorrectionCollar(self, double: float) -> None: ...
    def setID(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMedium(self, medium: bioformats_jar._ome.xml.model.enums.Medium) -> None: ...
    def setObjective(self, objective: Objective) -> None: ...
    def setRefractiveIndex(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TagAnnotation(TextAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, tagAnnotation: 'TagAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TermAnnotation(BasicAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, termAnnotation: 'TermAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class TimestampAnnotation(BasicAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, timestampAnnotation: 'TimestampAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> bioformats_jar._ome.xml.model.primitives.Timestamp: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, timestamp: bioformats_jar._ome.xml.model.primitives.Timestamp) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class XMLAnnotation(TextAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, xMLAnnotation: 'XMLAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> java.lang.String: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class DoubleAnnotation(NumericAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, doubleAnnotation: 'DoubleAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> float: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, double: float) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...

class LongAnnotation(NumericAnnotation):
    NAMESPACE: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, longAnnotation: 'LongAnnotation'): ...
    @typing.overload
    def __init__(self, element: org.w3c.dom.Element, oMEModel: OMEModel): ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @typing.overload
    def asXMLElement(self, document: org.w3c.dom.Document, element: org.w3c.dom.Element) -> org.w3c.dom.Element: ...
    def getStructuredAnnotations(self) -> StructuredAnnotations: ...
    def getValue(self) -> int: ...
    def link(self, reference: Reference, oMEModelObject: OMEModelObject) -> bool: ...
    def setStructuredAnnotations(self, structuredAnnotations: StructuredAnnotations) -> None: ...
    def setValue(self, long: int) -> None: ...
    def update(self, element: org.w3c.dom.Element, oMEModel: OMEModel) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("ome.xml.model")``.

    AbstractOMEModelObject: typing.Type[AbstractOMEModelObject]
    AffineTransform: typing.Type[AffineTransform]
    Annotation: typing.Type[Annotation]
    AnnotationRef: typing.Type[AnnotationRef]
    Arc: typing.Type[Arc]
    BasicAnnotation: typing.Type[BasicAnnotation]
    BinData: typing.Type[BinData]
    BinaryFile: typing.Type[BinaryFile]
    BinaryOnly: typing.Type[BinaryOnly]
    BooleanAnnotation: typing.Type[BooleanAnnotation]
    Channel: typing.Type[Channel]
    ChannelRef: typing.Type[ChannelRef]
    CommentAnnotation: typing.Type[CommentAnnotation]
    Dataset: typing.Type[Dataset]
    DatasetRef: typing.Type[DatasetRef]
    Detector: typing.Type[Detector]
    DetectorSettings: typing.Type[DetectorSettings]
    Dichroic: typing.Type[Dichroic]
    DichroicRef: typing.Type[DichroicRef]
    DoubleAnnotation: typing.Type[DoubleAnnotation]
    Ellipse: typing.Type[Ellipse]
    EmissionFilterRef: typing.Type[EmissionFilterRef]
    ExcitationFilterRef: typing.Type[ExcitationFilterRef]
    Experiment: typing.Type[Experiment]
    ExperimentRef: typing.Type[ExperimentRef]
    Experimenter: typing.Type[Experimenter]
    ExperimenterGroup: typing.Type[ExperimenterGroup]
    ExperimenterGroupRef: typing.Type[ExperimenterGroupRef]
    ExperimenterRef: typing.Type[ExperimenterRef]
    External: typing.Type[External]
    Filament: typing.Type[Filament]
    FileAnnotation: typing.Type[FileAnnotation]
    Filter: typing.Type[Filter]
    FilterRef: typing.Type[FilterRef]
    FilterSet: typing.Type[FilterSet]
    FilterSetRef: typing.Type[FilterSetRef]
    Folder: typing.Type[Folder]
    FolderRef: typing.Type[FolderRef]
    GenericExcitationSource: typing.Type[GenericExcitationSource]
    Image: typing.Type[Image]
    ImageRef: typing.Type[ImageRef]
    ImagingEnvironment: typing.Type[ImagingEnvironment]
    Instrument: typing.Type[Instrument]
    InstrumentRef: typing.Type[InstrumentRef]
    Label: typing.Type[Label]
    Laser: typing.Type[Laser]
    Leader: typing.Type[Leader]
    LightEmittingDiode: typing.Type[LightEmittingDiode]
    LightPath: typing.Type[LightPath]
    LightSource: typing.Type[LightSource]
    LightSourceSettings: typing.Type[LightSourceSettings]
    Line: typing.Type[Line]
    ListAnnotation: typing.Type[ListAnnotation]
    LongAnnotation: typing.Type[LongAnnotation]
    ManufacturerSpec: typing.Type[ManufacturerSpec]
    MapAnnotation: typing.Type[MapAnnotation]
    MapPair: typing.Type[MapPair]
    Mask: typing.Type[Mask]
    MetadataOnly: typing.Type[MetadataOnly]
    MicrobeamManipulation: typing.Type[MicrobeamManipulation]
    MicrobeamManipulationRef: typing.Type[MicrobeamManipulationRef]
    Microscope: typing.Type[Microscope]
    NumericAnnotation: typing.Type[NumericAnnotation]
    OME: typing.Type[OME]
    OMEModel: typing.Type[OMEModel]
    OMEModelImpl: typing.Type[OMEModelImpl]
    OMEModelObject: typing.Type[OMEModelObject]
    Objective: typing.Type[Objective]
    ObjectiveSettings: typing.Type[ObjectiveSettings]
    Pixels: typing.Type[Pixels]
    Plane: typing.Type[Plane]
    Plate: typing.Type[Plate]
    PlateAcquisition: typing.Type[PlateAcquisition]
    PlateRef: typing.Type[PlateRef]
    Point: typing.Type[Point]
    Polygon: typing.Type[Polygon]
    Polyline: typing.Type[Polyline]
    Project: typing.Type[Project]
    ProjectRef: typing.Type[ProjectRef]
    Pump: typing.Type[Pump]
    ROI: typing.Type[ROI]
    ROIRef: typing.Type[ROIRef]
    Reagent: typing.Type[Reagent]
    ReagentRef: typing.Type[ReagentRef]
    Rectangle: typing.Type[Rectangle]
    Reference: typing.Type[Reference]
    ReferenceList: typing.Type[ReferenceList]
    Rights: typing.Type[Rights]
    Screen: typing.Type[Screen]
    Settings: typing.Type[Settings]
    Shape: typing.Type[Shape]
    StageLabel: typing.Type[StageLabel]
    StructuredAnnotations: typing.Type[StructuredAnnotations]
    TagAnnotation: typing.Type[TagAnnotation]
    TermAnnotation: typing.Type[TermAnnotation]
    TextAnnotation: typing.Type[TextAnnotation]
    TiffData: typing.Type[TiffData]
    TimestampAnnotation: typing.Type[TimestampAnnotation]
    TransmittanceRange: typing.Type[TransmittanceRange]
    TypeAnnotation: typing.Type[TypeAnnotation]
    UUID: typing.Type[UUID]
    Union: typing.Type[Union]
    Well: typing.Type[Well]
    WellSample: typing.Type[WellSample]
    WellSampleRef: typing.Type[WellSampleRef]
    XMLAnnotation: typing.Type[XMLAnnotation]
    enums: bioformats_jar._ome.xml.model.enums.__module_protocol__
    primitives: bioformats_jar._ome.xml.model.primitives.__module_protocol__
