import java.io
import java.lang
import java.util
import bioformats_jar._loci.poi.ddf
import bioformats_jar._loci.poi.hssf.model
import bioformats_jar._loci.poi.hssf.record.aggregates
import bioformats_jar._loci.poi.hssf.record.formula
import bioformats_jar._loci.poi.hssf.usermodel
import bioformats_jar._loci.poi.util
import typing



class CellValueRecordInterface:
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getRow(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: 'CellValueRecordInterface') -> bool: ...
    def isBefore(self, cellValueRecordInterface: 'CellValueRecordInterface') -> bool: ...
    def isEqual(self, cellValueRecordInterface: 'CellValueRecordInterface') -> bool: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...

class CustomField(java.lang.Cloneable):
    def fillField(self, recordInputStream: 'RecordInputStream') -> int: ...
    def getSize(self) -> int: ...
    def serializeField(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self, stringBuffer: java.lang.StringBuffer) -> None: ...

class Margin:
    def getMargin(self) -> float: ...
    def setMargin(self, double: float) -> None: ...

class Record:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: 'RecordInputStream'): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    def toString(self) -> java.lang.String: ...

class RecordFactory:
    def __init__(self): ...
    @staticmethod
    def createRecord(recordInputStream: 'RecordInputStream') -> typing.List[Record]: ...
    @staticmethod
    def createRecords(inputStream: java.io.InputStream) -> java.util.List: ...
    @staticmethod
    def getAllKnownRecordSIDs() -> typing.List[int]: ...
    @staticmethod
    def setCapacity(int: int) -> None: ...

class RecordFormatException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class RecordInputStream(java.io.InputStream):
    MAX_RECORD_DATA_SIZE: typing.ClassVar[int] = ...
    def __init__(self, inputStream: java.io.InputStream): ...
    def getAutoContinue(self) -> bool: ...
    def getLength(self) -> int: ...
    def getNANData(self) -> typing.List[int]: ...
    def getPos(self) -> int: ...
    def getRecordOffset(self) -> int: ...
    def getSid(self) -> int: ...
    def hasNextRecord(self) -> bool: ...
    def isContinueNext(self) -> bool: ...
    def nextRecord(self) -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    def readAllContinuedRemainder(self) -> typing.List[int]: ...
    def readByte(self) -> int: ...
    def readCompressedUnicode(self, int: int) -> java.lang.String: ...
    def readDouble(self) -> float: ...
    def readInt(self) -> int: ...
    def readLong(self) -> int: ...
    def readRemainder(self) -> typing.List[int]: ...
    def readShort(self) -> int: ...
    def readShortArray(self) -> typing.List[int]: ...
    def readUShort(self) -> int: ...
    def readUnicodeLEString(self, int: int) -> java.lang.String: ...
    def readUnicodeString(self) -> 'UnicodeString': ...
    def remaining(self) -> int: ...
    def setAutoContinue(self, boolean: bool) -> None: ...

class UnicodeString(java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addFormatRun(self, formatRun: 'UnicodeString.FormatRun') -> None: ...
    def clearFormatting(self) -> None: ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def formatIterator(self) -> java.util.Iterator: ...
    def getCharCount(self) -> int: ...
    def getDebugInfo(self) -> java.lang.String: ...
    def getExtendedRst(self) -> typing.List[int]: ...
    def getFormatRun(self, int: int) -> 'UnicodeString.FormatRun': ...
    def getFormatRunCount(self) -> int: ...
    def getOptionFlags(self) -> int: ...
    def getRecordSize(self, unicodeRecordStats: 'UnicodeString.UnicodeRecordStats') -> None: ...
    def getSid(self) -> int: ...
    def getString(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def isExtendedText(self) -> bool: ...
    def isRichText(self) -> bool: ...
    def removeFormatRun(self, formatRun: 'UnicodeString.FormatRun') -> None: ...
    def serialize(self, unicodeRecordStats: 'UnicodeString.UnicodeRecordStats', int: int, byteArray: typing.List[int]) -> int: ...
    def setCharCount(self, short: int) -> None: ...
    def setCompressedUnicode(self) -> None: ...
    def setExtendedRst(self, byteArray: typing.List[int]) -> None: ...
    def setOptionFlags(self, byte: int) -> None: ...
    def setString(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUncompressedUnicode(self) -> None: ...
    def toString(self) -> java.lang.String: ...
    class FormatRun(java.lang.Comparable):
        def __init__(self, short: int, short2: int): ...
        def compareTo(self, object: typing.Any) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
        def getCharacterPos(self) -> int: ...
        def getFontIndex(self) -> int: ...
        def toString(self) -> java.lang.String: ...
    class UnicodeRecordStats:
        recordSize: int = ...
        remainingSize: int = ...
        lastLengthPos: int = ...
        def __init__(self): ...

class AbstractEscherHolderRecord(Record):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def addEscherRecord(self, escherRecord: bioformats_jar._loci.poi.ddf.EscherRecord) -> bool: ...
    @typing.overload
    def addEscherRecord(self, int: int, escherRecord: bioformats_jar._loci.poi.ddf.EscherRecord) -> None: ...
    def clearEscherRecords(self) -> None: ...
    def clone(self) -> typing.Any: ...
    def decode(self) -> None: ...
    def getEscherRecord(self, int: int) -> bioformats_jar._loci.poi.ddf.EscherRecord: ...
    def getEscherRecords(self) -> java.util.List: ...
    def getRawData(self) -> typing.List[int]: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def join(self, abstractEscherHolderRecord: 'AbstractEscherHolderRecord') -> None: ...
    def processContinueRecord(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setRawData(self, byteArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...

class AreaFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBackcolorIndex(self) -> int: ...
    def getBackgroundColor(self) -> int: ...
    def getForecolorIndex(self) -> int: ...
    def getForegroundColor(self) -> int: ...
    def getFormatFlags(self) -> int: ...
    def getPattern(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isAutomatic(self) -> bool: ...
    def isInvert(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutomatic(self, boolean: bool) -> None: ...
    def setBackcolorIndex(self, short: int) -> None: ...
    def setBackgroundColor(self, int: int) -> None: ...
    def setForecolorIndex(self, short: int) -> None: ...
    def setForegroundColor(self, int: int) -> None: ...
    def setFormatFlags(self, short: int) -> None: ...
    def setInvert(self, boolean: bool) -> None: ...
    def setPattern(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class AreaRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormatFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isDisplayAsPercentage(self) -> bool: ...
    def isShadow(self) -> bool: ...
    def isStacked(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setDisplayAsPercentage(self, boolean: bool) -> None: ...
    def setFormatFlags(self, short: int) -> None: ...
    def setShadow(self, boolean: bool) -> None: ...
    def setStacked(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class AxisLineFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    AXIS_TYPE_AXIS_LINE: typing.ClassVar[int] = ...
    AXIS_TYPE_MAJOR_GRID_LINE: typing.ClassVar[int] = ...
    AXIS_TYPE_MINOR_GRID_LINE: typing.ClassVar[int] = ...
    AXIS_TYPE_WALLS_OR_FLOOR: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAxisType(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAxisType(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class AxisOptionsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBaseUnit(self) -> int: ...
    def getCrossingPoint(self) -> int: ...
    def getMajorUnit(self) -> int: ...
    def getMajorUnitValue(self) -> int: ...
    def getMaximumCategory(self) -> int: ...
    def getMinimumCategory(self) -> int: ...
    def getMinorUnit(self) -> int: ...
    def getMinorUnitValue(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isDefaultBase(self) -> bool: ...
    def isDefaultCross(self) -> bool: ...
    def isDefaultDateSettings(self) -> bool: ...
    def isDefaultMajor(self) -> bool: ...
    def isDefaultMaximum(self) -> bool: ...
    def isDefaultMinimum(self) -> bool: ...
    def isDefaultMinorUnit(self) -> bool: ...
    def isIsDate(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBaseUnit(self, short: int) -> None: ...
    def setCrossingPoint(self, short: int) -> None: ...
    def setDefaultBase(self, boolean: bool) -> None: ...
    def setDefaultCross(self, boolean: bool) -> None: ...
    def setDefaultDateSettings(self, boolean: bool) -> None: ...
    def setDefaultMajor(self, boolean: bool) -> None: ...
    def setDefaultMaximum(self, boolean: bool) -> None: ...
    def setDefaultMinimum(self, boolean: bool) -> None: ...
    def setDefaultMinorUnit(self, boolean: bool) -> None: ...
    def setIsDate(self, boolean: bool) -> None: ...
    def setMajorUnit(self, short: int) -> None: ...
    def setMajorUnitValue(self, short: int) -> None: ...
    def setMaximumCategory(self, short: int) -> None: ...
    def setMinimumCategory(self, short: int) -> None: ...
    def setMinorUnit(self, short: int) -> None: ...
    def setMinorUnitValue(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class AxisParentRecord(Record):
    sid: typing.ClassVar[int] = ...
    AXIS_TYPE_MAIN: typing.ClassVar[int] = ...
    AXIS_TYPE_SECONDARY: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAxisType(self) -> int: ...
    def getHeight(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getWidth(self) -> int: ...
    def getX(self) -> int: ...
    def getY(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAxisType(self, short: int) -> None: ...
    def setHeight(self, int: int) -> None: ...
    def setWidth(self, int: int) -> None: ...
    def setX(self, int: int) -> None: ...
    def setY(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class AxisRecord(Record):
    sid: typing.ClassVar[int] = ...
    AXIS_TYPE_CATEGORY_OR_X_AXIS: typing.ClassVar[int] = ...
    AXIS_TYPE_VALUE_AXIS: typing.ClassVar[int] = ...
    AXIS_TYPE_SERIES_AXIS: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAxisType(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getReserved1(self) -> int: ...
    def getReserved2(self) -> int: ...
    def getReserved3(self) -> int: ...
    def getReserved4(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAxisType(self, short: int) -> None: ...
    def setReserved1(self, int: int) -> None: ...
    def setReserved2(self, int: int) -> None: ...
    def setReserved3(self, int: int) -> None: ...
    def setReserved4(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class AxisUsedRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumAxis(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setNumAxis(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BOFRecord(Record):
    sid: typing.ClassVar[int] = ...
    VERSION: typing.ClassVar[int] = ...
    BUILD: typing.ClassVar[int] = ...
    BUILD_YEAR: typing.ClassVar[int] = ...
    HISTORY_MASK: typing.ClassVar[int] = ...
    TYPE_WORKBOOK: typing.ClassVar[int] = ...
    TYPE_VB_MODULE: typing.ClassVar[int] = ...
    TYPE_WORKSHEET: typing.ClassVar[int] = ...
    TYPE_CHART: typing.ClassVar[int] = ...
    TYPE_EXCEL_4_MACRO: typing.ClassVar[int] = ...
    TYPE_WORKSPACE_FILE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBuild(self) -> int: ...
    def getBuildYear(self) -> int: ...
    def getHistoryBitMask(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRequiredVersion(self) -> int: ...
    def getSid(self) -> int: ...
    def getType(self) -> int: ...
    def getVersion(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBuild(self, short: int) -> None: ...
    def setBuildYear(self, short: int) -> None: ...
    def setHistoryBitMask(self, int: int) -> None: ...
    def setRequiredVersion(self, int: int) -> None: ...
    def setType(self, short: int) -> None: ...
    def setVersion(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BackupRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getBackup(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBackup(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BarRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBarSpace(self) -> int: ...
    def getCategorySpace(self) -> int: ...
    def getFormatFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isDisplayAsPercentage(self) -> bool: ...
    def isHorizontal(self) -> bool: ...
    def isShadow(self) -> bool: ...
    def isStacked(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBarSpace(self, short: int) -> None: ...
    def setCategorySpace(self, short: int) -> None: ...
    def setDisplayAsPercentage(self, boolean: bool) -> None: ...
    def setFormatFlags(self, short: int) -> None: ...
    def setHorizontal(self, boolean: bool) -> None: ...
    def setShadow(self, boolean: bool) -> None: ...
    def setStacked(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class BeginRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class BlankRecord(Record, CellValueRecordInterface, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getColumn(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BookBoolRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSaveLinkValues(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setSaveLinkValues(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BoolErrRecord(Record, CellValueRecordInterface, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getBooleanValue(self) -> bool: ...
    def getColumn(self) -> int: ...
    def getErrorValue(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBoolean(self) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isError(self) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setError(self, boolean: bool) -> None: ...
    def setRow(self, int: int) -> None: ...
    @typing.overload
    def setValue(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, byte: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class BottomMarginRecord(Record, Margin):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMargin(self) -> float: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMargin(self, double: float) -> None: ...
    def toString(self) -> java.lang.String: ...

class BoundSheetRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getCompressedUnicodeFlag(self) -> int: ...
    def getOptionFlags(self) -> int: ...
    def getPositionOfBof(self) -> int: ...
    def getRawSheetnameLength(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSheetname(self) -> java.lang.String: ...
    def getSheetnameLength(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCompressedUnicodeFlag(self, byte: int) -> None: ...
    def setOptionFlags(self, short: int) -> None: ...
    def setPositionOfBof(self, int: int) -> None: ...
    def setSheetname(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSheetnameLength(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class CalcCountRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getIterations(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setIterations(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class CalcModeRecord(Record):
    sid: typing.ClassVar[int] = ...
    MANUAL: typing.ClassVar[int] = ...
    AUTOMATIC: typing.ClassVar[int] = ...
    AUTOMATIC_EXCEPT_TABLES: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCalcMode(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCalcMode(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class CategorySeriesAxisRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCrossingPoint(self) -> int: ...
    def getLabelFrequency(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getTickMarkFrequency(self) -> int: ...
    def isCrossesFarRight(self) -> bool: ...
    def isReversed(self) -> bool: ...
    def isValueAxisCrossing(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCrossesFarRight(self, boolean: bool) -> None: ...
    def setCrossingPoint(self, short: int) -> None: ...
    def setLabelFrequency(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setReversed(self, boolean: bool) -> None: ...
    def setTickMarkFrequency(self, short: int) -> None: ...
    def setValueAxisCrossing(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class ChartFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getHeight(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getVaryDisplayPattern(self) -> bool: ...
    def getWidth(self) -> int: ...
    def getXPosition(self) -> int: ...
    def getYPosition(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHeight(self, int: int) -> None: ...
    def setVaryDisplayPattern(self, boolean: bool) -> None: ...
    def setWidth(self, int: int) -> None: ...
    def setXPosition(self, int: int) -> None: ...
    def setYPosition(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ChartRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getHeight(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getWidth(self) -> int: ...
    def getX(self) -> int: ...
    def getY(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHeight(self, int: int) -> None: ...
    def setWidth(self, int: int) -> None: ...
    def setX(self, int: int) -> None: ...
    def setY(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class CodepageRecord(Record):
    sid: typing.ClassVar[int] = ...
    CODEPAGE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getCodepage(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCodepage(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ColumnInfoRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCollapsed(self) -> bool: ...
    def getColumnWidth(self) -> int: ...
    def getFirstColumn(self) -> int: ...
    def getHidden(self) -> bool: ...
    def getLastColumn(self) -> int: ...
    def getOptions(self) -> int: ...
    def getOutlineLevel(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCollapsed(self, boolean: bool) -> None: ...
    def setColumnWidth(self, short: int) -> None: ...
    def setFirstColumn(self, short: int) -> None: ...
    def setHidden(self, boolean: bool) -> None: ...
    def setLastColumn(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setOutlineLevel(self, short: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ContinueRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getData(self) -> typing.List[int]: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setData(self, byteArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...

class CountryRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getCurrentCountry(self) -> int: ...
    def getDefaultCountry(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCurrentCountry(self, short: int) -> None: ...
    def setDefaultCountry(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DBCellRecord(Record):
    BLOCK_SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addCellOffset(self, short: int) -> None: ...
    def getCellOffsetAt(self, int: int) -> int: ...
    def getNumCellOffsets(self) -> int: ...
    def getRecordSize(self) -> int: ...
    @staticmethod
    def getRecordSizeForRows(int: int) -> int: ...
    def getRowOffset(self) -> int: ...
    def getSid(self) -> int: ...
    def isInValueSection(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setRowOffset(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DSFRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getDsf(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setDsf(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DatRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isBorder(self) -> bool: ...
    def isHorizontalBorder(self) -> bool: ...
    def isShowSeriesKey(self) -> bool: ...
    def isVerticalBorder(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBorder(self, boolean: bool) -> None: ...
    def setHorizontalBorder(self, boolean: bool) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setShowSeriesKey(self, boolean: bool) -> None: ...
    def setVerticalBorder(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class DataFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormatFlags(self) -> int: ...
    def getPointNumber(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSeriesIndex(self) -> int: ...
    def getSeriesNumber(self) -> int: ...
    def getSid(self) -> int: ...
    def isUseExcel4Colors(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormatFlags(self, short: int) -> None: ...
    def setPointNumber(self, short: int) -> None: ...
    def setSeriesIndex(self, short: int) -> None: ...
    def setSeriesNumber(self, short: int) -> None: ...
    def setUseExcel4Colors(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class DateWindow1904Record(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getWindowing(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setWindowing(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DefaultColWidthRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColWidth(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColWidth(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DefaultDataLabelTextPropertiesRecord(Record):
    sid: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_SHOW_LABELS_CHARACTERISTIC: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_VALUE_AND_PERCENTAGE_CHARACTERISTIC: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_ALL_TEXT_CHARACTERISTIC: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCategoryDataType(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCategoryDataType(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DefaultRowHeightRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getOptionFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRowHeight(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setOptionFlags(self, short: int) -> None: ...
    def setRowHeight(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DeltaRecord(Record):
    sid: typing.ClassVar[int] = ...
    DEFAULT_VALUE: typing.ClassVar[float] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMaxChange(self) -> float: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMaxChange(self, double: float) -> None: ...
    def toString(self) -> java.lang.String: ...

class DimensionsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFirstCol(self) -> int: ...
    def getFirstRow(self) -> int: ...
    def getLastCol(self) -> int: ...
    def getLastRow(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFirstCol(self, short: int) -> None: ...
    def setFirstRow(self, int: int) -> None: ...
    def setLastCol(self, short: int) -> None: ...
    def setLastRow(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DrawingRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getData(self) -> typing.List[int]: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def processContinueRecord(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setData(self, byteArray: typing.List[int]) -> None: ...

class EOFRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class EndRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class ExtSSTInfoSubRecord(Record):
    INFO_SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getBucketSSTOffset(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getStreamPos(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBucketRecordOffset(self, short: int) -> None: ...
    def setStreamPos(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ExtSSTRecord(Record):
    DEFAULT_BUCKET_SIZE: typing.ClassVar[int] = ...
    MAX_BUCKETS: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addInfoRecord(self, extSSTInfoSubRecord: ExtSSTInfoSubRecord) -> None: ...
    def getInfoRecordAt(self, int: int) -> ExtSSTInfoSubRecord: ...
    def getNumInfoRecords(self) -> int: ...
    def getNumStringsPerBucket(self) -> int: ...
    @staticmethod
    def getNumberOfInfoRecsForStrings(int: int) -> int: ...
    def getRecordSize(self) -> int: ...
    @staticmethod
    def getRecordSizeForStrings(int: int) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBucketOffsets(self, intArray: typing.List[int], intArray2: typing.List[int]) -> None: ...
    def setNumStringsPerBucket(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ExtendedFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    NULL: typing.ClassVar[int] = ...
    XF_STYLE: typing.ClassVar[int] = ...
    XF_CELL: typing.ClassVar[int] = ...
    NONE: typing.ClassVar[int] = ...
    THIN: typing.ClassVar[int] = ...
    MEDIUM: typing.ClassVar[int] = ...
    DASHED: typing.ClassVar[int] = ...
    DOTTED: typing.ClassVar[int] = ...
    THICK: typing.ClassVar[int] = ...
    DOUBLE: typing.ClassVar[int] = ...
    HAIR: typing.ClassVar[int] = ...
    MEDIUM_DASHED: typing.ClassVar[int] = ...
    DASH_DOT: typing.ClassVar[int] = ...
    MEDIUM_DASH_DOT: typing.ClassVar[int] = ...
    DASH_DOT_DOT: typing.ClassVar[int] = ...
    MEDIUM_DASH_DOT_DOT: typing.ClassVar[int] = ...
    SLANTED_DASH_DOT: typing.ClassVar[int] = ...
    GENERAL: typing.ClassVar[int] = ...
    LEFT: typing.ClassVar[int] = ...
    CENTER: typing.ClassVar[int] = ...
    RIGHT: typing.ClassVar[int] = ...
    FILL: typing.ClassVar[int] = ...
    JUSTIFY: typing.ClassVar[int] = ...
    CENTER_SELECTION: typing.ClassVar[int] = ...
    VERTICAL_TOP: typing.ClassVar[int] = ...
    VERTICAL_CENTER: typing.ClassVar[int] = ...
    VERTICAL_BOTTOM: typing.ClassVar[int] = ...
    VERTICAL_JUSTIFY: typing.ClassVar[int] = ...
    NO_FILL: typing.ClassVar[int] = ...
    SOLID_FILL: typing.ClassVar[int] = ...
    FINE_DOTS: typing.ClassVar[int] = ...
    ALT_BARS: typing.ClassVar[int] = ...
    SPARSE_DOTS: typing.ClassVar[int] = ...
    THICK_HORZ_BANDS: typing.ClassVar[int] = ...
    THICK_VERT_BANDS: typing.ClassVar[int] = ...
    THICK_BACKWARD_DIAG: typing.ClassVar[int] = ...
    THICK_FORWARD_DIAG: typing.ClassVar[int] = ...
    BIG_SPOTS: typing.ClassVar[int] = ...
    BRICKS: typing.ClassVar[int] = ...
    THIN_HORZ_BANDS: typing.ClassVar[int] = ...
    THIN_VERT_BANDS: typing.ClassVar[int] = ...
    THIN_BACKWARD_DIAG: typing.ClassVar[int] = ...
    THIN_FORWARD_DIAG: typing.ClassVar[int] = ...
    SQUARES: typing.ClassVar[int] = ...
    DIAMONDS: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def get123Prefix(self) -> bool: ...
    def getAdtlDiag(self) -> int: ...
    def getAdtlDiagLineStyle(self) -> int: ...
    def getAdtlFillPattern(self) -> int: ...
    def getAdtlPaletteOptions(self) -> int: ...
    def getAlignment(self) -> int: ...
    def getAlignmentOptions(self) -> int: ...
    def getBorderBottom(self) -> int: ...
    def getBorderLeft(self) -> int: ...
    def getBorderOptions(self) -> int: ...
    def getBorderRight(self) -> int: ...
    def getBorderTop(self) -> int: ...
    def getBottomBorderPaletteIdx(self) -> int: ...
    def getCellOptions(self) -> int: ...
    def getDiag(self) -> int: ...
    def getFillBackground(self) -> int: ...
    def getFillForeground(self) -> int: ...
    def getFillPaletteOptions(self) -> int: ...
    def getFontIndex(self) -> int: ...
    def getFormatIndex(self) -> int: ...
    def getIndent(self) -> int: ...
    def getIndentionOptions(self) -> int: ...
    def getJustifyLast(self) -> int: ...
    def getLeftBorderPaletteIdx(self) -> int: ...
    def getMergeCells(self) -> bool: ...
    def getPaletteOptions(self) -> int: ...
    def getParentIndex(self) -> int: ...
    def getReadingOrder(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRightBorderPaletteIdx(self) -> int: ...
    def getRotation(self) -> int: ...
    def getShrinkToFit(self) -> bool: ...
    def getSid(self) -> int: ...
    def getTopBorderPaletteIdx(self) -> int: ...
    def getVerticalAlignment(self) -> int: ...
    def getWrapText(self) -> bool: ...
    def getXFType(self) -> int: ...
    def isHidden(self) -> bool: ...
    def isIndentNotParentAlignment(self) -> bool: ...
    def isIndentNotParentBorder(self) -> bool: ...
    def isIndentNotParentCellOptions(self) -> bool: ...
    def isIndentNotParentFont(self) -> bool: ...
    def isIndentNotParentFormat(self) -> bool: ...
    def isIndentNotParentPattern(self) -> bool: ...
    def isLocked(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def set123Prefix(self, boolean: bool) -> None: ...
    def setAdtlDiag(self, short: int) -> None: ...
    def setAdtlDiagLineStyle(self, short: int) -> None: ...
    def setAdtlFillPattern(self, short: int) -> None: ...
    def setAdtlPaletteOptions(self, short: int) -> None: ...
    def setAlignment(self, short: int) -> None: ...
    def setAlignmentOptions(self, short: int) -> None: ...
    def setBorderBottom(self, short: int) -> None: ...
    def setBorderLeft(self, short: int) -> None: ...
    def setBorderOptions(self, short: int) -> None: ...
    def setBorderRight(self, short: int) -> None: ...
    def setBorderTop(self, short: int) -> None: ...
    def setBottomBorderPaletteIdx(self, short: int) -> None: ...
    def setCellOptions(self, short: int) -> None: ...
    def setDiag(self, short: int) -> None: ...
    def setFillBackground(self, short: int) -> None: ...
    def setFillForeground(self, short: int) -> None: ...
    def setFillPaletteOptions(self, short: int) -> None: ...
    def setFontIndex(self, short: int) -> None: ...
    def setFormatIndex(self, short: int) -> None: ...
    def setHidden(self, boolean: bool) -> None: ...
    def setIndent(self, short: int) -> None: ...
    def setIndentNotParentAlignment(self, boolean: bool) -> None: ...
    def setIndentNotParentBorder(self, boolean: bool) -> None: ...
    def setIndentNotParentCellOptions(self, boolean: bool) -> None: ...
    def setIndentNotParentFont(self, boolean: bool) -> None: ...
    def setIndentNotParentFormat(self, boolean: bool) -> None: ...
    def setIndentNotParentPattern(self, boolean: bool) -> None: ...
    def setIndentionOptions(self, short: int) -> None: ...
    def setJustifyLast(self, short: int) -> None: ...
    def setLeftBorderPaletteIdx(self, short: int) -> None: ...
    def setLocked(self, boolean: bool) -> None: ...
    def setMergeCells(self, boolean: bool) -> None: ...
    def setPaletteOptions(self, short: int) -> None: ...
    def setParentIndex(self, short: int) -> None: ...
    def setReadingOrder(self, short: int) -> None: ...
    def setRightBorderPaletteIdx(self, short: int) -> None: ...
    def setRotation(self, short: int) -> None: ...
    def setShrinkToFit(self, boolean: bool) -> None: ...
    def setTopBorderPaletteIdx(self, short: int) -> None: ...
    def setVerticalAlignment(self, short: int) -> None: ...
    def setWrapText(self, boolean: bool) -> None: ...
    def setXFType(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ExternSheetRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addREFRecord(self, externSheetSubRecord: 'ExternSheetSubRecord') -> None: ...
    def getNumOfREFRecords(self) -> int: ...
    def getNumOfREFStructures(self) -> int: ...
    def getREFRecordAt(self, int: int) -> 'ExternSheetSubRecord': ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setNumOfREFStructures(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ExternSheetSubRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getIndexToFirstSupBook(self) -> int: ...
    def getIndexToLastSupBook(self) -> int: ...
    def getIndexToSupBook(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setIndexToFirstSupBook(self, short: int) -> None: ...
    def setIndexToLastSupBook(self, short: int) -> None: ...
    def setIndexToSupBook(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FilePassRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class FileSharingRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getPassword(self) -> int: ...
    def getReadOnly(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getUnknown(self) -> int: ...
    def getUsername(self) -> java.lang.String: ...
    def getUsernameLength(self) -> int: ...
    @staticmethod
    def hashPassword(string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPassword(self, short: int) -> None: ...
    def setReadOnly(self, short: int) -> None: ...
    def setUnknown(self, short: int) -> None: ...
    def setUsername(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUsernameLength(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FnGroupCountRecord(Record):
    sid: typing.ClassVar[int] = ...
    COUNT: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getCount(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCount(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FontBasisRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getHeightBasis(self) -> int: ...
    def getIndexToFontTable(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getScale(self) -> int: ...
    def getSid(self) -> int: ...
    def getXBasis(self) -> int: ...
    def getYBasis(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHeightBasis(self, short: int) -> None: ...
    def setIndexToFontTable(self, short: int) -> None: ...
    def setScale(self, short: int) -> None: ...
    def setXBasis(self, short: int) -> None: ...
    def setYBasis(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FontIndexRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFontIndex(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFontIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FontRecord(Record):
    sid: typing.ClassVar[int] = ...
    SS_NONE: typing.ClassVar[int] = ...
    SS_SUPER: typing.ClassVar[int] = ...
    SS_SUB: typing.ClassVar[int] = ...
    U_NONE: typing.ClassVar[int] = ...
    U_SINGLE: typing.ClassVar[int] = ...
    U_DOUBLE: typing.ClassVar[int] = ...
    U_SINGLE_ACCOUNTING: typing.ClassVar[int] = ...
    U_DOUBLE_ACCOUNTING: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getAttributes(self) -> int: ...
    def getBoldWeight(self) -> int: ...
    def getCharset(self) -> int: ...
    def getColorPaletteIndex(self) -> int: ...
    def getFamily(self) -> int: ...
    def getFontHeight(self) -> int: ...
    def getFontName(self) -> java.lang.String: ...
    def getFontNameLength(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getSuperSubScript(self) -> int: ...
    def getUnderline(self) -> int: ...
    def isItalic(self) -> bool: ...
    def isMacoutlined(self) -> bool: ...
    def isMacshadowed(self) -> bool: ...
    def isStruckout(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAttributes(self, short: int) -> None: ...
    def setBoldWeight(self, short: int) -> None: ...
    def setCharset(self, byte: int) -> None: ...
    def setColorPaletteIndex(self, short: int) -> None: ...
    def setFamily(self, byte: int) -> None: ...
    def setFontHeight(self, short: int) -> None: ...
    def setFontName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFontNameLength(self, byte: int) -> None: ...
    def setItalic(self, boolean: bool) -> None: ...
    def setMacoutline(self, boolean: bool) -> None: ...
    def setMacshadow(self, boolean: bool) -> None: ...
    def setStrikeout(self, boolean: bool) -> None: ...
    def setSuperSubScript(self, short: int) -> None: ...
    def setUnderline(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FooterRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFooter(self) -> java.lang.String: ...
    def getFooterLength(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isMultibyte(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFooter(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFooterLength(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFormatString(self) -> java.lang.String: ...
    def getIndexCode(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getUnicodeFlag(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormatString(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFormatStringLength(self, byte: int) -> None: ...
    def setIndexCode(self, short: int) -> None: ...
    def setUnicodeFlag(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class FormulaRecord(Record, CellValueRecordInterface, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getColumn(self) -> int: ...
    def getExpressionLength(self) -> int: ...
    def getNumberOfExpressionTokens(self) -> int: ...
    def getOptions(self) -> int: ...
    def getParsedExpression(self) -> java.util.List: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getValue(self) -> float: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isSharedFormula(self) -> bool: ...
    def isValue(self) -> bool: ...
    def peekExpressionToken(self) -> bioformats_jar._loci.poi.hssf.record.formula.Ptg: ...
    def popExpressionToken(self) -> bioformats_jar._loci.poi.hssf.record.formula.Ptg: ...
    def pushExpressionToken(self, ptg: bioformats_jar._loci.poi.hssf.record.formula.Ptg) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setExpressionLength(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setParsedExpression(self, stack: java.util.Stack) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setSharedFormula(self, boolean: bool) -> None: ...
    def setValue(self, double: float) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class FrameRecord(Record):
    sid: typing.ClassVar[int] = ...
    BORDER_TYPE_REGULAR: typing.ClassVar[int] = ...
    BORDER_TYPE_SHADOW: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBorderType(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isAutoPosition(self) -> bool: ...
    def isAutoSize(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutoPosition(self, boolean: bool) -> None: ...
    def setAutoSize(self, boolean: bool) -> None: ...
    def setBorderType(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class GridsetRecord(Record):
    sid: typing.ClassVar[int] = ...
    field_1_gridset_flag: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getGridset(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setGridset(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class GutsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColLevelMax(self) -> int: ...
    def getLeftRowGutter(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRowLevelMax(self) -> int: ...
    def getSid(self) -> int: ...
    def getTopColGutter(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColLevelMax(self, short: int) -> None: ...
    def setLeftRowGutter(self, short: int) -> None: ...
    def setRowLevelMax(self, short: int) -> None: ...
    def setTopColGutter(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class HCenterRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getHCenter(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHCenter(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class HeaderRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getHeader(self) -> java.lang.String: ...
    def getHeaderLength(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isMultibyte(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHeader(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHeaderLength(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class HideObjRecord(Record):
    sid: typing.ClassVar[int] = ...
    HIDE_ALL: typing.ClassVar[int] = ...
    SHOW_PLACEHOLDERS: typing.ClassVar[int] = ...
    SHOW_ALL: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getHideObj(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHideObj(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class IndexRecord(Record):
    sid: typing.ClassVar[int] = ...
    DBCELL_CAPACITY: typing.ClassVar[int] = ...
    field_1_zero: int = ...
    field_2_first_row: int = ...
    field_3_last_row_add1: int = ...
    field_4_zero: int = ...
    field_5_dbcells: bioformats_jar._loci.poi.util.IntList = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addDbcell(self, int: int) -> None: ...
    def clone(self) -> typing.Any: ...
    def getDbcellAt(self, int: int) -> int: ...
    def getFirstRow(self) -> int: ...
    def getLastRowAdd1(self) -> int: ...
    def getNumDbcells(self) -> int: ...
    def getRecordSize(self) -> int: ...
    @staticmethod
    def getRecordSizeForBlockCount(int: int) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setDbcell(self, int: int, int2: int) -> None: ...
    def setFirstRow(self, int: int) -> None: ...
    def setLastRowAdd1(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class InterfaceEndRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class InterfaceHdrRecord(Record):
    sid: typing.ClassVar[int] = ...
    CODEPAGE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getCodepage(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCodepage(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class IterationRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getIteration(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setIteration(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class LabelRecord(Record, CellValueRecordInterface):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getStringLength(self) -> int: ...
    def getValue(self) -> java.lang.String: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isUnCompressedUnicode(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class LabelSSTRecord(Record, CellValueRecordInterface, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getColumn(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getSSTIndex(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setSSTIndex(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class LeftMarginRecord(Record, Margin):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMargin(self) -> float: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMargin(self, double: float) -> None: ...
    def toString(self) -> java.lang.String: ...

class LegendRecord(Record):
    sid: typing.ClassVar[int] = ...
    TYPE_BOTTOM: typing.ClassVar[int] = ...
    TYPE_CORNER: typing.ClassVar[int] = ...
    TYPE_TOP: typing.ClassVar[int] = ...
    TYPE_RIGHT: typing.ClassVar[int] = ...
    TYPE_LEFT: typing.ClassVar[int] = ...
    TYPE_UNDOCKED: typing.ClassVar[int] = ...
    SPACING_CLOSE: typing.ClassVar[int] = ...
    SPACING_MEDIUM: typing.ClassVar[int] = ...
    SPACING_OPEN: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getSpacing(self) -> int: ...
    def getType(self) -> int: ...
    def getXAxisUpperLeft(self) -> int: ...
    def getXSize(self) -> int: ...
    def getYAxisUpperLeft(self) -> int: ...
    def getYSize(self) -> int: ...
    def isAutoPosition(self) -> bool: ...
    def isAutoSeries(self) -> bool: ...
    def isAutoXPositioning(self) -> bool: ...
    def isAutoYPositioning(self) -> bool: ...
    def isDataTable(self) -> bool: ...
    def isVertical(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutoPosition(self, boolean: bool) -> None: ...
    def setAutoSeries(self, boolean: bool) -> None: ...
    def setAutoXPositioning(self, boolean: bool) -> None: ...
    def setAutoYPositioning(self, boolean: bool) -> None: ...
    def setDataTable(self, boolean: bool) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setSpacing(self, byte: int) -> None: ...
    def setType(self, byte: int) -> None: ...
    def setVertical(self, boolean: bool) -> None: ...
    def setXAxisUpperLeft(self, int: int) -> None: ...
    def setXSize(self, int: int) -> None: ...
    def setYAxisUpperLeft(self, int: int) -> None: ...
    def setYSize(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class LineFormatRecord(Record):
    sid: typing.ClassVar[int] = ...
    LINE_PATTERN_SOLID: typing.ClassVar[int] = ...
    LINE_PATTERN_DASH: typing.ClassVar[int] = ...
    LINE_PATTERN_DOT: typing.ClassVar[int] = ...
    LINE_PATTERN_DASH_DOT: typing.ClassVar[int] = ...
    LINE_PATTERN_DASH_DOT_DOT: typing.ClassVar[int] = ...
    LINE_PATTERN_NONE: typing.ClassVar[int] = ...
    LINE_PATTERN_DARK_GRAY_PATTERN: typing.ClassVar[int] = ...
    LINE_PATTERN_MEDIUM_GRAY_PATTERN: typing.ClassVar[int] = ...
    LINE_PATTERN_LIGHT_GRAY_PATTERN: typing.ClassVar[int] = ...
    WEIGHT_HAIRLINE: typing.ClassVar[int] = ...
    WEIGHT_NARROW: typing.ClassVar[int] = ...
    WEIGHT_MEDIUM: typing.ClassVar[int] = ...
    WEIGHT_WIDE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColourPaletteIndex(self) -> int: ...
    def getFormat(self) -> int: ...
    def getLineColor(self) -> int: ...
    def getLinePattern(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getWeight(self) -> int: ...
    def isAuto(self) -> bool: ...
    def isDrawTicks(self) -> bool: ...
    def isUnknown(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAuto(self, boolean: bool) -> None: ...
    def setColourPaletteIndex(self, short: int) -> None: ...
    def setDrawTicks(self, boolean: bool) -> None: ...
    def setFormat(self, short: int) -> None: ...
    def setLineColor(self, int: int) -> None: ...
    def setLinePattern(self, short: int) -> None: ...
    def setUnknown(self, boolean: bool) -> None: ...
    def setWeight(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class LinkedDataFormulaField(CustomField):
    def __init__(self): ...
    def clone(self) -> typing.Any: ...
    def fillField(self, recordInputStream: RecordInputStream) -> int: ...
    def getFormulaTokens(self) -> java.util.Stack: ...
    def getSize(self) -> int: ...
    def serializeField(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormulaTokens(self, stack: java.util.Stack) -> None: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self, stringBuffer: java.lang.StringBuffer) -> None: ...

class LinkedDataRecord(Record):
    sid: typing.ClassVar[int] = ...
    LINK_TYPE_TITLE_OR_TEXT: typing.ClassVar[int] = ...
    LINK_TYPE_VALUES: typing.ClassVar[int] = ...
    LINK_TYPE_CATEGORIES: typing.ClassVar[int] = ...
    REFERENCE_TYPE_DEFAULT_CATEGORIES: typing.ClassVar[int] = ...
    REFERENCE_TYPE_DIRECT: typing.ClassVar[int] = ...
    REFERENCE_TYPE_WORKSHEET: typing.ClassVar[int] = ...
    REFERENCE_TYPE_NOT_USED: typing.ClassVar[int] = ...
    REFERENCE_TYPE_ERROR_REPORTED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormulaOfLink(self) -> LinkedDataFormulaField: ...
    def getIndexNumberFmtRecord(self) -> int: ...
    def getLinkType(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getReferenceType(self) -> int: ...
    def getSid(self) -> int: ...
    def isCustomNumberFormat(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCustomNumberFormat(self, boolean: bool) -> None: ...
    def setFormulaOfLink(self, linkedDataFormulaField: LinkedDataFormulaField) -> None: ...
    def setIndexNumberFmtRecord(self, short: int) -> None: ...
    def setLinkType(self, byte: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setReferenceType(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class MMSRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getAddMenuCount(self) -> int: ...
    def getDelMenuCount(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAddMenuCount(self, byte: int) -> None: ...
    def setDelMenuCount(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class MergeCellsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addArea(self, int: int, short: int, int2: int, short2: int) -> int: ...
    def clone(self) -> typing.Any: ...
    def getAreaAt(self, int: int) -> 'MergeCellsRecord.MergedRegion': ...
    def getNumAreas(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def removeAreaAt(self, int: int) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setNumAreas(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...
    class MergedRegion:
        row_from: int = ...
        row_to: int = ...
        col_from: int = ...
        col_to: int = ...
        def __init__(self, mergeCellsRecord: 'MergeCellsRecord', int: int, int2: int, short: int, short2: int): ...

class MulBlankRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFirstColumn(self) -> int: ...
    def getLastColumn(self) -> int: ...
    def getNumColumns(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFAt(self, int: int) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class MulRKRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFirstColumn(self) -> int: ...
    def getLastColumn(self) -> int: ...
    def getNumColumns(self) -> int: ...
    def getRKNumberAt(self, int: int) -> float: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFAt(self, int: int) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class NameRecord(Record):
    sid: typing.ClassVar[int] = ...
    BUILTIN_CONSOLIDATE_AREA: typing.ClassVar[int] = ...
    BUILTIN_AUTO_OPEN: typing.ClassVar[int] = ...
    BUILTIN_AUTO_CLOSE: typing.ClassVar[int] = ...
    BUILTIN_DATABASE: typing.ClassVar[int] = ...
    BUILTIN_CRITERIA: typing.ClassVar[int] = ...
    BUILTIN_PRINT_AREA: typing.ClassVar[int] = ...
    BUILTIN_PRINT_TITLE: typing.ClassVar[int] = ...
    BUILTIN_RECORDER: typing.ClassVar[int] = ...
    BUILTIN_DATA_FORM: typing.ClassVar[int] = ...
    BUILTIN_AUTO_ACTIVATE: typing.ClassVar[int] = ...
    BUILTIN_AUTO_DEACTIVATE: typing.ClassVar[int] = ...
    BUILTIN_SHEET_TITLE: typing.ClassVar[int] = ...
    OPT_HIDDEN_NAME: typing.ClassVar[int] = ...
    OPT_FUNCTION_NAME: typing.ClassVar[int] = ...
    OPT_COMMAND_NAME: typing.ClassVar[int] = ...
    OPT_MACRO: typing.ClassVar[int] = ...
    OPT_COMPLEX: typing.ClassVar[int] = ...
    OPT_BUILTIN: typing.ClassVar[int] = ...
    OPT_BINDATA: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, byte: int, short: int): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getAreaReference(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def getBuiltInName(self) -> int: ...
    def getCompressedUnicodeFlag(self) -> int: ...
    def getCustomMenuLength(self) -> int: ...
    def getCustomMenuText(self) -> java.lang.String: ...
    def getDefinitionLength(self) -> int: ...
    def getDescriptionText(self) -> java.lang.String: ...
    def getDescriptionTextLength(self) -> int: ...
    def getEqualsToIndexToSheet(self) -> int: ...
    def getExternSheetNumber(self) -> int: ...
    def getFnGroup(self) -> int: ...
    def getHelpTopicLength(self) -> int: ...
    def getHelpTopicText(self) -> java.lang.String: ...
    def getIndexToSheet(self) -> int: ...
    def getKeyboardShortcut(self) -> int: ...
    def getNameDefinition(self) -> java.util.List: ...
    def getNameText(self) -> java.lang.String: ...
    def getNameTextLength(self) -> int: ...
    def getOptionFlag(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getStatusBarLength(self) -> int: ...
    def getStatusBarText(self) -> java.lang.String: ...
    def getTextsLength(self) -> int: ...
    def getUnused(self) -> int: ...
    def isBuiltInName(self) -> bool: ...
    def isCommandName(self) -> bool: ...
    def isComplexFunction(self) -> bool: ...
    def isFunctionName(self) -> bool: ...
    def isHiddenName(self) -> bool: ...
    def isMacro(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAreaReference(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCompressedUnicodeFlag(self, byte: int) -> None: ...
    def setCustomMenuLength(self, byte: int) -> None: ...
    def setCustomMenuText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDefinitionTextLength(self, short: int) -> None: ...
    def setDescriptionText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDescriptionTextLength(self, byte: int) -> None: ...
    def setEqualsToIndexToSheet(self, short: int) -> None: ...
    def setExternSheetNumber(self, short: int) -> None: ...
    def setHelpTopicLength(self, byte: int) -> None: ...
    def setHelpTopicText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setKeyboardShortcut(self, byte: int) -> None: ...
    def setNameDefinition(self, stack: java.util.Stack) -> None: ...
    def setNameText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNameTextLength(self, byte: int) -> None: ...
    def setOptionFlag(self, short: int) -> None: ...
    def setStatusBarLength(self, byte: int) -> None: ...
    def setStatusBarText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUnused(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class NoteRecord(Record):
    sid: typing.ClassVar[int] = ...
    NOTE_HIDDEN: typing.ClassVar[int] = ...
    NOTE_VISIBLE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getAuthor(self) -> java.lang.String: ...
    def getColumn(self) -> int: ...
    def getFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getShapeId(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAuthor(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setColumn(self, short: int) -> None: ...
    def setFlags(self, short: int) -> None: ...
    def setRow(self, short: int) -> None: ...
    def setShapeId(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class NumberFormatIndexRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormatIndex(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormatIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class NumberRecord(Record, CellValueRecordInterface, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getColumn(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getValue(self) -> float: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setValue(self, double: float) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ObjRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def addSubRecord(self, object: typing.Any) -> bool: ...
    @typing.overload
    def addSubRecord(self, int: int, object: typing.Any) -> None: ...
    def clearSubRecords(self) -> None: ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getSubRecords(self) -> java.util.List: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class ObjectLinkRecord(Record):
    sid: typing.ClassVar[int] = ...
    ANCHOR_ID_CHART_TITLE: typing.ClassVar[int] = ...
    ANCHOR_ID_Y_AXIS: typing.ClassVar[int] = ...
    ANCHOR_ID_X_AXIS: typing.ClassVar[int] = ...
    ANCHOR_ID_SERIES_OR_POINT: typing.ClassVar[int] = ...
    ANCHOR_ID_Z_AXIS: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAnchorId(self) -> int: ...
    def getLink1(self) -> int: ...
    def getLink2(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAnchorId(self, short: int) -> None: ...
    def setLink1(self, short: int) -> None: ...
    def setLink2(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class ObjectProtectRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getProtect(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setProtect(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class PageBreakRecord(Record):
    HORIZONTAL_SID: typing.ClassVar[int] = ...
    VERTICAL_SID: typing.ClassVar[int] = ...
    sid: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int): ...
    def addBreak(self, short: int, short2: int, short3: int) -> None: ...
    def clone(self) -> typing.Any: ...
    def getBreak(self, short: int) -> 'PageBreakRecord.Break': ...
    def getBreaksIterator(self) -> java.util.Iterator: ...
    def getNumBreaks(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def removeBreak(self, short: int) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setNumBreaks(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...
    class Break:
        main: int = ...
        subFrom: int = ...
        subTo: int = ...
        def __init__(self, pageBreakRecord: 'PageBreakRecord', short: int, short2: int, short3: int): ...

class PaletteRecord(Record):
    sid: typing.ClassVar[int] = ...
    STANDARD_PALETTE_SIZE: typing.ClassVar[int] = ...
    FIRST_COLOR_INDEX: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getColor(self, short: int) -> typing.List[int]: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColor(self, short: int, byte: int, byte2: int, byte3: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class PaneRecord(Record):
    sid: typing.ClassVar[int] = ...
    ACTIVE_PANE_LOWER_RIGHT: typing.ClassVar[int] = ...
    ACTIVE_PANE_UPPER_RIGHT: typing.ClassVar[int] = ...
    ACTIVE_PANE_LOWER_LEFT: typing.ClassVar[int] = ...
    ACTIVE_PANE_UPER_LEFT: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getActivePane(self) -> int: ...
    def getLeftColumn(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getTopRow(self) -> int: ...
    def getX(self) -> int: ...
    def getY(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setActivePane(self, short: int) -> None: ...
    def setLeftColumn(self, short: int) -> None: ...
    def setTopRow(self, short: int) -> None: ...
    def setX(self, short: int) -> None: ...
    def setY(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class PasswordRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getPassword(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @staticmethod
    def hashPassword(string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPassword(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class PasswordRev4Record(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getPassword(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPassword(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class PlotAreaRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class PlotGrowthRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getHorizontalScale(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getVerticalScale(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setHorizontalScale(self, int: int) -> None: ...
    def setVerticalScale(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class PrecisionRecord(Record):
    sid: typing.ClassVar[int] = ...
    field_1_precision: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFullPrecision(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFullPrecision(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class PrintGridlinesRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getPrintGridlines(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPrintGridlines(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class PrintHeadersRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getPrintHeaders(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPrintHeaders(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class PrintSetupRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCopies(self) -> int: ...
    def getDraft(self) -> bool: ...
    def getFitHeight(self) -> int: ...
    def getFitWidth(self) -> int: ...
    def getFooterMargin(self) -> float: ...
    def getHResolution(self) -> int: ...
    def getHeaderMargin(self) -> float: ...
    def getLandscape(self) -> bool: ...
    def getLeftToRight(self) -> bool: ...
    def getNoColor(self) -> bool: ...
    def getNoOrientation(self) -> bool: ...
    def getNotes(self) -> bool: ...
    def getOptions(self) -> int: ...
    def getPageStart(self) -> int: ...
    def getPaperSize(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getScale(self) -> int: ...
    def getSid(self) -> int: ...
    def getUsePage(self) -> bool: ...
    def getVResolution(self) -> int: ...
    def getValidSettings(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCopies(self, short: int) -> None: ...
    def setDraft(self, boolean: bool) -> None: ...
    def setFitHeight(self, short: int) -> None: ...
    def setFitWidth(self, short: int) -> None: ...
    def setFooterMargin(self, double: float) -> None: ...
    def setHResolution(self, short: int) -> None: ...
    def setHeaderMargin(self, double: float) -> None: ...
    def setLandscape(self, boolean: bool) -> None: ...
    def setLeftToRight(self, boolean: bool) -> None: ...
    def setNoColor(self, boolean: bool) -> None: ...
    def setNoOrientation(self, boolean: bool) -> None: ...
    def setNotes(self, boolean: bool) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setPageStart(self, short: int) -> None: ...
    def setPaperSize(self, short: int) -> None: ...
    def setScale(self, short: int) -> None: ...
    def setUsePage(self, boolean: bool) -> None: ...
    def setVResolution(self, short: int) -> None: ...
    def setValidSettings(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class ProtectRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getProtect(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setProtect(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class ProtectionRev4Record(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getProtect(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setProtect(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class RKRecord(Record, CellValueRecordInterface):
    sid: typing.ClassVar[int] = ...
    RK_IEEE_NUMBER: typing.ClassVar[int] = ...
    RK_IEEE_NUMBER_TIMES_100: typing.ClassVar[int] = ...
    RK_INTEGER: typing.ClassVar[int] = ...
    RK_INTEGER_TIMES_100: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getRKField(self) -> int: ...
    def getRKNumber(self) -> float: ...
    def getRKType(self) -> int: ...
    def getRow(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def isAfter(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isBefore(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isEqual(self, cellValueRecordInterface: CellValueRecordInterface) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setColumn(self, short: int) -> None: ...
    def setRow(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class RecalcIdRecord(Record):
    sid: typing.ClassVar[int] = ...
    field_1_recalcids: typing.List[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecalcIdArray(self) -> typing.List[int]: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isNeeded(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setIsNeeded(self, boolean: bool) -> None: ...
    def setRecalcIdArray(self, shortArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...

class RefModeRecord(Record):
    sid: typing.ClassVar[int] = ...
    USE_A1_MODE: typing.ClassVar[int] = ...
    USE_R1C1_MODE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMode(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMode(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class RefreshAllRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getRefreshAll(self) -> bool: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setRefreshAll(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class RightMarginRecord(Record, Margin):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMargin(self) -> float: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMargin(self, double: float) -> None: ...
    def toString(self) -> java.lang.String: ...

class RowRecord(Record, java.lang.Comparable):
    sid: typing.ClassVar[int] = ...
    MAX_ROW_NUMBER: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def compareTo(self, object: typing.Any) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getBadFontHeight(self) -> bool: ...
    def getColapsed(self) -> bool: ...
    def getFirstCol(self) -> int: ...
    def getFormatted(self) -> bool: ...
    def getHeight(self) -> int: ...
    def getLastCol(self) -> int: ...
    def getOptimize(self) -> int: ...
    def getOptionFlags(self) -> int: ...
    def getOutlineLevel(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRowNumber(self) -> int: ...
    def getSid(self) -> int: ...
    def getXFIndex(self) -> int: ...
    def getZeroHeight(self) -> bool: ...
    def isInValueSection(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBadFontHeight(self, boolean: bool) -> None: ...
    def setColapsed(self, boolean: bool) -> None: ...
    def setFirstCol(self, short: int) -> None: ...
    def setFormatted(self, boolean: bool) -> None: ...
    def setHeight(self, short: int) -> None: ...
    def setLastCol(self, short: int) -> None: ...
    def setOptimize(self, short: int) -> None: ...
    def setOptionFlags(self, short: int) -> None: ...
    def setOutlineLevel(self, short: int) -> None: ...
    def setRowNumber(self, int: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def setZeroHeight(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class SCLRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDenominator(self) -> int: ...
    def getNumerator(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setDenominator(self, short: int) -> None: ...
    def setNumerator(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SSTRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def addString(self, unicodeString: UnicodeString) -> int: ...
    def calcExtSSTRecordSize(self) -> int: ...
    def createExtSSTRecord(self, int: int) -> ExtSSTRecord: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getNumStrings(self) -> int: ...
    def getNumUniqueStrings(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getString(self, int: int) -> UnicodeString: ...
    def hashCode(self) -> int: ...
    def isString16bit(self, int: int) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setNumStrings(self, int: int) -> None: ...
    def setNumUniqueStrings(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SaveRecalcRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecalc(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setRecalc(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class ScenarioProtectRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getProtect(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setProtect(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class SelectionRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getActiveCellCol(self) -> int: ...
    def getActiveCellRef(self) -> int: ...
    def getActiveCellRow(self) -> int: ...
    def getNumRefs(self) -> int: ...
    def getPane(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setActiveCellCol(self, short: int) -> None: ...
    def setActiveCellRef(self, short: int) -> None: ...
    def setActiveCellRow(self, int: int) -> None: ...
    def setNumRefs(self, short: int) -> None: ...
    def setPane(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...
    class Reference:
        def getFirstColumn(self) -> int: ...
        def getFirstRow(self) -> int: ...
        def getLastColumn(self) -> int: ...
        def getLastRow(self) -> int: ...

class SeriesChartGroupIndexRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getChartGroupIndex(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setChartGroupIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesIndexRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getIndex(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesLabelsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormatFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isLabelAsPercentage(self) -> bool: ...
    def isShowActual(self) -> bool: ...
    def isShowBubbleSizes(self) -> bool: ...
    def isShowLabel(self) -> bool: ...
    def isShowPercent(self) -> bool: ...
    def isSmoothedLine(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormatFlags(self, short: int) -> None: ...
    def setLabelAsPercentage(self, boolean: bool) -> None: ...
    def setShowActual(self, boolean: bool) -> None: ...
    def setShowBubbleSizes(self, boolean: bool) -> None: ...
    def setShowLabel(self, boolean: bool) -> None: ...
    def setShowPercent(self, boolean: bool) -> None: ...
    def setSmoothedLine(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesListRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSeriesNumbers(self) -> typing.List[int]: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setSeriesNumbers(self, shortArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesRecord(Record):
    sid: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_DATES: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_NUMERIC: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_SEQUENCE: typing.ClassVar[int] = ...
    CATEGORY_DATA_TYPE_TEXT: typing.ClassVar[int] = ...
    VALUES_DATA_TYPE_DATES: typing.ClassVar[int] = ...
    VALUES_DATA_TYPE_NUMERIC: typing.ClassVar[int] = ...
    VALUES_DATA_TYPE_SEQUENCE: typing.ClassVar[int] = ...
    VALUES_DATA_TYPE_TEXT: typing.ClassVar[int] = ...
    BUBBLE_SERIES_TYPE_DATES: typing.ClassVar[int] = ...
    BUBBLE_SERIES_TYPE_NUMERIC: typing.ClassVar[int] = ...
    BUBBLE_SERIES_TYPE_SEQUENCE: typing.ClassVar[int] = ...
    BUBBLE_SERIES_TYPE_TEXT: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBubbleSeriesType(self) -> int: ...
    def getCategoryDataType(self) -> int: ...
    def getNumBubbleValues(self) -> int: ...
    def getNumCategories(self) -> int: ...
    def getNumValues(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getValuesDataType(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBubbleSeriesType(self, short: int) -> None: ...
    def setCategoryDataType(self, short: int) -> None: ...
    def setNumBubbleValues(self, short: int) -> None: ...
    def setNumCategories(self, short: int) -> None: ...
    def setNumValues(self, short: int) -> None: ...
    def setValuesDataType(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesTextRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getId(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getText(self) -> java.lang.String: ...
    def getTextLength(self) -> int: ...
    def getUndocumented(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setId(self, short: int) -> None: ...
    def setText(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTextLength(self, byte: int) -> None: ...
    def setUndocumented(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SeriesToChartGroupRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getChartGroupIndex(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setChartGroupIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SharedFormulaRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def convertSharedFormulaRecord(self, formulaRecord: FormulaRecord) -> None: ...
    def getExpressionLength(self) -> int: ...
    def getFirstColumn(self) -> int: ...
    def getFirstRow(self) -> int: ...
    def getLastColumn(self) -> int: ...
    def getLastRow(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isFormulaInShared(self, formulaRecord: FormulaRecord) -> bool: ...
    def isInValueSection(self) -> bool: ...
    def isValue(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class SheetPropertiesRecord(Record):
    sid: typing.ClassVar[int] = ...
    EMPTY_NOT_PLOTTED: typing.ClassVar[int] = ...
    EMPTY_ZERO: typing.ClassVar[int] = ...
    EMPTY_INTERPOLATED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getEmpty(self) -> int: ...
    def getFlags(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isAutoPlotArea(self) -> bool: ...
    def isChartTypeManuallyFormatted(self) -> bool: ...
    def isDefaultPlotDimensions(self) -> bool: ...
    def isDoNotSizeWithWindow(self) -> bool: ...
    def isPlotVisibleOnly(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutoPlotArea(self, boolean: bool) -> None: ...
    def setChartTypeManuallyFormatted(self, boolean: bool) -> None: ...
    def setDefaultPlotDimensions(self, boolean: bool) -> None: ...
    def setDoNotSizeWithWindow(self, boolean: bool) -> None: ...
    def setEmpty(self, byte: int) -> None: ...
    def setFlags(self, short: int) -> None: ...
    def setPlotVisibleOnly(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class StringRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getString(self) -> java.lang.String: ...
    def isInValueSection(self) -> bool: ...
    def isUnCompressedUnicode(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setCompressedFlag(self, byte: int) -> None: ...
    def setString(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def toString(self) -> java.lang.String: ...

class StyleRecord(Record):
    sid: typing.ClassVar[int] = ...
    STYLE_USER_DEFINED: typing.ClassVar[int] = ...
    STYLE_BUILT_IN: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getBuiltin(self) -> int: ...
    def getIndex(self) -> int: ...
    def getName(self) -> java.lang.String: ...
    def getNameLength(self) -> int: ...
    def getOutlineStyleLevel(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getType(self) -> int: ...
    def getXFIndex(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setBuiltin(self, byte: int) -> None: ...
    def setIndex(self, short: int) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNameLength(self, byte: int) -> None: ...
    def setOutlineStyleLevel(self, byte: int) -> None: ...
    def setType(self, short: int) -> None: ...
    def setXFIndex(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class SubRecord(Record):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @staticmethod
    def createSubRecord(recordInputStream: RecordInputStream) -> Record: ...

class SupBookRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFlag(self) -> int: ...
    def getNumberOfSheets(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFlag(self, short: int) -> None: ...
    def setNumberOfSheets(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class TabIdRecord(Record):
    sid: typing.ClassVar[int] = ...
    field_1_tabids: typing.List[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getTabIdArray(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setTabIdArray(self, shortArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...

class TextObjectBaseRecord(Record):
    sid: typing.ClassVar[int] = ...
    HORIZONTAL_TEXT_ALIGNMENT_LEFT_ALIGNED: typing.ClassVar[int] = ...
    HORIZONTAL_TEXT_ALIGNMENT_CENTERED: typing.ClassVar[int] = ...
    HORIZONTAL_TEXT_ALIGNMENT_RIGHT_ALIGNED: typing.ClassVar[int] = ...
    HORIZONTAL_TEXT_ALIGNMENT_JUSTIFIED: typing.ClassVar[int] = ...
    VERTICAL_TEXT_ALIGNMENT_TOP: typing.ClassVar[int] = ...
    VERTICAL_TEXT_ALIGNMENT_CENTER: typing.ClassVar[int] = ...
    VERTICAL_TEXT_ALIGNMENT_BOTTOM: typing.ClassVar[int] = ...
    VERTICAL_TEXT_ALIGNMENT_JUSTIFY: typing.ClassVar[int] = ...
    TEXT_ORIENTATION_NONE: typing.ClassVar[int] = ...
    TEXT_ORIENTATION_TOP_TO_BOTTOM: typing.ClassVar[int] = ...
    TEXT_ORIENTATION_ROT_RIGHT: typing.ClassVar[int] = ...
    TEXT_ORIENTATION_ROT_LEFT: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getFormattingRunLength(self) -> int: ...
    def getHorizontalTextAlignment(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getReserved2(self) -> int: ...
    def getReserved3(self) -> int: ...
    def getReserved4(self) -> int: ...
    def getReserved5(self) -> int: ...
    def getReserved6(self) -> int: ...
    def getReserved7(self) -> int: ...
    def getSid(self) -> int: ...
    def getTextLength(self) -> int: ...
    def getTextOrientation(self) -> int: ...
    def getVerticalTextAlignment(self) -> int: ...
    def isReserved1(self) -> bool: ...
    def isTextLocked(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFormattingRunLength(self, short: int) -> None: ...
    def setHorizontalTextAlignment(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setReserved1(self, boolean: bool) -> None: ...
    def setReserved2(self, short: int) -> None: ...
    def setReserved3(self, short: int) -> None: ...
    def setReserved4(self, short: int) -> None: ...
    def setReserved5(self, short: int) -> None: ...
    def setReserved6(self, short: int) -> None: ...
    def setReserved7(self, int: int) -> None: ...
    def setTextLength(self, short: int) -> None: ...
    def setTextLocked(self, boolean: bool) -> None: ...
    def setTextOrientation(self, short: int) -> None: ...
    def setVerticalTextAlignment(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class TextRecord(Record):
    sid: typing.ClassVar[int] = ...
    HORIZONTAL_ALIGNMENT_LEFT: typing.ClassVar[int] = ...
    HORIZONTAL_ALIGNMENT_CENTER: typing.ClassVar[int] = ...
    HORIZONTAL_ALIGNMENT_BOTTOM: typing.ClassVar[int] = ...
    HORIZONTAL_ALIGNMENT_JUSTIFY: typing.ClassVar[int] = ...
    VERTICAL_ALIGNMENT_TOP: typing.ClassVar[int] = ...
    VERTICAL_ALIGNMENT_CENTER: typing.ClassVar[int] = ...
    VERTICAL_ALIGNMENT_BOTTOM: typing.ClassVar[int] = ...
    VERTICAL_ALIGNMENT_JUSTIFY: typing.ClassVar[int] = ...
    DISPLAY_MODE_TRANSPARENT: typing.ClassVar[int] = ...
    DISPLAY_MODE_OPAQUE: typing.ClassVar[int] = ...
    ROTATION_NONE: typing.ClassVar[int] = ...
    ROTATION_TOP_TO_BOTTOM: typing.ClassVar[int] = ...
    ROTATION_ROTATED_90_DEGREES: typing.ClassVar[int] = ...
    ROTATION_ROTATED_90_DEGREES_CLOCKWISE: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_CHART_DEPENDENT: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_OUTSIDE: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_INSIDE: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_CENTER: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_AXIS: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_ABOVE: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_BELOW: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_LEFT: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_RIGHT: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_AUTO: typing.ClassVar[int] = ...
    DATA_LABEL_PLACEMENT_USER_MOVED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDataLabelPlacement(self) -> int: ...
    def getDisplayMode(self) -> int: ...
    def getHeight(self) -> int: ...
    def getHorizontalAlignment(self) -> int: ...
    def getIndexOfColorValue(self) -> int: ...
    def getOptions1(self) -> int: ...
    def getOptions2(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRgbColor(self) -> int: ...
    def getRotation(self) -> int: ...
    def getSid(self) -> int: ...
    def getTextRotation(self) -> int: ...
    def getVerticalAlignment(self) -> int: ...
    def getWidth(self) -> int: ...
    def getX(self) -> int: ...
    def getY(self) -> int: ...
    def isAutoBackground(self) -> bool: ...
    def isAutoColor(self) -> bool: ...
    def isAutoGeneratedText(self) -> bool: ...
    def isAutoLabelDeleted(self) -> bool: ...
    def isGenerated(self) -> bool: ...
    def isShowBubbleSizes(self) -> bool: ...
    def isShowCategoryLabelAsPercentage(self) -> bool: ...
    def isShowKey(self) -> bool: ...
    def isShowLabel(self) -> bool: ...
    def isShowValue(self) -> bool: ...
    def isShowValueAsPercentage(self) -> bool: ...
    def isVertical(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutoBackground(self, boolean: bool) -> None: ...
    def setAutoColor(self, boolean: bool) -> None: ...
    def setAutoGeneratedText(self, boolean: bool) -> None: ...
    def setAutoLabelDeleted(self, boolean: bool) -> None: ...
    def setDataLabelPlacement(self, short: int) -> None: ...
    def setDisplayMode(self, short: int) -> None: ...
    def setGenerated(self, boolean: bool) -> None: ...
    def setHeight(self, int: int) -> None: ...
    def setHorizontalAlignment(self, byte: int) -> None: ...
    def setIndexOfColorValue(self, short: int) -> None: ...
    def setOptions1(self, short: int) -> None: ...
    def setOptions2(self, short: int) -> None: ...
    def setRgbColor(self, int: int) -> None: ...
    def setRotation(self, short: int) -> None: ...
    def setShowBubbleSizes(self, boolean: bool) -> None: ...
    def setShowCategoryLabelAsPercentage(self, boolean: bool) -> None: ...
    def setShowKey(self, boolean: bool) -> None: ...
    def setShowLabel(self, boolean: bool) -> None: ...
    def setShowValue(self, boolean: bool) -> None: ...
    def setShowValueAsPercentage(self, boolean: bool) -> None: ...
    def setTextRotation(self, short: int) -> None: ...
    def setVertical(self, boolean: bool) -> None: ...
    def setVerticalAlignment(self, byte: int) -> None: ...
    def setWidth(self, int: int) -> None: ...
    def setX(self, int: int) -> None: ...
    def setY(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class TickRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getBackground(self) -> int: ...
    def getLabelColorRgb(self) -> int: ...
    def getLabelPosition(self) -> int: ...
    def getMajorTickType(self) -> int: ...
    def getMinorTickType(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getRotation(self) -> int: ...
    def getSid(self) -> int: ...
    def getTickColor(self) -> int: ...
    def getZero1(self) -> int: ...
    def getZero2(self) -> int: ...
    def getZero3(self) -> int: ...
    def isAutoTextBackground(self) -> bool: ...
    def isAutoTextColor(self) -> bool: ...
    def isAutorotate(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutoTextBackground(self, boolean: bool) -> None: ...
    def setAutoTextColor(self, boolean: bool) -> None: ...
    def setAutorotate(self, boolean: bool) -> None: ...
    def setBackground(self, byte: int) -> None: ...
    def setLabelColorRgb(self, int: int) -> None: ...
    def setLabelPosition(self, byte: int) -> None: ...
    def setMajorTickType(self, byte: int) -> None: ...
    def setMinorTickType(self, byte: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setRotation(self, short: int) -> None: ...
    def setTickColor(self, short: int) -> None: ...
    def setZero1(self, int: int) -> None: ...
    def setZero2(self, int: int) -> None: ...
    def setZero3(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class TopMarginRecord(Record, Margin):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getMargin(self) -> float: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setMargin(self, double: float) -> None: ...
    def toString(self) -> java.lang.String: ...

class UnitsRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getUnits(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setUnits(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class UnknownRecord(Record):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, byteArray: typing.List[int]): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class UseSelFSRecord(Record):
    sid: typing.ClassVar[int] = ...
    TRUE: typing.ClassVar[int] = ...
    FALSE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getFlag(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setFlag(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class VCenterRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getVCenter(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setVCenter(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class ValueRangeRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getCategoryAxisCross(self) -> float: ...
    def getMajorIncrement(self) -> float: ...
    def getMaximumAxisValue(self) -> float: ...
    def getMinimumAxisValue(self) -> float: ...
    def getMinorIncrement(self) -> float: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def isAutomaticCategoryCrossing(self) -> bool: ...
    def isAutomaticMajor(self) -> bool: ...
    def isAutomaticMaximum(self) -> bool: ...
    def isAutomaticMinimum(self) -> bool: ...
    def isAutomaticMinor(self) -> bool: ...
    def isCrossCategoryAxisAtMaximum(self) -> bool: ...
    def isLogarithmicScale(self) -> bool: ...
    def isReserved(self) -> bool: ...
    def isValuesInReverse(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutomaticCategoryCrossing(self, boolean: bool) -> None: ...
    def setAutomaticMajor(self, boolean: bool) -> None: ...
    def setAutomaticMaximum(self, boolean: bool) -> None: ...
    def setAutomaticMinimum(self, boolean: bool) -> None: ...
    def setAutomaticMinor(self, boolean: bool) -> None: ...
    def setCategoryAxisCross(self, double: float) -> None: ...
    def setCrossCategoryAxisAtMaximum(self, boolean: bool) -> None: ...
    def setLogarithmicScale(self, boolean: bool) -> None: ...
    def setMajorIncrement(self, double: float) -> None: ...
    def setMaximumAxisValue(self, double: float) -> None: ...
    def setMinimumAxisValue(self, double: float) -> None: ...
    def setMinorIncrement(self, double: float) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setReserved(self, boolean: bool) -> None: ...
    def setValuesInReverse(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class WSBoolRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAlternateExpression(self) -> bool: ...
    def getAlternateFormula(self) -> bool: ...
    def getAutobreaks(self) -> bool: ...
    def getDialog(self) -> bool: ...
    def getDisplayGuts(self) -> bool: ...
    def getFitToPage(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getRowSumsBelow(self) -> bool: ...
    def getRowSumsRight(self) -> bool: ...
    def getSid(self) -> int: ...
    def getWSBool1(self) -> int: ...
    def getWSBool2(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAlternateExpression(self, boolean: bool) -> None: ...
    def setAlternateFormula(self, boolean: bool) -> None: ...
    def setAutobreaks(self, boolean: bool) -> None: ...
    def setDialog(self, boolean: bool) -> None: ...
    def setDisplayGuts(self, boolean: bool) -> None: ...
    def setFitToPage(self, boolean: bool) -> None: ...
    def setRowSumsBelow(self, boolean: bool) -> None: ...
    def setRowSumsRight(self, boolean: bool) -> None: ...
    def setWSBool1(self, byte: int) -> None: ...
    def setWSBool2(self, byte: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class WindowOneRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getDisplayHorizontalScrollbar(self) -> bool: ...
    def getDisplayTabs(self) -> bool: ...
    def getDisplayVerticalScrollbar(self) -> bool: ...
    def getDisplayedTab(self) -> int: ...
    def getHeight(self) -> int: ...
    def getHidden(self) -> bool: ...
    def getHorizontalHold(self) -> int: ...
    def getIconic(self) -> bool: ...
    def getNumSelectedTabs(self) -> int: ...
    def getOptions(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSelectedTab(self) -> int: ...
    def getSid(self) -> int: ...
    def getTabWidthRatio(self) -> int: ...
    def getVerticalHold(self) -> int: ...
    def getWidth(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setDisplayHorizonalScrollbar(self, boolean: bool) -> None: ...
    def setDisplayTabs(self, boolean: bool) -> None: ...
    def setDisplayVerticalScrollbar(self, boolean: bool) -> None: ...
    def setDisplayedTab(self, short: int) -> None: ...
    def setHeight(self, short: int) -> None: ...
    def setHidden(self, boolean: bool) -> None: ...
    def setHorizontalHold(self, short: int) -> None: ...
    def setIconic(self, boolean: bool) -> None: ...
    def setNumSelectedTabs(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setSelectedTab(self, short: int) -> None: ...
    def setTabWidthRatio(self, short: int) -> None: ...
    def setVerticalHold(self, short: int) -> None: ...
    def setWidth(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class WindowProtectRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getProtect(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setProtect(self, boolean: bool) -> None: ...
    def toString(self) -> java.lang.String: ...

class WindowTwoRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getArabic(self) -> bool: ...
    def getDefaultHeader(self) -> bool: ...
    def getDisplayFormulas(self) -> bool: ...
    def getDisplayGridlines(self) -> bool: ...
    def getDisplayGuts(self) -> bool: ...
    def getDisplayRowColHeadings(self) -> bool: ...
    def getDisplayZeros(self) -> bool: ...
    def getFreezePanes(self) -> bool: ...
    def getFreezePanesNoSplit(self) -> bool: ...
    def getHeaderColor(self) -> int: ...
    def getLeftCol(self) -> int: ...
    def getNormalZoom(self) -> int: ...
    def getOptions(self) -> int: ...
    def getPageBreakZoom(self) -> int: ...
    def getPaged(self) -> bool: ...
    def getRecordSize(self) -> int: ...
    def getReserved(self) -> int: ...
    def getSavedInPageBreakPreview(self) -> bool: ...
    def getSelected(self) -> bool: ...
    def getSid(self) -> int: ...
    def getTopRow(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setArabic(self, boolean: bool) -> None: ...
    def setDefaultHeader(self, boolean: bool) -> None: ...
    def setDisplayFormulas(self, boolean: bool) -> None: ...
    def setDisplayGridlines(self, boolean: bool) -> None: ...
    def setDisplayGuts(self, boolean: bool) -> None: ...
    def setDisplayRowColHeadings(self, boolean: bool) -> None: ...
    def setDisplayZeros(self, boolean: bool) -> None: ...
    def setFreezePanes(self, boolean: bool) -> None: ...
    def setFreezePanesNoSplit(self, boolean: bool) -> None: ...
    def setHeaderColor(self, int: int) -> None: ...
    def setLeftCol(self, short: int) -> None: ...
    def setNormalZoom(self, short: int) -> None: ...
    def setOptions(self, short: int) -> None: ...
    def setPageBreakZoom(self, short: int) -> None: ...
    def setPaged(self, boolean: bool) -> None: ...
    def setReserved(self, int: int) -> None: ...
    def setSavedInPageBreakPreview(self, boolean: bool) -> None: ...
    def setSelected(self, boolean: bool) -> None: ...
    def setTopRow(self, short: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class WriteAccessRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getUsername(self) -> java.lang.String: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setUsername(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def toString(self) -> java.lang.String: ...

class WriteProtectRecord(Record):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class CommonObjectDataSubRecord(SubRecord):
    sid: typing.ClassVar[int] = ...
    OBJECT_TYPE_GROUP: typing.ClassVar[int] = ...
    OBJECT_TYPE_LINE: typing.ClassVar[int] = ...
    OBJECT_TYPE_RECTANGLE: typing.ClassVar[int] = ...
    OBJECT_TYPE_OVAL: typing.ClassVar[int] = ...
    OBJECT_TYPE_ARC: typing.ClassVar[int] = ...
    OBJECT_TYPE_CHART: typing.ClassVar[int] = ...
    OBJECT_TYPE_TEXT: typing.ClassVar[int] = ...
    OBJECT_TYPE_BUTTON: typing.ClassVar[int] = ...
    OBJECT_TYPE_PICTURE: typing.ClassVar[int] = ...
    OBJECT_TYPE_POLYGON: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED1: typing.ClassVar[int] = ...
    OBJECT_TYPE_CHECKBOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_OPTION_BUTTON: typing.ClassVar[int] = ...
    OBJECT_TYPE_EDIT_BOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_LABEL: typing.ClassVar[int] = ...
    OBJECT_TYPE_DIALOG_BOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_SPINNER: typing.ClassVar[int] = ...
    OBJECT_TYPE_SCROLL_BAR: typing.ClassVar[int] = ...
    OBJECT_TYPE_LIST_BOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_GROUP_BOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_COMBO_BOX: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED2: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED3: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED4: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED5: typing.ClassVar[int] = ...
    OBJECT_TYPE_COMMENT: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED6: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED7: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED8: typing.ClassVar[int] = ...
    OBJECT_TYPE_RESERVED9: typing.ClassVar[int] = ...
    OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getObjectId(self) -> int: ...
    def getObjectType(self) -> int: ...
    def getOption(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getReserved1(self) -> int: ...
    def getReserved2(self) -> int: ...
    def getReserved3(self) -> int: ...
    def getSid(self) -> int: ...
    def isAutofill(self) -> bool: ...
    def isAutoline(self) -> bool: ...
    def isLocked(self) -> bool: ...
    def isPrintable(self) -> bool: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setAutofill(self, boolean: bool) -> None: ...
    def setAutoline(self, boolean: bool) -> None: ...
    def setLocked(self, boolean: bool) -> None: ...
    def setObjectId(self, short: int) -> None: ...
    def setObjectType(self, short: int) -> None: ...
    def setOption(self, short: int) -> None: ...
    def setPrintable(self, boolean: bool) -> None: ...
    def setReserved1(self, int: int) -> None: ...
    def setReserved2(self, int: int) -> None: ...
    def setReserved3(self, int: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class DrawingGroupRecord(AbstractEscherHolderRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRawDataSize(self) -> int: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...

class DrawingRecordForBiffViewer(AbstractEscherHolderRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getSid(self) -> int: ...

class DrawingSelectionRecord(AbstractEscherHolderRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getSid(self) -> int: ...

class EmbeddedObjectRefSubRecord(SubRecord):
    sid: typing.ClassVar[int] = ...
    field_1_stream_id_offset: int = ...
    field_2_unknown: typing.List[int] = ...
    field_3_unicode_len: int = ...
    field_4_unicode_flag: bool = ...
    field_5_ole_classname: java.lang.String = ...
    field_6_stream_id: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    def getStreamId(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class EndSubRecord(SubRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class EscherAggregate(AbstractEscherHolderRecord):
    sid: typing.ClassVar[int] = ...
    ST_MIN: typing.ClassVar[int] = ...
    ST_NOT_PRIMATIVE: typing.ClassVar[int] = ...
    ST_RECTANGLE: typing.ClassVar[int] = ...
    ST_ROUNDRECTANGLE: typing.ClassVar[int] = ...
    ST_ELLIPSE: typing.ClassVar[int] = ...
    ST_DIAMOND: typing.ClassVar[int] = ...
    ST_ISOCELESTRIANGLE: typing.ClassVar[int] = ...
    ST_RIGHTTRIANGLE: typing.ClassVar[int] = ...
    ST_PARALLELOGRAM: typing.ClassVar[int] = ...
    ST_TRAPEZOID: typing.ClassVar[int] = ...
    ST_HEXAGON: typing.ClassVar[int] = ...
    ST_OCTAGON: typing.ClassVar[int] = ...
    ST_PLUS: typing.ClassVar[int] = ...
    ST_STAR: typing.ClassVar[int] = ...
    ST_ARROW: typing.ClassVar[int] = ...
    ST_THICKARROW: typing.ClassVar[int] = ...
    ST_HOMEPLATE: typing.ClassVar[int] = ...
    ST_CUBE: typing.ClassVar[int] = ...
    ST_BALLOON: typing.ClassVar[int] = ...
    ST_SEAL: typing.ClassVar[int] = ...
    ST_ARC: typing.ClassVar[int] = ...
    ST_LINE: typing.ClassVar[int] = ...
    ST_PLAQUE: typing.ClassVar[int] = ...
    ST_CAN: typing.ClassVar[int] = ...
    ST_DONUT: typing.ClassVar[int] = ...
    ST_TEXTSIMPLE: typing.ClassVar[int] = ...
    ST_TEXTOCTAGON: typing.ClassVar[int] = ...
    ST_TEXTHEXAGON: typing.ClassVar[int] = ...
    ST_TEXTCURVE: typing.ClassVar[int] = ...
    ST_TEXTWAVE: typing.ClassVar[int] = ...
    ST_TEXTRING: typing.ClassVar[int] = ...
    ST_TEXTONCURVE: typing.ClassVar[int] = ...
    ST_TEXTONRING: typing.ClassVar[int] = ...
    ST_STRAIGHTCONNECTOR1: typing.ClassVar[int] = ...
    ST_BENTCONNECTOR2: typing.ClassVar[int] = ...
    ST_BENTCONNECTOR3: typing.ClassVar[int] = ...
    ST_BENTCONNECTOR4: typing.ClassVar[int] = ...
    ST_BENTCONNECTOR5: typing.ClassVar[int] = ...
    ST_CURVEDCONNECTOR2: typing.ClassVar[int] = ...
    ST_CURVEDCONNECTOR3: typing.ClassVar[int] = ...
    ST_CURVEDCONNECTOR4: typing.ClassVar[int] = ...
    ST_CURVEDCONNECTOR5: typing.ClassVar[int] = ...
    ST_CALLOUT1: typing.ClassVar[int] = ...
    ST_CALLOUT2: typing.ClassVar[int] = ...
    ST_CALLOUT3: typing.ClassVar[int] = ...
    ST_ACCENTCALLOUT1: typing.ClassVar[int] = ...
    ST_ACCENTCALLOUT2: typing.ClassVar[int] = ...
    ST_ACCENTCALLOUT3: typing.ClassVar[int] = ...
    ST_BORDERCALLOUT1: typing.ClassVar[int] = ...
    ST_BORDERCALLOUT2: typing.ClassVar[int] = ...
    ST_BORDERCALLOUT3: typing.ClassVar[int] = ...
    ST_ACCENTBORDERCALLOUT1: typing.ClassVar[int] = ...
    ST_ACCENTBORDERCALLOUT2: typing.ClassVar[int] = ...
    ST_ACCENTBORDERCALLOUT3: typing.ClassVar[int] = ...
    ST_RIBBON: typing.ClassVar[int] = ...
    ST_RIBBON2: typing.ClassVar[int] = ...
    ST_CHEVRON: typing.ClassVar[int] = ...
    ST_PENTAGON: typing.ClassVar[int] = ...
    ST_NOSMOKING: typing.ClassVar[int] = ...
    ST_SEAL8: typing.ClassVar[int] = ...
    ST_SEAL16: typing.ClassVar[int] = ...
    ST_SEAL32: typing.ClassVar[int] = ...
    ST_WEDGERECTCALLOUT: typing.ClassVar[int] = ...
    ST_WEDGERRECTCALLOUT: typing.ClassVar[int] = ...
    ST_WEDGEELLIPSECALLOUT: typing.ClassVar[int] = ...
    ST_WAVE: typing.ClassVar[int] = ...
    ST_FOLDEDCORNER: typing.ClassVar[int] = ...
    ST_LEFTARROW: typing.ClassVar[int] = ...
    ST_DOWNARROW: typing.ClassVar[int] = ...
    ST_UPARROW: typing.ClassVar[int] = ...
    ST_LEFTRIGHTARROW: typing.ClassVar[int] = ...
    ST_UPDOWNARROW: typing.ClassVar[int] = ...
    ST_IRREGULARSEAL1: typing.ClassVar[int] = ...
    ST_IRREGULARSEAL2: typing.ClassVar[int] = ...
    ST_LIGHTNINGBOLT: typing.ClassVar[int] = ...
    ST_HEART: typing.ClassVar[int] = ...
    ST_PICTUREFRAME: typing.ClassVar[int] = ...
    ST_QUADARROW: typing.ClassVar[int] = ...
    ST_LEFTARROWCALLOUT: typing.ClassVar[int] = ...
    ST_RIGHTARROWCALLOUT: typing.ClassVar[int] = ...
    ST_UPARROWCALLOUT: typing.ClassVar[int] = ...
    ST_DOWNARROWCALLOUT: typing.ClassVar[int] = ...
    ST_LEFTRIGHTARROWCALLOUT: typing.ClassVar[int] = ...
    ST_UPDOWNARROWCALLOUT: typing.ClassVar[int] = ...
    ST_QUADARROWCALLOUT: typing.ClassVar[int] = ...
    ST_BEVEL: typing.ClassVar[int] = ...
    ST_LEFTBRACKET: typing.ClassVar[int] = ...
    ST_RIGHTBRACKET: typing.ClassVar[int] = ...
    ST_LEFTBRACE: typing.ClassVar[int] = ...
    ST_RIGHTBRACE: typing.ClassVar[int] = ...
    ST_LEFTUPARROW: typing.ClassVar[int] = ...
    ST_BENTUPARROW: typing.ClassVar[int] = ...
    ST_BENTARROW: typing.ClassVar[int] = ...
    ST_SEAL24: typing.ClassVar[int] = ...
    ST_STRIPEDRIGHTARROW: typing.ClassVar[int] = ...
    ST_NOTCHEDRIGHTARROW: typing.ClassVar[int] = ...
    ST_BLOCKARC: typing.ClassVar[int] = ...
    ST_SMILEYFACE: typing.ClassVar[int] = ...
    ST_VERTICALSCROLL: typing.ClassVar[int] = ...
    ST_HORIZONTALSCROLL: typing.ClassVar[int] = ...
    ST_CIRCULARARROW: typing.ClassVar[int] = ...
    ST_NOTCHEDCIRCULARARROW: typing.ClassVar[int] = ...
    ST_UTURNARROW: typing.ClassVar[int] = ...
    ST_CURVEDRIGHTARROW: typing.ClassVar[int] = ...
    ST_CURVEDLEFTARROW: typing.ClassVar[int] = ...
    ST_CURVEDUPARROW: typing.ClassVar[int] = ...
    ST_CURVEDDOWNARROW: typing.ClassVar[int] = ...
    ST_CLOUDCALLOUT: typing.ClassVar[int] = ...
    ST_ELLIPSERIBBON: typing.ClassVar[int] = ...
    ST_ELLIPSERIBBON2: typing.ClassVar[int] = ...
    ST_FLOWCHARTPROCESS: typing.ClassVar[int] = ...
    ST_FLOWCHARTDECISION: typing.ClassVar[int] = ...
    ST_FLOWCHARTINPUTOUTPUT: typing.ClassVar[int] = ...
    ST_FLOWCHARTPREDEFINEDPROCESS: typing.ClassVar[int] = ...
    ST_FLOWCHARTINTERNALSTORAGE: typing.ClassVar[int] = ...
    ST_FLOWCHARTDOCUMENT: typing.ClassVar[int] = ...
    ST_FLOWCHARTMULTIDOCUMENT: typing.ClassVar[int] = ...
    ST_FLOWCHARTTERMINATOR: typing.ClassVar[int] = ...
    ST_FLOWCHARTPREPARATION: typing.ClassVar[int] = ...
    ST_FLOWCHARTMANUALINPUT: typing.ClassVar[int] = ...
    ST_FLOWCHARTMANUALOPERATION: typing.ClassVar[int] = ...
    ST_FLOWCHARTCONNECTOR: typing.ClassVar[int] = ...
    ST_FLOWCHARTPUNCHEDCARD: typing.ClassVar[int] = ...
    ST_FLOWCHARTPUNCHEDTAPE: typing.ClassVar[int] = ...
    ST_FLOWCHARTSUMMINGJUNCTION: typing.ClassVar[int] = ...
    ST_FLOWCHARTOR: typing.ClassVar[int] = ...
    ST_FLOWCHARTCOLLATE: typing.ClassVar[int] = ...
    ST_FLOWCHARTSORT: typing.ClassVar[int] = ...
    ST_FLOWCHARTEXTRACT: typing.ClassVar[int] = ...
    ST_FLOWCHARTMERGE: typing.ClassVar[int] = ...
    ST_FLOWCHARTOFFLINESTORAGE: typing.ClassVar[int] = ...
    ST_FLOWCHARTONLINESTORAGE: typing.ClassVar[int] = ...
    ST_FLOWCHARTMAGNETICTAPE: typing.ClassVar[int] = ...
    ST_FLOWCHARTMAGNETICDISK: typing.ClassVar[int] = ...
    ST_FLOWCHARTMAGNETICDRUM: typing.ClassVar[int] = ...
    ST_FLOWCHARTDISPLAY: typing.ClassVar[int] = ...
    ST_FLOWCHARTDELAY: typing.ClassVar[int] = ...
    ST_TEXTPLAINTEXT: typing.ClassVar[int] = ...
    ST_TEXTSTOP: typing.ClassVar[int] = ...
    ST_TEXTTRIANGLE: typing.ClassVar[int] = ...
    ST_TEXTTRIANGLEINVERTED: typing.ClassVar[int] = ...
    ST_TEXTCHEVRON: typing.ClassVar[int] = ...
    ST_TEXTCHEVRONINVERTED: typing.ClassVar[int] = ...
    ST_TEXTRINGINSIDE: typing.ClassVar[int] = ...
    ST_TEXTRINGOUTSIDE: typing.ClassVar[int] = ...
    ST_TEXTARCHUPCURVE: typing.ClassVar[int] = ...
    ST_TEXTARCHDOWNCURVE: typing.ClassVar[int] = ...
    ST_TEXTCIRCLECURVE: typing.ClassVar[int] = ...
    ST_TEXTBUTTONCURVE: typing.ClassVar[int] = ...
    ST_TEXTARCHUPPOUR: typing.ClassVar[int] = ...
    ST_TEXTARCHDOWNPOUR: typing.ClassVar[int] = ...
    ST_TEXTCIRCLEPOUR: typing.ClassVar[int] = ...
    ST_TEXTBUTTONPOUR: typing.ClassVar[int] = ...
    ST_TEXTCURVEUP: typing.ClassVar[int] = ...
    ST_TEXTCURVEDOWN: typing.ClassVar[int] = ...
    ST_TEXTCASCADEUP: typing.ClassVar[int] = ...
    ST_TEXTCASCADEDOWN: typing.ClassVar[int] = ...
    ST_TEXTWAVE1: typing.ClassVar[int] = ...
    ST_TEXTWAVE2: typing.ClassVar[int] = ...
    ST_TEXTWAVE3: typing.ClassVar[int] = ...
    ST_TEXTWAVE4: typing.ClassVar[int] = ...
    ST_TEXTINFLATE: typing.ClassVar[int] = ...
    ST_TEXTDEFLATE: typing.ClassVar[int] = ...
    ST_TEXTINFLATEBOTTOM: typing.ClassVar[int] = ...
    ST_TEXTDEFLATEBOTTOM: typing.ClassVar[int] = ...
    ST_TEXTINFLATETOP: typing.ClassVar[int] = ...
    ST_TEXTDEFLATETOP: typing.ClassVar[int] = ...
    ST_TEXTDEFLATEINFLATE: typing.ClassVar[int] = ...
    ST_TEXTDEFLATEINFLATEDEFLATE: typing.ClassVar[int] = ...
    ST_TEXTFADERIGHT: typing.ClassVar[int] = ...
    ST_TEXTFADELEFT: typing.ClassVar[int] = ...
    ST_TEXTFADEUP: typing.ClassVar[int] = ...
    ST_TEXTFADEDOWN: typing.ClassVar[int] = ...
    ST_TEXTSLANTUP: typing.ClassVar[int] = ...
    ST_TEXTSLANTDOWN: typing.ClassVar[int] = ...
    ST_TEXTCANUP: typing.ClassVar[int] = ...
    ST_TEXTCANDOWN: typing.ClassVar[int] = ...
    ST_FLOWCHARTALTERNATEPROCESS: typing.ClassVar[int] = ...
    ST_FLOWCHARTOFFPAGECONNECTOR: typing.ClassVar[int] = ...
    ST_CALLOUT90: typing.ClassVar[int] = ...
    ST_ACCENTCALLOUT90: typing.ClassVar[int] = ...
    ST_BORDERCALLOUT90: typing.ClassVar[int] = ...
    ST_ACCENTBORDERCALLOUT90: typing.ClassVar[int] = ...
    ST_LEFTRIGHTUPARROW: typing.ClassVar[int] = ...
    ST_SUN: typing.ClassVar[int] = ...
    ST_MOON: typing.ClassVar[int] = ...
    ST_BRACKETPAIR: typing.ClassVar[int] = ...
    ST_BRACEPAIR: typing.ClassVar[int] = ...
    ST_SEAL4: typing.ClassVar[int] = ...
    ST_DOUBLEWAVE: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONBLANK: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONHOME: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONHELP: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONINFORMATION: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONFORWARDNEXT: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONBACKPREVIOUS: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONEND: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONBEGINNING: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONRETURN: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONDOCUMENT: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONSOUND: typing.ClassVar[int] = ...
    ST_ACTIONBUTTONMOVIE: typing.ClassVar[int] = ...
    ST_HOSTCONTROL: typing.ClassVar[int] = ...
    ST_TEXTBOX: typing.ClassVar[int] = ...
    ST_NIL: typing.ClassVar[int] = ...
    def __init__(self, drawingManager2: bioformats_jar._loci.poi.hssf.model.DrawingManager2): ...
    def assoicateShapeToObjRecord(self, escherRecord: bioformats_jar._loci.poi.ddf.EscherRecord, record: Record) -> typing.Any: ...
    def clear(self) -> None: ...
    @staticmethod
    def createAggregate(list: java.util.List, int: int, drawingManager2: bioformats_jar._loci.poi.hssf.model.DrawingManager2) -> 'EscherAggregate': ...
    def getPatriarch(self) -> bioformats_jar._loci.poi.hssf.usermodel.HSSFPatriarch: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setPatriarch(self, hSSFPatriarch: bioformats_jar._loci.poi.hssf.usermodel.HSSFPatriarch) -> None: ...
    def toString(self) -> java.lang.String: ...

class GroupMarkerSubRecord(SubRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class HorizontalPageBreakRecord(PageBreakRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int): ...
    def getSid(self) -> int: ...

class NoteStructureSubRecord(SubRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getSid(self) -> int: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def toString(self) -> java.lang.String: ...

class TextObjectRecord(TextObjectBaseRecord):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    def getRecordSize(self) -> int: ...
    def getStr(self) -> bioformats_jar._loci.poi.hssf.usermodel.HSSFRichTextString: ...
    @typing.overload
    def serialize(self) -> typing.List[int]: ...
    @typing.overload
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setStr(self, hSSFRichTextString: bioformats_jar._loci.poi.hssf.usermodel.HSSFRichTextString) -> None: ...
    def toString(self) -> java.lang.String: ...

class VerticalPageBreakRecord(PageBreakRecord):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int): ...
    def getSid(self) -> int: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.hssf.record")``.

    AbstractEscherHolderRecord: typing.Type[AbstractEscherHolderRecord]
    AreaFormatRecord: typing.Type[AreaFormatRecord]
    AreaRecord: typing.Type[AreaRecord]
    AxisLineFormatRecord: typing.Type[AxisLineFormatRecord]
    AxisOptionsRecord: typing.Type[AxisOptionsRecord]
    AxisParentRecord: typing.Type[AxisParentRecord]
    AxisRecord: typing.Type[AxisRecord]
    AxisUsedRecord: typing.Type[AxisUsedRecord]
    BOFRecord: typing.Type[BOFRecord]
    BackupRecord: typing.Type[BackupRecord]
    BarRecord: typing.Type[BarRecord]
    BeginRecord: typing.Type[BeginRecord]
    BlankRecord: typing.Type[BlankRecord]
    BookBoolRecord: typing.Type[BookBoolRecord]
    BoolErrRecord: typing.Type[BoolErrRecord]
    BottomMarginRecord: typing.Type[BottomMarginRecord]
    BoundSheetRecord: typing.Type[BoundSheetRecord]
    CalcCountRecord: typing.Type[CalcCountRecord]
    CalcModeRecord: typing.Type[CalcModeRecord]
    CategorySeriesAxisRecord: typing.Type[CategorySeriesAxisRecord]
    CellValueRecordInterface: typing.Type[CellValueRecordInterface]
    ChartFormatRecord: typing.Type[ChartFormatRecord]
    ChartRecord: typing.Type[ChartRecord]
    CodepageRecord: typing.Type[CodepageRecord]
    ColumnInfoRecord: typing.Type[ColumnInfoRecord]
    CommonObjectDataSubRecord: typing.Type[CommonObjectDataSubRecord]
    ContinueRecord: typing.Type[ContinueRecord]
    CountryRecord: typing.Type[CountryRecord]
    CustomField: typing.Type[CustomField]
    DBCellRecord: typing.Type[DBCellRecord]
    DSFRecord: typing.Type[DSFRecord]
    DatRecord: typing.Type[DatRecord]
    DataFormatRecord: typing.Type[DataFormatRecord]
    DateWindow1904Record: typing.Type[DateWindow1904Record]
    DefaultColWidthRecord: typing.Type[DefaultColWidthRecord]
    DefaultDataLabelTextPropertiesRecord: typing.Type[DefaultDataLabelTextPropertiesRecord]
    DefaultRowHeightRecord: typing.Type[DefaultRowHeightRecord]
    DeltaRecord: typing.Type[DeltaRecord]
    DimensionsRecord: typing.Type[DimensionsRecord]
    DrawingGroupRecord: typing.Type[DrawingGroupRecord]
    DrawingRecord: typing.Type[DrawingRecord]
    DrawingRecordForBiffViewer: typing.Type[DrawingRecordForBiffViewer]
    DrawingSelectionRecord: typing.Type[DrawingSelectionRecord]
    EOFRecord: typing.Type[EOFRecord]
    EmbeddedObjectRefSubRecord: typing.Type[EmbeddedObjectRefSubRecord]
    EndRecord: typing.Type[EndRecord]
    EndSubRecord: typing.Type[EndSubRecord]
    EscherAggregate: typing.Type[EscherAggregate]
    ExtSSTInfoSubRecord: typing.Type[ExtSSTInfoSubRecord]
    ExtSSTRecord: typing.Type[ExtSSTRecord]
    ExtendedFormatRecord: typing.Type[ExtendedFormatRecord]
    ExternSheetRecord: typing.Type[ExternSheetRecord]
    ExternSheetSubRecord: typing.Type[ExternSheetSubRecord]
    FilePassRecord: typing.Type[FilePassRecord]
    FileSharingRecord: typing.Type[FileSharingRecord]
    FnGroupCountRecord: typing.Type[FnGroupCountRecord]
    FontBasisRecord: typing.Type[FontBasisRecord]
    FontIndexRecord: typing.Type[FontIndexRecord]
    FontRecord: typing.Type[FontRecord]
    FooterRecord: typing.Type[FooterRecord]
    FormatRecord: typing.Type[FormatRecord]
    FormulaRecord: typing.Type[FormulaRecord]
    FrameRecord: typing.Type[FrameRecord]
    GridsetRecord: typing.Type[GridsetRecord]
    GroupMarkerSubRecord: typing.Type[GroupMarkerSubRecord]
    GutsRecord: typing.Type[GutsRecord]
    HCenterRecord: typing.Type[HCenterRecord]
    HeaderRecord: typing.Type[HeaderRecord]
    HideObjRecord: typing.Type[HideObjRecord]
    HorizontalPageBreakRecord: typing.Type[HorizontalPageBreakRecord]
    IndexRecord: typing.Type[IndexRecord]
    InterfaceEndRecord: typing.Type[InterfaceEndRecord]
    InterfaceHdrRecord: typing.Type[InterfaceHdrRecord]
    IterationRecord: typing.Type[IterationRecord]
    LabelRecord: typing.Type[LabelRecord]
    LabelSSTRecord: typing.Type[LabelSSTRecord]
    LeftMarginRecord: typing.Type[LeftMarginRecord]
    LegendRecord: typing.Type[LegendRecord]
    LineFormatRecord: typing.Type[LineFormatRecord]
    LinkedDataFormulaField: typing.Type[LinkedDataFormulaField]
    LinkedDataRecord: typing.Type[LinkedDataRecord]
    MMSRecord: typing.Type[MMSRecord]
    Margin: typing.Type[Margin]
    MergeCellsRecord: typing.Type[MergeCellsRecord]
    MulBlankRecord: typing.Type[MulBlankRecord]
    MulRKRecord: typing.Type[MulRKRecord]
    NameRecord: typing.Type[NameRecord]
    NoteRecord: typing.Type[NoteRecord]
    NoteStructureSubRecord: typing.Type[NoteStructureSubRecord]
    NumberFormatIndexRecord: typing.Type[NumberFormatIndexRecord]
    NumberRecord: typing.Type[NumberRecord]
    ObjRecord: typing.Type[ObjRecord]
    ObjectLinkRecord: typing.Type[ObjectLinkRecord]
    ObjectProtectRecord: typing.Type[ObjectProtectRecord]
    PageBreakRecord: typing.Type[PageBreakRecord]
    PaletteRecord: typing.Type[PaletteRecord]
    PaneRecord: typing.Type[PaneRecord]
    PasswordRecord: typing.Type[PasswordRecord]
    PasswordRev4Record: typing.Type[PasswordRev4Record]
    PlotAreaRecord: typing.Type[PlotAreaRecord]
    PlotGrowthRecord: typing.Type[PlotGrowthRecord]
    PrecisionRecord: typing.Type[PrecisionRecord]
    PrintGridlinesRecord: typing.Type[PrintGridlinesRecord]
    PrintHeadersRecord: typing.Type[PrintHeadersRecord]
    PrintSetupRecord: typing.Type[PrintSetupRecord]
    ProtectRecord: typing.Type[ProtectRecord]
    ProtectionRev4Record: typing.Type[ProtectionRev4Record]
    RKRecord: typing.Type[RKRecord]
    RecalcIdRecord: typing.Type[RecalcIdRecord]
    Record: typing.Type[Record]
    RecordFactory: typing.Type[RecordFactory]
    RecordFormatException: typing.Type[RecordFormatException]
    RecordInputStream: typing.Type[RecordInputStream]
    RefModeRecord: typing.Type[RefModeRecord]
    RefreshAllRecord: typing.Type[RefreshAllRecord]
    RightMarginRecord: typing.Type[RightMarginRecord]
    RowRecord: typing.Type[RowRecord]
    SCLRecord: typing.Type[SCLRecord]
    SSTRecord: typing.Type[SSTRecord]
    SaveRecalcRecord: typing.Type[SaveRecalcRecord]
    ScenarioProtectRecord: typing.Type[ScenarioProtectRecord]
    SelectionRecord: typing.Type[SelectionRecord]
    SeriesChartGroupIndexRecord: typing.Type[SeriesChartGroupIndexRecord]
    SeriesIndexRecord: typing.Type[SeriesIndexRecord]
    SeriesLabelsRecord: typing.Type[SeriesLabelsRecord]
    SeriesListRecord: typing.Type[SeriesListRecord]
    SeriesRecord: typing.Type[SeriesRecord]
    SeriesTextRecord: typing.Type[SeriesTextRecord]
    SeriesToChartGroupRecord: typing.Type[SeriesToChartGroupRecord]
    SharedFormulaRecord: typing.Type[SharedFormulaRecord]
    SheetPropertiesRecord: typing.Type[SheetPropertiesRecord]
    StringRecord: typing.Type[StringRecord]
    StyleRecord: typing.Type[StyleRecord]
    SubRecord: typing.Type[SubRecord]
    SupBookRecord: typing.Type[SupBookRecord]
    TabIdRecord: typing.Type[TabIdRecord]
    TextObjectBaseRecord: typing.Type[TextObjectBaseRecord]
    TextObjectRecord: typing.Type[TextObjectRecord]
    TextRecord: typing.Type[TextRecord]
    TickRecord: typing.Type[TickRecord]
    TopMarginRecord: typing.Type[TopMarginRecord]
    UnicodeString: typing.Type[UnicodeString]
    UnitsRecord: typing.Type[UnitsRecord]
    UnknownRecord: typing.Type[UnknownRecord]
    UseSelFSRecord: typing.Type[UseSelFSRecord]
    VCenterRecord: typing.Type[VCenterRecord]
    ValueRangeRecord: typing.Type[ValueRangeRecord]
    VerticalPageBreakRecord: typing.Type[VerticalPageBreakRecord]
    WSBoolRecord: typing.Type[WSBoolRecord]
    WindowOneRecord: typing.Type[WindowOneRecord]
    WindowProtectRecord: typing.Type[WindowProtectRecord]
    WindowTwoRecord: typing.Type[WindowTwoRecord]
    WriteAccessRecord: typing.Type[WriteAccessRecord]
    WriteProtectRecord: typing.Type[WriteProtectRecord]
    aggregates: bioformats_jar._loci.poi.hssf.record.aggregates.__module_protocol__
    formula: bioformats_jar._loci.poi.hssf.record.formula.__module_protocol__
