import ch.systemsx.cisd.base.mdarray
import ch.systemsx.cisd.hdf5
import com.esotericsoftware.kryo
import com.esotericsoftware.kryo.io
import java.awt.image
import java.io
import java.lang
import java.util
import bioformats_jar._loci.common
import bioformats_jar._loci.common.services
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.codec
import bioformats_jar._loci.formats.meta
import bioformats_jar._loci.formats.ome
import ome.xml.model
import org.w3c.dom
import typing



class EXIFService(loci.common.services.Service):
    def close(self) -> None: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getTags(self) -> java.util.HashMap[java.lang.String, java.lang.String]: ...
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...

class JAIIIOService(loci.common.services.Service):
    @typing.overload
    def readImage(self, inputStream: java.io.InputStream) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def readImage(self, inputStream: java.io.InputStream, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def readRaster(self, inputStream: java.io.InputStream) -> java.awt.image.Raster: ...
    @typing.overload
    def readRaster(self, inputStream: java.io.InputStream, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> java.awt.image.Raster: ...
    def writeImage(self, outputStream: java.io.OutputStream, bufferedImage: java.awt.image.BufferedImage, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> None: ...

class JHDFService(loci.common.services.Service):
    def close(self) -> None: ...
    def createGroup(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def exists(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def getElementSize(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getFile(self) -> java.lang.String: ...
    def getMember(self, string: typing.Union[java.lang.String, str]) -> java.util.List[java.lang.String]: ...
    def getShape(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def initIntArray(self, string: typing.Union[java.lang.String, str], longArray: typing.List[int], long2: int) -> None: ...
    def readByteArray(self, string: typing.Union[java.lang.String, str]) -> ch.systemsx.cisd.base.mdarray.MDByteArray: ...
    def readByteBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDByteArray: ...
    def readCompoundArrayDataMap(self, string: typing.Union[java.lang.String, str]) -> typing.List[ch.systemsx.cisd.hdf5.HDF5CompoundDataMap]: ...
    def readIntArray(self, string: typing.Union[java.lang.String, str]) -> ch.systemsx.cisd.base.mdarray.MDIntArray: ...
    def readIntBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDIntArray: ...
    def readShortBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDShortArray: ...
    def readStringArray(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def setFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFileForWrite(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDByteArray: ch.systemsx.cisd.base.mdarray.MDByteArray, longArray: typing.List[int]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDIntArray: ch.systemsx.cisd.base.mdarray.MDIntArray, longArray: typing.List[int]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDShortArray: ch.systemsx.cisd.base.mdarray.MDShortArray, longArray: typing.List[int]) -> None: ...

class JPEGTurboService(loci.common.services.Service):
    def close(self) -> None: ...
    def getRestartMarkers(self) -> typing.List[int]: ...
    @typing.overload
    def getTile(self, byteArray: typing.List[int], int: int, int2: int, int3: int, int4: int) -> typing.List[int]: ...
    @typing.overload
    def getTile(self, int: int, int2: int) -> typing.List[int]: ...
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, int2: int) -> None: ...
    def setRestartMarkers(self, longArray: typing.List[int]) -> None: ...

class JPEGXRService(loci.common.services.Service):
    def decompress(self, byteArray: typing.List[int]) -> typing.List[int]: ...

class LuraWaveService(loci.common.services.Service):
    def decodeToMemoryGray16(self, shortArray: typing.List[int], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, int9: int, int10: int) -> None: ...
    def decodeToMemoryGray8(self, byteArray: typing.List[int], int: int, int2: int, int3: int) -> None: ...
    def getHeight(self) -> int: ...
    def getLicenseCode(self) -> java.lang.String: ...
    def getWidth(self) -> int: ...
    def initialize(self, inputStream: java.io.InputStream) -> None: ...
    def setLicenseCode(self, string: typing.Union[java.lang.String, str]) -> None: ...

class MDBService(loci.common.services.Service):
    def close(self) -> None: ...
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def parseDatabase(self) -> java.util.Vector[java.util.Vector[typing.List[java.lang.String]]]: ...
    def parseTable(self, string: typing.Union[java.lang.String, str]) -> java.util.Vector[typing.List[java.lang.String]]: ...

class MetakitService(loci.common.services.Service):
    def close(self) -> None: ...
    def getColumNames(self, int: int) -> typing.List[java.lang.String]: ...
    def getColumnNames(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getColumnTypes(self, int: int) -> typing.List[typing.Type]: ...
    @typing.overload
    def getColumnTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[typing.Type]: ...
    @typing.overload
    def getRowCount(self, int: int) -> int: ...
    @typing.overload
    def getRowCount(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getRowData(self, int: int, int2: int) -> typing.List[typing.Any]: ...
    @typing.overload
    def getRowData(self, int: int, string: typing.Union[java.lang.String, str]) -> typing.List[typing.Any]: ...
    def getTableCount(self) -> int: ...
    @typing.overload
    def getTableData(self, int: int) -> typing.List[typing.List[typing.Any]]: ...
    @typing.overload
    def getTableData(self, string: typing.Union[java.lang.String, str]) -> typing.List[typing.List[typing.Any]]: ...
    def getTableNames(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...

class NetCDFService(loci.common.services.Service):
    def close(self) -> None: ...
    def getArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> typing.Any: ...
    def getAttributeList(self) -> java.util.Vector[java.lang.String]: ...
    def getAttributeValue(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def getDimension(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getFile(self) -> java.lang.String: ...
    def getVariableAttributes(self, string: typing.Union[java.lang.String, str]) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getVariableList(self) -> java.util.Vector[java.lang.String]: ...
    def getVariableValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def setFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OMEXMLService(loci.common.services.Service):
    @typing.overload
    def addMetadataOnly(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> None: ...
    @typing.overload
    def addMetadataOnly(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int, boolean: bool) -> None: ...
    def addModuloAlong(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, coreMetadata: bioformats_jar._loci.formats.CoreMetadata, int: int) -> None: ...
    def asRetrieve(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    def asStore(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    @typing.overload
    def convertMetadata(self, string: typing.Union[java.lang.String, str], metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    @typing.overload
    def convertMetadata(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    @typing.overload
    def createOMEXMLMetadata(self) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    @typing.overload
    def createOMEXMLMetadata(self, string: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    @typing.overload
    def createOMEXMLMetadata(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    def createOMEXMLRoot(self, string: typing.Union[java.lang.String, str]) -> ome.xml.model.OMEModelObject: ...
    def getLatestVersion(self) -> java.lang.String: ...
    def getModuloAlongC(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getModuloAlongT(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getModuloAlongZ(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getOMEMetadata(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    def getOMEXML(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> java.lang.String: ...
    def getOMEXMLVersion(self, object: typing.Any) -> java.lang.String: ...
    def getOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> java.util.Hashtable: ...
    def isEqual(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, oMEXMLMetadata2: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> bool: ...
    def isOMEXMLMetadata(self, object: typing.Any) -> bool: ...
    def isOMEXMLRoot(self, object: typing.Any) -> bool: ...
    @typing.overload
    def populateOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def populateOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, hashtable: java.util.Hashtable[typing.Union[java.lang.String, str], typing.Any]) -> None: ...
    def removeBinData(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> None: ...
    def removeChannels(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int, int2: int) -> None: ...
    def removeTiffData(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> None: ...
    def transformToLatestVersion(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def validateOMEXML(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def validateOMEXML(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...

class POIService(loci.common.services.Service):
    def close(self) -> None: ...
    @typing.overload
    def getDocumentBytes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def getDocumentBytes(self, string: typing.Union[java.lang.String, str], int: int) -> typing.List[int]: ...
    def getDocumentList(self) -> java.util.Vector[java.lang.String]: ...
    def getDocumentStream(self, string: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    def getFileSize(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getInputStream(self, string: typing.Union[java.lang.String, str]) -> java.io.InputStream: ...
    @typing.overload
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...

class WlzService(loci.common.services.Service):
    def close(self) -> None: ...
    def getNoWlzMsg(self) -> java.lang.String: ...
    def getOrgX(self) -> float: ...
    def getOrgY(self) -> float: ...
    def getOrgZ(self) -> float: ...
    def getPixelType(self) -> int: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getSupPixelTypes(self) -> typing.List[int]: ...
    def getVoxSzX(self) -> float: ...
    def getVoxSzY(self) -> float: ...
    def getVoxSzZ(self) -> float: ...
    def getWlzOrgLabelName(self) -> java.lang.String: ...
    def isRGB(self) -> bool: ...
    def open(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def readBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setupWrite(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, double: float, double2: float, double3: float, int9: int) -> None: ...

class EXIFServiceImpl(loci.common.services.AbstractService, EXIFService):
    def __init__(self): ...
    def close(self) -> None: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getTags(self) -> java.util.HashMap[java.lang.String, java.lang.String]: ...
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...

class JAIIIOServiceImpl(loci.common.services.AbstractService, JAIIIOService):
    NO_J2K_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def readImage(self, inputStream: java.io.InputStream) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def readImage(self, inputStream: java.io.InputStream, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def readRaster(self, inputStream: java.io.InputStream) -> java.awt.image.Raster: ...
    @typing.overload
    def readRaster(self, inputStream: java.io.InputStream, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> java.awt.image.Raster: ...
    def writeImage(self, outputStream: java.io.OutputStream, bufferedImage: java.awt.image.BufferedImage, jPEG2000CodecOptions: bioformats_jar._loci.formats.codec.JPEG2000CodecOptions) -> None: ...

class JHDFServiceImpl(loci.common.services.AbstractService, JHDFService):
    NO_JHDF_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def close(self) -> None: ...
    def createGroup(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def exists(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def getElementSize(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getFile(self) -> java.lang.String: ...
    def getMember(self, string: typing.Union[java.lang.String, str]) -> java.util.List[java.lang.String]: ...
    def getShape(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def initIntArray(self, string: typing.Union[java.lang.String, str], longArray: typing.List[int], long2: int) -> None: ...
    def readByteArray(self, string: typing.Union[java.lang.String, str]) -> ch.systemsx.cisd.base.mdarray.MDByteArray: ...
    def readByteBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDByteArray: ...
    def readCompoundArrayDataMap(self, string: typing.Union[java.lang.String, str]) -> typing.List[ch.systemsx.cisd.hdf5.HDF5CompoundDataMap]: ...
    def readIntArray(self, string: typing.Union[java.lang.String, str]) -> ch.systemsx.cisd.base.mdarray.MDIntArray: ...
    def readIntBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDIntArray: ...
    def readShortBlockArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> ch.systemsx.cisd.base.mdarray.MDShortArray: ...
    def readStringArray(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def setFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFileForWrite(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDByteArray: ch.systemsx.cisd.base.mdarray.MDByteArray, longArray: typing.List[int]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDIntArray: ch.systemsx.cisd.base.mdarray.MDIntArray, longArray: typing.List[int]) -> None: ...
    @typing.overload
    def writeArraySlice(self, string: typing.Union[java.lang.String, str], mDShortArray: ch.systemsx.cisd.base.mdarray.MDShortArray, longArray: typing.List[int]) -> None: ...

class JPEGTurboServiceImpl(JPEGTurboService):
    def __init__(self): ...
    def close(self) -> None: ...
    def getRestartMarkers(self) -> typing.List[int]: ...
    @typing.overload
    def getTile(self, byteArray: typing.List[int], int: int, int2: int, int3: int, int4: int) -> typing.List[int]: ...
    @typing.overload
    def getTile(self, int: int, int2: int) -> typing.List[int]: ...
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, int2: int) -> None: ...
    def setRestartMarkers(self, longArray: typing.List[int]) -> None: ...

class JPEGXRServiceImpl(loci.common.services.AbstractService, JPEGXRService):
    def __init__(self): ...
    def decompress(self, byteArray: typing.List[int]) -> typing.List[int]: ...

class LuraWaveServiceImpl(loci.common.services.AbstractService, LuraWaveService):
    LICENSE_PROPERTY: typing.ClassVar[java.lang.String] = ...
    NO_LURAWAVE_MSG: typing.ClassVar[java.lang.String] = ...
    NO_LICENSE_MSG: typing.ClassVar[java.lang.String] = ...
    INVALID_LICENSE_MSG: typing.ClassVar[java.lang.String] = ...
    STUB_FIELD: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def decodeToMemoryGray16(self, shortArray: typing.List[int], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, int9: int, int10: int) -> None: ...
    def decodeToMemoryGray8(self, byteArray: typing.List[int], int: int, int2: int, int3: int) -> None: ...
    def getHeight(self) -> int: ...
    def getLicenseCode(self) -> java.lang.String: ...
    def getWidth(self) -> int: ...
    def initialize(self, inputStream: java.io.InputStream) -> None: ...
    def setLicenseCode(self, string: typing.Union[java.lang.String, str]) -> None: ...

class MDBServiceImpl(loci.common.services.AbstractService, MDBService):
    def __init__(self): ...
    def close(self) -> None: ...
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def parseDatabase(self) -> java.util.Vector[java.util.Vector[typing.List[java.lang.String]]]: ...
    def parseTable(self, string: typing.Union[java.lang.String, str]) -> java.util.Vector[typing.List[java.lang.String]]: ...

class MetakitServiceImpl(MetakitService):
    def __init__(self): ...
    def close(self) -> None: ...
    def getColumNames(self, int: int) -> typing.List[java.lang.String]: ...
    def getColumnNames(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getColumnTypes(self, int: int) -> typing.List[typing.Type]: ...
    @typing.overload
    def getColumnTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[typing.Type]: ...
    @typing.overload
    def getRowCount(self, int: int) -> int: ...
    @typing.overload
    def getRowCount(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getRowData(self, int: int, int2: int) -> typing.List[typing.Any]: ...
    @typing.overload
    def getRowData(self, int: int, string: typing.Union[java.lang.String, str]) -> typing.List[typing.Any]: ...
    def getTableCount(self) -> int: ...
    @typing.overload
    def getTableData(self, int: int) -> typing.List[typing.List[typing.Any]]: ...
    @typing.overload
    def getTableData(self, string: typing.Union[java.lang.String, str]) -> typing.List[typing.List[typing.Any]]: ...
    def getTableNames(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...

class NetCDFServiceImpl(loci.common.services.AbstractService, NetCDFService, com.esotericsoftware.kryo.KryoSerializable):
    NO_NETCDF_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def close(self) -> None: ...
    def getArray(self, string: typing.Union[java.lang.String, str], intArray: typing.List[int], intArray2: typing.List[int]) -> typing.Any: ...
    def getAttributeList(self) -> java.util.Vector[java.lang.String]: ...
    def getAttributeValue(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def getDimension(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getFile(self) -> java.lang.String: ...
    def getVariableAttributes(self, string: typing.Union[java.lang.String, str]) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getVariableList(self) -> java.util.Vector[java.lang.String]: ...
    def getVariableValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def read(self, kryo: com.esotericsoftware.kryo.Kryo, input: com.esotericsoftware.kryo.io.Input) -> None: ...
    def setFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def write(self, kryo: com.esotericsoftware.kryo.Kryo, output: com.esotericsoftware.kryo.io.Output) -> None: ...

class OMEXMLServiceImpl(loci.common.services.AbstractService, OMEXMLService):
    LATEST_VERSION: typing.ClassVar[java.lang.String] = ...
    NO_OME_XML_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def addMetadataOnly(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> None: ...
    @typing.overload
    def addMetadataOnly(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int, boolean: bool) -> None: ...
    def addModuloAlong(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, coreMetadata: bioformats_jar._loci.formats.CoreMetadata, int: int) -> None: ...
    def asRetrieve(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    def asStore(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    @typing.overload
    def convertMetadata(self, string: typing.Union[java.lang.String, str], metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    @typing.overload
    def convertMetadata(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    @typing.overload
    def createOMEXMLMetadata(self) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    @typing.overload
    def createOMEXMLMetadata(self, string: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    @typing.overload
    def createOMEXMLMetadata(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    def createOMEXMLRoot(self, string: typing.Union[java.lang.String, str]) -> ome.xml.model.OMEModelObject: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, node: org.w3c.dom.Node, node2: org.w3c.dom.Node) -> bool: ...
    def getLatestVersion(self) -> java.lang.String: ...
    def getModuloAlongC(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getModuloAlongT(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getModuloAlongZ(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int) -> bioformats_jar._loci.formats.Modulo: ...
    def getOMEMetadata(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    def getOMEXML(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> java.lang.String: ...
    def getOMEXMLVersion(self, object: typing.Any) -> java.lang.String: ...
    def getOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> java.util.Hashtable: ...
    def isEqual(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, oMEXMLMetadata2: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> bool: ...
    def isOMEXMLMetadata(self, object: typing.Any) -> bool: ...
    def isOMEXMLRoot(self, object: typing.Any) -> bool: ...
    @typing.overload
    def populateOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def populateOriginalMetadata(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, hashtable: java.util.Hashtable[typing.Union[java.lang.String, str], typing.Any]) -> None: ...
    def removeBinData(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> None: ...
    def removeChannels(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, int: int, int2: int) -> None: ...
    def removeTiffData(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata) -> None: ...
    def transformToLatestVersion(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def validateOMEXML(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def validateOMEXML(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...

class POIServiceImpl(loci.common.services.AbstractService, POIService):
    def __init__(self): ...
    def close(self) -> None: ...
    @typing.overload
    def getDocumentBytes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def getDocumentBytes(self, string: typing.Union[java.lang.String, str], int: int) -> typing.List[int]: ...
    def getDocumentList(self) -> java.util.Vector[java.lang.String]: ...
    def getDocumentStream(self, string: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    def getFileSize(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getInputStream(self, string: typing.Union[java.lang.String, str]) -> java.io.InputStream: ...
    @typing.overload
    def initialize(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initialize(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...

class WlzServiceImpl(loci.common.services.AbstractService, WlzService):
    WLZ_ORG_LABEL: typing.ClassVar[java.lang.String] = ...
    NO_WLZ_MSG: typing.ClassVar[java.lang.String] = ...
    WLZ_SERVICE_UNKNOWN: typing.ClassVar[int] = ...
    WLZ_SERVICE_READ: typing.ClassVar[int] = ...
    WLZ_SERVICE_WRITE: typing.ClassVar[int] = ...
    def __init__(self): ...
    def close(self) -> None: ...
    def getNoWlzMsg(self) -> java.lang.String: ...
    def getOrgX(self) -> float: ...
    def getOrgY(self) -> float: ...
    def getOrgZ(self) -> float: ...
    def getPixelType(self) -> int: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getSupPixelTypes(self) -> typing.List[int]: ...
    def getVoxSzX(self) -> float: ...
    def getVoxSzY(self) -> float: ...
    def getVoxSzZ(self) -> float: ...
    def getWlzOrgLabelName(self) -> java.lang.String: ...
    def isRGB(self) -> bool: ...
    def open(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def readBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setupWrite(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, double: float, double2: float, double3: float, int9: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.services")``.

    EXIFService: typing.Type[EXIFService]
    EXIFServiceImpl: typing.Type[EXIFServiceImpl]
    JAIIIOService: typing.Type[JAIIIOService]
    JAIIIOServiceImpl: typing.Type[JAIIIOServiceImpl]
    JHDFService: typing.Type[JHDFService]
    JHDFServiceImpl: typing.Type[JHDFServiceImpl]
    JPEGTurboService: typing.Type[JPEGTurboService]
    JPEGTurboServiceImpl: typing.Type[JPEGTurboServiceImpl]
    JPEGXRService: typing.Type[JPEGXRService]
    JPEGXRServiceImpl: typing.Type[JPEGXRServiceImpl]
    LuraWaveService: typing.Type[LuraWaveService]
    LuraWaveServiceImpl: typing.Type[LuraWaveServiceImpl]
    MDBService: typing.Type[MDBService]
    MDBServiceImpl: typing.Type[MDBServiceImpl]
    MetakitService: typing.Type[MetakitService]
    MetakitServiceImpl: typing.Type[MetakitServiceImpl]
    NetCDFService: typing.Type[NetCDFService]
    NetCDFServiceImpl: typing.Type[NetCDFServiceImpl]
    OMEXMLService: typing.Type[OMEXMLService]
    OMEXMLServiceImpl: typing.Type[OMEXMLServiceImpl]
    POIService: typing.Type[POIService]
    POIServiceImpl: typing.Type[POIServiceImpl]
    WlzService: typing.Type[WlzService]
    WlzServiceImpl: typing.Type[WlzServiceImpl]
