import ch.qos.logback.classic.spi
import ch.qos.logback.core
import com.esotericsoftware.kryo
import com.esotericsoftware.kryo.io
import java.io
import java.lang
import java.net
import java.nio
import java.nio.channels
import java.util
import java.util.zip
import jpype.protocol
import bioformats_jar._loci.common.enumeration
import bioformats_jar._loci.common.image
import bioformats_jar._loci.common.services
import bioformats_jar._loci.common.xml
import typing



class CBZip2InputStream(java.io.InputStream):
    def __init__(self, inputStream: java.io.InputStream): ...
    def close(self) -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...

class CRC:
    CRC_32_TABLE: typing.ClassVar[typing.List[int]] = ...
    def __init__(self): ...
    def getFinalCRC(self) -> int: ...
    def getGlobalCRC(self) -> int: ...
    def initialiseCRC(self) -> None: ...
    def setGlobalCRC(self, int: int) -> None: ...
    def updateCRC(self, int: int) -> None: ...

class Constants:
    ENCODING: typing.ClassVar[java.lang.String] = ...
    EPSILON: typing.ClassVar[float] = ...
    def __init__(self): ...

class DataTools:
    @staticmethod
    def allocate(intArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(byteArray: typing.List[int], boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(byteArray: typing.List[int], int: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(shortArray: typing.List[int], boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(shortArray: typing.List[int], int: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToDouble(shortArray: typing.List[int], int: int, int2: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(byteArray: typing.List[int], boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(byteArray: typing.List[int], int: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(shortArray: typing.List[int], boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(shortArray: typing.List[int], int: int, boolean: bool) -> float: ...
    @typing.overload
    @staticmethod
    def bytesToFloat(shortArray: typing.List[int], int: int, int2: int, boolean: bool) -> float: ...
    @staticmethod
    def bytesToHex(byteArray: typing.List[int]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def bytesToInt(byteArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToInt(byteArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToInt(byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToInt(shortArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToInt(shortArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToInt(shortArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(byteArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(byteArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(shortArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(shortArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToLong(shortArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(byteArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(byteArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(shortArray: typing.List[int], boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(shortArray: typing.List[int], int: int, boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def bytesToShort(shortArray: typing.List[int], int: int, int2: int, boolean: bool) -> int: ...
    @staticmethod
    def containsValue(intArray: typing.List[int], int2: int) -> bool: ...
    @staticmethod
    def doubleToBytes(double: float, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def doublesToBytes(doubleArray: typing.List[float], boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def floatToBytes(float: float, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def floatsToBytes(floatArray: typing.List[float], boolean: bool) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def indexOf(intArray: typing.List[int], int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def indexOf(objectArray: typing.List[typing.Any], object2: typing.Any) -> int: ...
    @staticmethod
    def intToBytes(int: int, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def intsToBytes(intArray: typing.List[int], boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def longToBytes(long: int, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def longsToBytes(longArray: typing.List[int], boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def makeDataArray(byteArray: typing.List[int], int: int, boolean: bool, boolean2: bool) -> typing.Any: ...
    @staticmethod
    def makeDataArray2D(byteArray: typing.List[int], int: int, boolean: bool, boolean2: bool, int2: int) -> typing.Any: ...
    @typing.overload
    @staticmethod
    def makeSigned(byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def makeSigned(intArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def makeSigned(shortArray: typing.List[int]) -> typing.List[int]: ...
    @staticmethod
    def normalizeDoubles(doubleArray: typing.List[float]) -> typing.List[float]: ...
    @staticmethod
    def normalizeFloats(floatArray: typing.List[float]) -> typing.List[float]: ...
    @staticmethod
    def parseByte(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def parseDouble(string: typing.Union[java.lang.String, str]) -> float: ...
    @staticmethod
    def parseFloat(string: typing.Union[java.lang.String, str]) -> float: ...
    @staticmethod
    def parseInteger(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def parseLong(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def parseShort(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def readFile(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def safeMultiply32(intArray: typing.List[int]) -> int: ...
    @staticmethod
    def safeMultiply64(longArray: typing.List[int]) -> int: ...
    @staticmethod
    def samePrefix(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    @staticmethod
    def sanitize(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def sanitizeDouble(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def shortToBytes(short: int, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def shortsToBytes(shortArray: typing.List[int], boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def stripString(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def swap(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def swap(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def swap(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def swap(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def swap(long: int) -> int: ...
    @typing.overload
    @staticmethod
    def swap(short: int) -> int: ...
    @staticmethod
    def unpackBytes(long: int, byteArray: typing.List[int], int: int, int2: int, boolean: bool) -> None: ...

class DateTools:
    UNIX: typing.ClassVar[int] = ...
    COBOL: typing.ClassVar[int] = ...
    MICROSOFT: typing.ClassVar[int] = ...
    ZVI: typing.ClassVar[int] = ...
    ALT_ZVI: typing.ClassVar[int] = ...
    UNIX_EPOCH: typing.ClassVar[int] = ...
    COBOL_EPOCH: typing.ClassVar[int] = ...
    MICROSOFT_EPOCH: typing.ClassVar[int] = ...
    ZVI_EPOCH: typing.ClassVar[int] = ...
    ALT_ZVI_EPOCH: typing.ClassVar[int] = ...
    ISO8601_FORMAT_MS: typing.ClassVar[java.lang.String] = ...
    ISO8601_FORMAT: typing.ClassVar[java.lang.String] = ...
    TIMESTAMP_FORMAT: typing.ClassVar[java.lang.String] = ...
    FILENAME_FORMAT: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    @staticmethod
    def convertDate(long: int, int: int) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def convertDate(long: int, int: int, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def convertDate(long: int, int: int, string: typing.Union[java.lang.String, str], boolean: bool) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool, string3: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String], boolean: bool) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String], boolean: bool, string3: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def formatDate(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String], string3: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def getFileTimestamp() -> java.lang.String: ...
    @staticmethod
    def getMillisFromTicks(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def getTime(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    @staticmethod
    def getTime(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def getTimestamp() -> java.lang.String: ...

class DebugTools:
    @staticmethod
    def enableIJLogging(boolean: bool) -> bool: ...
    @typing.overload
    @staticmethod
    def enableLogging() -> bool: ...
    @typing.overload
    @staticmethod
    def enableLogging(string: typing.Union[java.lang.String, str]) -> bool: ...
    @staticmethod
    def getFieldName(class_: typing.Type[typing.Any], int: int) -> java.lang.String: ...
    @staticmethod
    def getStackTrace(throwable: java.lang.Throwable) -> java.lang.String: ...
    @staticmethod
    def isEnabled() -> bool: ...
    @staticmethod
    def setRootLevel(string: typing.Union[java.lang.String, str]) -> None: ...

class HandleException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class IRandomAccess(java.io.DataInput, java.io.DataOutput):
    def close(self) -> None: ...
    def exists(self) -> bool: ...
    def getFilePointer(self) -> int: ...
    def getOrder(self) -> java.nio.ByteOrder: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    def seek(self, long: int) -> None: ...
    def setOrder(self, byteOrder: java.nio.ByteOrder) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...

class IniList(java.util.ArrayList['IniTable']):
    def __init__(self): ...
    def flattenIntoHashMap(self) -> java.util.HashMap[java.lang.String, java.lang.String]: ...
    def getHeaders(self) -> java.util.List[java.lang.String]: ...
    def getTable(self, string: typing.Union[java.lang.String, str]) -> 'IniTable': ...

class IniParser:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def openTextResource(string: typing.Union[java.lang.String, str]) -> java.io.BufferedReader: ...
    @typing.overload
    @staticmethod
    def openTextResource(string: typing.Union[java.lang.String, str], class_: typing.Type[typing.Any]) -> java.io.BufferedReader: ...
    @typing.overload
    def parseINI(self, bufferedReader: java.io.BufferedReader) -> IniList: ...
    @typing.overload
    def parseINI(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> IniList: ...
    @typing.overload
    def parseINI(self, string: typing.Union[java.lang.String, str]) -> IniList: ...
    @typing.overload
    def parseINI(self, string: typing.Union[java.lang.String, str], class_: typing.Type[typing.Any]) -> IniList: ...
    def setBackslashContinuesLine(self, boolean: bool) -> None: ...
    def setCommentDelimiter(self, string: typing.Union[java.lang.String, str]) -> None: ...

class IniTable(java.util.HashMap[java.lang.String, java.lang.String]):
    HEADER_KEY: typing.ClassVar[java.lang.String] = ...
    DEFAULT_HEADER: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...

class IniWriter:
    def __init__(self): ...
    @typing.overload
    def saveINI(self, iniList: IniList, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def saveINI(self, iniList: IniList, string: typing.Union[java.lang.String, str], boolean: bool) -> None: ...
    @typing.overload
    def saveINI(self, iniList: IniList, string: typing.Union[java.lang.String, str], boolean: bool, boolean2: bool) -> None: ...

class Location:
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, location: 'Location', string: typing.Union[java.lang.String, str]): ...
    @staticmethod
    def cacheDirectoryListings(boolean: bool) -> None: ...
    def canRead(self) -> bool: ...
    def canWrite(self) -> bool: ...
    @staticmethod
    def checkValidId(string: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def cleanStaleCacheEntries() -> None: ...
    @staticmethod
    def clearDirectoryListingsCache() -> None: ...
    def createNewFile(self) -> bool: ...
    def delete(self) -> bool: ...
    def deleteOnExit(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def exists(self) -> bool: ...
    def getAbsoluteFile(self) -> 'Location': ...
    def getAbsolutePath(self) -> java.lang.String: ...
    def getCanonicalFile(self) -> 'Location': ...
    def getCanonicalPath(self) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def getHandle(string: typing.Union[java.lang.String, str]) -> IRandomAccess: ...
    @typing.overload
    @staticmethod
    def getHandle(string: typing.Union[java.lang.String, str], boolean: bool) -> IRandomAccess: ...
    @typing.overload
    @staticmethod
    def getHandle(string: typing.Union[java.lang.String, str], boolean: bool, boolean2: bool) -> IRandomAccess: ...
    @typing.overload
    @staticmethod
    def getHandle(string: typing.Union[java.lang.String, str], boolean: bool, boolean2: bool, int: int) -> IRandomAccess: ...
    @staticmethod
    def getIdMap() -> java.util.HashMap[java.lang.String, typing.Any]: ...
    @staticmethod
    def getMappedFile(string: typing.Union[java.lang.String, str]) -> IRandomAccess: ...
    @staticmethod
    def getMappedId(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def getName(self) -> java.lang.String: ...
    def getParent(self) -> java.lang.String: ...
    def getParentFile(self) -> 'Location': ...
    def getPath(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isDirectory(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def lastModified(self) -> int: ...
    def length(self) -> int: ...
    @typing.overload
    def list(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def list(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def listFiles(self) -> typing.List['Location']: ...
    @staticmethod
    def mapFile(string: typing.Union[java.lang.String, str], iRandomAccess: IRandomAccess) -> None: ...
    @staticmethod
    def mapId(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def mkdirs(self) -> bool: ...
    @staticmethod
    def reset() -> None: ...
    @staticmethod
    def setCacheDirectoryTimeout(double: float) -> None: ...
    @staticmethod
    def setIdMap(hashMap: java.util.HashMap[typing.Union[java.lang.String, str], typing.Any]) -> None: ...
    def toString(self) -> java.lang.String: ...
    def toURL(self) -> java.net.URL: ...

class Log4jTools:
    @staticmethod
    def enableLogging() -> bool: ...
    @staticmethod
    def isEnabled() -> bool: ...
    @staticmethod
    def setRootLevel(string: typing.Union[java.lang.String, str]) -> None: ...

class LogbackTools:
    @staticmethod
    def enableIJLogging(boolean: bool, appender: ch.qos.logback.core.Appender[ch.qos.logback.classic.spi.ILoggingEvent]) -> None: ...
    @staticmethod
    def enableLogging() -> bool: ...
    @staticmethod
    def isEnabled() -> bool: ...
    @staticmethod
    def setRootLevel(string: typing.Union[java.lang.String, str]) -> None: ...

class NIOByteBufferProvider:
    MINIMUM_JAVA_VERSION: typing.ClassVar[int] = ...
    def __init__(self, fileChannel: java.nio.channels.FileChannel, mapMode: java.nio.channels.FileChannel.MapMode): ...
    def allocate(self, long: int, int: int) -> java.nio.ByteBuffer: ...

class NIOInputStream(java.io.InputStream, java.io.DataInput):
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, iRandomAccess: IRandomAccess): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    @typing.overload
    def findString(self, boolean: bool, int: int, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, boolean: bool, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, int: int, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    def getFilePointer(self) -> int: ...
    def getInputStream(self) -> java.io.DataInputStream: ...
    def isLittleEndian(self) -> bool: ...
    def length(self) -> int: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    def order(self, boolean: bool) -> None: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readCString(self) -> java.lang.String: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    @typing.overload
    def readString(self, int: int) -> java.lang.String: ...
    @typing.overload
    def readString(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def reset(self) -> None: ...
    def seek(self, long: int) -> None: ...
    def setExtend(self, int: int) -> None: ...
    def skipBytes(self, int: int) -> int: ...

class RandomAccessInputStream(java.io.InputStream, java.io.DataInput, java.io.Closeable, com.esotericsoftware.kryo.KryoSerializable):
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], int: int): ...
    @typing.overload
    def __init__(self, iRandomAccess: IRandomAccess): ...
    @typing.overload
    def __init__(self, iRandomAccess: IRandomAccess, string: typing.Union[java.lang.String, str]): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    @typing.overload
    def findString(self, boolean: bool, int: int, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, boolean: bool, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, int: int, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def findString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    def getFilePointer(self) -> int: ...
    def isBitOnByteBoundary(self) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def length(self) -> int: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    def order(self, boolean: bool) -> None: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, kryo: com.esotericsoftware.kryo.Kryo, input: com.esotericsoftware.kryo.io.Input) -> None: ...
    def readBits(self, int: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readByteToString(self, int: int) -> java.lang.String: ...
    def readCString(self) -> java.lang.String: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    @typing.overload
    def readString(self, int: int) -> java.lang.String: ...
    @typing.overload
    def readString(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedInt(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def reset(self) -> None: ...
    def seek(self, long: int) -> None: ...
    def setEncoding(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLength(self, long: int) -> None: ...
    def skipBits(self, long: int) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    def write(self, kryo: com.esotericsoftware.kryo.Kryo, output: com.esotericsoftware.kryo.io.Output) -> None: ...

class RandomAccessOutputStream(java.io.OutputStream, java.io.DataOutput, java.io.Closeable):
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, iRandomAccess: IRandomAccess): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getFilePointer(self) -> int: ...
    def isLittleEndian(self) -> bool: ...
    def length(self) -> int: ...
    def order(self, boolean: bool) -> None: ...
    def seek(self, long: int) -> None: ...
    def skipBytes(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...
    @typing.overload
    def writeBits(self, int: int, int2: int) -> None: ...
    @typing.overload
    def writeBits(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLine(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ReflectException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class ReflectedUniverse:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, classLoader: java.lang.ClassLoader): ...
    @typing.overload
    def __init__(self, uRLArray: typing.List[java.net.URL]): ...
    def getVar(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def isAccessibilityIgnored(self) -> bool: ...
    @staticmethod
    def isInstance(class_: typing.Type[typing.Any], object: typing.Any) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    def setAccessibilityIgnored(self, boolean: bool) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], boolean: bool) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], byte: int) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], char: str) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], float: float) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], object: typing.Any) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], long: int) -> None: ...
    @typing.overload
    def setVar(self, string: typing.Union[java.lang.String, str], short: int) -> None: ...

class Region:
    x: int = ...
    y: int = ...
    width: int = ...
    height: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def containsPoint(self, int: int, int2: int) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def intersection(self, region: 'Region') -> 'Region': ...
    def intersects(self, region: 'Region') -> bool: ...
    def toString(self) -> java.lang.String: ...

class StatusEvent:
    @typing.overload
    def __init__(self, int: int, int2: int, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, int: int, int2: int, string: typing.Union[java.lang.String, str], boolean: bool): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], boolean: bool): ...
    def getProgressMaximum(self) -> int: ...
    def getProgressValue(self) -> int: ...
    def getStatusMessage(self) -> java.lang.String: ...
    def isWarning(self) -> bool: ...
    def toString(self) -> java.lang.String: ...

class StatusListener(java.util.EventListener):
    def statusUpdated(self, statusEvent: StatusEvent) -> None: ...

class StatusReporter:
    def addStatusListener(self, statusListener: StatusListener) -> None: ...
    def notifyListeners(self, statusEvent: StatusEvent) -> None: ...
    def removeStatusListener(self, statusListener: StatusListener) -> None: ...

class AbstractNIOHandle(IRandomAccess):
    def __init__(self): ...
    def exists(self) -> bool: ...

class CaseInsensitiveLocation(Location):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, caseInsensitiveLocation: 'CaseInsensitiveLocation', string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, location: Location): ...
    @typing.overload
    @staticmethod
    def invalidateCache() -> None: ...
    @typing.overload
    @staticmethod
    def invalidateCache(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...

class FileHandle(IRandomAccess):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def close(self) -> None: ...
    def exists(self) -> bool: ...
    def getFilePointer(self) -> int: ...
    def getOrder(self) -> java.nio.ByteOrder: ...
    def getRandomAccessFile(self) -> java.io.RandomAccessFile: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def setOrder(self, byteOrder: java.nio.ByteOrder) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: typing.Union[java.lang.String, str]) -> None: ...

class StreamHandle(IRandomAccess):
    def __init__(self): ...
    def close(self) -> None: ...
    def exists(self) -> bool: ...
    def getFilePointer(self) -> int: ...
    def getOrder(self) -> java.nio.ByteOrder: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def setOrder(self, byteOrder: java.nio.ByteOrder) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: typing.Union[java.lang.String, str]) -> None: ...
    class Settings:
        def __init__(self): ...
        def get(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def getRemoteCacheRootDir(self) -> java.lang.String: ...

class BZip2Handle(StreamHandle):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @staticmethod
    def isBZip2File(string: typing.Union[java.lang.String, str]) -> bool: ...

class ByteArrayHandle(AbstractNIOHandle):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, byteBuffer: java.nio.ByteBuffer): ...
    def close(self) -> None: ...
    def getByteBuffer(self) -> java.nio.ByteBuffer: ...
    def getBytes(self) -> typing.List[int]: ...
    def getFilePointer(self) -> int: ...
    def getOrder(self) -> java.nio.ByteOrder: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def setLength(self, long: int) -> None: ...
    def setOrder(self, byteOrder: java.nio.ByteOrder) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: typing.Union[java.lang.String, str]) -> None: ...

class GZipHandle(StreamHandle):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @staticmethod
    def isGZipFile(string: typing.Union[java.lang.String, str]) -> bool: ...

class NIOFileHandle(AbstractNIOHandle):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: typing.Union[java.lang.String, str], int: int): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def close(self) -> None: ...
    def getBufferSize(self) -> int: ...
    def getFileChannel(self) -> java.nio.channels.FileChannel: ...
    def getFilePointer(self) -> int: ...
    def getOrder(self) -> java.nio.ByteOrder: ...
    def getRandomAccessFile(self) -> java.io.RandomAccessFile: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def read(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> java.lang.String: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> java.lang.String: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    @staticmethod
    def setDefaultBufferSize(int: int) -> None: ...
    @staticmethod
    def setDefaultReadWriteBufferSize(int: int) -> None: ...
    def setLength(self, long: int) -> None: ...
    def setOrder(self, byteOrder: java.nio.ByteOrder) -> None: ...
    @typing.overload
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def skipBytes(self, long: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def write(self, byteBuffer: java.nio.ByteBuffer, int: int, int2: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: typing.Union[java.lang.String, str]) -> None: ...

class S3Handle(StreamHandle):
    DEFAULT_S3_PROTOCOL: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], boolean: bool, settings: StreamHandle.Settings): ...
    @staticmethod
    def cacheObject(string: typing.Union[java.lang.String, str], settings: StreamHandle.Settings) -> java.lang.String: ...
    @staticmethod
    def canHandleScheme(string: typing.Union[java.lang.String, str]) -> bool: ...
    def exists(self) -> bool: ...
    def getBucket(self) -> java.lang.String: ...
    def getCacheKey(self) -> java.lang.String: ...
    def getPath(self) -> java.lang.String: ...
    def getPort(self) -> int: ...
    def getServer(self) -> java.lang.String: ...
    def isBucket(self) -> bool: ...
    def length(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def toString(self) -> java.lang.String: ...

class URLHandle(StreamHandle):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def seek(self, long: int) -> None: ...

class ZipHandle(StreamHandle):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], zipEntry: java.util.zip.ZipEntry): ...
    def close(self) -> None: ...
    def getEntryCount(self) -> int: ...
    def getEntryName(self) -> java.lang.String: ...
    def getInputStream(self) -> java.io.DataInputStream: ...
    @staticmethod
    def isZipFile(string: typing.Union[java.lang.String, str]) -> bool: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.common")``.

    AbstractNIOHandle: typing.Type[AbstractNIOHandle]
    BZip2Handle: typing.Type[BZip2Handle]
    ByteArrayHandle: typing.Type[ByteArrayHandle]
    CBZip2InputStream: typing.Type[CBZip2InputStream]
    CRC: typing.Type[CRC]
    CaseInsensitiveLocation: typing.Type[CaseInsensitiveLocation]
    Constants: typing.Type[Constants]
    DataTools: typing.Type[DataTools]
    DateTools: typing.Type[DateTools]
    DebugTools: typing.Type[DebugTools]
    FileHandle: typing.Type[FileHandle]
    GZipHandle: typing.Type[GZipHandle]
    HandleException: typing.Type[HandleException]
    IRandomAccess: typing.Type[IRandomAccess]
    IniList: typing.Type[IniList]
    IniParser: typing.Type[IniParser]
    IniTable: typing.Type[IniTable]
    IniWriter: typing.Type[IniWriter]
    Location: typing.Type[Location]
    Log4jTools: typing.Type[Log4jTools]
    LogbackTools: typing.Type[LogbackTools]
    NIOByteBufferProvider: typing.Type[NIOByteBufferProvider]
    NIOFileHandle: typing.Type[NIOFileHandle]
    NIOInputStream: typing.Type[NIOInputStream]
    RandomAccessInputStream: typing.Type[RandomAccessInputStream]
    RandomAccessOutputStream: typing.Type[RandomAccessOutputStream]
    ReflectException: typing.Type[ReflectException]
    ReflectedUniverse: typing.Type[ReflectedUniverse]
    Region: typing.Type[Region]
    S3Handle: typing.Type[S3Handle]
    StatusEvent: typing.Type[StatusEvent]
    StatusListener: typing.Type[StatusListener]
    StatusReporter: typing.Type[StatusReporter]
    StreamHandle: typing.Type[StreamHandle]
    URLHandle: typing.Type[URLHandle]
    ZipHandle: typing.Type[ZipHandle]
    enumeration: bioformats_jar._loci.common.enumeration.__module_protocol__
    image: bioformats_jar._loci.common.image.__module_protocol__
    services: bioformats_jar._loci.common.services.__module_protocol__
    xml: bioformats_jar._loci.common.xml.__module_protocol__
