/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataScalar;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleAdapter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.VariableSimpleImpl;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.SectionFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;

public class WriterCFTrajectoryProfileCollection
extends CFPointWriter {
    public static final String trajectoryIndexName = "trajectoryIndex";
    private int ntraj;
    private int traj_strlen;
    private Structure trajStructure;
    private HashMap<String, Integer> trajIndexMap;
    private Map<String, Variable> trajVarMap = new HashMap<String, Variable>();
    private Structure profileStruct;
    private Map<String, Variable> profileVarMap = new HashMap<String, Variable>();
    private boolean headerDone = false;
    private int trajRecno = 0;
    private int profileRecno = 0;
    private int obsRecno = 0;

    public WriterCFTrajectoryProfileCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, List<Variable> extra, DateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, extra, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.trajectoryProfile.name()));
    }

    public void setFeatureAuxInfo2(int ntraj, int traj_strlen) {
        this.ntraj = ntraj;
        this.traj_strlen = traj_strlen;
        this.trajIndexMap = new HashMap(2 * ntraj);
    }

    public int writeProfile(SectionFeature section, ProfileFeature profile) throws IOException {
        profile.resetIteration();
        int count = 0;
        while (profile.hasNext()) {
            PointFeature pf = profile.next();
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = profile.getName().length() * 2;
                }
                this.writeHeader(section, profile, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        Integer sectionIndex = this.trajIndexMap.get(section.getName());
        if (sectionIndex == null) {
            sectionIndex = this.writeSectionData(section);
            this.trajIndexMap.put(section.getName(), sectionIndex);
        }
        this.writeProfileData(sectionIndex, profile, count);
        return count;
    }

    private void writeHeader(SectionFeature section, ProfileFeature profile, PointFeature obs) throws IOException {
        StructureData sectionData = section.getFeatureData();
        StructureData profileData = profile.getFeatureData();
        StructureData obsData = obs.getFeatureData();
        Formatter coordNames = new Formatter().format("%s %s %s", "profileTime", "latitude", "longitude");
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        if (this.useAlt) {
            obsCoords.add(VariableSimpleImpl.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).add(new Attribute("standard_name", "altitude")).add(new Attribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits))));
            coordNames.format(" %s", this.altitudeCoordinateName);
        }
        super.writeHeader2(obsCoords, sectionData, profileData, obsData, coordNames.toString());
    }

    @Override
    protected void makeFeatureVariables(StructureData trajData, boolean isExtended) throws IOException {
        Dimension trajDim = this.writer.addDimension(null, "traj", this.ntraj);
        ArrayList<VariableSimpleIF> trajVars = new ArrayList<VariableSimpleIF>();
        trajVars.add(VariableSimpleImpl.makeString("trajectoryId", "trajectory identifier", null, this.traj_strlen).add(new Attribute("cf_role", "trajectory_id")));
        for (StructureMembers.Member m3 : trajData.getMembers()) {
            if (this.getDataVar(m3.getName()) == null) continue;
            trajVars.add(new VariableSimpleAdapter(m3));
        }
        if (isExtended) {
            this.trajStructure = (Structure)this.writer.addVariable(null, "trajectory", DataType.STRUCTURE, "traj");
            this.addCoordinatesExtended(this.trajStructure, trajVars);
        } else {
            this.addCoordinatesClassic(trajDim, trajVars, this.trajVarMap);
        }
    }

    private int writeSectionData(SectionFeature section) throws IOException {
        StructureDataScalar coords = new StructureDataScalar("Coords");
        coords.addMemberString("trajectoryId", null, null, section.getName().trim(), this.traj_strlen);
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(section.getFeatureData());
        this.trajRecno = super.writeStructureData(this.trajRecno, this.trajStructure, sdall, this.trajVarMap);
        return this.trajRecno - 1;
    }

    @Override
    protected void makeMiddleVariables(StructureData profileData, boolean isExtended) throws IOException {
        Dimension profileDim = this.writer.addDimension(null, "profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleImpl.makeString("profileId", "profile identifier", null, this.id_strlen).add(new Attribute("cf_role", "profile_id")).add(new Attribute("missing_value", String.valueOf(-9999))));
        profileVars.add(VariableSimpleImpl.makeScalar("latitude", "profile latitude", "degrees_north", DataType.DOUBLE));
        profileVars.add(VariableSimpleImpl.makeScalar("longitude", "profile longitude", "degrees_east", DataType.DOUBLE));
        profileVars.add(VariableSimpleImpl.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUnitsString(), DataType.DOUBLE));
        profileVars.add(VariableSimpleImpl.makeScalar(trajectoryIndexName, "trajectory index for this profile", null, DataType.INT).add(new Attribute("instance_dimension", "traj")));
        profileVars.add(VariableSimpleImpl.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).add(new Attribute("sample_dimension", "obs")));
        for (StructureMembers.Member m3 : profileData.getMembers()) {
            VariableSimpleIF dv = this.getDataVar(m3.getName());
            if (dv == null) continue;
            profileVars.add(dv);
        }
        if (isExtended) {
            this.profileStruct = (Structure)this.writer.addVariable(null, "profile", DataType.STRUCTURE, "profile");
            this.addCoordinatesExtended(this.profileStruct, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    public void writeProfileData(int sectionIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), CalendarDate.of(profile.getTime()));
        StructureDataScalar profileCoords = new StructureDataScalar("Coords");
        profileCoords.addMember("latitude", null, null, DataType.DOUBLE, false, profile.getLatLon().getLatitude());
        profileCoords.addMember("longitude", null, null, DataType.DOUBLE, false, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeValue(profile.getTime());
        profileCoords.addMember("profileTime", null, null, DataType.DOUBLE, false, timeInMyUnits);
        profileCoords.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        profileCoords.addMember("nobs", null, null, DataType.INT, false, nobs);
        profileCoords.addMember(trajectoryIndexName, null, null, DataType.INT, false, sectionIndex);
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(profileCoords);
        sdall.add(profile.getFeatureData());
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    public void writeObsData(PointFeature pf) throws IOException {
        StructureDataScalar coords = new StructureDataScalar("Coords");
        if (this.useAlt) {
            coords.addMember(this.altitudeCoordinateName, null, null, DataType.DOUBLE, false, pf.getLocation().getAltitude());
        }
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(pf.getFeatureData());
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

