/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsTime;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsTimeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsTimeEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsTimeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Ys\\s*", "Ys");
        p.put("^\\s*Zs\\s*", "Zs");
        p.put("^\\s*Es\\s*", "Es");
        p.put("^\\s*Ps\\s*", "Ps");
        p.put("^\\s*Ts\\s*", "Ts");
        p.put("^\\s*Gs\\s*", "Gs");
        p.put("^\\s*Ms\\s*", "Ms");
        p.put("^\\s*ks\\s*", "ks");
        p.put("^\\s*hs\\s*", "hs");
        p.put("^\\s*das\\s*", "das");
        p.put("^\\s*s\\s*", "s");
        p.put("^\\s*ds\\s*", "ds");
        p.put("^\\s*cs\\s*", "cs");
        p.put("^\\s*ms\\s*", "ms");
        p.put("^\\s*\u00b5s\\s*", "\u00b5s");
        p.put("^\\s*ns\\s*", "ns");
        p.put("^\\s*ps\\s*", "ps");
        p.put("^\\s*fs\\s*", "fs");
        p.put("^\\s*as\\s*", "as");
        p.put("^\\s*zs\\s*", "zs");
        p.put("^\\s*ys\\s*", "ys");
        p.put("^\\s*min\\s*", "min");
        p.put("^\\s*h\\s*", "h");
        p.put("^\\s*d\\s*", "d");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsTime.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsTime", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Time inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Time> getBaseUnit(UnitsTime inModelUnit) {
        Unit<Time> theResult = UNITS.SECOND;
        if (UnitsTime.YOTTASECOND.equals(inModelUnit)) {
            theResult = UNITS.YOTTASECOND;
        }
        if (UnitsTime.ZETTASECOND.equals(inModelUnit)) {
            theResult = UNITS.ZETTASECOND;
        }
        if (UnitsTime.EXASECOND.equals(inModelUnit)) {
            theResult = UNITS.EXASECOND;
        }
        if (UnitsTime.PETASECOND.equals(inModelUnit)) {
            theResult = UNITS.PETASECOND;
        }
        if (UnitsTime.TERASECOND.equals(inModelUnit)) {
            theResult = UNITS.TERASECOND;
        }
        if (UnitsTime.GIGASECOND.equals(inModelUnit)) {
            theResult = UNITS.GIGASECOND;
        }
        if (UnitsTime.MEGASECOND.equals(inModelUnit)) {
            theResult = UNITS.MEGASECOND;
        }
        if (UnitsTime.KILOSECOND.equals(inModelUnit)) {
            theResult = UNITS.KILOSECOND;
        }
        if (UnitsTime.HECTOSECOND.equals(inModelUnit)) {
            theResult = UNITS.HECTOSECOND;
        }
        if (UnitsTime.DECASECOND.equals(inModelUnit)) {
            theResult = UNITS.DECASECOND;
        }
        if (UnitsTime.SECOND.equals(inModelUnit)) {
            theResult = UNITS.SECOND;
        }
        if (UnitsTime.DECISECOND.equals(inModelUnit)) {
            theResult = UNITS.DECISECOND;
        }
        if (UnitsTime.CENTISECOND.equals(inModelUnit)) {
            theResult = UNITS.CENTISECOND;
        }
        if (UnitsTime.MILLISECOND.equals(inModelUnit)) {
            theResult = UNITS.MILLISECOND;
        }
        if (UnitsTime.MICROSECOND.equals(inModelUnit)) {
            theResult = UNITS.MICROSECOND;
        }
        if (UnitsTime.NANOSECOND.equals(inModelUnit)) {
            theResult = UNITS.NANOSECOND;
        }
        if (UnitsTime.PICOSECOND.equals(inModelUnit)) {
            theResult = UNITS.PICOSECOND;
        }
        if (UnitsTime.FEMTOSECOND.equals(inModelUnit)) {
            theResult = UNITS.FEMTOSECOND;
        }
        if (UnitsTime.ATTOSECOND.equals(inModelUnit)) {
            theResult = UNITS.ATTOSECOND;
        }
        if (UnitsTime.ZEPTOSECOND.equals(inModelUnit)) {
            theResult = UNITS.ZEPTOSECOND;
        }
        if (UnitsTime.YOCTOSECOND.equals(inModelUnit)) {
            theResult = UNITS.YOCTOSECOND;
        }
        if (UnitsTime.MINUTE.equals(inModelUnit)) {
            theResult = UNITS.MINUTE;
        }
        if (UnitsTime.HOUR.equals(inModelUnit)) {
            theResult = UNITS.HOUR;
        }
        if (UnitsTime.DAY.equals(inModelUnit)) {
            theResult = UNITS.DAY;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Time getQuantity(T inValue, UnitsTime inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Time((Number)typedValue.getValue(), UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Time' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsTimeEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Time getQuantity(T inValue, UnitsTime inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Time(doubleValue, UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Time(intValue, UnitsTimeEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Time' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsTimeEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsTime.class;
    }
}

