/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MicrobeamManipulationRef
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrobeamManipulationRef.class);
    private String id;

    public MicrobeamManipulationRef() {
    }

    public MicrobeamManipulationRef(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public MicrobeamManipulationRef(MicrobeamManipulationRef orig) {
        super(orig);
        this.id = orig.id;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("MicrobeamManipulationRef missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element MicrobeamManipulationRef_element) {
        if (MicrobeamManipulationRef_element == null) {
            MicrobeamManipulationRef_element = document.createElementNS(NAMESPACE, "MicrobeamManipulationRef");
        }
        super.asXMLElement(document, MicrobeamManipulationRef_element);
        if (this.id != null) {
            MicrobeamManipulationRef_element.setAttribute("ID", this.id.toString());
        }
        return MicrobeamManipulationRef_element;
    }
}

