/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;
import loci.poi.hpsf.DocumentSummaryInformation;
import loci.poi.hpsf.HPSFRuntimeException;
import loci.poi.hpsf.MarkUnsupportedException;
import loci.poi.hpsf.MutablePropertySet;
import loci.poi.hpsf.MutableSection;
import loci.poi.hpsf.NoPropertySetStreamException;
import loci.poi.hpsf.PropertySet;
import loci.poi.hpsf.SummaryInformation;
import loci.poi.hpsf.UnexpectedPropertySetTypeException;
import loci.poi.hpsf.wellknown.SectionIDMap;

public class PropertySetFactory {
    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s2 = (MutableSection)ps.getFirstSection();
        s2.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s2 = (MutableSection)ps.getFirstSection();
        s2.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }
}

