/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public final class MDByteArray
extends MDAbstractArray<Byte> {
    private static final long serialVersionUID = 1L;
    private byte[] flattenedArray;

    public MDByteArray(long[] dimensions) {
        this(new byte[MDByteArray.getLength(dimensions, 0L)], MDByteArray.toInt(dimensions), false);
    }

    public MDByteArray(long[] dimensions, long capacityHyperRows) {
        this(new byte[MDByteArray.getLength(dimensions, capacityHyperRows)], MDByteArray.toInt(dimensions), false);
    }

    public MDByteArray(byte[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDByteArray.toInt(dimensions), true);
    }

    public MDByteArray(byte[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDByteArray.toInt(dimensions), checkdimensions);
    }

    public MDByteArray(int[] dimensions) {
        this(new byte[MDByteArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDByteArray(int[] dimensions, int capacityHyperRows) {
        this(new byte[MDByteArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDByteArray(byte[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDByteArray(byte[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDByteArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDByteArray(byte[][] matrix) {
        this(matrix, MDByteArray.getDimensions(matrix));
    }

    public MDByteArray(byte[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDByteArray.getLength(dimensions, 0);
        this.flattenedArray = new byte[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    private static int[] getDimensions(byte[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Byte getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(Byte value, int ... indices) {
        this.set((byte)value, indices);
    }

    @Override
    public Byte getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(Byte value, int linearIndex) {
        this.set((byte)value, linearIndex);
    }

    public byte[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public byte[] getCopyAsFlatArray() {
        return ArrayUtils.subarray(this.flattenedArray, 0, this.dimensions[0] * this.hyperRowLength);
    }

    @Override
    protected void adaptCapacityHyperRows() {
        byte[] oldArray = this.flattenedArray;
        this.flattenedArray = new byte[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public byte get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public byte get(int index) {
        return this.flattenedArray[index];
    }

    public byte get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public byte get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(byte value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(byte value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(byte value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(byte value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public byte[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        byte[][] result = new byte[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDByteArray other = (MDByteArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private byte[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }
}

