/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.IllegalAnnotationError;
import ch.systemsx.cisd.args4j.Messages;
import ch.systemsx.cisd.args4j.spi.Setter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodSetter<T>
implements Setter<T> {
    private final Object bean;
    private final Method m;

    public MethodSetter(Object bean, Method m3) {
        this.bean = bean;
        this.m = m3;
        if (m3.getParameterTypes().length != 1) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_METHOD_SIGNATURE.format(m3));
        }
    }

    @Override
    public Class getType() {
        return this.m.getParameterTypes()[0];
    }

    @Override
    public void addValue(T value) throws CmdLineException {
        try {
            try {
                this.m.invoke(this.bean, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.m.setAccessible(true);
                try {
                    this.m.invoke(this.bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof CmdLineException) {
                throw (CmdLineException)t;
            }
            if (t != null) {
                throw new CmdLineException(t);
            }
            throw new CmdLineException(e);
        }
    }
}

