"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionProtocol = exports.Subscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * A new subscription.
 *
 * Prefer to use the `ITopic.addSubscription()` methods to create instances of
 * this class.
 */
class Subscription extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_SubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.rawMessageDelivery &&
            [
                SubscriptionProtocol.HTTP,
                SubscriptionProtocol.HTTPS,
                SubscriptionProtocol.SQS,
                SubscriptionProtocol.FIREHOSE,
            ]
                .indexOf(props.protocol) < 0) {
            throw new Error('Raw message delivery can only be enabled for HTTP, HTTPS, SQS, and Firehose subscriptions.');
        }
        if (props.filterPolicy) {
            if (Object.keys(props.filterPolicy).length > 5) {
                throw new Error('A filter policy can have a maximum of 5 attribute names.');
            }
            this.filterPolicy = Object.entries(props.filterPolicy)
                .reduce((acc, [k, v]) => ({ ...acc, [k]: v.conditions }), {});
            let total = 1;
            Object.values(this.filterPolicy).forEach(filter => { total *= filter.length; });
            if (total > 100) {
                throw new Error(`The total combination of values (${total}) must not exceed 100.`);
            }
        }
        if (props.protocol === SubscriptionProtocol.FIREHOSE && !props.subscriptionRoleArn) {
            throw new Error('Subscription role arn is required field for subscriptions with a firehose protocol.');
        }
        this.deadLetterQueue = this.buildDeadLetterQueue(props);
        new sns_generated_1.CfnSubscription(this, 'Resource', {
            endpoint: props.endpoint,
            protocol: props.protocol,
            topicArn: props.topic.topicArn,
            rawMessageDelivery: props.rawMessageDelivery,
            filterPolicy: this.filterPolicy,
            region: props.region,
            redrivePolicy: this.buildDeadLetterConfig(this.deadLetterQueue),
            subscriptionRoleArn: props.subscriptionRoleArn,
        });
    }
    buildDeadLetterQueue(props) {
        if (!props.deadLetterQueue) {
            return undefined;
        }
        const deadLetterQueue = props.deadLetterQueue;
        deadLetterQueue.addToResourcePolicy(new aws_iam_1.PolicyStatement({
            resources: [deadLetterQueue.queueArn],
            actions: ['sqs:SendMessage'],
            principals: [new aws_iam_1.ServicePrincipal('sns.amazonaws.com')],
            conditions: {
                ArnEquals: { 'aws:SourceArn': props.topic.topicArn },
            },
        }));
        return deadLetterQueue;
    }
    buildDeadLetterConfig(deadLetterQueue) {
        if (deadLetterQueue) {
            return {
                deadLetterTargetArn: deadLetterQueue.queueArn,
            };
        }
        else {
            return undefined;
        }
    }
}
exports.Subscription = Subscription;
_a = JSII_RTTI_SYMBOL_1;
Subscription[_a] = { fqn: "@aws-cdk/aws-sns.Subscription", version: "1.159.0" };
/**
 * The type of subscription, controlling the type of the endpoint parameter.
 */
var SubscriptionProtocol;
(function (SubscriptionProtocol) {
    /**
     * JSON-encoded message is POSTED to an HTTP url.
     */
    SubscriptionProtocol["HTTP"] = "http";
    /**
     * JSON-encoded message is POSTed to an HTTPS url.
     */
    SubscriptionProtocol["HTTPS"] = "https";
    /**
     * Notifications are sent via email.
     */
    SubscriptionProtocol["EMAIL"] = "email";
    /**
     * Notifications are JSON-encoded and sent via mail.
     */
    SubscriptionProtocol["EMAIL_JSON"] = "email-json";
    /**
     * Notification is delivered by SMS
     */
    SubscriptionProtocol["SMS"] = "sms";
    /**
     * Notifications are enqueued into an SQS queue.
     */
    SubscriptionProtocol["SQS"] = "sqs";
    /**
     * JSON-encoded notifications are sent to a mobile app endpoint.
     */
    SubscriptionProtocol["APPLICATION"] = "application";
    /**
     * Notifications trigger a Lambda function.
     */
    SubscriptionProtocol["LAMBDA"] = "lambda";
    /**
     * Notifications put records into a firehose delivery stream.
     */
    SubscriptionProtocol["FIREHOSE"] = "firehose";
})(SubscriptionProtocol = exports.SubscriptionProtocol || (exports.SubscriptionProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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