"""
    StatusCake API

    Copyright (c) 2022

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or  sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    API Version: 1.0.0-beta.3
    Contact: support@statuscake.com

    Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
"""


import re  # noqa: F401
import sys  # noqa: F401

from statuscake.api_client import ApiClient, Endpoint as _Endpoint
from statuscake.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from statuscake.model.api_error import APIError
from statuscake.model.api_response import APIResponse
from statuscake.model.pagespeed_test_check_rate import PagespeedTestCheckRate
from statuscake.model.pagespeed_test_history import PagespeedTestHistory
from statuscake.model.pagespeed_test_region import PagespeedTestRegion
from statuscake.model.pagespeed_test_response import PagespeedTestResponse
from statuscake.model.pagespeed_tests import PagespeedTests


class PagespeedApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_pagespeed_test_endpoint = _Endpoint(
            settings={
                'response_type': (APIResponse,),
                'auth': [],
                'endpoint_path': '/pagespeed',
                'operation_id': 'create_pagespeed_test',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'website_url',
                    'check_rate',
                    'region',
                    'alert_bigger',
                    'alert_slower',
                    'alert_smaller',
                    'contact_groups',
                    'contact_groups_csv',
                    'paused',
                ],
                'required': [
                    'name',
                    'website_url',
                    'check_rate',
                    'region',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'alert_bigger',
                    'alert_slower',
                    'alert_smaller',
                ]
            },
            root_map={
                'validations': {
                    ('alert_bigger',): {

                        'inclusive_minimum': 0,
                    },
                    ('alert_slower',): {

                        'inclusive_minimum': 0,
                    },
                    ('alert_smaller',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'website_url':
                        (str,),
                    'check_rate':
                        (PagespeedTestCheckRate,),
                    'region':
                        (PagespeedTestRegion,),
                    'alert_bigger':
                        (int,),
                    'alert_slower':
                        (int,),
                    'alert_smaller':
                        (int,),
                    'contact_groups':
                        ([str],),
                    'contact_groups_csv':
                        (str,),
                    'paused':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'website_url': 'website_url',
                    'check_rate': 'check_rate',
                    'region': 'region',
                    'alert_bigger': 'alert_bigger',
                    'alert_slower': 'alert_slower',
                    'alert_smaller': 'alert_smaller',
                    'contact_groups': 'contact_groups',
                    'contact_groups_csv': 'contact_groups_csv',
                    'paused': 'paused',
                },
                'location_map': {
                    'name': 'form',
                    'website_url': 'form',
                    'check_rate': 'form',
                    'region': 'form',
                    'alert_bigger': 'form',
                    'alert_slower': 'form',
                    'alert_smaller': 'form',
                    'contact_groups': 'form',
                    'contact_groups_csv': 'form',
                    'paused': 'form',
                },
                'collection_format_map': {
                    'contact_groups': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )
        self.delete_pagespeed_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/pagespeed/{test_id}',
                'operation_id': 'delete_pagespeed_test',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pagespeed_test_endpoint = _Endpoint(
            settings={
                'response_type': (PagespeedTestResponse,),
                'auth': [],
                'endpoint_path': '/pagespeed/{test_id}',
                'operation_id': 'get_pagespeed_test',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_pagespeed_test_history_endpoint = _Endpoint(
            settings={
                'response_type': (PagespeedTestHistory,),
                'auth': [],
                'endpoint_path': '/pagespeed/{test_id}/history',
                'operation_id': 'list_pagespeed_test_history',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'limit',
                    'before',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'before',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('before',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'limit':
                        (int,),
                    'before':
                        (int,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'limit': 'limit',
                    'before': 'before',
                },
                'location_map': {
                    'test_id': 'path',
                    'limit': 'query',
                    'before': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_pagespeed_tests_endpoint = _Endpoint(
            settings={
                'response_type': (PagespeedTests,),
                'auth': [],
                'endpoint_path': '/pagespeed',
                'operation_id': 'list_pagespeed_tests',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'limit': 'limit',
                },
                'location_map': {
                    'page': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_pagespeed_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/pagespeed/{test_id}',
                'operation_id': 'update_pagespeed_test',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'name',
                    'check_rate',
                    'alert_bigger',
                    'alert_slower',
                    'alert_smaller',
                    'contact_groups',
                    'contact_groups_csv',
                    'paused',
                    'region',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'alert_bigger',
                    'alert_slower',
                    'alert_smaller',
                ]
            },
            root_map={
                'validations': {
                    ('alert_bigger',): {

                        'inclusive_minimum': 0,
                    },
                    ('alert_slower',): {

                        'inclusive_minimum': 0,
                    },
                    ('alert_smaller',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'name':
                        (str,),
                    'check_rate':
                        (PagespeedTestCheckRate,),
                    'alert_bigger':
                        (int,),
                    'alert_slower':
                        (int,),
                    'alert_smaller':
                        (int,),
                    'contact_groups':
                        ([str],),
                    'contact_groups_csv':
                        (str,),
                    'paused':
                        (bool,),
                    'region':
                        (PagespeedTestRegion,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'name': 'name',
                    'check_rate': 'check_rate',
                    'alert_bigger': 'alert_bigger',
                    'alert_slower': 'alert_slower',
                    'alert_smaller': 'alert_smaller',
                    'contact_groups': 'contact_groups',
                    'contact_groups_csv': 'contact_groups_csv',
                    'paused': 'paused',
                    'region': 'region',
                },
                'location_map': {
                    'test_id': 'path',
                    'name': 'form',
                    'check_rate': 'form',
                    'alert_bigger': 'form',
                    'alert_slower': 'form',
                    'alert_smaller': 'form',
                    'contact_groups': 'form',
                    'contact_groups_csv': 'form',
                    'paused': 'form',
                    'region': 'form',
                },
                'collection_format_map': {
                    'contact_groups': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )

    def create_pagespeed_test(
        self,
        name,
        website_url,
        check_rate,
        region,
        **kwargs
    ):
        """Create a pagespeed check  # noqa: E501

        Creates a pagespeed check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_pagespeed_test(name, website_url, check_rate, region, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Name of the check
            website_url (str): URL or IP address of the website under test
            check_rate (PagespeedTestCheckRate):
            region (PagespeedTestRegion):

        Keyword Args:
            alert_bigger (int): An alert will be sent if the size of the page is larger than this value (kb). A value of 0 prevents alerts being sent. . [optional] if omitted the server will use the default value of 0
            alert_slower (int): An alert will be sent if the load time of the page exceeds this value (ms). A value of 0 prevents alerts being sent . [optional] if omitted the server will use the default value of 0
            alert_smaller (int): An alert will be sent if the size of the page is smaller than this value (kb). A value of 0 prevents alerts being sent . [optional] if omitted the server will use the default value of 0
            contact_groups ([str]): List of contact group IDs. [optional]
            contact_groups_csv (str): Comma separated list of contact group IDs. [optional]
            paused (bool): Whether the check should be run. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['website_url'] = \
            website_url
        kwargs['check_rate'] = \
            check_rate
        kwargs['region'] = \
            region
        return self.create_pagespeed_test_endpoint.call_with_http_info(**kwargs)

    def delete_pagespeed_test(
        self,
        test_id,
        **kwargs
    ):
        """Delete a pagespeed check  # noqa: E501

        Deletes a pagespeed check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_pagespeed_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Pagespeed check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.delete_pagespeed_test_endpoint.call_with_http_info(**kwargs)

    def get_pagespeed_test(
        self,
        test_id,
        **kwargs
    ):
        """Retrieve a pagespeed check  # noqa: E501

        Returns a pagespeed check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pagespeed_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Pagespeed check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PagespeedTestResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.get_pagespeed_test_endpoint.call_with_http_info(**kwargs)

    def list_pagespeed_test_history(
        self,
        test_id,
        **kwargs
    ):
        """Get all pagespeed check history  # noqa: E501

        Returns a list of pagespeed check history results for a given id, detailing the runs performed on the StatusCake testing infrastruture.  The returned results are a paginated series. Alongside the response data is a `links` object referencing the current response document, `self`, and the next page in the series, `next`.  Aggregated data over the specified duration is returned in the root level `metadata` field.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_pagespeed_test_history(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Pagespeed check ID

        Keyword Args:
            limit (int): The number of results to return from the series. [optional] if omitted the server will use the default value of 25
            before (int): Only results created before this UNIX timestamp will be returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PagespeedTestHistory
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.list_pagespeed_test_history_endpoint.call_with_http_info(**kwargs)

    def list_pagespeed_tests(
        self,
        **kwargs
    ):
        """Get all pagespeed checks  # noqa: E501

        Returns a list of pagespeed checks for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_pagespeed_tests(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Page of results. [optional] if omitted the server will use the default value of 1
            limit (int): The number of pagespeed checks to return per page. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PagespeedTests
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_pagespeed_tests_endpoint.call_with_http_info(**kwargs)

    def update_pagespeed_test(
        self,
        test_id,
        **kwargs
    ):
        """Update a pagespeed check  # noqa: E501

        Updates a pagespeed check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_pagespeed_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Pagespeed check ID

        Keyword Args:
            name (str): Name of the check. [optional]
            check_rate (PagespeedTestCheckRate): [optional]
            alert_bigger (int): An alert will be sent if the size of the page is larger than this value (kb). A value of 0 prevents alerts being sent. . [optional]
            alert_slower (int): An alert will be sent if the load time of the page exceeds this value (ms). A value of 0 prevents alerts being sent . [optional]
            alert_smaller (int): An alert will be sent if the size of the page is smaller than this value (kb). A value of 0 prevents alerts being sent . [optional]
            contact_groups ([str]): List of contact group IDs. [optional]
            contact_groups_csv (str): Comma separated list of contact group IDs. [optional]
            paused (bool): Whether the check should be run. [optional]
            region (PagespeedTestRegion): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.update_pagespeed_test_endpoint.call_with_http_info(**kwargs)
