# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from wordsapi.configuration import Configuration
from wordsapi.controllers.base_controller import BaseController
from wordsapi.configuration import Environment
from wordsapi.http.auth.custom_header_authentication import CustomHeaderAuthentication
from wordsapi.controllers.ap_is_controller import APIsController


class WordsapiClient(object):
    @LazyProperty
    def ap_is(self):
        return APIsController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None,
                 environment=Environment.PRODUCTION, x_rapid_api_key=None,
                 custom_header_authentication_credentials=None, config=None):
        self.config = config or Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            environment=environment, x_rapid_api_key=x_rapid_api_key,
            custom_header_authentication_credentials=custom_header_authentication_credentials)

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())

        self.auth_managers = {key: None for key in ['RapidAPI-Key']}
        self.auth_managers['RapidAPI-Key'] = CustomHeaderAuthentication(
            self.config.custom_header_authentication_credentials)
        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

