# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper


class SyllableDetails(object):

    """Implementation of the 'syllableDetails' model.

    This custom type contains the syllable details for word API.

    Attributes:
        count (int): The count of syllables.
        list (List[str]): The list of syllables.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "count": 'count',
        "list": 'list'
    }

    _optionals = [
        'count',
        'list',
    ]

    def __init__(self,
                 count=APIHelper.SKIP,
                 list=APIHelper.SKIP):
        """Constructor for the SyllableDetails class"""

        # Initialize members of the class
        if count is not APIHelper.SKIP:
            self.count = count 
        if list is not APIHelper.SKIP:
            self.list = list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        count = dictionary.get("count") if dictionary.get("count") else APIHelper.SKIP
        list = dictionary.get("list") if dictionary.get("list") else APIHelper.SKIP
        # Return an object of this model
        return cls(count,
                   list)
