# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.models.frequency_details import FrequencyDetails


class FrequencyResponse(object):

    """Implementation of the 'FrequencyResponse' model.

    This custom type contains response for frequency endpoint.

    Attributes:
        word (str): The word that is searched.
        frequency (FrequencyDetails): This model contains frequency details of
            a specific word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "frequency": 'frequency'
    }

    def __init__(self,
                 word=None,
                 frequency=None):
        """Constructor for the FrequencyResponse class"""

        # Initialize members of the class
        self.word = word 
        self.frequency = frequency 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        word = dictionary.get("word") if dictionary.get("word") else None
        frequency = FrequencyDetails.from_dictionary(dictionary.get('frequency')) if dictionary.get('frequency') else None
        # Return an object of this model
        return cls(word,
                   frequency)
