from dissect.hypervisor.disk.vhd import VHD, DynamicDisk, FixedDisk


def test_vhd_fixed(fixed_vhd):
    vhd = VHD(fixed_vhd)
    assert vhd.size == 10485760
    assert isinstance(vhd.disk, FixedDisk)

    assert vhd.read(512) == bytes.fromhex(
        "33c08ed0bc007c8ec08ed8be007cbf0006b90002fcf3a450681c06cbfbb90400"
        "bdbe07807e00007c0b0f850e0183c510e2f1cd1888560055c6461105c6461000"
        "b441bbaa55cd135d720f81fb55aa7509f7c101007403fe46106660807e100074"
        "2666680000000066ff760868000068007c680100681000b4428a56008bf4cd13"
        "9f83c4109eeb14b80102bb007c8a56008a76018a4e028a6e03cd136661731cfe"
        "4e11750c807e00800f848a00b280eb845532e48a5600cd135deb9e813efe7d55"
        "aa756eff7600e88d007517fab0d1e664e88300b0dfe660e87c00b0ffe664e875"
        "00fbb800bbcd1a6623c0753b6681fb54435041753281f90201722c666807bb00"
        "006668000200006668080000006653665366556668000000006668007c000066"
        "6168000007cd1a5a32f6ea007c0000cd18a0b707eb08a0b607eb03a0b50732e4"
        "0500078bf0ac3c007409bb0700b40ecd10ebf2f4ebfd2bc9e464eb002402e0f8"
        "2402c3496e76616c696420706172746974696f6e207461626c65004572726f72"
        "206c6f6164696e67206f7065726174696e672073797374656d004d697373696e"
        "67206f7065726174696e672073797374656d000000637b9aeb3dad8c00000002"
        "030007e525008000000000380000000000000000000000000000000000000000"
        "00000000000000000000000000000000000000000000000000000000000055aa"
    )

    vhd.seek(0x200000)
    assert vhd.read(512) == b"\xFF" * 512


def test_vhd_dynamic(dynamic_vhd):
    vhd = VHD(dynamic_vhd)
    assert vhd.size == 10485760
    assert isinstance(vhd.disk, DynamicDisk)

    assert vhd.read(512) == bytes.fromhex(
        "33c08ed0bc007c8ec08ed8be007cbf0006b90002fcf3a450681c06cbfbb90400"
        "bdbe07807e00007c0b0f850e0183c510e2f1cd1888560055c6461105c6461000"
        "b441bbaa55cd135d720f81fb55aa7509f7c101007403fe46106660807e100074"
        "2666680000000066ff760868000068007c680100681000b4428a56008bf4cd13"
        "9f83c4109eeb14b80102bb007c8a56008a76018a4e028a6e03cd136661731cfe"
        "4e11750c807e00800f848a00b280eb845532e48a5600cd135deb9e813efe7d55"
        "aa756eff7600e88d007517fab0d1e664e88300b0dfe660e87c00b0ffe664e875"
        "00fbb800bbcd1a6623c0753b6681fb54435041753281f90201722c666807bb00"
        "006668000200006668080000006653665366556668000000006668007c000066"
        "6168000007cd1a5a32f6ea007c0000cd18a0b707eb08a0b607eb03a0b50732e4"
        "0500078bf0ac3c007409bb0700b40ecd10ebf2f4ebfd2bc9e464eb002402e0f8"
        "2402c3496e76616c696420706172746974696f6e207461626c65004572726f72"
        "206c6f6164696e67206f7065726174696e672073797374656d004d697373696e"
        "67206f7065726174696e672073797374656d000000637b9ae13dad8c00000002"
        "030007e525008000000000380000000000000000000000000000000000000000"
        "00000000000000000000000000000000000000000000000000000000000055aa"
    )

    vhd.seek(0x200000)
    assert vhd.read(512) == b"\xFF" * 512
    assert vhd.disk.read_sectors(0x3FFF, 16) == (b"\x00" * 512 * 16)
