% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentimsr.R
\name{rt_query}
\alias{rt_query}
\title{Get the retention time for each frame.}
\usage{
rt_query(
  opentims,
  min_retention_time,
  max_retention_time,
  columns = all_columns
)
}
\arguments{
\item{opentims}{Instance of OpenTIMS.}

\item{min_retention_time}{Lower boundry on retention time.}

\item{max_retention_time}{Upper boundry on retention time.}

\item{columns}{Vector of columns to extract. Defaults to all columns.}
}
\value{
data.frame with selected columns.
}
\description{
Extract all frames corresponding to retention times inside [min_retention_time, max_retention_time] closed borders interval.
}
\examples{
\dontrun{
D = OpenTIMS('path/to/your/folder.d')
print(rt_query(D, 10, 100)) # frames between tenth and a hundreth second of the experiment
}
}
