# Generated by Django 3.1.7 on 2022-04-22 20:51

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('dcim', '0122_standardize_name_length'),
        ('tenancy', '0011_standardize_name_length'),
        ('virtualization', '0019_standardize_name_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='IC',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('assigned_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('assigned_object_type', models.ForeignKey(blank=True, limit_choices_to=models.Q(models.Q(models.Q(('app_label', 'dcim'), ('model', 'device')), models.Q(('app_label', 'circuits'), ('model', 'circuit')), models.Q(('app_label', 'virtualization'), ('model', 'virtualmachine')), models.Q(('app_label', 'nb_service'), ('model', 'application')), _connector='OR')), null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=100)),
                ('comments', models.TextField(blank=True)),
                ('backup_profile', models.CharField(max_length=100)),
                ('clients', models.ManyToManyField(related_name='itsm_services', to='tenancy.Tenant')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Relation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('source_shape', models.IntegerField()),
                ('destination_shape', models.IntegerField()),
                ('connector_shape', models.IntegerField()),
                ('link_text', models.CharField(max_length=100)),
                ('destination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='nb_service.ic')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='relationships', to='nb_service.service')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='nb_service.ic')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PenTest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('comments', models.TextField(blank=True)),
                ('status', models.IntegerField(blank=True)),
                ('date', models.DateField(blank=True)),
                ('ticket', models.CharField(max_length=100)),
                ('report_link', models.CharField(max_length=100)),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pentest_reports', to='nb_service.service')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='ic',
            name='service',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='config_itens', to='nb_service.service'),
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=100)),
                ('protocol', models.CharField(max_length=50)),
                ('ports', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)]), size=None)),
                ('version', models.CharField(max_length=100)),
                ('devices', models.ManyToManyField(blank=True, related_name='uses_apps', to='dcim.Device')),
                ('vm', models.ManyToManyField(blank=True, related_name='uses_apps', to='virtualization.VirtualMachine')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='ic',
            unique_together={('service', 'assigned_object_type', 'assigned_object_id')},
        ),
    ]
