"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsRuleToStepFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
class EventsRuleToStepFunction extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the EventsRuleToStepFunction class.
     * @since 0.9.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        [this.stateMachine, this.stateMachineLogGroup] = defaults.buildStateMachine(this, props.stateMachineProps, props.logGroupProps);
        // Create an IAM role for Events to start the State Machine
        const eventsRole = new iam.Role(this, 'EventsRuleRole', {
            assumedBy: new iam.ServicePrincipal('events.amazonaws.com')
        });
        // Grant the start execution permission to the Events service
        this.stateMachine.grantStartExecution(eventsRole);
        // Setup the Events target
        const stateMachine = {
            bind: () => ({
                id: '',
                arn: this.stateMachine.stateMachineArn,
                role: eventsRole
            })
        };
        // Defaults props for the Events
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([stateMachine]);
        // Override the defaults with the user provided props
        const eventsRuleProps = core_2.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Create the Events Rule for the State Machine
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for State Machine
            this.cloudwatchAlarms = defaults.buildStepFunctionCWAlarms(this, this.stateMachine);
        }
    }
}
exports.EventsRuleToStepFunction = EventsRuleToStepFunction;
_a = JSII_RTTI_SYMBOL_1;
EventsRuleToStepFunction[_a] = { fqn: "@aws-solutions-constructs/aws-events-rule-step-function.EventsRuleToStepFunction", version: "1.108.0" };
//# sourceMappingURL=data:application/json;base64,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