# generated by datamodel-codegen:
#   filename:  partner_outbound_api.yaml
#   timestamp: 2022-05-18T08:40:47+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, List, Optional

from pydantic import AnyUrl, BaseModel, Field


class Configuration(BaseModel):
    """
    Authentication configuration details required by the Partner API.
    """

    __root__: Optional[dict] = None


class Mandate(BaseModel):
    """
    Customer mandate to bank.
    """

    dateOfSignature: Optional[str] = Field(
        None,
        description="The date the direct debit mandate was signed.",
        regex="^(19|20)([0-9]{2})-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$",
    )
    id: Optional[str] = Field(None, description="The ID of the direct debit mandate.", regex="^[a-zA-Z0-9]{35}$")
    reference: Optional[str] = Field(
        None,
        description="The mandate reference for direct debit as a contractual agreement between the creditor and the debtor.",
        regex="^[a-zA-Z0-9]{32}$",
    )


class Browser(BaseModel):
    """
    The customer's browser details.
    """

    acceptHeader: Optional[str] = Field(
        None,
        description="The value of the accept header sent from the customer's browser.",
        example="application/json",
        regex="^[\\s\\S]{1,2048}$",
    )
    language: Optional[str] = Field(
        None,
        description="The value representing the browser language as defined in IETF BCP47.",
        example="EN",
        regex="^[\\s\\S]{1,8}$",
    )
    screenHeight: Optional[str] = Field(
        None,
        description="The total height of the customer's screen in pixels.",
        example="1080",
        regex="^[\\s\\S]{1,6}$",
    )
    screenWidth: Optional[str] = Field(
        None, description="The total width of the customer's screen in pixels.", example="1920", regex="^[\\s\\S]{1,6}$"
    )
    timezone: Optional[str] = Field(
        None,
        description="The time-zone offset in minutes between UTC and the local time of the customer's browser.",
        example="30",
        regex="^[\\s\\S]{1,5}$",
    )
    userAgent: Optional[str] = Field(
        None,
        description="The exact content of the HTTP user-agent header.",
        example="Mozilla/5.0 (Android 4.4; Mobile; rv:41.0) Gecko/41.0 Firefox/41.0",
        regex="^[\\s\\S]{1,2048}$",
    )
    javaEnabled: Optional[str] = Field(
        None,
        description="The boolean that represents the ability of the customer's browser to execute Java.",
        example="false",
        regex="^(true|false)$",
    )
    javascriptEnabled: Optional[str] = Field(
        None,
        description="The boolean that represents the ability of the customer's browser to execute JavaScript.",
        example="true",
        regex="^(true|false)$",
    )
    screenColorDepth: Optional[str] = Field(
        None,
        description="The value representing the bit depth of the colour palette for displaying images in bits per pixel.",
        example="24",
        regex="^[0-9]{1,2}$",
    )
    challengeWindow: Optional[str] = Field(
        None,
        description="The dimensions of the challenge window that has been displayed to the customer.",
        example="01",
        regex="^[0-9]{1,2}$",
    )


class Customer(BaseModel):
    """
    Optional object sent if partner requires customer data.
    """

    email: Optional[str] = Field(
        None,
        description="The customer's email  address.",
        example="name@example.com",
        regex="^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$",
    )
    fax: Optional[str] = Field(
        None,
        description="The customer's fax number, if provided.",
        example="2919392022",
        regex="^[+0-9][0-9 \\.()/-]{7,25}$",
    )
    givenName: Optional[str] = Field(
        None,
        description="The customer's first name or given name.",
        example="Jane",
        regex="^[\\w'\\-,.][^0-9_!¡?÷?¿/\\\\+=@#$%ˆ&*(){}|~<>;:[\\]]{2,127}$",
    )
    surname: Optional[str] = Field(
        None,
        description="The customer's last name or surname.",
        example="Doe",
        regex="^[\\w'\\-,.][^0-9_!¡?÷?¿/\\\\+=@#$%ˆ&*(){}|~<>;:[\\]]{2,127}$",
    )
    mobile: Optional[str] = Field(
        None,
        description="The customer's mobile phone number.",
        example="27610107822",
        regex="^[+0-9][0-9 \\.()/-]{5,25}$",
    )
    phone: Optional[str] = Field(
        None, description="The customer's phone number.", example="27210030000", regex="^[+0-9][0-9 \\.()/-]{7,25}$"
    )
    ip: Optional[str] = Field(None, description="The customer's IP address.", example="0.0.0.0")
    merchantCustomerLanguage: Optional[str] = Field(
        None,
        description="The language used for the customer on the merchant's site.",
        example="EN",
        regex="^[\\s\\S]{1,255}$",
    )
    status: Optional[str] = Field(
        None,
        description="Used to determine if this is a new or returning customer.",
        example="NEW",
        regex="^[\\s\\S]{1,255}$",
    )
    merchantCustomerId: Optional[str] = Field(
        None, description="The customer's ID on the merchant's site.", example="sxxopjqy", regex="^[\\s\\S]{1,255}$"
    )
    taxId: Optional[str] = Field(
        None, description="The customer's tax ID, if required.", example="4550045030303", regex="^[\\s\\S]{1,100}$"
    )
    taxType: Optional[str] = Field(
        None, description="The customer's tax type, if required.", example="tax type", regex="^[\\s\\S]{1,255}$"
    )
    birthDate: Optional[str] = Field(
        None,
        description="The customer's birth date.",
        example="1996-08-07",
        regex="^(19|20)([0-9]{2})-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$",
    )
    browser: Optional[Browser] = Field(None, description="The customer's browser details.")


class CartItem(BaseModel):
    name: Optional[str] = Field(
        None, description="The name of the item in the shopping cart.", example="Laptop", regex="^[\\s\\S]{1,255}$"
    )
    merchantItemId: Optional[str] = Field(
        None,
        description="The unique identifier of the item in the shopping cart.",
        example="item123",
        regex="^[\\s\\S]{1,255}$",
    )
    quantity: Optional[str] = Field(
        None, description="The number of items in the shopping cart.", example="125", regex="^[1-9][0-9]{0,11}$"
    )
    price: Optional[str] = Field(
        None,
        description="The price of the item in the shopping cart.",
        example="05.25",
        regex="^[0-9]{1,10}\\.[0-9]{2}$",
    )
    description: Optional[str] = Field(
        None, description="The description of the item in the shopping cart.", regex="^[\\s\\S]{1,2048}$"
    )
    weightInKg: Optional[str] = Field(
        None,
        description="The weight (in kg) of the item in the shopping cart.",
        example="05.25",
        regex="^[0-9]{1,10}\\.[0-9]{2}$",
    )
    category: Optional[str] = Field(
        None,
        description="The category of the item in the shopping cart.",
        example="electronics",
        regex="^[\\s\\S]{1,2048}$",
    )


class Cart(BaseModel):
    """
    Customer cart data.
    """

    cartItems: Optional[List[CartItem]] = Field(None, description="List of details of the items in the cart.")
    tax: Optional[str] = Field(
        None,
        description="The tax percentage applied to the price of the item in the shopping cart.",
        regex="^[0-9]{1,8}(\\.[0-9]{2})?$",
    )
    shippingAmount: Optional[str] = Field(
        None,
        description="The shipping amount applied to the item in the shopping cart.",
        example="12.25",
        regex="^[0-9]{1,10}\\.[0-9]{2}$",
    )
    discount: Optional[str] = Field(
        None,
        description="The discount percentage applied to the price of the item in the shopping cart.",
        example="02.25",
        regex="^[0-9]{1,10}\\.[0-9]{2}$",
    )


class CustomParameters(BaseModel):
    """
    A JSON object depicting custom information sent by the merchant and Peach. Must be echoed back in the response.
    """

    __root__: Optional[dict] = None


class Recon(BaseModel):
    """
    The transaction reconciliation data.
    """

    ciMerchantNumber: Optional[str] = Field(
        None, description="The clearing institute merchant number.", regex="^[\\s\\S]{1,128}$"
    )
    rrn: Optional[str] = Field(None, description="The recon reference number from the bank.", regex="^[\\s\\S]{1,128}$")
    stan: Optional[str] = Field(None, description="The STAN reference number from the bank.", regex="^[\\s\\S]{1,128}$")
    authCode: Optional[str] = Field(None, description="The auth code returned by the bank.", regex="^[\\s\\S]{1,128}$")
    resultCode: Optional[str] = Field(
        None, description="The result code provided by the bank.", regex="^[\\s\\S]{1,128}$"
    )


class Data(BaseModel):
    """
    Optional object that can be used for billing or shipping information.
    """

    city: Optional[str] = Field(
        None,
        description="The town, district, or city linked to billing or shipping.",
        example="Cape Town",
        regex="^[\\s\\S]{1,48}$",
    )
    company: Optional[str] = Field(
        None, description="The customer's company name.", example="Company name", regex="^[\\s\\S]{1,255}$"
    )
    country: Optional[str] = Field(
        None, description="The country linked to billing or shipping.", example="ZA", regex="^[A-Z]{2}$"
    )
    houseNumber1: Optional[str] = Field(
        None,
        description="Primary house number of the billing or shipping address.",
        example="25567",
        regex="^[\\s\\S]{1,100}$",
    )
    postcode: Optional[str] = Field(
        None,
        description="The postal code or zip code of the billing or shipping address.",
        example="8001",
        regex="^[\\s\\S]{1,16}$",
    )
    state: Optional[str] = Field(
        None,
        description="The county, state, or region of the billing address.",
        example="Nasarawa",
        regex="^[a-zA-Z0-9\\.]{1,10}$",
    )
    street1: Optional[str] = Field(
        None,
        description="The door number, floor, building number, building name, and/or street name of the billing or shipping address.",
        example="Langtree Lane",
        regex="^[\\s\\S]{1,95}$",
    )
    street2: Optional[str] = Field(
        None,
        description="Secondary house number of the billing or shipping address. Used when more addresses are bundled to the same primary house number. If present, houseNumber1 is mandatory.",
        example="Loe Street",
        regex="^[\\s\\S]{1,95}$",
    )
    customer: Optional[Customer] = None


class ResultDetails(BaseModel):
    """
    Additional details from the partner that can provide information about the status or result of the transaction.
    """

    __root__: Optional[dict] = None


class Parameter(BaseModel):
    name: Optional[str] = None
    value: Optional[str] = None


class Method(Enum):
    """
    REST method used for redirection.
    """

    GET = "GET"
    POST = "POST"


class Redirect(BaseModel):
    url: AnyUrl = Field(
        ...,
        description="The URL that the shopper must be redirected to in order to proceed.",
        example="https://test.yourdomain.com/link?",
    )
    parameters: List[Parameter] = Field(
        ...,
        description="Array of parameter names and values for the redirect URL.",
        example=[
            {"name": "MD", "value": "8ac7a49f7921f2fd0179230196ec4bbe"},
            {
                "name": "TermUrl",
                "value": "https://test.yourdomain.com/connectors/asyncresponse_simulator;jsessionid=021942B282D8.uat01-vm-con01?asyncsource=THREEDSECURE",
            },
        ],
    )
    method: Method = Field(..., description="REST method used for redirection.", example="POST")


class ParameterError(BaseModel):
    value: Any = Field(
        ...,
        description="The value of the parameter which failed validation. Can be any value - string, number, boolean, array, or object.",
    )
    name: str = Field(..., description="The name of the parameter.")
    message: str = Field(..., description="A message describing the error.")


class ParameterErrors(BaseModel):
    """
    Error details of the request parameters which failed validation.
    """

    __root__: List[ParameterError] = Field(
        ...,
        description="Error details of the request parameters which failed validation.",
        example=[
            {"value": "null", "name": "authenticationValue", "message": "Partner API requires authenticationValue."}
        ],
    )


class Amount(BaseModel):
    __root__: str = Field(
        ..., description="The payment request amount.", example="22.50", regex="(?!0+\\.00)^\\d{1,10}\\.\\d{2}$"
    )


class Currency(BaseModel):
    __root__: str = Field(
        ..., description="The currency code of the payment request's amount.", example="ZAR", regex="^[A-Z]{3}$"
    )


class PaymentBrand(BaseModel):
    __root__: str = Field(
        ...,
        description="The payment brand specifies the method of payment for the request.",
        example="PartnerBrand",
        regex="^[a-zA-Z0-9_]{1,32}$",
    )


class UniqueId(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique transaction ID provided by Peach.",
        example="b4508276b8d146728dac871d6f68b45d",
        regex="^[0-9a-f]{32}$",
    )


class ConnectorTxID1(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique transaction identifier provided by the partner.",
        example="8ac7a49f7921f2fd0179230196ec4bbe",
        regex="^[\\S]{1,64}$",
    )


class Timestamp(BaseModel):
    __root__: datetime = Field(
        ..., description="The timestamp of the transaction.", example="2021-04-23T07:41:25.519947Z"
    )


class NotificationUrl(BaseModel):
    __root__: AnyUrl = Field(
        ...,
        description="The Peach-provided URL to which the partner is required to send notifications or webhooks when the transaction status is updated.",
        example="https://peachnotify.com",
    )


class PaymentType(Enum):
    """
    Payment type of the transaction.
    """

    DB = "DB"
    RF = "RF"


class Code(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique code that indicates the result status of the request.",
        example="800.100.153",
        regex="^([0-9]{3}.[0-9]{3}.[0-9]{3})$",
    )


class MerchantTransactionId(BaseModel):
    __root__: str = Field(
        ...,
        description="Merchant-provided reference number, often used for reconciliation.",
        example="test-12345",
        regex="^[\\s\\S]{1,255}$",
    )


class ClearingInstituteSessionId(BaseModel):
    __root__: str = Field(
        ...,
        description="Session ID of the transaction, provided by the partner.",
        example="6262",
        regex="^[\\s\\S]{1,32}$",
    )


class ExpiryMonth(BaseModel):
    __root__: str = Field(..., description="The expiry month of the card.", example="01", regex="^(0[1-9]|1[0-2])$")


class ExpiryYear(BaseModel):
    __root__: str = Field(..., description="The expiry year of the card.", example="2030", regex="^(20)([0-9]{2})$")


class Holder(BaseModel):
    __root__: str = Field(
        ...,
        description="The credit card account holder.",
        example="Jane Doe",
        regex="^[\\w'\\-,.][^0-9_!¡?÷?¿/\\\\+=@#$%ˆ&*(){}|~<>;:[\\]]{2,127}$",
    )


class RefundRequest(BaseModel):
    uniqueId: UniqueId
    configuration: Configuration
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    customer: Optional[Customer] = None
    customParameters: Optional[CustomParameters] = None
    notificationUrl: NotificationUrl
    timestamp: Timestamp


class CancelRequest(BaseModel):
    configuration: Configuration
    paymentBrand: PaymentBrand
    customParameters: Optional[CustomParameters] = None
    merchantTransactionId: Optional[MerchantTransactionId] = None
    notificationUrl: NotificationUrl
    clearingInstituteSessionId: Optional[ClearingInstituteSessionId] = None
    timestamp: Timestamp


class BankAccount(BaseModel):
    """
    Customer bank account details.
    """

    holder: Optional[str] = Field(None, description="The bank account holder.", regex="^[\\s\\S]{4,128}$")
    bankName: Optional[str] = Field(
        None, description="The name of the bank which holds the account.", regex="^[\\s\\S]{1,255}$"
    )
    number: Optional[str] = Field(None, description="The bank account number.", regex="^[a-zA-Z0-9]{3,64}$")
    iban: Optional[str] = Field(
        None,
        description="The IBAN (International Bank Account Number) associated with the bank account.",
        regex="^[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{11,27}$",
    )
    bic: Optional[str] = Field(
        None,
        description="The BIC (Bank Identifier Code (SWIFT)) of the bank account.",
        regex="^[a-zA-Z0-9]{8}|[a-zA-Z0-9]{11}$",
    )
    bankCode: Optional[str] = Field(
        None, description="The code associated with the bank account.", regex="^[a-zA-Z0-9]{1,12}$"
    )
    country: Optional[str] = Field(
        None, description="The country code of the bank account (ISO 3166-1).", regex="^[a-zA-Z]{2}$"
    )
    mandate: Optional[Mandate] = None
    transactionDueDate: Optional[str] = Field(
        None,
        description="The due date of the transaction of the direct debit.",
        regex="^(19|20)([0-9]{2})-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$",
    )


class DebitRequestCard(BaseModel):
    """
    The card data structure holds all information regarding a credit or debit card account.
    """

    number: str = Field(
        ...,
        description="The primary account number (PAN) of the card.",
        example="4242424242424242",
        regex="^[0-9]{12,19}$",
    )
    cvv: Optional[str] = Field(
        None, description="The security code or CVV of the card.", example="123", regex="^[0-9]{3,4}$"
    )
    holder: Optional[Holder] = None
    expiryMonth: ExpiryMonth
    expiryYear: ExpiryYear


class StatusResponseCard(BaseModel):
    """
    The card data structure holds all information regarding a credit or debit card account.
    """

    bin: Optional[str] = Field(
        None, description="The first six digits of the card number.", example="455112", regex="^[\\d]{6}$"
    )
    last4Digits: Optional[str] = Field(
        None, description="The last 4 digits of the credit or debit card.", example="2315", regex="^[\\d]{4}$"
    )
    holder: Optional[Holder] = None
    expiryMonth: Optional[ExpiryMonth] = None
    expiryYear: Optional[ExpiryYear] = None


class Result(BaseModel):
    code: Code


class ErrorResponse(BaseModel):
    result: Result
    resultDetails: Optional[ResultDetails] = None
    timestamp: Timestamp


class Error400Result(BaseModel):
    code: Code
    parameterErrors: ParameterErrors


class DebitRequest(BaseModel):
    uniqueId: UniqueId
    configuration: Configuration
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    customer: Optional[Customer] = None
    customParameters: Optional[CustomParameters] = None
    merchantTransactionId: Optional[MerchantTransactionId] = None
    merchantName: str = Field(
        ..., description="The merchant's name.", example="Shopping Merchant", regex="^[\\s\\S]{1,255}$"
    )
    merchantInvoiceId: Optional[str] = Field(
        None,
        description="The merchant's invoice ID.",
        example="20170630-4072-00",
        regex="^[\\w~!@#$%\\^&*()+\\-,./:?\\][\\\\\\{}`;|\\\"']{8,255}$",
    )
    notificationUrl: NotificationUrl
    clearingInstituteSessionId: Optional[ClearingInstituteSessionId] = None
    shopperResultUrl: AnyUrl = Field(
        ...,
        description="The Payment Service Provider must redirect the user to this URL after processing the payment request.",
        example="https://peachredirect.com/v1/redirect/paymentBrand",
    )
    card: Optional[DebitRequestCard] = None
    billing: Optional[Data] = None
    shipping: Optional[Data] = None
    timestamp: Timestamp
    cart: Optional[Cart] = None


class DebitResponse(BaseModel):
    uniqueId: UniqueId
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    result: Result
    resultDetails: Optional[ResultDetails] = None
    redirect: Redirect
    connectorTxID1: ConnectorTxID1
    customParameters: Optional[CustomParameters] = None
    timestamp: Timestamp
    clearingInstituteSessionId: Optional[ClearingInstituteSessionId] = None


class RefundResponse(BaseModel):
    uniqueId: UniqueId
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    result: Result
    resultDetails: Optional[ResultDetails] = None
    connectorTxID1: ConnectorTxID1
    timestamp: Timestamp
    customParameters: Optional[CustomParameters] = None


class CancelResponse(BaseModel):
    uniqueId: UniqueId
    paymentBrand: PaymentBrand
    result: Result
    resultDetails: Optional[ResultDetails] = None
    connectorTxID1: ConnectorTxID1
    timestamp: Timestamp
    customParameters: Optional[CustomParameters] = None


class StatusResponse(BaseModel):
    uniqueId: UniqueId
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    result: Result
    resultDetails: Optional[ResultDetails] = None
    connectorTxID1: ConnectorTxID1
    clearingInstituteSessionId: Optional[ClearingInstituteSessionId] = None
    timestamp: Timestamp
    recon: Optional[Recon] = None
    bankAccount: Optional[BankAccount] = None
    card: Optional[StatusResponseCard] = None
    customParameters: Optional[CustomParameters] = None


class Error400Response(BaseModel):
    result: Error400Result
    resultDetails: Optional[ResultDetails] = None
    timestamp: Timestamp
