"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resource = void 0;
const constructs_1 = require("constructs");
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
class Resource extends constructs_1.Construct {
    constructor(scope, id, _) {
        super(scope, id);
    }
    get metadata() {
        return this.apiObject.metadata;
    }
    /**
     * The name of this API object.
     */
    get name() {
        return this.apiObject.name;
    }
}
exports.Resource = Resource;
//# sourceMappingURL=data:application/json;base64,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