"""
    Cisco SD-WAN vManage API

    The vManage API exposes the functionality of operations maintaining devices and the overlay network  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: vmanage@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class RealTimeMonitoringIPsecApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_crypto_ipsec_identity_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/identity',
                'operation_id': 'create_crypto_ipsec_identity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                    ('local_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                    'local_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                    'local_tloc_color': 'local-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                    'local_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_cryptov1_local_sa_list_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/ikev1',
                'operation_id': 'create_cryptov1_local_sa_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_cryptov2_local_sa_list_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/ikev2',
                'operation_id': 'create_cryptov2_local_sa_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_i_psec_pwk_inbound_connections_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/pwk/inbound',
                'operation_id': 'create_i_psec_pwk_inbound_connections',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                    ('local_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                    'local_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                    'local_tloc_color': 'local-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                    'local_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_i_psec_pwk_local_sa_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/pwk/localsa',
                'operation_id': 'create_i_psec_pwk_local_sa',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                    ('local_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                    'local_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                    'local_tloc_color': 'local-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                    'local_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_i_psec_pwk_outbound_connections_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/ipsec/pwk/outbound',
                'operation_id': 'create_i_psec_pwk_outbound_connections',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                    ('local_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                    'local_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                    'local_tloc_color': 'local-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                    'local_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_ike_inbound_list_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/ike/inbound',
                'operation_id': 'create_ike_inbound_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_ike_outbound_list_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/ike/outbound',
                'operation_id': 'create_ike_outbound_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_ike_sessions_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/ike/sessions',
                'operation_id': 'create_ike_sessions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_in_bound_list_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/inbound',
                'operation_id': 'create_in_bound_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                    'local_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                    ('local_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                    'local_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                    'local_tloc_color': 'local-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                    'local_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_local_sa_list_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/localsa',
                'operation_id': 'create_local_sa_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_out_bound_list_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [],
                'endpoint_path': '/device/ipsec/outbound',
                'operation_id': 'create_out_bound_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                    'remote_tloc_address',
                    'remote_tloc_color',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'remote_tloc_color',
                ],
                'validation': [
                    'device_id',
                ]
            },
            root_map={
                'validations': {
                    ('device_id',): {

                        'regex': {
                            'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('remote_tloc_color',): {

                        "DEFAULT": "default",
                        "MPLS": "mpls",
                        "METRO-ETHERNET": "metro-ethernet",
                        "BIZ-INTERNET": "biz-internet",
                        "PUBLIC-INTERNET": "public-internet",
                        "LTE": "lte",
                        "3G": "3g",
                        "RED": "red",
                        "GREEN": "green",
                        "BLUE": "blue",
                        "GOLD": "gold",
                        "SILVER": "silver",
                        "BRONZE": "bronze",
                        "CUSTOM1": "custom1",
                        "CUSTOM2": "custom2",
                        "CUSTOM3": "custom3",
                        "PRIVATE1": "private1",
                        "PRIVATE2": "private2",
                        "PRIVATE3": "private3",
                        "PRIVATE4": "private4",
                        "PRIVATE5": "private5",
                        "PRIVATE6": "private6"
                    },
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                    'remote_tloc_address':
                        (str,),
                    'remote_tloc_color':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                    'remote_tloc_address': 'remote-tloc-address',
                    'remote_tloc_color': 'remote-tloc-color',
                },
                'location_map': {
                    'device_id': 'query',
                    'remote_tloc_address': 'query',
                    'remote_tloc_color': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_crypto_ipsec_identity(
        self,
        device_id,
        **kwargs
    ):
        """create_crypto_ipsec_identity  # noqa: E501

        Get Crypto IPSEC identity entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_crypto_ipsec_identity(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            local_tloc_color (str): Local tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_crypto_ipsec_identity_endpoint.call_with_http_info(**kwargs)

    def create_cryptov1_local_sa_list(
        self,
        device_id,
        **kwargs
    ):
        """create_cryptov1_local_sa_list  # noqa: E501

        Get Crypto IKEv1 SA entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cryptov1_local_sa_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_cryptov1_local_sa_list_endpoint.call_with_http_info(**kwargs)

    def create_cryptov2_local_sa_list(
        self,
        device_id,
        **kwargs
    ):
        """create_cryptov2_local_sa_list  # noqa: E501

        Get Crypto IKEv2 SA entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cryptov2_local_sa_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_cryptov2_local_sa_list_endpoint.call_with_http_info(**kwargs)

    def create_i_psec_pwk_inbound_connections(
        self,
        device_id,
        **kwargs
    ):
        """create_i_psec_pwk_inbound_connections  # noqa: E501

        Get IPSEC pairwise key inbound entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_i_psec_pwk_inbound_connections(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            local_tloc_color (str): Local tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_i_psec_pwk_inbound_connections_endpoint.call_with_http_info(**kwargs)

    def create_i_psec_pwk_local_sa(
        self,
        device_id,
        **kwargs
    ):
        """create_i_psec_pwk_local_sa  # noqa: E501

        Get IPSEC pairwise key local SA  entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_i_psec_pwk_local_sa(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            local_tloc_color (str): Local tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_i_psec_pwk_local_sa_endpoint.call_with_http_info(**kwargs)

    def create_i_psec_pwk_outbound_connections(
        self,
        device_id,
        **kwargs
    ):
        """create_i_psec_pwk_outbound_connections  # noqa: E501

        Get IPSEC pairwise key outbound entry from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_i_psec_pwk_outbound_connections(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            local_tloc_color (str): Local tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_i_psec_pwk_outbound_connections_endpoint.call_with_http_info(**kwargs)

    def create_ike_inbound_list(
        self,
        device_id,
        **kwargs
    ):
        """create_ike_inbound_list  # noqa: E501

        Get IPsec IKE inbound connection list from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ike_inbound_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_ike_inbound_list_endpoint.call_with_http_info(**kwargs)

    def create_ike_outbound_list(
        self,
        device_id,
        **kwargs
    ):
        """create_ike_outbound_list  # noqa: E501

        Get IPsec IKE outbound connection list from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ike_outbound_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_ike_outbound_list_endpoint.call_with_http_info(**kwargs)

    def create_ike_sessions(
        self,
        device_id,
        **kwargs
    ):
        """create_ike_sessions  # noqa: E501

        Get IPsec IKE sessions from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ike_sessions(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_ike_sessions_endpoint.call_with_http_info(**kwargs)

    def create_in_bound_list(
        self,
        device_id,
        **kwargs
    ):
        """create_in_bound_list  # noqa: E501

        Get IPsec inbound connection list from device (Real Time)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_in_bound_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            local_tloc_color (str): Local tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_in_bound_list_endpoint.call_with_http_info(**kwargs)

    def create_local_sa_list(
        self,
        device_id,
        **kwargs
    ):
        """create_local_sa_list  # noqa: E501

        Get IPsec local SA list from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_local_sa_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_local_sa_list_endpoint.call_with_http_info(**kwargs)

    def create_out_bound_list(
        self,
        device_id,
        **kwargs
    ):
        """create_out_bound_list  # noqa: E501

        Get IPsec outbound connection list from device (Real Time)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_out_bound_list(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device IP

        Keyword Args:
            remote_tloc_address (str): Remote TLOC address. [optional]
            remote_tloc_color (str): Remote tloc color. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.create_out_bound_list_endpoint.call_with_http_info(**kwargs)

