# openapi_client.RealTimeMonitoringPPPoEApi

All URIs are relative to *https://1.1.1.1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_pppo_e_interface_list**](RealTimeMonitoringPPPoEApi.md#create_pppo_e_interface_list) | **GET** /device/pppoe/session | 
[**create_pppo_e_neighbor_list**](RealTimeMonitoringPPPoEApi.md#create_pppo_e_neighbor_list) | **GET** /device/pppoe/statistic | 


# **create_pppo_e_interface_list**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} create_pppo_e_interface_list(device_id)



Get PPPoE session list from device

### Example


```python
import time
import openapi_client
from openapi_client.api import real_time_monitoring_pppo_e_api
from openapi_client.model.device_ip import DeviceIP
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = real_time_monitoring_pppo_e_api.RealTimeMonitoringPPPoEApi(api_client)
    device_id = DeviceIP(
        device_ip="device_ip_example",
    ) # DeviceIP | Device IP

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_pppo_e_interface_list(device_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling RealTimeMonitoringPPPoEApi->create_pppo_e_interface_list: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **DeviceIP**| Device IP |

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_pppo_e_neighbor_list**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} create_pppo_e_neighbor_list(device_id)



Get PPPoE statistics from device

### Example


```python
import time
import openapi_client
from openapi_client.api import real_time_monitoring_pppo_e_api
from openapi_client.model.device_ip import DeviceIP
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = real_time_monitoring_pppo_e_api.RealTimeMonitoringPPPoEApi(api_client)
    device_id = DeviceIP(
        device_ip="device_ip_example",
    ) # DeviceIP | Device IP

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_pppo_e_neighbor_list(device_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling RealTimeMonitoringPPPoEApi->create_pppo_e_neighbor_list: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **DeviceIP**| Device IP |

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

