import { BaseGLGlyph, Transform } from "./base";
import { ReglWrapper } from "./regl_wrap";
import type { ScatterView } from "../scatter";
import type { CircleView } from "../circle";
import { MarkerType } from "../../../core/enums";
declare type MarkerLikeView = ScatterView | CircleView;
export declare class MarkerGL extends BaseGLGlyph {
    readonly glyph: MarkerLikeView;
    readonly marker_type: MarkerType;
    protected _marker_type: MarkerType;
    protected _antialias: number;
    protected _centers: Float32Array;
    protected _sizes: number[] | Float32Array;
    protected _angles: number[] | Float32Array;
    protected _linewidths: number[] | Float32Array;
    protected _line_rgba: Uint8Array;
    protected _fill_rgba: Uint8Array;
    protected _show: Uint8Array;
    protected _show_all: boolean;
    static is_supported(marker_type: MarkerType): boolean;
    constructor(regl_wrapper: ReglWrapper, glyph: MarkerLikeView, marker_type: MarkerType);
    draw(indices: number[], main_glyph: MarkerLikeView, transform: Transform): void;
    protected _set_data(): void;
    protected _set_visuals(): void;
}
export {};
//# sourceMappingURL=markers.d.ts.map