/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(r,t,_,a,n){a();var o=r(1);r(2),o.__exportStar(r(116),_)},
function _(t,e,r,n,o){n();var a=function(t,e){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r])})(t,e)};r.__extends=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,r=e&&t[e],n=0;if(r)return r.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var r="function"==typeof Symbol&&t[Symbol.iterator];if(!r)return t;var n,o,a=r.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(t){o={error:t}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}r.__assign=function(){return r.__assign=Object.assign||function(t){for(var e,r=1,n=arguments.length;r<n;r++)for(var o in e=arguments[r])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},r.__assign.apply(this,arguments)},r.__rest=function(t,e){var r={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(r[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(t);o<n.length;o++)e.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(t,n[o])&&(r[n[o]]=t[n[o]])}return r},r.__decorate=function(t,e,r,n){var o,a=arguments.length,i=a<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,r,n);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,r,i):o(e,r))||i);return a>3&&i&&Object.defineProperty(e,r,i),i},r.__param=function(t,e){return function(r,n){e(r,n,t)}},r.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},r.__awaiter=function(t,e,r,n){return new(r||(r=Promise))((function(o,a){function i(t){try{u(n.next(t))}catch(t){a(t)}}function c(t){try{u(n.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(i,c)}u((n=n.apply(t,e||[])).next())}))},r.__generator=function(t,e){var r,n,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;i;)try{if(r=1,n&&(o=2&a[0]?n.return:a[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,a[1])).done)return o;switch(n=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,n=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],n=0}finally{r=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},r.__createBinding=Object.create?function(t,e,r,n){void 0===n&&(n=r),Object.defineProperty(t,n,{enumerable:!0,get:function(){return e[r]}})}:function(t,e,r,n){void 0===n&&(n=r),t[n]=e[r]},r.__exportStar=function(t,e){for(var n in t)"default"===n||Object.prototype.hasOwnProperty.call(e,n)||r.__createBinding(e,t,n)},r.__values=i,r.__read=c,r.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},r.__spreadArrays=function(){for(var t=0,e=0,r=arguments.length;e<r;e++)t+=arguments[e].length;var n=Array(t),o=0;for(e=0;e<r;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n},r.__spreadArray=function(t,e){for(var r=0,n=e.length,o=t.length;r<n;r++,o++)t[o]=e[r];return t},r.__await=u,r.__asyncGenerator=function(t,e,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(t,e||[]),a=[];return n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n;function i(t){o[t]&&(n[t]=function(e){return new Promise((function(r,n){a.push([t,e,r,n])>1||c(t,e)}))})}function c(t,e){try{(r=o[t](e)).value instanceof u?Promise.resolve(r.value.v).then(f,l):s(a[0][2],r)}catch(t){s(a[0][3],t)}var r}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},r.__asyncDelegator=function(t){var e,r;return e={},n("next"),n("throw",(function(t){throw t})),n("return"),e[Symbol.iterator]=function(){return this},e;function n(n,o){e[n]=t[n]?function(e){return(r=!r)?{value:u(t[n](e)),done:"return"===n}:o?o(e):e}:o}},r.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,r=t[Symbol.asyncIterator];return r?r.call(t):(t=i(t),e={},n("next"),n("throw"),n("return"),e[Symbol.asyncIterator]=function(){return this},e);function n(r){e[r]=t[r]&&function(e){return new Promise((function(n,o){(function(t,e,r,n){Promise.resolve(n).then((function(e){t({value:e,done:r})}),e)})(n,o,(e=t[r](e)).done,e.value)}))}}},r.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};r.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)"default"!==n&&Object.prototype.hasOwnProperty.call(t,n)&&r.__createBinding(e,t,n);return f(e,t),e},r.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},r.__classPrivateFieldGet=function(t,e,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof e?t!==e||!n:!e.has(t))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(t):n?n.value:e.get(t)},r.__classPrivateFieldSet=function(t,e,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof e?t!==e||!o:!e.has(t))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(t,r):o?o.value=r:e.set(t,r),r}},
function _(t,r,o,e,i){if(e(),t(3),t(12),t(15),t(18),t(25),t(55),t(58),t(61),t(64),t(100),t(107),t(113),t(114),void 0===Object.is&&(Object.is=function(t,r){return t===r?0!==t||1/t==1/r:t!=t&&r!=r}),void 0===Object.values&&(Object.values=function(t){return Object.keys(t).map((function(r){return t[r]}))}),void 0===String.prototype.includes&&(String.prototype.includes=function(t,r){return void 0===r&&(r=0),-1!=this.indexOf(t,r)}),void 0===Uint8Array.prototype.fill){var y=Array.prototype.fill;Uint8Array.prototype.fill=y,Int8Array.prototype.fill=y,Uint16Array.prototype.fill=y,Int16Array.prototype.fill=y,Uint32Array.prototype.fill=y,Int32Array.prototype.fill=y,Float32Array.prototype.fill=y,Float64Array.prototype.fill=y}if(void 0===Array.prototype[Symbol.iterator]){function n(){var t=0,r=this;return{next:function(){var o=r.length<=t;return{value:o?void 0:r[t++],done:o}}}}!function(){arguments.constructor.prototype[Symbol.iterator]=n,Array.prototype[Symbol.iterator]=n,Uint8Array.prototype[Symbol.iterator]=n,Int8Array.prototype[Symbol.iterator]=n,Uint16Array.prototype[Symbol.iterator]=n,Int16Array.prototype[Symbol.iterator]=n,Uint32Array.prototype[Symbol.iterator]=n,Int32Array.prototype[Symbol.iterator]=n,Float32Array.prototype[Symbol.iterator]=n,Float64Array.prototype[Symbol.iterator]=n}()}"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(t){for(var r=0;r<this.length;r++)this[r]=t[r]})},
function _(e,n,a,b,i){e(4)()||Object.defineProperty(Object,"assign",{value:e(5),configurable:!0,enumerable:!1,writable:!0})},
function _(r,t,o,a,n){t.exports=function(){var r,t=Object.assign;return"function"==typeof t&&(t(r={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),r.foo+r.bar+r.trzy==="razdwatrzy")}},
function _(t,r,n,o,c){var a=t(6),f=t(11),h=Math.max;r.exports=function(t,r){var n,o,c,i=h(arguments.length,2);for(t=Object(f(t)),c=function(o){try{t[o]=r[o]}catch(t){n||(n=t)}},o=1;o<i;++o)a(r=arguments[o]).forEach(c);if(void 0!==n)throw n;return t}},
function _(e,t,c,n,o){t.exports=e(7)()?Object.keys:e(8)},
function _(t,r,e,n,c){r.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},
function _(t,e,n,c,r){var o=t(9),u=Object.keys;e.exports=function(t){return u(o(t)?Object(t):t)}},
function _(n,r,t,u,o){var c=n(10)();r.exports=function(n){return n!==c&&null!==n}},
function _(n,o,t,c,f){o.exports=function(){}},
function _(n,r,e,o,t){var u=n(9);r.exports=function(n){if(!u(n))throw new TypeError("Cannot use null or undefined");return n}},
function _(e,n,r,t,b){e(13)()||Object.defineProperty(Object,"entries",{value:e(14),configurable:!0,enumerable:!1,writable:!0})},
function _(t,n,o,r,e){n.exports=function(){try{return"foo"===Object.entries({foo:12})[0][0]}catch(t){return!1}}},
function _(r,n,e,t,a){var o=r(11);n.exports=function(r){o(r);var n=[];for(var e in r=Object(r))propertyIsEnumerable.call(r,e)&&n.push([e,r[e]]);return n}},
function _(e,r,n,b,i){e(16)()||Object.defineProperty(Number,"isInteger",{value:e(17),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,e,r,o){t.exports=function(){var n=Number.isInteger;return"function"==typeof n&&(!n("23")&&n(34)&&!n(32.34))}},
function _(n,t,e,o,r){t.exports=function(n){return"number"==typeof n&&n%1==0}},
function _(e,r,t,n,a){e(19)()||Object.defineProperty(String.prototype,"repeat",{value:e(20),configurable:!0,enumerable:!1,writable:!0})},
function _(o,f,t,e,n){f.exports=function(){return"function"==typeof"foo".repeat&&"foofoo"==="foo".repeat(2)}},
function _(r,n,t,o,e){var i=r(11),u=r(21);n.exports=function(r){var n,t=String(i(this));if((r=u(r))<0)throw new RangeError("Count must be >= 0");if(!isFinite(r))throw new RangeError("Count must be < ∞");for(n="";r;)r%2&&(n+=t),r>1&&(t+=t),r>>=1;return n}},
function _(t,i,n,r,a){var o=t(22),e=Math.abs,s=Math.floor;i.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?o(t)*s(e(t)):t}},
function _(n,t,i,o,s){t.exports=n(23)()?Math.sign:n(24)},
function _(n,t,o,f,i){t.exports=function(){var n=Math.sign;return"function"==typeof n&&(1===n(10)&&-1===n(-20))}},
function _(n,r,t,u,e){r.exports=function(n){return n=Number(n),isNaN(n)||0===n?n:n>0?1:-1}},
function _(e,r,a,n,b){e(26)()||Object.defineProperty(Array,"from",{value:e(27),configurable:!0,enumerable:!1,writable:!0})},
function _(n,o,r,a,t){o.exports=function(){var n,o,r=Array.from;return"function"==typeof r&&(o=r(n=["raz","dwa"]),Boolean(o&&o!==n&&"dwa"===o[1]))}},
function _(e,l,r,n,t){var a=e(28).iterator,i=e(50),u=e(51),o=e(52),f=e(53),c=e(11),v=e(9),h=e(54),y=Array.isArray,s=Function.prototype.call,A={configurable:!0,enumerable:!0,writable:!0,value:null},g=Object.defineProperty;l.exports=function(e){var l,r,n,t,p,w,b,d,x,j,O=arguments[1],m=arguments[2];if(e=Object(c(e)),v(O)&&f(O),this&&this!==Array&&u(this))l=this;else{if(!O){if(i(e))return 1!==(p=e.length)?Array.apply(null,e):((t=new Array(1))[0]=e[0],t);if(y(e)){for(t=new Array(p=e.length),r=0;r<p;++r)t[r]=e[r];return t}}t=[]}if(!y(e))if(void 0!==(x=e[a])){for(b=f(x).call(e),l&&(t=new l),d=b.next(),r=0;!d.done;)j=O?s.call(O,m,d.value,r):d.value,l?(A.value=j,g(t,r,A)):t[r]=j,d=b.next(),++r;p=r}else if(h(e)){for(p=e.length,l&&(t=new l),r=0,n=0;r<p;++r)j=e[r],r+1<p&&(w=j.charCodeAt(0))>=55296&&w<=56319&&(j+=e[++r]),j=O?s.call(O,m,j,n):j,l?(A.value=j,g(t,n,A)):t[n]=j,++n;p=n}if(void 0===p)for(p=o(e.length),l&&(t=new l(p)),r=0;r<p;++r)j=O?s.call(O,m,e[r],r):e[r],l?(A.value=j,g(t,r,A)):t[r]=j;return l&&(A.value=null,t.length=p),t}},
function _(o,n,t,b,c){n.exports=o(29)()?o(30).Symbol:o(33)},
function _(t,o,r,e,n){var i=t(30),f={object:!0,symbol:!0};o.exports=function(){var t,o=i.Symbol;if("function"!=typeof o)return!1;t=o("test symbol");try{String(t)}catch(t){return!1}return!!f[typeof o.iterator]&&(!!f[typeof o.toPrimitive]&&!!f[typeof o.toStringTag])}},
function _(o,i,l,n,s){i.exports=o(31)()?globalThis:o(32)},
function _(o,r,l,t,a){r.exports=function(){return"object"==typeof globalThis&&(!!globalThis&&globalThis.Array===Array)}},
function _(t,e,o,r,n){var i=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return i()}try{return __global__||i()}finally{delete Object.prototype.__global__}}()},
function _(t,o,r,n,e){var i,c,p,y=t(34),s=t(45),u=t(30).Symbol,f=t(47),_=t(48),a=t(49),S=Object.create,g=Object.defineProperties,m=Object.defineProperty;if("function"==typeof u)try{String(u()),p=!0}catch(t){}else u=null;c=function(t){if(this instanceof c)throw new TypeError("Symbol is not a constructor");return i(t)},o.exports=i=function t(o){var r;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return p?u(o):(r=S(c.prototype),o=void 0===o?"":String(o),g(r,{__description__:y("",o),__name__:y("",f(o))}))},_(i),a(i),g(c.prototype,{constructor:y(i),toString:y("",(function(){return this.__name__}))}),g(i.prototype,{toString:y((function(){return"Symbol ("+s(this).__description__+")"})),valueOf:y((function(){return s(this)}))}),m(i.prototype,i.toPrimitive,y("",(function(){var t=s(this);return"symbol"==typeof t?t:t.toString()}))),m(i.prototype,i.toStringTag,y("c","Symbol")),m(c.prototype,i.toStringTag,y("c",i.prototype[i.toStringTag])),m(c.prototype,i.toPrimitive,y("c",i.prototype[i.toPrimitive]))},
function _(l,e,n,r,a){var t=l(35),c=l(36),i=l(40),o=l(41),u=l(42);(e.exports=function(l,e){var n,r,a,c,v;return arguments.length<2||"string"!=typeof l?(c=e,e=l,l=null):c=arguments[2],t(l)?(n=u.call(l,"c"),r=u.call(l,"e"),a=u.call(l,"w")):(n=a=!0,r=!1),v={value:e,configurable:n,enumerable:r,writable:a},c?i(o(c),v):v}).gs=function(l,e,n){var r,a,v,f;return"string"!=typeof l?(v=n,n=e,e=l,l=null):v=arguments[3],t(e)?c(e)?t(n)?c(n)||(v=n,n=void 0):n=void 0:(v=e,e=n=void 0):e=void 0,t(l)?(r=u.call(l,"c"),a=u.call(l,"e")):(r=!0,a=!1),f={get:e,set:n,configurable:r,enumerable:a},v?i(o(v),f):f}},
function _(n,t,u,o,r){t.exports=function(n){return null!=n}},
function _(t,n,o,r,s){var c=t(37),e=/^\s*class[\s{/}]/,i=Function.prototype.toString;n.exports=function(t){return!!c(t)&&!e.test(i.call(t))}},
function _(t,n,r,e,f){var u=t(38);n.exports=function(t){if("function"!=typeof t)return!1;if(!hasOwnProperty.call(t,"length"))return!1;try{if("number"!=typeof t.length)return!1;if("function"!=typeof t.call)return!1;if("function"!=typeof t.apply)return!1}catch(t){return!1}return!u(t)}},
function _(r,t,n,o,c){var u=r(39);t.exports=function(r){if(!u(r))return!1;try{return!!r.constructor&&r.constructor.prototype===r}catch(r){return!1}}},
function _(n,t,e,o,r){var c=n(35),f={object:!0,function:!0,undefined:!0};t.exports=function(n){return!!c(n)&&hasOwnProperty.call(f,typeof n)}},
function _(n,s,t,c,e){s.exports=n(4)()?Object.assign:n(5)},
function _(r,n,t,c,o){var a=r(9),e=Array.prototype.forEach,f=Object.create,u=function(r,n){var t;for(t in r)n[t]=r[t]};n.exports=function(r){var n=f(null);return e.call(arguments,(function(r){a(r)&&u(Object(r),n)})),n}},
function _(t,n,o,i,p){n.exports=t(43)()?String.prototype.contains:t(44)},
function _(n,o,t,a,c){var i="razdwatrzy";o.exports=function(){return"function"==typeof i.contains&&(!0===i.contains("dwa")&&!1===i.contains("foo"))}},
function _(t,n,r,i,o){var e=String.prototype.indexOf;n.exports=function(t){return e.call(this,t,arguments[1])>-1}},
function _(r,n,o,t,e){var i=r(46);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not a symbol");return r}},
function _(o,t,n,r,c){t.exports=function(o){return!!o&&("symbol"==typeof o||!!o.constructor&&("Symbol"===o.constructor.name&&"Symbol"===o[o.constructor.toStringTag]))}},
function _(t,e,n,r,o){var c=t(34),u=Object.create,f=Object.defineProperty,i=Object.prototype,l=u(null);e.exports=function(t){for(var e,n,r=0;l[t+(r||"")];)++r;return l[t+=r||""]=!0,f(i,e="@@"+t,c.gs(null,(function(t){n||(n=!0,f(this,e,c(t)),n=!1)}))),e}},
function _(e,t,a,s,i){var r=e(34),c=e(30).Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:r("",c&&c.hasInstance||e("hasInstance")),isConcatSpreadable:r("",c&&c.isConcatSpreadable||e("isConcatSpreadable")),iterator:r("",c&&c.iterator||e("iterator")),match:r("",c&&c.match||e("match")),replace:r("",c&&c.replace||e("replace")),search:r("",c&&c.search||e("search")),species:r("",c&&c.species||e("species")),split:r("",c&&c.split||e("split")),toPrimitive:r("",c&&c.toPrimitive||e("toPrimitive")),toStringTag:r("",c&&c.toStringTag||e("toStringTag")),unscopables:r("",c&&c.unscopables||e("unscopables"))})}},
function _(r,n,e,t,i){var o=r(34),f=r(45),u=Object.create(null);n.exports=function(r){return Object.defineProperties(r,{for:o((function(n){return u[n]?u[n]:u[n]=r(String(n))})),keyFor:o((function(r){var n;for(n in f(r),u)if(u[n]===r)return n}))})}},
function _(t,n,r,o,c){var e=Object.prototype.toString,u=e.call(function(){return arguments}());n.exports=function(t){return e.call(t)===u}},
function _(t,o,n,e,c){var p=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);o.exports=function(t){return"function"==typeof t&&r(p.call(t))}},
function _(n,t,r,a,o){var u=n(21),c=Math.max;t.exports=function(n){return c(0,u(n))}},
function _(n,o,t,r,f){o.exports=function(n){if("function"!=typeof n)throw new TypeError(n+" is not a function");return n}},
function _(t,n,o,e,r){var c=Object.prototype.toString,i=c.call("");n.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||c.call(t)===i)||!1}},
function _(e,r,l,t,a){e(56)()||Object.defineProperty(Array.prototype,"fill",{value:e(57),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,f,i,o){t.exports=function(){var n=[1,2,3,4,5,6];return"function"==typeof n.fill&&"1,2,3,-1,-1,-1"===String(n.fill(-1,-3))}},
function _(t,n,i,o,r){var a=t(21),h=t(52),v=t(11),e=Math.max,f=Math.min;n.exports=function(t){var n,i=v(this),o=arguments[1],r=arguments[2],u=h(i.length);for(o=void 0===o?0:a(o),r=void 0===r?u:a(r),n=o<0?e(u+o,0):f(o,u);n<u&&n<r;++n)i[n]=t;return i}},
function _(e,a,l,n,r){e(59)()||Object.defineProperty(Math,"log10",{value:e(60),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log10;return"function"==typeof n&&.3010299956639812===n(2)}},
function _(t,a,n,r,N){var o=Math.log,u=Math.LOG10E;a.exports=function(t){return isNaN(t)||(t=Number(t))<0?NaN:0===t?-1/0:1===t?0:t===1/0?1/0:o(t)*u}},
function _(e,a,l,n,r){e(62)()||Object.defineProperty(Math,"log1p",{value:e(63),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log1p;return"function"==typeof n&&.6931471805599453===n(1)}},
function _(e,n,r,t,N){var a=Math.log;n.exports=function(e){return isNaN(e)||(e=Number(e))<-1?NaN:-1===e?-1/0:0===e?e:e===1/0?1/0:e>-1e-8&&e<1e-8?e-e*e/2:a(1+e)}},
function _(e,n,r,t,a){e(65)()||Object.defineProperty(e(66),"Set",{value:e(67),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;return"function"==typeof Set&&(t=new Set(["raz","dwa","trzy"]),"[object Set]"===String(t)&&(3===t.size&&("function"==typeof t.add&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.values&&(!1===(e=t.values().next()).done&&"raz"===e.value)))))))))))}},
function _(t,e,o,r,l){var n=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;if("object"==typeof globalThis&&globalThis)return globalThis;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return n()}try{return __global__||n()}finally{delete Object.prototype.__global__}}()},
function _(t,e,n,r,i){var s,o,a,_=t(68),c=t(69),u=t(73),h=t(53),l=t(34),f=t(78),p=t(28),y=t(79),v=t(81),d=t(98),D=t(99),g=Function.prototype.call,w=Object.defineProperty,b=Object.getPrototypeOf;D&&(a=Set),e.exports=s=function(){var t,e=arguments[0];if(!(this instanceof s))throw new TypeError("Constructor requires 'new'");return t=D&&u?u(new a,b(this)):this,null!=e&&y(e),w(t,"__setData__",l("c",[])),e?(v(e,(function(t){-1===c.call(this,t)&&this.push(t)}),t.__setData__),t):t},D&&(u&&u(s,a),s.prototype=Object.create(a.prototype,{constructor:l(s)})),f(Object.defineProperties(s.prototype,{add:l((function(t){return this.has(t)||this.emit("_add",this.__setData__.push(t)-1,t),this})),clear:l((function(){this.__setData__.length&&(_.call(this.__setData__),this.emit("_clear"))})),delete:l((function(t){var e=c.call(this.__setData__,t);return-1!==e&&(this.__setData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:l((function(){return new d(this,"key+value")})),forEach:l((function(t){var e,n,r,i=arguments[1];for(h(t),n=(e=this.values())._next();void 0!==n;)r=e._resolve(n),g.call(t,i,r,r,this),n=e._next()})),has:l((function(t){return-1!==c.call(this.__setData__,t)})),keys:l(o=function(){return this.values()}),size:l.gs((function(){return this.__setData__.length})),values:l((function(){return new d(this)})),toString:l((function(){return"[object Set]"}))})),w(s.prototype,p.iterator,l(o)),w(s.prototype,p.toStringTag,l("c","Set"))},
function _(t,n,i,r,e){var h=t(11);n.exports=function(){return h(this).length=0,this}},
function _(t,r,e,i,n){var o=t(70),a=t(52),h=t(11),s=Array.prototype.indexOf,p=Object.prototype.hasOwnProperty,f=Math.abs,l=Math.floor;r.exports=function(t){var r,e,i,n;if(!o(t))return s.apply(this,arguments);for(e=a(h(this).length),i=arguments[1],r=i=isNaN(i)?0:i>=0?l(i):a(this.length)-l(f(i));r<e;++r)if(p.call(this,r)&&(n=this[r],o(n)))return r;return-1}},
function _(N,e,i,n,o){e.exports=N(71)()?Number.isNaN:N(72)},
function _(n,t,o,r,u){t.exports=function(){var n=Number.isNaN;return"function"==typeof n&&(!n({})&&n(NaN)&&!n(34))}},
function _(n,t,o,r,u){t.exports=function(n){return n!=n}},
function _(t,e,o,c,f){e.exports=t(74)()?Object.setPrototypeOf:t(75)},
function _(t,e,o,n,r){var c=Object.create,f=Object.getPrototypeOf,u={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||c;return"function"==typeof t&&f(t(e(null),u))===u}},
function _(e,t,l,r,o){var n,_,u,c,i=e(76),p=e(11),f=Object.prototype.isPrototypeOf,a=Object.defineProperty,b={configurable:!0,enumerable:!1,writable:!0,value:void 0};n=function(e,t){if(p(e),null===t||i(t))return e;throw new TypeError("Prototype must be null or an object")},t.exports=(_=function(){var e,t=Object.create(null),l={},r=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(r){try{(e=r.set).call(t,l)}catch(e){}if(Object.getPrototypeOf(t)===l)return{set:e,level:2}}return t.__proto__=l,Object.getPrototypeOf(t)===l?{level:2}:((t={}).__proto__=l,Object.getPrototypeOf(t)===l&&{level:1})}())?(2===_.level?_.set?(c=_.set,u=function(e,t){return c.call(n(e,t),t),e}):u=function(e,t){return n(e,t).__proto__=t,e}:u=function e(t,l){var r;return n(t,l),(r=f.call(e.nullPolyfill,t))&&delete e.nullPolyfill.__proto__,null===l&&(l=e.nullPolyfill),t.__proto__=l,r&&a(e.nullPolyfill,"__proto__",b),t},Object.defineProperty(u,"level",{configurable:!1,enumerable:!1,writable:!1,value:_.level})):null,e(77)},
function _(n,t,o,c,e){var f=n(9),r={function:!0,object:!0};t.exports=function(n){return f(n)&&r[typeof n]||!1}},
function _(e,r,l,t,n){var o,a,i,u,b=Object.create;e(74)()||(o=e(75)),r.exports=o?1!==o.level?b:(a={},i={},u={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach((function(e){i[e]="__proto__"!==e?u:{configurable:!0,enumerable:!1,writable:!0,value:void 0}})),Object.defineProperties(a,i),Object.defineProperty(o,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:a}),function(e,r){return b(null===e?a:e,r)}):b},
function _(e,t,n,i,l){var r,c,_,o,s,a,h,f=e(34),u=e(53),p=Function.prototype.apply,b=Function.prototype.call,y=Object.create,O=Object.defineProperty,j=Object.defineProperties,v=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0};c=function(e,t){var n,i;return u(t),i=this,r.call(this,e,n=function(){_.call(i,e,n),p.call(t,this,arguments)}),n.__eeOnceListener__=t,this},s={on:r=function(e,t){var n;return u(t),v.call(this,"__ee__")?n=this.__ee__:(n=d.value=y(null),O(this,"__ee__",d),d.value=null),n[e]?"object"==typeof n[e]?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},once:c,off:_=function(e,t){var n,i,l,r;if(u(t),!v.call(this,"__ee__"))return this;if(!(n=this.__ee__)[e])return this;if("object"==typeof(i=n[e]))for(r=0;l=i[r];++r)l!==t&&l.__eeOnceListener__!==t||(2===i.length?n[e]=i[r?0:1]:i.splice(r,1));else i!==t&&i.__eeOnceListener__!==t||delete n[e];return this},emit:o=function(e){var t,n,i,l,r;if(v.call(this,"__ee__")&&(l=this.__ee__[e]))if("object"==typeof l){for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];for(l=l.slice(),t=0;i=l[t];++t)p.call(i,this,r)}else switch(arguments.length){case 1:b.call(l,this);break;case 2:b.call(l,this,arguments[1]);break;case 3:b.call(l,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];p.call(l,this,r)}}},a={on:f(r),once:f(c),off:f(_),emit:f(o)},h=j({},a),t.exports=n=function(e){return null==e?y(h):j(Object(e),a)},n.methods=s},
function _(r,n,t,e,o){var i=r(80);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not iterable");return r}},
function _(r,t,n,o,i){var a=r(50),e=r(9),f=r(54),u=r(28).iterator,c=Array.isArray;t.exports=function(r){return!!e(r)&&(!!c(r)||(!!f(r)||(!!a(r)||"function"==typeof r[u])))}},
function _(r,n,t,a,e){var o=r(50),l=r(53),c=r(54),i=r(82),f=Array.isArray,u=Function.prototype.call,s=Array.prototype.some;n.exports=function(r,n){var t,a,e,y,p,A,g,v,x=arguments[2];if(f(r)||o(r)?t="array":c(r)?t="string":r=i(r),l(n),e=function(){y=!0},"array"!==t)if("string"!==t)for(a=r.next();!a.done;){if(u.call(n,x,a.value,e),y)return;a=r.next()}else for(A=r.length,p=0;p<A&&(g=r[p],p+1<A&&(v=g.charCodeAt(0))>=55296&&v<=56319&&(g+=r[++p]),u.call(n,x,g,e),!y);++p);else s.call(r,(function(r){return u.call(n,x,r,e),y}))}},
function _(n,t,e,o,r){var f=n(50),i=n(54),u=n(83),c=n(97),w=n(79),a=n(28).iterator;t.exports=function(n){return"function"==typeof w(n)[a]?n[a]():f(n)?new u(n):i(n)?new c(n):new u(n)}},
function _(t,e,r,o,_){var i,n=t(73),l=t(42),a=t(34),s=t(28),c=t(84),u=Object.defineProperty;i=e.exports=function(t,e){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");c.call(this,t),e=e?l.call(e,"key+value")?"key+value":l.call(e,"key")?"key":"value":"value",u(this,"__kind__",a("",e))},n&&n(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t}))}),u(i.prototype,s.toStringTag,a("c","Array Iterator"))},
function _(_,t,e,n,i){var o,s=_(68),r=_(40),h=_(53),d=_(11),c=_(34),u=_(85),l=_(28),f=Object.defineProperty,x=Object.defineProperties;t.exports=o=function(_,t){if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");x(this,{__list__:c("w",d(_)),__context__:c("w",t),__nextIndex__:c("w",0)}),t&&(h(t.on),t.on("_add",this._onAdd),t.on("_delete",this._onDelete),t.on("_clear",this._onClear))},delete o.prototype.constructor,x(o.prototype,r({_next:c((function(){var _;if(this.__list__)return this.__redo__&&void 0!==(_=this.__redo__.shift())?_:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()})),next:c((function(){return this._createResult(this._next())})),_createResult:c((function(_){return void 0===_?{done:!0,value:void 0}:{done:!1,value:this._resolve(_)}})),_resolve:c((function(_){return this.__list__[_]})),_unBind:c((function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)})),toString:c((function(){return"[object "+(this[l.toStringTag]||"Object")+"]"}))},u({_onAdd:c((function(_){_>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach((function(t,e){t>=_&&(this.__redo__[e]=++t)}),this),this.__redo__.push(_)):f(this,"__redo__",c("c",[_])))})),_onDelete:c((function(_){var t;_>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(_))&&this.__redo__.splice(t,1),this.__redo__.forEach((function(t,e){t>_&&(this.__redo__[e]=--t)}),this)))})),_onClear:c((function(){this.__redo__&&s.call(this.__redo__),this.__nextIndex__=0}))}))),f(o.prototype,l.iterator,c((function(){return this})))},
function _(e,t,n,r,o){var i,l=e(35),u=e(86),s=e(91),v=e(92),a=e(41),c=e(94),f=Function.prototype.bind,p=Object.defineProperty,h=Object.prototype.hasOwnProperty;i=function(e,t,n){var r,o=u(t)&&s(t.value);return delete(r=v(t)).writable,delete r.value,r.get=function(){return!n.overwriteDefinition&&h.call(this,e)?o:(t.value=f.call(o,n.resolveContext?n.resolveContext(this):this),p(this,e,t),this[e])},r},t.exports=function(e){var t=a(arguments[1]);return l(t.resolveContext)&&s(t.resolveContext),c(e,(function(e,n){return i(n,e,t)}))}},
function _(n,t,o,r,u){var e=n(87),a=n(35);t.exports=function(n){return a(n)?n:e(n,"Cannot use %v",arguments[1])}},
function _(r,e,n,t,i){var o=r(35),f=r(39),u=r(88),a=r(89),l=function(r,e){return r.replace("%v",a(e))};e.exports=function(r,e,n){if(!f(n))throw new TypeError(l(e,r));if(!o(r)){if("default"in n)return n.default;if(n.isOptional)return null}var t=u(n.errorMessage);throw o(t)||(t=e),new TypeError(l(t,r))}},
function _(t,n,r,u,e){var i=t(35),o=t(39),f=Object.prototype.toString;n.exports=function(t){if(!i(t))return null;if(o(t)){var n=t.toString;if("function"!=typeof n)return null;if(n===f)return null}try{return""+t}catch(t){return null}}},
function _(r,e,n,t,u){var c=r(90),a=/[\n\r\u2028\u2029]/g;e.exports=function(r){var e=c(r);return null===e?"<Non-coercible to string value>":(e.length>100&&(e=e.slice(0,99)+"…"),e=e.replace(a,(function(r){switch(r){case"\n":return"\\n";case"\r":return"\\r";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";default:throw new Error("Unexpected character")}})))}},
function _(t,r,n,c,u){r.exports=function(t){try{return t.toString()}catch(r){try{return String(t)}catch(t){return null}}}},
function _(n,t,i,o,r){var u=n(87),a=n(36);t.exports=function(n){return a(n)?n:u(n,"%v is not a plain function",arguments[1])}},
function _(n,r,t,e,u){var c=n(93),i=n(40),f=n(11);r.exports=function(n){var r=Object(f(n)),t=arguments[1],e=Object(arguments[2]);if(r!==n&&!t)return r;var u={};return t?c(t,(function(r){(e.ensure||r in n)&&(u[r]=n[r])})):i(u,n),u}},
function _(r,o,f,n,t){o.exports=r(26)()?Array.from:r(27)},
function _(n,t,o,c,r){var u=n(53),a=n(95),i=Function.prototype.call;t.exports=function(n,t){var o={},c=arguments[2];return u(t),a(n,(function(n,r,u,a){o[r]=i.call(t,c,n,r,u,a)})),o}},
function _(o,c,f,n,r){c.exports=o(96)("forEach")},
function _(t,n,o,c,e){var r=t(53),u=t(11),l=Function.prototype.bind,p=Function.prototype.call,i=Object.keys,a=Object.prototype.propertyIsEnumerable;n.exports=function(t,n){return function(o,c){var e,f=arguments[2],y=arguments[3];return o=Object(u(o)),r(c),e=i(o),y&&e.sort("function"==typeof y?l.call(y,o):void 0),"function"!=typeof t&&(t=e[t]),p.call(t,e,(function(t,e){return a.call(o,t)?p.call(c,f,o[t],t,o,e):n}))}}},
function _(t,_,e,n,r){var i,o=t(73),s=t(34),h=t(28),c=t(84),l=Object.defineProperty;i=_.exports=function(t){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");t=String(t),c.call(this,t),l(this,"__length__",s("",t.length))},o&&o(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_next:s((function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()})),_resolve:s((function(t){var _,e=this.__list__[t];return this.__nextIndex__===this.__length__?e:(_=e.charCodeAt(0))>=55296&&_<=56319?e+this.__list__[this.__nextIndex__++]:e}))}),l(i.prototype,h.toStringTag,s("c","String Iterator"))},
function _(t,e,_,r,i){var o,n=t(73),s=t(42),a=t(34),c=t(84),l=t(28).toStringTag,u=Object.defineProperty;o=e.exports=function(t,e){if(!(this instanceof o))return new o(t,e);c.call(this,t.__setData__,t),e=e&&s.call(e,"key+value")?"key+value":"value",u(this,"__kind__",a("",e))},n&&n(o,c),o.prototype=Object.create(c.prototype,{constructor:a(o),_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__list__[t]]})),toString:a((function(){return"[object Set Iterator]"}))}),u(o.prototype,l,a("c","Set Iterator"))},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Set&&"[object Set]"===Object.prototype.toString.call(Set.prototype)},
function _(e,a,n,r,b){e(101)()||Object.defineProperty(e(66),"Map",{value:e(102),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&(3===t.size&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.get&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.set&&("function"==typeof t.values&&(!1===(e=t.entries().next()).done&&(!!e.value&&("raz"===e.value[0]&&"one"===e.value[1])))))))))))))}},
function _(t,e,a,_,n){var i,r=t(68),s=t(69),o=t(73),p=t(53),c=t(11),u=t(34),l=t(78),h=t(28),f=t(79),y=t(81),m=t(103),D=t(106),v=Function.prototype.call,K=Object.defineProperties,d=Object.getPrototypeOf;e.exports=i=function(){var t,e,a,_=arguments[0];if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");return a=D&&o&&Map!==i?o(new Map,d(this)):this,null!=_&&f(_),K(a,{__mapKeysData__:u("c",t=[]),__mapValuesData__:u("c",e=[])}),_?(y(_,(function(a){var _=c(a)[0];a=a[1],-1===s.call(t,_)&&(t.push(_),e.push(a))}),a),a):a},D&&(o&&o(i,Map),i.prototype=Object.create(Map.prototype,{constructor:u(i)})),l(K(i.prototype,{clear:u((function(){this.__mapKeysData__.length&&(r.call(this.__mapKeysData__),r.call(this.__mapValuesData__),this.emit("_clear"))})),delete:u((function(t){var e=s.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:u((function(){return new m(this,"key+value")})),forEach:u((function(t){var e,a,_=arguments[1];for(p(t),a=(e=this.entries())._next();void 0!==a;)v.call(t,_,this.__mapValuesData__[a],this.__mapKeysData__[a],this),a=e._next()})),get:u((function(t){var e=s.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]})),has:u((function(t){return-1!==s.call(this.__mapKeysData__,t)})),keys:u((function(){return new m(this,"key")})),set:u((function(t,e){var a,_=s.call(this.__mapKeysData__,t);return-1===_&&(_=this.__mapKeysData__.push(t)-1,a=!0),this.__mapValuesData__[_]=e,a&&this.emit("_add",_,t),this})),size:u.gs((function(){return this.__mapKeysData__.length})),values:u((function(){return new m(this,"value")})),toString:u((function(){return"[object Map]"}))})),Object.defineProperty(i.prototype,h.iterator,u((function(){return this.entries()}))),Object.defineProperty(i.prototype,h.toStringTag,u("c","Map"))},
function _(t,_,e,i,n){var r,o=t(73),s=t(34),a=t(84),u=t(28).toStringTag,c=t(104),l=Object.defineProperties,p=a.prototype._unBind;r=_.exports=function(t,_){if(!(this instanceof r))return new r(t,_);a.call(this,t.__mapKeysData__,t),_&&c[_]||(_="key+value"),l(this,{__kind__:s("",_),__values__:s("w",t.__mapValuesData__)})},o&&o(r,a),r.prototype=Object.create(a.prototype,{constructor:s(r),_resolve:s((function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]})),_unBind:s((function(){this.__values__=null,p.call(this)})),toString:s((function(){return"[object Map Iterator]"}))}),Object.defineProperty(r.prototype,u,s("c","Map Iterator"))},
function _(e,u,a,k,l){u.exports=e(105)("key","value","key+value")},
function _(r,t,n,c,o){var a=Array.prototype.forEach,e=Object.create;t.exports=function(r){var t=e(null);return a.call(arguments,(function(r){t[r]=!0})),t}},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},
function _(e,a,n,r,b){e(108)()||Object.defineProperty(e(66),"WeakMap",{value:e(109),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&("function"==typeof t.set&&(t.set({},1)===t&&("function"==typeof t.delete&&("function"==typeof t.has&&"one"===t.get(e)))))}},
function _(t,e,a,r,n){var o,p=t(9),_=t(73),i=t(110),c=t(11),s=t(111),u=t(34),f=t(82),k=t(81),M=t(28).toStringTag,h=t(112),w=Array.isArray,y=Object.defineProperty,l=Object.prototype.hasOwnProperty,D=Object.getPrototypeOf;e.exports=o=function(){var t,e=arguments[0];if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");return t=h&&_&&WeakMap!==o?_(new WeakMap,D(this)):this,p(e)&&(w(e)||(e=f(e))),y(t,"__weakMapData__",u("c","$weakMap$"+s())),e?(k(e,(function(e){c(e),t.set(e[0],e[1])})),t):t},h&&(_&&_(o,WeakMap),o.prototype=Object.create(WeakMap.prototype,{constructor:u(o)})),Object.defineProperties(o.prototype,{delete:u((function(t){return!!l.call(i(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)})),get:u((function(t){if(l.call(i(t),this.__weakMapData__))return t[this.__weakMapData__]})),has:u((function(t){return l.call(i(t),this.__weakMapData__)})),set:u((function(t,e){return y(i(t),this.__weakMapData__,u("c",e)),this})),toString:u((function(){return"[object WeakMap]"}))}),y(o.prototype,M,u("c","WeakMap"))},
function _(n,r,t,o,e){var i=n(76);r.exports=function(n){if(!i(n))throw new TypeError(n+" is not an Object");return n}},
function _(t,n,r,e,o){var a=Object.create(null),c=Math.random;n.exports=function(){var t;do{t=c().toString(36).slice(2)}while(a[t]);return t}},
function _(t,e,o,a,p){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},
function _(e,b,l,n,r){e(29)()||Object.defineProperty(e(30),"Symbol",{value:e(33),configurable:!0,enumerable:!1,writable:!0})},
function _(l,o,f,i,n){o.exports=l(115).polyfill()},
function _(t,e,n,r,o){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
!function(t,r){"object"==typeof n&&void 0!==e?e.exports=r():"function"==typeof define&&define.amd?define(r):t.ES6Promise=r()}(this,(function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},r=0,o=void 0,i=void 0,s=function(t,e){v[r]=t,v[r+1]=e,2===(r+=2)&&(i?i(p):b())};var u="undefined"!=typeof window?window:void 0,c=u||{},a=c.MutationObserver||c.WebKitMutationObserver,f="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),l="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function h(){var t=setTimeout;return function(){return t(p,1)}}var v=new Array(1e3);function p(){for(var t=0;t<r;t+=2){(0,v[t])(v[t+1]),v[t]=void 0,v[t+1]=void 0}r=0}var d,_,y,m,b=void 0;function w(t,e){var n=this,r=new this.constructor(j);void 0===r[A]&&k(r);var o=n._state;if(o){var i=arguments[o-1];s((function(){return F(o,r,i,n._result)}))}else O(n,r,t,e);return r}function g(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(j);return T(e,t),e}f?b=function(){return process.nextTick(p)}:a?(_=0,y=new a(p),m=document.createTextNode(""),y.observe(m,{characterData:!0}),b=function(){m.data=_=++_%2}):l?((d=new MessageChannel).port1.onmessage=p,b=function(){return d.port2.postMessage(0)}):b=void 0===u&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(o=t.runOnLoop||t.runOnContext)?function(){o(p)}:h()}catch(t){return h()}}():h();var A=Math.random().toString(36).substring(2);function j(){}var S=void 0;function E(t,n,r){n.constructor===t.constructor&&r===w&&n.constructor.resolve===g?function(t,e){1===e._state?P(t,e._result):2===e._state?C(t,e._result):O(e,void 0,(function(e){return T(t,e)}),(function(e){return C(t,e)}))}(t,n):void 0===r?P(t,n):e(r)?function(t,e,n){s((function(t){var r=!1,o=function(t,e,n,r){try{t.call(e,n,r)}catch(t){return t}}(n,e,(function(n){r||(r=!0,e!==n?T(t,n):P(t,n))}),(function(e){r||(r=!0,C(t,e))}),t._label);!r&&o&&(r=!0,C(t,o))}),t)}(t,n,r):P(t,n)}function T(t,e){if(t===e)C(t,new TypeError("You cannot resolve a promise with itself"));else if(o=typeof(r=e),null===r||"object"!==o&&"function"!==o)P(t,e);else{var n=void 0;try{n=e.then}catch(e){return void C(t,e)}E(t,e,n)}var r,o}function M(t){t._onerror&&t._onerror(t._result),x(t)}function P(t,e){t._state===S&&(t._result=e,t._state=1,0!==t._subscribers.length&&s(x,t))}function C(t,e){t._state===S&&(t._state=2,t._result=e,s(M,t))}function O(t,e,n,r){var o=t._subscribers,i=o.length;t._onerror=null,o[i]=e,o[i+1]=n,o[i+2]=r,0===i&&t._state&&s(x,t)}function x(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var r=void 0,o=void 0,i=t._result,s=0;s<e.length;s+=3)r=e[s],o=e[s+n],r?F(n,r,o,i):o(i);t._subscribers.length=0}}function F(t,n,r,o){var i=e(r),s=void 0,u=void 0,c=!0;if(i){try{s=r(o)}catch(t){c=!1,u=t}if(n===s)return void C(n,new TypeError("A promises callback cannot return that same promise."))}else s=o;n._state!==S||(i&&c?T(n,s):!1===c?C(n,u):1===t?P(n,s):2===t&&C(n,s))}var Y=0;function k(t){t[A]=Y++,t._state=void 0,t._result=void 0,t._subscribers=[]}var q=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(j),this.promise[A]||k(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?P(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&P(this.promise,this._result))):C(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===S&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,r=n.resolve;if(r===g){var o=void 0,i=void 0,s=!1;try{o=t.then}catch(t){s=!0,i=t}if(o===w&&t._state!==S)this._settledAt(t._state,e,t._result);else if("function"!=typeof o)this._remaining--,this._result[e]=t;else if(n===D){var u=new n(j);s?C(u,i):E(u,t,o),this._willSettleAt(u,e)}else this._willSettleAt(new n((function(e){return e(t)})),e)}else this._willSettleAt(r(t),e)},t.prototype._settledAt=function(t,e,n){var r=this.promise;r._state===S&&(this._remaining--,2===t?C(r,n):this._result[e]=n),0===this._remaining&&P(r,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;O(t,void 0,(function(t){return n._settledAt(1,e,t)}),(function(t){return n._settledAt(2,e,t)}))},t}();var D=function(){function t(e){this[A]=Y++,this._result=this._state=void 0,this._subscribers=[],j!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e((function(e){T(t,e)}),(function(e){C(t,e)}))}catch(e){C(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this,r=n.constructor;return e(t)?n.then((function(e){return r.resolve(t()).then((function(){return e}))}),(function(e){return r.resolve(t()).then((function(){throw e}))})):n.then(t,t)},t}();return D.prototype.then=w,D.all=function(t){return new q(this,t).promise},D.race=function(t){var e=this;return n(t)?new e((function(n,r){for(var o=t.length,i=0;i<o;i++)e.resolve(t[i]).then(n,r)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},D.resolve=g,D.reject=function(t){var e=new this(j);return C(e,t),e},D._setScheduler=function(t){i=t},D._setAsap=function(t){s=t},D._asap=s,D.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=D},D.Promise=D,D}))},
function _(t,_,n,o,r){o(),t(1).__exportStar(t(117),n)},
function _(e,t,o,s,l){s();var r=e(1);l("version",e(118).version),l("index",e(119).index),o.embed=r.__importStar(e(119)),o.protocol=r.__importStar(e(528)),o._testing=r.__importStar(e(529));var _=e(134);l("logger",_.logger),l("set_log_level",_.set_log_level),l("settings",e(143).settings),l("Models",e(122).Models),l("documents",e(120).documents),l("safely",e(530).safely)},
function _(n,e,i,o,v){o(),i.version="2.4.0-dev.1"},
function _(e,r,t,n,o){n();var s=e(1),a=e(120),d=e(134),u=e(149),i=e(128),_=e(123),l=e(131),c=e(519),m=e(521),f=e(520),h=e(519);o("add_document_standalone",h.add_document_standalone),o("index",h.index),o("add_document_from_session",e(521).add_document_from_session);var v=e(526);function b(e,r,t,n){return s.__awaiter(this,void 0,void 0,(function(){var o,l,h,v,b,g,p,w,y,k,O,x,B,E,H,K,R,T,S,j,D,I,J;return s.__generator(this,(function(L){switch(L.label){case 0:_.isString(e)&&(e=JSON.parse(u.unescape(e))),o={};try{for(l=s.__values(i.entries(e)),h=l.next();!h.done;h=l.next())v=s.__read(h.value,2),b=v[0],g=v[1],o[b]=a.Document.from_json(g)}catch(e){j={error:e}}finally{try{h&&!h.done&&(D=l.return)&&D.call(l)}finally{if(j)throw j.error}}p=[],L.label=1;case 1:L.trys.push([1,12,13,14]),w=s.__values(r),y=w.next(),L.label=2;case 2:return y.done?[3,11]:(k=y.value,O=f._resolve_element(k),x=f._resolve_root_elements(k),null==k.docid?[3,4]:(E=(B=p).push,[4,c.add_document_standalone(o[k.docid],O,x,k.use_for_title)]));case 3:return E.apply(B,[L.sent()]),[3,10];case 4:if(null==k.token)return[3,9];H=m._get_ws_url(t,n),d.logger.debug("embed: computed ws url: "+H),L.label=5;case 5:return L.trys.push([5,7,,8]),R=(K=p).push,[4,m.add_document_from_session(H,k.token,O,x,k.use_for_title)];case 6:return R.apply(K,[L.sent()]),console.log("Bokeh items were rendered successfully"),[3,8];case 7:return T=L.sent(),console.log("Error rendering Bokeh items:",T),[3,8];case 8:return[3,10];case 9:throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");case 10:return y=w.next(),[3,2];case 11:return[3,14];case 12:return S=L.sent(),I={error:S},[3,14];case 13:try{y&&!y.done&&(J=w.return)&&J.call(w)}finally{if(I)throw I.error}return[7];case 14:return[2,p]}}))}))}o("embed_items_notebook",v.embed_items_notebook),o("kernels",v.kernels),o("BOKEH_ROOT",e(520).BOKEH_ROOT),t.embed_item=function(e,r){return s.__awaiter(this,void 0,void 0,(function(){var t,n,o,a,d,i;return s.__generator(this,(function(_){switch(_.label){case 0:return t={},n=u.uuid4(),t[n]=e.doc,null==r&&(r=e.target_id),null!=(o=document.getElementById(r))&&o.classList.add(f.BOKEH_ROOT),(i={})[e.root_id]=r,a={roots:i,root_ids:[e.root_id],docid:n},[4,l.defer()];case 1:return _.sent(),[4,b(t,[a])];case 2:return d=s.__read.apply(void 0,[_.sent(),1]),[2,d[0]]}}))}))},t.embed_items=function(e,r,t,n){return s.__awaiter(this,void 0,void 0,(function(){return s.__generator(this,(function(o){switch(o.label){case 0:return[4,l.defer()];case 1:return o.sent(),[2,b(e,r,t,n)]}}))}))}},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(121),_),e.__exportStar(r(150),_)},
function _(e,t,r,n,o){n();var a=e(1),l=e(122),i=e(118),s=e(134),_=e(361),c=e(129),u=e(145),f=e(130),d=e(132),v=e(146),h=e(144),y=e(124),p=e(128),m=a.__importStar(e(192)),w=e(141),g=e(123),x=e(432),b=e(190),k=e(168),M=e(518),j=e(150),S=function(){function e(e){this.document=e,this.session=null,this.subscribed_models=new Set}return e.prototype.send_event=function(e){var t=new j.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)},e.prototype.trigger=function(e){var t,r;try{for(var n=a.__values(this.subscribed_models),o=n.next();!o.done;o=n.next()){var l=o.value;null!=e.origin&&e.origin!=l||l._process_event(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}},e}();r.EventManager=S,S.__name__="EventManager",r.documents=[],r.DEFAULT_TITLE="Bokeh Application";var z=function(){function e(e){var t;r.documents.push(this),this._init_timestamp=Date.now(),this._resolver=null!==(t=null==e?void 0:e.resolver)&&void 0!==t?t:new l.ModelResolver,this._title=r.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new S(this),this.idle=new f.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(e.prototype,"layoutables",{get:function(){return this._roots.filter((function(e){return e instanceof x.LayoutDOM}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){var e,t;try{for(var r=a.__values(this.layoutables),n=r.next();!n.done;n=r.next()){var o=n.value;if(!this._idle_roots.has(o))return!1}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return!0},enumerable:!1,configurable:!0}),e.prototype.notify_idle=function(e){this._idle_roots.set(e,!0),this.is_idle&&(s.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.event_manager.send_event(new _.DocumentReady),this.idle.emit())},e.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},e.prototype.interactive_start=function(e,t){void 0===t&&(t=null),null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new _.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()},e.prototype.interactive_stop=function(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new _.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null},e.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},e.prototype.destructively_move=function(e){var t,r,n,o;if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();var l=y.copy(this._roots);this.clear();try{for(var i=a.__values(l),s=i.next();!s.done;s=i.next()){if(null!=(u=s.value).document)throw new Error("Somehow we didn't detach "+u)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);try{for(var _=a.__values(l),c=_.next();!c.done;c=_.next()){var u=c.value;e.add_root(u)}}catch(e){n={error:e}}finally{try{c&&!c.done&&(o=_.return)&&o.call(_)}finally{if(n)throw n.error}}e.set_title(this._title)},e.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},e.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._invalidate_all_models=function(){s.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._recompute_all_models=function(){var e,t,r,n,o,l,i,s,_=new Set;try{for(var c=a.__values(this._roots),u=c.next();!u.done;u=c.next()){var f=u.value;_=m.union(_,f.references())}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=c.return)&&t.call(c)}finally{if(e)throw e.error}}var d=new Set(this._all_models.values()),v=m.difference(d,_),h=m.difference(_,d),y=new Map;try{for(var p=a.__values(_),w=p.next();!w.done;w=p.next()){var g=w.value;y.set(g.id,g)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}try{for(var x=a.__values(v),b=x.next();!b.done;b=x.next()){b.value.detach_document()}}catch(e){o={error:e}}finally{try{b&&!b.done&&(l=x.return)&&l.call(x)}finally{if(o)throw o.error}}try{for(var k=a.__values(h),M=k.next();!M.done;M=k.next()){M.value.attach_document(this)}}catch(e){i={error:e}}finally{try{M&&!M.done&&(s=k.return)&&s.call(k)}finally{if(i)throw i.error}}this._all_models=y},e.prototype.roots=function(){return this._roots},e.prototype.add_root=function(e,t){if(s.logger.debug("Adding root: "+e),!y.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootAddedEvent(this,e,t))}},e.prototype.remove_root=function(e,t){var r=this._roots.indexOf(e);if(!(r<0)){this._push_all_models_freeze();try{this._roots.splice(r,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootRemovedEvent(this,e,t))}},e.prototype.title=function(){return this._title},e.prototype.set_title=function(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new j.TitleChangedEvent(this,e,t)))},e.prototype.get_model_by_id=function(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null},e.prototype.get_model_by_name=function(e){var t,r,n=[];try{for(var o=a.__values(this._all_models.values()),l=o.next();!l.done;l=o.next()){var i=l.value;i instanceof k.Model&&i.name==e&&n.push(i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}switch(n.length){case 0:return null;case 1:return n[0];default:throw new Error("Multiple models are named '"+e+"'")}},e.prototype.on_message=function(e,t){var r=this._message_callbacks.get(e);null==r?this._message_callbacks.set(e,new Set([t])):r.add(t)},e.prototype.remove_on_message=function(e,t){var r;null===(r=this._message_callbacks.get(e))||void 0===r||r.delete(t)},e.prototype._trigger_on_message=function(e,t){var r,n,o=this._message_callbacks.get(e);if(null!=o)try{for(var l=a.__values(o),i=l.next();!i.done;i=l.next()){(0,i.value)(t)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},e.prototype.on_change=function(e,t){void 0===t&&(t=!1),this._callbacks.has(e)||this._callbacks.set(e,t)},e.prototype.remove_on_change=function(e){this._callbacks.delete(e)},e.prototype._trigger_on_change=function(e){var t,r,n,o;try{for(var l=a.__values(this._callbacks),i=l.next();!i.done;i=l.next()){var s=a.__read(i.value,2),_=s[0];if(!s[1]&&e instanceof j.DocumentEventBatch)try{for(var c=(n=void 0,a.__values(e.events)),u=c.next();!u.done;u=c.next()){_(u.value)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(o=c.return)&&o.call(c)}finally{if(n)throw n.error}}else _(e)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}},e.prototype._notify_change=function(e,t,r,n,o){this._trigger_on_change(new j.ModelChangedEvent(this,e,t,r,n,null==o?void 0:o.setter_id,null==o?void 0:o.hint))},e._instantiate_object=function(e,t,r,n){var o=a.__assign(a.__assign({},r),{id:e,__deferred__:!0});return new(n.get(t))(o)},e._instantiate_references_json=function(t,r,n){var o,l,i,s=new Map;try{for(var _=a.__values(t),c=_.next();!c.done;c=_.next()){var u=c.value,f=u.id,d=u.type,v=null!==(i=u.attributes)&&void 0!==i?i:{},h=r.get(f);null==h&&(h=e._instantiate_object(f,d,v,n),null!=u.subtype&&h.set_subtype(u.subtype)),s.set(h.id,h)}}catch(e){o={error:e}}finally{try{c&&!c.done&&(l=_.return)&&l.call(_)}finally{if(o)throw o.error}}return s},e._resolve_refs=function(e,t,r,n){function o(e){var l;if(d.is_ref(e)){var i=null!==(l=t.get(e.id))&&void 0!==l?l:r.get(e.id);if(null!=i)return i;throw new Error("reference "+JSON.stringify(e)+" isn't known (not in Document?)")}if(v.is_NDArray_ref(e)){var s=v.decode_NDArray(e,n),_=s.buffer,c=s.dtype,u=s.shape;return h.ndarray(_,{dtype:c,shape:u})}return g.isArray(e)?function(e){var t,r,n=[];try{for(var l=a.__values(e),i=l.next();!i.done;i=l.next()){var s=i.value;n.push(o(s))}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):g.isPlainObject(e)?function(e){var t,r,n={};try{for(var l=a.__values(p.entries(e)),i=l.next();!i.done;i=l.next()){var s=a.__read(i.value,2),_=s[0],c=s[1];n[_]=o(c)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):e}return o(e)},e._initialize_references_json=function(t,r,n,o){var l,i,s,_,u,f,d=new Map;try{for(var v=a.__values(t),h=v.next();!h.done;h=v.next()){var y=h.value,m=y.id,w=y.attributes,x=!r.has(m),b=x?n.get(m):r.get(m),k=e._resolve_refs(w,r,n,o);b.setv(k,{silent:!0}),d.set(m,{instance:b,is_new:x})}}catch(e){l={error:e}}finally{try{h&&!h.done&&(i=v.return)&&i.call(v)}finally{if(l)throw l.error}}var M=[],j=new Set;function S(e){var t,r,n,o,l,i;if(e instanceof c.HasProps){if(d.has(e.id)&&!j.has(e.id)){j.add(e.id);var s=d.get(e.id),_=s.instance,u=s.is_new,f=_.attributes;try{for(var v=a.__values(p.values(f)),h=v.next();!h.done;h=v.next()){S(h.value)}}catch(e){t={error:e}}finally{try{h&&!h.done&&(r=v.return)&&r.call(v)}finally{if(t)throw t.error}}u&&(_.finalize(),M.push(_))}}else if(g.isArray(e))try{for(var y=a.__values(e),m=y.next();!m.done;m=y.next()){S(m.value)}}catch(e){n={error:e}}finally{try{m&&!m.done&&(o=y.return)&&o.call(y)}finally{if(n)throw n.error}}else if(g.isPlainObject(e))try{for(var w=a.__values(p.values(e)),x=w.next();!x.done;x=w.next()){S(x.value)}}catch(e){l={error:e}}finally{try{x&&!x.done&&(i=w.return)&&i.call(w)}finally{if(l)throw l.error}}}try{for(var z=a.__values(d.values()),E=z.next();!E.done;E=z.next()){S(E.value.instance)}}catch(e){s={error:e}}finally{try{E&&!E.done&&(_=z.return)&&_.call(z)}finally{if(s)throw s.error}}try{for(var C=a.__values(M),D=C.next();!D.done;D=C.next()){(b=D.value).connect_signals()}}catch(e){u={error:e}}finally{try{D&&!D.done&&(f=C.return)&&f.call(C)}finally{if(u)throw u.error}}},e._event_for_attribute_change=function(e,t,r,n,o){if(n.get_model_by_id(e.id).property(t).syncable){var a={kind:"ModelChanged",model:{id:e.id},attr:t,new:r};return c.HasProps._json_record_references(n,r,o,{recursive:!0}),a}return null},e._events_to_sync_objects=function(t,r,n,o){var l,i,_,c,u,f,d=Object.keys(t.attributes),v=Object.keys(r.attributes),h=y.difference(d,v),p=y.difference(v,d),m=y.intersection(d,v),g=[];try{for(var x=a.__values(h),b=x.next();!b.done;b=x.next()){var k=b.value;s.logger.warn("Server sent key "+k+" but we don't seem to have it in our JSON")}}catch(e){l={error:e}}finally{try{b&&!b.done&&(i=x.return)&&i.call(x)}finally{if(l)throw l.error}}try{for(var M=a.__values(p),j=M.next();!j.done;j=M.next()){k=j.value;var S=r.attributes[k];g.push(e._event_for_attribute_change(t,k,S,n,o))}}catch(e){_={error:e}}finally{try{j&&!j.done&&(c=M.return)&&c.call(M)}finally{if(_)throw _.error}}try{for(var z=a.__values(m),E=z.next();!E.done;E=z.next()){k=E.value;var C=t.attributes[k];S=r.attributes[k];null==C&&null==S||(null==C||null==S?g.push(e._event_for_attribute_change(t,k,S,n,o)):w.is_equal(C,S)||g.push(e._event_for_attribute_change(t,k,S,n,o)))}}catch(e){u={error:e}}finally{try{E&&!E.done&&(f=z.return)&&f.call(z)}finally{if(u)throw u.error}}return g.filter((function(e){return null!=e}))},e._compute_patch_since_json=function(t,r){var n,o,l,i,s,_,c=r.to_json(!1);function f(e){var t,r,n=new Map;try{for(var o=a.__values(e.roots.references),l=o.next();!l.done;l=o.next()){var i=l.value;n.set(i.id,i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}return n}var d=f(t),v=new Map,h=[];try{for(var p=a.__values(t.roots.root_ids),m=p.next();!m.done;m=p.next()){var w=m.value;v.set(w,d.get(w)),h.push(w)}}catch(e){n={error:e}}finally{try{m&&!m.done&&(o=p.return)&&o.call(p)}finally{if(n)throw n.error}}var g=f(c),x=new Map,b=[];try{for(var k=a.__values(c.roots.root_ids),M=k.next();!M.done;M=k.next()){w=M.value;x.set(w,g.get(w)),b.push(w)}}catch(e){l={error:e}}finally{try{M&&!M.done&&(i=k.return)&&i.call(k)}finally{if(l)throw l.error}}if(h.sort(),b.sort(),y.difference(h,b).length>0||y.difference(b,h).length>0)throw new Error("Not implemented: computing add/remove of document roots");var j=new Set,S=[];try{for(var z=a.__values(r._all_models.keys()),E=z.next();!E.done;E=z.next()){var C=E.value;if(d.has(C)){var D=e._events_to_sync_objects(d.get(C),g.get(C),r,j);S=S.concat(D)}}}catch(e){s={error:e}}finally{try{E&&!E.done&&(_=z.return)&&_.call(z)}finally{if(s)throw s.error}}var O=new u.Serializer({include_defaults:!1});return O.to_serializable(a.__spreadArray([],a.__read(j))),{references:a.__spreadArray([],a.__read(O.definitions)),events:S}},e.prototype.to_json_string=function(e){return void 0===e&&(e=!0),JSON.stringify(this.to_json(e))},e.prototype.to_json=function(e){void 0===e&&(e=!0);var t=new u.Serializer({include_defaults:e}),r=t.to_serializable(this._roots);return{version:i.version,title:this._title,roots:{root_ids:r.map((function(e){return e.id})),references:a.__spreadArray([],a.__read(t.definitions))}}},e.from_json_string=function(t){var r=JSON.parse(t);return e.from_json(r)},e.from_json=function(t){var r,n;s.logger.debug("Creating Document from JSON");var o=t.version,_=-1!==o.indexOf("+")||-1!==o.indexOf("-"),c="Library versions: JS ("+i.version+") / Python ("+o+")";_||i.version.replace(/-(dev|rc)\./,"$1")==o?s.logger.debug(c):(s.logger.warn("JS/Python version mismatch"),s.logger.warn(c));var u=new l.ModelResolver;null!=t.defs&&M.resolve_defs(t.defs,u);var f=t.roots,d=f.root_ids,v=f.references,h=e._instantiate_references_json(v,new Map,u);e._initialize_references_json(v,new Map,h,new Map);var y=new e({resolver:u});try{for(var p=a.__values(d),m=p.next();!m.done;m=p.next()){var w=m.value,g=h.get(w);null!=g&&y.add_root(g)}}catch(e){r={error:e}}finally{try{m&&!m.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}return y.set_title(t.title),y},e.prototype.replace_with_json=function(t){e.from_json(t).destructively_move(this)},e.prototype.create_json_patch_string=function(e){return JSON.stringify(this.create_json_patch(e))},e.prototype.create_json_patch=function(e){var t,r,n,o;try{for(var l=a.__values(e),i=l.next();!i.done;i=l.next()){if(i.value.document!=this)throw new Error("Cannot create a patch using events from a different document")}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}var s=new u.Serializer,_=s.to_serializable(e);try{for(var c=a.__values(this._all_models.values()),f=c.next();!f.done;f=c.next()){var d=f.value;s.remove_def(d)}}catch(e){n={error:e}}finally{try{f&&!f.done&&(o=c.return)&&o.call(c)}finally{if(n)throw n.error}}return{events:_,references:a.__spreadArray([],a.__read(s.definitions))}},e.prototype.apply_json_patch=function(t,r,n){var o,l,i,_,c,u,f;void 0===r&&(r=new Map);var d=t.references,v=t.events,h=e._instantiate_references_json(d,this._all_models,this._resolver);r instanceof Map||(r=new Map(r));try{for(var y=a.__values(v),p=y.next();!p.done;p=y.next()){switch((D=p.value).kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var m=D.model.id,w=this._all_models.get(m);if(null!=w)h.set(m,w);else if(!h.has(m))throw s.logger.warn("Got an event for unknown model "+D.model+'"'),new Error("event model wasn't known")}}}catch(e){o={error:e}}finally{try{p&&!p.done&&(l=y.return)&&l.call(y)}finally{if(o)throw o.error}}var g=new Map(this._all_models),x=new Map;try{for(var k=a.__values(h),M=k.next();!M.done;M=k.next()){var j=a.__read(M.value,2),S=j[0],z=j[1];g.has(S)||x.set(S,z)}}catch(e){i={error:e}}finally{try{M&&!M.done&&(_=k.return)&&_.call(k)}finally{if(i)throw i.error}}e._initialize_references_json(d,g,x,r);try{for(var E=a.__values(v),C=E.next();!C.done;C=E.next()){var D;switch((D=C.value).kind){case"MessageSent":var O=D.msg_type,A=D.msg_data,R=void 0;if(void 0===A){if(1!=r.size)throw new Error("expected exactly one buffer");var N=a.__read(r,1);R=a.__read(N[0],2)[1]}else R=e._resolve_refs(A,g,x,r);this._trigger_on_message(O,R);break;case"ModelChanged":var J=D.model.id,P=this._all_models.get(J);if(null==P)throw new Error("Cannot apply patch to "+J+" which is not in the document");var L=D.attr;z=e._resolve_refs(D.new,g,x,r);P.setv(((f={})[L]=z,f),{setter_id:n});break;case"ColumnDataChanged":var T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");R=e._resolve_refs(D.new,new Map,new Map,r);if(null!=D.cols)for(var U in B.data)U in R||(R[U]=B.data[U]);B.setv({data:R},{setter_id:n,check_eq:!1});break;case"ColumnsStreamed":T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");if(!(B instanceof b.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");R=D.data;var q=D.rollover;B.stream(R,q,n);break;case"ColumnsPatched":var B;T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot patch "+T+" which is not in the document");if(!(B instanceof b.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var F=D.patches;B.patch(F,n);break;case"RootAdded":var H=D.model.id,I=h.get(H);this.add_root(I,n);break;case"RootRemoved":H=D.model.id,I=h.get(H);this.remove_root(I,n);break;case"TitleChanged":this.set_title(D.title,n);break;default:throw new Error("Unknown patch event "+JSON.stringify(D))}}}catch(e){c={error:e}}finally{try{C&&!C.done&&(u=E.return)&&u.call(E)}finally{if(c)throw c.error}}},e}();r.Document=z,z.__name__="Document"},
function _(e,r,o,t,s){t();var n=e(1),i=e(123),l=e(128),d=e(129);o.overrides={};var a=new Map;o.Models=function(e){var r=o.Models.get(e);if(null!=r)return r;throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.")},o.Models.get=function(e){var r;return null!==(r=o.overrides[e])&&void 0!==r?r:a.get(e)},o.Models.register=function(e,r){o.overrides[e]=r},o.Models.unregister=function(e){delete o.overrides[e]},o.Models.register_models=function(e,r,o){var t,s,u;if(void 0===r&&(r=!1),null!=e)try{for(var _=n.__values(i.isArray(e)?e:l.values(e)),f=_.next();!f.done;f=_.next()){var v=f.value;if(u=v,i.isObject(u)&&u.prototype instanceof d.HasProps){var g=v.__qualified__;r||!a.has(g)?a.set(g,v):null!=o?o(g):console.warn("Model '"+g+"' was already registered")}}}catch(e){t={error:e}}finally{try{f&&!f.done&&(s=_.return)&&s.call(_)}finally{if(t)throw t.error}}},o.register_models=o.Models.register_models,o.Models.registered_names=function(){return n.__spreadArray([],n.__read(a.keys()))};var u=function(){function e(){this._known_models=new Map}return e.prototype.get=function(e,r){var t,s=null!==(t=o.Models.get(e))&&void 0!==t?t:this._known_models.get(e);if(null!=s)return s;if(void 0!==r)return r;throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.")},e.prototype.register=function(e){var r=e.__qualified__;null==this.get(r,null)?this._known_models.set(r,e):console.warn("Model '"+r+"' was already registered with this resolver")},e}();o.ModelResolver=u,u.__name__="ModelResolver";var _=n.__importStar(e(153));o.register_models(_);var f=n.__importStar(e(514));o.register_models(f)},
function _(r,n,t,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var u=r(124),o=Object.prototype.toString;function c(r){return!0===r||!1===r||"[object Boolean]"===o.call(r)}function a(r){return"[object Number]"===o.call(r)}function f(r){return"[object String]"===o.call(r)}function l(r){var n=typeof r;return"function"===n||"object"===n&&!!r}function s(r){return l(r)&&void 0!==r[Symbol.iterator]}t.isBoolean=c,t.isNumber=a,t.isInteger=function(r){return a(r)&&Number.isInteger(r)},t.isString=f,t.isPrimitive=function(r){return null===r||c(r)||a(r)||f(r)},t.isFunction=function(r){return"[object Function]"===o.call(r)},t.isArray=function(r){return Array.isArray(r)},t.isArrayOf=function(r,n){return u.every(r,n)},t.isArrayableOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.isTypedArray=function(r){return ArrayBuffer.isView(r)&&!(r instanceof DataView)},t.isObject=l,t.isPlainObject=function(r){return l(r)&&(null==r.constructor||r.constructor===Object)},t.isIterable=s,t.isArrayable=function(r){return s(r)&&"length"in r}},
function _(r,n,e,t,a){t();var i=r(1),o=r(125),u=r(126),f=r(127);
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
a("map",f.map),a("reduce",f.reduce),a("min",f.min),a("min_by",f.min_by),a("max",f.max),a("max_by",f.max_by),a("sum",f.sum),a("cumsum",f.cumsum),a("every",f.every),a("some",f.some),a("find",f.find),a("find_last",f.find_last),a("find_index",f.find_index),a("find_last_index",f.find_last_index),a("sorted_index",f.sorted_index),a("is_empty",f.is_empty);var l=Array.prototype.slice;function c(r){return l.call(r)}function v(r){return[].concat.apply([],i.__spreadArray([],i.__read(r)))}function y(r,n){return-1!==r.indexOf(n)}function d(r,n,e){void 0===e&&(e=1),u.assert(e>0,"'step' must be a positive number"),null==n&&(n=r,r=0);for(var t=r<=n?e:-e,a=(0,Math.max)((0,Math.ceil)((0,Math.abs)(n-r)/e),0),i=new Array(a),o=0;o<a;o++,r+=t)i[o]=r;return i}e.head=function(r){return r[0]},e.tail=function(r){return r[r.length-1]},e.last=function(r){return r[r.length-1]},e.copy=c,e.concat=v,e.includes=y,e.contains=y,e.nth=function(r,n){return r[n>=0?n:r.length+n]},e.zip=function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];if(0==r.length)return[];for(var e=f.min(r.map((function(r){return r.length}))),t=r.length,a=new Array(e),i=0;i<e;i++){a[i]=new Array(t);for(var o=0;o<t;o++)a[i][o]=r[o][i]}return a},e.unzip=function(r){for(var n=r.length,e=f.min(r.map((function(r){return r.length}))),t=Array(e),a=0;a<e;a++)t[a]=new Array(n);for(var i=0;i<n;i++)for(a=0;a<e;a++)t[a][i]=r[i][a];return t},e.range=d,e.linspace=function(r,n,e){void 0===e&&(e=100);for(var t=(n-r)/(e-1),a=new Array(e),i=0;i<e;i++)a[i]=r+t*i;return a},e.transpose=function(r){for(var n=r.length,e=r[0].length,t=[],a=0;a<e;a++){t[a]=[];for(var i=0;i<n;i++)t[a][i]=r[i][a]}return t},e.argmin=function(r){return f.min_by(d(r.length),(function(n){return r[n]}))},e.argmax=function(r){return f.max_by(d(r.length),(function(n){return r[n]}))},e.sort_by=function(r,n){var e=r.map((function(r,e){return{value:r,index:e,key:n(r)}}));return e.sort((function(r,n){var e=r.key,t=n.key;if(e!==t){if(e>t||void 0===e)return 1;if(e<t||void 0===t)return-1}return r.index-n.index})),e.map((function(r){return r.value}))},e.uniq=function(r){var n,e,t=new Set;try{for(var a=i.__values(r),o=a.next();!o.done;o=a.next()){var u=o.value;t.add(u)}}catch(r){n={error:r}}finally{try{o&&!o.done&&(e=a.return)&&e.call(a)}finally{if(n)throw n.error}}return i.__spreadArray([],i.__read(t))},e.uniq_by=function(r,n){var e,t,a=[],o=[];try{for(var u=i.__values(r),f=u.next();!f.done;f=u.next()){var l=f.value,c=n(l);y(o,c)||(o.push(c),a.push(l))}}catch(r){e={error:r}}finally{try{f&&!f.done&&(t=u.return)&&t.call(u)}finally{if(e)throw e.error}}return a},e.union=function(){for(var r,n,e,t,a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];var u=new Set;try{for(var f=i.__values(a),l=f.next();!l.done;l=f.next()){var c=l.value;try{for(var v=(e=void 0,i.__values(c)),y=v.next();!y.done;y=v.next()){var d=y.value;u.add(d)}}catch(r){e={error:r}}finally{try{y&&!y.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}}}catch(n){r={error:n}}finally{try{l&&!l.done&&(n=f.return)&&n.call(f)}finally{if(r)throw r.error}}return i.__spreadArray([],i.__read(u))},e.intersection=function(r){for(var n,e,t,a,o=[],u=1;u<arguments.length;u++)o[u-1]=arguments[u];var f=[];try{r:for(var l=i.__values(r),c=l.next();!c.done;c=l.next()){var v=c.value;if(!y(f,v)){try{for(var d=(t=void 0,i.__values(o)),s=d.next();!s.done;s=d.next()){var _=s.value;if(!y(_,v))continue r}}catch(r){t={error:r}}finally{try{s&&!s.done&&(a=d.return)&&a.call(d)}finally{if(t)throw t.error}}f.push(v)}}}catch(r){n={error:r}}finally{try{c&&!c.done&&(e=l.return)&&e.call(l)}finally{if(n)throw n.error}}return f},e.difference=function(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];var t=v(n);return r.filter((function(r){return!y(t,r)}))},e.remove_at=function(r,n){var e=c(r);return e.splice(n,1),e},e.remove_by=function(r,n){for(var e=0;e<r.length;)n(r[e])?r.splice(e,1):e++},e.shuffle=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++){var a=o.randomIn(0,t);a!==t&&(e[t]=e[a]),e[a]=r[t]}return e},e.pairwise=function(r,n){for(var e=r.length,t=new Array(e-1),a=0;a<e-1;a++)t[a]=n(r[a],r[a+1]);return t},e.reversed=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++)e[n-t-1]=r[t];return e},e.repeat=function(r,n){for(var e=new Array(n),t=0;t<n;t++)e[t]=r;return e}},
function _(n,r,t,a,e){a();var u=Math.PI;function o(n){if(0==n)return 0;for(;n<=0;)n+=2*u;for(;n>2*u;)n-=2*u;return n}function f(n,r){return o(n-r)}function i(){return Math.random()}function c(n){switch(n){case"deg":return u/180;case"rad":return 1;case"grad":return u/200;case"turn":return 2*u}}t.angle_norm=o,t.angle_dist=f,t.angle_between=function(n,r,t,a){void 0===a&&(a=!1);var e=f(r,t);if(0==e)return!1;if(e==2*u)return!0;var i=o(n),c=f(r,i)<=e&&f(i,t)<=e;return a?!c:c},t.random=i,t.randomIn=function(n,r){return null==r&&(r=n,n=0),n+Math.floor(Math.random()*(r-n+1))},t.atan2=function(n,r){return Math.atan2(r[1]-n[1],r[0]-n[0])},t.radians=function(n){return n*(u/180)},t.degrees=function(n){return n/(u/180)},t.resolve_angle=function(n,r){return-c(r)*n},t.to_radians_coeff=c,t.rnorm=function(n,r){for(var t,a;t=i(),a=(2*(a=i())-1)*Math.sqrt(1/Math.E*2),!(-4*t*t*Math.log(t)>=a*a););var e=a/t;return e=n+r*e},t.clamp=function(n,r,t){return n<r?r:n>t?t:n},t.log=function(n,r){return void 0===r&&(r=Math.E),Math.log(n)/Math.log(r)}},
function _(r,n,e,t,o){t();var i=r(1),s=function(r){function n(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(n,r),n}(Error);e.AssertionError=s,s.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new s(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(n,r,t,e,i){e();var o=n(1),u=n(125);function f(n,r,t){for(var e,i,u=[],f=3;f<arguments.length;f++)u[f-3]=arguments[f];var a=n.length;r<0&&(r+=a),r<0?r=0:r>a&&(r=a),null==t||t>a-r?t=a-r:t<0&&(t=0);for(var l=a-t+u.length,c=new n.constructor(l),v=0;v<r;v++)c[v]=n[v];try{for(var h=o.__values(u),g=h.next();!g.done;g=h.next()){var s=g.value;c[v++]=s}}catch(n){e={error:n}}finally{try{g&&!g.done&&(i=h.return)&&i.call(h)}finally{if(e)throw e.error}}for(var d=r+t;d<a;d++)c[v++]=n[d];return c}function a(n,r){return f(n,r,n.length-r)}function l(n,r){for(var t=n.length,e=new n.constructor(t),i=0;i<t;i++)e[i]=r(n[i],i,n);return e}function c(n,r,t){var e,i,o=n.length;if(void 0===t&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===t?(e=n[0],i=1):(e=t,i=0);i<o;i++)e=r(e,n[i],i,n);return e}function v(n){return function(r,t){for(var e=r.length,i=n>0?0:e-1;i>=0&&i<e;i+=n)if(t(r[i]))return i;return-1}}function h(n,r){for(var t=0,e=n.length;t<e;){var i=Math.floor((t+e)/2);n[i]<r?t=i+1:e=i}return t}function g(n,r,t,e,i){var o=(i-t)/(e-r),u=o*(n-r)+t;return isFinite(u)||(u=o*(n-e)+i,isFinite(u)||t!=i||(u=t)),u}function s(n,r){if(n<r[0])return-1;if(n>r[r.length-1])return r.length;for(var t=0,e=r.length-1;e-t!=1;){var i=t+Math.floor((e-t)/2);n>=r[i]?t=i:e=i}return t}t.is_empty=function(n){return 0==n.length},t.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},t.splice=f,t.head=a,t.insert=function(n,r,t){return f(n,t,0,r)},t.append=function(n,r){return f(n,n.length,0,r)},t.prepend=function(n,r){return f(n,0,0,r)},t.indexOf=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.subselect=function(n,r){for(var t=r.length,e=new n.constructor(t),i=0;i<t;i++)e[i]=n[r[i]];return e},t.mul=function(n,r,t){for(var e=n.length,i=null!=t?t:new n.constructor(e),o=0;o<e;o++)i[o]=n[o]*r;return i},t.map=l,t.inplace_map=function(n,r,t){for(var e=n.length,i=null!=t?t:n,o=0;o<e;o++)i[o]=r(n[o],o)},t.filter=function(n,r){for(var t=n.length,e=new n.constructor(t),i=0,o=0;o<t;o++){var u=n[o];r(u,o,n)&&(e[i++]=u)}return a(e,i)},t.reduce=c,t.min=function(n){for(var r,t=1/0,e=0,i=n.length;e<i;e++)r=n[e],!isNaN(r)&&r<t&&(t=r);return t},t.max=function(n){for(var r,t=-1/0,e=0,i=n.length;e<i;e++)r=n[e],!isNaN(r)&&r>t&&(t=r);return t},t.minmax=function(n){for(var r,t=1/0,e=-1/0,i=0,o=n.length;i<o;i++)r=n[i],isNaN(r)||(r<t&&(t=r),r>e&&(e=r));return[t,e]},t.minmax2=function(n,r){for(var t,e,i=1/0,o=-1/0,u=1/0,f=-1/0,a=Math.min(n.length,r.length),l=0;l<a;l++)t=n[l],e=r[l],isNaN(t)||isNaN(e)||(t<i&&(i=t),t>o&&(o=t),e<u&&(u=e),e>f&&(f=e));return[i,o,u,f]},t.min_by=function(n,r){if(0==n.length)throw new Error("min_by() called with an empty array");for(var t=n[0],e=r(t),i=1,o=n.length;i<o;i++){var u=n[i],f=r(u);f<e&&(t=u,e=f)}return t},t.max_by=function(n,r){if(0==n.length)throw new Error("max_by() called with an empty array");for(var t=n[0],e=r(t),i=1,o=n.length;i<o;i++){var u=n[i],f=r(u);f>e&&(t=u,e=f)}return t},t.sum=function(n){for(var r=0,t=0,e=n.length;t<e;t++)r+=n[t];return r},t.cumsum=function(n){var r=new n.constructor(n.length);return c(n,(function(n,t,e){return r[e]=n+t}),0),r},t.every=function(n,r){for(var t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.some=function(n,r){for(var t=0,e=n.length;t<e;t++)if(r(n[t]))return!0;return!1},t.index_of=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.find_index=v(1),t.find_last_index=v(-1),t.find=function(n,r){var e=t.find_index(n,r);return-1==e?void 0:n[e]},t.find_last=function(n,r){var e=t.find_last_index(n,r);return-1==e?void 0:n[e]},t.sorted_index=h,t.bin_counts=function(n,r){for(var t=r.length-1,e=Array(t).fill(0),i=0;i<n.length;i++){var o=h(r,n[i]);e[u.clamp(o-1,0,t-1)]+=1}return e},t.interpolate=function(n,r,t){for(var e=n.length,i=new Array(e),o=0;o<e;o++){var u=n[o];if(isNaN(u))i[o]=u;else{var f=s(u,r);if(-1==f)i[o]=t[0];else if(f==r.length)i[o]=t[t.length-1];else if(f==r.length-1||r[f]==u)i[o]=t[f];else{var a=r[f],l=t[f],c=r[f+1],v=t[f+1];i[o]=g(u,a,l,c,v)}}}return i},t.left_edge_index=s,t.norm=function(n,r,t){var e=t-r;return l(n,(function(n){return(n-r)/e}))}},
function _(e,r,t,n,a){n();var c=e(1),o=e(124),l=Object.prototype.hasOwnProperty;function i(e){return Object.keys(e).length}function u(e){return 0==i(e)}t.keys=Object.keys,t.values=Object.values,t.entries=Object.entries,t.extend=Object.assign,t.clone=function(e){return c.__assign({},e)},t.merge=function(e,r){var t,n,a=Object.create(Object.prototype),i=o.concat([Object.keys(e),Object.keys(r)]);try{for(var u=c.__values(i),s=u.next();!s.done;s=u.next()){var y=s.value,f=l.call(e,y)?e[y]:[],v=l.call(r,y)?r[y]:[];a[y]=o.union(f,v)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(n=u.return)&&n.call(u)}finally{if(t)throw t.error}}return a},t.size=i,t.is_empty=u,t.isEmpty=u,t.to_object=function(e){var r,t,n={};try{for(var a=c.__values(e),o=a.next();!o.done;o=a.next()){var l=c.__read(o.value,2),i=l[0],u=l[1];n[i]=u}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return n}},
function _(e,r,t,n,a){n();var o=e(1),i=e(130),l=e(132),s=o.__importStar(e(133)),u=o.__importStar(e(136)),c=e(149),_=e(128),f=e(123),v=e(141),y=e(145),p=e(150),d=e(141),h=e(151),g=e(152),x=o.__importStar(e(136)),w=function(e){function r(r){var t,n,a,l;void 0===r&&(r={});var f=e.call(this)||this;f._subtype=void 0,f.document=null,f.destroyed=new i.Signal0(f,"destroyed"),f.change=new i.Signal0(f,"change"),f.transformchange=new i.Signal0(f,"transformchange"),f.exprchange=new i.Signal0(f,"exprchange"),f.properties={},f._pending=!1,f._changing=!1;var v=r instanceof Map?r.get.bind(r):function(e){return r[e]};f.id=null!==(a=v("id"))&&void 0!==a?a:c.uniqueId();var y=function(e,r,t,n){var a=void 0;r instanceof s.PropertyAlias?Object.defineProperty(p.properties,e,{get:function(){return f.properties[r.attr]},configurable:!1,enumerable:!1}):(a=r instanceof u.Kind?new s.PrimitiveProperty(p,e,r,t,v(e),n):new r(p,e,u.Any,t,v(e),n),p.properties[e]=a)},p=this;try{for(var d=o.__values(_.entries(f._props)),h=d.next();!h.done;h=d.next()){var g=o.__read(h.value,2),x=g[0],w=g[1];y(x,w.type,w.default_value,w.options)}}catch(e){t={error:e}}finally{try{h&&!h.done&&(n=d.return)&&n.call(d)}finally{if(t)throw t.error}}return null!==(l=v("__deferred__"))&&void 0!==l&&l||(f.finalize(),f.connect_signals()),f}return o.__extends(r,e),Object.defineProperty(r.prototype,"is_syncable",{get:function(){return!0},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"type",{get:function(){return this.constructor.__qualified__},set:function(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e},enumerable:!1,configurable:!0}),Object.defineProperty(r,"__qualified__",{get:function(){var e=this.__module__,r=this.__name__;return null!=e?e+"."+r:r},enumerable:!1,configurable:!0}),Object.defineProperty(r,Symbol.toStringTag,{get:function(){return this.__name__},enumerable:!1,configurable:!0}),r.init_HasProps=function(){this.prototype._props={},this.prototype._mixins=[]},r._fix_default=function(e,r){if(void 0===e||f.isFunction(e))return e;if(f.isPrimitive(e))return function(){return e};var t=new g.Cloner;return function(){return t.clone(e)}},r.define=function(e){var r,t,n=function(e,r){if(null!=a.prototype._props[e])throw new Error("attempted to redefine property '"+a.prototype.type+"."+e+"'");if(null!=a.prototype[e])throw new Error("attempted to redefine attribute '"+a.prototype.type+"."+e+"'");Object.defineProperty(a.prototype,e,{get:function(){return this.properties[e].get_value()},set:function(r){var t;return this.setv(((t={})[e]=r,t)),this},configurable:!1,enumerable:!0});var t=o.__read(r,3),n=t[0],i=t[1],l=t[2],s=void 0===l?{}:l,u={type:n,default_value:a._fix_default(i,e),options:s},c=o.__assign({},a.prototype._props);c[e]=u,a.prototype._props=c},a=this;try{for(var i=o.__values(_.entries(f.isFunction(e)?e(x):e)),l=i.next();!l.done;l=i.next()){var s=o.__read(l.value,2);n(s[0],s[1])}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(r)throw r.error}}},r.internal=function(e){var r,t,n={};try{for(var a=o.__values(_.entries(f.isFunction(e)?e(x):e)),i=a.next();!i.done;i=a.next()){var l=o.__read(i.value,2),s=l[0],u=l[1],c=o.__read(u,3),v=c[0],y=c[1],p=c[2],d=void 0===p?{}:p;n[s]=[v,y,o.__assign(o.__assign({},d),{internal:!0})]}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}this.define(n)},r.mixins=function(e){var r,t;function n(e,r){var t,n,a={};try{for(var i=o.__values(_.entries(r)),l=i.next();!l.done;l=i.next()){var s=o.__read(l.value,2),u=s[0],c=s[1];a[e+u]=c}}catch(e){t={error:e}}finally{try{l&&!l.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}return a}var a={},i=[];try{for(var l=o.__values(f.isArray(e)?e:[e]),s=l.next();!s.done;s=l.next()){var u=s.value;if(f.isArray(u)){var c=o.__read(u,2),v=c[0],y=c[1];_.extend(a,n(v,y)),i.push([v,y])}else{y=u;_.extend(a,y),i.push(["",y])}}}catch(e){r={error:e}}finally{try{s&&!s.done&&(t=l.return)&&t.call(l)}finally{if(r)throw r.error}}this.define(a),this.prototype._mixins=o.__spreadArray(o.__spreadArray([],o.__read(this.prototype._mixins)),o.__read(i))},r.override=function(e){var r,t;try{for(var n=o.__values(_.entries(e)),a=n.next();!a.done;a=n.next()){var i=o.__read(a.value,2),l=i[0],s=i[1],u=this._fix_default(s,l),c=this.prototype._props[l];if(null==c)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+l+"'");var f=o.__assign({},this.prototype._props);f[l]=o.__assign(o.__assign({},c),{default_value:u}),this.prototype._props=f}}catch(e){r={error:e}}finally{try{a&&!a.done&&(t=n.return)&&t.call(n)}finally{if(r)throw r.error}}},r.prototype.toString=function(){return this.type+"("+this.id+")"},r.prototype.property=function(e){var r=this.properties[e];if(null!=r)return r;throw new Error("unknown property "+this.type+"."+e)},Object.defineProperty(r.prototype,"attributes",{get:function(){var e,r,t={};try{for(var n=o.__values(this),a=n.next();!a.done;a=n.next()){var i=a.value;t[i.attr]=i.get_value()}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return t},enumerable:!1,configurable:!0}),r.prototype[g.clone]=function(e){var r,t,n=new Map;try{for(var a=o.__values(this),i=a.next();!i.done;i=a.next()){var l=i.value;l.dirty&&n.set(l.attr,e.clone(l.get_value()))}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return new this.constructor(n)},r.prototype[d.equals]=function(e,r){var t,n;try{for(var a=o.__values(this),i=a.next();!i.done;i=a.next()){var l=i.value,s=e.property(l.attr);if(r.eq(l.get_value(),s.get_value()))return!1}}catch(e){t={error:e}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}return!0},r.prototype[h.pretty]=function(e){var r,t,n=e.token,a=[];try{for(var i=o.__values(this),l=i.next();!l.done;l=i.next()){var s=l.value;if(s.dirty){var u=s.get_value();a.push(""+s.attr+n(":")+" "+e.to_string(u))}}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(r)throw r.error}}return""+this.constructor.__qualified__+n("(")+n("{")+a.join(n(",")+" ")+n("}")+n(")")},r.prototype[y.serialize]=function(e){var r,t,n=this.ref();e.add_ref(this,n);var a=this.struct();try{for(var i=o.__values(this),l=i.next();!l.done;l=i.next()){var s=l.value;s.syncable&&(e.include_defaults||s.dirty)&&(a.attributes[s.attr]=e.to_serializable(s.get_value()))}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(r)throw r.error}}return e.add_def(this,a),n},r.prototype.finalize=function(){var e,r,t=this;try{for(var n=o.__values(this),a=n.next();!a.done;a=n.next()){var i=a.value;if(i instanceof s.VectorSpec||i instanceof s.ScalarSpec){var l=i.get_value();if(null!=l){var u=l.transform,c=l.expr;null!=u&&this.connect(u.change,(function(){return t.transformchange.emit()})),null!=c&&this.connect(c.change,(function(){return t.exprchange.emit()}))}}}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}this.initialize()},r.prototype.initialize=function(){},r.prototype.connect_signals=function(){},r.prototype.disconnect_signals=function(){i.Signal.disconnectReceiver(this)},r.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},r.prototype.clone=function(){return(new g.Cloner).clone(this)},r.prototype._setv=function(e,r){var t,n,a,i,l=r.check_eq,s=[],u=this._changing;this._changing=!0;try{for(var c=o.__values(e),_=c.next();!_.done;_=c.next()){var f=o.__read(_.value,2),y=f[0],p=f[1];!1!==l&&v.is_equal(y.get_value(),p)||(y.set_value(p),s.push(y))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=c.return)&&n.call(c)}finally{if(t)throw t.error}}s.length>0&&(this._pending=!0);try{for(var d=o.__values(s),h=d.next();!h.done;h=d.next()){(y=h.value).change.emit()}}catch(e){a={error:e}}finally{try{h&&!h.done&&(i=d.return)&&i.call(d)}finally{if(a)throw a.error}}if(!u){if(!r.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},r.prototype.setv=function(e,r){var t,n,a,i,l,s,u,c;void 0===r&&(r={});var f=_.entries(e);if(0!=f.length)if(!0!==r.silent){var v=new Map,y=new Map;try{for(var p=o.__values(f),d=p.next();!d.done;d=p.next()){var h=o.__read(d.value,2),g=(k=h[0],C=h[1],this.properties[k]);v.set(g,C),y.set(g,g.get_value())}}catch(e){a={error:e}}finally{try{d&&!d.done&&(i=p.return)&&i.call(p)}finally{if(a)throw a.error}}this._setv(v,r);var x=this.document;if(null!=x){var w=[];try{for(var b=o.__values(y),m=b.next();!m.done;m=b.next()){var S=o.__read(m.value,2);g=S[0],C=S[1];w.push([g,C,g.get_value()])}}catch(e){l={error:e}}finally{try{m&&!m.done&&(s=b.return)&&s.call(b)}finally{if(l)throw l.error}}try{for(var P=o.__values(w),j=P.next();!j.done;j=P.next()){var A=o.__read(j.value,3),O=A[1],q=A[2];if(this._needs_invalidate(O,q)){x._invalidate_all_models();break}}}catch(e){u={error:e}}finally{try{j&&!j.done&&(c=P.return)&&c.call(P)}finally{if(u)throw u.error}}this._push_changes(w,r)}}else try{for(var z=o.__values(f),E=z.next();!E.done;E=z.next()){var M=o.__read(E.value,2),k=M[0],C=M[1];this.properties[k].set_value(C)}}catch(e){t={error:e}}finally{try{E&&!E.done&&(n=z.return)&&n.call(z)}finally{if(t)throw t.error}}},r.prototype.getv=function(e){return this.property(e).get_value()},r.prototype.ref=function(){return{id:this.id}},r.prototype.struct=function(){var e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e},r.prototype.set_subtype=function(e){this._subtype=e},r.prototype[Symbol.iterator]=function(){return o.__generator(this,(function(e){switch(e.label){case 0:return[5,o.__values(_.values(this.properties))];case 1:return e.sent(),[2]}}))},r.prototype.syncable_properties=function(){var e,r,t,n,a,i;return o.__generator(this,(function(l){switch(l.label){case 0:l.trys.push([0,5,6,7]),e=o.__values(this),r=e.next(),l.label=1;case 1:return r.done?[3,4]:(t=r.value).syncable?[4,t]:[3,3];case 2:l.sent(),l.label=3;case 3:return r=e.next(),[3,1];case 4:return[3,7];case 5:return n=l.sent(),a={error:n},[3,7];case 6:try{r&&!r.done&&(i=e.return)&&i.call(e)}finally{if(a)throw a.error}return[7];case 7:return[2]}}))},r.prototype.serializable_attributes=function(){var e,r,t={};try{for(var n=o.__values(this.syncable_properties()),a=n.next();!a.done;a=n.next()){var i=a.value;t[i.attr]=i.get_value()}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return t},r._json_record_references=function(e,t,n,a){var i,s,u,c,v=a.recursive;if(l.is_ref(t)){var y=e.get_model_by_id(t.id);null==y||n.has(y)||r._value_record_references(y,n,{recursive:v})}else if(f.isArray(t))try{for(var p=o.__values(t),d=p.next();!d.done;d=p.next()){var h=d.value;r._json_record_references(e,h,n,{recursive:v})}}catch(e){i={error:e}}finally{try{d&&!d.done&&(s=p.return)&&s.call(p)}finally{if(i)throw i.error}}else if(f.isPlainObject(t))try{for(var g=o.__values(_.values(t)),x=g.next();!x.done;x=g.next()){h=x.value;r._json_record_references(e,h,n,{recursive:v})}}catch(e){u={error:e}}finally{try{x&&!x.done&&(c=g.return)&&c.call(g)}finally{if(u)throw u.error}}},r._value_record_references=function(e,t,n){var a,i,l,s,u,c,v=n.recursive;if(e instanceof r){if(!t.has(e)&&(t.add(e),v))try{for(var y=o.__values(e.syncable_properties()),p=y.next();!p.done;p=y.next()){var d=p.value.get_value();r._value_record_references(d,t,{recursive:v})}}catch(e){a={error:e}}finally{try{p&&!p.done&&(i=y.return)&&i.call(y)}finally{if(a)throw a.error}}}else if(f.isArray(e))try{for(var h=o.__values(e),g=h.next();!g.done;g=h.next()){var x=g.value;r._value_record_references(x,t,{recursive:v})}}catch(e){l={error:e}}finally{try{g&&!g.done&&(s=h.return)&&s.call(h)}finally{if(l)throw l.error}}else if(f.isPlainObject(e))try{for(var w=o.__values(_.values(e)),b=w.next();!b.done;b=w.next()){x=b.value;r._value_record_references(x,t,{recursive:v})}}catch(e){u={error:e}}finally{try{b&&!b.done&&(c=w.return)&&c.call(w)}finally{if(u)throw u.error}}},r.prototype.references=function(){var e=new Set;return r._value_record_references(this,e,{recursive:!0}),e},r.prototype._doc_attached=function(){},r.prototype._doc_detached=function(){},r.prototype.attach_document=function(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()},r.prototype.detach_document=function(){this._doc_detached(),this.document=null},r.prototype._needs_invalidate=function(e,t){var n,a,i,l,s=new Set;r._value_record_references(t,s,{recursive:!1});var u=new Set;r._value_record_references(e,u,{recursive:!1});try{for(var c=o.__values(s),_=c.next();!_.done;_=c.next()){var f=_.value;if(!u.has(f))return!0}}catch(e){n={error:e}}finally{try{_&&!_.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}try{for(var v=o.__values(u),y=v.next();!y.done;y=v.next()){var p=y.value;if(!s.has(p))return!0}}catch(e){i={error:e}}finally{try{y&&!y.done&&(l=v.return)&&l.call(v)}finally{if(i)throw i.error}}return!1},r.prototype._push_changes=function(e,r){var t,n;if(void 0===r&&(r={}),this.is_syncable){var a=this.document;if(null!=a){var i=r.setter_id,l=[];try{for(var s=o.__values(e),u=s.next();!u.done;u=s.next()){var c=o.__read(u.value,3),_=c[0],f=c[1],v=c[2];_.syncable&&l.push(new p.ModelChangedEvent(a,this,_.attr,f,v,i))}}catch(e){t={error:e}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(t)throw t.error}}if(0!=l.length){var y=void 0;1==l.length?y=o.__read(l,1)[0]:y=new p.DocumentEventBatch(a,l,i),a._trigger_on_change(y)}}}},r.prototype.on_change=function(e,r){var t,n;try{for(var a=o.__values(f.isArray(e)?e:[e]),i=a.next();!i.done;i=a.next()){var l=i.value;this.connect(l.change,r)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}},r}(i.Signalable());t.HasProps=w,w.init_HasProps()},
function _(n,e,t,r,l){r();var i=n(1),a=n(131),o=n(124),u=function(){function n(n,e){this.sender=n,this.name=e}return n.prototype.connect=function(n,e){void 0===e&&(e=null),s.has(this.sender)||s.set(this.sender,[]);var t=s.get(this.sender);if(null!=v(t,this,n,e))return!1;var r=null!=e?e:n;f.has(r)||f.set(r,[]);var l=f.get(r),i={signal:this,slot:n,context:e};return t.push(i),l.push(i),!0},n.prototype.disconnect=function(n,e){void 0===e&&(e=null);var t=s.get(this.sender);if(null==t||0===t.length)return!1;var r=v(t,this,n,e);if(null==r)return!1;var l=null!=e?e:n,i=f.get(l);return r.signal=null,h(t),h(i),!0},n.prototype.emit=function(n){var e,t,r,l=null!==(r=s.get(this.sender))&&void 0!==r?r:[];try{for(var a=i.__values(l),o=a.next();!o.done;o=a.next()){var u=o.value,c=u.signal,f=u.slot,v=u.context;c===this&&f.call(v,n,this.sender)}}catch(n){e={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}},n}();t.Signal=u,u.__name__="Signal";var c=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(e,n),e.prototype.emit=function(){n.prototype.emit.call(this,void 0)},e}(u);t.Signal0=c,c.__name__="Signal0",function(n){function e(n,e){var t,r,l=s.get(n);if(null!=l&&0!==l.length){var a=f.get(e);if(null!=a&&0!==a.length){try{for(var o=i.__values(a),u=o.next();!u.done;u=o.next()){var c=u.value;if(null==c.signal)return;c.signal.sender===n&&(c.signal=null)}}catch(n){t={error:n}}finally{try{u&&!u.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}h(l),h(a)}}}function t(n){var e,t,r,l=s.get(n);if(null!=l&&0!==l.length){try{for(var a=i.__values(l),o=a.next();!o.done;o=a.next()){var u=o.value;if(null==u.signal)return;var c=null!==(r=u.context)&&void 0!==r?r:u.slot;u.signal=null,h(f.get(c))}}catch(n){e={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}h(l)}}function r(n,e,t){var r,l,a=f.get(n);if(null!=a&&0!==a.length){try{for(var o=i.__values(a),u=o.next();!u.done;u=o.next()){var c=u.value;if(null==c.signal)return;if(null==e||c.slot==e){var v=c.signal.sender;null!=t&&t.has(v)||(c.signal=null,h(s.get(v)))}}}catch(n){r={error:n}}finally{try{u&&!u.done&&(l=o.return)&&l.call(o)}finally{if(r)throw r.error}}h(a)}}function l(n){var e,t,r,l,a=s.get(n);if(null!=a&&0!==a.length){try{for(var o=i.__values(a),u=o.next();!u.done;u=o.next()){u.value.signal=null}}catch(n){e={error:n}}finally{try{u&&!u.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}h(a)}var c=f.get(n);if(null!=c&&0!==c.length){try{for(var v=i.__values(c),d=v.next();!d.done;d=v.next()){d.value.signal=null}}catch(n){r={error:n}}finally{try{d&&!d.done&&(l=v.return)&&l.call(v)}finally{if(r)throw r.error}}h(c)}}n.disconnect_between=e,n.disconnect_sender=t,n.disconnect_receiver=r,n.disconnect_all=l,n.disconnectBetween=e,n.disconnectSender=t,n.disconnectReceiver=r,n.disconnectAll=l}(u||(t.Signal=u={})),t.Signalable=function(){return function(){function n(){}return n.prototype.connect=function(n,e){return n.connect(e,this)},n.prototype.disconnect=function(n,e){return n.disconnect(e,this)},n}()};var s=new WeakMap,f=new WeakMap;function v(n,e,t,r){return o.find(n,(function(n){return n.signal===e&&n.slot===t&&n.context===r}))}var d=new Set;function h(n){var e=this;0===d.size&&i.__awaiter(e,void 0,void 0,(function(){return i.__generator(this,(function(n){switch(n.label){case 0:return[4,a.defer()];case 1:return n.sent(),function(){var n,e;try{for(var t=i.__values(d),r=t.next();!r.done;r=t.next()){var l=r.value;o.remove_by(l,(function(n){return null==n.signal}))}}catch(e){n={error:e}}finally{try{r&&!r.done&&(e=t.return)&&e.call(t)}finally{if(n)throw n.error}}d.clear()}(),[2]}}))})),d.add(n)}},
function _(e,n,t,a,r){a();var o=new MessageChannel,s=new Map;o.port1.onmessage=function(e){var n=e.data,t=s.get(n);if(null!=t)try{t()}finally{s.delete(n)}};var f=1;t.defer=function(){return new Promise((function(e){var n=f++;s.set(n,e),o.port2.postMessage(n)}))}},
function _(n,i,r,e,t){e();var f=n(123),u=n(128);r.is_ref=function(n){if(f.isPlainObject(n)){var i=u.keys(n);return 1==i.length&&"id"==i[0]}return!1}},
function _(e,n,t,r,i){r(),t.YCoordinateSeqSeqSeqSpec=t.XCoordinateSeqSeqSeqSpec=t.YCoordinateSeqSpec=t.XCoordinateSeqSpec=t.YCoordinateSpec=t.XCoordinateSpec=t.CoordinateSeqSeqSeqSpec=t.CoordinateSeqSpec=t.CoordinateSpec=t.BaseCoordinateSpec=t.NumberUnitsSpec=t.UnitsSpec=t.DataSpec=t.VectorSpec=t.TextBaselineScalar=t.TextAlignScalar=t.FontStyleScalar=t.FontSizeScalar=t.FontScalar=t.LineDashScalar=t.LineCapScalar=t.LineJoinScalar=t.ArrayScalar=t.NullStringScalar=t.StringScalar=t.NumberScalar=t.ColorScalar=t.AnyScalar=t.ScalarSpec=t.VerticalAlign=t.UpdateMode=t.TooltipAttachment=t.TickLabelOrientation=t.TextureRepetition=t.TextBaseline=t.TextAlign=t.TapBehavior=t.StepMode=t.StartEnd=t.SpatialUnits=t.Sort=t.SizingMode=t.Side=t.RoundingFunction=t.ResetPolicy=t.RenderMode=t.RenderLevel=t.RadiusDimension=t.PointPolicy=t.Place=void 0,t.TextBaselineSpec=t.TextAlignSpec=t.FontStyleSpec=t.FontSizeSpec=t.FontSpec=t.LineDashSpec=t.LineCapSpec=t.LineJoinSpec=t.MarkerSpec=t.ArraySpec=t.NullStringSpec=t.StringSpec=t.AnySpec=t.NDArraySpec=t.ColorSpec=t.ScreenSizeSpec=t.NumberSpec=t.IntSpec=t.BooleanSpec=t.NullDistanceSpec=t.DistanceSpec=t.AngleSpec=void 0;var a=e(1),o=e(130),u=e(134),l=a.__importStar(e(135)),c=e(139),_=e(124),p=e(127),s=e(125),f=e(137),d=e(142),y=e(123),h=e(143),S=e(144),v=e(148);function m(e){try{return JSON.stringify(e)}catch(n){return e.toString()}}function g(e){return y.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}i("Uniform",v.Uniform),i("UniformScalar",v.UniformScalar),i("UniformVector",v.UniformVector),t.isSpec=g;var x=function(){function e(e,n,t,r,i,a){var u,l;if(void 0===a&&(a={}),this.obj=e,this.attr=n,this.kind=t,this.default_value=r,this._dirty=!1,this.change=new o.Signal0(this.obj,"change"),this.internal=null!==(u=a.internal)&&void 0!==u&&u,this.convert=a.convert,this.on_update=a.on_update,void 0!==i)l=i,this._dirty=!0;else{var c=this._default_override();if(void 0!==c)l=c;else{if(void 0===r)return void(this.spec={value:null});l=r(e)}}this._update(l)}return Object.defineProperty(e.prototype,"is_value",{get:function(){return void 0!==this.spec.value},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"syncable",{get:function(){return!this.internal},enumerable:!1,configurable:!0}),e.prototype.get_value=function(){return this.spec.value},e.prototype.set_value=function(e){this._update(e),this._dirty=!0},e.prototype._default_override=function(){},Object.defineProperty(e.prototype,"dirty",{get:function(){return this._dirty},enumerable:!1,configurable:!0}),e.prototype._update=function(e){var n;if(this.validate(e),null!=this.convert){var t=this.convert(e);void 0!==t&&(e=t)}this.spec={value:e},null===(n=this.on_update)||void 0===n||n.call(this,e,this.obj)},e.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+m(this.spec)+")"},e.prototype.normalize=function(e){return e},e.prototype.validate=function(e){if(!this.valid(e))throw new Error(this.obj+"."+this.attr+" given invalid value: "+m(e))},e.prototype.valid=function(e){return this.kind.valid(e)},e.prototype._value=function(e){if(void 0===e&&(e=!0),!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");var n=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(n=this.spec.transform.compute(n)),n},e}();t.Property=x,x.__name__="Property";var A=function(e){this.attr=e};t.PropertyAlias=A,A.__name__="PropertyAlias",t.Alias=function(e){return new A(e)};var b=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(x);t.PrimitiveProperty=b,b.__name__="PrimitiveProperty";var C=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(x);t.Any=C,C.__name__="Any";var P=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isArray(e)||y.isTypedArray(e)},n}(x);t.Array=P,P.__name__="Array";var T=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isBoolean(e)},n}(x);t.Boolean=T,T.__name__="Boolean";var L=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return f.is_Color(e)},n}(x);t.Color=L,L.__name__="Color";var w=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(x);t.Instance=w,w.__name__="Instance";var q=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isNumber(e)},n}(x);t.Number=q,q.__name__="Number";var N=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isNumber(e)&&(0|e)==e},n}(q);t.Int=N,N.__name__="Int";var z=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(q);t.Angle=z,z.__name__="Angle";var B=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isNumber(e)&&0<=e&&e<=1},n}(q);t.Percent=B,B.__name__="Percent";var F=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isString(e)},n}(x);t.String=F,F.__name__="String";var D=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return null===e||y.isString(e)},n}(x);t.NullString=D,D.__name__="NullString";var U=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(F);t.FontSize=U,U.__name__="FontSize";var M=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(F);t.Font=M,M.__name__="Font";var O=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isString(e)&&_.includes(this.enum_values,e)},n}(x);function R(e){return function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return a.__extends(t,n),Object.defineProperty(t.prototype,"enum_values",{get:function(){return a.__spreadArray([],a.__read(e))},enumerable:!1,configurable:!0}),t}(O)}t.EnumProperty=O,O.__name__="EnumProperty",t.Enum=R;var k=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),Object.defineProperty(n.prototype,"enum_values",{get:function(){return a.__spreadArray([],a.__read(l.Direction))},enumerable:!1,configurable:!0}),n.prototype.normalize=function(e){for(var n=new Uint8Array(e.length),t=0;t<e.length;t++)switch(e[t]){case"clock":n[t]=0;break;case"anticlock":n[t]=1}return n},n}(O);t.Direction=k,k.__name__="Direction",t.Anchor=R(l.Anchor),t.AngleUnits=R(l.AngleUnits),t.BoxOrigin=R(l.BoxOrigin),t.ButtonType=R(l.ButtonType),t.CalendarPosition=R(l.CalendarPosition),t.Dimension=R(l.Dimension),t.Dimensions=R(l.Dimensions),t.Distribution=R(l.Distribution),t.FontStyle=R(l.FontStyle),t.HatchPatternType=R(l.HatchPatternType),t.HTTPMethod=R(l.HTTPMethod),t.HexTileOrientation=R(l.HexTileOrientation),t.HoverMode=R(l.HoverMode),t.LatLon=R(l.LatLon),t.LegendClickPolicy=R(l.LegendClickPolicy),t.LegendLocation=R(l.LegendLocation),t.LineCap=R(l.LineCap),t.LineJoin=R(l.LineJoin),t.LinePolicy=R(l.LinePolicy),t.Location=R(l.Location),t.Logo=R(l.Logo),t.MarkerType=R(l.MarkerType),t.MutedPolicy=R(l.MutedPolicy),t.Orientation=R(l.Orientation),t.OutputBackend=R(l.OutputBackend),t.PaddingUnits=R(l.PaddingUnits),t.Place=R(l.Place),t.PointPolicy=R(l.PointPolicy),t.RadiusDimension=R(l.RadiusDimension),t.RenderLevel=R(l.RenderLevel),t.RenderMode=R(l.RenderMode),t.ResetPolicy=R(l.ResetPolicy),t.RoundingFunction=R(l.RoundingFunction),t.Side=R(l.Side),t.SizingMode=R(l.SizingMode),t.Sort=R(l.Sort),t.SpatialUnits=R(l.SpatialUnits),t.StartEnd=R(l.StartEnd),t.StepMode=R(l.StepMode),t.TapBehavior=R(l.TapBehavior),t.TextAlign=R(l.TextAlign),t.TextBaseline=R(l.TextBaseline),t.TextureRepetition=R(l.TextureRepetition),t.TickLabelOrientation=R(l.TickLabelOrientation),t.TooltipAttachment=R(l.TooltipAttachment),t.UpdateMode=R(l.UpdateMode),t.VerticalAlign=R(l.VerticalAlign);var j=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.get_value=function(){var e=this.spec,n=e.value,t=e.expr,r=e.transform;return null!=t||null!=r?this.spec:n},n.prototype._update=function(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)},n.prototype.materialize=function(e){return e},n.prototype.scalar=function(e,n){return new v.UniformScalar(e,n)},n.prototype.uniform=function(e){var n,t=this.spec,r=t.expr,i=t.value,a=t.transform,o=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=r){var u=r.compute(e);return null!=a&&(u=a.compute(u)),u=this.materialize(u),this.scalar(u,o)}u=i;return null!=a&&(u=a.compute(u)),u=this.materialize(u),this.scalar(u,o)},n}(x);t.ScalarSpec=j,j.__name__="ScalarSpec";var E=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.AnyScalar=E,E.__name__="AnyScalar";var V=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.ColorScalar=V,V.__name__="ColorScalar";var I=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.NumberScalar=I,I.__name__="NumberScalar";var J=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.StringScalar=J,J.__name__="StringScalar";var X=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.NullStringScalar=X,X.__name__="NullStringScalar";var Y=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.ArrayScalar=Y,Y.__name__="ArrayScalar";var H=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.LineJoinScalar=H,H.__name__="LineJoinScalar";var G=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.LineCapScalar=G,G.__name__="LineCapScalar";var K=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.LineDashScalar=K,K.__name__="LineDashScalar";var Q=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(j);t.FontScalar=Q,Q.__name__="FontScalar";var W=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.FontSizeScalar=W,W.__name__="FontSizeScalar";var Z=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.FontStyleScalar=Z,Z.__name__="FontStyleScalar";var $=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.TextAlignScalar=$,$.__name__="TextAlignScalar";var ee=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(j);t.TextBaselineScalar=ee,ee.__name__="TextBaselineScalar";var ne=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.get_value=function(){return null===this.spec.value?null:this.spec},n.prototype._update=function(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)},n.prototype.materialize=function(e){return e},n.prototype.v_materialize=function(e){return e},n.prototype.scalar=function(e,n){return new v.UniformScalar(e,n)},n.prototype.vector=function(e){return new v.UniformVector(e)},n.prototype.uniform=function(e){var n,t=this.spec,r=t.field,i=t.expr,a=t.value,o=t.transform,l=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=r)return null!=(c=e.get_column(r))?(null!=o&&(c=o.v_compute(c)),c=this.v_materialize(c),this.vector(c)):(u.logger.warn("attempted to retrieve property array for nonexistent field '"+r+"'"),this.scalar(null,l));if(null!=i){var c=i.v_compute(e);return null!=o&&(c=o.v_compute(c)),c=this.v_materialize(c),this.vector(c)}var _=a;return null!=o&&(_=o.compute(_)),_=this.materialize(_),this.scalar(_,l)},n.prototype.array=function(e){var n,t,r=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=this.spec.field){var i=e.get_column(this.spec.field);if(null!=i)t=this.normalize(i);else{u.logger.warn("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'");var a=new Float64Array(r);a.fill(NaN),t=a}}else if(null!=this.spec.expr)t=this.normalize(this.spec.expr.v_compute(e));else{var o=this._value(!1);if(y.isNumber(o)){var l=new Float64Array(r);l.fill(o),t=l}else t=_.repeat(o,r)}return null!=this.spec.transform&&(t=this.spec.transform.v_compute(t)),t},n}(x);t.VectorSpec=ne,ne.__name__="VectorSpec";var te=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(ne);t.DataSpec=te,te.__name__="DataSpec";var re=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype._update=function(n){e.prototype._update.call(this,n);var t=this.spec.units;if(null!=t&&!_.includes(this.valid_units,t))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+t)},Object.defineProperty(n.prototype,"units",{get:function(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:this.default_units},set:function(e){e!=this.default_units?this.spec.units=e:delete this.spec.units},enumerable:!1,configurable:!0}),n}(ne);t.UnitsSpec=re,re.__name__="UnitsSpec";var ie=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.array=function(n){return new Float64Array(e.prototype.array.call(this,n))},n}(re);t.NumberUnitsSpec=ie,ie.__name__="NumberUnitsSpec";var ae=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.BaseCoordinateSpec=ae,ae.__name__="BaseCoordinateSpec";var oe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(ae);t.CoordinateSpec=oe,oe.__name__="CoordinateSpec";var ue=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(ae);t.CoordinateSeqSpec=ue,ue.__name__="CoordinateSeqSpec";var le=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(ae);t.CoordinateSeqSeqSeqSpec=le,le.__name__="CoordinateSeqSeqSeqSpec";var ce=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="x",n}return a.__extends(n,e),n}(oe);t.XCoordinateSpec=ce,ce.__name__="XCoordinateSpec";var _e=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="y",n}return a.__extends(n,e),n}(oe);t.YCoordinateSpec=_e,_e.__name__="YCoordinateSpec";var pe=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="x",n}return a.__extends(n,e),n}(ue);t.XCoordinateSeqSpec=pe,pe.__name__="XCoordinateSeqSpec";var se=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="y",n}return a.__extends(n,e),n}(ue);t.YCoordinateSeqSpec=se,se.__name__="YCoordinateSeqSpec";var fe=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="x",n}return a.__extends(n,e),n}(le);t.XCoordinateSeqSeqSeqSpec=fe,fe.__name__="XCoordinateSeqSeqSeqSpec";var de=function(e){function n(){var n=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return n.dimension="y",n}return a.__extends(n,e),n}(le);t.YCoordinateSeqSeqSeqSpec=de,de.__name__="YCoordinateSeqSeqSeqSpec";var ye=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),Object.defineProperty(n.prototype,"default_units",{get:function(){return"rad"},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return a.__spreadArray([],a.__read(l.AngleUnits))},enumerable:!1,configurable:!0}),n.prototype.materialize=function(e){return e*-s.to_radians_coeff(this.units)},n.prototype.v_materialize=function(e){var n=-s.to_radians_coeff(this.units),t=new Float32Array(e.length);return p.mul(e,n,t),t},n.prototype.array=function(e){throw new Error("not supported")},n}(ie);t.AngleSpec=ye,ye.__name__="AngleSpec";var he=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),Object.defineProperty(n.prototype,"default_units",{get:function(){return"data"},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return a.__spreadArray([],a.__read(l.SpatialUnits))},enumerable:!1,configurable:!0}),n}(ie);t.DistanceSpec=he,he.__name__="DistanceSpec";var Se=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.materialize=function(e){return null!=e?e:NaN},n}(he);t.NullDistanceSpec=Se,Se.__name__="NullDistanceSpec";var ve=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.v_materialize=function(e){return new Uint8Array(e)},n.prototype.array=function(n){return new Uint8Array(e.prototype.array.call(this,n))},n}(te);t.BooleanSpec=ve,ve.__name__="BooleanSpec";var me=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.v_materialize=function(e){return y.isTypedArray(e)?e:new Int32Array(e)},n.prototype.array=function(n){return new Int32Array(e.prototype.array.call(this,n))},n}(te);t.IntSpec=me,me.__name__="IntSpec";var ge=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.v_materialize=function(e){return y.isTypedArray(e)?e:new Float64Array(e)},n.prototype.array=function(n){return new Float64Array(e.prototype.array.call(this,n))},n}(te);t.NumberSpec=ge,ge.__name__="NumberSpec";var xe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.valid=function(e){return y.isNumber(e)&&e>=0},n}(ge);t.ScreenSizeSpec=xe,xe.__name__="ScreenSizeSpec";var Ae=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype.materialize=function(e){return f.encode_rgba(f.color2rgba(e))},n.prototype.v_materialize=function(e){var n,t,r,i;if(!S.is_NDArray(e)){v=e.length,m=new c.RGBAArray(4*v),g=0;try{for(var o=a.__values(e),u=o.next();!u.done;u=o.next()){var l=u.value,_=a.__read(f.color2rgba(l),4),p=_[0],s=_[1],y=_[2],h=_[3];m[g++]=p,m[g++]=s,m[g++]=y,m[g++]=h}}catch(e){r={error:e}}finally{try{u&&!u.done&&(i=o.return)&&i.call(o)}finally{if(r)throw r.error}}return new c.ColorArray(m.buffer)}if("uint32"==e.dtype&&1==e.dimension)return d.to_big_endian(e);if("uint8"==e.dtype&&1==e.dimension){var v=a.__read(e.shape,1)[0],m=new c.RGBAArray(4*v),g=0;try{for(var x=a.__values(e),A=x.next();!A.done;A=x.next()){var b=A.value;m[g++]=b,m[g++]=b,m[g++]=b,m[g++]=255}}catch(e){n={error:e}}finally{try{A&&!A.done&&(t=x.return)&&t.call(x)}finally{if(n)throw n.error}}return new c.ColorArray(m.buffer)}if("uint8"==e.dtype&&2==e.dimension){var C=a.__read(e.shape,2),v=C[0];if(4==(T=C[1]))return new c.ColorArray(e.buffer);if(3==T){for(var m=new c.RGBAArray(4*v),P=0,g=0;P<T*v;)m[g++]=e[P++],m[g++]=e[P++],m[g++]=e[P++],m[g++]=255;return new c.ColorArray(m.buffer)}}else if(("float32"==e.dtype||"float64"==e.dtype)&&2==e.dimension){var T,L=a.__read(e.shape,2);v=L[0];if(3==(T=L[1])||4==T){for(m=new c.RGBAArray(4*v),P=0,g=0;P<T*v;)m[g++]=255*e[P++],m[g++]=255*e[P++],m[g++]=255*e[P++],m[g++]=255*(3==T?1:e[P++]);return new c.ColorArray(m.buffer)}}throw new Error("invalid color array")},n.prototype.vector=function(e){return new v.ColorUniformVector(e)},n}(te);t.ColorSpec=Ae,Ae.__name__="ColorSpec";var be=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.NDArraySpec=be,be.__name__="NDArraySpec";var Ce=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.AnySpec=Ce,Ce.__name__="AnySpec";var Pe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.StringSpec=Pe,Pe.__name__="StringSpec";var Te=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.NullStringSpec=Te,Te.__name__="NullStringSpec";var Le=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.ArraySpec=Le,Le.__name__="ArraySpec";var we=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.MarkerSpec=we,we.__name__="MarkerSpec";var qe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.LineJoinSpec=qe,qe.__name__="LineJoinSpec";var Ne=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.LineCapSpec=Ne,Ne.__name__="LineCapSpec";var ze=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.LineDashSpec=ze,ze.__name__="LineDashSpec";var Be=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(te);t.FontSpec=Be,Be.__name__="FontSpec";var Fe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.FontSizeSpec=Fe,Fe.__name__="FontSizeSpec";var De=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.FontStyleSpec=De,De.__name__="FontStyleSpec";var Ue=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.TextAlignSpec=Ue,Ue.__name__="TextAlignSpec";var Me=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),n}(te);t.TextBaselineSpec=Me,Me.__name__="TextBaselineSpec"},
function _(e,l,o,n,t){n();var r=e(1),g=e(123),i=e(128),v={},a=function(e,l){this.name=e,this.level=l};o.LogLevel=a,a.__name__="LogLevel";var s=function(){function e(l,o){void 0===o&&(o=e.INFO),this._name=l,this.set_level(o)}return Object.defineProperty(e,"levels",{get:function(){return Object.keys(e.log_levels)},enumerable:!1,configurable:!0}),e.get=function(l,o){if(void 0===o&&(o=e.INFO),l.length>0){var n=v[l];return null==n&&(v[l]=n=new e(l,o)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(e.prototype,"level",{get:function(){return this.get_level()},enumerable:!1,configurable:!0}),e.prototype.get_level=function(){return this._log_level},e.prototype.set_level=function(l){var o,n;if(l instanceof a)this._log_level=l;else{if(!g.isString(l)||null==e.log_levels[l])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=e.log_levels[l]}var t="["+this._name+"]";try{for(var v=r.__values(i.entries(e.log_levels)),s=v.next();!s.done;s=v.next()){var c=r.__read(s.value,2),_=c[0];c[1].level<this._log_level.level||this._log_level.level===e.OFF.level?this[_]=function(){}:this[_]=f(_,t)}}catch(e){o={error:e}}finally{try{s&&!s.done&&(n=v.return)&&n.call(v)}finally{if(o)throw o.error}}},e.prototype.trace=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.debug=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.info=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.warn=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.error=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e}();function f(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){var l=o.logger.level;return g.isString(e)&&null==s.log_levels[e]?(console.log("[bokeh] unrecognized logging level '"+e+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+s.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+(g.isString(e)?e:e.level)+"'"),o.logger.set_level(e)),l}o.Logger=s,s.__name__="Logger",s.TRACE=new a("trace",0),s.DEBUG=new a("debug",1),s.INFO=new a("info",2),s.WARN=new a("warn",6),s.ERROR=new a("error",7),s.FATAL=new a("fatal",8),s.OFF=new a("off",9),s.log_levels={trace:s.TRACE,debug:s.DEBUG,info:s.INFO,warn:s.WARN,error:s.ERROR,fatal:s.FATAL,off:s.OFF},o.logger=s.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){var o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o(),t.VerticalAlign=void 0;var a=e(136);t.Align=a.Enum("start","center","end"),t.Anchor=a.Enum("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),t.AngleUnits=a.Enum("deg","rad","grad","turn"),t.BoxOrigin=a.Enum("corner","center"),t.ButtonType=a.Enum("default","primary","success","warning","danger","light"),t.CalendarPosition=a.Enum("auto","above","below"),t.Dimension=a.Enum("width","height"),t.Dimensions=a.Enum("width","height","both"),t.Direction=a.Enum("clock","anticlock"),t.Distribution=a.Enum("uniform","normal"),t.FontStyle=a.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=a.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=a.Enum("POST","GET"),t.HexTileOrientation=a.Enum("pointytop","flattop"),t.HoverMode=a.Enum("mouse","hline","vline"),t.LatLon=a.Enum("lat","lon"),t.LegendClickPolicy=a.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=a.Enum("butt","round","square"),t.LineJoin=a.Enum("miter","round","bevel"),t.LineDash=a.Enum("solid","dashed","dotted","dotdash","dashdot"),t.LinePolicy=a.Enum("prev","next","nearest","interp","none"),t.Location=a.Enum("above","below","left","right"),t.Logo=a.Enum("normal","grey"),t.MarkerType=a.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=a.Enum("show","ignore"),t.Orientation=a.Enum("vertical","horizontal"),t.OutputBackend=a.Enum("canvas","svg","webgl"),t.PaddingUnits=a.Enum("percent","absolute"),t.Place=a.Enum("above","below","left","right","center"),t.PointPolicy=a.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=a.Enum("x","y","max","min"),t.RenderLevel=a.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=a.Enum("canvas","css"),t.ResetPolicy=a.Enum("standard","event_only"),t.RoundingFunction=a.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=a.Enum("replace","append","intersect","subtract"),t.Side=a.Enum("above","below","left","right"),t.SizingMode=a.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=a.Enum("ascending","descending"),t.SpatialUnits=a.Enum("screen","data"),t.StartEnd=a.Enum("start","end"),t.StepMode=a.Enum("after","before","center"),t.TapBehavior=a.Enum("select","inspect"),t.TextAlign=a.Enum("left","right","center"),t.TextBaseline=a.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=a.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=a.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=a.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=a.Enum("replace","append"),t.VerticalAlign=a.Enum("top","middle","bottom")},
function _(n,t,r,e,i){e();var u=n(1),o=u.__importStar(n(123)),a=n(137),l=n(128),_=window.Map,s=Object.prototype.hasOwnProperty,c=function(){};r.Kind=c,c.__name__="Kind",function(n){var t=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(c);t.__name__="Any",n.Any=t;var r=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(c);r.__name__="Unknown",n.Unknown=r;var e=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isBoolean(n)},t}(c);e.__name__="Boolean",n.Boolean=e;var i=function(n){function t(t){var r=n.call(this)||this;return r.obj_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(c);i.__name__="Ref",n.Ref=i;var f=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return!0},t}(c);f.__name__="AnyRef",n.AnyRef=f;var p=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isNumber(n)},t}(c);p.__name__="Number",n.Number=p;var y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&o.isInteger(t)},t}(p);y.__name__="Int",n.Int=y;var v=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&0<=t&&t<=1},t}(p);v.__name__="Percent",n.Percent=v;var d=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return this.types.some((function(t){return t.valid(n)}))},t}(c);d.__name__="Or",n.Or=d;var h=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isArray(n))return!1;for(var t=0;t<this.types.length;t++){var r=this.types[t],e=n[t];if(!r.valid(e))return!1}return!0},t}(c);h.__name__="Tuple",n.Tuple=h;var m=function(n){function t(t){var r=n.call(this)||this;return r.struct_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;var t=this.struct_type;if(l.size(t)!=l.size(n))return!1;for(var r in t)if(s.call(t,r)){if(!s.call(n,r))return!1;var e=t[r],i=n[r];if(!e.valid(i))return!1}return!0},t}(c);m.__name__="Struct",n.Struct=m;var w=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isArray(n)||o.isTypedArray(n)},t}(c);w.__name__="Arrayable",n.Arrayable=w;var K=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){var t=this;return o.isArray(n)&&n.every((function(n){return t.item_type.valid(n)}))},t}(c);K.__name__="Array",n.Array=K;var b=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return null===n},t}(c);b.__name__="Null",n.Null=b;var x=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return null===n||this.base_type.valid(n)},t}(c);x.__name__="Nullable",n.Nullable=x;var A=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){return void 0===n||this.base_type.valid(n)},t}(c);A.__name__="Opt",n.Opt=A;var S=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isString(n)},t}(c);S.__name__="String",n.String=S;var g=function(n){function t(t){var r=n.call(this)||this;return r.values=new Set(t),r}return u.__extends(t,n),t.prototype.valid=function(n){return this.values.has(n)},t.prototype[Symbol.iterator]=function(){return u.__generator(this,(function(n){switch(n.label){case 0:return[5,u.__values(this.values)];case 1:return n.sent(),[2]}}))},t}(c);g.__name__="Enum",n.Enum=g;var N=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return u.__extends(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;for(var t in n)if(s.call(n,t)){var r=n[t];if(!this.item_type.valid(r))return!1}return!0},t}(c);N.__name__="Dict",n.Dict=N;var O=function(n){function t(t,r){var e=n.call(this)||this;return e.key_type=t,e.item_type=r,e}return u.__extends(t,n),t.prototype.valid=function(n){var t,r;if(!(n instanceof _))return!1;try{for(var e=u.__values(n.entries()),i=e.next();!i.done;i=e.next()){var o=u.__read(i.value,2),a=o[0],l=o[1];if(!this.key_type.valid(a)||!this.item_type.valid(l))return!1}}catch(n){t={error:n}}finally{try{i&&!i.done&&(r=e.return)&&r.call(e)}finally{if(t)throw t.error}}return!0},t}(c);O.__name__="Map",n.Map=O;var P=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return a.is_Color(n)},t}(c);P.__name__="Color",n.Color=P;var R=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return u.__extends(t,n),t.prototype.valid=function(n){return o.isFunction(n)},t}(c);R.__name__="Function",n.Function=R}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Boolean=new r.Kinds.Boolean,r.Number=new r.Kinds.Number,r.Int=new r.Kinds.Int,r.String=new r.Kinds.String,r.Null=new r.Kinds.Null;r.Nullable=function(n){return new r.Kinds.Nullable(n)};r.Opt=function(n){return new r.Kinds.Opt(n)};r.Or=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Or(n)};r.Tuple=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Tuple(n)};r.Struct=function(n){return new r.Kinds.Struct(n)},r.Arrayable=new r.Kinds.Arrayable;r.Array=function(n){return new r.Kinds.Array(n)};r.Dict=function(n){return new r.Kinds.Dict(n)};r.Map=function(n,t){return new r.Kinds.Map(n,t)};r.Enum=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Enum(n)};r.Ref=function(n){return new r.Kinds.Ref(n)};r.AnyRef=function(){return new r.Kinds.AnyRef};r.Function=function(){return new r.Kinds.Function},r.Percent=new r.Kinds.Percent,r.Alpha=r.Percent,r.Color=new r.Kinds.Color,r.Auto=r.Enum("auto"),r.FontSize=r.String,r.Font=r.String,r.Angle=r.Number},
function _(r,n,e,t,a){t();var u=r(1),s=r(138),i=r(125),l=r(123),c=Math.round;function o(r){return i.clamp(c(r),0,255)}function d(){return[0,0,0,0]}function _(r){return[r>>24&255,r>>16&255,r>>8&255,255&r]}function f(r,n){var e,t,a,s,i,c,d,f,v,h;return null==r?(d=(e=u.__read([0,0,0,0],4))[0],f=e[1],v=e[2],h=e[3]):l.isInteger(r)?(d=(t=u.__read(_(r),4))[0],f=t[1],v=t[2],h=t[3]):l.isString(r)?(d=(a=u.__read(null!==(c=N(r))&&void 0!==c?c:[0,0,0,0],4))[0],f=a[1],v=a[2],h=a[3]):(d=(s=u.__read(r,4))[0],f=s[1],v=s[2],h=o(255*(h=void 0===(i=s[3])?1:i))),255==h&&null!=n&&(h=o(255*n)),[d,f,v,h]}e.transparent=d,e.encode_rgba=function(r){var n=u.__read(r,4);return n[0]<<24|n[1]<<16|n[2]<<8|n[3]},e.decode_rgba=_,e.compose_alpha=function(r,n){return 255==(255&r)?4294967040&r|o(255*n):r},e.color2rgba=f;var v={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function h(r){return v[r>>4]+v[15&r]}e.color2css=function(r,n){var e=u.__read(f(r,n),4);return"rgba("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]/255+")"},e.color2hex=function(r,n){var e=u.__read(f(r,n),4),t=e[0],a=e[1],s=e[2],i=e[3],l="#"+h(t)+h(a)+h(s);return 255==i?l:""+l+h(i)},e.color2hexrgb=function(r){var n=u.__read(f(r),3),e=n[0],t=n[1],a=n[2];return"#"+h(e)+h(t)+h(a)};var g=/^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/,b=/^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/,m=function(){var r=document.createElement("canvas");r.width=1,r.height=1;var n=r.getContext("2d"),e=n.createLinearGradient(0,0,1,1);return function(r){n.fillStyle=e,n.fillStyle=r;var t=n.fillStyle;return t!=e?t:null}}();function N(r){var n;if(!(r=r.trim().toLowerCase()))return null;if("transparent"==r)return[0,0,0,0];if(s.is_named_color(r))return _(s.named_colors[r]);if("#"==r[0]){var e=Number("0x"+r.substr(1));if(isNaN(e))return null;switch(r.length-1){case 3:return[(i=e>>8&15)<<4|i,(l=e>>4&15)<<4|l,(c=e>>0&15)<<4|c,255];case 4:return[(i=e>>12&15)<<4|i,(l=e>>8&15)<<4|l,(c=e>>4&15)<<4|c,(f=e>>0&15)<<4|f];case 6:return[e>>16&255,e>>8&255,e>>0&255,255];case 8:return[e>>24&255,e>>16&255,e>>8&255,e>>0&255]}}else if(r.startsWith("rgb")){var t=null!==(n=r.match(g))&&void 0!==n?n:r.match(b);if(null!=t){var a=u.__read(t,5),i=a[1],l=a[2],c=a[3],d=a[4],f=void 0===d?"1":d,v=i.endsWith("%"),h=l.endsWith("%"),p=c.endsWith("%"),S=f.endsWith("%");if(!(v&&h&&p)&&(v||h||p))return null;v&&(i=i.slice(0,-1)),h&&(l=l.slice(0,-1)),p&&(c=c.slice(0,-1)),S&&(f=f.slice(0,-1));var W=Number(i),x=Number(l),y=Number(c),w=Number(f);return isNaN(W+x+y+w)?null:(v&&(W=W/100*255),h&&(x=x/100*255),p&&(y=y/100*255),w=255*(S?w/100:w),[W=o(W),x=o(x),y=o(y),w=o(w)])}}else{var C=m(r);if(null!=C)return N(C)}return null}e.css4_parse=N,e.is_Color=function(r){return!!l.isInteger(r)||(!(!l.isString(r)||null==N(r))||!(!l.isArray(r)||3!=r.length&&4!=r.length))},e.is_dark=function(r){var n=u.__read(r,3);return 1-(.299*n[0]+.587*n[1]+.114*n[2])/255>=.6}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,a,o){a();var e=r(1);n.GeneratorFunction=Object.getPrototypeOf((function(){return e.__generator(this,(function(r){return[2]}))})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:new Float32Array(r)},o("Indices",r(140).BitSet)},
function _(r,t,e,n,i){n();var s,a=r(1),o=r(141),c=r(126),u=function(){function r(r,t){void 0===t&&(t=0),this.size=r,this[s]="BitSet",this._count=null,this._nwords=Math.ceil(r/32),0==t||1==t?(this._array=new Uint32Array(this._nwords),1==t&&this._array.fill(4294967295)):(c.assert(t.length==this._nwords,"Initializer size mismatch"),this._array=t)}return r.prototype.clone=function(){return new r(this.size,new Uint32Array(this._array))},r.prototype[(s=Symbol.toStringTag,o.equals)]=function(r,t){if(!t.eq(this.size,r.size))return!1;for(var e=this._nwords,n=this.size%e,i=0==n?e:e-1,s=0;s<i;s++)if(this._array[s]!=r._array[s])return!1;if(0==n)return!0;var a=1<<n-1,o=a-1^a;return(this._array[i]&o)==(r._array[i]&o)},r.all_set=function(t){return new r(t,1)},r.all_unset=function(t){return new r(t,0)},r.from_indices=function(t,e){var n,i,s=new r(t);try{for(var o=a.__values(e),c=o.next();!c.done;c=o.next()){var u=c.value;s.set(u)}}catch(r){n={error:r}}finally{try{c&&!c.done&&(i=o.return)&&i.call(o)}finally{if(n)throw n.error}}return s},r.from_booleans=function(t,e){for(var n=new r(t),i=Math.min(t,e.length),s=0;s<i;s++)e[s]&&n.set(s);return n},r.prototype._check_bounds=function(r){c.assert(0<=r&&r<this.size,"Out of bounds: 0 <= "+r+" < "+this.size)},r.prototype.get=function(r){this._check_bounds(r);var t=r>>>5,e=31&r;return!!(this._array[t]>>e&1)},r.prototype.set=function(r,t){void 0===t&&(t=!0),this._check_bounds(r),this._count=null;var e=r>>>5,n=31&r;t?this._array[e]|=1<<n:this._array[e]&=~(1<<n)},r.prototype.unset=function(r){this.set(r,!1)},r.prototype[Symbol.iterator]=function(){return a.__generator(this,(function(r){switch(r.label){case 0:return[5,a.__values(this.ones())];case 1:return r.sent(),[2]}}))},Object.defineProperty(r.prototype,"count",{get:function(){var r=this._count;return null==r&&(this._count=r=this._get_count()),r},enumerable:!1,configurable:!0}),r.prototype._get_count=function(){for(var r=this,t=r._array,e=r._nwords,n=r.size,i=0,s=0,a=0;a<e;a++){var o=t[a];if(0==o)s+=32;else for(var c=0;c<32&&s<n;c++,s++)o>>>c&1&&(i+=1)}return i},r.prototype.ones=function(){var r,t,e,n,i,s,o,c;return a.__generator(this,(function(a){switch(a.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,i=0,s=0,a.label=1;case 1:if(!(s<e))return[3,6];if(0==(o=t[s]))return i+=32,[3,5];c=0,a.label=2;case 2:return c<32&&i<n?o>>>c&1?[4,i]:[3,4]:[3,5];case 3:a.sent(),a.label=4;case 4:return c++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype.zeros=function(){var r,t,e,n,i,s,o,c;return a.__generator(this,(function(a){switch(a.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,i=0,s=0,a.label=1;case 1:if(!(s<e))return[3,6];if(4294967295==(o=t[s]))return i+=32,[3,5];c=0,a.label=2;case 2:return c<32&&i<n?o>>>c&1?[3,4]:[4,i]:[3,5];case 3:a.sent(),a.label=4;case 4:return c++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype._check_size=function(r){c.assert(this.size==r.size,"Size mismatch")},r.prototype.add=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]|=r._array[t]},r.prototype.intersect=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]&=r._array[t]},r.prototype.subtract=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++){var e=this._array[t],n=r._array[t];this._array[t]=(e^n)&e}},r.prototype.union=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]|=r._array[e];return t},r.prototype.intersection=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]&=r._array[e];return t},r.prototype.difference=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++){var n=this._array[e],i=r._array[e];t._array[e]=(n^i)&n}return t},r.prototype.select=function(r){var t,e;c.assert(this.size<=r.length,"Size mismatch");var n=this.count,i=new r.constructor(n),s=0;try{for(var o=a.__values(this),u=o.next();!u.done;u=o.next()){var _=u.value;i[s++]=r[_]}}catch(r){t={error:r}}finally{try{u&&!u.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}return i},r}();e.BitSet=u,u.__name__="BitSet"},
function _(r,t,e,n,o){n();var a=r(1),c=r(123),i=Object.prototype.hasOwnProperty;function s(r){return c.isObject(r)&&void 0!==r[e.equals]}e.equals=Symbol("equals"),e.wildcard=Symbol("wildcard");var u=Object.prototype.toString,l=function(){function r(){this.a_stack=[],this.b_stack=[]}return r.prototype.eq=function(r,t){var n=this;if(Object.is(r,t))return!0;if(r===e.wildcard||t===e.wildcard)return!0;if(null==r||null==t)return r===t;var o=u.call(r);if(o!=u.call(t))return!1;switch(o){case"[object Number]":return this.numbers(r,t);case"[object RegExp]":case"[object String]":return""+r==""+t;case"[object Date]":case"[object Boolean]":return+r==+t}for(var a=this.a_stack,c=this.b_stack,i=a.length;i--;)if(a[i]===r)return c[i]===t;a.push(r),c.push(t);var l=function(){if(s(r)&&s(t))return r[e.equals](t,n);switch(o){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return n.arrays(r,t);case"[object Map]":return n.maps(r,t);case"[object Set]":return n.sets(r,t);case"[object Object]":if(r.constructor==t.constructor&&(null==r.constructor||r.constructor===Object))return n.objects(r,t);case"[object Function]":if(r.constructor==t.constructor&&r.constructor===Function)return n.eq(""+r,""+t)}if(r instanceof Node)return n.nodes(r,t);throw Error("can't compare objects of type "+o)}();return a.pop(),c.pop(),l},r.prototype.numbers=function(r,t){return Object.is(r,t)},r.prototype.arrays=function(r,t){var e=r.length;if(e!=t.length)return!1;for(var n=0;n<e;n++)if(!this.eq(r[n],t[n]))return!1;return!0},r.prototype.iterables=function(r,t){for(var e=r[Symbol.iterator](),n=t[Symbol.iterator]();;){var o=e.next(),a=n.next();if(o.done&&a.done)return!0;if(o.done||a.done)return!1;if(!this.eq(o.value,a.value))return!1}},r.prototype.maps=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=a.__values(r),c=o.next();!c.done;c=o.next()){var i=a.__read(c.value,2),s=i[0],u=i[1];if(!t.has(s)||!this.eq(u,t.get(s)))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.sets=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=a.__values(r),c=o.next();!c.done;c=o.next()){var i=c.value;if(!t.has(i))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.objects=function(r,t){var e,n,o=Object.keys(r);if(o.length!=Object.keys(t).length)return!1;try{for(var c=a.__values(o),s=c.next();!s.done;s=c.next()){var u=s.value;if(!i.call(t,u)||!this.eq(r[u],t[u]))return!1}}catch(r){e={error:r}}finally{try{s&&!s.done&&(n=c.return)&&n.call(c)}finally{if(e)throw e.error}}return!0},r.prototype.nodes=function(r,t){return r.nodeType==t.nodeType&&(r.textContent==t.textContent&&!!this.iterables(r.childNodes,t.childNodes))},r}();e.Comparator=l,l.__name__="Comparator";var f=Math.abs,y=function(r){function t(t){void 0===t&&(t=1e-4);var e=r.call(this)||this;return e.tolerance=t,e}return a.__extends(t,r),t.prototype.numbers=function(t,e){return r.prototype.numbers.call(this,t,e)||f(t-e)<this.tolerance},t}(l);function b(r,t){return(new l).eq(r,t)}e.SimilarComparator=y,y.__name__="SimilarComparator",e.is_equal=b,e.is_similar=function(r,t,e){return new y(e).eq(r,t)},e.isEqual=b},
function _(n,i,e,r,t){r();var a,o=n(1);e.is_windows=navigator.appVersion.includes("Windows"),e.is_ie=(a=navigator.userAgent).includes("MSIE")||a.includes("Trident")||a.includes("Edge"),e.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),e.is_little_endian=function(){var n=new ArrayBuffer(4),i=new Uint8Array(n);new Uint32Array(n)[1]=168496141;var e=!0;return 10==i[4]&&11==i[5]&&12==i[6]&&13==i[7]&&(e=!1),e}(),e.BYTE_ORDER=e.is_little_endian?"little":"big",e.to_big_endian=function(n){var i,r;if(e.is_little_endian){var t=new Uint32Array(n.length),a=new DataView(t.buffer),l=0;try{for(var u=o.__values(n),d=u.next();!d.done;d=u.next()){var s=d.value;a.setUint32(l,s),l+=4}}catch(n){i={error:n}}finally{try{d&&!d.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}return t}return n}},
function _(e,t,n,r,i){r();var f=function(){function e(){this._dev=!1,this._wireframe=!1}return Object.defineProperty(e.prototype,"dev",{get:function(){return this._dev},set:function(e){this._dev=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"wireframe",{get:function(){return this._wireframe},set:function(e){this._wireframe=e},enumerable:!1,configurable:!0}),e}();n.Settings=f,f.__name__="Settings",n.settings=new f},
function _(n,e,r,t,a){t();var i,s,u,o,h,p,y,c,l=n(1),_=n(123),f=n(126),A=n(141),d=n(145),D=n(146),N=Symbol("__ndarray__"),v=function(n){function e(e,r){var t=new n(e);return t[i]=!0,t.dtype="uint8",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(i=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Uint8Array);r.Uint8NDArray=v,v.__name__="Uint8NDArray";var w=function(n){function e(e,r){var t=new n(e);return t[s]=!0,t.dtype="int8",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(s=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Int8Array);r.Int8NDArray=w,w.__name__="Int8NDArray";var m=function(n){function e(e,r){var t=new n(e);return t[u]=!0,t.dtype="uint16",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(u=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Uint16Array);r.Uint16NDArray=m,m.__name__="Uint16NDArray";var g=function(n){function e(e,r){var t=new n(e);return t[o]=!0,t.dtype="int16",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(o=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Int16Array);r.Int16NDArray=g,g.__name__="Int16NDArray";var q=function(n){function e(e,r){var t=new n(e);return t[h]=!0,t.dtype="uint32",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(h=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Uint32Array);r.Uint32NDArray=q,q.__name__="Uint32NDArray";var I=function(n){function e(e,r){var t=new n(e);return t[p]=!0,t.dtype="int32",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(p=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Int32Array);r.Int32NDArray=I,I.__name__="Int32NDArray";var U=function(n){function e(e,r){var t=new n(e);return t[y]=!0,t.dtype="float32",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(y=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Float32Array);r.Float32NDArray=U,U.__name__="Float32NDArray";var x=function(n){function e(e,r){var t=new n(e);return t[c]=!0,t.dtype="float64",t.shape=null!=r?r:z(e)?e.shape:[t.length],t.dimension=t.shape.length,t}return l.__extends(e,n),e.prototype[(c=N,A.equals)]=function(n,e){return e.eq(this.shape,n.shape)&&e.arrays(this,n)},e.prototype[d.serialize]=function(n){return D.encode_NDArray(this)},e}(Float64Array);function z(n){return _.isObject(n)&&void 0!==n[N]}r.Float64NDArray=x,x.__name__="Float64NDArray",r.is_NDArray=z,r.ndarray=function(n,e){void 0===e&&(e={});var r=e.dtype;null==r&&(r=n instanceof ArrayBuffer||_.isArray(n)?"float64":function(){switch(!0){case n instanceof Uint8Array:return"uint8";case n instanceof Int8Array:return"int8";case n instanceof Uint16Array:return"uint16";case n instanceof Int16Array:return"int16";case n instanceof Uint32Array:return"uint32";case n instanceof Int32Array:return"int32";case n instanceof Float32Array:return"float32";case n instanceof Float64Array:return"float64";default:f.unreachable()}}());var t=e.shape;switch(r){case"uint8":return new v(n,t);case"int8":return new w(n,t);case"uint16":return new m(n,t);case"int16":return new g(n,t);case"uint32":return new q(n,t);case"int32":return new I(n,t);case"float32":return new U(n,t);case"float64":return new x(n,t)}}},
function _(e,r,t,i,n){i();var o=e(1),s=e(126),a=e(128),f=e(123);t.serialize=Symbol("serialize");var l=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r}(Error);t.SerializationError=l,l.__name__="SerializationError";var u=function(){function e(e){var r;this._references=new Map,this._definitions=new Map,this._refmap=new Map,this.include_defaults=null===(r=null==e?void 0:e.include_defaults)||void 0===r||r}return e.prototype.get_ref=function(e){return this._references.get(e)},e.prototype.add_ref=function(e,r){s.assert(!this._references.has(e)),this._references.set(e,r)},e.prototype.add_def=function(e,r){var t=this.get_ref(e);s.assert(null!=t),this._definitions.set(e,r),this._refmap.set(t,r)},Object.defineProperty(e.prototype,"objects",{get:function(){return new Set(this._references.keys())},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"references",{get:function(){return new Set(this._references.values())},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"definitions",{get:function(){return new Set(this._definitions.values())},enumerable:!1,configurable:!0}),e.prototype.resolve_ref=function(e){return this._refmap.get(e)},e.prototype.remove_ref=function(e){return this._references.delete(e)},e.prototype.remove_def=function(e){return this._definitions.delete(e)},e.prototype.to_serializable=function(e){var r,i,n=this.get_ref(e);if(null!=n)return n;if(function(e){return f.isObject(e)&&void 0!==e[t.serialize]}(e))return e[t.serialize](this);if(f.isArray(e)||f.isTypedArray(e)){for(var s=e.length,u=new Array(s),_=0;_<s;_++){var c=e[_];u[_]=this.to_serializable(c)}return u}if(f.isPlainObject(e)){u={};try{for(var p=o.__values(a.entries(e)),d=p.next();!d.done;d=p.next()){var h=o.__read(d.value,2),y=h[0];c=h[1];u[y]=this.to_serializable(c)}}catch(e){r={error:e}}finally{try{d&&!d.done&&(i=p.return)&&i.call(p)}finally{if(r)throw r.error}}return u}if(null===e||f.isBoolean(e)||f.isNumber(e)||f.isString(e))return e;throw new l(Object.prototype.toString.call(e)+" is not serializable")},e}();t.Serializer=u,u.__name__="Serializer"},
function _(r,_,e,f,n){f();var a=r(1),u=r(123),t=r(142),i=r(147);e.is_NDArray_ref=function(r){return u.isPlainObject(r)&&("__buffer__"in r||"__ndarray__"in r)},e.decode_NDArray=function(r,_){var e,f=r.shape,n=r.dtype,a=r.order;if("__buffer__"in r){var u=_.get(r.__buffer__);if(null==u)throw new Error("buffer for "+r.__buffer__+" not found");e=u}else e=i.base64_to_buffer(r.__ndarray__);return a!==t.BYTE_ORDER&&i.swap(e,n),{buffer:e,dtype:n,shape:f}},e.encode_NDArray=function(r,_){var e={order:t.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=_){var f=""+_.size;return _.set(f,r.buffer),a.__assign({__buffer__:f},e)}var n={toJSON:function(){return i.buffer_to_base64(r.buffer)}};return a.__assign({__ndarray__:n},e)}},
function _(r,n,t,a,e){a(),t.buffer_to_base64=function(r){var n=new Uint8Array(r),t=Array.from(n).map((function(r){return String.fromCharCode(r)}));return btoa(t.join(""))},t.base64_to_buffer=function(r){for(var n=atob(r),t=n.length,a=new Uint8Array(t),e=0,o=t;e<o;e++)a[e]=n.charCodeAt(e);return a.buffer},t.swap=function(r,n){switch(n){case"uint16":case"int16":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=2){var e=n[t];n[t]=n[t+1],n[t+1]=e}}(r);break;case"uint32":case"int32":case"float32":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=4){var e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}(r);break;case"float64":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=8){var e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}(r)}}},
function _(t,r,e,n,a){n();var o=t(1),i=t(141),s=function(){function t(){}return t.prototype.is_Scalar=function(){return this.is_scalar},t.prototype.is_Vector=function(){return!this.is_scalar},t}();e.Uniform=s,s.__name__="Uniform";var u=function(t){function r(r,e){var n=t.call(this)||this;return n.value=r,n.length=e,n.is_scalar=!0,n}return o.__extends(r,t),r.prototype.get=function(t){return this.value},r.prototype[Symbol.iterator]=function(){var t,r,e,n;return o.__generator(this,(function(a){switch(a.label){case 0:r=(t=this).length,e=t.value,n=0,a.label=1;case 1:return n<r?[4,e]:[3,4];case 2:a.sent(),a.label=3;case 3:return n++,[3,1];case 4:return[2]}}))},r.prototype.select=function(t){return new r(this.value,t.count)},r.prototype[i.equals]=function(t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)},r}(s);e.UniformScalar=u,u.__name__="UniformScalar";var c=function(t){function r(r){var e=t.call(this)||this;return e.array=r,e.is_scalar=!1,e.length=e.array.length,e}return o.__extends(r,t),r.prototype.get=function(t){return this.array[t]},r.prototype[Symbol.iterator]=function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[5,o.__values(this.array)];case 1:return t.sent(),[2]}}))},r.prototype.select=function(t){var r=t.select(this.array);return new this.constructor(r)},r.prototype[i.equals]=function(t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)},r}(s);e.UniformVector=c,c.__name__="UniformVector";var l=function(t){function r(r){var e=t.call(this,r)||this;return e.array=r,e._view=new DataView(r.buffer),e}return o.__extends(r,t),r.prototype.get=function(t){return this._view.getUint32(4*t)},r.prototype[Symbol.iterator]=function(){var t,r;return o.__generator(this,(function(e){switch(e.label){case 0:t=this.length,r=0,e.label=1;case 1:return r<t?[4,this.get(r)]:[3,4];case 2:e.sent(),e.label=3;case 3:return r++,[3,1];case 4:return[2]}}))},r}(c);e.ColorUniformVector=l,l.__name__="ColorUniformVector"},
function _(r,t,e,n,u){n();var a=r(143);function c(){for(var r=new Array(32),t="0123456789ABCDEF",e=0;e<32;e++)r[e]=t.substr(Math.floor(16*Math.random()),1);return r[12]="4",r[16]=t.substr(3&r[16].charCodeAt(0)|8,1),r.join("")}e.startsWith=function(r,t,e){return void 0===e&&(e=0),r.substr(e,t.length)==t},e.uuid4=c;var s=1e3;e.uniqueId=function(r){var t=a.settings.dev?"j"+s++:c();return null!=r?r+"-"+t:t},e.escape=function(r){return r.replace(/(?:[&<>"'`])/g,(function(r){switch(r){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return r}}))},e.unescape=function(r){return r.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(function(r,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},e.use_strict=function(r){return"'use strict';\n"+r},e.to_fixed=function(r,t){return r.toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(t,e,n,r,i){r();var o=t(1),a=t(145),s=function(t){this.document=t};n.DocumentEvent=s,s.__name__="DocumentEvent";var _=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.events=n,i.setter_id=r,i}return o.__extends(e,t),e}(s);n.DocumentEventBatch=_,_.__name__="DocumentEventBatch";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(s);n.DocumentChangedEvent=u,u.__name__="DocumentChangedEvent";var l=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.msg_type=n,i.msg_data=r,i}return o.__extends(e,t),e.prototype[a.serialize]=function(t){var e=this.msg_data,n=t.to_serializable(e);return{kind:"MessageSent",msg_type:this.msg_type,msg_data:n}},e}(u);n.MessageSentEvent=l,l.__name__="MessageSentEvent";var d=function(t){function e(e,n,r,i,o,a,s){var _=t.call(this,e)||this;return _.model=n,_.attr=r,_.old=i,_.new_=o,_.setter_id=a,_.hint=s,_}return o.__extends(e,t),e.prototype[a.serialize]=function(t){if(null!=this.hint)return t.to_serializable(this.hint);var e=this.new_,n=t.to_serializable(e);return this.model!=e&&t.remove_def(this.model),{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:n}},e}(u);n.ModelChangedEvent=d,d.__name__="ModelChangedEvent";var c=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.column_source=n,i.patches=r,i}return o.__extends(e,t),e.prototype[a.serialize]=function(t){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},e}(u);n.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";var h=function(t){function e(e,n,r,i){var o=t.call(this,e)||this;return o.column_source=n,o.data=r,o.rollover=i,o}return o.__extends(e,t),e.prototype[a.serialize]=function(t){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},e}(u);n.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";var m=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.title=n,i.setter_id=r,i}return o.__extends(e,t),e.prototype[a.serialize]=function(t){return{kind:"TitleChanged",title:this.title}},e}(u);n.TitleChangedEvent=m,m.__name__="TitleChangedEvent";var v=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.model=n,i.setter_id=r,i}return o.__extends(e,t),e.prototype[a.serialize]=function(t){return{kind:"RootAdded",model:t.to_serializable(this.model)}},e}(u);n.RootAddedEvent=v,v.__name__="RootAddedEvent";var f=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.model=n,i.setter_id=r,i}return o.__extends(e,t),e.prototype[a.serialize]=function(t){return{kind:"RootRemoved",model:this.model.ref()}},e}(u);n.RootRemovedEvent=f,f.__name__="RootRemovedEvent"},
function _(t,r,n,e,i){e();var o=t(1),s=t(123),a=t(128);n.pretty=Symbol("pretty");var u=function(){function t(t){this.visited=new Set,this.precision=null==t?void 0:t.precision}return t.prototype.to_string=function(t){if(s.isObject(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return s.isObject(t)&&void 0!==t[n.pretty]}(t)?t[n.pretty](this):s.isBoolean(t)?this.boolean(t):s.isNumber(t)?this.number(t):s.isString(t)?this.string(t):s.isArray(t)?this.array(t):s.isIterable(t)?this.iterable(t):s.isPlainObject(t)?this.object(t):""+t},t.prototype.token=function(t){return t},t.prototype.boolean=function(t){return""+t},t.prototype.number=function(t){return null!=this.precision?t.toFixed(this.precision):""+t},t.prototype.string=function(t){return'"'+t.replace(/'/g,"\\'")+'"'},t.prototype.array=function(t){var r,n,e=this.token,i=[];try{for(var s=o.__values(t),a=s.next();!a.done;a=s.next()){var u=a.value;i.push(this.to_string(u))}}catch(t){r={error:t}}finally{try{a&&!a.done&&(n=s.return)&&n.call(s)}finally{if(r)throw r.error}}return""+e("[")+i.join(e(",")+" ")+e("]")},t.prototype.iterable=function(t){var r,n=this.token,e=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",i=this.array(t);return""+e+n("(")+i+n(")")},t.prototype.object=function(t){var r,n,e=this.token,i=[];try{for(var s=o.__values(a.entries(t)),u=s.next();!u.done;u=s.next()){var c=o.__read(u.value,2),l=c[0],p=c[1];i.push(""+l+e(":")+" "+this.to_string(p))}}catch(t){r={error:t}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(r)throw r.error}}return""+e("{")+i.join(e(",")+" ")+e("}")},t}();n.Printer=u,u.__name__="Printer",n.to_string=function(t,r){return new u(r).to_string(t)}},
function _(r,n,e,t,o){t();var i=r(1),l=r(128),a=r(123);function c(r){return a.isObject(r)&&void 0!==r[e.clone]}e.clone=Symbol("clone"),e.is_Cloneable=c;var u=function(r){function n(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(n,r),n}(Error);e.CloningError=u,u.__name__="CloningError";var f=function(){function r(){}return r.prototype.clone=function(r){var n,t;if(c(r))return r[e.clone](this);if(a.isArray(r)){for(var o=r.length,f=new Array(o),s=0;s<o;s++){var _=r[s];f[s]=this.clone(_)}return f}if(a.isPlainObject(r)){f={};try{for(var v=i.__values(l.entries(r)),y=v.next();!y.done;y=v.next()){var h=i.__read(y.value,2),b=h[0];_=h[1];f[b]=this.clone(_)}}catch(r){n={error:r}}finally{try{y&&!y.done&&(t=v.return)&&t.call(v)}finally{if(n)throw n.error}}return f}if(null===r||a.isBoolean(r)||a.isNumber(r)||a.isString(r))return r;throw new u(Object.prototype.toString.call(r)+" is not cloneable")},r}();e.Cloner=f,f.__name__="Cloner"},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(154),_),e.__exportStar(r(240),_),e.__exportStar(r(354),_),e.__exportStar(r(358),_),e.__exportStar(r(373),_),e.__exportStar(r(382),_),e.__exportStar(r(303),_),e.__exportStar(r(387),_),e.__exportStar(r(424),_),e.__exportStar(r(428),_),e.__exportStar(r(430),_),e.__exportStar(r(307),_),e.__exportStar(r(443),_),e.__exportStar(r(451),_),e.__exportStar(r(459),_),e.__exportStar(r(317),_),e.__exportStar(r(460),_),e.__exportStar(r(315),_),e.__exportStar(r(462),_),e.__exportStar(r(463),_),e.__exportStar(r(276),_),e.__exportStar(r(468),_),e.__exportStar(r(478),_),e.__exportStar(r(482),_)},
function _(e,o,n,a,t){a(),t("Annotation",e(155).Annotation),t("Arrow",e(183).Arrow),t("ArrowHead",e(227).ArrowHead),t("OpenHead",e(227).OpenHead),t("NormalHead",e(227).NormalHead),t("TeeHead",e(227).TeeHead),t("VeeHead",e(227).VeeHead),t("Band",e(229).Band),t("BoxAnnotation",e(231).BoxAnnotation),t("ColorBar",e(232).ColorBar),t("Label",e(323).Label),t("LabelSet",e(324).LabelSet),t("Legend",e(325).Legend),t("LegendItem",e(326).LegendItem),t("PolyAnnotation",e(328).PolyAnnotation),t("Slope",e(329).Slope),t("Span",e(330).Span),t("TextAnnotation",e(234).TextAnnotation),t("Title",e(233).Title),t("ToolbarPanel",e(331).ToolbarPanel),t("Tooltip",e(351).Tooltip),t("Whisker",e(353).Whisker)},
function _(t,n,e,i,o){i();var r=t(1),a=t(156),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),n=t.width,e=t.height;return{width:Math.round(n),height:Math.round(e)}}return{width:0,height:0}},n.prototype._get_size=function(){throw new Error("not implemented")},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var e=this.model.properties;this.on_change(e.visible,(function(){null!=n.layout&&(n.layout.visible=n.model.visible,n.plot_view.request_layout())}))},Object.defineProperty(n.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!1,configurable:!0}),n.prototype.serializable_state=function(){var n=t.prototype.serializable_state.call(this);return null==this.layout?n:r.__assign(r.__assign({},n),{bbox:this.layout.bbox.box})},n}(a.RendererView);e.AnnotationView=l,l.__name__="AnnotationView";var s=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_Annotation=function(){this.override({level:"annotation"})},n}(a.Renderer);e.Annotation=s,s.__name__="Annotation",s.init_Annotation()},
function _(e,t,n,r,i){r();var o=e(1),a=e(157),l=o.__importStar(e(160)),s=e(135),u=e(168),_=e(169),p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_RendererGroup=function(){this.define((function(e){return{visible:[e.Boolean,!0]}}))},t}(u.Model);n.RendererGroup=p,p.__name__="RendererGroup",p.init_RendererGroup();var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"coordinates",{get:function(){var e=this._coordinates;return null!=e?e:this._coordinates=this._initialize_coordinates()},enumerable:!1,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new l.Visuals(this),this.needs_webgl_blit=!1},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var n=this.model.properties,r=n.x_range_name,i=n.y_range_name;this.on_change([r,i],(function(){return t._initialize_coordinates()}));var o=this.model.group;null!=o&&this.on_change(o.properties.visible,(function(){t.model.visible=o.visible}))},t.prototype._initialize_coordinates=function(){var e=this.model.coordinates,t=this.plot_view.frame;if(null!=e)return e.get_transform(t);var n=this.model,r=n.x_range_name,i=n.y_range_name,o=t.x_scales.get(r),a=t.y_scales.get(i);return new _.CoordinateTransform(o,a)},Object.defineProperty(t.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"layer",{get:function(){var e=this.canvas,t=e.overlays,n=e.primary;return"overlay"==this.model.level?t:n},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"canvas",{get:function(){return this.plot_view.canvas_view},enumerable:!1,configurable:!0}),t.prototype.request_render=function(){this.request_paint()},t.prototype.request_paint=function(){this.plot_view.request_paint(this)},t.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return!1},enumerable:!1,configurable:!0}),t.prototype.render=function(){this.model.visible&&this._render(),this._has_finished=!0},t.prototype.renderer_view=function(e){},t}(a.View);n.RendererView=c,c.__name__="RendererView";var f=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Renderer=function(){this.define((function(e){var t=e.Boolean,n=e.String,r=e.Ref,i=e.Nullable;return{group:[i(r(p)),null],level:[s.RenderLevel,"image"],visible:[t,!0],x_range_name:[n,"default"],y_range_name:[n,"default"],coordinates:[i(r(_.CoordinateMapping)),null]}}))},t}(u.Model);n.Renderer=f,f.__name__="Renderer",f.init_Renderer()},
function _(t,e,i,n,o){n();var r=t(1),s=t(130),l=t(158),h=t(123),a=r.__importDefault(t(159)),u=function(){function t(t){this.removed=new s.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._idle_notified=!1;var e=t.model,i=t.parent;this.model=e,this.parent=i,this.root=null==i?this:i.root,this.removed.emit()}return Object.defineProperty(t.prototype,"ready",{get:function(){return this._ready},enumerable:!1,configurable:!0}),t.prototype.connect=function(t,e){var i=this,n=this._slots.get(e);return null==n&&(n=function(t,n){var o=Promise.resolve(e.call(i,t,n));i._ready=i._ready.then((function(){return o}))},this._slots.set(e,n)),t.connect(n,this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t.prototype.initialize=function(){var t,e;this._has_finished=!1,this.is_root&&(this._stylesheet=l.stylesheet);try{for(var i=r.__values(this.styles()),n=i.next();!n.done;n=i.next()){var o=n.value;this.stylesheet.append(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}},t.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){return[2]}))}))},t.prototype.remove=function(){this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.model.id+")"},t.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(t.prototype,"is_root",{get:function(){return null==this.parent},enumerable:!1,configurable:!0}),t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){s.Signal.disconnect_receiver(this)},t.prototype.on_change=function(t,e){var i,n;try{for(var o=r.__values(h.isArray(t)?t:[t]),s=o.next();!s.done;s=o.next()){var l=s.value;this.connect(l.change,e)}}catch(t){i={error:t}}finally{try{s&&!s.done&&(n=o.return)&&n.call(o)}finally{if(i)throw i.error}}},t.prototype.cursor=function(t,e){return null},Object.defineProperty(t.prototype,"stylesheet",{get:function(){return this.is_root?this._stylesheet:this.root.stylesheet},enumerable:!1,configurable:!0}),t.prototype.styles=function(){return[a.default]},t.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},t}();i.View=u,u.__name__="View"},
function _(t,e,r,n,i){n();var o=t(1),l=t(123),a=t(128),s=function(t){return function(e){var r,n,i,s,u,d,c,h,f,y,p,v;void 0===e&&(e={});for(var g=[],m=1;m<arguments.length;m++)g[m-1]=arguments[m];var _=document.createElement(t);_.classList.add("bk"),l.isPlainObject(e)||(g=o.__spreadArray([e],o.__read(g)),e={});try{for(var w=o.__values(a.entries(e)),x=w.next();!x.done;x=w.next()){var b=o.__read(x.value,2),L=b[0],C=b[1];if(null!=C&&(!l.isBoolean(C)||C))if("class"===L&&(l.isString(C)&&(C=C.split(/\s+/)),l.isArray(C)))try{for(var M=(i=void 0,o.__values(C)),E=M.next();!E.done;E=M.next()){var S=E.value;null!=S&&_.classList.add(S)}}catch(t){i={error:t}}finally{try{E&&!E.done&&(s=M.return)&&s.call(M)}finally{if(i)throw i.error}}else if("style"===L&&l.isPlainObject(C))try{for(var B=(u=void 0,o.__values(a.entries(C))),k=B.next();!k.done;k=B.next()){var A=o.__read(k.value,2),T=A[0],N=A[1];_.style[T]=N}}catch(t){u={error:t}}finally{try{k&&!k.done&&(d=B.return)&&d.call(B)}finally{if(u)throw u.error}}else if("data"===L&&l.isPlainObject(C))try{for(var O=(c=void 0,o.__values(a.entries(C))),P=O.next();!P.done;P=O.next()){var R=o.__read(P.value,2),D=R[0];N=R[1];_.dataset[D]=N}}catch(t){c={error:t}}finally{try{P&&!P.done&&(h=O.return)&&h.call(O)}finally{if(c)throw c.error}}else _.setAttribute(L,C)}}catch(t){r={error:t}}finally{try{x&&!x.done&&(n=w.return)&&n.call(w)}finally{if(r)throw r.error}}function z(t){var e,r;if(l.isString(t))_.appendChild(document.createTextNode(t));else if(t instanceof Node)_.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)try{for(var n=o.__values(t),i=n.next();!i.done;i=n.next()){var a=i.value;_.appendChild(a)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}try{for(var W=o.__values(g),j=W.next();!j.done;j=W.next()){var U=j.value;if(l.isArray(U))try{for(var H=(p=void 0,o.__values(U)),K=H.next();!K.done;K=H.next()){var F=K.value;z(F)}}catch(t){p={error:t}}finally{try{K&&!K.done&&(v=H.return)&&v.call(H)}finally{if(p)throw p.error}}else z(U)}}catch(t){f={error:t}}finally{try{j&&!j.done&&(y=W.return)&&y.call(W)}finally{if(f)throw f.error}}return _}};function u(t){var e=t.parentNode;null!=e&&e.removeChild(t)}function d(t){for(var e,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];var l=t.firstChild;try{for(var a=o.__values(n),s=a.next();!s.done;s=a.next()){var u=s.value;t.insertBefore(u,l)}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}}function c(t,e){var r,n,i,o=Element.prototype;return(null!==(i=null!==(n=null!==(r=o.matches)&&void 0!==r?r:o.webkitMatchesSelector)&&void 0!==n?n:o.mozMatchesSelector)&&void 0!==i?i:o.msMatchesSelector).call(t,e)}function h(t){return parseFloat(t)||0}function f(t){var e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function y(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}r.createElement=function(t,e){for(var r=[],n=2;n<arguments.length;n++)r[n-2]=arguments[n];return s(t).apply(void 0,o.__spreadArray([e],o.__read(r)))},r.div=s("div"),r.span=s("span"),r.canvas=s("canvas"),r.link=s("link"),r.style=s("style"),r.a=s("a"),r.p=s("p"),r.i=s("i"),r.pre=s("pre"),r.button=s("button"),r.label=s("label"),r.input=s("input"),r.select=s("select"),r.option=s("option"),r.optgroup=s("optgroup"),r.textarea=s("textarea"),r.nbsp=function(){return document.createTextNode(" ")},r.append=function(t){for(var e,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];try{for(var l=o.__values(n),a=l.next();!a.done;a=l.next()){var s=a.value;t.appendChild(s)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=l.return)&&r.call(l)}finally{if(e)throw e.error}}},r.remove=u,r.removeElement=u,r.replaceWith=function(t,e){var r=t.parentNode;null!=r&&r.replaceChild(e,t)},r.prepend=d,r.empty=function(t,e){var r,n,i;for(void 0===e&&(e=!1);i=t.firstChild;)t.removeChild(i);if(e&&t instanceof Element)try{for(var l=o.__values(t.attributes),a=l.next();!a.done;a=l.next()){var s=a.value;t.removeAttributeNode(s)}}catch(t){r={error:t}}finally{try{a&&!a.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},r.display=function(t){t.style.display=""},r.undisplay=function(t){t.style.display="none"},r.show=function(t){t.style.visibility=""},r.hide=function(t){t.style.visibility="hidden"},r.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},r.matches=c,r.parent=function(t,e){for(var r=t;r=r.parentElement;)if(c(r,e))return r;return null},r.extents=f,r.size=y,r.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},r.outer_size=function(t){var e=f(t).margin,r=e.left,n=e.right,i=e.top,o=e.bottom,l=y(t),a=l.width,s=l.height;return{width:Math.ceil(a+r+n),height:Math.ceil(s+i+o)}},r.content_size=function(t){var e,r,n=t.getBoundingClientRect(),i=n.left,l=n.top,a=f(t).padding,s=0,u=0;try{for(var d=o.__values(t.children),c=d.next();!c.done;c=d.next()){var h=c.value.getBoundingClientRect();s=Math.max(s,Math.ceil(h.left-i-a.left+h.width)),u=Math.max(u,Math.ceil(h.top-l-a.top+h.height))}}catch(t){e={error:t}}finally{try{c&&!c.done&&(r=d.return)&&r.call(d)}finally{if(e)throw e.error}}return{width:s,height:u}},r.position=function(t,e,r){var n=t.style;if(n.left=e.x+"px",n.top=e.y+"px",n.width=e.width+"px",n.height=e.height+"px",null==r)n.margin="";else{var i=r.top,o=r.right,l=r.bottom,a=r.left;n.margin=i+"px "+o+"px "+l+"px "+a+"px"}},r.children=function(t){return Array.from(t.children)};var p,v=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var r=this.classList.item(e);null!=r&&t.push(r)}return t},enumerable:!1,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t,e,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=o.__values(r),l=i.next();!l.done;l=i.next()){var a=l.value;this.classList.add(a)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return this},t.prototype.remove=function(){for(var t,e,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=o.__values(r),l=i.next();!l.done;l=i.next()){var a=l.value;this.classList.remove(a)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return this},t.prototype.clear=function(){var t,e;try{for(var r=o.__values(this.values),n=r.next();!n.done;n=r.next()){var i=n.value;"bk"!=i&&this.classList.remove(i)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return this},t.prototype.toggle=function(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this},t}();function g(t,e,r){var n=t.style,i=n.width,o=n.height,l=n.position,a=n.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return r()}finally{t.style.position=l,t.style.display=a,t.style.width=i,t.style.height=o}}r.ClassList=v,v.__name__="ClassList",r.classes=function(t){return new v(t)},r.toggle_attribute=function(t,e,r){null==r&&(r=!t.hasAttribute(e)),r?t.setAttribute(e,"true"):t.removeAttribute(e)},(p=r.Keys||(r.Keys={}))[p.Backspace=8]="Backspace",p[p.Tab=9]="Tab",p[p.Enter=13]="Enter",p[p.Esc=27]="Esc",p[p.PageUp=33]="PageUp",p[p.PageDown=34]="PageDown",p[p.Left=37]="Left",p[p.Up=38]="Up",p[p.Right=39]="Right",p[p.Down=40]="Down",p[p.Delete=46]="Delete",r.undisplayed=function(t,e){var r=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=r}},r.unsized=function(t,e){return g(t,{},e)},r.sized=g;var m=function(){function t(t){this.root=t,this.known=new Set,this.style=r.style({type:"text/css"}),d(t,this.style)}return t.prototype.append=function(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))},t}();r.StyleSheet=m,m.__name__="StyleSheet",r.stylesheet=new m(document.head),r.dom_ready=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){return"loading"==document.readyState?[2,new Promise((function(t,e){document.addEventListener("DOMContentLoaded",(function(){return t()}),{once:!0})}))]:[2]}))}))}},
function _(o,i,t,e,r){e(),t.root="bk-root",t.default=".bk-root{position:relative;width:auto;height:auto;z-index:0;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}"},
function _(e,r,a,t,n){t();var c=e(1),l=e(161);n("Line",l.Line),n("LineScalar",l.LineScalar),n("LineVector",l.LineVector);var i=e(164);n("Fill",i.Fill),n("FillScalar",i.FillScalar),n("FillVector",i.FillVector);var o=e(165);n("Text",o.Text),n("TextScalar",o.TextScalar),n("TextVector",o.TextVector);var s=e(166);n("Hatch",s.Hatch),n("HatchScalar",s.HatchScalar),n("HatchVector",s.HatchVector);var u=c.__importStar(e(163)),h=e(162);n("VisualProperties",h.VisualProperties),n("VisualUniforms",h.VisualUniforms);var V=function(){function e(e){var r,a;this._visuals=[];var t=function(r,a){var t=function(){switch(a){case u.Line:return new l.Line(e,r);case u.LineScalar:return new l.LineScalar(e,r);case u.LineVector:return new l.LineVector(e,r);case u.Fill:return new i.Fill(e,r);case u.FillScalar:return new i.FillScalar(e,r);case u.FillVector:return new i.FillVector(e,r);case u.Text:return new o.Text(e,r);case u.TextScalar:return new o.TextScalar(e,r);case u.TextVector:return new o.TextVector(e,r);case u.Hatch:return new s.Hatch(e,r);case u.HatchScalar:return new s.HatchScalar(e,r);case u.HatchVector:return new s.HatchVector(e,r);default:throw new Error("unknown visual")}}();n._visuals.push(t),Object.defineProperty(n,r+t.type,{get:function(){return t},configurable:!1,enumerable:!0})},n=this;try{for(var h=c.__values(e.model._mixins),V=h.next();!V.done;V=h.next()){var _=c.__read(V.value,2);t(_[0],_[1])}}catch(e){r={error:e}}finally{try{V&&!V.done&&(a=h.return)&&a.call(h)}finally{if(r)throw r.error}}}return e.prototype[Symbol.iterator]=function(){return c.__generator(this,(function(e){switch(e.label){case 0:return[5,c.__values(this._visuals)];case 1:return e.sent(),[2]}}))},e}();a.Visuals=V,V.__name__="Visuals"},
function _(e,t,i,n,l){n();var r=e(1),a=e(162),s=r.__importStar(e(163)),o=e(137),u=e(123);function _(e){if(u.isArray(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(u.isInteger)}}i.resolve_line_dash=_;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)},enumerable:!1,configurable:!0}),t.prototype.apply=function(e){var t=this.doit;return t&&(this.set_value(e),e.stroke()),t},t.prototype.set_value=function(e){var t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=o.color2css(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.lineDash=_(this.line_dash.get_value()),e.lineDashOffset=this.line_dash_offset.get_value()},t}(a.VisualProperties);i.Line=h,h.__name__="Line";var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)},enumerable:!1,configurable:!0}),t.prototype.apply=function(e){var t=this.doit;return t&&(this.set_value(e),e.stroke()),t},t.prototype.set_value=function(e){var t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=o.color2css(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.lineDash=_(this.line_dash.value),e.lineDashOffset=this.line_dash_offset.value},t}(a.VisualUniforms);i.LineScalar=p,p.__name__="LineScalar";var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color;if(e.is_Scalar()&&0==e.value)return!1;var t=this.line_alpha;if(t.is_Scalar()&&0==t.value)return!1;var i=this.line_width;return!i.is_Scalar()||0!=i.value},enumerable:!1,configurable:!0}),t.prototype.apply=function(e,t){var i=this.doit;return i&&(this.set_vectorize(e,t),e.stroke()),i},t.prototype.set_vectorize=function(e,t){var i=this.line_color.get(t),n=this.line_alpha.get(t),l=this.line_width.get(t),r=this.line_join.get(t),a=this.line_cap.get(t),s=this.line_dash.get(t),u=this.line_dash_offset.get(t);e.strokeStyle=o.color2css(i,n),e.lineWidth=l,e.lineJoin=r,e.lineCap=a,e.lineDash=_(s),e.lineDashOffset=u},t}(a.VisualUniforms);i.LineVector=c,c.__name__="LineVector",h.prototype.type="line",h.prototype.attrs=Object.keys(s.Line),p.prototype.type="line",p.prototype.attrs=Object.keys(s.LineScalar),c.prototype.type="line",c.prototype.attrs=Object.keys(s.LineVector)},
function _(r,t,e,n,o){n();var i=r(1),a=function(){function r(r,t){var e,n,o=this;void 0===t&&(t=""),this.obj=r,this.prefix=t;this._props=[];try{for(var a=i.__values(this.attrs),s=a.next();!s.done;s=a.next()){var u=s.value,l=r.model.properties[t+u];l.change.connect((function(){return o.update()})),this[u]=l,this._props.push(l)}}catch(r){e={error:r}}finally{try{s&&!s.done&&(n=a.return)&&n.call(a)}finally{if(e)throw e.error}}this.update()}return r.prototype[Symbol.iterator]=function(){return i.__generator(this,(function(r){switch(r.label){case 0:return[5,i.__values(this._props)];case 1:return r.sent(),[2]}}))},r.prototype.update=function(){},r}();e.VisualProperties=a,a.__name__="VisualProperties";var s=function(){function r(r,t){var e,n;void 0===t&&(t=""),this.obj=r,this.prefix=t;var o=function(e){Object.defineProperty(a,e,{get:function(){return r[t+e]}})},a=this;try{for(var s=i.__values(this.attrs),u=s.next();!u.done;u=s.next()){o(u.value)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(e)throw e.error}}}return r.prototype[Symbol.iterator]=function(){var r,t,e,n,o,a;return i.__generator(this,(function(s){switch(s.label){case 0:s.trys.push([0,5,6,7]),r=i.__values(this.attrs),t=r.next(),s.label=1;case 1:return t.done?[3,4]:(e=t.value,[4,this.obj.model.properties[this.prefix+e]]);case 2:s.sent(),s.label=3;case 3:return t=r.next(),[3,1];case 4:return[3,7];case 5:return n=s.sent(),o={error:n},[3,7];case 6:try{t&&!t.done&&(a=r.return)&&a.call(r)}finally{if(o)throw o.error}return[7];case 7:return[2]}}))},r.prototype.update=function(){},r}();e.VisualUniforms=s,s.__name__="VisualUniforms"},
function _(e,l,a,t,r){t();var c=e(1),n=c.__importStar(e(133)),o=e(135),i=c.__importStar(e(136)),_=e(128);a.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[o.LineJoin,"bevel"],line_cap:[o.LineCap,"butt"],line_dash:[i.Or(o.LineDash,i.Array(i.Number)),[]],line_dash_offset:[i.Number,0]},a.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},a.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(o.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},a.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[n.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[o.FontStyle,"normal"],text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},a.LineScalar={line_color:[n.ColorScalar,"black"],line_alpha:[n.NumberScalar,1],line_width:[n.NumberScalar,1],line_join:[n.LineJoinScalar,"bevel"],line_cap:[n.LineCapScalar,"butt"],line_dash:[n.LineDashScalar,[]],line_dash_offset:[n.NumberScalar,0]},a.FillScalar={fill_color:[n.ColorScalar,"gray"],fill_alpha:[n.NumberScalar,1]},a.HatchScalar={hatch_color:[n.ColorScalar,"black"],hatch_alpha:[n.NumberScalar,1],hatch_scale:[n.NumberScalar,12],hatch_pattern:[n.NullStringScalar,null],hatch_weight:[n.NumberScalar,1],hatch_extra:[n.AnyScalar,{}]},a.TextScalar={text_color:[n.ColorScalar,"#444444"],text_alpha:[n.NumberScalar,1],text_font:[n.FontScalar,"helvetica"],text_font_size:[n.FontSizeScalar,"16px"],text_font_style:[n.FontStyleScalar,"normal"],text_align:[n.TextAlignScalar,"left"],text_baseline:[n.TextBaselineScalar,"bottom"],text_line_height:[n.NumberScalar,1.2]},a.LineVector={line_color:[n.ColorSpec,"black"],line_alpha:[n.NumberSpec,1],line_width:[n.NumberSpec,1],line_join:[n.LineJoinSpec,"bevel"],line_cap:[n.LineCapSpec,"butt"],line_dash:[n.LineDashSpec,[]],line_dash_offset:[n.NumberSpec,0]},a.FillVector={fill_color:[n.ColorSpec,"gray"],fill_alpha:[n.NumberSpec,1]},a.HatchVector={hatch_color:[n.ColorSpec,"black"],hatch_alpha:[n.NumberSpec,1],hatch_scale:[n.NumberSpec,12],hatch_pattern:[n.NullStringSpec,null],hatch_weight:[n.NumberSpec,1],hatch_extra:[n.AnyScalar,{}]},a.TextVector={text_color:[n.ColorSpec,"#444444"],text_alpha:[n.NumberSpec,1],text_font:[n.FontSpec,"helvetica"],text_font_size:[n.FontSizeSpec,"16px"],text_font_style:[n.FontStyleSpec,"normal"],text_align:[n.TextAlignSpec,"left"],text_baseline:[n.TextBaselineSpec,"bottom"],text_line_height:[n.NumberSpec,1.2]},a.attrs_of=function(e,l,a,t){var r,n;void 0===t&&(t=!1);var o={};try{for(var i=c.__values(_.keys(a)),h=i.next();!h.done;h=i.next()){var S=h.value,p=""+l+S,b=e[p];o[t?p:S]=b}}catch(e){r={error:e}}finally{try{h&&!h.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}return o}},
function _(t,l,e,i,r){i();var o=t(1),a=t(162),n=o.__importStar(t(163)),p=t(137),u=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color.get_value(),l=this.fill_alpha.get_value();return!(null==t||0==l)},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l){var e=this.doit;return e&&(this.set_value(t),t.fill(l)),e},l.prototype.set_value=function(t){var l=this.fill_color.get_value(),e=this.fill_alpha.get_value();t.fillStyle=p.color2css(l,e)},l}(a.VisualProperties);e.Fill=u,u.__name__="Fill";var s=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color.value,l=this.fill_alpha.value;return!(0==t||0==l)},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l){var e=this.doit;return e&&(this.set_value(t),t.fill(l)),e},l.prototype.set_value=function(t){var l=this.fill_color.value,e=this.fill_alpha.value;t.fillStyle=p.color2css(l,e)},l}(a.VisualUniforms);e.FillScalar=s,s.__name__="FillScalar";var c=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color;if(t.is_Scalar()&&0==t.value)return!1;var l=this.fill_alpha;return!l.is_Scalar()||0!=l.value},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l,e){var i=this.doit;return i&&(this.set_vectorize(t,l),t.fill(e)),i},l.prototype.set_vectorize=function(t,l){var e=this.fill_color.get(l),i=this.fill_alpha.get(l);t.fillStyle=p.color2css(e,i)},l}(a.VisualUniforms);e.FillVector=c,c.__name__="FillVector",u.prototype.type="fill",u.prototype.attrs=Object.keys(n.Fill),s.prototype.type="fill",s.prototype.attrs=Object.keys(n.FillScalar),c.prototype.type="fill",c.prototype.attrs=Object.keys(n.FillVector)},
function _(t,e,o,n,l){n();var i=t(1),r=t(162),a=i.__importStar(t(163)),s=t(137),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)},enumerable:!1,configurable:!0}),e.prototype.set_value=function(t){var e=this.text_color.get_value(),o=this.text_alpha.get_value();t.fillStyle=s.color2css(e,o),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()},e.prototype.font_value=function(){return this.text_font_style.get_value()+" "+this.text_font_size.get_value()+" "+this.text_font.get_value()},e}(r.VisualProperties);o.Text=_,_.__name__="Text";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)},enumerable:!1,configurable:!0}),e.prototype.set_value=function(t){var e=this.text_color.value,o=this.text_alpha.value,n=this.font_value(),l=this.text_align.value,i=this.text_baseline.value;t.fillStyle=s.color2css(e,o),t.font=n,t.textAlign=l,t.textBaseline=i},e.prototype.font_value=function(){return this.text_font_style.value+" "+this.text_font_size.value+" "+this.text_font.value},e}(r.VisualUniforms);o.TextScalar=u,u.__name__="TextScalar";var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color;if(t.is_Scalar()&&0==t.value)return!1;var e=this.text_alpha;return!e.is_Scalar()||0!=e.value},enumerable:!1,configurable:!0}),e.prototype.set_vectorize=function(t,e){var o=this.text_color.get(e),n=this.text_alpha.get(e),l=this.font_value(e),i=this.text_align.get(e),r=this.text_baseline.get(e);t.fillStyle=s.color2css(o,n),t.font=l,t.textAlign=i,t.textBaseline=r},e.prototype.font_value=function(t){return this.text_font_style.get(t)+" "+this.text_font_size.get(t)+" "+this.text_font.get(t)},e}(r.VisualUniforms);o.TextVector=p,p.__name__="TextVector",_.prototype.type="text",_.prototype.attrs=Object.keys(a.Text),u.prototype.type="text",u.prototype.attrs=Object.keys(a.TextScalar),p.prototype.type="text",p.prototype.attrs=Object.keys(a.TextVector)},
function _(t,e,a,r,i){r();var n=t(1),h=t(162),o=t(167),_=n.__importStar(t(133)),c=n.__importStar(t(163)),l=function(t){function e(){var e=t.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return e._update_iteration=0,e}return n.__extends(e,t),e.prototype.update=function(){var t=this;if(this._update_iteration++,this._hatch_image=null,this.doit){var e=this.hatch_color.get_value(),a=this.hatch_alpha.get_value(),r=this.hatch_scale.get_value(),i=this.hatch_pattern.get_value(),n=this.hatch_weight.get_value(),h=function(e){t._hatch_image=e},_=this.hatch_extra.get_value()[i];if(null!=_){if((s=_.get_pattern(e,a,r,n))instanceof Promise){var c=this._update_iteration;s.then((function(e){t._update_iteration==c&&(h(e),t.obj.request_render())}))}else h(s)}else{var l=this.obj.canvas.create_layer(),s=o.get_pattern(l,i,e,a,r,n);h(s)}}},Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e){var a=this.doit;return a&&(this.set_value(t),t.layer.undo_transform((function(){return t.fill(e)}))),a},e.prototype.set_value=function(t){var e=this.pattern(t);t.fillStyle=null!=e?e:"transparent"},e.prototype.pattern=function(t){var e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())},e.prototype.repetition=function(){var t=this.hatch_pattern.get_value(),e=this.hatch_extra.get_value()[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualProperties);a.Hatch=l,l.__name__="Hatch";var s=function(t){function e(){var e=t.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return e._static_doit=!1,e._update_iteration=0,e}return n.__extends(e,t),e.prototype._compute_static_doit=function(){var t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(null==t||0==e||" "==a||"blank"==a||null==a)},e.prototype.update=function(){var t=this;this._update_iteration++;var e=this.hatch_color.length;if(this._hatch_image=new _.UniformScalar(null,e),this._static_doit=this._compute_static_doit(),this._static_doit){var a=this.hatch_color.value,r=this.hatch_alpha.value,i=this.hatch_scale.value,n=this.hatch_pattern.value,h=this.hatch_weight.value,c=function(a){t._hatch_image=new _.UniformScalar(a,e)},l=this.hatch_extra.value[n];if(null!=l){if((p=l.get_pattern(a,r,i,h))instanceof Promise){var s=this._update_iteration;p.then((function(e){t._update_iteration==s&&(c(e),t.obj.request_render())}))}else c(p)}else{var u=this.obj.canvas.create_layer(),p=o.get_pattern(u,n,a,r,i,h);c(p)}}},Object.defineProperty(e.prototype,"doit",{get:function(){return this._static_doit},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e){var a=this.doit;return a&&(this.set_value(t),t.layer.undo_transform((function(){return t.fill(e)}))),a},e.prototype.set_value=function(t){var e;t.fillStyle=null!==(e=this.pattern(t))&&void 0!==e?e:"transparent"},e.prototype.pattern=function(t){var e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())},e.prototype.repetition=function(){var t=this.hatch_pattern.value,e=this.hatch_extra.value[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualUniforms);a.HatchScalar=s,s.__name__="HatchScalar";var u=function(t){function e(){var e=t.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return e._static_doit=!1,e._update_iteration=0,e}return n.__extends(e,t),e.prototype._compute_static_doit=function(){var t=this.hatch_color;if(t.is_Scalar()&&0==t.value)return!1;var e=this.hatch_alpha;if(e.is_Scalar()&&0==e.value)return!1;var a=this.hatch_pattern;if(a.is_Scalar()){var r=a.value;if(" "==r||"blank"==r||null==r)return!1}return!0},e.prototype.update=function(){var t=this;this._update_iteration++;var e=this.hatch_color.length;if(this._hatch_image=new _.UniformScalar(null,e),this._static_doit=this._compute_static_doit(),this._static_doit){var a=function(e,a,r,i,n,h){var _=t.hatch_extra.value[e];if(null!=_){if((s=_.get_pattern(a,r,i,n))instanceof Promise){var c=t._update_iteration;s.then((function(e){t._update_iteration==c&&(h(e),t.obj.request_render())}))}else h(s)}else{var l=t.obj.canvas.create_layer(),s=o.get_pattern(l,e,a,r,i,n);h(s)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){var r=this.hatch_color.value,i=this.hatch_alpha.value,n=this.hatch_scale.value,h=this.hatch_pattern.value,c=this.hatch_weight.value;a(h,r,i,n,c,(function(a){t._hatch_image=new _.UniformScalar(a,e)}))}else{var l=new Array(e);l.fill(null),this._hatch_image=new _.UniformVector(l);for(var s=function(t){var e=u.hatch_color.get(t),r=u.hatch_alpha.get(t),i=u.hatch_scale.get(t),n=u.hatch_pattern.get(t),h=u.hatch_weight.get(t);a(n,e,r,i,h,(function(e){l[t]=e}))},u=this,p=0;p<e;p++)s(p)}}},Object.defineProperty(e.prototype,"doit",{get:function(){return this._static_doit},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e,a){var r=this.doit;return r&&(this.set_vectorize(t,e),t.layer.undo_transform((function(){return t.fill(a)}))),r},e.prototype.set_vectorize=function(t,e){var a;t.fillStyle=null!==(a=this.pattern(t,e))&&void 0!==a?a:"transparent"},e.prototype.pattern=function(t,e){var a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))},e.prototype.repetition=function(t){var e=this.hatch_pattern.get(t),a=this.hatch_extra.value[e];if(null==a)return"repeat";switch(a.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualUniforms);a.HatchVector=u,u.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(c.Hatch),s.prototype.type="hatch",s.prototype.attrs=Object.keys(c.HatchScalar),u.prototype.type="hatch",u.prototype.attrs=Object.keys(c.HatchVector)},
function _(e,o,a,r,i){r();var s=e(137);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function n(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function t(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,r,i,c,k){return e.resize(c,c),e.prepare(),function(e,o,r,i,c,k){var _,v=c,T=v/2,h=T/2,d=s.color2css(r,i);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=k,null!==(_=a.hatch_aliases[o])&&void 0!==_?_:o){case"blank":break;case"dot":e.arc(T,T,T/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(T,T,T/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,v,T);break;case"vertical_line":n(e,v,T);break;case"cross":l(e,v,T),n(e,v,T);break;case"horizontal_dash":l(e,T,T);break;case"vertical_dash":n(e,T,T);break;case"spiral":var b=v/30;e.moveTo(T,T);for(var g=0;g<360;g++){var m=.1*g,f=T+b*m*Math.cos(m),u=T+b*m*Math.sin(m);e.lineTo(f,u)}e.stroke();break;case"right_diagonal_line":e.moveTo(.5-h,v),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,v),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,v),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,v),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,v),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,v),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":t(e,v);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(T,3*h),e.lineTo(v,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,T),e.lineTo(h,v),e.stroke();break;case"criss_cross":t(e,v),l(e,v,T),n(e,v,T)}}(e.ctx,o,r,i,c,k),e.canvas}},
function _(e,t,n,r,a){r();var o=e(1),c=e(129),i=e(123),s=e(128),l=e(134),_=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"is_syncable",{get:function(){return this.syncable},enumerable:!1,configurable:!0}),t.init_Model=function(){this.define((function(e){var t=e.Any,n=e.Unknown,r=e.Boolean,a=e.String,o=e.Array,c=e.Dict,i=e.Nullable;return{tags:[o(n),[]],name:[i(a),null],js_property_callbacks:[c(o(t)),{}],js_event_callbacks:[c(o(t)),{}],subscribed_events:[o(a),[]],syncable:[r,!0]}}))},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._js_callbacks=new Map},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(function(){return t._update_property_callbacks()})),this.connect(this.properties.js_event_callbacks.change,(function(){return t._update_event_callbacks()})),this.connect(this.properties.subscribed_events.change,(function(){return t._update_event_callbacks()}))},t.prototype._process_event=function(e){var t,n,r;try{for(var a=o.__values(null!==(r=this.js_event_callbacks[e.event_name])&&void 0!==r?r:[]),c=a.next();!c.done;c=a.next()){c.value.execute(e)}}catch(e){t={error:e}}finally{try{c&&!c.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}null!=this.document&&this.subscribed_events.some((function(t){return t==e.event_name}))&&this.document.event_manager.send_event(e)},t.prototype.trigger_event=function(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))},t.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this):l.logger.warn("WARNING: Document not defined for updating event callbacks")},t.prototype._update_property_callbacks=function(){var e,t,n,r,a,c,i,l,_=this,u=function(e){var t=o.__read(e.split(":"),2),n=t[0],r=t[1],a=void 0===r?null:r;return null!=a?_.properties[a][n]:_[n]};try{for(var d=o.__values(this._js_callbacks),p=d.next();!p.done;p=d.next()){var h=o.__read(p.value,2),f=h[0],v=h[1],y=u(f);try{for(var b=(n=void 0,o.__values(v)),g=b.next();!g.done;g=b.next()){var m=g.value;this.disconnect(y,m)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=b.return)&&r.call(b)}finally{if(n)throw n.error}}}}catch(t){e={error:t}}finally{try{p&&!p.done&&(t=d.return)&&t.call(d)}finally{if(e)throw e.error}}this._js_callbacks.clear();try{for(var k=o.__values(s.entries(this.js_property_callbacks)),j=k.next();!j.done;j=k.next()){var w=o.__read(j.value,2),x=(f=w[0],(v=w[1]).map((function(e){return function(){return e.execute(_)}})));this._js_callbacks.set(f,x);y=u(f);try{for(var A=(i=void 0,o.__values(x)),M=A.next();!M.done;M=A.next()){m=M.value;this.connect(y,m)}}catch(e){i={error:e}}finally{try{M&&!M.done&&(l=A.return)&&l.call(A)}finally{if(i)throw i.error}}}}catch(e){a={error:e}}finally{try{j&&!j.done&&(c=k.return)&&c.call(k)}finally{if(a)throw a.error}}},t.prototype._doc_attached=function(){s.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()},t.prototype._doc_detached=function(){this.document.event_manager.subscribed_models.delete(this)},t.prototype.select=function(e){if(i.isString(e))return o.__spreadArray([],o.__read(this.references())).filter((function(n){return n instanceof t&&n.name===e}));if(e.prototype instanceof c.HasProps)return o.__spreadArray([],o.__read(this.references())).filter((function(t){return t instanceof e}));throw new Error("invalid selector")},t.prototype.select_one=function(e){var t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}},t}(c.HasProps);n.Model=_,_.__name__="Model",_.init_Model()},
function _(e,t,n,r,a){r();var o=e(1),c=e(127),s=e(168),i=e(170),_=e(174),u=e(176),l=e(177),p=e(172),g=e(178),f=e(182),h=function(){function e(e,t){this.x_scale=e,this.y_scale=t,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}return e.prototype.map_to_screen=function(e,t){return[this.x_scale.v_compute(e),this.y_scale.v_compute(t)]},e.prototype.map_from_screen=function(e,t){return[this.x_scale.v_invert(e),this.y_scale.v_invert(t)]},e}();n.CoordinateTransform=h,h.__name__="CoordinateTransform";var y=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CoordinateMapping=function(){this.define((function(e){var t=e.Ref;return{x_source:[t(p.Range),function(){return new g.DataRange1d}],y_source:[t(p.Range),function(){return new g.DataRange1d}],x_scale:[t(i.Scale),function(){return new _.LinearScale}],y_scale:[t(i.Scale),function(){return new _.LinearScale}],x_target:[t(p.Range)],y_target:[t(p.Range)]}}))},Object.defineProperty(t.prototype,"x_ranges",{get:function(){return new Map([["default",this.x_source]])},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return new Map([["default",this.y_source]])},enumerable:!1,configurable:!0}),t.prototype._get_scale=function(e,t,n){if(e instanceof f.FactorRange!=t instanceof l.CategoricalScale)throw new Error("Range "+e.type+" is incompatible is Scale "+t.type);t instanceof u.LogScale&&e instanceof g.DataRange1d&&(e.scale_hint="log");var r=t.clone();return r.setv({source_range:e,target_range:n}),r},t.prototype.get_transform=function(e){var t=this,n=t.x_source,r=t.x_scale,a=t.x_target,o=this._get_scale(n,r,a),c=this,s=c.y_source,i=c.y_scale,_=c.y_target,u=this._get_scale(s,i,_),l=new m({source_scale:o,source_range:o.source_range,target_scale:e.x_scale,target_range:e.x_target}),p=new m({source_scale:u,source_range:u.source_range,target_scale:e.y_scale,target_range:e.y_target});return new h(l,p)},t}(s.Model);n.CoordinateMapping=y,y.__name__="CoordinateMapping",y.init_CoordinateMapping();var m=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CompositeScale=function(){this.internal((function(e){var t=e.Ref;return{source_scale:[t(i.Scale)],target_scale:[t(i.Scale)]}}))},Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=this.source_scale.s_compute,t=this.target_scale.s_compute;return function(n){return t(e(n))}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=this.source_scale.s_invert,t=this.target_scale.s_invert;return function(n){return e(t(n))}},enumerable:!1,configurable:!0}),t.prototype.compute=function(e){return this.s_compute(e)},t.prototype.v_compute=function(e){var t=this.s_compute;return c.map(e,t)},t.prototype.invert=function(e){return this.s_invert(e)},t.prototype.v_invert=function(e){var t=this.s_invert;return c.map(e,t)},t}(i.Scale);n.CompositeScale=m,m.__name__="CompositeScale",m.init_CompositeScale()},
function _(t,e,r,n,i){n();var o=t(1),u=t(171),a=t(172),_=t(173),c=t(139),s=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Scale=function(){this.internal((function(t){var e=t.Ref;return{source_range:[e(a.Range)],target_range:[e(_.Range1d)]}}))},e.prototype.compute=function(t){return this.s_compute(t)},e.prototype.v_compute=function(t){for(var e=new c.ScreenArray(t.length),r=this.s_compute,n=0;n<t.length;n++)e[n]=r(t[n]);return e},e.prototype.invert=function(t){return this.s_invert(t)},e.prototype.v_invert=function(t){for(var e=new Float64Array(t.length),r=this.s_invert,n=0;n<t.length;n++)e[n]=r(t[n]);return e},e.prototype.r_compute=function(t,e){var r=this.s_compute;return this.target_range.is_reversed?[r(e),r(t)]:[r(t),r(e)]},e.prototype.r_invert=function(t,e){var r=this.s_invert;return this.target_range.is_reversed?[r(e),r(t)]:[r(t),r(e)]},e}(u.Transform);r.Scale=s,s.__name__="Scale",s.init_Scale()},
function _(n,r,t,_,e){_();var o=n(1),a=function(n){function r(r){return n.call(this,r)||this}return o.__extends(r,n),r}(n(168).Model);t.Transform=a,a.__name__="Transform"},
function _(e,n,t,i,r){i();var a=e(1),u=function(e){function n(n){var t=e.call(this,n)||this;return t.have_updated_interactively=!1,t}return a.__extends(n,e),n.init_Range=function(){this.define((function(e){var n=e.Number,t=e.Tuple,i=e.Or,r=e.Auto,a=e.Nullable;return{bounds:[a(i(t(a(n),a(n)),r)),null],min_interval:[a(n),null],max_interval:[a(n),null]}})),this.internal((function(e){return{plots:[(0,e.Array)((0,e.AnyRef)()),[]]}}))},Object.defineProperty(n.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"is_valid",{get:function(){return isFinite(this.min)&&isFinite(this.max)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"span",{get:function(){return Math.abs(this.end-this.start)},enumerable:!1,configurable:!0}),n}(e(168).Model);t.Range=u,u.__name__="Range",u.init_Range()},
function _(t,e,n,s,i){s();var r=t(1),a=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Range1d=function(){this.define((function(t){var e=t.Number,n=t.Nullable;return{start:[e,0],end:[e,1],reset_start:[n(e),null,{on_update:function(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[n(e),null,{on_update:function(t,e){e._reset_end=null!=t?t:e.end}}]}}))},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds();var t=this._reset_start,e=this._reset_end;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()},e.prototype.map=function(t){return new e({start:t(this.start),end:t(this.end)})},e.prototype.widen=function(t){var n=this.start,s=this.end;return this.is_reversed?(n+=t,s-=t):(n-=t,s+=t),new e({start:n,end:s})},e}(t(172).Range);n.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(e,t,r,n,a){n();var i=e(1),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=i.__read(this._linear_compute_state(),2),t=e[0],r=e[1];return function(e){return t*e+r}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=i.__read(this._linear_compute_state(),2),t=e[0],r=e[1];return function(e){return(e-r)/t}},enumerable:!1,configurable:!0}),t.prototype._linear_compute_state=function(){var e=this.source_range.start,t=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(t-e);return[n,-n*e+r]},t}(e(175).ContinuousScale);r.LinearScale=u,u.__name__="LinearScale"},
function _(n,t,u,e,c){e();var i=n(1),o=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t}(n(170).Scale);u.ContinuousScale=o,o.__name__="ContinuousScale"},
function _(t,e,r,a,o){a();var n=t(1),i=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"s_compute",{get:function(){var t=n.__read(this._compute_state(),4),e=t[0],r=t[1],a=t[2],o=t[3];return function(t){if(0==a)return 0;var n=(Math.log(t)-o)/a;return isFinite(n)?n*e+r:NaN}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"s_invert",{get:function(){var t=n.__read(this._compute_state(),4),e=t[0],r=t[1],a=t[2],o=t[3];return function(t){var n=(t-r)/e;return Math.exp(a*n+o)}},enumerable:!1,configurable:!0}),e.prototype._get_safe_factor=function(t,e){var r,a=t<0?0:t,o=e<0?0:e;if(a==o)if(0==a)a=(r=n.__read([1,10],2))[0],o=r[1];else{var i=Math.log(a)/Math.log(10);a=Math.pow(10,Math.floor(i)),o=Math.ceil(i)!=Math.floor(i)?Math.pow(10,Math.ceil(i)):Math.pow(10,Math.ceil(i)+1)}return[a,o]},e.prototype._compute_state=function(){var t,e,r=this.source_range.start,a=this.source_range.end,o=this.target_range.start,i=this.target_range.end-o,_=n.__read(this._get_safe_factor(r,a),2),u=_[0],c=_[1];return 0==u?(t=Math.log(c),e=0):(t=Math.log(c)-Math.log(u),e=Math.log(u)),[i,o,t,e]},e}(t(175).ContinuousScale);r.LogScale=i,i.__name__="LogScale"},
function _(e,t,r,n,a){n();var c=e(1),i=e(170),o=e(174).LinearScale.prototype._linear_compute_state,u=function(e){function t(t){return e.call(this,t)||this}return c.__extends(t,e),Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=c.__read(o.call(this),2),t=e[0],r=e[1],n=this.source_range;return function(e){return t*n.synthetic(e)+r}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=c.__read(o.call(this),2),t=e[0],r=e[1];return function(e){return(e-r)/t}},enumerable:!1,configurable:!0}),t}(i.Scale);r.CategoricalScale=u,u.__name__="CategoricalScale"},
function _(t,i,n,a,e){a();var r=t(1),l=t(179),s=t(135),_=t(124),o=t(134),d=r.__importStar(t(180)),u=t(181),h=function(t){function i(i){var n=t.call(this,i)||this;return n.have_updated_interactively=!1,n}return r.__extends(i,t),i.init_DataRange1d=function(){this.define((function(t){var i=t.Boolean,n=t.Number,a=t.Nullable;return{start:[n],end:[n],range_padding:[n,.1],range_padding_units:[s.PaddingUnits,"percent"],flipped:[i,!1],follow:[a(s.StartEnd),null],follow_interval:[a(n),null],default_span:[n,2],only_visible:[i,!1]}})),this.internal((function(t){return{scale_hint:[(0,t.Enum)("log","auto"),"auto"]}}))},i.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map},Object.defineProperty(i.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),i.prototype.computed_renderers=function(){var t=this.renderers,i=this.names,n=_.concat(this.plots.map((function(t){return t.data_renderers})));return u.compute_renderers(0==t.length?"auto":t,n,i)},i.prototype._compute_plot_bounds=function(t,i){var n,a,e=d.empty();try{for(var l=r.__values(t),s=l.next();!s.done;s=l.next()){var _=s.value,o=i.get(_);null==o||!_.visible&&this.only_visible||(e=d.union(e,o))}}catch(t){n={error:t}}finally{try{s&&!s.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}return e},i.prototype.adjust_bounds_for_aspect=function(t,i){var n=d.empty(),a=t.x1-t.x0;a<=0&&(a=1);var e=t.y1-t.y0;e<=0&&(e=1);var r=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=r+.5*a,n.x0=r-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n},i.prototype._compute_min_max=function(t,i){var n,a,e,l,s,_,o=d.empty();try{for(var u=r.__values(t),h=u.next();!h.done;h=u.next()){var p=h.value;o=d.union(o,p)}}catch(t){n={error:t}}finally{try{h&&!h.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}return 0==i?(s=(e=r.__read([o.x0,o.x1],2))[0],_=e[1]):(s=(l=r.__read([o.y0,o.y1],2))[0],_=l[1]),[s,_]},i.prototype._compute_range=function(t,i){var n,a,e,l=this.range_padding;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,o.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,o.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i));var s=void 0,_=void 0;if(i==t)_=this.default_span+.001,s=Math.log(t)/Math.log(10);else{var d=void 0,u=void 0;"percent"==this.range_padding_units?(d=Math.log(t)/Math.log(10),_=((u=Math.log(i)/Math.log(10))-d)*(1+l)):(d=Math.log(t-l)/Math.log(10),_=(u=Math.log(i+l)/Math.log(10))-d),s=(d+u)/2}a=Math.pow(10,s-_/2),e=Math.pow(10,s+_/2)}else{_=void 0;a=(s=(i+t)/2)-(_=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+l):i-t+2*l)/2,e=s+_/2}var h=1;this.flipped&&(a=(n=r.__read([e,a],2))[0],e=n[1],h=-1);var p=this.follow_interval;return null!=p&&Math.abs(a-e)>p&&("start"==this.follow?e=a+h*p:"end"==this.follow&&(a=e-h*p)),[a,e]},i.prototype.update=function(t,i,n,a){if(!this.have_updated_interactively){var e=this.computed_renderers(),l=this._compute_plot_bounds(e,t);null!=a&&(l=this.adjust_bounds_for_aspect(l,a)),this._plot_bounds.set(n,l);var s=r.__read(this._compute_min_max(this._plot_bounds.values(),i),2),_=s[0],o=s[1],d=r.__read(this._compute_range(_,o),2),u=d[0],h=d[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);var p=!1;"auto"==this.bounds&&(this.setv({bounds:[u,h]},{silent:!0}),p=!0);var g=r.__read([this.start,this.end],2),f=g[0],c=g[1];if(u!=f||h!=c){var v={};u!=f&&(v.start=u),h!=c&&(v.end=h),this.setv(v),p=!1}p&&this.change.emit()}},i.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},i}(l.DataRange);n.DataRange1d=h,h.__name__="DataRange1d",h.init_DataRange1d()},
function _(n,a,t,e,i){e();var r=n(1),_=function(n){function a(a){return n.call(this,a)||this}return r.__extends(a,n),a.init_DataRange=function(){this.define((function(n){var a=n.String,t=n.Array,e=n.AnyRef;return{names:[t(a),[]],renderers:[t(e()),[]]}}))},a}(n(172).Range);t.DataRange=_,_.__name__="DataRange",_.init_DataRange()},
function _(t,e,i,r,n){r();var o=t(139),h=t(141),u=Math.min,y=Math.max;i.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},i.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},i.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},i.union=function(t,e){return{x0:u(t.x0,e.x0),x1:y(t.x1,e.x1),y0:u(t.y0,e.y0),y1:y(t.y1,e.y1)}};var s=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t.x0,i=t.y0,r=t.x1,n=t.y1;if(!(e<=r&&i<=n))throw new Error("invalid bbox {x0: "+e+", y0: "+i+", x1: "+r+", y1: "+n+"}");this.x0=e,this.y0=i,this.x1=r,this.y1=n}else if("x"in t){var o=t.x,h=t.y,u=t.width,y=t.height;if(!(u>=0&&y>=0))throw new Error("invalid bbox {x: "+o+", y: "+h+", width: "+u+", height: "+y+"}");this.x0=o,this.y0=h,this.x1=o+u,this.y1=h+y}else{var s=void 0,f=void 0,p=void 0,c=void 0;if("width"in t)if("left"in t)f=(s=t.left)+t.width;else if("right"in t)s=(f=t.right)-t.width;else{var x=t.width/2;s=t.hcenter-x,f=t.hcenter+x}else s=t.left,f=t.right;if("height"in t)if("top"in t)c=(p=t.top)+t.height;else if("bottom"in t)p=(c=t.bottom)-t.height;else{var a=t.height/2;p=t.vcenter-a,c=t.vcenter+a}else p=t.top,c=t.bottom;if(!(s<=f&&p<=c))throw new Error("invalid bbox {left: "+s+", top: "+p+", right: "+f+", bottom: "+c+"}");this.x0=s,this.y0=p,this.x1=f,this.y1=c}}return t.from_rect=function(e){var i=e.left,r=e.right,n=e.top,o=e.bottom;return new t({x0:Math.min(i,r),y0:Math.min(n,o),x1:Math.max(i,r),y1:Math.max(n,o)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},t.prototype[h.equals]=function(t,e){return e.eq(this.x0,t.x0)&&e.eq(this.y0,t.y0)&&e.eq(this.x1,t.x1)&&e.eq(this.y1,t.y1)},t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"size",{get:function(){return{width:this.width,height:this.height}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){var t=this,e=t.x0,i=t.y0,r=t.x1,n=t.y1;return{p0:{x:e,y:i},p1:{x:r,y:i},p2:{x:r,y:n},p3:{x:e,y:n}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){var t=this;return{x:t.x,y:t.y,width:t.width,height:t.height}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"area",{get:function(){return this.width*this.height},enumerable:!1,configurable:!0}),t.prototype.relative=function(){return new t({x:0,y:0,width:this.width,height:this.height})},t.prototype.translate=function(e,i){var r=this;return new t({x:e+r.x,y:i+r.y,width:r.width,height:r.height})},t.prototype.relativize=function(t,e){return[t-this.x,e-this.y]},t.prototype.contains=function(t,e){return this.x0<=t&&t<=this.x1&&this.y0<=e&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.grow_by=function(e){return new t({left:this.left-e,right:this.right+e,top:this.top-e,bottom:this.bottom+e})},t.prototype.shrink_by=function(e){return new t({left:this.left+e,right:this.right-e,top:this.top+e,bottom:this.bottom-e})},t.prototype.union=function(e){return new t({x0:u(this.x0,e.x0),y0:u(this.y0,e.y0),x1:y(this.x1,e.x1),y1:y(this.y1,e.y1)})},t.prototype.intersection=function(e){return this.intersects(e)?new t({x0:y(this.x0,e.x0),y0:y(this.y0,e.y0),x1:u(this.x1,e.x1),y1:u(this.y1,e.y1)}):null},t.prototype.intersects=function(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var i=new o.ScreenArray(e.length),r=t.left,n=0;n<e.length;n++)i[n]=r+e[n];return i}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var i=new o.ScreenArray(e.length),r=t.bottom,n=0;n<e.length;n++)i[n]=r-e[n];return i}}},enumerable:!1,configurable:!0}),t}();i.BBox=s,s.__name__="BBox"},
function _(n,r,e,t,u){t();var i=n(124);e.compute_renderers=function(n,r,e){if(null==n)return[];var t="auto"==n?r:n;return e.length>0&&(t=t.filter((function(n){return i.includes(e,n.name)}))),t}},
function _(r,e,t,n,a){n();var i=r(1),o=r(172),s=r(135),l=r(136),u=r(139),p=r(124),c=r(123),_=r(126);function d(r,e,t){void 0===t&&(t=0);for(var n=new Map,a=0;a<r.length;a++){var i=r[a];if(n.has(i))throw new Error("duplicate factor or subfactor: "+i);n.set(i,{value:.5+a*(1+e)+t})}return[n,(r.length-1)*e]}function g(r,e,t,n){var a,o,s,l,u;void 0===n&&(n=0);var c=new Map,_=new Map;try{for(var g=i.__values(r),f=g.next();!f.done;f=g.next()){var v=i.__read(f.value,2),h=v[0],y=v[1],m=null!==(u=_.get(h))&&void 0!==u?u:[];_.set(h,i.__spreadArray(i.__spreadArray([],i.__read(m)),[y]))}}catch(r){a={error:r}}finally{try{f&&!f.done&&(o=g.return)&&o.call(g)}finally{if(a)throw a.error}}var S=n,b=0,w=function(r,n){var a=n.length,o=i.__read(d(n,t,S),2),s=o[0],l=o[1];b+=l;var u=p.sum(n.map((function(r){return s.get(r).value})));c.set(r,{value:u/a,mapping:s}),S+=a+e+l};try{for(var x=i.__values(_),A=x.next();!A.done;A=x.next()){var N=i.__read(A.value,2);w(h=N[0],m=N[1])}}catch(r){s={error:r}}finally{try{A&&!A.done&&(l=x.return)&&l.call(x)}finally{if(s)throw s.error}}return[c,(_.size-1)*e+b]}function f(r,e,t,n,a){var o,s,l,u,c;void 0===a&&(a=0);var _=new Map,d=new Map;try{for(var f=i.__values(r),v=f.next();!v.done;v=f.next()){var h=i.__read(v.value,3),y=h[0],m=h[1],S=h[2],b=null!==(c=d.get(y))&&void 0!==c?c:[];d.set(y,i.__spreadArray(i.__spreadArray([],i.__read(b)),[[m,S]]))}}catch(r){o={error:r}}finally{try{v&&!v.done&&(s=f.return)&&s.call(f)}finally{if(o)throw o.error}}var w=a,x=0,A=function(r,a){var o=a.length,s=i.__read(g(a,t,n,w),2),l=s[0],u=s[1];x+=u;var c=p.sum(a.map((function(r){var e=i.__read(r,1)[0];return l.get(e).value})));_.set(r,{value:c/o,mapping:l}),w+=o+e+u};try{for(var N=i.__values(d),F=N.next();!F.done;F=N.next()){var k=i.__read(F.value,2);A(y=k[0],b=k[1])}}catch(r){l={error:r}}finally{try{F&&!F.done&&(u=N.return)&&u.call(N)}finally{if(l)throw l.error}}return[_,(d.size-1)*e+x]}t.Factor=l.Or(l.String,l.Tuple(l.String,l.String),l.Tuple(l.String,l.String,l.String)),t.FactorSeq=l.Or(l.Array(l.String),l.Array(l.Tuple(l.String,l.String)),l.Array(l.Tuple(l.String,l.String,l.String))),t.map_one_level=d,t.map_two_levels=g,t.map_three_levels=f;var v=function(r){function e(e){return r.call(this,e)||this}return i.__extends(e,r),e.init_FactorRange=function(){this.define((function(r){var e=r.Number;return{factors:[t.FactorSeq,[]],factor_padding:[e,0],subgroup_padding:[e,.8],group_padding:[e,1.4],range_padding:[e,0],range_padding_units:[s.PaddingUnits,"percent"],start:[e],end:[e]}})),this.internal((function(r){var e=r.Number,t=r.String,n=r.Array,a=r.Tuple,i=r.Nullable;return{levels:[e],mids:[i(n(a(t,t))),null],tops:[i(n(t)),null]}}))},Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){r.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;r.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,(function(){return e.reset()})),this.connect(this.properties.factor_padding.change,(function(){return e.reset()})),this.connect(this.properties.group_padding.change,(function(){return e.reset()})),this.connect(this.properties.subgroup_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding_units.change,(function(){return e.reset()}))},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(r){switch(r.length){case 1:var e=i.__read(r,1)[0];return null!=(a=this._mapping.get(e))?a.value:NaN;case 2:var t=i.__read(r,2),n=(e=t[0],t[1]);if(null!=(a=this._mapping.get(e)))if(null!=(o=a.mapping.get(n)))return o.value;return NaN;case 3:var a,o,s=i.__read(r,3),l=(e=s[0],n=s[1],s[2]);if(null!=(a=this._mapping.get(e)))if(null!=(o=a.mapping.get(n))){var u=o.mapping.get(l);if(null!=u)return u.value}return NaN;default:_.unreachable()}},e.prototype.synthetic=function(r){if(c.isNumber(r))return r;if(c.isString(r))return this._lookup([r]);var e=0,t=r[r.length-1];return c.isNumber(t)&&(e=t,r=r.slice(0,-1)),this._lookup(r)+e},e.prototype.v_synthetic=function(r){for(var e=r.length,t=new u.ScreenArray(e),n=0;n<e;n++)t[n]=this.synthetic(r[n]);return t},e.prototype._init=function(r){var e=this,t=function(){var r,t,n,a;if(p.every(e.factors,c.isString)){var o=e.factors,s=i.__read(d(o,e.factor_padding),2);return{levels:1,mapping:s[0],tops:null,mids:null,inside_padding:s[1]}}if(p.every(e.factors,(function(r){return c.isArray(r)&&2==r.length&&c.isString(r[0])&&c.isString(r[1])}))){o=e.factors;var l=i.__read(g(o,e.group_padding,e.factor_padding),2),u=l[0],v=l[1],h=i.__spreadArray([],i.__read(u.keys()));return{levels:2,mapping:u,tops:h,mids:null,inside_padding:v}}if(p.every(e.factors,(function(r){return c.isArray(r)&&3==r.length&&c.isString(r[0])&&c.isString(r[1])&&c.isString(r[2])}))){o=e.factors;var y=i.__read(f(o,e.group_padding,e.subgroup_padding,e.factor_padding),2),m=y[0],S=y[1],b=i.__spreadArray([],i.__read(m.keys())),w=[];try{for(var x=i.__values(m),A=x.next();!A.done;A=x.next()){var N=i.__read(A.value,2),F=N[0],k=N[1];try{for(var M=(n=void 0,i.__values(k.mapping.keys())),R=M.next();!R.done;R=M.next()){var T=R.value;w.push([F,T])}}catch(r){n={error:r}}finally{try{R&&!R.done&&(a=M.return)&&a.call(M)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{A&&!A.done&&(t=x.return)&&t.call(x)}finally{if(r)throw r.error}}return{levels:3,mapping:m,tops:b,mids:w,inside_padding:S}}_.unreachable()}(),n=t.levels,a=t.mapping,o=t.tops,s=t.mids,l=t.inside_padding;this._mapping=a,this.tops=o,this.mids=s;var u=0,v=this.factors.length+l;if("percent"==this.range_padding_units){var h=(v-u)*this.range_padding/2;u-=h,v+=h}else u-=this.range_padding,v+=this.range_padding;this.setv({start:u,end:v,levels:n},{silent:r}),"auto"==this.bounds&&this.setv({bounds:[u,v]},{silent:!0})},e}(o.Range);t.FactorRange=v,v.__name__="FactorRange",v.init_FactorRange()},
function _(t,e,s,i,a){i();var n=t(1),r=t(184),o=t(227),_=t(163),l=t(135),d=t(139),h=t(228),u=n.__importStar(t(133)),c=t(125),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){var e,s,i,a,r;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return n.sent(),e=this.model,s=e.start,i=e.end,null==s?[3,3]:(a=this,[4,h.build_view(s,{parent:this})]);case 2:a.start=n.sent(),n.label=3;case 3:return null==i?[3,5]:(r=this,[4,h.build_view(i,{parent:this})]);case 4:r.end=n.sent(),n.label=5;case 5:return[2]}}))}))},e.prototype.set_data=function(e){var s,i;t.prototype.set_data.call(this,e),null===(s=this.start)||void 0===s||s.set_data(e),null===(i=this.end)||void 0===i||i.set_data(e)},e.prototype.remove=function(){var e,s;null===(e=this.start)||void 0===e||e.remove(),null===(s=this.end)||void 0===s||s.remove(),t.prototype.remove.call(this)},e.prototype.map_data=function(){var t=this.plot_view.frame;"data"==this.model.start_units?(this._sx_start=this.coordinates.x_scale.v_compute(this._x_start),this._sy_start=this.coordinates.y_scale.v_compute(this._y_start)):(this._sx_start=t.bbox.xview.v_compute(this._x_start),this._sy_start=t.bbox.yview.v_compute(this._y_start)),"data"==this.model.end_units?(this._sx_end=this.coordinates.x_scale.v_compute(this._x_end),this._sy_end=this.coordinates.y_scale.v_compute(this._y_end)):(this._sx_end=t.bbox.xview.v_compute(this._x_end),this._sy_end=t.bbox.yview.v_compute(this._y_end));for(var e=this,s=e._sx_start,i=e._sy_start,a=e._sx_end,n=e._sy_end,r=s.length,o=this._angles=new d.ScreenArray(r),_=0;_<r;_++)o[_]=Math.PI/2+c.atan2([s[_],i[_]],[a[_],n[_]])},e.prototype.paint=function(t){for(var e=this.start,s=this.end,i=this,a=i._sx_start,n=i._sy_start,r=i._sx_end,o=i._sy_end,_=i._angles,l=this.plot_view.frame.bbox,d=l.x,h=l.y,u=l.width,c=l.height,p=0,v=a.length;p<v;p++)null!=s&&(t.save(),t.translate(r[p],o[p]),t.rotate(_[p]),s.render(t,p),t.restore()),null!=e&&(t.save(),t.translate(a[p],n[p]),t.rotate(_[p]+Math.PI),e.render(t,p),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(d,h,u,c),null!=s&&(t.save(),t.translate(r[p],o[p]),t.rotate(_[p]),s.clip(t,p),t.restore()),null!=e&&(t.save(),t.translate(a[p],n[p]),t.rotate(_[p]+Math.PI),e.clip(t,p),t.restore()),t.closePath(),t.clip()),this.visuals.line.set_vectorize(t,p),t.beginPath(),t.moveTo(a[p],n[p]),t.lineTo(r[p],o[p]),t.stroke(),t.restore())},e}(r.DataAnnotationView);s.ArrowView=p,p.__name__="ArrowView";var v=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Arrow=function(){this.prototype.default_view=p,this.mixins(_.LineVector),this.define((function(t){var e=t.Ref,s=t.Nullable;return{x_start:[u.XCoordinateSpec,{field:"x_start"}],y_start:[u.YCoordinateSpec,{field:"y_start"}],start_units:[l.SpatialUnits,"data"],start:[s(e(o.ArrowHead)),null],x_end:[u.XCoordinateSpec,{field:"x_end"}],y_end:[u.YCoordinateSpec,{field:"y_end"}],end_units:[l.SpatialUnits,"data"],end:[s(e(o.ArrowHead)),function(){return new o.OpenHead}]}}))},e}(r.DataAnnotation);s.Arrow=v,v.__name__="Arrow",v.init_Arrow()},
function _(t,n,a,e,i){e();var o=t(1),r=t(155),s=t(185),c=t(190),_=t(193),l=o.__importStar(t(133)),u=function(t){function n(){var n=t.apply(this,o.__spreadArray([],o.__read(arguments)))||this;return n._initial_set_data=!1,n}return o.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var a=function(){n.set_data(n.model.source),n.request_render()};this.connect(this.model.change,a),this.connect(this.model.source.streaming,a),this.connect(this.model.source.patching,a),this.connect(this.model.source.change,a)},n.prototype.set_data=function(t){var n,a,e,i,r=this;try{for(var s=o.__values(this.model),c=s.next();!c.done;c=s.next()){var u=c.value;if(u instanceof l.VectorSpec||u instanceof l.ScalarSpec)if(u instanceof l.BaseCoordinateSpec){var h=u.array(t);r["_"+u.attr]=h}else{var d=u.uniform(t);r[""+u.attr]=d}}}catch(t){n={error:t}}finally{try{c&&!c.done&&(a=s.return)&&a.call(s)}finally{if(n)throw n.error}}this.plot_model.use_map&&(null!=r._x&&_.inplace.project_xy(r._x,r._y),null!=r._xs&&_.inplace.project_xsys(r._xs,r._ys));try{for(var f=o.__values(this.visuals),p=f.next();!p.done;p=f.next()){p.value.update()}}catch(t){e={error:t}}finally{try{p&&!p.done&&(i=f.return)&&i.call(f)}finally{if(e)throw e.error}}},n.prototype._render=function(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)},n}(r.AnnotationView);a.DataAnnotationView=u,u.__name__="DataAnnotationView";var h=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.init_DataAnnotation=function(){this.define((function(t){return{source:[(0,t.Ref)(s.ColumnarDataSource),function(){return new c.ColumnDataSource}]}}))},n}(r.Annotation);a.DataAnnotation=h,h.__name__="DataAnnotation",h.init_DataAnnotation()},
function _(t,n,e,r,i){r();var a=t(1),o=t(186),l=t(130),u=t(134),c=t(188),s=t(123),h=t(124),f=t(128),p=t(187),g=t(189),y=t(144),d=function(t){function n(n){var e=t.call(this,n)||this;return e.selection_manager=new c.SelectionManager(e),e}return a.__extends(n,t),n.prototype.get_array=function(t){var n=this.data[t];return null==n?this.data[t]=n=[]:s.isArray(n)||(this.data[t]=n=Array.from(n)),n},n.init_ColumnarDataSource=function(){this.define((function(t){return{selection_policy:[(0,t.Ref)(g.SelectionPolicy),function(){return new g.UnionRenderers}]}})),this.internal((function(t){return{inspected:[(0,t.AnyRef)(),function(){return new p.Selection}]}}))},n.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new l.Signal0(this,"select"),this.inspect=new l.Signal(this,"inspect"),this.streaming=new l.Signal0(this,"streaming"),this.patching=new l.Signal(this,"patching")},n.prototype.get_column=function(t){var n=this.data[t];return null!=n?n:null},n.prototype.columns=function(){return f.keys(this.data)},n.prototype.get_length=function(t){void 0===t&&(t=!0);var n=h.uniq(f.values(this.data).map((function(t){return y.is_NDArray(t)?t.shape[0]:t.length})));switch(n.length){case 0:return null;case 1:return n[0];default:var e="data source has columns of inconsistent lengths";if(t)return u.logger.warn(e),n.sort()[0];throw new Error(e)}},Object.defineProperty(n.prototype,"length",{get:function(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0},enumerable:!1,configurable:!0}),n.prototype.clear=function(){var t,n,e={};try{for(var r=a.__values(this.columns()),i=r.next();!i.done;i=r.next()){var o=i.value;e[o]=new this.data[o].constructor(0)}}catch(n){t={error:n}}finally{try{i&&!i.done&&(n=r.return)&&n.call(r)}finally{if(t)throw t.error}}this.data=e},n}(o.DataSource);e.ColumnarDataSource=d,d.__name__="ColumnarDataSource",d.init_ColumnarDataSource()},
function _(n,e,t,i,c){i();var u=n(1),o=n(168),r=n(187),a=function(n){function e(e){return n.call(this,e)||this}return u.__extends(e,n),e.init_DataSource=function(){this.define((function(n){return{selected:[(0,n.Ref)(r.Selection),function(){return new r.Selection}]}}))},e}(o.Model);t.DataSource=a,a.__name__="DataSource",a.init_DataSource()},
function _(i,e,t,n,s){n();var c=i(1),l=i(168),h=i(124),d=i(128),_=function(i){function e(e){return i.call(this,e)||this}return c.__extends(e,i),e.prototype.get_view=function(){return this.view},e.init_Selection=function(){this.define((function(i){var e=i.Int,t=i.Array,n=i.Dict;return{indices:[t(e),[]],line_indices:[t(e),[]],multiline_indices:[n(t(e)),{}]}})),this.internal((function(i){var e=i.Int,t=i.Array,n=i.AnyRef,s=i.Struct,c=i.Nullable;return{selected_glyphs:[t(n()),[]],view:[c(n()),null],image_indices:[t(s({index:e,dim1:e,dim2:e,flat_index:e})),[]]}}))},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!1,configurable:!0}),e.prototype.add_to_selected_glyphs=function(i){this.selected_glyphs.push(i)},e.prototype.update=function(i,e,t){switch(void 0===e&&(e=!0),void 0===t&&(t="replace"),t){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}},e.prototype.clear=function(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(i){this.indices=h.union(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(i){this.indices=h.intersection(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_subtraction=function(i){this.indices=h.difference(this.indices,i.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=d.merge(i.multiline_indices,this.multiline_indices)},e}(l.Model);t.Selection=_,_.__name__="Selection",_.init_Selection()},
function _(e,t,r,o,n){o();var i=e(1),c=e(187);function l(e){return"GlyphRenderer"==e.model.type}function s(e){return"GraphRenderer"==e.model.type}var a=function(){function e(e){this.source=e,this.inspectors=new Map}return e.prototype.select=function(e,t,r,o){var n,c,a,p;void 0===o&&(o="replace");var u=[],_=[];try{for(var h=i.__values(e),d=h.next();!d.done;d=h.next()){l(m=d.value)?u.push(m):s(m)&&_.push(m)}}catch(e){n={error:e}}finally{try{d&&!d.done&&(c=h.return)&&c.call(h)}finally{if(n)throw n.error}}var y=!1;try{for(var f=i.__values(_),v=f.next();!v.done;v=f.next()){var m,g=(m=v.value).model.selection_policy.hit_test(t,m);y=y||m.model.selection_policy.do_selection(g,m.model,r,o)}}catch(e){a={error:e}}finally{try{v&&!v.done&&(p=f.return)&&p.call(f)}finally{if(a)throw a.error}}if(u.length>0){g=this.source.selection_policy.hit_test(t,u);y=y||this.source.selection_policy.do_selection(g,this.source,r,o)}return y},e.prototype.inspect=function(e,t){var r=!1;if(l(e)){if(null!=(n=e.hit_test(t))){r=!n.is_empty();var o=this.get_or_create_inspector(e.model);o.update(n,!0,"replace"),this.source.setv({inspected:o},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(s(e)){var n=e.model.inspection_policy.hit_test(t,e);r=r||e.model.inspection_policy.do_inspection(n,t,e,!1,"replace")}return r},e.prototype.clear=function(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()},e.prototype.get_or_create_inspector=function(e){var t=this.inspectors.get(e);return null==t&&(t=new c.Selection,this.inspectors.set(e,t)),t},e}();r.SelectionManager=a,a.__name__="SelectionManager"},
function _(e,r,t,n,l){n();var o=e(1),u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.do_selection=function(e,r,t,n){return null!=e&&(r.selected.update(e,t,n),r._select.emit(),!r.selected.is_empty())},r}(e(168).Model);t.SelectionPolicy=u,u.__name__="SelectionPolicy";var a=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=o.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!=c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=o.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_intersection(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.IntersectRenderers=a,a.__name__="IntersectRenderers";var i=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=o.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!=c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=o.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_union(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.UnionRenderers=i,i.__name__="UnionRenderers"},
function _(t,r,e,n,a){n();var i=t(1),o=t(185),l=t(123),u=t(128),s=i.__importStar(t(191)),c=t(192),d=t(150);function h(t,r,e){if(l.isArray(t)){var n=t.concat(r);return null!=e&&n.length>e?n.slice(-e):n}if(l.isTypedArray(t)){var a=t.length+r.length;if(null!=e&&a>e){var i=a-e,o=t.length;n=void 0;t.length<e?(n=new t.constructor(e)).set(t,0):n=t;for(var u=i,c=o;u<c;u++)n[u-i]=n[u];for(u=0,c=r.length;u<c;u++)n[u+(o-i)]=r[u];return n}var d=new t.constructor(r);return s.concat(t,d)}throw new Error("unsupported array types")}function _(t,r){var e,n,a;return l.isNumber(t)?(e=t,a=t+1,n=1):(e=null!=t.start?t.start:0,a=null!=t.stop?t.stop:r,n=null!=t.step?t.step:1),[e,a,n]}function f(t,r){var e,n,a=new Set,o=!1;try{for(var u=i.__values(r),s=u.next();!s.done;s=u.next()){var c=i.__read(s.value,2),d=c[0],h=c[1],f=void 0,v=void 0,m=void 0,y=void 0;if(l.isArray(d)){var p=i.__read(d,1)[0];a.add(p),f=t[p].shape,v=t[p],y=h,2===d.length?(f=[1,f[0]],m=[d[0],0,d[1]]):m=d}else l.isNumber(d)?(y=[h],a.add(d)):(y=h,o=!0),m=[0,0,d],f=[1,t.length],v=t;var g=0,w=i.__read(_(m[1],f[0]),3),S=w[0],x=w[1],C=w[2],D=i.__read(_(m[2],f[1]),3),A=D[0],E=D[1],b=D[2];for(p=S;p<x;p+=C)for(var N=A;N<E;N+=b)o&&a.add(N),v[p*f[1]+N]=y[g],g++}}catch(t){e={error:t}}finally{try{s&&!s.done&&(n=u.return)&&n.call(u)}finally{if(e)throw e.error}}return a}e.stream_to_column=h,e.slice=_,e.patch_to_column=f;var v=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.init_ColumnDataSource=function(){this.define((function(t){return{data:[(0,t.Dict)(t.Any),{}]}}))},r.prototype.stream=function(t,r,e){var n,a,o=this.data;try{for(var l=i.__values(u.entries(t)),s=l.next();!s.done;s=l.next()){var c=i.__read(s.value,2),_=c[0],f=c[1];o[_]=h(o[_],f,r)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}if(this.setv({data:o},{silent:!0}),this.streaming.emit(),null!=this.document){var v=new d.ColumnsStreamedEvent(this.document,this.ref(),t,r);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:v})}},r.prototype.patch=function(t,r){var e,n,a=this.data,o=new Set;try{for(var l=i.__values(u.entries(t)),s=l.next();!s.done;s=l.next()){var h=i.__read(s.value,2),_=h[0],v=h[1];o=c.union(o,f(a[_],v))}}catch(t){e={error:t}}finally{try{s&&!s.done&&(n=l.return)&&n.call(l)}finally{if(e)throw e.error}}if(this.setv({data:a},{silent:!0}),this.patching.emit(i.__spreadArray([],i.__read(o))),null!=this.document){var m=new d.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:r,hint:m})}},r}(o.ColumnarDataSource);e.ColumnDataSource=v,v.__name__="ColumnDataSource",v.init_ColumnDataSource()},
function _(r,e,n,t,a){t();var l=r(1);n.concat=function(r){for(var e,n,t,a,o=[],c=1;c<arguments.length;c++)o[c-1]=arguments[c];var v=r.length;try{for(var f=l.__values(o),u=f.next();!u.done;u=f.next()){v+=(s=u.value).length}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=f.return)&&n.call(f)}finally{if(e)throw e.error}}var h=new r.constructor(v);h.set(r,0);var i=r.length;try{for(var y=l.__values(o),g=y.next();!g.done;g=y.next()){var s=g.value;h.set(s,i),i+=s.length}}catch(r){t={error:r}}finally{try{g&&!g.done&&(a=y.return)&&a.call(y)}finally{if(t)throw t.error}}return h}},
function _(r,e,n,a,t){a();var l=r(1);function o(){for(var r,e,n,a,t=[],o=0;o<arguments.length;o++)t[o]=arguments[o];var f=new Set;try{for(var v=l.__values(t),i=v.next();!i.done;i=v.next()){var u=i.value;try{for(var c=(n=void 0,l.__values(u)),y=c.next();!y.done;y=c.next()){var d=y.value;f.add(d)}}catch(r){n={error:r}}finally{try{y&&!y.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{i&&!i.done&&(e=v.return)&&e.call(v)}finally{if(r)throw r.error}}return f}n.union=o,n.intersection=function(r){for(var e,n,a,t,o=[],f=1;f<arguments.length;f++)o[f-1]=arguments[f];var v=new Set;try{r:for(var i=l.__values(r),u=i.next();!u.done;u=i.next()){var c=u.value;try{for(var y=(a=void 0,l.__values(o)),d=y.next();!d.done;d=y.next()){var _=d.value;if(!_.has(c))continue r}}catch(r){a={error:r}}finally{try{d&&!d.done&&(t=y.return)&&t.call(y)}finally{if(a)throw a.error}}v.add(c)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=i.return)&&n.call(i)}finally{if(e)throw e.error}}return v},n.difference=function(r){for(var e,n,a=[],t=1;t<arguments.length;t++)a[t-1]=arguments[t];var f=new Set(r);try{for(var v=l.__values(o.apply(void 0,l.__spreadArray([],l.__read(a)))),i=v.next();!i.done;i=v.next()){var u=i.value;f.delete(u)}}catch(r){e={error:r}}finally{try{i&&!i.done&&(n=v.return)&&n.call(v)}finally{if(e)throw e.error}}return f}},
function _(n,r,e,t,a){t();var i=n(1),l=i.__importDefault(n(194)),o=i.__importDefault(n(195)),u=n(139),c=new o.default("GOOGLE"),_=new o.default("WGS84"),f=l.default(_,c);e.wgs84_mercator={compute:function(n,r){return isFinite(n)&&isFinite(r)?f.forward([n,r]):[NaN,NaN]},invert:function(n,r){return isFinite(n)&&isFinite(r)?f.inverse([n,r]):[NaN,NaN]}};var p={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},v={lon:[-180,180],lat:[-85.06,85.06]},s=Math.min,g=Math.max;function h(n,r){var t=s(n.length,r.length),a=u.infer_type(n,r),i=new a(t),l=new a(t);return e.inplace.project_xy(n,r,i,l),[i,l]}e.clip_mercator=function(n,r,e){var t=i.__read(p[e],2),a=t[0],l=t[1];return[g(n,a),s(r,l)]},e.in_bounds=function(n,r){var e=i.__read(v[r],2),t=e[0],a=e[1];return t<n&&n<a},function(n){function r(n,r,t,a){var l=s(n.length,r.length);t=null!=t?t:n,a=null!=a?a:r;for(var o=0;o<l;o++){var u=n[o],c=r[o],_=i.__read(e.wgs84_mercator.compute(u,c),2),f=_[0],p=_[1];t[o]=f,a[o]=p}}n.project_xy=r,n.project_xsys=function(n,e,t,a){var i=s(n.length,e.length);t=null!=t?t:n,a=null!=a?a:e;for(var l=0;l<i;l++)r(n[l],e[l],t[l],a[l])}}(e.inplace||(e.inplace={})),e.project_xy=h,e.project_xsys=function(n,r){for(var e=s(n.length,r.length),t=new Array(e),a=new Array(e),l=0;l<e;l++){var o=i.__read(h(n[l],r[l]),2),u=o[0],c=o[1];t[l]=u,a[l]=c}return[t,a]}},
function _(e,n,t,r,o){r();var a=e(1),i=a.__importDefault(e(195)),c=a.__importDefault(e(221)),u=i.default("WGS84");function f(e,n,t){var r,o,a;return Array.isArray(t)?(r=c.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=c.default(e,n,t),2===(a=Object.keys(t)).length||a.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:i.default(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t){return f(e,n,t)},inverse:function(t){return f(n,e,t)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();var l=t(1),u=l.__importDefault(t(196)),r=l.__importDefault(t(207)),d=l.__importDefault(t(208)),f=t(216),o=l.__importDefault(t(218)),p=l.__importDefault(t(219)),m=l.__importDefault(t(203)),n=t(220);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=u.default(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=m.default(o.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=f.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),d=f.eccentricity(l.a,l.b,l.rf,a.R_A),_=n.getNadgrids(a.nadgrids),c=a.datum||p.default(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);r.default(this,a),r.default(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,u,n,e){n();var f=t(1),i=f.__importDefault(t(197)),a=f.__importDefault(t(204)),o=f.__importDefault(t(199)),l=f.__importDefault(t(203));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];u.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=a.default(t);if(function(t){var r=l.default(t,"authority");if(r){var u=l.default(r,"epsg");return u&&d.indexOf(u)>-1}}(r))return i.default["EPSG:3857"];var u=function(t){var r=l.default(t,"extension");if(r)return l.default(r,"proj4")}(r);return u?o.default(u):r}return function(t){return"+"===t[0]}(t)?o.default(t):void 0}},
function _(t,r,i,e,n){e();var a=t(1),f=a.__importDefault(t(198)),l=a.__importDefault(t(199)),u=a.__importDefault(t(204));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=l.default(arguments[1]):o[t]=u.default(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}f.default(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();var e=t(1),r=t(200),i=e.__importDefault(t(201)),f=e.__importDefault(t(202)),l=e.__importDefault(t(203));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=l.default(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=l.default(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,d){o();var r=e(1),n=r.__importDefault(e(205)),l=e(206);function i(e){return.017453292519943295*e}t.default=function(e){var a=n.default(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var d={};return l.sExpr(a,d),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var d=e.AXIS[t][0].toLowerCase();-1!==d.indexOf("north")?a+="n":-1!==d.indexOf("south")?a+="s":-1!==d.indexOf("east")?a+="e":-1!==d.indexOf("west")&&(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function n(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",n],["y0","false_northing",n],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(a){return t=e,d=(o=a)[0],r=o[1],void(!(d in t)&&r in t&&(t[d]=t[r],3===o.length&&(t[d]=o[2](t[d]))));var t,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(d),d}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,a,e,o,n){o();var r=t(1),f=r.__importDefault(t(209)),u=r.__importDefault(t(215)),i=[f.default,u.default],d={},c=[];function l(t,a){var e=c.length;return t.names?(c[e]=t,t.names.forEach((function(t){d[t.toLowerCase()]=e})),this):(console.log(a),!0)}function s(t){if(!t)return!1;var a=t.toLowerCase();return void 0!==d[a]&&c[d[a]]?c[d[a]]:void 0}function v(){i.forEach(l)}e.add=l,e.get=s,e.start=v,e.default={start:v,add:l,get:s}},
function _(t,i,s,h,a){h();var e=t(1),r=e.__importDefault(t(210)),n=e.__importDefault(t(211)),l=e.__importDefault(t(213)),u=e.__importDefault(t(214)),o=t(200);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=r.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=l.default(this.e,a,e);i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=u.default(this.e,e)))return null}return i=n.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,a,u,f,n){f();var e=t(1),r=t(200),_=e.__importDefault(t(212));u.default=function(t){return Math.abs(t)<=r.SPI?t:t-_.default(t)*r.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,a,n,r,u){r();var f=t(200);n.default=function(t,a,n){var r=t*n,u=.5*t;return r=Math.pow((1-r)/(1+r),u),Math.tan(.5*(f.HALF_PI-a))/r}},
function _(a,t,n,r,f){r();var h=a(200);n.default=function(a,t){for(var n,r,f=.5*a,u=h.HALF_PI-2*Math.atan(t),M=0;M<=15;M++)if(n=a*Math.sin(u),u+=r=h.HALF_PI-2*Math.atan(t*Math.pow((1-n)/(1+n),f))-u,Math.abs(r)<=1e-10)return u;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(r,t,e,a,f){a();var n=r(1),i=r(200),u=n.__importStar(r(217)),c=n.__importDefault(r(203));e.eccentricity=function(r,t,e,a){var f=r*r,n=t*t,u=(f-n)/f,c=0;return a?(f=(r*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*r,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(f-n)/n}},e.sphere=function(r,t,e,a,f){if(!r){var n=c.default(u.default,a);n||(n=u.WGS84),r=n.a,t=n.b,e=n.rf}return e&&!t&&(t=(1-1/e)*r),(0===e||Math.abs(r-t)<i.EPSLN)&&(f=!0,t=r),{a:r,b:t,rf:e,sphere:f}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();var d=a(200);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r();var u={};function l(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function o(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[o(t.longitudeShift),o(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function s(t,e,n,r){for(var i=e+176,u=[],l=0;l<n.gridNodeCount;l++){var o={latitudeShift:t.getFloat32(i+16*l,r),longitudeShift:t.getFloat32(i+16*l+4,r),latitudeAccuracy:t.getFloat32(i+16*l+8,r),longitudeAccuracy:t.getFloat32(i+16*l+12,r)};u.push(o)}return u}n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;11!==(e=t.getInt32(8,!0))&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r);i.nSubgrids>1&&console.log("Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored");var l={header:i,subgrids:function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var l=g(t,r,n),a=s(t,r,l,n),f=Math.round(1+(l.upperLongitude-l.lowerLongitude)/l.longitudeInterval),c=Math.round(1+(l.upperLatitude-l.lowerLatitude)/l.latitudeInterval);i.push({ll:[o(l.lowerLongitude),o(l.lowerLatitude)],del:[o(l.longitudeInterval),o(l.latitudeInterval)],lim:[f,c],count:l.gridNodeCount,cvs:d(a)})}return i}(n,i,r)};return u[t]=l,l},n.getNadgrids=function(t){return void 0===t?null:t.split(",").map(l)}},
function _(t,e,a,r,u){r();var m=t(1),_=t(200),o=m.__importDefault(t(222)),d=m.__importDefault(t(224)),f=m.__importDefault(t(195)),i=m.__importDefault(t(225)),n=m.__importDefault(t(226));a.default=function t(e,a,r){var u;if(Array.isArray(r)&&(r=i.default(r)),n.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,u=new f.default("WGS84"),r),e=u),"enu"!==e.axis&&(r=d.default(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;if(e.from_greenwich&&(r.x+=e.from_greenwich),r=o.default(e.datum,a.datum,r))return a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?d.default(a,!0,r):r}},
function _(r,e,t,a,i){a();var l=r(1),n=r(200),o=r(223),u=l.__importDefault(r(211));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;for(var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[],o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid){var d=u.grid.subgrids[0],s=(Math.abs(d.del[1])+Math.abs(d.del[0]))/1e4,f=d.ll[0]-s,x=d.ll[1]-s,m=d.ll[0]+(d.lim[0]-1)*d.del[0]+s,N=d.ll[1]+(d.lim[1]-1)*d.del[1]+s;if(!(x>a.y||f>a.x||N<a.y||m<a.x||(i=y(a,e,d),isNaN(i.x))))break}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=u.default(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=u.default(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],_=e.cvs[t][1],c=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+c*x,u.y=v*s+g*f+S*_+c*m,u}t.default=function(r,e,t){if(o.compareDatums(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;if(e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED),i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;if(t=o.geodeticToGeocentric(t,i,a),d(r.datum_type)&&(t=o.geocentricToWgs84(t,r.datum_type,r.datum_params)),d(e.datum_type)&&(t=o.geocentricFromWgs84(t,e.datum_type,e.datum_params)),t=o.geocentricToGeodetic(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT&&0!==s(e,!0,t))return;return t},t.applyGridShift=s},
function _(a,t,r,m,u){m();var s=a(200);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===s.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==s.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-s.HALF_PI&&d>-1.001*s.HALF_PI)d=-s.HALF_PI;else if(d>s.HALF_PI&&d<1.001*s.HALF_PI)d=s.HALF_PI;else{if(d<-s.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>s.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),e=Math.cos(d),_=u*u,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,_,e,n,d,i,p,P,y,z,M,A,o,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(u=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),u/r<h){if(c=0,_/r<h)return s.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=u/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,o=0;do{o++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=u*P+F*y-p*(1-t*y*y))),A=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(A*A>1e-24&&o<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+u,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,r,s){r(),i.default=function(e,a,i){var r,s,n,c=i.x,d=i.y,f=i.z||0,u={};for(n=0;n<3;n++)if(!a||2!==n||void 0!==i.z)switch(0===n?(r=c,s=-1!=="ew".indexOf(e.axis[n])?"x":"y"):1===n?(r=d,s=-1!=="ns".indexOf(e.axis[n])?"y":"x"):(r=f,s="z"),e.axis[n]){case"e":u[s]=r;break;case"w":u[s]=-r;break;case"n":u[s]=r;break;case"s":u[s]=-r;break;case"u":void 0!==i[s]&&(u.z=r);break;case"d":void 0!==i[s]&&(u.z=-r);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,t,n,o){n();var r=e(1),s=e(168),a=e(157),l=r.__importStar(e(160)),_=e(163),u=r.__importStar(e(133)),c=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new l.Visuals(this)},i.prototype.request_render=function(){this.parent.request_render()},Object.defineProperty(i.prototype,"canvas",{get:function(){return this.parent.canvas},enumerable:!1,configurable:!0}),i.prototype.set_data=function(e){var i,t;try{for(var n=r.__values(this.model),o=n.next();!o.done;o=n.next()){var s=o.value;if(s instanceof u.VectorSpec||s instanceof u.ScalarSpec){var a=s.uniform(e);this[""+s.attr]=a}}}catch(e){i={error:e}}finally{try{o&&!o.done&&(t=n.return)&&t.call(n)}finally{if(i)throw i.error}}},i}(a.View);t.ArrowHeadView=c,c.__name__="ArrowHeadView";var h=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_ArrowHead=function(){this.define((function(){return{size:[u.NumberSpec,25]}}))},i}(s.Model);t.ArrowHead=h,h.__name__="ArrowHead",h.init_ArrowHead();var f=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype.clip=function(e,i){this.visuals.line.set_vectorize(e,i);var t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(0,0),e.lineTo(.5*t,t)},i.prototype.render=function(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);var t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.stroke()}},i}(c);t.OpenHeadView=f,f.__name__="OpenHeadView";var p=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_OpenHead=function(){this.prototype.default_view=f,this.mixins(_.LineVector)},i}(h);t.OpenHead=p,p.__name__="OpenHead",p.init_OpenHead();var v=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype.clip=function(e,i){this.visuals.line.set_vectorize(e,i);var t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(.5*t,t)},i.prototype.render=function(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._normal(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._normal(e,i),e.stroke())},i.prototype._normal=function(e,i){var t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.closePath()},i}(c);t.NormalHeadView=v,v.__name__="NormalHeadView";var d=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_NormalHead=function(){this.prototype.default_view=v,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})},i}(h);t.NormalHead=d,d.__name__="NormalHead",d.init_NormalHead();var m=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype.clip=function(e,i){this.visuals.line.set_vectorize(e,i);var t=this.size.get(i);e.moveTo(.5*t,t),e.lineTo(.5*t,-2),e.lineTo(-.5*t,-2),e.lineTo(-.5*t,t),e.lineTo(0,.5*t),e.lineTo(.5*t,t)},i.prototype.render=function(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._vee(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._vee(e,i),e.stroke())},i.prototype._vee=function(e,i){var t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,t),e.lineTo(0,0),e.lineTo(-.5*t,t),e.lineTo(0,.5*t),e.closePath()},i}(c);t.VeeHeadView=m,m.__name__="VeeHeadView";var T=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_VeeHead=function(){this.prototype.default_view=m,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})},i}(h);t.VeeHead=T,T.__name__="VeeHead",T.init_VeeHead();var H=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype.render=function(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);var t=this.size.get(i);e.beginPath(),e.moveTo(.5*t,0),e.lineTo(-.5*t,0),e.stroke()}},i.prototype.clip=function(e,i){},i}(c);t.TeeHeadView=H,H.__name__="TeeHeadView";var y=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_TeeHead=function(){this.prototype.default_view=H,this.mixins(_.LineVector)},i}(h);t.TeeHead=y,y.__name__="TeeHead",y.init_TeeHead()},
function _(e,r,n,t,a){t();var i=e(1),l=e(124);function o(e,r,n){return i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(a){switch(a.label){case 0:return(t=new e(i.__assign(i.__assign({},n),{model:r}))).initialize(),[4,t.lazy_initialize()];case 1:return a.sent(),[2,t]}}))}))}n.build_view=function(e,r,n){return void 0===r&&(r={parent:null}),void 0===n&&(n=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(a){switch(a.label){case 0:return[4,o(n(e),e,r)];case 1:return(t=a.sent()).connect_signals(),[2,t]}}))}))},n.build_views=function(e,r,n,t){return void 0===n&&(n={parent:null}),void 0===t&&(t=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var a,u,s,c,_,f,v,d,h,y,w,b,g,x,p,m,z,k;return i.__generator(this,(function(A){switch(A.label){case 0:a=l.difference(i.__spreadArray([],i.__read(e.keys())),r);try{for(u=i.__values(a),s=u.next();!s.done;s=u.next())d=s.value,e.get(d).remove(),e.delete(d)}catch(e){g={error:e}}finally{try{s&&!s.done&&(x=u.return)&&x.call(u)}finally{if(g)throw g.error}}c=[],_=r.filter((function(r){return!e.has(r)})),A.label=1;case 1:A.trys.push([1,6,7,8]),f=i.__values(_),v=f.next(),A.label=2;case 2:return v.done?[3,5]:(d=v.value,[4,o(t(d),d,n)]);case 3:b=A.sent(),e.set(d,b),c.push(b),A.label=4;case 4:return v=f.next(),[3,2];case 5:return[3,8];case 6:return h=A.sent(),p={error:h},[3,8];case 7:try{v&&!v.done&&(m=f.return)&&m.call(f)}finally{if(p)throw p.error}return[7];case 8:try{for(y=i.__values(c),w=y.next();!w.done;w=y.next())(b=w.value).connect_signals()}catch(e){z={error:e}}finally{try{w&&!w.done&&(k=y.return)&&k.call(y)}finally{if(z)throw z.error}}return[2,c]}}))}))},n.remove_views=function(e){var r,n;try{for(var t=i.__values(e),a=t.next();!a.done;a=t.next()){var l=i.__read(a.value,2),o=l[0];l[1].remove(),e.delete(o)}}catch(e){r={error:e}}finally{try{a&&!a.done&&(n=t.return)&&n.call(t)}finally{if(r)throw r.error}}}},
function _(i,e,t,_,s){_();var n=i(1),l=i(230),r=n.__importStar(i(163)),o=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(e,i),e.prototype.paint=function(i){i.beginPath(),i.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,t=this._lower_sx.length;e<t;e++)i.lineTo(this._lower_sx[e],this._lower_sy[e]);for(e=this._upper_sx.length-1;e>=0;e--)i.lineTo(this._upper_sx[e],this._upper_sy[e]);i.closePath(),this.visuals.fill.apply(i),i.beginPath(),i.moveTo(this._lower_sx[0],this._lower_sy[0]);for(e=0,t=this._lower_sx.length;e<t;e++)i.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.apply(i),i.beginPath(),i.moveTo(this._upper_sx[0],this._upper_sy[0]);for(e=0,t=this._upper_sx.length;e<t;e++)i.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.apply(i)},e}(l.UpperLowerView);t.BandView=o,o.__name__="BandView";var h=function(i){function e(e){return i.call(this,e)||this}return n.__extends(e,i),e.init_Band=function(){this.prototype.default_view=o,this.mixins([r.Line,r.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e}(l.UpperLower);t.Band=h,h.__name__="Band",h.init_Band()},
function _(e,t,i,r,n){r();var o=e(1),p=e(184),s=e(135),_=o.__importStar(e(133)),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.map_data=function(){var e,t,i,r=this.plot_view.frame,n=this.model.dimension,p=this.coordinates.x_scale,s=this.coordinates.y_scale,_="height"==n?s:p,a="height"==n?p:s,u="height"==n?r.bbox.yview:r.bbox.xview,h="height"==n?r.bbox.xview:r.bbox.yview;e="data"==this.model.properties.lower.units?_.v_compute(this._lower):u.v_compute(this._lower),t="data"==this.model.properties.upper.units?_.v_compute(this._upper):u.v_compute(this._upper),i="data"==this.model.properties.base.units?a.v_compute(this._base):h.v_compute(this._base);var c=o.__read("height"==n?[1,0]:[0,1],2),l=c[0],d=c[1],m=[e,i],w=[t,i];this._lower_sx=m[l],this._lower_sy=m[d],this._upper_sx=w[l],this._upper_sy=w[d]},t}(p.DataAnnotationView);i.UpperLowerView=a,a.__name__="UpperLowerView";var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),Object.defineProperty(t.prototype,"dimension",{get:function(){return"width"==this.obj.dimension?"x":"y"},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"units",{get:function(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"},enumerable:!1,configurable:!0}),t}(_.CoordinateSpec);i.XOrYCoordinateSpec=u,u.__name__="XOrYCoordinateSpec";var h=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_UpperLower=function(){this.define((function(){return{dimension:[s.Dimension,"height"],lower:[u,{field:"lower"}],upper:[u,{field:"upper"}],base:[u,{field:"base"}]}}))},t}(p.DataAnnotation);i.UpperLower=h,h.__name__="UpperLower",h.init_UpperLower()},
function _(t,o,n,i,e){i();var r=t(1),a=t(155),l=r.__importStar(t(163)),s=t(135),u=t(180);n.EDGE_TOLERANCE=2.5;var h=function(t){function o(){var o=t.apply(this,r.__spreadArray([],r.__read(arguments)))||this;return o.bbox=new u.BBox,o}return r.__extends(o,t),o.prototype.connect_signals=function(){var o=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return o.request_render()}))},o.prototype._render=function(){var t=this,o=this.model,n=o.left,i=o.right,e=o.top,r=o.bottom;if(null!=n||null!=i||null!=e||null!=r){var a=this.plot_view.frame,l=this.coordinates.x_scale,s=this.coordinates.y_scale,h=function(o,n,i,e,r){return null!=o?t.model.screen?o:"data"==n?i.compute(o):e.compute(o):r};this.bbox=u.BBox.from_rect({left:h(n,this.model.left_units,l,a.bbox.xview,a.bbox.left),right:h(i,this.model.right_units,l,a.bbox.xview,a.bbox.right),top:h(e,this.model.top_units,s,a.bbox.yview,a.bbox.top),bottom:h(r,this.model.bottom_units,s,a.bbox.yview,a.bbox.bottom)}),this._paint_box()}},o.prototype._paint_box=function(){var t=this.layer.ctx;t.save();var o=this.bbox,n=o.left,i=o.top,e=o.width,r=o.height;t.beginPath(),t.rect(n,i,e,r),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t),t.restore()},o.prototype.interactive_bbox=function(){var t=this.model.line_width+n.EDGE_TOLERANCE;return this.bbox.grow_by(t)},o.prototype.interactive_hit=function(t,o){return null!=this.model.in_cursor&&this.interactive_bbox().contains(t,o)},o.prototype.cursor=function(t,o){var n=this.bbox,i=n.left,e=n.right,r=n.bottom,a=n.top;return Math.abs(t-i)<3||Math.abs(t-e)<3?this.model.ew_cursor:Math.abs(o-r)<3||Math.abs(o-a)<3?this.model.ns_cursor:this.bbox.contains(t,o)?this.model.in_cursor:null},o}(a.AnnotationView);n.BoxAnnotationView=h,h.__name__="BoxAnnotationView";var c=function(t){function o(o){return t.call(this,o)||this}return r.__extends(o,t),o.init_BoxAnnotation=function(){this.prototype.default_view=h,this.mixins([l.Line,l.Fill,l.Hatch]),this.define((function(t){var o=t.Number,n=t.Nullable;return{top:[n(o),null],top_units:[s.SpatialUnits,"data"],bottom:[n(o),null],bottom_units:[s.SpatialUnits,"data"],left:[n(o),null],left_units:[s.SpatialUnits,"data"],right:[n(o),null],right_units:[s.SpatialUnits,"data"],render_mode:[s.RenderMode,"canvas"]}})),this.internal((function(t){var o=t.Boolean,n=t.String,i=t.Nullable;return{screen:[o,!1],ew_cursor:[i(n),null],ns_cursor:[i(n),null],in_cursor:[i(n),null]}})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},o.prototype.update=function(t){var o=t.left,n=t.right,i=t.top,e=t.bottom;this.setv({left:o,right:n,top:i,bottom:e,screen:!0})},o}(a.Annotation);n.BoxAnnotation=c,c.__name__="BoxAnnotation",c.init_BoxAnnotation()},
function _(t,e,i,r,n){r();var a=t(1),o=t(155),l=t(233),_=t(239),s=t(240),c=t(243),h=t(276),u=t(244),p=t(303),m=t(247),f=t(281),d=t(280),g=t(307),v=t(315),w=t(317),b=t(135),y=a.__importStar(t(163)),k=t(124),x=t(318),C=t(319),z=t(322),j=t(235),L=t(126),S=t(228),M=t(123),T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),Object.defineProperty(e.prototype,"orientation",{get:function(){return this._orientation},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var i=this.model,r=i.ticker,n=i.formatter,o=i.color_mapper;this._ticker="auto"!=r?r:function(){switch(!0){case o instanceof g.LogColorMapper:return new h.LogTicker;case o instanceof g.ScanningColorMapper:return new h.BinnedTicker({mapper:o});case o instanceof g.CategoricalColorMapper:return new h.CategoricalTicker;default:return new h.BasicTicker}}(),this._formatter="auto"!=n?n:function(){switch(!0){case e._ticker instanceof h.LogTicker:return new p.LogTickFormatter;case o instanceof g.CategoricalColorMapper:return new p.CategoricalTickFormatter;default:return new p.BasicTickFormatter}}(),this._major_range=function(){if(o instanceof g.CategoricalColorMapper){var t=o.factors;return new w.FactorRange({factors:t})}if(o instanceof d.ContinuousColorMapper){var e=o.metrics,i=e.min,r=e.max;return new w.Range1d({start:i,end:r})}L.unreachable()}(),this._major_scale=function(){if(o instanceof g.LinearColorMapper)return new v.LinearScale;if(o instanceof g.LogColorMapper)return new v.LogScale;if(o instanceof g.ScanningColorMapper){var t=o.metrics.binning;return new v.LinearInterpolationScale({binning:t})}if(o instanceof g.CategoricalColorMapper)return new v.CategoricalScale;L.unreachable()}(),this._minor_range=new w.Range1d({start:0,end:1}),this._minor_scale=new v.LinearScale;var _=y.attrs_of(this.model,"major_label_",y.Text,!0),c=y.attrs_of(this.model,"major_tick_",y.Line,!0),u=y.attrs_of(this.model,"minor_tick_",y.Line,!0),m=y.attrs_of(this.model,"title_",y.Text),f=o instanceof g.CategoricalColorMapper?s.CategoricalAxis:o instanceof g.LogColorMapper?s.LogAxis:s.LinearAxis;this._axis=new f(a.__assign(a.__assign(a.__assign({ticker:this._ticker,formatter:this._formatter,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_standoff:this.model.label_standoff,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,axis_line_color:null},_),c),u));var b=this.model.title;b&&(this._title=new l.Title(a.__assign({text:b,standoff:this.model.title_standoff},m)))},e.prototype.lazy_initialize=function(){return a.__awaiter(this,void 0,void 0,(function(){var e,i,r,n;return a.__generator(this,(function(a){switch(a.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return a.sent(),e=this,i={get parent(){return e.parent},get root(){return e.root},get frame(){return e._frame},get canvas_view(){return e.parent.canvas_view},request_layout:function(){e.parent.request_layout()}},r=this,[4,S.build_view(this._axis,{parent:i})];case 2:return r._axis_view=a.sent(),null==this._title?[3,4]:(n=this,[4,S.build_view(this._title,{parent:i})]);case 3:n._title_view=a.sent(),a.label=4;case 4:return[2]}}))}))},e.prototype.remove=function(){var e;null===(e=this._title_view)||void 0===e||e.remove(),this._axis_view.remove(),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this._ticker.change,(function(){return e.request_render()})),this.connect(this._formatter.change,(function(){return e.request_render()})),this.connect(this.model.color_mapper.metrics_change,(function(){var t=e._major_range,i=e._major_scale,r=e.model.color_mapper;if(r instanceof d.ContinuousColorMapper&&t instanceof w.Range1d){var n=r.metrics,a=n.min,o=n.max;t.setv({start:a,end:o})}if(r instanceof g.ScanningColorMapper&&i instanceof v.LinearInterpolationScale){var l=r.metrics.binning;i.binning=l}e._set_canvas_image(),e.plot_view.request_layout()}))},e.prototype._set_canvas_image=function(){var t=this,e=this.orientation,i=function(){var i=t.model.color_mapper.palette;return"vertical"==e?k.reversed(i):i}(),r=a.__read("vertical"==e?[1,i.length]:[i.length,1],2),n=r[0],o=r[1],l=this._image=document.createElement("canvas");l.width=n,l.height=o;var _=l.getContext("2d"),s=_.getImageData(0,0,n,o),c=new g.LinearColorMapper({palette:i}).rgba_mapper.v_compute(k.range(0,i.length));s.data.set(c),_.putImageData(s,0,0)},e.prototype.update_layout=function(){var t=this,e=this.model,i=e.location,r=e.width,n=e.height,o=e.padding,l=e.margin,s=a.__read(function(){if(!M.isString(i))return["end","start"];switch(i){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}}(),2),c=s[0],h=s[1],u=this._orientation=function(){var e=t.model.orientation;return"auto"==e?null!=t.panel?t.panel.is_horizontal?"horizontal":"vertical":"start"==h||"end"==h||"center"==h&&"center"==c?"vertical":"horizontal":e}(),p=new C.NodeLayout,m=new C.VStack,f=new C.VStack,d=new C.HStack,g=new C.HStack;p.absolute=!0,m.absolute=!0,f.absolute=!0,d.absolute=!0,g.absolute=!0;var v=a.__read("horizontal"==u?[t._major_scale,t._minor_scale,t._major_range,t._minor_range]:[t._minor_scale,t._major_scale,t._minor_range,t._major_range],4),w=v[0],b=v[1],y=v[2],k=v[3];this._frame=new _.CartesianFrame(w,b,y,k),p.on_resize((function(e){return t._frame.set_geometry(e)}));var L=new z.BorderLayout;this._inner_layout=L,L.absolute=!0,L.center_panel=p,L.top_panel=m,L.bottom_panel=f,L.left_panel=d,L.right_panel=g;var S,T,B,A,R={left:o,right:o,top:o,bottom:o},F=function(){if(null==t.panel){if(M.isString(i))return{left:l,right:l,top:l,bottom:l};var e=a.__read(i,2),r=e[0],n=e[1];return{left:r,right:l,top:l,bottom:n}}if(!M.isString(i)){var o=a.__read(i,2);return{left:r=o[0],right:0,top:0,bottom:n=o[1]}}}();if(L.padding=R,null!=this.panel?(S="max",T=void 0,B=void 0,A=void 0):"auto"==("horizontal"==u?r:n)?(S="fixed",T=25*this.model.color_mapper.palette.length,B={percent:.3},A={percent:.8}):(S="fit",T=void 0),"horizontal"==u){var I="auto"==r?void 0:r,q="auto"==n?25:n;L.set_sizing({width_policy:S,height_policy:"min",width:T,min_width:B,max_width:A,halign:h,valign:c,margin:F}),L.center_panel.set_sizing({width_policy:"auto"==r?"fit":"fixed",height_policy:"fixed",width:I,height:q})}else{I="auto"==r?25:r,q="auto"==n?void 0:n;L.set_sizing({width_policy:"min",height_policy:S,height:T,min_height:B,max_height:A,halign:h,valign:c,margin:F}),L.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==n?"fit":"fixed",width:I,height:q})}m.set_sizing({width_policy:"fit",height_policy:"min"}),f.set_sizing({width_policy:"fit",height_policy:"min"}),d.set_sizing({width_policy:"min",height_policy:"fit"}),g.set_sizing({width_policy:"min",height_policy:"fit"});var P=this._title_view;null!=P&&("horizontal"==u?(P.panel=new j.Panel("above"),P.update_layout(),m.children.push(P.layout)):(P.panel=new j.Panel("left"),P.update_layout(),d.children.push(P.layout)));var V=this.panel,N=null!=V&&u==V.orientation?V.side:"horizontal"==u?"below":"right",O=function(){switch(N){case"above":return m;case"below":return f;case"left":return d;case"right":return g}}(),D=this._axis_view;if(D.panel=new j.Panel(N),D.update_layout(),O.children.push(D.layout),null!=this.panel){var E=new x.Grid([{layout:L,row:0,col:0}]);E.absolute=!0,"horizontal"==u?E.set_sizing({width_policy:"max",height_policy:"min"}):E.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=E}else this.layout=this._inner_layout;var H=this.model.visible;this.layout.sizing.visible=H,this._set_canvas_image()},e.prototype._render=function(){var t,e=this.layer.ctx;e.save(),this._paint_bbox(e,this._inner_layout.bbox),this._paint_image(e,this._inner_layout.center_panel.bbox),null===(t=this._title_view)||void 0===t||t.render(),this._axis_view.render(),e.restore()},e.prototype._paint_bbox=function(t,e){var i=e.x,r=e.y,n=e.width,a=e.height;i+n>=this.parent.canvas_view.bbox.width&&(n-=1),r+a>=this.parent.canvas_view.bbox.height&&(a-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,r,n,a)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,r,n,a)),t.restore()},e.prototype._paint_image=function(t,e){var i=e.x,r=e.y,n=e.width,a=e.height;t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this._image,i,r,n,a),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(i,r,n,a)),t.restore()},e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this),i=e.children,r=void 0===i?[]:i,n=a.__rest(e,["children"]);return null!=this._title_view&&r.push(this._title_view.serializable_state()),r.push(this._axis_view.serializable_state()),a.__assign(a.__assign({},n),{children:r})},e}(o.AnnotationView);i.ColorBarView=T,T.__name__="ColorBarView";var B=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_ColorBar=function(){this.prototype.default_view=T,this.mixins([["major_label_",y.Text],["title_",y.Text],["major_tick_",y.Line],["minor_tick_",y.Line],["border_",y.Line],["bar_",y.Line],["background_",y.Fill]]),this.define((function(t){var e=t.Alpha,i=t.Number,r=t.String,n=t.Tuple,a=t.Dict,o=t.Or,l=t.Ref,_=t.Auto,s=t.Nullable;return{location:[o(b.Anchor,n(i,i)),"top_right"],orientation:[o(b.Orientation,_),"auto"],title:[s(r),null],title_standoff:[i,2],width:[o(i,_),"auto"],height:[o(i,_),"auto"],scale_alpha:[e,1],ticker:[o(l(c.Ticker),_),"auto"],formatter:[o(l(u.TickFormatter),_),"auto"],major_label_overrides:[a(r),{}],major_label_policy:[l(m.LabelingPolicy),function(){return new m.NoOverlap}],color_mapper:[l(f.ColorMapper)],label_standoff:[i,5],margin:[i,30],padding:[i,10],major_tick_in:[i,5],major_tick_out:[i,0],minor_tick_in:[i,0],minor_tick_out:[i,0]}})),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},e}(o.Annotation);i.ColorBar=B,B.__name__="ColorBar",B.init_ColorBar()},
function _(t,e,i,n,l){n();var a=t(1),o=t(234),r=t(135),s=t(238),h=a.__importStar(t(163)),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._get_location=function(){var t,e,i=this.model.offset,n=this.model.standoff/2,l=this.layout.bbox;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=l.top+n;break;case"middle":e=l.vcenter;break;case"bottom":e=l.bottom-n}switch(this.model.align){case"left":t=l.left+i;break;case"center":t=l.hcenter;break;case"right":t=l.right-i}break;case"left":switch(this.model.vertical_align){case"top":t=l.left+n;break;case"middle":t=l.hcenter;break;case"bottom":t=l.right-n}switch(this.model.align){case"left":e=l.bottom-i;break;case"center":e=l.vcenter;break;case"right":e=l.top+i}break;case"right":switch(this.model.vertical_align){case"top":t=l.right-n;break;case"middle":t=l.hcenter;break;case"bottom":t=l.left+n}switch(this.model.align){case"left":e=l.top+i;break;case"center":e=l.vcenter;break;case"right":e=l.bottom-i}}return[t,e]},e.prototype._render=function(){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=a.__read(this._get_location(),2),i=e[0],n=e[1],l=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,i,n,l)}},e.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return{width:0,height:0};var e=this.layer.ctx;return this.visuals.text.set_value(e),{width:this.layer.ctx.measureText(t).width,height:2+s.font_metrics(e.font).height*this.model.text_line_height+this.model.standoff}},e}(o.TextAnnotationView);i.TitleView=c,c.__name__="TitleView";var _=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Title=function(){this.prototype.default_view=c,this.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),this.define((function(t){var e=t.Number;return{text:[t.String,""],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[e,0],standoff:[e,10]}})),this.prototype._props.text_align.options.internal=!0,this.prototype._props.text_baseline.options.internal=!0,this.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,border_line_color:null})},e}(o.TextAnnotation);i.Title=_,_.__name__="Title",_.init_Title()},
function _(t,e,n,i,s){i();var o=t(1),a=t(155),l=t(158),r=t(135),u=t(235),c=t(238),d=t(126),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.update_layout=function(){var t=this,e=this.panel;this.layout=null!=e?new u.SideLayout(e,(function(){return t.get_size()}),!0):void 0},e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el=l.div(),this.plot_view.canvas_view.add_overlay(this.el))},e.prototype.remove=function(){null!=this.el&&l.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,(function(){return e.render()})):this.connect(this.model.change,(function(){return e.request_render()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),t.prototype.render.call(this)},e.prototype._calculate_text_dimensions=function(t,e){return[t.measureText(e).width,c.font_metrics(this.visuals.text.font_value()).height]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var n,i,s=o.__read(this._calculate_text_dimensions(t,e),2),a=s[0],l=s[1];switch(t.textAlign){case"left":n=0;break;case"center":n=-a/2;break;case"right":n=-a;break;default:d.unreachable()}switch(t.textBaseline){case"top":i=0;break;case"middle":i=-.5*l;break;case"bottom":i=-1*l;break;case"alphabetic":i=-.8*l;break;case"hanging":i=-.17*l;break;case"ideographic":i=-.83*l;break;default:d.unreachable()}return[n,i,a,l]},e.prototype._canvas_text=function(t,e,n,i,s){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(n,i),s&&t.rotate(s),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,n,i,s){var a=this.el;d.assert(null!=a),l.undisplay(a),this.visuals.text.set_value(t);var r=o.__read(this._calculate_bounding_box_dimensions(t,e),2),u=r[0],c=r[1];a.style.position="absolute",a.style.left=n+u+"px",a.style.top=i+c+"px",a.style.color=t.fillStyle,a.style.font=t.font,a.style.lineHeight="normal",s&&(a.style.transform="rotate("+s+"rad)"),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),a.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),a.style.borderStyle=t.lineDash.length<2?"solid":"dashed",a.style.borderWidth=t.lineWidth+"px",a.style.borderColor=t.strokeStyle),a.textContent=e,l.display(a)},e}(a.AnnotationView);n.TextAnnotationView=_,_.__name__="TextAnnotationView";var h=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_TextAnnotation=function(){this.define((function(){return{render_mode:[r.RenderMode,"canvas"]}}))},e}(a.Annotation);n.TextAnnotation=h,h.__name__="TextAnnotation",h.init_TextAnnotation()},
function _(e,t,r,i,n){i();var l=e(1),o=e(236),a=e(237),h=e(123),c=Math.PI/2,s={above:{parallel:0,normal:-c,horizontal:0,vertical:-c},below:{parallel:0,normal:c,horizontal:0,vertical:c},left:{parallel:-c,normal:0,horizontal:0,vertical:-c},right:{parallel:c,normal:0,horizontal:0,vertical:c}},p={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},b={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},u={above:"right",below:"left",left:"right",right:"left"},g={above:"left",below:"right",left:"right",right:"left"},f=function(){function e(e){this.side=e}return Object.defineProperty(e.prototype,"dimension",{get:function(){return"above"==this.side||"below"==this.side?0:1},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"normals",{get:function(){switch(this.side){case"above":return[0,-1];case"below":return[0,1];case"left":return[-1,0];case"right":return[1,0]}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"orientation",{get:function(){return this.is_horizontal?"horizontal":"vertical"},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_horizontal",{get:function(){return 0==this.dimension},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_vertical",{get:function(){return 1==this.dimension},enumerable:!1,configurable:!0}),e.prototype.get_label_text_heuristics=function(e){var t=this.side;return h.isString(e)?{vertical_align:p[t][e],align:b[t][e]}:{vertical_align:"center",align:(e<0?u:g)[t]}},e.prototype.get_label_angle_heuristic=function(e){return h.isString(e)?s[this.side][e]:-e},e}();r.Panel=f,f.__name__="Panel";var _=function(e){function t(t,r,i){void 0===i&&(i=!1);var n=e.call(this)||this;return n.panel=t,n.get_size=r,n.rotate=i,n.panel.is_horizontal?n.set_sizing({width_policy:"max",height_policy:"fixed"}):n.set_sizing({width_policy:"fixed",height_policy:"max"}),n}return l.__extends(t,e),t.prototype._content_size=function(){var e=this.get_size(),t=e.width,r=e.height;return!this.rotate||this.panel.is_horizontal?new o.Sizeable({width:t,height:r}):new o.Sizeable({width:r,height:t})},t.prototype.has_size_changed=function(){var e=this._content_size(),t=e.width,r=e.height;return this.panel.is_horizontal?this.bbox.height!=r:this.bbox.width!=t},t}(a.ContentLayoutable);r.SideLayout=_,_.__name__="SideLayout"},
function _(t,h,i,e,n){e();var o=t(136),r=Math.min,w=Math.max,d=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(h){var i=h.width,e=h.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=e?e:this.height})},t.prototype.expanded_to=function(h){var i=h.width,e=h.height;return new t({width:i!=1/0?w(this.width,i):this.width,height:e!=1/0?w(this.height,e):this.height})},t.prototype.expand_to=function(t){var h=t.width,i=t.height;this.width=w(this.width,h),this.height=w(this.height,i)},t.prototype.narrowed_to=function(h){var i=h.width,e=h.height;return new t({width:r(this.width,i),height:r(this.height,e)})},t.prototype.narrow_to=function(t){var h=t.width,i=t.height;this.width=r(this.width,h),this.height=r(this.height,i)},t.prototype.grow_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:this.width+i+e,height:this.height+n+o})},t.prototype.shrink_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:w(this.width-i-e,0),height:w(this.height-n-o,0)})},t.prototype.map=function(h,i){return new t({width:h(this.width),height:(null!=i?i:h)(this.height)})},t}();i.Sizeable=d,d.__name__="Sizeable",i.SizingPolicy=o.Enum("fixed","fit","min","max")},
function _(i,t,e,n,h){n();var r=i(1),o=i(236),s=i(180),u=i(123),a=Math.min,l=Math.max,g=Math.round,_=function(){function i(){this.absolute=!1,this._bbox=new s.BBox,this._inner_bbox=new s.BBox,this._dirty=!1,this._handlers=[]}return i.prototype[Symbol.iterator]=function(){return r.__generator(this,(function(i){return[2]}))},Object.defineProperty(i.prototype,"bbox",{get:function(){return this._bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"sizing",{get:function(){return this._sizing},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"visible",{set:function(i){this._sizing.visible=i,this._dirty=!0},enumerable:!1,configurable:!0}),i.prototype.set_sizing=function(i){var t,e,n,h,r,o=null!==(t=i.width_policy)&&void 0!==t?t:"fit",s=i.width,u=i.min_width,a=i.max_width,l=null!==(e=i.height_policy)&&void 0!==e?e:"fit",g=i.height,_=i.min_height,c=i.max_height,d=i.aspect,p=null!==(n=i.margin)&&void 0!==n?n:{top:0,right:0,bottom:0,left:0},f=!1!==i.visible,y=null!==(h=i.halign)&&void 0!==h?h:"start",b=null!==(r=i.valign)&&void 0!==r?r:"start";this._sizing={width_policy:o,min_width:u,width:s,max_width:a,height_policy:l,min_height:_,height:g,max_height:c,aspect:d,margin:p,visible:f,halign:y,valign:b,size:{width:s,height:g}},this._init()},i.prototype._init=function(){},i.prototype._set_geometry=function(i,t){this._bbox=i,this._inner_bbox=t},i.prototype.set_geometry=function(i,t){var e,n;this._set_geometry(i,null!=t?t:i);try{for(var h=r.__values(this._handlers),o=h.next();!o.done;o=h.next()){(0,o.value)(this._bbox,this._inner_bbox)}}catch(i){e={error:i}}finally{try{o&&!o.done&&(n=h.return)&&n.call(h)}finally{if(e)throw e.error}}},i.prototype.on_resize=function(i){this._handlers.push(i)},i.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},i.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},i.prototype.apply_aspect=function(i,t){var e=t.width,n=t.height,h=this.sizing.aspect;if(null!=h){var r=this.sizing,o=r.width_policy,s=r.height_policy;if("fixed"!=o&&"fixed"!=s)if(o==s){var u=e,a=g(e/h),l=g(n*h),_=n;Math.abs(i.width-u)+Math.abs(i.height-a)<=Math.abs(i.width-l)+Math.abs(i.height-_)?(e=u,n=a):(e=l,n=_)}else!function(i,t){var e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]}(o,s)?e=g(n*h):n=g(e/h);else"fixed"==o?n=g(e/h):"fixed"==s&&(e=g(n*h))}return{width:e,height:n}},i.prototype.measure=function(i){var t=this;if(!this.sizing.visible)return{width:0,height:0};var e=new o.Sizeable(i).shrink_by(this.sizing.margin).map((function(i){return i==1/0&&"fixed"==t.sizing.width_policy&&null!=t.sizing.width?t.sizing.width:i}),(function(i){return i==1/0&&"fixed"==t.sizing.height_policy&&null!=t.sizing.height?t.sizing.height:i})),n=this._measure(e),h=this.clip_size(n,e),s=this.apply_aspect(e,h);return r.__assign(r.__assign({},n),s)},i.prototype.compute=function(i){void 0===i&&(i={});var t={width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0},e=this.measure(t),n=e.width,h=e.height,r=new s.BBox({left:0,top:0,width:n,height:h}),o=void 0;if(null!=e.inner){var u=e.inner,a=u.left,l=u.top,g=u.right,_=u.bottom;o=new s.BBox({left:a,top:l,right:n-g,bottom:h-_})}this.set_geometry(r,o)},Object.defineProperty(i.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!1,configurable:!0}),i.prototype.clip_size=function(i,t){function e(i,t,e,n){return null==e?e=0:u.isNumber(e)||(e=Math.round(e.percent*t)),null==n?n=1/0:u.isNumber(n)||(n=Math.round(n.percent*t)),l(e,a(i,n))}return{width:e(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:e(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}},i.prototype.has_size_changed=function(){var i=this._dirty;return this._dirty=!1,i},i}();e.Layoutable=_,_.__name__="Layoutable";var c=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return r.__extends(t,i),t.prototype._measure=function(i){var t=this,e=this.sizing,n=e.width_policy,h=e.height_policy;return{width:function(){var e=t.sizing.width;if(i.width==1/0)return null!=e?e:0;switch(n){case"fixed":return null!=e?e:0;case"min":return null!=e?a(i.width,e):0;case"fit":return null!=e?a(i.width,e):i.width;case"max":return null!=e?l(i.width,e):i.width}}(),height:function(){var e=t.sizing.height;if(i.height==1/0)return null!=e?e:0;switch(h){case"fixed":return null!=e?e:0;case"min":return null!=e?a(i.height,e):0;case"fit":return null!=e?a(i.height,e):i.height;case"max":return null!=e?l(i.height,e):i.height}}()}},t}(_);e.LayoutItem=c,c.__name__="LayoutItem";var d=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return r.__extends(t,i),t.prototype._measure=function(i){var t=this,e=this._content_size(),n=i.bounded_to(this.sizing.size).bounded_to(e);return{width:function(){switch(t.sizing.width_policy){case"fixed":return null!=t.sizing.width?t.sizing.width:e.width;case"min":return e.width;case"fit":return n.width;case"max":return Math.max(e.width,n.width)}}(),height:function(){switch(t.sizing.height_policy){case"fixed":return null!=t.sizing.height?t.sizing.height:e.height;case"min":return e.height;case"fit":return n.height;case"max":return Math.max(e.height,n.height)}}()}},t}(_);e.ContentLayoutable=d,d.__name__="ContentLayoutable"},
function _(t,e,n,r,a){r();var l,u=t(1),c=t(126),i=function(){try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch(t){return!1}}()?function(t,e){return new OffscreenCanvas(t,e)}:function(t,e){var n=document.createElement("canvas");return n.width=t,n.height=e,n},o=(l=i(0,0).getContext("2d"),function(t){l.font=t;var e=l.measureText("M"),n=l.measureText("x"),r=l.measureText("ÅŚg|"),a=r.fontBoundingBoxAscent,u=r.fontBoundingBoxDescent;if(null!=a&&null!=u)return{height:a+u,ascent:a,descent:u,cap_height:e.actualBoundingBoxAscent,x_height:n.actualBoundingBoxAscent};var i=r.actualBoundingBoxAscent,o=r.actualBoundingBoxDescent;if(null!=i&&null!=o)return{height:i+o,ascent:i,descent:o,cap_height:e.actualBoundingBoxAscent,x_height:n.actualBoundingBoxAscent};c.unreachable()}),f=function(){var t=i(0,0).getContext("2d");return function(e,n){t.font=n;var r=t.measureText(e),a=r.actualBoundingBoxAscent,l=r.actualBoundingBoxDescent;if(null!=a&&null!=l)return{width:r.width,height:a+l,ascent:a,descent:l};c.unreachable()}}(),h=function(){var t=document.createElement("canvas"),e=t.getContext("2d"),n=-1,r=-1;return function(a,l){var c,i,o,f,h,s;void 0===l&&(l=1),e.font=a;var g=e.measureText("M").width*l,v=Math.ceil(g),d=Math.ceil(2*g),x=Math.ceil(1.5*g);n<v&&(n=v,t.width=v),r<d&&(r=d,t.height=d),e.save(),e.scale(l,l),e.fillStyle="#f00",e.fillRect(0,0,v,d);var y=function(t){for(var e=0,n=0;n<=x;n++)for(var r=0;r<v;r++,e+=4)if(255!=t[e])return x-n;return 0};e.font=a,e.fillStyle="#000";try{for(var m=u.__values("xa"),B=m.next();!B.done;B=m.next()){var w=B.value;e.fillText(w,0,x/l)}}catch(t){c={error:t}}finally{try{B&&!B.done&&(i=m.return)&&i.call(m)}finally{if(c)throw c.error}}var _=y(e.getImageData(0,0,v,d).data)/l;try{for(var p=u.__values("ASQ"),M=p.next();!M.done;M=p.next()){w=M.value;e.fillText(w,0,x/l)}}catch(t){o={error:t}}finally{try{M&&!M.done&&(f=p.return)&&f.call(p)}finally{if(o)throw o.error}}var T=y(e.getImageData(0,0,v,d).data)/l;try{for(var A=u.__values("ÅŚgy"),C=A.next();!C.done;C=A.next()){w=C.value;e.fillText(w,0,x/l)}}catch(t){h={error:t}}finally{try{C&&!C.done&&(s=A.return)&&s.call(A)}finally{if(h)throw h.error}}var D=e.getImageData(0,0,v,d).data,S=y(D)/l,I=function(t){for(var e=t.length-4,n=d;n>=x;n--)for(var r=0;r<v;r++,e-=4)if(255!=t[e])return n-x;return 0}(D)/l;return e.restore(),{height:S+I,ascent:S,cap_height:T,x_height:_,descent:I}}}(),s=function(){var t=document.createElement("canvas"),e=t.getContext("2d"),n=-1,r=-1;return function(a,l,u){void 0===u&&(u=1),e.font=l;var c=e.measureText("M").width*u,i=Math.ceil(c),o=Math.ceil(2*c),f=Math.ceil(1.5*c);(n<i||r<o)&&(n=i,t.width=i,r=o,t.height=o),e.save(),e.scale(u,u),e.fillStyle="#f00",e.fillRect(0,0,i,o);e.font=l,e.fillStyle="#000",e.fillText(a,0,f/u);var h=e.measureText(a),s=e.getImageData(0,0,i,o).data,g=function(t){for(var e=0,n=0;n<=f;n++)for(var r=0;r<i;r++,e+=4)if(255!=t[e])return f-n;return 0}(s)/u,v=function(t){for(var e=t.length-4,n=o;n>=f;n--)for(var r=0;r<i;r++,e-=4)if(255!=t[e])return n-f;return 0}(s)/u;return e.restore(),{width:h.width,height:g+v,ascent:g,descent:v}}}(),g=function(){try{return o("normal 10px sans-serif"),o}catch(t){return h}}(),v=function(){try{return f("A","normal 10px sans-serif"),f}catch(t){return s}}(),d=new Map;function x(t){var e=d.get(t);return null==e&&(e={font:g(t),glyphs:new Map},d.set(t,e)),e.font}n.font_metrics=x,n.glyph_metrics=function(t,e){var n=d.get(e);null==n&&(x(e),n=d.get(e));var r=n.glyphs.get(t);return null==r&&(r=v(t,e),n.glyphs.set(t,r)),r}},
function _(e,t,r,n,a){n();var s=e(1),_=e(177),o=e(176),i=e(173),c=e(178),l=e(182),g=e(180),u=e(128),f=e(126),y=function(){function e(e,t,r,n,a,s){void 0===a&&(a={}),void 0===s&&(s={}),this.in_x_scale=e,this.in_y_scale=t,this.x_range=r,this.y_range=n,this.extra_x_ranges=a,this.extra_y_ranges=s,this._bbox=new g.BBox,f.assert(null==e.source_range&&null==e.target_range),f.assert(null==t.source_range&&null==t.target_range),this._configure_scales()}return Object.defineProperty(e.prototype,"bbox",{get:function(){return this._bbox},enumerable:!1,configurable:!0}),e.prototype._get_ranges=function(e,t){return new Map(u.entries(s.__assign(s.__assign({},t),{default:e})))},e.prototype._get_scales=function(e,t,r){var n,a,i=new Map;try{for(var g=s.__values(t),u=g.next();!u.done;u=g.next()){var f=s.__read(u.value,2),y=f[0],h=f[1];if(h instanceof l.FactorRange!=e instanceof _.CategoricalScale)throw new Error("Range "+h.type+" is incompatible is Scale "+e.type);e instanceof o.LogScale&&h instanceof c.DataRange1d&&(h.scale_hint="log");var p=e.clone();p.setv({source_range:h,target_range:r}),i.set(y,p)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(a=g.return)&&a.call(g)}finally{if(n)throw n.error}}return i},e.prototype._configure_frame_ranges=function(){var e=this.bbox;this._x_target=new i.Range1d({start:e.left,end:e.right}),this._y_target=new i.Range1d({start:e.bottom,end:e.top})},e.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)},e.prototype._update_scales=function(){var e,t,r,n;this._configure_frame_ranges();try{for(var a=s.__values(this._x_scales),_=a.next();!_.done;_=a.next()){s.__read(_.value,2)[1].target_range=this._x_target}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}try{for(var o=s.__values(this._y_scales),i=o.next();!i.done;i=o.next()){s.__read(i.value,2)[1].target_range=this._y_target}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}},e.prototype.set_geometry=function(e){this._bbox=e,this._update_scales()},Object.defineProperty(e.prototype,"x_target",{get:function(){return this._x_target},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_target",{get:function(){return this._y_target},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_scales",{get:function(){return this._x_scales},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_scales",{get:function(){return this._y_scales},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_scale",{get:function(){return this._x_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_scale",{get:function(){return this._y_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"xscales",{get:function(){return u.to_object(this.x_scales)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"yscales",{get:function(){return u.to_object(this.y_scales)},enumerable:!1,configurable:!0}),e}();r.CartesianFrame=y,y.__name__="CartesianFrame"},
function _(i,s,x,A,o){A(),o("Axis",i(241).Axis),o("CategoricalAxis",i(248).CategoricalAxis),o("ContinuousAxis",i(251).ContinuousAxis),o("DatetimeAxis",i(252).DatetimeAxis),o("LinearAxis",i(253).LinearAxis),o("LogAxis",i(270).LogAxis),o("MercatorAxis",i(273).MercatorAxis)},
function _(t,e,i,r,a){r();var o=t(1),n=t(242),s=t(243),l=t(244),_=t(247),c=o.__importStar(t(163)),h=t(135),u=t(139),d=t(235),b=t(124),f=t(123),m=t(245),p=t(182),x=Math.abs,g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.update_layout=function(){var t=this;this.layout=new d.SideLayout(this.panel,(function(){return t.get_size()}),!0),this.layout.on_resize((function(){return t._coordinates=void 0}))},e.prototype.get_size=function(){var t=this.model,e=t.visible,i=t.fixed_location;if(e&&null==i&&this.is_renderable){var r=this.extents;return{width:0,height:Math.round(r.tick+r.tick_label+r.axis_label)}}return{width:0,height:0}},Object.defineProperty(e.prototype,"is_renderable",{get:function(){var t=o.__read(this.ranges,2),e=t[0],i=t[1];return e.is_valid&&i.is_valid},enumerable:!1,configurable:!0}),e.prototype._render=function(){var t;if(this.is_renderable){var e=this.tick_coords,i=this.extents,r=this.layer.ctx;r.save(),this._draw_rule(r,i),this._draw_major_ticks(r,i,e),this._draw_minor_ticks(r,i,e),this._draw_major_labels(r,i,e),this._draw_axis_label(r,i,e),null===(t=this._paint)||void 0===t||t.call(this,r,i,e),r.restore()}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_layout()}))},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!1,configurable:!0}),e.prototype._draw_rule=function(t,e){if(this.visuals.axis_line.doit){var i=o.__read(this.rule_coords,2),r=i[0],a=i[1],n=o.__read(this.coordinates.map_to_screen(r,a),2),s=n[0],l=n[1],_=o.__read(this.normals,2),c=_[0],h=_[1],u=o.__read(this.offsets,2),d=u[0],b=u[1];this.visuals.axis_line.set_value(t),t.beginPath();for(var f=0;f<s.length;f++){var m=Math.round(s[f]+c*d),p=Math.round(l[f]+h*b);t.lineTo(m,p)}t.stroke()}},e.prototype._draw_major_ticks=function(t,e,i){var r=this.model.major_tick_in,a=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,i.major,r,a,o)},e.prototype._draw_minor_ticks=function(t,e,i){var r=this.model.minor_tick_in,a=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,r,a,o)},e.prototype._draw_major_labels=function(t,e,i){var r=i.major,a=this.compute_labels(r[this.dimension]),o=this.model.major_label_orientation,n=e.tick+this.model.major_label_standoff,s=this.visuals.major_label_text;this._draw_oriented_labels(t,a,r,o,this.panel.side,n,s)},e.prototype._axis_label_extent=function(){var t=this.model.axis_label;if(!t)return 0;var e=new m.TextBox({text:t});e.angle=this.panel.get_label_angle_heuristic("parallel"),e.visuals=this.visuals.axis_label_text;var i=e.size(),r=0==this.dimension?i.height:i.width,a=this.model.axis_label_standoff;return r>0?a+r+3:0},e.prototype._draw_axis_label=function(t,e,i){var r=this,a=this.model.axis_label;if(a&&null==this.model.fixed_location){var n=new m.TextBox({text:a});n.angle=this.panel.get_label_angle_heuristic("parallel"),n.visuals=this.visuals.axis_label_text;var s=o.__read(function(){var t=r.layout.bbox;switch(r.panel.side){case"above":return[t.hcenter,t.bottom];case"below":return[t.hcenter,t.top];case"left":return[t.right,t.vcenter];case"right":return[t.left,t.vcenter]}}(),2),l=s[0],_=s[1],c=o.__read(this.normals,2),h=c[0],u=c[1],d=e.tick+e.tick_label+this.model.axis_label_standoff,b=this.panel.get_label_text_heuristics("parallel"),f=b.vertical_align,p=b.align;n.position={sx:l+h*d,sy:_+u*d,x_anchor:p,y_anchor:f},n.align=p,n.paint(t)}},e.prototype._draw_ticks=function(t,e,i,r,a){if(a.doit){var n=o.__read(e,2),s=n[0],l=n[1],_=o.__read(this.coordinates.map_to_screen(s,l),2),c=_[0],h=_[1],u=o.__read(this.normals,2),d=u[0],b=u[1],f=o.__read(this.offsets,2),m=f[0],p=f[1],x=o.__read([d*(m-i),b*(p-i)],2),g=x[0],v=x[1],y=o.__read([d*(m+r),b*(p+r)],2),k=y[0],w=y[1];a.set_value(t),t.beginPath();for(var j=0;j<c.length;j++){var P=Math.round(c[j]+k),O=Math.round(h[j]+w),T=Math.round(c[j]+g),A=Math.round(h[j]+v);t.moveTo(P,O),t.lineTo(T,A)}t.stroke()}},e.prototype._draw_oriented_labels=function(t,e,i,r,a,n,s){var l,_,c=this;if(s.doit&&0!=e.length){var h=o.__read(i,2),d=h[0],b=h[1],f=o.__read(this.coordinates.map_to_screen(d,b),2),p=f[0],x=f[1],g=o.__read(this.offsets,2),v=g[0],y=g[1],k=o.__read(this.normals,2),w=k[0]*(v+n),j=k[1]*(y+n),P=this.panel.get_label_text_heuristics(r),O=P.vertical_align,T=P.align,A=this.panel.get_label_angle_heuristic(r);e.visuals=s,e.angle=A;for(var M=0;M<e.length;M++){(C=e.items[M]).position={sx:p[M]+w,sy:x[M]+j,x_anchor:T,y_anchor:O},C instanceof m.TextBox&&(C.align=T)}var z=e.length,L=u.Indices.all_set(z),B=e.items,N=B.map((function(t){return t.bbox()})),R=o.__read(c.ranges,1)[0].is_reversed?0==c.dimension?function(t,e){return N[t].left-N[e].right}:function(t,e){return N[e].top-N[t].bottom}:0==c.dimension?function(t,e){return N[e].left-N[t].right}:function(t,e){return N[t].top-N[e].bottom},G=this.model.major_label_policy.filter(L,N,R),S=o.__spreadArray([],o.__read(G.ones()));if(0!=S.length){var V=this.parent.canvas_view.bbox,F=function(t){var e=N[t];if(e.left<0){var i=-e.left,r=B[t].position;B[t].position=o.__assign(o.__assign({},r),{sx:r.sx+i})}else if(e.right>V.width){i=e.right-V.width,r=B[t].position;B[t].position=o.__assign(o.__assign({},r),{sx:r.sx-i})}},I=function(t){var e=N[t];if(e.top<0){var i=-e.top,r=B[t].position;B[t].position=o.__assign(o.__assign({},r),{sy:r.sy+i})}else if(e.bottom>V.height){i=e.bottom-V.height,r=B[t].position;B[t].position=o.__assign(o.__assign({},r),{sy:r.sy-i})}},q=(M=S[0],S[S.length-1]);0==this.dimension?(F(M),F(q)):(I(M),I(q))}try{for(var D=o.__values(G),E=D.next();!E.done;E=D.next()){var C;M=E.value;(C=B[M]).paint(t)}}catch(t){l={error:t}}finally{try{E&&!E.done&&(_=D.return)&&_.call(D)}finally{if(l)throw l.error}}}},e.prototype._tick_extent=function(){return this.model.major_tick_out},e.prototype._tick_label_extents=function(){var t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,r=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,r,a)]},Object.defineProperty(e.prototype,"extents",{get:function(){var t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:b.sum(t),axis_label:this._axis_label_extent()}},enumerable:!1,configurable:!0}),e.prototype._oriented_labels_extent=function(t,e,i,r){if(0==t.length||!r.doit)return 0;var a=this.panel.get_label_angle_heuristic(e);t.visuals=r,t.angle=a;var o=t.max_size(),n=0==this.dimension?o.height:o.width;return n>0?i+n+3:0},Object.defineProperty(e.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!1,configurable:!0}),e.prototype.compute_labels=function(t){for(var e=this.model.formatter.format_graphics(t,this),i=this.model.major_label_overrides,r=0;r<t.length;r++){var a=i[t[r]];null!=a&&(e[r]=new m.TextBox({text:a}))}return new m.GraphicsBoxes(e)},Object.defineProperty(e.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var t=this.plot_view.frame,e=o.__read([0,0],2),i=e[0],r=e[1];switch(this.panel.side){case"below":r=x(this.layout.bbox.top-t.bbox.bottom);break;case"above":r=x(this.layout.bbox.bottom-t.bbox.top);break;case"right":i=x(this.layout.bbox.left-t.bbox.right);break;case"left":i=x(this.layout.bbox.right-t.bbox.left)}return[i,r]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"ranges",{get:function(){var t=this.dimension,e=(t+1)%2,i=this.coordinates.ranges;return[i[t],i[e]]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"computed_bounds",{get:function(){var t=o.__read(this.ranges,1)[0],e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];var r=void 0,a=void 0,n=o.__read(e,2),s=n[0],l=n[1],_=o.__read(i,2),c=_[0],h=_[1],u=Math.min,d=Math.max;return x(s-l)>x(c-h)?(r=d(u(s,l),c),a=u(d(s,l),h)):(r=u(s,l),a=d(s,l)),[r,a]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"rule_coords",{get:function(){var t=this.dimension,e=(t+1)%2,i=o.__read(this.ranges,1)[0],r=o.__read(this.computed_bounds,2),a=r[0],n=r[1],s=[new Array(2),new Array(2)];return s[t][0]=Math.max(a,i.min),s[t][1]=Math.min(n,i.max),s[t][0]>s[t][1]&&(s[t][0]=s[t][1]=NaN),s[e][0]=this.loc,s[e][1]=this.loc,s},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tick_coords",{get:function(){for(var t=this.dimension,e=(t+1)%2,i=o.__read(this.ranges,1)[0],r=o.__read(this.computed_bounds,2),a=r[0],n=r[1],s=this.model.ticker.get_ticks(a,n,i,this.loc),l=s.major,_=s.minor,c=[[],[]],h=[[],[]],u=o.__read([i.min,i.max],2),d=u[0],b=u[1],f=0;f<l.length;f++)l[f]<d||l[f]>b||(c[t].push(l[f]),c[e].push(this.loc));for(f=0;f<_.length;f++)_[f]<d||_[f]>b||(h[t].push(_[f]),h[e].push(this.loc));return{major:c,minor:h}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"loc",{get:function(){var t=this.model.fixed_location;if(null!=t){if(f.isNumber(t))return t;var e=o.__read(this.ranges,2)[1];if(e instanceof p.FactorRange)return e.synthetic(t);throw new Error("unexpected")}var i=o.__read(this.ranges,2)[1];switch(this.panel.side){case"left":case"below":return i.start;case"right":case"above":return i.end}},enumerable:!1,configurable:!0}),e.prototype.serializable_state=function(){return o.__assign(o.__assign({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box})},e}(n.GuideRendererView);i.AxisView=g,g.__name__="AxisView";var v=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Axis=function(){this.prototype.default_view=g,this.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text]]),this.define((function(t){var e=t.Any,i=t.Int,r=t.Number,a=t.String,o=t.Ref,n=t.Dict,c=t.Tuple,u=t.Or,d=t.Nullable,b=t.Auto;return{bounds:[u(c(r,r),b),"auto"],ticker:[o(s.Ticker)],formatter:[o(l.TickFormatter)],axis_label:[d(a),""],axis_label_standoff:[i,5],major_label_standoff:[i,5],major_label_orientation:[u(h.TickLabelOrientation,r),"horizontal"],major_label_overrides:[n(a),{}],major_label_policy:[o(_.LabelingPolicy),function(){return new _.AllLabels}],major_tick_in:[r,2],major_tick_out:[r,6],minor_tick_in:[r,0],minor_tick_out:[r,4],fixed_location:[d(u(r,e)),null]}})),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},e}(n.GuideRenderer);i.Axis=v,v.__name__="Axis",v.init_Axis()},
function _(e,n,r,i,t){i();var d=e(1),u=e(156),_=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return d.__extends(n,e),n}(u.RendererView);r.GuideRendererView=_,_.__name__="GuideRendererView";var R=function(e){function n(n){return e.call(this,n)||this}return d.__extends(n,e),n.init_GuideRenderer=function(){this.override({level:"guide"})},n}(u.Renderer);r.GuideRenderer=R,R.__name__="GuideRenderer",R.init_GuideRenderer()},
function _(n,e,t,i,r){i();var _=n(1),c=function(n){function e(e){return n.call(this,e)||this}return _.__extends(e,n),e}(n(168).Model);t.Ticker=c,c.__name__="Ticker"},
function _(t,o,n,r,e){r();var u=t(1),c=t(168),i=t(245),a=function(t){function o(o){return t.call(this,o)||this}return u.__extends(o,t),o.prototype.format_graphics=function(t,o){return this.doFormat(t,o).map((function(t){return new i.TextBox({text:t})}))},o.prototype.compute=function(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]},o.prototype.v_compute=function(t,o){return this.doFormat(t,null!=o?o:{loc:0})},o}(c.Model);n.TickFormatter=a,a.__name__="TickFormatter"},
function _(t,e,i,n,r){n();var s,o,a=t(1),h=t(180),c=t(238),u=t(124),l=t(123),_=t(246),f=t(137);i.text_width=(s=document.createElement("canvas").getContext("2d"),o="",function(t,e){return e!=o&&(o=e,s.font=e),s.measureText(t).width});var p=function(){function t(){this._position={sx:0,sy:0},this.font_size_scale=1}return Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){this._position=t},enumerable:!1,configurable:!0}),t.prototype.infer_text_height=function(){return"ascent_descent"},t.prototype.bbox=function(){var t=this.rect(),e=t.p0,i=t.p1,n=t.p2,r=t.p3,s=Math.min(e.x,i.x,n.x,r.x),o=Math.min(e.y,i.y,n.y,r.y),a=Math.max(e.x,i.x,n.x,r.x),c=Math.max(e.y,i.y,n.y,r.y);return new h.BBox({left:s,right:a,top:o,bottom:c})},t.prototype.size=function(){var t=this._size(),e=t.width,i=t.height,n=this.angle;if(n){var r=Math.cos(Math.abs(n)),s=Math.sin(Math.abs(n));return{width:Math.abs(e*r+i*s),height:Math.abs(e*s+i*r)}}return{width:e,height:i}},t.prototype.rect=function(){var t=this._rect(),e=this.angle;if(e){var i=this.position,n=i.sx,r=i.sy,s=new _.AffineTransform;return s.translate(n,r),s.rotate(e),s.translate(-n,-r),s.apply_rect(t)}return t},t.prototype.paint_rect=function(t){var e=this.rect(),i=e.p0,n=e.p1,r=e.p2,s=e.p3;t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();var o=Math.round;t.moveTo(o(i.x),o(i.y)),t.lineTo(o(n.x),o(n.y)),t.lineTo(o(r.x),o(r.y)),t.lineTo(o(s.x),o(s.y)),t.closePath(),t.stroke(),t.restore()},t.prototype.paint_bbox=function(t){var e=this.bbox(),i=e.x,n=e.y,r=e.width,s=e.height;t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();var o=Math.round;t.moveTo(o(i),o(n)),t.lineTo(o(i),o(n+s)),t.lineTo(o(i+r),o(n+s)),t.lineTo(o(i+r),o(n)),t.closePath(),t.stroke(),t.restore()},t}();i.GraphicsBox=p,p.__name__="GraphicsBox";var x=function(t){function e(e){var i=e.text,n=t.call(this)||this;return n.align="left",n.text=i,n}return a.__extends(e,t),Object.defineProperty(e.prototype,"visuals",{set:function(t){var e=t.text_color.get_value(),i=t.text_alpha.get_value(),n=t.text_font_style.get_value(),r=t.text_font_size.get_value(),s=t.text_font.get_value(),o=this.font_size_scale;if(1!=o){var h=r.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=h){var c=a.__read(h,4),u=c[1],l=c[3],_=Number(u);isNaN(_)||(r=""+_*o+l)}}var p=n+" "+r+" "+s;this.font=p,this.color=f.color2css(e,i),this.line_height=t.text_line_height.get_value()},enumerable:!1,configurable:!0}),e.prototype.infer_text_height=function(){if(this.text.includes("\n"))return"ascent_descent";return function(t){var e,i;try{for(var n=a.__values(new Set(t)),r=n.next();!r.done;r=n.next()){var s=r.value;if(!("0"<=s&&s<="9"))switch(s){case",":case".":case"+":case"-":case"−":case"e":continue;default:return!1}}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}return!0}(this.text)?"cap":"ascent_descent"},e.prototype._text_line=function(t){var e,i=null!==(e=this.text_height_metric)&&void 0!==e?e:this.infer_text_height(),n=function(){switch(i){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}}(),r=function(){switch(i){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}}();return{height:n+r,ascent:n,descent:r}},Object.defineProperty(e.prototype,"nlines",{get:function(){return this.text.split("\n").length},enumerable:!1,configurable:!0}),e.prototype._size=function(){var t,e,n=this.font,r=c.font_metrics(n),s=(this.line_height-1)*r.height,o=""==this.text,a=this.text.split("\n"),h=a.length,l=a.map((function(t){return i.text_width(t,n)})),_=this._text_line(r).height*h,f="%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1,p="%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1;return{width:u.max(l)*f,height:o?0:(_+s*(h-1))*p,metrics:r}},e.prototype._computed_position=function(t,e,i){var n=this,r=t.width,s=t.height,o=this.position,a=o.sx,h=o.sy,c=o.x_anchor,u=void 0===c?"left":c,_=o.y_anchor,f=void 0===_?"center":_;return{x:a-function(){if(l.isNumber(u))return u*r;switch(u){case"left":return 0;case"center":return.5*r;case"right":return r}}(),y:h-function(){var t;if(l.isNumber(f))return f*s;switch(f){case"top":return 0;case"center":return.5*s;case"bottom":return s;case"baseline":if(1!=i)return.5*s;switch(null!==(t=n.text_height_metric)&&void 0!==t?t:n.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}}()}},e.prototype._rect=function(){var t=this._size(),e=t.width,i=t.height,n=t.metrics,r=this.text.split("\n").length,s=this._computed_position({width:e,height:i},n,r),o=s.x,a=s.y;return new h.BBox({x:o,y:a,width:e,height:i}).rect},e.prototype.paint=function(t){var e,n,r=this.font,s=c.font_metrics(r),o=(this.line_height-1)*s.height,a=this.text.split("\n"),h=a.length,l=a.map((function(t){return i.text_width(t,r)})),_=this._text_line(s),f=_.height*h,p="%"==(null===(e=this.width)||void 0===e?void 0:e.unit)?this.width.value:1,x="%"==(null===(n=this.height)||void 0===n?void 0:n.unit)?this.height.value:1,v=u.max(l)*p,y=(f+o*(h-1))*x;t.save(),t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";var d=this.position,g=d.sx,b=d.sy,m=this.align,w=this.angle;w&&(t.translate(g,b),t.rotate(w),t.translate(-g,-b));var z=this._computed_position({width:v,height:y},s,h),M=z.x,T=z.y;if("justify"==m)for(var B=0;B<h;B++){for(var P=M,j=a[B].split(" "),O=j.length,N=j.map((function(t){return i.text_width(t,r)})),S=(v-u.sum(N))/(O-1),k=0;k<O;k++)t.fillText(j[k],P,T),P+=N[k]+S;T+=_.height+o}else{var G=function(e){var i=M+function(){switch(m){case"left":return 0;case"center":return.5*(v-l[e]);case"right":return v-l[e]}}();t.fillStyle=E.color,t.fillText(a[e],i,T+_.ascent),T+=_.height+o},E=this;for(B=0;B<h;B++)G(B)}t.restore()},e}(p);i.TextBox=x,x.__name__="TextBox";var v=function(t){function e(e,i){var n=t.call(this)||this;return n.base=e,n.expo=i,n}return a.__extends(e,t),Object.defineProperty(e.prototype,"children",{get:function(){return[this.base,this.expo]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"position",{get:function(){return this._position},set:function(t){this._position=t;var e=this.base.size(),i=this.expo.size(),n=this._shift_scale()*e.height,r=Math.max(e.height,n+i.height);this.base.position={sx:0,x_anchor:"left",sy:r,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:n,y_anchor:"bottom"}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"visuals",{set:function(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t},enumerable:!1,configurable:!0}),e.prototype._shift_scale=function(){if(this.base instanceof x&&1==this.base.nlines){var t=c.font_metrics(this.base.font);return t.x_height/t.cap_height}return 2/3},e.prototype.infer_text_height=function(){return this.base.infer_text_height()},e.prototype._rect=function(){var t=this.base.bbox(),e=this.expo.bbox(),i=t.union(e),n=this._computed_position(),r=n.x,s=n.y;return i.translate(r,s).rect},e.prototype._size=function(){var t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}},e.prototype.paint=function(t){t.save();var e=this.angle;if(e){var i=this.position,n=i.sx,r=i.sy;t.translate(n,r),t.rotate(e),t.translate(-n,-r)}var s=this._computed_position(),o=s.x,a=s.y;t.translate(o,a),this.base.paint(t),this.expo.paint(t),t.restore()},e.prototype.paint_bbox=function(e){var i,n;t.prototype.paint_bbox.call(this,e);var r=this._computed_position(),s=r.x,o=r.y;e.save(),e.translate(s,o);try{for(var h=a.__values(this.children),c=h.next();!c.done;c=h.next()){c.value.paint_bbox(e)}}catch(t){i={error:t}}finally{try{c&&!c.done&&(n=h.return)&&n.call(h)}finally{if(i)throw i.error}}e.restore()},e.prototype._computed_position=function(){var t=this._size(),e=t.width,i=t.height,n=this.position,r=n.sx,s=n.sy,o=n.x_anchor,a=void 0===o?"left":o,h=n.y_anchor,c=void 0===h?"center":h;return{x:r-function(){if(l.isNumber(a))return a*e;switch(a){case"left":return 0;case"center":return.5*e;case"right":return e}}(),y:s-function(){if(l.isNumber(c))return c*i;switch(c){case"top":return 0;case"center":return.5*i;case"bottom":return i;case"baseline":return.5*i}}()}},e}(p);i.BaseExpo=v,v.__name__="BaseExpo";var y=function(){function t(t){this.items=t}return Object.defineProperty(t.prototype,"length",{get:function(){return this.items.length},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"visuals",{set:function(t){var e,i,n,r;try{for(var s=a.__values(this.items),o=s.next();!o.done;o=s.next()){o.value.visuals=t}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=s.return)&&i.call(s)}finally{if(e)throw e.error}}var h={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},c=u.max_by(this.items.map((function(t){return t.infer_text_height()})),(function(t){return h[t]}));try{for(var l=a.__values(this.items),_=l.next();!_.done;_=l.next()){_.value.text_height_metric=c}}catch(t){n={error:t}}finally{try{_&&!_.done&&(r=l.return)&&r.call(l)}finally{if(n)throw n.error}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"angle",{set:function(t){var e,i;try{for(var n=a.__values(this.items),r=n.next();!r.done;r=n.next()){r.value.angle=t}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}},enumerable:!1,configurable:!0}),t.prototype.max_size=function(){var t,e,i=0,n=0;try{for(var r=a.__values(this.items),s=r.next();!s.done;s=r.next()){var o=s.value.size();i=Math.max(i,o.width),n=Math.max(n,o.height)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return{width:i,height:n}},t}();i.GraphicsBoxes=y,y.__name__="GraphicsBoxes"},
function _(t,r,n,o,i){o();var e=t(1),p=Math.sin,a=Math.cos,s=function(){function t(t,r,n,o,i,e){void 0===t&&(t=1),void 0===r&&(r=0),void 0===n&&(n=0),void 0===o&&(o=1),void 0===i&&(i=0),void 0===e&&(e=0),this.a=t,this.b=r,this.c=n,this.d=o,this.e=i,this.f=e}return t.prototype.toString=function(){var t=this;return"matrix("+t.a+", "+t.b+", "+t.c+", "+t.d+", "+t.e+", "+t.f+")"},t.from_DOMMatrix=function(r){return new t(r.a,r.b,r.c,r.d,r.e,r.f)},t.prototype.to_DOMMatrix=function(){var t=this,r=t.a,n=t.b,o=t.c,i=t.d,e=t.e,p=t.f;return new DOMMatrix([r,n,o,i,e,p])},t.prototype.clone=function(){var r=this;return new t(r.a,r.b,r.c,r.d,r.e,r.f)},Object.defineProperty(t.prototype,"is_identity",{get:function(){var t=this,r=t.a,n=t.b,o=t.c,i=t.d,e=t.e,p=t.f;return 1==r&&0==n&&0==o&&1==i&&0==e&&0==p},enumerable:!1,configurable:!0}),t.prototype.apply_point=function(t){var r=e.__read(this.apply(t.x,t.y),2);return{x:r[0],y:r[1]}},t.prototype.apply_rect=function(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}},t.prototype.apply=function(t,r){var n=this,o=n.a,i=n.b,e=n.c,p=n.d;return[o*t+e*r+n.e,i*t+p*r+n.f]},t.prototype.iv_apply=function(t,r){for(var n=this,o=n.a,i=n.b,e=n.c,p=n.d,a=n.e,s=n.f,f=t.length,u=0;u<f;u++){var c=t[u],h=r[u];t[u]=o*c+e*h+a,r[u]=i*c+p*h+s}},t.prototype.transform=function(t,r,n,o,i,e){var p=this,a=p.a,s=p.b,f=p.c,u=p.d,c=p.e,h=p.f;return this.a=a*t+f*r,this.c=a*n+f*o,this.e=a*i+f*e+c,this.b=s*t+u*r,this.d=s*n+u*o,this.f=s*i+u*e+h,this},t.prototype.translate=function(t,r){return this.transform(1,0,0,1,t,r)},t.prototype.scale=function(t,r){return this.transform(t,0,0,r,0,0)},t.prototype.skew=function(t,r){return this.transform(1,r,t,1,0,0)},t.prototype.rotate=function(t){var r=p(t),n=a(t);return this.transform(n,r,-r,n,0,0)},t.prototype.rotate_ccw=function(t){return this.rotate(-t)},t.prototype.translate_x=function(t){return this.translate(t,0)},t.prototype.translate_y=function(t){return this.translate(0,t)},t.prototype.flip=function(){return this.scale(-1,-1)},t.prototype.flip_x=function(){return this.scale(1,-1)},t.prototype.flip_y=function(){return this.scale(-1,1)},t}();n.AffineTransform=s,s.__name__="AffineTransform"},
function _(e,n,t,r,i){r();var a=e(1),o=e(168),l=e(128),u=e(149),s=e(123),c=e(139),_=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n}(o.Model);t.LabelingPolicy=_,_.__name__="LabelingPolicy";var f=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.prototype.filter=function(e,n,t){return e},n}(_);t.AllLabels=f,f.__name__="AllLabels";var d=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_NoOverlap=function(){this.define((function(e){return{min_distance:[e.Number,5]}}))},n.prototype.filter=function(e,n,t){var r,i,o=this.min_distance,l=null;try{for(var u=a.__values(e),s=u.next();!s.done;s=u.next()){var c=s.value;null!=l&&t(l,c)<o?e.unset(c):l=c}}catch(e){r={error:e}}finally{try{s&&!s.done&&(i=u.return)&&i.call(u)}finally{if(r)throw r.error}}return e},n}(_);t.NoOverlap=d,d.__name__="NoOverlap",d.init_NoOverlap();var p=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_CustomLabelingPolicy=function(){this.define((function(e){var n=e.Unknown,t=e.String;return{args:[(0,e.Dict)(n),{}],code:[t,""]}}))},Object.defineProperty(n.prototype,"names",{get:function(){return l.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return l.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"func",{get:function(){var e=u.use_strict(this.code);return new(c.GeneratorFunction.bind.apply(c.GeneratorFunction,a.__spreadArray(a.__spreadArray([void 0,"indices","bboxes","distance"],a.__read(this.names)),[e])))},enumerable:!1,configurable:!0}),n.prototype.filter=function(e,n,t){var r,i=Object.create(null),o=(r=this.func).call.apply(r,a.__spreadArray([i,e,n,t],a.__read(this.values))),l=o.next();if(l.done&&void 0!==l.value){var u=l.value;return u instanceof c.Indices?u:void 0===u?e:s.isIterable(u)?c.Indices.from_indices(e.size,u):c.Indices.all_unset(e.size)}var _=[];do{_.push(l.value),l=o.next()}while(!l.done);return c.Indices.from_indices(e.size,_)},n}(_);t.CustomLabelingPolicy=p,p.__name__="CustomLabelingPolicy",p.init_CustomLabelingPolicy()},
function _(t,e,r,o,i){o();var a=t(1),s=t(241),n=t(249),_=t(250),l=a.__importStar(t(163)),u=t(135),p=t(245),c=t(123),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._paint=function(t,e,r){this._draw_group_separators(t,e,r)},e.prototype._draw_group_separators=function(t,e,r){var o,i=a.__read(this.ranges,1)[0],s=a.__read(this.computed_bounds,2),n=s[0],_=s[1];if(i.tops&&!(i.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,u=(l+1)%2,p=[[],[]],c=0,h=0;h<i.tops.length-1;h++){for(var d=void 0,m=void 0,f=c;f<i.factors.length;f++)if(i.factors[f][0]==i.tops[h+1]){d=(o=a.__read([i.factors[f-1],i.factors[f]],2))[0],m=o[1],c=f;break}var g=(i.synthetic(d)+i.synthetic(m))/2;g>n&&g<_&&(p[l].push(g),p[u].push(this.loc))}var b=this.extents.tick_label;this._draw_ticks(t,p,-3,b-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,r){for(var o=this._get_factor_info(),i=e.tick+this.model.major_label_standoff,s=0;s<o.length;s++){var n=a.__read(o[s],4),_=n[0],l=n[1],u=n[2],p=n[3];this._draw_oriented_labels(t,_,l,u,this.panel.side,i,p),i+=e.tick_labels[s]}},e.prototype._tick_label_extents=function(){var t,e,r=this._get_factor_info(),o=[];try{for(var i=a.__values(r),s=i.next();!s.done;s=i.next()){var n=a.__read(s.value,4),_=n[0],l=n[2],u=n[3],p=this._oriented_labels_extent(_,l,this.model.major_label_standoff,u);o.push(p)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return o},e.prototype._get_factor_info=function(){var t=this,e=a.__read(this.ranges,1)[0],r=a.__read(this.computed_bounds,2),o=r[0],i=r[1],s=this.loc,n=this.model.ticker.get_ticks(o,i,e,s),_=this.tick_coords,l=[],u=function(t){return new p.GraphicsBoxes(t.map((function(t){return c.isString(t)?new p.TextBox({text:t}):t})))},h=function(e){return u(t.model.formatter.doFormat(e,t))};if(1==e.levels){var d=h(n.major);l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==e.levels){d=h(n.major.map((function(t){return t[1]})));l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),l.push([u(n.tops),_.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==e.levels){d=h(n.major.map((function(t){return t[2]})));var m=n.mids.map((function(t){return t[1]}));l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),l.push([u(m),_.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),l.push([u(n.tops),_.tops,this.model.group_label_orientation,this.visuals.group_text])}return l},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,r=(e+1)%2,o=a.__read(this.ranges,1)[0],i=a.__read(this.computed_bounds,2),s=i[0],n=i[1],_=this.model.ticker.get_ticks(s,n,o,this.loc),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=_.major,l.major[r]=_.major.map((function(){return t.loc})),3==o.levels&&(l.mids[e]=_.mids,l.mids[r]=_.mids.map((function(){return t.loc}))),o.levels>1&&(l.tops[e]=_.tops,l.tops[r]=_.tops.map((function(){return t.loc}))),l},enumerable:!1,configurable:!0}),e}(s.AxisView);r.CategoricalAxisView=h,h.__name__="CategoricalAxisView";var d=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_CategoricalAxis=function(){this.prototype.default_view=h,this.mixins([["separator_",l.Line],["group_",l.Text],["subgroup_",l.Text]]),this.define((function(t){var e=t.Number,r=t.Or;return{group_label_orientation:[r(u.TickLabelOrientation,e),"parallel"],subgroup_label_orientation:[r(u.TickLabelOrientation,e),"parallel"]}})),this.override({ticker:function(){return new n.CategoricalTicker},formatter:function(){return new _.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},e}(s.Axis);r.CategoricalAxis=d,d.__name__="CategoricalAxis",d.init_CategoricalAxis()},
function _(t,r,e,o,n){o();var c=t(1),i=function(t){function r(r){return t.call(this,r)||this}return c.__extends(r,t),r.prototype.get_ticks=function(t,r,e,o){var n,c;return{major:this._collect(e.factors,e,t,r),minor:[],tops:this._collect(null!==(n=e.tops)&&void 0!==n?n:[],e,t,r),mids:this._collect(null!==(c=e.mids)&&void 0!==c?c:[],e,t,r)}},r.prototype._collect=function(t,r,e,o){var n,i,l=[];try{for(var a=c.__values(t),s=a.next();!s.done;s=a.next()){var u=s.value,_=r.synthetic(u);_>e&&_<o&&l.push(u)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=a.return)&&i.call(a)}finally{if(n)throw n.error}}return l},r}(t(243).Ticker);e.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,n,e){n();var a=t(1),c=t(244),i=t(124),u=function(t){function r(r){return t.call(this,r)||this}return a.__extends(r,t),r.prototype.doFormat=function(t,r){return i.copy(t)},r}(c.TickFormatter);o.CategoricalTickFormatter=u,u.__name__="CategoricalTickFormatter"},
function _(n,i,t,u,s){u();var e=n(1),o=n(241),_=function(n){function i(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(i,n),i}(o.AxisView);t.ContinuousAxisView=_,_.__name__="ContinuousAxisView";var r=function(n){function i(i){return n.call(this,i)||this}return e.__extends(i,n),i}(o.Axis);t.ContinuousAxis=r,r.__name__="ContinuousAxis"},
function _(t,e,i,n,r){n();var a=t(1),s=t(253),u=t(258),_=t(263),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e}(s.LinearAxisView);i.DatetimeAxisView=o,o.__name__="DatetimeAxisView";var c=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_DatetimeAxis=function(){this.prototype.default_view=o,this.override({ticker:function(){return new _.DatetimeTicker},formatter:function(){return new u.DatetimeTickFormatter}})},e}(s.LinearAxis);i.DatetimeAxis=c,c.__name__="DatetimeAxis",c.init_DatetimeAxis()},
function _(i,n,t,e,r){e();var s=i(1),u=i(251),a=i(254),o=i(255),_=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(n,i),n}(u.ContinuousAxisView);t.LinearAxisView=_,_.__name__="LinearAxisView";var c=function(i){function n(n){return i.call(this,n)||this}return s.__extends(n,i),n.init_LinearAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new o.BasicTicker},formatter:function(){return new a.BasicTickFormatter}})},n}(u.ContinuousAxis);t.LinearAxis=c,c.__name__="LinearAxis",c.init_LinearAxis()},
function _(t,i,r,e,n){e();var o=t(1),a=t(244),c=t(149);function s(t){var i,r,e="";try{for(var n=o.__values(t),a=n.next();!a.done;a=n.next()){var c=a.value;e+="-"==c?"−":c}}catch(t){i={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(i)throw i.error}}return e}r.unicode_replace=s;var _=function(t){function i(i){var r=t.call(this,i)||this;return r.last_precision=3,r}return o.__extends(i,t),i.init_BasicTickFormatter=function(){this.define((function(t){var i=t.Boolean,r=t.Int,e=t.Auto;return{precision:[(0,t.Or)(r,e),"auto"],use_scientific:[i,!0],power_limit_high:[r,5],power_limit_low:[r,-3]}}))},Object.defineProperty(i.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!1,configurable:!0}),i.prototype._need_sci=function(t){var i,r;if(!this.use_scientific)return!1;var e=this.scientific_limit_high,n=this.scientific_limit_low,a=t.length<2?0:Math.abs(t[1]-t[0])/1e4;try{for(var c=o.__values(t),s=c.next();!s.done;s=c.next()){var _=s.value,l=Math.abs(_);if(!(l<=a)&&(l>=e||l<=n))return!0}}catch(t){i={error:t}}finally{try{s&&!s.done&&(r=c.return)&&r.call(c)}finally{if(i)throw i.error}}return!1},i.prototype._format_with_precision=function(t,i,r){return i?t.map((function(t){return s(t.toExponential(r))})):t.map((function(t){return s(c.to_fixed(t,r))}))},i.prototype._auto_precision=function(t,i){var r=new Array(t.length),e=this.last_precision<=15;t:for(var n=this.last_precision;e?n<=15:n>=1;e?n++:n--){if(i){r[0]=t[0].toExponential(n);for(var o=1;o<t.length;o++)if(r[o]==r[o-1])continue t;this.last_precision=n;break}r[0]=c.to_fixed(t[0],n);for(o=1;o<t.length;o++)if(r[o]=c.to_fixed(t[o],n),r[o]==r[o-1])continue t;this.last_precision=n;break}return this.last_precision},i.prototype.doFormat=function(t,i){if(0==t.length)return[];var r=this._need_sci(t),e="auto"==this.precision?this._auto_precision(t,r):this.precision;return this._format_with_precision(t,r,e)},i}(a.TickFormatter);r.BasicTickFormatter=_,_.__name__="BasicTickFormatter",_.init_BasicTickFormatter()},
function _(i,n,c,e,t){e();var r=i(1),_=function(i){function n(n){return i.call(this,n)||this}return r.__extends(n,i),n}(i(256).AdaptiveTicker);c.BasicTicker=_,_.__name__="BasicTicker"},
function _(t,i,a,e,n){e();var r=t(1),s=t(257),_=t(124),o=t(125),l=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_AdaptiveTicker=function(){this.define((function(t){var i=t.Number,a=t.Array,e=t.Nullable;return{base:[i,10],mantissas:[a(i),[1,2,5]],min_interval:[i,0],max_interval:[e(i),null]}}))},i.prototype.get_min_interval=function(){return this.min_interval},i.prototype.get_max_interval=function(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0},i.prototype.initialize=function(){t.prototype.initialize.call(this);var i=_.nth(this.mantissas,-1)/this.base,a=_.nth(this.mantissas,0)*this.base;this.extended_mantissas=r.__spreadArray(r.__spreadArray([i],r.__read(this.mantissas)),[a]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},i.prototype.get_interval=function(t,i,a){var e=i-t,n=this.get_ideal_interval(t,i,a),r=Math.floor(o.log(n/this.base_factor,this.base)),s=Math.pow(this.base,r)*this.base_factor,l=this.extended_mantissas,h=l.map((function(t){return Math.abs(a-e/(t*s))})),u=l[_.argmin(h)]*s;return o.clamp(u,this.get_min_interval(),this.get_max_interval())},i}(s.ContinuousTicker);a.AdaptiveTicker=l,l.__name__="AdaptiveTicker",l.init_AdaptiveTicker()},
function _(t,r,n,e,i){e();var o=t(1),u=t(243),a=t(124),l=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_ContinuousTicker=function(){this.define((function(t){var r=t.Int;return{num_minor_ticks:[r,5],desired_num_ticks:[r,6]}}))},r.prototype.get_ticks=function(t,r,n,e){return this.get_ticks_no_defaults(t,r,e,this.desired_num_ticks)},r.prototype.get_ticks_no_defaults=function(t,r,n,e){var i,u,l,c,_,s,f=this.get_interval(t,r,e),h=Math.floor(t/f),v=Math.ceil(r/f),d=(isFinite(h)&&isFinite(v)?a.range(h,v+1):[]).map((function(t){return t*f})).filter((function(n){return t<=n&&n<=r})),y=this.num_minor_ticks,k=[];if(y>0&&d.length>0){var m=f/y,p=a.range(0,y).map((function(t){return t*m}));try{for(var g=o.__values(p.slice(1)),x=g.next();!x.done;x=g.next()){var T=x.value,C=d[0]-T;t<=C&&C<=r&&k.push(C)}}catch(t){i={error:t}}finally{try{x&&!x.done&&(u=g.return)&&u.call(g)}finally{if(i)throw i.error}}try{for(var w=o.__values(d),F=w.next();!F.done;F=w.next()){var M=F.value;try{for(var j=(_=void 0,o.__values(p)),I=j.next();!I.done;I=j.next()){T=I.value;t<=(C=M+T)&&C<=r&&k.push(C)}}catch(t){_={error:t}}finally{try{I&&!I.done&&(s=j.return)&&s.call(j)}finally{if(_)throw _.error}}}}catch(t){l={error:t}}finally{try{F&&!F.done&&(c=w.return)&&c.call(w)}finally{if(l)throw l.error}}}return{major:d,minor:k}},r.prototype.get_ideal_interval=function(t,r,n){return(r-t)/n},r}(u.Ticker);n.ContinuousTicker=l,l.__name__="ContinuousTicker",l.init_ContinuousTicker()},
function _(t,r,e,n,i){n();var s=t(1),o=s.__importDefault(t(259)),a=t(244),u=t(134),c=t(260),m=t(124),h=t(123);function d(t){return o.default(t,"%Y %m %d %H %M %S").split(/\s+/).map((function(t){return parseInt(t,10)}))}function l(t,r){if(h.isFunction(r))return r(t);var e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(r=r.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?r:o.default(t,r)}var f=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],_=function(t){function r(r){var e=t.call(this,r)||this;return e.strip_leading_zeros=!0,e}return s.__extends(r,t),r.init_DatetimeTickFormatter=function(){this.define((function(t){var r=t.String,e=t.Array;return{microseconds:[e(r),["%fus"]],milliseconds:[e(r),["%3Nms","%S.%3Ns"]],seconds:[e(r),["%Ss"]],minsec:[e(r),[":%M:%S"]],minutes:[e(r),[":%M","%Mm"]],hourmin:[e(r),["%H:%M"]],hours:[e(r),["%Hh","%H:%M"]],days:[e(r),["%m/%d","%a%d"]],months:[e(r),["%m/%Y","%b %Y"]],years:[e(r),["%Y"]]}}))},r.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},r.prototype._update_width_formats=function(){var t=+o.default(new Date),r=function(r){var e=r.map((function(r){return l(t,r).length})),n=m.sort_by(m.zip(e,r),(function(t){return s.__read(t,1)[0]}));return m.unzip(n)};this._width_formats={microseconds:r(this.microseconds),milliseconds:r(this.milliseconds),seconds:r(this.seconds),minsec:r(this.minsec),minutes:r(this.minutes),hourmin:r(this.hourmin),hours:r(this.hours),days:r(this.days),months:r(this.months),years:r(this.years)}},r.prototype._get_resolution_str=function(t,r){var e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return r>=60?"minsec":"seconds";case!(e<3600):return r>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}},r.prototype.doFormat=function(t,r){var e,n,i,o;if(0==t.length)return[];var a=Math.abs(t[t.length-1]-t[0])/1e3,c=a/(t.length-1),m=this._get_resolution_str(c,a),h=s.__read(this._width_formats[m],2),_=s.__read(h[1],1)[0],p=[],y=f.indexOf(m),v={};try{for(var g=s.__values(f),w=g.next();!w.done;w=g.next()){v[w.value]=0}}catch(t){e={error:t}}finally{try{w&&!w.done&&(n=g.return)&&n.call(g)}finally{if(e)throw e.error}}v.seconds=5,v.minsec=4,v.minutes=4,v.hourmin=3,v.hours=3;try{for(var k=s.__values(t),M=k.next();!M.done;M=k.next()){var x=M.value,F=void 0,b=void 0;try{b=d(x),F=l(x,_)}catch(t){u.logger.warn("unable to format tick for timestamp value "+x),u.logger.warn(" - "+t),p.push("ERR");continue}for(var z=!1,D=y;0==b[v[f[D]]];){if((D+=1)==f.length)break;if(("minsec"==m||"hourmin"==m)&&!z){if("minsec"==m&&0==b[4]&&0!=b[5]||"hourmin"==m&&0==b[3]&&0!=b[4]){F=l(x,this._width_formats[f[y-1]][1][0]);break}z=!0}F=l(x,this._width_formats[f[D]][1][0])}if(this.strip_leading_zeros){var S=F.replace(/^0+/g,"");S!=F&&isNaN(parseInt(S))&&(S="0"+S),p.push(S)}else p.push(F)}}catch(t){i={error:t}}finally{try{M&&!M.done&&(o=k.return)&&o.call(k)}finally{if(i)throw i.error}}return p},r}(a.TickFormatter);e.DatetimeTickFormatter=_,_.__name__="DatetimeTickFormatter",_.init_DatetimeTickFormatter()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,t,e,i){e();var u=r(1),a=u.__importStar(r(261)),f=r(262),o=u.__importDefault(r(259)),l=r(136),c=r(123);function s(r){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];return f.sprintf.apply(void 0,u.__spreadArray([r],u.__read(n)))}function _(r,n,t){return c.isNumber(r)?s(function(){switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}}(),r):""+r}function m(r,n,e){if(null==n)return _;if(null!=e&&r in e){var i=e[r];if(c.isString(i)){if(i in t.DEFAULT_FORMATTERS)return t.DEFAULT_FORMATTERS[i];throw new Error("Unknown tooltip field formatter type '"+i+"'")}return function(r,n,t){return i.format(r,n,t)}}return t.DEFAULT_FORMATTERS.numeral}function d(r,n,t){var e=n.get_column(r);if(null==e)return null;if(c.isNumber(t))return e[t];var i=e[t.index];return c.isTypedArray(i)||c.isArray(i)?c.isArray(i[0])?i[t.dim2][t.dim1]:i[t.flat_index]:i}function p(r,n,t,e){return"$"==r[0]?function(r,n){if(r in n)return n[r];throw new Error("Unknown special variable '$"+r+"'")}(r.substring(1),e):d(r.substring(1).replace(/[{}]/g,""),n,t)}t.FormatterType=l.Enum("numeral","printf","datetime"),t.DEFAULT_FORMATTERS={numeral:function(r,n,t){return a.format(r,n)},datetime:function(r,n,t){return o.default(r,n)},printf:function(r,n,t){return s(n,r)}},t.sprintf=s,t.basic_formatter=_,t.get_formatter=m,t._get_column_value=d,t.get_value=p,t.replace_placeholders=function(r,n,t,e,i,a){var f,o;if(void 0===i&&(i={}),c.isString(r)?(f=r,o=!1):(f=r.html,o=!0),f=(f=f.replace(/@\$name/g,(function(r){return"@{"+i.name+"}"}))).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(function(r,u,f){var l=p(u,n,t,i);if(null==l)return a?a("???"):"???";if("safe"==f)return o=!0,""+l;var c=""+m(u,f,e)(l,f,i);return a?a(c):c})),o){var l=(new DOMParser).parseFromString(f,"text/html");return u.__spreadArray([],u.__read(l.body.childNodes))}return f}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t)}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i,t,r){t();var a=e(1),s=e(124),c=e(256),_=e(264),m=e(265),k=e(268),o=e(269),T=e(267),u=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_DatetimeTicker=function(){this.override({num_minor_ticks:0,tickers:function(){return[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new m.DaysTicker({days:s.range(1,32)}),new m.DaysTicker({days:s.range(1,31,3)}),new m.DaysTicker({days:[1,8,15,22]}),new m.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:s.range(0,12,1)}),new k.MonthsTicker({months:s.range(0,12,2)}),new k.MonthsTicker({months:s.range(0,12,4)}),new k.MonthsTicker({months:s.range(0,12,6)}),new o.YearsTicker({})]}})},n}(_.CompositeTicker);i.DatetimeTicker=u,u.__name__="DatetimeTicker",u.init_DatetimeTicker()},
function _(t,e,i,n,r){n();var o=t(1),s=t(257),_=t(124),a=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_CompositeTicker=function(){this.define((function(t){return{tickers:[(0,t.Array)((0,t.Ref)(s.ContinuousTicker)),[]]}}))},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map((function(t){return t.get_min_interval()}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map((function(t){return t.get_max_interval()}))},enumerable:!1,configurable:!0}),e.prototype.get_min_interval=function(){return this.min_intervals[0]},e.prototype.get_max_interval=function(){return this.max_intervals[0]},e.prototype.get_best_ticker=function(t,e,i){var n,r=e-t,o=this.get_ideal_interval(t,e,i),s=[_.sorted_index(this.min_intervals,o)-1,_.sorted_index(this.max_intervals,o)],a=[this.min_intervals[s[0]],this.max_intervals[s[1]]].map((function(t){return Math.abs(i-r/t)}));if(_.is_empty(a.filter((function(t){return!isNaN(t)}))))n=this.tickers[0];else{var u=s[_.argmin(a)];n=this.tickers[u]}return n},e.prototype.get_interval=function(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)},e.prototype.get_ticks_no_defaults=function(t,e,i,n){return this.get_best_ticker(t,e,n).get_ticks_no_defaults(t,e,i,n)},e}(s.ContinuousTicker);i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,n,e,r,i){r();var a=t(1),o=t(266),s=t(267),c=t(124);var u=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_DaysTicker=function(){this.define((function(t){var n=t.Int;return{days:[(0,t.Array)(n),[]]}})),this.override({num_minor_ticks:0})},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.days;n.length>1?this.interval=(n[1]-n[0])*s.ONE_DAY:this.interval=31*s.ONE_DAY},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=s.last_month_no_later_than(new Date(t)),r=s.last_month_no_later_than(new Date(n));r.setUTCMonth(r.getUTCMonth()+1);for(var i=[],a=e;i.push(s.copy_date(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>r););return i}(t,n),o=this.days,u=this.interval;return{major:c.concat(i.map((function(t){return function(t,n){var e,r,i=t.getUTCMonth(),c=[];try{for(var u=a.__values(o),_=u.next();!_.done;_=u.next()){var l=_.value,h=s.copy_date(t);h.setUTCDate(l),new Date(h.getTime()+n/2).getUTCMonth()==i&&c.push(h)}}catch(t){e={error:t}}finally{try{_&&!_.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}return c}(t,u)}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(o.SingleIntervalTicker);e.DaysTicker=u,u.__name__="DaysTicker",u.init_DaysTicker()},
function _(n,t,e,i,r){i();var l=n(1),u=function(n){function t(t){return n.call(this,t)||this}return l.__extends(t,n),t.init_SingleIntervalTicker=function(){this.define((function(n){return{interval:[n.Number]}}))},t.prototype.get_interval=function(n,t,e){return this.interval},t.prototype.get_min_interval=function(){return this.interval},t.prototype.get_max_interval=function(){return this.interval},t}(n(257).ContinuousTicker);e.SingleIntervalTicker=u,u.__name__="SingleIntervalTicker",u.init_SingleIntervalTicker()},
function _(t,e,_,n,E){function N(t){return new Date(t.getTime())}function O(t){var e=N(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}n(),_.ONE_MILLI=1,_.ONE_SECOND=1e3,_.ONE_MINUTE=60*_.ONE_SECOND,_.ONE_HOUR=60*_.ONE_MINUTE,_.ONE_DAY=24*_.ONE_HOUR,_.ONE_MONTH=30*_.ONE_DAY,_.ONE_YEAR=365*_.ONE_DAY,_.copy_date=N,_.last_month_no_later_than=O,_.last_year_no_later_than=function(t){var e=O(t);return e.setUTCMonth(0),e}},
function _(t,n,e,r,i){r();var a=t(1),o=t(266),u=t(267),l=t(124);var c=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_MonthsTicker=function(){this.define((function(t){var n=t.Int;return{months:[(0,t.Array)(n),[]]}}))},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.months;n.length>1?this.interval=(n[1]-n[0])*u.ONE_MONTH:this.interval=12*u.ONE_MONTH},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=u.last_year_no_later_than(new Date(t)),r=u.last_year_no_later_than(new Date(n));r.setUTCFullYear(r.getUTCFullYear()+1);for(var i=[],a=e;i.push(u.copy_date(a)),a.setUTCFullYear(a.getUTCFullYear()+1),!(a>r););return i}(t,n),a=this.months;return{major:l.concat(i.map((function(t){return a.map((function(n){var e=u.copy_date(t);return e.setUTCMonth(n),e}))}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(o.SingleIntervalTicker);e.MonthsTicker=c,c.__name__="MonthsTicker",c.init_MonthsTicker()},
function _(t,e,i,n,r){n();var a=t(1),_=t(255),c=t(266),o=t(267),l=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=o.ONE_YEAR,this.basic_ticker=new _.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=o.last_year_no_later_than(new Date(t)).getUTCFullYear(),a=o.last_year_no_later_than(new Date(e)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,a,i,n).major.map((function(t){return Date.UTC(t,0,1)})).filter((function(i){return t<=i&&i<=e})),minor:[]}},e}(c.SingleIntervalTicker);i.YearsTicker=l,l.__name__="YearsTicker"},
function _(i,n,t,e,o){e();var r=i(1),u=i(251),s=i(271),_=i(272),c=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return r.__extends(n,i),n}(u.ContinuousAxisView);t.LogAxisView=c,c.__name__="LogAxisView";var f=function(i){function n(n){return i.call(this,n)||this}return r.__extends(n,i),n.init_LogAxis=function(){this.prototype.default_view=c,this.override({ticker:function(){return new _.LogTicker},formatter:function(){return new s.LogTickFormatter}})},n}(u.ContinuousAxis);t.LogAxis=f,f.__name__="LogAxis",f.init_LogAxis()},
function _(t,e,n,r,i){r();var o=t(1),a=t(244),l=t(254),u=t(272),c=t(245),p=Math.abs,s=Math.log,_=Math.round,f=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_LogTickFormatter=function(){this.define((function(t){var e=t.Int,n=t.Ref;return{ticker:[(0,t.Nullable)(n(u.LogTicker)),null],min_exponent:[e,0]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new l.BasicTickFormatter},e.prototype.format_graphics=function(t,e){var n,r,i=this;if(0==t.length)return[];var o=null!==(r=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==r?r:10,a=this._exponents(t,o);return null==a?this.basic_formatter.format_graphics(t,e):a.map((function(t){if(p(t)<i.min_exponent){var e=new c.TextBox({text:l.unicode_replace(""+Math.pow(o,t))}),n=new c.TextBox({text:""});return new c.BaseExpo(e,n)}e=new c.TextBox({text:l.unicode_replace(""+o)}),n=new c.TextBox({text:l.unicode_replace(""+t)});return new c.BaseExpo(e,n)}))},e.prototype._exponents=function(t,e){var n,r,i=null,a=[];try{for(var l=o.__values(t),u=l.next();!u.done;u=l.next()){var c=u.value,p=_(s(c)/s(e));if(i==p)return null;i=p,a.push(p)}}catch(t){n={error:t}}finally{try{u&&!u.done&&(r=l.return)&&r.call(l)}finally{if(n)throw n.error}}return a},e.prototype.doFormat=function(t,e){var n,r,i=this;if(0==t.length)return[];var o=null!==(r=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==r?r:10,a=this._exponents(t,o);return null==a?this.basic_formatter.doFormat(t,e):a.map((function(t){return p(t)<i.min_exponent?l.unicode_replace(""+Math.pow(o,t)):l.unicode_replace(o+"^"+t)}))},e}(a.TickFormatter);n.LogTickFormatter=f,f.__name__="LogTickFormatter",f.init_LogTickFormatter()},
function _(r,t,e,n,a){n();var o=r(1),i=r(256),l=r(124),u=function(r){function t(t){return r.call(this,t)||this}return o.__extends(t,r),t.init_LogTicker=function(){this.override({mantissas:[1,5]})},t.prototype.get_ticks_no_defaults=function(r,t,e,n){var a,i,u,f,c,h,v,s,_,y,d,g,p,x=this.num_minor_ticks,M=[],m=this.base,w=Math.log(r)/Math.log(m),k=Math.log(t)/Math.log(m),T=k-w;if(isFinite(T))if(T<2){var L=this.get_interval(r,t,n),b=Math.floor(r/L),j=Math.ceil(t/L);if(p=l.range(b,j+1).filter((function(r){return 0!=r})).map((function(r){return r*L})).filter((function(e){return r<=e&&e<=t})),x>0&&p.length>0){var A=L/x,F=l.range(0,x).map((function(r){return r*A}));try{for(var q=o.__values(F.slice(1)),z=q.next();!z.done;z=q.next()){var B=z.value;M.push(p[0]-B)}}catch(r){a={error:r}}finally{try{z&&!z.done&&(i=q.return)&&i.call(q)}finally{if(a)throw a.error}}try{for(var C=o.__values(p),D=C.next();!D.done;D=C.next()){var E=D.value;try{for(var G=(c=void 0,o.__values(F)),H=G.next();!H.done;H=G.next()){B=H.value;M.push(E+B)}}catch(r){c={error:r}}finally{try{H&&!H.done&&(h=G.return)&&h.call(G)}finally{if(c)throw c.error}}}}catch(r){u={error:r}}finally{try{D&&!D.done&&(f=C.return)&&f.call(C)}finally{if(u)throw u.error}}}}else{var I=Math.ceil(.999999*w),J=Math.floor(1.000001*k),K=Math.ceil((J-I)/9);if(p=l.range(I-1,J+1,K).map((function(r){return Math.pow(m,r)})),x>0&&p.length>0){var N=Math.pow(m,K)/x;F=l.range(1,x+1).map((function(r){return r*N}));try{for(var O=o.__values(F),P=O.next();!P.done;P=O.next()){B=P.value;M.push(p[0]/B)}}catch(r){v={error:r}}finally{try{P&&!P.done&&(s=O.return)&&s.call(O)}finally{if(v)throw v.error}}M.push(p[0]);try{for(var Q=o.__values(p),R=Q.next();!R.done;R=Q.next()){E=R.value;try{for(var S=(d=void 0,o.__values(F)),U=S.next();!U.done;U=S.next()){B=U.value;M.push(E*B)}}catch(r){d={error:r}}finally{try{U&&!U.done&&(g=S.return)&&g.call(S)}finally{if(d)throw d.error}}}}catch(r){_={error:r}}finally{try{R&&!R.done&&(y=Q.return)&&y.call(Q)}finally{if(_)throw _.error}}}}else p=[];return{major:p.filter((function(e){return r<=e&&e<=t})),minor:M.filter((function(e){return r<=e&&e<=t}))}},t}(i.AdaptiveTicker);e.LogTicker=u,u.__name__="LogTicker",u.init_LogTicker()},
function _(t,r,i,e,n){e();var o=t(1),a=t(241),c=t(253),s=t(274),u=t(275),_=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(r,t),r}(a.AxisView);i.MercatorAxisView=_,_.__name__="MercatorAxisView";var f=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_MercatorAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new u.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},r}(c.LinearAxis);i.MercatorAxis=f,f.__name__="MercatorAxis",f.init_MercatorAxis()},
function _(r,t,n,e,o){e();var i=r(1),a=r(254),c=r(135),l=r(193),m=function(r){function t(t){return r.call(this,t)||this}return i.__extends(t,r),t.init_MercatorTickFormatter=function(){this.define((function(r){return{dimension:[(0,r.Nullable)(c.LatLon),null]}}))},t.prototype.doFormat=function(t,n){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var e=t.length,o=new Array(e);if("lon"==this.dimension)for(var a=0;a<e;a++){var c=i.__read(l.wgs84_mercator.invert(t[a],n.loc),1)[0];o[a]=c}else for(a=0;a<e;a++){var m=i.__read(l.wgs84_mercator.invert(n.loc,t[a]),2)[1];o[a]=m}return r.prototype.doFormat.call(this,o,n)},t}(a.BasicTickFormatter);n.MercatorTickFormatter=m,m.__name__="MercatorTickFormatter",m.init_MercatorTickFormatter()},
function _(r,t,e,n,o){n();var a=r(1),i=r(255),_=r(135),l=r(193),c=function(r){function t(t){return r.call(this,t)||this}return a.__extends(t,r),t.init_MercatorTicker=function(){this.define((function(r){return{dimension:[(0,r.Nullable)(_.LatLon),null]}}))},t.prototype.get_ticks_no_defaults=function(r,t,e,n){var o;if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return r=(o=a.__read(l.clip_mercator(r,t,this.dimension),2))[0],t=o[1],"lon"==this.dimension?this._get_ticks_lon(r,t,e,n):this._get_ticks_lat(r,t,e,n)},t.prototype._get_ticks_lon=function(t,e,n,o){var i,_,c,s,u=a.__read(l.wgs84_mercator.invert(t,n),1)[0],f=a.__read(l.wgs84_mercator.invert(e,n),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,d,n,o),h=[];try{for(var y=a.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(l.in_bounds(g,"lon")){var w=a.__read(l.wgs84_mercator.compute(g,m),1)[0];h.push(w)}}}catch(r){i={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(i)throw i.error}}var k=[];try{for(var x=a.__values(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if(l.in_bounds(g,"lon")){w=a.__read(l.wgs84_mercator.compute(g,m),1)[0];k.push(w)}}}catch(r){c={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(c)throw c.error}}return{major:h,minor:k}},t.prototype._get_ticks_lat=function(t,e,n,o){var i,_,c,s,u=a.__read(l.wgs84_mercator.invert(n,t),2)[1],f=a.__read(l.wgs84_mercator.invert(n,e),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,m,n,o),h=[];try{for(var y=a.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(l.in_bounds(g,"lat")){var w=a.__read(l.wgs84_mercator.compute(d,g),2)[1];h.push(w)}}}catch(r){i={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(i)throw i.error}}var k=[];try{for(var x=a.__values(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if(l.in_bounds(g,"lat")){w=a.__read(l.wgs84_mercator.compute(d,g),2)[1];k.push(w)}}}catch(r){c={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(c)throw c.error}}return{major:h,minor:k}},t}(i.BasicTicker);e.MercatorTicker=c,c.__name__="MercatorTicker",c.init_MercatorTicker()},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(256).AdaptiveTicker),k("BasicTicker",e(255).BasicTicker),k("CategoricalTicker",e(249).CategoricalTicker),k("CompositeTicker",e(264).CompositeTicker),k("ContinuousTicker",e(257).ContinuousTicker),k("DatetimeTicker",e(263).DatetimeTicker),k("DaysTicker",e(265).DaysTicker),k("FixedTicker",e(277).FixedTicker),k("LogTicker",e(272).LogTicker),k("MercatorTicker",e(275).MercatorTicker),k("MonthsTicker",e(268).MonthsTicker),k("SingleIntervalTicker",e(266).SingleIntervalTicker),k("Ticker",e(243).Ticker),k("YearsTicker",e(269).YearsTicker),k("BinnedTicker",e(278).BinnedTicker)},
function _(t,i,n,r,e){r();var o=t(1),c=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_FixedTicker=function(){this.define((function(t){var i=t.Number,n=t.Array;return{ticks:[n(i),[]],minor_ticks:[n(i),[]]}}))},i.prototype.get_ticks_no_defaults=function(t,i,n,r){return{major:this.ticks,minor:this.minor_ticks}},i.prototype.get_interval=function(t,i,n){return 0},i.prototype.get_min_interval=function(){return 0},i.prototype.get_max_interval=function(){return 0},i}(t(257).ContinuousTicker);n.FixedTicker=c,c.__name__="FixedTicker",c.init_FixedTicker()},
function _(n,e,t,i,r){i();var a=n(1),o=n(243),_=n(279),c=n(127),u=function(n){function e(e){return n.call(this,e)||this}return a.__extends(e,n),e.init_BinnedTicker=function(){this.define((function(n){var e=n.Number,t=n.Ref,i=n.Or,r=n.Auto;return{mapper:[t(_.ScanningColorMapper)],num_major_ticks:[i(e,r),8]}}))},e.prototype.get_ticks=function(n,e,t,i){for(var r=this.mapper.metrics.binning,a=Math.max(0,c.left_edge_index(n,r)),o=Math.min(c.left_edge_index(e,r)+1,r.length-1),_=[],u=a;u<=o;u++)_.push(r[u]);for(var h=this.num_major_ticks,m=[],f="auto"==h?_.length:h,s=Math.max(1,Math.floor(_.length/f)),d=0;d<_.length;d+=s)m.push(_[d]);return{major:m,minor:[]}},e}(o.Ticker);t.BinnedTicker=u,u.__name__="BinnedTicker",u.init_BinnedTicker()},
function _(n,i,e,t,o){t();var r=n(1),a=n(280),p=n(127),u=function(n){function i(i){return n.call(this,i)||this}return r.__extends(i,n),i.prototype.cmap=function(n,i,e,t,o){return n<o.binning[0]?e:n>o.binning[o.binning.length-1]?t:i[p.left_edge_index(n,o.binning)]},i}(a.ContinuousColorMapper);e.ScanningColorMapper=u,u.__name__="ScanningColorMapper"},
function _(e,r,t,n,a){n();var o=e(1),l=e(281),s=e(283),c=e(124),i=e(123),u=function(e){function r(r){var t=e.call(this,r)||this;return t._scan_data=null,t}return o.__extends(r,e),r.init_ContinuousColorMapper=function(){this.define((function(e){var r=e.Number,t=e.String,n=e.Ref,a=e.Color,o=e.Or,l=e.Tuple,c=e.Array,i=e.Nullable;return{high:[i(r),null],low:[i(r),null],high_color:[i(a),null],low_color:[i(a),null],domain:[c(l(n(s.GlyphRenderer),o(t,c(t)))),[]]}}))},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this);var t=function(){var e,t;try{for(var n=o.__values(r.domain),a=n.next();!a.done;a=n.next()){var l=o.__read(a.value,1)[0];r.connect(l.view.change,(function(){return r.update_data()})),r.connect(l.data_source.selected.change,(function(){return r.update_data()}))}}catch(r){e={error:r}}finally{try{a&&!a.done&&(t=n.return)&&t.call(n)}finally{if(e)throw e.error}}};this.connect(this.properties.domain.change,(function(){return t()})),t()},r.prototype.update_data=function(){var e=this.domain,r=this.palette,t=o.__spreadArray([],o.__read(this._collect(e)));this._scan_data=this.scan(t,r.length),this.metrics_change.emit(),this.change.emit()},Object.defineProperty(r.prototype,"metrics",{get:function(){return null==this._scan_data&&this.update_data(),this._scan_data},enumerable:!1,configurable:!0}),r.prototype._collect=function(e){var r,t,n,a,l,s,u,_,h,d,p,f,v,y,g;return o.__generator(this,(function(m){switch(m.label){case 0:m.trys.push([0,11,12,13]),r=o.__values(e),t=r.next(),m.label=1;case 1:if(t.done)return[3,10];n=o.__read(t.value,2),a=n[0],l=n[1],s=function(e){var r,t,n,l,s,u,_,h,d,p;return o.__generator(this,(function(f){switch(f.label){case 0:if(r=a.data_source.get_column(e),r=a.view.indices.select(r),t=a.view.masked,n=a.data_source.selected.indices,l=void 0,null!=t&&n.length>0?l=c.intersection(o.__spreadArray([],o.__read(t)),n):null!=t?l=o.__spreadArray([],o.__read(t)):n.length>0&&(l=n),null!=l&&(r=c.map(l,(function(e){return r[e]}))),!(r.length>0)||i.isNumber(r[0]))return[3,9];f.label=1;case 1:f.trys.push([1,6,7,8]),d=void 0,s=o.__values(r),u=s.next(),f.label=2;case 2:return u.done?[3,5]:(_=u.value,[5,o.__values(_)]);case 3:f.sent(),f.label=4;case 4:return u=s.next(),[3,2];case 5:return[3,8];case 6:return h=f.sent(),d={error:h},[3,8];case 7:try{u&&!u.done&&(p=s.return)&&p.call(s)}finally{if(d)throw d.error}return[7];case 8:return[3,11];case 9:return[5,o.__values(r)];case 10:f.sent(),f.label=11;case 11:return[2]}}))},m.label=2;case 2:m.trys.push([2,7,8,9]),y=void 0,u=o.__values(i.isArray(l)?l:[l]),_=u.next(),m.label=3;case 3:return _.done?[3,6]:(h=_.value,[5,s(h)]);case 4:m.sent(),m.label=5;case 5:return _=u.next(),[3,3];case 6:return[3,9];case 7:return d=m.sent(),y={error:d},[3,9];case 8:try{_&&!_.done&&(g=u.return)&&g.call(u)}finally{if(y)throw y.error}return[7];case 9:return t=r.next(),[3,1];case 10:return[3,13];case 11:return p=m.sent(),f={error:p},[3,13];case 12:try{t&&!t.done&&(v=r.return)&&v.call(r)}finally{if(f)throw f.error}return[7];case 13:return[2]}}))},r.prototype._v_compute=function(e,r,t,n){var a=n.nan_color,l=n.low_color,s=n.high_color;null==l&&(l=t[0]),null==s&&(s=t[t.length-1]);var i=this.domain,u=c.is_empty(i)?e:o.__spreadArray([],o.__read(this._collect(i)));this._scan_data=this.scan(u,t.length),this.metrics_change.emit();for(var _=0,h=e.length;_<h;_++){var d=e[_];isNaN(d)?r[_]=a:r[_]=this.cmap(d,t,l,s,this._scan_data)}},r.prototype._colors=function(r){return o.__assign(o.__assign({},e.prototype._colors.call(this,r)),{low_color:null!=this.low_color?r(this.low_color):void 0,high_color:null!=this.high_color?r(this.high_color):void 0})},r}(l.ColorMapper);t.ContinuousColorMapper=u,u.__name__="ContinuousColorMapper",u.init_ContinuousColorMapper()},
function _(t,r,n,e,o){e();var i=t(1),a=t(282),c=t(130),l=t(139),p=t(137),_=t(142);function u(t){return p.encode_rgba(p.color2rgba(t))}function f(t){for(var r=new Uint32Array(t.length),n=0,e=t.length;n<e;n++)r[n]=u(t[n]);return r}n._convert_color=u,n._convert_palette=f;var h=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.prototype.initialize=function(){t.prototype.initialize.call(this),this.metrics_change=new c.Signal0(this,"metrics_change")},r.init_ColorMapper=function(){this.define((function(t){var r=t.Color;return{palette:[(0,t.Array)(r)],nan_color:[r,"gray"]}}))},r.prototype.v_compute=function(t){var r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors((function(t){return t}))),r},Object.defineProperty(r.prototype,"rgba_mapper",{get:function(){var t=this,r=f(this.palette),n=this._colors(u);return{v_compute:function(e){var o=new l.ColorArray(e.length);return t._v_compute(e,o,r,n),new Uint8ClampedArray(_.to_big_endian(o).buffer)}}},enumerable:!1,configurable:!0}),r.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},r}(a.Mapper);n.ColorMapper=h,h.__name__="ColorMapper",h.init_ColorMapper()},
function _(n,r,t,e,o){e();var p=n(1),i=function(n){function r(r){return n.call(this,r)||this}return p.__extends(r,n),r.prototype.compute=function(n){throw new Error("mapping single values is not supported")},r}(n(171).Transform);t.Mapper=i,i.__name__="Mapper"},
function _(e,t,i,n,l){n();var r=e(1),s=e(284),h=e(285),o=e(297),a=e(298),c=e(300),_=e(287),d=e(185),u=e(301),p=e(139),y=e(127),g=e(124),v=e(128),f=e(228),m=e(182),w={fill:{},line:{}},b={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},x={fill:{fill_alpha:.2},line:{}},V=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),Object.defineProperty(t.prototype,"glyph_view",{get:function(){return this.glyph},enumerable:!1,configurable:!0}),t.prototype.lazy_initialize=function(){var t,i;return r.__awaiter(this,void 0,void 0,(function(){function n(e){var t=v.clone(a);return h&&v.extend(t,e.fill),o&&v.extend(t,e.line),new l.constructor(t)}var l,s,h,o,a,c,_,d,u,p,y,g,f,m,V;return r.__generator(this,(function(v){switch(v.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return v.sent(),l=this.model.glyph,s=this,[4,this.build_glyph_view(l)];case 2:return s.glyph=v.sent(),h="fill"in this.glyph.visuals,o="line"in this.glyph.visuals,delete(a=r.__assign({},l.attributes)).id,null==(c=this.model.selection_glyph)?c=n({fill:{},line:{}}):"auto"==c&&(c=n(w)),_=this,[4,this.build_glyph_view(c)];case 3:return _.selection_glyph=v.sent(),null==(d=this.model.nonselection_glyph)?d=n({fill:{},line:{}}):"auto"==d&&(d=n(x)),u=this,[4,this.build_glyph_view(d)];case 4:return u.nonselection_glyph=v.sent(),null==(p=this.model.hover_glyph)?[3,6]:(y=this,[4,this.build_glyph_view(p)]);case 5:y.hover_glyph=v.sent(),v.label=6;case 6:return null==(g=this.model.muted_glyph)?[3,8]:(f=this,[4,this.build_glyph_view(g)]);case 7:f.muted_glyph=v.sent(),v.label=8;case 8:return m=n(b),V=this,[4,this.build_glyph_view(m)];case 9:return V.decimated_glyph=v.sent(),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),null===(t=this.hover_glyph)||void 0===t||t.set_base(this.glyph),null===(i=this.muted_glyph)||void 0===i||i.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),this.set_data(),[2]}}))}))},t.prototype.build_glyph_view=function(e){return r.__awaiter(this,void 0,void 0,(function(){return r.__generator(this,(function(t){return[2,f.build_view(e,{parent:this})]}))}))},t.prototype.remove=function(){var t,i;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(t=this.hover_glyph)||void 0===t||t.remove(),null===(i=this.muted_glyph)||void 0===i||i.remove(),this.decimated_glyph.remove(),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,i,n,l,s=this;e.prototype.connect_signals.call(this);var h=function(){return s.request_render()},o=function(){return s.update_data()};this.connect(this.model.change,h),this.connect(this.glyph.model.change,o),this.connect(this.selection_glyph.model.change,o),this.connect(this.nonselection_glyph.model.change,o),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,o),null!=this.muted_glyph&&this.connect(this.muted_glyph.model.change,o),this.connect(this.decimated_glyph.model.change,o),this.connect(this.model.data_source.change,o),this.connect(this.model.data_source.streaming,o),this.connect(this.model.data_source.patching,(function(e){return s.update_data(e)})),this.connect(this.model.data_source.selected.change,h),this.connect(this.model.data_source._select,h),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,h),this.connect(this.model.properties.view.change,o),this.connect(this.model.view.properties.indices.change,o),this.connect(this.model.view.properties.masked.change,(function(){return s.set_visuals()})),this.connect(this.model.properties.visible.change,(function(){return s.plot_view.invalidate_dataranges=!0}));var a=this.plot_view.frame,c=a.x_ranges,_=a.y_ranges;try{for(var d=r.__values(c),u=d.next();!u.done;u=d.next()){(g=r.__read(u.value,2)[1])instanceof m.FactorRange&&this.connect(g.change,o)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=d.return)&&i.call(d)}finally{if(t)throw t.error}}try{for(var p=r.__values(_),y=p.next();!y.done;y=p.next()){var g;(g=r.__read(y.value,2)[1])instanceof m.FactorRange&&this.connect(g.change,o)}}catch(e){n={error:e}}finally{try{y&&!y.done&&(l=p.return)&&l.call(p)}finally{if(n)throw n.error}}var v=this.model.glyph,f=v.transformchange,w=v.exprchange;this.connect(f,o),this.connect(w,o)},t.prototype._update_masked_indices=function(){var e=this.glyph.mask_data();return this.model.view.masked=e,e},t.prototype.update_data=function(e){this.set_data(e),this.request_render()},t.prototype.set_data=function(e){var t=this.model.data_source;this.all_indices=this.model.view.indices;var i=this.all_indices;this.glyph.set_data(t,i,e),this.set_visuals(),this._update_masked_indices();var n=this.plot_model.lod_factor,l=this.all_indices.count;this.decimated=new p.Indices(l);for(var r=0;r<l;r+=n)this.decimated.set(r);this.plot_view.invalidate_dataranges=!0},t.prototype.set_visuals=function(){var e,t,i,n,l=this.model.data_source,r=this.all_indices;this.glyph.set_visuals(l,r),this.decimated_glyph.set_visuals(l,r),null===(e=this.selection_glyph)||void 0===e||e.set_visuals(l,r),null===(t=this.nonselection_glyph)||void 0===t||t.set_visuals(l,r),null===(i=this.hover_glyph)||void 0===i||i.set_visuals(l,r),null===(n=this.muted_glyph)||void 0===n||n.set_visuals(l,r)},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return this.glyph.has_webgl},enumerable:!1,configurable:!0}),t.prototype._render=function(){var e,t,i,n,l,s,_,d,u=this,p=this.has_webgl;this.glyph.map_data();var v=r.__spreadArray([],r.__read(this.all_indices)),f=r.__spreadArray([],r.__read(this._update_masked_indices())),m=this.layer.ctx;m.save();var w,b=this.model.data_source.selected;w=!b||b.is_empty()?[]:this.glyph instanceof h.LineView&&b.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(f):b.indices;var x,V,G,R=this.model.data_source.inspected,A=new Set(!R||R.is_empty()?[]:R.selected_glyph?u.model.view.convert_indices_from_subset(f):R.indices.length>0?R.indices:Object.keys(R.multiline_indices).map((function(e){return parseInt(e)}))),k=y.filter(f,(function(e){return A.has(v[e])})),z=this.plot_model.lod_threshold;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!p&&null!=z&&v.length>z?(f=r.__spreadArray([],r.__read(this.decimated)),x=this.decimated_glyph,V=this.decimated_glyph,G=this.selection_glyph):(x=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,V=this.nonselection_glyph,G=this.selection_glyph),null!=this.hover_glyph&&k.length&&(f=g.difference(f,k)),w.length){var D={};try{for(var O=r.__values(w),j=O.next();!j.done;j=O.next()){D[F=j.value]=!0}}catch(e){i={error:e}}finally{try{j&&!j.done&&(n=O.return)&&n.call(O)}finally{if(i)throw i.error}}var L=new Array,S=new Array;if(this.glyph instanceof h.LineView)try{for(var C=r.__values(v),I=C.next();!I.done;I=C.next()){null!=D[F=I.value]?L.push(F):S.push(F)}}catch(e){l={error:e}}finally{try{I&&!I.done&&(s=C.return)&&s.call(C)}finally{if(l)throw l.error}}else try{for(var P=r.__values(f),q=P.next();!q.done;q=P.next()){var F=q.value;null!=D[v[F]]?L.push(F):S.push(F)}}catch(e){_={error:e}}finally{try{q&&!q.done&&(d=P.return)&&d.call(P)}finally{if(_)throw _.error}}V.render(m,S),G.render(m,L),null!=this.hover_glyph&&(this.glyph instanceof h.LineView?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(k)):this.hover_glyph.render(m,k))}else if(this.glyph instanceof h.LineView)this.hover_glyph&&k.length?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(k)):x.render(m,v);else if(this.glyph instanceof o.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof c.VAreaView)if(0==R.selected_glyphs.length||null==this.hover_glyph)x.render(m,v);else try{for(var N=r.__values(R.selected_glyphs),B=N.next();!B.done;B=N.next()){B.value==this.glyph.model&&this.hover_glyph.render(m,v)}}catch(t){e={error:t}}finally{try{B&&!B.done&&(t=N.return)&&t.call(N)}finally{if(e)throw e.error}}else x.render(m,f),this.hover_glyph&&k.length&&this.hover_glyph.render(m,k);m.restore()},t.prototype.draw_legend=function(e,t,i,n,l,r,s,h){0!=this.glyph.data_size&&(null==h&&(h=this.model.get_reference_point(r,s)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:n,y1:l},h))},t.prototype.hit_test=function(e){if(!this.model.visible)return null;var t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)},t}(s.DataRendererView);i.GlyphRendererView=V,V.__name__="GlyphRendererView";var G=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_GlyphRenderer=function(){this.prototype.default_view=V,this.define((function(e){var t=e.Boolean,i=e.Auto,n=e.Or,l=e.Ref,r=e.Null,s=e.Nullable;return{data_source:[l(d.ColumnarDataSource)],view:[l(u.CDSView),function(e){return new u.CDSView({source:e.data_source})}],glyph:[l(_.Glyph)],hover_glyph:[s(l(_.Glyph)),null],nonselection_glyph:[n(l(_.Glyph),i,r),"auto"],selection_glyph:[n(l(_.Glyph),i,r),"auto"],muted_glyph:[s(l(_.Glyph)),null],muted:[t,!1]}}))},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(e,t){var i,n;if(null!=e){var l=this.data_source.get_column(e);if(null!=l)try{for(var s=r.__values(Object.entries(this.view.indices_map)),h=s.next();!h.done;h=s.next()){var o=r.__read(h.value,2),a=o[0],c=o[1];if(l[parseInt(a)]==t)return c}}catch(e){i={error:e}}finally{try{h&&!h.done&&(n=s.return)&&n.call(s)}finally{if(i)throw i.error}}}return 0},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(s.DataRenderer);i.GlyphRenderer=G,G.__name__="GlyphRenderer",G.init_GlyphRenderer()},
function _(e,n,t,r,i){r();var a=e(1),o=e(156),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(n,e),Object.defineProperty(n.prototype,"xscale",{get:function(){return this.coordinates.x_scale},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"yscale",{get:function(){return this.coordinates.y_scale},enumerable:!1,configurable:!0}),n}(o.RendererView);t.DataRendererView=c,c.__name__="DataRendererView";var u=function(e){function n(n){return e.call(this,n)||this}return a.__extends(n,e),n.init_DataRenderer=function(){this.override({level:"glyph"})},Object.defineProperty(n.prototype,"selection_manager",{get:function(){return this.get_selection_manager()},enumerable:!1,configurable:!0}),n}(o.Renderer);t.DataRenderer=u,u.__name__="DataRenderer",u.init_DataRenderer()},
function _(e,i,t,n,r){n();var s=e(1),_=e(286),l=e(292),o=e(294),a=s.__importStar(e(163)),h=s.__importStar(e(293)),p=e(187),u=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(i,e),i.prototype.initialize=function(){e.prototype.initialize.call(this);var i=this.renderer.plot_view.canvas_view.webgl;if(null!=i){var t=i.regl_wrapper;t.has_webgl&&(this.glglyph=new o.LineGL(t,this))}},i.prototype._render=function(e,i,t){var n,r,_=null!=t?t:this,l=_.sx,o=_.sy,a=!0;e.beginPath();try{for(var h=s.__values(i),p=h.next();!p.done;p=h.next()){var u=p.value,c=l[u],y=o[u];isFinite(c+y)?a?(e.moveTo(c,y),a=!1):e.lineTo(c,y):a=!0}}catch(e){n={error:e}}finally{try{p&&!p.done&&(r=h.return)&&r.call(h)}finally{if(n)throw n.error}}this.visuals.line.set_value(e),e.stroke()},i.prototype._hit_point=function(e){for(var i=new p.Selection,t={x:e.sx,y:e.sy},n=9999,r=Math.max(2,this.line_width.value/2),s=0,_=this.sx.length-1;s<_;s++){var l={x:this.sx[s],y:this.sy[s]},o={x:this.sx[s+1],y:this.sy[s+1]},a=h.dist_to_segment(t,l,o);a<r&&a<n&&(n=a,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[s])}return i},i.prototype._hit_span=function(e){var i,t,n=e.sx,r=e.sy,s=new p.Selection;"v"==e.direction?(i=this.renderer.yscale.invert(r),t=this._y):(i=this.renderer.xscale.invert(n),t=this._x);for(var _=0,l=t.length-1;_<l;_++)(t[_]<=i&&i<=t[_+1]||t[_+1]<=i&&i<=t[_])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(_));return s},i.prototype.get_interpolation_hit=function(e,i){var t=s.__read([this._x[e],this._y[e],this._x[e+1],this._y[e+1]],4),n=t[0],r=t[1],_=t[2],o=t[3];return l.line_interpolation(this.renderer,i,n,r,_,o)},i.prototype.draw_legend_for_index=function(e,i,t){l.generic_line_scalar_legend(this.visuals,e,i)},i}(_.XYGlyphView);t.LineView=u,u.__name__="LineView";var c=function(e){function i(i){return e.call(this,i)||this}return s.__extends(i,e),i.init_Line=function(){this.prototype.default_view=u,this.mixins(a.LineScalar)},i}(_.XYGlyph);t.Line=c,c.__name__="Line",c.init_Line()},
function _(t,n,i,e,_){e();var r=t(1),o=t(193),p=r.__importStar(t(133)),a=t(287),y=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype._project_data=function(){o.inplace.project_xy(this._x,this._y)},n.prototype._index_data=function(t){for(var n=this,i=n._x,e=n._y,_=n.data_size,r=0;r<_;r++){var o=i[r],p=e[r];t.add_point(o,p)}},n.prototype.scenterxy=function(t){return[this.sx[t],this.sy[t]]},n}(a.GlyphView);i.XYGlyphView=y,y.__name__="XYGlyphView";var h=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_XYGlyph=function(){this.define((function(t){return{x:[p.XCoordinateSpec,{field:"x"}],y:[p.YCoordinateSpec,{field:"y"}]}}))},n}(a.Glyph);i.XYGlyph=h,h.__name__="XYGlyph",h.init_XYGlyph()},
function _(e,t,r,n,i){n();var a=e(1),o=a.__importStar(e(133)),s=a.__importStar(e(180)),l=a.__importStar(e(160)),_=e(157),u=e(168),c=e(134),d=e(139),h=e(123),p=e(288),f=e(127),y=e(141),v=e(289),g=e(182),x=e(187),b=Math.abs,m=Math.ceil,w=function(e){function t(){var t=e.apply(this,a.__spreadArray([],a.__read(arguments)))||this;return t._index=null,t._data_size=null,t._nohit_warned=new Set,t}return a.__extends(t,e),Object.defineProperty(t.prototype,"renderer",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return null!=this.glglyph},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"index",{get:function(){var e=this._index;if(null!=e)return e;throw new Error(this+".index_data() wasn't called")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"data_size",{get:function(){var e=this._data_size;if(null!=e)return e;throw new Error(this+".set_data() wasn't called")},enumerable:!1,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new l.Visuals(this)},t.prototype.request_render=function(){this.parent.request_render()},Object.defineProperty(t.prototype,"canvas",{get:function(){return this.renderer.parent.canvas_view},enumerable:!1,configurable:!0}),t.prototype.render=function(e,t,r){var n;null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,null!==(n=this.base)&&void 0!==n?n:this),this.renderer.needs_webgl_blit)||this._render(e,t,null!=r?r:this.base)},t.prototype.has_finished=function(){return!0},t.prototype.notify_finished=function(){this.renderer.notify_finished()},t.prototype._bounds=function(e){return e},t.prototype.bounds=function(){return this._bounds(this.index.bbox)},t.prototype.log_bounds=function(){var e=this.index.bounds(s.positive_x()),t=e.x0,r=e.x1,n=this.index.bounds(s.positive_y()),i=n.y0,a=n.y1;return this._bounds({x0:t,y0:i,x1:r,y1:a})},t.prototype.get_anchor_point=function(e,t,r){var n=a.__read(r,2),i=n[0],o=n[1];switch(e){case"center":case"center_center":var s=a.__read(this.scenterxy(t,i,o),2);return{x:s[0],y:s[1]};default:return null}},t.prototype.scenterx=function(e,t,r){return this.scenterxy(e,t,r)[0]},t.prototype.scentery=function(e,t,r){return this.scenterxy(e,t,r)[1]},t.prototype.sdist=function(e,t,r,n,i){void 0===n&&(n="edge"),void 0===i&&(i=!1);var a=t.length,o=new d.ScreenArray(a),s=e.s_compute;if("center"==n)for(var l=0;l<a;l++){var _=t[l],u=r.get(l)/2,c=s(_-u),h=s(_+u);o[l]=b(h-c)}else for(l=0;l<a;l++){c=s(_=t[l]),h=s(_+r.get(l));o[l]=b(h-c)}return i&&f.inplace_map(o,(function(e){return m(e)})),o},t.prototype.draw_legend_for_index=function(e,t,r){},t.prototype.hit_test=function(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(c.logger.debug("'"+e.type+"' selection not available for "+this.model.type),this._nohit_warned.add(e.type)),null},t.prototype._hit_rect_against_index=function(e){var t=e.sx0,r=e.sx1,n=e.sy0,i=e.sy1,o=a.__read(this.renderer.coordinates.x_scale.r_invert(t,r),2),s=o[0],l=o[1],_=a.__read(this.renderer.coordinates.y_scale.r_invert(n,i),2),u=_[0],c=_[1],d=a.__spreadArray([],a.__read(this.index.indices({x0:s,x1:l,y0:u,y1:c})));return new x.Selection({indices:d})},t.prototype._project_data=function(){},t.prototype._iter_visuals=function(){var e,t,r,n,i,s,l,_,u,c,d,h;return a.__generator(this,(function(p){switch(p.label){case 0:p.trys.push([0,11,12,13]),e=a.__values(this.visuals),t=e.next(),p.label=1;case 1:if(t.done)return[3,10];r=t.value,p.label=2;case 2:p.trys.push([2,7,8,9]),d=void 0,n=a.__values(r),i=n.next(),p.label=3;case 3:return i.done?[3,6]:(s=i.value)instanceof o.VectorSpec||s instanceof o.ScalarSpec?[4,s]:[3,5];case 4:p.sent(),p.label=5;case 5:return i=n.next(),[3,3];case 6:return[3,9];case 7:return l=p.sent(),d={error:l},[3,9];case 8:try{i&&!i.done&&(h=n.return)&&h.call(n)}finally{if(d)throw d.error}return[7];case 9:return t=e.next(),[3,1];case 10:return[3,13];case 11:return _=p.sent(),u={error:_},[3,13];case 12:try{t&&!t.done&&(c=e.return)&&c.call(e)}finally{if(u)throw u.error}return[7];case 13:return[2]}}))},t.prototype.set_base=function(e){e!=this&&e instanceof this.constructor&&(this.base=e)},t.prototype._configure=function(e,t){Object.defineProperty(this,h.isString(e)?e:e.attr,a.__assign({configurable:!0,enumerable:!0},t))},t.prototype.set_visuals=function(e,t){var r,n,i,o,s,l=function(r){var n=_.base;if(null!=n){var i=n.model.properties[r.attr];if(null!=i&&y.is_equal(r.get_value(),i.get_value()))return _._configure(r,{get:function(){return n[""+r.attr]}}),"continue"}var a=r.uniform(e).select(t);_._configure(r,{value:a})},_=this;try{for(var u=a.__values(this._iter_visuals()),c=u.next();!c.done;c=u.next()){l(c.value)}}catch(e){r={error:e}}finally{try{c&&!c.done&&(n=u.return)&&n.call(u)}finally{if(r)throw r.error}}try{for(var d=a.__values(this.visuals),h=d.next();!h.done;h=d.next()){h.value.update()}}catch(e){i={error:e}}finally{try{h&&!h.done&&(o=d.return)&&o.call(d)}finally{if(i)throw i.error}}null===(s=this.glglyph)||void 0===s||s.set_visuals_changed()},t.prototype.set_data=function(e,t,r){var n,i,s,l=this.renderer.coordinates,_=l.x_source,u=l.y_source,c=new Set(this._iter_visuals());this._data_size=t.count;try{for(var d=a.__values(this.model),h=d.next();!h.done;h=d.next()){var y=h.value;if((y instanceof o.VectorSpec||y instanceof o.ScalarSpec)&&!c.has(y))if(y instanceof o.BaseCoordinateSpec){var v=y.array(e),x=t.select(v),b="x"==y.dimension?_:u;if(b instanceof g.FactorRange)if(y instanceof o.CoordinateSpec)x=b.v_synthetic(x);else if(y instanceof o.CoordinateSeqSpec)for(var m=0;m<x.length;m++)x[m]=b.v_synthetic(x[m]);var w=void 0;w=y instanceof o.CoordinateSeqSpec?p.RaggedArray.from(x,Float64Array):x,this._configure("_"+y.attr,{value:w})}else{var S=y.uniform(e).select(t);if(this._configure(y,{value:S}),y instanceof o.DistanceSpec){var z=S.is_Scalar()?S.value:f.max(S.array);this._configure("max_"+y.attr,{value:z})}}}}catch(e){n={error:e}}finally{try{h&&!h.done&&(i=d.return)&&i.call(d)}finally{if(n)throw n.error}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(null!=r?r:null),null===(s=this.glglyph)||void 0===s||s.set_data_changed(),this.index_data()},t.prototype._set_data=function(e){},Object.defineProperty(t.prototype,"_index_size",{get:function(){return this.data_size},enumerable:!1,configurable:!0}),t.prototype.index_data=function(){var e=new v.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e},t.prototype.mask_data=function(){return null==this._mask_data?d.Indices.all_set(this.data_size):this._mask_data()},t.prototype.map_data=function(){var e,t,r,n=this.renderer.coordinates,i=n.x_scale,s=n.y_scale;try{for(var l=a.__values(this.model),_=l.next();!_.done;_=l.next()){var u=_.value;if(u instanceof o.BaseCoordinateSpec){var c="x"==u.dimension?i:s,d=this["_"+u.attr];if(d instanceof p.RaggedArray){var h=c.v_compute(d.array);d=new p.RaggedArray(d.offsets,h)}else d=c.v_compute(d);this["s"+u.attr]=d}}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=l.return)&&t.call(l)}finally{if(e)throw e.error}}this._map_data(),null===(r=this.glglyph)||void 0===r||r.set_data_changed()},t.prototype._map_data=function(){},t}(_.View);r.GlyphView=w,w.__name__="GlyphView";var S=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t}(u.Model);r.Glyph=S,S.__name__="Glyph"},
function _(t,r,e,n,s){n();var a,o=t(1),i=t(141),f=t(126),u=function(){function t(t,r){this.offsets=t,this.array=r}return t.prototype[(a=Symbol.toStringTag,i.equals)]=function(t,r){return r.arrays(this.offsets,t.offsets)&&r.arrays(this.array,t.array)},Object.defineProperty(t.prototype,"length",{get:function(){return this.offsets.length},enumerable:!1,configurable:!0}),t.prototype.clone=function(){return new t(this.offsets.slice(),this.array.slice())},t.from=function(r,e){for(var n=r.length,s=0,a=function(){for(var t=new Uint32Array(n),e=0;e<n;e++){var a=r[e].length;t[e]=s,s+=a}return s<256?new Uint8Array(t):s<65536?new Uint16Array(t):t}(),o=new e(s),i=0;i<n;i++)o.set(r[i],a[i]);return new t(a,o)},t.prototype[Symbol.iterator]=function(){var t,r,e,n;return o.__generator(this,(function(s){switch(s.label){case 0:r=(t=this).offsets,e=t.length,n=0,s.label=1;case 1:return n<e?[4,this.array.subarray(r[n],r[n+1])]:[3,4];case 2:s.sent(),s.label=3;case 3:return n++,[3,1];case 4:return[2]}}))},t.prototype._check_bounds=function(t){f.assert(0<=t&&t<this.length,"Out of bounds: 0 <= "+t+" < "+this.length)},t.prototype.get=function(t){this._check_bounds(t);var r=this.offsets;return this.array.subarray(r[t],r[t+1])},t.prototype.set=function(t,r){this._check_bounds(t),this.array.set(r,this.offsets[t])},t}();e.RaggedArray=u,u.__name__="RaggedArray",u[a]="RaggedArray"},
function _(t,n,i,e,r){e();var o=t(1),s=o.__importDefault(t(290)),a=t(139),d=t(180);function u(t,n){for(var i=0,e=n.length-1;i<e;){var r=i+e>>1;n[r]>t?e=r:i=r+1}return n[i]}var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n.prototype.search_indices=function(t,n,i,e){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var r=this._boxes.length-4,o=[],s=new a.Indices(this.numItems);void 0!==r;){for(var d=Math.min(r+4*this.nodeSize,u(r,this._levelBounds)),h=r;h<d;h+=4){var l=0|this._indices[h>>2];i<this._boxes[h+0]||(e<this._boxes[h+1]||t>this._boxes[h+2]||n>this._boxes[h+3]||(r<4*this.numItems?s.set(l):o.push(l)))}r=o.pop()}return s},n}(s.default);h.__name__="_FlatBush";var l=function(){function t(t){this.index=null,t>0&&(this.index=new h(t))}return t.prototype.add_rect=function(t,n,i,e){var r;isFinite(t+n+i+e)?null===(r=this.index)||void 0===r||r.add(t,n,i,e):this.add_empty()},t.prototype.add_point=function(t,n){var i;isFinite(t+n)?null===(i=this.index)||void 0===i||i.add(t,n,t,n):this.add_empty()},t.prototype.add_empty=function(){var t;null===(t=this.index)||void 0===t||t.add(1/0,1/0,-1/0,-1/0)},t.prototype.finish=function(){var t;null===(t=this.index)||void 0===t||t.finish()},t.prototype._normalize=function(t){var n,i,e=t.x0,r=t.y0,s=t.x1,a=t.y1;return e>s&&(e=(n=o.__read([s,e],2))[0],s=n[1]),r>a&&(r=(i=o.__read([a,r],2))[0],a=i[1]),{x0:e,y0:r,x1:s,y1:a}},Object.defineProperty(t.prototype,"bbox",{get:function(){if(null==this.index)return d.empty();var t=this.index;return{x0:t.minX,y0:t.minY,x1:t.maxX,y1:t.maxY}},enumerable:!1,configurable:!0}),t.prototype.indices=function(t){if(null==this.index)return new a.Indices(0);var n=this._normalize(t),i=n.x0,e=n.y0,r=n.x1,o=n.y1;return this.index.search_indices(i,e,r,o)},t.prototype.bounds=function(t){var n,i,e=d.empty();try{for(var r=o.__values(this.indices(t)),s=r.next();!s.done;s=r.next()){var a=s.value,u=this.index._boxes,h=u[4*a+0],l=u[4*a+1],x=u[4*a+2],_=u[4*a+3];x<e.x0&&(e.x0=x),h>e.x1&&(e.x1=h),_<e.y0&&(e.y0=_),l>e.y1&&(e.y1=l)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=r.return)&&i.call(r)}finally{if(n)throw n.error}}return e},t}();i.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,i,s,e,r){e();var h=t(1),o=h.__importDefault(t(291)),n=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],a=function(){function t(t,i,s,e){if(void 0===i&&(i=16),void 0===s&&(s=Float64Array),void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535);var r=t,h=r;this._levelBounds=[4*r];do{h+=r=Math.ceil(r/this.nodeSize),this._levelBounds.push(4*h)}while(1!==r);this.ArrayType=s||Float64Array,this.IndexArrayType=h<16384?Uint16Array:Uint32Array;var a=n.indexOf(this.ArrayType),_=4*h*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+s+".");e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=4*h,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+h*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new o.default}return t.from=function(i){if(!(i instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var s=h.__read(new Uint8Array(i,0,2),2),e=s[0],r=s[1];if(251!==e)throw new Error("Data does not appear to be in a Flatbush format.");if(r>>4!=3)throw new Error("Got v"+(r>>4)+" data when expected v3.");var o=h.__read(new Uint16Array(i,2,1),1)[0];return new t(h.__read(new Uint32Array(i,4,1),1)[0],o,n[15&r],i)},t.prototype.add=function(t,i,s,e){var r=this._pos>>2;return this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=i,this._boxes[this._pos++]=s,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),r},t.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);for(var t=this.maxX-this.minX,i=this.maxY-this.minY,s=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var r=4*e,h=this._boxes[r++],o=this._boxes[r++],n=this._boxes[r++],a=this._boxes[r++],_=Math.floor(65535*((h+n)/2-this.minX)/t),d=Math.floor(65535*((o+a)/2-this.minY)/i);s[e]=u(_,d)}x(s,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(e=0,r=0;e<this._levelBounds.length-1;e++)for(var p=this._levelBounds[e];r<p;){for(var m=r,f=1/0,y=1/0,l=-1/0,b=-1/0,v=0;v<this.nodeSize&&r<p;v++)f=Math.min(f,this._boxes[r++]),y=Math.min(y,this._boxes[r++]),l=Math.max(l,this._boxes[r++]),b=Math.max(b,this._boxes[r++]);this._indices[this._pos>>2]=m,this._boxes[this._pos++]=f,this._boxes[this._pos++]=y,this._boxes[this._pos++]=l,this._boxes[this._pos++]=b}},t.prototype.search=function(t,i,s,e,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=[],n=[];void 0!==h;){for(var a=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),_=h;_<a;_+=4){var x=0|this._indices[_>>2];s<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||i>this._boxes[_+3]||(h<4*this.numItems?(void 0===r||r(x))&&n.push(x):o.push(x)))}h=o.pop()}return n},t.prototype.neighbors=function(t,i,s,e,r){if(void 0===s&&(s=1/0),void 0===e&&(e=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=this._queue,n=[],a=e*e;void 0!==h;){for(var x=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),p=h;p<x;p+=4){var u=0|this._indices[p>>2],m=_(t,this._boxes[p],this._boxes[p+2]),f=_(i,this._boxes[p+1],this._boxes[p+3]),y=m*m+f*f;h<4*this.numItems?(void 0===r||r(u))&&o.push(-u-1,y):o.push(u,y)}for(;o.length&&o.peek()<0;){if((y=o.peekValue())>a)return o.clear(),n;if(n.push(-o.pop()-1),n.length===s)return o.clear(),n}h=o.pop()}return o.clear(),n},t}();function _(t,i,s){return t<i?i-t:t<=s?0:t-s}function d(t,i){for(var s=0,e=i.length-1;s<e;){var r=s+e>>1;i[r]>t?e=r:s=r+1}return i[s]}function x(t,i,s,e,r,h){if(!(Math.floor(e/h)>=Math.floor(r/h))){for(var o=t[e+r>>1],n=e-1,a=r+1;;){do{n++}while(t[n]<o);do{a--}while(t[a]>o);if(n>=a)break;p(t,i,s,n,a)}x(t,i,s,e,a,h),x(t,i,s,a+1,r,h)}}function p(t,i,s,e,r){var h=t[e];t[e]=t[r],t[r]=h;var o=4*e,n=4*r,a=i[o],_=i[o+1],d=i[o+2],x=i[o+3];i[o]=i[n],i[o+1]=i[n+1],i[o+2]=i[n+2],i[o+3]=i[n+3],i[n]=a,i[n+1]=_,i[n+2]=d,i[n+3]=x;var p=s[e];s[e]=s[r],s[r]=p}function u(t,i){var s=t^i,e=65535^s,r=65535^(t|i),h=t&(65535^i),o=s|e>>1,n=s>>1^s,a=r>>1^e&h>>1^r,_=s&r>>1^h>>1^h;n=(s=o)&(e=n)>>2^e&(s^e)>>2,a^=s&(r=a)>>2^e&(h=_)>>2,_^=e&r>>2^(s^e)&h>>2,n=(s=o=s&s>>2^e&e>>2)&(e=n)>>4^e&(s^e)>>4,a^=s&(r=a)>>4^e&(h=_)>>4,_^=e&r>>4^(s^e)&h>>4,a^=(s=o=s&s>>4^e&e>>4)&(r=a)>>8^(e=n)&(h=_)>>8;var d=t^i,x=(e=(_^=e&r>>8^(s^e)&h>>8)^_>>1)|65535^(d|(s=a^a>>1));return((x=1431655765&((x=858993459&((x=252645135&((x=16711935&(x|x<<8))|x<<4))|x<<2))|x<<1))<<1|(d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1)))>>>0}s.default=a},
function _(t,i,s,h,e){h();var n=function(){function t(){this.ids=[],this.values=[],this.length=0}return t.prototype.clear=function(){this.length=0},t.prototype.push=function(t,i){var s=this.length++;for(this.ids[s]=t,this.values[s]=i;s>0;){var h=s-1>>1,e=this.values[h];if(i>=e)break;this.ids[s]=this.ids[h],this.values[s]=e,s=h}this.ids[s]=t,this.values[s]=i},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var i=this.ids[0]=this.ids[this.length],s=this.values[0]=this.values[this.length],h=this.length>>1,e=0;e<h;){var n=1+(e<<1),l=n+1,u=this.ids[n],r=this.values[n],a=this.values[l];if(l<this.length&&a<r&&(n=l,u=this.ids[l],r=a),r>=s)break;this.ids[e]=u,this.values[e]=r,e=n}this.ids[e]=i,this.values[e]=s}return t}},t.prototype.peek=function(){if(0!==this.length)return this.ids[0]},t.prototype.peekValue=function(){if(0!==this.length)return this.values[0]},t}();s.default=n},
function _(e,a,n,r,i){r();var l=e(1),t=l.__importStar(e(293));function _(e,a,n,r){var i=n.x0,l=n.x1,t=n.y0,_=n.y1;a.save(),a.beginPath(),a.moveTo(i,(t+_)/2),a.lineTo(l,(t+_)/2),e.line.apply(a,r),a.restore()}function c(e,a,n,r){var i,l,t=n.x0,_=n.x1,c=n.y0,o=n.y1,v=.1*Math.abs(_-t),y=.1*Math.abs(o-c),p=t+v,s=_-v,d=c+y,g=o-y;a.beginPath(),a.rect(p,d,s-p,g-d),e.fill.apply(a,r),null===(i=e.hatch)||void 0===i||i.apply(a,r),null===(l=e.line)||void 0===l||l.apply(a,r)}n.generic_line_scalar_legend=function(e,a,n){var r=n.x0,i=n.x1,l=n.y0,t=n.y1;a.save(),a.beginPath(),a.moveTo(r,(l+t)/2),a.lineTo(i,(l+t)/2),e.line.apply(a),a.restore()},n.generic_line_vector_legend=_,n.generic_line_legend=_,n.generic_area_scalar_legend=function(e,a,n){var r,i,l=n.x0,t=n.x1,_=n.y0,c=n.y1,o=.1*Math.abs(t-l),v=.1*Math.abs(c-_),y=l+o,p=t-o,s=_+v,d=c-v;a.beginPath(),a.rect(y,s,p-y,d-s),e.fill.apply(a),null===(r=e.hatch)||void 0===r||r.apply(a),null===(i=e.line)||void 0===i||i.apply(a)},n.generic_area_vector_legend=c,n.generic_area_legend=c,n.line_interpolation=function(e,a,n,r,i,_){var c,o,v,y,p,s,d,g,h,x,u=a.sx,b=a.sy;"point"==a.type?(h=(c=l.__read(e.yscale.r_invert(b-1,b+1),2))[0],x=c[1],d=(o=l.__read(e.xscale.r_invert(u-1,u+1),2))[0],g=o[1]):"v"==a.direction?(h=(v=l.__read(e.yscale.r_invert(b,b),2))[0],x=v[1],d=(y=l.__read([Math.min(n-1,i-1),Math.max(n+1,i+1)],2))[0],g=y[1]):(d=(p=l.__read(e.xscale.r_invert(u,u),2))[0],g=p[1],h=(s=l.__read([Math.min(r-1,_-1),Math.max(r+1,_+1)],2))[0],x=s[1]);var f=t.check_2_segments_intersect(d,h,g,x,n,r,i,_);return[f.x,f.y]}},
function _(t,n,r,o,a){function e(t,n){return Math.pow(t.x-n.x,2)+Math.pow(t.y-n.y,2)}function h(t,n,r){var o=e(n,r);if(0==o)return e(t,n);var a=((t.x-n.x)*(r.x-n.x)+(t.y-n.y)*(r.y-n.y))/o;return e(t,a<0?n:a>1?r:{x:n.x+a*(r.x-n.x),y:n.y+a*(r.y-n.y)})}o(),r.point_in_poly=function(t,n,r,o){for(var a=!1,e=r[r.length-1],h=o[o.length-1],i=0;i<r.length;i++){var s=r[i],u=o[i];h<n!=u<n&&e+(n-h)/(u-h)*(s-e)<t&&(a=!a),e=s,h=u}return a},r.point_in_ellipse=function(t,n,r,o,a,e,h){var i=Math.pow(Math.cos(r)/a,2)+Math.pow(Math.sin(r)/o,2),s=2*Math.cos(r)*Math.sin(r)*(Math.pow(1/a,2)-Math.pow(1/o,2)),u=Math.pow(Math.cos(r)/o,2)+Math.pow(Math.sin(r)/a,2);return i*Math.pow(t-e,2)+s*(t-e)*(n-h)+u*Math.pow(n-h,2)<=1},r.dist_2_pts=e,r.dist_to_segment_squared=h,r.dist_to_segment=function(t,n,r){return Math.sqrt(h(t,n,r))},r.check_2_segments_intersect=function(t,n,r,o,a,e,h,i){var s=(i-e)*(r-t)-(h-a)*(o-n);if(0==s)return{hit:!1,x:null,y:null};var u=n-e,M=t-a,p=(h-a)*u-(i-e)*M;return M=((r-t)*u-(o-n)*M)/s,{hit:(u=p/s)>0&&u<1&&M>0&&M<1,x:t+u*(r-t),y:n+u*(o-n)}}},
function _(i,s,t,e,_){e();var h=i(1),a=i(295),l=i(137),n=i(161),r=i(296),o=-1e4,p=function(i){function s(s,t){var e=i.call(this,s,t)||this;return e.glyph=t,e._antialias=1.5,e._miter_limit=5,e}return h.__extends(s,i),s.prototype.draw=function(i,s,t){var e=s.glglyph;this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),e.data_changed&&(e._set_data(),e.data_changed=!1);var _=this.glyph.visuals.line,h=r.cap_lookup[_.line_cap.value],a=r.join_lookup[_.line_join.value];if(this._is_dashed()){var l={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[t.width,t.height],pixel_ratio:t.pixel_ratio,line_color:this._color,linewidth:this._linewidth,antialias:this._antialias,miter_limit:this._miter_limit,points:e._points.buffer,nsegments:e._nsegments,line_join:a,line_cap:h,length_so_far:e._length_so_far.buffer,dash_tex:this._dash_tex,dash_tex_info:this._dash_tex_info,dash_scale:this._dash_scale,dash_offset:this._dash_offset};this.regl_wrapper.dashed_line()(l)}else{l={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[t.width,t.height],pixel_ratio:t.pixel_ratio,line_color:this._color,linewidth:this._linewidth,antialias:this._antialias,miter_limit:this._miter_limit,points:e._points.buffer,nsegments:e._nsegments,line_join:a,line_cap:h};this.regl_wrapper.solid_line()(l)}},s.prototype._is_dashed=function(){return this._line_dash.length>0},s.prototype._set_data=function(){var i=this.glyph.sx.length;this._nsegments=i-1,null==this._is_closed&&(this._is_closed=this.glyph.sx[0]==this.glyph.sx[i-1]&&this.glyph.sy[0]==this.glyph.sy[i-1]&&isFinite(this.glyph.sx[0])&&isFinite(this.glyph.sy[0]));for(var s=this.get_buffer_array(this._points,2*(i+2)),t=1;t<i+1;t++)isFinite(this.glyph.sx[t-1])&&isFinite(this.glyph.sy[t-1])?(s[2*t]=this.glyph.sx[t-1],s[2*t+1]=this.glyph.sy[t-1]):(s[2*t]=o,s[2*t+1]=o);if(this._is_closed?(s[0]=s[2*i-2],s[1]=s[2*i-1],s[2*i+2]=s[4],s[2*i+3]=s[5]):(s[0]=o,s[1]=o,s[2*i+2]=o,s[2*i+3]=o),this._points=this.update_buffer(this._points,s),this._is_dashed()){var e=this.get_buffer_array(this._length_so_far,this._nsegments),_=0;for(t=0;t<this._nsegments;t++)e[t]=_,s[2*t+2]>-9e3&&s[2*t+4]>-9e3&&(_+=Math.sqrt(Math.pow(s[2*t+4]-s[2*t+2],2)+Math.pow(s[2*t+5]-s[2*t+3],2)));this._length_so_far=this.update_buffer(this._length_so_far,e)}},s.prototype._set_visuals=function(){var i,s=this.glyph.visuals.line,t=l.color2rgba(s.line_color.value,s.line_alpha.value);this._color=t.map((function(i){return i/255})),this._linewidth=s.line_width.value,this._linewidth<1&&(this._color[3]*=this._linewidth,this._linewidth=1),this._line_dash=n.resolve_line_dash(s.line_dash.value),1==this._line_dash.length&&this._line_dash.push(this._line_dash[0]),this._is_dashed()&&(i=h.__read(this.regl_wrapper.get_dash(this._line_dash),3),this._dash_tex_info=i[0],this._dash_tex=i[1],this._dash_scale=i[2],this._dash_offset=s.line_dash_offset.value)},s}(a.BaseGLGlyph);t.LineGL=p,p.__name__="LineGL"},
function _(e,t,a,r,i){r();var n=function(){function e(e,t){this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.regl_wrapper=e}return e.prototype.set_data_changed=function(){var e=this.glyph.data_size;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0},e.prototype.set_visuals_changed=function(){this.visuals_changed=!0},e.prototype.render=function(e,t,a){if(0==t.length)return!0;var r=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,i=r.width,n=r.height,h={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:i,height:n};return this.draw(t,a,h),!0},e.prototype.get_buffer_array=function(e,t){return null==e||e.array.length!=t?new Float32Array(t):e.array},e.prototype.update_buffer=function(e,t){return null==e?e={array:t,buffer:this.regl_wrapper.buffer({usage:"dynamic",type:"float",data:t})}:(e.array=t,e.buffer({data:t})),e},e}();a.BaseGLGlyph=n,n.__name__="BaseGLGlyph"},
function _(r,a,n,l,t){l();var o=r(1),e=r(137),i=r(167);n.cap_lookup={butt:0,round:1,square:2},n.join_lookup={miter:0,round:1,bevel:2};var _={blank:0,dot:1,ring:2,horizontal_line:3,vertical_line:4,cross:5,horizontal_dash:6,vertical_dash:7,spiral:8,right_diagonal_line:9,left_diagonal_line:10,diagonal_cross:11,right_diagonal_dash:12,left_diagonal_dash:13,horizontal_wave:14,vertical_wave:15,criss_cross:16};function u(r){var a,n;return null!==(n=_[null!==(a=i.hatch_aliases[r])&&void 0!==a?a:r])&&void 0!==n?n:0}n.color_to_uint8_array=function(r,a){for(var n=r.is_Scalar()&&a.is_Scalar()?1:r.length,l=new Uint8Array(4*n),t=0;t<n;t++){var i=o.__read(e.color2rgba(r.get(t),a.get(t)),4),_=i[0],u=i[1],s=i[2],c=i[3];l[4*t]=_,l[4*t+1]=u,l[4*t+2]=s,l[4*t+3]=c}return l},n.prop_as_array=function(r){if(null==r)return[];if(r.is_Scalar())return[r.value];for(var a=new Float32Array(r.length),n=0;n<r.length;n++)a[n]=r.get(n);return a},n.hatch_pattern_prop_as_array=function(r){if(null==r)return[];if(r.is_Scalar())return[u(r.value)];for(var a=new Float32Array(r.length),n=0;n<r.length;n++)a[n]=u(r.get(n));return a},n.line_join_prop_as_array=function(r){if(null==r)return[];if(r.is_Scalar())return[n.join_lookup[r.value]];for(var a=new Float32Array(r.length),l=0;l<r.length;l++)a[l]=n.join_lookup[r.get(l)];return a}},
function _(t,i,e,n,a){n();var r=t(1),l=t(286),s=t(292),o=r.__importStar(t(293)),_=r.__importStar(t(163)),h=t(187),c=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype._render=function(t,i,e){var n,a,l=null!=e?e:this,s=l.sx,o=l.sy,_=!0;t.beginPath();try{for(var h=r.__values(i),c=h.next();!c.done;c=h.next()){var p=c.value,u=s[p],y=o[p];isFinite(u+y)?_?(t.moveTo(u,y),_=!1):t.lineTo(u,y):(t.closePath(),_=!0)}}catch(t){n={error:t}}finally{try{c&&!c.done&&(a=h.return)&&a.call(h)}finally{if(n)throw n.error}}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)},i.prototype.draw_legend_for_index=function(t,i,e){s.generic_area_scalar_legend(this.visuals,t,i)},i.prototype._hit_point=function(t){var i=new h.Selection;return o.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.view=this),i},i}(l.XYGlyphView);e.PatchView=c,c.__name__="PatchView";var p=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_Patch=function(){this.prototype.default_view=c,this.mixins([_.LineScalar,_.FillScalar,_.HatchScalar])},i}(l.XYGlyph);e.Patch=p,p.__name__="Patch",p.init_Patch()},
function _(t,e,i,r,n){r();var s=t(1),a=t(139),o=t(299),h=s.__importStar(t(293)),_=s.__importStar(t(133)),l=t(187),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x1[n],a=this._x2[n],o=this._y[n];t.add_rect(e(s,a),o,i(s,a),o)}},e.prototype._render=function(t,e,i){var r=null!=i?i:this,n=r.sx1,s=r.sx2,a=r.sy;t.beginPath();for(var o=0,h=n.length;o<h;o++)t.lineTo(n[o],a[o]);for(o=s.length-1;o>=0;o--)t.lineTo(s[o],a[o]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)},e.prototype._hit_point=function(t){for(var e=this.sy.length,i=new a.ScreenArray(2*e),r=new a.ScreenArray(2*e),n=0,s=e;n<s;n++)i[n]=this.sx1[n],r[n]=this.sy[n],i[e+n]=this.sx2[e-n-1],r[e+n]=this.sy[e-n-1];var o=new l.Selection;return h.point_in_poly(t.sx,t.sy,i,r)&&(o.add_to_selected_glyphs(this.model),o.view=this),o},e.prototype.scenterxy=function(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(o.AreaView);i.HAreaView=p,p.__name__="HAreaView";var c=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_HArea=function(){this.prototype.default_view=p,this.define((function(t){return{x1:[_.XCoordinateSpec,{field:"x1"}],x2:[_.XCoordinateSpec,{field:"x2"}],y:[_.YCoordinateSpec,{field:"y"}]}}))},e}(o.Area);i.HArea=c,c.__name__="HArea",c.init_HArea()},
function _(n,e,i,r,t){r();var a=n(1),_=n(287),l=n(292),c=a.__importStar(n(163)),u=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return a.__extends(e,n),e.prototype.draw_legend_for_index=function(n,e,i){l.generic_area_scalar_legend(this.visuals,n,e)},e}(_.GlyphView);i.AreaView=u,u.__name__="AreaView";var s=function(n){function e(e){return n.call(this,e)||this}return a.__extends(e,n),e.init_Area=function(){this.mixins([c.FillScalar,c.HatchScalar])},e}(_.Glyph);i.Area=s,s.__name__="Area",s.init_Area()},
function _(t,e,i,r,n){r();var s=t(1),a=t(139),o=t(299),h=s.__importStar(t(293)),_=s.__importStar(t(133)),y=t(187),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x[n],a=this._y1[n],o=this._y2[n];t.add_rect(s,e(a,o),s,i(a,o))}},e.prototype._render=function(t,e,i){var r=null!=i?i:this,n=r.sx,s=r.sy1,a=r.sy2;t.beginPath();for(var o=0,h=s.length;o<h;o++)t.lineTo(n[o],s[o]);for(o=a.length-1;o>=0;o--)t.lineTo(n[o],a[o]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)},e.prototype.scenterxy=function(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]},e.prototype._hit_point=function(t){for(var e=this.sx.length,i=new a.ScreenArray(2*e),r=new a.ScreenArray(2*e),n=0,s=e;n<s;n++)i[n]=this.sx[n],r[n]=this.sy1[n],i[e+n]=this.sx[e-n-1],r[e+n]=this.sy2[e-n-1];var o=new y.Selection;return h.point_in_poly(t.sx,t.sy,i,r)&&(o.add_to_selected_glyphs(this.model),o.view=this),o},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(o.AreaView);i.VAreaView=l,l.__name__="VAreaView";var p=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_VArea=function(){this.prototype.default_view=l,this.define((function(t){return{x:[_.XCoordinateSpec,{field:"x"}],y1:[_.YCoordinateSpec,{field:"y1"}],y2:[_.YCoordinateSpec,{field:"y2"}]}}))},e}(o.Area);i.VArea=p,p.__name__="VArea",p.init_VArea()},
function _(n,i,t,e,s){e();var r=n(1),c=n(168),o=n(187),u=n(139),a=n(302),_=n(185),l=function(n){function i(i){return n.call(this,i)||this}return r.__extends(i,n),i.init_CDSView=function(){this.define((function(n){var i=n.Array,t=n.Ref;return{filters:[i(t(a.Filter)),[]],source:[t(_.ColumnarDataSource)]}})),this.internal((function(n){var i=n.Int,t=n.Dict,e=n.Ref,s=n.Nullable;return{indices:[e(u.Indices)],indices_map:[t(i),{}],masked:[s(e(u.Indices)),null]}}))},i.prototype.initialize=function(){n.prototype.initialize.call(this),this.compute_indices()},i.prototype.connect_signals=function(){var i=this;n.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,(function(){return i.compute_indices()}));var t=function(){var n=function(){return i.compute_indices()};null!=i.source&&(i.connect(i.source.change,n),i.source instanceof _.ColumnarDataSource&&(i.connect(i.source.streaming,n),i.connect(i.source.patching,n)))},e=null!=this.source;e?t():this.connect(this.properties.source.change,(function(){e||(t(),e=!0)}))},i.prototype.compute_indices=function(){var n,i,t,e=this.source;if(null!=e){var s=null!==(t=e.get_length())&&void 0!==t?t:1,c=u.Indices.all_set(s);try{for(var o=r.__values(this.filters),a=o.next();!a.done;a=o.next()){var _=a.value;c.intersect(_.compute_indices(e))}}catch(i){n={error:i}}finally{try{a&&!a.done&&(i=o.return)&&i.call(o)}finally{if(n)throw n.error}}this.indices=c,this._indices=r.__spreadArray([],r.__read(c)),this.indices_map_to_subset()}},i.prototype.indices_map_to_subset=function(){this.indices_map={};for(var n=0;n<this._indices.length;n++)this.indices_map[this._indices[n]]=n},i.prototype.convert_selection_from_subset=function(n){var i=this,t=n.indices.map((function(n){return i._indices[n]}));return new o.Selection(r.__assign(r.__assign({},n.attributes),{indices:t}))},i.prototype.convert_selection_to_subset=function(n){var i=this,t=n.indices.map((function(n){return i.indices_map[n]}));return new o.Selection(r.__assign(r.__assign({},n.attributes),{indices:t}))},i.prototype.convert_indices_from_subset=function(n){var i=this;return n.map((function(n){return i._indices[n]}))},i}(c.Model);t.CDSView=l,l.__name__="CDSView",l.init_CDSView()},
function _(n,t,e,i,r){i();var _=n(1),l=function(n){function t(t){return n.call(this,t)||this}return _.__extends(t,n),t}(n(168).Model);e.Filter=l,l.__name__="Filter"},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(254).BasicTickFormatter),c("CategoricalTickFormatter",t(250).CategoricalTickFormatter),c("DatetimeTickFormatter",t(258).DatetimeTickFormatter),c("FuncTickFormatter",t(304).FuncTickFormatter),c("LogTickFormatter",t(271).LogTickFormatter),c("MercatorTickFormatter",t(274).MercatorTickFormatter),c("NumeralTickFormatter",t(305).NumeralTickFormatter),c("PrintfTickFormatter",t(306).PrintfTickFormatter),c("TickFormatter",t(244).TickFormatter)},
function _(t,n,r,e,i){e();var a=t(1),o=t(244),c=t(128),u=t(149),s=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_FuncTickFormatter=function(){this.define((function(t){var n=t.Unknown,r=t.String;return{args:[(0,t.Dict)(n),{}],code:[r,""]}}))},Object.defineProperty(n.prototype,"names",{get:function(){return c.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return c.values(this.args)},enumerable:!1,configurable:!0}),n.prototype._make_func=function(){var t=u.use_strict(this.code);return new(Function.bind.apply(Function,a.__spreadArray(a.__spreadArray([void 0,"tick","index","ticks"],a.__read(this.names)),[t])))},n.prototype.doFormat=function(t,n){var r=this,e=this._make_func().bind({});return t.map((function(t,n,i){return""+e.apply(void 0,a.__spreadArray([t,n,i],a.__read(r.values)))}))},n}(o.TickFormatter);r.FuncTickFormatter=s,s.__name__="FuncTickFormatter",s.init_FuncTickFormatter()},
function _(r,n,t,e,o){e();var a=r(1),i=a.__importStar(r(261)),u=r(244),c=r(135),f=function(r){function n(n){return r.call(this,n)||this}return a.__extends(n,r),n.init_NumeralTickFormatter=function(){this.define((function(r){var n=r.String;return{format:[n,"0,0"],language:[n,"en"],rounding:[c.RoundingFunction,"round"]}}))},Object.defineProperty(n.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!1,configurable:!0}),n.prototype.doFormat=function(r,n){var t=this,e=t.format,o=t.language,a=t._rounding_fn;return r.map((function(r){return i.format(r,e,o,a)}))},n}(u.TickFormatter);t.NumeralTickFormatter=f,f.__name__="NumeralTickFormatter",f.init_NumeralTickFormatter()},
function _(t,r,n,i,o){i();var e=t(1),f=t(244),a=t(260),c=function(t){function r(r){return t.call(this,r)||this}return e.__extends(r,t),r.init_PrintfTickFormatter=function(){this.define((function(t){return{format:[t.String,"%s"]}}))},r.prototype.doFormat=function(t,r){var n=this;return t.map((function(t){return a.sprintf(n.format,t)}))},r}(f.TickFormatter);n.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(308).CategoricalColorMapper),e("CategoricalMarkerMapper",r(310).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(311).CategoricalPatternMapper),e("ContinuousColorMapper",r(280).ContinuousColorMapper),e("ColorMapper",r(281).ColorMapper),e("LinearColorMapper",r(312).LinearColorMapper),e("LogColorMapper",r(313).LogColorMapper),e("ScanningColorMapper",r(279).ScanningColorMapper),e("EqHistColorMapper",r(314).EqHistColorMapper)},
function _(t,r,o,a,e){a();var n=t(1),i=t(309),c=t(281),l=t(182),p=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_CategoricalColorMapper=function(){this.define((function(t){var r=t.Number,o=t.Nullable;return{factors:[l.FactorSeq],start:[r,0],end:[o(r),null]}}))},r.prototype._v_compute=function(t,r,o,a){var e=a.nan_color;i.cat_v_compute(t,this.factors,o,r,this.start,this.end,e)},r}(c.ColorMapper);o.CategoricalColorMapper=p,p.__name__="CategoricalColorMapper",p.init_CategoricalColorMapper()},
function _(n,t,e,i,l){i();var r=n(127),u=n(123);function f(n,t){if(n.length!=t.length)return!1;for(var e=0,i=n.length;e<i;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,i,l,o,c){for(var a=n.length,v=function(a){var v=n[a],_=void 0;u.isString(v)?_=r.index_of(t,v):(null!=l?v=null!=o?v.slice(l,o):v.slice(l):null!=o&&(v=v.slice(0,o)),_=1==v.length?r.index_of(t,v[0]):r.find_index(t,(function(n){return f(n,v)})));var g=void 0;g=_<0||_>=e.length?c:e[_],i[a]=g},_=0;_<a;_++)v(_)}},
function _(r,e,t,a,n){a();var i=r(1),c=r(309),u=r(182),l=r(282),o=r(135),p=function(r){function e(e){return r.call(this,e)||this}return i.__extends(e,r),e.init_CategoricalMarkerMapper=function(){this.define((function(r){var e=r.Number,t=r.Array,a=r.Nullable;return{factors:[u.FactorSeq],markers:[t(o.MarkerType)],start:[e,0],end:[a(e),null],default_value:[o.MarkerType,"circle"]}}))},e.prototype.v_compute=function(r){var e=new Array(r.length);return c.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(l.Mapper);t.CategoricalMarkerMapper=p,p.__name__="CategoricalMarkerMapper",p.init_CategoricalMarkerMapper()},
function _(t,e,a,r,n){r();var i=t(1),c=t(309),u=t(182),p=t(282),o=t(135),l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_CategoricalPatternMapper=function(){this.define((function(t){var e=t.Number,a=t.Array,r=t.Nullable;return{factors:[u.FactorSeq],patterns:[a(o.HatchPatternType)],start:[e,0],end:[r(e),null],default_value:[o.HatchPatternType," "]}}))},e.prototype.v_compute=function(t){var e=new Array(t.length);return c.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(p.Mapper);a.CategoricalPatternMapper=l,l.__name__="CategoricalPatternMapper",l.init_CategoricalPatternMapper()},
function _(n,r,t,o,i){o();var a=n(1),e=n(280),l=n(127),u=function(n){function r(r){return n.call(this,r)||this}return a.__extends(r,n),r.prototype.scan=function(n,r){var t=null!=this.low?this.low:l.min(n),o=null!=this.high?this.high:l.max(n);return{max:o,min:t,norm_factor:1/(o-t),normed_interval:1/r}},r.prototype.cmap=function(n,r,t,o,i){var a=r.length-1;if(n==i.max)return r[a];var e=(n-i.min)*i.norm_factor,l=Math.floor(e/i.normed_interval);return l<0?t:l>a?o:r[l]},r}(e.ContinuousColorMapper);t.LinearColorMapper=u,u.__name__="LinearColorMapper"},
function _(t,n,o,r,a){r();var i=t(1),l=t(280),e=t(127),h=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.prototype.scan=function(t,n){var o=null!=this.low?this.low:e.min(t),r=null!=this.high?this.high:e.max(t);return{max:r,min:o,scale:n/(Math.log(r)-Math.log(o))}},n.prototype.cmap=function(t,n,o,r,a){var i=n.length-1;if(t>a.max)return r;if(t==a.max)return n[i];if(t<a.min)return o;var l=Math.log(t)-Math.log(a.min),e=Math.floor(l*a.scale);return e>i&&(e=i),n[e]},n}(l.ContinuousColorMapper);o.LogColorMapper=h,h.__name__="LogColorMapper"},
function _(n,i,r,t,e){t();var o=n(1),a=n(279),l=n(127),s=n(124),u=n(134),h=function(n){function i(i){return n.call(this,i)||this}return o.__extends(i,n),i.init_EqHistColorMapper=function(){this.define((function(n){return{bins:[n.Int,65536]}}))},i.prototype.scan=function(n,i){for(var r=null!=this.low?this.low:l.min(n),t=null!=this.high?this.high:l.max(n),e=this.bins,o=s.linspace(r,t,e+1),a=l.bin_counts(n,o),h=new Array(e),p=0,c=o.length;p<c-1;p++){var g=o[p],f=o[p+1];h[p]=(g+f)/2}for(var m=s.cumsum(a),_=m[m.length-1],v=l.map(m,(function(n){return n/_})),M=i-1,q=[],C=0,H=2*i;M!=i&&C<4&&0!=M;){var b=H/M;if(b>1e3)break;H=Math.round(Math.max(i*b,i));var d=s.range(0,H),w=l.map(v,(function(n){return n*(H-1)}));q=l.interpolate(d,w,h),M=s.uniq(q).length-1,C++}if(0==M){q=[r,t];for(var E=0;E<i-1;E++)q.push(t)}else q=q.slice(q.length-i-1),M!=i&&u.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return q[0]=r,q[q.length-1]=t,{min:r,max:t,binning:q}},i}(a.ScanningColorMapper);r.EqHistColorMapper=h,h.__name__="EqHistColorMapper",h.init_EqHistColorMapper()},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(177).CategoricalScale),n("ContinuousScale",a(175).ContinuousScale),n("LinearScale",a(174).LinearScale),n("LinearInterpolationScale",a(316).LinearInterpolationScale),n("LogScale",a(176).LogScale),n("Scale",a(170).Scale)},
function _(e,n,r,t,a){t();var o=e(1),i=e(170),c=e(174),u=e(127),l=function(e){function n(n){return e.call(this,n)||this}return o.__extends(n,e),n.init_LinearInterpolationScale=function(){this.internal((function(e){return{binning:[e.Arrayable],linear_scale:[(0,e.Ref)(c.LinearScale),function(e){return new c.LinearScale({source_range:e.source_range,target_range:e.target_range})}]}}))},n.prototype.connect_signals=function(){var n=this;e.prototype.connect_signals.call(this);var r=this.properties,t=r.source_range,a=r.target_range;this.on_change([t,a],(function(){n.linear_scale=new c.LinearScale({source_range:n.source_range,target_range:n.target_range})}))},Object.defineProperty(n.prototype,"s_compute",{get:function(){throw new Error("not implemented")},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"s_invert",{get:function(){throw new Error("not implemented")},enumerable:!1,configurable:!0}),n.prototype.compute=function(e){return e},n.prototype.v_compute=function(e){for(var n=this.binning,r=this.source_range,t=r.start,a=r.end,o=t,i=a,c=n.length,l=(a-t)/(c-1),_=new Float64Array(c),p=0;p<c;p++)_[p]=t+p*l;var s=u.map(e,(function(e){if(e<o)return o;if(e>i)return i;var r=u.left_edge_index(e,n),t=n[r],a=(e-t)/(n[r+1]-t),c=_[r];return c+a*(_[r+1]-c)}));return this.linear_scale.v_compute(s)},n.prototype.invert=function(e){return e},n.prototype.v_invert=function(e){return new Float64Array(e)},n}(i.Scale);r.LinearInterpolationScale=l,l.__name__="LinearInterpolationScale",l.init_LinearInterpolationScale()},
function _(a,n,e,g,R){g(),R("DataRange",a(179).DataRange),R("DataRange1d",a(178).DataRange1d),R("FactorRange",a(182).FactorRange),R("Range",a(172).Range),R("Range1d",a(173).Range1d)},
function _(a,o,i,t,e){t();var n=a(236);e("Sizeable",n.Sizeable),e("SizingPolicy",n.SizingPolicy);var c=a(237);e("Layoutable",c.Layoutable),e("LayoutItem",c.LayoutItem);var r=a(319);e("HStack",r.HStack),e("VStack",r.VStack);var l=a(320);e("Grid",l.Grid),e("Row",l.Row),e("Column",l.Column);var S=a(321);e("ContentBox",S.ContentBox),e("VariadicBox",S.VariadicBox)},
function _(t,e,r,n,i){n();var h=t(1),a=t(237),o=t(180),l=function(t){function e(){var e=t.apply(this,h.__spreadArray([],h.__read(arguments)))||this;return e.children=[],e}return h.__extends(e,t),e.prototype[Symbol.iterator]=function(){return h.__generator(this,(function(t){switch(t.label){case 0:return[5,h.__values(this.children)];case 1:return t.sent(),[2]}}))},e}(a.Layoutable);r.Stack=l,l.__name__="Stack";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(e,t),e.prototype._measure=function(t){var e,r,n=0,i=0;try{for(var a=h.__values(this.children),o=a.next();!o.done;o=a.next()){var l=o.value.measure({width:0,height:0});n+=l.width,i=Math.max(i,l.height)}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return{width:n,height:i}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e.top:0,l=this.absolute?e.left:0,u=e.height;try{for(var s=h.__values(this.children),c=s.next();!c.done;c=s.next()){var _=c.value,d=_.measure({width:0,height:0}).width;_.set_geometry(new o.BBox({left:l,width:d,top:a,height:u})),l+=d}}catch(t){n={error:t}}finally{try{c&&!c.done&&(i=s.return)&&i.call(s)}finally{if(n)throw n.error}}},e}(l);r.HStack=u,u.__name__="HStack";var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(e,t),e.prototype._measure=function(t){var e,r,n=0,i=0;try{for(var a=h.__values(this.children),o=a.next();!o.done;o=a.next()){var l=o.value.measure({width:0,height:0});n=Math.max(n,l.width),i+=l.height}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return{width:n,height:i}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e.left:0,l=this.absolute?e.top:0,u=e.width;try{for(var s=h.__values(this.children),c=s.next();!c.done;c=s.next()){var _=c.value,d=_.measure({width:0,height:0}).height;_.set_geometry(new o.BBox({top:l,height:d,left:a,width:u})),l+=d}}catch(t){n={error:t}}finally{try{c&&!c.done&&(i=s.return)&&i.call(s)}finally{if(n)throw n.error}}},e}(l);r.VStack=s,s.__name__="VStack";var c=function(t){function e(){var e=t.apply(this,h.__spreadArray([],h.__read(arguments)))||this;return e.children=[],e}return h.__extends(e,t),e.prototype[Symbol.iterator]=function(){return h.__generator(this,(function(t){switch(t.label){case 0:return[5,h.__values(this.children)];case 1:return t.sent(),[2]}}))},e.prototype._measure=function(t){var e,r,n=this,i=this.sizing,a=i.width_policy,o=i.height_policy,l=Math.min,u=Math.max,s=0,c=0;try{for(var _=h.__values(this.children),d=_.next();!d.done;d=_.next()){var f=d.value.measure(t),g=f.width,y=f.height;s=u(s,g),c=u(c,y)}}catch(t){e={error:t}}finally{try{d&&!d.done&&(r=_.return)&&r.call(_)}finally{if(e)throw e.error}}return{width:function(){var e=n.sizing.width;if(t.width==1/0)return"fixed"==a&&null!=e?e:s;switch(a){case"fixed":return null!=e?e:s;case"min":return s;case"fit":return null!=e?l(t.width,e):t.width;case"max":return null!=e?u(t.width,e):t.width}}(),height:function(){var e=n.sizing.height;if(t.height==1/0)return"fixed"==o&&null!=e?e:c;switch(o){case"fixed":return null!=e?e:c;case"min":return c;case"fit":return null!=e?l(t.height,e):t.height;case"max":return null!=e?u(t.height,e):t.height}}()}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e:e.relative(),l=a.left,u=a.right,s=a.top,c=a.bottom,_=Math.round(a.vcenter),d=Math.round(a.hcenter),f=function(t){var r=t.sizing,n=r.margin,i=r.halign,h=r.valign,a=t.measure(e),f=a.width,g=a.height,y=a.inner,w=function(){switch(h+"_"+i){case"start_start":return new o.BBox({left:l+n.left,top:s+n.top,width:f,height:g});case"start_center":return new o.BBox({hcenter:d,top:s+n.top,width:f,height:g});case"start_end":return new o.BBox({right:u-n.right,top:s+n.top,width:f,height:g});case"center_start":return new o.BBox({left:l+n.left,vcenter:_,width:f,height:g});case"center_center":return new o.BBox({hcenter:d,vcenter:_,width:f,height:g});case"center_end":return new o.BBox({right:u-n.right,vcenter:_,width:f,height:g});case"end_start":return new o.BBox({left:l+n.left,bottom:c-n.bottom,width:f,height:g});case"end_center":return new o.BBox({hcenter:d,bottom:c-n.bottom,width:f,height:g});case"end_end":return new o.BBox({right:u-n.right,bottom:c-n.bottom,width:f,height:g})}}(),v=null==y?w:new o.BBox({left:w.left+y.left,top:w.top+y.top,right:w.right-y.right,bottom:w.bottom-y.bottom});t.set_geometry(w,v)};try{for(var g=h.__values(this.children),y=g.next();!y.done;y=g.next()){f(y.value)}}catch(t){n={error:t}}finally{try{y&&!y.done&&(i=g.return)&&i.call(g)}finally{if(n)throw n.error}}},e}(a.Layoutable);r.NodeLayout=c,c.__name__="NodeLayout"},
function _(t,i,r,e,n){e();var o=t(1),a=t(236),s=t(237),l=t(123),c=t(180),h=t(124),u=Math.max,f=Math.round,p=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i},t.prototype.apply=function(t,i){var r=this.get(t);this._map.set(t,i(r))},t}();p.__name__="DefaultMap";var _=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!1,configurable:!0}),t.prototype.add=function(t,i){var r=t.r1,e=t.c1;this._nrows=u(this._nrows,r+1),this._ncols=u(this._ncols,e+1),this._items.push({span:t,data:i})},t.prototype.at=function(t,i){return this._items.filter((function(r){var e=r.span;return e.r0<=t&&t<=e.r1&&e.c0<=i&&i<=e.c1})).map((function(t){return t.data}))},t.prototype.row=function(t){return this._items.filter((function(i){var r=i.span;return r.r0<=t&&t<=r.r1})).map((function(t){return t.data}))},t.prototype.col=function(t){return this._items.filter((function(i){var r=i.span;return r.c0<=t&&t<=r.c1})).map((function(t){return t.data}))},t.prototype.foreach=function(t){var i,r;try{for(var e=o.__values(this._items),n=e.next();!n.done;n=e.next()){var a=n.value;t(a.span,a.data)}}catch(t){i={error:t}}finally{try{n&&!n.done&&(r=e.return)&&r.call(e)}finally{if(i)throw i.error}}},t.prototype.map=function(i){var r,e,n=new t;try{for(var a=o.__values(this._items),s=a.next();!s.done;s=a.next()){var l=s.value,c=l.span,h=l.data;n.add(c,i(c,h))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(e=a.return)&&e.call(a)}finally{if(r)throw r.error}}return n},t}();_.__name__="Container";var g=function(t){function i(i){void 0===i&&(i=[]);var r=t.call(this)||this;return r.items=i,r.rows="auto",r.cols="auto",r.spacing=0,r}return o.__extends(i,t),i.prototype[Symbol.iterator]=function(){var t,i,r,e,n;return o.__generator(this,(function(a){switch(a.label){case 0:a.trys.push([0,5,6,7]),t=o.__values(this.items),i=t.next(),a.label=1;case 1:return i.done?[3,4]:[4,i.value.layout];case 2:a.sent(),a.label=3;case 3:return i=t.next(),[3,1];case 4:return[3,7];case 5:return r=a.sent(),e={error:r},[3,7];case 6:try{i&&!i.done&&(n=t.return)&&n.call(t)}finally{if(e)throw e.error}return[7];case 7:return[2]}}))},i.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var i=this._state.cols;return h.some(i,(function(t){return"max"==t.policy}))},i.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var i=this._state.rows;return h.some(i,(function(t){return"max"==t.policy}))},i.prototype._init=function(){var i,r,e,n,a,s,c=this;t.prototype._init.call(this);var u=new _;try{for(var f=o.__values(this.items),p=f.next();!p.done;p=f.next()){var g=p.value,d=g.layout,y=g.row,w=g.col,v=g.row_span,m=g.col_span;if(d.sizing.visible){var x=y,b=w,z=y+(null!=v?v:1)-1,B=w+(null!=m?m:1)-1;u.add({r0:x,c0:b,r1:z,c1:B},d)}}}catch(t){i={error:t}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(i)throw i.error}}for(var M=u.nrows,j=u.ncols,A=new Array(M),O=function(t){var i=function(){var i,r=l.isPlainObject(c.rows)?null!==(i=c.rows[t])&&void 0!==i?i:c.rows["*"]:c.rows;return null==r?{policy:"auto"}:l.isNumber(r)?{policy:"fixed",height:r}:l.isString(r)?{policy:r}:r}(),r=null!==(e=i.align)&&void 0!==e?e:"auto";if("fixed"==i.policy)A[t]={policy:"fixed",height:i.height,align:r};else if("min"==i.policy)A[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)A[t]={policy:i.policy,flex:null!==(n=i.flex)&&void 0!==n?n:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");h.some(u.row(t),(function(t){return t.is_height_expanding()}))?A[t]={policy:"max",flex:1,align:r}:A[t]={policy:"min",align:r}}},P=0;P<M;P++)O(P);for(var S=new Array(j),C=function(t){var i=function(){var i,r=l.isPlainObject(c.cols)?null!==(i=c.cols[t])&&void 0!==i?i:c.cols["*"]:c.cols;return null==r?{policy:"auto"}:l.isNumber(r)?{policy:"fixed",width:r}:l.isString(r)?{policy:r}:r}(),r=null!==(a=i.align)&&void 0!==a?a:"auto";if("fixed"==i.policy)S[t]={policy:"fixed",width:i.width,align:r};else if("min"==i.policy)S[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)S[t]={policy:i.policy,flex:null!==(s=i.flex)&&void 0!==s?s:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");h.some(u.col(t),(function(t){return t.is_width_expanding()}))?S[t]={policy:"max",flex:1,align:r}:S[t]={policy:"min",align:r}}},N=0;N<j;N++)C(N);var E=o.__read(l.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,2),G=E[0],R=E[1];this._state={items:u,nrows:M,ncols:j,rows:A,cols:S,rspacing:G,cspacing:R}},i.prototype._measure_totals=function(t,i){var r=this._state,e=r.nrows,n=r.ncols,o=r.rspacing,a=r.cspacing;return{height:h.sum(t)+(e-1)*o,width:h.sum(i)+(n-1)*a}},i.prototype._measure_cells=function(t){for(var i=this._state,r=i.items,e=i.nrows,n=i.ncols,s=i.rows,l=i.cols,c=i.rspacing,h=i.cspacing,p=new Array(e),g=0;g<e;g++){var d=s[g];p[g]="fixed"==d.policy?d.height:0}for(var y=new Array(n),w=0;w<n;w++){var v=l[w];y[w]="fixed"==v.policy?v.width:0}var m=new _;return r.foreach((function(i,r){for(var e,n,_,g,d=i.r0,w=i.c0,v=i.r1,x=i.c1,b=(v-d)*c,z=(x-w)*h,B=0,M=d;M<=v;M++)B+=t(M,w).height;B+=b;for(var j=0,A=w;A<=x;A++)j+=t(d,A).width;j+=z;var O=r.measure({width:j,height:B});m.add(i,{layout:r,size_hint:O});var P=new a.Sizeable(O).grow_by(r.sizing.margin);P.height-=b,P.width-=z;var S=[];for(M=d;M<=v;M++){var C=s[M];"fixed"==C.policy?P.height-=C.height:S.push(M)}if(P.height>0){var N=f(P.height/S.length);try{for(var E=o.__values(S),G=E.next();!G.done;G=E.next()){M=G.value;p[M]=u(p[M],N)}}catch(t){e={error:t}}finally{try{G&&!G.done&&(n=E.return)&&n.call(E)}finally{if(e)throw e.error}}}var R=[];for(A=w;A<=x;A++){var D=l[A];"fixed"==D.policy?P.width-=D.width:R.push(A)}if(P.width>0){var L=f(P.width/R.length);try{for(var k=o.__values(R),q=k.next();!q.done;q=k.next()){A=q.value;y[A]=u(y[A],L)}}catch(t){_={error:t}}finally{try{q&&!q.done&&(g=k.return)&&g.call(k)}finally{if(_)throw _.error}}}})),{size:this._measure_totals(p,y),row_heights:p,col_widths:y,size_hints:m}},i.prototype._measure_grid=function(t){var i=this,r=this._state,e=r.nrows,n=r.ncols,o=r.rows,a=r.cols,s=r.rspacing,l=r.cspacing,c=function(r){var n;n="fixed"==i.sizing.height_policy&&null!=i.sizing.height?i.sizing.height:t.height!=1/0&&i.is_height_expanding()?Math.max(t.height,r.size.height):r.size.height;for(var a=0,l=0;l<e;l++){"max"==(p=o[l]).policy?a+=p.flex:n-=r.row_heights[l]}if(n-=(e-1)*s,0!=a&&n>0)for(l=0;l<e;l++){if("max"==(p=o[l]).policy)n-=_=f(n*(p.flex/a)),r.row_heights[l]=_,a-=p.flex}else if(n<0){var c=0;for(l=0;l<e;l++){"fixed"!=(p=o[l]).policy&&c++}var h=-n;for(l=0;l<e;l++){var p;if("fixed"!=(p=o[l]).policy){var _=r.row_heights[l],g=f(h/c);r.row_heights[l]=u(_-g,0),h-=g>_?_:g,c--}}}},h=function(r){var e;e="fixed"==i.sizing.width_policy&&null!=i.sizing.width?i.sizing.width:t.width!=1/0&&i.is_width_expanding()?t.width:r.size.width;for(var o=0,s=0;s<n;s++){"fit"==(p=a[s]).policy||"max"==p.policy?o+=p.flex:e-=r.col_widths[s]}if(e-=(n-1)*l,0!=o&&e>0)for(s=0;s<n;s++){if("fit"==(p=a[s]).policy||"max"==p.policy)e-=_=f(e*(p.flex/o)),r.col_widths[s]=_,o-=p.flex}else if(e<0){var c=0;for(s=0;s<n;s++){"fixed"!=(p=a[s]).policy&&c++}var h=-e;for(s=0;s<n;s++){var p;if("fixed"!=(p=a[s]).policy){var _=r.col_widths[s],g=f(h/c);r.col_widths[s]=u(_-g,0),h-=g>_?_:g,c--}}}},p=this._measure_cells((function(t,i){var r=o[t],e=a[i];return{width:"fixed"==e.policy?e.width:1/0,height:"fixed"==r.policy?r.height:1/0}}));c(p),h(p);var _=this._measure_cells((function(t,i){return{width:p.col_widths[i],height:p.row_heights[t]}}));c(_),h(_);var g=_.row_heights,d=_.col_widths;return{size:this._measure_totals(g,d),row_heights:g,col_widths:d}},i.prototype._measure=function(t){return this._measure_grid(t).size},i.prototype._set_geometry=function(i,r){var e=this;t.prototype._set_geometry.call(this,i,r);for(var n=this._state,a=n.nrows,s=n.ncols,l=n.rspacing,h=n.cspacing,_=this._measure_grid(i),g=_.row_heights,d=_.col_widths,y=this._measure_cells((function(t,i){return{width:d[i],height:g[t]}})).size_hints,w=this._state.rows.map((function(t,i){return o.__assign(o.__assign({},t),{top:0,height:g[i],get bottom(){return this.top+this.height}})})),v=this._state.cols.map((function(t,i){return o.__assign(o.__assign({},t),{left:0,width:d[i],get right(){return this.left+this.width}})})),m=y.map((function(t,i){return o.__assign(o.__assign({},i),{outer:new c.BBox,inner:new c.BBox})})),x=0,b=this.absolute?i.top:0;x<a;x++){var z=w[x];z.top=b,b+=z.height+l}for(var B=0,M=this.absolute?i.left:0;B<s;B++){var j=v[B];j.left=M,M+=j.width+h}m.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.layout,s=i.size_hint,u=a.sizing,p=s.width,_=s.height,g=function(t,i){for(var r=(i-t)*h,e=t;e<=i;e++)r+=v[e].width;return r}(e,o),d=function(t,i){for(var r=(i-t)*l,e=t;e<=i;e++)r+=w[e].height;return r}(r,n),y=e==o&&"auto"!=v[e].align?v[e].align:u.halign,m=r==n&&"auto"!=w[r].align?w[r].align:u.valign,x=v[e].left;"start"==y?x+=u.margin.left:"center"==y?x+=f((g-p)/2):"end"==y&&(x+=g-u.margin.right-p);var b=w[r].top;"start"==m?b+=u.margin.top:"center"==m?b+=f((d-_)/2):"end"==m&&(b+=d-u.margin.bottom-_),i.outer=new c.BBox({left:x,top:b,width:p,height:_})}));var A=w.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}})),O=v.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}}));m.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,s=i.outer,l=a.inner;null!=l&&(A[r].start.apply(s.top,(function(t){return u(t,l.top)})),A[n].end.apply(w[n].bottom-s.bottom,(function(t){return u(t,l.bottom)})),O[e].start.apply(s.left,(function(t){return u(t,l.left)})),O[o].end.apply(v[o].right-s.right,(function(t){return u(t,l.right)})))})),m.foreach((function(t,i){var r=t.r0,n=t.c0,o=t.r1,a=t.c1,s=i.size_hint,l=i.outer,h=function(t){var i=e.absolute?l:l.relative(),r=i.left+t.left,n=i.top+t.top,o=i.right-t.right,a=i.bottom-t.bottom;return new c.BBox({left:r,top:n,right:o,bottom:a})};if(null!=s.inner){var u=h(s.inner);if(!1!==s.align){var f=A[r].start.get(l.top),p=A[o].end.get(w[o].bottom-l.bottom),_=O[n].start.get(l.left),g=O[a].end.get(v[a].right-l.right);try{u=h({top:f,bottom:p,left:_,right:g})}catch(t){}}i.inner=u}else i.inner=l})),m.foreach((function(t,i){var r=i.layout,e=i.outer,n=i.inner;r.set_geometry(e,n)}))},i}(s.Layoutable);r.Grid=g,g.__name__="Grid";var d=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:0,col:i}})),r.rows="fit",r}return o.__extends(i,t),i}(g);r.Row=d,d.__name__="Row";var y=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:i,col:0}})),r.cols="fit",r}return o.__extends(i,t),i}(g);r.Column=y,y.__name__="Column"},
function _(e,t,n,i,a){i();var r=e(1),o=e(237),c=e(236),_=e(158),u=function(e){function t(t){var n=e.call(this)||this;return n.content_size=_.unsized(t,(function(){return new c.Sizeable(_.size(t))})),n}return r.__extends(t,e),t.prototype._content_size=function(){return this.content_size},t}(o.ContentLayoutable);n.ContentBox=u,u.__name__="ContentBox";var s=function(e){function t(t){var n=e.call(this)||this;return n.el=t,n}return r.__extends(t,e),t.prototype._measure=function(e){var t=this,n=new c.Sizeable(e).bounded_to(this.sizing.size);return _.sized(this.el,n,(function(){var e=new c.Sizeable(_.content_size(t.el)),n=_.extents(t.el),i=n.border,a=n.padding;return e.grow_by(i).grow_by(a).map(Math.ceil)}))},t}(o.Layoutable);n.VariadicBox=s,s.__name__="VariadicBox";var h=function(e){function t(t){var n=e.call(this,t)||this;return n._cache=new Map,n}return r.__extends(t,e),t.prototype._measure=function(t){var n=t.width+","+t.height,i=this._cache.get(n);return null==i&&(i=e.prototype._measure.call(this,t),this._cache.set(n,i)),i},t.prototype.invalidate_cache=function(){this._cache.clear()},t}(s);n.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(t,e,i,h,r){h();var o=t(1),n=t(236),s=t(237),a=t(180),g=function(t){function e(){var e=t.apply(this,o.__spreadArray([],o.__read(arguments)))||this;return e.min_border={left:0,top:0,right:0,bottom:0},e.padding={left:0,top:0,right:0,bottom:0},e}return o.__extends(e,t),e.prototype[Symbol.iterator]=function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,this.top_panel];case 1:return t.sent(),[4,this.bottom_panel];case 2:return t.sent(),[4,this.left_panel];case 3:return t.sent(),[4,this.right_panel];case 4:return t.sent(),[4,this.center_panel];case 5:return t.sent(),[2]}}))},e.prototype._measure=function(t){var e=this;t=new n.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});var i,h,r,o=this.left_panel.measure({width:0,height:t.height}),s=Math.max(o.width,this.min_border.left)+this.padding.left,a=this.right_panel.measure({width:0,height:t.height}),g=Math.max(a.width,this.min_border.right)+this.padding.right,p=this.top_panel.measure({width:t.width,height:0}),_=Math.max(p.height,this.min_border.top)+this.padding.top,d=this.bottom_panel.measure({width:t.width,height:0}),l=Math.max(d.height,this.min_border.bottom)+this.padding.bottom,m=new n.Sizeable(t).shrink_by({left:s,right:g,top:_,bottom:l}),w=this.center_panel.measure(m);return{width:s+w.width+g,height:_+w.height+l,inner:{left:s,right:g,top:_,bottom:l},align:(i=e.center_panel.sizing,h=i.width_policy,r=i.height_policy,"fixed"!=h&&"fixed"!=r)}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i),this.center_panel.set_geometry(i);var h=this.left_panel.measure({width:0,height:e.height}),r=this.right_panel.measure({width:0,height:e.height}),o=this.top_panel.measure({width:e.width,height:0}),n=this.bottom_panel.measure({width:e.width,height:0}),s=i.left,g=i.top,p=i.right,_=i.bottom;this.top_panel.set_geometry(new a.BBox({left:s,right:p,bottom:g,height:o.height})),this.bottom_panel.set_geometry(new a.BBox({left:s,right:p,top:_,height:n.height})),this.left_panel.set_geometry(new a.BBox({top:g,bottom:_,right:s,width:h.width})),this.right_panel.set_geometry(new a.BBox({top:g,bottom:_,left:p,width:r.width}))},e}(s.Layoutable);i.BorderLayout=g,g.__name__="BorderLayout"},
function _(t,e,i,n,s){n();var o=t(1),l=t(234),a=t(125),_=t(238),r=t(135),h=o.__importStar(t(163)),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype._get_size=function(){var t=this.layer.ctx;return this.visuals.text.set_value(t),{width:t.measureText(this.model.text).width,height:_.font_metrics(t.font).height}},e.prototype._render=function(){var t=this.model,e=t.angle,i=t.angle_units,n=a.resolve_angle(e,i),s=null!=this.layout?this.layout:this.plot_view.frame,o=this.coordinates.x_scale,l=this.coordinates.y_scale,_="data"==this.model.x_units?o.compute(this.model.x):s.bbox.xview.compute(this.model.x),r="data"==this.model.y_units?l.compute(this.model.y):s.bbox.yview.compute(this.model.y);_+=this.model.x_offset,r-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,_,r,n)},e}(l.TextAnnotationView);i.LabelView=u,u.__name__="LabelView";var d=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Label=function(){this.prototype.default_view=u,this.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),this.define((function(t){var e=t.Number,i=t.String,n=t.Angle;return{x:[e],x_units:[r.SpatialUnits,"data"],y:[e],y_units:[r.SpatialUnits,"data"],text:[i,""],angle:[n,0],angle_units:[r.AngleUnits,"rad"],x_offset:[e,0],y_offset:[e,0]}})),this.override({background_fill_color:null,border_line_color:null})},e}(l.TextAnnotation);i.Label=d,d.__name__="Label",d.init_Label()},
function _(t,e,i,s,o){s();var n=t(1),a=t(234),r=t(184),l=t(190),_=n.__importStar(t(163)),c=t(135),h=t(158),u=n.__importStar(t(133)),d=t(238),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.set_data=function(t){r.DataAnnotationView.prototype.set_data.call(this,t)},e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this.text.length;e<i;e++){var s=h.div({style:{display:"none"}});this.el.appendChild(s)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var i=function(){e.set_data(e.model.source),"css"==e.model.render_mode?e.render():e.request_render()};this.connect(this.model.change,i),this.connect(this.model.source.streaming,i),this.connect(this.model.source.patching,i),this.connect(this.model.source.change,i)},e.prototype._calculate_text_dimensions=function(t,e){return[t.measureText(e).width,d.font_metrics(this.visuals.text.font_value(0)).height]},e.prototype._map_data=function(){var t=this.coordinates.x_scale,e=this.coordinates.y_scale,i=null!=this.layout?this.layout:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):i.bbox.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):i.bbox.yview.v_compute(this._y)]},e.prototype._render=function(){for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.layer.ctx,i=n.__read(this._map_data(),2),s=i[0],o=i[1],a=0,r=this.text.length;a<r;a++)t(e,a,this.text.get(a),s[a]+this.x_offset.get(a),o[a]-this.y_offset.get(a),this.angle.get(a))},e.prototype._get_size=function(){var t=this.layer.ctx;return this.visuals.text.set_vectorize(t,0),{width:t.measureText(this.text.get(0)).width,height:d.font_metrics(t.font).height}},e.prototype._v_canvas_text=function(t,e,i,s,o,n){this.visuals.text.set_vectorize(t,e);var a=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(s,o),t.rotate(n),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.apply(t,e),this.visuals.border_line.apply(t,e),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,i,s,o,a){var r=this.el.children[e];r.textContent=i,this.visuals.text.set_vectorize(t,e);var l=n.__read(this._calculate_bounding_box_dimensions(t,i),2),_=l[0],c=l[1];r.style.position="absolute",r.style.left=s+_+"px",r.style.top=o+c+"px",r.style.color=t.fillStyle,r.style.font=t.font,r.style.lineHeight="normal",a&&(r.style.transform="rotate("+a+"rad)"),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),r.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),r.style.borderStyle=t.lineDash.length<2?"solid":"dashed",r.style.borderWidth=t.lineWidth+"px",r.style.borderColor=t.strokeStyle),h.display(r)},e}(a.TextAnnotationView);i.LabelSetView=p,p.__name__="LabelSetView";var v=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_LabelSet=function(){this.prototype.default_view=p,this.mixins([_.TextVector,["border_",_.LineVector],["background_",_.FillVector]]),this.define((function(t){var e=t.Ref;return{x:[u.XCoordinateSpec,{field:"x"}],y:[u.YCoordinateSpec,{field:"y"}],x_units:[c.SpatialUnits,"data"],y_units:[c.SpatialUnits,"data"],text:[u.StringSpec,{field:"text"}],angle:[u.AngleSpec,0],x_offset:[u.NumberSpec,{value:0}],y_offset:[u.NumberSpec,{value:0}],source:[e(l.ColumnDataSource),function(){return new l.ColumnDataSource}]}})),this.override({background_fill_color:null,border_line_color:null})},e}(a.TextAnnotation);i.LabelSet=v,v.__name__="LabelSet",v.init_LabelSet()},
function _(e,t,i,r,l){r();var n=e(1),a=e(155),o=e(326),_=e(135),s=n.__importStar(e(163)),h=e(130),d=e(235),c=e(238),u=e(180),f=e(124),g=e(123),v=e(126),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.update_layout=function(){var e=this,t=this.panel;this.layout=null!=t?new d.SideLayout(t,(function(){return e.get_size()})):void 0},t.prototype.cursor=function(e,t){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(t.prototype,"legend_padding",{get:function(){return null!=this.model.border_line_color?this.model.padding:0},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.item_change,(function(){return t.request_render()}))},t.prototype.compute_legend_bbox=function(){var e,t,i,r,l=this.model.get_legend_names(),a=this.model,o=a.glyph_height,_=a.glyph_width,s=this.model,h=s.label_height,d=s.label_width;this.max_label_height=f.max([c.font_metrics(this.visuals.label_text.font_value()).height,h,o]);var p=this.layer.ctx;p.save(),this.visuals.label_text.set_value(p),this.text_widths=new Map;try{for(var m=n.__values(l),y=m.next();!y.done;y=m.next()){var x=y.value;this.text_widths.set(x,f.max([p.measureText(x).width,d]))}}catch(t){e={error:t}}finally{try{y&&!y.done&&(t=m.return)&&t.call(m)}finally{if(e)throw e.error}}this.visuals.title_text.set_value(p),this.title_height=this.model.title?c.font_metrics(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?p.measureText(this.model.title).width:0,p.restore();var b,w,k=Math.max(f.max(n.__spreadArray([],n.__read(this.text_widths.values()))),0),L=this.model.margin,T=this.legend_padding,z=this.model.spacing,A=this.model.label_standoff;if("vertical"==this.model.orientation)b=l.length*this.max_label_height+Math.max(l.length-1,0)*z+2*T+this.title_height,w=f.max([k+_+A+2*T,this.title_width+2*T]);else{var S=2*T+Math.max(l.length-1,0)*z;try{for(var B=n.__values(this.text_widths),M=B.next();!M.done;M=B.next()){var P=n.__read(M.value,2)[1];S+=f.max([P,d])+_+A}}catch(e){i={error:e}}finally{try{M&&!M.done&&(r=B.return)&&r.call(B)}finally{if(i)throw i.error}}w=f.max([this.title_width+2*T,S]),b=this.max_label_height+this.title_height+2*T}var O,V,q=null!=this.layout?this.layout:this.plot_view.frame,F=n.__read(q.bbox.ranges,2),N=F[0],j=F[1],C=this.model.location;if(g.isString(C))switch(C){case"top_left":O=N.start+L,V=j.start+L;break;case"top":case"top_center":O=(N.end+N.start)/2-w/2,V=j.start+L;break;case"top_right":O=N.end-L-w,V=j.start+L;break;case"bottom_right":O=N.end-L-w,V=j.end-L-b;break;case"bottom":case"bottom_center":O=(N.end+N.start)/2-w/2,V=j.end-L-b;break;case"bottom_left":O=N.start+L,V=j.end-L-b;break;case"left":case"center_left":O=N.start+L,V=(j.end+j.start)/2-b/2;break;case"center":case"center_center":O=(N.end+N.start)/2-w/2,V=(j.end+j.start)/2-b/2;break;case"right":case"center_right":O=N.end-L-w,V=(j.end+j.start)/2-b/2}else if(g.isArray(C)&&2==C.length){var I=n.__read(C,2),R=I[0],D=I[1];O=q.bbox.xview.compute(R),V=q.bbox.yview.compute(D)-b}else v.unreachable();return new u.BBox({left:O,top:V,width:w,height:b})},t.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},t.prototype.interactive_hit=function(e,t){return this.interactive_bbox().contains(e,t)},t.prototype.on_hit=function(e,t){var i,r,l,a,o,_,s,h,d,c,f,g=this.model.glyph_width,v=this.legend_padding,p=this.model.spacing,m=this.model.label_standoff,y=f=v,x=this.compute_legend_bbox(),b="vertical"==this.model.orientation;try{for(var w=n.__values(this.model.items),k=w.next();!k.done;k=w.next()){var L=k.value,T=L.get_labels_list_from_label_prop();try{for(var z=(l=void 0,n.__values(T)),A=z.next();!A.done;A=z.next()){var S=A.value,B=x.x+y,M=x.y+f+this.title_height,P=void 0,O=void 0;if(b?(P=(o=n.__read([x.width-2*v,this.max_label_height],2))[0],O=o[1]):(P=(_=n.__read([this.text_widths.get(S)+g+m,this.max_label_height],2))[0],O=_[1]),new u.BBox({left:B,top:M,width:P,height:O}).contains(e,t)){switch(this.model.click_policy){case"hide":try{for(var V=(s=void 0,n.__values(L.renderers)),q=V.next();!q.done;q=V.next()){(j=q.value).visible=!j.visible}}catch(e){s={error:e}}finally{try{q&&!q.done&&(h=V.return)&&h.call(V)}finally{if(s)throw s.error}}break;case"mute":try{for(var F=(d=void 0,n.__values(L.renderers)),N=F.next();!N.done;N=F.next()){var j;(j=N.value).muted=!j.muted}}catch(e){d={error:e}}finally{try{N&&!N.done&&(c=F.return)&&c.call(F)}finally{if(d)throw d.error}}}return!0}b?f+=this.max_label_height+p:y+=this.text_widths.get(S)+g+m+p}}catch(e){l={error:e}}finally{try{A&&!A.done&&(a=z.return)&&a.call(z)}finally{if(l)throw l.error}}}}catch(e){i={error:e}}finally{try{k&&!k.done&&(r=w.return)&&r.call(w)}finally{if(i)throw i.error}}return!1},t.prototype._render=function(){var e,t;if(0!=this.model.items.length){try{for(var i=n.__values(this.model.items),r=i.next();!r.done;r=i.next()){r.value.legend=this.model}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}var l=this.layer.ctx,a=this.compute_legend_bbox();l.save(),this._draw_legend_box(l,a),this._draw_legend_items(l,a),this._draw_title(l,a),l.restore()}},t.prototype._draw_legend_box=function(e,t){e.beginPath(),e.rect(t.x,t.y,t.width,t.height),this.visuals.background_fill.apply(e),this.visuals.border_line.apply(e)},t.prototype._draw_legend_items=function(e,t){var i,r,l=this,a=this.model,o=a.glyph_width,_=a.glyph_height,s=this.legend_padding,h=this.model.spacing,d=this.model.label_standoff,c=s,u=s,g="vertical"==this.model.orientation,v=function(i){var r,a,v,m,y,x,b=i.get_labels_list_from_label_prop(),w=i.get_field_from_label_prop();if(0==b.length)return"continue";var k=function(){switch(l.model.click_policy){case"none":return!0;case"hide":return f.every(i.renderers,(function(e){return e.visible}));case"mute":return f.every(i.renderers,(function(e){return!e.muted}))}}();try{for(var L=(r=void 0,n.__values(b)),T=L.next();!T.done;T=L.next()){var z=T.value,A=t.x+c,S=t.y+u+p.title_height,B=A+o,M=S+_;g?u+=p.max_label_height+h:c+=p.text_widths.get(z)+o+d+h,p.visuals.label_text.set_value(e),e.fillText(z,B+d,S+p.max_label_height/2);try{for(var P=(v=void 0,n.__values(i.renderers)),O=P.next();!O.done;O=P.next()){var V=O.value,q=p.plot_view.renderer_view(V);null==q||q.draw_legend(e,A,B,S,M,w,z,i.index)}}catch(e){v={error:e}}finally{try{O&&!O.done&&(m=P.return)&&m.call(P)}finally{if(v)throw v.error}}if(!k){var F=void 0,N=void 0;g?(F=(y=n.__read([t.width-2*s,p.max_label_height],2))[0],N=y[1]):(F=(x=n.__read([p.text_widths.get(z)+o+d,p.max_label_height],2))[0],N=x[1]),e.beginPath(),e.rect(A,S,F,N),p.visuals.inactive_fill.set_value(e),e.fill()}}}catch(e){r={error:e}}finally{try{T&&!T.done&&(a=L.return)&&a.call(L)}finally{if(r)throw r.error}}},p=this;try{for(var m=n.__values(this.model.items),y=m.next();!y.done;y=m.next()){v(y.value)}}catch(e){i={error:e}}finally{try{y&&!y.done&&(r=m.return)&&r.call(m)}finally{if(i)throw i.error}}},t.prototype._draw_title=function(e,t){var i=this.model.title;i&&this.visuals.title_text.doit&&(e.save(),e.translate(t.x0,t.y0+this.title_height),this.visuals.title_text.set_value(e),e.fillText(i,this.legend_padding,this.legend_padding-this.model.title_standoff),e.restore())},t.prototype._get_size=function(){var e=this.compute_legend_bbox(),t=e.width,i=e.height;return{width:t+2*this.model.margin,height:i+2*this.model.margin}},t}(a.AnnotationView);i.LegendView=p,p.__name__="LegendView";var m=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.item_change=new h.Signal0(this,"item_change")},t.init_Legend=function(){this.prototype.default_view=p,this.mixins([["label_",s.Text],["title_",s.Text],["inactive_",s.Fill],["border_",s.Line],["background_",s.Fill]]),this.define((function(e){var t=e.Number,i=e.String,r=e.Array,l=e.Tuple,n=e.Or,a=e.Ref,s=e.Nullable;return{orientation:[_.Orientation,"vertical"],location:[n(_.LegendLocation,l(t,t)),"top_right"],title:[s(i),null],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[r(a(o.LegendItem)),[]],click_policy:[_.LegendClickPolicy,"none"]}})),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},t.prototype.get_legend_names=function(){var e,t,i=[];try{for(var r=n.__values(this.items),l=r.next();!l.done;l=r.next()){var a=l.value.get_labels_list_from_label_prop();i.push.apply(i,n.__spreadArray([],n.__read(a)))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return i},t}(a.Annotation);i.Legend=m,m.__name__="Legend",m.init_Legend()},
function _(e,r,n,t,l){t();var i=e(1),o=e(168),a=e(283),u=e(185),_=e(327),s=i.__importStar(e(133)),d=e(134),c=e(124),f=function(e){function r(r){return e.call(this,r)||this}return i.__extends(r,e),r.init_LegendItem=function(){this.define((function(e){var r=e.Int,n=e.Array,t=e.Ref,l=e.Nullable;return{label:[s.NullStringSpec,null],renderers:[n(t(a.GlyphRenderer)),[]],index:[l(r),null]}}))},r.prototype._check_data_sources_on_renderers=function(){var e,r;if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;var n=this.renderers[0].data_source;if(null!=n)try{for(var t=i.__values(this.renderers),l=t.next();!l.done;l=t.next()){if(l.value.data_source!=n)return!1}}catch(r){e={error:r}}finally{try{l&&!l.done&&(r=t.return)&&r.call(t)}finally{if(e)throw e.error}}}return!0},r.prototype._check_field_label_on_data_source=function(){var e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;var r=this.renderers[0].data_source;if(null!=r&&!c.includes(r.columns(),e))return!1}return!0},r.prototype.initialize=function(){var r=this;e.prototype.initialize.call(this),this.legend=null,this.connect(this.change,(function(){var e;return null===(e=r.legend)||void 0===e?void 0:e.item_change.emit()})),this._check_data_sources_on_renderers()||d.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||d.logger.error("Bad column name on label: "+this.label)},r.prototype.get_field_from_label_prop=function(){var e=this.label;return _.isField(e)?e.field:null},r.prototype.get_labels_list_from_label_prop=function(){if(_.isValue(this.label)){var e=this.label.value;return null!=e?[e]:[]}var r=this.get_field_from_label_prop();if(null!=r){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof u.ColumnarDataSource){var t=n.get_column(r);return null!=t?c.uniq(Array.from(t)):["Invalid field"]}}return[]},r}(o.Model);n.LegendItem=f,f.__name__="LegendItem",f.init_LegendItem()},
function _(i,n,e,t,r){t();var u=i(123);e.isValue=function(i){return u.isPlainObject(i)&&"value"in i},e.isField=function(i){return u.isPlainObject(i)&&"field"in i},e.isExpr=function(i){return u.isPlainObject(i)&&"expr"in i}},
function _(t,n,i,e,o){e();var s=t(1),a=t(155),l=s.__importStar(t(163)),r=t(135),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.request_render()}))},n.prototype._render=function(){var t=this.model,n=t.xs,i=t.ys;if(n.length==i.length){var e=n.length;if(!(e<3)){var o=this.plot_view.frame,s=this.layer.ctx,a=this.coordinates.x_scale,l=this.coordinates.y_scale,r=this.model.screen,c=u(n,this.model.xs_units,a,o.bbox.xview),h=u(i,this.model.ys_units,l,o.bbox.yview);s.beginPath();for(var _=0;_<e;_++)s.lineTo(c[_],h[_]);s.closePath(),this.visuals.fill.apply(s),this.visuals.hatch.apply(s),this.visuals.line.apply(s)}}function u(t,n,i,e){return r?t:"data"==n?i.v_compute(t):e.v_compute(t)}},n}(a.AnnotationView);i.PolyAnnotationView=c,c.__name__="PolyAnnotationView";var h=function(t){function n(n){return t.call(this,n)||this}return s.__extends(n,t),n.init_PolyAnnotation=function(){this.prototype.default_view=c,this.mixins([l.Line,l.Fill,l.Hatch]),this.define((function(t){var n=t.Number,i=t.Array;return{xs:[i(n),[]],xs_units:[r.SpatialUnits,"data"],ys:[i(n),[]],ys_units:[r.SpatialUnits,"data"]}})),this.internal((function(t){return{screen:[t.Boolean,!1]}})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},n.prototype.update=function(t){var n=t.xs,i=t.ys;this.setv({xs:n,ys:i,screen:!0},{check_eq:!1})},n}(a.Annotation);i.PolyAnnotation=h,h.__name__="PolyAnnotation",h.init_PolyAnnotation()},
function _(t,e,n,i,o){i();var r=t(1),l=t(155),s=r.__importStar(t(163)),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.request_render()}))},e.prototype._render=function(){var t=this.model,e=t.gradient,n=t.y_intercept;if(null!=e&&null!=n){var i,o,r,l,s=this.plot_view.frame,a=this.coordinates.x_scale,c=this.coordinates.y_scale;if(0==e)o=i=c.compute(n),l=(r=s.bbox.left)+s.bbox.width;else{o=(i=s.bbox.top)+s.bbox.height;var u=(c.invert(i)-n)/e,_=(c.invert(o)-n)/e;r=a.compute(u),l=a.compute(_)}var p=this.layer.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(r,i),p.lineTo(l,o),p.stroke(),p.restore()}},e}(l.AnnotationView);n.SlopeView=a,a.__name__="SlopeView";var c=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Slope=function(){this.prototype.default_view=a,this.mixins(s.Line),this.define((function(t){var e=t.Number,n=t.Nullable;return{gradient:[n(e),null],y_intercept:[n(e),null]}})),this.override({line_color:"black"})},e}(l.Annotation);n.Slope=c,c.__name__="Slope",c.init_Slope()},
function _(t,n,i,e,o){e();var a=t(1),r=t(155),s=a.__importStar(t(163)),l=t(135),h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.plot_view.request_paint(n)}))},n.prototype._render=function(){var t=this,n=this.model.location;if(null!=n){var i,e,o,a,r=this.plot_view.frame,s=this.coordinates.x_scale,l=this.coordinates.y_scale,h=function(i,e){return"data"==t.model.location_units?i.compute(n):t.model.for_hover?n:e.compute(n)};"width"==this.model.dimension?(o=h(l,r.bbox.yview),e=r.bbox.left,a=r.bbox.width,i=this.model.line_width):(o=r.bbox.top,e=h(s,r.bbox.xview),a=this.model.line_width,i=r.bbox.height);var c=this.layer.ctx;c.save(),c.beginPath(),this.visuals.line.set_value(c),c.moveTo(e,o),"width"==this.model.dimension?c.lineTo(e+a,o):c.lineTo(e,o+i),c.stroke(),c.restore()}},n}(r.AnnotationView);i.SpanView=h,h.__name__="SpanView";var c=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_Span=function(){this.prototype.default_view=h,this.mixins(s.Line),this.define((function(t){var n=t.Number,i=t.Nullable;return{render_mode:[l.RenderMode,"canvas"],location:[i(n),null],location_units:[l.SpatialUnits,"data"],dimension:[l.Dimension,"width"]}})),this.internal((function(t){return{for_hover:[t.Boolean,!1]}})),this.override({line_color:"black"})},n}(r.Annotation);i.Span=c,c.__name__="Span",c.init_Span()},
function _(t,i,e,o,n){o();var l=t(1),r=t(155),a=t(332),s=t(228),_=t(158),h=t(235),u=t(180),p=function(t){function i(){var i=t.apply(this,l.__spreadArray([],l.__read(arguments)))||this;return i._invalidate_toolbar=!0,i._previous_bbox=new u.BBox,i}return l.__extends(i,t),i.prototype.update_layout=function(){var t=this;this.layout=new h.SideLayout(this.panel,(function(){return t.get_size()}),!0)},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=_.div(),this.plot_view.canvas_view.add_event(this.el)},i.prototype.lazy_initialize=function(){return l.__awaiter(this,void 0,void 0,(function(){var i,e=this;return l.__generator(this,(function(o){switch(o.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return o.sent(),i=this,[4,s.build_view(this.model.toolbar,{parent:this})];case 2:return i._toolbar_view=o.sent(),this.plot_view.visibility_callbacks.push((function(t){return e._toolbar_view.set_visibility(t)})),[2]}}))}))},i.prototype.remove=function(){this._toolbar_view.remove(),_.remove(this.el),t.prototype.remove.call(this)},i.prototype.render=function(){this.model.visible||_.undisplay(this.el),t.prototype.render.call(this)},i.prototype._render=function(){var t=this.layout.bbox;this._previous_bbox.equals(t)||(_.position(this.el,t),this._previous_bbox=t,this._invalidate_toolbar=!0),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",_.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._toolbar_view.layout.bbox=t,this._toolbar_view.render(),this._invalidate_toolbar=!1),_.display(this.el)},i.prototype._get_size=function(){var t=this.model.toolbar,i=t.tools,e=t.logo;return{width:30*i.length+(null!=e?25:0)+15,height:30}},i}(r.AnnotationView);e.ToolbarPanelView=p,p.__name__="ToolbarPanelView";var v=function(t){function i(i){return t.call(this,i)||this}return l.__extends(i,t),i.init_ToolbarPanel=function(){this.prototype.default_view=p,this.define((function(t){return{toolbar:[(0,t.Ref)(a.Toolbar)]}}))},i}(r.Annotation);e.ToolbarPanel=v,v.__name__="ToolbarPanel",v.init_ToolbarPanel()},
function _(t,e,r,i,n){i();var a=t(1),o=t(123),l=t(124),c=t(128),s=t(333),u=t(334),v=t(343),_=t(344);function h(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null}function f(t){return"tap"==t||"pan"==t}r.Drag=s.Tool,r.Inspection=s.Tool,r.Scroll=s.Tool,r.Tap=s.Tool;var p=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Toolbar=function(){this.prototype.default_view=_.ToolbarBaseView,this.define((function(t){var e=t.Or,i=t.Ref,n=t.Auto,a=t.Null;return{active_drag:[e(i(r.Drag),n,a),"auto"],active_inspect:[e(i(r.Inspection),n,a),"auto"],active_scroll:[e(i(r.Scroll),n,a),"auto"],active_tap:[e(i(r.Tap),n,a),"auto"],active_multi:[e(i(u.GestureTool),n,a),"auto"]}}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var r=this.properties,i=r.tools,n=r.active_drag,a=r.active_inspect,o=r.active_scroll,l=r.active_tap,c=r.active_multi;this.on_change([i,n,a,o,l,c],(function(){return e._init_tools()}))},e.prototype._init_tools=function(){var e,r,i,n,s,u,_,p,y,d,g,T,x=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof v.InspectTool){var w=!1;try{for(var b=a.__values(this.inspectors),m=b.next();!m.done;m=b.next()){(D=m.value)!=this.active_inspect?D.active=!1:w=!0}}catch(t){e={error:t}}finally{try{m&&!m.done&&(r=b.return)&&r.call(b)}finally{if(e)throw e.error}}w||(this.active_inspect=null)}else if(o.isArray(this.active_inspect)){var I=l.intersection(this.active_inspect,this.inspectors);I.length!=this.active_inspect.length&&(this.active_inspect=I);try{for(var A=a.__values(this.inspectors),B=A.next();!B.done;B=A.next()){var D=B.value;l.includes(this.active_inspect,D)||(D.active=!1)}}catch(t){i={error:t}}finally{try{B&&!B.done&&(n=A.return)&&n.call(A)}finally{if(i)throw i.error}}}else if(null==this.active_inspect)try{for(var S=a.__values(this.inspectors),G=S.next();!G.done;G=S.next()){(D=G.value).active=!1}}catch(t){s={error:t}}finally{try{G&&!G.done&&(u=S.return)&&u.call(S)}finally{if(s)throw s.error}}var N=function(t){t.active?x._active_change(t):t.active=!0};try{for(var O=a.__values(c.values(this.gestures)),R=O.next();!R.done;R=O.next()){(H=R.value).tools=l.sort_by(H.tools,(function(t){return t.default_order}));var V=function(t){j.connect(t.properties.active.change,(function(){return x._active_change(t)}))},j=this;try{for(var k=(y=void 0,a.__values(H.tools)),q=k.next();!q.done;q=k.next()){V(q.value)}}catch(t){y={error:t}}finally{try{q&&!q.done&&(d=k.return)&&d.call(k)}finally{if(y)throw y.error}}}}catch(t){_={error:t}}finally{try{R&&!R.done&&(p=O.return)&&p.call(O)}finally{if(_)throw _.error}}try{for(var z=a.__values(c.entries(this.gestures)),C=z.next();!C.done;C=z.next()){var E=a.__read(C.value,2),F=E[0],H=E[1],J=h(F);if(J){var K=this[J];"auto"==K?0!=H.tools.length&&f(F)&&N(H.tools[0]):null!=K&&(l.includes(this.tools,K)?N(K):this[J]=null)}}}catch(t){g={error:t}}finally{try{C&&!C.done&&(T=z.return)&&T.call(z)}finally{if(g)throw g.error}}},e}(_.ToolbarBase);r.Toolbar=p,p.__name__="Toolbar",p.init_Toolbar()},
function _(t,e,n,o,r){o();var i=t(1),a=t(157),s=t(124),l=t(168),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){e.model.active?e.activate():e.deactivate()}))},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(a.View);n.ToolView=c,c.__name__="ToolView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Tool=function(){this.prototype._known_aliases=new Map,this.define((function(t){var e=t.String;return{description:[(0,t.Nullable)(e),null]}})),this.internal((function(t){return{active:[t.Boolean,!1]}}))},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._get_dim_limits=function(t,e,n,o){var r,a=i.__read(t,2),l=a[0],c=a[1],_=i.__read(e,2),p=_[0],u=_[1],f=n.bbox.h_range;"width"==o||"both"==o?(r=[s.min([l,p]),s.max([l,p])],r=[s.max([r[0],f.start]),s.min([r[1],f.end])]):r=[f.start,f.end];var d,h=n.bbox.v_range;return"height"==o||"both"==o?(d=[s.min([c,u]),s.max([c,u])],d=[s.max([d[0],h.start]),s.min([d[1],h.end])]):d=[h.start,h.end],[r,d]},e.register_alias=function(t,e){this.prototype._known_aliases.set(t,e)},e.from_string=function(t){var e=this.prototype._known_aliases.get(t);if(null!=e)return e();var n=i.__spreadArray([],i.__read(this.prototype._known_aliases.keys()));throw new Error("unexpected tool name '"+t+"', possible tools are "+n.join(", "))},e}(l.Model);n.Tool=_,_.__name__="Tool",_.init_Tool()},
function _(t,n,e,o,u){o();var r=t(1),i=t(335),_=t(342),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(i.ButtonToolView);e.GestureToolView=l,l.__name__="GestureToolView";var s=function(t){function n(n){var e=t.call(this,n)||this;return e.button_view=_.OnOffButtonView,e}return r.__extends(n,t),n}(i.ButtonTool);e.GestureTool=s,s.__name__="GestureTool"},
function _(t,e,o,n,i){n();var r=t(1),l=r.__importDefault(t(336)),u=t(337),a=t(333),s=t(158),c=t(149),_=t(123),p=t(124),h=r.__importStar(t(338)),d=h,m=r.__importDefault(t(339)),f=r.__importDefault(t(340)),y=t(341),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var o=this.model.menu;if(null!=o){var n=this.parent.model.toolbar_location,i="left"==n||"above"==n,r=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new y.ContextMenu(i?p.reversed(o):o,{orientation:r,prevent_hide:function(t){return t.target==e.el}})}this._hammer=new l.default(this.el,{touchAction:"auto",inputClass:l.default.TouchMouseInput}),this.connect(this.model.change,(function(){return e.render()})),this._hammer.on("tap",(function(t){var o;(null===(o=e._menu)||void 0===o?void 0:o.is_open)?e._menu.hide():t.target==e.el&&e._clicked()})),this._hammer.on("press",(function(){return e._pressed()}))},e.prototype.remove=function(){var e;this._hammer.destroy(),null===(e=this._menu)||void 0===e||e.remove(),t.prototype.remove.call(this)},e.prototype.styles=function(){return r.__spreadArray(r.__spreadArray([],r.__read(t.prototype.styles.call(this))),[h.default,m.default,f.default])},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(d.toolbar_button)},e.prototype.render=function(){s.empty(this.el);var t=this.model.computed_icon;_.isString(t)&&(c.startsWith(t,"data:image")?this.el.style.backgroundImage='url("'+t+'")':this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)},e.prototype._pressed=function(){var t,e=this,o=function(){switch(e.parent.model.toolbar_location){case"right":return{left_of:e.el};case"left":return{right_of:e.el};case"above":return{below:e.el};case"below":return{above:e.el}}}();null===(t=this._menu)||void 0===t||t.toggle(o)},e}(u.DOMView);o.ButtonToolButtonView=v,v.__name__="ButtonToolButtonView";var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e}(a.ToolView);o.ButtonToolView=b,b.__name__="ButtonToolView";var g=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_ButtonTool=function(){this.internal((function(t){return{disabled:[t.Boolean,!1]}}))},e.prototype._get_dim_tooltip=function(t){var e=this.description,o=this.tool_name;return null!=e?e:"both"==t?o:o+" ("+("width"==t?"x":"y")+"-axis)"},Object.defineProperty(e.prototype,"tooltip",{get:function(){var t;return null!==(t=this.description)&&void 0!==t?t:this.tool_name},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"menu",{get:function(){return null},enumerable:!1,configurable:!0}),e}(a.Tool);o.ButtonTool=g,g.__name__="ButtonTool",g.init_ButtonTool()},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(t,e,i,n,o){n();var r=t(1),s=t(157),c=t(158),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=this._createElement()},e.prototype.remove=function(){c.remove(this.el),t.prototype.remove.call(this)},e.prototype.css_classes=function(){return[]},e.prototype.render=function(){},e.prototype.renderTo=function(t){t.appendChild(this.el),this.render(),this._has_finished=!0,this.notify_finished()},e.prototype._createElement=function(){return c.createElement(this.constructor.tag_name,{class:this.css_classes()})},e}(s.View);i.DOMView=p,p.__name__="DOMView",p.tag_name="div"},
function _(o,t,b,r,e){r(),b.root="bk-root",b.toolbar_hidden="bk-toolbar-hidden",b.toolbar="bk-toolbar",b.logo="bk-logo",b.above="bk-above",b.below="bk-below",b.left="bk-left",b.right="bk-right",b.toolbar_button="bk-toolbar-button",b.toobar_button="bk-toobar-button",b.tool_overflow="bk-tool-overflow",b.active="bk-active",b.divider="bk-divider",b.horizontal="bk-horizontal",b.vertical="bk-vertical",b.default='.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toobar-button:hover,.bk-root .bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toobar-button:focus,.bk-root .bk-tool-overflow:focus{outline:none;}.bk-root .bk-toobar-button::-moz-focus-inner,.bk-root .bk-tool-overflow::-moz-focus-inner{border:0;}.bk-root .bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-divider{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-above .bk-divider,.bk-root .bk-below .bk-divider{height:10px;width:1px;}.bk-root .bk-left .bk-divider,.bk-root .bk-right .bk-divider{height:1px;width:10px;}.bk-root .bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-root .bk-above .bk-tool-overflow,.bk-root .bk-below .bk-tool-overflow,.bk-root .bk-horizontal .bk-tool-overflow{width:15px;height:30px;flex-direction:row;}.bk-root .bk-left .bk-tool-overflow,.bk-root .bk-right .bk-tool-overflow,.bk-root .bk-vertical .bk-tool-overflow{width:30px;height:15px;flex-direction:column;}'},
function _(A,g,o,C,l){C(),o.root="bk-root",o.tool_icon_copy_to_clipboard="bk-tool-icon-copy-to-clipboard",o.tool_icon_replace_mode="bk-tool-icon-replace-mode",o.tool_icon_append_mode="bk-tool-icon-append-mode",o.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",o.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",o.tool_icon_clear_selection="bk-tool-icon-clear-selection",o.tool_icon_box_select="bk-tool-icon-box-select",o.tool_icon_box_zoom="bk-tool-icon-box-zoom",o.tool_icon_zoom_in="bk-tool-icon-zoom-in",o.tool_icon_zoom_out="bk-tool-icon-zoom-out",o.tool_icon_help="bk-tool-icon-help",o.tool_icon_hover="bk-tool-icon-hover",o.tool_icon_crosshair="bk-tool-icon-crosshair",o.tool_icon_lasso_select="bk-tool-icon-lasso-select",o.tool_icon_pan="bk-tool-icon-pan",o.tool_icon_xpan="bk-tool-icon-xpan",o.tool_icon_ypan="bk-tool-icon-ypan",o.tool_icon_range="bk-tool-icon-range",o.tool_icon_polygon_select="bk-tool-icon-polygon-select",o.tool_icon_redo="bk-tool-icon-redo",o.tool_icon_reset="bk-tool-icon-reset",o.tool_icon_save="bk-tool-icon-save",o.tool_icon_tap_select="bk-tool-icon-tap-select",o.tool_icon_undo="bk-tool-icon-undo",o.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.tool_icon_box_edit="bk-tool-icon-box-edit",o.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.tool_icon_poly_draw="bk-tool-icon-poly-draw",o.tool_icon_point_draw="bk-tool-icon-point-draw",o.tool_icon_poly_edit="bk-tool-icon-poly-edit",o.tool_icon_line_edit="bk-tool-icon-line-edit",o.default='.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAABCJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIgogICAgICAgICAgICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgICAgICAgICAgIHhtbG5zOnhtcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx0aWZmOlJlc29sdXRpb25Vbml0PjI8L3RpZmY6UmVzb2x1dGlvblVuaXQ+CiAgICAgICAgIDx0aWZmOkNvbXByZXNzaW9uPjU8L3RpZmY6Q29tcHJlc3Npb24+CiAgICAgICAgIDx0aWZmOlhSZXNvbHV0aW9uPjcyPC90aWZmOlhSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICAgICA8dGlmZjpZUmVzb2x1dGlvbj43MjwvdGlmZjpZUmVzb2x1dGlvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjMyPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6Q29sb3JTcGFjZT4xPC9leGlmOkNvbG9yU3BhY2U+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj4zMjwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgICAgIDxkYzpzdWJqZWN0PgogICAgICAgICAgICA8cmRmOkJhZy8+CiAgICAgICAgIDwvZGM6c3ViamVjdD4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMTgtMDQtMjhUMTQ6MDQ6NDk8L3htcDpNb2RpZnlEYXRlPgogICAgICAgICA8eG1wOkNyZWF0b3JUb29sPlBpeGVsbWF0b3IgMy43PC94bXA6Q3JlYXRvclRvb2w+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgrsrWBhAAAD60lEQVRYCcVWv2scRxSemZ097SHbSeWkcYwwclDhzr1Q5T6QE1LghP6BGNIYJGRWNlaZItiFK1mr+JAu4HQu0kjpU8sgF3ITAsaFg0hOvt2Zyfvmdsa7a610Unx44Zgf773vvfneezPHNzrbhn3CT3xC3wPXYOC8LDzqdi8YY/gwh4BeknS/2th6dr2kf94AOp3OFyWgMyziOPbMDxV9FTtJnl1ut795Xd0/YQ0/vtYQwMT1KXWCfr2IjOWwtNehwN4xL9ykTrm6Pzl58yLn3J+mKh9mXbT3uRjGEDph+O8/TjfP5dBp7Ha7AX7O3o5nZeD/0E/OGyXntDgzA0X6qmCnrVutVlrUWV9f/3xo+pwhGDhvEPHOjoxnZjJggXmMHzBQ7NGNp9vxk61fr0HR7e/u7pZzCGHlc7qwBYYTT7tJYSx1AQzppyFPft5apta9w7SKcn0b7P7+/jCsDQ5mbc0dCmIJGDN0ehdcjsmkm6A6KUeKFOTE11PLxrC7Ukqh3ylL2fT0NAP9q6ur6rRCJJYsbKB0JsbCKMuy+xREePDyxQPCz+Crlw062QcA5wBOOt1l6vIl2WiI9F1fN6Q+BBqit6hEC4Hk08GQJMn4myjSP7RavVxgdaVUh/3U6HCMsPr9pYnJKRziHtWQ+un58+hGs6nsjQSjpuTyKGN3CX+FBwHXSiEVgjP+O8X6N12kIePES+GzTKAkGbNp8yJsGUMVzz8jPKReiyAQRimy5/cjye5RpF8utFp/+nwmT7d/NMzcFkS7yjJNGDaPURQxIQThEQy0SyF4l5WJYYhBa816vZ6dU7A6CAhbZVow/pDe0O9hVOoCi13r4BgBAvJHqMSQL2vE/iH6IAXEwgrRVUmBoRRwnwJQT98xEeVeSUyB4dJ5nwJBKdCFFGRmUCcu7rwIYypCTblaChuNBhWODrman5ub+4v0rMNBt8z6Ezh7GksJQpCbm79cMQE7QBFm/X6f0rjWnv8WRYg/QdbUpwDAEBy8vPyA8rNGzg3a8MiElwiM7dAtRqNoNptjGPM1laVxP9umWEMGLOKhKUOJDtBwDmzsw9fC/CzHr9SGuCTi2LbbKvVtmqXpCjMihBFa79Wrt5fGx9PDzc3fmu32Lf8qFliwU9emKhBSp+kRKn/hu9k1COEDbFdt/BoKWOAkuEbdVYyoIXv8+I/QK9dMHEb1Knb7MHOv8LFFOsjzCVHWOD7Ltn+MXCRF4729vWMDK+p8rLkvwjLg4N4v741m5YuwCI9CvHp1Ha8gFdBoPnQAkGsYYGxxcfEI7QQlFCTGUXwjAz4tWF+EpymOWu7fglE7qsOvrYE6g4+9/x/vhRbMdLOCFgAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYxIDY0LjE0MDk0OSwgMjAxMC8xMi8wNy0xMDo1NzowMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo3NzIwRUFGMDYyMjE2ODExOTdBNUNBNjVEQTY5OTRDRSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpCOTJBQzE0RDQ0RDUxMUU0QTE0ODk2NTE1M0M0MkZENCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpCOTJBQzE0QzQ0RDUxMUU0QTE0ODk2NTE1M0M0MkZENCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1LjEgTWFjaW50b3NoIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6OTQ0QzIwMUM1RjIxNjgxMUE3QkFFMzhGRjc2NTI3MjgiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NzcyMEVBRjA2MjIxNjgxMTk3QTVDQTY1REE2OTk0Q0UiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6eYZ88AAADLklEQVR42rSXf2TUYRzHv7tuGcfE6Vwb5zLSSjEj7Y9KWqfEmFZJP+yPMdKKmUrrn0iUfjhWlLFi6YfNrF+StBoTo39iYkTGco4xxxG59P7k/T2PT8/37nu3bx9ezvPj+zyf5/PreS78bGLS8SmrwE6yje3NHJsDBTALpknBz6JhH3NiYAB0gHqPOVv52wJ6QQ48BzdAttTioRJjdeA8mAHHS2xuk3p+M8M16ipVQE49Ds6CiFO9RLjGONf05QLx6wPQaBlbBlPgJVgkP0ETiIJ2sB/E1XfimjfgBOOlKDUqCGOcqBcQnw6BYW5YTo4wbvQhMmCfGRemC2rBiGXzWUb+kM/NRZ6CHWBM9ce5R61NgX6ayhSJ5EPlItlDRNkz4JbFHf06BkSzHjXxM+gDv1S/mPUo2AXWgt9UUHL/IVhS8yUV1/EbV3o4N+NaoE9Fu/i827K5pNYHnqAVJECShWmAaddpscYFFXwR7vnXBRGlnUN/L6kqKJlxnRUuDbaDBiL+vst5d4gpcpBrqk/2jIgCKVUolhntplzivHmwh4stGOPfwBWwl/2dpp8p7xjQZqFLiQJtauKkivYm+kzccpK57yXfOUe+P23JqAnVbhMFmlXntCWnxbT31am9ZJ4BJifsUmNTqt0cYhA5ypympPg7VkEKunPbVb8cIG+0kyHLJZNR7fUMooUKFHAPkfQo58VLK+RzwRDd4FdWG9mjpaAXzqkJa1R7kQttqEABWXMjOOxxVRfnhRm5URX1prk/0pQHwNcKlchZ+jdpC+hFdVqO0my9Hj5dkYgCn1Rfh/KdlNDHrJhPqlDih+IfBd6qwpOgEqYMsorJ2HtWxtagLJDn/W3KRfPOZhoeBJfZPgVeGKeKrkQBh5dLXl25Ny3pc4/1fkTdbvFqFQgbxWeYD0hXulhQ0pYiM1jG547fcbMQpVnHTZEn9W3ljsCzwHxCdVteNHIZvQa7/7cC7nV6zHIfyFP9EXjFa7YxKAVqPP4bxhhoLWW+z9JyCb6M/MREg59/RlmmXbmneIybB+YC/ay+yrffqEddDzwGvKxxDmzhc0tc80XVgblqFfgjwAAPubcGjAOl1wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}'},
function _(o,r,t,e,b){e(),t.root="bk-root",t.menu_icon="bk-menu-icon",t.context_menu="bk-context-menu",t.horizontal="bk-horizontal",t.vertical="bk-vertical",t.divider="bk-divider",t.active="bk-active",t.menu="bk-menu",t.above="bk-above",t.below="bk-below",t.caret="bk-caret",t.down="bk-down",t.up="bk-up",t.left="bk-left",t.right="bk-right",t.default=".bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}"},
function _(t,e,n,i,o){i();var l=t(1),r=t(158),s=t(124),u=l.__importStar(t(340)),h=function(){function t(t,e){var n,i,o=this;void 0===e&&(e={}),this.items=t,this.el=r.div(),this._open=!1,this._item_click=function(t){var e;null===(e=t.handler)||void 0===e||e.call(t),o.hide()},this._on_mousedown=function(t){var e,n=t.target;n instanceof Node&&o.el.contains(n)||(null===(e=o.prevent_hide)||void 0===e?void 0:e.call(o,t))||o.hide()},this._on_keydown=function(t){t.keyCode==r.Keys.Esc&&o.hide()},this._on_blur=function(){o.hide()},this.orientation=null!==(n=e.orientation)&&void 0!==n?n:"vertical",this.reversed=null!==(i=e.reversed)&&void 0!==i&&i,this.prevent_hide=e.prevent_hide,r.undisplay(this.el)}return Object.defineProperty(t.prototype,"is_open",{get:function(){return this._open},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"can_open",{get:function(){return 0!=this.items.length},enumerable:!1,configurable:!0}),t.prototype.remove=function(){r.remove(this.el),this._unlisten()},t.prototype._listen=function(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)},t.prototype._unlisten=function(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)},t.prototype._position=function(t){var e=this.el.parentElement;if(null!=e){var n=function(){if("left_of"in t){var e=t.left_of.getBoundingClientRect();return{right:e.left,top:i=e.top}}if("right_of"in t){var n=t.right_of.getBoundingClientRect(),i=n.top;return{left:n.right,top:i}}if("below"in t){var o=t.below.getBoundingClientRect();return{left:o.left,top:o.bottom}}if("above"in t){var l=t.above.getBoundingClientRect();return{left:l.left,bottom:i=l.top}}return t}(),i=e.getBoundingClientRect();this.el.style.left=null!=n.left?n.left-i.left+"px":"",this.el.style.top=null!=n.top?n.top-i.top+"px":"",this.el.style.right=null!=n.right?i.right-n.right+"px":"",this.el.style.bottom=null!=n.bottom?i.bottom-n.bottom+"px":""}},t.prototype.render=function(){var t,e,n,i=this;r.empty(this.el,!0),r.classes(this.el).add("bk-context-menu","bk-"+this.orientation);var o=this.reversed?s.reversed(this.items):this.items,h=function(t){var e=void 0;if(null==t)e=r.div({class:u.divider});else{if(null!=t.if&&!t.if())return"continue";if(null!=t.content)e=t.content;else{var o=null!=t.icon?r.div({class:["bk-menu-icon",t.icon]}):null,l=[(null===(n=t.active)||void 0===n?void 0:n.call(t))?"bk-active":null,t.class];(e=r.div({class:l,title:t.tooltip},o,t.label,t.content)).addEventListener("click",(function(){return i._item_click(t)}))}}d.el.appendChild(e)},d=this;try{for(var c=l.__values(o),p=c.next();!p.done;p=c.next()){h(p.value)}}catch(e){t={error:e}}finally{try{p&&!p.done&&(e=c.return)&&e.call(c)}finally{if(t)throw t.error}}},t.prototype.show=function(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),r.display(this.el),this._listen(),this._open=!0}},t.prototype.hide=function(){this._open&&(this._open=!1,this._unlisten(),r.undisplay(this.el))},t.prototype.toggle=function(t){this._open?this.hide():this.show(t)},t}();n.ContextMenu=h,h.__name__="ContextMenu"},
function _(t,e,n,o,i){o();var r=t(1),c=t(335),l=r.__importStar(t(338)),u=t(158),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),u.classes(this.el).toggle(l.active,this.model.active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(c.ButtonToolButtonView);n.OnOffButtonView=a,a.__name__="OnOffButtonView"},
function _(t,n,e,o,i){o();var u=t(1),_=t(335),l=t(342),r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),n}(_.ButtonToolView);e.InspectToolView=r,r.__name__="InspectToolView";var c=function(t){function n(n){var e=t.call(this,n)||this;return e.event_type="move",e}return u.__extends(n,t),n.init_InspectTool=function(){this.prototype.button_view=l.OnOffButtonView,this.define((function(t){return{toggleable:[t.Boolean,!0]}})),this.override({active:!0})},n}(_.ButtonTool);e.InspectTool=c,c.__name__="InspectTool",c.init_InspectTool()},
function _(t,e,o,i,n){i();var l=t(1),r=t(134),a=t(158),s=t(228),u=t(337),c=t(135),_=t(124),h=t(345),v=t(128),p=t(123),f=t(346),d=t(180),b=t(168),y=t(333),g=t(334),w=t(348),m=t(349),x=t(343),T=t(341),z=l.__importStar(t(338)),B=z,C=l.__importStar(t(350)),M=C,A=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_ToolbarViewModel=function(){this.define((function(t){return{autohide:[t.Boolean,!1]}})),this.internal((function(t){var e=t.Boolean;return{_visible:[(0,t.Nullable)(e),null]}}))},Object.defineProperty(e.prototype,"visible",{get:function(){var t;return!this.autohide||null!==(t=this._visible)&&void 0!==t&&t},enumerable:!1,configurable:!0}),e}(b.Model);o.ToolbarViewModel=A,A.__name__="ToolbarViewModel",A.init_ToolbarViewModel();var V=function(t){function e(){var e=t.apply(this,l.__spreadArray([],l.__read(arguments)))||this;return e.layout={bbox:new d.BBox},e}return l.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views=new Map,this._toolbar_view_model=new A({autohide:this.model.autohide});var e=this.model.toolbar_location,o="left"==e||"above"==e,i=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new T.ContextMenu([],{orientation:i,reversed:o})},e.prototype.lazy_initialize=function(){return l.__awaiter(this,void 0,void 0,(function(){return l.__generator(this,(function(e){switch(e.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return e.sent(),[4,this._build_tool_button_views()];case 2:return e.sent(),[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,(function(){return l.__awaiter(e,void 0,void 0,(function(){return l.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),this.render(),[2]}}))}))})),this.connect(this.model.properties.autohide.change,(function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(function(){return e._on_visible_change()}))},e.prototype.styles=function(){return l.__spreadArray(l.__spreadArray([],l.__read(t.prototype.styles.call(this))),[z.default,C.default])},e.prototype.remove=function(){s.remove_views(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){return l.__awaiter(this,void 0,void 0,(function(){var t;return l.__generator(this,(function(e){switch(e.label){case 0:return t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools,[4,s.build_views(this._tool_button_views,t,{parent:this},(function(t){return t.button_view}))];case 1:return e.sent(),[2]}}))}))},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible;a.classes(this.el).toggle(B.toolbar_hidden,!t)},e.prototype.render=function(){var t,e,o,i,n,r,s=this;a.empty(this.el),this.el.classList.add(B.toolbar),this.el.classList.add(B[this.model.toolbar_location]),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change();var u=this.model.horizontal,c=0;if(null!=this.model.logo){var _="grey"===this.model.logo?M.grey:null,p=a.a({href:"https://bokeh.org/",target:"_blank",class:[M.logo,M.logo_small,_]});this.el.appendChild(p);var f=p.getBoundingClientRect(),d=f.width,b=f.height;c+=u?d:b}try{for(var y=l.__values(this._tool_button_views),g=y.next();!g.done;g=y.next()){l.__read(g.value,2)[1].render()}}catch(e){t={error:e}}finally{try{g&&!g.done&&(e=y.return)&&e.call(y)}finally{if(t)throw t.error}}var w=[],m=function(t){return s._tool_button_views.get(t).el},x=this.model.gestures;try{for(var T=l.__values(v.values(x)),z=T.next();!z.done;z=T.next()){var C=z.value;w.push(C.tools.map(m))}}catch(t){o={error:t}}finally{try{z&&!z.done&&(i=T.return)&&i.call(T)}finally{if(o)throw o.error}}w.push(this.model.actions.map(m)),w.push(this.model.inspectors.filter((function(t){return t.toggleable})).map(m));var A=w.filter((function(t){return 0!=t.length})),V=this.layout.bbox,L=!1;this.root.el.appendChild(this._overflow_menu.el);var S=a.div({class:B.tool_overflow},u?"⋮":"⋯");S.addEventListener("click",(function(){var t=function(){switch(s.model.toolbar_location){case"right":return{left_of:S};case"left":return{right_of:S};case"above":return{below:S};case"below":return{above:S}}}();s._overflow_menu.toggle(t)}));try{for(var j=l.__values(h.join(A,(function(){return a.div({class:B.divider})}))),k=j.next();!k.done;k=j.next()){var O=k.value;if(L)this._overflow_menu.items.push({content:O,class:u?B.right:B.above});else{this.el.appendChild(O);var R=O.getBoundingClientRect();d=R.width,b=R.height;if(c+=u?d:b,L=u?c>V.width-15:c>V.height-15){this.el.removeChild(O),this.el.appendChild(S);var N=this._overflow_menu.items;N.splice(0,N.length),N.push({content:O})}}}}catch(t){n={error:t}}finally{try{k&&!k.done&&(r=j.return)&&r.call(j)}finally{if(n)throw n.error}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e.prototype.export=function(t,e){void 0===e&&(e=!0);var o="png"==t?"canvas":"svg",i=new f.CanvasLayer(o,e);return i.resize(0,0),i},e}(u.DOMView);function L(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}o.ToolbarBaseView=V,V.__name__="ToolbarBaseView";var S=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_ToolbarBase=function(){this.prototype.default_view=V,this.define((function(t){var e=t.Boolean,o=t.Array,i=t.Ref,n=t.Nullable;return{tools:[o(i(y.Tool)),[]],logo:[n(c.Logo),"normal"],autohide:[e,!1]}})),this.internal((function(t){var e=t.Array,o=t.Struct,i=t.Ref,n=t.Nullable,l=o({tools:e(i(g.GestureTool)),active:n(i(y.Tool))});return{gestures:[o({pan:l,scroll:l,pinch:l,tap:l,doubletap:l,press:l,pressup:l,rotate:l,move:l,multi:l}),L],actions:[e(i(w.ActionTool)),[]],inspectors:[e(i(x.InspectTool)),[]],help:[e(i(m.HelpTool)),[]],toolbar_location:[c.Location,"right"]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype._init_tools=function(){var t,e,o,i,n,a,s=this,u=function(t,e){if(t.length!=e.length)return!0;var o=new Set(e.map((function(t){return t.id})));return _.some(t,(function(t){return!o.has(t.id)}))},c=this.tools.filter((function(t){return t instanceof x.InspectTool}));u(this.inspectors,c)&&(this.inspectors=c);var h=this.tools.filter((function(t){return t instanceof m.HelpTool}));u(this.help,h)&&(this.help=h);var v=this.tools.filter((function(t){return t instanceof w.ActionTool}));u(this.actions,v)&&(this.actions=v);var f=function(t,e){t in s.gestures||r.logger.warn("Toolbar: unknown event type '"+t+"' for tool: "+e)},d={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};try{for(var b=l.__values(this.tools),y=b.next();!y.done;y=b.next()){var T=y.value;if(T instanceof g.GestureTool&&T.event_type)if(p.isString(T.event_type))d[T.event_type].tools.push(T),f(T.event_type,T);else{d.multi.tools.push(T);try{for(var z=(o=void 0,l.__values(T.event_type)),B=z.next();!B.done;B=z.next()){f(B.value,T)}}catch(t){o={error:t}}finally{try{B&&!B.done&&(i=z.return)&&i.call(z)}finally{if(o)throw o.error}}}}}catch(e){t={error:e}}finally{try{y&&!y.done&&(e=b.return)&&e.call(b)}finally{if(t)throw t.error}}var C=function(t){var e=M.gestures[t];u(e.tools,d[t].tools)&&(e.tools=d[t].tools),e.active&&_.every(e.tools,(function(t){return t.id!=e.active.id}))&&(e.active=null)},M=this;try{for(var A=l.__values(Object.keys(d)),V=A.next();!V.done;V=A.next()){C(V.value)}}catch(t){n={error:t}}finally{try{V&&!V.done&&(a=A.return)&&a.call(A)}finally{if(n)throw n.error}}},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!1,configurable:!0}),e.prototype._active_change=function(t){var e,o,i=t.event_type;if(null!=i){var n=p.isString(i)?[i]:i;try{for(var a=l.__values(n),s=a.next();!s.done;s=a.next()){var u=s.value;if(t.active){var c=this.gestures[u].active;null!=c&&t!=c&&(r.logger.debug("Toolbar: deactivating tool: "+c+" for event type '"+u+"'"),c.active=!1),this.gestures[u].active=t,r.logger.debug("Toolbar: activating tool: "+t+" for event type '"+u+"'")}else this.gestures[u].active=null}}catch(t){e={error:t}}finally{try{s&&!s.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}}},e}(b.Model);o.ToolbarBase=S,S.__name__="ToolbarBase",S.init_ToolbarBase()},
function _(e,r,n,t,a){t();var l=e(1),s=e(124);function u(e,r){var n,t,a,u,c,o,i,f,_,v,h,b,y;return l.__generator(this,(function(d){switch(d.label){case 0:return n=e.length,r>n?[2]:[4,(t=s.range(r)).map((function(r){return e[r]}))];case 1:d.sent(),d.label=2;case 2:0,a=void 0;try{for(v=void 0,u=l.__values(s.reversed(s.range(r))),c=u.next();!c.done;c=u.next())if(o=c.value,t[o]!=o+n-r){a=o;break}}catch(e){v={error:e}}finally{try{c&&!c.done&&(h=u.return)&&h.call(u)}finally{if(v)throw v.error}}if(null==a)return[2];t[a]+=1;try{for(b=void 0,i=l.__values(s.range(a+1,r)),f=i.next();!f.done;f=i.next())_=f.value,t[_]=t[_-1]+1}catch(e){b={error:e}}finally{try{f&&!f.done&&(y=i.return)&&y.call(i)}finally{if(b)throw b.error}}return[4,t.map((function(r){return e[r]}))];case 3:return d.sent(),[3,2];case 4:return[2]}}))}n.enumerate=function(e){var r,n,t,a,s,u;return l.__generator(this,(function(c){switch(c.label){case 0:r=0,c.label=1;case 1:c.trys.push([1,6,7,8]),n=l.__values(e),t=n.next(),c.label=2;case 2:return t.done?[3,5]:[4,[t.value,r++]];case 3:c.sent(),c.label=4;case 4:return t=n.next(),[3,2];case 5:return[3,8];case 6:return a=c.sent(),s={error:a},[3,8];case 7:try{t&&!t.done&&(u=n.return)&&u.call(n)}finally{if(s)throw s.error}return[7];case 8:return[2]}}))},n.join=function(e,r){var n,t,a,s,u,c,o;return l.__generator(this,(function(i){switch(i.label){case 0:n=!0,i.label=1;case 1:i.trys.push([1,9,10,11]),t=l.__values(e),a=t.next(),i.label=2;case 2:return a.done?[3,8]:(s=a.value,n?(n=!1,[3,5]):[3,3]);case 3:return null==r?[3,5]:[4,r()];case 4:i.sent(),i.label=5;case 5:return[5,l.__values(s)];case 6:i.sent(),i.label=7;case 7:return a=t.next(),[3,2];case 8:return[3,11];case 9:return u=i.sent(),c={error:u},[3,11];case 10:try{a&&!a.done&&(o=t.return)&&o.call(t)}finally{if(c)throw c.error}return[7];case 11:return[2]}}))},n.combinations=u,n.subsets=function(e){var r,n,t,a,c,o;return l.__generator(this,(function(i){switch(i.label){case 0:i.trys.push([0,5,6,7]),r=l.__values(s.range(e.length+1)),n=r.next(),i.label=1;case 1:return n.done?[3,4]:(t=n.value,[5,l.__values(u(e,t))]);case 2:i.sent(),i.label=3;case 3:return n=r.next(),[3,1];case 4:return[3,7];case 5:return a=i.sent(),c={error:a},[3,7];case 6:try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(c)throw c.error}return[7];case 7:return[2]}}))}},
function _(t,e,n,i,o){i();var r=t(347),a=t(180),s=t(158);function c(t){!function(t){void 0===t.lineDash&&Object.defineProperty(t,"lineDash",{get:function(){return t.getLineDash()},set:function(e){return t.setLineDash(e)}})}(t),function(t){t.setImageSmoothingEnabled=function(e){t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=function(){var e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.ellipse||(t.ellipse=function(e,n,i,o,r,a,s,c){void 0===c&&(c=!1);var l=.551784;t.translate(e,n),t.rotate(r);var h=i,u=o;c&&(h=-i,u=-o),t.moveTo(-h,0),t.bezierCurveTo(-h,u*l,-h*l,u,0,u),t.bezierCurveTo(h*l,u,h,u*l,h,0),t.bezierCurveTo(h,-u*l,h*l,-u,0,-u),t.bezierCurveTo(-h*l,-u,-h,-u*l,-h,0),t.rotate(-r),t.translate(-e,-n)})}(t)}var l={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},h=function(){function t(t,e){switch(this.backend=t,this.hidpi=e,this.pixel_ratio=1,this.bbox=new a.BBox,t){case"webgl":case"canvas":if(this._el=this._canvas=s.canvas({style:l}),null==(n=this.canvas.getContext("2d")))throw new Error("unable to obtain 2D rendering context");this._ctx=n,e&&(this.pixel_ratio=devicePixelRatio);break;case"svg":var n=new r.SVGRenderingContext2D;this._ctx=n,this._canvas=n.get_svg(),this._el=s.div({style:l},this._canvas)}this._ctx.layer=this,c(this._ctx)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this._canvas},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ctx",{get:function(){return this._ctx},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"el",{get:function(){return this._el},enumerable:!1,configurable:!0}),t.prototype.resize=function(t,e){this.bbox=new a.BBox({left:0,top:0,width:t,height:e});var n=this._ctx instanceof r.SVGRenderingContext2D?this._ctx:this.canvas;n.width=t*this.pixel_ratio,n.height=e*this.pixel_ratio},t.prototype.undo_transform=function(t){var e=this.ctx;if(void 0===e.getTransform)t(e);else{var n=e.getTransform();e.setTransform(this._base_transform);try{t(e)}finally{e.setTransform(n)}}},t.prototype.prepare=function(){var t=this,e=t.ctx,n=t.hidpi,i=t.pixel_ratio;e.save(),n&&(e.scale(i,i),e.translate(.5,.5)),this._base_transform=e.getTransform(),this.clear()},t.prototype.clear=function(){var t=this.bbox,e=t.x,n=t.y,i=t.width,o=t.height;this.ctx.clearRect(e,n,i,o)},t.prototype.finish=function(){this.ctx.restore()},t.prototype.to_blob=function(){var t=this._canvas;if(t instanceof HTMLCanvasElement)return null!=t.msToBlob?Promise.resolve(t.msToBlob()):new Promise((function(e,n){t.toBlob((function(t){return null!=t?e(t):n()}),"image/png")}));var e=this._ctx.get_serialized_svg(!0),n=new Blob([e],{type:"image/svg+xml"});return Promise.resolve(n)},t}();n.CanvasLayer=h,h.__name__="CanvasLayer"},
function _(t,e,r,i,n){i();var a=t(1),s=t(246),o=t(123),l=t(158);function h(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");var e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",r="";do{r="";for(var i=0;i<12;i++)r+=e[Math.floor(Math.random()*e.length)]}while(t[r]);return r}function _(t){var e,r={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=r[t])&&void 0!==e?e:r.alphabetic}var p=function(t,e){var r=new Map,i=t.split(",");e=null!=e?e:10;for(var n=0;n<i.length;n+=2){var a="&"+i[n+1]+";",s=parseInt(i[n],e);r.set(a,"&#"+s+";")}return r.set("\\xa0","&#160;"),r}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"}},c=function(){function t(t,e){this.__root=t,this.__ctx=e}return t.prototype.addColorStop=function(t,e){var r=this.__ctx.__createElement("stop");if(r.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){var i=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),n=a.__read(i,5),s=n[1],o=n[2],l=n[3],h=n[4];r.setAttribute("stop-color","rgb("+s+","+o+","+l+")"),r.setAttribute("stop-opacity",h)}else r.setAttribute("stop-color",e);this.__root.appendChild(r)},t}();c.__name__="CanvasGradient";var d=function(t,e){this.__root=t,this.__ctx=e};d.__name__="CanvasPattern";var f=function(){function t(t){var e,r,i;this.__currentPosition=null,this._transform=new s.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(r=null==t?void 0:t.width)&&void 0!==r?r:500,this.height=null!==(i=null==t?void 0:t.height)&&void 0!==i?i:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this._width},set:function(t){this._width=t,this.__root.setAttribute("width",""+t)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._height},set:function(t){this._height=t,this.__root.setAttribute("height",""+t)},enumerable:!1,configurable:!0}),t.prototype.__createElement=function(t,e,r){var i,n;void 0===e&&(e={}),void 0===r&&(r=!1);var s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);r&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));var o=Object.keys(e);try{for(var l=a.__values(o),h=l.next();!h.done;h=l.next()){var _=h.value;s.setAttribute(_,""+e[_])}}catch(t){i={error:t}}finally{try{h&&!h.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}return s},t.prototype.__setDefaultStyles=function(){for(var t=Object.keys(u),e=0;e<t.length;e++){var r=t[e];this[r]=u[r].canvas}},t.prototype.__applyStyleState=function(t){for(var e=Object.keys(t),r=0;r<e.length;r++){var i=e[r];this[i]=t[i]}},t.prototype.__getStyleState=function(){for(var t=Object.keys(u),e={},r=0;r<t.length;r++){var i=t[r];e[i]=this[i]}return e},t.prototype.__applyStyleToCurrentElement=function(t){for(var e,r,i,n=this.__currentElement,s=Object.keys(u),l=0;l<s.length;l++){var h=u[s[l]],_=this[s[l]];if(null===(i=h.apply)||void 0===i?void 0:i.includes(t))if(_ instanceof d){try{for(var p=(e=void 0,a.__values(a.__spreadArray([],a.__read(_.__ctx.__defs.childNodes)))),f=p.next();!f.done;f=p.next()){var m=f.value;if(m instanceof Element){var g=m.getAttribute("id");this.__ids[g]=g,this.__defs.appendChild(m)}}}catch(t){e={error:t}}finally{try{f&&!f.done&&(r=p.return)&&r.call(p)}finally{if(e)throw e.error}}var v=_.__root.getAttribute("id");n.setAttribute(h.apply,"url(#"+v+")")}else if(_ instanceof c){v=_.__root.getAttribute("id");n.setAttribute(h.apply,"url(#"+v+")")}else if(h.svg!==_)if("stroke"!==h.svgAttr&&"fill"!==h.svgAttr||!o.isString(_)||-1===_.indexOf("rgba")){var y=h.svgAttr;if("globalAlpha"===s[l]&&(y=t+"-"+h.svgAttr,n.getAttribute(y)))continue;n.setAttribute(y,""+_)}else{var w=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(_),b=a.__read(w,5),x=b[1],A=b[2],E=b[3],k=b[4];n.setAttribute(h.svgAttr,"rgb("+x+","+A+","+E+")");var C=parseFloat(k),S=this.globalAlpha;null!=S&&(C*=S),n.setAttribute(h.svgAttr+"-opacity",""+C)}}},t.prototype.get_serialized_svg=function(t){var e,r;void 0===t&&(t=!1);var i=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(i)&&(i=i.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)try{for(var n=a.__values(p),s=n.next();!s.done;s=n.next()){var o=a.__read(s.value,2),l=o[0],h=o[1],_=new RegExp(l,"gi");_.test(i)&&(i=i.replace(_,h))}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return i},t.prototype.get_svg=function(){return this.__root},t.prototype.save=function(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()},t.prototype.restore=function(){if(0!=this.__stack.length){var t=this.__stack.pop(),e=t.transform,r=t.clip_path,i=t.attributes;this._transform=e,this._clip_path=r,this.__applyStyleState(i)}},t.prototype._apply_transform=function(t,e){void 0===e&&(e=this._transform),e.is_identity||t.setAttribute("transform",e.toString())},t.prototype.scale=function(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)},t.prototype.rotate=function(t){isFinite(t)&&this._transform.rotate(t)},t.prototype.translate=function(t,e){isFinite(t+e)&&this._transform.translate(t,e)},t.prototype.transform=function(t,e,r,i,n,a){isFinite(t+e+r+i+n+a)&&this._transform.transform(t,e,r,i,n,a)},t.prototype.beginPath=function(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()},t.prototype.__init_element=function(){var t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t},t.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},t.prototype.__addPathCommand=function(t,e,r){var i=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=i+r,this.__currentPosition={x:t,y:e}},Object.defineProperty(t.prototype,"_hasCurrentDefaultPath",{get:function(){return!!this.__currentDefaultPath},enumerable:!1,configurable:!0}),t.prototype.moveTo=function(t,e){if(isFinite(t+e)){"path"!==this.__currentElement.nodeName&&this.beginPath();var r=a.__read(this._transform.apply(t,e),2),i=r[0],n=r[1];this.__addPathCommand(i,n,"M "+i+" "+n)}},t.prototype.closePath=function(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")},t.prototype.lineTo=function(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){var r=a.__read(this._transform.apply(t,e),2),i=r[0],n=r[1];this.__addPathCommand(i,n,"L "+i+" "+n)}else this.moveTo(t,e)},t.prototype.bezierCurveTo=function(t,e,r,i,n,s){if(isFinite(t+e+r+i+n+s)){var o=a.__read(this._transform.apply(n,s),2),l=o[0],h=o[1],_=a.__read(this._transform.apply(t,e),2),p=_[0],u=_[1],c=a.__read(this._transform.apply(r,i),2),d=c[0],f=c[1];this.__addPathCommand(l,h,"C "+p+" "+u+" "+d+" "+f+" "+l+" "+h)}},t.prototype.quadraticCurveTo=function(t,e,r,i){if(isFinite(t+e+r+i)){var n=a.__read(this._transform.apply(r,i),2),s=n[0],o=n[1],l=a.__read(this._transform.apply(t,e),2),h=l[0],_=l[1];this.__addPathCommand(s,o,"Q "+h+" "+_+" "+s+" "+o)}},t.prototype.arcTo=function(t,e,r,i,n){if(isFinite(t+e+r+i+n)&&null!=this.__currentPosition){var s=this.__currentPosition.x,o=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(s===t&&o===e||t===r&&e===i||0===n)this.lineTo(t,e);else{var l=w([s-t,o-e]),h=w([r-t,i-e]);if(l[0]*h[1]!=l[1]*h[0]){var _=l[0]*h[0]+l[1]*h[1],p=Math.acos(Math.abs(_)),u=w([l[0]+h[0],l[1]+h[1]]),c=n/Math.sin(p/2),d=t+c*u[0],f=e+c*u[1],m=[-l[1],l[0]],g=[h[1],-h[0]],v=b(m),y=b(g);this.lineTo(d+m[0]*n,f+m[1]*n),this.arc(d,f,n,v,y)}else this.lineTo(t,e)}}function w(t){var e=a.__read(t,2),r=e[0],i=e[1],n=Math.sqrt(Math.pow(r,2)+Math.pow(i,2));return[r/n,i/n]}function b(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}},t.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.fill=function(t){"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=t&&this.__currentElement.setAttribute("fill-rule",t),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.rect=function(t,e,r,i){isFinite(t+e+r+i)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e))},t.prototype.fillRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.fill())},t.prototype.strokeRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.stroke())},t.prototype.__clearCanvas=function(){l.empty(this.__defs),l.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root},t.prototype.clearRect=function(t,e,r,i){if(isFinite(t+e+r+i))if(0!==t||0!==e||r!==this.width||i!==this.height){var n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}else this.__clearCanvas()},t.prototype.createLinearGradient=function(t,e,r,i){if(!isFinite(t+e+r+i))throw new Error("The provided double value is non-finite");var n=a.__read(this._transform.apply(t,e),2),s=n[0],o=n[1],l=a.__read(this._transform.apply(r,i),2),_=l[0],p=l[1],u=this.__createElement("linearGradient",{id:h(this.__ids),x1:s+"px",x2:_+"px",y1:o+"px",y2:p+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(u),new c(u,this)},t.prototype.createRadialGradient=function(t,e,r,i,n,s){if(!isFinite(t+e+r+i+n+s))throw new Error("The provided double value is non-finite");var o=a.__read(this._transform.apply(t,e),2),l=o[0],_=o[1],p=a.__read(this._transform.apply(i,n),2),u=p[0],d=p[1],f=this.__createElement("radialGradient",{id:h(this.__ids),cx:u+"px",cy:d+"px",r:s+"px",fx:l+"px",fy:_+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(f),new c(f,this)},t.prototype.__parseFont=function(){var t,e,r,i,n,a=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),s={style:null!==(t=a[1])&&void 0!==t?t:"normal",size:null!==(e=a[4])&&void 0!==e?e:"10px",family:null!==(r=a[6])&&void 0!==r?r:"sans-serif",weight:null!==(i=a[3])&&void 0!==i?i:"normal",decoration:null!==(n=a[2])&&void 0!==n?n:"normal"};return"underline"===this.__fontUnderline&&(s.decoration="underline"),null!=this.__fontHref&&(s.href=this.__fontHref),s},t.prototype.__wrapTextLink=function(t,e){if(t.href){var r=this.__createElement("a");return r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),r.appendChild(e),r}return e},t.prototype.__applyText=function(t,e,r,i){var n,a,s,o=this.__parseFont(),l=this.__createElement("text",{"font-family":o.family,"font-size":o.size,"font-style":o.style,"font-weight":o.weight,"text-decoration":o.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,s={left:"start",right:"end",center:"middle",start:"start",end:"end"},null!==(a=s[n])&&void 0!==a?a:s.start),"dominant-baseline":_(this.textBaseline)},!0);l.appendChild(this.__document.createTextNode(t)),this._apply_transform(l),this.__currentElement=l,this.__applyStyleToCurrentElement(i),this.__root.appendChild(this.__wrapTextLink(o,l))},t.prototype.fillText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"fill")},t.prototype.strokeText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"stroke")},t.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},t.prototype.arc=function(t,e,r,i,n,s){if(void 0===s&&(s=!1),isFinite(t+e+r+i+n)&&i!==n){(i%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(s?-1:1))%(2*Math.PI));var o=t+r*Math.cos(n),l=e+r*Math.sin(n),h=t+r*Math.cos(i),_=e+r*Math.sin(i),p=s?0:1,u=0,c=n-i;c<0&&(c+=2*Math.PI),u=s?c>Math.PI?0:1:c>Math.PI?1:0,this.lineTo(h,_);var d=r,f=r,m=a.__read(this._transform.apply(o,l),2),g=m[0],v=m[1];this.__addPathCommand(g,v,"A "+d+" "+f+" 0 "+u+" "+p+" "+g+" "+v)}},t.prototype.clip=function(){var t=this.__createElement("clipPath"),e=h(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path="url(#"+e+")"},t.prototype.drawImage=function(e){for(var r,i,n,s,o,l,h,_,p,u,c,d,f,m,g,v=[],y=1;y<arguments.length;y++)v[y-1]=arguments[y];if(2==v.length){if(_=(r=a.__read(v,2))[0],p=r[1],!isFinite(_+p))return;d=0,f=0,u=m=e.width,c=g=e.height}else if(4==v.length){if(_=(i=a.__read(v,4))[0],p=i[1],u=i[2],c=i[3],!isFinite(_+p+u+c))return;d=0,f=0,m=e.width,g=e.height}else{if(8!==v.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if(d=(n=a.__read(v,8))[0],f=n[1],m=n[2],g=n[3],_=n[4],p=n[5],u=n[6],c=n[7],!isFinite(d+f+m+g+_+p+u+c))return}var w=this.__root,b=this._transform.clone().translate(_,p);if(e instanceof t||e instanceof SVGSVGElement){var x=e instanceof SVGSVGElement?e:e.get_svg(),A=x.cloneNode(!0),E=void 0;b.is_identity?E=w:(E=this.__createElement("g"),this._apply_transform(E,b),w.appendChild(E));try{for(var k=a.__values(a.__spreadArray([],a.__read(A.childNodes))),C=k.next();!C.done;C=k.next()){var S=C.value;if(S instanceof SVGDefsElement)try{for(var T=(l=void 0,a.__values(a.__spreadArray([],a.__read(S.childNodes)))),P=T.next();!P.done;P=T.next()){var M=P.value;if(M instanceof Element){var N=M.getAttribute("id");this.__ids[N]=N,this.__defs.appendChild(M.cloneNode(!0))}}}catch(t){l={error:t}}finally{try{P&&!P.done&&(h=T.return)&&h.call(T)}finally{if(l)throw l.error}}else E.appendChild(S.cloneNode(!0))}}catch(t){s={error:t}}finally{try{C&&!C.done&&(o=k.return)&&o.call(k)}finally{if(s)throw s.error}}}else if(e instanceof HTMLImageElement||e instanceof SVGImageElement){if((D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),d||f||m!==e.width||g!==e.height)(F=this.__document.createElement("canvas")).width=u,F.height=c,(O=F.getContext("2d")).drawImage(e,d,f,m,g,0,0,u,c),e=F;this._apply_transform(D,b);var j=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",j),w.appendChild(D)}else if(e instanceof HTMLCanvasElement){var D,F,O;(D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),(F=this.__document.createElement("canvas")).width=u,F.height=c,(O=F.getContext("2d")).imageSmoothingEnabled=!1,O.drawImage(e,d,f,m,g,0,0,u,c),e=F,this._apply_transform(D,b),D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e.toDataURL()),w.appendChild(D)}},t.prototype.createPattern=function(e,r){var i,n,s,o,l=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),_=h(this.__ids);if(l.setAttribute("id",_),l.setAttribute("width",""+this._to_number(e.width)),l.setAttribute("height",""+this._to_number(e.height)),l.setAttribute("patternUnits","userSpaceOnUse"),e instanceof HTMLCanvasElement||e instanceof HTMLImageElement||e instanceof SVGImageElement){var p=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),u=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",u),l.appendChild(p),this.__defs.appendChild(l)}else if(e instanceof t){try{for(var c=a.__values(a.__spreadArray([],a.__read(e.__root.childNodes))),f=c.next();!f.done;f=c.next()){(v=f.value)instanceof SVGDefsElement||l.appendChild(v.cloneNode(!0))}}catch(t){i={error:t}}finally{try{f&&!f.done&&(n=c.return)&&n.call(c)}finally{if(i)throw i.error}}this.__defs.appendChild(l)}else{if(!(e instanceof SVGSVGElement))throw new Error("unsupported");try{for(var m=a.__values(a.__spreadArray([],a.__read(e.childNodes))),g=m.next();!g.done;g=m.next()){var v;(v=g.value)instanceof SVGDefsElement||l.appendChild(v.cloneNode(!0))}}catch(t){s={error:t}}finally{try{g&&!g.done&&(o=m.return)&&o.call(m)}finally{if(s)throw s.error}}this.__defs.appendChild(l)}return new d(l,this)},t.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},t.prototype._to_number=function(t){return o.isNumber(t)?t:t.baseVal.value},t.prototype.getTransform=function(){return this._transform.to_DOMMatrix()},t.prototype.setTransform=function(t){this._transform=s.AffineTransform.from_DOMMatrix(t)},t.prototype.resetTransform=function(){this._transform=new s.AffineTransform},t}();r.SVGRenderingContext2D=f,f.__name__="SVGRenderingContext2D"},
function _(t,n,o,i,e){i();var c=t(1),u=t(335),l=t(130),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(n,t),n.prototype._clicked=function(){this.model.do.emit(void 0)},n}(u.ButtonToolButtonView);o.ActionToolButtonView=_,_.__name__="ActionToolButtonView";var r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,(function(t){return n.doit(t)}))},n}(u.ButtonToolView);o.ActionToolView=r,r.__name__="ActionToolView";var s=function(t){function n(n){var o=t.call(this,n)||this;return o.button_view=_,o.do=new l.Signal(o,"do"),o}return c.__extends(n,t),n}(u.ButtonTool);o.ActionTool=s,s.__name__="ActionTool"},
function _(o,t,e,n,i){n();var l=o(1),r=o(348),s=o(339),u=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return l.__extends(t,o),t.prototype.doit=function(){window.open(this.model.redirect)},t}(r.ActionToolView);e.HelpToolView=u,u.__name__="HelpToolView";var _=function(o){function t(t){var e=o.call(this,t)||this;return e.tool_name="Help",e.icon=s.tool_icon_help,e}return l.__extends(t,o),t.init_HelpTool=function(){this.prototype.default_view=u,this.define((function(o){return{redirect:[o.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}})),this.override({description:"Click the question mark to learn more about Bokeh plot tools."}),this.register_alias("help",(function(){return new t}))},t}(r.ActionTool);e.HelpTool=_,_.__name__="HelpTool",_.init_HelpTool()},
function _(o,l,g,A,r){A(),g.root="bk-root",g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.logo_notebook="bk-logo-notebook",g.default=".bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}"},
function _(t,e,i,o,l){o();var s=t(1),n=t(155),r=t(135),a=t(158),h=s.__importStar(t(352)),c=h,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=a.div({class:c.tooltip}),a.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)},e.prototype.remove=function(){a.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.content.change,(function(){return e.render()})),this.connect(this.model.properties.position.change,(function(){return e._reposition()}))},e.prototype.styles=function(){return s.__spreadArray(s.__spreadArray([],s.__read(t.prototype.styles.call(this))),[h.default])},e.prototype.render=function(){this.model.visible||a.undisplay(this.el),t.prototype.render.call(this)},e.prototype._render=function(){var t=this.model.content;null!=t?(a.empty(this.el),a.classes(this.el).toggle("bk-tooltip-custom",this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(c.tooltip_arrow)):a.undisplay(this.el)},e.prototype._reposition=function(){var t=this,e=this.model.position;if(null!=e){var i,o=s.__read(e,2),l=o[0],n=o[1],r=function(){var e=t.parent.layout.bbox.relative(),i=t.model.attachment;switch(i){case"horizontal":return l<e.hcenter?"right":"left";case"vertical":return n<e.vcenter?"below":"above";default:return i}}();this.el.classList.remove(c.right),this.el.classList.remove(c.left),this.el.classList.remove(c.above),this.el.classList.remove(c.below),a.display(this.el);var h=null,p=null;switch(r){case"right":this.el.classList.add(c.left),h=l+(this.el.offsetWidth-this.el.clientWidth)+10,i=n-this.el.offsetHeight/2;break;case"left":this.el.classList.add(c.right),p=this.plot_view.layout.bbox.width-l+10,i=n-this.el.offsetHeight/2;break;case"below":this.el.classList.add(c.above),i=n+(this.el.offsetHeight-this.el.clientHeight)+10,h=Math.round(l-this.el.offsetWidth/2);break;case"above":this.el.classList.add(c.below),i=n-this.el.offsetHeight-10,h=Math.round(l-this.el.offsetWidth/2)}this.el.style.top=i+"px",this.el.style.left=null!=h?h+"px":"auto",this.el.style.right=null!=p?p+"px":"auto"}else a.undisplay(this.el)},e}(n.AnnotationView);i.TooltipView=p,p.__name__="TooltipView";var u=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Tooltip=function(){this.prototype.default_view=p,this.define((function(t){var e=t.Boolean;return{attachment:[r.TooltipAttachment,"horizontal"],inner_only:[e,!0],show_arrow:[e,!0]}})),this.internal((function(t){var e=t.Boolean,i=t.Number,o=t.Tuple,l=t.Ref;return{position:[(0,t.Nullable)(o(i,i)),null],content:[l(HTMLElement),function(){return a.div()}],custom:[e]}})),this.override({level:"overlay"})},e.prototype.clear=function(){this.position=null},e}(n.Annotation);i.Tooltip=u,u.__name__="Tooltip",u.init_Tooltip()},
function _(o,t,r,e,l){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.left="bk-left",r.tooltip_arrow="bk-tooltip-arrow",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.default='.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}'},
function _(e,t,i,r,s){r();var n=e(1),a=e(230),o=e(227),h=e(228),l=e(163),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){var t,i,r,s,a;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return n.sent(),t=this.model,i=t.lower_head,r=t.upper_head,null==i?[3,3]:(s=this,[4,h.build_view(i,{parent:this})]);case 2:s.lower_head=n.sent(),n.label=3;case 3:return null==r?[3,5]:(a=this,[4,h.build_view(r,{parent:this})]);case 4:a.upper_head=n.sent(),n.label=5;case 5:return[2]}}))}))},t.prototype.set_data=function(t){var i,r;e.prototype.set_data.call(this,t),null===(i=this.lower_head)||void 0===i||i.set_data(t),null===(r=this.upper_head)||void 0===r||r.set_data(t)},t.prototype.paint=function(e){if(this.visuals.line.doit)for(var t=0,i=this._lower_sx.length;t<i;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();var r="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(t=0,i=this._lower_sx.length;t<i;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(r+Math.PI),this.lower_head.render(e,t),e.restore();if(null!=this.upper_head)for(t=0,i=this._upper_sx.length;t<i;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(r),this.upper_head.render(e,t),e.restore()},t}(a.UpperLowerView);i.WhiskerView=_,_.__name__="WhiskerView";var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Whisker=function(){this.prototype.default_view=_,this.mixins(l.LineVector),this.define((function(e){var t=e.Ref,i=e.Nullable;return{lower_head:[i(t(o.ArrowHead)),function(){return new o.TeeHead({size:10})}],upper_head:[i(t(o.ArrowHead)),function(){return new o.TeeHead({size:10})}]}})),this.override({level:"underlay"})},t}(a.UpperLower);i.Whisker=u,u.__name__="Whisker",u.init_Whisker()},
function _(n,o,t,u,e){u(),e("CustomJS",n(355).CustomJS),e("OpenURL",n(357).OpenURL)},
function _(e,t,n,r,i){r();var o=e(1),u=e(356),a=e(128),c=e(149),s=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CustomJS=function(){this.define((function(e){var t=e.Unknown,n=e.String;return{args:[(0,e.Dict)(t),{}],code:[n,""]}}))},Object.defineProperty(t.prototype,"names",{get:function(){return a.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return a.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=c.use_strict(this.code);return new(Function.bind.apply(Function,o.__spreadArray(o.__spreadArray([void 0],o.__read(this.names)),["cb_obj","cb_data",e])))},enumerable:!1,configurable:!0}),t.prototype.execute=function(e,t){return void 0===t&&(t={}),this.func.apply(e,this.values.concat(e,t))},t}(u.Callback);n.CustomJS=s,s.__name__="CustomJS",s.init_CustomJS()},
function _(n,t,a,l,_){l();var c=n(1),e=function(n){function t(t){return n.call(this,t)||this}return c.__extends(t,n),t}(n(168).Model);a.Callback=e,e.__name__="Callback"},
function _(n,e,t,r,i){r();var o=n(1),a=n(356),l=n(260),c=n(123),u=function(n){function e(e){return n.call(this,e)||this}return o.__extends(e,n),e.init_OpenURL=function(){this.define((function(n){var e=n.Boolean;return{url:[n.String,"http://"],same_tab:[e,!1]}}))},e.prototype.navigate=function(n){this.same_tab?window.location.href=n:window.open(n)},e.prototype.execute=function(n,e){var t,r,i,a,u=this,f=e.source,s=function(n){var e=l.replace_placeholders(u.url,f,n,void 0,void 0,encodeURI);if(!c.isString(e))throw new Error("HTML output is not supported in this context");u.navigate(e)},_=f.selected;try{for(var d=o.__values(_.indices),p=d.next();!p.done;p=d.next()){s(p.value)}}catch(n){t={error:n}}finally{try{p&&!p.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}try{for(var h=o.__values(_.line_indices),v=h.next();!v.done;v=h.next()){s(v.value)}}catch(n){i={error:n}}finally{try{v&&!v.done&&(a=h.return)&&a.call(h)}finally{if(i)throw i.error}}},e}(a.Callback);t.OpenURL=u,u.__name__="OpenURL",u.init_OpenURL()},
function _(a,n,i,e,r){e(),r("Canvas",a(359).Canvas),r("CartesianFrame",a(239).CartesianFrame),r("CoordinateMapping",a(169).CoordinateMapping)},
function _(e,t,i,r,a){r();var n=e(1),s=e(129),o=e(337),l=e(134),p=e(158),h=e(135),_=e(128),u=e(360),c=e(180),v=e(346),d=e(363),y=function(){var e=document.createElement("canvas"),t=e.getContext("webgl",{premultipliedAlpha:!0});if(null!=t){var i=d.get_regl(t);return i.has_webgl?{canvas:e,regl_wrapper:i}:void l.logger.trace("WebGL is supported, but not the required extensions")}l.logger.trace("WebGL is not supported")}(),b={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},g=function(e){function t(){var t=e.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return t.bbox=new c.BBox,t}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),"webgl"==this.model.output_backend&&(this.webgl=y),this.underlays_el=p.div({style:b}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=p.div({style:b}),this.events_el=p.div({class:"bk-canvas-events",style:b});var t=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];_.extend(this.el.style,b),p.append.apply(void 0,n.__spreadArray([this.el],n.__read(t))),this.ui_event_bus=new u.UIEventBus(this)},t.prototype.remove=function(){this.ui_event_bus.destroy(),e.prototype.remove.call(this)},t.prototype.add_underlay=function(e){this.underlays_el.appendChild(e)},t.prototype.add_overlay=function(e){this.overlays_el.appendChild(e)},t.prototype.add_event=function(e){this.events_el.appendChild(e)},Object.defineProperty(t.prototype,"pixel_ratio",{get:function(){return this.primary.pixel_ratio},enumerable:!1,configurable:!0}),t.prototype.resize=function(e,t){this.bbox=new c.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)},t.prototype.prepare_webgl=function(e){var t=this.webgl;if(null!=t){var i=this.bbox,r=i.width,a=i.height;t.canvas.width=this.pixel_ratio*r,t.canvas.height=this.pixel_ratio*a;var s=n.__read(e,4),o=s[0],l=s[1],p=s[2],h=s[3],_=this.bbox,u=_.xview,c=_.yview,v=u.compute(o),d=c.compute(l+h),y=this.pixel_ratio;t.regl_wrapper.set_scissor(y*v,y*d,y*p,y*h),this._clear_webgl()}},t.prototype.blit_webgl=function(e){var t=this.webgl;if(null!=t){if(l.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){var i=this.pixel_ratio;e.scale(i,i),e.translate(.5,.5)}this._clear_webgl()}},t.prototype._clear_webgl=function(){var e=this.webgl;if(null!=e){var t=e.regl_wrapper,i=e.canvas;t.clear(i.width,i.height)}},t.prototype.compose=function(){var e=this.create_layer(),t=this.bbox,i=t.width,r=t.height;return e.resize(i,r),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e},t.prototype.create_layer=function(){var e=this.model,t=e.output_backend,i=e.hidpi;return new v.CanvasLayer(t,i)},t.prototype.to_blob=function(){return this.compose().to_blob()},t}(o.DOMView);i.CanvasView=g,g.__name__="CanvasView";var w=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Canvas=function(){this.prototype.default_view=g,this.internal((function(e){return{hidpi:[e.Boolean,!0],output_backend:[h.OutputBackend,"canvas"]}}))},t}(s.HasProps);i.Canvas=w,w.__name__="Canvas",w.init_Canvas()},
function _(t,e,n,r,i){r();var s=t(1),o=s.__importDefault(t(336)),a=t(130),_=t(134),h=t(158),p=s.__importStar(t(361)),u=t(362),c=t(124),l=t(123),v=t(142),y=t(341);var d=function(){function t(t){var e=this;this.canvas_view=t,this.pan_start=new a.Signal(this,"pan:start"),this.pan=new a.Signal(this,"pan"),this.pan_end=new a.Signal(this,"pan:end"),this.pinch_start=new a.Signal(this,"pinch:start"),this.pinch=new a.Signal(this,"pinch"),this.pinch_end=new a.Signal(this,"pinch:end"),this.rotate_start=new a.Signal(this,"rotate:start"),this.rotate=new a.Signal(this,"rotate"),this.rotate_end=new a.Signal(this,"rotate:end"),this.tap=new a.Signal(this,"tap"),this.doubletap=new a.Signal(this,"doubletap"),this.press=new a.Signal(this,"press"),this.pressup=new a.Signal(this,"pressup"),this.move_enter=new a.Signal(this,"move:enter"),this.move=new a.Signal(this,"move"),this.move_exit=new a.Signal(this,"move:exit"),this.scroll=new a.Signal(this,"scroll"),this.keydown=new a.Signal(this,"keydown"),this.keyup=new a.Signal(this,"keyup"),this.hammer=new o.default(this.hit_area,{touchAction:"auto",inputClass:o.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(function(t){return e._mouse_move(t)})),this.hit_area.addEventListener("mouseenter",(function(t){return e._mouse_enter(t)})),this.hit_area.addEventListener("mouseleave",(function(t){return e._mouse_exit(t)})),this.hit_area.addEventListener("contextmenu",(function(t){return e._context_menu(t)})),this.hit_area.addEventListener("wheel",(function(t){return e._mouse_wheel(t)})),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new y.ContextMenu([],{prevent_hide:function(t){return 2==t.button&&t.target==e.hit_area}}),this.hit_area.appendChild(this.menu.el)}return Object.defineProperty(t.prototype,"hit_area",{get:function(){return this.canvas_view.events_el},enumerable:!1,configurable:!0}),t.prototype.destroy=function(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(function(e){return t._doubletap(e)})),this.hammer.on("tap",(function(e){return t._tap(e)})),this.hammer.on("press",(function(e){return t._press(e)})),this.hammer.on("pressup",(function(e){return t._pressup(e)})),this.hammer.get("pan").set({direction:o.default.DIRECTION_ALL}),this.hammer.on("panstart",(function(e){return t._pan_start(e)})),this.hammer.on("pan",(function(e){return t._pan(e)})),this.hammer.on("panend",(function(e){return t._pan_end(e)})),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(function(e){return t._pinch_start(e)})),this.hammer.on("pinch",(function(e){return t._pinch(e)})),this.hammer.on("pinchend",(function(e){return t._pinch_end(e)})),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(function(e){return t._rotate_start(e)})),this.hammer.on("rotate",(function(e){return t._rotate(e)})),this.hammer.on("rotateend",(function(e){return t._rotate_end(e)}))},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&(l.isString(n)?this._register_tool(t,n):n.forEach((function(n,r){return e._register_tool(t,n,r<1)})))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var r=t,i=r.model.id,s=function(t){return function(e){e.id==i&&t(e.e)}},o=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=r._pan_start&&r.connect(this.pan_start,s(r._pan_start.bind(r))),null!=r._pan&&r.connect(this.pan,s(r._pan.bind(r))),null!=r._pan_end&&r.connect(this.pan_end,s(r._pan_end.bind(r)));break;case"pinch":null!=r._pinch_start&&r.connect(this.pinch_start,s(r._pinch_start.bind(r))),null!=r._pinch&&r.connect(this.pinch,s(r._pinch.bind(r))),null!=r._pinch_end&&r.connect(this.pinch_end,s(r._pinch_end.bind(r)));break;case"rotate":null!=r._rotate_start&&r.connect(this.rotate_start,s(r._rotate_start.bind(r))),null!=r._rotate&&r.connect(this.rotate,s(r._rotate.bind(r))),null!=r._rotate_end&&r.connect(this.rotate_end,s(r._rotate_end.bind(r)));break;case"move":null!=r._move_enter&&r.connect(this.move_enter,s(r._move_enter.bind(r))),null!=r._move&&r.connect(this.move,s(r._move.bind(r))),null!=r._move_exit&&r.connect(this.move_exit,s(r._move_exit.bind(r)));break;case"tap":null!=r._tap&&r.connect(this.tap,s(r._tap.bind(r))),null!=r._doubletap&&r.connect(this.doubletap,s(r._doubletap.bind(r)));break;case"press":null!=r._press&&r.connect(this.press,s(r._press.bind(r))),null!=r._pressup&&r.connect(this.pressup,s(r._pressup.bind(r)));break;case"scroll":null!=r._scroll&&r.connect(this.scroll,s(r._scroll.bind(r)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=r._keydown&&r.connect(this.keydown,o(r._keydown.bind(r))),null!=r._keyup&&r.connect(this.keyup,o(r._keyup.bind(r))),v.is_mobile&&null!=r._scroll&&"pinch"==e&&(_.logger.debug("Registering scroll on touch screen"),r.connect(this.scroll,s(r._scroll.bind(r)))))},t.prototype._hit_test_renderers=function(t,e,n){var r,i,o,a=t.get_renderer_views();try{for(var _=s.__values(c.reversed(a)),h=_.next();!h.done;h=_.next()){var p=h.value;if(null===(o=p.interactive_hit)||void 0===o?void 0:o.call(p,e,n))return p}}catch(t){r={error:t}}finally{try{h&&!h.done&&(i=_.return)&&i.call(_)}finally{if(r)throw r.error}}return null},t.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.hit_area.style.cursor=t},t.prototype._hit_test_frame=function(t,e,n){return t.frame.bbox.contains(e,n)},t.prototype._hit_test_canvas=function(t,e,n){return t.layout.bbox.contains(e,n)},t.prototype._hit_test_plot=function(t,e){var n,r;try{for(var i=s.__values(this.canvas_view.plot_views),o=i.next();!o.done;o=i.next()){var a=o.value;if(a.layout.bbox.relative().contains(t,e))return a}}catch(t){n={error:t}}finally{try{o&&!o.done&&(r=i.return)&&r.call(i)}finally{if(n)throw n.error}}return null},t.prototype._trigger=function(t,e,n){var r,i=e.sx,o=e.sy,a=this._hit_test_plot(i,o),_=function(t){var n=s.__read([i,o],2),r=n[0],a=n[1];return s.__assign(s.__assign({},e),{sx:r,sy:a})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){var h=void 0;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},h=a):"pan"==e.type&&null!=this._curr_pan?h=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(h=this._curr_pan.plot_view,this._curr_pan=null):h=null,null!=h){var p=_();this.__trigger(h,t,p,n)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){var u=void 0;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},u=a):"pinch"==e.type&&null!=this._curr_pinch?u=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(u=this._curr_pinch.plot_view,this._curr_pinch=null):u=null,null!=u){p=_();this.__trigger(u,t,p,n)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){var c=void 0;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},c=a):"rotate"==e.type&&null!=this._curr_rotate?c=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(c=this._curr_rotate.plot_view,this._curr_rotate=null):c=null,null!=c){p=_();this.__trigger(c,t,p,n)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){var l=null===(r=this._prev_move)||void 0===r?void 0:r.plot_view;if(null!=l&&("mouseleave"==e.type||l!=a)){var v=_(),y=v.sx,d=v.sy;this.__trigger(l,this.move_exit,{type:"mouseleave",sx:y,sy:d,shiftKey:!1,ctrlKey:!1},n)}if(null!=a&&("mouseenter"==e.type||l!=a)){var g=_(),f=g.sx,m=g.sy;this.__trigger(a,this.move_enter,{type:"mouseenter",sx:f,sy:m,shiftKey:!1,ctrlKey:!1},n)}if(null!=a&&"mousemove"==e.type){p=_();this.__trigger(a,t,p,n)}this._prev_move={sx:i,sy:o,plot_view:a}}else if(null!=a){p=_();this.__trigger(a,t,p,n)}},t.prototype.__trigger=function(t,e,n,r){var i,s,o=this,a=t.model.toolbar.gestures,_=e.name.split(":")[0],h=this._hit_test_renderers(t,n.sx,n.sy),p=this._hit_test_canvas(t,n.sx,n.sy);switch(_){case"move":null!=(d=a[_].active)&&this.trigger(e,n,d.id);var u=t.model.toolbar.inspectors.filter((function(t){return t.active})),l="default";null!=h?(l=null!==(i=h.cursor(n.sx,n.sy))&&void 0!==i?i:l,c.is_empty(u)||(e=this.move_exit)):this._hit_test_frame(t,n.sx,n.sy)&&(c.is_empty(u)||(l="crosshair")),this.set_cursor(l),t.set_toolbar_visibility(p),u.map((function(t){return o.trigger(e,n,t.id)}));break;case"tap":var y=r.target;if(null!=y&&y!=this.hit_area)return;null!=h&&null!=h.on_hit&&h.on_hit(n.sx,n.sy),null!=(d=a[_].active)&&this.trigger(e,n,d.id);break;case"doubletap":null!=(d=null!==(s=a.doubletap.active)&&void 0!==s?s:a.tap.active)&&this.trigger(e,n,d.id);break;case"scroll":null!=(d=a[v.is_mobile?"pinch":"scroll"].active)&&(r.preventDefault(),r.stopPropagation(),this.trigger(e,n,d.id));break;case"pan":null!=(d=a[_].active)&&(r.preventDefault(),this.trigger(e,n,d.id));break;default:var d;null!=(d=a[_].active)&&this.trigger(e,n,d.id)}this._trigger_bokeh_event(t,n)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t,e){var n=function(){var n=e.sx,r=e.sy,i=t.frame.x_scale.invert(n),s=t.frame.y_scale.invert(r);switch(e.type){case"wheel":return new p.MouseWheel(n,r,i,s,e.delta);case"mousemove":return new p.MouseMove(n,r,i,s);case"mouseenter":return new p.MouseEnter(n,r,i,s);case"mouseleave":return new p.MouseLeave(n,r,i,s);case"tap":return new p.Tap(n,r,i,s);case"doubletap":return new p.DoubleTap(n,r,i,s);case"press":return new p.Press(n,r,i,s);case"pressup":return new p.PressUp(n,r,i,s);case"pan":return new p.Pan(n,r,i,s,e.deltaX,e.deltaY);case"panstart":return new p.PanStart(n,r,i,s);case"panend":return new p.PanEnd(n,r,i,s);case"pinch":return new p.Pinch(n,r,i,s,e.scale);case"pinchstart":return new p.PinchStart(n,r,i,s);case"pinchend":return new p.PinchEnd(n,r,i,s);case"rotate":return new p.Rotate(n,r,i,s,e.rotation);case"rotatestart":return new p.RotateStart(n,r,i,s);case"rotateend":return new p.RotateEnd(n,r,i,s);default:return}}();null!=n&&t.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,r=e.pageY,i=h.offset(this.hit_area);return{sx:n-i.left,sy:r-i.top}},t.prototype._pan_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._pinch_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._rotate_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._tap_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._move_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._scroll_event=function(t){return s.__assign(s.__assign({type:t.type},this._get_sxy(t)),{delta:u.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._pressup=function(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._context_menu=function(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();var e=this._get_sxy(t),n=e.sx,r=e.sy;this.menu.toggle({left:n,top:r})},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();n.UIEventBus=d,d.__name__="UIEventBus"},
function _(t,n,e,r,_){r();var o=t(1),a=this&&this.__decorate||function(t,n,e,r){var _,o=arguments.length,a=o<3?n:null===r?r=Object.getOwnPropertyDescriptor(n,e):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(t,n,e,r);else for(var s=t.length-1;s>=0;s--)(_=t[s])&&(a=(o<3?_(a):o>3?_(n,e,a):_(n,e))||a);return o>3&&a&&Object.defineProperty(n,e,a),a};function s(t){return function(n){n.prototype.event_name=t}}var i=function(){function t(){}return t.prototype.to_json=function(){return{event_name:this.event_name,event_values:this._to_json()}},t}();e.BokehEvent=i,i.__name__="BokehEvent";var u=function(t){function n(){var n=t.apply(this,o.__spreadArray([],o.__read(arguments)))||this;return n.origin=null,n}return o.__extends(n,t),n.prototype._to_json=function(){return{model:this.origin}},n}(i);e.ModelEvent=u,u.__name__="ModelEvent";var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n.prototype._to_json=function(){return{}},n}(i);e.DocumentReady=l,l.__name__="DocumentReady",e.DocumentReady=l=a([s("document_ready")],l);var c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(u);e.ButtonClick=c,c.__name__="ButtonClick",e.ButtonClick=c=a([s("button_click")],c);var p=function(t){function n(n){var e=t.call(this)||this;return e.item=n,e}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.item;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{item:n})},n}(u);e.MenuItemClick=p,p.__name__="MenuItemClick",e.MenuItemClick=p=a([s("menu_item_click")],p);var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(u);e.UIEvent=h,h.__name__="UIEvent";var f=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(h);e.LODStart=f,f.__name__="LODStart",e.LODStart=f=a([s("lodstart")],f);var d=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(h);e.LODEnd=d,d.__name__="LODEnd",e.LODEnd=d=a([s("lodend")],d);var y=function(t){function n(n,e,r,_){var o=t.call(this)||this;return o.x0=n,o.x1=e,o.y0=r,o.y1=_,o}return o.__extends(n,t),n.prototype._to_json=function(){var n=this,e=n.x0,r=n.x1,_=n.y0,a=n.y1;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{x0:e,x1:r,y0:_,y1:a})},n}(h);e.RangesUpdate=y,y.__name__="RangesUpdate",e.RangesUpdate=y=a([s("rangesupdate")],y);var v=function(t){function n(n,e){var r=t.call(this)||this;return r.geometry=n,r.final=e,r}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.geometry,e=this.final;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{geometry:n,final:e})},n}(h);e.SelectionGeometry=v,v.__name__="SelectionGeometry",e.SelectionGeometry=v=a([s("selectiongeometry")],v);var m=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(h);e.Reset=m,m.__name__="Reset",e.Reset=m=a([s("reset")],m);var x=function(t){function n(n,e,r,_){var o=t.call(this)||this;return o.sx=n,o.sy=e,o.x=r,o.y=_,o}return o.__extends(n,t),n.prototype._to_json=function(){var n=this,e=n.sx,r=n.sy,_=n.x,a=n.y;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{sx:e,sy:r,x:_,y:a})},n}(h);e.PointEvent=x,x.__name__="PointEvent";var g=function(t){function n(n,e,r,_,o,a){var s=t.call(this,n,e,r,_)||this;return s.delta_x=o,s.delta_y=a,s}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.delta_x,e=this.delta_y;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{delta_x:n,delta_y:e})},n}(x);e.Pan=g,g.__name__="Pan",e.Pan=g=a([s("pan")],g);var P=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.scale=o,a}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.scale;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{scale:n})},n}(x);e.Pinch=P,P.__name__="Pinch",e.Pinch=P=a([s("pinch")],P);var j=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.rotation=o,a}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.rotation;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{rotation:n})},n}(x);e.Rotate=j,j.__name__="Rotate",e.Rotate=j=a([s("rotate")],j);var E=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.delta=o,a}return o.__extends(n,t),n.prototype._to_json=function(){var n=this.delta;return o.__assign(o.__assign({},t.prototype._to_json.call(this)),{delta:n})},n}(x);e.MouseWheel=E,E.__name__="MouseWheel",e.MouseWheel=E=a([s("wheel")],E);var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.MouseMove=R,R.__name__="MouseMove",e.MouseMove=R=a([s("mousemove")],R);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.MouseEnter=M,M.__name__="MouseEnter",e.MouseEnter=M=a([s("mouseenter")],M);var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.MouseLeave=S,S.__name__="MouseLeave",e.MouseLeave=S=a([s("mouseleave")],S);var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.Tap=D,D.__name__="Tap",e.Tap=D=a([s("tap")],D);var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.DoubleTap=k,k.__name__="DoubleTap",e.DoubleTap=k=a([s("doubletap")],k);var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.Press=L,L.__name__="Press",e.Press=L=a([s("press")],L);var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.PressUp=O,O.__name__="PressUp",e.PressUp=O=a([s("pressup")],O);var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.PanStart=b,b.__name__="PanStart",e.PanStart=b=a([s("panstart")],b);var U=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.PanEnd=U,U.__name__="PanEnd",e.PanEnd=U=a([s("panend")],U);var C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.PinchStart=C,C.__name__="PinchStart",e.PinchStart=C=a([s("pinchstart")],C);var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.PinchEnd=T,T.__name__="PinchEnd",e.PinchEnd=T=a([s("pinchend")],T);var B=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.RotateStart=B,B.__name__="RotateStart",e.RotateStart=B=a([s("rotatestart")],B);var I=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n}(x);e.RotateEnd=I,I.__name__="RotateEnd",e.RotateEnd=I=a([s("rotateend")],I)},
function _(t,e,n,l,a){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function o(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){var e,n,l,a,r=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:r*=(e=t.target,null!==(a=null!==(l=o(null!==(n=e.offsetParent)&&void 0!==n?n:document.body))&&void 0!==l?l:o(e))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:r*=function(t){return t.clientHeight}(t.target)}return r}},
function _(e,r,t,n,i){n();var a,o=e(1),s=o.__importDefault(e(364)),_=e(365),l=o.__importDefault(e(367)),u=o.__importDefault(e(368)),p=o.__importDefault(e(369)),f=o.__importDefault(e(370)),c=o.__importDefault(e(371)),h=o.__importDefault(e(372));t.get_regl=function(e){return null==a&&(a=new d(e)),a};var d=function(){function e(e){try{this._regl=s.default({gl:e,extensions:["ANGLE_instanced_arrays","EXT_blend_minmax"]}),this._regl_available=!0,this._line_geometry=this._regl.buffer({usage:"static",type:"float",data:[[-2,0],[-1,-1],[1,-1],[2,0],[1,1],[-1,1]]}),this._line_triangles=this._regl.elements({usage:"static",primitive:"triangles",data:[[0,1,5],[1,2,5],[5,2,4],[2,3,4]]})}catch(e){this._regl_available=!1}}return e.prototype.buffer=function(e){return this._regl.buffer(e)},e.prototype.clear=function(e,r){this._viewport={x:0,y:0,width:e,height:r},this._regl.clear({color:[0,0,0,0]})},Object.defineProperty(e.prototype,"has_webgl",{get:function(){return this._regl_available},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"scissor",{get:function(){return this._scissor},enumerable:!1,configurable:!0}),e.prototype.set_scissor=function(e,r,t,n){this._scissor={x:e,y:r,width:t,height:n}},Object.defineProperty(e.prototype,"viewport",{get:function(){return this._viewport},enumerable:!1,configurable:!0}),e.prototype.dashed_line=function(){var e,r,t,n;return null==this._dashed_line&&(this._dashed_line=(e=this._regl,r=this._line_geometry,t=this._line_triangles,n={vert:"#define DASHED\n\n"+l.default,frag:"#define DASHED\n\n"+u.default,attributes:{a_position:{buffer:r,divisor:0},a_point_prev:function(e,r){return{buffer:r.points,divisor:1}},a_point_start:function(e,r){return{buffer:r.points,divisor:1,offset:2*Float32Array.BYTES_PER_ELEMENT}},a_point_end:function(e,r){return{buffer:r.points,divisor:1,offset:4*Float32Array.BYTES_PER_ELEMENT}},a_point_next:function(e,r){return{buffer:r.points,divisor:1,offset:6*Float32Array.BYTES_PER_ELEMENT}},a_length_so_far:function(e,r){return{buffer:r.length_so_far,divisor:1}}},uniforms:{u_canvas_size:e.prop("canvas_size"),u_pixel_ratio:e.prop("pixel_ratio"),u_antialias:e.prop("antialias"),u_line_color:e.prop("line_color"),u_linewidth:e.prop("linewidth"),u_miter_limit:e.prop("miter_limit"),u_line_join:e.prop("line_join"),u_line_cap:e.prop("line_cap"),u_dash_tex:e.prop("dash_tex"),u_dash_tex_info:e.prop("dash_tex_info"),u_dash_scale:e.prop("dash_scale"),u_dash_offset:e.prop("dash_offset")},elements:t,instances:e.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:e.prop("scissor")},viewport:e.prop("viewport")},e(n))),this._dashed_line},e.prototype.get_dash=function(e){return null==this._dash_cache&&(this._dash_cache=new _.DashCache(this._regl)),this._dash_cache.get(e)},e.prototype.marker=function(e){null==this._marker_map&&(this._marker_map=new Map);var r=this._marker_map.get(e);return null==r&&(r=function(e,r){var t={vert:p.default,frag:"#define USE_"+r.toUpperCase()+"\n\n"+f.default,attributes:{a_position:{buffer:e.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:function(r,t){return{buffer:e.buffer(t.center),divisor:1}},a_size:function(r,t){return m(e,t.size,1,!1,t.nmarkers)},a_angle:function(r,t){return m(e,t.angle,1,!1,t.nmarkers)},a_linewidth:function(r,t){return m(e,t.linewidth,1,!1,t.nmarkers)},a_line_color:function(r,t){return m(e,t.line_color,4,!0,t.nmarkers)},a_fill_color:function(r,t){return m(e,t.fill_color,4,!0,t.nmarkers)},a_show:function(r,t){return{buffer:e.buffer(t.show),normalized:!0,divisor:1}}},uniforms:{u_canvas_size:e.prop("canvas_size"),u_pixel_ratio:e.prop("pixel_ratio"),u_antialias:e.prop("antialias")},count:4,primitive:"triangle fan",instances:e.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:e.prop("scissor")},viewport:e.prop("viewport")};return e(t)}(this._regl,e),this._marker_map.set(e,r)),r},e.prototype.rect_no_hatch=function(){var e,r;return null==this._rect_no_hatch&&(this._rect_no_hatch=(e=this._regl,r={vert:c.default,frag:h.default,attributes:{a_position:{buffer:e.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:function(r,t){return{buffer:e.buffer(t.center),divisor:1}},a_width:function(r,t){return m(e,t.width,1,!1,t.nmarkers)},a_height:function(r,t){return m(e,t.height,1,!1,t.nmarkers)},a_angle:function(r,t){return m(e,t.angle,1,!1,t.nmarkers)},a_linewidth:function(r,t){return m(e,t.linewidth,1,!1,t.nmarkers)},a_line_color:function(r,t){return m(e,t.line_color,4,!0,t.nmarkers)},a_fill_color:function(r,t){return m(e,t.fill_color,4,!0,t.nmarkers)},a_line_join:function(r,t){return m(e,t.line_join,1,!1,t.nmarkers)},a_show:function(r,t){return{buffer:e.buffer(t.show),normalized:!0,divisor:1}}},uniforms:{u_canvas_size:e.prop("canvas_size"),u_pixel_ratio:e.prop("pixel_ratio"),u_antialias:e.prop("antialias")},count:4,primitive:"triangle fan",instances:e.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:e.prop("scissor")},viewport:e.prop("viewport")},e(r))),this._rect_no_hatch},e.prototype.rect_hatch=function(){var e,r;return null==this._rect_hatch&&(this._rect_hatch=(e=this._regl,r={vert:"#define HATCH\n\n"+c.default,frag:"#define HATCH\n\n"+h.default,attributes:{a_position:{buffer:e.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:function(r,t){return{buffer:e.buffer(t.center),divisor:1}},a_width:function(r,t){return m(e,t.width,1,!1,t.nmarkers)},a_height:function(r,t){return m(e,t.height,1,!1,t.nmarkers)},a_angle:function(r,t){return m(e,t.angle,1,!1,t.nmarkers)},a_linewidth:function(r,t){return m(e,t.linewidth,1,!1,t.nmarkers)},a_line_color:function(r,t){return m(e,t.line_color,4,!0,t.nmarkers)},a_fill_color:function(r,t){return m(e,t.fill_color,4,!0,t.nmarkers)},a_line_join:function(r,t){return m(e,t.line_join,1,!1,t.nmarkers)},a_show:function(r,t){return{buffer:e.buffer(t.show),normalized:!0,divisor:1}},a_hatch_pattern:function(r,t){return m(e,t.hatch_pattern,1,!1,t.nmarkers)},a_hatch_scale:function(r,t){return m(e,t.hatch_scale,1,!1,t.nmarkers)},a_hatch_weight:function(r,t){return m(e,t.hatch_weight,1,!1,t.nmarkers)},a_hatch_color:function(r,t){return m(e,t.hatch_color,4,!0,t.nmarkers)}},uniforms:{u_canvas_size:e.prop("canvas_size"),u_pixel_ratio:e.prop("pixel_ratio"),u_antialias:e.prop("antialias")},count:4,primitive:"triangle fan",instances:e.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:e.prop("scissor")},viewport:e.prop("viewport")},e(r))),this._rect_hatch},e.prototype.solid_line=function(){var e,r,t,n;return null==this._solid_line&&(this._solid_line=(e=this._regl,r=this._line_geometry,t=this._line_triangles,n={vert:l.default,frag:u.default,attributes:{a_position:{buffer:r,divisor:0},a_point_prev:function(e,r){return{buffer:r.points,divisor:1}},a_point_start:function(e,r){return{buffer:r.points,divisor:1,offset:2*Float32Array.BYTES_PER_ELEMENT}},a_point_end:function(e,r){return{buffer:r.points,divisor:1,offset:4*Float32Array.BYTES_PER_ELEMENT}},a_point_next:function(e,r){return{buffer:r.points,divisor:1,offset:6*Float32Array.BYTES_PER_ELEMENT}}},uniforms:{u_canvas_size:e.prop("canvas_size"),u_pixel_ratio:e.prop("pixel_ratio"),u_antialias:e.prop("antialias"),u_line_color:e.prop("line_color"),u_linewidth:e.prop("linewidth"),u_miter_limit:e.prop("miter_limit"),u_line_join:e.prop("line_join"),u_line_cap:e.prop("line_cap")},elements:t,instances:e.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:e.prop("scissor")},viewport:e.prop("viewport")},e(n))),this._solid_line},e}();function m(e,r,t,n,i){var a=r.length==t&&i>1?0:1;return{buffer:e.buffer(1==a?r:[r,r,r,r]),divisor:a,normalized:n}}t.ReglWrapper=d,d.__name__="ReglWrapper"},
function _(e,t,r,n,a){var i,o;i=this,o=function(){"use strict";var e=function(e){return e instanceof Uint8Array||e instanceof Uint16Array||e instanceof Uint32Array||e instanceof Int8Array||e instanceof Int16Array||e instanceof Int32Array||e instanceof Float32Array||e instanceof Float64Array||e instanceof Uint8ClampedArray},t=function(e,t){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]=t[r[n]];return e},r="\n";function n(e){var t=new Error("(regl) "+e);throw console.error(t),t}function a(e,t){e||n(t)}function i(e){return e?": "+e:""}function o(e,t){switch(t){case"number":return"number"==typeof e;case"object":return"object"==typeof e;case"string":return"string"==typeof e;case"boolean":return"boolean"==typeof e;case"function":return"function"==typeof e;case"undefined":return void 0===e;case"symbol":return"symbol"==typeof e}}function f(e,t,r){t.indexOf(e)<0&&n("invalid value"+i(r)+". must be one of: "+t)}var u=["gl","canvas","container","attributes","pixelRatio","extensions","optionalExtensions","profile","onDone"];function s(e,t){for(e+="";e.length<t;)e=" "+e;return e}function c(){this.name="unknown",this.lines=[],this.index={},this.hasErrors=!1}function l(e,t){this.number=e,this.line=t,this.errors=[]}function d(e,t,r){this.file=e,this.line=t,this.message=r}function m(){var e=new Error,t=(e.stack||e).toString(),r=/compileProcedure.*\n\s*at.*\((.*)\)/.exec(t);if(r)return r[1];var n=/compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(t);return n?n[1]:"unknown"}function p(){var e=new Error,t=(e.stack||e).toString(),r=/at REGLCommand.*\n\s+at.*\((.*)\)/.exec(t);if(r)return r[1];var n=/at REGLCommand.*\n\s+at\s+(.*)\n/.exec(t);return n?n[1]:"unknown"}function h(e,t){var r,n=e.split("\n"),a=1,i=0,o={unknown:new c,0:new c};o.unknown.name=o[0].name=t||m(),o.unknown.lines.push(new l(0,""));for(var f=0;f<n.length;++f){var u=n[f],s=/^\s*#\s*(\w+)\s+(.+)\s*$/.exec(u);if(s)switch(s[1]){case"line":var d=/(\d+)(\s+\d+)?/.exec(s[2]);d&&(a=0|d[1],d[2]&&((i=0|d[2])in o||(o[i]=new c)));break;case"define":var p=/SHADER_NAME(_B64)?\s+(.*)$/.exec(s[2]);p&&(o[i].name=p[1]?(r=p[2],"undefined"!=typeof atob?atob(r):"base64:"+r):p[2])}o[i].lines.push(new l(a++,u))}return Object.keys(o).forEach((function(e){var t=o[e];t.lines.forEach((function(e){t.index[e.number]=e}))})),o}function b(e){e._commandRef=m()}function v(e,t){var r=p();n(e+" in command "+(t||m())+("unknown"===r?"":" called from "+r))}function g(e,t,r,n){o(e,t)||v("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e,n||m())}var y=33071,x={};function w(e,t){return 32820===e||32819===e||33635===e?2:34042===e?4:x[e]*t}function A(e){return!(e&e-1||!e)}x[5120]=x[5121]=1,x[5122]=x[5123]=x[36193]=x[33635]=x[32819]=x[32820]=2,x[5124]=x[5125]=x[5126]=x[34042]=4;var _=t(a,{optional:function(e){e()},raise:n,commandRaise:v,command:function(e,t,r){e||v(t,r||m())},parameter:function(e,t,r){e in t||n("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join())},commandParameter:function(e,t,r,n){e in t||v("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join(),n||m())},constructor:function(e){Object.keys(e).forEach((function(e){u.indexOf(e)<0&&n('invalid regl constructor argument "'+e+'". must be one of '+u)}))},type:function(e,t,r){o(e,t)||n("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e)},commandType:g,isTypedArray:function(t,r){e(t)||n("invalid parameter type"+i(r)+". must be a typed array")},nni:function(e,t){e>=0&&(0|e)===e||n("invalid parameter type, ("+e+")"+i(t)+". must be a nonnegative integer")},oneOf:f,shaderError:function(e,t,n,i,o){if(!e.getShaderParameter(t,e.COMPILE_STATUS)){var f=e.getShaderInfoLog(t),u=i===e.FRAGMENT_SHADER?"fragment":"vertex";g(n,"string",u+" shader source must be a string",o);var c=h(n,o),l=function(e){var t=[];return e.split("\n").forEach((function(e){if(!(e.length<5)){var r=/^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(e);r?t.push(new d(0|r[1],0|r[2],r[3].trim())):e.length>0&&t.push(new d("unknown",0,e))}})),t}(f);!function(e,t){t.forEach((function(t){var r=e[t.file];if(r){var n=r.index[t.line];if(n)return n.errors.push(t),void(r.hasErrors=!0)}e.unknown.hasErrors=!0,e.unknown.lines[0].errors.push(t)}))}(c,l),Object.keys(c).forEach((function(e){var t=c[e];if(t.hasErrors){var n=[""],a=[""];i("file number "+e+": "+t.name+"\n","color:red;text-decoration:underline;font-weight:bold"),t.lines.forEach((function(e){if(e.errors.length>0){i(s(e.number,4)+"|  ","background-color:yellow; font-weight:bold"),i(e.line+r,"color:red; background-color:yellow; font-weight:bold");var t=0;e.errors.forEach((function(n){var a=n.message,o=/^\s*'(.*)'\s*:\s*(.*)$/.exec(a);if(o){var f=o[1];switch(a=o[2],f){case"assign":f="="}t=Math.max(e.line.indexOf(f,t),0)}else t=0;i(s("| ",6)),i(s("^^^",t+3)+r,"font-weight:bold"),i(s("| ",6)),i(a+r,"font-weight:bold")})),i(s("| ",6)+r)}else i(s(e.number,4)+"|  "),i(e.line+r,"color:red")})),"undefined"==typeof document||window.chrome?console.log(n.join("")):(a[0]=n.join("%c"),console.log.apply(console,a))}function i(e,t){n.push(e),a.push(t||"")}})),a.raise("Error compiling "+u+" shader, "+c[0].name)}},linkError:function(e,t,n,i,o){if(!e.getProgramParameter(t,e.LINK_STATUS)){var f=e.getProgramInfoLog(t),u=h(n,o),s='Error linking program with vertex shader, "'+h(i,o)[0].name+'", and fragment shader "'+u[0].name+'"';"undefined"!=typeof document?console.log("%c"+s+"\n%c"+f,"color:red;text-decoration:underline;font-weight:bold","color:red"):console.log(s+r+f),a.raise(s)}},callSite:p,saveCommandRef:b,saveDrawInfo:function(e,t,r,n){function a(e){return e?n.id(e):0}function i(e,t){Object.keys(t).forEach((function(t){e[n.id(t)]=!0}))}b(e),e._fragId=a(e.static.frag),e._vertId=a(e.static.vert);var o=e._uniformSet={};i(o,t.static),i(o,t.dynamic);var f=e._attributeSet={};i(f,r.static),i(f,r.dynamic),e._hasCount="count"in e.static||"count"in e.dynamic||"elements"in e.static||"elements"in e.dynamic},framebufferFormat:function(e,t,r){e.texture?f(e.texture._texture.internalformat,t,"unsupported texture format for attachment"):f(e.renderbuffer._renderbuffer.format,r,"unsupported renderbuffer format for attachment")},guessCommand:m,texture2D:function(e,t,r){var n,i=t.width,o=t.height,f=t.channels;a(i>0&&i<=r.maxTextureSize&&o>0&&o<=r.maxTextureSize,"invalid texture shape"),e.wrapS===y&&e.wrapT===y||a(A(i)&&A(o),"incompatible wrap mode for texture, both width and height must be power of 2"),1===t.mipmask?1!==i&&1!==o&&a(9984!==e.minFilter&&9986!==e.minFilter&&9985!==e.minFilter&&9987!==e.minFilter,"min filter requires mipmap"):(a(A(i)&&A(o),"texture must be a square power of 2 to support mipmapping"),a(t.mipmask===(i<<1)-1,"missing or incomplete mipmap data")),5126===t.type&&(r.extensions.indexOf("oes_texture_float_linear")<0&&a(9728===e.minFilter&&9728===e.magFilter,"filter not supported, must enable oes_texture_float_linear"),a(!e.genMipmaps,"mipmap generation not supported with float textures"));var u=t.images;for(n=0;n<16;++n)if(u[n]){var s=i>>n,c=o>>n;a(t.mipmask&1<<n,"missing mipmap data");var l=u[n];if(a(l.width===s&&l.height===c,"invalid shape for mip images"),a(l.format===t.format&&l.internalformat===t.internalformat&&l.type===t.type,"incompatible type for mip image"),l.compressed);else if(l.data){var d=Math.ceil(w(l.type,f)*s/l.unpackAlignment)*l.unpackAlignment;a(l.data.byteLength===d*c,"invalid data for image, buffer size is inconsistent with image format")}else l.element||l.copy}else e.genMipmaps||a(0==(t.mipmask&1<<n),"extra mipmap data");t.compressed&&a(!e.genMipmaps,"mipmap generation for compressed images not supported")},textureCube:function(e,t,r,n){var i=e.width,o=e.height,f=e.channels;a(i>0&&i<=n.maxTextureSize&&o>0&&o<=n.maxTextureSize,"invalid texture shape"),a(i===o,"cube map must be square"),a(t.wrapS===y&&t.wrapT===y,"wrap mode not supported by cube map");for(var u=0;u<r.length;++u){var s=r[u];a(s.width===i&&s.height===o,"inconsistent cube map face shape"),t.genMipmaps&&(a(!s.compressed,"can not generate mipmap for compressed textures"),a(1===s.mipmask,"can not specify mipmaps and generate mipmaps"));for(var c=s.images,l=0;l<16;++l){var d=c[l];if(d){var m=i>>l,p=o>>l;a(s.mipmask&1<<l,"missing mipmap data"),a(d.width===m&&d.height===p,"invalid shape for mip images"),a(d.format===e.format&&d.internalformat===e.internalformat&&d.type===e.type,"incompatible type for mip image"),d.compressed||(d.data?a(d.data.byteLength===m*p*Math.max(w(d.type,f),d.unpackAlignment),"invalid data for image, buffer size is inconsistent with image format"):d.element||d.copy)}}}}}),k=0;function S(e,t){this.id=k++,this.type=e,this.data=t}function O(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"')}function E(e){if(0===e.length)return[];var t=e.charAt(0),r=e.charAt(e.length-1);if(e.length>1&&t===r&&('"'===t||"'"===t))return['"'+O(e.substr(1,e.length-2))+'"'];var n=/\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(e);if(n)return E(e.substr(0,n.index)).concat(E(n[1])).concat(E(e.substr(n.index+n[0].length)));var a=e.split(".");if(1===a.length)return['"'+O(e)+'"'];for(var i=[],o=0;o<a.length;++o)i=i.concat(E(a[o]));return i}function T(e){return"["+E(e).join("][")+"]"}var D={DynamicVariable:S,define:function(e,t){return new S(e,T(t+""))},isDynamic:function(e){return"function"==typeof e&&!e._reglType||e instanceof S},unbox:function e(t,r){return"function"==typeof t?new S(0,t):"number"==typeof t||"boolean"==typeof t?new S(5,t):Array.isArray(t)?new S(6,t.map((function(t,n){return e(t,r+"["+n+"]")}))):t instanceof S?t:void _(!1,"invalid option type in uniform "+r)},accessor:T},j={next:"function"==typeof requestAnimationFrame?function(e){return requestAnimationFrame(e)}:function(e){return setTimeout(e,16)},cancel:"function"==typeof cancelAnimationFrame?function(e){return cancelAnimationFrame(e)}:clearTimeout},C="undefined"!=typeof performance&&performance.now?function(){return performance.now()}:function(){return+new Date};function z(e){return"string"==typeof e?e.split():(_(Array.isArray(e),"invalid extension array"),e)}function F(e){return"string"==typeof e?(_("undefined"!=typeof document,"not supported outside of DOM"),document.querySelector(e)):e}function B(e){var r,n,a,i,o,f=e||{},u={},s=[],c=[],l="undefined"==typeof window?1:window.devicePixelRatio,d=!1,m=function(e){e&&_.raise(e)},p=function(){};if("string"==typeof f?(_("undefined"!=typeof document,"selector queries only supported in DOM enviroments"),r=document.querySelector(f),_(r,"invalid query string for element")):"object"==typeof f?"string"==typeof(o=f).nodeName&&"function"==typeof o.appendChild&&"function"==typeof o.getBoundingClientRect?r=f:function(e){return"function"==typeof e.drawArrays||"function"==typeof e.drawElements}(f)?a=(i=f).canvas:(_.constructor(f),"gl"in f?i=f.gl:"canvas"in f?a=F(f.canvas):"container"in f&&(n=F(f.container)),"attributes"in f&&(u=f.attributes,_.type(u,"object","invalid context attributes")),"extensions"in f&&(s=z(f.extensions)),"optionalExtensions"in f&&(c=z(f.optionalExtensions)),"onDone"in f&&(_.type(f.onDone,"function","invalid or missing onDone callback"),m=f.onDone),"profile"in f&&(d=!!f.profile),"pixelRatio"in f&&(l=+f.pixelRatio,_(l>0,"invalid pixel ratio"))):_.raise("invalid arguments to regl"),r&&("canvas"===r.nodeName.toLowerCase()?a=r:n=r),!i){if(!a){_("undefined"!=typeof document,"must manually specify webgl context outside of DOM environments");var h=function(e,r,n){var a,i=document.createElement("canvas");function o(){var t=window.innerWidth,r=window.innerHeight;if(e!==document.body){var a=i.getBoundingClientRect();t=a.right-a.left,r=a.bottom-a.top}i.width=n*t,i.height=n*r}return t(i.style,{border:0,margin:0,padding:0,top:0,left:0,width:"100%",height:"100%"}),e.appendChild(i),e===document.body&&(i.style.position="absolute",t(e.style,{margin:0,padding:0})),e!==document.body&&"function"==typeof ResizeObserver?(a=new ResizeObserver((function(){setTimeout(o)}))).observe(e):window.addEventListener("resize",o,!1),o(),{canvas:i,onDestroy:function(){a?a.disconnect():window.removeEventListener("resize",o),e.removeChild(i)}}}(n||document.body,0,l);if(!h)return null;a=h.canvas,p=h.onDestroy}void 0===u.premultipliedAlpha&&(u.premultipliedAlpha=!0),i=function(e,t){function r(r){try{return e.getContext(r,t)}catch(e){return null}}return r("webgl")||r("experimental-webgl")||r("webgl-experimental")}(a,u)}return i?{gl:i,canvas:a,container:n,extensions:s,optionalExtensions:c,pixelRatio:l,profile:d,onDone:m,onDestroy:p}:(p(),m("webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org"),null)}function V(e,t){for(var r=Array(e),n=0;n<e;++n)r[n]=t(n);return r}function I(e){var t,r;return t=(e>65535)<<4,t|=r=((e>>>=t)>255)<<3,t|=r=((e>>>=r)>15)<<2,(t|=r=((e>>>=r)>3)<<1)|(e>>>=r)>>1}function P(){var e=V(8,(function(){return[]}));function t(t){var r=function(e){for(var t=16;t<=1<<28;t*=16)if(e<=t)return t;return 0}(t),n=e[I(r)>>2];return n.length>0?n.pop():new ArrayBuffer(r)}function r(t){e[I(t.byteLength)>>2].push(t)}return{alloc:t,free:r,allocType:function(e,r){var n=null;switch(e){case 5120:n=new Int8Array(t(r),0,r);break;case 5121:n=new Uint8Array(t(r),0,r);break;case 5122:n=new Int16Array(t(2*r),0,r);break;case 5123:n=new Uint16Array(t(2*r),0,r);break;case 5124:n=new Int32Array(t(4*r),0,r);break;case 5125:n=new Uint32Array(t(4*r),0,r);break;case 5126:n=new Float32Array(t(4*r),0,r);break;default:return null}return n.length!==r?n.subarray(0,r):n},freeType:function(e){r(e.buffer)}}}var L=P();L.zero=P();var R=3553,M=6408,W=5126,U=36160;function G(t){return!!t&&"object"==typeof t&&Array.isArray(t.shape)&&Array.isArray(t.stride)&&"number"==typeof t.offset&&t.shape.length===t.stride.length&&(Array.isArray(t.data)||e(t.data))}var H=function(e){return Object.keys(e).map((function(t){return e[t]}))},N={shape:function(e){for(var t=[],r=e;r.length;r=r[0])t.push(r.length);return t},flatten:function(e,t,r,n){var a=1;if(t.length)for(var i=0;i<t.length;++i)a*=t[i];else a=0;var o=n||L.allocType(r,a);switch(t.length){case 0:break;case 1:!function(e,t,r){for(var n=0;n<t;++n)r[n]=e[n]}(e,t[0],o);break;case 2:!function(e,t,r,n){for(var a=0,i=0;i<t;++i)for(var o=e[i],f=0;f<r;++f)n[a++]=o[f]}(e,t[0],t[1],o);break;case 3:q(e,t[0],t[1],t[2],o,0);break;default:Q(e,t,0,o,0)}return o}};function q(e,t,r,n,a,i){for(var o=i,f=0;f<t;++f)for(var u=e[f],s=0;s<r;++s)for(var c=u[s],l=0;l<n;++l)a[o++]=c[l]}function Q(e,t,r,n,a){for(var i=1,o=r+1;o<t.length;++o)i*=t[o];var f=t[r];if(t.length-r==4){var u=t[r+1],s=t[r+2],c=t[r+3];for(o=0;o<f;++o)q(e[o],u,s,c,n,a),a+=i}else for(o=0;o<f;++o)Q(e[o],t,r+1,n,a),a+=i}var Y={"[object Int8Array]":5120,"[object Int16Array]":5122,"[object Int32Array]":5124,"[object Uint8Array]":5121,"[object Uint8ClampedArray]":5121,"[object Uint16Array]":5123,"[object Uint32Array]":5125,"[object Float32Array]":5126,"[object Float64Array]":5121,"[object ArrayBuffer]":5121},X={int8:5120,int16:5122,int32:5124,uint8:5121,uint16:5123,uint32:5125,float:5126,float32:5126},$={dynamic:35048,stream:35040,static:35044},K=N.flatten,J=N.shape,Z=5121,ee=5126,te=[];function re(e){return 0|Y[Object.prototype.toString.call(e)]}function ne(e,t){for(var r=0;r<t.length;++r)e[r]=t[r]}function ae(e,t,r,n,a,i,o){for(var f=0,u=0;u<r;++u)for(var s=0;s<n;++s)e[f++]=t[a*u+i*s+o]}te[5120]=1,te[5122]=2,te[5124]=4,te[5121]=1,te[5123]=2,te[5125]=4,te[5126]=4;var ie={points:0,point:0,lines:1,line:1,triangles:4,triangle:4,"line loop":2,"line strip":3,"triangle strip":5,"triangle fan":6},oe=5121,fe=5123,ue=5125,se=34963,ce=new Float32Array(1),le=new Uint32Array(ce.buffer);function de(e){for(var t=L.allocType(5123,e.length),r=0;r<e.length;++r)if(isNaN(e[r]))t[r]=65535;else if(e[r]===1/0)t[r]=31744;else if(e[r]===-1/0)t[r]=64512;else{ce[0]=e[r];var n=le[0],a=n>>>31<<15,i=(n<<1>>>24)-127,o=n>>13&1023;if(i<-24)t[r]=a;else if(i<-14){var f=-14-i;t[r]=a+(o+1024>>f)}else t[r]=i>15?a+31744:a+(i+15<<10)+o}return t}function me(t){return Array.isArray(t)||e(t)}var pe=function(e){return!(e&e-1||!e)},he=3553,be=34067,ve=34069,ge=6408,ye=6406,xe=6407,we=6409,Ae=6410,_e=32855,ke=6402,Se=34041,Oe=35904,Ee=35906,Te=36193,De=33776,je=33777,Ce=33778,ze=33779,Fe=5121,Be=5123,Ve=5125,Ie=5126,Pe=33071,Le=9728,Re=9984,Me=9987,We=4352,Ue=33984,Ge=[Re,9986,9985,Me],He=[0,we,Ae,xe,ge],Ne={};function qe(e){return"[object "+e+"]"}Ne[6409]=Ne[6406]=Ne[6402]=1,Ne[34041]=Ne[6410]=2,Ne[6407]=Ne[35904]=3,Ne[6408]=Ne[35906]=4;var Qe=qe("HTMLCanvasElement"),Ye=qe("OffscreenCanvas"),Xe=qe("CanvasRenderingContext2D"),$e=qe("ImageBitmap"),Ke=qe("HTMLImageElement"),Je=qe("HTMLVideoElement"),Ze=Object.keys(Y).concat([Qe,Ye,Xe,$e,Ke,Je]),et=[];et[5121]=1,et[5126]=4,et[36193]=2,et[5123]=2,et[5125]=4;var tt=[];function rt(e){return Array.isArray(e)&&(0===e.length||"number"==typeof e[0])}function nt(e){return!!Array.isArray(e)&&!(0===e.length||!me(e[0]))}function at(e){return Object.prototype.toString.call(e)}function it(e){return at(e)===Qe}function ot(e){return at(e)===Ye}function ft(e){if(!e)return!1;var t=at(e);return Ze.indexOf(t)>=0||rt(e)||nt(e)||G(e)}function ut(e){return 0|Y[Object.prototype.toString.call(e)]}function st(e,t){return L.allocType(e.type===Te?Ie:e.type,t)}function ct(e,t){e.type===Te?(e.data=de(t),L.freeType(t)):e.data=t}function lt(e,t,r,n,a,i){var o;if(o=void 0!==tt[e]?tt[e]:Ne[e]*et[t],i&&(o*=6),a){for(var f=0,u=r;u>=1;)f+=o*u*u,u/=2;return f}return o*r*n}function dt(r,n,a,i,o,f,u){var s={"don't care":We,"dont care":We,nice:4354,fast:4353},c={repeat:10497,clamp:Pe,mirror:33648},l={nearest:Le,linear:9729},d=t({mipmap:Me,"nearest mipmap nearest":Re,"linear mipmap nearest":9985,"nearest mipmap linear":9986,"linear mipmap linear":Me},l),m={none:0,browser:37444},p={uint8:Fe,rgba4:32819,rgb565:33635,"rgb5 a1":32820},h={alpha:ye,luminance:we,"luminance alpha":Ae,rgb:xe,rgba:ge,rgba4:32854,"rgb5 a1":_e,rgb565:36194},b={};n.ext_srgb&&(h.srgb=Oe,h.srgba=Ee),n.oes_texture_float&&(p.float32=p.float=Ie),n.oes_texture_half_float&&(p.float16=p["half float"]=Te),n.webgl_depth_texture&&(t(h,{depth:ke,"depth stencil":Se}),t(p,{uint16:Be,uint32:Ve,"depth stencil":34042})),n.webgl_compressed_texture_s3tc&&t(b,{"rgb s3tc dxt1":De,"rgba s3tc dxt1":je,"rgba s3tc dxt3":Ce,"rgba s3tc dxt5":ze}),n.webgl_compressed_texture_atc&&t(b,{"rgb atc":35986,"rgba atc explicit alpha":35987,"rgba atc interpolated alpha":34798}),n.webgl_compressed_texture_pvrtc&&t(b,{"rgb pvrtc 4bppv1":35840,"rgb pvrtc 2bppv1":35841,"rgba pvrtc 4bppv1":35842,"rgba pvrtc 2bppv1":35843}),n.webgl_compressed_texture_etc1&&(b["rgb etc1"]=36196);var v=Array.prototype.slice.call(r.getParameter(34467));Object.keys(b).forEach((function(e){var t=b[e];v.indexOf(t)>=0&&(h[e]=t)}));var g=Object.keys(h);a.textureFormats=g;var y=[];Object.keys(h).forEach((function(e){var t=h[e];y[t]=e}));var x=[];Object.keys(p).forEach((function(e){var t=p[e];x[t]=e}));var w=[];Object.keys(l).forEach((function(e){w[l[e]]=e}));var A=[];Object.keys(d).forEach((function(e){var t=d[e];A[t]=e}));var k=[];Object.keys(c).forEach((function(e){k[c[e]]=e}));var S=g.reduce((function(e,t){var r=h[t];return r===we||r===ye||r===we||r===Ae||r===ke||r===Se||n.ext_srgb&&(r===Oe||r===Ee)?e[r]=r:r===_e||t.indexOf("rgba")>=0?e[r]=ge:e[r]=xe,e}),{});function O(){this.internalformat=ge,this.format=ge,this.type=Fe,this.compressed=!1,this.premultiplyAlpha=!1,this.flipY=!1,this.unpackAlignment=1,this.colorSpace=37444,this.width=0,this.height=0,this.channels=0}function E(e,t){e.internalformat=t.internalformat,e.format=t.format,e.type=t.type,e.compressed=t.compressed,e.premultiplyAlpha=t.premultiplyAlpha,e.flipY=t.flipY,e.unpackAlignment=t.unpackAlignment,e.colorSpace=t.colorSpace,e.width=t.width,e.height=t.height,e.channels=t.channels}function T(e,t){if("object"==typeof t&&t){if("premultiplyAlpha"in t&&(_.type(t.premultiplyAlpha,"boolean","invalid premultiplyAlpha"),e.premultiplyAlpha=t.premultiplyAlpha),"flipY"in t&&(_.type(t.flipY,"boolean","invalid texture flip"),e.flipY=t.flipY),"alignment"in t&&(_.oneOf(t.alignment,[1,2,4,8],"invalid texture unpack alignment"),e.unpackAlignment=t.alignment),"colorSpace"in t&&(_.parameter(t.colorSpace,m,"invalid colorSpace"),e.colorSpace=m[t.colorSpace]),"type"in t){var r=t.type;_(n.oes_texture_float||!("float"===r||"float32"===r),"you must enable the OES_texture_float extension in order to use floating point textures."),_(n.oes_texture_half_float||!("half float"===r||"float16"===r),"you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures."),_(n.webgl_depth_texture||!("uint16"===r||"uint32"===r||"depth stencil"===r),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(r,p,"invalid texture type"),e.type=p[r]}var i=e.width,o=e.height,f=e.channels,u=!1;"shape"in t?(_(Array.isArray(t.shape)&&t.shape.length>=2,"shape must be an array"),i=t.shape[0],o=t.shape[1],3===t.shape.length&&(f=t.shape[2],_(f>0&&f<=4,"invalid number of channels"),u=!0),_(i>=0&&i<=a.maxTextureSize,"invalid width"),_(o>=0&&o<=a.maxTextureSize,"invalid height")):("radius"in t&&(i=o=t.radius,_(i>=0&&i<=a.maxTextureSize,"invalid radius")),"width"in t&&(i=t.width,_(i>=0&&i<=a.maxTextureSize,"invalid width")),"height"in t&&(o=t.height,_(o>=0&&o<=a.maxTextureSize,"invalid height")),"channels"in t&&(f=t.channels,_(f>0&&f<=4,"invalid number of channels"),u=!0)),e.width=0|i,e.height=0|o,e.channels=0|f;var s=!1;if("format"in t){var c=t.format;_(n.webgl_depth_texture||!("depth"===c||"depth stencil"===c),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(c,h,"invalid texture format");var l=e.internalformat=h[c];e.format=S[l],c in p&&("type"in t||(e.type=p[c])),c in b&&(e.compressed=!0),s=!0}!u&&s?e.channels=Ne[e.format]:u&&!s?e.channels!==He[e.format]&&(e.format=e.internalformat=He[e.channels]):s&&u&&_(e.channels===Ne[e.format],"number of channels inconsistent with specified format")}}function D(e){r.pixelStorei(37440,e.flipY),r.pixelStorei(37441,e.premultiplyAlpha),r.pixelStorei(37443,e.colorSpace),r.pixelStorei(3317,e.unpackAlignment)}function j(){O.call(this),this.xOffset=0,this.yOffset=0,this.data=null,this.needsFree=!1,this.element=null,this.needsCopy=!1}function C(t,r){var n=null;if(ft(r)?n=r:r&&(_.type(r,"object","invalid pixel data type"),T(t,r),"x"in r&&(t.xOffset=0|r.x),"y"in r&&(t.yOffset=0|r.y),ft(r.data)&&(n=r.data)),_(!t.compressed||n instanceof Uint8Array,"compressed texture data must be stored in a uint8array"),r.copy){_(!n,"can not specify copy and data field for the same texture");var i=o.viewportWidth,f=o.viewportHeight;t.width=t.width||i-t.xOffset,t.height=t.height||f-t.yOffset,t.needsCopy=!0,_(t.xOffset>=0&&t.xOffset<i&&t.yOffset>=0&&t.yOffset<f&&t.width>0&&t.width<=i&&t.height>0&&t.height<=f,"copy texture read out of bounds")}else if(n){if(e(n))t.channels=t.channels||4,t.data=n,"type"in r||t.type!==Fe||(t.type=ut(n));else if(rt(n))t.channels=t.channels||4,function(e,t){var r=t.length;switch(e.type){case Fe:case Be:case Ve:case Ie:var n=L.allocType(e.type,r);n.set(t),e.data=n;break;case Te:e.data=de(t);break;default:_.raise("unsupported texture type, must specify a typed array")}}(t,n),t.alignment=1,t.needsFree=!0;else if(G(n)){var u=n.data;Array.isArray(u)||t.type!==Fe||(t.type=ut(u));var s,c,l,d,m,p,h=n.shape,b=n.stride;3===h.length?(l=h[2],p=b[2]):(_(2===h.length,"invalid ndarray pixel data, must be 2 or 3D"),l=1,p=1),s=h[0],c=h[1],d=b[0],m=b[1],t.alignment=1,t.width=s,t.height=c,t.channels=l,t.format=t.internalformat=He[l],t.needsFree=!0,function(e,t,r,n,a,i){for(var o=e.width,f=e.height,u=e.channels,s=st(e,o*f*u),c=0,l=0;l<f;++l)for(var d=0;d<o;++d)for(var m=0;m<u;++m)s[c++]=t[r*d+n*l+a*m+i];ct(e,s)}(t,u,d,m,p,n.offset)}else if(it(n)||ot(n)||at(n)===Xe)it(n)||ot(n)?t.element=n:t.element=n.canvas,t.width=t.element.width,t.height=t.element.height,t.channels=4;else if(function(e){return at(e)===$e}(n))t.element=n,t.width=n.width,t.height=n.height,t.channels=4;else if(function(e){return at(e)===Ke}(n))t.element=n,t.width=n.naturalWidth,t.height=n.naturalHeight,t.channels=4;else if(function(e){return at(e)===Je}(n))t.element=n,t.width=n.videoWidth,t.height=n.videoHeight,t.channels=4;else if(nt(n)){var v=t.width||n[0].length,g=t.height||n.length,y=t.channels;y=me(n[0][0])?y||n[0][0].length:y||1;for(var x=N.shape(n),w=1,A=0;A<x.length;++A)w*=x[A];var k=st(t,w);N.flatten(n,x,"",k),ct(t,k),t.alignment=1,t.width=v,t.height=g,t.channels=y,t.format=t.internalformat=He[y],t.needsFree=!0}}else t.width=t.width||1,t.height=t.height||1,t.channels=t.channels||4;t.type===Ie?_(a.extensions.indexOf("oes_texture_float")>=0,"oes_texture_float extension not enabled"):t.type===Te&&_(a.extensions.indexOf("oes_texture_half_float")>=0,"oes_texture_half_float extension not enabled")}function z(e,t,n){var a=e.element,o=e.data,f=e.internalformat,u=e.format,s=e.type,c=e.width,l=e.height;D(e),a?r.texImage2D(t,n,u,u,s,a):e.compressed?r.compressedTexImage2D(t,n,f,c,l,0,o):e.needsCopy?(i(),r.copyTexImage2D(t,n,u,e.xOffset,e.yOffset,c,l,0)):r.texImage2D(t,n,u,c,l,0,u,s,o||null)}function F(e,t,n,a,o){var f=e.element,u=e.data,s=e.internalformat,c=e.format,l=e.type,d=e.width,m=e.height;D(e),f?r.texSubImage2D(t,o,n,a,c,l,f):e.compressed?r.compressedTexSubImage2D(t,o,n,a,s,d,m,u):e.needsCopy?(i(),r.copyTexSubImage2D(t,o,n,a,e.xOffset,e.yOffset,d,m)):r.texSubImage2D(t,o,n,a,d,m,c,l,u)}var B=[];function V(){return B.pop()||new j}function I(e){e.needsFree&&L.freeType(e.data),j.call(e),B.push(e)}function P(){O.call(this),this.genMipmaps=!1,this.mipmapHint=We,this.mipmask=0,this.images=Array(16)}function R(e,t,r){var n=e.images[0]=V();e.mipmask=1,n.width=e.width=t,n.height=e.height=r,n.channels=e.channels=4}function M(e,t){var r=null;if(ft(t))E(r=e.images[0]=V(),e),C(r,t),e.mipmask=1;else if(T(e,t),Array.isArray(t.mipmap))for(var n=t.mipmap,a=0;a<n.length;++a)E(r=e.images[a]=V(),e),r.width>>=a,r.height>>=a,C(r,n[a]),e.mipmask|=1<<a;else E(r=e.images[0]=V(),e),C(r,t),e.mipmask=1;E(e,e.images[0]),!e.compressed||e.internalformat!==De&&e.internalformat!==je&&e.internalformat!==Ce&&e.internalformat!==ze||_(e.width%4==0&&e.height%4==0,"for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4")}function W(e,t){for(var r=e.images,n=0;n<r.length;++n){if(!r[n])return;z(r[n],t,n)}}var U=[];function q(){var e=U.pop()||new P;O.call(e),e.mipmask=0;for(var t=0;t<16;++t)e.images[t]=null;return e}function Q(e){for(var t=e.images,r=0;r<t.length;++r)t[r]&&I(t[r]),t[r]=null;U.push(e)}function Y(){this.minFilter=Le,this.magFilter=Le,this.wrapS=Pe,this.wrapT=Pe,this.anisotropic=1,this.genMipmaps=!1,this.mipmapHint=We}function X(e,t){if("min"in t){var r=t.min;_.parameter(r,d),e.minFilter=d[r],Ge.indexOf(e.minFilter)>=0&&!("faces"in t)&&(e.genMipmaps=!0)}if("mag"in t){var n=t.mag;_.parameter(n,l),e.magFilter=l[n]}var i=e.wrapS,o=e.wrapT;if("wrap"in t){var f=t.wrap;"string"==typeof f?(_.parameter(f,c),i=o=c[f]):Array.isArray(f)&&(_.parameter(f[0],c),_.parameter(f[1],c),i=c[f[0]],o=c[f[1]])}else{if("wrapS"in t){var u=t.wrapS;_.parameter(u,c),i=c[u]}if("wrapT"in t){var m=t.wrapT;_.parameter(m,c),o=c[m]}}if(e.wrapS=i,e.wrapT=o,"anisotropic"in t){var p=t.anisotropic;_("number"==typeof p&&p>=1&&p<=a.maxAnisotropic,"aniso samples must be between 1 and "),e.anisotropic=t.anisotropic}if("mipmap"in t){var h=!1;switch(typeof t.mipmap){case"string":_.parameter(t.mipmap,s,"invalid mipmap hint"),e.mipmapHint=s[t.mipmap],e.genMipmaps=!0,h=!0;break;case"boolean":h=e.genMipmaps=t.mipmap;break;case"object":_(Array.isArray(t.mipmap),"invalid mipmap type"),e.genMipmaps=!1,h=!0;break;default:_.raise("invalid mipmap type")}h&&!("min"in t)&&(e.minFilter=Re)}}function $(e,t){r.texParameteri(t,10241,e.minFilter),r.texParameteri(t,10240,e.magFilter),r.texParameteri(t,10242,e.wrapS),r.texParameteri(t,10243,e.wrapT),n.ext_texture_filter_anisotropic&&r.texParameteri(t,34046,e.anisotropic),e.genMipmaps&&(r.hint(33170,e.mipmapHint),r.generateMipmap(t))}var K=0,J={},Z=a.maxTextureUnits,ee=Array(Z).map((function(){return null}));function te(e){O.call(this),this.mipmask=0,this.internalformat=ge,this.id=K++,this.refCount=1,this.target=e,this.texture=r.createTexture(),this.unit=-1,this.bindCount=0,this.texInfo=new Y,u.profile&&(this.stats={size:0})}function re(e){r.activeTexture(Ue),r.bindTexture(e.target,e.texture)}function ne(){var e=ee[0];e?r.bindTexture(e.target,e.texture):r.bindTexture(he,null)}function ae(e){var t=e.texture;_(t,"must not double destroy texture");var n=e.unit,a=e.target;n>=0&&(r.activeTexture(Ue+n),r.bindTexture(a,null),ee[n]=null),r.deleteTexture(t),e.texture=null,e.params=null,e.pixels=null,e.refCount=0,delete J[e.id],f.textureCount--}return t(te.prototype,{bind:function(){var e=this;e.bindCount+=1;var t=e.unit;if(t<0){for(var n=0;n<Z;++n){var a=ee[n];if(a){if(a.bindCount>0)continue;a.unit=-1}ee[n]=e,t=n;break}t>=Z&&_.raise("insufficient number of texture units"),u.profile&&f.maxTextureUnits<t+1&&(f.maxTextureUnits=t+1),e.unit=t,r.activeTexture(Ue+t),r.bindTexture(e.target,e.texture)}return t},unbind:function(){this.bindCount-=1},decRef:function(){--this.refCount<=0&&ae(this)}}),u.profile&&(f.getTotalTextureSize=function(){var e=0;return Object.keys(J).forEach((function(t){e+=J[t].stats.size})),e}),{create2D:function(e,t){var n=new te(he);function i(e,t){var r=n.texInfo;Y.call(r);var o=q();return"number"==typeof e?R(o,0|e,"number"==typeof t?0|t:0|e):e?(_.type(e,"object","invalid arguments to regl.texture"),X(r,e),M(o,e)):R(o,1,1),r.genMipmaps&&(o.mipmask=(o.width<<1)-1),n.mipmask=o.mipmask,E(n,o),_.texture2D(r,o,a),n.internalformat=o.internalformat,i.width=o.width,i.height=o.height,re(n),W(o,he),$(r,he),ne(),Q(o),u.profile&&(n.stats.size=lt(n.internalformat,n.type,o.width,o.height,r.genMipmaps,!1)),i.format=y[n.internalformat],i.type=x[n.type],i.mag=w[r.magFilter],i.min=A[r.minFilter],i.wrapS=k[r.wrapS],i.wrapT=k[r.wrapT],i}return J[n.id]=n,f.textureCount++,i(e,t),i.subimage=function(e,t,r,a){_(!!e,"must specify image data");var o=0|t,f=0|r,u=0|a,s=V();return E(s,n),s.width=0,s.height=0,C(s,e),s.width=s.width||(n.width>>u)-o,s.height=s.height||(n.height>>u)-f,_(n.type===s.type&&n.format===s.format&&n.internalformat===s.internalformat,"incompatible format for texture.subimage"),_(o>=0&&f>=0&&o+s.width<=n.width&&f+s.height<=n.height,"texture.subimage write out of bounds"),_(n.mipmask&1<<u,"missing mipmap data"),_(s.data||s.element||s.needsCopy,"missing image data"),re(n),F(s,he,o,f,u),ne(),I(s),i},i.resize=function(e,t){var a=0|e,o=0|t||a;if(a===n.width&&o===n.height)return i;i.width=n.width=a,i.height=n.height=o,re(n);for(var f=0;n.mipmask>>f;++f){var s=a>>f,c=o>>f;if(!s||!c)break;r.texImage2D(he,f,n.format,s,c,0,n.format,n.type,null)}return ne(),u.profile&&(n.stats.size=lt(n.internalformat,n.type,a,o,!1,!1)),i},i._reglType="texture2d",i._texture=n,u.profile&&(i.stats=n.stats),i.destroy=function(){n.decRef()},i},createCube:function(e,t,n,i,o,s){var c=new te(be);J[c.id]=c,f.cubeCount++;var l=new Array(6);function d(e,t,r,n,i,o){var f,s=c.texInfo;for(Y.call(s),f=0;f<6;++f)l[f]=q();if("number"!=typeof e&&e)if("object"==typeof e)if(t)M(l[0],e),M(l[1],t),M(l[2],r),M(l[3],n),M(l[4],i),M(l[5],o);else if(X(s,e),T(c,e),"faces"in e){var m=e.faces;for(_(Array.isArray(m)&&6===m.length,"cube faces must be a length 6 array"),f=0;f<6;++f)_("object"==typeof m[f]&&!!m[f],"invalid input for cube map face"),E(l[f],c),M(l[f],m[f])}else for(f=0;f<6;++f)M(l[f],e);else _.raise("invalid arguments to cube map");else{var p=0|e||1;for(f=0;f<6;++f)R(l[f],p,p)}for(E(c,l[0]),_.optional((function(){a.npotTextureCube||_(pe(c.width)&&pe(c.height),"your browser does not support non power or two texture dimensions")})),s.genMipmaps?c.mipmask=(l[0].width<<1)-1:c.mipmask=l[0].mipmask,_.textureCube(c,s,l,a),c.internalformat=l[0].internalformat,d.width=l[0].width,d.height=l[0].height,re(c),f=0;f<6;++f)W(l[f],ve+f);for($(s,be),ne(),u.profile&&(c.stats.size=lt(c.internalformat,c.type,d.width,d.height,s.genMipmaps,!0)),d.format=y[c.internalformat],d.type=x[c.type],d.mag=w[s.magFilter],d.min=A[s.minFilter],d.wrapS=k[s.wrapS],d.wrapT=k[s.wrapT],f=0;f<6;++f)Q(l[f]);return d}return d(e,t,n,i,o,s),d.subimage=function(e,t,r,n,a){_(!!t,"must specify image data"),_("number"==typeof e&&e===(0|e)&&e>=0&&e<6,"invalid face");var i=0|r,o=0|n,f=0|a,u=V();return E(u,c),u.width=0,u.height=0,C(u,t),u.width=u.width||(c.width>>f)-i,u.height=u.height||(c.height>>f)-o,_(c.type===u.type&&c.format===u.format&&c.internalformat===u.internalformat,"incompatible format for texture.subimage"),_(i>=0&&o>=0&&i+u.width<=c.width&&o+u.height<=c.height,"texture.subimage write out of bounds"),_(c.mipmask&1<<f,"missing mipmap data"),_(u.data||u.element||u.needsCopy,"missing image data"),re(c),F(u,ve+e,i,o,f),ne(),I(u),d},d.resize=function(e){var t=0|e;if(t!==c.width){d.width=c.width=t,d.height=c.height=t,re(c);for(var n=0;n<6;++n)for(var a=0;c.mipmask>>a;++a)r.texImage2D(ve+n,a,c.format,t>>a,t>>a,0,c.format,c.type,null);return ne(),u.profile&&(c.stats.size=lt(c.internalformat,c.type,d.width,d.height,!1,!0)),d}},d._reglType="textureCube",d._texture=c,u.profile&&(d.stats=c.stats),d.destroy=function(){c.decRef()},d},clear:function(){for(var e=0;e<Z;++e)r.activeTexture(Ue+e),r.bindTexture(he,null),ee[e]=null;H(J).forEach(ae),f.cubeCount=0,f.textureCount=0},getTexture:function(e){return null},restore:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null)}H(J).forEach((function(e){e.texture=r.createTexture(),r.bindTexture(e.target,e.texture);for(var t=0;t<32;++t)if(0!=(e.mipmask&1<<t))if(e.target===he)r.texImage2D(he,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);else for(var n=0;n<6;++n)r.texImage2D(ve+n,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);$(e.texInfo,e.target)}))},refresh:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null),r.activeTexture(Ue+e),r.bindTexture(he,null),r.bindTexture(be,null)}}}}tt[32854]=2,tt[32855]=2,tt[36194]=2,tt[34041]=4,tt[33776]=.5,tt[33777]=.5,tt[33778]=1,tt[33779]=1,tt[35986]=.5,tt[35987]=1,tt[34798]=1,tt[35840]=.5,tt[35841]=.25,tt[35842]=.5,tt[35843]=.25,tt[36196]=.5;var mt=36161,pt=32854,ht=[];function bt(e,t,r){return ht[e]*t*r}ht[32854]=2,ht[32855]=2,ht[36194]=2,ht[33189]=2,ht[36168]=1,ht[34041]=4,ht[35907]=4,ht[34836]=16,ht[34842]=8,ht[34843]=6;var vt=36160,gt=36161,yt=3553,xt=34069,wt=[6407,6408],At=[];At[6408]=4,At[6407]=3;var _t=[];_t[5121]=1,_t[5126]=4,_t[36193]=2;var kt=[32854,32855,36194,35907,34842,34843,34836],St={36053:"complete",36054:"incomplete attachment",36057:"incomplete dimensions",36055:"incomplete, missing attachment",36061:"unsupported"},Ot=34963,Et=["attributes","elements","offset","count","primitive","instances"];function Tt(){this.state=0,this.x=0,this.y=0,this.z=0,this.w=0,this.buffer=null,this.size=0,this.normalized=!1,this.type=5126,this.offset=0,this.stride=0,this.divisor=0}var Dt=5121,jt=5126;function Ct(t,r,n,a,i,o,f){function u(u){var s;null===r.next?(_(i.preserveDrawingBuffer,'you must create a webgl context with "preserveDrawingBuffer":true in order to read pixels from the drawing buffer'),s=Dt):(_(null!==r.next.colorAttachments[0].texture,"You cannot read from a renderbuffer"),s=r.next.colorAttachments[0].texture._texture.type,_.optional((function(){o.oes_texture_float?(_(s===Dt||s===jt,"Reading from a framebuffer is only allowed for the types 'uint8' and 'float'"),s===jt&&_(f.readFloat,"Reading 'float' values is not permitted in your browser. For a fallback, please see: https://www.npmjs.com/package/glsl-read-float")):_(s===Dt,"Reading from a framebuffer is only allowed for the type 'uint8'")})));var c=0,l=0,d=a.framebufferWidth,m=a.framebufferHeight,p=null;e(u)?p=u:u&&(_.type(u,"object","invalid arguments to regl.read()"),c=0|u.x,l=0|u.y,_(c>=0&&c<a.framebufferWidth,"invalid x offset for regl.read"),_(l>=0&&l<a.framebufferHeight,"invalid y offset for regl.read"),d=0|(u.width||a.framebufferWidth-c),m=0|(u.height||a.framebufferHeight-l),p=u.data||null),p&&(s===Dt?_(p instanceof Uint8Array,"buffer must be 'Uint8Array' when reading from a framebuffer of type 'uint8'"):s===jt&&_(p instanceof Float32Array,"buffer must be 'Float32Array' when reading from a framebuffer of type 'float'")),_(d>0&&d+c<=a.framebufferWidth,"invalid width for read pixels"),_(m>0&&m+l<=a.framebufferHeight,"invalid height for read pixels"),n();var h=d*m*4;return p||(s===Dt?p=new Uint8Array(h):s===jt&&(p=p||new Float32Array(h))),_.isTypedArray(p,"data buffer for regl.read() must be a typedarray"),_(p.byteLength>=h,"data buffer for regl.read() too small"),t.pixelStorei(3333,4),t.readPixels(c,l,d,m,6408,s,p),p}return function(e){return e&&"framebuffer"in e?function(e){var t;return r.setFBO({framebuffer:e.framebuffer},(function(){t=u(e)})),t}(e):u(e)}}function zt(e){return Array.prototype.slice.call(e)}function Ft(e){return zt(e).join("")}var Bt="xyzw".split(""),Vt="dither",It="blend.enable",Pt="blend.color",Lt="blend.equation",Rt="blend.func",Mt="depth.enable",Wt="depth.func",Ut="depth.range",Gt="depth.mask",Ht="colorMask",Nt="cull.enable",qt="cull.face",Qt="frontFace",Yt="lineWidth",Xt="polygonOffset.enable",$t="polygonOffset.offset",Kt="sample.alpha",Jt="sample.enable",Zt="sample.coverage",er="stencil.enable",tr="stencil.mask",rr="stencil.func",nr="stencil.opFront",ar="stencil.opBack",ir="scissor.enable",or="scissor.box",fr="viewport",ur="profile",sr="framebuffer",cr="vert",lr="frag",dr="elements",mr="primitive",pr="count",hr="offset",br="instances",vr="vao",gr="Width",yr="Height",xr=sr+gr,wr=sr+yr,Ar="drawingBufferWidth",_r="drawingBufferHeight",kr=[Rt,Lt,rr,nr,ar,Zt,fr,or,$t],Sr=34962,Or=34963,Er=5126,Tr=35664,Dr=35665,jr=35666,Cr=5124,zr=35667,Fr=35668,Br=35669,Vr=35670,Ir=35671,Pr=35672,Lr=35673,Rr=35674,Mr=35675,Wr=35676,Ur=35678,Gr=35680,Hr=1028,Nr=1029,qr=2305,Qr=7680,Yr={0:0,1:1,zero:0,one:1,"src color":768,"one minus src color":769,"src alpha":770,"one minus src alpha":771,"dst color":774,"one minus dst color":775,"dst alpha":772,"one minus dst alpha":773,"constant color":32769,"one minus constant color":32770,"constant alpha":32771,"one minus constant alpha":32772,"src alpha saturate":776},Xr=["constant color, constant alpha","one minus constant color, constant alpha","constant color, one minus constant alpha","one minus constant color, one minus constant alpha","constant alpha, constant color","constant alpha, one minus constant color","one minus constant alpha, constant color","one minus constant alpha, one minus constant color"],$r={never:512,less:513,"<":513,equal:514,"=":514,"==":514,"===":514,lequal:515,"<=":515,greater:516,">":516,notequal:517,"!=":517,"!==":517,gequal:518,">=":518,always:519},Kr={0:0,zero:0,keep:7680,replace:7681,increment:7682,decrement:7683,"increment wrap":34055,"decrement wrap":34056,invert:5386},Jr={frag:35632,vert:35633},Zr={cw:2304,ccw:qr};function en(t){return Array.isArray(t)||e(t)||G(t)}function tn(e){return e.sort((function(e,t){return e===fr?-1:t===fr?1:e<t?-1:1}))}function rn(e,t,r,n){this.thisDep=e,this.contextDep=t,this.propDep=r,this.append=n}function nn(e){return e&&!(e.thisDep||e.contextDep||e.propDep)}function an(e){return new rn(!1,!1,!1,e)}function on(e,t){var r=e.type;if(0===r){var n=e.data.length;return new rn(!0,n>=1,n>=2,t)}if(4===r){var a=e.data;return new rn(a.thisDep,a.contextDep,a.propDep,t)}if(5===r)return new rn(!1,!1,!1,t);if(6===r){for(var i=!1,o=!1,f=!1,u=0;u<e.data.length;++u){var s=e.data[u];if(1===s.type)f=!0;else if(2===s.type)o=!0;else if(3===s.type)i=!0;else if(0===s.type){i=!0;var c=s.data;c>=1&&(o=!0),c>=2&&(f=!0)}else 4===s.type&&(i=i||s.data.thisDep,o=o||s.data.contextDep,f=f||s.data.propDep)}return new rn(i,o,f,t)}return new rn(3===r,2===r,1===r,t)}var fn=new rn(!1,!1,!1,(function(){}));function un(e,r,n,a,i,o,f,u,s,c,l,d,m,p,h){var b=c.Record,v={add:32774,subtract:32778,"reverse subtract":32779};n.ext_blend_minmax&&(v.min=32775,v.max=32776);var g=n.angle_instanced_arrays,y=n.webgl_draw_buffers,x=n.oes_vertex_array_object,w={dirty:!0,profile:h.profile},A={},k=[],S={},O={};function E(e){return e.replace(".","_")}function T(e,t,r){var n=E(e);k.push(e),A[n]=w[n]=!!r,S[n]=t}function j(e,t,r){var n=E(e);k.push(e),Array.isArray(r)?(w[n]=r.slice(),A[n]=r.slice()):w[n]=A[n]=r,O[n]=t}T(Vt,3024),T(It,3042),j(Pt,"blendColor",[0,0,0,0]),j(Lt,"blendEquationSeparate",[32774,32774]),j(Rt,"blendFuncSeparate",[1,0,1,0]),T(Mt,2929,!0),j(Wt,"depthFunc",513),j(Ut,"depthRange",[0,1]),j(Gt,"depthMask",!0),j(Ht,Ht,[!0,!0,!0,!0]),T(Nt,2884),j(qt,"cullFace",Nr),j(Qt,Qt,qr),j(Yt,Yt,1),T(Xt,32823),j($t,"polygonOffset",[0,0]),T(Kt,32926),T(Jt,32928),j(Zt,"sampleCoverage",[1,!1]),T(er,2960),j(tr,"stencilMask",-1),j(rr,"stencilFunc",[519,0,-1]),j(nr,"stencilOpSeparate",[Hr,Qr,Qr,Qr]),j(ar,"stencilOpSeparate",[Nr,Qr,Qr,Qr]),T(ir,3089),j(or,"scissor",[0,0,e.drawingBufferWidth,e.drawingBufferHeight]),j(fr,fr,[0,0,e.drawingBufferWidth,e.drawingBufferHeight]);var C={gl:e,context:m,strings:r,next:A,current:w,draw:d,elements:o,buffer:i,shader:l,attributes:c.state,vao:c,uniforms:s,framebuffer:u,extensions:n,timer:p,isBufferArgs:en},z={primTypes:ie,compareFuncs:$r,blendFuncs:Yr,blendEquations:v,stencilOps:Kr,glTypes:X,orientationType:Zr};_.optional((function(){C.isArrayLike=me})),y&&(z.backBuffer=[Nr],z.drawBuffer=V(a.maxDrawbuffers,(function(e){return 0===e?[0]:V(e,(function(e){return 36064+e}))})));var F=0;function B(){var e=function(){var e=0,r=[],n=[];function a(){var r=[],n=[];return t((function(){r.push.apply(r,zt(arguments))}),{def:function(){var t="v"+e++;return n.push(t),arguments.length>0&&(r.push(t,"="),r.push.apply(r,zt(arguments)),r.push(";")),t},toString:function(){return Ft([n.length>0?"var "+n.join(",")+";":"",Ft(r)])}})}function i(){var e=a(),r=a(),n=e.toString,i=r.toString;function o(t,n){r(t,n,"=",e.def(t,n),";")}return t((function(){e.apply(e,zt(arguments))}),{def:e.def,entry:e,exit:r,save:o,set:function(t,r,n){o(t,r),e(t,r,"=",n,";")},toString:function(){return n()+i()}})}var o=a(),f={};return{global:o,link:function(t){for(var a=0;a<n.length;++a)if(n[a]===t)return r[a];var i="g"+e++;return r.push(i),n.push(t),i},block:a,proc:function(e,r){var n=[];function a(){var e="a"+n.length;return n.push(e),e}r=r||0;for(var o=0;o<r;++o)a();var u=i(),s=u.toString;return f[e]=t(u,{arg:a,toString:function(){return Ft(["function(",n.join(),"){",s(),"}"])}})},scope:i,cond:function(){var e=Ft(arguments),r=i(),n=i(),a=r.toString,o=n.toString;return t(r,{then:function(){return r.apply(r,zt(arguments)),this},else:function(){return n.apply(n,zt(arguments)),this},toString:function(){var t=o();return t&&(t="else{"+t+"}"),Ft(["if(",e,"){",a(),"}",t])}})},compile:function(){var e=['"use strict";',o,"return {"];Object.keys(f).forEach((function(t){e.push('"',t,'":',f[t].toString(),",")})),e.push("}");var t=Ft(e).replace(/;/g,";\n").replace(/}/g,"}\n").replace(/{/g,"{\n");return Function.apply(null,r.concat(t)).apply(null,n)}}}(),n=e.link,a=e.global;e.id=F++,e.batchId="0";var i=n(C),o=e.shared={props:"a0"};Object.keys(C).forEach((function(e){o[e]=a.def(i,".",e)})),_.optional((function(){e.CHECK=n(_),e.commandStr=_.guessCommand(),e.command=n(e.commandStr),e.assert=function(e,t,r){e("if(!(",t,"))",this.CHECK,".commandRaise(",n(r),",",this.command,");")},z.invalidBlendCombinations=Xr}));var f=e.next={},u=e.current={};Object.keys(O).forEach((function(e){Array.isArray(w[e])&&(f[e]=a.def(o.next,".",e),u[e]=a.def(o.current,".",e))}));var s=e.constants={};Object.keys(z).forEach((function(e){s[e]=a.def(JSON.stringify(z[e]))})),e.invoke=function(t,r){switch(r.type){case 0:var a=["this",o.context,o.props,e.batchId];return t.def(n(r.data),".call(",a.slice(0,Math.max(r.data.length+1,4)),")");case 1:return t.def(o.props,r.data);case 2:return t.def(o.context,r.data);case 3:return t.def("this",r.data);case 4:return r.data.append(e,t),r.data.ref;case 5:return r.data.toString();case 6:return r.data.map((function(r){return e.invoke(t,r)}))}},e.attribCache={};var l={};return e.scopeAttrib=function(e){var t=r.id(e);if(t in l)return l[t];var a=c.scope[t];return a||(a=c.scope[t]=new b),l[t]=n(a)},e}function I(e,t,f,s,d){var m=e.static,p=e.dynamic;_.optional((function(){var e=[sr,cr,lr,dr,mr,hr,pr,br,ur,vr].concat(k);function t(t){Object.keys(t).forEach((function(t){_.command(e.indexOf(t)>=0,'unknown parameter "'+t+'"',d.commandStr)}))}t(m),t(p)}));var h=function(e,t){var r=e.static;if("string"==typeof r[lr]&&"string"==typeof r[cr]){if(Object.keys(t.dynamic).length>0)return null;var n=t.static,a=Object.keys(n);if(a.length>0&&"number"==typeof n[a[0]]){for(var i=[],o=0;o<a.length;++o)_("number"==typeof n[a[o]],"must specify all vertex attribute locations when using vaos"),i.push([0|n[a[o]],a[o]]);return i}}return null}(e,t),y=function(e,t){var r=e.static,n=e.dynamic;if(sr in r){var a=r[sr];return a?(a=u.getFramebuffer(a),_.command(a,"invalid framebuffer object"),an((function(e,t){var r=e.link(a),n=e.shared;t.set(n.framebuffer,".next",r);var i=n.context;return t.set(i,"."+xr,r+".width"),t.set(i,"."+wr,r+".height"),r}))):an((function(e,t){var r=e.shared;t.set(r.framebuffer,".next","null");var n=r.context;return t.set(n,"."+xr,n+"."+Ar),t.set(n,"."+wr,n+"."+_r),"null"}))}if(sr in n){var i=n[sr];return on(i,(function(e,t){var r=e.invoke(t,i),n=e.shared,a=n.framebuffer,o=t.def(a,".getFramebuffer(",r,")");_.optional((function(){e.assert(t,"!"+r+"||"+o,"invalid framebuffer object")})),t.set(a,".next",o);var f=n.context;return t.set(f,"."+xr,o+"?"+o+".width:"+f+"."+Ar),t.set(f,"."+wr,o+"?"+o+".height:"+f+"."+_r),o}))}return null}(e),x=function(e,t,r){var n=e.static,a=e.dynamic;function i(e){if(e in n){var i=n[e];_.commandType(i,"object","invalid "+e,r.commandStr);var o,f,u=!0,s=0|i.x,c=0|i.y;return"width"in i?(o=0|i.width,_.command(o>=0,"invalid "+e,r.commandStr)):u=!1,"height"in i?(f=0|i.height,_.command(f>=0,"invalid "+e,r.commandStr)):u=!1,new rn(!u&&t&&t.thisDep,!u&&t&&t.contextDep,!u&&t&&t.propDep,(function(e,t){var r=e.shared.context,n=o;"width"in i||(n=t.def(r,".",xr,"-",s));var a=f;return"height"in i||(a=t.def(r,".",wr,"-",c)),[s,c,n,a]}))}if(e in a){var l=a[e],d=on(l,(function(t,r){var n=t.invoke(r,l);_.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)}));var a=t.shared.context,i=r.def(n,".x|0"),o=r.def(n,".y|0"),f=r.def('"width" in ',n,"?",n,".width|0:","(",a,".",xr,"-",i,")"),u=r.def('"height" in ',n,"?",n,".height|0:","(",a,".",wr,"-",o,")");return _.optional((function(){t.assert(r,f+">=0&&"+u+">=0","invalid "+e)})),[i,o,f,u]}));return t&&(d.thisDep=d.thisDep||t.thisDep,d.contextDep=d.contextDep||t.contextDep,d.propDep=d.propDep||t.propDep),d}return t?new rn(t.thisDep,t.contextDep,t.propDep,(function(e,t){var r=e.shared.context;return[0,0,t.def(r,".",xr),t.def(r,".",wr)]})):null}var o=i(fr);if(o){var f=o;o=new rn(o.thisDep,o.contextDep,o.propDep,(function(e,t){var r=f.append(e,t),n=e.shared.context;return t.set(n,".viewportWidth",r[2]),t.set(n,".viewportHeight",r[3]),r}))}return{viewport:o,scissor_box:i(or)}}(e,y,d),w=function(e,t){var r=e.static,n=e.dynamic,a={},i=!1,f=function(){if(vr in r){var e=r[vr];return null!==e&&null===c.getVAO(e)&&(e=c.createVAO(e)),i=!0,a.vao=e,an((function(t){var r=c.getVAO(e);return r?t.link(r):"null"}))}if(vr in n){i=!0;var t=n[vr];return on(t,(function(e,r){var n=e.invoke(r,t);return r.def(e.shared.vao+".getVAO("+n+")")}))}return null}(),u=!1,s=function(){if(dr in r){var e=r[dr];if(a.elements=e,en(e)){var s=a.elements=o.create(e,!0);e=o.getElements(s),u=!0}else e&&(e=o.getElements(e),u=!0,_.command(e,"invalid elements",t.commandStr));var c=an((function(t,r){if(e){var n=t.link(e);return t.ELEMENTS=n,n}return t.ELEMENTS=null,null}));return c.value=e,c}if(dr in n){u=!0;var l=n[dr];return on(l,(function(e,t){var r=e.shared,n=r.isBufferArgs,a=r.elements,i=e.invoke(t,l),o=t.def("null"),f=t.def(n,"(",i,")"),u=e.cond(f).then(o,"=",a,".createStream(",i,");").else(o,"=",a,".getElements(",i,");");return _.optional((function(){e.assert(u.else,"!"+i+"||"+o,"invalid elements")})),t.entry(u),t.exit(e.cond(f).then(a,".destroyStream(",o,");")),e.ELEMENTS=o,o}))}return i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.elements+".getElements("+e.shared.vao+".currentVAO.elements):null")})):null}();function l(e,o){if(e in r){var s=0|r[e];return o?a.offset=s:a.instances=s,_.command(!o||s>=0,"invalid "+e,t.commandStr),an((function(e,t){return o&&(e.OFFSET=s),s}))}if(e in n){var c=n[e];return on(c,(function(t,r){var n=t.invoke(r,c);return o&&(t.OFFSET=n,_.optional((function(){t.assert(r,n+">=0","invalid "+e)}))),n}))}if(o){if(u)return an((function(e,t){return e.OFFSET=0,0}));if(i)return new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.offset:0")}))}else if(i)return new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.instances:-1")}));return null}var d=l(hr,!0),m=function(){if(mr in r){var e=r[mr];return a.primitive=e,_.commandParameter(e,ie,"invalid primitve",t.commandStr),an((function(t,r){return ie[e]}))}if(mr in n){var o=n[mr];return on(o,(function(e,t){var r=e.constants.primTypes,n=e.invoke(t,o);return _.optional((function(){e.assert(t,n+" in "+r,"invalid primitive, must be one of "+Object.keys(ie))})),t.def(r,"[",n,"]")}))}return u?nn(s)?s.value?an((function(e,t){return t.def(e.ELEMENTS,".primType")})):an((function(){return 4})):new rn(s.thisDep,s.contextDep,s.propDep,(function(e,t){var r=e.ELEMENTS;return t.def(r,"?",r,".primType:",4)})):i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.primitive:4")})):null}(),p=function(){if(pr in r){var e=0|r[pr];return a.count=e,_.command("number"==typeof e&&e>=0,"invalid vertex count",t.commandStr),an((function(){return e}))}if(pr in n){var o=n[pr];return on(o,(function(e,t){var r=e.invoke(t,o);return _.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">=0&&"+r+"===("+r+"|0)","invalid vertex count")})),r}))}if(u){if(nn(s)){if(s)return d?new rn(d.thisDep,d.contextDep,d.propDep,(function(e,t){var r=t.def(e.ELEMENTS,".vertCount-",e.OFFSET);return _.optional((function(){e.assert(t,r+">=0","invalid vertex offset/element buffer too small")})),r})):an((function(e,t){return t.def(e.ELEMENTS,".vertCount")}));var c=an((function(){return-1}));return _.optional((function(){c.MISSING=!0})),c}var l=new rn(s.thisDep||d.thisDep,s.contextDep||d.contextDep,s.propDep||d.propDep,(function(e,t){var r=e.ELEMENTS;return e.OFFSET?t.def(r,"?",r,".vertCount-",e.OFFSET,":-1"):t.def(r,"?",r,".vertCount:-1")}));return _.optional((function(){l.DYNAMIC=!0})),l}return i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao,".currentVAO?",e.shared.vao,".currentVAO.count:-1")})):null}(),h=l(br,!1);return{elements:s,primitive:m,count:p,instances:h,offset:d,vao:f,vaoActive:i,elementsActive:u,static:a}}(e,d),A=function(e,t){var r=e.static,n=e.dynamic,i={};return k.forEach((function(e){var o=E(e);function f(t,a){if(e in r){var f=t(r[e]);i[o]=an((function(){return f}))}else if(e in n){var u=n[e];i[o]=on(u,(function(e,t){return a(e,t,e.invoke(t,u))}))}}switch(e){case Nt:case It:case Vt:case er:case Mt:case ir:case Xt:case Kt:case Jt:case Gt:return f((function(r){return _.commandType(r,"boolean",e,t.commandStr),r}),(function(t,r,n){return _.optional((function(){t.assert(r,"typeof "+n+'==="boolean"',"invalid flag "+e,t.commandStr)})),n}));case Wt:return f((function(r){return _.commandParameter(r,$r,"invalid "+e,t.commandStr),$r[r]}),(function(t,r,n){var a=t.constants.compareFuncs;return _.optional((function(){t.assert(r,n+" in "+a,"invalid "+e+", must be one of "+Object.keys($r))})),r.def(a,"[",n,"]")}));case Ut:return f((function(e){return _.command(me(e)&&2===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&e[0]<=e[1],"depth range is 2d array",t.commandStr),e}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===2&&typeof "+r+'[0]==="number"&&typeof '+r+'[1]==="number"&&'+r+"[0]<="+r+"[1]","depth range must be a 2d array")})),[t.def("+",r,"[0]"),t.def("+",r,"[1]")]}));case Rt:return f((function(e){_.commandType(e,"object","blend.func",t.commandStr);var r="srcRGB"in e?e.srcRGB:e.src,n="srcAlpha"in e?e.srcAlpha:e.src,a="dstRGB"in e?e.dstRGB:e.dst,i="dstAlpha"in e?e.dstAlpha:e.dst;return _.commandParameter(r,Yr,o+".srcRGB",t.commandStr),_.commandParameter(n,Yr,o+".srcAlpha",t.commandStr),_.commandParameter(a,Yr,o+".dstRGB",t.commandStr),_.commandParameter(i,Yr,o+".dstAlpha",t.commandStr),_.command(-1===Xr.indexOf(r+", "+a),"unallowed blending combination (srcRGB, dstRGB) = ("+r+", "+a+")",t.commandStr),[Yr[r],Yr[a],Yr[n],Yr[i]]}),(function(t,r,n){var a=t.constants.blendFuncs;function i(i,o){var f=r.def('"',i,o,'" in ',n,"?",n,".",i,o,":",n,".",i);return _.optional((function(){t.assert(r,f+" in "+a,"invalid "+e+"."+i+o+", must be one of "+Object.keys(Yr))})),f}_.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid blend func, must be an object")}));var o=i("src","RGB"),f=i("dst","RGB");_.optional((function(){var e=t.constants.invalidBlendCombinations;t.assert(r,e+".indexOf("+o+'+", "+'+f+") === -1 ","unallowed blending combination for (srcRGB, dstRGB)")}));var u=r.def(a,"[",o,"]"),s=r.def(a,"[",i("src","Alpha"),"]");return[u,r.def(a,"[",f,"]"),s,r.def(a,"[",i("dst","Alpha"),"]")]}));case Lt:return f((function(r){return"string"==typeof r?(_.commandParameter(r,v,"invalid "+e,t.commandStr),[v[r],v[r]]):"object"==typeof r?(_.commandParameter(r.rgb,v,e+".rgb",t.commandStr),_.commandParameter(r.alpha,v,e+".alpha",t.commandStr),[v[r.rgb],v[r.alpha]]):void _.commandRaise("invalid blend.equation",t.commandStr)}),(function(t,r,n){var a=t.constants.blendEquations,i=r.def(),o=r.def(),f=t.cond("typeof ",n,'==="string"');return _.optional((function(){function r(e,r,n){t.assert(e,n+" in "+a,"invalid "+r+", must be one of "+Object.keys(v))}r(f.then,e,n),t.assert(f.else,n+"&&typeof "+n+'==="object"',"invalid "+e),r(f.else,e+".rgb",n+".rgb"),r(f.else,e+".alpha",n+".alpha")})),f.then(i,"=",o,"=",a,"[",n,"];"),f.else(i,"=",a,"[",n,".rgb];",o,"=",a,"[",n,".alpha];"),r(f),[i,o]}));case Pt:return f((function(e){return _.command(me(e)&&4===e.length,"blend.color must be a 4d array",t.commandStr),V(4,(function(t){return+e[t]}))}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","blend.color must be a 4d array")})),V(4,(function(e){return t.def("+",r,"[",e,"]")}))}));case tr:return f((function(e){return _.commandType(e,"number",o,t.commandStr),0|e}),(function(e,t,r){return _.optional((function(){e.assert(t,"typeof "+r+'==="number"',"invalid stencil.mask")})),t.def(r,"|0")}));case rr:return f((function(r){_.commandType(r,"object",o,t.commandStr);var n=r.cmp||"keep",a=r.ref||0,i="mask"in r?r.mask:-1;return _.commandParameter(n,$r,e+".cmp",t.commandStr),_.commandType(a,"number",e+".ref",t.commandStr),_.commandType(i,"number",e+".mask",t.commandStr),[$r[n],a,i]}),(function(e,t,r){var n=e.constants.compareFuncs;return _.optional((function(){function a(){e.assert(t,Array.prototype.join.call(arguments,""),"invalid stencil.func")}a(r+"&&typeof ",r,'==="object"'),a('!("cmp" in ',r,")||(",r,".cmp in ",n,")")})),[t.def('"cmp" in ',r,"?",n,"[",r,".cmp]",":",Qr),t.def(r,".ref|0"),t.def('"mask" in ',r,"?",r,".mask|0:-1")]}));case nr:case ar:return f((function(r){_.commandType(r,"object",o,t.commandStr);var n=r.fail||"keep",a=r.zfail||"keep",i=r.zpass||"keep";return _.commandParameter(n,Kr,e+".fail",t.commandStr),_.commandParameter(a,Kr,e+".zfail",t.commandStr),_.commandParameter(i,Kr,e+".zpass",t.commandStr),[e===ar?Nr:Hr,Kr[n],Kr[a],Kr[i]]}),(function(t,r,n){var a=t.constants.stencilOps;function i(i){return _.optional((function(){t.assert(r,'!("'+i+'" in '+n+")||("+n+"."+i+" in "+a+")","invalid "+e+"."+i+", must be one of "+Object.keys(Kr))})),r.def('"',i,'" in ',n,"?",a,"[",n,".",i,"]:",Qr)}return _.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[e===ar?Nr:Hr,i("fail"),i("zfail"),i("zpass")]}));case $t:return f((function(e){_.commandType(e,"object",o,t.commandStr);var r=0|e.factor,n=0|e.units;return _.commandType(r,"number",o+".factor",t.commandStr),_.commandType(n,"number",o+".units",t.commandStr),[r,n]}),(function(t,r,n){return _.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[r.def(n,".factor|0"),r.def(n,".units|0")]}));case qt:return f((function(e){var r=0;return"front"===e?r=Hr:"back"===e&&(r=Nr),_.command(!!r,o,t.commandStr),r}),(function(e,t,r){return _.optional((function(){e.assert(t,r+'==="front"||'+r+'==="back"',"invalid cull.face")})),t.def(r,'==="front"?',Hr,":",Nr)}));case Yt:return f((function(e){return _.command("number"==typeof e&&e>=a.lineWidthDims[0]&&e<=a.lineWidthDims[1],"invalid line width, must be a positive number between "+a.lineWidthDims[0]+" and "+a.lineWidthDims[1],t.commandStr),e}),(function(e,t,r){return _.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">="+a.lineWidthDims[0]+"&&"+r+"<="+a.lineWidthDims[1],"invalid line width")})),r}));case Qt:return f((function(e){return _.commandParameter(e,Zr,o,t.commandStr),Zr[e]}),(function(e,t,r){return _.optional((function(){e.assert(t,r+'==="cw"||'+r+'==="ccw"',"invalid frontFace, must be one of cw,ccw")})),t.def(r+'==="cw"?2304:'+qr)}));case Ht:return f((function(e){return _.command(me(e)&&4===e.length,"color.mask must be length 4 array",t.commandStr),e.map((function(e){return!!e}))}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","invalid color.mask")})),V(4,(function(e){return"!!"+r+"["+e+"]"}))}));case Zt:return f((function(e){_.command("object"==typeof e&&e,o,t.commandStr);var r="value"in e?e.value:1,n=!!e.invert;return _.command("number"==typeof r&&r>=0&&r<=1,"sample.coverage.value must be a number between 0 and 1",t.commandStr),[r,n]}),(function(e,t,r){return _.optional((function(){e.assert(t,r+"&&typeof "+r+'==="object"',"invalid sample.coverage")})),[t.def('"value" in ',r,"?+",r,".value:1"),t.def("!!",r,".invert")]}))}})),i}(e,d),S=function(e,t,n){var a=e.static,i=e.dynamic;function o(e){if(e in a){var t=r.id(a[e]);_.optional((function(){l.shader(Jr[e],t,_.guessCommand())}));var n=an((function(){return t}));return n.id=t,n}if(e in i){var o=i[e];return on(o,(function(t,r){var n=t.invoke(r,o),a=r.def(t.shared.strings,".id(",n,")");return _.optional((function(){r(t.shared.shader,".shader(",Jr[e],",",a,",",t.command,");")})),a}))}return null}var f,u=o(lr),s=o(cr),c=null;return nn(u)&&nn(s)?(c=l.program(s.id,u.id,null,n),f=an((function(e,t){return e.link(c)}))):f=new rn(u&&u.thisDep||s&&s.thisDep,u&&u.contextDep||s&&s.contextDep,u&&u.propDep||s&&s.propDep,(function(e,t){var r,n=e.shared.shader;r=u?u.append(e,t):t.def(n,".",lr);var a=n+".program("+(s?s.append(e,t):t.def(n,".",cr))+","+r;return _.optional((function(){a+=","+e.command})),t.def(a+")")})),{frag:u,vert:s,progVar:f,program:c}}(e,0,h);function O(e){var t=x[e];t&&(A[e]=t)}O(fr),O(E(or));var T=Object.keys(A).length>0,D={framebuffer:y,draw:w,shader:S,state:A,dirty:T,scopeVAO:null,drawVAO:null,useVAO:!1,attributes:{}};if(D.profile=function(e){var t,r=e.static,n=e.dynamic;if(ur in r){var a=!!r[ur];(t=an((function(e,t){return a}))).enable=a}else if(ur in n){var i=n[ur];t=on(i,(function(e,t){return e.invoke(t,i)}))}return t}(e),D.uniforms=function(e,t){var r=e.static,n=e.dynamic,a={};return Object.keys(r).forEach((function(e){var n,i=r[e];if("number"==typeof i||"boolean"==typeof i)n=an((function(){return i}));else if("function"==typeof i){var o=i._reglType;"texture2d"===o||"textureCube"===o?n=an((function(e){return e.link(i)})):"framebuffer"===o||"framebufferCube"===o?(_.command(i.color.length>0,'missing color attachment for framebuffer sent to uniform "'+e+'"',t.commandStr),n=an((function(e){return e.link(i.color[0])}))):_.commandRaise('invalid data for uniform "'+e+'"',t.commandStr)}else me(i)?n=an((function(t){return t.global.def("[",V(i.length,(function(r){return _.command("number"==typeof i[r]||"boolean"==typeof i[r],"invalid uniform "+e,t.commandStr),i[r]})),"]")})):_.commandRaise('invalid or missing data for uniform "'+e+'"',t.commandStr);n.value=i,a[e]=n})),Object.keys(n).forEach((function(e){var t=n[e];a[e]=on(t,(function(e,r){return e.invoke(r,t)}))})),a}(f,d),D.drawVAO=D.scopeVAO=w.vao,!D.drawVAO&&S.program&&!h&&n.angle_instanced_arrays&&w.static.elements){var j=!0,C=S.program.attributes.map((function(e){var r=t.static[e];return j=j&&!!r,r}));if(j&&C.length>0){var z=c.getVAO(c.createVAO({attributes:C,elements:w.static.elements}));D.drawVAO=new rn(null,null,null,(function(e,t){return e.link(z)})),D.useVAO=!0}}return h?D.useVAO=!0:D.attributes=function(e,t){var n=e.static,a=e.dynamic,o={};return Object.keys(n).forEach((function(e){var a=n[e],f=r.id(e),u=new b;if(en(a))u.state=1,u.buffer=i.getBuffer(i.create(a,Sr,!1,!0)),u.type=0;else{var s=i.getBuffer(a);if(s)u.state=1,u.buffer=s,u.type=0;else if(_.command("object"==typeof a&&a,"invalid data for attribute "+e,t.commandStr),"constant"in a){var c=a.constant;u.buffer="null",u.state=2,"number"==typeof c?u.x=c:(_.command(me(c)&&c.length>0&&c.length<=4,"invalid constant for attribute "+e,t.commandStr),Bt.forEach((function(e,t){t<c.length&&(u[e]=c[t])})))}else{s=en(a.buffer)?i.getBuffer(i.create(a.buffer,Sr,!1,!0)):i.getBuffer(a.buffer),_.command(!!s,'missing buffer for attribute "'+e+'"',t.commandStr);var l=0|a.offset;_.command(l>=0,'invalid offset for attribute "'+e+'"',t.commandStr);var d=0|a.stride;_.command(d>=0&&d<256,'invalid stride for attribute "'+e+'", must be integer betweeen [0, 255]',t.commandStr);var m=0|a.size;_.command(!("size"in a)||m>0&&m<=4,'invalid size for attribute "'+e+'", must be 1,2,3,4',t.commandStr);var p=!!a.normalized,h=0;"type"in a&&(_.commandParameter(a.type,X,"invalid type for attribute "+e,t.commandStr),h=X[a.type]);var v=0|a.divisor;_.optional((function(){"divisor"in a&&(_.command(0===v||g,'cannot specify divisor for attribute "'+e+'", instancing not supported',t.commandStr),_.command(v>=0,'invalid divisor for attribute "'+e+'"',t.commandStr));var r=t.commandStr,n=["buffer","offset","divisor","normalized","type","size","stride"];Object.keys(a).forEach((function(t){_.command(n.indexOf(t)>=0,'unknown parameter "'+t+'" for attribute pointer "'+e+'" (valid parameters are '+n+")",r)}))})),u.buffer=s,u.state=1,u.size=m,u.normalized=p,u.type=h||s.dtype,u.offset=l,u.stride=d,u.divisor=v}}o[e]=an((function(e,t){var r=e.attribCache;if(f in r)return r[f];var n={isStream:!1};return Object.keys(u).forEach((function(e){n[e]=u[e]})),u.buffer&&(n.buffer=e.link(u.buffer),n.type=n.type||n.buffer+".dtype"),r[f]=n,n}))})),Object.keys(a).forEach((function(e){var t=a[e];o[e]=on(t,(function(r,n){var a=r.invoke(n,t),i=r.shared,o=r.constants,f=i.isBufferArgs,u=i.buffer;_.optional((function(){r.assert(n,a+"&&(typeof "+a+'==="object"||typeof '+a+'==="function")&&('+f+"("+a+")||"+u+".getBuffer("+a+")||"+u+".getBuffer("+a+".buffer)||"+f+"("+a+'.buffer)||("constant" in '+a+"&&(typeof "+a+'.constant==="number"||'+i.isArrayLike+"("+a+".constant))))",'invalid dynamic attribute "'+e+'"')}));var s={isStream:n.def(!1)},c=new b;c.state=1,Object.keys(c).forEach((function(e){s[e]=n.def(""+c[e])}));var l=s.buffer,d=s.type;function m(e){n(s[e],"=",a,".",e,"|0;")}return n("if(",f,"(",a,")){",s.isStream,"=true;",l,"=",u,".createStream(",Sr,",",a,");",d,"=",l,".dtype;","}else{",l,"=",u,".getBuffer(",a,");","if(",l,"){",d,"=",l,".dtype;",'}else if("constant" in ',a,"){",s.state,"=",2,";","if(typeof "+a+'.constant === "number"){',s[Bt[0]],"=",a,".constant;",Bt.slice(1).map((function(e){return s[e]})).join("="),"=0;","}else{",Bt.map((function(e,t){return s[e]+"="+a+".constant.length>"+t+"?"+a+".constant["+t+"]:0;"})).join(""),"}}else{","if(",f,"(",a,".buffer)){",l,"=",u,".createStream(",Sr,",",a,".buffer);","}else{",l,"=",u,".getBuffer(",a,".buffer);","}",d,'="type" in ',a,"?",o.glTypes,"[",a,".type]:",l,".dtype;",s.normalized,"=!!",a,".normalized;"),m("size"),m("offset"),m("stride"),m("divisor"),n("}}"),n.exit("if(",s.isStream,"){",u,".destroyStream(",l,");","}"),s}))})),o}(t,d),D.context=function(e){var t=e.static,r=e.dynamic,n={};return Object.keys(t).forEach((function(e){var r=t[e];n[e]=an((function(e,t){return"number"==typeof r||"boolean"==typeof r?""+r:e.link(r)}))})),Object.keys(r).forEach((function(e){var t=r[e];n[e]=on(t,(function(e,r){return e.invoke(r,t)}))})),n}(s),D}function P(e,t,r){var n=e.shared.context,a=e.scope();Object.keys(r).forEach((function(i){t.save(n,"."+i);var o=r[i].append(e,t);Array.isArray(o)?a(n,".",i,"=[",o.join(),"];"):a(n,".",i,"=",o,";")})),t(a)}function L(e,t,r,n){var a,i=e.shared,o=i.gl,f=i.framebuffer;y&&(a=t.def(i.extensions,".webgl_draw_buffers"));var u,s=e.constants,c=s.drawBuffer,l=s.backBuffer;u=r?r.append(e,t):t.def(f,".next"),n||t("if(",u,"!==",f,".cur){"),t("if(",u,"){",o,".bindFramebuffer(",36160,",",u,".framebuffer);"),y&&t(a,".drawBuffersWEBGL(",c,"[",u,".colorAttachments.length]);"),t("}else{",o,".bindFramebuffer(",36160,",null);"),y&&t(a,".drawBuffersWEBGL(",l,");"),t("}",f,".cur=",u,";"),n||t("}")}function R(e,t,r){var n=e.shared,a=n.gl,i=e.current,o=e.next,f=n.current,u=n.next,s=e.cond(f,".dirty");k.forEach((function(t){var n,c,l=E(t);if(!(l in r.state))if(l in o){n=o[l],c=i[l];var d=V(w[l].length,(function(e){return s.def(n,"[",e,"]")}));s(e.cond(d.map((function(e,t){return e+"!=="+c+"["+t+"]"})).join("||")).then(a,".",O[l],"(",d,");",d.map((function(e,t){return c+"["+t+"]="+e})).join(";"),";"))}else{n=s.def(u,".",l);var m=e.cond(n,"!==",f,".",l);s(m),l in S?m(e.cond(n).then(a,".enable(",S[l],");").else(a,".disable(",S[l],");"),f,".",l,"=",n,";"):m(a,".",O[l],"(",n,");",f,".",l,"=",n,";")}})),0===Object.keys(r.state).length&&s(f,".dirty=false;"),t(s)}function M(e,t,r,n){var a=e.shared,i=e.current,o=a.current,f=a.gl;tn(Object.keys(r)).forEach((function(a){var u=r[a];if(!n||n(u)){var s=u.append(e,t);if(S[a]){var c=S[a];nn(u)?t(f,s?".enable(":".disable(",c,");"):t(e.cond(s).then(f,".enable(",c,");").else(f,".disable(",c,");")),t(o,".",a,"=",s,";")}else if(me(s)){var l=i[a];t(f,".",O[a],"(",s,");",s.map((function(e,t){return l+"["+t+"]="+e})).join(";"),";")}else t(f,".",O[a],"(",s,");",o,".",a,"=",s,";")}}))}function W(e,t){g&&(e.instancing=t.def(e.shared.extensions,".angle_instanced_arrays"))}function U(e,t,r,n,a){var i,o,f,u=e.shared,s=e.stats,c=u.current,l=u.timer,d=r.profile;function m(){return"undefined"==typeof performance?"Date.now()":"performance.now()"}function h(e){e(i=t.def(),"=",m(),";"),"string"==typeof a?e(s,".count+=",a,";"):e(s,".count++;"),p&&(n?e(o=t.def(),"=",l,".getNumPendingQueries();"):e(l,".beginQuery(",s,");"))}function b(e){e(s,".cpuTime+=",m(),"-",i,";"),p&&(n?e(l,".pushScopeStats(",o,",",l,".getNumPendingQueries(),",s,");"):e(l,".endQuery();"))}function v(e){var r=t.def(c,".profile");t(c,".profile=",e,";"),t.exit(c,".profile=",r,";")}if(d){if(nn(d))return void(d.enable?(h(t),b(t.exit),v("true")):v("false"));v(f=d.append(e,t))}else f=t.def(c,".profile");var g=e.block();h(g),t("if(",f,"){",g,"}");var y=e.block();b(y),t.exit("if(",f,"){",y,"}")}function G(e,t,r,n,a){var i=e.shared;n.forEach((function(n){var o,f=n.name,u=r.attributes[f];if(u){if(!a(u))return;o=u.append(e,t)}else{if(!a(fn))return;var s=e.scopeAttrib(f);_.optional((function(){e.assert(t,s+".state","missing attribute "+f)})),o={},Object.keys(new b).forEach((function(e){o[e]=t.def(s,".",e)}))}!function(r,n,a){var o=i.gl,f=t.def(r,".location"),u=t.def(i.attributes,"[",f,"]"),s=a.state,c=a.buffer,l=[a.x,a.y,a.z,a.w],d=["buffer","normalized","offset","stride"];function m(){t("if(!",u,".buffer){",o,".enableVertexAttribArray(",f,");}");var r,i=a.type;if(r=a.size?t.def(a.size,"||",n):n,t("if(",u,".type!==",i,"||",u,".size!==",r,"||",d.map((function(e){return u+"."+e+"!=="+a[e]})).join("||"),"){",o,".bindBuffer(",Sr,",",c,".buffer);",o,".vertexAttribPointer(",[f,r,i,a.normalized,a.stride,a.offset],");",u,".type=",i,";",u,".size=",r,";",d.map((function(e){return u+"."+e+"="+a[e]+";"})).join(""),"}"),g){var s=a.divisor;t("if(",u,".divisor!==",s,"){",e.instancing,".vertexAttribDivisorANGLE(",[f,s],");",u,".divisor=",s,";}")}}function p(){t("if(",u,".buffer){",o,".disableVertexAttribArray(",f,");",u,".buffer=null;","}if(",Bt.map((function(e,t){return u+"."+e+"!=="+l[t]})).join("||"),"){",o,".vertexAttrib4f(",f,",",l,");",Bt.map((function(e,t){return u+"."+e+"="+l[t]+";"})).join(""),"}")}1===s?m():2===s?p():(t("if(",s,"===",1,"){"),m(),t("}else{"),p(),t("}"))}(e.link(n),function(e){switch(e){case Tr:case zr:case Ir:return 2;case Dr:case Fr:case Pr:return 3;case jr:case Br:case Lr:return 4;default:return 1}}(n.info.type),o)}))}function H(e,t,n,a,i,o){for(var f,u=e.shared,s=u.gl,c={},l=0;l<a.length;++l){var d=a[l],m=d.name,p=d.info.type,h=d.info.size,b=n.uniforms[m];if(h>1){if(!b)continue;var v=m.replace("[0]","");if(c[v])continue;c[v]=1}var g,y=e.link(d)+".location";if(b){if(!i(b))continue;if(nn(b)){var x=b.value;if(_.command(null!=x,'missing uniform "'+m+'"',e.commandStr),p===Ur||p===Gr){_.command("function"==typeof x&&(p===Ur&&("texture2d"===x._reglType||"framebuffer"===x._reglType)||p===Gr&&("textureCube"===x._reglType||"framebufferCube"===x._reglType)),"invalid texture for uniform "+m,e.commandStr);var w=e.link(x._texture||x.color[0]._texture);t(s,".uniform1i(",y,",",w+".bind());"),t.exit(w,".unbind();")}else if(p===Rr||p===Mr||p===Wr){_.optional((function(){_.command(me(x),"invalid matrix for uniform "+m,e.commandStr),_.command(p===Rr&&4===x.length||p===Mr&&9===x.length||p===Wr&&16===x.length,"invalid length for matrix uniform "+m,e.commandStr)}));var A=e.global.def("new Float32Array(["+Array.prototype.slice.call(x)+"])"),k=2;p===Mr?k=3:p===Wr&&(k=4),t(s,".uniformMatrix",k,"fv(",y,",false,",A,");")}else{switch(p){case Er:1===h?_.commandType(x,"number","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1f";break;case Tr:_.command(me(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2f";break;case Dr:_.command(me(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3f";break;case jr:_.command(me(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4f";break;case Vr:1===h?_.commandType(x,"boolean","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Cr:1===h?_.commandType(x,"number","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Ir:case zr:_.command(me(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2i";break;case Pr:case Fr:_.command(me(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3i";break;case Lr:case Br:_.command(me(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4i"}h>1?(f+="v",x=e.global.def("["+Array.prototype.slice.call(x)+"]")):x=me(x)?Array.prototype.slice.call(x):x,t(s,".uniform",f,"(",y,",",x,");")}continue}g=b.append(e,t)}else{if(!i(fn))continue;g=t.def(u.uniforms,"[",r.id(m),"]")}p===Ur?(_(!Array.isArray(g),"must specify a scalar prop for textures"),t("if(",g,"&&",g,'._reglType==="framebuffer"){',g,"=",g,".color[0];","}")):p===Gr&&(_(!Array.isArray(g),"must specify a scalar prop for cube maps"),t("if(",g,"&&",g,'._reglType==="framebufferCube"){',g,"=",g,".color[0];","}")),_.optional((function(){function r(r,n){e.assert(t,r,'bad data or missing for uniform "'+m+'".  '+n)}function n(e,t){1===t&&_(!Array.isArray(g),"must not specify an array type for uniform"),r("Array.isArray("+g+") && typeof "+g+'[0]===" '+e+'" || typeof '+g+'==="'+e+'"',"invalid type, expected "+e)}function a(t,n,a){Array.isArray(g)?_(g.length&&g.length%t==0&&g.length<=t*a,"must have length of "+(1===a?"":"n * ")+t):r(u.isArrayLike+"("+g+")&&"+g+".length && "+g+".length % "+t+" === 0 && "+g+".length<="+t*a,"invalid vector, should have length of "+(1===a?"":"n * ")+t,e.commandStr)}function i(t){_(!Array.isArray(g),"must not specify a value type"),r("typeof "+g+'==="function"&&'+g+'._reglType==="texture'+(3553===t?"2d":"Cube")+'"',"invalid texture type",e.commandStr)}switch(p){case Cr:n("number",h);break;case zr:a(2,0,h);break;case Fr:a(3,0,h);break;case Br:a(4,0,h);break;case Er:n("number",h);break;case Tr:a(2,0,h);break;case Dr:a(3,0,h);break;case jr:a(4,0,h);break;case Vr:n("boolean",h);break;case Ir:a(2,0,h);break;case Pr:a(3,0,h);break;case Lr:case Rr:a(4,0,h);break;case Mr:a(9,0,h);break;case Wr:a(16,0,h);break;case Ur:i(3553);break;case Gr:i(34067)}}));var S=1;switch(p){case Ur:case Gr:var O=t.def(g,"._texture");t(s,".uniform1i(",y,",",O,".bind());"),t.exit(O,".unbind();");continue;case Cr:case Vr:f="1i";break;case zr:case Ir:f="2i",S=2;break;case Fr:case Pr:f="3i",S=3;break;case Br:case Lr:f="4i",S=4;break;case Er:f="1f";break;case Tr:f="2f",S=2;break;case Dr:f="3f",S=3;break;case jr:f="4f",S=4;break;case Rr:f="Matrix2fv";break;case Mr:f="Matrix3fv";break;case Wr:f="Matrix4fv"}if(-1===f.indexOf("Matrix")&&h>1&&(f+="v",S=1),"M"===f.charAt(0)){t(s,".uniform",f,"(",y,",");var E=Math.pow(p-Rr+2,2),T=e.global.def("new Float32Array(",E,")");Array.isArray(g)?t("false,(",V(E,(function(e){return T+"["+e+"]="+g[e]})),",",T,")"):t("false,(Array.isArray(",g,")||",g," instanceof Float32Array)?",g,":(",V(E,(function(e){return T+"["+e+"]="+g+"["+e+"]"})),",",T,")"),t(");")}else if(S>1){for(var D=[],j=[],C=0;C<S;++C)Array.isArray(g)?j.push(g[C]):j.push(t.def(g+"["+C+"]")),o&&D.push(t.def());o&&t("if(!",e.batchId,"||",D.map((function(e,t){return e+"!=="+j[t]})).join("||"),"){",D.map((function(e,t){return e+"="+j[t]+";"})).join("")),t(s,".uniform",f,"(",y,",",j.join(","),");"),o&&t("}")}else{if(_(!Array.isArray(g),"uniform value must not be an array"),o){var z=t.def();t("if(!",e.batchId,"||",z,"!==",g,"){",z,"=",g,";")}t(s,".uniform",f,"(",y,",",g,");"),o&&t("}")}}}function N(e,t,r,n){var a=e.shared,i=a.gl,o=a.draw,f=n.draw,u=function(){var u,s=f.elements,c=t;return s?((s.contextDep&&n.contextDynamic||s.propDep)&&(c=r),u=s.append(e,c),f.elementsActive&&c("if("+u+")"+i+".bindBuffer(34963,"+u+".buffer.buffer);")):(u=c.def(),c(u,"=",o,".",dr,";","if(",u,"){",i,".bindBuffer(",Or,",",u,".buffer.buffer);}","else if(",a.vao,".currentVAO){",u,"=",e.shared.elements+".getElements("+a.vao,".currentVAO.elements);",x?"":"if("+u+")"+i+".bindBuffer(34963,"+u+".buffer.buffer);","}")),u}();function s(a){var i=f[a];return i?i.contextDep&&n.contextDynamic||i.propDep?i.append(e,r):i.append(e,t):t.def(o,".",a)}var c,l,d=s(mr),m=s(hr),p=function(){var a,i=f.count,u=t;return i?((i.contextDep&&n.contextDynamic||i.propDep)&&(u=r),a=i.append(e,u),_.optional((function(){i.MISSING&&e.assert(t,"false","missing vertex count"),i.DYNAMIC&&e.assert(u,a+">=0","missing vertex count")}))):(a=u.def(o,".",pr),_.optional((function(){e.assert(u,a+">=0","missing vertex count")}))),a}();if("number"==typeof p){if(0===p)return}else r("if(",p,"){"),r.exit("}");g&&(c=s(br),l=e.instancing);var h=u+".type",b=f.elements&&nn(f.elements)&&!f.vaoActive;function v(){function e(){r(l,".drawElementsInstancedANGLE(",[d,p,h,m+"<<(("+h+"-5121)>>1)",c],");")}function t(){r(l,".drawArraysInstancedANGLE(",[d,m,p,c],");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}function y(){function e(){r(i+".drawElements("+[d,p,h,m+"<<(("+h+"-5121)>>1)"]+");")}function t(){r(i+".drawArrays("+[d,m,p]+");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}g&&("number"!=typeof c||c>=0)?"string"==typeof c?(r("if(",c,">0){"),v(),r("}else if(",c,"<0){"),y(),r("}")):v():y()}function q(e,t,r,n,a){var i=B(),o=i.proc("body",a);return _.optional((function(){i.commandStr=t.commandStr,i.command=i.link(t.commandStr)})),g&&(i.instancing=o.def(i.shared.extensions,".angle_instanced_arrays")),e(i,o,r,n),i.compile().body}function Q(e,t,r,n){W(e,t),r.useVAO?r.drawVAO?t(e.shared.vao,".setVAO(",r.drawVAO.append(e,t),");"):t(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(t(e.shared.vao,".setVAO(null);"),G(e,t,r,n.attributes,(function(){return!0}))),H(e,t,r,n.uniforms,(function(){return!0}),!1),N(e,t,t,r)}function Y(e,t,r,n){function a(){return!0}e.batchId="a1",W(e,t),G(e,t,r,n.attributes,a),H(e,t,r,n.uniforms,a,!1),N(e,t,t,r)}function $(e,t,r,n){W(e,t);var a=r.contextDep,i=t.def(),o=t.def();e.shared.props=o,e.batchId=i;var f=e.scope(),u=e.scope();function s(e){return e.contextDep&&a||e.propDep}function c(e){return!s(e)}if(t(f.entry,"for(",i,"=0;",i,"<","a1",";++",i,"){",o,"=","a0","[",i,"];",u,"}",f.exit),r.needsContext&&P(e,u,r.context),r.needsFramebuffer&&L(e,u,r.framebuffer),M(e,u,r.state,s),r.profile&&s(r.profile)&&U(e,u,r,!1,!0),n)r.useVAO?r.drawVAO?s(r.drawVAO)?u(e.shared.vao,".setVAO(",r.drawVAO.append(e,u),");"):f(e.shared.vao,".setVAO(",r.drawVAO.append(e,f),");"):f(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(f(e.shared.vao,".setVAO(null);"),G(e,f,r,n.attributes,c),G(e,u,r,n.attributes,s)),H(e,f,r,n.uniforms,c,!1),H(e,u,r,n.uniforms,s,!0),N(e,f,u,r);else{var l=e.global.def("{}"),d=r.shader.progVar.append(e,u),m=u.def(d,".id"),p=u.def(l,"[",m,"]");u(e.shared.gl,".useProgram(",d,".program);","if(!",p,"){",p,"=",l,"[",m,"]=",e.link((function(t){return q(Y,e,r,t,2)})),"(",d,");}",p,".call(this,a0[",i,"],",i,");")}}function K(e,t,r){var n=t.static[r];if(n&&function(e){if("object"==typeof e&&!me(e)){for(var t=Object.keys(e),r=0;r<t.length;++r)if(D.isDynamic(e[t[r]]))return!0;return!1}}(n)){var a=e.global,i=Object.keys(n),o=!1,f=!1,u=!1,s=e.global.def("{}");i.forEach((function(t){var r=n[t];if(D.isDynamic(r)){"function"==typeof r&&(r=n[t]=D.unbox(r));var i=on(r,null);o=o||i.thisDep,u=u||i.propDep,f=f||i.contextDep}else{switch(a(s,".",t,"="),typeof r){case"number":a(r);break;case"string":a('"',r,'"');break;case"object":Array.isArray(r)&&a("[",r.join(),"]");break;default:a(e.link(r))}a(";")}})),t.dynamic[r]=new D.DynamicVariable(4,{thisDep:o,contextDep:f,propDep:u,ref:s,append:function(e,t){i.forEach((function(r){var a=n[r];if(D.isDynamic(a)){var i=e.invoke(t,a);t(s,".",r,"=",i,";")}}))}}),delete t.static[r]}}return{next:A,current:w,procs:function(){var e=B(),t=e.proc("poll"),r=e.proc("refresh"),i=e.block();t(i),r(i);var o,f=e.shared,u=f.gl,s=f.next,c=f.current;i(c,".dirty=false;"),L(e,t),L(e,r,null,!0),g&&(o=e.link(g)),n.oes_vertex_array_object&&r(e.link(n.oes_vertex_array_object),".bindVertexArrayOES(null);");for(var l=0;l<a.maxAttributes;++l){var d=r.def(f.attributes,"[",l,"]"),m=e.cond(d,".buffer");m.then(u,".enableVertexAttribArray(",l,");",u,".bindBuffer(",Sr,",",d,".buffer.buffer);",u,".vertexAttribPointer(",l,",",d,".size,",d,".type,",d,".normalized,",d,".stride,",d,".offset);").else(u,".disableVertexAttribArray(",l,");",u,".vertexAttrib4f(",l,",",d,".x,",d,".y,",d,".z,",d,".w);",d,".buffer=null;"),r(m),g&&r(o,".vertexAttribDivisorANGLE(",l,",",d,".divisor);")}return r(e.shared.vao,".currentVAO=null;",e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"),Object.keys(S).forEach((function(n){var a=S[n],o=i.def(s,".",n),f=e.block();f("if(",o,"){",u,".enable(",a,")}else{",u,".disable(",a,")}",c,".",n,"=",o,";"),r(f),t("if(",o,"!==",c,".",n,"){",f,"}")})),Object.keys(O).forEach((function(n){var a,o,f=O[n],l=w[n],d=e.block();if(d(u,".",f,"("),me(l)){var m=l.length;a=e.global.def(s,".",n),o=e.global.def(c,".",n),d(V(m,(function(e){return a+"["+e+"]"})),");",V(m,(function(e){return o+"["+e+"]="+a+"["+e+"];"})).join("")),t("if(",V(m,(function(e){return a+"["+e+"]!=="+o+"["+e+"]"})).join("||"),"){",d,"}")}else a=i.def(s,".",n),o=i.def(c,".",n),d(a,");",c,".",n,"=",a,";"),t("if(",a,"!==",o,"){",d,"}");r(d)})),e.compile()}(),compile:function(e,n,a,i,o){var f=B();f.stats=f.link(o),Object.keys(n.static).forEach((function(e){K(f,n,e)})),kr.forEach((function(t){K(f,e,t)}));var u=I(e,n,a,i,f);return function(e,t){var r=e.proc("draw",1);W(e,r),P(e,r,t.context),L(e,r,t.framebuffer),R(e,r,t),M(e,r,t.state),U(e,r,t,!1,!0);var n=t.shader.progVar.append(e,r);if(r(e.shared.gl,".useProgram(",n,".program);"),t.shader.program)Q(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var a=e.global.def("{}"),i=r.def(n,".id"),o=r.def(a,"[",i,"]");r(e.cond(o).then(o,".call(this,a0);").else(o,"=",a,"[",i,"]=",e.link((function(r){return q(Q,e,t,r,1)})),"(",n,");",o,".call(this,a0);"))}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),function(e,t){var n=e.proc("scope",3);e.batchId="a2";var a=e.shared,i=a.current;function o(r){var i=t.shader[r];i&&n.set(a.shader,"."+r,i.append(e,n))}P(e,n,t.context),t.framebuffer&&t.framebuffer.append(e,n),tn(Object.keys(t.state)).forEach((function(r){var i=t.state[r].append(e,n);me(i)?i.forEach((function(t,a){n.set(e.next[r],"["+a+"]",t)})):n.set(a.next,"."+r,i)})),U(e,n,t,!0,!0),[dr,hr,pr,br,mr].forEach((function(r){var i=t.draw[r];i&&n.set(a.draw,"."+r,""+i.append(e,n))})),Object.keys(t.uniforms).forEach((function(i){var o=t.uniforms[i].append(e,n);Array.isArray(o)&&(o="["+o.join()+"]"),n.set(a.uniforms,"["+r.id(i)+"]",o)})),Object.keys(t.attributes).forEach((function(r){var a=t.attributes[r].append(e,n),i=e.scopeAttrib(r);Object.keys(new b).forEach((function(e){n.set(i,"."+e,a[e])}))})),t.scopeVAO&&n.set(a.vao,".targetVAO",t.scopeVAO.append(e,n)),o(cr),o(lr),Object.keys(t.state).length>0&&(n(i,".dirty=true;"),n.exit(i,".dirty=true;")),n("a1(",e.shared.context,",a0,",e.batchId,");")}(f,u),function(e,t){var r=e.proc("batch",2);e.batchId="0",W(e,r);var n=!1,a=!0;Object.keys(t.context).forEach((function(e){n=n||t.context[e].propDep})),n||(P(e,r,t.context),a=!1);var i=t.framebuffer,o=!1;function f(e){return e.contextDep&&n||e.propDep}i?(i.propDep?n=o=!0:i.contextDep&&n&&(o=!0),o||L(e,r,i)):L(e,r,null),t.state.viewport&&t.state.viewport.propDep&&(n=!0),R(e,r,t),M(e,r,t.state,(function(e){return!f(e)})),t.profile&&f(t.profile)||U(e,r,t,!1,"a1"),t.contextDep=n,t.needsContext=a,t.needsFramebuffer=o;var u=t.shader.progVar;if(u.contextDep&&n||u.propDep)$(e,r,t,null);else{var s=u.append(e,r);if(r(e.shared.gl,".useProgram(",s,".program);"),t.shader.program)$(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var c=e.global.def("{}"),l=r.def(s,".id"),d=r.def(c,"[",l,"]");r(e.cond(d).then(d,".call(this,a0,a1);").else(d,"=",c,"[",l,"]=",e.link((function(r){return q($,e,t,r,2)})),"(",s,");",d,".call(this,a0,a1);"))}}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),t(f.compile(),{destroy:function(){u.shader.program.destroy()}})}}}var sn=function(e,t){if(!t.ext_disjoint_timer_query)return null;var r=[];function n(e){r.push(e)}var a=[];function i(){this.startQueryIndex=-1,this.endQueryIndex=-1,this.sum=0,this.stats=null}var o=[];function f(e){o.push(e)}var u=[];function s(e,t,r){var n=o.pop()||new i;n.startQueryIndex=e,n.endQueryIndex=t,n.sum=0,n.stats=r,u.push(n)}var c=[],l=[];return{beginQuery:function(e){var n=r.pop()||t.ext_disjoint_timer_query.createQueryEXT();t.ext_disjoint_timer_query.beginQueryEXT(35007,n),a.push(n),s(a.length-1,a.length,e)},endQuery:function(){t.ext_disjoint_timer_query.endQueryEXT(35007)},pushScopeStats:s,update:function(){var e,r,i=a.length;if(0!==i){l.length=Math.max(l.length,i+1),c.length=Math.max(c.length,i+1),c[0]=0,l[0]=0;var o=0;for(e=0,r=0;r<a.length;++r){var s=a[r];t.ext_disjoint_timer_query.getQueryObjectEXT(s,34919)?(o+=t.ext_disjoint_timer_query.getQueryObjectEXT(s,34918),n(s)):a[e++]=s,c[r+1]=o,l[r+1]=e}for(a.length=e,e=0,r=0;r<u.length;++r){var d=u[r],m=d.startQueryIndex,p=d.endQueryIndex;d.sum+=c[p]-c[m];var h=l[m],b=l[p];b===h?(d.stats.gpuTime+=d.sum/1e6,f(d)):(d.startQueryIndex=h,d.endQueryIndex=b,u[e++]=d)}u.length=e}},getNumPendingQueries:function(){return a.length},clear:function(){r.push.apply(r,a);for(var e=0;e<r.length;e++)t.ext_disjoint_timer_query.deleteQueryEXT(r[e]);a.length=0,r.length=0},restore:function(){a.length=0,r.length=0}}},cn="webglcontextlost",ln="webglcontextrestored";function dn(e,t){for(var r=0;r<e.length;++r)if(e[r]===t)return r;return-1}return function(r){var n=B(r);if(!n)return null;var a=n.gl,i=a.getContextAttributes(),o=a.isContextLost(),f=function(e,t){var r={};function n(t){_.type(t,"string","extension name must be string");var n,a=t.toLowerCase();try{n=r[a]=e.getExtension(a)}catch(e){}return!!n}for(var a=0;a<t.extensions.length;++a){var i=t.extensions[a];if(!n(i))return t.onDestroy(),t.onDone('"'+i+'" extension is not supported by the current WebGL context, try upgrading your system or a different browser'),null}return t.optionalExtensions.forEach(n),{extensions:r,restore:function(){Object.keys(r).forEach((function(e){if(r[e]&&!n(e))throw new Error("(regl): error restoring extension "+e)}))}}}(a,n);if(!f)return null;var u,s,c=(u={"":0},s=[""],{id:function(e){var t=u[e];return t||(t=u[e]=s.length,s.push(e),t)},str:function(e){return s[e]}}),l={vaoCount:0,bufferCount:0,elementsCount:0,framebufferCount:0,shaderCount:0,textureCount:0,cubeCount:0,renderbufferCount:0,maxTextureUnits:0},d=f.extensions,m=sn(0,d),p=C(),h=a.drawingBufferWidth,b=a.drawingBufferHeight,v={tick:0,time:0,viewportWidth:h,viewportHeight:b,framebufferWidth:h,framebufferHeight:b,drawingBufferWidth:h,drawingBufferHeight:b,pixelRatio:n.pixelRatio},g={elements:null,primitive:4,count:-1,offset:0,instances:-1},y=function(e,t){var r=1;t.ext_texture_filter_anisotropic&&(r=e.getParameter(34047));var n=1,a=1;t.webgl_draw_buffers&&(n=e.getParameter(34852),a=e.getParameter(36063));var i=!!t.oes_texture_float;if(i){var o=e.createTexture();e.bindTexture(R,o),e.texImage2D(R,0,M,1,1,0,M,W,null);var f=e.createFramebuffer();if(e.bindFramebuffer(U,f),e.framebufferTexture2D(U,36064,R,o,0),e.bindTexture(R,null),36053!==e.checkFramebufferStatus(U))i=!1;else{e.viewport(0,0,1,1),e.clearColor(1,0,0,1),e.clear(16384);var u=L.allocType(W,4);e.readPixels(0,0,1,1,M,W,u),e.getError()?i=!1:(e.deleteFramebuffer(f),e.deleteTexture(o),i=1===u[0]),L.freeType(u)}}var s=!0;if("undefined"==typeof navigator||!(/MSIE/.test(navigator.userAgent)||/Trident\//.test(navigator.appVersion)||/Edge/.test(navigator.userAgent))){var c=e.createTexture(),l=L.allocType(5121,36);e.activeTexture(33984),e.bindTexture(34067,c),e.texImage2D(34069,0,M,3,3,0,M,5121,l),L.freeType(l),e.bindTexture(34067,null),e.deleteTexture(c),s=!e.getError()}return{colorBits:[e.getParameter(3410),e.getParameter(3411),e.getParameter(3412),e.getParameter(3413)],depthBits:e.getParameter(3414),stencilBits:e.getParameter(3415),subpixelBits:e.getParameter(3408),extensions:Object.keys(t).filter((function(e){return!!t[e]})),maxAnisotropic:r,maxDrawbuffers:n,maxColorAttachments:a,pointSizeDims:e.getParameter(33901),lineWidthDims:e.getParameter(33902),maxViewportDims:e.getParameter(3386),maxCombinedTextureUnits:e.getParameter(35661),maxCubeMapSize:e.getParameter(34076),maxRenderbufferSize:e.getParameter(34024),maxTextureUnits:e.getParameter(34930),maxTextureSize:e.getParameter(3379),maxAttributes:e.getParameter(34921),maxVertexUniforms:e.getParameter(36347),maxVertexTextureUnits:e.getParameter(35660),maxVaryingVectors:e.getParameter(36348),maxFragmentUniforms:e.getParameter(36349),glsl:e.getParameter(35724),renderer:e.getParameter(7937),vendor:e.getParameter(7936),version:e.getParameter(7938),readFloat:i,npotTextureCube:s}}(a,d),x=function(t,r,n,a){var i=0,o={};function f(e){this.id=i++,this.buffer=t.createBuffer(),this.type=e,this.usage=35044,this.byteLength=0,this.dimension=1,this.dtype=Z,this.persistentData=null,n.profile&&(this.stats={size:0})}f.prototype.bind=function(){t.bindBuffer(this.type,this.buffer)},f.prototype.destroy=function(){l(this)};var u=[];function s(e,r,n){e.byteLength=r.byteLength,t.bufferData(e.type,r,n)}function c(t,r,n,a,i,o){var f,u;if(t.usage=n,Array.isArray(r)){if(t.dtype=a||ee,r.length>0)if(Array.isArray(r[0])){f=J(r);for(var c=1,l=1;l<f.length;++l)c*=f[l];t.dimension=c,s(t,u=K(r,f,t.dtype),n),o?t.persistentData=u:L.freeType(u)}else if("number"==typeof r[0]){t.dimension=i;var d=L.allocType(t.dtype,r.length);ne(d,r),s(t,d,n),o?t.persistentData=d:L.freeType(d)}else e(r[0])?(t.dimension=r[0].length,t.dtype=a||re(r[0])||ee,s(t,u=K(r,[r.length,r[0].length],t.dtype),n),o?t.persistentData=u:L.freeType(u)):_.raise("invalid buffer data")}else if(e(r))t.dtype=a||re(r),t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r.buffer)));else if(G(r)){f=r.shape;var m=r.stride,p=r.offset,h=0,b=0,v=0,g=0;1===f.length?(h=f[0],b=1,v=m[0],g=0):2===f.length?(h=f[0],b=f[1],v=m[0],g=m[1]):_.raise("invalid shape"),t.dtype=a||re(r.data)||ee,t.dimension=b;var y=L.allocType(t.dtype,h*b);ae(y,r.data,h,b,v,g,p),s(t,y,n),o?t.persistentData=y:L.freeType(y)}else r instanceof ArrayBuffer?(t.dtype=Z,t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r)))):_.raise("invalid buffer data")}function l(e){r.bufferCount--,a(e);var n=e.buffer;_(n,"buffer must not be deleted already"),t.deleteBuffer(n),e.buffer=null,delete o[e.id]}return n.profile&&(r.getTotalBufferSize=function(){var e=0;return Object.keys(o).forEach((function(t){e+=o[t].stats.size})),e}),{create:function(a,i,u,s){r.bufferCount++;var d=new f(i);function m(r){var a=35044,i=null,o=0,f=0,u=1;return Array.isArray(r)||e(r)||G(r)||r instanceof ArrayBuffer?i=r:"number"==typeof r?o=0|r:r&&(_.type(r,"object","buffer arguments must be an object, a number or an array"),"data"in r&&(_(null===i||Array.isArray(i)||e(i)||G(i),"invalid data for buffer"),i=r.data),"usage"in r&&(_.parameter(r.usage,$,"invalid buffer usage"),a=$[r.usage]),"type"in r&&(_.parameter(r.type,X,"invalid buffer type"),f=X[r.type]),"dimension"in r&&(_.type(r.dimension,"number","invalid dimension"),u=0|r.dimension),"length"in r&&(_.nni(o,"buffer length must be a nonnegative integer"),o=0|r.length)),d.bind(),i?c(d,i,a,f,u,s):(o&&t.bufferData(d.type,o,a),d.dtype=f||Z,d.usage=a,d.dimension=u,d.byteLength=o),n.profile&&(d.stats.size=d.byteLength*te[d.dtype]),m}function p(e,r){_(r+e.byteLength<=d.byteLength,"invalid buffer subdata call, buffer is too small.  Can't write data of size "+e.byteLength+" starting from offset "+r+" to a buffer of size "+d.byteLength),t.bufferSubData(d.type,r,e)}return o[d.id]=d,u||m(a),m._reglType="buffer",m._buffer=d,m.subdata=function(t,r){var n,a=0|(r||0);if(d.bind(),e(t)||t instanceof ArrayBuffer)p(t,a);else if(Array.isArray(t)){if(t.length>0)if("number"==typeof t[0]){var i=L.allocType(d.dtype,t.length);ne(i,t),p(i,a),L.freeType(i)}else if(Array.isArray(t[0])||e(t[0])){n=J(t);var o=K(t,n,d.dtype);p(o,a),L.freeType(o)}else _.raise("invalid buffer data")}else if(G(t)){n=t.shape;var f=t.stride,u=0,s=0,c=0,l=0;1===n.length?(u=n[0],s=1,c=f[0],l=0):2===n.length?(u=n[0],s=n[1],c=f[0],l=f[1]):_.raise("invalid shape");var h=Array.isArray(t.data)?d.dtype:re(t.data),b=L.allocType(h,u*s);ae(b,t.data,u,s,c,l,t.offset),p(b,a),L.freeType(b)}else _.raise("invalid data for buffer subdata");return m},n.profile&&(m.stats=d.stats),m.destroy=function(){l(d)},m},createStream:function(e,t){var r=u.pop();return r||(r=new f(e)),r.bind(),c(r,t,35040,0,1,!1),r},destroyStream:function(e){u.push(e)},clear:function(){H(o).forEach(l),u.forEach(l)},getBuffer:function(e){return e&&e._buffer instanceof f?e._buffer:null},restore:function(){H(o).forEach((function(e){e.buffer=t.createBuffer(),t.bindBuffer(e.type,e.buffer),t.bufferData(e.type,e.persistentData||e.byteLength,e.usage)}))},_initBuffer:c}}(a,l,n,(function(e){return A.destroyBuffer(e)})),w=function(t,r,n,a){var i={},o=0,f={uint8:oe,uint16:fe};function u(e){this.id=o++,i[this.id]=this,this.buffer=e,this.primType=4,this.vertCount=0,this.type=0}r.oes_element_index_uint&&(f.uint32=ue),u.prototype.bind=function(){this.buffer.bind()};var s=[];function c(a,i,o,f,u,s,c){var l;if(a.buffer.bind(),i){var d=c;c||e(i)&&(!G(i)||e(i.data))||(d=r.oes_element_index_uint?ue:fe),n._initBuffer(a.buffer,i,o,d,3)}else t.bufferData(se,s,o),a.buffer.dtype=l||oe,a.buffer.usage=o,a.buffer.dimension=3,a.buffer.byteLength=s;if(l=c,!c){switch(a.buffer.dtype){case oe:case 5120:l=oe;break;case fe:case 5122:l=fe;break;case ue:case 5124:l=ue;break;default:_.raise("unsupported type for element array")}a.buffer.dtype=l}a.type=l,_(l!==ue||!!r.oes_element_index_uint,"32 bit element buffers not supported, enable oes_element_index_uint first");var m=u;m<0&&(m=a.buffer.byteLength,l===fe?m>>=1:l===ue&&(m>>=2)),a.vertCount=m;var p=f;if(f<0){p=4;var h=a.buffer.dimension;1===h&&(p=0),2===h&&(p=1),3===h&&(p=4)}a.primType=p}function l(e){a.elementsCount--,_(null!==e.buffer,"must not double destroy elements"),delete i[e.id],e.buffer.destroy(),e.buffer=null}return{create:function(t,r){var i=n.create(null,se,!0),o=new u(i._buffer);function s(t){if(t)if("number"==typeof t)i(t),o.primType=4,o.vertCount=0|t,o.type=oe;else{var r=null,n=35044,a=-1,u=-1,l=0,d=0;Array.isArray(t)||e(t)||G(t)?r=t:(_.type(t,"object","invalid arguments for elements"),"data"in t&&(r=t.data,_(Array.isArray(r)||e(r)||G(r),"invalid data for element buffer")),"usage"in t&&(_.parameter(t.usage,$,"invalid element buffer usage"),n=$[t.usage]),"primitive"in t&&(_.parameter(t.primitive,ie,"invalid element buffer primitive"),a=ie[t.primitive]),"count"in t&&(_("number"==typeof t.count&&t.count>=0,"invalid vertex count for elements"),u=0|t.count),"type"in t&&(_.parameter(t.type,f,"invalid buffer type"),d=f[t.type]),"length"in t?l=0|t.length:(l=u,d===fe||5122===d?l*=2:d!==ue&&5124!==d||(l*=4))),c(o,r,n,a,u,l,d)}else i(),o.primType=4,o.vertCount=0,o.type=oe;return s}return a.elementsCount++,s(t),s._reglType="elements",s._elements=o,s.subdata=function(e,t){return i.subdata(e,t),s},s.destroy=function(){l(o)},s},createStream:function(e){var t=s.pop();return t||(t=new u(n.create(null,se,!0,!1)._buffer)),c(t,e,35040,-1,-1,0,0),t},destroyStream:function(e){s.push(e)},getElements:function(e){return"function"==typeof e&&e._elements instanceof u?e._elements:null},clear:function(){H(i).forEach(l)}}}(a,d,x,l),A=function(t,r,n,a,i,o,f){for(var u=n.maxAttributes,s=new Array(u),c=0;c<u;++c)s[c]=new Tt;var l=0,d={},m={Record:Tt,scope:{},state:s,currentVAO:null,targetVAO:null,restore:p()?function(){p()&&H(d).forEach((function(e){e.refresh()}))}:function(){},createVAO:function(t){var n=new b;function f(t){var a;if(Array.isArray(t))a=t,n.elements&&n.ownsElements&&n.elements.destroy(),n.elements=null,n.ownsElements=!1,n.offset=0,n.count=0,n.instances=-1,n.primitive=4;else{if(_("object"==typeof t,"invalid arguments for create vao"),_("attributes"in t,"must specify attributes for vao"),t.elements){var s=t.elements;n.ownsElements?"function"==typeof s&&"elements"===s._reglType?(n.elements.destroy(),n.ownsElements=!1):(n.elements(s),n.ownsElements=!1):o.getElements(t.elements)?(n.elements=t.elements,n.ownsElements=!1):(n.elements=o.create(t.elements),n.ownsElements=!0)}else n.elements=null,n.ownsElements=!1;a=t.attributes,n.offset=0,n.count=-1,n.instances=-1,n.primitive=4,n.elements&&(n.count=n.elements._elements.vertCount,n.primitive=n.elements._elements.primType),"offset"in t&&(n.offset=0|t.offset),"count"in t&&(n.count=0|t.count),"instances"in t&&(n.instances=0|t.instances),"primitive"in t&&(_(t.primitive in ie,"bad primitive type: "+t.primitive),n.primitive=ie[t.primitive]),_.optional((()=>{for(var e=Object.keys(t),r=0;r<e.length;++r)_(Et.indexOf(e[r])>=0,'invalid option for vao: "'+e[r]+'" valid options are '+Et)})),_(Array.isArray(a),"attributes must be an array")}_(a.length<u,"too many attributes"),_(a.length>0,"must specify at least one attribute");var c={},l=n.attributes;l.length=a.length;for(var d=0;d<a.length;++d){var m,p=a[d],h=l[d]=new Tt,b=p.data||p;Array.isArray(b)||e(b)||G(b)?(n.buffers[d]&&(m=n.buffers[d],e(b)&&m._buffer.byteLength>=b.byteLength?m.subdata(b):(m.destroy(),n.buffers[d]=null)),n.buffers[d]||(m=n.buffers[d]=i.create(p,34962,!1,!0)),h.buffer=i.getBuffer(m),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1,c[d]=1):i.getBuffer(p)?(h.buffer=i.getBuffer(p),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1):i.getBuffer(p.buffer)?(h.buffer=i.getBuffer(p.buffer),h.size=0|(+p.size||h.buffer.dimension),h.normalized=!!p.normalized||!1,"type"in p?(_.parameter(p.type,X,"invalid buffer type"),h.type=X[p.type]):h.type=h.buffer.dtype,h.offset=0|(p.offset||0),h.stride=0|(p.stride||0),h.divisor=0|(p.divisor||0),h.state=1,_(h.size>=1&&h.size<=4,"size must be between 1 and 4"),_(h.offset>=0,"invalid offset"),_(h.stride>=0&&h.stride<=255,"stride must be between 0 and 255"),_(h.divisor>=0,"divisor must be positive"),_(!h.divisor||!!r.angle_instanced_arrays,"ANGLE_instanced_arrays must be enabled to use divisor")):"x"in p?(_(d>0,"first attribute must not be a constant"),h.x=+p.x||0,h.y=+p.y||0,h.z=+p.z||0,h.w=+p.w||0,h.state=2):_(!1,"invalid attribute spec for location "+d)}for(var v=0;v<n.buffers.length;++v)!c[v]&&n.buffers[v]&&(n.buffers[v].destroy(),n.buffers[v]=null);return n.refresh(),f}return a.vaoCount+=1,f.destroy=function(){for(var e=0;e<n.buffers.length;++e)n.buffers[e]&&n.buffers[e].destroy();n.buffers.length=0,n.ownsElements&&(n.elements.destroy(),n.elements=null,n.ownsElements=!1),n.destroy()},f._vao=n,f._reglType="vao",f(t)},getVAO:function(e){return"function"==typeof e&&e._vao?e._vao:null},destroyBuffer:function(e){for(var r=0;r<s.length;++r){var n=s[r];n.buffer===e&&(t.disableVertexAttribArray(r),n.buffer=null)}},setVAO:p()?function(e){if(e!==m.currentVAO){var t=p();e?t.bindVertexArrayOES(e.vao):t.bindVertexArrayOES(null),m.currentVAO=e}}:function(e){if(e!==m.currentVAO){if(e)e.bindAttrs();else{for(var r=h(),n=0;n<s.length;++n){var a=s[n];a.buffer?(t.enableVertexAttribArray(n),a.buffer.bind(),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offfset),r&&a.divisor&&r.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}f.elements?t.bindBuffer(Ot,f.elements.buffer.buffer):t.bindBuffer(Ot,null)}m.currentVAO=e}},clear:p()?function(){H(d).forEach((function(e){e.destroy()}))}:function(){}};function p(){return r.oes_vertex_array_object}function h(){return r.angle_instanced_arrays}function b(){this.id=++l,this.attributes=[],this.elements=null,this.ownsElements=!1,this.count=0,this.offset=0,this.instances=-1,this.primitive=4;var e=p();this.vao=e?e.createVertexArrayOES():null,d[this.id]=this,this.buffers=[]}return b.prototype.bindAttrs=function(){for(var e=h(),r=this.attributes,n=0;n<r.length;++n){var a=r[n];a.buffer?(t.enableVertexAttribArray(n),t.bindBuffer(34962,a.buffer.buffer),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offset),e&&a.divisor&&e.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}for(var i=r.length;i<u;++i)t.disableVertexAttribArray(i);var f=o.getElements(this.elements);f?t.bindBuffer(Ot,f.buffer.buffer):t.bindBuffer(Ot,null)},b.prototype.refresh=function(){var e=p();e&&(e.bindVertexArrayOES(this.vao),this.bindAttrs(),m.currentVAO=null,e.bindVertexArrayOES(null))},b.prototype.destroy=function(){if(this.vao){var e=p();this===m.currentVAO&&(m.currentVAO=null,e.bindVertexArrayOES(null)),e.deleteVertexArrayOES(this.vao),this.vao=null}this.ownsElements&&(this.elements.destroy(),this.elements=null,this.ownsElements=!1),d[this.id]&&(delete d[this.id],a.vaoCount-=1)},m}(a,d,y,l,x,w,g),k=function(e,r,n,a){var i={},o={};function f(e,t,r,n){this.name=e,this.id=t,this.location=r,this.info=n}function u(e,t){for(var r=0;r<e.length;++r)if(e[r].id===t.id)return void(e[r].location=t.location);e.push(t)}function s(t,n,a){var f=35632===t?i:o,u=f[n];if(!u){var s=r.str(n);u=e.createShader(t),e.shaderSource(u,s),e.compileShader(u),_.shaderError(e,u,s,t,a),f[n]=u}return u}var c={},l=[],d=0;function m(e,t){this.id=d++,this.fragId=e,this.vertId=t,this.program=null,this.uniforms=[],this.attributes=[],this.refCount=1,a.profile&&(this.stats={uniformsCount:0,attributesCount:0})}function p(t,n,i){var o,c,l=s(35632,t.fragId),d=s(35633,t.vertId),m=t.program=e.createProgram();if(e.attachShader(m,l),e.attachShader(m,d),i)for(o=0;o<i.length;++o){var p=i[o];e.bindAttribLocation(m,p[0],p[1])}e.linkProgram(m),_.linkError(e,m,r.str(t.fragId),r.str(t.vertId),n);var h=e.getProgramParameter(m,35718);a.profile&&(t.stats.uniformsCount=h);var b=t.uniforms;for(o=0;o<h;++o)if(c=e.getActiveUniform(m,o)){if(c.size>1)for(var v=0;v<c.size;++v){var g=c.name.replace("[0]","["+v+"]");u(b,new f(g,r.id(g),e.getUniformLocation(m,g),c))}var y=c.name;c.size>1&&(y=y.replace("[0]","")),u(b,new f(y,r.id(y),e.getUniformLocation(m,y),c))}var x=e.getProgramParameter(m,35721);a.profile&&(t.stats.attributesCount=x);var w=t.attributes;for(o=0;o<x;++o)(c=e.getActiveAttrib(m,o))&&u(w,new f(c.name,r.id(c.name),e.getAttribLocation(m,c.name),c))}return a.profile&&(n.getMaxUniformsCount=function(){var e=0;return l.forEach((function(t){t.stats.uniformsCount>e&&(e=t.stats.uniformsCount)})),e},n.getMaxAttributesCount=function(){var e=0;return l.forEach((function(t){t.stats.attributesCount>e&&(e=t.stats.attributesCount)})),e}),{clear:function(){var t=e.deleteShader.bind(e);H(i).forEach(t),i={},H(o).forEach(t),o={},l.forEach((function(t){e.deleteProgram(t.program)})),l.length=0,c={},n.shaderCount=0},program:function(r,a,f,u){_.command(r>=0,"missing vertex shader",f),_.command(a>=0,"missing fragment shader",f);var s=c[a];s||(s=c[a]={});var d=s[r];if(d&&(d.refCount++,!u))return d;var h=new m(a,r);return n.shaderCount++,p(h,f,u),d||(s[r]=h),l.push(h),t(h,{destroy:function(){if(h.refCount--,h.refCount<=0){e.deleteProgram(h.program);var t=l.indexOf(h);l.splice(t,1),n.shaderCount--}s[h.vertId].refCount<=0&&(e.deleteShader(o[h.vertId]),delete o[h.vertId],delete c[h.fragId][h.vertId]),Object.keys(c[h.fragId]).length||(e.deleteShader(i[h.fragId]),delete i[h.fragId],delete c[h.fragId])}})},restore:function(){i={},o={};for(var e=0;e<l.length;++e)p(l[e],null,l[e].attributes.map((function(e){return[e.location,e.name]})))},shader:s,frag:-1,vert:-1}}(a,c,l,n),S=dt(a,d,y,(function(){T.procs.poll()}),v,l,n),O=function(e,t,r,n,a){var i={rgba4:pt,rgb565:36194,"rgb5 a1":32855,depth:33189,stencil:36168,"depth stencil":34041};t.ext_srgb&&(i.srgba=35907),t.ext_color_buffer_half_float&&(i.rgba16f=34842,i.rgb16f=34843),t.webgl_color_buffer_float&&(i.rgba32f=34836);var o=[];Object.keys(i).forEach((function(e){var t=i[e];o[t]=e}));var f=0,u={};function s(e){this.id=f++,this.refCount=1,this.renderbuffer=e,this.format=pt,this.width=0,this.height=0,a.profile&&(this.stats={size:0})}function c(t){var r=t.renderbuffer;_(r,"must not double destroy renderbuffer"),e.bindRenderbuffer(mt,null),e.deleteRenderbuffer(r),t.renderbuffer=null,t.refCount=0,delete u[t.id],n.renderbufferCount--}return s.prototype.decRef=function(){--this.refCount<=0&&c(this)},a.profile&&(n.getTotalRenderbufferSize=function(){var e=0;return Object.keys(u).forEach((function(t){e+=u[t].stats.size})),e}),{create:function(t,f){var c=new s(e.createRenderbuffer());function l(t,n){var f=0,u=0,s=pt;if("object"==typeof t&&t){var d=t;if("shape"in d){var m=d.shape;_(Array.isArray(m)&&m.length>=2,"invalid renderbuffer shape"),f=0|m[0],u=0|m[1]}else"radius"in d&&(f=u=0|d.radius),"width"in d&&(f=0|d.width),"height"in d&&(u=0|d.height);"format"in d&&(_.parameter(d.format,i,"invalid renderbuffer format"),s=i[d.format])}else"number"==typeof t?(f=0|t,u="number"==typeof n?0|n:f):t?_.raise("invalid arguments to renderbuffer constructor"):f=u=1;if(_(f>0&&u>0&&f<=r.maxRenderbufferSize&&u<=r.maxRenderbufferSize,"invalid renderbuffer size"),f!==c.width||u!==c.height||s!==c.format)return l.width=c.width=f,l.height=c.height=u,c.format=s,e.bindRenderbuffer(mt,c.renderbuffer),e.renderbufferStorage(mt,s,f,u),_(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=bt(c.format,c.width,c.height)),l.format=o[c.format],l}return u[c.id]=c,n.renderbufferCount++,l(t,f),l.resize=function(t,n){var i=0|t,o=0|n||i;return i===c.width&&o===c.height||(_(i>0&&o>0&&i<=r.maxRenderbufferSize&&o<=r.maxRenderbufferSize,"invalid renderbuffer size"),l.width=c.width=i,l.height=c.height=o,e.bindRenderbuffer(mt,c.renderbuffer),e.renderbufferStorage(mt,c.format,i,o),_(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=bt(c.format,c.width,c.height))),l},l._reglType="renderbuffer",l._renderbuffer=c,a.profile&&(l.stats=c.stats),l.destroy=function(){c.decRef()},l},clear:function(){H(u).forEach(c)},restore:function(){H(u).forEach((function(t){t.renderbuffer=e.createRenderbuffer(),e.bindRenderbuffer(mt,t.renderbuffer),e.renderbufferStorage(mt,t.format,t.width,t.height)})),e.bindRenderbuffer(mt,null)}}}(a,d,y,l,n),E=function(e,r,n,a,i,o){var f={cur:null,next:null,dirty:!1,setFBO:null},u=["rgba"],s=["rgba4","rgb565","rgb5 a1"];r.ext_srgb&&s.push("srgba"),r.ext_color_buffer_half_float&&s.push("rgba16f","rgb16f"),r.webgl_color_buffer_float&&s.push("rgba32f");var c=["uint8"];function l(e,t,r){this.target=e,this.texture=t,this.renderbuffer=r;var n=0,a=0;t?(n=t.width,a=t.height):r&&(n=r.width,a=r.height),this.width=n,this.height=a}function d(e){e&&(e.texture&&e.texture._texture.decRef(),e.renderbuffer&&e.renderbuffer._renderbuffer.decRef())}function m(e,t,r){if(e)if(e.texture){var n=e.texture._texture,a=Math.max(1,n.width),i=Math.max(1,n.height);_(a===t&&i===r,"inconsistent width/height for supplied texture"),n.refCount+=1}else{var o=e.renderbuffer._renderbuffer;_(o.width===t&&o.height===r,"inconsistent width/height for renderbuffer"),o.refCount+=1}}function p(t,r){r&&(r.texture?e.framebufferTexture2D(vt,t,r.target,r.texture._texture.texture,0):e.framebufferRenderbuffer(vt,t,gt,r.renderbuffer._renderbuffer.renderbuffer))}function h(e){var t=yt,r=null,n=null,a=e;"object"==typeof e&&(a=e.data,"target"in e&&(t=0|e.target)),_.type(a,"function","invalid attachment data");var i=a._reglType;return"texture2d"===i?(r=a,_(t===yt)):"textureCube"===i?(r=a,_(t>=xt&&t<34075,"invalid cube map target")):"renderbuffer"===i?(n=a,t=gt):_.raise("invalid regl object for attachment"),new l(t,r,n)}function b(e,t,r,n,o){if(r){var f=a.create2D({width:e,height:t,format:n,type:o});return f._texture.refCount=0,new l(yt,f,null)}var u=i.create({width:e,height:t,format:n});return u._renderbuffer.refCount=0,new l(gt,null,u)}function v(e){return e&&(e.texture||e.renderbuffer)}function g(e,t,r){e&&(e.texture?e.texture.resize(t,r):e.renderbuffer&&e.renderbuffer.resize(t,r),e.width=t,e.height=r)}r.oes_texture_half_float&&c.push("half float","float16"),r.oes_texture_float&&c.push("float","float32");var y=0,x={};function w(){this.id=y++,x[this.id]=this,this.framebuffer=e.createFramebuffer(),this.width=0,this.height=0,this.colorAttachments=[],this.depthAttachment=null,this.stencilAttachment=null,this.depthStencilAttachment=null}function A(e){e.colorAttachments.forEach(d),d(e.depthAttachment),d(e.stencilAttachment),d(e.depthStencilAttachment)}function k(t){var r=t.framebuffer;_(r,"must not double destroy framebuffer"),e.deleteFramebuffer(r),t.framebuffer=null,o.framebufferCount--,delete x[t.id]}function S(t){var r;e.bindFramebuffer(vt,t.framebuffer);var a=t.colorAttachments;for(r=0;r<a.length;++r)p(36064+r,a[r]);for(r=a.length;r<n.maxColorAttachments;++r)e.framebufferTexture2D(vt,36064+r,yt,null,0);e.framebufferTexture2D(vt,33306,yt,null,0),e.framebufferTexture2D(vt,36096,yt,null,0),e.framebufferTexture2D(vt,36128,yt,null,0),p(36096,t.depthAttachment),p(36128,t.stencilAttachment),p(33306,t.depthStencilAttachment);var i=e.checkFramebufferStatus(vt);e.isContextLost()||36053===i||_.raise("framebuffer configuration not supported, status = "+St[i]),e.bindFramebuffer(vt,f.next?f.next.framebuffer:null),f.cur=f.next,e.getError()}function O(e,a){var i=new w;function l(e,t){var a;_(f.next!==i,"can not update framebuffer which is currently in use");var o=0,d=0,p=!0,g=!0,y=null,x=!0,w="rgba",k="uint8",O=1,E=null,T=null,D=null,j=!1;if("number"==typeof e)o=0|e,d=0|t||o;else if(e){_.type(e,"object","invalid arguments for framebuffer");var C=e;if("shape"in C){var z=C.shape;_(Array.isArray(z)&&z.length>=2,"invalid shape for framebuffer"),o=z[0],d=z[1]}else"radius"in C&&(o=d=C.radius),"width"in C&&(o=C.width),"height"in C&&(d=C.height);("color"in C||"colors"in C)&&(y=C.color||C.colors,Array.isArray(y)&&_(1===y.length||r.webgl_draw_buffers,"multiple render targets not supported")),y||("colorCount"in C&&(O=0|C.colorCount,_(O>0,"invalid color buffer count")),"colorTexture"in C&&(x=!!C.colorTexture,w="rgba4"),"colorType"in C&&(k=C.colorType,x?(_(r.oes_texture_float||!("float"===k||"float32"===k),"you must enable OES_texture_float in order to use floating point framebuffer objects"),_(r.oes_texture_half_float||!("half float"===k||"float16"===k),"you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects")):"half float"===k||"float16"===k?(_(r.ext_color_buffer_half_float,"you must enable EXT_color_buffer_half_float to use 16-bit render buffers"),w="rgba16f"):"float"!==k&&"float32"!==k||(_(r.webgl_color_buffer_float,"you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers"),w="rgba32f"),_.oneOf(k,c,"invalid color type")),"colorFormat"in C&&(w=C.colorFormat,u.indexOf(w)>=0?x=!0:s.indexOf(w)>=0?x=!1:_.optional((function(){x?_.oneOf(C.colorFormat,u,"invalid color format for texture"):_.oneOf(C.colorFormat,s,"invalid color format for renderbuffer")})))),("depthTexture"in C||"depthStencilTexture"in C)&&(j=!(!C.depthTexture&&!C.depthStencilTexture),_(!j||r.webgl_depth_texture,"webgl_depth_texture extension not supported")),"depth"in C&&("boolean"==typeof C.depth?p=C.depth:(E=C.depth,g=!1)),"stencil"in C&&("boolean"==typeof C.stencil?g=C.stencil:(T=C.stencil,p=!1)),"depthStencil"in C&&("boolean"==typeof C.depthStencil?p=g=C.depthStencil:(D=C.depthStencil,p=!1,g=!1))}else o=d=1;var F=null,B=null,V=null,I=null;if(Array.isArray(y))F=y.map(h);else if(y)F=[h(y)];else for(F=new Array(O),a=0;a<O;++a)F[a]=b(o,d,x,w,k);_(r.webgl_draw_buffers||F.length<=1,"you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers."),_(F.length<=n.maxColorAttachments,"too many color attachments, not supported"),o=o||F[0].width,d=d||F[0].height,E?B=h(E):p&&!g&&(B=b(o,d,j,"depth","uint32")),T?V=h(T):g&&!p&&(V=b(o,d,!1,"stencil","uint8")),D?I=h(D):!E&&!T&&g&&p&&(I=b(o,d,j,"depth stencil","depth stencil")),_(!!E+!!T+!!D<=1,"invalid framebuffer configuration, can specify exactly one depth/stencil attachment");var P=null;for(a=0;a<F.length;++a)if(m(F[a],o,d),_(!F[a]||F[a].texture&&wt.indexOf(F[a].texture._texture.format)>=0||F[a].renderbuffer&&kt.indexOf(F[a].renderbuffer._renderbuffer.format)>=0,"framebuffer color attachment "+a+" is invalid"),F[a]&&F[a].texture){var L=At[F[a].texture._texture.format]*_t[F[a].texture._texture.type];null===P?P=L:_(P===L,"all color attachments much have the same number of bits per pixel.")}return m(B,o,d),_(!B||B.texture&&6402===B.texture._texture.format||B.renderbuffer&&33189===B.renderbuffer._renderbuffer.format,"invalid depth attachment for framebuffer object"),m(V,o,d),_(!V||V.renderbuffer&&36168===V.renderbuffer._renderbuffer.format,"invalid stencil attachment for framebuffer object"),m(I,o,d),_(!I||I.texture&&34041===I.texture._texture.format||I.renderbuffer&&34041===I.renderbuffer._renderbuffer.format,"invalid depth-stencil attachment for framebuffer object"),A(i),i.width=o,i.height=d,i.colorAttachments=F,i.depthAttachment=B,i.stencilAttachment=V,i.depthStencilAttachment=I,l.color=F.map(v),l.depth=v(B),l.stencil=v(V),l.depthStencil=v(I),l.width=i.width,l.height=i.height,S(i),l}return o.framebufferCount++,l(e,a),t(l,{resize:function(e,t){_(f.next!==i,"can not resize a framebuffer which is currently in use");var r=Math.max(0|e,1),n=Math.max(0|t||r,1);if(r===i.width&&n===i.height)return l;for(var a=i.colorAttachments,o=0;o<a.length;++o)g(a[o],r,n);return g(i.depthAttachment,r,n),g(i.stencilAttachment,r,n),g(i.depthStencilAttachment,r,n),i.width=l.width=r,i.height=l.height=n,S(i),l},_reglType:"framebuffer",_framebuffer:i,destroy:function(){k(i),A(i)},use:function(e){f.setFBO({framebuffer:l},e)}})}return t(f,{getFramebuffer:function(e){if("function"==typeof e&&"framebuffer"===e._reglType){var t=e._framebuffer;if(t instanceof w)return t}return null},create:O,createCube:function(e){var i=Array(6);function o(e){var n;_(i.indexOf(f.next)<0,"can not update framebuffer which is currently in use");var s,l={color:null},d=0,m=null,p="rgba",h="uint8",b=1;if("number"==typeof e)d=0|e;else if(e){_.type(e,"object","invalid arguments for framebuffer");var v=e;if("shape"in v){var g=v.shape;_(Array.isArray(g)&&g.length>=2,"invalid shape for framebuffer"),_(g[0]===g[1],"cube framebuffer must be square"),d=g[0]}else"radius"in v&&(d=0|v.radius),"width"in v?(d=0|v.width,"height"in v&&_(v.height===d,"must be square")):"height"in v&&(d=0|v.height);("color"in v||"colors"in v)&&(m=v.color||v.colors,Array.isArray(m)&&_(1===m.length||r.webgl_draw_buffers,"multiple render targets not supported")),m||("colorCount"in v&&(b=0|v.colorCount,_(b>0,"invalid color buffer count")),"colorType"in v&&(_.oneOf(v.colorType,c,"invalid color type"),h=v.colorType),"colorFormat"in v&&(p=v.colorFormat,_.oneOf(v.colorFormat,u,"invalid color format for texture"))),"depth"in v&&(l.depth=v.depth),"stencil"in v&&(l.stencil=v.stencil),"depthStencil"in v&&(l.depthStencil=v.depthStencil)}else d=1;if(m)if(Array.isArray(m))for(s=[],n=0;n<m.length;++n)s[n]=m[n];else s=[m];else{s=Array(b);var y={radius:d,format:p,type:h};for(n=0;n<b;++n)s[n]=a.createCube(y)}for(l.color=Array(s.length),n=0;n<s.length;++n){var x=s[n];_("function"==typeof x&&"textureCube"===x._reglType,"invalid cube map"),d=d||x.width,_(x.width===d&&x.height===d,"invalid cube map shape"),l.color[n]={target:xt,data:s[n]}}for(n=0;n<6;++n){for(var w=0;w<s.length;++w)l.color[w].target=xt+n;n>0&&(l.depth=i[0].depth,l.stencil=i[0].stencil,l.depthStencil=i[0].depthStencil),i[n]?i[n](l):i[n]=O(l)}return t(o,{width:d,height:d,color:s})}return o(e),t(o,{faces:i,resize:function(e){var t,r=0|e;if(_(r>0&&r<=n.maxCubeMapSize,"invalid radius for cube fbo"),r===o.width)return o;var a=o.color;for(t=0;t<a.length;++t)a[t].resize(r);for(t=0;t<6;++t)i[t].resize(r);return o.width=o.height=r,o},_reglType:"framebufferCube",destroy:function(){i.forEach((function(e){e.destroy()}))}})},clear:function(){H(x).forEach(k)},restore:function(){f.cur=null,f.next=null,f.dirty=!0,H(x).forEach((function(t){t.framebuffer=e.createFramebuffer(),S(t)}))}})}(a,d,y,S,O,l),T=un(a,c,d,y,x,w,0,E,{},A,k,g,v,m,n),z=Ct(a,E,T.procs.poll,v,i,d,y),F=T.next,V=a.canvas,I=[],P=[],N=[],q=[n.onDestroy],Q=null;function Y(){if(0===I.length)return m&&m.update(),void(Q=null);Q=j.next(Y),ye();for(var e=I.length-1;e>=0;--e){var t=I[e];t&&t(v,null,0)}a.flush(),m&&m.update()}function ce(){!Q&&I.length>0&&(Q=j.next(Y))}function le(){Q&&(j.cancel(Y),Q=null)}function de(e){e.preventDefault(),o=!0,le(),P.forEach((function(e){e()}))}function me(e){a.getError(),o=!1,f.restore(),k.restore(),x.restore(),S.restore(),O.restore(),E.restore(),A.restore(),m&&m.restore(),T.procs.refresh(),ce(),N.forEach((function(e){e()}))}function pe(e){function r(e,t){var r={},n={};return Object.keys(e).forEach((function(a){var i=e[a];if(D.isDynamic(i))n[a]=D.unbox(i,a);else{if(t&&Array.isArray(i))for(var o=0;o<i.length;++o)if(D.isDynamic(i[o]))return void(n[a]=D.unbox(i,a));r[a]=i}})),{dynamic:n,static:r}}_(!!e,"invalid args to regl({...})"),_.type(e,"object","invalid args to regl({...})");var n=r(e.context||{},!0),a=r(e.uniforms||{},!0),i=r(e.attributes||{},!1),f=r(function(e){var r=t({},e);function n(e){if(e in r){var t=r[e];delete r[e],Object.keys(t).forEach((function(n){r[e+"."+n]=t[n]}))}}return delete r.uniforms,delete r.attributes,delete r.context,delete r.vao,"stencil"in r&&r.stencil.op&&(r.stencil.opBack=r.stencil.opFront=r.stencil.op,delete r.stencil.op),n("blend"),n("depth"),n("cull"),n("stencil"),n("polygonOffset"),n("scissor"),n("sample"),"vao"in e&&(r.vao=e.vao),r}(e),!1),u={gpuTime:0,cpuTime:0,count:0},s=T.compile(f,i,a,n,u),c=s.draw,l=s.batch,d=s.scope,m=[];return t((function(e,t){var r;if(o&&_.raise("context lost"),"function"==typeof e)return d.call(this,null,e,0);if("function"==typeof t)if("number"==typeof e)for(r=0;r<e;++r)d.call(this,null,t,r);else{if(!Array.isArray(e))return d.call(this,e,t,0);for(r=0;r<e.length;++r)d.call(this,e[r],t,r)}else if("number"==typeof e){if(e>0)return l.call(this,function(e){for(;m.length<e;)m.push(null);return m}(0|e),0|e)}else{if(!Array.isArray(e))return c.call(this,e);if(e.length)return l.call(this,e,e.length)}}),{stats:u,destroy:function(){s.destroy()}})}V&&(V.addEventListener(cn,de,!1),V.addEventListener(ln,me,!1));var he=E.setFBO=pe({framebuffer:D.define.call(null,1,"framebuffer")});function be(e,t){var r=0;T.procs.poll();var n=t.color;n&&(a.clearColor(+n[0]||0,+n[1]||0,+n[2]||0,+n[3]||0),r|=16384),"depth"in t&&(a.clearDepth(+t.depth),r|=256),"stencil"in t&&(a.clearStencil(0|t.stencil),r|=1024),_(!!r,"called regl.clear with no buffer specified"),a.clear(r)}function ve(e){return _.type(e,"function","regl.frame() callback must be a function"),I.push(e),ce(),{cancel:function(){var t=dn(I,e);_(t>=0,"cannot cancel a frame twice"),I[t]=function e(){var t=dn(I,e);I[t]=I[I.length-1],I.length-=1,I.length<=0&&le()}}}}function ge(){var e=F.viewport,t=F.scissor_box;e[0]=e[1]=t[0]=t[1]=0,v.viewportWidth=v.framebufferWidth=v.drawingBufferWidth=e[2]=t[2]=a.drawingBufferWidth,v.viewportHeight=v.framebufferHeight=v.drawingBufferHeight=e[3]=t[3]=a.drawingBufferHeight}function ye(){v.tick+=1,v.time=we(),ge(),T.procs.poll()}function xe(){S.refresh(),ge(),T.procs.refresh(),m&&m.update()}function we(){return(C()-p)/1e3}xe();var Ae=t(pe,{clear:function(e){if(_("object"==typeof e&&e,"regl.clear() takes an object as input"),"framebuffer"in e)if(e.framebuffer&&"framebufferCube"===e.framebuffer_reglType)for(var r=0;r<6;++r)he(t({framebuffer:e.framebuffer.faces[r]},e),be);else he(e,be);else be(0,e)},prop:D.define.bind(null,1),context:D.define.bind(null,2),this:D.define.bind(null,3),draw:pe({}),buffer:function(e){return x.create(e,34962,!1,!1)},elements:function(e){return w.create(e,!1)},texture:S.create2D,cube:S.createCube,renderbuffer:O.create,framebuffer:E.create,framebufferCube:E.createCube,vao:A.createVAO,attributes:i,frame:ve,on:function(e,t){var r;switch(_.type(t,"function","listener callback must be a function"),e){case"frame":return ve(t);case"lost":r=P;break;case"restore":r=N;break;case"destroy":r=q;break;default:_.raise("invalid event, must be one of frame,lost,restore,destroy")}return r.push(t),{cancel:function(){for(var e=0;e<r.length;++e)if(r[e]===t)return r[e]=r[r.length-1],void r.pop()}}},limits:y,hasExtension:function(e){return y.extensions.indexOf(e.toLowerCase())>=0},read:z,destroy:function(){I.length=0,le(),V&&(V.removeEventListener(cn,de),V.removeEventListener(ln,me)),k.clear(),E.clear(),O.clear(),A.clear(),S.clear(),w.clear(),x.clear(),m&&m.clear(),q.forEach((function(e){e()}))},_gl:a,_refresh:xe,poll:function(){ye(),m&&m.update()},now:we,stats:l});return n.onDone(null,Ae),Ae}},"object"==typeof r&&void 0!==t?t.exports=o():"function"==typeof define&&define.amd?define(o):i.createREGL=o()},
function _(t,e,r,a,n){a();var _=t(1),i=t(366),o=t(127),h=function(){function t(t){this._regl=t,this._map=new Map}return t.prototype._create_texture=function(t){for(var e=t.length,r=0,a=[],n=0,_=0,o=0;o<e;o++)r+=t[o],a.push(t[o]+t[(o+1)%e]),o%2==0?_=Math.max(_,t[o]):n=Math.min(n,-t[o]);n*=.5,_*=.5;var h=i.gcd(a),p=[0];for(o=0;o<e;o++)p.push(p[o]+t[o]);var u,s=2*r/h,c=i.is_pow_2(s),f=c?s:128,g=.5*h*s/f;c?g<(u=.5*t[0])&&(u-=Math.floor(u/g)*g):u=0;var l=u-.5*g,m=new Uint8Array(f),v=0;for(o=0;o<f;o++){var y=u+o*g;y>p[v+1]&&v++;var d=t[v],M=p[v]+.5*d,w=.5*d-Math.abs(y-M);v%2==1&&(w=-w),m[o]=Math.round(255*(w-n)/(_-n))}return[[r,l,n,_],this._regl.texture({shape:[f,1,1],data:m,wrapS:"repeat",format:"alpha",type:"uint8",mag:"linear",min:"linear"})]},t.prototype._get_key=function(t){return t.join(",")},t.prototype._get_or_create=function(t){var e=this._get_key(t),r=this._map.get(e);if(null==r){var a=i.gcd(t);if(a>1){t=o.map(t,(function(t){return t/a})),r=this._get_or_create(t);var n=_.__read(r,3),h=n[0],p=n[1];n[2];r=[h,p,a],this._map.set(e,r)}else{var u=_.__read(this._create_texture(t),2);r=[h=u[0],p=u[1],a],this._map.set(e,r)}}return r},t.prototype.get=function(t){return t.length%2==1&&(t=t.slice(0,-1)),this._get_or_create(t)},t}();r.DashCache=h,h.__name__="DashCache"},
function _(n,r,t,o,u){function f(n,r){var t,o;n>r?(t=n,o=r):(t=r,o=n);for(var u=t%o;0!=u;)u=(t=o)%(o=u);return o}o(),t.gcd=function(n){for(var r=n[0],t=1;t<n.length;t++)r=f(r,n[t]);return r},t.is_pow_2=function(n){return!(n&n-1||!n)}},
function _(n,t,i,e,_){e();i.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nconst float missing_point_threshold = -9000.0;\n\nattribute vec2 a_position;\nattribute vec2 a_point_prev;\nattribute vec2 a_point_start;\nattribute vec2 a_point_end;\nattribute vec2 a_point_next;\n#ifdef DASHED\nattribute float a_length_so_far;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform float u_miter_limit;\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;  // Booleans for start/end caps and miters too long.\nvarying float v_cos_theta_turn_right_start;  // Sign gives turn_right, abs gives\nvarying float v_cos_theta_turn_right_end;    //   cos(theta).\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nvec2 line_intersection(in vec2 point0, in vec2 dir0,\n                       in vec2 point1, in vec2 dir1)\n{\n    // Line-line intersection: point0 + lambda0 dir0 = point1 + lambda1 dir1.\n    // Not checking if lines are parallel!\n    float lambda0 = cross_z(point1 - point0, dir1) / cross_z(dir0, dir1);\n    return point0 + lambda0*dir0;\n}\n\nvoid main()\n{\n    if (a_point_start.x < missing_point_threshold ||\n        a_point_end.x < missing_point_threshold) {\n        // Line segment has non-finite value at one or both ends, do not render.\n        gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n        return;\n    }\n\n    const float min_miter_factor_round_join_mesh = sqrt(2.0);\n\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n    vec2 segment_along = normalize(a_point_end - a_point_start); // unit vector.\n    v_segment_length = length(a_point_end - a_point_start);\n    vec2 segment_right = right_vector(segment_along);  // unit vector.\n    vec2 xy;\n\n    bool miter_too_large_start = false;\n    bool miter_too_large_end = false;\n\n    v_coords.y = a_position.y*halfwidth;  // Overwritten later for end points.\n\n    bool has_start_cap = a_point_prev.x < missing_point_threshold;\n    bool has_end_cap = a_point_next.x < missing_point_threshold;\n\n    vec2 point_normal_start;\n    float cos_theta_start;\n    float turn_right_start;\n    if (has_start_cap)\n        point_normal_start = segment_right;\n    else {\n        vec2 prev_right = right_vector(normalize(a_point_start - a_point_prev));\n        point_normal_start = normalize(segment_right + prev_right);\n        cos_theta_start = dot(segment_right, point_normal_start);  // Always +ve\n        turn_right_start = sign(dot(segment_right, a_point_prev - a_point_start));\n    }\n\n    vec2 point_normal_end;\n    float cos_theta_end;\n    float turn_right_end;\n    if (has_end_cap)\n        point_normal_end = segment_right;\n    else {\n        vec2 next_right = right_vector(normalize(a_point_next - a_point_end));\n        point_normal_end = normalize(segment_right + next_right);\n        cos_theta_end = dot(segment_right, point_normal_end);  // Always +ve\n        turn_right_end = sign(dot(segment_right, a_point_next - a_point_end));\n    }\n\n    float miter_factor_start = 1.0 / dot(segment_right, point_normal_start);\n    float miter_factor_end = 1.0 / dot(segment_right, point_normal_end);\n    if (join_type == miter_join) {\n        // If miter too large, use bevel join instead.\n        miter_too_large_start = (miter_factor_start > u_miter_limit);\n        miter_too_large_end = (miter_factor_end > u_miter_limit);\n    }\n\n    float sign_at_start = -sign(a_position.x);  // +ve at segment start, -ve end.\n    vec2 point = sign_at_start > 0.0 ? a_point_start : a_point_end;\n    vec2 adjacent_point =\n        sign_at_start > 0.0 ? (has_start_cap ? a_point_start : a_point_prev)\n                            : (has_end_cap ? a_point_end : a_point_next);\n\n    if ( (has_start_cap && sign_at_start > 0.0) ||\n         (has_end_cap && sign_at_start < 0.0) ) {\n        // Cap.\n        xy = point - segment_right*(halfwidth*a_position.y);\n        if (cap_type == butt_cap)\n            xy -= sign_at_start*0.5*u_antialias*segment_along;\n        else\n            xy -= sign_at_start*halfwidth*segment_along;\n    }\n    else { // Join.\n        // +ve if turning to right, -ve if to left.\n        float turn_sign = sign_at_start > 0.0 ? turn_right_start : turn_right_end;\n\n        vec2 adjacent_right = sign_at_start*normalize(right_vector(point - adjacent_point));\n        vec2 point_right = normalize(segment_right + adjacent_right);\n        float miter_factor = sign_at_start > 0.0 ? miter_factor_start : miter_factor_end;\n        bool miter_too_large = sign_at_start > 0.0 ? miter_too_large_start : miter_too_large_end;\n\n        if (abs(a_position.x) > 1.5) {\n            // Outer point, meets prev/next segment.\n            float factor;  // multiplied by halfwidth...\n\n            if (join_type == bevel_join || (join_type == miter_join && miter_too_large))\n                factor = 1.0 / miter_factor;  // cos_theta.\n            else if (join_type == round_join &&\n                     miter_factor > min_miter_factor_round_join_mesh)\n                factor = 1.0;\n            else  // miter, or round (small angle only).\n                factor = miter_factor;\n\n            xy = point - point_right*(halfwidth*turn_sign*factor);\n            v_coords.y = turn_sign*halfwidth*factor / miter_factor;\n        }\n        else if (turn_sign*a_position.y < 0.0) {\n            // Inner point, meets prev/next segment.\n            float len = halfwidth*miter_factor;\n            float segment_len = v_segment_length;\n            float adjacent_len = distance(point, adjacent_point);\n\n            if (len <= min(segment_len, adjacent_len))\n                // Normal behaviour.\n                xy = point - point_right*(len*a_position.y);\n            else\n                // For short wide line segments the inner point using the above\n                // calculation can be outside of the line.  Here clipping it.\n                xy = point + segment_right*(halfwidth*turn_sign);\n        }\n        else {\n            // Point along outside edge.\n            xy = point - segment_right*(halfwidth*a_position.y);\n            if (join_type == round_join &&\n                miter_factor > min_miter_factor_round_join_mesh) {\n                xy = line_intersection(xy, segment_along,\n                                       point - turn_sign*point_right*halfwidth,\n                                       right_vector(point_right));\n            }\n        }\n    }\n\n    vec2 pos = xy + 0.5;  // Bokeh's offset.\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n\n    v_coords.x = dot(xy - a_point_start, segment_along);\n    v_flags = float(int(has_start_cap) +\n                    2*int(has_end_cap) +\n                    4*int(miter_too_large_start) +\n                    8*int(miter_too_large_end));\n    v_cos_theta_turn_right_start = cos_theta_start*turn_right_start;\n    v_cos_theta_turn_right_end = cos_theta_end*turn_right_end;\n\n#ifdef DASHED\n    v_length_so_far = a_length_so_far;\n#endif\n}\n"},
function _(n,t,a,i,e){i();a.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform vec4 u_line_color;\n#ifdef DASHED\nuniform sampler2D u_dash_tex;\nuniform vec4 u_dash_tex_info;\nuniform float u_dash_scale;\nuniform float u_dash_offset;\n#endif\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;\nvarying float v_cos_theta_turn_right_start;\nvarying float v_cos_theta_turn_right_end;\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nfloat point_line_side(in vec2 point, in vec2 start, in vec2 end)\n{\n    // +ve if point to right of line.\n    // Alternatively could do dot product with right_vector.\n    return cross_z(point - start, end - start);\n}\n\nfloat point_line_distance(in vec2 point, in vec2 start, in vec2 end)\n{\n    return point_line_side(point, start, end) / distance(start, end);\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nfloat bevel_join_distance(in float sign_start, in float halfwidth)\n{\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n    float distance_along = sign_start > 0.0 ? 0.0 : v_segment_length;\n\n    // In v_coords reference frame (x is along segment, y across).\n    vec2 line_start = vec2(distance_along, halfwidth*turn_right);\n    float sin_alpha = cos_theta;\n    float cos_alpha = sqrt(1.0 - sin_alpha*sin_alpha);\n    vec2 line_along = vec2(-sign_start*turn_right*sin_alpha, -cos_alpha);\n\n    return halfwidth + sign_start*point_line_distance(\n        v_coords, line_start, line_start+line_along);\n}\n\nfloat cap(in int cap_type, in float x, in float y)\n{\n    // x is distance along segment in direction away from end of segment,\n    // y is distance across segment.\n    if (cap_type == butt_cap)\n        return max(0.5*u_linewidth - x, abs(y));\n    else if (cap_type == square_cap)\n        return max(-x, abs(y));\n    else  // cap_type == round_cap\n        return distance(vec2(min(x, 0.0), y), vec2(0.0, 0.0));\n}\n\nfloat distance_to_alpha(in float dist)\n{\n    return 1.0 - smoothstep(0.5*(u_linewidth - u_antialias),\n                            0.5*(u_linewidth + u_antialias), dist);\n}\n\n#ifdef DASHED\nfloat dash_distance(in float x)\n{\n    // x is in direction of v_coords.x, i.e. along segment.\n    float tex_length = u_dash_tex_info.x;\n    float tex_offset = u_dash_tex_info.y;\n    float tex_dist_min = u_dash_tex_info.z;\n    float tex_dist_max = u_dash_tex_info.w;\n\n    // Apply offset.\n    x += v_length_so_far - u_dash_scale*tex_offset + u_dash_offset;\n\n    // Interpolate within texture to obtain distance to dash.\n    float dist = texture2D(u_dash_tex,\n                           vec2(x / (tex_length*u_dash_scale), 0.0)).a;\n\n    // Scale distance within min and max limits.\n    dist = tex_dist_min + dist*(tex_dist_max - tex_dist_min);\n\n    return u_dash_scale*dist;\n}\n\nmat2 rotation_matrix(in float sign_start)\n{\n    // Rotation matrix for v_coords from this segment to prev or next segment.\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n\n    float sin_theta = sqrt(1.0 - cos_theta*cos_theta)*sign_start*turn_right;\n    float cos_2theta = 2.0*cos_theta*cos_theta - 1.0;\n    float sin_2theta = 2.0*sin_theta*cos_theta;\n    return mat2(cos_2theta, -sin_2theta, sin_2theta, cos_2theta);\n}\n#endif\n\nvoid main()\n{\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n\n    // Extract flags.\n    int flags = int(v_flags + 0.5);\n    bool miter_too_large_end = (flags / 8 > 0);\n    flags -= 8*int(miter_too_large_end);\n    bool miter_too_large_start = (flags / 4 > 0);\n    flags -= 4*int(miter_too_large_start);\n    bool has_end_cap = (flags / 2 > 0);\n    flags -= 2*int(has_end_cap);\n    bool has_start_cap = flags > 0;\n\n    float dist = v_coords.y;  // For straight segment, and miter join.\n\n    if (v_coords.x <= 0.5*u_antialias) {\n        // At start of segment, either cap or join.\n        if (has_start_cap)\n            dist = cap(cap_type, v_coords.x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(0.0, 0.0));\n        else if (join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_start))\n            dist = max(abs(dist), bevel_join_distance(1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n    else if (v_coords.x >= v_segment_length - 0.5*u_antialias) {\n        // At end of segment, either cap or join.\n        if (has_end_cap)\n            dist = cap(cap_type, v_segment_length - v_coords.x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(v_segment_length, 0));\n        else if ((join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_end)))\n            dist = max(abs(dist), bevel_join_distance(-1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n\n    float alpha = distance_to_alpha(abs(dist));\n\n#ifdef DASHED\n    if (u_dash_tex_info.x >= 0.0) {\n        // Dashes in straight segments (outside of joins) are easily calculated.\n        dist = dash_distance(v_coords.x);\n\n        if (!has_start_cap && cap_type == butt_cap) {\n            if (v_coords.x < 0.5*u_antialias) {\n                // Outer of start join rendered solid color or not at all\n                // depending on whether corner point is in dash or gap, with\n                // antialiased ends.\n                dist = (dash_distance(0.0) > 0.0 ? 0.5*u_antialias - v_coords.x\n                                                 : -0.5*u_linewidth);\n\n                // Also consider antialiased end of dash just outside corner.\n                float end_dist = dash_distance(0.5*u_antialias) + v_coords.x -\n                    0.5*u_antialias;\n                dist = max(dist, end_dist);\n            }\n\n            vec2 prev_coords = rotation_matrix(1.0)*v_coords;\n\n            if (abs(prev_coords.y) < halfwidth &&\n                prev_coords.x < 0.5*u_antialias) {\n                // Extend dashes across from previous segment, with antialiased\n                // end.\n                float new_dist = dash_distance(min(prev_coords.x,\n                                                   -0.5*u_antialias));\n\n                if (prev_coords.x > -0.5*u_antialias)\n                    new_dist -= prev_coords.x + 0.5*u_antialias;\n\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(prev_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        if (!has_end_cap && cap_type == butt_cap) {\n            if (v_coords.x > v_segment_length - 0.5*u_antialias) {\n                // Similar for end join.\n                dist = (dash_distance(v_segment_length) > 0.0\n                            ? v_coords.x - v_segment_length + 0.5*u_antialias\n                            : -0.5*u_linewidth);\n\n                float end_dist =\n                    dash_distance(v_segment_length - 0.5*u_antialias) -\n                    v_coords.x + v_segment_length - 0.5*u_antialias;\n                dist = max(dist, end_dist);\n            }\n\n            vec2 next_coords =\n                rotation_matrix(-1.0)*(v_coords - vec2(v_segment_length, 0.0));\n\n            if (abs(next_coords.y) < halfwidth &&\n                next_coords.x > -0.5*u_antialias) {\n                // Extend dashes across from next segment, with antialiased end.\n                float new_dist = dash_distance(v_segment_length +\n                    max(next_coords.x, 0.5*u_antialias));\n\n                if (next_coords.x < 0.5*u_antialias)\n                    new_dist += next_coords.x - 0.5*u_antialias;\n\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(next_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        dist = cap(cap_type, dist, v_coords.y);\n\n        float dash_alpha = distance_to_alpha(dist);\n        alpha = min(alpha, dash_alpha);\n    }\n#endif\n\n    alpha = u_line_color.a*alpha;\n    gl_FragColor = vec4(u_line_color.rgb*alpha, alpha);  // Premultiplied alpha.\n}\n"},
function _(n,i,o,a,t){a();o.default="\nprecision mediump float;\n\nattribute vec2 a_position;\nattribute vec2 a_center;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4 a_line_color;\nattribute vec4 a_fill_color;\nattribute float a_show;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying vec2 v_coords;\n\nvoid main()\n{\n    v_size = a_size;\n    v_linewidth = a_linewidth;\n    v_line_color = a_line_color;\n    v_fill_color = a_fill_color;\n\n    if (a_show < 0.5) {\n      // Do not show this marker.\n      gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n      return;\n    }\n\n    float enclosing_size = v_size + 2.0*v_linewidth + 3.0*u_antialias;\n\n    // Coordinates in rotated frame with respect to center of marker, used in\n    // distance functions in fragment shader.\n    v_coords = a_position*enclosing_size;\n\n    float c = cos(-a_angle);\n    float s = sin(-a_angle);\n    mat2 rotation = mat2(c, -s, s, c);\n\n    vec2 pos = a_center + rotation*v_coords;\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n}\n"},
function _(n,a,e,t,s){t();e.default="\nprecision mediump float;\n\nconst float SQRT_2 = 1.4142135623730951;\nconst float SQRT_3 = sqrt(3.0);\nconst float PI = 3.14159265358979323846264;\n\nconst float IN_ANGLE = 0.6283185307179586; // PI/5. = 36 degrees (star of 5 pikes)\n//const float OUT_ANGLE = PI/2. - IN_ANGLE; // External angle for regular stars\nconst float COS_A = 0.8090169943749475; // cos(IN_ANGLE)\nconst float SIN_A = 0.5877852522924731; // sin(IN_ANGLE)\nconst float COS_B = 0.5877852522924731; // cos(OUT_ANGLE)\nconst float SIN_B = 0.8090169943749475; // sin(OUT_ANGLE)\n\nuniform float u_antialias;\n\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2 v_coords;\n\n#ifdef USE_ASTERISK\n// asterisk\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / 2.0;\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y));\n    float cross = min(abs(P.x), abs(P.y));\n    // Result is union of masked shapes\n    float result = min(max(X, diamond), max(cross, square));\n    return max(result - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n}\n#endif\n\n#ifdef USE_CIRCLE\n// circle\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n#endif\n\n#ifdef USE_DOT\nfloat marker(vec2 P, float size)\n{\n    return max(length(P) - size/8.0 - v_linewidth/15.0 + u_antialias, 0.0);\n}\n#endif\n\n#ifdef USE_CIRCLE_DOT\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size/2.0;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(circle, dot_);\n}\n#endif\n\n#ifdef USE_SQUARE\n// square\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n#endif\n\n#ifdef USE_SQUARE_DOT\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(square, dot_);\n}\n#endif\n\n#ifdef USE_DIAMOND\n// diamond\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n#endif\n\n#ifdef USE_DIAMOND_DOT\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    float diamond = r1 / SQRT_2;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(diamond, dot_);\n}\n#endif\n\n#ifdef USE_HEX\n// hex\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n#endif\n\n#ifdef USE_HEX_DOT\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    float hex = max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(hex, dot_);\n}\n#endif\n\n#ifdef USE_STAR\n// star\n// https://iquilezles.org/www/articles/distfunctions2d/distfunctions2d.htm\nfloat marker(vec2 P, float size)\n{\n    float bn = mod(atan(P.x, -P.y), 2.0*IN_ANGLE) - IN_ANGLE;\n    P = length(P)*vec2(cos(bn), abs(sin(bn)));\n    P -= size*vec2(COS_A, SIN_A)/2.;\n    P += vec2(COS_B, SIN_B)*clamp(-(P.x*COS_B + P.y*SIN_B), 0.0, size*SIN_A/SIN_B/2.);\n    return length(P)*sign(P.x);\n}\n#endif\n\n#ifdef USE_STAR_DOT\nfloat marker(vec2 P, float size)\n{\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    float bn = mod(atan(P.x, -P.y), 2.0*IN_ANGLE) - IN_ANGLE;\n    P = length(P)*vec2(cos(bn), abs(sin(bn)));\n    P -= size*vec2(COS_A, SIN_A)/2.;\n    P += vec2(COS_B, SIN_B)*clamp(-(P.x*COS_B + P.y*SIN_B), 0.0, size*SIN_A/SIN_B/2.);\n    float star = length(P)*sign(P.x);\n    return max(star, dot_);\n}\n#endif\n\n#ifdef USE_TRIANGLE\n// triangle\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_TRIANGLE_DOT\nfloat marker(vec2 P, float size)\n{\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    float triangle = max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n    return max(triangle, dot_);\n}\n#endif\n\n#ifdef USE_INVERTED_TRIANGLE\n// inverted_triangle\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_CROSS\n// cross\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    float cross = min(abs(P.x), abs(P.y));\n    cross = max(cross - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(square, cross);\n}\n#endif\n\n#ifdef USE_DASH\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    float cross = abs(P.y);\n    cross = max(cross - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(square, cross);\n}\n#endif\n\n#ifdef USE_CIRCLE_CROSS\n// circle_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_SQUARE_CROSS\n// square_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_DIAMOND_CROSS\n// diamond_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_X\n// x\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 2.0;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y));\n    X = max(X - v_linewidth/2.0, 0.0);\n    return max(circle, X);\n}\n#endif\n\n#ifdef USE_Y\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 2.0;\n\n    float dx = 1.0 / SQRT_3;\n    float dy = SQRT_2 / SQRT_3;\n\n    // Sideways distance from the three spokes.\n    float d0 = abs(P.x);\n    float d1 = abs(dot(P, vec2(dx, dy)));\n    float d2 = abs(dot(P, vec2(dx, -dy)));\n\n    // Clip each spoke to semicircle.\n    d0 = max(d0, -P.y);\n    d1 = max(d1, dot(P, vec2(-dy, dx)));\n    d2 = max(d2, dot(P, vec2(dy, dx)));\n\n    float Y = min(min(d0, d1), d2);\n    Y = max(Y - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(circle, Y);\n}\n#endif\n\n#ifdef USE_CIRCLE_X\n// circle_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_CIRCLE_Y\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size/2.0;\n\n    float dx = 1.0 / SQRT_3;\n    float dy = SQRT_2 / SQRT_3;\n\n    // Sideways distance from the three spokes.\n    float d0 = abs(P.x);\n    float d1 = abs(dot(P, vec2(dx, dy)));\n    float d2 = abs(dot(P, vec2(dx, -dy)));\n\n    // Clip each spoke to semicircle.\n    d0 = max(d0, -P.y);\n    d1 = max(d1, dot(P, vec2(-dy, dx)));\n    d2 = max(d2, dot(P, vec2(dy, dx)));\n\n    float Y = min(min(d0, d1), d2);\n    Y = min(v_linewidth/2.0 - u_antialias/2.0 - Y, 0.0);\n\n    return max(circle, Y);\n}\n#endif\n\n#ifdef USE_SQUARE_X\n// square_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_PLUS\nfloat marker(vec2 P, float size)\n{\n    vec2 size2 = vec2(size*0.5, size*0.2);\n    P = abs(P);\n    P = (P.y > P.x) ? P.yx : P.xy;\n    vec2 q = P - size2;\n    float k = max(q.y, q.x);\n    vec2 w = (k > 0.0) ? q : vec2(size2.y - P.x, -k);\n    return sign(k)*length(max(w, 0.0));\n}\n#endif\n\n#ifdef USE_SQUARE_PIN\nfloat marker(vec2 P, float size)\n{\n    float actual_size = size*1.2;\n    float radius = 0.75*actual_size; // Radius of curvature of edges.\n    float offset = actual_size/2.0 + sqrt(radius*radius - actual_size*actual_size/4.0);\n    vec2 centerx = vec2(offset, 0.0);\n    vec2 centery = vec2(0.0, offset);\n\n    float right = length(P - centerx);\n    float left = length(P + centerx);\n    float up = length(P - centery);\n    float down = length(P + centery);\n    float pin = radius - min(min(right, left), min(up, down));\n\n    float circle = length(P) - actual_size*0.6;\n    return max(circle, pin);\n}\n#endif\n\n#ifdef USE_TRIANGLE_PIN\nfloat marker(vec2 P, float size)\n{\n    float actual_size = size*1.2;\n    float radius = 1.2*actual_size; // Radius of curvature of edges.\n\n    float angle = 2.0*PI / 3.0;\n    float c = cos(angle);\n    float s = sin(angle);\n    mat2 rotation = mat2(c, -s, s, c);\n\n    // Half the length of straight triangle edge.\n    float half_edge = actual_size*SQRT_3/4.0;\n    // Distance from center of triangle to middle of straight edge.\n    float centre_middle_edge = 0.25*actual_size;\n    float offset = centre_middle_edge + sqrt(radius*radius - half_edge*half_edge);\n    // Centre of curvature.\n    vec2 center = vec2(0.0, offset);\n\n    float dist0 = length(P - center);\n    P = rotation*P;\n    float dist1 = length(P - center);\n    P = rotation*P;\n    float dist2 = length(P - center);\n    float pin = radius - min(min(dist0, dist1), dist2);\n\n    float circle = length(P) - actual_size / 2.0;\n    return max(circle, pin);\n}\n#endif\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 line_color,\n             vec4 fill_color)\n{\n    vec4 frag_color;\n    float t = min(linewidth/2.0 - antialias, 0.0);  // Line half-width.\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If line alpha is zero, it probably means no outline. To avoid a dark\n    // outline shining through due to antialiasing, we set the line color to the\n    // fill color.\n    float select = float(bool(line_color.a));\n    line_color.rgb = select*line_color.rgb + (1.0 - select)*fill_color.rgb;\n    // Similarly, if we want a transparent fill.\n    select = float(bool(fill_color.a));\n    fill_color.rgb = select*fill_color.rgb + (1.0 - select)*line_color.rgb;\n\n    if (border_distance < 0.0)\n        frag_color = line_color;\n    else if (signed_distance < 0.0)\n        frag_color = mix(fill_color, line_color, sqrt(alpha));\n    else {\n        if (abs(signed_distance) < linewidth/2.0 + antialias)\n            frag_color = vec4(line_color.rgb, line_color.a*alpha);\n        else\n            discard;\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    float distance = marker(v_coords, v_size);\n    gl_FragColor = outline(\n        distance, v_linewidth, u_antialias, v_line_color, v_fill_color);\n    gl_FragColor.rgb *= gl_FragColor.a;  // Premultiplied alpha.\n}\n"},
function _(n,t,a,i,e){i();a.default="\nprecision mediump float;\n\nattribute vec2 a_position;\nattribute vec2 a_center;\nattribute float a_width;\nattribute float a_height;\nattribute float a_angle; // In radians\nattribute float a_linewidth;\nattribute vec4 a_line_color;\nattribute vec4 a_fill_color;\nattribute float a_line_join;\nattribute float a_show;\n#ifdef HATCH\nattribute float a_hatch_pattern;\nattribute float a_hatch_scale;\nattribute float a_hatch_weight;\nattribute vec4 a_hatch_color;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying vec2 v_size; // 2D size for rects compared to 1D for markers.\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\nvoid main()\n{\n  if (a_show < 0.5) {\n    // Do not show this rect.\n    gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n    return;\n  }\n\n  v_size = vec2(a_width, a_height);\n  v_linewidth = a_linewidth;\n  v_line_color = a_line_color;\n  v_fill_color = a_fill_color;\n  v_line_join = a_line_join;\n\n  if (v_linewidth < 1.0) {\n    // Linewidth less than 1 is implemented as 1 but with reduced alpha.\n    v_line_color.a *= v_linewidth;\n    v_linewidth = 1.0;\n  }\n\n#ifdef HATCH\n  v_hatch_pattern = a_hatch_pattern;\n  v_hatch_scale = a_hatch_scale;\n  v_hatch_weight = a_hatch_weight;\n  v_hatch_color = a_hatch_color;\n#endif\n\n  vec2 enclosing_size = v_size + v_linewidth + u_antialias;\n\n  // Coordinates in rotated frame with respect to center of marker, used for\n  // distance functions in fragment shader.\n  v_coords = a_position*enclosing_size;\n\n  float c = cos(-a_angle);\n  float s = sin(-a_angle);\n  mat2 rotation = mat2(c, -s, s, c);\n\n  vec2 pos = a_center + rotation*v_coords;\n#ifdef HATCH\n  // Coordinates for hatching in unrotated frame of reference.\n  v_hatch_coords = pos - 0.5;\n#endif\n  pos += 0.5; // Make up for Bokeh's offset.\n  pos /= u_canvas_size / u_pixel_ratio; // 0 to 1.\n  gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n}\n"},
function _(n,a,t,o,r){o();t.default="\nprecision mediump float;\n\nconst float SQRT2 = sqrt(2.0);\nconst float INVSQRT2 = 1.0/SQRT2;\nconst float PI = 3.14159265358979323846;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n#ifdef HATCH\nconst int hatch_dot = 1;\nconst int hatch_ring = 2;\nconst int hatch_horizontal_line = 3;\nconst int hatch_vertical_line = 4;\nconst int hatch_cross = 5;\nconst int hatch_horizontal_dash = 6;\nconst int hatch_vertical_dash = 7;\nconst int hatch_spiral = 8;\nconst int hatch_right_diagonal_line = 9;\nconst int hatch_left_diagonal_line = 10;\nconst int hatch_diagonal_cross = 11;\nconst int hatch_right_diagonal_dash = 12;\nconst int hatch_left_diagonal_dash = 13;\nconst int hatch_horizontal_wave = 14;\nconst int hatch_vertical_wave = 15;\nconst int hatch_criss_cross = 16;\n#endif\n\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying vec2 v_size;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\n// Distance is zero on edge of marker, +ve outside and -ve inside.\nfloat marker_distance(vec2 p, int line_join)\n{\n  vec2 dist2 = abs(p) - v_size/2.0;\n  float dist = max(dist2.x, dist2.y);\n\n  if (dist2.x > 0.0 && dist2.y > 0.0) {\n    // Outside of corner needs correct join, default is miter.\n    if (line_join == round_join)\n      dist = length(dist2);\n    else if (line_join == bevel_join) {\n      vec2 normal = vec2(INVSQRT2, INVSQRT2);\n      dist = dot(dist2, normal) + 0.5*v_linewidth*(1.0 - INVSQRT2);\n    }\n  }\n\n  return dist;\n}\n\n// Convert distance from edge of marker to fraction in range 0 to 1, depending\n// on antialiasing width.\nfloat distance_to_fraction(float dist)\n{\n  return 1.0 - smoothstep(-0.5*u_antialias, 0.5*u_antialias, dist);\n}\n\n// Return fraction from 0 (no fill color) to 1 (full fill color).\nfloat fill_fraction(float dist)\n{\n  return distance_to_fraction(dist);\n}\n\n// Return fraction in range 0 (no line color) to 1 (full line color).\nfloat line_fraction(float dist)\n{\n  return distance_to_fraction(abs(dist) - 0.5*v_linewidth);\n}\n\n// Return fraction (in range 0 to 1) of a color, with premultiplied alpha.\nvec4 fractional_color(vec4 color, float fraction)\n{\n  color.a *= fraction;\n  color.rgb *= color.a;\n  return color;\n}\n\n// Blend colors that have premultiplied alpha.\nvec4 blend_colors(vec4 src, vec4 dest)\n{\n  return (1.0 - src.a)*dest + src;\n}\n\n#ifdef HATCH\n// Wrap coordinate(s) by removing integer part to give distance from center of\n// repeat, in the range -0.5 to +0.5.\nfloat wrap(float x)\n{\n  return fract(x) - 0.5;\n}\n\nvec2 wrap(vec2 xy)\n{\n  return fract(xy) - 0.5;\n}\n\n// Return fraction from 0 (no hatch color) to 1 (full hatch color).\nfloat hatch_fraction(vec2 coords, int hatch_pattern)\n{\n  float scale = v_hatch_scale; // Hatch repeat distance.\n\n  // Coordinates and linewidth/halfwidth are scaled to hatch repeat distance.\n  coords = coords / scale;\n  float halfwidth = 0.5*v_hatch_weight / scale; // Half the hatch linewidth.\n\n  // Default is to return fraction of zero, i.e. no pattern.\n  float dist = u_antialias;\n\n  if (hatch_pattern == hatch_dot) {\n    const float dot_radius = 0.25;\n    dist = length(wrap(coords)) - dot_radius;\n  }\n  else if (hatch_pattern == hatch_ring) {\n    const float ring_radius = 0.25;\n    dist = abs(length(wrap(coords)) - ring_radius) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_line) {\n    dist = abs(wrap(coords.y)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_line) {\n    dist = abs(wrap(coords.x)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_cross) {\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_dash) {\n    // Dashes have square caps.\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.y)),\n               abs(wrap(coords.x) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_dash) {\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.x)),\n               abs(wrap(coords.y) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_spiral) {\n    vec2 wrap2 = wrap(coords);\n    float angle = wrap(atan(wrap2.y, wrap2.x) / (2.0*PI));\n    // Canvas spiral radius increases by scale*pi/15 each rotation.\n    const float dr = PI/15.0;\n    float radius = length(wrap2);\n    // At any angle, spiral lines are equally spaced dr apart.\n    // Find distance to nearest of these lines.\n    float frac = fract((radius - dr*angle) / dr); // 0 to 1.\n    dist = dr*(abs(frac - 0.5));\n    dist = min(dist, radius) - halfwidth; // Consider center point also.\n  }\n  else if (hatch_pattern == hatch_right_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x + coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x - coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_diagonal_cross) {\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_right_diagonal_dash) {\n    float across = coords.x + coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x - coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_dash) {\n    float across = coords.x - coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x + coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_wave) {\n    float wrapx = wrap(coords.x);\n    float wrapy = wrap(coords.y - 0.25 + abs(wrapx));\n    dist = abs(wrapy) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_wave) {\n    float wrapy = wrap(coords.y);\n    float wrapx = wrap(coords.x - 0.25 + abs(wrapy));\n    dist = abs(wrapx) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_criss_cross) {\n    float plus = min(abs(wrap(coords.x)), abs(wrap(coords.y)));\n\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    float X = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2;\n\n    dist = min(plus, X) - halfwidth;\n  }\n\n  return distance_to_fraction(dist*scale);\n}\n#endif\n\nvoid main()\n{\n  int line_join = int(v_line_join + 0.5);\n#ifdef HATCH\n  int hatch_pattern = int(v_hatch_pattern + 0.5);\n#endif\n\n  float dist = marker_distance(v_coords, line_join);\n\n  float fill_frac = fill_fraction(dist);\n  vec4 color = fractional_color(v_fill_color, fill_frac);\n\n#ifdef HATCH\n  if (hatch_pattern > 0 && fill_frac > 0.0) {\n    float hatch_frac = hatch_fraction(v_hatch_coords, hatch_pattern);\n    vec4 hatch_color = fractional_color(v_hatch_color, hatch_frac*fill_frac);\n    color = blend_colors(hatch_color, color);\n  }\n#endif\n\n  float line_frac = line_fraction(dist);\n  if (line_frac > 0.0) {\n    vec4 line_color = fractional_color(v_line_color, line_frac);\n    color = blend_colors(line_color, color);\n  }\n\n  gl_FragColor = color;\n}\n"},
function _(m,o,n,r,a){r(),a("Expression",m(374).Expression),a("CustomJSExpr",m(375).CustomJSExpr),a("Stack",m(376).Stack),a("CumSum",m(377).CumSum),a("ScalarExpression",m(374).ScalarExpression),a("Minimum",m(378).Minimum),a("Maximum",m(379).Maximum);var s=m(380);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(381).PolarTransform)},
function _(t,e,n,i,r){i();var s=t(1),c=t(168),o=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected=new Set,this._result=new Map},e.prototype.v_compute=function(t){var e=this;this._connected.has(t)||(this.connect(t.change,(function(){return e._result.delete(t)})),this.connect(t.patching,(function(){return e._result.delete(t)})),this.connect(t.streaming,(function(){return e._result.delete(t)})),this._connected.add(t));var n=this._result.get(t);return null==n&&(n=this._v_compute(t),this._result.set(t,n)),n},e}(c.Model);n.Expression=o,o.__name__="Expression";var u=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected=new Set,this._result=new Map},e.prototype.compute=function(t){var e=this;this._connected.has(t)||(this.connect(t.change,(function(){return e._result.delete(t)})),this.connect(t.patching,(function(){return e._result.delete(t)})),this.connect(t.streaming,(function(){return e._result.delete(t)})),this._connected.add(t));var n=this._result.get(t);return null==n&&(n=this._compute(t),this._result.set(t,n)),n},e}(c.Model);n.ScalarExpression=u,u.__name__="ScalarExpression"},
function _(e,r,t,n,a){n();var o=e(1),i=e(129),s=e(374),u=e(139),c=e(124),l=e(128),p=e(149),_=e(123),f=function(e){function r(r){return e.call(this,r)||this}return o.__extends(r,e),r.init_CustomJSExpr=function(){this.define((function(e){var r=e.Unknown,t=e.String;return{args:[(0,e.Dict)(r),{}],code:[t,""]}}))},r.prototype.connect_signals=function(){var r,t,n=this;e.prototype.connect_signals.call(this);try{for(var a=o.__values(l.values(this.args)),s=a.next();!s.done;s=a.next()){var u=s.value;u instanceof i.HasProps&&u.change.connect((function(){n._result.clear(),n.change.emit()}))}}catch(e){r={error:e}}finally{try{s&&!s.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}},Object.defineProperty(r.prototype,"names",{get:function(){return l.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return l.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"func",{get:function(){var e=p.use_strict(this.code);return new(u.GeneratorFunction.bind.apply(u.GeneratorFunction,o.__spreadArray(o.__spreadArray([void 0],o.__read(this.names)),[e])))},enumerable:!1,configurable:!0}),r.prototype._v_compute=function(e){var r=this.func.apply(e,this.values),t=r.next();if(t.done&&void 0!==t.value){var n=t.value;return _.isArray(n)||_.isTypedArray(n)?n:_.isIterable(n)?o.__spreadArray([],o.__read(n)):c.repeat(n,e.length)}var a=[];do{a.push(t.value),t=r.next()}while(!t.done);return a},r}(s.Expression);t.CustomJSExpr=f,f.__name__="CustomJSExpr",f.init_CustomJSExpr()},
function _(t,n,r,e,i){e();var a=t(1),l=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_Stack=function(){this.define((function(t){var n=t.String;return{fields:[(0,t.Array)(n),[]]}}))},n.prototype._v_compute=function(t){var n,r,e,i=null!==(e=t.get_length())&&void 0!==e?e:0,l=new Float64Array(i);try{for(var o=a.__values(this.fields),u=o.next();!u.done;u=o.next()){var c=u.value,f=t.data[c];if(null!=f)for(var _=0,s=Math.min(i,f.length);_<s;_++)l[_]+=f[_]}}catch(t){n={error:t}}finally{try{u&&!u.done&&(r=o.return)&&r.call(o)}finally{if(n)throw n.error}}return l},n}(t(374).Expression);r.Stack=l,l.__name__="Stack",l.init_Stack()},
function _(n,t,e,i,u){i();var r=n(1),o=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.init_CumSum=function(){this.define((function(n){var t=n.Boolean;return{field:[n.String],include_zero:[t,!1]}}))},t.prototype._v_compute=function(n){var t,e=new Float64Array(null!==(t=n.get_length())&&void 0!==t?t:0),i=n.data[this.field],u=this.include_zero?1:0;e[0]=this.include_zero?0:i[0];for(var r=1;r<e.length;r++)e[r]=e[r-1]+i[r-u];return e},t}(n(374).Expression);e.CumSum=o,o.__name__="CumSum",o.init_CumSum()},
function _(i,n,t,u,e){u();var l=i(1),r=i(374),a=i(124),m=function(i){function n(n){return i.call(this,n)||this}return l.__extends(n,i),n.init_Minimum=function(){this.define((function(i){var n=i.Number;return{field:[i.String],initial:[(0,i.Nullable)(n),null]}}))},n.prototype._compute=function(i){var n,t,u=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.min(null!==(t=this.initial)&&void 0!==t?t:1/0,a.min(u))},n}(r.ScalarExpression);t.Minimum=m,m.__name__="Minimum",m.init_Minimum()},
function _(i,n,t,u,a){u();var e=i(1),l=i(374),r=i(124),m=function(i){function n(n){return i.call(this,n)||this}return e.__extends(n,i),n.init_Maximum=function(){this.define((function(i){var n=i.Number;return{field:[i.String],initial:[(0,i.Nullable)(n),null]}}))},n.prototype._compute=function(i){var n,t,u=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.max(null!==(t=this.initial)&&void 0!==t?t:-1/0,r.max(u))},n}(l.ScalarExpression);t.Maximum=m,m.__name__="Maximum",m.init_Maximum()},
function _(n,t,e,o,r){o();var i=n(1),u=n(374),_=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t.init_CoordinateTransform=function(){},Object.defineProperty(t.prototype,"x",{get:function(){return new s({transform:this})},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return new a({transform:this})},enumerable:!1,configurable:!0}),t}(u.Expression);e.CoordinateTransform=_,_.__name__="CoordinateTransform",_.init_CoordinateTransform();var f=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t.init_XYComponent=function(){this.define((function(n){return{transform:[(0,n.Ref)(_)]}}))},t}(u.Expression);e.XYComponent=f,f.__name__="XYComponent",f.init_XYComponent();var s=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t.prototype._v_compute=function(n){return this.transform.v_compute(n).x},t}(f);e.XComponent=s,s.__name__="XComponent";var a=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t.prototype._v_compute=function(n){return this.transform.v_compute(n).y},t}(f);e.YComponent=a,a.__name__="YComponent"},
function _(r,n,t,i,e){i();var o=r(1),a=r(380),s=r(135),c=o.__importStar(r(133)),l=function(r){function n(n){return r.call(this,n)||this}return o.__extends(n,r),n.init_PolarTransform=function(){this.define((function(r){return{radius:[c.DistanceSpec,{field:"radius"}],angle:[c.AngleSpec,{field:"angle"}],direction:[s.Direction,"anticlock"]}}))},n.prototype._v_compute=function(r){for(var n=this.properties.radius.uniform(r),t=this.properties.angle.uniform(r),i="anticlock"==this.direction?-1:1,e=Math.min(n.length,t.length),o=new Float64Array(e),a=new Float64Array(e),s=0;s<e;s++){var c=n.get(s),l=t.get(s)*i;o[s]=c*Math.cos(l),a[s]=c*Math.sin(l)}return{x:o,y:a}},n}(a.CoordinateTransform);t.PolarTransform=l,l.__name__="PolarTransform",l.init_PolarTransform()},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(383).BooleanFilter),i("CustomJSFilter",e(384).CustomJSFilter),i("Filter",e(302).Filter),i("GroupFilter",e(385).GroupFilter),i("IndexFilter",e(386).IndexFilter)},
function _(n,e,t,o,l){o();var i=n(1),r=n(302),a=n(139),u=function(n){function e(e){return n.call(this,e)||this}return i.__extends(e,n),e.init_BooleanFilter=function(){this.define((function(n){var e=n.Boolean,t=n.Array;return{booleans:[(0,n.Nullable)(t(e)),null]}}))},e.prototype.compute_indices=function(n){var e=n.length,t=this.booleans;return null==t?a.Indices.all_set(e):a.Indices.from_booleans(e,t)},e}(r.Filter);t.BooleanFilter=u,u.__name__="BooleanFilter",u.init_BooleanFilter()},
function _(e,r,t,n,i){n();var o=e(1),s=e(302),a=e(139),u=e(128),c=e(123),l=e(149),f=function(e){function r(r){return e.call(this,r)||this}return o.__extends(r,e),r.init_CustomJSFilter=function(){this.define((function(e){var r=e.Unknown,t=e.String;return{args:[(0,e.Dict)(r),{}],code:[t,""]}}))},Object.defineProperty(r.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"func",{get:function(){var e=l.use_strict(this.code);return new(Function.bind.apply(Function,o.__spreadArray(o.__spreadArray([void 0],o.__read(this.names)),["source",e])))},enumerable:!1,configurable:!0}),r.prototype.compute_indices=function(e){var r=e.length,t=this.func.apply(this,o.__spreadArray(o.__spreadArray([],o.__read(this.values)),[e]));if(null==t)return a.Indices.all_set(r);if(c.isArrayOf(t,c.isInteger))return a.Indices.from_indices(r,t);if(c.isArrayOf(t,c.isBoolean))return a.Indices.from_booleans(r,t);throw new Error("expect an array of integers or booleans, or null, got "+t)},r}(s.Filter);t.CustomJSFilter=f,f.__name__="CustomJSFilter",f.init_CustomJSFilter()},
function _(n,t,e,r,i){r();var u=n(1),o=n(302),c=n(139),l=n(134),s=function(n){function t(t){return n.call(this,t)||this}return u.__extends(t,n),t.init_GroupFilter=function(){this.define((function(n){var t=n.String;return{column_name:[t],group:[t]}}))},t.prototype.compute_indices=function(n){var t=n.get_column(this.column_name);if(null==t)return l.logger.warn(this+": groupby column '"+this.column_name+"' not found in the data source"),new c.Indices(n.length,1);for(var e=new c.Indices(n.length),r=0;r<e.size;r++)t[r]===this.group&&e.set(r);return e},t}(o.Filter);e.GroupFilter=s,s.__name__="GroupFilter",s.init_GroupFilter()},
function _(n,i,e,t,r){t();var l=n(1),c=n(302),u=n(139),d=function(n){function i(i){return n.call(this,i)||this}return l.__extends(i,n),i.init_IndexFilter=function(){this.define((function(n){var i=n.Int,e=n.Array;return{indices:[(0,n.Nullable)(e(i)),null]}}))},i.prototype.compute_indices=function(n){var i=n.length,e=this.indices;return null==e?u.Indices.all_set(i):u.Indices.from_indices(i,e)},i}(c.Filter);e.IndexFilter=d,d.__name__="IndexFilter",d.init_IndexFilter()},
function _(e,a,l,i,t){i(),t("AnnularWedge",e(388).AnnularWedge),t("Annulus",e(389).Annulus),t("Arc",e(390).Arc),t("Bezier",e(391).Bezier),t("Circle",e(392).Circle),t("Ellipse",e(394).Ellipse),t("EllipseOval",e(395).EllipseOval),t("Glyph",e(287).Glyph),t("HArea",e(298).HArea),t("HBar",e(397).HBar),t("HexTile",e(399).HexTile),t("Image",e(400).Image),t("ImageRGBA",e(402).ImageRGBA),t("ImageURL",e(403).ImageURL),t("Line",e(285).Line),t("MultiLine",e(405).MultiLine),t("MultiPolygons",e(406).MultiPolygons),t("Oval",e(407).Oval),t("Patch",e(297).Patch),t("Patches",e(408).Patches),t("Quad",e(409).Quad),t("Quadratic",e(410).Quadratic),t("Ray",e(411).Ray),t("Rect",e(412).Rect),t("Scatter",e(414).Scatter),t("Segment",e(417).Segment),t("Spline",e(418).Spline),t("Step",e(420).Step),t("Text",e(421).Text),t("VArea",e(300).VArea),t("VBar",e(422).VBar),t("Wedge",e(423).Wedge)},
function _(e,t,r,i,n){i();var s=e(1),a=e(286),_=e(292),o=e(163),u=e(139),l=e(135),d=s.__importStar(e(133)),h=e(125),c=e(187),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=u.to_screen(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=u.to_screen(this.outer_radius)},t.prototype._render=function(e,t,r){var i,n,a=null!=r?r:this,_=a.sx,o=a.sy,u=a.start_angle,l=a.end_angle,d=a.sinner_radius,h=a.souter_radius,c="anticlock"==this.model.direction;try{for(var p=s.__values(t),y=p.next();!y.done;y=p.next()){var f=y.value,x=_[f],v=o[f],g=d[f],m=h[f],w=u.get(f),A=l.get(f);if(isFinite(x+v+g+m+w+A)){var M=A-w;e.translate(x,v),e.rotate(w),e.beginPath(),e.moveTo(m,0),e.arc(0,0,m,0,M,c),e.rotate(M),e.lineTo(g,0),e.arc(0,0,g,0,-M,!c),e.closePath(),e.rotate(-M-w),e.translate(-x,-v),this.visuals.fill.apply(e,f),this.visuals.hatch.apply(e,f),this.visuals.line.apply(e,f)}}}catch(e){i={error:e}}finally{try{y&&!y.done&&(n=p.return)&&n.call(p)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,n,a,_,o,u,l,d,p=e.sx,y=e.sy,f=this.renderer.xscale.invert(p),x=this.renderer.yscale.invert(y);if("data"==this.model.properties.outer_radius.units)o=f-this.max_outer_radius,l=f+this.max_outer_radius,u=x-this.max_outer_radius,d=x+this.max_outer_radius;else{var v=p-this.max_outer_radius,g=p+this.max_outer_radius;o=(t=s.__read(this.renderer.xscale.r_invert(v,g),2))[0],l=t[1];var m=y-this.max_outer_radius,w=y+this.max_outer_radius;u=(r=s.__read(this.renderer.yscale.r_invert(m,w),2))[0],d=r[1]}var A=[];try{for(var M=s.__values(this.index.indices({x0:o,x1:l,y0:u,y1:d})),S=M.next();!S.done;S=M.next()){var V=S.value,W=Math.pow(this.souter_radius[V],2),k=Math.pow(this.sinner_radius[V],2),D=s.__read(this.renderer.xscale.r_compute(f,this._x[V]),2),b=(v=D[0],g=D[1],s.__read(this.renderer.yscale.r_compute(x,this._y[V]),2)),F=(m=b[0],w=b[1],Math.pow(v-g,2)+Math.pow(m-w,2));F<=W&&F>=k&&A.push(V)}}catch(e){i={error:e}}finally{try{S&&!S.done&&(n=M.return)&&n.call(M)}finally{if(i)throw i.error}}var G="anticlock"==this.model.direction,P=[];try{for(var T=s.__values(A),X=T.next();!X.done;X=T.next()){V=X.value;var Y=Math.atan2(y-this.sy[V],p-this.sx[V]);h.angle_between(-Y,-this.start_angle.get(V),-this.end_angle.get(V),G)&&P.push(V)}}catch(e){a={error:e}}finally{try{X&&!X.done&&(_=T.return)&&_.call(T)}finally{if(a)throw a.error}}return new c.Selection({indices:P})},t.prototype.draw_legend_for_index=function(e,t,r){_.generic_area_vector_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=(this.sinner_radius[e]+this.souter_radius[e])/2,r=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(a.XYGlyphView);r.AnnularWedgeView=p,p.__name__="AnnularWedgeView";var y=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_AnnularWedge=function(){this.prototype.default_view=p,this.mixins([o.LineVector,o.FillVector,o.HatchVector]),this.define((function(e){return{direction:[l.Direction,"anticlock"],inner_radius:[d.DistanceSpec,{field:"inner_radius"}],outer_radius:[d.DistanceSpec,{field:"outer_radius"}],start_angle:[d.AngleSpec,{field:"start_angle"}],end_angle:[d.AngleSpec,{field:"end_angle"}]}}))},t}(a.XYGlyph);r.AnnularWedge=y,y.__name__="AnnularWedge",y.init_AnnularWedge()},
function _(r,e,t,i,s){i();var a=r(1),n=r(286),u=r(139),_=r(163),o=a.__importStar(r(133)),h=r(142),d=r(187),l=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return a.__extends(e,r),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=u.to_screen(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=u.to_screen(this.outer_radius)},e.prototype._render=function(r,e,t){var i,s,n,u,_=null!=t?t:this,o=_.sx,d=_.sy,l=_.sinner_radius,c=_.souter_radius;try{for(var p=a.__values(e),y=p.next();!y.done;y=p.next()){var v=y.value,x=o[v],f=d[v],m=l[v],w=c[v];if(isFinite(x+f+m+w)){if(r.beginPath(),h.is_ie)try{for(var M=(n=void 0,a.__values([!1,!0])),A=M.next();!A.done;A=M.next()){var V=A.value;r.moveTo(x,f),r.arc(x,f,m,0,Math.PI,V),r.moveTo(x+w,f),r.arc(x,f,w,Math.PI,0,!V)}}catch(r){n={error:r}}finally{try{A&&!A.done&&(u=M.return)&&u.call(M)}finally{if(n)throw n.error}}else r.arc(x,f,m,0,2*Math.PI,!0),r.moveTo(x+w,f),r.arc(x,f,w,2*Math.PI,0,!1);this.visuals.fill.apply(r,v),this.visuals.hatch.apply(r,v),this.visuals.line.apply(r,v)}}}catch(r){i={error:r}}finally{try{y&&!y.done&&(s=p.return)&&s.call(p)}finally{if(i)throw i.error}}},e.prototype._hit_point=function(r){var e,t,i,s,n,u,_,o,h=r.sx,l=r.sy,c=this.renderer.xscale.invert(h),p=this.renderer.yscale.invert(l);if("data"==this.model.properties.outer_radius.units)n=c-this.max_outer_radius,_=c+this.max_outer_radius,u=p-this.max_outer_radius,o=p+this.max_outer_radius;else{var y=h-this.max_outer_radius,v=h+this.max_outer_radius;n=(e=a.__read(this.renderer.xscale.r_invert(y,v),2))[0],_=e[1];var x=l-this.max_outer_radius,f=l+this.max_outer_radius;u=(t=a.__read(this.renderer.yscale.r_invert(x,f),2))[0],o=t[1]}var m=[];try{for(var w=a.__values(this.index.indices({x0:n,x1:_,y0:u,y1:o})),M=w.next();!M.done;M=w.next()){var A=M.value,V=Math.pow(this.souter_radius[A],2),P=Math.pow(this.sinner_radius[A],2),I=a.__read(this.renderer.xscale.r_compute(c,this._x[A]),2),S=(y=I[0],v=I[1],a.__read(this.renderer.yscale.r_compute(p,this._y[A]),2)),b=(x=S[0],f=S[1],Math.pow(y-v,2)+Math.pow(x-f,2));b<=V&&b>=P&&m.push(A)}}catch(r){i={error:r}}finally{try{M&&!M.done&&(s=w.return)&&s.call(w)}finally{if(i)throw i.error}}return new d.Selection({indices:m})},e.prototype.draw_legend_for_index=function(r,e,t){var i=e.x0,s=e.y0,a=e.x1,n=e.y1,u=t+1,_=new Array(u);_[t]=(i+a)/2;var o=new Array(u);o[t]=(s+n)/2;var h=.5*Math.min(Math.abs(a-i),Math.abs(n-s)),d=new Array(u);d[t]=.4*h;var l=new Array(u);l[t]=.8*h,this._render(r,[t],{sx:_,sy:o,sinner_radius:d,souter_radius:l})},e}(n.XYGlyphView);t.AnnulusView=l,l.__name__="AnnulusView";var c=function(r){function e(e){return r.call(this,e)||this}return a.__extends(e,r),e.init_Annulus=function(){this.prototype.default_view=l,this.mixins([_.LineVector,_.FillVector,_.HatchVector]),this.define((function(r){return{inner_radius:[o.DistanceSpec,{field:"inner_radius"}],outer_radius:[o.DistanceSpec,{field:"outer_radius"}]}}))},e}(n.XYGlyph);t.Annulus=c,c.__name__="Annulus",c.init_Annulus()},
function _(e,t,i,n,r){n();var s=e(1),a=e(286),l=e(292),o=e(163),c=e(139),_=e(135),d=s.__importStar(e(133)),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=c.to_screen(this.radius)},t.prototype._render=function(e,t,i){var n,r;if(this.visuals.line.doit){var a=null!=i?i:this,l=a.sx,o=a.sy,c=a.sradius,_=a.start_angle,d=a.end_angle,u="anticlock"==this.model.direction;try{for(var h=s.__values(t),f=h.next();!f.done;f=h.next()){var p=f.value,g=l[p],v=o[p],y=c[p],x=_.get(p),A=d.get(p);isFinite(g+v+y+x+A)&&(e.beginPath(),e.arc(g,v,y,x,A,u),this.visuals.line.set_vectorize(e,p),e.stroke())}}catch(e){n={error:e}}finally{try{f&&!f.done&&(r=h.return)&&r.call(h)}finally{if(n)throw n.error}}}},t.prototype.draw_legend_for_index=function(e,t,i){l.generic_line_vector_legend(this.visuals,e,t,i)},t}(a.XYGlyphView);i.ArcView=u,u.__name__="ArcView";var h=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Arc=function(){this.prototype.default_view=u,this.mixins(o.LineVector),this.define((function(e){return{direction:[_.Direction,"anticlock"],radius:[d.DistanceSpec,{field:"radius"}],start_angle:[d.AngleSpec,{field:"start_angle"}],end_angle:[d.AngleSpec,{field:"end_angle"}]}}))},t}(a.XYGlyph);i.Arc=h,h.__name__="Arc",h.init_Arc()},
function _(e,r,t,i,a){i();var n=e(1),o=e(163),_=e(287),s=e(292),c=e(193),d=n.__importStar(e(133));function p(e,r,t,i,a,o,_,s){for(var c=[],d=[[],[]],p=0;p<=2;p++){var l=void 0,y=void 0,h=void 0;if(0===p?(y=6*e-12*t+6*a,l=-3*e+9*t-9*a+3*_,h=3*t-3*e):(y=6*r-12*i+6*o,l=-3*r+9*i-9*o+3*s,h=3*i-3*r),Math.abs(l)<1e-12){if(Math.abs(y)<1e-12)continue;0<(z=-h/y)&&z<1&&c.push(z)}else{var f=y*y-4*h*l,u=Math.sqrt(f);if(!(f<0)){var v=(-y+u)/(2*l);0<v&&v<1&&c.push(v);var x=(-y-u)/(2*l);0<x&&x<1&&c.push(x)}}}for(var m=c.length,M=m;m--;){var z,C=1-(z=c[m]),S=C*C*C*e+3*C*C*z*t+3*C*z*z*a+z*z*z*_;d[0][m]=S;var w=C*C*C*r+3*C*C*z*i+3*C*z*z*o+z*z*z*s;d[1][m]=w}return d[0][M]=e,d[1][M]=r,d[0][M+1]=_,d[1][M+1]=s,[Math.min.apply(Math,n.__spreadArray([],n.__read(d[0]))),Math.max.apply(Math,n.__spreadArray([],n.__read(d[1]))),Math.max.apply(Math,n.__spreadArray([],n.__read(d[0]))),Math.min.apply(Math,n.__spreadArray([],n.__read(d[1])))]}var l=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.prototype._project_data=function(){c.inplace.project_xy(this._x0,this._y0),c.inplace.project_xy(this._x1,this._y1)},r.prototype._index_data=function(e){for(var r=this,t=r.data_size,i=r._x0,a=r._y0,o=r._x1,_=r._y1,s=r._cx0,c=r._cy0,d=r._cx1,l=r._cy1,y=0;y<t;y++){var h=i[y],f=a[y],u=o[y],v=_[y],x=s[y],m=c[y],M=d[y],z=l[y];if(isFinite(h+u+f+v+x+m+M+z)){var C=n.__read(p(h,f,u,v,x,m,M,z),4),S=C[0],w=C[1],B=C[2],g=C[3];e.add_rect(S,w,B,g)}else e.add_empty()}},r.prototype._render=function(e,r,t){var i,a;if(this.visuals.line.doit){var o=null!=t?t:this,_=o.sx0,s=o.sy0,c=o.sx1,d=o.sy1,p=o.scx0,l=o.scy0,y=o.scx1,h=o.scy1;try{for(var f=n.__values(r),u=f.next();!u.done;u=f.next()){var v=u.value,x=_[v],m=s[v],M=c[v],z=d[v],C=p[v],S=l[v],w=y[v],B=h[v];isFinite(x+m+M+z+C+S+w+B)&&(e.beginPath(),e.moveTo(x,m),e.bezierCurveTo(C,S,w,B,M,z),this.visuals.line.set_vectorize(e,v),e.stroke())}}catch(e){i={error:e}}finally{try{u&&!u.done&&(a=f.return)&&a.call(f)}finally{if(i)throw i.error}}}},r.prototype.draw_legend_for_index=function(e,r,t){s.generic_line_vector_legend(this.visuals,e,r,t)},r.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},r}(_.GlyphView);t.BezierView=l,l.__name__="BezierView";var y=function(e){function r(r){return e.call(this,r)||this}return n.__extends(r,e),r.init_Bezier=function(){this.prototype.default_view=l,this.define((function(e){return{x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}],cx0:[d.XCoordinateSpec,{field:"cx0"}],cy0:[d.YCoordinateSpec,{field:"cy0"}],cx1:[d.XCoordinateSpec,{field:"cx1"}],cy1:[d.YCoordinateSpec,{field:"cy1"}]}})),this.mixins(o.LineVector)},r}(_.Glyph);t.Bezier=y,y.__name__="Bezier",y.init_Bezier()},
function _(e,i,r,s,t){s();var a=e(1),n=e(286),d=e(393),h=e(163),u=e(139),_=e(135),l=a.__importStar(e(293)),o=a.__importStar(e(133)),c=e(124),p=e(127),y=e(187),x=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(i,e),i.prototype.initialize=function(){e.prototype.initialize.call(this);var i=this.renderer.plot_view.canvas_view.webgl;if(null!=i){var r=i.regl_wrapper;r.has_webgl&&(this.glglyph=new d.MarkerGL(r,this,"circle"))}},Object.defineProperty(i.prototype,"use_radius",{get:function(){return!(this.radius.is_Scalar()&&isNaN(this.radius.value))},enumerable:!1,configurable:!0}),i.prototype._map_data=function(){if(this.use_radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this.radius);break;case"max":var e=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=p.map(e,(function(e,r){return Math.max(e,i[r])}));break;case"min":e=this.sdist(this.renderer.xscale,this._x,this.radius);var r=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=p.map(e,(function(e,i){return Math.min(e,r[i])}))}else this.sradius=u.to_screen(this.radius),this._configure("max_size",{value:2*this.max_radius});else{var s=new u.ScreenArray(this.size);this.sradius=p.map(s,(function(e){return e/2}))}},i.prototype._mask_data=function(){var e,i,r=this,s=this.renderer.plot_view.frame,t=s.x_target,a=s.y_target;return this.use_radius&&"data"==this.model.properties.radius.units?(e=t.map((function(e){return r.renderer.xscale.invert(e)})).widen(this.max_radius),i=a.map((function(e){return r.renderer.yscale.invert(e)})).widen(this.max_radius)):(e=t.widen(this.max_size).map((function(e){return r.renderer.xscale.invert(e)})),i=a.widen(this.max_size).map((function(e){return r.renderer.yscale.invert(e)}))),this.index.indices({x0:e.start,x1:e.end,y0:i.start,y1:i.end})},i.prototype._render=function(e,i,r){var s,t,n=null!=r?r:this,d=n.sx,h=n.sy,u=n.sradius;try{for(var _=a.__values(i),l=_.next();!l.done;l=_.next()){var o=l.value,c=d[o],p=h[o],y=u[o];isFinite(c+p+y)&&(e.beginPath(),e.arc(c,p,y,0,2*Math.PI,!1),this.visuals.fill.apply(e,o),this.visuals.hatch.apply(e,o),this.visuals.line.apply(e,o))}}catch(e){s={error:e}}finally{try{l&&!l.done&&(t=_.return)&&t.call(_)}finally{if(s)throw s.error}}},i.prototype._hit_point=function(e){var i,r,s,t,n,d,h,u,_,l,o=e.sx,c=e.sy,p=this.renderer.xscale.invert(o),x=this.renderer.yscale.invert(c),v=this.model.hit_dilation;if(this.use_radius&&"data"==this.model.properties.radius.units)h=p-this.max_radius*v,u=p+this.max_radius*v,_=x-this.max_radius*v,l=x+this.max_radius*v;else{var m=o-this.max_size*v,f=o+this.max_size*v;h=(i=a.__read(this.renderer.xscale.r_invert(m,f),2))[0],u=i[1];var w=c-this.max_size*v,g=c+this.max_size*v;_=(r=a.__read(this.renderer.yscale.r_invert(w,g),2))[0],l=r[1]}var z=this.index.indices({x0:h,x1:u,y0:_,y1:l}),b=[];if(this.use_radius&&"data"==this.model.properties.radius.units)try{for(var M=a.__values(z),S=M.next();!S.done;S=M.next()){var A=S.value,C=Math.pow(this.sradius[A]*v,2),V=a.__read(this.renderer.xscale.r_compute(p,this._x[A]),2),k=(m=V[0],f=V[1],a.__read(this.renderer.yscale.r_compute(x,this._y[A]),2));w=k[0],g=k[1];Math.pow(m-f,2)+Math.pow(w-g,2)<=C&&b.push(A)}}catch(e){s={error:e}}finally{try{S&&!S.done&&(t=M.return)&&t.call(M)}finally{if(s)throw s.error}}else try{for(var N=a.__values(z),G=N.next();!G.done;G=N.next()){A=G.value,C=Math.pow(this.sradius[A]*v,2);Math.pow(this.sx[A]-o,2)+Math.pow(this.sy[A]-c,2)<=C&&b.push(A)}}catch(e){n={error:e}}finally{try{G&&!G.done&&(d=N.return)&&d.call(N)}finally{if(n)throw n.error}}return new y.Selection({indices:b})},i.prototype._hit_span=function(e){var i,r,s,t,n,d,h,u,_=e.sx,l=e.sy,o=this.bounds();if("h"==e.direction){var c=void 0,p=void 0;if(h=o.y0,u=o.y1,this.use_radius&&"data"==this.model.properties.radius.units)c=_-this.max_radius,p=_+this.max_radius,n=(i=a.__read(this.renderer.xscale.r_invert(c,p),2))[0],d=i[1];else c=_-(x=this.max_size/2),p=_+x,n=(r=a.__read(this.renderer.xscale.r_invert(c,p),2))[0],d=r[1]}else{var x,v=void 0,m=void 0;if(n=o.x0,d=o.x1,this.use_radius&&"data"==this.model.properties.radius.units)v=l-this.max_radius,m=l+this.max_radius,h=(s=a.__read(this.renderer.yscale.r_invert(v,m),2))[0],u=s[1];else v=l-(x=this.max_size/2),m=l+x,h=(t=a.__read(this.renderer.yscale.r_invert(v,m),2))[0],u=t[1]}var f=a.__spreadArray([],a.__read(this.index.indices({x0:n,x1:d,y0:h,y1:u})));return new y.Selection({indices:f})},i.prototype._hit_rect=function(e){var i=e.sx0,r=e.sx1,s=e.sy0,t=e.sy1,n=a.__read(this.renderer.xscale.r_invert(i,r),2),d=n[0],h=n[1],u=a.__read(this.renderer.yscale.r_invert(s,t),2),_=u[0],l=u[1],o=a.__spreadArray([],a.__read(this.index.indices({x0:d,x1:h,y0:_,y1:l})));return new y.Selection({indices:o})},i.prototype._hit_poly=function(e){for(var i=e.sx,r=e.sy,s=c.range(0,this.sx.length),t=[],a=0,n=s.length;a<n;a++){var d=s[a];l.point_in_poly(this.sx[a],this.sy[a],i,r)&&t.push(d)}return new y.Selection({indices:t})},i.prototype.draw_legend_for_index=function(e,i,r){var s=i.x0,t=i.y0,a=i.x1,n=i.y1,d=r+1,h=new Array(d);h[r]=(s+a)/2;var u=new Array(d);u[r]=(t+n)/2;var _=new Array(d);_[r]=.2*Math.min(Math.abs(a-s),Math.abs(n-t)),this._render(e,[r],{sx:h,sy:u,sradius:_})},i}(n.XYGlyphView);r.CircleView=x,x.__name__="CircleView";var v=function(e){function i(i){return e.call(this,i)||this}return a.__extends(i,e),i.init_Circle=function(){this.prototype.default_view=x,this.mixins([h.LineVector,h.FillVector,h.HatchVector]),this.define((function(e){var i=e.Number;return{angle:[o.AngleSpec,0],size:[o.ScreenSizeSpec,{value:4}],radius:[o.NullDistanceSpec,null],radius_dimension:[_.RadiusDimension,"x"],hit_dilation:[i,1]}}))},i}(n.XYGlyph);r.Circle=v,v.__name__="Circle",v.init_Circle()},
function _(s,e,i,a,t){a();var r=s(1),_=s(295),l=s(296),h=-1e4;function n(s){return"Circle"==s.model.type}var c=function(s){function e(e,i,a){var t=s.call(this,e,i)||this;return t.glyph=i,t.marker_type=a,t._marker_type=a,t._antialias=.8,t._show_all=!1,t}return r.__extends(e,s),e.is_supported=function(s){switch(s){case"asterisk":case"circle":case"circle_cross":case"circle_dot":case"circle_x":case"circle_y":case"cross":case"dash":case"diamond":case"diamond_cross":case"diamond_dot":case"dot":case"hex":case"hex_dot":case"inverted_triangle":case"plus":case"square":case"square_cross":case"square_dot":case"square_pin":case"square_x":case"star":case"star_dot":case"triangle":case"triangle_dot":case"triangle_pin":case"x":case"y":return!0;default:return!1}},e.prototype.draw=function(s,e,i){var a=e.glglyph;(a.data_changed||n(this.glyph))&&(a._set_data(),a.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);var t=a._centers.length/2;if(null==this._show&&(this._show=new Uint8Array(t)),s.length<t){this._show_all=!1;for(var r=0;r<t;r++)this._show[r]=0;for(var _=0;_<s.length;_++)this._show[s[_]]=255}else if(!this._show_all){this._show_all=!0;for(r=0;r<t;r++)this._show[r]=255}var l={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[i.width,i.height],pixel_ratio:i.pixel_ratio,center:a._centers,size:a._sizes,angle:a._angles,nmarkers:t,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,show:this._show};this.regl_wrapper.marker(this._marker_type)(l)},e.prototype._set_data=function(){var s=this.glyph.sx.length;null!=this._centers&&this._centers.length==2*s||(this._centers=new Float32Array(2*s));for(var e=0;e<s;e++)isFinite(this.glyph.sx[e])&&isFinite(this.glyph.sy[e])?(this._centers[2*e]=this.glyph.sx[e],this._centers[2*e+1]=this.glyph.sy[e]):(this._centers[2*e]=h,this._centers[2*e+1]=h);if(n(this.glyph)&&null!=this.glyph.radius){this._sizes=new Float32Array(s);for(e=0;e<s;e++)this._sizes[e]=2*this.glyph.sradius[e]}else this._sizes=l.prop_as_array(this.glyph.size);this._angles=l.prop_as_array(this.glyph.angle)},e.prototype._set_visuals=function(){var s=this.glyph.visuals.fill,e=this.glyph.visuals.line;this._linewidths=l.prop_as_array(e.line_width),this._line_rgba=l.color_to_uint8_array(e.line_color,e.line_alpha),this._fill_rgba=l.color_to_uint8_array(s.fill_color,s.fill_alpha)},e}(_.BaseGLGlyph);i.MarkerGL=c,c.__name__="MarkerGL"},
function _(i,e,l,n,t){n();var _=i(1),s=i(395),p=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return _.__extends(e,i),e}(s.EllipseOvalView);l.EllipseView=p,p.__name__="EllipseView";var u=function(i){function e(e){return i.call(this,e)||this}return _.__extends(e,i),e.init_Ellipse=function(){this.prototype.default_view=p},e}(s.EllipseOval);l.Ellipse=u,u.__name__="Ellipse",u.init_Ellipse()},
function _(t,e,i,s,r){s();var h=t(1),a=t(396),n=h.__importStar(t(293)),l=t(139),_=t(187),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"):this.sw=l.to_screen(this.width),"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"):this.sh=l.to_screen(this.height)},e.prototype._render=function(t,e,i){var s,r,a=null!=i?i:this,n=a.sx,l=a.sy,_=a.sw,o=a.sh,d=a.angle;try{for(var p=h.__values(e),y=p.next();!y.done;y=p.next()){var c=y.value,u=n[c],x=l[c],v=_[c],w=o[c],f=d.get(c);isFinite(u+x+v+w+f)&&(t.beginPath(),t.ellipse(u,x,v/2,w/2,f,0,2*Math.PI),this.visuals.fill.apply(t,c),this.visuals.hatch.apply(t,c),this.visuals.line.apply(t,c))}}catch(t){s={error:t}}finally{try{y&&!y.done&&(r=p.return)&&r.call(p)}finally{if(s)throw s.error}}},e.prototype._hit_point=function(t){var e,i,s,r,a,l,o,d,p,y,c,u,x=t.sx,v=t.sy,w=this.renderer.xscale.invert(x),f=this.renderer.yscale.invert(v);"data"==this.model.properties.width.units?(a=w-this.max_width,l=w+this.max_width):(p=x-this.max_width,y=x+this.max_width,a=(e=h.__read(this.renderer.xscale.r_invert(p,y),2))[0],l=e[1]),"data"==this.model.properties.height.units?(o=f-this.max_height,d=f+this.max_height):(c=v-this.max_height,u=v+this.max_height,o=(i=h.__read(this.renderer.yscale.r_invert(c,u),2))[0],d=i[1]);var m=this.index.indices({x0:a,x1:l,y0:o,y1:d}),g=[];try{for(var b=h.__values(m),A=b.next();!A.done;A=b.next()){var E=A.value;n.point_in_ellipse(x,v,this.angle.get(E),this.sh[E]/2,this.sw[E]/2,this.sx[E],this.sy[E])&&g.push(E)}}catch(t){s={error:t}}finally{try{A&&!A.done&&(r=b.return)&&r.call(b)}finally{if(s)throw s.error}}return new _.Selection({indices:g})},e.prototype.draw_legend_for_index=function(t,e,i){var s=e.x0,r=e.y0,h=e.x1,a=e.y1,n=i+1,l=new Array(n);l[i]=(s+h)/2;var _=new Array(n);_[i]=(r+a)/2;var o=this.sw[i]/this.sh[i],d=.8*Math.min(Math.abs(h-s),Math.abs(a-r)),p=new Array(n),y=new Array(n);o>1?(p[i]=d,y[i]=d/o):(p[i]=d*o,y[i]=d),this._render(t,[i],{sx:l,sy:_,sw:p,sh:y,_angle:[0]})},e}(a.CenterRotatableView);i.EllipseOvalView=o,o.__name__="EllipseOvalView";var d=function(t){function e(e){return t.call(this,e)||this}return h.__extends(e,t),e}(a.CenterRotatable);i.EllipseOval=d,d.__name__="EllipseOval"},
function _(t,e,n,i,r){i();var a=t(1),o=t(286),h=t(163),u=a.__importStar(t(133)),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),Object.defineProperty(e.prototype,"max_w2",{get:function(){return"data"==this.model.properties.width.units?this.max_width/2:0},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max_h2",{get:function(){return"data"==this.model.properties.height.units?this.max_height/2:0},enumerable:!1,configurable:!0}),e.prototype._bounds=function(t){var e=t.x0,n=t.x1,i=t.y0,r=t.y1,a=this.max_w2,o=this.max_h2;return{x0:e-a,x1:n+a,y0:i-o,y1:r+o}},e}(o.XYGlyphView);n.CenterRotatableView=l,l.__name__="CenterRotatableView";var c=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_CenterRotatable=function(){this.mixins([h.LineVector,h.FillVector,h.HatchVector]),this.define((function(t){return{angle:[u.AngleSpec,0],width:[u.DistanceSpec,{field:"width"}],height:[u.DistanceSpec,{field:"height"}]}}))},e}(o.XYGlyph);n.CenterRotatable=c,c.__name__="CenterRotatable",c.init_CenterRotatable()},
function _(t,e,i,r,s){r();var h=t(1),n=t(398),o=t(139),a=h.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return h.__extends(e,t),e.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]},e.prototype._lrtb=function(t){var e=this._left[t],i=this._right[t],r=this._y[t],s=this.height.get(t)/2;return[Math.min(e,i),Math.max(e,i),r+s,r-s]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new o.ScreenArray(t),this.sbottom=new o.ScreenArray(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e}(n.BoxView);i.HBarView=_,_.__name__="HBarView";var c=function(t){function e(e){return t.call(this,e)||this}return h.__extends(e,t),e.init_HBar=function(){this.prototype.default_view=_,this.define((function(t){return{left:[a.XCoordinateSpec,{value:0}],y:[a.YCoordinateSpec,{field:"y"}],height:[a.NumberSpec,{value:1}],right:[a.XCoordinateSpec,{field:"right"}]}}))},e}(n.Box);i.HBar=c,c.__name__="HBar",c.init_HBar()},
function _(t,e,r,i,n){i();var s=t(1),a=t(163),o=t(287),_=t(292),h=t(187),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.get_anchor_point=function(t,e,r){var i=Math.min(this.sleft[e],this.sright[e]),n=Math.max(this.sright[e],this.sleft[e]),s=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:s};case"top":case"top_center":return{x:(i+n)/2,y:s};case"top_right":return{x:n,y:s};case"bottom_left":return{x:i,y:a};case"bottom":case"bottom_center":return{x:(i+n)/2,y:a};case"bottom_right":return{x:n,y:a};case"left":case"center_left":return{x:i,y:(s+a)/2};case"center":case"center_center":return{x:(i+n)/2,y:(s+a)/2};case"right":case"center_right":return{x:n,y:(s+a)/2}}},e.prototype._index_data=function(t){for(var e=Math.min,r=Math.max,i=this.data_size,n=0;n<i;n++){var a=s.__read(this._lrtb(n),4),o=a[0],_=a[1],h=a[2],c=a[3];t.add_rect(e(o,_),e(h,c),r(_,o),r(h,c))}},e.prototype._render=function(t,e,r){var i,n,a=null!=r?r:this,o=a.sleft,_=a.sright,h=a.stop,c=a.sbottom;try{for(var l=s.__values(e),p=l.next();!p.done;p=l.next()){var d=p.value,x=o[d],y=h[d],u=_[d],f=c[d];isFinite(x+y+u+f)&&(t.beginPath(),t.rect(x,y,u-x,f-y),this.visuals.fill.apply(t,d),this.visuals.hatch.apply(t,d),this.visuals.line.apply(t,d))}}catch(t){i={error:t}}finally{try{p&&!p.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,r=this.stop.length,i=0;i<r;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,r=t.sy,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(r),a=s.__spreadArray([],s.__read(this.index.indices({x0:i,y0:n,x1:i,y1:n})));return new h.Selection({indices:a})},e.prototype._hit_span=function(t){var e,r=t.sx,i=t.sy;if("v"==t.direction){var n=this.renderer.yscale.invert(i),a=this.renderer.plot_view.frame.bbox.h_range,o=s.__read(this.renderer.xscale.r_invert(a.start,a.end),2),_=o[0],c=o[1];e=s.__spreadArray([],s.__read(this.index.indices({x0:_,y0:n,x1:c,y1:n})))}else{var l=this.renderer.xscale.invert(r),p=this.renderer.plot_view.frame.bbox.v_range,d=s.__read(this.renderer.yscale.r_invert(p.start,p.end),2),x=d[0],y=d[1];e=s.__spreadArray([],s.__read(this.index.indices({x0:l,y0:x,x1:l,y1:y})))}return new h.Selection({indices:e})},e.prototype.draw_legend_for_index=function(t,e,r){_.generic_area_vector_legend(this.visuals,t,e,r)},e}(o.GlyphView);r.BoxView=c,c.__name__="BoxView";var l=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Box=function(){this.mixins([a.LineVector,a.FillVector,a.HatchVector])},e}(o.Glyph);r.Box=l,l.__name__="Box",l.init_Box()},
function _(e,t,r,i,s){i();var n=e(1),a=e(287),o=n.__importStar(e(293)),_=n.__importStar(e(133)),l=e(163),c=e(135),h=e(193),d=e(292),p=e(187),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.scenterxy=function(e){return[this.sx[e],this.sy[e]]},t.prototype._set_data=function(){var e=this.model,t=e.orientation,r=e.size,i=e.aspect_scale,s=this.q,n=this.r,a=this.q.length;this._x=new Float64Array(a),this._y=new Float64Array(a);var o=this._x,_=this._y,l=Math.sqrt(3);if("pointytop"==t)for(var c=0;c<a;c++){var h=s.get(c),d=n.get(c)/2;o[c]=r*l*(h+d)/i,_[c]=-3*r*d}else for(c=0;c<a;c++){var p=s.get(c)/2,y=n.get(c);o[c]=3*r*p,_[c]=-r*l*(y+p)*i}},t.prototype._project_data=function(){h.inplace.project_xy(this._x,this._y)},t.prototype._index_data=function(e){var t,r=this.model.size,i=Math.sqrt(3)*r/2;"flattop"==this.model.orientation?(i=(t=n.__read([r,i],2))[0],r=t[1],r*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var s=this.data_size,a=0;a<s;a++){var o=this._x[a],_=this._y[a];e.add_rect(o-i,_-r,o+i,_+r)}},t.prototype.map_data=function(){var e,t;e=n.__read(this.renderer.coordinates.map_to_screen(this._x,this._y),2),this.sx=e[0],this.sy=e[1],t=n.__read(this._get_unscaled_vertices(),2),this.svx=t[0],this.svy=t[1]},t.prototype._get_unscaled_vertices=function(){var e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){var r=this.renderer.yscale,i=this.renderer.xscale,s=Math.abs(r.compute(0)-r.compute(e));return[[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t),-n,0,n,n],[s,a=s/2,-a,-s,-a,a]]}var n,a;r=this.renderer.xscale,i=this.renderer.yscale;return[[s=Math.abs(r.compute(0)-r.compute(e)),a=s/2,-a,-s,-a,a],[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t),-n,0,n,n]]},t.prototype._render=function(e,t,r){var i,s,a=null!=r?r:this,o=a.sx,_=a.sy,l=a.svx,c=a.svy,h=a.scale;try{for(var d=n.__values(t),p=d.next();!p.done;p=d.next()){var y=p.value,u=o[y],v=_[y],x=h.get(y);if(isFinite(u+v+x)){e.translate(u,v),e.beginPath();for(var f=0;f<6;f++)e.lineTo(l[f]*x,c[f]*x);e.closePath(),e.translate(-u,-v),this.visuals.fill.apply(e,y),this.visuals.hatch.apply(e,y),this.visuals.line.apply(e,y)}}}catch(e){i={error:e}}finally{try{p&&!p.done&&(s=d.return)&&s.call(d)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i=e.sx,s=e.sy,a=this.renderer.xscale.invert(i),_=this.renderer.yscale.invert(s),l=this.index.indices({x0:a,y0:_,x1:a,y1:_}),c=[];try{for(var h=n.__values(l),d=h.next();!d.done;d=h.next()){var y=d.value;o.point_in_poly(i-this.sx[y],s-this.sy[y],this.svx,this.svy)&&c.push(y)}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=h.return)&&r.call(h)}finally{if(t)throw t.error}}return new p.Selection({indices:c})},t.prototype._hit_span=function(e){var t,r=e.sx,i=e.sy;if("v"==e.direction){var s=this.renderer.yscale.invert(i),a=this.renderer.plot_view.frame.bbox.h_range,o=n.__read(this.renderer.xscale.r_invert(a.start,a.end),2),_=o[0],l=o[1];t=n.__spreadArray([],n.__read(this.index.indices({x0:_,y0:s,x1:l,y1:s})))}else{var c=this.renderer.xscale.invert(r),h=this.renderer.plot_view.frame.bbox.v_range,d=n.__read(this.renderer.yscale.r_invert(h.start,h.end),2),y=d[0],u=d[1];t=n.__spreadArray([],n.__read(this.index.indices({x0:c,y0:y,x1:c,y1:u})))}return new p.Selection({indices:t})},t.prototype._hit_rect=function(e){var t=e.sx0,r=e.sx1,i=e.sy0,s=e.sy1,a=n.__read(this.renderer.xscale.r_invert(t,r),2),o=a[0],_=a[1],l=n.__read(this.renderer.yscale.r_invert(i,s),2),c=l[0],h=l[1],d=n.__spreadArray([],n.__read(this.index.indices({x0:o,x1:_,y0:c,y1:h})));return new p.Selection({indices:d})},t.prototype.draw_legend_for_index=function(e,t,r){d.generic_area_vector_legend(this.visuals,e,t,r)},t}(a.GlyphView);r.HexTileView=y,y.__name__="HexTileView";var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_HexTile=function(){this.prototype.default_view=y,this.mixins([l.LineVector,l.FillVector,l.HatchVector]),this.define((function(e){var t=e.Number;return{r:[_.NumberSpec,{field:"r"}],q:[_.NumberSpec,{field:"q"}],scale:[_.NumberSpec,1],size:[t,1],aspect_scale:[t,1],orientation:[c.HexTileOrientation,"pointytop"]}})),this.override({line_color:null})},t}(a.Glyph);r.HexTile=u,u.__name__="HexTile",u.init_HexTile()},
function _(e,t,n,r,i){r();var a=e(1),o=e(401),_=e(281),u=e(312),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.color_mapper.change,(function(){return t._update_image()}))},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(null),this.renderer.request_render())},t.prototype._flat_img_to_buf8=function(e){return this.model.color_mapper.rgba_mapper.v_compute(e)},t}(o.ImageBaseView);n.ImageView=p,p.__name__="ImageView";var f=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Image=function(){this.prototype.default_view=p,this.define((function(e){return{color_mapper:[(0,e.Ref)(_.ColorMapper),function(){return new u.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]}}))},t}(o.ImageBase);n.Image=f,f.__name__="Image",f.init_Image()},
function _(e,t,i,a,r){a();var s=e(1),h=e(286),n=e(139),_=s.__importStar(e(133)),d=e(187),l=e(124),o=e(144),g=e(126),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._render=function(e,t,i){var a,r,h=null!=i?i:this,n=h.image_data,_=h.sx,d=h.sy,l=h.sw,o=h.sh,g=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;try{for(var c=s.__values(t),u=c.next();!u.done;u=c.next()){var m=u.value,p=n[m],f=_[m],y=d[m],v=l[m],w=o[m];if(null!=p&&isFinite(f+y+v+w)){var x=y;e.translate(0,x),e.scale(1,-1),e.translate(0,-x),e.drawImage(p,0|f,0|y,v,w),e.translate(0,x),e.scale(1,-1),e.translate(0,-x)}}}catch(e){a={error:e}}finally{try{u&&!u.done&&(r=c.return)&&r.call(c)}finally{if(a)throw a.error}}e.setImageSmoothingEnabled(g)},t.prototype._set_data=function(e){this._set_width_heigh_data();for(var t=0,i=this.image.length;t<i;t++)if(!(null!=e&&e.indexOf(t)<0)){var a=this.image.get(t),r=void 0;o.is_NDArray(a)?(g.assert(2==a.dimension,"expected a 2D array"),r=a,this._height[t]=a.shape[0],this._width[t]=a.shape[1]):(r=l.concat(a),this._height[t]=a.length,this._width[t]=a[0].length);var s=this._flat_img_to_buf8(r);this._set_image_data_from_buffer(t,s)}},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var a=s.__read(this._lrtb(i),4),r=a[0],h=a[1],n=a[2],_=a[3];e.add_rect(r,_,h,n)}},t.prototype._lrtb=function(e){var t=this.dw.get(e),i=this.dh.get(e),a=this.renderer.xscale.source_range,r=this._x[e],h=a.is_reversed?r-t:r+t,n=this.renderer.yscale.source_range,_=this._y[e],d=n.is_reversed?_-i:_+i,l=s.__read(r<h?[r,h]:[h,r],2),o=l[0],g=l[1],c=s.__read(_<d?[_,d]:[d,_],2),u=c[0];return[o,g,c[1],u]},t.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this.image.length||(this.image_data=new Array(this.image.length)),null!=this._width&&this._width.length==this.image.length||(this._width=new Uint32Array(this.image.length)),null!=this._height&&this._height.length==this.image.length||(this._height=new Uint32Array(this.image.length))},t.prototype._get_or_create_canvas=function(e){var t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;var i=document.createElement("canvas");return i.width=this._width[e],i.height=this._height[e],i},t.prototype._set_image_data_from_buffer=function(e,t){var i=this._get_or_create_canvas(e),a=i.getContext("2d"),r=a.getImageData(0,0,this._width[e],this._height[e]);r.data.set(t),a.putImageData(r,0,0),this.image_data[e]=i},t.prototype._map_data=function(){"data"==this.model.properties.dw.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.dw,"edge",this.model.dilate):this.sw=n.to_screen(this.dw),"data"==this.model.properties.dh.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.dh,"edge",this.model.dilate):this.sh=n.to_screen(this.dh)},t.prototype._image_index=function(e,t,i){var a=s.__read(this._lrtb(e),4),r=a[0],h=a[1],n=a[2],_=a[3],d=this._width[e],l=this._height[e],o=(h-r)/d,g=(n-_)/l,c=Math.floor((t-r)/o),u=Math.floor((i-_)/g);return this.renderer.xscale.source_range.is_reversed&&(c=d-c-1),this.renderer.yscale.source_range.is_reversed&&(u=l-u-1),{index:e,dim1:c,dim2:u,flat_index:u*d+c}},t.prototype._hit_point=function(e){var t,i,a=e.sx,r=e.sy,h=this.renderer.xscale.invert(a),n=this.renderer.yscale.invert(r),_=this.index.indices({x0:h,x1:h,y0:n,y1:n}),l=new d.Selection;try{for(var o=s.__values(_),g=o.next();!g.done;g=o.next()){var c=g.value;a!=1/0&&r!=1/0&&l.image_indices.push(this._image_index(c,h,n))}}catch(e){t={error:e}}finally{try{g&&!g.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}return l},t}(h.XYGlyphView);i.ImageBaseView=c,c.__name__="ImageBaseView";var u=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_ImageBase=function(){this.define((function(e){var t=e.Boolean,i=e.Alpha;return{image:[_.NDArraySpec,{field:"image"}],dw:[_.DistanceSpec,{field:"dw"}],dh:[_.DistanceSpec,{field:"dh"}],dilate:[t,!1],global_alpha:[i,1]}}))},t}(h.XYGlyph);i.ImageBase=u,u.__name__="ImageBase",u.init_ImageBase()},
function _(e,n,t,i,a){i();var r=e(1),_=e(401),u=e(123),f=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(n,e),n.prototype._flat_img_to_buf8=function(e){var n;return n=u.isArray(e)?new Uint32Array(e):e,new Uint8ClampedArray(n.buffer)},n}(_.ImageBaseView);t.ImageRGBAView=f,f.__name__="ImageRGBAView";var m=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n.init_ImageRGBA=function(){this.prototype.default_view=f},n}(_.ImageBase);t.ImageRGBA=m,m.__name__="ImageRGBA",m.init_ImageRGBA()},
function _(e,t,r,a,i){a();var n=e(1),s=e(286),o=e(139),_=e(135),c=n.__importStar(e(133)),h=e(127),l=e(404),d=function(e){function t(){var t=e.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return t._images_rendered=!1,t._set_data_iteration=0,t}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++)e.add_empty()},t.prototype._set_data=function(){var e,t,r=this;this._set_data_iteration++;var a=this.url.length;this.image=new Array(a);for(var i=this.model,s=i.retry_attempts,_=i.retry_timeout,c=this._set_data_iteration,d=function(e){var t=u.url.get(e);if(!t)return"continue";new l.ImageLoader(t,{loaded:function(t){r._set_data_iteration==c&&(r.image[e]=t,r.renderer.request_render())},attempts:s+1,timeout:_})},u=this,p=0;p<a;p++)d(p);var f="data"==this.model.properties.w.units,m="data"==this.model.properties.h.units,g=this._x.length,y=new o.ScreenArray(f?2*g:g),b=new o.ScreenArray(m?2*g:g),w=this.model.anchor;function v(e,t){switch(w){case"top_left":case"bottom_left":case"left":case"center_left":return[e,e+t];case"top":case"top_center":case"bottom":case"bottom_center":case"center":case"center_center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"right":case"center_right":return[e-t,e]}}function x(e,t){switch(w){case"top_left":case"top":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom":case"bottom_center":case"bottom_right":return[e+t,e];case"left":case"center_left":case"center":case"center_center":case"right":case"center_right":return[e+t/2,e-t/2]}}if(f)for(p=0;p<g;p++)e=n.__read(v(this._x[p],this.w.get(p)),2),y[p]=e[0],y[g+p]=e[1];else y.set(this._x,0);if(m)for(p=0;p<g;p++)t=n.__read(x(this._y[p],this.h.get(p)),2),b[p]=t[0],b[g+p]=t[1];else b.set(this._y,0);var I=n.__read(h.minmax(y),2),A=I[0],S=I[1],L=n.__read(h.minmax(b),2),R=L[0],U=L[1];this._bounds_rect={x0:A,x1:S,y0:R,y1:U}},t.prototype.has_finished=function(){return e.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){"data"==this.model.properties.w.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.w,"edge",this.model.dilate):this.sw=o.to_screen(this.w),"data"==this.model.properties.h.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.h,"edge",this.model.dilate):this.sh=o.to_screen(this.h)},t.prototype._render=function(e,t,r){var a,i,s=null!=r?r:this,o=s.image,_=s.sx,c=s.sy,h=s.sw,l=s.sh,d=s.angle,u=this.renderer.plot_view.frame;e.beginPath(),e.rect(u.bbox.left+1,u.bbox.top+1,u.bbox.width-2,u.bbox.height-2),e.clip();var p=!0;try{for(var f=n.__values(t),m=f.next();!m.done;m=f.next()){var g=m.value;if(isFinite(_[g]+c[g]+d.get(g))){var y=o[g];null!=y?this._render_image(e,g,y,_,c,h,l,d):p=!1}}}catch(e){a={error:e}}finally{try{m&&!m.done&&(i=f.return)&&i.call(f)}finally{if(a)throw a.error}}p&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(e,t,r,a,i){switch(e){case"top_left":return[t,r];case"top":case"top_center":return[t-a/2,r];case"top_right":return[t-a,r];case"right":case"center_right":return[t-a,r-i/2];case"bottom_right":return[t-a,r-i];case"bottom":case"bottom_center":return[t-a/2,r-i];case"bottom_left":return[t,r-i];case"left":case"center_left":return[t,r-i/2];case"center":case"center_center":return[t-a/2,r-i/2]}},t.prototype._render_image=function(e,t,r,a,i,s,o,_){isFinite(s[t])||(s[t]=r.width),isFinite(o[t])||(o[t]=r.height);var c=s[t],h=o[t],l=this.model.anchor,d=n.__read(this._final_sx_sy(l,a[t],i[t],c,h),2),u=d[0],p=d[1],f=_.get(t);e.save(),e.globalAlpha=this.model.global_alpha;var m=c/2,g=h/2;f?(e.translate(u,p),e.translate(m,g),e.rotate(f),e.translate(-m,-g),e.drawImage(r,0,0,c,h),e.translate(m,g),e.rotate(-f),e.translate(-m,-g),e.translate(-u,-p)):e.drawImage(r,u,p,c,h),e.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(s.XYGlyphView);r.ImageURLView=d,d.__name__="ImageURLView";var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_ImageURL=function(){this.prototype.default_view=d,this.define((function(e){var t=e.Boolean,r=e.Int,a=e.Alpha;return{url:[c.StringSpec,{field:"url"}],anchor:[_.Anchor,"top_left"],global_alpha:[a,1],angle:[c.AngleSpec,0],w:[c.NullDistanceSpec,null],h:[c.NullDistanceSpec,null],dilate:[t,!1],retry_attempts:[r,0],retry_timeout:[r,0]}}))},t}(s.XYGlyph);r.ImageURL=u,u.__name__="ImageURL",u.init_ImageURL()},
function _(e,i,n,o,t){o();var r=e(134),a=function(){function e(e,i){var n=this;void 0===i&&(i={}),this._image=new Image,this._finished=!1;var o=i.attempts,t=void 0===o?1:o,a=i.timeout,g=void 0===a?1:a;this.promise=new Promise((function(o,a){n._image.crossOrigin="anonymous";var s=0;n._image.onerror=function(){if(++s==t){var o="unable to load "+e+" image after "+t+" attempts";if(r.logger.warn(o),null==n._image.crossOrigin)return void(null!=i.failed&&i.failed());r.logger.warn("attempting to load "+e+" without a cross origin policy"),n._image.crossOrigin=null,s=0}setTimeout((function(){return n._image.src=e}),g)},n._image.onload=function(){n._finished=!0,null!=i.loaded&&i.loaded(n._image),o(n._image)},n._image.src=e}))}return Object.defineProperty(e.prototype,"finished",{get:function(){return this._finished},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"image",{get:function(){if(this._finished)return this._image;throw new Error("not loaded yet")},enumerable:!1,configurable:!0}),e}();n.ImageLoader=a,a.__name__="ImageLoader"},
function _(t,e,i,n,r){n();var s=t(1),o=t(193),_=t(163),a=s.__importStar(t(293)),l=s.__importStar(t(133)),h=t(127),c=t(128),u=t(287),p=t(292),y=t(187),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._project_data=function(){o.inplace.project_xy(this._xs.array,this._ys.array)},e.prototype._index_data=function(t){for(var e=this.data_size,i=0;i<e;i++){var n=this._xs.get(i),r=this._ys.get(i),o=s.__read(h.minmax2(n,r),4),_=o[0],a=o[1],l=o[2],c=o[3];t.add_rect(_,l,a,c)}},e.prototype._render=function(t,e,i){var n,r,o=null!=i?i:this,_=o.sxs,a=o.sys;try{for(var l=s.__values(e),h=l.next();!h.done;h=l.next()){var c=h.value,u=_.get(c),p=a.get(c),y=Math.min(u.length,p.length),d=!0;t.beginPath();for(var f=0;f<y;f++){var v=u[f],x=p[f];isFinite(v+x)?d?(t.moveTo(v,x),d=!1):t.lineTo(v,x):d=!0}this.visuals.line.set_vectorize(t,c),t.stroke()}}catch(t){n={error:t}}finally{try{h&&!h.done&&(r=l.return)&&r.call(l)}finally{if(n)throw n.error}}},e.prototype._hit_point=function(t){for(var e={x:t.sx,y:t.sy},i=9999,n=new Map,r=0,o=this.sxs.length;r<o;r++){for(var _=Math.max(2,this.line_width.get(r)/2),l=this.sxs.get(r),h=this.sys.get(r),u=null,p=0,d=l.length-1;p<d;p++){var f={x:l[p],y:h[p]},v={x:l[p+1],y:h[p+1]},x=a.dist_to_segment(e,f,v);x<_&&x<i&&(i=x,u=[p])}null!=u&&n.set(r,u)}return new y.Selection({indices:s.__spreadArray([],s.__read(n.keys())),multiline_indices:c.to_object(n)})},e.prototype._hit_span=function(t){var e,i,n=t.sx,r=t.sy;"v"==t.direction?(e=this.renderer.yscale.invert(r),i=this._ys):(e=this.renderer.xscale.invert(n),i=this._xs);for(var o=new Map,_=0,a=i.length;_<a;_++){for(var l=i.get(_),h=[],u=0,p=l.length-1;u<p;u++)l[u]<=e&&e<=l[u+1]&&h.push(u);h.length>0&&o.set(_,h)}return new y.Selection({indices:s.__spreadArray([],s.__read(o.keys())),multiline_indices:c.to_object(o)})},e.prototype.get_interpolation_hit=function(t,e,i){var n=this._xs.get(t),r=this._ys.get(t),s=n[e],o=r[e],_=n[e+1],a=r[e+1];return p.line_interpolation(this.renderer,i,s,o,_,a)},e.prototype.draw_legend_for_index=function(t,e,i){p.generic_line_vector_legend(this.visuals,t,e,i)},e.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},e}(u.GlyphView);i.MultiLineView=d,d.__name__="MultiLineView";var f=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_MultiLine=function(){this.prototype.default_view=d,this.define((function(t){return{xs:[l.XCoordinateSeqSpec,{field:"xs"}],ys:[l.YCoordinateSeqSpec,{field:"ys"}]}})),this.mixins(_.LineVector)},e}(u.Glyph);i.MultiLine=f,f.__name__="MultiLine",f.init_MultiLine()},
function _(t,e,r,i,n){i();var s=t(1),a=t(289),o=t(287),h=t(292),l=t(127),_=t(127),y=t(163),d=s.__importStar(t(293)),f=s.__importStar(t(133)),c=t(187),p=t(126),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._project_data=function(){},e.prototype._index_data=function(t){for(var e=Math.min,r=Math.max,i=this.data_size,n=0;n<i;n++){var a=this._xs[n],o=this._ys[n];if(0!=a.length&&0!=o.length){for(var h=1/0,_=-1/0,y=1/0,d=-1/0,f=0,c=a.length;f<c;f++){var p=a[f][0],v=o[f][0];if(0!=p.length&&0!=v.length){var u=s.__read(l.minmax(p),2),x=u[0],g=u[1],m=s.__read(l.minmax(v),2),w=m[0],M=m[1];h=e(h,x),_=r(_,g),y=e(y,w),d=r(d,M)}}t.add_rect(h,y,_,d)}else t.add_empty()}this._hole_index=this._index_hole_data()},e.prototype._index_hole_data=function(){for(var t=Math.min,e=Math.max,r=this.data_size,i=new a.SpatialIndex(r),n=0;n<r;n++){var o=this._xs[n],h=this._ys[n];if(0!=o.length&&0!=h.length){for(var _=1/0,y=-1/0,d=1/0,f=-1/0,c=0,p=o.length;c<p;c++){var v=o[c],u=h[c];if(v.length>1&&u.length>1)for(var x=1,g=v.length;x<g;x++){var m=s.__read(l.minmax(v[x]),2),w=m[0],M=m[1],S=s.__read(l.minmax(u[x]),2),P=S[0],q=S[1];_=t(_,w),y=e(y,M),d=t(d,P),f=e(f,q)}}i.add_rect(_,d,y,f)}else i.add_empty()}return i.finish(),i},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame,e=t.x_range,r=t.y_range;return this.index.indices({x0:e.min,x1:e.max,y0:r.min,y1:r.max})},e.prototype._render=function(t,e,r){var i,n;if(this.visuals.fill.doit||this.visuals.line.doit){var a=null!=r?r:this,o=a.sxs,h=a.sys;try{for(var l=s.__values(e),_=l.next();!_.done;_=l.next()){var y=_.value;t.beginPath();for(var d=o[y],f=h[y],c=Math.min(d.length,f.length),p=0;p<c;p++)for(var v=d[p],u=f[p],x=Math.min(v.length,u.length),g=0;g<x;g++){for(var m=v[g],w=u[g],M=Math.min(m.length,w.length),S=0;S<M;S++){var P=m[S],q=w[S];0==S?t.moveTo(P,q):t.lineTo(P,q)}t.closePath()}this.visuals.fill.apply(t,y,"evenodd"),this.visuals.hatch.apply(t,y,"evenodd"),this.visuals.line.apply(t,y)}}catch(t){i={error:t}}finally{try{_&&!_.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}}},e.prototype._hit_rect=function(t){var e,r,i=t.sx0,n=t.sx1,a=t.sy0,o=t.sy1,h=[i,n,n,i],l=[a,a,o,o],_=s.__read(this.renderer.xscale.r_invert(i,n),2),y=_[0],f=_[1],p=s.__read(this.renderer.yscale.r_invert(a,o),2),v=p[0],u=p[1],x=this.index.indices({x0:y,x1:f,y0:v,y1:u}),g=[];try{for(var m=s.__values(x),w=m.next();!w.done;w=m.next()){for(var M=w.value,S=this.sxs[M],P=this.sys[M],q=!0,A=0,V=S.length;A<V;A++){for(var b=0,k=S[A][0].length;b<k;b++){var z=S[A][0][b],C=P[A][0][b];if(!d.point_in_poly(z,C,h,l)){q=!1;break}}if(!q)break}q&&g.push(M)}}catch(t){e={error:t}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(e)throw e.error}}return new c.Selection({indices:g})},e.prototype._hit_point=function(t){var e,r,i=t.sx,n=t.sy,a=this.renderer.xscale.invert(i),o=this.renderer.yscale.invert(n),h=this.index.indices({x0:a,y0:o,x1:a,y1:o}),l=this._hole_index.indices({x0:a,y0:o,x1:a,y1:o}),_=[];try{for(var y=s.__values(h),f=y.next();!f.done;f=y.next())for(var p=f.value,v=this.sxs[p],u=this.sys[p],x=0,g=v.length;x<g;x++){var m=v[x].length;if(d.point_in_poly(i,n,v[x][0],u[x][0]))if(1==m)_.push(p);else if(l.get(p)){if(m>1){for(var w=!1,M=1;M<m;M++){var S=v[x][M],P=u[x][M];if(d.point_in_poly(i,n,S,P)){w=!0;break}}w||_.push(p)}}else _.push(p)}}catch(t){e={error:t}}finally{try{f&&!f.done&&(r=y.return)&&r.call(y)}finally{if(e)throw e.error}}return new c.Selection({indices:_})},e.prototype._get_snap_coord=function(t){return _.sum(t)/t.length},e.prototype.scenterxy=function(t,e,r){if(1==this.sxs[t].length)return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])];for(var i=this.sxs[t],n=this.sys[t],s=0,a=i.length;s<a;s++){if(d.point_in_poly(e,r,i[s][0],n[s][0]))return[this._get_snap_coord(i[s][0]),this._get_snap_coord(n[s][0])]}p.unreachable()},e.prototype.map_data=function(){var t=this._xs.length;this.sxs=new Array(t),this.sys=new Array(t);for(var e=0;e<t;e++){var r=this._xs[e].length;this.sxs[e]=new Array(r),this.sys[e]=new Array(r);for(var i=0;i<r;i++){var n=this._xs[e][i].length;this.sxs[e][i]=new Array(n),this.sys[e][i]=new Array(n);for(var a=0;a<n;a++){var o=s.__read(this.renderer.coordinates.map_to_screen(this._xs[e][i][a],this._ys[e][i][a]),2),h=o[0],l=o[1];this.sxs[e][i][a]=h,this.sys[e][i][a]=l}}}},e.prototype.draw_legend_for_index=function(t,e,r){h.generic_area_vector_legend(this.visuals,t,e,r)},e}(o.GlyphView);r.MultiPolygonsView=v,v.__name__="MultiPolygonsView";var u=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_MultiPolygons=function(){this.prototype.default_view=v,this.define((function(t){return{xs:[f.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[f.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}})),this.mixins([y.LineVector,y.FillVector,y.HatchVector])},e}(o.Glyph);r.MultiPolygons=u,u.__name__="MultiPolygons",u.init_MultiPolygons()},
function _(t,n,i,a,l){a();var e=t(1),_=t(395),u=t(127),o=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype._map_data=function(){t.prototype._map_data.call(this),u.mul(this.sw,.75)},n}(_.EllipseOvalView);i.OvalView=o,o.__name__="OvalView";var r=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_Oval=function(){this.prototype.default_view=o},n}(_.EllipseOval);i.Oval=r,r.__name__="Oval",r.init_Oval()},
function _(e,t,r,i,n){i();var a=e(1),s=e(287),o=e(292),_=e(127),l=e(163),h=a.__importStar(e(293)),c=a.__importStar(e(133)),y=e(187),p=e(126),u=e(193),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._project_data=function(){u.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++){var i=this._xs.get(r),n=this._ys.get(r),s=a.__read(_.minmax2(i,n),4),o=s[0],l=s[1],h=s[2],c=s[3];e.add_rect(o,h,l,c)}},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame,t=e.x_range,r=e.y_range;return this.index.indices({x0:t.min,x1:t.max,y0:r.min,y1:r.max})},t.prototype._render=function(e,t,r){var i,n,s=null!=r?r:this,o=s.sxs,_=s.sys;try{for(var l=a.__values(t),h=l.next();!h.done;h=l.next()){var c=h.value,y=o.get(c),p=_.get(c),u=!0;e.beginPath();for(var f=Math.min(y.length,p.length),d=0;d<f;d++){var v=y[d],x=p[d];isFinite(v+x)?u?(e.moveTo(v,x),u=!1):e.lineTo(v,x):(e.closePath(),u=!0)}e.closePath(),this.visuals.fill.apply(e,c),this.visuals.hatch.apply(e,c),this.visuals.line.apply(e,c)}}catch(e){i={error:e}}finally{try{h&&!h.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}},t.prototype._hit_rect=function(e){var t,r,i=e.sx0,n=e.sx1,s=e.sy0,o=e.sy1,_=[i,n,n,i],l=[s,s,o,o],c=a.__read(this.renderer.xscale.r_invert(i,n),2),p=c[0],u=c[1],f=a.__read(this.renderer.yscale.r_invert(s,o),2),d=f[0],v=f[1],x=this.index.indices({x0:p,x1:u,y0:d,y1:v}),g=[];try{for(var m=a.__values(x),w=m.next();!w.done;w=m.next()){for(var b=w.value,P=this.sxs.get(b),S=this.sys.get(b),V=!0,k=0,N=P.length;k<N;k++){var j=P[k],q=S[k];if(!h.point_in_poly(j,q,_,l)){V=!1;break}}V&&g.push(b)}}catch(e){t={error:e}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new y.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,i=e.sx,n=e.sy,s=this.renderer.xscale.invert(i),o=this.renderer.yscale.invert(n),_=this.index.indices({x0:s,y0:o,x1:s,y1:o}),l=[];try{for(var c=a.__values(_),p=c.next();!p.done;p=c.next())for(var u=p.value,f=this.sxs.get(u),d=this.sys.get(u),v=f.length,x=0,g=0;;g++){if(isNaN(f[g])||g==v){var m=f.subarray(x,g),w=d.subarray(x,g);if(h.point_in_poly(i,n,m,w)){l.push(u);break}x=g+1}if(g==v)break}}catch(e){t={error:e}}finally{try{p&&!p.done&&(r=c.return)&&r.call(c)}finally{if(t)throw t.error}}return new y.Selection({indices:l})},t.prototype._get_snap_coord=function(e){return _.sum(e)/e.length},t.prototype.scenterxy=function(e,t,r){for(var i=this.sxs.get(e),n=this.sys.get(e),a=i.length,s=!1,o=0,_=0;;_++){var l=isNaN(i[_]);if(s=s||l,_==a&&!s)return[this._get_snap_coord(i),this._get_snap_coord(n)];if(l||_==a){var c=i.subarray(o,_),y=n.subarray(o,_);if(h.point_in_poly(t,r,c,y))return[this._get_snap_coord(c),this._get_snap_coord(y)];o=_+1}if(_==a)break}p.unreachable()},t.prototype.draw_legend_for_index=function(e,t,r){o.generic_area_vector_legend(this.visuals,e,t,r)},t}(s.GlyphView);r.PatchesView=f,f.__name__="PatchesView";var d=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Patches=function(){this.prototype.default_view=f,this.define((function(e){return{xs:[c.XCoordinateSeqSpec,{field:"xs"}],ys:[c.YCoordinateSeqSpec,{field:"ys"}]}})),this.mixins([l.LineVector,l.FillVector,l.HatchVector])},t}(s.Glyph);r.Patches=d,d.__name__="Patches",d.init_Patches()},
function _(t,i,e,n,o){n();var r=t(1),u=t(398),_=r.__importStar(t(133)),s=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype.scenterxy=function(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]},i.prototype._lrtb=function(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]},i}(u.BoxView);e.QuadView=s,s.__name__="QuadView";var f=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_Quad=function(){this.prototype.default_view=s,this.define((function(t){return{right:[_.XCoordinateSpec,{field:"right"}],bottom:[_.YCoordinateSpec,{field:"bottom"}],left:[_.XCoordinateSpec,{field:"left"}],top:[_.YCoordinateSpec,{field:"top"}]}}))},i}(u.Box);e.Quad=f,f.__name__="Quad",f.init_Quad()},
function _(t,e,i,r,n){r();var a=t(1),o=t(163),_=t(193),c=t(287),d=t(292),s=a.__importStar(t(133));function u(t,e,i){if(e==(t+i)/2)return[t,i];var r=(t-e)/(t-2*e+i),n=t*Math.pow(1-r,2)+2*e*(1-r)*r+i*Math.pow(r,2);return[Math.min(t,i,n),Math.max(t,i,n)]}var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e.prototype._project_data=function(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)},e.prototype._index_data=function(t){for(var e=this,i=e._x0,r=e._x1,n=e._y0,o=e._y1,_=e._cx,c=e._cy,d=e.data_size,s=0;s<d;s++){var l=i[s],p=r[s],y=n[s],f=o[s],h=_[s],x=c[s];if(isFinite(l+p+y+f+h+x)){var v=a.__read(u(l,h,p),2),m=v[0],w=v[1],C=a.__read(u(y,x,f),2),S=C[0],Q=C[1];t.add_rect(m,S,w,Q)}else t.add_empty()}},e.prototype._render=function(t,e,i){var r,n;if(this.visuals.line.doit){var o=null!=i?i:this,_=o.sx0,c=o.sy0,d=o.sx1,s=o.sy1,u=o.scx,l=o.scy;try{for(var p=a.__values(e),y=p.next();!y.done;y=p.next()){var f=y.value,h=_[f],x=c[f],v=d[f],m=s[f],w=u[f],C=l[f];isFinite(h+x+v+m+w+C)&&(t.beginPath(),t.moveTo(h,x),t.quadraticCurveTo(w,C,v,m),this.visuals.line.set_vectorize(t,f),t.stroke())}}catch(t){r={error:t}}finally{try{y&&!y.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}}},e.prototype.draw_legend_for_index=function(t,e,i){d.generic_line_vector_legend(this.visuals,t,e,i)},e.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},e}(c.GlyphView);i.QuadraticView=l,l.__name__="QuadraticView";var p=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_Quadratic=function(){this.prototype.default_view=l,this.define((function(t){return{x0:[s.XCoordinateSpec,{field:"x0"}],y0:[s.YCoordinateSpec,{field:"y0"}],x1:[s.XCoordinateSpec,{field:"x1"}],y1:[s.YCoordinateSpec,{field:"y1"}],cx:[s.XCoordinateSpec,{field:"cx"}],cy:[s.YCoordinateSpec,{field:"cy"}]}})),this.mixins(o.LineVector)},e}(c.Glyph);i.Quadratic=p,p.__name__="Quadratic",p.init_Quadratic()},
function _(t,e,n,i,r){i();var s=t(1),a=t(286),l=t(292),o=t(163),h=t(139),_=s.__importStar(t(133)),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this.length):this.slength=h.to_screen(this.length);for(var t=this.renderer.plot_view.frame.bbox,e=2*(t.width+t.height),n=this.slength,i=0,r=n.length;i<r;i++)0==n[i]&&(n[i]=e)},e.prototype._render=function(t,e,n){var i,r,a=null!=n?n:this,l=a.sx,o=a.sy,h=a.slength,_=a.angle;if(this.visuals.line.doit)try{for(var u=s.__values(e),c=u.next();!c.done;c=u.next()){var f=c.value,d=l[f],p=o[f],g=_.get(f),y=h[f];isFinite(d+p+g+y)&&(t.translate(d,p),t.rotate(g),t.beginPath(),t.moveTo(0,0),t.lineTo(y,0),this.visuals.line.set_vectorize(t,f),t.stroke(),t.rotate(-g),t.translate(-d,-p))}}catch(t){i={error:t}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}},e.prototype.draw_legend_for_index=function(t,e,n){l.generic_line_vector_legend(this.visuals,t,e,n)},e}(a.XYGlyphView);n.RayView=u,u.__name__="RayView";var c=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Ray=function(){this.prototype.default_view=u,this.mixins(o.LineVector),this.define((function(t){return{length:[_.DistanceSpec,0],angle:[_.AngleSpec,0]}}))},e}(a.XYGlyph);n.Ray=c,c.__name__="Ray",c.init_Ray()},
function _(t,e,s,i,r){i();var n=t(1),h=t(396),a=t(292),o=t(139),l=t(127),_=t(187),c=t(413),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.renderer.plot_view.canvas_view.webgl;if(null!=e){var s=e.regl_wrapper;s.has_webgl&&(this.glglyph=new c.RectGL(s,this))}},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=n.__read(this._map_dist_corner_for_data_side_length(this._x,this.width,this.renderer.xscale),2),this.sw=t[0],this.sx0=t[1];else{this.sw=o.to_screen(this.width);var s=this.sx.length;this.sx0=new o.ScreenArray(s);for(var i=0;i<s;i++)this.sx0[i]=this.sx[i]-this.sw[i]/2}if("data"==this.model.properties.height.units)e=n.__read(this._map_dist_corner_for_data_side_length(this._y,this.height,this.renderer.yscale),2),this.sh=e[0],this.sy1=e[1];else{this.sh=o.to_screen(this.height);var r=this.sy.length;this.sy1=new o.ScreenArray(r);for(i=0;i<r;i++)this.sy1[i]=this.sy[i]-this.sh[i]/2}var h=this.sw.length;this.ssemi_diag=new o.ScreenArray(h);for(i=0;i<h;i++)this.ssemi_diag[i]=Math.sqrt(this.sw[i]/2*this.sw[i]/2+this.sh[i]/2*this.sh[i]/2)},e.prototype._render=function(t,e,s){var i,r,h=null!=s?s:this,a=h.sx,o=h.sy,l=h.sx0,_=h.sy1,c=h.sw,d=h.sh,y=h.angle;try{for(var v=n.__values(e),f=v.next();!f.done;f=v.next()){var p=f.value,u=a[p],w=o[p],g=l[p],x=_[p],m=c[p],b=d[p],R=y.get(p);isFinite(u+w+g+x+m+b+R)&&(0!=m&&0!=b&&(t.beginPath(),R?(t.translate(u,w),t.rotate(R),t.rect(-m/2,-b/2,m,b),t.rotate(-R),t.translate(-u,-w)):t.rect(g,x,m,b),this.visuals.fill.apply(t,p),this.visuals.hatch.apply(t,p),this.visuals.line.apply(t,p)))}}catch(t){i={error:t}}finally{try{f&&!f.done&&(r=v.return)&&r.call(v)}finally{if(i)throw i.error}}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e,s,i=t.sx,r=t.sy,h=this.renderer.xscale.invert(i),a=this.renderer.yscale.invert(r),c=this.sx0.length,d=new o.ScreenArray(c),y=0;y<c;y++)d[y]=this.sx0[y]+this.sw[y]/2;var v=new o.ScreenArray(c);for(y=0;y<c;y++)v[y]=this.sy1[y]+this.sh[y]/2;var f,p,u=l.max(this._ddist(0,d,this.ssemi_diag)),w=l.max(this._ddist(1,v,this.ssemi_diag)),g=h-u,x=h+u,m=a-w,b=a+w,R=[];try{for(var A=n.__values(this.index.indices({x0:g,x1:x,y0:m,y1:b})),M=A.next();!M.done;M=A.next()){y=M.value;var S=this.angle.get(y);if(S){var F=Math.sin(-S),V=Math.cos(-S),z=V*(i-this.sx[y])-F*(r-this.sy[y])+this.sx[y],C=F*(i-this.sx[y])+V*(r-this.sy[y])+this.sy[y];i=z,r=C,f=Math.abs(this.sx[y]-i)<=this.sw[y]/2,p=Math.abs(this.sy[y]-r)<=this.sh[y]/2}else{var N=i-this.sx0[y],k=r-this.sy1[y];f=0<=N&&N<=this.sw[y],p=0<=k&&k<=this.sh[y]}f&&p&&R.push(y)}}catch(t){e={error:t}}finally{try{M&&!M.done&&(s=A.return)&&s.call(A)}finally{if(e)throw e.error}}return new _.Selection({indices:R})},e.prototype._map_dist_corner_for_data_side_length=function(t,e,s){for(var i=t.length,r=new Float64Array(i),n=new Float64Array(i),h=0;h<i;h++){var a=t[h],o=e.get(h)/2;r[h]=a-o,n[h]=a+o}var l=s.v_compute(r),_=s.v_compute(n),c=this.sdist(s,r,e,"edge",this.model.dilate),d=l;for(h=0;h<i;h++){var y=l[h],v=_[h];if(!isNaN(y+v)&&y!=v){d=y<v?l:_;break}}return[c,d]},e.prototype._ddist=function(t,e,s){for(var i=o.infer_type(e,s),r=0==t?this.renderer.xscale:this.renderer.yscale,n=e,h=n.length,a=new i(h),l=0;l<h;l++)a[l]=n[l]+s[l];var _=r.v_invert(n),c=r.v_invert(a),d=_.length,y=new i(d);for(l=0;l<d;l++)y[l]=Math.abs(c[l]-_[l]);return y},e.prototype.draw_legend_for_index=function(t,e,s){a.generic_area_vector_legend(this.visuals,t,e,s)},e}(h.CenterRotatableView);s.RectView=d,d.__name__="RectView";var y=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Rect=function(){this.prototype.default_view=d,this.define((function(t){return{dilate:[t.Boolean,!1]}}))},e}(h.CenterRotatable);s.Rect=y,y.__name__="Rect",y.init_Rect()},
function _(t,h,i,s,_){s();var a=t(1),e=t(295),r=t(296),l=-1e4,n=function(t){function h(h,i){var s=t.call(this,h,i)||this;return s.glyph=i,s._antialias=1.5,s}return a.__extends(h,t),h.prototype.draw=function(t,h,i){var s=h.glglyph;s.data_changed&&(s._set_data(),s.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);var _=s._centers.length/2;if(null==this._show&&(this._show=new Uint8Array(_)),t.length<_){this._show_all=!1;for(var a=0;a<_;a++)this._show[a]=0;for(var e=0;e<t.length;e++)this._show[t[e]]=255}else if(!this._show_all){this._show_all=!0;for(a=0;a<_;a++)this._show[a]=255}if(this._have_hatch){var r={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[i.width,i.height],pixel_ratio:i.pixel_ratio,center:s._centers,width:s._widths,height:s._heights,angle:s._angles,nmarkers:_,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,line_join:this._line_joins,show:this._show,hatch_pattern:this._hatch_patterns,hatch_scale:this._hatch_scales,hatch_weight:this._hatch_weights,hatch_color:this._hatch_rgba};this.regl_wrapper.rect_hatch()(r)}else{r={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[i.width,i.height],pixel_ratio:i.pixel_ratio,center:s._centers,width:s._widths,height:s._heights,angle:s._angles,nmarkers:_,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,line_join:this._line_joins,show:this._show};this.regl_wrapper.rect_no_hatch()(r)}},h.prototype._set_data=function(){var t=this.glyph.sx.length;null!=this._centers&&this._centers.length==2*t||(this._centers=new Float32Array(2*t));for(var h=0;h<t;h++)isFinite(this.glyph.sx[h])&&isFinite(this.glyph.sy[h])?(this._centers[2*h]=this.glyph.sx[h],this._centers[2*h+1]=this.glyph.sy[h]):(this._centers[2*h]=l,this._centers[2*h+1]=l);this._widths=this.glyph.sw,this._heights=this.glyph.sh,this._angles=r.prop_as_array(this.glyph.angle)},h.prototype._set_visuals=function(){var t=this.glyph.visuals.fill,h=this.glyph.visuals.line;if(this._linewidths=r.prop_as_array(h.line_width),this._line_joins=r.line_join_prop_as_array(h.line_join),this._line_rgba=r.color_to_uint8_array(h.line_color,h.line_alpha),this._fill_rgba=r.color_to_uint8_array(t.fill_color,t.fill_alpha),this._have_hatch=this.glyph.visuals.hatch.doit,this._have_hatch){var i=this.glyph.visuals.hatch;this._hatch_patterns=r.hatch_pattern_prop_as_array(i.hatch_pattern),this._hatch_scales=r.prop_as_array(i.hatch_scale),this._hatch_weights=r.prop_as_array(i.hatch_weight),this._hatch_rgba=r.color_to_uint8_array(i.hatch_color,i.hatch_alpha)}},h}(e.BaseGLGlyph);i.RectGL=n,n.__name__="RectGL"},
function _(e,r,t,a,i){a();var n=e(1),_=e(415),l=e(416),s=e(393),o=n.__importStar(e(133)),u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.prototype._init_webgl=function(){var e=this.renderer.plot_view.canvas_view.webgl;if(null!=e){var r=e.regl_wrapper;if(r.has_webgl){var t=new Set(this.marker);if(1==t.size){var a=n.__read(n.__spreadArray([],n.__read(t)),1)[0];if(s.MarkerGL.is_supported(a)){var i=this.glglyph;if(null==i||i.marker_type!=a)return void(this.glglyph=new s.MarkerGL(r,this,a))}}}}delete this.glglyph},r.prototype._set_data=function(r){e.prototype._set_data.call(this,r),this._init_webgl()},r.prototype._render=function(e,r,t){var a,i,_=null!=t?t:this,s=_.sx,o=_.sy,u=_.size,c=_.angle,f=_.marker;try{for(var h=n.__values(r),p=h.next();!p.done;p=h.next()){var g=p.value,d=s[g],v=o[g],y=u.get(g),w=c.get(g),k=f.get(g);if(isFinite(d+v+y+w)&&null!=k){var m=y/2;e.beginPath(),e.translate(d,v),w&&e.rotate(w),l.marker_funcs[k](e,g,m,this.visuals),w&&e.rotate(-w),e.translate(-d,-v)}}}catch(e){a={error:e}}finally{try{p&&!p.done&&(i=h.return)&&i.call(h)}finally{if(a)throw a.error}}},r.prototype.draw_legend_for_index=function(e,r,t){var a=r.x0,i=r.x1,_=r.y0,l=r.y1,s=t+1,u=this.marker.get(t),c=n.__assign(n.__assign({},this._get_legend_args({x0:a,x1:i,y0:_,y1:l},t)),{marker:new o.UniformScalar(u,s)});this._render(e,[t],c)},r}(_.MarkerView);t.ScatterView=u,u.__name__="ScatterView";var c=function(e){function r(r){return e.call(this,r)||this}return n.__extends(r,e),r.init_Scatter=function(){this.prototype.default_view=u,this.define((function(){return{marker:[o.MarkerSpec,{value:"circle"}]}}))},r}(_.Marker);t.Scatter=c,c.__name__="Scatter",c.init_Scatter()},
function _(e,r,t,n,i){n();var a=e(1),s=e(286),_=e(163),o=a.__importStar(e(293)),l=a.__importStar(e(133)),h=e(124),d=e(187),c=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(r,e),r.prototype._render=function(e,r,t){var n,i,s=null!=t?t:this,_=s.sx,o=s.sy,l=s.size,h=s.angle;try{for(var d=a.__values(r),c=d.next();!c.done;c=d.next()){var y=c.value,x=_[y],u=o[y],p=l.get(y),v=h.get(y);if(isFinite(x+u+p+v)){var f=p/2;e.beginPath(),e.translate(x,u),v&&e.rotate(v),this._render_one(e,y,f,this.visuals),v&&e.rotate(-v),e.translate(-x,-u)}}}catch(e){n={error:e}}finally{try{c&&!c.done&&(i=d.return)&&i.call(d)}finally{if(n)throw n.error}}},r.prototype._mask_data=function(){var e=this,r=this.renderer.plot_view.frame,t=r.x_target,n=r.y_target,i=t.widen(this.max_size).map((function(r){return e.renderer.xscale.invert(r)})),a=n.widen(this.max_size).map((function(r){return e.renderer.yscale.invert(r)}));return this.index.indices({x0:i.start,x1:i.end,y0:a.start,y1:a.end})},r.prototype._hit_point=function(e){var r,t,n=e.sx,i=e.sy,s=this.max_size,_=this.model.hit_dilation,o=n-s*_,l=n+s*_,h=a.__read(this.renderer.xscale.r_invert(o,l),2),c=h[0],y=h[1],x=i-s*_,u=i+s*_,p=a.__read(this.renderer.yscale.r_invert(x,u),2),v=p[0],f=p[1],g=this.index.indices({x0:c,x1:y,y0:v,y1:f}),m=[];try{for(var w=a.__values(g),S=w.next();!S.done;S=w.next()){var M=S.value,z=this.size.get(M)/2*_;Math.abs(this.sx[M]-n)<=z&&Math.abs(this.sy[M]-i)<=z&&m.push(M)}}catch(e){r={error:e}}finally{try{S&&!S.done&&(t=w.return)&&t.call(w)}finally{if(r)throw r.error}}return new d.Selection({indices:m})},r.prototype._hit_span=function(e){var r,t,n,i,s,_,o=e.sx,l=e.sy,h=this.bounds(),c=this.max_size/2;if("h"==e.direction){s=h.y0,_=h.y1;var y=o-c,x=o+c;n=(r=a.__read(this.renderer.xscale.r_invert(y,x),2))[0],i=r[1]}else{n=h.x0,i=h.x1;var u=l-c,p=l+c;s=(t=a.__read(this.renderer.yscale.r_invert(u,p),2))[0],_=t[1]}var v=a.__spreadArray([],a.__read(this.index.indices({x0:n,x1:i,y0:s,y1:_})));return new d.Selection({indices:v})},r.prototype._hit_rect=function(e){var r=e.sx0,t=e.sx1,n=e.sy0,i=e.sy1,s=a.__read(this.renderer.xscale.r_invert(r,t),2),_=s[0],o=s[1],l=a.__read(this.renderer.yscale.r_invert(n,i),2),h=l[0],c=l[1],y=a.__spreadArray([],a.__read(this.index.indices({x0:_,x1:o,y0:h,y1:c})));return new d.Selection({indices:y})},r.prototype._hit_poly=function(e){for(var r=e.sx,t=e.sy,n=h.range(0,this.sx.length),i=[],a=0,s=n.length;a<s;a++){var _=n[a];o.point_in_poly(this.sx[a],this.sy[a],r,t)&&i.push(_)}return new d.Selection({indices:i})},r.prototype._get_legend_args=function(e,r){var t=e.x0,n=e.x1,i=e.y0,a=e.y1,s=r+1,_=new Array(s),o=new Array(s);_[r]=(t+n)/2,o[r]=(i+a)/2;var h=.4*Math.min(Math.abs(n-t),Math.abs(a-i));return{sx:_,sy:o,size:new l.UniformScalar(h,s),angle:new l.UniformScalar(0,s)}},r.prototype.draw_legend_for_index=function(e,r,t){var n=r.x0,i=r.x1,a=r.y0,s=r.y1,_=this._get_legend_args({x0:n,x1:i,y0:a,y1:s},t);this._render(e,[t],_)},r}(s.XYGlyphView);t.MarkerView=c,c.__name__="MarkerView";var y=function(e){function r(r){return e.call(this,r)||this}return a.__extends(r,e),r.init_Marker=function(){this.mixins([_.LineVector,_.FillVector,_.HatchVector]),this.define((function(e){var r=e.Number;return{size:[l.ScreenSizeSpec,{value:4}],angle:[l.AngleSpec,0],hit_dilation:[r,1]}}))},r}(s.XYGlyph);t.Marker=y,y.__name__="Marker",y.init_Marker()},
function _(l,i,o,n,e){n();var t=Math.sqrt(3),a=Math.sqrt(5),c=(a+1)/4,p=Math.sqrt((5-a)/8),r=(a-1)/4,h=Math.sqrt((5+a)/8);function u(l,i){l.rotate(Math.PI/4),T(l,i),l.rotate(-Math.PI/4)}function f(l,i){var o=i*t,n=o/3;l.moveTo(-o/2,-n),l.lineTo(0,0),l.lineTo(o/2,-n),l.lineTo(0,0),l.lineTo(0,i)}function T(l,i){l.moveTo(0,i),l.lineTo(0,-i),l.moveTo(-i,0),l.lineTo(i,0)}function y(l,i){l.moveTo(0,i),l.lineTo(i/1.5,0),l.lineTo(0,-i),l.lineTo(-i/1.5,0),l.closePath()}function s(l,i){var o=i*t,n=o/3;l.moveTo(-i,n),l.lineTo(i,n),l.lineTo(0,n-o),l.closePath()}function v(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function d(l,i,o,n){y(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function _(l,i,o,n){!function(l,i){l.beginPath(),l.arc(0,0,i/4,0,2*Math.PI,!1),l.closePath()}(l,o),n.line.set_vectorize(l,i),l.fillStyle=l.strokeStyle,l.fill()}function P(l,i,o,n){!function(l,i){var o=i/2,n=t*o;l.moveTo(i,0),l.lineTo(o,-n),l.lineTo(-o,-n),l.lineTo(-i,0),l.lineTo(-o,n),l.lineTo(o,n),l.closePath()}(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function m(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function q(l,i,o,n){!function(l,i){var o=Math.sqrt(5-2*a)*i;l.moveTo(0,-i),l.lineTo(o*r,o*h-i),l.lineTo(o*(1+r),o*h-i),l.lineTo(o*(1+r-c),o*(h+p)-i),l.lineTo(o*(1+2*r-c),o*(2*h+p)-i),l.lineTo(0,2*o*h-i),l.lineTo(-o*(1+2*r-c),o*(2*h+p)-i),l.lineTo(-o*(1+r-c),o*(h+p)-i),l.lineTo(-o*(1+r),o*h-i),l.lineTo(-o*r,o*h-i),l.closePath()}(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function M(l,i,o,n){s(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}o.marker_funcs={asterisk:function(l,i,o,n){T(l,o),u(l,o),n.line.apply(l,i)},circle:v,circle_cross:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),T(l,o),l.stroke())},circle_dot:function(l,i,o,n){v(l,i,o,n),_(l,i,o,n)},circle_y:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),f(l,o),l.stroke())},circle_x:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),u(l,o),l.stroke())},cross:function(l,i,o,n){T(l,o),n.line.apply(l,i)},diamond:d,diamond_dot:function(l,i,o,n){d(l,i,o,n),_(l,i,o,n)},diamond_cross:function(l,i,o,n){y(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o/1.5,0),l.lineTo(o/1.5,0),l.stroke())},dot:_,hex:P,hex_dot:function(l,i,o,n){P(l,i,o,n),_(l,i,o,n)},inverted_triangle:function(l,i,o,n){l.rotate(Math.PI),s(l,o),l.rotate(-Math.PI),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},plus:function(l,i,o,n){var e=3*o/8,t=[e,e,o,o,e,e,-e,-e,-o,-o,-e,-e],a=[o,e,e,-e,-e,-o,-o,-e,-e,e,e,o];l.beginPath();for(var c=0;c<12;c++)l.lineTo(t[c],a[c]);l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},square:m,square_cross:function(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),T(l,o),l.stroke())},square_dot:function(l,i,o,n){m(l,i,o,n),_(l,i,o,n)},square_pin:function(l,i,o,n){var e=3*o/8;l.moveTo(-o,-o),l.quadraticCurveTo(0,-e,o,-o),l.quadraticCurveTo(e,0,o,o),l.quadraticCurveTo(0,e,-o,o),l.quadraticCurveTo(-e,0,-o,-o),l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},square_x:function(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),l.moveTo(-o,o),l.lineTo(o,-o),l.moveTo(-o,-o),l.lineTo(o,o),l.stroke())},star:q,star_dot:function(l,i,o,n){q(l,i,o,n),_(l,i,o,n)},triangle:M,triangle_dot:function(l,i,o,n){M(l,i,o,n),_(l,i,o,n)},triangle_pin:function(l,i,o,n){var e=o*t,a=e/3,c=3*a/8;l.moveTo(-o,a),l.quadraticCurveTo(0,c,o,a),l.quadraticCurveTo(t*c/2,c/2,0,a-e),l.quadraticCurveTo(-t*c/2,c/2,-o,a),l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},dash:function(l,i,o,n){!function(l,i){l.moveTo(-i,0),l.lineTo(i,0)}(l,o),n.line.apply(l,i)},x:function(l,i,o,n){u(l,o),n.line.apply(l,i)},y:function(l,i,o,n){f(l,o),n.line.apply(l,i)}}},
function _(e,t,r,i,n){i();var s=e(1),a=s.__importStar(e(293)),_=s.__importStar(e(133)),o=e(163),h=e(193),l=e(287),d=e(292),y=e(187),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._project_data=function(){h.inplace.project_xy(this._x0,this._y0),h.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=Math.min,r=Math.max,i=this,n=i._x0,s=i._x1,a=i._y0,_=i._y1,o=i.data_size,h=0;h<o;h++){var l=n[h],d=s[h],y=a[h],c=_[h];e.add_rect(t(l,d),t(y,c),r(l,d),r(y,c))}},t.prototype._render=function(e,t,r){var i,n;if(this.visuals.line.doit){var a=null!=r?r:this,_=a.sx0,o=a.sy0,h=a.sx1,l=a.sy1;try{for(var d=s.__values(t),y=d.next();!y.done;y=d.next()){var c=y.value,x=_[c],u=o[c],p=h[c],v=l[c];isFinite(x+u+p+v)&&(e.beginPath(),e.moveTo(x,u),e.lineTo(p,v),this.visuals.line.set_vectorize(e,c),e.stroke())}}catch(e){i={error:e}}finally{try{y&&!y.done&&(n=d.return)&&n.call(d)}finally{if(i)throw i.error}}}},t.prototype._hit_point=function(e){var t,r,i=e.sx,n=e.sy,_={x:i,y:n},o=s.__read(this.renderer.xscale.r_invert(i-2,i+2),2),h=o[0],l=o[1],d=s.__read(this.renderer.yscale.r_invert(n-2,n+2),2),c=d[0],x=d[1],u=this.index.indices({x0:h,y0:c,x1:l,y1:x}),p=[];try{for(var v=s.__values(u),f=v.next();!f.done;f=v.next()){var m=f.value,g=Math.pow(Math.max(2,this.line_width.get(m)/2),2),w={x:this.sx0[m],y:this.sy0[m]},S={x:this.sx1[m],y:this.sy1[m]};a.dist_to_segment_squared(_,w,S)<g&&p.push(m)}}catch(e){t={error:e}}finally{try{f&&!f.done&&(r=v.return)&&r.call(v)}finally{if(t)throw t.error}}return new y.Selection({indices:p})},t.prototype._hit_span=function(e){var t,r,i,n,a,_,o,h=s.__read(this.renderer.plot_view.frame.bbox.ranges,2),l=h[0],d=h[1],c=e.sx,x=e.sy;"v"==e.direction?(o=this.renderer.yscale.invert(x),a=(t=s.__read([this._y0,this._y1],2))[0],_=t[1]):(o=this.renderer.xscale.invert(c),a=(r=s.__read([this._x0,this._x1],2))[0],_=r[1]);var u=[],p=s.__read(this.renderer.xscale.r_invert(l.start,l.end),2),v=p[0],f=p[1],m=s.__read(this.renderer.yscale.r_invert(d.start,d.end),2),g=m[0],w=m[1],S=this.index.indices({x0:v,y0:g,x1:f,y1:w});try{for(var M=s.__values(S),b=M.next();!b.done;b=M.next()){var C=b.value;(a[C]<=o&&o<=_[C]||_[C]<=o&&o<=a[C])&&u.push(C);var V=1.5+this.line_width.get(C)/2;a[C]==_[C]&&("h"==e.direction?Math.abs(this.sx0[C]-c)<=V&&u.push(C):Math.abs(this.sy0[C]-x)<=V&&u.push(C))}}catch(e){i={error:e}}finally{try{b&&!b.done&&(n=M.return)&&n.call(M)}finally{if(i)throw i.error}}return new y.Selection({indices:u})},t.prototype.scenterxy=function(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]},t.prototype.draw_legend_for_index=function(e,t,r){d.generic_line_vector_legend(this.visuals,e,t,r)},t}(l.GlyphView);r.SegmentView=c,c.__name__="SegmentView";var x=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Segment=function(){this.prototype.default_view=c,this.define((function(e){return{x0:[_.XCoordinateSpec,{field:"x0"}],y0:[_.YCoordinateSpec,{field:"y0"}],x1:[_.XCoordinateSpec,{field:"x1"}],y1:[_.YCoordinateSpec,{field:"y1"}]}})),this.mixins(o.LineVector)},t}(l.Glyph);r.Segment=x,x.__name__="Segment",x.init_Segment()},
function _(t,i,e,n,s){n();var _=t(1),o=t(286),r=_.__importStar(t(163)),l=t(419),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(i,t),i.prototype._set_data=function(){var t,i=this.model,e=i.tension,n=i.closed;t=_.__read(l.catmullrom_spline(this._x,this._y,20,e,n),2),this._xt=t[0],this._yt=t[1]},i.prototype._map_data=function(){var t=this.renderer.coordinates,i=t.x_scale,e=t.y_scale;this.sxt=i.v_compute(this._xt),this.syt=e.v_compute(this._yt)},i.prototype._render=function(t,i,e){var n=null!=e?e:this,s=n.sxt,_=n.syt,o=!0;t.beginPath();for(var r=s.length,l=0;l<r;l++){var a=s[l],u=_[l];isFinite(a+u)?o?(t.moveTo(a,u),o=!1):t.lineTo(a,u):o=!0}this.visuals.line.set_value(t),t.stroke()},i}(o.XYGlyphView);e.SplineView=a,a.__name__="SplineView";var u=function(t){function i(i){return t.call(this,i)||this}return _.__extends(i,t),i.init_Spline=function(){this.prototype.default_view=a,this.mixins(r.LineScalar),this.define((function(t){var i=t.Boolean;return{tension:[t.Number,.5],closed:[i,!1]}}))},i}(o.XYGlyph);e.Spline=u,u.__name__="Spline",u.init_Spline()},
function _(e,n,r,t,a){t();var o=e(139),v=e(126);r.catmullrom_spline=function(e,n,r,t,a){void 0===r&&(r=10),void 0===t&&(t=.5),void 0===a&&(a=!1),v.assert(e.length==n.length);var i=e.length,f=a?i+1:i,l=o.infer_type(e,n),w=new l(f+2),s=new l(f+2);w.set(e,1),s.set(n,1),a?(w[0]=e[i-1],s[0]=n[i-1],w[f]=e[0],s[f]=n[0],w[f+1]=e[1],s[f+1]=n[1]):(w[0]=e[0],s[0]=n[0],w[f+1]=e[i-1],s[f+1]=n[i-1]);for(var h=new l(4*(r+1)),u=0,c=0;u<=r;u++){var d=u/r,g=Math.pow(d,2),p=d*g;h[c++]=2*p-3*g+1,h[c++]=-2*p+3*g,h[c++]=p-2*g+d,h[c++]=p-g}var _=new l((f-1)*(r+1)),m=new l((f-1)*(r+1)),y=1;for(c=0;y<f;y++){var M=(w[y+1]-w[y-1])*t,b=(s[y+1]-s[y-1])*t,j=(w[y+2]-w[y])*t,k=(s[y+2]-s[y])*t;for(u=0;u<=4*r;c++){var q=h[u++],x=h[u++],z=h[u++],A=h[u++];_[c]=q*w[y]+x*w[y+1]+z*M+A*j,m[c]=q*s[y]+x*s[y+1]+z*b+A*k}}return[_,m]}},
function _(e,t,n,r,i){r();var o=e(1),a=e(286),_=e(292),l=o.__importStar(e(163)),s=e(135),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._render=function(e,t,n){var r,i,a,_,l,s,u,d,c=null!=n?n:this,f=c.sx,h=c.sy,p=!1,v=null;this.visuals.line.set_value(e);var y=t.length;if(!(y<2)){e.beginPath(),e.moveTo(f[0],h[0]);try{for(var m=o.__values(t),w=m.next();!w.done;w=m.next()){var S=w.value,b=void 0,x=void 0,g=void 0,k=void 0;switch(this.model.mode){case"before":b=(a=o.__read([f[S-1],h[S]],2))[0],g=a[1],x=(_=o.__read([f[S],h[S]],2))[0],k=_[1];break;case"after":b=(l=o.__read([f[S],h[S-1]],2))[0],g=l[1],x=(s=o.__read([f[S],h[S]],2))[0],k=s[1];break;case"center":var T=(f[S-1]+f[S])/2;b=(u=o.__read([T,h[S-1]],2))[0],g=u[1],x=(d=o.__read([T,h[S]],2))[0],k=d[1];break;default:throw new Error("unexpected")}if(p){if(!isFinite(f[S]+h[S])){e.stroke(),e.beginPath(),p=!1,v=S;continue}null!=v&&S-v>1&&(e.stroke(),p=!1)}p?(e.lineTo(b,g),e.lineTo(x,k)):(e.beginPath(),e.moveTo(f[S],h[S]),p=!0),v=S}}catch(e){r={error:e}}finally{try{w&&!w.done&&(i=m.return)&&i.call(m)}finally{if(r)throw r.error}}e.lineTo(f[y-1],h[y-1]),e.stroke()}},t.prototype.draw_legend_for_index=function(e,t,n){_.generic_line_scalar_legend(this.visuals,e,t)},t}(a.XYGlyphView);n.StepView=u,u.__name__="StepView";var d=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_Step=function(){this.prototype.default_view=u,this.mixins(l.LineScalar),this.define((function(){return{mode:[s.StepMode,"before"]}}))},t}(a.XYGlyph);n.Step=d,d.__name__="Step",d.init_Step()},
function _(t,e,i,n,r){n();var s=t(1),o=t(286),a=t(163),_=s.__importStar(t(293)),l=s.__importStar(t(133)),h=t(238),u=t(126),f=t(187),x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._rotate_point=function(t,e,i,n,r){return[(t-i)*Math.cos(r)-(e-n)*Math.sin(r)+i,(t-i)*Math.sin(r)+(e-n)*Math.cos(r)+n]},e.prototype._text_bounds=function(t,e,i,n){return[[t,t+i,t+i,t,t],[e,e,e-n,e-n,e]]},e.prototype._render=function(t,e,i){var n,r,o,a,_=null!=i?i:this,l=_.sx,u=_.sy,f=_.x_offset,x=_.y_offset,p=_.angle,c=_.text;this._sys=[],this._sxs=[];try{for(var v=s.__values(e),d=v.next();!d.done;d=v.next()){var y=d.value,g=this._sxs[y]=[],m=this._sys[y]=[],w=l[y],b=u[y],T=f.get(y),S=x.get(y),M=p.get(y),V=c.get(y);if(isFinite(w+b+T+S+M)&&null!=V&&this.visuals.text.doit){var k=""+V;t.save(),t.translate(w+T,b+S),t.rotate(M),this.visuals.text.set_vectorize(t,y);var N=this.visuals.text.font_value(y),G=h.font_metrics(N).height,X=this.text_line_height.get(y)*G;if(-1==k.indexOf("\n")){t.fillText(k,0,0);var Y=w+T,z=b+S,A=t.measureText(k).width,F=s.__read(this._text_bounds(Y,z,A,X),2),O=F[0],j=F[1];g.push(O),m.push(j)}else{var q=k.split("\n"),B=X*q.length,C=this.text_baseline.get(y),D=void 0;switch(C){case"top":D=0;break;case"middle":D=-B/2+X/2;break;case"bottom":D=-B+X;break;default:D=0,console.warn("'"+C+"' baseline not supported with multi line text")}try{for(var E=(o=void 0,s.__values(q)),H=E.next();!H.done;H=E.next()){var I=H.value;t.fillText(I,0,D);Y=w+T,z=D+b+S,A=t.measureText(I).width;var J=s.__read(this._text_bounds(Y,z,A,X),2);O=J[0],j=J[1];g.push(O),m.push(j),D+=X}}catch(t){o={error:t}}finally{try{H&&!H.done&&(a=E.return)&&a.call(E)}finally{if(o)throw o.error}}}t.restore()}}}catch(t){n={error:t}}finally{try{d&&!d.done&&(r=v.return)&&r.call(v)}finally{if(n)throw n.error}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=[],r=0;r<this._sxs.length;r++)for(var o=this._sxs[r],a=this._sys[r],l=o.length,h=0,u=l;h<u;h++){var x=s.__read(this._rotate_point(e,i,o[l-1][0],a[l-1][0],-this.angle.get(r)),2),p=x[0],c=x[1];_.point_in_poly(p,c,o[h],a[h])&&n.push(r)}return new f.Selection({indices:n})},e.prototype.scenterxy=function(t){var e=this._sxs[t],i=this._sys[t];u.assert(0!=e.length&&0!=i.length);var n=e[0][0],r=i[0][0],o=(e[0][2]+n)/2,a=(i[0][2]+r)/2,_=s.__read(this._rotate_point(o,a,n,r,this.angle.get(t)),2);return[_[0],_[1]]},e}(o.XYGlyphView);i.TextView=x,x.__name__="TextView";var p=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Text=function(){this.prototype.default_view=x,this.mixins(a.TextVector),this.define((function(t){return{text:[l.NullStringSpec,{field:"text"}],angle:[l.AngleSpec,0],x_offset:[l.NumberSpec,0],y_offset:[l.NumberSpec,0]}}))},e}(o.XYGlyph);i.Text=p,p.__name__="Text",p.init_Text()},
function _(t,e,i,s,r){s();var n=t(1),o=t(398),h=t(139),a=n.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterxy=function(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]},e.prototype._lrtb=function(t){var e=this.width.get(t)/2,i=this._x[t],s=this._top[t],r=this._bottom[t];return[i-e,i+e,Math.max(s,r),Math.min(s,r)]},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new h.ScreenArray(t),this.sright=new h.ScreenArray(t);for(var e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()},e}(o.BoxView);i.VBarView=_,_.__name__="VBarView";var c=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_VBar=function(){this.prototype.default_view=_,this.define((function(t){return{x:[a.XCoordinateSpec,{field:"x"}],bottom:[a.YCoordinateSpec,{value:0}],width:[a.NumberSpec,{value:1}],top:[a.YCoordinateSpec,{field:"top"}]}}))},e}(o.Box);i.VBar=c,c.__name__="VBar",c.init_VBar()},
function _(e,t,r,i,n){i();var a=e(1),s=e(286),l=e(292),o=e(163),d=e(139),h=e(135),_=a.__importStar(e(133)),c=e(125),u=e(187),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=d.to_screen(this.radius)},t.prototype._render=function(e,t,r){var i,n,s=null!=r?r:this,l=s.sx,o=s.sy,d=s.sradius,h=s.start_angle,_=s.end_angle,c="anticlock"==this.model.direction;try{for(var u=a.__values(t),p=u.next();!p.done;p=u.next()){var y=p.value,f=l[y],g=o[y],v=d[y],x=h.get(y),w=_.get(y);isFinite(f+g+v+x+w)&&(e.beginPath(),e.arc(f,g,v,x,w,c),e.lineTo(f,g),e.closePath(),this.visuals.fill.apply(e,y),this.visuals.hatch.apply(e,y),this.visuals.line.apply(e,y))}}catch(e){i={error:e}}finally{try{p&&!p.done&&(n=u.return)&&n.call(u)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,n,s,l,o,d,h,_,p,y,f,g,v,x,w=e.sx,m=e.sy,M=this.renderer.xscale.invert(w),V=this.renderer.yscale.invert(m),W=2*this.max_radius;"data"===this.model.properties.radius.units?(f=M-W,g=M+W,v=V-W,x=V+W):(h=w-W,_=w+W,f=(t=a.__read(this.renderer.xscale.r_invert(h,_),2))[0],g=t[1],p=m-W,y=m+W,v=(r=a.__read(this.renderer.yscale.r_invert(p,y),2))[0],x=r[1]);var S=[];try{for(var k=a.__values(this.index.indices({x0:f,x1:g,y0:v,y1:x})),b=k.next();!b.done;b=k.next()){var A=b.value,D=Math.pow(this.sradius[A],2);h=(s=a.__read(this.renderer.xscale.r_compute(M,this._x[A]),2))[0],_=s[1],p=(l=a.__read(this.renderer.yscale.r_compute(V,this._y[A]),2))[0],y=l[1],Math.pow(h-_,2)+Math.pow(p-y,2)<=D&&S.push(A)}}catch(e){i={error:e}}finally{try{b&&!b.done&&(n=k.return)&&n.call(k)}finally{if(i)throw i.error}}var F="anticlock"==this.model.direction,G=[];try{for(var P=a.__values(S),X=P.next();!X.done;X=P.next()){A=X.value;var Y=Math.atan2(m-this.sy[A],w-this.sx[A]);c.angle_between(-Y,-this.start_angle.get(A),-this.end_angle.get(A),F)&&G.push(A)}}catch(e){o={error:e}}finally{try{X&&!X.done&&(d=P.return)&&d.call(P)}finally{if(o)throw o.error}}return new u.Selection({indices:G})},t.prototype.draw_legend_for_index=function(e,t,r){l.generic_area_vector_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=this.sradius[e]/2,r=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(s.XYGlyphView);r.WedgeView=p,p.__name__="WedgeView";var y=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Wedge=function(){this.prototype.default_view=p,this.mixins([o.LineVector,o.FillVector,o.HatchVector]),this.define((function(e){return{direction:[h.Direction,"anticlock"],radius:[_.DistanceSpec,{field:"radius"}],start_angle:[_.AngleSpec,{field:"start_angle"}],end_angle:[_.AngleSpec,{field:"end_angle"}]}}))},t}(s.XYGlyph);r.Wedge=y,y.__name__="Wedge",y.init_Wedge()},
function _(r,t,_,a,o){a();var e=r(1);e.__exportStar(r(425),_),e.__exportStar(r(426),_),e.__exportStar(r(427),_)},
function _(e,t,n,r,d){r();var o=e(1),i=e(168),_=e(127),s=e(124),a=e(187),c=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype._hit_test=function(e,t,n){if(!t.model.visible)return null;var r=n.glyph.hit_test(e);return null==r?null:n.model.view.convert_selection_from_subset(r)},t}(i.Model);n.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";var l=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.edge_view)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.edge_renderer.data_source.selected;return d.update(e,n,r),t.edge_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.model.edge_renderer.get_selection_manager().get_or_create_inspector(n.edge_view.model);return o.update(e,r,d),n.edge_view.model.data_source.setv({inspected:o},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.EdgesOnly=l,l.__name__="EdgesOnly";var u=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.node_view)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;return d.update(e,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.model.node_renderer.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.NodesOnly=u,u.__name__="NodesOnly";var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.node_view)},t.prototype.get_linked_edges=function(e,t,n){var r,d,i=[];"selection"==n?i=e.selected.indices.map((function(t){return e.data.index[t]})):"inspection"==n&&(i=e.inspected.indices.map((function(t){return e.data.index[t]})));for(var _=[],c=0;c<t.data.start.length;c++)(s.contains(i,t.data.start[c])||s.contains(i,t.data.end[c]))&&_.push(c);var l=new a.Selection;try{for(var u=o.__values(_),p=u.next();!p.done;p=u.next()){c=p.value;l.multiline_indices[c]=[0]}}catch(e){r={error:e}}finally{try{p&&!p.done&&(d=u.return)&&d.call(u)}finally{if(r)throw r.error}}return l.indices=_,l},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;d.update(e,n,r);var o=t.edge_renderer.data_source.selected,i=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),_=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.edge_view.model.data_source.setv({inspected:i},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.NodesAndLinkedEdges=p,p.__name__="NodesAndLinkedEdges";var v=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.edge_view)},t.prototype.get_linked_nodes=function(e,t,n){var r,d,i=[];"selection"==n?i=t.selected.indices:"inspection"==n&&(i=t.inspected.indices);var c=[];try{for(var l=o.__values(i),u=l.next();!u.done;u=l.next()){var p=u.value;c.push(t.data.start[p]),c.push(t.data.end[p])}}catch(e){r={error:e}}finally{try{u&&!u.done&&(d=l.return)&&d.call(l)}finally{if(r)throw r.error}}var v=s.uniq(c).map((function(t){return _.indexOf(e.data.index,t)}));return new a.Selection({indices:v})},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.edge_renderer.data_source.selected;d.update(e,n,r);var o=t.node_renderer.data_source.selected,i=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.edge_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,r,d),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),_=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.node_view.model.data_source.setv({inspected:i},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.EdgesAndLinkedNodes=v,v.__name__="EdgesAndLinkedNodes"},
function _(n,t,r,e,o){e();var i=n(1),u=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t}(n(168).Model);r.LayoutProvider=u,u.__name__="LayoutProvider"},
function _(t,a,r,n,o){n();var i=t(1),u=function(t){function a(a){return t.call(this,a)||this}return i.__extends(a,t),a.init_StaticLayoutProvider=function(){this.define((function(t){var a=t.Number,r=t.Tuple;return{graph_layout:[(0,t.Dict)(r(a,a)),{}]}}))},a.prototype.get_node_coordinates=function(t){for(var a,r=null!==(a=t.data.index)&&void 0!==a?a:[],n=r.length,o=new Float64Array(n),u=new Float64Array(n),e=0;e<n;e++){var l=this.graph_layout[r[e]],d=i.__read(null!=l?l:[NaN,NaN],2),h=d[0],s=d[1];o[e]=h,u[e]=s}return[o,u]},a.prototype.get_edge_coordinates=function(t){for(var a,r,n=null!==(a=t.data.start)&&void 0!==a?a:[],o=null!==(r=t.data.end)&&void 0!==r?r:[],i=Math.min(n.length,o.length),u=[],e=[],l=null!=t.data.xs&&null!=t.data.ys,d=0;d<i;d++){var h=null!=this.graph_layout[n[d]]&&null!=this.graph_layout[o[d]];if(l&&h)u.push(t.data.xs[d]),e.push(t.data.ys[d]);else{var s=void 0,_=void 0;h?(s=this.graph_layout[n[d]],_=this.graph_layout[o[d]]):(s=[NaN,NaN],_=[NaN,NaN]),u.push([s[0],_[0]]),e.push([s[1],_[1]])}}return[u,e]},a}(t(426).LayoutProvider);r.StaticLayoutProvider=u,u.__name__="StaticLayoutProvider",u.init_StaticLayoutProvider()},
function _(i,d,n,r,G){r(),G("Grid",i(429).Grid)},
function _(i,r,e,t,n){t();var o=i(1),a=i(240),s=i(242),_=i(243),d=o.__importStar(i(163)),l=i(123),h=function(i){function r(){return null!==i&&i.apply(this,arguments)||this}return o.__extends(r,i),r.prototype._render=function(){var i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()},r.prototype.connect_signals=function(){var r=this;i.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return r.request_render()}))},r.prototype._draw_regions=function(i){if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit)for(var r=o.__read(this.grid_coords("major",!1),2),e=r[0],t=r[1],n=0;n<e.length-1;n++)if(n%2==1){var a=o.__read(this.coordinates.map_to_screen(e[n],t[n]),2),s=a[0],_=a[1],d=o.__read(this.coordinates.map_to_screen(e[n+1],t[n+1]),2),l=d[0],h=d[1];i.beginPath(),i.rect(s[0],_[0],l[1]-s[0],h[1]-_[0]),this.visuals.band_fill.apply(i),this.visuals.band_hatch.apply(i)}},r.prototype._draw_grids=function(i){if(this.visuals.grid_line.doit){var r=o.__read(this.grid_coords("major"),2),e=r[0],t=r[1];this._draw_grid_helper(i,this.visuals.grid_line,e,t)}},r.prototype._draw_minor_grids=function(i){if(this.visuals.minor_grid_line.doit){var r=o.__read(this.grid_coords("minor"),2),e=r[0],t=r[1];this._draw_grid_helper(i,this.visuals.minor_grid_line,e,t)}},r.prototype._draw_grid_helper=function(i,r,e,t){r.set_value(i),i.beginPath();for(var n=0;n<e.length;n++){var a=o.__read(this.coordinates.map_to_screen(e[n],t[n]),2),s=a[0],_=a[1];i.moveTo(Math.round(s[0]),Math.round(_[0]));for(var d=1;d<s.length;d++)i.lineTo(Math.round(s[d]),Math.round(_[d]))}i.stroke()},r.prototype.ranges=function(){var i=this.model.dimension,r=(i+1)%2,e=this.coordinates.ranges;return[e[i],e[r]]},r.prototype.computed_bounds=function(){var i,r,e,t,n,a,s=o.__read(this.ranges(),1)[0],_=this.model.bounds,d=[s.min,s.max];if(l.isArray(_))n=Math.min(_[0],_[1]),a=Math.max(_[0],_[1]),n<d[0]&&(n=d[0]),a>d[1]&&(a=d[1]);else{n=(i=o.__read(d,2))[0],a=i[1];try{for(var h=o.__values(this.plot_view.axis_views),u=h.next();!u.done;u=h.next()){var c=u.value;c.dimension==this.model.dimension&&c.model.x_range_name==this.model.x_range_name&&c.model.y_range_name==this.model.y_range_name&&(n=(t=o.__read(c.computed_bounds,2))[0],a=t[1])}}catch(i){r={error:i}}finally{try{u&&!u.done&&(e=h.return)&&e.call(h)}finally{if(r)throw r.error}}}return[n,a]},r.prototype.grid_coords=function(i,r){var e;void 0===r&&(r=!0);var t=this.model.dimension,n=(t+1)%2,a=o.__read(this.ranges(),2),s=a[0],_=a[1],d=o.__read(this.computed_bounds(),2),l=d[0],h=d[1];l=(e=o.__read([Math.min(l,h),Math.max(l,h)],2))[0],h=e[1];var u=[[],[]],c=this.model.get_ticker();if(null==c)return u;var m=c.get_ticks(l,h,s,_.min)[i],p=s.min,g=s.max,v=_.min,f=_.max;r||(m[0]!=p&&m.splice(0,0,p),m[m.length-1]!=g&&m.push(g));for(var y=0;y<m.length;y++)if(m[y]!=p&&m[y]!=g||!r){for(var x=[],b=[],w=0;w<2;w++){var k=v+(f-v)/1*w;x.push(m[y]),b.push(k)}u[t].push(x),u[n].push(b)}return u},r}(s.GuideRendererView);e.GridView=h,h.__name__="GridView";var u=function(i){function r(r){return i.call(this,r)||this}return o.__extends(r,i),r.init_Grid=function(){this.prototype.default_view=h,this.mixins([["grid_",d.Line],["minor_grid_",d.Line],["band_",d.Fill],["band_",d.Hatch]]),this.define((function(i){var r=i.Number,e=i.Auto,t=i.Enum,n=i.Ref,o=i.Tuple,s=i.Or,d=i.Nullable;return{bounds:[s(o(r,r),e),"auto"],dimension:[t(0,1),0],axis:[d(n(a.Axis)),null],ticker:[d(n(_.Ticker)),null]}})),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},r.prototype.get_ticker=function(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null},r}(s.GuideRenderer);e.Grid=u,u.__name__="Grid",u.init_Grid()},
function _(o,a,x,B,e){B(),e("Box",o(431).Box),e("Column",o(433).Column),e("GridBox",o(434).GridBox),e("HTMLBox",o(435).HTMLBox),e("LayoutDOM",o(432).LayoutDOM),e("Panel",o(436).Panel),e("Row",o(437).Row),e("Spacer",o(438).Spacer),e("Tabs",o(439).Tabs),e("WidgetBox",o(442).WidgetBox)},
function _(n,t,e,i,o){i();var r=n(1),c=n(432),u=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return t.rebuild()}))},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.children},enumerable:!1,configurable:!0}),t}(c.LayoutDOMView);e.BoxView=u,u.__name__="BoxView";var a=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.init_Box=function(){this.define((function(n){var t=n.Number;return{children:[(0,n.Array)((0,n.Ref)(c.LayoutDOM)),[]],spacing:[t,0]}}))},t}(c.LayoutDOM);e.Box=a,a.__name__="Box",a.init_Box()},
function _(t,e,i,r,o){r();var n=t(1),l=t(168),a=t(135),s=t(158),h=t(134),u=t(123),_=t(137),c=t(228),d=t(337),p=t(318),y=t(159),f=t(346),v=function(t){function e(){var e=t.apply(this,n.__spreadArray([],n.__read(arguments)))||this;return e._offset_parent=null,e._viewport={},e}return n.__extends(e,t),Object.defineProperty(e.prototype,"is_layout_root",{get:function(){return this.is_root||!(this.parent instanceof e)},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_layout_root?"relative":"absolute",this._child_views=new Map},e.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(e){switch(e.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return e.sent(),[4,this.build_child_views()];case 2:return e.sent(),[2]}}))}))},e.prototype.remove=function(){var e,i;try{for(var r=n.__values(this.child_views),o=r.next();!o.done;o=r.next()){o.value.remove()}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}this._child_views.clear(),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.is_layout_root&&(this._on_resize=function(){return e.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((function(){var t=e.el.offsetParent;e._offset_parent!=t&&(e._offset_parent=t,null!=t&&(e.compute_viewport(),e.invalidate_layout()))}),250));var i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],(function(){return e.invalidate_layout()})),this.on_change([i.background,i.css_classes],(function(){return e.invalidate_render()}))},e.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(e.prototype,"child_views",{get:function(){var t=this;return this.child_models.map((function(e){return t._child_views.get(e)}))},enumerable:!1,configurable:!0}),e.prototype.build_child_views=function(){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(t){switch(t.label){case 0:return[4,c.build_views(this._child_views,this.child_models,{parent:this})];case 1:return t.sent(),[2]}}))}))},e.prototype.render=function(){var e,i,r;t.prototype.render.call(this),s.empty(this.el);var o=this.model.background;this.el.style.backgroundColor=null!=o?_.color2css(o):"",(e=s.classes(this.el).clear()).add.apply(e,n.__spreadArray([],n.__read(this.css_classes())));try{for(var l=n.__values(this.child_views),a=l.next();!a.done;a=l.next()){var h=a.value;this.el.appendChild(h.el),h.render()}}catch(t){i={error:t}}finally{try{a&&!a.done&&(r=l.return)&&r.call(l)}finally{if(i)throw i.error}}},e.prototype.update_layout=function(){var t,e;try{for(var i=n.__values(this.child_views),r=i.next();!r.done;r=i.next()){r.value.update_layout()}}catch(e){t={error:e}}finally{try{r&&!r.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._update_layout()},e.prototype.update_position=function(){var t,e;this.el.style.display=this.model.visible?"block":"none";var i=this.is_layout_root?this.layout.sizing.margin:void 0;s.position(this.el,this.layout.bbox,i);try{for(var r=n.__values(this.child_views),o=r.next();!o.done;o=r.next()){o.value.update_position()}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}},e.prototype.after_layout=function(){var t,e;try{for(var i=n.__values(this.child_views),r=i.next();!r.done;r=i.next()){r.value.after_layout()}}catch(e){t={error:e}}finally{try{r&&!r.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._has_finished=!0},e.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},e.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build(),this.notify_finished()},e.prototype.build=function(){if(!this.is_layout_root)throw new Error(this.toString()+" is not a root layout");return this.render(),this.update_layout(),this.compute_layout(),this},e.prototype.rebuild=function(){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),this.invalidate_render(),[2]}}))}))},e.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),h.logger.debug("layout computed in "+(Date.now()-t)+" ms")},e.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},e.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},e.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},e.prototype.has_finished=function(){var e,i;if(!t.prototype.has_finished.call(this))return!1;try{for(var r=n.__values(this.child_views),o=r.next();!o.done;o=r.next()){if(!o.value.has_finished())return!1}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}return!0},e.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},e.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},e.prototype.box_sizing=function(){var t,e=this.model,i=e.width_policy,r=e.height_policy,o=e.aspect_ratio;"auto"==i&&(i=this._width_policy()),"auto"==r&&(r=this._height_policy());var l=this.model.sizing_mode;if(null!=l)if("fixed"==l)i=r="fixed";else if("stretch_both"==l)i=r="max";else if("stretch_width"==l)i="max";else if("stretch_height"==l)r="max";else switch(null==o&&(o="auto"),l){case"scale_width":i="max",r="min";break;case"scale_height":i="min",r="max";break;case"scale_both":i="max",r="max"}var a={width_policy:i,height_policy:r},s=this.model,h=s.min_width,_=s.min_height;null!=h&&(a.min_width=h),null!=_&&(a.min_height=_);var c=this.model,d=c.width,p=c.height;null!=d&&(a.width=d),null!=p&&(a.height=p);var y=this.model,f=y.max_width,v=y.max_height;null!=f&&(a.max_width=f),null!=v&&(a.max_height=v),"auto"==o&&null!=d&&null!=p?a.aspect=d/p:u.isNumber(o)&&(a.aspect=o);var m=this.model.margin;if(null!=m)if(u.isNumber(m))a.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var g=n.__read(m,2),w=g[0],b=g[1];a.margin={top:w,right:b,bottom:w,left:b}}else{var x=n.__read(m,4),z=x[0],M=x[1],L=x[2],O=x[3];a.margin={top:z,right:M,bottom:L,left:O}}a.visible=this.model.visible;var D=this.model.align;return u.isArray(D)?(t=n.__read(D,2),a.halign=t[0],a.valign=t[1]):a.halign=a.valign=D,a},e.prototype._viewport_size=function(){var t=this;return s.undisplayed(this.el,(function(){for(var e,i,r=t.el;r=r.parentElement;)if(!r.classList.contains(y.root)){if(r==document.body){var o=s.extents(document.body).margin,l=o.left,a=o.right,h=o.top,u=o.bottom;return{width:Math.ceil(document.documentElement.clientWidth-l-a),height:Math.ceil(document.documentElement.clientHeight-h-u)}}var _=s.extents(r).padding,c=_.left,d=_.right,p=_.top,f=_.bottom,v=r.getBoundingClientRect(),m=v.width,g=v.height,w=0;try{for(var b=(e=void 0,n.__values(r.children)),x=b.next();!x.done;x=b.next()){var z=x.value,M=z.getBoundingClientRect().height,L=s.extents(z).margin;w+=M+L.top+L.bottom}}catch(t){e={error:t}}finally{try{x&&!x.done&&(i=b.return)&&i.call(b)}finally{if(e)throw e.error}}var O=Math.ceil(m-c-d),D=Math.ceil(g-p-f-w);if(O>0||D>0)return{width:O>0?O:void 0,height:D>0?D:void 0}}return{}}))},e.prototype.export=function(t,e){var i,r;void 0===e&&(e=!0);var o="png"==t?"canvas":"svg",l=new f.CanvasLayer(o,e),a=this.layout.bbox,s=a.width,h=a.height;l.resize(s,h);try{for(var u=n.__values(this.child_views),_=u.next();!_.done;_=u.next()){var c=_.value,d=c.export(t,e),p=c.layout.bbox,y=p.x,v=p.y;l.ctx.drawImage(d.canvas,y,v)}}catch(t){i={error:t}}finally{try{_&&!_.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}return l},e.prototype.serializable_state=function(){return n.__assign(n.__assign({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box,children:this.child_views.map((function(t){return t.serializable_state()}))})},e}(d.DOMView);i.LayoutDOMView=v,v.__name__="LayoutDOMView";var m=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_LayoutDOM=function(){this.define((function(t){var e=t.Boolean,i=t.Number,r=t.String,o=t.Auto,n=t.Color,l=t.Array,s=t.Tuple,h=t.Or,u=t.Null,_=t.Nullable,c=s(i,i),d=s(i,i,i,i);return{width:[_(i),null],height:[_(i),null],min_width:[_(i),null],min_height:[_(i),null],max_width:[_(i),null],max_height:[_(i),null],margin:[_(h(i,c,d)),[0,0,0,0]],width_policy:[h(p.SizingPolicy,o),"auto"],height_policy:[h(p.SizingPolicy,o),"auto"],aspect_ratio:[h(i,o,u),null],sizing_mode:[_(a.SizingMode),null],visible:[e,!0],disabled:[e,!1],align:[h(a.Align,s(a.Align,a.Align)),"start"],background:[_(n),null],css_classes:[l(r),[]]}}))},e}(l.Model);i.LayoutDOM=m,m.__name__="LayoutDOM",m.init_LayoutDOM()},
function _(t,n,i,o,u){o();var e=t(1),s=t(431),l=t(320),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new l.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},n}(s.BoxView);i.ColumnView=_,_.__name__="ColumnView";var r=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_Column=function(){this.prototype.default_view=_,this.define((function(t){return{rows:[t.Any,"auto"]}}))},n}(s.Box);i.Column=r,r.__name__="Column",r.init_Column()},
function _(t,i,o,n,e){n();var r=t(1),s=t(432),a=t(320),l=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this);var o=this.model.properties,n=o.children,e=o.rows,r=o.cols,s=o.spacing;this.on_change([n,e,r,s],(function(){return i.rebuild()}))},Object.defineProperty(i.prototype,"child_models",{get:function(){return this.model.children.map((function(t){return r.__read(t,1)[0]}))},enumerable:!1,configurable:!0}),i.prototype._update_layout=function(){var t,i;this.layout=new a.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;try{for(var o=r.__values(this.model.children),n=o.next();!n.done;n=o.next()){var e=r.__read(n.value,5),s=e[0],l=e[1],u=e[2],c=e[3],_=e[4],h=this._child_views.get(s);this.layout.items.push({layout:h.layout,row:l,col:u,row_span:c,col_span:_})}}catch(i){t={error:i}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}this.layout.set_sizing(this.box_sizing())},i}(s.LayoutDOMView);o.GridBoxView=l,l.__name__="GridBoxView";var u=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_GridBox=function(){this.prototype.default_view=l,this.define((function(t){var i=t.Any,o=t.Int,n=t.Number,e=t.Tuple,r=t.Array,a=t.Ref,l=t.Or,u=t.Opt;return{children:[r(e(a(s.LayoutDOM),o,o,u(o),u(o))),[]],rows:[i,"auto"],cols:[i,"auto"],spacing:[l(n,e(n,n)),0]}}))},i}(s.LayoutDOM);o.GridBox=u,u.__name__="GridBox",u.init_GridBox()},
function _(t,n,e,o,i){o();var u=t(1),r=t(432),_=t(318),a=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),Object.defineProperty(n.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),n.prototype._update_layout=function(){this.layout=new _.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},n}(r.LayoutDOMView);e.HTMLBoxView=a,a.__name__="HTMLBoxView";var s=function(t){function n(n){return t.call(this,n)||this}return u.__extends(n,t),n}(r.LayoutDOM);e.HTMLBox=s,s.__name__="HTMLBox"},
function _(n,t,e,i,l){i();var a=n(1),o=n(168),r=n(432),u=function(n){function t(t){return n.call(this,t)||this}return a.__extends(t,n),t.init_Panel=function(){this.define((function(n){var t=n.Boolean;return{title:[n.String,""],child:[(0,n.Ref)(r.LayoutDOM)],closable:[t,!1]}}))},t}(o.Model);e.Panel=u,u.__name__="Panel",u.init_Panel()},
function _(t,i,n,o,e){o();var s=t(1),u=t(431),_=t(320),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new _.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},i}(u.BoxView);n.RowView=a,a.__name__="RowView";var l=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_Row=function(){this.prototype.default_view=a,this.define((function(t){return{cols:[t.Any,"auto"]}}))},i}(u.Box);n.Row=l,l.__name__="Row",l.init_Row()},
function _(t,e,n,i,r){i();var o=t(1),u=t(432),a=t(318),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._update_layout=function(){this.layout=new a.LayoutItem,this.layout.set_sizing(this.box_sizing())},e}(u.LayoutDOMView);n.SpacerView=_,_.__name__="SpacerView";var c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Spacer=function(){this.prototype.default_view=_},e}(u.LayoutDOM);n.Spacer=c,c.__name__="Spacer",c.init_Spacer()},
function _(e,t,i,r,a){r();var s=e(1),l=e(318),n=e(158),o=e(124),h=e(135),c=e(432),d=e(436),u=s.__importStar(e(440)),_=u,p=s.__importStar(e(441)),v=p,f=s.__importStar(e(340)),b=f,y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,(function(){return t.rebuild()})),this.connect(this.model.properties.active.change,(function(){return t.on_active_change()}))},t.prototype.styles=function(){return s.__spreadArray(s.__spreadArray([],s.__read(e.prototype.styles.call(this))),[p.default,f.default,u.default])},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.tabs.map((function(e){return e.child}))},enumerable:!1,configurable:!0}),t.prototype._update_layout=function(){var e=this.model.tabs_location,t="above"==e||"below"==e,i=this.scroll_el,r=this.headers_el;this.header=new(function(e){function a(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(a,e),a.prototype._measure=function(a){var s=n.size(i),l=n.children(r).slice(0,3).map((function(e){return n.size(e)})),h=e.prototype._measure.call(this,a),c=h.width,d=h.height;if(t){var u=s.width+o.sum(l.map((function(e){return e.width})));return{width:a.width!=1/0?a.width:u,height:d}}var _=s.height+o.sum(l.map((function(e){return e.height})));return{width:c,height:a.height!=1/0?a.height:_}},a}(l.ContentBox))(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var a=1,h=1;switch(e){case"above":a-=1;break;case"below":a+=1;break;case"left":h-=1;break;case"right":h+=1}var c={layout:this.header,row:a,col:h},d=this.child_views.map((function(e){return{layout:e.layout,row:1,col:1}}));this.layout=new l.Grid(s.__spreadArray([c],s.__read(d))),this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){var t,i;e.prototype.update_position.call(this),this.header_el.style.position="absolute",n.position(this.header_el,this.header.bbox);var r=this.model.tabs_location,a="above"==r||"below"==r,l=n.size(this.scroll_el),o=n.scroll_size(this.headers_el);if(a){var h=this.header.bbox.width;o.width>h?(this.wrapper_el.style.maxWidth=h-l.width+"px",n.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",n.undisplay(this.scroll_el))}else{var c=this.header.bbox.height;o.height>c?(this.wrapper_el.style.maxHeight=c-l.height+"px",n.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",n.undisplay(this.scroll_el))}var d=this.child_views;try{for(var u=s.__values(d),_=u.next();!_.done;_=u.next()){var p=_.value;n.hide(p.el)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=u.return)&&i.call(u)}finally{if(t)throw t.error}}var v=d[this.model.active];null!=v&&n.show(v.el)},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=this.model.active,r=this.model.tabs_location,a="above"==r||"below"==r,s=this.model.tabs.map((function(e,r){var a=n.div({class:[_.tab,r==i?_.active:null]},e.title);if(a.addEventListener("click",(function(e){e.target==e.currentTarget&&t.change_active(r)})),e.closable){var s=n.div({class:_.close});s.addEventListener("click",(function(e){if(e.target==e.currentTarget){t.model.tabs=o.remove_at(t.model.tabs,r);var i=t.model.tabs.length;t.model.active>i-1&&(t.model.active=i-1)}})),a.appendChild(s)}return a}));this.headers_el=n.div({class:[_.headers]},s),this.wrapper_el=n.div({class:_.headers_wrapper},this.headers_el);var l=n.div({class:[v.btn,v.btn_default],disabled:""},n.div({class:[b.caret,_.left]})),h=n.div({class:[v.btn,v.btn_default]},n.div({class:[b.caret,_.right]})),c=0,d=function(e){return function(){var i=t.model.tabs.length;0==(c="left"==e?Math.max(c-1,0):Math.min(c+1,i-1))?l.setAttribute("disabled",""):l.removeAttribute("disabled"),c==i-1?h.setAttribute("disabled",""):h.removeAttribute("disabled");var r=n.children(t.headers_el).slice(0,c).map((function(e){return e.getBoundingClientRect()}));if(a){var s=-o.sum(r.map((function(e){return e.width})));t.headers_el.style.left=s+"px"}else{var d=-o.sum(r.map((function(e){return e.height})));t.headers_el.style.top=d+"px"}}};l.addEventListener("click",d("left")),h.addEventListener("click",d("right")),this.scroll_el=n.div({class:v.btn_group},l,h),this.header_el=n.div({class:[_.tabs_header,_[r]]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},t.prototype.change_active=function(e){e!=this.model.active&&(this.model.active=e)},t.prototype.on_active_change=function(){var e,t,i,r,a=this.model.active,l=n.children(this.headers_el);try{for(var o=s.__values(l),h=o.next();!h.done;h=o.next()){h.value.classList.remove(_.active)}}catch(t){e={error:t}}finally{try{h&&!h.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}l[a].classList.add(_.active);var c=this.child_views;try{for(var d=s.__values(c),u=d.next();!u.done;u=d.next()){var p=u.value;n.hide(p.el)}}catch(e){i={error:e}}finally{try{u&&!u.done&&(r=d.return)&&r.call(d)}finally{if(i)throw i.error}}n.show(c[a].el)},t}(c.LayoutDOMView);i.TabsView=y,y.__name__="TabsView";var m=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Tabs=function(){this.prototype.default_view=y,this.define((function(e){var t=e.Int;return{tabs:[(0,e.Array)((0,e.Ref)(d.Panel)),[]],tabs_location:[h.Location,"above"],active:[t,0]}}))},t}(c.LayoutDOM);i.Tabs=m,m.__name__="Tabs",m.init_Tabs()},
function _(e,r,b,o,t){o(),b.root="bk-root",b.tabs_header="bk-tabs-header",b.btn_group="bk-btn-group",b.btn="bk-btn",b.headers_wrapper="bk-headers-wrapper",b.above="bk-above",b.right="bk-right",b.below="bk-below",b.left="bk-left",b.headers="bk-headers",b.tab="bk-tab",b.active="bk-active",b.close="bk-close",b.default='.bk-root .bk-tabs-header{display:flex;flex-wrap:nowrap;align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');}.bk-root .bk-close:hover{background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');}'},
function _(o,b,r,t,e){t(),r.root="bk-root",r.btn="bk-btn",r.active="bk-active",r.btn_default="bk-btn-default",r.btn_primary="bk-btn-primary",r.btn_success="bk-btn-success",r.btn_warning="bk-btn-warning",r.btn_danger="bk-btn-danger",r.btn_light="bk-btn-light",r.btn_group="bk-btn-group",r.dropdown_toggle="bk-dropdown-toggle",r.default=".bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;flex-direction:row;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;}.bk-root .bk-btn-group > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:6px 6px;}"},
function _(t,i,n,e,o){e();var _=t(1),u=t(433),r=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(i,t),i}(u.ColumnView);n.WidgetBoxView=r,r.__name__="WidgetBoxView";var d=function(t){function i(i){return t.call(this,i)||this}return _.__extends(i,t),i.init_WidgetBox=function(){this.prototype.default_view=r},i}(u.Column);n.WidgetBox=d,d.__name__="WidgetBox",d.init_WidgetBox()},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(444).CustomJSTransform),n("Dodge",r(445).Dodge),n("Interpolator",r(447).Interpolator),n("Jitter",r(448).Jitter),n("LinearInterpolator",r(449).LinearInterpolator),n("StepInterpolator",r(450).StepInterpolator),n("Transform",r(171).Transform)},
function _(r,t,e,n,a){n();var o=r(1),s=r(171),i=r(128),u=r(149),_=function(r){function t(t){return r.call(this,t)||this}return o.__extends(t,r),t.init_CustomJSTransform=function(){this.define((function(r){var t=r.Unknown,e=r.String;return{args:[(0,r.Dict)(t),{}],func:[e,""],v_func:[e,""]}}))},Object.defineProperty(t.prototype,"names",{get:function(){return i.keys(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return i.values(this.args)},enumerable:!1,configurable:!0}),t.prototype._make_transform=function(r,t){return new(Function.bind.apply(Function,o.__spreadArray(o.__spreadArray([void 0],o.__read(this.names)),[r,u.use_strict(t)])))},Object.defineProperty(t.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!1,configurable:!0}),t.prototype.compute=function(r){return this.scalar_transform.apply(this,o.__spreadArray(o.__spreadArray([],o.__read(this.values)),[r]))},t.prototype.v_compute=function(r){return this.vector_transform.apply(this,o.__spreadArray(o.__spreadArray([],o.__read(this.values)),[r]))},t}(s.Transform);e.CustomJSTransform=_,_.__name__="CustomJSTransform",_.init_CustomJSTransform()},
function _(n,t,e,i,o){i();var u=n(1),r=function(n){function t(t){return n.call(this,t)||this}return u.__extends(t,n),t.init_Dodge=function(){this.define((function(n){return{value:[n.Number,0]}}))},t.prototype._compute=function(n){return n+this.value},t}(n(446).RangeTransform);e.Dodge=r,r.__name__="Dodge",r.init_Dodge()},
function _(n,e,r,t,i){t();var a=n(1),o=n(171),s=n(172),u=n(182),f=n(139),c=n(123),h=function(n){function e(e){return n.call(this,e)||this}return a.__extends(e,n),e.init_RangeTransform=function(){this.define((function(n){var e=n.Ref;return{range:[(0,n.Nullable)(e(s.Range)),null]}}))},e.prototype.v_compute=function(n){var e;if(this.range instanceof u.FactorRange)e=this.range.v_synthetic(n);else{if(!c.isArrayableOf(n,c.isNumber))throw new Error("unexpected");e=n}for(var r=new(f.infer_type(e))(e.length),t=0;t<e.length;t++){var i=e[t];r[t]=this._compute(i)}return r},e.prototype.compute=function(n){if(this.range instanceof u.FactorRange)return this._compute(this.range.synthetic(n));if(c.isNumber(n))return this._compute(n);throw new Error("unexpected")},e}(o.Transform);r.RangeTransform=h,h.__name__="RangeTransform",h.init_RangeTransform()},
function _(t,r,e,n,o){n();var i=t(1),a=t(171),s=t(185),h=t(139),l=t(124),d=t(123),u=function(t){function r(r){var e=t.call(this,r)||this;return e._sorted_dirty=!0,e}return i.__extends(r,t),r.init_Interpolator=function(){this.define((function(t){var r=t.Boolean,e=t.Number,n=t.String,o=t.Ref,i=t.Array,a=t.Or,h=t.Nullable;return{x:[a(n,i(e))],y:[a(n,i(e))],data:[h(o(s.ColumnarDataSource)),null],clip:[r,!0]}}))},r.prototype.connect_signals=function(){var r=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return r._sorted_dirty=!0}))},r.prototype.v_compute=function(t){for(var r=new(h.infer_type(t))(t.length),e=0;e<t.length;e++){var n=t[e];r[e]=this.compute(n)}return r},r.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var r,e;if(d.isString(this.x)&&d.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!l.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!l.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!d.isArray(this.x)||!d.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");for(var o=r.length,i=new Uint32Array(o),a=0;a<o;a++)i[a]=a;var s=t?-1:1;i.sort((function(t,e){return s*(r[t]-r[e])})),this._x_sorted=new(h.infer_type(r))(o),this._y_sorted=new(h.infer_type(e))(o);for(a=0;a<o;a++)this._x_sorted[a]=r[i[a]],this._y_sorted[a]=e[i[a]];this._sorted_dirty=!1}},r}(a.Transform);e.Interpolator=u,u.__name__="Interpolator",u.init_Interpolator()},
function _(t,i,n,r,e){r();var u=t(1),o=t(446),s=t(135),a=u.__importStar(t(125)),h=function(t){function i(i){return t.call(this,i)||this}return u.__extends(i,t),i.init_Jitter=function(){this.define((function(t){var i=t.Number;return{mean:[i,0],width:[i,1],distribution:[s.Distribution,"uniform"]}}))},i.prototype.v_compute=function(i){return null!=this.previous_values&&this.previous_values.length==i.length||(this.previous_values=t.prototype.v_compute.call(this,i)),this.previous_values},i.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}},i}(o.RangeTransform);n.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,r,_,e,s){e();var i=t(1),o=t(124),n=function(t){function r(r){return t.call(this,r)||this}return i.__extends(r,t),r.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var r=o.find_last_index(this._x_sorted,(function(r){return r<t})),_=this._x_sorted[r],e=this._x_sorted[r+1],s=this._y_sorted[r],i=this._y_sorted[r+1];return s+(t-_)/(e-_)*(i-s)},r}(t(447).Interpolator);_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,r,n,i){n();var o=t(1),s=t(447),_=t(135),d=t(124),h=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_StepInterpolator=function(){this.define((function(){return{mode:[_.StepMode,"after"]}}))},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=d.find_last_index(this._x_sorted,(function(e){return t>=e}));break;case"before":e=d.find_index(this._x_sorted,(function(e){return t<=e}));break;case"center":var r=d.map(this._x_sorted,(function(e){return Math.abs(e-t)})),n=d.min(r);e=d.find_index(r,(function(t){return n===t}));break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(s.Interpolator);r.StepInterpolator=h,h.__name__="StepInterpolator",h.init_StepInterpolator()},
function _(p,o,t,a,n){a(),n("MapOptions",p(452).MapOptions),n("GMapOptions",p(452).GMapOptions),n("GMapPlot",p(452).GMapPlot),n("Plot",p(453).Plot)},
function _(n,t,i,e,o){e();var a=n(1),r=n(453),_=n(168),p=n(173),u=n(458);o("GMapPlotView",u.GMapPlotView);var s=function(n){function t(t){return n.call(this,t)||this}return a.__extends(t,n),t.init_MapOptions=function(){this.define((function(n){var t=n.Int,i=n.Number;return{lat:[i],lng:[i],zoom:[t,12]}}))},t}(_.Model);i.MapOptions=s,s.__name__="MapOptions",s.init_MapOptions();var l=function(n){function t(t){return n.call(this,t)||this}return a.__extends(t,n),t.init_GMapOptions=function(){this.define((function(n){var t=n.Boolean,i=n.Int,e=n.String;return{map_type:[e,"roadmap"],scale_control:[t,!1],styles:[e],tilt:[i,45]}}))},t}(s);i.GMapOptions=l,l.__name__="GMapOptions",l.init_GMapOptions();var c=function(n){function t(t){var i=n.call(this,t)||this;return i.use_map=!0,i}return a.__extends(t,n),t.init_GMapPlot=function(){this.prototype.default_view=u.GMapPlotView,this.define((function(n){var t=n.String;return{map_options:[(0,n.Ref)(l)],api_key:[t],api_version:[t,"3.43"]}})),this.override({x_range:function(){return new p.Range1d},y_range:function(){return new p.Range1d}})},t}(r.Plot);i.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(t,e,r,n,o){n();var i=t(1),a=i.__importStar(t(163)),l=i.__importStar(t(133)),_=t(130),s=t(135),c=t(124),u=t(128),h=t(123),d=t(432),f=t(241),p=t(429),g=t(155),y=t(233),v=t(174),b=t(332),w=t(172),m=t(170),x=t(190),A=t(156),P=t(284),R=t(283),S=t(178),D=t(454);o("PlotView",D.PlotView);var L=function(t){function e(e){var r=t.call(this,e)||this;return r.use_map=!1,r}return i.__extends(e,t),e.init_Plot=function(){this.prototype.default_view=D.PlotView,this.mixins([["outline_",a.Line],["background_",a.Fill],["border_",a.Fill]]),this.define((function(t){var e=t.Boolean,r=t.Number,n=t.String,o=t.Array,i=t.Dict,a=t.Or,_=t.Ref,c=t.Null,u=t.Nullable;return{toolbar:[_(b.Toolbar),function(){return new b.Toolbar}],toolbar_location:[u(s.Location),"right"],toolbar_sticky:[e,!0],plot_width:[l.Alias("width")],plot_height:[l.Alias("height")],frame_width:[u(r),null],frame_height:[u(r),null],title:[a(_(y.Title),n,c),"",{convert:function(t){return h.isString(t)?new y.Title({text:t}):t}}],title_location:[u(s.Location),"above"],above:[o(a(_(g.Annotation),_(f.Axis))),[]],below:[o(a(_(g.Annotation),_(f.Axis))),[]],left:[o(a(_(g.Annotation),_(f.Axis))),[]],right:[o(a(_(g.Annotation),_(f.Axis))),[]],center:[o(a(_(g.Annotation),_(p.Grid))),[]],renderers:[o(_(A.Renderer)),[]],x_range:[_(w.Range),function(){return new S.DataRange1d}],extra_x_ranges:[i(_(w.Range)),{}],y_range:[_(w.Range),function(){return new S.DataRange1d}],extra_y_ranges:[i(_(w.Range)),{}],x_scale:[_(m.Scale),function(){return new v.LinearScale}],y_scale:[_(m.Scale),function(){return new v.LinearScale}],lod_factor:[r,10],lod_interval:[r,300],lod_threshold:[u(r),2e3],lod_timeout:[r,500],hidpi:[e,!0],output_backend:[s.OutputBackend,"canvas"],min_border:[u(r),5],min_border_top:[u(r),null],min_border_left:[u(r),null],min_border_bottom:[u(r),null],min_border_right:[u(r),null],inner_width:[r,0],inner_height:[r,0],outer_width:[r,0],outer_height:[r,0],match_aspect:[e,!1],aspect_scale:[r,1],reset_policy:[s.ResetPolicy,"standard"]}})),this.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},e.prototype._doc_attached=function(){t.prototype._doc_attached.call(this),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])},e.prototype.initialize=function(){var e,r,n,o;t.prototype.initialize.call(this),this.reset=new _.Signal0(this,"reset");try{for(var a=i.__values(u.values(this.extra_x_ranges).concat(this.x_range)),l=a.next();!l.done;l=a.next()){var s=l.value,c=s.pl