/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* legacy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    require(2) /* ./polyfill */;
    tslib_1.__exportStar(require(116) /* ./main */, exports);
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    exports.__extends = __extends;
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    exports.__rest = __rest;
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    exports.__decorate = __decorate;
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    exports.__param = __param;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    exports.__metadata = __metadata;
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    exports.__awaiter = __awaiter;
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__generator = __generator;
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                exports.__createBinding(o, m, p);
    }
    exports.__exportStar = __exportStar;
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    exports.__values = __values;
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    exports.__read = __read;
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    exports.__spread = __spread;
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    exports.__spreadArrays = __spreadArrays;
    function __spreadArray(to, from) {
        for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
            to[j] = from[i];
        return to;
    }
    exports.__spreadArray = __spreadArray;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    exports.__await = __await;
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) {
            if (g[n])
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    exports.__asyncGenerator = __asyncGenerator;
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    exports.__asyncDelegator = __asyncDelegator;
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    exports.__asyncValues = __asyncValues;
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    exports.__makeTemplateObject = __makeTemplateObject;
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    exports.__createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    exports.__importStar = __importStar;
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    exports.__importDefault = __importDefault;
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
},
/* polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    require(3) /* es5-ext/object/assign/implement */;
    require(12) /* es5-ext/object/entries/implement */;
    require(15) /* es5-ext/number/is-integer/implement */;
    require(18) /* es5-ext/string/#/repeat/implement */;
    require(25) /* es5-ext/array/from/implement */;
    require(55) /* es5-ext/array/#/fill/implement */;
    require(58) /* es5-ext/math/log10/implement */;
    require(61) /* es5-ext/math/log1p/implement */;
    require(64) /* es6-set/implement */;
    require(100) /* es6-map/implement */;
    require(107) /* es6-weak-map/implement */;
    require(113) /* es6-symbol/implement */;
    require(114) /* es6-promise/auto */;
    if (typeof Object.is === "undefined") {
        Object.is = function (a, b) {
            if (a === b)
                return a !== 0 || 1 / a === 1 / b;
            else
                return a !== a && b !== b;
        };
    }
    if (typeof Object.values === "undefined") {
        Object.values = function (obj) {
            return Object.keys(obj).map(function (key) { return obj[key]; });
        };
    }
    if (typeof String.prototype.includes === "undefined") {
        String.prototype.includes = function (search, start) {
            if (start === void 0) {
                start = 0;
            }
            return this.indexOf(search, start) != -1;
        };
    }
    if (typeof Uint8Array.prototype.fill === "undefined") {
        var fill = Array.prototype.fill;
        Uint8Array.prototype.fill = fill;
        Int8Array.prototype.fill = fill;
        Uint16Array.prototype.fill = fill;
        Int16Array.prototype.fill = fill;
        Uint32Array.prototype.fill = fill;
        Int32Array.prototype.fill = fill;
        Float32Array.prototype.fill = fill;
        Float64Array.prototype.fill = fill;
    }
    if (typeof Array.prototype[Symbol.iterator] === "undefined") {
        function iterator() {
            var i = 0;
            var self = this;
            return {
                next: function () {
                    var done = self.length <= i;
                    var value = done ? undefined : self[i++];
                    return { value: value, done: done };
                },
            };
        }
        (function () {
            arguments.constructor.prototype[Symbol.iterator] = iterator;
            Array.prototype[Symbol.iterator] = iterator;
            Uint8Array.prototype[Symbol.iterator] = iterator;
            Int8Array.prototype[Symbol.iterator] = iterator;
            Uint16Array.prototype[Symbol.iterator] = iterator;
            Int16Array.prototype[Symbol.iterator] = iterator;
            Uint32Array.prototype[Symbol.iterator] = iterator;
            Int32Array.prototype[Symbol.iterator] = iterator;
            Float32Array.prototype[Symbol.iterator] = iterator;
            Float64Array.prototype[Symbol.iterator] = iterator;
        })();
    }
    // fixes up a problem with some versions of IE11
    // ref: http://stackoverflow.com/questions/22062313/imagedata-set-in-internetexplorer
    if (typeof CanvasPixelArray !== "undefined") {
        CanvasPixelArray.prototype.set = function (arr) {
            for (var i = 0; i < this.length; i++) {
                this[i] = arr[i];
            }
        };
    }
},
/* es5-ext/object/assign/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(4) /* ./is-implemented */()) {
        Object.defineProperty(Object, "assign", {
            value: require(5) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/object/assign/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var assign = Object.assign, obj;
        if (typeof assign !== "function")
            return false;
        obj = { foo: "raz" };
        assign(obj, { bar: "dwa" }, { trzy: "trzy" });
        return obj.foo + obj.bar + obj.trzy === "razdwatrzy";
    };
},
/* es5-ext/object/assign/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var keys = require(6) /* ../keys */, value = require(11) /* ../valid-value */, max = Math.max;
    module.exports = function (dest, src /*, …srcn*/) {
        var error, i, length = max(arguments.length, 2), assign;
        dest = Object(value(dest));
        assign = function (key) {
            try {
                dest[key] = src[key];
            }
            catch (e) {
                if (!error)
                    error = e;
            }
        };
        for (i = 1; i < length; ++i) {
            src = arguments[i];
            keys(src).forEach(assign);
        }
        if (error !== undefined)
            throw error;
        return dest;
    };
},
/* es5-ext/object/keys/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(7) /* ./is-implemented */() ? Object.keys : require(8) /* ./shim */;
},
/* es5-ext/object/keys/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        try {
            Object.keys("primitive");
            return true;
        }
        catch (e) {
            return false;
        }
    };
},
/* es5-ext/object/keys/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ../is-value */;
    var keys = Object.keys;
    module.exports = function (object) { return keys(isValue(object) ? Object(object) : object); };
},
/* es5-ext/object/is-value.js */ function _(require, module, exports, __esModule, __esExport) {
    var _undefined = require(10) /* ../function/noop */(); // Support ES3 engines
    module.exports = function (val) { return val !== _undefined && val !== null; };
},
/* es5-ext/function/noop.js */ function _(require, module, exports, __esModule, __esExport) {
    // eslint-disable-next-line no-empty-function
    module.exports = function () { };
},
/* es5-ext/object/valid-value.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    module.exports = function (value) {
        if (!isValue(value))
            throw new TypeError("Cannot use null or undefined");
        return value;
    };
},
/* es5-ext/object/entries/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(13) /* ./is-implemented */()) {
        Object.defineProperty(Object, "entries", {
            value: require(14) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/object/entries/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        try {
            return Object.entries({ foo: 12 })[0][0] === "foo";
        }
        catch (e) {
            return false;
        }
    };
},
/* es5-ext/object/entries/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var ensureValue = require(11) /* ../valid-value */;
    module.exports = function (object) {
        ensureValue(object);
        var result = [];
        object = Object(object);
        for (var key in object) {
            if (!propertyIsEnumerable.call(object, key))
                continue;
            result.push([key, object[key]]);
        }
        return result;
    };
},
/* es5-ext/number/is-integer/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(16) /* ./is-implemented */()) {
        Object.defineProperty(Number, "isInteger", {
            value: require(17) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/number/is-integer/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var isInteger = Number.isInteger;
        if (typeof isInteger !== "function")
            return false;
        return !isInteger("23") && isInteger(34) && !isInteger(32.34);
    };
},
/* es5-ext/number/is-integer/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        if (typeof value !== "number")
            return false;
        return value % 1 === 0;
    };
},
/* es5-ext/string/#/repeat/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(19) /* ./is-implemented */()) {
        Object.defineProperty(String.prototype, "repeat", {
            value: require(20) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/string/#/repeat/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var str = "foo";
    module.exports = function () {
        if (typeof str.repeat !== "function")
            return false;
        return str.repeat(2) === "foofoo";
    };
},
/* es5-ext/string/#/repeat/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var value = require(11) /* ../../../object/valid-value */, toInteger = require(21) /* ../../../number/to-integer */;
    module.exports = function (count) {
        var str = String(value(this)), result;
        count = toInteger(count);
        if (count < 0)
            throw new RangeError("Count must be >= 0");
        if (!isFinite(count))
            throw new RangeError("Count must be < ∞");
        result = "";
        while (count) {
            if (count % 2)
                result += str;
            if (count > 1)
                str += str;
            // eslint-disable-next-line no-bitwise
            count >>= 1;
        }
        return result;
    };
},
/* es5-ext/number/to-integer.js */ function _(require, module, exports, __esModule, __esExport) {
    var sign = require(22) /* ../math/sign */, abs = Math.abs, floor = Math.floor;
    module.exports = function (value) {
        if (isNaN(value))
            return 0;
        value = Number(value);
        if (value === 0 || !isFinite(value))
            return value;
        return sign(value) * floor(abs(value));
    };
},
/* es5-ext/math/sign/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(23) /* ./is-implemented */() ? Math.sign : require(24) /* ./shim */;
},
/* es5-ext/math/sign/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var sign = Math.sign;
        if (typeof sign !== "function")
            return false;
        return sign(10) === 1 && sign(-20) === -1;
    };
},
/* es5-ext/math/sign/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        value = Number(value);
        if (isNaN(value) || value === 0)
            return value;
        return value > 0 ? 1 : -1;
    };
},
/* es5-ext/array/from/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(26) /* ./is-implemented */()) {
        Object.defineProperty(Array, "from", {
            value: require(27) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/array/from/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var from = Array.from, arr, result;
        if (typeof from !== "function")
            return false;
        arr = ["raz", "dwa"];
        result = from(arr);
        return Boolean(result && result !== arr && result[1] === "dwa");
    };
},
/* es5-ext/array/from/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var iteratorSymbol = require(28) /* es6-symbol */.iterator, isArguments = require(50) /* ../../function/is-arguments */, isFunction = require(51) /* ../../function/is-function */, toPosInt = require(52) /* ../../number/to-pos-integer */, callable = require(53) /* ../../object/valid-callable */, validValue = require(11) /* ../../object/valid-value */, isValue = require(9) /* ../../object/is-value */, isString = require(54) /* ../../string/is-string */, isArray = Array.isArray, call = Function.prototype.call, desc = { configurable: true, enumerable: true, writable: true, value: null }, defineProperty = Object.defineProperty;
    // eslint-disable-next-line complexity, max-lines-per-function
    module.exports = function (arrayLike /*, mapFn, thisArg*/) {
        var mapFn = arguments[1], thisArg = arguments[2], Context, i, j, arr, length, code, iterator, result, getIterator, value;
        arrayLike = Object(validValue(arrayLike));
        if (isValue(mapFn))
            callable(mapFn);
        if (!this || this === Array || !isFunction(this)) {
            // Result: Plain array
            if (!mapFn) {
                if (isArguments(arrayLike)) {
                    // Source: Arguments
                    length = arrayLike.length;
                    if (length !== 1)
                        return Array.apply(null, arrayLike);
                    arr = new Array(1);
                    arr[0] = arrayLike[0];
                    return arr;
                }
                if (isArray(arrayLike)) {
                    // Source: Array
                    arr = new Array((length = arrayLike.length));
                    for (i = 0; i < length; ++i)
                        arr[i] = arrayLike[i];
                    return arr;
                }
            }
            arr = [];
        }
        else {
            // Result: Non plain array
            Context = this;
        }
        if (!isArray(arrayLike)) {
            if ((getIterator = arrayLike[iteratorSymbol]) !== undefined) {
                // Source: Iterator
                iterator = callable(getIterator).call(arrayLike);
                if (Context)
                    arr = new Context();
                result = iterator.next();
                i = 0;
                while (!result.done) {
                    value = mapFn ? call.call(mapFn, thisArg, result.value, i) : result.value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, i, desc);
                    }
                    else {
                        arr[i] = value;
                    }
                    result = iterator.next();
                    ++i;
                }
                length = i;
            }
            else if (isString(arrayLike)) {
                // Source: String
                length = arrayLike.length;
                if (Context)
                    arr = new Context();
                for (i = 0, j = 0; i < length; ++i) {
                    value = arrayLike[i];
                    if (i + 1 < length) {
                        code = value.charCodeAt(0);
                        // eslint-disable-next-line max-depth
                        if (code >= 0xd800 && code <= 0xdbff)
                            value += arrayLike[++i];
                    }
                    value = mapFn ? call.call(mapFn, thisArg, value, j) : value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, j, desc);
                    }
                    else {
                        arr[j] = value;
                    }
                    ++j;
                }
                length = j;
            }
        }
        if (length === undefined) {
            // Source: array or array-like
            length = toPosInt(arrayLike.length);
            if (Context)
                arr = new Context(length);
            for (i = 0; i < length; ++i) {
                value = mapFn ? call.call(mapFn, thisArg, arrayLike[i], i) : arrayLike[i];
                if (Context) {
                    desc.value = value;
                    defineProperty(arr, i, desc);
                }
                else {
                    arr[i] = value;
                }
            }
        }
        if (Context) {
            desc.value = null;
            arr.length = length;
        }
        return arr;
    };
},
/* es6-symbol/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(29) /* ./is-implemented */()
        ? require(30) /* ext/global-this */.Symbol
        : require(33) /* ./polyfill */;
},
/* es6-symbol/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var global = require(30) /* ext/global-this */, validTypes = { object: true, symbol: true };
    module.exports = function () {
        var Symbol = global.Symbol;
        var symbol;
        if (typeof Symbol !== "function")
            return false;
        symbol = Symbol("test symbol");
        try {
            String(symbol);
        }
        catch (e) {
            return false;
        }
        // Return 'true' also for polyfills
        if (!validTypes[typeof Symbol.iterator])
            return false;
        if (!validTypes[typeof Symbol.toPrimitive])
            return false;
        if (!validTypes[typeof Symbol.toStringTag])
            return false;
        return true;
    };
},
/* ext/global-this/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(31) /* ./is-implemented */() ? globalThis : require(32) /* ./implementation */;
},
/* ext/global-this/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        if (typeof globalThis !== "object")
            return false;
        if (!globalThis)
            return false;
        return globalThis.Array === Array;
    };
},
/* ext/global-this/implementation.js */ function _(require, module, exports, __esModule, __esExport) {
    var naiveFallback = function () {
        if (typeof self === "object" && self)
            return self;
        if (typeof window === "object" && window)
            return window;
        throw new Error("Unable to resolve global `this`");
    };
    module.exports = (function () {
        if (this)
            return this;
        // Unexpected strict mode (may happen if e.g. bundled into ESM module)
        // Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
        // In all ES5+ engines global object inherits from Object.prototype
        // (if you approached one that doesn't please report)
        try {
            Object.defineProperty(Object.prototype, "__global__", {
                get: function () { return this; },
                configurable: true
            });
        }
        catch (error) {
            // Unfortunate case of Object.prototype being sealed (via preventExtensions, seal or freeze)
            return naiveFallback();
        }
        try {
            // Safari case (window.__global__ is resolved with global context, but __global__ does not)
            if (!__global__)
                return naiveFallback();
            return __global__;
        }
        finally {
            delete Object.prototype.__global__;
        }
    })();
},
/* es6-symbol/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, validateSymbol = require(45) /* ./validate-symbol */, NativeSymbol = require(30) /* ext/global-this */.Symbol, generateName = require(47) /* ./lib/private/generate-name */, setupStandardSymbols = require(48) /* ./lib/private/setup/standard-symbols */, setupSymbolRegistry = require(49) /* ./lib/private/setup/symbol-registry */;
    var create = Object.create, defineProperties = Object.defineProperties, defineProperty = Object.defineProperty;
    var SymbolPolyfill, HiddenSymbol, isNativeSafe;
    if (typeof NativeSymbol === "function") {
        try {
            String(NativeSymbol());
            isNativeSafe = true;
        }
        catch (ignore) { }
    }
    else {
        NativeSymbol = null;
    }
    // Internal constructor (not one exposed) for creating Symbol instances.
    // This one is used to ensure that `someSymbol instanceof Symbol` always return false
    HiddenSymbol = function Symbol(description) {
        if (this instanceof HiddenSymbol)
            throw new TypeError("Symbol is not a constructor");
        return SymbolPolyfill(description);
    };
    // Exposed `Symbol` constructor
    // (returns instances of HiddenSymbol)
    module.exports = SymbolPolyfill = function Symbol(description) {
        var symbol;
        if (this instanceof Symbol)
            throw new TypeError("Symbol is not a constructor");
        if (isNativeSafe)
            return NativeSymbol(description);
        symbol = create(HiddenSymbol.prototype);
        description = description === undefined ? "" : String(description);
        return defineProperties(symbol, {
            __description__: d("", description),
            __name__: d("", generateName(description))
        });
    };
    setupStandardSymbols(SymbolPolyfill);
    setupSymbolRegistry(SymbolPolyfill);
    // Internal tweaks for real symbol producer
    defineProperties(HiddenSymbol.prototype, {
        constructor: d(SymbolPolyfill),
        toString: d("", function () { return this.__name__; })
    });
    // Proper implementation of methods exposed on Symbol.prototype
    // They won't be accessible on produced symbol instances as they derive from HiddenSymbol.prototype
    defineProperties(SymbolPolyfill.prototype, {
        toString: d(function () { return "Symbol (" + validateSymbol(this).__description__ + ")"; }),
        valueOf: d(function () { return validateSymbol(this); })
    });
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toPrimitive, d("", function () {
        var symbol = validateSymbol(this);
        if (typeof symbol === "symbol")
            return symbol;
        return symbol.toString();
    }));
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toStringTag, d("c", "Symbol"));
    // Proper implementaton of toPrimitive and toStringTag for returned symbol instances
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toStringTag, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toStringTag]));
    // Note: It's important to define `toPrimitive` as last one, as some implementations
    // implement `toPrimitive` natively without implementing `toStringTag` (or other specified symbols)
    // And that may invoke error in definition flow:
    // See: https://github.com/medikoo/es6-symbol/issues/13#issuecomment-164146149
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toPrimitive, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toPrimitive]));
},
/* d/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* type/value/is */, isPlainFunction = require(36) /* type/plain-function/is */, assign = require(40) /* es5-ext/object/assign */, normalizeOpts = require(41) /* es5-ext/object/normalize-options */, contains = require(42) /* es5-ext/string/#/contains */;
    var d = (module.exports = function (dscr, value /*, options*/) {
        var c, e, w, options, desc;
        if (arguments.length < 2 || typeof dscr !== "string") {
            options = value;
            value = dscr;
            dscr = null;
        }
        else {
            options = arguments[2];
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
            w = contains.call(dscr, "w");
        }
        else {
            c = w = true;
            e = false;
        }
        desc = { value: value, configurable: c, enumerable: e, writable: w };
        return !options ? desc : assign(normalizeOpts(options), desc);
    });
    d.gs = function (dscr, get, set /*, options*/) {
        var c, e, options, desc;
        if (typeof dscr !== "string") {
            options = set;
            set = get;
            get = dscr;
            dscr = null;
        }
        else {
            options = arguments[3];
        }
        if (!isValue(get)) {
            get = undefined;
        }
        else if (!isPlainFunction(get)) {
            options = get;
            get = set = undefined;
        }
        else if (!isValue(set)) {
            set = undefined;
        }
        else if (!isPlainFunction(set)) {
            options = set;
            set = undefined;
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
        }
        else {
            c = true;
            e = false;
        }
        desc = { get: get, set: set, configurable: c, enumerable: e };
        return !options ? desc : assign(normalizeOpts(options), desc);
    };
},
/* type/value/is.js */ function _(require, module, exports, __esModule, __esExport) {
    // ES3 safe
    var _undefined = void 0;
    module.exports = function (value) { return value !== _undefined && value !== null; };
},
/* type/plain-function/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isFunction = require(37) /* ../function/is */;
    var classRe = /^\s*class[\s{/}]/, functionToString = Function.prototype.toString;
    module.exports = function (value) {
        if (!isFunction(value))
            return false;
        if (classRe.test(functionToString.call(value)))
            return false;
        return true;
    };
},
/* type/function/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isPrototype = require(38) /* ../prototype/is */;
    module.exports = function (value) {
        if (typeof value !== "function")
            return false;
        if (!hasOwnProperty.call(value, "length"))
            return false;
        try {
            if (typeof value.length !== "number")
                return false;
            if (typeof value.call !== "function")
                return false;
            if (typeof value.apply !== "function")
                return false;
        }
        catch (error) {
            return false;
        }
        return !isPrototype(value);
    };
},
/* type/prototype/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(39) /* ../object/is */;
    module.exports = function (value) {
        if (!isObject(value))
            return false;
        try {
            if (!value.constructor)
                return false;
            return value.constructor.prototype === value;
        }
        catch (error) {
            return false;
        }
    };
},
/* type/object/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */;
    // prettier-ignore
    var possibleTypes = { "object": true, "function": true, "undefined": true /* document.all */ };
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        return hasOwnProperty.call(possibleTypes, typeof value);
    };
},
/* es5-ext/object/assign/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(4) /* ./is-implemented */() ? Object.assign : require(5) /* ./shim */;
},
/* es5-ext/object/normalize-options.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    var forEach = Array.prototype.forEach, create = Object.create;
    var process = function (src, obj) {
        var key;
        for (key in src)
            obj[key] = src[key];
    };
    // eslint-disable-next-line no-unused-vars
    module.exports = function (opts1 /*, …options*/) {
        var result = create(null);
        forEach.call(arguments, function (options) {
            if (!isValue(options))
                return;
            process(Object(options), result);
        });
        return result;
    };
},
/* es5-ext/string/#/contains/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(43) /* ./is-implemented */() ? String.prototype.contains : require(44) /* ./shim */;
},
/* es5-ext/string/#/contains/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var str = "razdwatrzy";
    module.exports = function () {
        if (typeof str.contains !== "function")
            return false;
        return str.contains("dwa") === true && str.contains("foo") === false;
    };
},
/* es5-ext/string/#/contains/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var indexOf = String.prototype.indexOf;
    module.exports = function (searchString /*, position*/) {
        return indexOf.call(this, searchString, arguments[1]) > -1;
    };
},
/* es6-symbol/validate-symbol.js */ function _(require, module, exports, __esModule, __esExport) {
    var isSymbol = require(46) /* ./is-symbol */;
    module.exports = function (value) {
        if (!isSymbol(value))
            throw new TypeError(value + " is not a symbol");
        return value;
    };
},
/* es6-symbol/is-symbol.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        if (!value)
            return false;
        if (typeof value === "symbol")
            return true;
        if (!value.constructor)
            return false;
        if (value.constructor.name !== "Symbol")
            return false;
        return value[value.constructor.toStringTag] === "Symbol";
    };
},
/* es6-symbol/lib/private/generate-name.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */;
    var create = Object.create, defineProperty = Object.defineProperty, objPrototype = Object.prototype;
    var created = create(null);
    module.exports = function (desc) {
        var postfix = 0, name, ie11BugWorkaround;
        while (created[desc + (postfix || "")])
            ++postfix;
        desc += postfix || "";
        created[desc] = true;
        name = "@@" + desc;
        defineProperty(objPrototype, name, d.gs(null, function (value) {
            // For IE11 issue see:
            // https://connect.microsoft.com/IE/feedbackdetail/view/1928508/
            //    ie11-broken-getters-on-dom-objects
            // https://github.com/medikoo/es6-symbol/issues/12
            if (ie11BugWorkaround)
                return;
            ie11BugWorkaround = true;
            defineProperty(this, name, d(value));
            ie11BugWorkaround = false;
        }));
        return name;
    };
},
/* es6-symbol/lib/private/setup/standard-symbols.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, NativeSymbol = require(30) /* ext/global-this */.Symbol;
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            // To ensure proper interoperability with other native functions (e.g. Array.from)
            // fallback to eventual native implementation of given symbol
            hasInstance: d("", (NativeSymbol && NativeSymbol.hasInstance) || SymbolPolyfill("hasInstance")),
            isConcatSpreadable: d("", (NativeSymbol && NativeSymbol.isConcatSpreadable) ||
                SymbolPolyfill("isConcatSpreadable")),
            iterator: d("", (NativeSymbol && NativeSymbol.iterator) || SymbolPolyfill("iterator")),
            match: d("", (NativeSymbol && NativeSymbol.match) || SymbolPolyfill("match")),
            replace: d("", (NativeSymbol && NativeSymbol.replace) || SymbolPolyfill("replace")),
            search: d("", (NativeSymbol && NativeSymbol.search) || SymbolPolyfill("search")),
            species: d("", (NativeSymbol && NativeSymbol.species) || SymbolPolyfill("species")),
            split: d("", (NativeSymbol && NativeSymbol.split) || SymbolPolyfill("split")),
            toPrimitive: d("", (NativeSymbol && NativeSymbol.toPrimitive) || SymbolPolyfill("toPrimitive")),
            toStringTag: d("", (NativeSymbol && NativeSymbol.toStringTag) || SymbolPolyfill("toStringTag")),
            unscopables: d("", (NativeSymbol && NativeSymbol.unscopables) || SymbolPolyfill("unscopables"))
        });
    };
},
/* es6-symbol/lib/private/setup/symbol-registry.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, validateSymbol = require(45) /* ../../../validate-symbol */;
    var registry = Object.create(null);
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            for: d(function (key) {
                if (registry[key])
                    return registry[key];
                return (registry[key] = SymbolPolyfill(String(key)));
            }),
            keyFor: d(function (symbol) {
                var key;
                validateSymbol(symbol);
                for (key in registry) {
                    if (registry[key] === symbol)
                        return key;
                }
                return undefined;
            })
        });
    };
},
/* es5-ext/function/is-arguments.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, id = objToString.call((function () { return arguments; })());
    module.exports = function (value) { return objToString.call(value) === id; };
},
/* es5-ext/function/is-function.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, isFunctionStringTag = RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);
    module.exports = function (value) {
        return typeof value === "function" && isFunctionStringTag(objToString.call(value));
    };
},
/* es5-ext/number/to-pos-integer.js */ function _(require, module, exports, __esModule, __esExport) {
    var toInteger = require(21) /* ./to-integer */, max = Math.max;
    module.exports = function (value) { return max(0, toInteger(value)); };
},
/* es5-ext/object/valid-callable.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (fn) {
        if (typeof fn !== "function")
            throw new TypeError(fn + " is not a function");
        return fn;
    };
},
/* es5-ext/string/is-string.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, id = objToString.call("");
    module.exports = function (value) {
        return (typeof value === "string" ||
            (value &&
                typeof value === "object" &&
                (value instanceof String || objToString.call(value) === id)) ||
            false);
    };
},
/* es5-ext/array/#/fill/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(56) /* ./is-implemented */()) {
        Object.defineProperty(Array.prototype, "fill", {
            value: require(57) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/array/#/fill/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var arr = [1, 2, 3, 4, 5, 6];
        if (typeof arr.fill !== "function")
            return false;
        return String(arr.fill(-1, -3)) === "1,2,3,-1,-1,-1";
    };
},
/* es5-ext/array/#/fill/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var toInteger = require(21) /* ../../../number/to-integer */, toPosInt = require(52) /* ../../../number/to-pos-integer */, validValue = require(11) /* ../../../object/valid-value */, max = Math.max, min = Math.min;
    module.exports = function (value /*, start, end*/) {
        var arr = validValue(this), start = arguments[1], end = arguments[2], length = toPosInt(arr.length), relativeStart, i;
        start = start === undefined ? 0 : toInteger(start);
        end = end === undefined ? length : toInteger(end);
        relativeStart = start < 0 ? max(length + start, 0) : min(start, length);
        for (i = relativeStart; i < length && i < end; ++i)
            arr[i] = value;
        return arr;
    };
},
/* es5-ext/math/log10/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(59) /* ./is-implemented */()) {
        Object.defineProperty(Math, "log10", {
            value: require(60) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/math/log10/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var log10 = Math.log10;
        if (typeof log10 !== "function")
            return false;
        return log10(2) === 0.3010299956639812;
    };
},
/* es5-ext/math/log10/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var log = Math.log, LOG10E = Math.LOG10E;
    module.exports = function (value) {
        if (isNaN(value))
            return NaN;
        value = Number(value);
        if (value < 0)
            return NaN;
        if (value === 0)
            return -Infinity;
        if (value === 1)
            return 0;
        if (value === Infinity)
            return Infinity;
        return log(value) * LOG10E;
    };
},
/* es5-ext/math/log1p/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(62) /* ./is-implemented */()) {
        Object.defineProperty(Math, "log1p", {
            value: require(63) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/math/log1p/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var log1p = Math.log1p;
        if (typeof log1p !== "function")
            return false;
        return log1p(1) === 0.6931471805599453;
    };
},
/* es5-ext/math/log1p/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var log = Math.log;
    module.exports = function (value) {
        if (isNaN(value))
            return NaN;
        value = Number(value);
        if (value < -1)
            return NaN;
        if (value === -1)
            return -Infinity;
        if (value === 0)
            return value;
        if (value === Infinity)
            return Infinity;
        if (value > -1.0e-8 && value < 1.0e-8)
            return value - (value * value) / 2;
        return log(1 + value);
    };
},
/* es6-set/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(65) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, 'Set', { value: require(67) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-set/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var set, iterator, result;
        if (typeof Set !== 'function')
            return false;
        set = new Set(['raz', 'dwa', 'trzy']);
        if (String(set) !== '[object Set]')
            return false;
        if (set.size !== 3)
            return false;
        if (typeof set.add !== 'function')
            return false;
        if (typeof set.clear !== 'function')
            return false;
        if (typeof set.delete !== 'function')
            return false;
        if (typeof set.entries !== 'function')
            return false;
        if (typeof set.forEach !== 'function')
            return false;
        if (typeof set.has !== 'function')
            return false;
        if (typeof set.keys !== 'function')
            return false;
        if (typeof set.values !== 'function')
            return false;
        iterator = set.values();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (result.value !== 'raz')
            return false;
        return true;
    };
},
/* es5-ext/global.js */ function _(require, module, exports, __esModule, __esExport) {
    var naiveFallback = function () {
        if (typeof self === "object" && self)
            return self;
        if (typeof window === "object" && window)
            return window;
        throw new Error("Unable to resolve global `this`");
    };
    module.exports = (function () {
        if (this)
            return this;
        // Unexpected strict mode (may happen if e.g. bundled into ESM module)
        // Fallback to standard globalThis if available
        if (typeof globalThis === "object" && globalThis)
            return globalThis;
        // Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
        // In all ES5+ engines global object inherits from Object.prototype
        // (if you approached one that doesn't please report)
        try {
            Object.defineProperty(Object.prototype, "__global__", {
                get: function () { return this; },
                configurable: true
            });
        }
        catch (error) {
            // Unfortunate case of updates to Object.prototype being restricted
            // via preventExtensions, seal or freeze
            return naiveFallback();
        }
        try {
            // Safari case (window.__global__ works, but __global__ does not)
            if (!__global__)
                return naiveFallback();
            return __global__;
        }
        finally {
            delete Object.prototype.__global__;
        }
    })();
},
/* es6-set/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, eIndexOf = require(69) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, callable = require(53) /* es5-ext/object/valid-callable */, d = require(34) /* d */, ee = require(78) /* event-emitter */, Symbol = require(28) /* es6-symbol */, iterator = require(79) /* es6-iterator/valid-iterable */, forOf = require(81) /* es6-iterator/for-of */, Iterator = require(98) /* ./lib/iterator */, isNative = require(99) /* ./is-native-implemented */, call = Function.prototype.call, defineProperty = Object.defineProperty, getPrototypeOf = Object.getPrototypeOf, SetPoly, getValues, NativeSet;
    if (isNative)
        NativeSet = Set;
    module.exports = SetPoly = function Set( /*iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof SetPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf)
            self = setPrototypeOf(new NativeSet(), getPrototypeOf(this));
        else
            self = this;
        if (iterable != null)
            iterator(iterable);
        defineProperty(self, '__setData__', d('c', []));
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            if (eIndexOf.call(this, value) !== -1)
                return;
            this.push(value);
        }, self.__setData__);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(SetPoly, NativeSet);
        SetPoly.prototype = Object.create(NativeSet.prototype, { constructor: d(SetPoly) });
    }
    ee(Object.defineProperties(SetPoly.prototype, {
        add: d(function (value) {
            if (this.has(value))
                return this;
            this.emit('_add', this.__setData__.push(value) - 1, value);
            return this;
        }),
        clear: d(function () {
            if (!this.__setData__.length)
                return;
            clear.call(this.__setData__);
            this.emit('_clear');
        }),
        delete: d(function (value) {
            var index = eIndexOf.call(this.__setData__, value);
            if (index === -1)
                return false;
            this.__setData__.splice(index, 1);
            this.emit('_delete', index, value);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result, value;
            callable(cb);
            iterator = this.values();
            result = iterator._next();
            while (result !== undefined) {
                value = iterator._resolve(result);
                call.call(cb, thisArg, value, value, this);
                result = iterator._next();
            }
        }),
        has: d(function (value) {
            return (eIndexOf.call(this.__setData__, value) !== -1);
        }),
        keys: d(getValues = function () { return this.values(); }),
        size: d.gs(function () { return this.__setData__.length; }),
        values: d(function () { return new Iterator(this); }),
        toString: d(function () { return '[object Set]'; })
    }));
    defineProperty(SetPoly.prototype, Symbol.iterator, d(getValues));
    defineProperty(SetPoly.prototype, Symbol.toStringTag, d('c', 'Set'));
},
/* es5-ext/array/#/clear.js */ function _(require, module, exports, __esModule, __esExport) {
    var value = require(11) /* ../../object/valid-value */;
    module.exports = function () {
        value(this).length = 0;
        return this;
    };
},
/* es5-ext/array/#/e-index-of.js */ function _(require, module, exports, __esModule, __esExport) {
    var numberIsNaN = require(70) /* ../../number/is-nan */, toPosInt = require(52) /* ../../number/to-pos-integer */, value = require(11) /* ../../object/valid-value */, indexOf = Array.prototype.indexOf, objHasOwnProperty = Object.prototype.hasOwnProperty, abs = Math.abs, floor = Math.floor;
    module.exports = function (searchElement /*, fromIndex*/) {
        var i, length, fromIndex, val;
        if (!numberIsNaN(searchElement))
            return indexOf.apply(this, arguments);
        length = toPosInt(value(this).length);
        fromIndex = arguments[1];
        if (isNaN(fromIndex))
            fromIndex = 0;
        else if (fromIndex >= 0)
            fromIndex = floor(fromIndex);
        else
            fromIndex = toPosInt(this.length) - floor(abs(fromIndex));
        for (i = fromIndex; i < length; ++i) {
            if (objHasOwnProperty.call(this, i)) {
                val = this[i];
                if (numberIsNaN(val))
                    return i; // Jslint: ignore
            }
        }
        return -1;
    };
},
/* es5-ext/number/is-nan/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(71) /* ./is-implemented */() ? Number.isNaN : require(72) /* ./shim */;
},
/* es5-ext/number/is-nan/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var numberIsNaN = Number.isNaN;
        if (typeof numberIsNaN !== "function")
            return false;
        return !numberIsNaN({}) && numberIsNaN(NaN) && !numberIsNaN(34);
    };
},
/* es5-ext/number/is-nan/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        // eslint-disable-next-line no-self-compare
        return value !== value;
    };
},
/* es5-ext/object/set-prototype-of/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(74) /* ./is-implemented */() ? Object.setPrototypeOf : require(75) /* ./shim */;
},
/* es5-ext/object/set-prototype-of/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var create = Object.create, getPrototypeOf = Object.getPrototypeOf, plainObject = {};
    module.exports = function ( /* CustomCreate*/) {
        var setPrototypeOf = Object.setPrototypeOf, customCreate = arguments[0] || create;
        if (typeof setPrototypeOf !== "function")
            return false;
        return getPrototypeOf(setPrototypeOf(customCreate(null), plainObject)) === plainObject;
    };
},
/* es5-ext/object/set-prototype-of/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(76) /* ../is-object */, value = require(11) /* ../valid-value */, objIsPrototypeOf = Object.prototype.isPrototypeOf, defineProperty = Object.defineProperty, nullDesc = { configurable: true, enumerable: false, writable: true, value: undefined }, validate;
    validate = function (obj, prototype) {
        value(obj);
        if (prototype === null || isObject(prototype))
            return obj;
        throw new TypeError("Prototype must be null or an object");
    };
    module.exports = (function (status) {
        var fn, set;
        if (!status)
            return null;
        if (status.level === 2) {
            if (status.set) {
                set = status.set;
                fn = function (obj, prototype) {
                    set.call(validate(obj, prototype), prototype);
                    return obj;
                };
            }
            else {
                fn = function (obj, prototype) {
                    validate(obj, prototype).__proto__ = prototype;
                    return obj;
                };
            }
        }
        else {
            fn = function self(obj, prototype) {
                var isNullBase;
                validate(obj, prototype);
                isNullBase = objIsPrototypeOf.call(self.nullPolyfill, obj);
                if (isNullBase)
                    delete self.nullPolyfill.__proto__;
                if (prototype === null)
                    prototype = self.nullPolyfill;
                obj.__proto__ = prototype;
                if (isNullBase)
                    defineProperty(self.nullPolyfill, "__proto__", nullDesc);
                return obj;
            };
        }
        return Object.defineProperty(fn, "level", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: status.level
        });
    })((function () {
        var tmpObj1 = Object.create(null), tmpObj2 = {}, set, desc = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__");
        if (desc) {
            try {
                set = desc.set; // Opera crashes at this point
                set.call(tmpObj1, tmpObj2);
            }
            catch (ignore) { }
            if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
                return { set: set, level: 2 };
        }
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 2 };
        tmpObj1 = {};
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 1 };
        return false;
    })());
    require(77) /* ../create */;
},
/* es5-ext/object/is-object.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    var map = { function: true, object: true };
    module.exports = function (value) { return (isValue(value) && map[typeof value]) || false; };
},
/* es5-ext/object/create.js */ function _(require, module, exports, __esModule, __esExport) {
    var create = Object.create, shim;
    if (!require(74) /* ./set-prototype-of/is-implemented */()) {
        shim = require(75) /* ./set-prototype-of/shim */;
    }
    module.exports = (function () {
        var nullObject, polyProps, desc;
        if (!shim)
            return create;
        if (shim.level !== 1)
            return create;
        nullObject = {};
        polyProps = {};
        desc = { configurable: false, enumerable: false, writable: true, value: undefined };
        Object.getOwnPropertyNames(Object.prototype).forEach(function (name) {
            if (name === "__proto__") {
                polyProps[name] = {
                    configurable: true,
                    enumerable: false,
                    writable: true,
                    value: undefined
                };
                return;
            }
            polyProps[name] = desc;
        });
        Object.defineProperties(nullObject, polyProps);
        Object.defineProperty(shim, "nullPolyfill", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: nullObject
        });
        return function (prototype, props) {
            return create(prototype === null ? nullObject : prototype, props);
        };
    })();
},
/* event-emitter/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, callable = require(53) /* es5-ext/object/valid-callable */, apply = Function.prototype.apply, call = Function.prototype.call, create = Object.create, defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, hasOwnProperty = Object.prototype.hasOwnProperty, descriptor = { configurable: true, enumerable: false, writable: true }, on, once, off, emit, methods, descriptors, base;
    on = function (type, listener) {
        var data;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__')) {
            data = descriptor.value = create(null);
            defineProperty(this, '__ee__', descriptor);
            descriptor.value = null;
        }
        else {
            data = this.__ee__;
        }
        if (!data[type])
            data[type] = listener;
        else if (typeof data[type] === 'object')
            data[type].push(listener);
        else
            data[type] = [data[type], listener];
        return this;
    };
    once = function (type, listener) {
        var once, self;
        callable(listener);
        self = this;
        on.call(this, type, once = function () {
            off.call(self, type, once);
            apply.call(listener, this, arguments);
        });
        once.__eeOnceListener__ = listener;
        return this;
    };
    off = function (type, listener) {
        var data, listeners, candidate, i;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__'))
            return this;
        data = this.__ee__;
        if (!data[type])
            return this;
        listeners = data[type];
        if (typeof listeners === 'object') {
            for (i = 0; (candidate = listeners[i]); ++i) {
                if ((candidate === listener) ||
                    (candidate.__eeOnceListener__ === listener)) {
                    if (listeners.length === 2)
                        data[type] = listeners[i ? 0 : 1];
                    else
                        listeners.splice(i, 1);
                }
            }
        }
        else {
            if ((listeners === listener) ||
                (listeners.__eeOnceListener__ === listener)) {
                delete data[type];
            }
        }
        return this;
    };
    emit = function (type) {
        var i, l, listener, listeners, args;
        if (!hasOwnProperty.call(this, '__ee__'))
            return;
        listeners = this.__ee__[type];
        if (!listeners)
            return;
        if (typeof listeners === 'object') {
            l = arguments.length;
            args = new Array(l - 1);
            for (i = 1; i < l; ++i)
                args[i - 1] = arguments[i];
            listeners = listeners.slice();
            for (i = 0; (listener = listeners[i]); ++i) {
                apply.call(listener, this, args);
            }
        }
        else {
            switch (arguments.length) {
                case 1:
                    call.call(listeners, this);
                    break;
                case 2:
                    call.call(listeners, this, arguments[1]);
                    break;
                case 3:
                    call.call(listeners, this, arguments[1], arguments[2]);
                    break;
                default:
                    l = arguments.length;
                    args = new Array(l - 1);
                    for (i = 1; i < l; ++i) {
                        args[i - 1] = arguments[i];
                    }
                    apply.call(listeners, this, args);
            }
        }
    };
    methods = {
        on: on,
        once: once,
        off: off,
        emit: emit
    };
    descriptors = {
        on: d(on),
        once: d(once),
        off: d(off),
        emit: d(emit)
    };
    base = defineProperties({}, descriptors);
    module.exports = exports = function (o) {
        return (o == null) ? create(base) : defineProperties(Object(o), descriptors);
    };
    exports.methods = methods;
},
/* es6-iterator/valid-iterable.js */ function _(require, module, exports, __esModule, __esExport) {
    var isIterable = require(80) /* ./is-iterable */;
    module.exports = function (value) {
        if (!isIterable(value))
            throw new TypeError(value + " is not iterable");
        return value;
    };
},
/* es6-iterator/is-iterable.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, isValue = require(9) /* es5-ext/object/is-value */, isString = require(54) /* es5-ext/string/is-string */;
    var iteratorSymbol = require(28) /* es6-symbol */.iterator, isArray = Array.isArray;
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        if (isArray(value))
            return true;
        if (isString(value))
            return true;
        if (isArguments(value))
            return true;
        return typeof value[iteratorSymbol] === "function";
    };
},
/* es6-iterator/for-of.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, callable = require(53) /* es5-ext/object/valid-callable */, isString = require(54) /* es5-ext/string/is-string */, get = require(82) /* ./get */;
    var isArray = Array.isArray, call = Function.prototype.call, some = Array.prototype.some;
    module.exports = function (iterable, cb /*, thisArg*/) {
        var mode, thisArg = arguments[2], result, doBreak, broken, i, length, char, code;
        if (isArray(iterable) || isArguments(iterable))
            mode = "array";
        else if (isString(iterable))
            mode = "string";
        else
            iterable = get(iterable);
        callable(cb);
        doBreak = function () {
            broken = true;
        };
        if (mode === "array") {
            some.call(iterable, function (value) {
                call.call(cb, thisArg, value, doBreak);
                return broken;
            });
            return;
        }
        if (mode === "string") {
            length = iterable.length;
            for (i = 0; i < length; ++i) {
                char = iterable[i];
                if (i + 1 < length) {
                    code = char.charCodeAt(0);
                    if (code >= 0xd800 && code <= 0xdbff)
                        char += iterable[++i];
                }
                call.call(cb, thisArg, char, doBreak);
                if (broken)
                    break;
            }
            return;
        }
        result = iterable.next();
        while (!result.done) {
            call.call(cb, thisArg, result.value, doBreak);
            if (broken)
                return;
            result = iterable.next();
        }
    };
},
/* es6-iterator/get.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, isString = require(54) /* es5-ext/string/is-string */, ArrayIterator = require(83) /* ./array */, StringIterator = require(97) /* ./string */, iterable = require(79) /* ./valid-iterable */, iteratorSymbol = require(28) /* es6-symbol */.iterator;
    module.exports = function (obj) {
        if (typeof iterable(obj)[iteratorSymbol] === "function")
            return obj[iteratorSymbol]();
        if (isArguments(obj))
            return new ArrayIterator(obj);
        if (isString(obj))
            return new StringIterator(obj);
        return new ArrayIterator(obj);
    };
},
/* es6-iterator/array.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, contains = require(42) /* es5-ext/string/#/contains */, d = require(34) /* d */, Symbol = require(28) /* es6-symbol */, Iterator = require(84) /* ./ */;
    var defineProperty = Object.defineProperty, ArrayIterator;
    ArrayIterator = module.exports = function (arr, kind) {
        if (!(this instanceof ArrayIterator))
            throw new TypeError("Constructor requires 'new'");
        Iterator.call(this, arr);
        if (!kind)
            kind = "value";
        else if (contains.call(kind, "key+value"))
            kind = "key+value";
        else if (contains.call(kind, "key"))
            kind = "key";
        else
            kind = "value";
        defineProperty(this, "__kind__", d("", kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(ArrayIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete ArrayIterator.prototype.constructor;
    ArrayIterator.prototype = Object.create(Iterator.prototype, {
        _resolve: d(function (i) {
            if (this.__kind__ === "value")
                return this.__list__[i];
            if (this.__kind__ === "key+value")
                return [i, this.__list__[i]];
            return i;
        })
    });
    defineProperty(ArrayIterator.prototype, Symbol.toStringTag, d("c", "Array Iterator"));
},
/* es6-iterator/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, assign = require(40) /* es5-ext/object/assign */, callable = require(53) /* es5-ext/object/valid-callable */, value = require(11) /* es5-ext/object/valid-value */, d = require(34) /* d */, autoBind = require(85) /* d/auto-bind */, Symbol = require(28) /* es6-symbol */;
    var defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, Iterator;
    module.exports = Iterator = function (list, context) {
        if (!(this instanceof Iterator))
            throw new TypeError("Constructor requires 'new'");
        defineProperties(this, {
            __list__: d("w", value(list)),
            __context__: d("w", context),
            __nextIndex__: d("w", 0)
        });
        if (!context)
            return;
        callable(context.on);
        context.on("_add", this._onAdd);
        context.on("_delete", this._onDelete);
        context.on("_clear", this._onClear);
    };
    // Internal %IteratorPrototype% doesn't expose its constructor
    delete Iterator.prototype.constructor;
    defineProperties(Iterator.prototype, assign({
        _next: d(function () {
            var i;
            if (!this.__list__)
                return undefined;
            if (this.__redo__) {
                i = this.__redo__.shift();
                if (i !== undefined)
                    return i;
            }
            if (this.__nextIndex__ < this.__list__.length)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        next: d(function () {
            return this._createResult(this._next());
        }),
        _createResult: d(function (i) {
            if (i === undefined)
                return { done: true, value: undefined };
            return { done: false, value: this._resolve(i) };
        }),
        _resolve: d(function (i) {
            return this.__list__[i];
        }),
        _unBind: d(function () {
            this.__list__ = null;
            delete this.__redo__;
            if (!this.__context__)
                return;
            this.__context__.off("_add", this._onAdd);
            this.__context__.off("_delete", this._onDelete);
            this.__context__.off("_clear", this._onClear);
            this.__context__ = null;
        }),
        toString: d(function () {
            return "[object " + (this[Symbol.toStringTag] || "Object") + "]";
        })
    }, autoBind({
        _onAdd: d(function (index) {
            if (index >= this.__nextIndex__)
                return;
            ++this.__nextIndex__;
            if (!this.__redo__) {
                defineProperty(this, "__redo__", d("c", [index]));
                return;
            }
            this.__redo__.forEach(function (redo, i) {
                if (redo >= index)
                    this.__redo__[i] = ++redo;
            }, this);
            this.__redo__.push(index);
        }),
        _onDelete: d(function (index) {
            var i;
            if (index >= this.__nextIndex__)
                return;
            --this.__nextIndex__;
            if (!this.__redo__)
                return;
            i = this.__redo__.indexOf(index);
            if (i !== -1)
                this.__redo__.splice(i, 1);
            this.__redo__.forEach(function (redo, j) {
                if (redo > index)
                    this.__redo__[j] = --redo;
            }, this);
        }),
        _onClear: d(function () {
            if (this.__redo__)
                clear.call(this.__redo__);
            this.__nextIndex__ = 0;
        })
    })));
    defineProperty(Iterator.prototype, Symbol.iterator, d(function () {
        return this;
    }));
},
/* d/auto-bind.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* type/value/is */, ensureValue = require(86) /* type/value/ensure */, ensurePlainFunction = require(91) /* type/plain-function/ensure */, copy = require(92) /* es5-ext/object/copy */, normalizeOptions = require(41) /* es5-ext/object/normalize-options */, map = require(94) /* es5-ext/object/map */;
    var bind = Function.prototype.bind, defineProperty = Object.defineProperty, hasOwnProperty = Object.prototype.hasOwnProperty, define;
    define = function (name, desc, options) {
        var value = ensureValue(desc) && ensurePlainFunction(desc.value), dgs;
        dgs = copy(desc);
        delete dgs.writable;
        delete dgs.value;
        dgs.get = function () {
            if (!options.overwriteDefinition && hasOwnProperty.call(this, name))
                return value;
            desc.value = bind.call(value, options.resolveContext ? options.resolveContext(this) : this);
            defineProperty(this, name, desc);
            return this[name];
        };
        return dgs;
    };
    module.exports = function (props /*, options*/) {
        var options = normalizeOptions(arguments[1]);
        if (isValue(options.resolveContext))
            ensurePlainFunction(options.resolveContext);
        return map(props, function (desc, name) { return define(name, desc, options); });
    };
},
/* type/value/ensure.js */ function _(require, module, exports, __esModule, __esExport) {
    var resolveException = require(87) /* ../lib/resolve-exception */, is = require(35) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "Cannot use %v", arguments[1]);
    };
},
/* type/lib/resolve-exception.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */, isObject = require(39) /* ../object/is */, stringCoerce = require(88) /* ../string/coerce */, toShortString = require(89) /* ./to-short-string */;
    var resolveMessage = function (message, value) {
        return message.replace("%v", toShortString(value));
    };
    module.exports = function (value, defaultMessage, inputOptions) {
        if (!isObject(inputOptions))
            throw new TypeError(resolveMessage(defaultMessage, value));
        if (!isValue(value)) {
            if ("default" in inputOptions)
                return inputOptions["default"];
            if (inputOptions.isOptional)
                return null;
        }
        var errorMessage = stringCoerce(inputOptions.errorMessage);
        if (!isValue(errorMessage))
            errorMessage = defaultMessage;
        throw new TypeError(resolveMessage(errorMessage, value));
    };
},
/* type/string/coerce.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */, isObject = require(39) /* ../object/is */;
    var objectToString = Object.prototype.toString;
    module.exports = function (value) {
        if (!isValue(value))
            return null;
        if (isObject(value)) {
            // Reject Object.prototype.toString coercion
            var valueToString = value.toString;
            if (typeof valueToString !== "function")
                return null;
            if (valueToString === objectToString)
                return null;
            // Note: It can be object coming from other realm, still as there's no ES3 and CSP compliant
            // way to resolve its realm's Object.prototype.toString it's left as not addressed edge case
        }
        try {
            return "" + value; // Ensure implicit coercion
        }
        catch (error) {
            return null;
        }
    };
},
/* type/lib/to-short-string.js */ function _(require, module, exports, __esModule, __esExport) {
    var safeToString = require(90) /* ./safe-to-string */;
    var reNewLine = /[\n\r\u2028\u2029]/g;
    module.exports = function (value) {
        var string = safeToString(value);
        if (string === null)
            return "<Non-coercible to string value>";
        // Trim if too long
        if (string.length > 100)
            string = string.slice(0, 99) + "…";
        // Replace eventual new lines
        string = string.replace(reNewLine, function (char) {
            switch (char) {
                case "\n":
                    return "\\n";
                case "\r":
                    return "\\r";
                case "\u2028":
                    return "\\u2028";
                case "\u2029":
                    return "\\u2029";
                /* istanbul ignore next */
                default:
                    throw new Error("Unexpected character");
            }
        });
        return string;
    };
},
/* type/lib/safe-to-string.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        try {
            return value.toString();
        }
        catch (error) {
            try {
                return String(value);
            }
            catch (error2) {
                return null;
            }
        }
    };
},
/* type/plain-function/ensure.js */ function _(require, module, exports, __esModule, __esExport) {
    var resolveException = require(87) /* ../lib/resolve-exception */, is = require(36) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "%v is not a plain function", arguments[1]);
    };
},
/* es5-ext/object/copy.js */ function _(require, module, exports, __esModule, __esExport) {
    var aFrom = require(93) /* ../array/from */, assign = require(40) /* ./assign */, value = require(11) /* ./valid-value */;
    module.exports = function (obj /*, propertyNames, options*/) {
        var copy = Object(value(obj)), propertyNames = arguments[1], options = Object(arguments[2]);
        if (copy !== obj && !propertyNames)
            return copy;
        var result = {};
        if (propertyNames) {
            aFrom(propertyNames, function (propertyName) {
                if (options.ensure || propertyName in obj)
                    result[propertyName] = obj[propertyName];
            });
        }
        else {
            assign(result, obj);
        }
        return result;
    };
},
/* es5-ext/array/from/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(26) /* ./is-implemented */() ? Array.from : require(27) /* ./shim */;
},
/* es5-ext/object/map.js */ function _(require, module, exports, __esModule, __esExport) {
    var callable = require(53) /* ./valid-callable */, forEach = require(95) /* ./for-each */, call = Function.prototype.call;
    module.exports = function (obj, cb /*, thisArg*/) {
        var result = {}, thisArg = arguments[2];
        callable(cb);
        forEach(obj, function (value, key, targetObj, index) {
            result[key] = call.call(cb, thisArg, value, key, targetObj, index);
        });
        return result;
    };
},
/* es5-ext/object/for-each.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(96) /* ./_iterate */("forEach");
},
/* es5-ext/object/_iterate.js */ function _(require, module, exports, __esModule, __esExport) {
    var callable = require(53) /* ./valid-callable */, value = require(11) /* ./valid-value */, bind = Function.prototype.bind, call = Function.prototype.call, keys = Object.keys, objPropertyIsEnumerable = Object.prototype.propertyIsEnumerable;
    module.exports = function (method, defVal) {
        return function (obj, cb /*, thisArg, compareFn*/) {
            var list, thisArg = arguments[2], compareFn = arguments[3];
            obj = Object(value(obj));
            callable(cb);
            list = keys(obj);
            if (compareFn) {
                list.sort(typeof compareFn === "function" ? bind.call(compareFn, obj) : undefined);
            }
            if (typeof method !== "function")
                method = list[method];
            return call.call(method, list, function (key, index) {
                if (!objPropertyIsEnumerable.call(obj, key))
                    return defVal;
                return call.call(cb, thisArg, obj[key], key, obj, index);
            });
        };
    };
},
/* es6-iterator/string.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, d = require(34) /* d */, Symbol = require(28) /* es6-symbol */, Iterator = require(84) /* ./ */;
    var defineProperty = Object.defineProperty, StringIterator;
    StringIterator = module.exports = function (str) {
        if (!(this instanceof StringIterator))
            throw new TypeError("Constructor requires 'new'");
        str = String(str);
        Iterator.call(this, str);
        defineProperty(this, "__length__", d("", str.length));
    };
    if (setPrototypeOf)
        setPrototypeOf(StringIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete StringIterator.prototype.constructor;
    StringIterator.prototype = Object.create(Iterator.prototype, {
        _next: d(function () {
            if (!this.__list__)
                return undefined;
            if (this.__nextIndex__ < this.__length__)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        _resolve: d(function (i) {
            var char = this.__list__[i], code;
            if (this.__nextIndex__ === this.__length__)
                return char;
            code = char.charCodeAt(0);
            if (code >= 0xd800 && code <= 0xdbff)
                return char + this.__list__[this.__nextIndex__++];
            return char;
        })
    });
    defineProperty(StringIterator.prototype, Symbol.toStringTag, d("c", "String Iterator"));
},
/* es6-set/lib/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, contains = require(42) /* es5-ext/string/#/contains */, d = require(34) /* d */, Iterator = require(84) /* es6-iterator */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, defineProperty = Object.defineProperty, SetIterator;
    SetIterator = module.exports = function (set, kind) {
        if (!(this instanceof SetIterator))
            return new SetIterator(set, kind);
        Iterator.call(this, set.__setData__, set);
        if (!kind)
            kind = 'value';
        else if (contains.call(kind, 'key+value'))
            kind = 'key+value';
        else
            kind = 'value';
        defineProperty(this, '__kind__', d('', kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(SetIterator, Iterator);
    SetIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(SetIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__list__[i];
            return [this.__list__[i], this.__list__[i]];
        }),
        toString: d(function () { return '[object Set Iterator]'; })
    });
    defineProperty(SetIterator.prototype, toStringTagSymbol, d('c', 'Set Iterator'));
},
/* es6-set/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof Set === 'undefined')
            return false;
        return (Object.prototype.toString.call(Set.prototype) === '[object Set]');
    }());
},
/* es6-map/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(101) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, 'Map', { value: require(102) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-map/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var map, iterator, result;
        if (typeof Map !== 'function')
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            map = new Map([['raz', 'one'], ['dwa', 'two'], ['trzy', 'three']]);
        }
        catch (e) {
            return false;
        }
        if (String(map) !== '[object Map]')
            return false;
        if (map.size !== 3)
            return false;
        if (typeof map.clear !== 'function')
            return false;
        if (typeof map.delete !== 'function')
            return false;
        if (typeof map.entries !== 'function')
            return false;
        if (typeof map.forEach !== 'function')
            return false;
        if (typeof map.get !== 'function')
            return false;
        if (typeof map.has !== 'function')
            return false;
        if (typeof map.keys !== 'function')
            return false;
        if (typeof map.set !== 'function')
            return false;
        if (typeof map.values !== 'function')
            return false;
        iterator = map.entries();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (!result.value)
            return false;
        if (result.value[0] !== 'raz')
            return false;
        if (result.value[1] !== 'one')
            return false;
        return true;
    };
},
/* es6-map/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, eIndexOf = require(69) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, callable = require(53) /* es5-ext/object/valid-callable */, validValue = require(11) /* es5-ext/object/valid-value */, d = require(34) /* d */, ee = require(78) /* event-emitter */, Symbol = require(28) /* es6-symbol */, iterator = require(79) /* es6-iterator/valid-iterable */, forOf = require(81) /* es6-iterator/for-of */, Iterator = require(103) /* ./lib/iterator */, isNative = require(106) /* ./is-native-implemented */, call = Function.prototype.call, defineProperties = Object.defineProperties, getPrototypeOf = Object.getPrototypeOf, MapPoly;
    module.exports = MapPoly = function ( /*iterable*/) {
        var iterable = arguments[0], keys, values, self;
        if (!(this instanceof MapPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf && (Map !== MapPoly)) {
            self = setPrototypeOf(new Map(), getPrototypeOf(this));
        }
        else {
            self = this;
        }
        if (iterable != null)
            iterator(iterable);
        defineProperties(self, {
            __mapKeysData__: d('c', keys = []),
            __mapValuesData__: d('c', values = [])
        });
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            var key = validValue(value)[0];
            value = value[1];
            if (eIndexOf.call(keys, key) !== -1)
                return;
            keys.push(key);
            values.push(value);
        }, self);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(MapPoly, Map);
        MapPoly.prototype = Object.create(Map.prototype, {
            constructor: d(MapPoly)
        });
    }
    ee(defineProperties(MapPoly.prototype, {
        clear: d(function () {
            if (!this.__mapKeysData__.length)
                return;
            clear.call(this.__mapKeysData__);
            clear.call(this.__mapValuesData__);
            this.emit('_clear');
        }),
        delete: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return false;
            this.__mapKeysData__.splice(index, 1);
            this.__mapValuesData__.splice(index, 1);
            this.emit('_delete', index, key);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result;
            callable(cb);
            iterator = this.entries();
            result = iterator._next();
            while (result !== undefined) {
                call.call(cb, thisArg, this.__mapValuesData__[result], this.__mapKeysData__[result], this);
                result = iterator._next();
            }
        }),
        get: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return;
            return this.__mapValuesData__[index];
        }),
        has: d(function (key) {
            return (eIndexOf.call(this.__mapKeysData__, key) !== -1);
        }),
        keys: d(function () { return new Iterator(this, 'key'); }),
        set: d(function (key, value) {
            var index = eIndexOf.call(this.__mapKeysData__, key), emit;
            if (index === -1) {
                index = this.__mapKeysData__.push(key) - 1;
                emit = true;
            }
            this.__mapValuesData__[index] = value;
            if (emit)
                this.emit('_add', index, key);
            return this;
        }),
        size: d.gs(function () { return this.__mapKeysData__.length; }),
        values: d(function () { return new Iterator(this, 'value'); }),
        toString: d(function () { return '[object Map]'; })
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.iterator, d(function () {
        return this.entries();
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.toStringTag, d('c', 'Map'));
},
/* es6-map/lib/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, d = require(34) /* d */, Iterator = require(84) /* es6-iterator */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, kinds = require(104) /* ./iterator-kinds */, defineProperties = Object.defineProperties, unBind = Iterator.prototype._unBind, MapIterator;
    MapIterator = module.exports = function (map, kind) {
        if (!(this instanceof MapIterator))
            return new MapIterator(map, kind);
        Iterator.call(this, map.__mapKeysData__, map);
        if (!kind || !kinds[kind])
            kind = 'key+value';
        defineProperties(this, {
            __kind__: d('', kind),
            __values__: d('w', map.__mapValuesData__)
        });
    };
    if (setPrototypeOf)
        setPrototypeOf(MapIterator, Iterator);
    MapIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(MapIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__values__[i];
            if (this.__kind__ === 'key')
                return this.__list__[i];
            return [this.__list__[i], this.__values__[i]];
        }),
        _unBind: d(function () {
            this.__values__ = null;
            unBind.call(this);
        }),
        toString: d(function () { return '[object Map Iterator]'; })
    });
    Object.defineProperty(MapIterator.prototype, toStringTagSymbol, d('c', 'Map Iterator'));
},
/* es6-map/lib/iterator-kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(105) /* es5-ext/object/primitive-set */('key', 'value', 'key+value');
},
/* es5-ext/object/primitive-set.js */ function _(require, module, exports, __esModule, __esExport) {
    var forEach = Array.prototype.forEach, create = Object.create;
    // eslint-disable-next-line no-unused-vars
    module.exports = function (arg /*, …args*/) {
        var set = create(null);
        forEach.call(arguments, function (name) { set[name] = true; });
        return set;
    };
},
/* es6-map/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof Map === 'undefined')
            return false;
        return (Object.prototype.toString.call(new Map()) === '[object Map]');
    }());
},
/* es6-weak-map/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(108) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, "WeakMap", {
            value: require(109) /* ./polyfill */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es6-weak-map/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var weakMap, obj;
        if (typeof WeakMap !== "function")
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            weakMap = new WeakMap([[obj = {}, "one"], [{}, "two"], [{}, "three"]]);
        }
        catch (e) {
            return false;
        }
        if (String(weakMap) !== "[object WeakMap]")
            return false;
        if (typeof weakMap.set !== "function")
            return false;
        if (weakMap.set({}, 1) !== weakMap)
            return false;
        if (typeof weakMap.delete !== "function")
            return false;
        if (typeof weakMap.has !== "function")
            return false;
        if (weakMap.get(obj) !== "one")
            return false;
        return true;
    };
},
/* es6-weak-map/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* es5-ext/object/is-value */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, object = require(110) /* es5-ext/object/valid-object */, ensureValue = require(11) /* es5-ext/object/valid-value */, randomUniq = require(111) /* es5-ext/string/random-uniq */, d = require(34) /* d */, getIterator = require(82) /* es6-iterator/get */, forOf = require(81) /* es6-iterator/for-of */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, isNative = require(112) /* ./is-native-implemented */, isArray = Array.isArray, defineProperty = Object.defineProperty, objHasOwnProperty = Object.prototype.hasOwnProperty, getPrototypeOf = Object.getPrototypeOf, WeakMapPoly;
    module.exports = WeakMapPoly = function ( /* Iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof WeakMapPoly))
            throw new TypeError("Constructor requires 'new'");
        self = isNative && setPrototypeOf && (WeakMap !== WeakMapPoly)
            ? setPrototypeOf(new WeakMap(), getPrototypeOf(this)) : this;
        if (isValue(iterable)) {
            if (!isArray(iterable))
                iterable = getIterator(iterable);
        }
        defineProperty(self, "__weakMapData__", d("c", "$weakMap$" + randomUniq()));
        if (!iterable)
            return self;
        forOf(iterable, function (val) {
            ensureValue(val);
            self.set(val[0], val[1]);
        });
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(WeakMapPoly, WeakMap);
        WeakMapPoly.prototype = Object.create(WeakMap.prototype, { constructor: d(WeakMapPoly) });
    }
    Object.defineProperties(WeakMapPoly.prototype, {
        delete: d(function (key) {
            if (objHasOwnProperty.call(object(key), this.__weakMapData__)) {
                delete key[this.__weakMapData__];
                return true;
            }
            return false;
        }),
        get: d(function (key) {
            if (!objHasOwnProperty.call(object(key), this.__weakMapData__))
                return undefined;
            return key[this.__weakMapData__];
        }),
        has: d(function (key) {
            return objHasOwnProperty.call(object(key), this.__weakMapData__);
        }),
        set: d(function (key, value) {
            defineProperty(object(key), this.__weakMapData__, d("c", value));
            return this;
        }),
        toString: d(function () {
            return "[object WeakMap]";
        })
    });
    defineProperty(WeakMapPoly.prototype, toStringTagSymbol, d("c", "WeakMap"));
},
/* es5-ext/object/valid-object.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(76) /* ./is-object */;
    module.exports = function (value) {
        if (!isObject(value))
            throw new TypeError(value + " is not an Object");
        return value;
    };
},
/* es5-ext/string/random-uniq.js */ function _(require, module, exports, __esModule, __esExport) {
    var generated = Object.create(null), random = Math.random;
    module.exports = function () {
        var str;
        do {
            str = random().toString(36).slice(2);
        } while (generated[str]);
        return str;
    };
},
/* es6-weak-map/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof WeakMap !== "function")
            return false;
        return Object.prototype.toString.call(new WeakMap()) === "[object WeakMap]";
    }());
},
/* es6-symbol/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(29) /* ./is-implemented */()) {
        Object.defineProperty(require(30) /* ext/global-this */, "Symbol", {
            value: require(33) /* ./polyfill */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es6-promise/auto.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(115) /* ./ */.polyfill();
},
/* es6-promise/dist/es6-promise.js */ function _(require, module, exports, __esModule, __esExport) {
    /*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
            typeof define === 'function' && define.amd ? define(factory) :
                (global.ES6Promise = factory());
    }(this, (function () {
        'use strict';
        function objectOrFunction(x) {
            var type = typeof x;
            return x !== null && (type === 'object' || type === 'function');
        }
        function isFunction(x) {
            return typeof x === 'function';
        }
        var _isArray = void 0;
        if (Array.isArray) {
            _isArray = Array.isArray;
        }
        else {
            _isArray = function (x) {
                return Object.prototype.toString.call(x) === '[object Array]';
            };
        }
        var isArray = _isArray;
        var len = 0;
        var vertxNext = void 0;
        var customSchedulerFn = void 0;
        var asap = function asap(callback, arg) {
            queue[len] = callback;
            queue[len + 1] = arg;
            len += 2;
            if (len === 2) {
                // If len is 2, that means that we need to schedule an async flush.
                // If additional callbacks are queued before the queue is flushed, they
                // will be processed by this flush that we are scheduling.
                if (customSchedulerFn) {
                    customSchedulerFn(flush);
                }
                else {
                    scheduleFlush();
                }
            }
        };
        function setScheduler(scheduleFn) {
            customSchedulerFn = scheduleFn;
        }
        function setAsap(asapFn) {
            asap = asapFn;
        }
        var browserWindow = typeof window !== 'undefined' ? window : undefined;
        var browserGlobal = browserWindow || {};
        var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
        var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
        // test for web worker but not in IE10
        var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
        // node
        function useNextTick() {
            // node version 0.10.x displays a deprecation warning when nextTick is used recursively
            // see https://github.com/cujojs/when/issues/410 for details
            return function () {
                return process.nextTick(flush);
            };
        }
        // vertx
        function useVertxTimer() {
            if (typeof vertxNext !== 'undefined') {
                return function () {
                    vertxNext(flush);
                };
            }
            return useSetTimeout();
        }
        function useMutationObserver() {
            var iterations = 0;
            var observer = new BrowserMutationObserver(flush);
            var node = document.createTextNode('');
            observer.observe(node, { characterData: true });
            return function () {
                node.data = iterations = ++iterations % 2;
            };
        }
        // web worker
        function useMessageChannel() {
            var channel = new MessageChannel();
            channel.port1.onmessage = flush;
            return function () {
                return channel.port2.postMessage(0);
            };
        }
        function useSetTimeout() {
            // Store setTimeout reference so es6-promise will be unaffected by
            // other code modifying setTimeout (like sinon.useFakeTimers())
            var globalSetTimeout = setTimeout;
            return function () {
                return globalSetTimeout(flush, 1);
            };
        }
        var queue = new Array(1000);
        function flush() {
            for (var i = 0; i < len; i += 2) {
                var callback = queue[i];
                var arg = queue[i + 1];
                callback(arg);
                queue[i] = undefined;
                queue[i + 1] = undefined;
            }
            len = 0;
        }
        function attemptVertx() {
            try {
                var vertx = Function('return this')().require('vertx');
                vertxNext = vertx.runOnLoop || vertx.runOnContext;
                return useVertxTimer();
            }
            catch (e) {
                return useSetTimeout();
            }
        }
        var scheduleFlush = void 0;
        // Decide what async method to use to triggering processing of queued callbacks:
        if (isNode) {
            scheduleFlush = useNextTick();
        }
        else if (BrowserMutationObserver) {
            scheduleFlush = useMutationObserver();
        }
        else if (isWorker) {
            scheduleFlush = useMessageChannel();
        }
        else if (browserWindow === undefined && typeof require === 'function') {
            scheduleFlush = attemptVertx();
        }
        else {
            scheduleFlush = useSetTimeout();
        }
        function then(onFulfillment, onRejection) {
            var parent = this;
            var child = new this.constructor(noop);
            if (child[PROMISE_ID] === undefined) {
                makePromise(child);
            }
            var _state = parent._state;
            if (_state) {
                var callback = arguments[_state - 1];
                asap(function () {
                    return invokeCallback(_state, child, callback, parent._result);
                });
            }
            else {
                subscribe(parent, child, onFulfillment, onRejection);
            }
            return child;
        }
        /**
          `Promise.resolve` returns a promise that will become resolved with the
          passed `value`. It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            resolve(1);
          });
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.resolve(1);
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          @method resolve
          @static
          @param {Any} value value that the returned promise will be resolved with
          Useful for tooling.
          @return {Promise} a promise that will become fulfilled with the given
          `value`
        */
        function resolve$1(object) {
            /*jshint validthis:true */
            var Constructor = this;
            if (object && typeof object === 'object' && object.constructor === Constructor) {
                return object;
            }
            var promise = new Constructor(noop);
            resolve(promise, object);
            return promise;
        }
        var PROMISE_ID = Math.random().toString(36).substring(2);
        function noop() { }
        var PENDING = void 0;
        var FULFILLED = 1;
        var REJECTED = 2;
        function selfFulfillment() {
            return new TypeError("You cannot resolve a promise with itself");
        }
        function cannotReturnOwn() {
            return new TypeError('A promises callback cannot return that same promise.');
        }
        function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
            try {
                then$$1.call(value, fulfillmentHandler, rejectionHandler);
            }
            catch (e) {
                return e;
            }
        }
        function handleForeignThenable(promise, thenable, then$$1) {
            asap(function (promise) {
                var sealed = false;
                var error = tryThen(then$$1, thenable, function (value) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    if (thenable !== value) {
                        resolve(promise, value);
                    }
                    else {
                        fulfill(promise, value);
                    }
                }, function (reason) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    reject(promise, reason);
                }, 'Settle: ' + (promise._label || ' unknown promise'));
                if (!sealed && error) {
                    sealed = true;
                    reject(promise, error);
                }
            }, promise);
        }
        function handleOwnThenable(promise, thenable) {
            if (thenable._state === FULFILLED) {
                fulfill(promise, thenable._result);
            }
            else if (thenable._state === REJECTED) {
                reject(promise, thenable._result);
            }
            else {
                subscribe(thenable, undefined, function (value) {
                    return resolve(promise, value);
                }, function (reason) {
                    return reject(promise, reason);
                });
            }
        }
        function handleMaybeThenable(promise, maybeThenable, then$$1) {
            if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
                handleOwnThenable(promise, maybeThenable);
            }
            else {
                if (then$$1 === undefined) {
                    fulfill(promise, maybeThenable);
                }
                else if (isFunction(then$$1)) {
                    handleForeignThenable(promise, maybeThenable, then$$1);
                }
                else {
                    fulfill(promise, maybeThenable);
                }
            }
        }
        function resolve(promise, value) {
            if (promise === value) {
                reject(promise, selfFulfillment());
            }
            else if (objectOrFunction(value)) {
                var then$$1 = void 0;
                try {
                    then$$1 = value.then;
                }
                catch (error) {
                    reject(promise, error);
                    return;
                }
                handleMaybeThenable(promise, value, then$$1);
            }
            else {
                fulfill(promise, value);
            }
        }
        function publishRejection(promise) {
            if (promise._onerror) {
                promise._onerror(promise._result);
            }
            publish(promise);
        }
        function fulfill(promise, value) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._result = value;
            promise._state = FULFILLED;
            if (promise._subscribers.length !== 0) {
                asap(publish, promise);
            }
        }
        function reject(promise, reason) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._state = REJECTED;
            promise._result = reason;
            asap(publishRejection, promise);
        }
        function subscribe(parent, child, onFulfillment, onRejection) {
            var _subscribers = parent._subscribers;
            var length = _subscribers.length;
            parent._onerror = null;
            _subscribers[length] = child;
            _subscribers[length + FULFILLED] = onFulfillment;
            _subscribers[length + REJECTED] = onRejection;
            if (length === 0 && parent._state) {
                asap(publish, parent);
            }
        }
        function publish(promise) {
            var subscribers = promise._subscribers;
            var settled = promise._state;
            if (subscribers.length === 0) {
                return;
            }
            var child = void 0, callback = void 0, detail = promise._result;
            for (var i = 0; i < subscribers.length; i += 3) {
                child = subscribers[i];
                callback = subscribers[i + settled];
                if (child) {
                    invokeCallback(settled, child, callback, detail);
                }
                else {
                    callback(detail);
                }
            }
            promise._subscribers.length = 0;
        }
        function invokeCallback(settled, promise, callback, detail) {
            var hasCallback = isFunction(callback), value = void 0, error = void 0, succeeded = true;
            if (hasCallback) {
                try {
                    value = callback(detail);
                }
                catch (e) {
                    succeeded = false;
                    error = e;
                }
                if (promise === value) {
                    reject(promise, cannotReturnOwn());
                    return;
                }
            }
            else {
                value = detail;
            }
            if (promise._state !== PENDING) {
                // noop
            }
            else if (hasCallback && succeeded) {
                resolve(promise, value);
            }
            else if (succeeded === false) {
                reject(promise, error);
            }
            else if (settled === FULFILLED) {
                fulfill(promise, value);
            }
            else if (settled === REJECTED) {
                reject(promise, value);
            }
        }
        function initializePromise(promise, resolver) {
            try {
                resolver(function resolvePromise(value) {
                    resolve(promise, value);
                }, function rejectPromise(reason) {
                    reject(promise, reason);
                });
            }
            catch (e) {
                reject(promise, e);
            }
        }
        var id = 0;
        function nextId() {
            return id++;
        }
        function makePromise(promise) {
            promise[PROMISE_ID] = id++;
            promise._state = undefined;
            promise._result = undefined;
            promise._subscribers = [];
        }
        function validationError() {
            return new Error('Array Methods must be provided an Array');
        }
        var Enumerator = function () {
            function Enumerator(Constructor, input) {
                this._instanceConstructor = Constructor;
                this.promise = new Constructor(noop);
                if (!this.promise[PROMISE_ID]) {
                    makePromise(this.promise);
                }
                if (isArray(input)) {
                    this.length = input.length;
                    this._remaining = input.length;
                    this._result = new Array(this.length);
                    if (this.length === 0) {
                        fulfill(this.promise, this._result);
                    }
                    else {
                        this.length = this.length || 0;
                        this._enumerate(input);
                        if (this._remaining === 0) {
                            fulfill(this.promise, this._result);
                        }
                    }
                }
                else {
                    reject(this.promise, validationError());
                }
            }
            Enumerator.prototype._enumerate = function _enumerate(input) {
                for (var i = 0; this._state === PENDING && i < input.length; i++) {
                    this._eachEntry(input[i], i);
                }
            };
            Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
                var c = this._instanceConstructor;
                var resolve$$1 = c.resolve;
                if (resolve$$1 === resolve$1) {
                    var _then = void 0;
                    var error = void 0;
                    var didError = false;
                    try {
                        _then = entry.then;
                    }
                    catch (e) {
                        didError = true;
                        error = e;
                    }
                    if (_then === then && entry._state !== PENDING) {
                        this._settledAt(entry._state, i, entry._result);
                    }
                    else if (typeof _then !== 'function') {
                        this._remaining--;
                        this._result[i] = entry;
                    }
                    else if (c === Promise$1) {
                        var promise = new c(noop);
                        if (didError) {
                            reject(promise, error);
                        }
                        else {
                            handleMaybeThenable(promise, entry, _then);
                        }
                        this._willSettleAt(promise, i);
                    }
                    else {
                        this._willSettleAt(new c(function (resolve$$1) {
                            return resolve$$1(entry);
                        }), i);
                    }
                }
                else {
                    this._willSettleAt(resolve$$1(entry), i);
                }
            };
            Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
                var promise = this.promise;
                if (promise._state === PENDING) {
                    this._remaining--;
                    if (state === REJECTED) {
                        reject(promise, value);
                    }
                    else {
                        this._result[i] = value;
                    }
                }
                if (this._remaining === 0) {
                    fulfill(promise, this._result);
                }
            };
            Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
                var enumerator = this;
                subscribe(promise, undefined, function (value) {
                    return enumerator._settledAt(FULFILLED, i, value);
                }, function (reason) {
                    return enumerator._settledAt(REJECTED, i, reason);
                });
            };
            return Enumerator;
        }();
        /**
          `Promise.all` accepts an array of promises, and returns a new promise which
          is fulfilled with an array of fulfillment values for the passed promises, or
          rejected with the reason of the first passed promise to be rejected. It casts all
          elements of the passed iterable to promises as it runs this algorithm.
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = resolve(2);
          let promise3 = resolve(3);
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // The array here would be [ 1, 2, 3 ];
          });
          ```
        
          If any of the `promises` given to `all` are rejected, the first promise
          that is rejected will be given as an argument to the returned promises's
          rejection handler. For example:
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = reject(new Error("2"));
          let promise3 = reject(new Error("3"));
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // Code here never runs because there are rejected promises!
          }, function(error) {
            // error.message === "2"
          });
          ```
        
          @method all
          @static
          @param {Array} entries array of promises
          @param {String} label optional string for labeling the promise.
          Useful for tooling.
          @return {Promise} promise that is fulfilled when all `promises` have been
          fulfilled, or rejected if any of them become rejected.
          @static
        */
        function all(entries) {
            return new Enumerator(this, entries).promise;
        }
        /**
          `Promise.race` returns a new promise which is settled in the same way as the
          first passed promise to settle.
        
          Example:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 2');
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // result === 'promise 2' because it was resolved before promise1
            // was resolved.
          });
          ```
        
          `Promise.race` is deterministic in that only the state of the first
          settled promise matters. For example, even if other promises given to the
          `promises` array argument are resolved, but the first settled promise has
          become rejected before the other promises became fulfilled, the returned
          promise will become rejected:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              reject(new Error('promise 2'));
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // Code here never runs
          }, function(reason){
            // reason.message === 'promise 2' because promise 2 became rejected before
            // promise 1 became fulfilled
          });
          ```
        
          An example real-world use case is implementing timeouts:
        
          ```javascript
          Promise.race([ajax('foo.json'), timeout(5000)])
          ```
        
          @method race
          @static
          @param {Array} promises array of promises to observe
          Useful for tooling.
          @return {Promise} a promise which settles in the same way as the first passed
          promise to settle.
        */
        function race(entries) {
            /*jshint validthis:true */
            var Constructor = this;
            if (!isArray(entries)) {
                return new Constructor(function (_, reject) {
                    return reject(new TypeError('You must pass an array to race.'));
                });
            }
            else {
                return new Constructor(function (resolve, reject) {
                    var length = entries.length;
                    for (var i = 0; i < length; i++) {
                        Constructor.resolve(entries[i]).then(resolve, reject);
                    }
                });
            }
        }
        /**
          `Promise.reject` returns a promise rejected with the passed `reason`.
          It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            reject(new Error('WHOOPS'));
          });
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.reject(new Error('WHOOPS'));
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          @method reject
          @static
          @param {Any} reason value that the returned promise will be rejected with.
          Useful for tooling.
          @return {Promise} a promise rejected with the given `reason`.
        */
        function reject$1(reason) {
            /*jshint validthis:true */
            var Constructor = this;
            var promise = new Constructor(noop);
            reject(promise, reason);
            return promise;
        }
        function needsResolver() {
            throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
        }
        function needsNew() {
            throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
        }
        /**
          Promise objects represent the eventual result of an asynchronous operation. The
          primary way of interacting with a promise is through its `then` method, which
          registers callbacks to receive either a promise's eventual value or the reason
          why the promise cannot be fulfilled.
        
          Terminology
          -----------
        
          - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
          - `thenable` is an object or function that defines a `then` method.
          - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
          - `exception` is a value that is thrown using the throw statement.
          - `reason` is a value that indicates why a promise was rejected.
          - `settled` the final resting state of a promise, fulfilled or rejected.
        
          A promise can be in one of three states: pending, fulfilled, or rejected.
        
          Promises that are fulfilled have a fulfillment value and are in the fulfilled
          state.  Promises that are rejected have a rejection reason and are in the
          rejected state.  A fulfillment value is never a thenable.
        
          Promises can also be said to *resolve* a value.  If this value is also a
          promise, then the original promise's settled state will match the value's
          settled state.  So a promise that *resolves* a promise that rejects will
          itself reject, and a promise that *resolves* a promise that fulfills will
          itself fulfill.
        
        
          Basic Usage:
          ------------
        
          ```js
          let promise = new Promise(function(resolve, reject) {
            // on success
            resolve(value);
        
            // on failure
            reject(reason);
          });
        
          promise.then(function(value) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Advanced Usage:
          ---------------
        
          Promises shine when abstracting away asynchronous interactions such as
          `XMLHttpRequest`s.
        
          ```js
          function getJSON(url) {
            return new Promise(function(resolve, reject){
              let xhr = new XMLHttpRequest();
        
              xhr.open('GET', url);
              xhr.onreadystatechange = handler;
              xhr.responseType = 'json';
              xhr.setRequestHeader('Accept', 'application/json');
              xhr.send();
        
              function handler() {
                if (this.readyState === this.DONE) {
                  if (this.status === 200) {
                    resolve(this.response);
                  } else {
                    reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
                  }
                }
              };
            });
          }
        
          getJSON('/posts.json').then(function(json) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Unlike callbacks, promises are great composable primitives.
        
          ```js
          Promise.all([
            getJSON('/posts'),
            getJSON('/comments')
          ]).then(function(values){
            values[0] // => postsJSON
            values[1] // => commentsJSON
        
            return values;
          });
          ```
        
          @class Promise
          @param {Function} resolver
          Useful for tooling.
          @constructor
        */
        var Promise$1 = function () {
            function Promise(resolver) {
                this[PROMISE_ID] = nextId();
                this._result = this._state = undefined;
                this._subscribers = [];
                if (noop !== resolver) {
                    typeof resolver !== 'function' && needsResolver();
                    this instanceof Promise ? initializePromise(this, resolver) : needsNew();
                }
            }
            /**
            The primary way of interacting with a promise is through its `then` method,
            which registers callbacks to receive either a promise's eventual value or the
            reason why the promise cannot be fulfilled.
             ```js
            findUser().then(function(user){
              // user is available
            }, function(reason){
              // user is unavailable, and you are given the reason why
            });
            ```
             Chaining
            --------
             The return value of `then` is itself a promise.  This second, 'downstream'
            promise is resolved with the return value of the first promise's fulfillment
            or rejection handler, or rejected if the handler throws an exception.
             ```js
            findUser().then(function (user) {
              return user.name;
            }, function (reason) {
              return 'default name';
            }).then(function (userName) {
              // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
              // will be `'default name'`
            });
             findUser().then(function (user) {
              throw new Error('Found user, but still unhappy');
            }, function (reason) {
              throw new Error('`findUser` rejected and we're unhappy');
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
              // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
            });
            ```
            If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
             ```js
            findUser().then(function (user) {
              throw new PedagogicalException('Upstream error');
            }).then(function (value) {
              // never reached
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // The `PedgagocialException` is propagated all the way down to here
            });
            ```
             Assimilation
            ------------
             Sometimes the value you want to propagate to a downstream promise can only be
            retrieved asynchronously. This can be achieved by returning a promise in the
            fulfillment or rejection handler. The downstream promise will then be pending
            until the returned promise is settled. This is called *assimilation*.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // The user's comments are now available
            });
            ```
             If the assimliated promise rejects, then the downstream promise will also reject.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // If `findCommentsByAuthor` fulfills, we'll have the value here
            }, function (reason) {
              // If `findCommentsByAuthor` rejects, we'll have the reason here
            });
            ```
             Simple Example
            --------------
             Synchronous Example
             ```javascript
            let result;
             try {
              result = findResult();
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
            findResult(function(result, err){
              if (err) {
                // failure
              } else {
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findResult().then(function(result){
              // success
            }, function(reason){
              // failure
            });
            ```
             Advanced Example
            --------------
             Synchronous Example
             ```javascript
            let author, books;
             try {
              author = findAuthor();
              books  = findBooksByAuthor(author);
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
             function foundBooks(books) {
             }
             function failure(reason) {
             }
             findAuthor(function(author, err){
              if (err) {
                failure(err);
                // failure
              } else {
                try {
                  findBoooksByAuthor(author, function(books, err) {
                    if (err) {
                      failure(err);
                    } else {
                      try {
                        foundBooks(books);
                      } catch(reason) {
                        failure(reason);
                      }
                    }
                  });
                } catch(error) {
                  failure(err);
                }
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findAuthor().
              then(findBooksByAuthor).
              then(function(books){
                // found books
            }).catch(function(reason){
              // something went wrong
            });
            ```
             @method then
            @param {Function} onFulfilled
            @param {Function} onRejected
            Useful for tooling.
            @return {Promise}
            */
            /**
            `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
            as the catch block of a try/catch statement.
            ```js
            function findAuthor(){
            throw new Error('couldn't find that author');
            }
            // synchronous
            try {
            findAuthor();
            } catch(reason) {
            // something went wrong
            }
            // async with promises
            findAuthor().catch(function(reason){
            // something went wrong
            });
            ```
            @method catch
            @param {Function} onRejection
            Useful for tooling.
            @return {Promise}
            */
            Promise.prototype.catch = function _catch(onRejection) {
                return this.then(null, onRejection);
            };
            /**
              `finally` will be invoked regardless of the promise's fate just as native
              try/catch/finally behaves
            
              Synchronous example:
            
              ```js
              findAuthor() {
                if (Math.random() > 0.5) {
                  throw new Error();
                }
                return new Author();
              }
            
              try {
                return findAuthor(); // succeed or fail
              } catch(error) {
                return findOtherAuther();
              } finally {
                // always runs
                // doesn't affect the return value
              }
              ```
            
              Asynchronous example:
            
              ```js
              findAuthor().catch(function(reason){
                return findOtherAuther();
              }).finally(function(){
                // author was either found, or not
              });
              ```
            
              @method finally
              @param {Function} callback
              @return {Promise}
            */
            Promise.prototype.finally = function _finally(callback) {
                var promise = this;
                var constructor = promise.constructor;
                if (isFunction(callback)) {
                    return promise.then(function (value) {
                        return constructor.resolve(callback()).then(function () {
                            return value;
                        });
                    }, function (reason) {
                        return constructor.resolve(callback()).then(function () {
                            throw reason;
                        });
                    });
                }
                return promise.then(callback, callback);
            };
            return Promise;
        }();
        Promise$1.prototype.then = then;
        Promise$1.all = all;
        Promise$1.race = race;
        Promise$1.resolve = resolve$1;
        Promise$1.reject = reject$1;
        Promise$1._setScheduler = setScheduler;
        Promise$1._setAsap = setAsap;
        Promise$1._asap = asap;
        /*global self*/
        function polyfill() {
            var local = void 0;
            if (typeof global !== 'undefined') {
                local = global;
            }
            else if (typeof self !== 'undefined') {
                local = self;
            }
            else {
                try {
                    local = Function('return this')();
                }
                catch (e) {
                    throw new Error('polyfill failed because global object is unavailable in this environment');
                }
            }
            var P = local.Promise;
            if (P) {
                var promiseToString = null;
                try {
                    promiseToString = Object.prototype.toString.call(P.resolve());
                }
                catch (e) {
                    // silently ignored
                }
                if (promiseToString === '[object Promise]' && !P.cast) {
                    return;
                }
            }
            local.Promise = Promise$1;
        }
        // Strange compat..
        Promise$1.polyfill = polyfill;
        Promise$1.Promise = Promise$1;
        return Promise$1;
    })));
},
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(117) /* ./index */, exports);
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var version_1 = require(118) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(119) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(119) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(528) /* ./protocol */);
    exports._testing = tslib_1.__importStar(require(529) /* ./testing */);
    var logging_1 = require(134) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(143) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(122) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(120) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(530) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "2.4.0-dev.1";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var document_1 = require(120) /* ../document */;
    var logging_1 = require(134) /* ../core/logging */;
    var string_1 = require(149) /* ../core/util/string */;
    var object_1 = require(128) /* ../core/util/object */;
    var types_1 = require(123) /* ../core/util/types */;
    var defer_1 = require(131) /* ../core/util/defer */;
    var standalone_1 = require(519) /* ./standalone */;
    var server_1 = require(521) /* ./server */;
    var dom_1 = require(520) /* ./dom */;
    var standalone_2 = require(519) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(521) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(526) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    var dom_2 = require(520) /* ./dom */;
    __esExport("BOKEH_ROOT", dom_2.BOKEH_ROOT);
    function embed_item(item, target_id) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var docs_json, doc_id, element, roots, render_item, _a, views;
            var _b;
            return tslib_1.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        docs_json = {};
                        doc_id = string_1.uuid4();
                        docs_json[doc_id] = item.doc;
                        if (target_id == null)
                            target_id = item.target_id;
                        element = document.getElementById(target_id);
                        if (element != null)
                            element.classList.add(dom_1.BOKEH_ROOT);
                        roots = (_b = {}, _b[item.root_id] = target_id, _b);
                        render_item = { roots: roots, root_ids: [item.root_id], docid: doc_id };
                        return [4 /*yield*/, defer_1.defer()];
                    case 1:
                        _c.sent();
                        return [4 /*yield*/, _embed_items(docs_json, [render_item])];
                    case 2:
                        _a = tslib_1.__read.apply(void 0, [_c.sent(), 1]), views = _a[0];
                        return [2 /*return*/, views];
                }
            });
        });
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    function embed_items(docs_json, render_items, app_path, absolute_url) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, defer_1.defer()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, _embed_items(docs_json, render_items, app_path, absolute_url)];
                }
            });
        });
    }
    exports.embed_items = embed_items;
    function _embed_items(docs_json, render_items, app_path, absolute_url) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var docs, _a, _b, _c, docid, doc_json, views, render_items_1, render_items_1_1, item, element, roots, _d, _e, websocket_url, _f, _g, error_1, e_1_1;
            var e_2, _h, e_1, _j;
            return tslib_1.__generator(this, function (_k) {
                switch (_k.label) {
                    case 0:
                        if (types_1.isString(docs_json))
                            docs_json = JSON.parse(string_1.unescape(docs_json));
                        docs = {};
                        try {
                            for (_a = tslib_1.__values(object_1.entries(docs_json)), _b = _a.next(); !_b.done; _b = _a.next()) {
                                _c = tslib_1.__read(_b.value, 2), docid = _c[0], doc_json = _c[1];
                                docs[docid] = document_1.Document.from_json(doc_json);
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (_b && !_b.done && (_h = _a.return))
                                    _h.call(_a);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        views = [];
                        _k.label = 1;
                    case 1:
                        _k.trys.push([1, 12, 13, 14]);
                        render_items_1 = tslib_1.__values(render_items), render_items_1_1 = render_items_1.next();
                        _k.label = 2;
                    case 2:
                        if (!!render_items_1_1.done)
                            return [3 /*break*/, 11];
                        item = render_items_1_1.value;
                        element = dom_1._resolve_element(item);
                        roots = dom_1._resolve_root_elements(item);
                        if (!(item.docid != null))
                            return [3 /*break*/, 4];
                        _e = (_d = views).push;
                        return [4 /*yield*/, standalone_1.add_document_standalone(docs[item.docid], element, roots, item.use_for_title)];
                    case 3:
                        _e.apply(_d, [_k.sent()]);
                        return [3 /*break*/, 10];
                    case 4:
                        if (!(item.token != null))
                            return [3 /*break*/, 9];
                        websocket_url = server_1._get_ws_url(app_path, absolute_url);
                        logging_1.logger.debug("embed: computed ws url: " + websocket_url);
                        _k.label = 5;
                    case 5:
                        _k.trys.push([5, 7, , 8]);
                        _g = (_f = views).push;
                        return [4 /*yield*/, server_1.add_document_from_session(websocket_url, item.token, element, roots, item.use_for_title)];
                    case 6:
                        _g.apply(_f, [_k.sent()]);
                        console.log("Bokeh items were rendered successfully");
                        return [3 /*break*/, 8];
                    case 7:
                        error_1 = _k.sent();
                        console.log("Error rendering Bokeh items:", error_1);
                        return [3 /*break*/, 8];
                    case 8: return [3 /*break*/, 10];
                    case 9: throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
                    case 10:
                        render_items_1_1 = render_items_1.next();
                        return [3 /*break*/, 2];
                    case 11: return [3 /*break*/, 14];
                    case 12:
                        e_1_1 = _k.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 14];
                    case 13:
                        try {
                            if (render_items_1_1 && !render_items_1_1.done && (_j = render_items_1.return))
                                _j.call(render_items_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                        return [7 /*endfinally*/];
                    case 14: return [2 /*return*/, views];
                }
            });
        });
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(121) /* ./document */, exports);
    tslib_1.__exportStar(require(150) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var base_1 = require(122) /* ../base */;
    var version_1 = require(118) /* ../version */;
    var logging_1 = require(134) /* ../core/logging */;
    var bokeh_events_1 = require(361) /* ../core/bokeh_events */;
    var has_props_1 = require(129) /* ../core/has_props */;
    var serializer_1 = require(145) /* ../core/serializer */;
    var signaling_1 = require(130) /* ../core/signaling */;
    var refs_1 = require(132) /* ../core/util/refs */;
    var serialization_1 = require(146) /* ../core/util/serialization */;
    var ndarray_1 = require(144) /* ../core/util/ndarray */;
    var array_1 = require(124) /* ../core/util/array */;
    var object_1 = require(128) /* ../core/util/object */;
    var sets = tslib_1.__importStar(require(192) /* ../core/util/set */);
    var eq_1 = require(141) /* ../core/util/eq */;
    var types_1 = require(123) /* ../core/util/types */;
    var layout_dom_1 = require(432) /* ../models/layouts/layout_dom */;
    var column_data_source_1 = require(190) /* ../models/sources/column_data_source */;
    var model_1 = require(168) /* ../model */;
    var defs_1 = require(518) /* ./defs */;
    var events_1 = require(150) /* ./events */;
    // Dispatches events to the subscribed models
    var EventManager = /** @class */ (function () {
        function EventManager(document) {
            this.document = document;
            this.session = null;
            this.subscribed_models = new Set();
        }
        EventManager.prototype.send_event = function (bokeh_event) {
            var event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event.to_json());
            this.document._trigger_on_change(event);
        };
        EventManager.prototype.trigger = function (event) {
            var e_1, _a;
            try {
                for (var _b = tslib_1.__values(this.subscribed_models), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var model = _c.value;
                    if (event.origin != null && event.origin != model)
                        continue;
                    model._process_event(event);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return EventManager;
    }());
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    var Document = /** @class */ (function () {
        function Document(options) {
            var _a;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = (_a = options === null || options === void 0 ? void 0 : options.resolver) !== null && _a !== void 0 ? _a : new base_1.ModelResolver();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakMap(); // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        Object.defineProperty(Document.prototype, "layoutables", {
            get: function () {
                return this._roots.filter(function (root) { return root instanceof layout_dom_1.LayoutDOM; });
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Document.prototype, "is_idle", {
            get: function () {
                var e_2, _a;
                try {
                    for (var _b = tslib_1.__values(this.layoutables), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var root = _c.value;
                        if (!this._idle_roots.has(root))
                            return false;
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Document.prototype.notify_idle = function (model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info("document idle at " + (Date.now() - this._init_timestamp) + " ms");
                this.event_manager.send_event(new bokeh_events_1.DocumentReady());
                this.idle.emit();
            }
        };
        Document.prototype.clear = function () {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        };
        Document.prototype.interactive_start = function (plot, finalize) {
            if (finalize === void 0) {
                finalize = null;
            }
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_finalize = finalize;
            this._interactive_timestamp = Date.now();
        };
        Document.prototype.interactive_stop = function () {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
                if (this._interactive_finalize != null) {
                    this._interactive_finalize();
                }
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
            this._interactive_finalize = null;
        };
        Document.prototype.interactive_duration = function () {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        };
        Document.prototype.destructively_move = function (dest_doc) {
            var e_3, _a, e_4, _b;
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            var roots = array_1.copy(this._roots);
            this.clear();
            try {
                for (var roots_1 = tslib_1.__values(roots), roots_1_1 = roots_1.next(); !roots_1_1.done; roots_1_1 = roots_1.next()) {
                    var root = roots_1_1.value;
                    if (root.document != null)
                        throw new Error("Somehow we didn't detach " + root);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (roots_1_1 && !roots_1_1.done && (_a = roots_1.return))
                        _a.call(roots_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            if (this._all_models.size != 0) {
                throw new Error("this._all_models still had stuff in it: " + this._all_models);
            }
            try {
                for (var roots_2 = tslib_1.__values(roots), roots_2_1 = roots_2.next(); !roots_2_1.done; roots_2_1 = roots_2.next()) {
                    var root = roots_2_1.value;
                    dest_doc.add_root(root);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (roots_2_1 && !roots_2_1.done && (_b = roots_2.return))
                        _b.call(roots_2);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            dest_doc.set_title(this._title);
        };
        // TODO other fields of doc
        Document.prototype._push_all_models_freeze = function () {
            this._all_models_freeze_count += 1;
        };
        Document.prototype._pop_all_models_freeze = function () {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        /*protected*/ Document.prototype._invalidate_all_models = function () {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        Document.prototype._recompute_all_models = function () {
            var e_5, _a, e_6, _b, e_7, _c, e_8, _d;
            var new_all_models_set = new Set();
            try {
                for (var _e = tslib_1.__values(this._roots), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var r = _f.value;
                    new_all_models_set = sets.union(new_all_models_set, r.references());
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return))
                        _a.call(_e);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            var old_all_models_set = new Set(this._all_models.values());
            var to_detach = sets.difference(old_all_models_set, new_all_models_set);
            var to_attach = sets.difference(new_all_models_set, old_all_models_set);
            var recomputed = new Map();
            try {
                for (var new_all_models_set_1 = tslib_1.__values(new_all_models_set), new_all_models_set_1_1 = new_all_models_set_1.next(); !new_all_models_set_1_1.done; new_all_models_set_1_1 = new_all_models_set_1.next()) {
                    var model = new_all_models_set_1_1.value;
                    recomputed.set(model.id, model);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (new_all_models_set_1_1 && !new_all_models_set_1_1.done && (_b = new_all_models_set_1.return))
                        _b.call(new_all_models_set_1);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            try {
                for (var to_detach_1 = tslib_1.__values(to_detach), to_detach_1_1 = to_detach_1.next(); !to_detach_1_1.done; to_detach_1_1 = to_detach_1.next()) {
                    var d = to_detach_1_1.value;
                    d.detach_document();
                }
            }
            catch (e_7_1) {
                e_7 = { error: e_7_1 };
            }
            finally {
                try {
                    if (to_detach_1_1 && !to_detach_1_1.done && (_c = to_detach_1.return))
                        _c.call(to_detach_1);
                }
                finally {
                    if (e_7)
                        throw e_7.error;
                }
            }
            try {
                for (var to_attach_1 = tslib_1.__values(to_attach), to_attach_1_1 = to_attach_1.next(); !to_attach_1_1.done; to_attach_1_1 = to_attach_1.next()) {
                    var a = to_attach_1_1.value;
                    a.attach_document(this);
                }
            }
            catch (e_8_1) {
                e_8 = { error: e_8_1 };
            }
            finally {
                try {
                    if (to_attach_1_1 && !to_attach_1_1.done && (_d = to_attach_1.return))
                        _d.call(to_attach_1);
                }
                finally {
                    if (e_8)
                        throw e_8.error;
                }
            }
            this._all_models = recomputed;
        };
        Document.prototype.roots = function () {
            return this._roots;
        };
        Document.prototype.add_root = function (model, setter_id) {
            logging_1.logger.debug("Adding root: " + model);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootAddedEvent(this, model, setter_id));
        };
        Document.prototype.remove_root = function (model, setter_id) {
            var i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootRemovedEvent(this, model, setter_id));
        };
        Document.prototype.title = function () {
            return this._title;
        };
        Document.prototype.set_title = function (title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title, setter_id));
            }
        };
        Document.prototype.get_model_by_id = function (model_id) {
            var _a;
            return (_a = this._all_models.get(model_id)) !== null && _a !== void 0 ? _a : null;
        };
        Document.prototype.get_model_by_name = function (name) {
            var e_9, _a;
            var found = [];
            try {
                for (var _b = tslib_1.__values(this._all_models.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var model = _c.value;
                    if (model instanceof model_1.Model && model.name == name)
                        found.push(model);
                }
            }
            catch (e_9_1) {
                e_9 = { error: e_9_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_9)
                        throw e_9.error;
                }
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error("Multiple models are named '" + name + "'");
            }
        };
        Document.prototype.on_message = function (msg_type, callback) {
            var message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null)
                this._message_callbacks.set(msg_type, new Set([callback]));
            else
                message_callbacks.add(callback);
        };
        Document.prototype.remove_on_message = function (msg_type, callback) {
            var _a;
            (_a = this._message_callbacks.get(msg_type)) === null || _a === void 0 ? void 0 : _a.delete(callback);
        };
        Document.prototype._trigger_on_message = function (msg_type, msg_data) {
            var e_10, _a;
            var message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                try {
                    for (var message_callbacks_1 = tslib_1.__values(message_callbacks), message_callbacks_1_1 = message_callbacks_1.next(); !message_callbacks_1_1.done; message_callbacks_1_1 = message_callbacks_1.next()) {
                        var cb = message_callbacks_1_1.value;
                        cb(msg_data);
                    }
                }
                catch (e_10_1) {
                    e_10 = { error: e_10_1 };
                }
                finally {
                    try {
                        if (message_callbacks_1_1 && !message_callbacks_1_1.done && (_a = message_callbacks_1.return))
                            _a.call(message_callbacks_1);
                    }
                    finally {
                        if (e_10)
                            throw e_10.error;
                    }
                }
            }
        };
        Document.prototype.on_change = function (callback, allow_batches) {
            if (allow_batches === void 0) {
                allow_batches = false;
            }
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        };
        Document.prototype.remove_on_change = function (callback) {
            this._callbacks.delete(callback);
        };
        Document.prototype._trigger_on_change = function (event) {
            var e_11, _a, e_12, _b;
            try {
                for (var _c = tslib_1.__values(this._callbacks), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = tslib_1.__read(_d.value, 2), callback = _e[0], allow_batches = _e[1];
                    if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                        try {
                            for (var _f = (e_12 = void 0, tslib_1.__values(event.events)), _g = _f.next(); !_g.done; _g = _f.next()) {
                                var ev = _g.value;
                                callback(ev);
                            }
                        }
                        catch (e_12_1) {
                            e_12 = { error: e_12_1 };
                        }
                        finally {
                            try {
                                if (_g && !_g.done && (_b = _f.return))
                                    _b.call(_f);
                            }
                            finally {
                                if (e_12)
                                    throw e_12.error;
                            }
                        }
                    }
                    else {
                        callback(event); // TODO
                    }
                }
            }
            catch (e_11_1) {
                e_11 = { error: e_11_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_11)
                        throw e_11.error;
                }
            }
        };
        Document.prototype._notify_change = function (model, attr, old_value, new_value, options) {
            this._trigger_on_change(new events_1.ModelChangedEvent(this, model, attr, old_value, new_value, options === null || options === void 0 ? void 0 : options.setter_id, options === null || options === void 0 ? void 0 : options.hint));
        };
        Document._instantiate_object = function (obj_id, obj_type, obj_attrs, resolver) {
            var full_attrs = tslib_1.__assign(tslib_1.__assign({}, obj_attrs), { id: obj_id, __deferred__: true });
            var model = resolver.get(obj_type);
            return new model(full_attrs);
        };
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        Document._instantiate_references_json = function (references_json, existing_models, resolver) {
            var e_13, _a;
            var _b;
            // Create all instances, but without setting their props
            var references = new Map();
            try {
                for (var references_json_1 = tslib_1.__values(references_json), references_json_1_1 = references_json_1.next(); !references_json_1_1.done; references_json_1_1 = references_json_1.next()) {
                    var obj = references_json_1_1.value;
                    var obj_id = obj.id;
                    var obj_type = obj.type;
                    var obj_attrs = (_b = obj.attributes) !== null && _b !== void 0 ? _b : {};
                    var instance = existing_models.get(obj_id);
                    if (instance == null) {
                        instance = Document._instantiate_object(obj_id, obj_type, obj_attrs, resolver);
                        if (obj.subtype != null)
                            instance.set_subtype(obj.subtype);
                    }
                    references.set(instance.id, instance);
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (references_json_1_1 && !references_json_1_1.done && (_a = references_json_1.return))
                        _a.call(references_json_1);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            return references;
        };
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        Document._resolve_refs = function (value, old_references, new_references, buffers) {
            function resolve_ref(v) {
                var _a;
                if (refs_1.is_ref(v)) {
                    var obj = (_a = old_references.get(v.id)) !== null && _a !== void 0 ? _a : new_references.get(v.id);
                    if (obj != null)
                        return obj;
                    else
                        throw new Error("reference " + JSON.stringify(v) + " isn't known (not in Document?)");
                }
                else if (serialization_1.is_NDArray_ref(v)) {
                    var _b = serialization_1.decode_NDArray(v, buffers), buffer = _b.buffer, dtype = _b.dtype, shape = _b.shape;
                    return ndarray_1.ndarray(buffer, { dtype: dtype, shape: shape });
                }
                else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isPlainObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                var e_14, _a;
                var results = [];
                try {
                    for (var array_2 = tslib_1.__values(array), array_2_1 = array_2.next(); !array_2_1.done; array_2_1 = array_2.next()) {
                        var v = array_2_1.value;
                        results.push(resolve_ref(v));
                    }
                }
                catch (e_14_1) {
                    e_14 = { error: e_14_1 };
                }
                finally {
                    try {
                        if (array_2_1 && !array_2_1.done && (_a = array_2.return))
                            _a.call(array_2);
                    }
                    finally {
                        if (e_14)
                            throw e_14.error;
                    }
                }
                return results;
            }
            function resolve_dict(dict) {
                var e_15, _a;
                var resolved = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(dict)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), k = _d[0], v = _d[1];
                        resolved[k] = resolve_ref(v);
                    }
                }
                catch (e_15_1) {
                    e_15 = { error: e_15_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_15)
                            throw e_15.error;
                    }
                }
                return resolved;
            }
            return resolve_ref(value);
        };
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        Document._initialize_references_json = function (references_json, old_references, new_references, buffers) {
            var e_16, _a, e_17, _b, e_18, _c;
            var to_update = new Map();
            try {
                for (var references_json_2 = tslib_1.__values(references_json), references_json_2_1 = references_json_2.next(); !references_json_2_1.done; references_json_2_1 = references_json_2.next()) {
                    var _d = references_json_2_1.value, id = _d.id, attributes = _d.attributes;
                    var is_new = !old_references.has(id);
                    var instance = is_new ? new_references.get(id) : old_references.get(id);
                    // replace references with actual instances in obj_attrs
                    var resolved_attrs = Document._resolve_refs(attributes, old_references, new_references, buffers);
                    instance.setv(resolved_attrs, { silent: true });
                    to_update.set(id, { instance: instance, is_new: is_new });
                }
            }
            catch (e_16_1) {
                e_16 = { error: e_16_1 };
            }
            finally {
                try {
                    if (references_json_2_1 && !references_json_2_1.done && (_a = references_json_2.return))
                        _a.call(references_json_2);
                }
                finally {
                    if (e_16)
                        throw e_16.error;
                }
            }
            var ordered_instances = [];
            var handled = new Set();
            function finalize_all_by_dfs(v) {
                var e_19, _a, e_20, _b, e_21, _c;
                if (v instanceof has_props_1.HasProps) {
                    // note that we ignore instances that aren't updated (not in to_update)
                    if (to_update.has(v.id) && !handled.has(v.id)) {
                        handled.add(v.id);
                        var _d = to_update.get(v.id), instance = _d.instance, is_new = _d.is_new;
                        var attributes = instance.attributes;
                        try {
                            for (var _e = tslib_1.__values(object_1.values(attributes)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var value = _f.value;
                                finalize_all_by_dfs(value);
                            }
                        }
                        catch (e_19_1) {
                            e_19 = { error: e_19_1 };
                        }
                        finally {
                            try {
                                if (_f && !_f.done && (_a = _e.return))
                                    _a.call(_e);
                            }
                            finally {
                                if (e_19)
                                    throw e_19.error;
                            }
                        }
                        if (is_new) {
                            // Finalizing here just to avoid iterating
                            // over `ordered_instances` twice.
                            instance.finalize();
                            // Preserving an ordered collection of instances
                            // to avoid having to go through DFS again.
                            ordered_instances.push(instance);
                        }
                    }
                }
                else if (types_1.isArray(v)) {
                    try {
                        for (var v_1 = tslib_1.__values(v), v_1_1 = v_1.next(); !v_1_1.done; v_1_1 = v_1.next()) {
                            var e = v_1_1.value;
                            finalize_all_by_dfs(e);
                        }
                    }
                    catch (e_20_1) {
                        e_20 = { error: e_20_1 };
                    }
                    finally {
                        try {
                            if (v_1_1 && !v_1_1.done && (_b = v_1.return))
                                _b.call(v_1);
                        }
                        finally {
                            if (e_20)
                                throw e_20.error;
                        }
                    }
                }
                else if (types_1.isPlainObject(v)) {
                    try {
                        for (var _g = tslib_1.__values(object_1.values(v)), _h = _g.next(); !_h.done; _h = _g.next()) {
                            var value = _h.value;
                            finalize_all_by_dfs(value);
                        }
                    }
                    catch (e_21_1) {
                        e_21 = { error: e_21_1 };
                    }
                    finally {
                        try {
                            if (_h && !_h.done && (_c = _g.return))
                                _c.call(_g);
                        }
                        finally {
                            if (e_21)
                                throw e_21.error;
                        }
                    }
                }
            }
            try {
                for (var _e = tslib_1.__values(to_update.values()), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var item = _f.value;
                    finalize_all_by_dfs(item.instance);
                }
            }
            catch (e_17_1) {
                e_17 = { error: e_17_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_17)
                        throw e_17.error;
                }
            }
            try {
                // `connect_signals` has to be executed last because it
                // may rely on properties of dependencies that are initialized
                // only in `finalize`. It's a problem that appears when
                // there are circular references, e.g. as in
                // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
                for (var ordered_instances_1 = tslib_1.__values(ordered_instances), ordered_instances_1_1 = ordered_instances_1.next(); !ordered_instances_1_1.done; ordered_instances_1_1 = ordered_instances_1.next()) {
                    var instance = ordered_instances_1_1.value;
                    instance.connect_signals();
                }
            }
            catch (e_18_1) {
                e_18 = { error: e_18_1 };
            }
            finally {
                try {
                    if (ordered_instances_1_1 && !ordered_instances_1_1.done && (_c = ordered_instances_1.return))
                        _c.call(ordered_instances_1);
                }
                finally {
                    if (e_18)
                        throw e_18.error;
                }
            }
        };
        //////
        ///{{{
        Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
            var changed_model = doc.get_model_by_id(changed_obj.id); // XXX!
            if (!changed_model.property(key).syncable)
                return null;
            else {
                var event = {
                    kind: "ModelChanged",
                    model: { id: changed_obj.id },
                    attr: key,
                    new: new_value,
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, { recursive: true });
                return event;
            }
        };
        Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
            var e_22, _a, e_23, _b, e_24, _c;
            var from_keys = Object.keys(from_obj.attributes); //XXX!
            var to_keys = Object.keys(to_obj.attributes); //XXX!
            var removed = array_1.difference(from_keys, to_keys);
            var added = array_1.difference(to_keys, from_keys);
            var shared = array_1.intersection(from_keys, to_keys);
            var events = [];
            try {
                for (var removed_1 = tslib_1.__values(removed), removed_1_1 = removed_1.next(); !removed_1_1.done; removed_1_1 = removed_1.next()) {
                    var key = removed_1_1.value;
                    // we don't really have a "remove" event - not sure this ever
                    // happens even. One way this could happen is if the server
                    // does include_defaults=True and we do
                    // include_defaults=false ... in that case it'd be best to
                    // just ignore this probably. Warn about it, could mean
                    // there's a bug if we don't have a key that the server sent.
                    logging_1.logger.warn("Server sent key " + key + " but we don't seem to have it in our JSON");
                }
            }
            catch (e_22_1) {
                e_22 = { error: e_22_1 };
            }
            finally {
                try {
                    if (removed_1_1 && !removed_1_1.done && (_a = removed_1.return))
                        _a.call(removed_1);
                }
                finally {
                    if (e_22)
                        throw e_22.error;
                }
            }
            try {
                for (var added_1 = tslib_1.__values(added), added_1_1 = added_1.next(); !added_1_1.done; added_1_1 = added_1.next()) {
                    var key = added_1_1.value;
                    var new_value = to_obj.attributes[key]; // XXX!
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            catch (e_23_1) {
                e_23 = { error: e_23_1 };
            }
            finally {
                try {
                    if (added_1_1 && !added_1_1.done && (_b = added_1.return))
                        _b.call(added_1);
                }
                finally {
                    if (e_23)
                        throw e_23.error;
                }
            }
            try {
                for (var shared_1 = tslib_1.__values(shared), shared_1_1 = shared_1.next(); !shared_1_1.done; shared_1_1 = shared_1.next()) {
                    var key = shared_1_1.value;
                    var old_value = from_obj.attributes[key]; // XXX!
                    var new_value = to_obj.attributes[key]; // XXX!
                    if (old_value == null && new_value == null) {
                    }
                    else if (old_value == null || new_value == null) {
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                    }
                    else {
                        if (!eq_1.is_equal(old_value, new_value))
                            events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                    }
                }
            }
            catch (e_24_1) {
                e_24 = { error: e_24_1 };
            }
            finally {
                try {
                    if (shared_1_1 && !shared_1_1.done && (_c = shared_1.return))
                        _c.call(shared_1);
                }
                finally {
                    if (e_24)
                        throw e_24.error;
                }
            }
            return events.filter(function (e) { return e != null; });
        };
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        Document._compute_patch_since_json = function (from_json, to_doc) {
            var e_25, _a, e_26, _b, e_27, _c;
            var to_json = to_doc.to_json(false); // include_defaults=false
            function refs(json) {
                var e_28, _a;
                var result = new Map();
                try {
                    for (var _b = tslib_1.__values(json.roots.references), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var obj = _c.value;
                        result.set(obj.id, obj);
                    }
                }
                catch (e_28_1) {
                    e_28 = { error: e_28_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_28)
                            throw e_28.error;
                    }
                }
                return result;
            }
            var from_references = refs(from_json);
            var from_roots = new Map();
            var from_root_ids = [];
            try {
                for (var _d = tslib_1.__values(from_json.roots.root_ids), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var r = _e.value;
                    from_roots.set(r, from_references.get(r));
                    from_root_ids.push(r);
                }
            }
            catch (e_25_1) {
                e_25 = { error: e_25_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_25)
                        throw e_25.error;
                }
            }
            var to_references = refs(to_json);
            var to_roots = new Map();
            var to_root_ids = [];
            try {
                for (var _f = tslib_1.__values(to_json.roots.root_ids), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var r = _g.value;
                    to_roots.set(r, to_references.get(r));
                    to_root_ids.push(r);
                }
            }
            catch (e_26_1) {
                e_26 = { error: e_26_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_26)
                        throw e_26.error;
                }
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 ||
                array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error("Not implemented: computing add/remove of document roots");
            }
            var value_refs = new Set();
            var events = [];
            try {
                for (var _h = tslib_1.__values(to_doc._all_models.keys()), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var id = _j.value;
                    if (from_references.has(id)) {
                        var update_model_events = Document._events_to_sync_objects(from_references.get(id), to_references.get(id), to_doc, value_refs);
                        events = events.concat(update_model_events);
                    }
                }
            }
            catch (e_27_1) {
                e_27 = { error: e_27_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_c = _h.return))
                        _c.call(_h);
                }
                finally {
                    if (e_27)
                        throw e_27.error;
                }
            }
            var serializer = new serializer_1.Serializer({ include_defaults: false });
            serializer.to_serializable(tslib_1.__spreadArray([], tslib_1.__read(value_refs)));
            return {
                references: tslib_1.__spreadArray([], tslib_1.__read(serializer.definitions)),
                events: events,
            };
        };
        ///}}}
        //////
        Document.prototype.to_json_string = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            return JSON.stringify(this.to_json(include_defaults));
        };
        Document.prototype.to_json = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var serializer = new serializer_1.Serializer({ include_defaults: include_defaults });
            var roots = serializer.to_serializable(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots: {
                    root_ids: roots.map(function (r) { return r.id; }),
                    references: tslib_1.__spreadArray([], tslib_1.__read(serializer.definitions)),
                },
            };
        };
        Document.from_json_string = function (s) {
            var json = JSON.parse(s);
            return Document.from_json(json);
        };
        Document.from_json = function (json) {
            var e_29, _a;
            logging_1.logger.debug("Creating Document from JSON");
            function pyify(version) {
                return version.replace(/-(dev|rc)\./, "$1");
            }
            var py_version = json.version; // XXX!
            var is_dev = py_version.indexOf("+") !== -1 || py_version.indexOf("-") !== -1;
            var versions_string = "Library versions: JS (" + version_1.version + ") / Python (" + py_version + ")";
            if (!is_dev && pyify(version_1.version) != py_version) {
                logging_1.logger.warn("JS/Python version mismatch");
                logging_1.logger.warn(versions_string);
            }
            else
                logging_1.logger.debug(versions_string);
            var resolver = new base_1.ModelResolver();
            if (json.defs != null) {
                defs_1.resolve_defs(json.defs, resolver);
            }
            var roots_json = json.roots;
            var root_ids = roots_json.root_ids;
            var references_json = roots_json.references;
            var references = Document._instantiate_references_json(references_json, new Map(), resolver);
            Document._initialize_references_json(references_json, new Map(), references, new Map());
            var doc = new Document({ resolver: resolver });
            try {
                for (var root_ids_1 = tslib_1.__values(root_ids), root_ids_1_1 = root_ids_1.next(); !root_ids_1_1.done; root_ids_1_1 = root_ids_1.next()) {
                    var id = root_ids_1_1.value;
                    var root = references.get(id);
                    if (root != null) {
                        doc.add_root(root); // XXX: HasProps
                    }
                }
            }
            catch (e_29_1) {
                e_29 = { error: e_29_1 };
            }
            finally {
                try {
                    if (root_ids_1_1 && !root_ids_1_1.done && (_a = root_ids_1.return))
                        _a.call(root_ids_1);
                }
                finally {
                    if (e_29)
                        throw e_29.error;
                }
            }
            doc.set_title(json.title); // XXX!
            return doc;
        };
        Document.prototype.replace_with_json = function (json) {
            var replacement = Document.from_json(json);
            replacement.destructively_move(this);
        };
        /** @deprecated */
        Document.prototype.create_json_patch_string = function (events) {
            return JSON.stringify(this.create_json_patch(events));
        };
        Document.prototype.create_json_patch = function (events) {
            var e_30, _a, e_31, _b;
            try {
                for (var events_2 = tslib_1.__values(events), events_2_1 = events_2.next(); !events_2_1.done; events_2_1 = events_2.next()) {
                    var event = events_2_1.value;
                    if (event.document != this)
                        throw new Error("Cannot create a patch using events from a different document");
                }
            }
            catch (e_30_1) {
                e_30 = { error: e_30_1 };
            }
            finally {
                try {
                    if (events_2_1 && !events_2_1.done && (_a = events_2.return))
                        _a.call(events_2);
                }
                finally {
                    if (e_30)
                        throw e_30.error;
                }
            }
            var serializer = new serializer_1.Serializer();
            var events_repr = serializer.to_serializable(events);
            try {
                // TODO: We need a proper differential serializer. For now just remove known
                // definitions. We are doing this after a complete serialization, so that all
                // new objects are recorded.
                for (var _c = tslib_1.__values(this._all_models.values()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var model = _d.value;
                    serializer.remove_def(model);
                }
            }
            catch (e_31_1) {
                e_31 = { error: e_31_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_b = _c.return))
                        _b.call(_c);
                }
                finally {
                    if (e_31)
                        throw e_31.error;
                }
            }
            return {
                events: events_repr,
                references: tslib_1.__spreadArray([], tslib_1.__read(serializer.definitions)),
            };
        };
        Document.prototype.apply_json_patch = function (patch, buffers, setter_id) {
            var e_32, _a, e_33, _b, e_34, _c, _d;
            if (buffers === void 0) {
                buffers = new Map();
            }
            var references_json = patch.references;
            var events_json = patch.events;
            var references = Document._instantiate_references_json(references_json, this._all_models, this._resolver);
            if (!(buffers instanceof Map)) {
                buffers = new Map(buffers);
            }
            try {
                // The model being changed isn't always in references so add it in
                for (var events_json_1 = tslib_1.__values(events_json), events_json_1_1 = events_json_1.next(); !events_json_1_1.done; events_json_1_1 = events_json_1.next()) {
                    var event_json = events_json_1_1.value;
                    switch (event_json.kind) {
                        case "RootAdded":
                        case "RootRemoved":
                        case "ModelChanged": {
                            var model_id = event_json.model.id;
                            var model = this._all_models.get(model_id);
                            if (model != null) {
                                references.set(model_id, model);
                            }
                            else if (!references.has(model_id)) {
                                logging_1.logger.warn("Got an event for unknown model " + event_json.model + "\"");
                                throw new Error("event model wasn't known");
                            }
                            break;
                        }
                    }
                }
            }
            catch (e_32_1) {
                e_32 = { error: e_32_1 };
            }
            finally {
                try {
                    if (events_json_1_1 && !events_json_1_1.done && (_a = events_json_1.return))
                        _a.call(events_json_1);
                }
                finally {
                    if (e_32)
                        throw e_32.error;
                }
            }
            // split references into old and new so we know whether to initialize or update
            var old_references = new Map(this._all_models);
            var new_references = new Map();
            try {
                for (var references_1 = tslib_1.__values(references), references_1_1 = references_1.next(); !references_1_1.done; references_1_1 = references_1.next()) {
                    var _e = tslib_1.__read(references_1_1.value, 2), id = _e[0], value = _e[1];
                    if (!old_references.has(id))
                        new_references.set(id, value);
                }
            }
            catch (e_33_1) {
                e_33 = { error: e_33_1 };
            }
            finally {
                try {
                    if (references_1_1 && !references_1_1.done && (_b = references_1.return))
                        _b.call(references_1);
                }
                finally {
                    if (e_33)
                        throw e_33.error;
                }
            }
            Document._initialize_references_json(references_json, old_references, new_references, buffers);
            try {
                for (var events_json_2 = tslib_1.__values(events_json), events_json_2_1 = events_json_2.next(); !events_json_2_1.done; events_json_2_1 = events_json_2.next()) {
                    var event_json = events_json_2_1.value;
                    switch (event_json.kind) {
                        case "MessageSent": {
                            var msg_type = event_json.msg_type, msg_data = event_json.msg_data;
                            var data = void 0;
                            if (msg_data === undefined) {
                                if (buffers.size == 1) {
                                    var _f = tslib_1.__read(buffers, 1), _g = tslib_1.__read(_f[0], 2), buffer = _g[1];
                                    data = buffer;
                                }
                                else {
                                    throw new Error("expected exactly one buffer");
                                }
                            }
                            else {
                                data = Document._resolve_refs(msg_data, old_references, new_references, buffers);
                            }
                            this._trigger_on_message(msg_type, data);
                            break;
                        }
                        case "ModelChanged": {
                            var patched_id = event_json.model.id;
                            var patched_obj = this._all_models.get(patched_id);
                            if (patched_obj == null) {
                                throw new Error("Cannot apply patch to " + patched_id + " which is not in the document");
                            }
                            var attr = event_json.attr;
                            var value = Document._resolve_refs(event_json.new, old_references, new_references, buffers);
                            patched_obj.setv((_d = {}, _d[attr] = value, _d), { setter_id: setter_id });
                            break;
                        }
                        case "ColumnDataChanged": {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                            }
                            var data = Document._resolve_refs(event_json.new, new Map(), new Map(), buffers);
                            if (event_json.cols != null) {
                                for (var k in column_source.data) {
                                    if (!(k in data)) {
                                        data[k] = column_source.data[k];
                                    }
                                }
                            }
                            column_source.setv({ data: data }, { setter_id: setter_id, check_eq: false });
                            break;
                        }
                        case "ColumnsStreamed": {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                            }
                            if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                                throw new Error("Cannot stream to non-ColumnDataSource");
                            }
                            var data = event_json.data;
                            var rollover = event_json.rollover;
                            column_source.stream(data, rollover, setter_id);
                            break;
                        }
                        case "ColumnsPatched": {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot patch " + column_source_id + " which is not in the document");
                            }
                            if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                                throw new Error("Cannot patch non-ColumnDataSource");
                            }
                            var patches = event_json.patches;
                            column_source.patch(patches, setter_id);
                            break;
                        }
                        case "RootAdded": {
                            var root_id = event_json.model.id;
                            var root_obj = references.get(root_id);
                            this.add_root(root_obj, setter_id); // XXX: HasProps
                            break;
                        }
                        case "RootRemoved": {
                            var root_id = event_json.model.id;
                            var root_obj = references.get(root_id);
                            this.remove_root(root_obj, setter_id); // XXX: HasProps
                            break;
                        }
                        case "TitleChanged": {
                            this.set_title(event_json.title, setter_id);
                            break;
                        }
                        default:
                            throw new Error("Unknown patch event " + JSON.stringify(event_json));
                    }
                }
            }
            catch (e_34_1) {
                e_34 = { error: e_34_1 };
            }
            finally {
                try {
                    if (events_json_2_1 && !events_json_2_1.done && (_c = events_json_2.return))
                        _c.call(events_json_2);
                }
                finally {
                    if (e_34)
                        throw e_34.error;
                }
            }
        };
        return Document;
    }());
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./core/util/types */;
    var object_1 = require(128) /* ./core/util/object */;
    var has_props_1 = require(129) /* ./core/has_props */;
    exports.overrides = {};
    var _all_models = new Map();
    exports.Models = (function (name) {
        var model = exports.Models.get(name);
        if (model != null)
            return model;
        else
            throw new Error("Model '" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
    });
    exports.Models.get = function (name) {
        var _a;
        return (_a = exports.overrides[name]) !== null && _a !== void 0 ? _a : _all_models.get(name);
    };
    exports.Models.register = function (name, model) {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = function (name) {
        delete exports.overrides[name];
    };
    function is_HasProps(obj) {
        return types_1.isObject(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    exports.Models.register_models = function (models, force, errorFn) {
        var e_1, _a;
        if (force === void 0) {
            force = false;
        }
        if (models == null)
            return;
        try {
            for (var _b = tslib_1.__values(types_1.isArray(models) ? models : object_1.values(models)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var model = _c.value;
                if (is_HasProps(model)) {
                    var qualified = model.__qualified__;
                    if (force || !_all_models.has(qualified))
                        _all_models.set(qualified, model);
                    else if (errorFn != null)
                        errorFn(qualified);
                    else
                        console.warn("Model '" + qualified + "' was already registered");
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = function () { return tslib_1.__spreadArray([], tslib_1.__read(_all_models.keys())); };
    var ModelResolver = /** @class */ (function () {
        function ModelResolver() {
            this._known_models = new Map();
        }
        ModelResolver.prototype.get = function (name, or_else) {
            var _a;
            var model = (_a = exports.Models.get(name)) !== null && _a !== void 0 ? _a : this._known_models.get(name);
            if (model != null)
                return model;
            else if (or_else !== undefined)
                return or_else;
            else
                throw new Error("Model '" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
        };
        ModelResolver.prototype.register = function (model) {
            var name = model.__qualified__;
            if (this.get(name, null) == null)
                this._known_models.set(name, model);
            else
                console.warn("Model '" + name + "' was already registered with this resolver");
        };
        return ModelResolver;
    }());
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
    // TODO: this doesn't belong here, but it's easier this way for backwards compatibility
    var AllModels = tslib_1.__importStar(require(153) /* ./models */);
    exports.register_models(AllModels);
    var DOMModels = tslib_1.__importStar(require(514) /* ./models/dom */);
    exports.register_models(DOMModels);
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    var array_1 = require(124) /* ./array */;
    var toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === "[object Boolean]";
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj);
    }
    exports.isPrimitive = isPrimitive;
    function isFunction(obj) {
        return toString.call(obj) === "[object Function]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return array_1.every(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (var i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        var tp = typeof obj;
        return tp === "function" || tp === "object" && !!obj;
    }
    exports.isObject = isObject;
    function isPlainObject(obj) {
        return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
    function isIterable(obj) {
        return isObject(obj) && obj[Symbol.iterator] !== undefined;
    }
    exports.isIterable = isIterable;
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    exports.isArrayable = isArrayable;
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    var math_1 = require(125) /* ./math */;
    var assert_1 = require(126) /* ./assert */;
    var arrayable_1 = require(127) /* ./arrayable */;
    __esExport("map", arrayable_1.map);
    __esExport("reduce", arrayable_1.reduce);
    __esExport("min", arrayable_1.min);
    __esExport("min_by", arrayable_1.min_by);
    __esExport("max", arrayable_1.max);
    __esExport("max_by", arrayable_1.max_by);
    __esExport("sum", arrayable_1.sum);
    __esExport("cumsum", arrayable_1.cumsum);
    __esExport("every", arrayable_1.every);
    __esExport("some", arrayable_1.some);
    __esExport("find", arrayable_1.find);
    __esExport("find_last", arrayable_1.find_last);
    __esExport("find_index", arrayable_1.find_index);
    __esExport("find_last_index", arrayable_1.find_last_index);
    __esExport("sorted_index", arrayable_1.sorted_index);
    __esExport("is_empty", arrayable_1.is_empty);
    var slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat.apply([], tslib_1.__spreadArray([], tslib_1.__read(arrays)));
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        if (arrays.length == 0)
            return [];
        var n = arrayable_1.min(arrays.map(function (a) { return a.length; }));
        var k = arrays.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (var j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        var n = array.length;
        var k = arrayable_1.min(array.map(function (a) { return a.length; }));
        var results = Array(k);
        for (var j = 0; j < k; j++)
            results[j] = new Array(n);
        for (var i = 0; i < n; i++) {
            for (var j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step) {
        if (step === void 0) {
            step = 1;
        }
        assert_1.assert(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        var max = Math.max, ceil = Math.ceil, abs = Math.abs;
        var delta = start <= stop ? step : -step;
        var length = max(ceil(abs(stop - start) / step), 0);
        var range = new Array(length);
        for (var i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num) {
        if (num === void 0) {
            num = 100;
        }
        var step = (stop - start) / (num - 1);
        var array = new Array(num);
        for (var i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        var rows = array.length;
        var cols = array[0].length;
        var transposed = [];
        for (var j = 0; j < cols; j++) {
            transposed[j] = [];
            for (var i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return arrayable_1.min_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmin = argmin;
    function argmax(array) {
        return arrayable_1.max_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        var tmp = array.map(function (value, index) {
            return { value: value, index: index, key: key(value) };
        });
        tmp.sort(function (left, right) {
            var a = left.key;
            var b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map(function (item) { return item.value; });
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        var e_1, _a;
        var result = new Set();
        try {
            for (var array_1 = tslib_1.__values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
                var value = array_1_1.value;
                result.add(value);
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (array_1_1 && !array_1_1.done && (_a = array_1.return))
                    _a.call(array_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return tslib_1.__spreadArray([], tslib_1.__read(result));
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        var e_2, _a;
        var result = [];
        var seen = [];
        try {
            for (var array_2 = tslib_1.__values(array), array_2_1 = array_2.next(); !array_2_1.done; array_2_1 = array_2.next()) {
                var value = array_2_1.value;
                var computed = key(value);
                if (!includes(seen, computed)) {
                    seen.push(computed);
                    result.push(value);
                }
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (array_2_1 && !array_2_1.done && (_a = array_2.return))
                    _a.call(array_2);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union() {
        var e_3, _a, e_4, _b;
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        var result = new Set();
        try {
            for (var arrays_1 = tslib_1.__values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
                var array = arrays_1_1.value;
                try {
                    for (var array_3 = (e_4 = void 0, tslib_1.__values(array)), array_3_1 = array_3.next(); !array_3_1.done; array_3_1 = array_3.next()) {
                        var value = array_3_1.value;
                        result.add(value);
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (array_3_1 && !array_3_1.done && (_b = array_3.return))
                            _b.call(array_3);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return))
                    _a.call(arrays_1);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        return tslib_1.__spreadArray([], tslib_1.__read(result));
    }
    exports.union = union;
    function intersection(array) {
        var e_5, _a, e_6, _b;
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var result = [];
        try {
            top: for (var array_4 = tslib_1.__values(array), array_4_1 = array_4.next(); !array_4_1.done; array_4_1 = array_4.next()) {
                var item = array_4_1.value;
                if (includes(result, item))
                    continue;
                try {
                    for (var arrays_2 = (e_6 = void 0, tslib_1.__values(arrays)), arrays_2_1 = arrays_2.next(); !arrays_2_1.done; arrays_2_1 = arrays_2.next()) {
                        var other = arrays_2_1.value;
                        if (!includes(other, item))
                            continue top;
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (arrays_2_1 && !arrays_2_1.done && (_b = arrays_2.return))
                            _b.call(arrays_2);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
                result.push(item);
            }
        }
        catch (e_5_1) {
            e_5 = { error: e_5_1 };
        }
        finally {
            try {
                if (array_4_1 && !array_4_1.done && (_a = array_4.return))
                    _a.call(array_4);
            }
            finally {
                if (e_5)
                    throw e_5.error;
            }
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var rest = concat(arrays);
        return array.filter(function (value) { return !includes(rest, value); });
    }
    exports.difference = difference;
    function remove_at(array, i) {
        var result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (var i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        var length = array.length;
        var shuffled = new Array(length);
        for (var i = 0; i < length; i++) {
            var rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        var n = array.length;
        var result = new Array(n - 1);
        for (var i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var PI = Math.PI;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, anticlock) {
        if (anticlock === void 0) {
            anticlock = false;
        }
        var d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * PI)
            return true;
        var norm_mid = angle_norm(mid);
        var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    exports.radians = radians;
    function degrees(radians) {
        return radians / (PI / 180);
    }
    exports.degrees = degrees;
    function resolve_angle(angle, units) {
        /** Convert CCW angle with units to CW radians (canvas). */
        return -to_radians_coeff(units) * angle;
    }
    exports.resolve_angle = resolve_angle;
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    exports.to_radians_coeff = to_radians_coeff;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        var r1;
        var r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        var rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    exports.clamp = clamp;
    function log(x, base) {
        if (base === void 0) {
            base = Math.E;
        }
        return Math.log(x) / Math.log(base);
    }
    exports.log = log;
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var AssertionError = /** @class */ (function (_super) {
        tslib_1.__extends(AssertionError, _super);
        function AssertionError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AssertionError;
    }(Error));
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message !== null && message !== void 0 ? message : "Assertion failed");
    }
    exports.assert = assert;
    function unreachable() {
        throw new Error("unreachable code");
    }
    exports.unreachable = unreachable;
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var math_1 = require(125) /* ./math */;
    function is_empty(array) {
        return array.length == 0;
    }
    exports.is_empty = is_empty;
    function copy(array) {
        if (Array.isArray(array))
            return array.slice();
        else
            return new array.constructor(array);
    }
    exports.copy = copy;
    function splice(array, start, k) {
        var e_1, _a;
        var items = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            items[_i - 3] = arguments[_i];
        }
        var len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        var n = len - k + items.length;
        var result = new array.constructor(n);
        var i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        try {
            for (var items_1 = tslib_1.__values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                var item = items_1_1.value;
                result[i++] = item;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (items_1_1 && !items_1_1.done && (_a = items_1.return))
                    _a.call(items_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        for (var j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (var i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function subselect(array, indices) {
        var n = indices.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    exports.subselect = subselect;
    function mul(array, coeff, output) {
        var n = array.length;
        var result = output !== null && output !== void 0 ? output : new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    exports.mul = mul;
    function map(array, fn) {
        var n = array.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function inplace_map(array, fn, output) {
        var n = array.length;
        var result = output !== null && output !== void 0 ? output : array;
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    exports.inplace_map = inplace_map;
    function filter(array, pred) {
        var n = array.length;
        var result = new array.constructor(n);
        var k = 0;
        for (var i = 0; i < n; i++) {
            var value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        var n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        var value;
        var i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        var value;
        var result = Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function max(array) {
        var value;
        var result = -Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function minmax(array) {
        var value;
        var min = +Infinity;
        var max = -Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
    exports.minmax = minmax;
    function minmax2(arr, brr) {
        var a;
        var b;
        var a_min = +Infinity;
        var a_max = -Infinity;
        var b_min = +Infinity;
        var b_max = -Infinity;
        var n = Math.min(arr.length, brr.length);
        for (var i = 0; i < n; i++) {
            a = arr[i];
            b = brr[i];
            if (!isNaN(a) && !isNaN(b)) {
                if (a < a_min)
                    a_min = a;
                if (a > a_max)
                    a_max = a;
                if (b < b_min)
                    b_min = b;
                if (b > b_max)
                    b_max = b;
            }
        }
        return [a_min, a_max, b_min, b_max];
    }
    exports.minmax2 = minmax2;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        var result = 0;
        for (var i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        var result = new array.constructor(array.length);
        reduce(array, function (a, b, i) { return result[i] = a + b; }, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (!predicate(array[i]))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (predicate(array[i]))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            var length = array.length;
            var index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        var index = exports.find_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        var index = exports.find_last_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        var low = 0;
        var high = array.length;
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
    function bin_counts(data, bin_edges) {
        var nbins = bin_edges.length - 1;
        var counts = Array(nbins).fill(0);
        for (var i = 0; i < data.length; i++) {
            var sample = data[i];
            var index = sorted_index(bin_edges, sample);
            var bin = math_1.clamp(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    exports.bin_counts = bin_counts;
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        var n = points.length;
        var results = new Array(n);
        for (var i = 0; i < n; i++) {
            var point = points[i];
            if (isNaN(point)) {
                results[i] = point;
                continue;
            }
            var index = left_edge_index(point, x_values);
            if (index == -1)
                results[i] = y_values[0];
            else if (index == x_values.length)
                results[i] = y_values[y_values.length - 1];
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                var x0 = x_values[index];
                var y0 = y_values[index];
                var x1 = x_values[index + 1];
                var y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    exports.interpolate = interpolate;
    function lerp(x, x0, y0, x1, y1) {
        var slope = (y1 - y0) / (x1 - x0);
        var res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1))
                res = y0;
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0])
            return -1;
        if (point > intervals[intervals.length - 1])
            return intervals.length;
        var leftEdgeIndex = 0;
        var rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            var indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare])
                leftEdgeIndex = indexOfNumberToCompare;
            else
                rightEdgeIndex = indexOfNumberToCompare;
        }
        return leftEdgeIndex;
    }
    exports.left_edge_index = left_edge_index;
    function norm(array, start, end) {
        var span = end - start;
        return map(array, function (x) { return (x - start) / span; });
    }
    exports.norm = norm;
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var array_1 = require(124) /* ./array */;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    exports.keys = Object.keys, exports.values = Object.values, exports.entries = Object.entries, exports.extend = Object.assign;
    function clone(obj) {
        return tslib_1.__assign({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        var e_1, _a;
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        var result = Object.create(Object.prototype);
        var keys = array_1.concat([Object.keys(obj1), Object.keys(obj2)]);
        try {
            for (var keys_1 = tslib_1.__values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                var arr1 = hasOwnProperty.call(obj1, key) ? obj1[key] : [];
                var arr2 = hasOwnProperty.call(obj2, key) ? obj2[key] : [];
                result[key] = array_1.union(arr1, arr2);
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
                    _a.call(keys_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function is_empty(obj) {
        return size(obj) == 0;
    }
    exports.is_empty = is_empty;
    /** @deprecated */
    exports.isEmpty = is_empty;
    function to_object(map) {
        var e_2, _a;
        var obj = {};
        try {
            for (var map_1 = tslib_1.__values(map), map_1_1 = map_1.next(); !map_1_1.done; map_1_1 = map_1.next()) {
                var _b = tslib_1.__read(map_1_1.value, 2), key = _b[0], val = _b[1];
                obj[key] = val;
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (map_1_1 && !map_1_1.done && (_a = map_1.return))
                    _a.call(map_1);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return obj;
    }
    exports.to_object = to_object;
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var refs_1 = require(132) /* ./util/refs */;
    var p = tslib_1.__importStar(require(133) /* ./properties */);
    var k = tslib_1.__importStar(require(136) /* ./kinds */);
    var string_1 = require(149) /* ./util/string */;
    var object_1 = require(128) /* ./util/object */;
    var types_1 = require(123) /* ./util/types */;
    var eq_1 = require(141) /* ./util/eq */;
    var serializer_1 = require(145) /* ./serializer */;
    var events_1 = require(150) /* ../document/events */;
    var eq_2 = require(141) /* ./util/eq */;
    var pretty_1 = require(151) /* ./util/pretty */;
    var cloneable_1 = require(152) /* ./util/cloneable */;
    var kinds = tslib_1.__importStar(require(136) /* ./kinds */);
    var HasProps = /** @class */ (function (_super) {
        tslib_1.__extends(HasProps, _super);
        function HasProps(attrs) {
            var e_1, _a;
            if (attrs === void 0) {
                attrs = {};
            }
            var _b, _c;
            var _this = _super.call(this) || this;
            _this._subtype = undefined;
            _this.document = null;
            _this.destroyed = new signaling_1.Signal0(_this, "destroyed");
            _this.change = new signaling_1.Signal0(_this, "change");
            _this.transformchange = new signaling_1.Signal0(_this, "transformchange");
            _this.exprchange = new signaling_1.Signal0(_this, "exprchange");
            _this.properties = {};
            _this._pending = false;
            _this._changing = false;
            var get = attrs instanceof Map ? attrs.get.bind(attrs) : function (name) { return attrs[name]; };
            _this.id = (_b = get("id")) !== null && _b !== void 0 ? _b : string_1.uniqueId();
            var _loop_1 = function (name, type, default_value, options) {
                var property = void 0;
                if (type instanceof p.PropertyAlias) {
                    Object.defineProperty(this_1.properties, name, {
                        get: function () { return _this.properties[type.attr]; },
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind)
                        property = new p.PrimitiveProperty(this_1, name, type, default_value, get(name), options);
                    else
                        property = new type(this_1, name, k.Any, default_value, get(name), options);
                    this_1.properties[name] = property;
                }
            };
            var this_1 = this;
            try {
                for (var _d = tslib_1.__values(object_1.entries(_this._props)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var _f = tslib_1.__read(_e.value, 2), name = _f[0], _g = _f[1], type = _g.type, default_value = _g.default_value, options = _g.options;
                    _loop_1(name, type, default_value, options);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!((_c = get("__deferred__")) !== null && _c !== void 0 ? _c : false)) {
                _this.finalize();
                _this.connect_signals();
            }
            return _this;
        }
        Object.defineProperty(HasProps.prototype, "is_syncable", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps.prototype, "type", {
            get: function () {
                return this.constructor.__qualified__;
            },
            // XXX: setter is only required for backwards compatibility
            set: function (name) {
                console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
                this.constructor.__name__ = name;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps, "__qualified__", {
            get: function () {
                var _a = this, __module__ = _a.__module__, __name__ = _a.__name__;
                return __module__ != null ? __module__ + "." + __name__ : __name__;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps, Symbol.toStringTag, {
            get: function () {
                return this.__name__;
            },
            enumerable: false,
            configurable: true
        });
        HasProps.init_HasProps = function () {
            this.prototype._props = {};
            this.prototype._mixins = [];
        };
        HasProps._fix_default = function (default_value, _attr) {
            if (default_value === undefined || types_1.isFunction(default_value))
                return default_value;
            else if (types_1.isPrimitive(default_value))
                return function () { return default_value; };
            else {
                var cloner_1 = new cloneable_1.Cloner();
                return function () { return cloner_1.clone(default_value); };
            }
        };
        // TODO: don't use Partial<>, but exclude inherited properties
        HasProps.define = function (obj) {
            var e_2, _a;
            var _loop_2 = function (name, prop) {
                if (this_2.prototype._props[name] != null)
                    throw new Error("attempted to redefine property '" + this_2.prototype.type + "." + name + "'");
                if (this_2.prototype[name] != null)
                    throw new Error("attempted to redefine attribute '" + this_2.prototype.type + "." + name + "'");
                Object.defineProperty(this_2.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get: function () {
                        var value = this.properties[name].get_value();
                        return value;
                    },
                    set: function (value) {
                        var _a;
                        this.setv((_a = {}, _a[name] = value, _a));
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                var _e = tslib_1.__read(prop, 3), type = _e[0], default_value = _e[1], _f = _e[2], options = _f === void 0 ? {} : _f;
                var refined_prop = {
                    type: type,
                    default_value: this_2._fix_default(default_value, name),
                    options: options,
                };
                var props = tslib_1.__assign({}, this_2.prototype._props);
                props[name] = refined_prop;
                this_2.prototype._props = props;
            };
            var this_2 = this;
            try {
                for (var _b = tslib_1.__values(object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    _loop_2(name, prop);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        HasProps.internal = function (obj) {
            var e_3, _a;
            var _object = {};
            try {
                for (var _b = tslib_1.__values(object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    var _e = tslib_1.__read(prop, 3), type = _e[0], default_value = _e[1], _f = _e[2], options = _f === void 0 ? {} : _f;
                    _object[name] = [type, default_value, tslib_1.__assign(tslib_1.__assign({}, options), { internal: true })];
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            this.define(_object);
        };
        HasProps.mixins = function (defs) {
            var e_4, _a;
            function rename(prefix, mixin) {
                var e_5, _a;
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(mixin)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                        result[prefix + name] = prop;
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                return result;
            }
            var mixin_defs = {};
            var mixins = [];
            try {
                for (var _b = tslib_1.__values(types_1.isArray(defs) ? defs : [defs]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var def = _c.value;
                    if (types_1.isArray(def)) {
                        var _d = tslib_1.__read(def, 2), prefix = _d[0], mixin = _d[1];
                        object_1.extend(mixin_defs, rename(prefix, mixin));
                        mixins.push([prefix, mixin]);
                    }
                    else {
                        var mixin = def;
                        object_1.extend(mixin_defs, mixin);
                        mixins.push(["", mixin]);
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(this.prototype._mixins)), tslib_1.__read(mixins));
        };
        HasProps.override = function (obj) {
            var e_6, _a;
            try {
                for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    var default_value = this._fix_default(prop, name);
                    var value = this.prototype._props[name];
                    if (value == null)
                        throw new Error("attempted to override nonexistent '" + this.prototype.type + "." + name + "'");
                    var props = tslib_1.__assign({}, this.prototype._props);
                    props[name] = tslib_1.__assign(tslib_1.__assign({}, value), { default_value: default_value });
                    this.prototype._props = props;
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        HasProps.prototype.toString = function () {
            return this.type + "(" + this.id + ")";
        };
        HasProps.prototype.property = function (name) {
            var prop = this.properties[name];
            if (prop != null)
                return prop;
            else
                throw new Error("unknown property " + this.type + "." + name);
        };
        Object.defineProperty(HasProps.prototype, "attributes", {
            get: function () {
                var e_7, _a;
                var attrs = {};
                try {
                    for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var prop = _c.value;
                        attrs[prop.attr] = prop.get_value();
                    }
                }
                catch (e_7_1) {
                    e_7 = { error: e_7_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_7)
                            throw e_7.error;
                    }
                }
                return attrs;
            },
            enumerable: false,
            configurable: true
        });
        HasProps.prototype[cloneable_1.clone] = function (cloner) {
            var e_8, _a;
            var attrs = new Map();
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.dirty) {
                        attrs.set(prop.attr, cloner.clone(prop.get_value()));
                    }
                }
            }
            catch (e_8_1) {
                e_8 = { error: e_8_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_8)
                        throw e_8.error;
                }
            }
            return new this.constructor(attrs);
        };
        HasProps.prototype[eq_2.equals] = function (that, cmp) {
            var e_9, _a;
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var p0 = _c.value;
                    var p1 = that.property(p0.attr);
                    if (cmp.eq(p0.get_value(), p1.get_value()))
                        return false;
                }
            }
            catch (e_9_1) {
                e_9 = { error: e_9_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_9)
                        throw e_9.error;
                }
            }
            return true;
        };
        HasProps.prototype[pretty_1.pretty] = function (printer) {
            var e_10, _a;
            var T = printer.token;
            var items = [];
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.dirty) {
                        var value = prop.get_value();
                        items.push("" + prop.attr + T(":") + " " + printer.to_string(value));
                    }
                }
            }
            catch (e_10_1) {
                e_10 = { error: e_10_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_10)
                        throw e_10.error;
                }
            }
            var cls = this.constructor.__qualified__;
            return "" + cls + T("(") + T("{") + items.join(T(",") + " ") + T("}") + T(")");
        };
        HasProps.prototype[serializer_1.serialize] = function (serializer) {
            var e_11, _a;
            var ref = this.ref();
            serializer.add_ref(this, ref);
            var struct = this.struct();
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
                        struct.attributes[prop.attr] = serializer.to_serializable(prop.get_value());
                    }
                }
            }
            catch (e_11_1) {
                e_11 = { error: e_11_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_11)
                        throw e_11.error;
                }
            }
            serializer.add_def(this, struct);
            return ref;
        };
        HasProps.prototype.finalize = function () {
            var e_12, _a;
            var _this = this;
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    var value = prop.get_value(); // XXX: T -> any under instanceof
                    if (value != null) {
                        var transform = value.transform, expr = value.expr;
                        if (transform != null)
                            this.connect(transform.change, function () { return _this.transformchange.emit(); });
                        if (expr != null)
                            this.connect(expr.change, function () { return _this.exprchange.emit(); });
                    }
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
            this.initialize();
        };
        HasProps.prototype.initialize = function () { };
        HasProps.prototype.connect_signals = function () { };
        HasProps.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        HasProps.prototype.destroy = function () {
            this.disconnect_signals();
            this.destroyed.emit();
        };
        // Create a new model with exact attribute values to this one, but new identity.
        HasProps.prototype.clone = function () {
            var cloner = new cloneable_1.Cloner();
            return cloner.clone(this);
        };
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        HasProps.prototype._setv = function (changes, options) {
            var e_13, _a, e_14, _b;
            // Extract attributes and options.
            var check_eq = options.check_eq;
            var changed = [];
            var changing = this._changing;
            this._changing = true;
            try {
                for (var changes_1 = tslib_1.__values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                    var _c = tslib_1.__read(changes_1_1.value, 2), prop = _c[0], value = _c[1];
                    if (check_eq === false || !eq_1.is_equal(prop.get_value(), value)) {
                        prop.set_value(value);
                        changed.push(prop);
                    }
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return))
                        _a.call(changes_1);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.length > 0)
                this._pending = true;
            try {
                for (var changed_1 = tslib_1.__values(changed), changed_1_1 = changed_1.next(); !changed_1_1.done; changed_1_1 = changed_1.next()) {
                    var prop = changed_1_1.value;
                    prop.change.emit();
                }
            }
            catch (e_14_1) {
                e_14 = { error: e_14_1 };
            }
            finally {
                try {
                    if (changed_1_1 && !changed_1_1.done && (_b = changed_1.return))
                        _b.call(changed_1);
                }
                finally {
                    if (e_14)
                        throw e_14.error;
                }
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        };
        HasProps.prototype.setv = function (changed_attrs, options) {
            var e_15, _a, e_16, _b, e_17, _c, e_18, _d;
            if (options === void 0) {
                options = {};
            }
            var changes = object_1.entries(changed_attrs);
            if (changes.length == 0)
                return;
            if (options.silent === true) {
                try {
                    for (var changes_2 = tslib_1.__values(changes), changes_2_1 = changes_2.next(); !changes_2_1.done; changes_2_1 = changes_2.next()) {
                        var _e = tslib_1.__read(changes_2_1.value, 2), attr = _e[0], value = _e[1];
                        this.properties[attr].set_value(value);
                    }
                }
                catch (e_15_1) {
                    e_15 = { error: e_15_1 };
                }
                finally {
                    try {
                        if (changes_2_1 && !changes_2_1.done && (_a = changes_2.return))
                            _a.call(changes_2);
                    }
                    finally {
                        if (e_15)
                            throw e_15.error;
                    }
                }
                return;
            }
            var changed = new Map();
            var previous = new Map();
            try {
                for (var changes_3 = tslib_1.__values(changes), changes_3_1 = changes_3.next(); !changes_3_1.done; changes_3_1 = changes_3.next()) {
                    var _f = tslib_1.__read(changes_3_1.value, 2), attr = _f[0], value = _f[1];
                    var prop = this.properties[attr];
                    changed.set(prop, value);
                    previous.set(prop, prop.get_value());
                }
            }
            catch (e_16_1) {
                e_16 = { error: e_16_1 };
            }
            finally {
                try {
                    if (changes_3_1 && !changes_3_1.done && (_b = changes_3.return))
                        _b.call(changes_3);
                }
                finally {
                    if (e_16)
                        throw e_16.error;
                }
            }
            this._setv(changed, options);
            var document = this.document;
            if (document != null) {
                var changed_3 = [];
                try {
                    for (var previous_1 = tslib_1.__values(previous), previous_1_1 = previous_1.next(); !previous_1_1.done; previous_1_1 = previous_1.next()) {
                        var _g = tslib_1.__read(previous_1_1.value, 2), prop = _g[0], value = _g[1];
                        changed_3.push([prop, value, prop.get_value()]);
                    }
                }
                catch (e_17_1) {
                    e_17 = { error: e_17_1 };
                }
                finally {
                    try {
                        if (previous_1_1 && !previous_1_1.done && (_c = previous_1.return))
                            _c.call(previous_1);
                    }
                    finally {
                        if (e_17)
                            throw e_17.error;
                    }
                }
                try {
                    for (var changed_2 = tslib_1.__values(changed_3), changed_2_1 = changed_2.next(); !changed_2_1.done; changed_2_1 = changed_2.next()) {
                        var _h = tslib_1.__read(changed_2_1.value, 3), old_value = _h[1], new_value = _h[2];
                        if (this._needs_invalidate(old_value, new_value)) {
                            document._invalidate_all_models();
                            break;
                        }
                    }
                }
                catch (e_18_1) {
                    e_18 = { error: e_18_1 };
                }
                finally {
                    try {
                        if (changed_2_1 && !changed_2_1.done && (_d = changed_2.return))
                            _d.call(changed_2);
                    }
                    finally {
                        if (e_18)
                            throw e_18.error;
                    }
                }
                this._push_changes(changed_3, options);
            }
        };
        /** @deprecated */
        HasProps.prototype.getv = function (name) {
            return this.property(name).get_value();
        };
        HasProps.prototype.ref = function () {
            return { id: this.id };
        };
        HasProps.prototype.struct = function () {
            var struct = {
                type: this.type,
                id: this.id,
                attributes: {},
            };
            if (this._subtype != null) {
                struct.subtype = this._subtype;
            }
            return struct;
        };
        // we only keep the subtype so we match Python;
        // only Python cares about this
        HasProps.prototype.set_subtype = function (subtype) {
            this._subtype = subtype;
        };
        HasProps.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(object_1.values(this.properties))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        HasProps.prototype.syncable_properties = function () {
            var _a, _b, prop, e_19_1;
            var e_19, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 5, 6, 7]);
                        _a = tslib_1.__values(this), _b = _a.next();
                        _d.label = 1;
                    case 1:
                        if (!!_b.done)
                            return [3 /*break*/, 4];
                        prop = _b.value;
                        if (!prop.syncable)
                            return [3 /*break*/, 3];
                        return [4 /*yield*/, prop];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 4: return [3 /*break*/, 7];
                    case 5:
                        e_19_1 = _d.sent();
                        e_19 = { error: e_19_1 };
                        return [3 /*break*/, 7];
                    case 6:
                        try {
                            if (_b && !_b.done && (_c = _a.return))
                                _c.call(_a);
                        }
                        finally {
                            if (e_19)
                                throw e_19.error;
                        }
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/];
                }
            });
        };
        /** @deprecated */
        HasProps.prototype.serializable_attributes = function () {
            var e_20, _a;
            var attrs = {};
            try {
                for (var _b = tslib_1.__values(this.syncable_properties()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    attrs[prop.attr] = prop.get_value();
                }
            }
            catch (e_20_1) {
                e_20 = { error: e_20_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_20)
                        throw e_20.error;
                }
            }
            return attrs;
        };
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        HasProps._json_record_references = function (doc, v, refs, options) {
            var e_21, _a, e_22, _b;
            var recursive = options.recursive;
            if (refs_1.is_ref(v)) {
                var model = doc.get_model_by_id(v.id);
                if (model != null && !refs.has(model)) {
                    HasProps._value_record_references(model, refs, { recursive: recursive });
                }
            }
            else if (types_1.isArray(v)) {
                try {
                    for (var v_1 = tslib_1.__values(v), v_1_1 = v_1.next(); !v_1_1.done; v_1_1 = v_1.next()) {
                        var elem = v_1_1.value;
                        HasProps._json_record_references(doc, elem, refs, { recursive: recursive });
                    }
                }
                catch (e_21_1) {
                    e_21 = { error: e_21_1 };
                }
                finally {
                    try {
                        if (v_1_1 && !v_1_1.done && (_a = v_1.return))
                            _a.call(v_1);
                    }
                    finally {
                        if (e_21)
                            throw e_21.error;
                    }
                }
            }
            else if (types_1.isPlainObject(v)) {
                try {
                    for (var _c = tslib_1.__values(object_1.values(v)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var elem = _d.value;
                        HasProps._json_record_references(doc, elem, refs, { recursive: recursive });
                    }
                }
                catch (e_22_1) {
                    e_22 = { error: e_22_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return))
                            _b.call(_c);
                    }
                    finally {
                        if (e_22)
                            throw e_22.error;
                    }
                }
            }
        };
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        HasProps._value_record_references = function (v, refs, options) {
            var e_23, _a, e_24, _b, e_25, _c;
            var recursive = options.recursive;
            if (v instanceof HasProps) {
                if (!refs.has(v)) {
                    refs.add(v);
                    if (recursive) {
                        try {
                            for (var _d = tslib_1.__values(v.syncable_properties()), _e = _d.next(); !_e.done; _e = _d.next()) {
                                var prop = _e.value;
                                var value = prop.get_value();
                                HasProps._value_record_references(value, refs, { recursive: recursive });
                            }
                        }
                        catch (e_23_1) {
                            e_23 = { error: e_23_1 };
                        }
                        finally {
                            try {
                                if (_e && !_e.done && (_a = _d.return))
                                    _a.call(_d);
                            }
                            finally {
                                if (e_23)
                                    throw e_23.error;
                            }
                        }
                    }
                }
            }
            else if (types_1.isArray(v)) {
                try {
                    for (var v_2 = tslib_1.__values(v), v_2_1 = v_2.next(); !v_2_1.done; v_2_1 = v_2.next()) {
                        var elem = v_2_1.value;
                        HasProps._value_record_references(elem, refs, { recursive: recursive });
                    }
                }
                catch (e_24_1) {
                    e_24 = { error: e_24_1 };
                }
                finally {
                    try {
                        if (v_2_1 && !v_2_1.done && (_b = v_2.return))
                            _b.call(v_2);
                    }
                    finally {
                        if (e_24)
                            throw e_24.error;
                    }
                }
            }
            else if (types_1.isPlainObject(v)) {
                try {
                    for (var _f = tslib_1.__values(object_1.values(v)), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var elem = _g.value;
                        HasProps._value_record_references(elem, refs, { recursive: recursive });
                    }
                }
                catch (e_25_1) {
                    e_25 = { error: e_25_1 };
                }
                finally {
                    try {
                        if (_g && !_g.done && (_c = _f.return))
                            _c.call(_f);
                    }
                    finally {
                        if (e_25)
                            throw e_25.error;
                    }
                }
            }
        };
        HasProps.prototype.references = function () {
            var refs = new Set();
            HasProps._value_record_references(this, refs, { recursive: true });
            return refs;
        };
        HasProps.prototype._doc_attached = function () { };
        HasProps.prototype._doc_detached = function () { };
        HasProps.prototype.attach_document = function (doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error("models must be owned by only a single document");
            this.document = doc;
            this._doc_attached();
        };
        HasProps.prototype.detach_document = function () {
            // This should only be called by the Document implementation to unset the document field
            this._doc_detached();
            this.document = null;
        };
        HasProps.prototype._needs_invalidate = function (old_value, new_value) {
            var e_26, _a, e_27, _b;
            var new_refs = new Set();
            HasProps._value_record_references(new_value, new_refs, { recursive: false });
            var old_refs = new Set();
            HasProps._value_record_references(old_value, old_refs, { recursive: false });
            try {
                for (var new_refs_1 = tslib_1.__values(new_refs), new_refs_1_1 = new_refs_1.next(); !new_refs_1_1.done; new_refs_1_1 = new_refs_1.next()) {
                    var new_id = new_refs_1_1.value;
                    if (!old_refs.has(new_id))
                        return true;
                }
            }
            catch (e_26_1) {
                e_26 = { error: e_26_1 };
            }
            finally {
                try {
                    if (new_refs_1_1 && !new_refs_1_1.done && (_a = new_refs_1.return))
                        _a.call(new_refs_1);
                }
                finally {
                    if (e_26)
                        throw e_26.error;
                }
            }
            try {
                for (var old_refs_1 = tslib_1.__values(old_refs), old_refs_1_1 = old_refs_1.next(); !old_refs_1_1.done; old_refs_1_1 = old_refs_1.next()) {
                    var old_id = old_refs_1_1.value;
                    if (!new_refs.has(old_id))
                        return true;
                }
            }
            catch (e_27_1) {
                e_27 = { error: e_27_1 };
            }
            finally {
                try {
                    if (old_refs_1_1 && !old_refs_1_1.done && (_b = old_refs_1.return))
                        _b.call(old_refs_1);
                }
                finally {
                    if (e_27)
                        throw e_27.error;
                }
            }
            return false;
        };
        HasProps.prototype._push_changes = function (changes, options) {
            var e_28, _a, _b;
            if (options === void 0) {
                options = {};
            }
            if (!this.is_syncable)
                return;
            var document = this.document;
            if (document == null)
                return;
            var setter_id = options.setter_id;
            var events = [];
            try {
                for (var changes_4 = tslib_1.__values(changes), changes_4_1 = changes_4.next(); !changes_4_1.done; changes_4_1 = changes_4.next()) {
                    var _c = tslib_1.__read(changes_4_1.value, 3), prop = _c[0], old_value = _c[1], new_value = _c[2];
                    if (prop.syncable)
                        events.push(new events_1.ModelChangedEvent(document, this, prop.attr, old_value, new_value, setter_id));
                }
            }
            catch (e_28_1) {
                e_28 = { error: e_28_1 };
            }
            finally {
                try {
                    if (changes_4_1 && !changes_4_1.done && (_a = changes_4.return))
                        _a.call(changes_4);
                }
                finally {
                    if (e_28)
                        throw e_28.error;
                }
            }
            if (events.length != 0) {
                var event = void 0;
                if (events.length == 1)
                    _b = tslib_1.__read(events, 1), event = _b[0];
                else
                    event = new events_1.DocumentEventBatch(document, events, setter_id);
                document._trigger_on_change(event);
            }
        };
        HasProps.prototype.on_change = function (properties, fn) {
            var e_29, _a;
            try {
                for (var _b = tslib_1.__values(types_1.isArray(properties) ? properties : [properties]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var property = _c.value;
                    this.connect(property.change, fn);
                }
            }
            catch (e_29_1) {
                e_29 = { error: e_29_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_29)
                        throw e_29.error;
                }
            }
        };
        return HasProps;
    }(signaling_1.Signalable()));
    exports.HasProps = HasProps;
    HasProps.init_HasProps();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    var defer_1 = require(131) /* ./util/defer */;
    var array_1 = require(124) /* ./util/array */;
    var Signal = /** @class */ (function () {
        function Signal(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        Signal.prototype.connect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            var receivers = receiversForSender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            var receiver = context !== null && context !== void 0 ? context : slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            var senders = sendersForReceiver.get(receiver);
            var connection = { signal: this, slot: slot, context: context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        };
        Signal.prototype.disconnect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            var receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            var connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            var receiver = context !== null && context !== void 0 ? context : slot;
            var senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        };
        Signal.prototype.emit = function (args) {
            var e_1, _a;
            var _b;
            var receivers = (_b = receiversForSender.get(this.sender)) !== null && _b !== void 0 ? _b : [];
            try {
                for (var receivers_1 = tslib_1.__values(receivers), receivers_1_1 = receivers_1.next(); !receivers_1_1.done; receivers_1_1 = receivers_1.next()) {
                    var _c = receivers_1_1.value, signal = _c.signal, slot = _c.slot, context = _c.context;
                    if (signal === this) {
                        slot.call(context, args, this.sender);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (receivers_1_1 && !receivers_1_1.done && (_a = receivers_1.return))
                        _a.call(receivers_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return Signal;
    }());
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    var Signal0 = /** @class */ (function (_super) {
        tslib_1.__extends(Signal0, _super);
        function Signal0() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Signal0.prototype.emit = function () {
            _super.prototype.emit.call(this, undefined);
        };
        return Signal0;
    }(Signal));
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            var e_2, _a;
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            try {
                for (var senders_1 = tslib_1.__values(senders), senders_1_1 = senders_1.next(); !senders_1_1.done; senders_1_1 = senders_1.next()) {
                    var connection = senders_1_1.value;
                    if (connection.signal == null)
                        return;
                    if (connection.signal.sender === sender)
                        connection.signal = null;
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (senders_1_1 && !senders_1_1.done && (_a = senders_1.return))
                        _a.call(senders_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            var e_3, _a;
            var _b;
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            try {
                for (var receivers_2 = tslib_1.__values(receivers), receivers_2_1 = receivers_2.next(); !receivers_2_1.done; receivers_2_1 = receivers_2.next()) {
                    var connection = receivers_2_1.value;
                    if (connection.signal == null)
                        return;
                    var receiver = (_b = connection.context) !== null && _b !== void 0 ? _b : connection.slot;
                    connection.signal = null;
                    schedule_cleanup(sendersForReceiver.get(receiver));
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (receivers_2_1 && !receivers_2_1.done && (_a = receivers_2.return))
                        _a.call(receivers_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            var e_4, _a;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            try {
                for (var senders_2 = tslib_1.__values(senders), senders_2_1 = senders_2.next(); !senders_2_1.done; senders_2_1 = senders_2.next()) {
                    var connection = senders_2_1.value;
                    if (connection.signal == null)
                        return;
                    if (slot != null && connection.slot != slot)
                        continue;
                    var sender = connection.signal.sender;
                    if (except_senders != null && except_senders.has(sender))
                        continue;
                    connection.signal = null;
                    schedule_cleanup(receiversForSender.get(sender));
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (senders_2_1 && !senders_2_1.done && (_a = senders_2.return))
                        _a.call(senders_2);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            var e_5, _a, e_6, _b;
            var receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                try {
                    for (var receivers_3 = tslib_1.__values(receivers), receivers_3_1 = receivers_3.next(); !receivers_3_1.done; receivers_3_1 = receivers_3.next()) {
                        var connection = receivers_3_1.value;
                        connection.signal = null;
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (receivers_3_1 && !receivers_3_1.done && (_a = receivers_3.return))
                            _a.call(receivers_3);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                schedule_cleanup(receivers);
            }
            var senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                try {
                    for (var senders_3 = tslib_1.__values(senders), senders_3_1 = senders_3.next(); !senders_3_1.done; senders_3_1 = senders_3.next()) {
                        var connection = senders_3_1.value;
                        connection.signal = null;
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (senders_3_1 && !senders_3_1.done && (_b = senders_3.return))
                            _b.call(senders_3);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
        /** @deprecated */
        Signal.disconnectBetween = disconnect_between;
        /** @deprecated */
        Signal.disconnectSender = disconnect_sender;
        /** @deprecated */
        Signal.disconnectReceiver = disconnect_receiver;
        /** @deprecated */
        Signal.disconnectAll = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return /** @class */ (function () {
            function class_1() {
            }
            class_1.prototype.connect = function (signal, slot) {
                return signal.connect(slot, this);
            };
            class_1.prototype.disconnect = function (signal, slot) {
                return signal.disconnect(slot, this);
            };
            return class_1;
        }());
    }
    exports.Signalable = Signalable;
    var receiversForSender = new WeakMap();
    var sendersForReceiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return array_1.find(conns, function (conn) { return conn.signal === signal && conn.slot === slot && conn.context === context; });
    }
    var dirty_set = new Set();
    function schedule_cleanup(connections) {
        var _this = this;
        if (dirty_set.size === 0) {
            (function () {
                return tslib_1.__awaiter(_this, void 0, void 0, function () {
                    return tslib_1.__generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, defer_1.defer()];
                            case 1:
                                _a.sent();
                                cleanup_dirty_set();
                                return [2 /*return*/];
                        }
                    });
                });
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        var e_7, _a;
        try {
            for (var dirty_set_1 = tslib_1.__values(dirty_set), dirty_set_1_1 = dirty_set_1.next(); !dirty_set_1_1.done; dirty_set_1_1 = dirty_set_1.next()) {
                var connections = dirty_set_1_1.value;
                array_1.remove_by(connections, function (connection) { return connection.signal == null; });
            }
        }
        catch (e_7_1) {
            e_7 = { error: e_7_1 };
        }
        finally {
            try {
                if (dirty_set_1_1 && !dirty_set_1_1.done && (_a = dirty_set_1.return))
                    _a.call(dirty_set_1);
            }
            finally {
                if (e_7)
                    throw e_7.error;
            }
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var channel = new MessageChannel();
    var tasks = new Map();
    channel.port1.onmessage = function (event) {
        var handle = event.data;
        var fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    var counter = 1;
    function defer() {
        return new Promise(function (resolve) {
            var handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    exports.defer = defer;
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(123) /* ./types */;
    var object_1 = require(128) /* ./object */;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a reference
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isPlainObject(arg)) {
            var attrs = object_1.keys(arg);
            return attrs.length == 1 && attrs[0] == "id";
        }
        return false;
    }
    exports.is_ref = is_ref;
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.YCoordinateSeqSeqSeqSpec = exports.XCoordinateSeqSeqSeqSpec = exports.YCoordinateSeqSpec = exports.XCoordinateSeqSpec = exports.YCoordinateSpec = exports.XCoordinateSpec = exports.CoordinateSeqSeqSeqSpec = exports.CoordinateSeqSpec = exports.CoordinateSpec = exports.BaseCoordinateSpec = exports.NumberUnitsSpec = exports.UnitsSpec = exports.DataSpec = exports.VectorSpec = exports.TextBaselineScalar = exports.TextAlignScalar = exports.FontStyleScalar = exports.FontSizeScalar = exports.FontScalar = exports.LineDashScalar = exports.LineCapScalar = exports.LineJoinScalar = exports.ArrayScalar = exports.NullStringScalar = exports.StringScalar = exports.NumberScalar = exports.ColorScalar = exports.AnyScalar = exports.ScalarSpec = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.TickLabelOrientation = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapBehavior = exports.StepMode = exports.StartEnd = exports.SpatialUnits = exports.Sort = exports.SizingMode = exports.Side = exports.RoundingFunction = exports.ResetPolicy = exports.RenderMode = exports.RenderLevel = exports.RadiusDimension = exports.PointPolicy = exports.Place = void 0;
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ArraySpec = exports.NullStringSpec = exports.StringSpec = exports.AnySpec = exports.NDArraySpec = exports.ColorSpec = exports.ScreenSizeSpec = exports.NumberSpec = exports.IntSpec = exports.BooleanSpec = exports.NullDistanceSpec = exports.DistanceSpec = exports.AngleSpec = void 0;
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var logging_1 = require(134) /* ./logging */;
    var enums = tslib_1.__importStar(require(135) /* ./enums */);
    var types_1 = require(139) /* ./types */;
    var array_1 = require(124) /* ./util/array */;
    var arrayable_1 = require(127) /* ./util/arrayable */;
    var math_1 = require(125) /* ./util/math */;
    var color_1 = require(137) /* ./util/color */;
    var platform_1 = require(142) /* ./util/platform */;
    var types_2 = require(123) /* ./util/types */;
    var settings_1 = require(143) /* ./settings */;
    var ndarray_1 = require(144) /* ./util/ndarray */;
    var uniforms_1 = require(148) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return types_2.isPlainObject(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    var Property = /** @class */ (function () {
        function Property(obj, attr, kind, default_value, initial_value, options) {
            if (options === void 0) {
                options = {};
            }
            var _a;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this._dirty = false;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = (_a = options.internal) !== null && _a !== void 0 ? _a : false;
            this.convert = options.convert;
            this.on_update = options.on_update;
            var attr_value;
            if (initial_value !== undefined) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                var value = this._default_override();
                if (value !== undefined)
                    attr_value = value;
                else if (default_value !== undefined)
                    attr_value = default_value(obj);
                else {
                    // XXX: temporary and super sketchy, but affects only "readonly" and a few internal properties
                    // console.warn(`${this.obj}.${this.attr} has no value nor default`)
                    this.spec = { value: null };
                    return;
                }
            }
            this._update(attr_value);
        }
        Object.defineProperty(Property.prototype, "is_value", {
            get: function () {
                return this.spec.value !== undefined;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Property.prototype, "syncable", {
            get: function () {
                return !this.internal;
            },
            enumerable: false,
            configurable: true
        });
        Property.prototype.get_value = function () {
            return this.spec.value;
        };
        Property.prototype.set_value = function (val) {
            this._update(val);
            this._dirty = true;
        };
        // abstract _intrinsic_default(): T
        Property.prototype._default_override = function () {
            return undefined;
        };
        Object.defineProperty(Property.prototype, "dirty", {
            get: function () {
                return this._dirty;
            },
            enumerable: false,
            configurable: true
        });
        //protected abstract _update(attr_value: T): void
        Property.prototype._update = function (attr_value) {
            var _a;
            this.validate(attr_value);
            if (this.convert != null) {
                var converted = this.convert(attr_value);
                if (converted !== undefined)
                    attr_value = converted;
            }
            this.spec = { value: attr_value };
            (_a = this.on_update) === null || _a === void 0 ? void 0 : _a.call(this, attr_value, this.obj);
        };
        Property.prototype.toString = function () {
            /*${this.name}*/
            return "Prop(" + this.obj + "." + this.attr + ", spec: " + valueToString(this.spec) + ")";
        };
        // ----- customizable policies
        Property.prototype.normalize = function (values) {
            return values;
        };
        Property.prototype.validate = function (value) {
            if (!this.valid(value))
                throw new Error(this.obj + "." + this.attr + " given invalid value: " + valueToString(value));
        };
        Property.prototype.valid = function (value) {
            return this.kind.valid(value);
        };
        // ----- property accessors
        Property.prototype._value = function (do_spec_transform) {
            if (do_spec_transform === void 0) {
                do_spec_transform = true;
            }
            if (!this.is_value)
                throw new Error("attempted to retrieve property value for property without value specification");
            var ret = this.normalize([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        };
        return Property;
    }());
    exports.Property = Property;
    Property.__name__ = "Property";
    var PropertyAlias = /** @class */ (function () {
        function PropertyAlias(attr) {
            this.attr = attr;
        }
        return PropertyAlias;
    }());
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    exports.Alias = Alias;
    //
    // Primitive Properties
    //
    var PrimitiveProperty = /** @class */ (function (_super) {
        tslib_1.__extends(PrimitiveProperty, _super);
        function PrimitiveProperty() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return PrimitiveProperty;
    }(Property));
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    /** @deprecated */
    var Any = /** @class */ (function (_super) {
        tslib_1.__extends(Any, _super);
        function Any() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Any;
    }(Property));
    exports.Any = Any;
    Any.__name__ = "Any";
    /** @deprecated */
    var Array = /** @class */ (function (_super) {
        tslib_1.__extends(Array, _super);
        function Array() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Array.prototype.valid = function (value) {
            return types_2.isArray(value) || types_2.isTypedArray(value);
        };
        return Array;
    }(Property));
    exports.Array = Array;
    Array.__name__ = "Array";
    /** @deprecated */
    var Boolean = /** @class */ (function (_super) {
        tslib_1.__extends(Boolean, _super);
        function Boolean() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Boolean.prototype.valid = function (value) {
            return types_2.isBoolean(value);
        };
        return Boolean;
    }(Property));
    exports.Boolean = Boolean;
    Boolean.__name__ = "Boolean";
    /** @deprecated */
    var Color = /** @class */ (function (_super) {
        tslib_1.__extends(Color, _super);
        function Color() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Color.prototype.valid = function (value) {
            return color_1.is_Color(value);
        };
        return Color;
    }(Property));
    exports.Color = Color;
    Color.__name__ = "Color";
    /** @deprecated */
    var Instance = /** @class */ (function (_super) {
        tslib_1.__extends(Instance, _super);
        function Instance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Instance;
    }(Property));
    exports.Instance = Instance;
    Instance.__name__ = "Instance";
    /** @deprecated */
    var Number = /** @class */ (function (_super) {
        tslib_1.__extends(Number, _super);
        function Number() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Number.prototype.valid = function (value) {
            return types_2.isNumber(value);
        };
        return Number;
    }(Property));
    exports.Number = Number;
    Number.__name__ = "Number";
    /** @deprecated */
    var Int = /** @class */ (function (_super) {
        tslib_1.__extends(Int, _super);
        function Int() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Int.prototype.valid = function (value) {
            return types_2.isNumber(value) && (value | 0) == value;
        };
        return Int;
    }(Number));
    exports.Int = Int;
    Int.__name__ = "Int";
    /** @deprecated */
    var Angle = /** @class */ (function (_super) {
        tslib_1.__extends(Angle, _super);
        function Angle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Angle;
    }(Number));
    exports.Angle = Angle;
    Angle.__name__ = "Angle";
    /** @deprecated */
    var Percent = /** @class */ (function (_super) {
        tslib_1.__extends(Percent, _super);
        function Percent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Percent.prototype.valid = function (value) {
            return types_2.isNumber(value) && 0 <= value && value <= 1.0;
        };
        return Percent;
    }(Number));
    exports.Percent = Percent;
    Percent.__name__ = "Percent";
    /** @deprecated */
    var String = /** @class */ (function (_super) {
        tslib_1.__extends(String, _super);
        function String() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        String.prototype.valid = function (value) {
            return types_2.isString(value);
        };
        return String;
    }(Property));
    exports.String = String;
    String.__name__ = "String";
    /** @deprecated */
    var NullString = /** @class */ (function (_super) {
        tslib_1.__extends(NullString, _super);
        function NullString() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullString.prototype.valid = function (value) {
            return value === null || types_2.isString(value);
        };
        return NullString;
    }(Property));
    exports.NullString = NullString;
    NullString.__name__ = "NullString";
    /** @deprecated */
    var FontSize = /** @class */ (function (_super) {
        tslib_1.__extends(FontSize, _super);
        function FontSize() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSize;
    }(String));
    exports.FontSize = FontSize;
    FontSize.__name__ = "FontSize";
    /** @deprecated */
    var Font = /** @class */ (function (_super) {
        tslib_1.__extends(Font, _super);
        function Font() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Font.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return Font;
    }(String));
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // Enum properties
    //
    /** @deprecated */
    var EnumProperty = /** @class */ (function (_super) {
        tslib_1.__extends(EnumProperty, _super);
        function EnumProperty() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EnumProperty.prototype.valid = function (value) {
            return types_2.isString(value) && array_1.includes(this.enum_values, value);
        };
        return EnumProperty;
    }(Property));
    exports.EnumProperty = EnumProperty;
    EnumProperty.__name__ = "EnumProperty";
    /** @deprecated */
    function Enum(values) {
        return /** @class */ (function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "enum_values", {
                get: function () {
                    return tslib_1.__spreadArray([], tslib_1.__read(values));
                },
                enumerable: false,
                configurable: true
            });
            return class_1;
        }(EnumProperty));
    }
    exports.Enum = Enum;
    var Direction = /** @class */ (function (_super) {
        tslib_1.__extends(Direction, _super);
        function Direction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Direction.prototype, "enum_values", {
            get: function () {
                return tslib_1.__spreadArray([], tslib_1.__read(enums.Direction));
            },
            enumerable: false,
            configurable: true
        });
        Direction.prototype.normalize = function (values) {
            var result = new Uint8Array(values.length);
            for (var i = 0; i < values.length; i++) {
                switch (values[i]) {
                    case "clock":
                        result[i] = 0;
                        break;
                    case "anticlock":
                        result[i] = 1;
                        break;
                }
            }
            return result;
        };
        return Direction;
    }(EnumProperty));
    exports.Direction = Direction;
    Direction.__name__ = "Direction";
    /** @deprecated */ exports.Anchor = Enum(enums.Anchor);
    /** @deprecated */ exports.AngleUnits = Enum(enums.AngleUnits);
    /** @deprecated */ exports.BoxOrigin = Enum(enums.BoxOrigin);
    /** @deprecated */ exports.ButtonType = Enum(enums.ButtonType);
    /** @deprecated */ exports.CalendarPosition = Enum(enums.CalendarPosition);
    /** @deprecated */ exports.Dimension = Enum(enums.Dimension);
    /** @deprecated */ exports.Dimensions = Enum(enums.Dimensions);
    /** @deprecated */ exports.Distribution = Enum(enums.Distribution);
    /** @deprecated */ exports.FontStyle = Enum(enums.FontStyle);
    /** @deprecated */ exports.HatchPatternType = Enum(enums.HatchPatternType);
    /** @deprecated */ exports.HTTPMethod = Enum(enums.HTTPMethod);
    /** @deprecated */ exports.HexTileOrientation = Enum(enums.HexTileOrientation);
    /** @deprecated */ exports.HoverMode = Enum(enums.HoverMode);
    /** @deprecated */ exports.LatLon = Enum(enums.LatLon);
    /** @deprecated */ exports.LegendClickPolicy = Enum(enums.LegendClickPolicy);
    /** @deprecated */ exports.LegendLocation = Enum(enums.LegendLocation);
    /** @deprecated */ exports.LineCap = Enum(enums.LineCap);
    /** @deprecated */ exports.LineJoin = Enum(enums.LineJoin);
    /** @deprecated */ exports.LinePolicy = Enum(enums.LinePolicy);
    /** @deprecated */ exports.Location = Enum(enums.Location);
    /** @deprecated */ exports.Logo = Enum(enums.Logo);
    /** @deprecated */ exports.MarkerType = Enum(enums.MarkerType);
    /** @deprecated */ exports.MutedPolicy = Enum(enums.MutedPolicy);
    /** @deprecated */ exports.Orientation = Enum(enums.Orientation);
    /** @deprecated */ exports.OutputBackend = Enum(enums.OutputBackend);
    /** @deprecated */ exports.PaddingUnits = Enum(enums.PaddingUnits);
    /** @deprecated */ exports.Place = Enum(enums.Place);
    /** @deprecated */ exports.PointPolicy = Enum(enums.PointPolicy);
    /** @deprecated */ exports.RadiusDimension = Enum(enums.RadiusDimension);
    /** @deprecated */ exports.RenderLevel = Enum(enums.RenderLevel);
    /** @deprecated */ exports.RenderMode = Enum(enums.RenderMode);
    /** @deprecated */ exports.ResetPolicy = Enum(enums.ResetPolicy);
    /** @deprecated */ exports.RoundingFunction = Enum(enums.RoundingFunction);
    /** @deprecated */ exports.Side = Enum(enums.Side);
    /** @deprecated */ exports.SizingMode = Enum(enums.SizingMode);
    /** @deprecated */ exports.Sort = Enum(enums.Sort);
    /** @deprecated */ exports.SpatialUnits = Enum(enums.SpatialUnits);
    /** @deprecated */ exports.StartEnd = Enum(enums.StartEnd);
    /** @deprecated */ exports.StepMode = Enum(enums.StepMode);
    /** @deprecated */ exports.TapBehavior = Enum(enums.TapBehavior);
    /** @deprecated */ exports.TextAlign = Enum(enums.TextAlign);
    /** @deprecated */ exports.TextBaseline = Enum(enums.TextBaseline);
    /** @deprecated */ exports.TextureRepetition = Enum(enums.TextureRepetition);
    /** @deprecated */ exports.TickLabelOrientation = Enum(enums.TickLabelOrientation);
    /** @deprecated */ exports.TooltipAttachment = Enum(enums.TooltipAttachment);
    /** @deprecated */ exports.UpdateMode = Enum(enums.UpdateMode);
    /** @deprecated */ exports.VerticalAlign = Enum(enums.VerticalAlign);
    //
    // DataSpec properties
    //
    var ScalarSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ScalarSpec, _super);
        function ScalarSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ScalarSpec.prototype.get_value = function () {
            // XXX: denormalize value for serialization, because bokeh doens't support scalar properties
            var _a = this.spec, value = _a.value, expr = _a.expr, transform = _a.transform;
            return (expr != null || transform != null ? this.spec : value);
            // XXX: allow obj.x = null; obj.x == null
            // return this.spec.value === null ? null : this.spec as any
        };
        ScalarSpec.prototype._update = function (attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        };
        ScalarSpec.prototype.materialize = function (value) {
            return value;
        };
        ScalarSpec.prototype.scalar = function (value, n) {
            return new uniforms_1.UniformScalar(value, n);
        };
        ScalarSpec.prototype.uniform = function (source) {
            var _a;
            var _b = this.spec, expr = _b.expr, value = _b.value, transform = _b.transform;
            var n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (expr != null) {
                var result = expr.compute(source);
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                var result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        };
        return ScalarSpec;
    }(Property));
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    var AnyScalar = /** @class */ (function (_super) {
        tslib_1.__extends(AnyScalar, _super);
        function AnyScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AnyScalar;
    }(ScalarSpec));
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    var ColorScalar = /** @class */ (function (_super) {
        tslib_1.__extends(ColorScalar, _super);
        function ColorScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ColorScalar;
    }(ScalarSpec));
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    var NumberScalar = /** @class */ (function (_super) {
        tslib_1.__extends(NumberScalar, _super);
        function NumberScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberScalar;
    }(ScalarSpec));
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    var StringScalar = /** @class */ (function (_super) {
        tslib_1.__extends(StringScalar, _super);
        function StringScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringScalar;
    }(ScalarSpec));
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    var NullStringScalar = /** @class */ (function (_super) {
        tslib_1.__extends(NullStringScalar, _super);
        function NullStringScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NullStringScalar;
    }(ScalarSpec));
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    var ArrayScalar = /** @class */ (function (_super) {
        tslib_1.__extends(ArrayScalar, _super);
        function ArrayScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ArrayScalar;
    }(ScalarSpec));
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    var LineJoinScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineJoinScalar, _super);
        function LineJoinScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoinScalar;
    }(ScalarSpec));
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    var LineCapScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineCapScalar, _super);
        function LineCapScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCapScalar;
    }(ScalarSpec));
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    var LineDashScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineDashScalar, _super);
        function LineDashScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineDashScalar;
    }(ScalarSpec));
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    var FontScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontScalar, _super);
        function FontScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FontScalar.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return FontScalar;
    }(ScalarSpec));
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    var FontSizeScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontSizeScalar, _super);
        function FontSizeScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeScalar;
    }(ScalarSpec));
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    var FontStyleScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontStyleScalar, _super);
        function FontStyleScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyleScalar;
    }(ScalarSpec));
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    var TextAlignScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextAlignScalar, _super);
        function TextAlignScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlignScalar;
    }(ScalarSpec));
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    var TextBaselineScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextBaselineScalar, _super);
        function TextBaselineScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaselineScalar;
    }(ScalarSpec));
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    var VectorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(VectorSpec, _super);
        function VectorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VectorSpec.prototype.get_value = function () {
            // XXX: allow obj.x = null; obj.x == null
            return this.spec.value === null ? null : this.spec;
        };
        VectorSpec.prototype._update = function (attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        };
        VectorSpec.prototype.materialize = function (value) {
            return value;
        };
        VectorSpec.prototype.v_materialize = function (values) {
            return values;
        };
        VectorSpec.prototype.scalar = function (value, n) {
            return new uniforms_1.UniformScalar(value, n);
        };
        VectorSpec.prototype.vector = function (values) {
            return new uniforms_1.UniformVector(values);
        };
        VectorSpec.prototype.uniform = function (source) {
            var _a;
            var _b = this.spec, field = _b.field, expr = _b.expr, value = _b.value, transform = _b.transform;
            var n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (field != null) {
                var array = source.get_column(field);
                if (array != null) {
                    if (transform != null)
                        array = transform.v_compute(array);
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    logging_1.logger.warn("attempted to retrieve property array for nonexistent field '" + field + "'");
                    return this.scalar(null, n);
                }
            }
            else if (expr != null) {
                var array = expr.v_compute(source);
                if (transform != null)
                    array = transform.v_compute(array);
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else {
                var result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        };
        VectorSpec.prototype.array = function (source) {
            var _a;
            var array;
            var length = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (this.spec.field != null) {
                var column = source.get_column(this.spec.field);
                if (column != null)
                    array = this.normalize(column);
                else {
                    logging_1.logger.warn("attempted to retrieve property array for nonexistent field '" + this.spec.field + "'");
                    var missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if (this.spec.expr != null) {
                array = this.normalize(this.spec.expr.v_compute(source));
            }
            else {
                var value = this._value(false); // don't apply any spec transform
                if (types_2.isNumber(value)) {
                    var values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else
                    array = array_1.repeat(value, length);
            }
            if (this.spec.transform != null)
                array = this.spec.transform.v_compute(array);
            return array;
        };
        return VectorSpec;
    }(Property));
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    var DataSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DataSpec, _super);
        function DataSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DataSpec;
    }(VectorSpec));
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    var UnitsSpec = /** @class */ (function (_super) {
        tslib_1.__extends(UnitsSpec, _super);
        function UnitsSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnitsSpec.prototype._update = function (attr_value) {
            _super.prototype._update.call(this, attr_value);
            var units = this.spec.units;
            if (units != null && !array_1.includes(this.valid_units, units)) {
                throw new Error("units must be one of " + this.valid_units.join(", ") + "; got: " + units);
            }
        };
        Object.defineProperty(UnitsSpec.prototype, "units", {
            get: function () {
                var _a;
                return (_a = this.spec.units) !== null && _a !== void 0 ? _a : this.default_units;
            },
            set: function (units) {
                if (units != this.default_units)
                    this.spec.units = units;
                else
                    delete this.spec.units;
            },
            enumerable: false,
            configurable: true
        });
        return UnitsSpec;
    }(VectorSpec));
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    var NumberUnitsSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NumberUnitsSpec, _super);
        function NumberUnitsSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NumberUnitsSpec.prototype.array = function (source) {
            return new Float64Array(_super.prototype.array.call(this, source));
        };
        return NumberUnitsSpec;
    }(UnitsSpec));
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    var BaseCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(BaseCoordinateSpec, _super);
        function BaseCoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return BaseCoordinateSpec;
    }(DataSpec));
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    var CoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSpec, _super);
        function CoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    var CoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSeqSpec, _super);
        function CoordinateSeqSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSeqSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    var CoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSeqSeqSeqSpec, _super);
        function CoordinateSeqSeqSeqSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSeqSeqSeqSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    var XCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSpec, _super);
        function XCoordinateSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSpec;
    }(CoordinateSpec));
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    var YCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSpec, _super);
        function YCoordinateSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSpec;
    }(CoordinateSpec));
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    var XCoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSeqSpec, _super);
        function XCoordinateSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSeqSpec;
    }(CoordinateSeqSpec));
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    var YCoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSeqSpec, _super);
        function YCoordinateSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSeqSpec;
    }(CoordinateSeqSpec));
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    var XCoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSeqSeqSeqSpec, _super);
        function XCoordinateSeqSeqSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSeqSeqSeqSpec;
    }(CoordinateSeqSeqSeqSpec));
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    var YCoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSeqSeqSeqSpec, _super);
        function YCoordinateSeqSeqSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSeqSeqSeqSpec;
    }(CoordinateSeqSeqSeqSpec));
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    var AngleSpec = /** @class */ (function (_super) {
        tslib_1.__extends(AngleSpec, _super);
        function AngleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AngleSpec.prototype, "default_units", {
            get: function () { return "rad"; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AngleSpec.prototype, "valid_units", {
            get: function () { return tslib_1.__spreadArray([], tslib_1.__read(enums.AngleUnits)); },
            enumerable: false,
            configurable: true
        });
        AngleSpec.prototype.materialize = function (value) {
            var coeff = -math_1.to_radians_coeff(this.units);
            return value * coeff;
        };
        AngleSpec.prototype.v_materialize = function (values) {
            var coeff = -math_1.to_radians_coeff(this.units);
            var result = new Float32Array(values.length);
            arrayable_1.mul(values, coeff, result); // TODO: in-place?
            return result;
        };
        AngleSpec.prototype.array = function (_source) {
            throw new Error("not supported");
        };
        return AngleSpec;
    }(NumberUnitsSpec));
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    var DistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DistanceSpec, _super);
        function DistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DistanceSpec.prototype, "default_units", {
            get: function () { return "data"; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(DistanceSpec.prototype, "valid_units", {
            get: function () { return tslib_1.__spreadArray([], tslib_1.__read(enums.SpatialUnits)); },
            enumerable: false,
            configurable: true
        });
        return DistanceSpec;
    }(NumberUnitsSpec));
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    var NullDistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NullDistanceSpec, _super);
        function NullDistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullDistanceSpec.prototype.materialize = function (value) {
            return value !== null && value !== void 0 ? value : NaN;
        };
        return NullDistanceSpec;
    }(DistanceSpec));
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    var BooleanSpec = /** @class */ (function (_super) {
        tslib_1.__extends(BooleanSpec, _super);
        function BooleanSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BooleanSpec.prototype.v_materialize = function (values) {
            return new Uint8Array(values);
        };
        BooleanSpec.prototype.array = function (source) {
            return new Uint8Array(_super.prototype.array.call(this, source));
        };
        return BooleanSpec;
    }(DataSpec));
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    var IntSpec = /** @class */ (function (_super) {
        tslib_1.__extends(IntSpec, _super);
        function IntSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        IntSpec.prototype.v_materialize = function (values) {
            return types_2.isTypedArray(values) ? values : new Int32Array(values);
        };
        IntSpec.prototype.array = function (source) {
            return new Int32Array(_super.prototype.array.call(this, source));
        };
        return IntSpec;
    }(DataSpec));
    exports.IntSpec = IntSpec;
    IntSpec.__name__ = "IntSpec";
    var NumberSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NumberSpec, _super);
        function NumberSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NumberSpec.prototype.v_materialize = function (values) {
            return types_2.isTypedArray(values) ? values : new Float64Array(values);
        };
        NumberSpec.prototype.array = function (source) {
            return new Float64Array(_super.prototype.array.call(this, source));
        };
        return NumberSpec;
    }(DataSpec));
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    var ScreenSizeSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ScreenSizeSpec, _super);
        function ScreenSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ScreenSizeSpec.prototype.valid = function (value) {
            return types_2.isNumber(value) && value >= 0;
        };
        return ScreenSizeSpec;
    }(NumberSpec));
    exports.ScreenSizeSpec = ScreenSizeSpec;
    ScreenSizeSpec.__name__ = "ScreenSizeSpec";
    var ColorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ColorSpec, _super);
        function ColorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColorSpec.prototype.materialize = function (color) {
            return color_1.encode_rgba(color_1.color2rgba(color));
        };
        ColorSpec.prototype.v_materialize = function (colors) {
            var e_1, _a, e_2, _b;
            if (ndarray_1.is_NDArray(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return platform_1.to_big_endian(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    var _c = tslib_1.__read(colors.shape, 1), n = _c[0];
                    var array = new types_1.RGBAArray(4 * n);
                    var j = 0;
                    try {
                        for (var colors_1 = tslib_1.__values(colors), colors_1_1 = colors_1.next(); !colors_1_1.done; colors_1_1 = colors_1.next()) {
                            var gray = colors_1_1.value;
                            array[j++] = gray;
                            array[j++] = gray;
                            array[j++] = gray;
                            array[j++] = 255;
                        }
                    }
                    catch (e_1_1) {
                        e_1 = { error: e_1_1 };
                    }
                    finally {
                        try {
                            if (colors_1_1 && !colors_1_1.done && (_a = colors_1.return))
                                _a.call(colors_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    var _d = tslib_1.__read(colors.shape, 2), n = _d[0], d = _d[1];
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        var array = new types_1.RGBAArray(4 * n);
                        for (var i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    var _e = tslib_1.__read(colors.shape, 2), n = _e[0], d = _e[1];
                    if (d == 3 || d == 4) {
                        var array = new types_1.RGBAArray(4 * n);
                        for (var i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
            }
            else {
                var n = colors.length;
                var array = new types_1.RGBAArray(4 * n);
                var j = 0;
                try {
                    for (var colors_2 = tslib_1.__values(colors), colors_2_1 = colors_2.next(); !colors_2_1.done; colors_2_1 = colors_2.next()) {
                        var color = colors_2_1.value;
                        var _f = tslib_1.__read(color_1.color2rgba(color), 4), r = _f[0], g = _f[1], b = _f[2], a = _f[3];
                        array[j++] = r;
                        array[j++] = g;
                        array[j++] = b;
                        array[j++] = a;
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (colors_2_1 && !colors_2_1.done && (_b = colors_2.return))
                            _b.call(colors_2);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return new types_1.ColorArray(array.buffer);
            }
            throw new Error("invalid color array");
        };
        ColorSpec.prototype.vector = function (values) {
            return new uniforms_1.ColorUniformVector(values);
        };
        return ColorSpec;
    }(DataSpec));
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    var NDArraySpec = /** @class */ (function (_super) {
        tslib_1.__extends(NDArraySpec, _super);
        function NDArraySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NDArraySpec;
    }(DataSpec));
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    var AnySpec = /** @class */ (function (_super) {
        tslib_1.__extends(AnySpec, _super);
        function AnySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AnySpec;
    }(DataSpec));
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    var StringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(StringSpec, _super);
        function StringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringSpec;
    }(DataSpec));
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    var NullStringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NullStringSpec, _super);
        function NullStringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NullStringSpec;
    }(DataSpec));
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    var ArraySpec = /** @class */ (function (_super) {
        tslib_1.__extends(ArraySpec, _super);
        function ArraySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ArraySpec;
    }(DataSpec));
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    var MarkerSpec = /** @class */ (function (_super) {
        tslib_1.__extends(MarkerSpec, _super);
        function MarkerSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return MarkerSpec;
    }(DataSpec));
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    var LineJoinSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineJoinSpec, _super);
        function LineJoinSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoinSpec;
    }(DataSpec));
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    var LineCapSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineCapSpec, _super);
        function LineCapSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCapSpec;
    }(DataSpec));
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    var LineDashSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineDashSpec, _super);
        function LineDashSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineDashSpec;
    }(DataSpec));
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    var FontSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontSpec, _super);
        function FontSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FontSpec.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return FontSpec;
    }(DataSpec));
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    var FontSizeSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontSizeSpec, _super);
        function FontSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeSpec;
    }(DataSpec));
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    var FontStyleSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontStyleSpec, _super);
        function FontStyleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyleSpec;
    }(DataSpec));
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    var TextAlignSpec = /** @class */ (function (_super) {
        tslib_1.__extends(TextAlignSpec, _super);
        function TextAlignSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlignSpec;
    }(DataSpec));
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    var TextBaselineSpec = /** @class */ (function (_super) {
        tslib_1.__extends(TextBaselineSpec, _super);
        function TextBaselineSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaselineSpec;
    }(DataSpec));
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // This is based on https://github.com/pimterry/loglevel
    var types_1 = require(123) /* ./util/types */;
    var object_1 = require(128) /* ./util/object */;
    var _loggers = {};
    var LogLevel = /** @class */ (function () {
        function LogLevel(name, level) {
            this.name = name;
            this.level = level;
        }
        return LogLevel;
    }());
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    var Logger = /** @class */ (function () {
        function Logger(name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            this._name = name;
            this.set_level(level);
        }
        Object.defineProperty(Logger, "levels", {
            get: function () {
                return Object.keys(Logger.log_levels);
            },
            enumerable: false,
            configurable: true
        });
        Logger.get = function (name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            if (name.length > 0) {
                var logger_1 = _loggers[name];
                if (logger_1 == null)
                    _loggers[name] = logger_1 = new Logger(name, level);
                return logger_1;
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        };
        Object.defineProperty(Logger.prototype, "level", {
            get: function () {
                return this.get_level();
            },
            enumerable: false,
            configurable: true
        });
        Logger.prototype.get_level = function () {
            return this._log_level;
        };
        Logger.prototype.set_level = function (log_level) {
            var e_1, _a;
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            var logger_name = "[" + this._name + "]";
            try {
                for (var _b = tslib_1.__values(object_1.entries(Logger.log_levels)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], log_level_1 = _d[1];
                    if (log_level_1.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                        this[name] = function () { };
                    else
                        this[name] = _method_factory(name, logger_name);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        Logger.prototype.trace = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.debug = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.info = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.warn = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.error = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        return Logger;
    }());
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () { };
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        var previous_level = exports.logger.level;
        if (types_1.isString(level) && Logger.log_levels[level] == null) {
            console.log("[bokeh] unrecognized logging level '" + level + "' passed to Bokeh.set_log_level(), ignoring");
            console.log("[bokeh] valid log levels are: " + Logger.levels.join(", "));
        }
        else {
            console.log("[bokeh] setting log level to: '" + (types_1.isString(level) ? level : level.level) + "'");
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    exports.set_log_level = set_log_level;
    function with_log_level(level, fn) {
        var original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
    exports.with_log_level = with_log_level;
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.VerticalAlign = void 0;
    var kinds_1 = require(136) /* ./kinds */;
    exports.Align = kinds_1.Enum("start", "center", "end");
    exports.Anchor = kinds_1.Enum("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = kinds_1.Enum("deg", "rad", "grad", "turn");
    exports.BoxOrigin = kinds_1.Enum("corner", "center");
    exports.ButtonType = kinds_1.Enum("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = kinds_1.Enum("auto", "above", "below");
    exports.Dimension = kinds_1.Enum("width", "height");
    exports.Dimensions = kinds_1.Enum("width", "height", "both");
    exports.Direction = kinds_1.Enum("clock", "anticlock");
    exports.Distribution = kinds_1.Enum("uniform", "normal");
    exports.FontStyle = kinds_1.Enum("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = kinds_1.Enum("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
    exports.HTTPMethod = kinds_1.Enum("POST", "GET");
    exports.HexTileOrientation = kinds_1.Enum("pointytop", "flattop");
    exports.HoverMode = kinds_1.Enum("mouse", "hline", "vline");
    exports.LatLon = kinds_1.Enum("lat", "lon");
    exports.LegendClickPolicy = kinds_1.Enum("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = kinds_1.Enum("butt", "round", "square");
    exports.LineJoin = kinds_1.Enum("miter", "round", "bevel");
    exports.LineDash = kinds_1.Enum("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LinePolicy = kinds_1.Enum("prev", "next", "nearest", "interp", "none");
    exports.Location = kinds_1.Enum("above", "below", "left", "right");
    exports.Logo = kinds_1.Enum("normal", "grey");
    exports.MarkerType = kinds_1.Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = kinds_1.Enum("show", "ignore");
    exports.Orientation = kinds_1.Enum("vertical", "horizontal");
    exports.OutputBackend = kinds_1.Enum("canvas", "svg", "webgl");
    exports.PaddingUnits = kinds_1.Enum("percent", "absolute");
    exports.Place = kinds_1.Enum("above", "below", "left", "right", "center");
    exports.PointPolicy = kinds_1.Enum("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = kinds_1.Enum("x", "y", "max", "min");
    exports.RenderLevel = kinds_1.Enum("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.RenderMode = kinds_1.Enum("canvas", "css");
    exports.ResetPolicy = kinds_1.Enum("standard", "event_only");
    exports.RoundingFunction = kinds_1.Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.SelectionMode = kinds_1.Enum("replace", "append", "intersect", "subtract");
    exports.Side = kinds_1.Enum("above", "below", "left", "right");
    exports.SizingMode = kinds_1.Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
    exports.Sort = kinds_1.Enum("ascending", "descending");
    exports.SpatialUnits = kinds_1.Enum("screen", "data");
    exports.StartEnd = kinds_1.Enum("start", "end");
    exports.StepMode = kinds_1.Enum("after", "before", "center");
    exports.TapBehavior = kinds_1.Enum("select", "inspect");
    exports.TextAlign = kinds_1.Enum("left", "right", "center");
    exports.TextBaseline = kinds_1.Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = kinds_1.Enum("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TickLabelOrientation = kinds_1.Enum("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = kinds_1.Enum("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = kinds_1.Enum("replace", "append");
    exports.VerticalAlign = kinds_1.Enum("top", "middle", "bottom");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var tp = tslib_1.__importStar(require(123) /* ./util/types */);
    var color_1 = require(137) /* ./util/color */;
    var object_1 = require(128) /* ./util/object */;
    var ESMap = window.Map;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var Kind = /** @class */ (function () {
        function Kind() {
        }
        return Kind;
    }());
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        var Any = /** @class */ (function (_super) {
            tslib_1.__extends(Any, _super);
            function Any() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Any.prototype.valid = function (_value) {
                return true;
            };
            return Any;
        }(Kind));
        Any.__name__ = "Any";
        Kinds.Any = Any;
        var Unknown = /** @class */ (function (_super) {
            tslib_1.__extends(Unknown, _super);
            function Unknown() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Unknown.prototype.valid = function (_value) {
                return true;
            };
            return Unknown;
        }(Kind));
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        var Boolean = /** @class */ (function (_super) {
            tslib_1.__extends(Boolean, _super);
            function Boolean() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Boolean.prototype.valid = function (value) {
                return tp.isBoolean(value);
            };
            return Boolean;
        }(Kind));
        Boolean.__name__ = "Boolean";
        Kinds.Boolean = Boolean;
        var Ref = /** @class */ (function (_super) {
            tslib_1.__extends(Ref, _super);
            function Ref(obj_type) {
                var _this = _super.call(this) || this;
                _this.obj_type = obj_type;
                return _this;
            }
            Ref.prototype.valid = function (_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return value instanceof this.obj_type
                return true;
            };
            return Ref;
        }(Kind));
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        var AnyRef = /** @class */ (function (_super) {
            tslib_1.__extends(AnyRef, _super);
            function AnyRef() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            AnyRef.prototype.valid = function (_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return tp.isObject(value)
                return true;
            };
            return AnyRef;
        }(Kind));
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        var Number = /** @class */ (function (_super) {
            tslib_1.__extends(Number, _super);
            function Number() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Number.prototype.valid = function (value) {
                return tp.isNumber(value);
            };
            return Number;
        }(Kind));
        Number.__name__ = "Number";
        Kinds.Number = Number;
        var Int = /** @class */ (function (_super) {
            tslib_1.__extends(Int, _super);
            function Int() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Int.prototype.valid = function (value) {
                return _super.prototype.valid.call(this, value) && tp.isInteger(value);
            };
            return Int;
        }(Number));
        Int.__name__ = "Int";
        Kinds.Int = Int;
        var Percent = /** @class */ (function (_super) {
            tslib_1.__extends(Percent, _super);
            function Percent() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Percent.prototype.valid = function (value) {
                return _super.prototype.valid.call(this, value) && 0 <= value && value <= 1;
            };
            return Percent;
        }(Number));
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        var Or = /** @class */ (function (_super) {
            tslib_1.__extends(Or, _super);
            function Or(types) {
                var _this = _super.call(this) || this;
                _this.types = types;
                _this.types = types;
                return _this;
            }
            Or.prototype.valid = function (value) {
                return this.types.some(function (type) { return type.valid(value); });
            };
            return Or;
        }(Kind));
        Or.__name__ = "Or";
        Kinds.Or = Or;
        var Tuple = /** @class */ (function (_super) {
            tslib_1.__extends(Tuple, _super);
            function Tuple(types) {
                var _this = _super.call(this) || this;
                _this.types = types;
                _this.types = types;
                return _this;
            }
            Tuple.prototype.valid = function (value) {
                if (!tp.isArray(value))
                    return false;
                for (var i = 0; i < this.types.length; i++) {
                    var type = this.types[i];
                    var item = value[i];
                    if (!type.valid(item))
                        return false;
                }
                return true;
            };
            return Tuple;
        }(Kind));
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        var Struct = /** @class */ (function (_super) {
            tslib_1.__extends(Struct, _super);
            function Struct(struct_type) {
                var _this = _super.call(this) || this;
                _this.struct_type = struct_type;
                return _this;
            }
            Struct.prototype.valid = function (value) {
                if (!tp.isPlainObject(value))
                    return false;
                var struct_type = this.struct_type;
                if (object_1.size(struct_type) != object_1.size(value))
                    return false;
                for (var key in struct_type) {
                    if (hasOwnProperty.call(struct_type, key)) {
                        if (!hasOwnProperty.call(value, key))
                            return false;
                        var item_type = struct_type[key];
                        var item = value[key];
                        if (!item_type.valid(item))
                            return false;
                    }
                }
                return true;
            };
            return Struct;
        }(Kind));
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        var Arrayable = /** @class */ (function (_super) {
            tslib_1.__extends(Arrayable, _super);
            function Arrayable() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Arrayable.prototype.valid = function (value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            };
            return Arrayable;
        }(Kind));
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        var Array = /** @class */ (function (_super) {
            tslib_1.__extends(Array, _super);
            function Array(item_type) {
                var _this = _super.call(this) || this;
                _this.item_type = item_type;
                return _this;
            }
            Array.prototype.valid = function (value) {
                var _this = this;
                return tp.isArray(value) && value.every(function (item) { return _this.item_type.valid(item); });
            };
            return Array;
        }(Kind));
        Array.__name__ = "Array";
        Kinds.Array = Array;
        var Null = /** @class */ (function (_super) {
            tslib_1.__extends(Null, _super);
            function Null() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Null.prototype.valid = function (value) {
                return value === null;
            };
            return Null;
        }(Kind));
        Null.__name__ = "Null";
        Kinds.Null = Null;
        var Nullable = /** @class */ (function (_super) {
            tslib_1.__extends(Nullable, _super);
            function Nullable(base_type) {
                var _this = _super.call(this) || this;
                _this.base_type = base_type;
                return _this;
            }
            Nullable.prototype.valid = function (value) {
                return value === null || this.base_type.valid(value);
            };
            return Nullable;
        }(Kind));
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        var Opt = /** @class */ (function (_super) {
            tslib_1.__extends(Opt, _super);
            function Opt(base_type) {
                var _this = _super.call(this) || this;
                _this.base_type = base_type;
                return _this;
            }
            Opt.prototype.valid = function (value) {
                return value === undefined || this.base_type.valid(value);
            };
            return Opt;
        }(Kind));
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        var String = /** @class */ (function (_super) {
            tslib_1.__extends(String, _super);
            function String() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            String.prototype.valid = function (value) {
                return tp.isString(value);
            };
            return String;
        }(Kind));
        String.__name__ = "String";
        Kinds.String = String;
        var Enum = /** @class */ (function (_super) {
            tslib_1.__extends(Enum, _super);
            function Enum(values) {
                var _this = _super.call(this) || this;
                _this.values = new Set(values);
                return _this;
            }
            Enum.prototype.valid = function (value) {
                return this.values.has(value);
            };
            Enum.prototype[Symbol.iterator] = function () {
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [5 /*yield**/, tslib_1.__values(this.values)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            };
            return Enum;
        }(Kind));
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        var Dict = /** @class */ (function (_super) {
            tslib_1.__extends(Dict, _super);
            function Dict(item_type) {
                var _this = _super.call(this) || this;
                _this.item_type = item_type;
                return _this;
            }
            Dict.prototype.valid = function (value) {
                if (!tp.isPlainObject(value))
                    return false;
                for (var key in value) {
                    if (hasOwnProperty.call(value, key)) {
                        var item = value[key];
                        if (!this.item_type.valid(item))
                            return false;
                    }
                }
                return true;
            };
            return Dict;
        }(Kind));
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        var Map = /** @class */ (function (_super) {
            tslib_1.__extends(Map, _super);
            function Map(key_type, item_type) {
                var _this = _super.call(this) || this;
                _this.key_type = key_type;
                _this.item_type = item_type;
                return _this;
            }
            Map.prototype.valid = function (value) {
                var e_1, _a;
                if (!(value instanceof ESMap))
                    return false;
                try {
                    for (var _b = tslib_1.__values(value.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], item = _d[1];
                        if (!(this.key_type.valid(key) && this.item_type.valid(item)))
                            return false;
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return true;
            };
            return Map;
        }(Kind));
        Map.__name__ = "Map";
        Kinds.Map = Map;
        var Color = /** @class */ (function (_super) {
            tslib_1.__extends(Color, _super);
            function Color() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Color.prototype.valid = function (value) {
                return color_1.is_Color(value);
            };
            return Color;
        }(Kind));
        Color.__name__ = "Color";
        Kinds.Color = Color;
        var Function = /** @class */ (function (_super) {
            tslib_1.__extends(Function, _super);
            function Function() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Function.prototype.valid = function (value) {
                return tp.isFunction(value);
            };
            return Function;
        }(Kind));
        Function.__name__ = "Function";
        Kinds.Function = Function;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Boolean = new exports.Kinds.Boolean();
    exports.Number = new exports.Kinds.Number();
    exports.Int = new exports.Kinds.Int();
    exports.String = new exports.Kinds.String();
    exports.Null = new exports.Kinds.Null();
    var Nullable = function (base_type) { return new exports.Kinds.Nullable(base_type); };
    exports.Nullable = Nullable;
    var Opt = function (base_type) { return new exports.Kinds.Opt(base_type); };
    exports.Opt = Opt;
    var Or = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        return new exports.Kinds.Or(types);
    };
    exports.Or = Or;
    var Tuple = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        return new exports.Kinds.Tuple(types);
    };
    exports.Tuple = Tuple;
    var Struct = function (struct_type) { return new exports.Kinds.Struct(struct_type); };
    exports.Struct = Struct;
    exports.Arrayable = new exports.Kinds.Arrayable();
    var Array = function (item_type) { return new exports.Kinds.Array(item_type); };
    exports.Array = Array;
    var Dict = function (item_type) { return new exports.Kinds.Dict(item_type); };
    exports.Dict = Dict;
    var Map = function (key_type, item_type) { return new exports.Kinds.Map(key_type, item_type); };
    exports.Map = Map;
    var Enum = function () {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        return new exports.Kinds.Enum(values);
    };
    exports.Enum = Enum;
    var Ref = function (obj_type) { return new exports.Kinds.Ref(obj_type); };
    exports.Ref = Ref;
    var AnyRef = function () { return new exports.Kinds.AnyRef(); };
    exports.AnyRef = AnyRef;
    var Function = function () { return new exports.Kinds.Function(); };
    exports.Function = Function;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = exports.Enum("auto");
    exports.FontSize = exports.String;
    exports.Font = exports.String;
    exports.Angle = exports.Number;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var svg_colors_1 = require(138) /* ./svg_colors */;
    var math_1 = require(125) /* ./math */;
    var types_1 = require(123) /* ./types */;
    var round = Math.round;
    function byte(v) {
        return math_1.clamp(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    exports.transparent = transparent;
    function encode_rgba(_a) {
        var _b = tslib_1.__read(_a, 4), r = _b[0], g = _b[1], b = _b[2], a = _b[3];
        return r << 24 | g << 16 | b << 8 | a;
    }
    exports.encode_rgba = encode_rgba;
    function decode_rgba(rgba) {
        var r = (rgba >> 24) & 0xff;
        var g = (rgba >> 16) & 0xff;
        var b = (rgba >> 8) & 0xff;
        var a = rgba & 0xff;
        return [r, g, b, a];
    }
    exports.decode_rgba = decode_rgba;
    function compose_alpha(color, alpha) {
        if ((color & 0xff) == 255)
            return (color & 0xffffff00) | byte(alpha * 255);
        else
            return color;
    }
    exports.compose_alpha = compose_alpha;
    function color2rgba(color, alpha) {
        var _a, _b, _c, _d, _e;
        var _f;
        var r, g, b, a;
        if (color == null)
            _a = tslib_1.__read(transparent(), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        else if (types_1.isInteger(color))
            _b = tslib_1.__read(decode_rgba(color), 4), r = _b[0], g = _b[1], b = _b[2], a = _b[3];
        else if (types_1.isString(color))
            _c = tslib_1.__read((_f = css4_parse(color)) !== null && _f !== void 0 ? _f : transparent(), 4), r = _c[0], g = _c[1], b = _c[2], a = _c[3];
        else {
            _d = tslib_1.__read(color, 4), r = _d[0], g = _d[1], b = _d[2], _e = _d[3], a = _e === void 0 ? 1.0 : _e;
            a = byte(a * 255);
        }
        if (a == 255 && alpha != null)
            a = byte(alpha * 255);
        return [r, g, b, a];
    }
    exports.color2rgba = color2rgba;
    var _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function color2css(color, alpha) {
        var _a = tslib_1.__read(color2rgba(color, alpha), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        return "rgba(" + r + ", " + g + ", " + b + ", " + a / 255 + ")";
    }
    exports.color2css = color2css;
    function color2hex(color, alpha) {
        var _a = tslib_1.__read(color2rgba(color, alpha), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        var rgb = "#" + hex(r) + hex(g) + hex(b);
        return a == 255 ? rgb : "" + rgb + hex(a);
    }
    exports.color2hex = color2hex;
    function color2hexrgb(color) {
        var _a = tslib_1.__read(color2rgba(color), 3), r = _a[0], g = _a[1], b = _a[2];
        return "#" + hex(r) + hex(g) + hex(b);
    }
    exports.color2hexrgb = color2hexrgb;
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    var rgb_modern = /^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/;
    var rgb_legacy = /^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/;
    var css4_normalize = (function () {
        var canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        var ctx = canvas.getContext("2d");
        var gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return function (color) {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            var style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        var _a;
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (!color)
            return null;
        else if (color == "transparent")
            return transparent();
        else if (svg_colors_1.is_named_color(color)) {
            return decode_rgba(svg_colors_1.named_colors[color]);
        }
        else if (color[0] == "#") {
            var v = Number("0x" + color.substr(1));
            if (isNaN(v))
                return null;
            switch (color.length - 1) {
                case 3: {
                    var r = (v >> 8) & 0xf;
                    var g = (v >> 4) & 0xf;
                    var b = (v >> 0) & 0xf;
                    var rr = (r << 4) | r;
                    var gg = (g << 4) | g;
                    var bb = (b << 4) | b;
                    return [rr, gg, bb, 255];
                }
                case 4: {
                    var r = (v >> 12) & 0xf;
                    var g = (v >> 8) & 0xf;
                    var b = (v >> 4) & 0xf;
                    var a = (v >> 0) & 0xf;
                    var rr = (r << 4) | r;
                    var gg = (g << 4) | g;
                    var bb = (b << 4) | b;
                    var aa = (a << 4) | a;
                    return [rr, gg, bb, aa];
                }
                case 6: {
                    var rr = (v >> 16) & 0xff;
                    var gg = (v >> 8) & 0xff;
                    var bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 255];
                }
                case 8: {
                    var rr = (v >> 24) & 0xff;
                    var gg = (v >> 16) & 0xff;
                    var bb = (v >> 8) & 0xff;
                    var aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            var result = (_a = color.match(rgb_modern)) !== null && _a !== void 0 ? _a : color.match(rgb_legacy);
            if (result != null) {
                var _b = tslib_1.__read(result, 5), r = _b[1], g = _b[2], b = _b[3], _c = _b[4], a = _c === void 0 ? "1" : _c; // XXX: use groups when IE is dropped
                var rp = r.endsWith("%");
                var gp = g.endsWith("%");
                var bp = b.endsWith("%");
                var ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp)))
                    return null;
                if (rp)
                    r = r.slice(0, -1);
                if (gp)
                    g = g.slice(0, -1);
                if (bp)
                    b = b.slice(0, -1);
                if (ap)
                    a = a.slice(0, -1);
                var R = Number(r);
                var G = Number(g);
                var B = Number(b);
                var A = Number(a);
                if (isNaN(R + G + B + A))
                    return null;
                if (rp)
                    R = 255 * (R / 100);
                if (gp)
                    G = 255 * (G / 100);
                if (bp)
                    B = 255 * (B / 100);
                A = 255 * (ap ? A / 100 : A);
                R = byte(R);
                G = byte(G);
                B = byte(B);
                A = byte(A);
                return [R, G, B, A];
            }
        }
        else {
            var style = css4_normalize(color);
            if (style != null)
                return css4_parse(style);
        }
        return null;
    }
    exports.css4_parse = css4_parse;
    function is_Color(value) {
        if (types_1.isInteger(value))
            return true;
        if (types_1.isString(value) && css4_parse(value) != null)
            return true;
        if (types_1.isArray(value) && (value.length == 3 || value.length == 4))
            return true;
        return false;
    }
    exports.is_Color = is_Color;
    function is_dark(_a) {
        var _b = tslib_1.__read(_a, 3), r = _b[0], g = _b[1], b = _b[2];
        var l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    exports.is_dark = is_dark;
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
    exports.is_named_color = is_named_color;
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    exports.GeneratorFunction = Object.getPrototypeOf(function () {
        return tslib_1.__generator(this, function (_a) {
            return [2 /*return*/];
        });
    }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array)
            return Float64Array;
        if (a1 instanceof Float64Array || a1 instanceof Array)
            return Float64Array;
        return Float32Array;
    }
    exports.infer_type = infer_type;
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array))
            return new Float32Array(array);
        else
            return array;
    }
    exports.to_screen = to_screen;
    var bitset_1 = require(140) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var _a;
    var eq_1 = require(141) /* ./eq */;
    var assert_1 = require(126) /* ./assert */;
    var BitSet = /** @class */ (function () {
        function BitSet(size, init) {
            if (init === void 0) {
                init = 0;
            }
            this.size = size;
            this[_a] = "BitSet";
            this._count = null;
            this._nwords = Math.ceil(size / 32);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                assert_1.assert(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        BitSet.prototype.clone = function () {
            return new BitSet(this.size, new Uint32Array(this._array));
        };
        BitSet.prototype[(_a = Symbol.toStringTag, eq_1.equals)] = function (that, cmp) {
            if (!cmp.eq(this.size, that.size))
                return false;
            var _nwords = this._nwords;
            var trailing = this.size % _nwords;
            var n = trailing == 0 ? _nwords : _nwords - 1;
            for (var i = 0; i < n; i++) {
                if (this._array[i] != that._array[i])
                    return false;
            }
            if (trailing == 0)
                return true;
            else {
                var msb = 1 << (trailing - 1);
                var mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        };
        BitSet.all_set = function (size) {
            return new BitSet(size, 1);
        };
        BitSet.all_unset = function (size) {
            return new BitSet(size, 0);
        };
        BitSet.from_indices = function (size, indices) {
            var e_1, _b;
            var bits = new BitSet(size);
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    bits.set(i);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_b = indices_1.return))
                        _b.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return bits;
        };
        BitSet.from_booleans = function (size, booleans) {
            var bits = new BitSet(size);
            var n = Math.min(size, booleans.length);
            for (var i = 0; i < n; i++) {
                if (booleans[i])
                    bits.set(i);
            }
            return bits;
        };
        BitSet.prototype._check_bounds = function (k) {
            assert_1.assert(0 <= k && k < this.size, "Out of bounds: 0 <= " + k + " < " + this.size);
        };
        BitSet.prototype.get = function (k) {
            this._check_bounds(k);
            var i = k >>> 5; // Math.floor(k/32)
            var j = k & 0x1f; // k % 32
            return !!((this._array[i] >> j) & 0x1);
        };
        BitSet.prototype.set = function (k, v) {
            if (v === void 0) {
                v = true;
            }
            this._check_bounds(k);
            this._count = null;
            var i = k >>> 5; // Math.floor(k/32)
            var j = k & 0x1f; // k % 32
            if (v)
                this._array[i] |= 0x1 << j;
            else
                this._array[i] &= ~(0x1 << j);
        };
        BitSet.prototype.unset = function (k) {
            this.set(k, false);
        };
        BitSet.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this.ones())];
                    case 1:
                        _b.sent();
                        return [2 /*return*/];
                }
            });
        };
        Object.defineProperty(BitSet.prototype, "count", {
            get: function () {
                var count = this._count;
                if (count == null)
                    this._count = count = this._get_count();
                return count;
            },
            enumerable: false,
            configurable: true
        });
        BitSet.prototype._get_count = function () {
            var _b = this, _array = _b._array, _nwords = _b._nwords, size = _b.size;
            var c = 0;
            for (var k = 0, i = 0; i < _nwords; i++) {
                var word = _array[i];
                if (word == 0) {
                    k += 32;
                }
                else {
                    for (var j = 0; j < 32 && k < size; j++, k++) {
                        if ((word >>> j) & 0x1)
                            c += 1;
                    }
                }
            }
            return c;
        };
        BitSet.prototype.ones = function () {
            var _b, _array, _nwords, size, k, i, word, j;
            return tslib_1.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _b = this, _array = _b._array, _nwords = _b._nwords, size = _b.size;
                        k = 0, i = 0;
                        _c.label = 1;
                    case 1:
                        if (!(i < _nwords))
                            return [3 /*break*/, 6];
                        word = _array[i];
                        if (word == 0) {
                            k += 32;
                            return [3 /*break*/, 5];
                        }
                        j = 0;
                        _c.label = 2;
                    case 2:
                        if (!(j < 32 && k < size))
                            return [3 /*break*/, 5];
                        if (!((word >>> j) & 0x1))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, k];
                    case 3:
                        _c.sent();
                        _c.label = 4;
                    case 4:
                        j++, k++;
                        return [3 /*break*/, 2];
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/];
                }
            });
        };
        BitSet.prototype.zeros = function () {
            var _b, _array, _nwords, size, k, i, word, j;
            return tslib_1.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _b = this, _array = _b._array, _nwords = _b._nwords, size = _b.size;
                        k = 0, i = 0;
                        _c.label = 1;
                    case 1:
                        if (!(i < _nwords))
                            return [3 /*break*/, 6];
                        word = _array[i];
                        if (word == 0xffffffff) {
                            k += 32;
                            return [3 /*break*/, 5];
                        }
                        j = 0;
                        _c.label = 2;
                    case 2:
                        if (!(j < 32 && k < size))
                            return [3 /*break*/, 5];
                        if (!!((word >>> j) & 0x1))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, k];
                    case 3:
                        _c.sent();
                        _c.label = 4;
                    case 4:
                        j++, k++;
                        return [3 /*break*/, 2];
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/];
                }
            });
        };
        BitSet.prototype._check_size = function (other) {
            assert_1.assert(this.size == other.size, "Size mismatch");
        };
        BitSet.prototype.add = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        };
        BitSet.prototype.intersect = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        };
        BitSet.prototype.subtract = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                var a = this._array[i];
                var b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        };
        BitSet.prototype.union = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                result._array[i] |= other._array[i];
            }
            return result;
        };
        BitSet.prototype.intersection = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                result._array[i] &= other._array[i];
            }
            return result;
        };
        BitSet.prototype.difference = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                var a = this._array[i];
                var b = other._array[i];
                result._array[i] = (a ^ b) & a;
            }
            return result;
        };
        BitSet.prototype.select = function (array) {
            var e_2, _b;
            assert_1.assert(this.size <= array.length, "Size mismatch");
            var n = this.count;
            var result = new array.constructor(n);
            var i = 0;
            try {
                for (var _c = tslib_1.__values(this), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var j = _d.value;
                    result[i++] = array[j];
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_b = _c.return))
                        _b.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return result;
        };
        return BitSet;
    }());
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    var types_1 = require(123) /* ./types */;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return types_1.isObject(obj) && obj[exports.equals] !== undefined;
    }
    exports.wildcard = Symbol("wildcard");
    var toString = Object.prototype.toString;
    var Comparator = /** @class */ (function () {
        function Comparator() {
            this.a_stack = [];
            this.b_stack = [];
        }
        Comparator.prototype.eq = function (a, b) {
            var _this = this;
            if (Object.is(a, b))
                return true;
            if (a === exports.wildcard || b === exports.wildcard)
                return true;
            if (a == null || b == null)
                return a === b;
            var class_name = toString.call(a);
            if (class_name != toString.call(b))
                return false;
            switch (class_name) {
                case "[object Number]":
                    return this.numbers(a, b);
                case "[object RegExp]":
                case "[object String]":
                    return "" + a == "" + b;
                case "[object Date]":
                case "[object Boolean]":
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            var _a = this, a_stack = _a.a_stack, b_stack = _a.b_stack;
            var length = a_stack.length;
            while (length--) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a)
                    return b_stack[length] === b;
            }
            a_stack.push(a);
            b_stack.push(b);
            var result = (function () {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, _this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return _this.arrays(a, b);
                    }
                    case "[object Map]":
                        return _this.maps(a, b);
                    case "[object Set]":
                        return _this.sets(a, b);
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return _this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return _this.eq("" + a, "" + b);
                        }
                    }
                }
                if (a instanceof Node) {
                    return _this.nodes(a, b);
                }
                throw Error("can't compare objects of type " + class_name);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        };
        Comparator.prototype.numbers = function (a, b) {
            return Object.is(a, b);
        };
        Comparator.prototype.arrays = function (a, b) {
            var length = a.length;
            if (length != b.length)
                return false;
            for (var i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i]))
                    return false;
            }
            return true;
        };
        Comparator.prototype.iterables = function (a, b) {
            var ai = a[Symbol.iterator]();
            var bi = b[Symbol.iterator]();
            while (true) {
                var an = ai.next();
                var bn = bi.next();
                if (an.done && bn.done)
                    return true;
                if (an.done || bn.done)
                    return false;
                if (!this.eq(an.value, bn.value))
                    return false;
            }
        };
        Comparator.prototype.maps = function (a, b) {
            var e_1, _a;
            if (a.size != b.size)
                return false;
            try {
                for (var a_1 = tslib_1.__values(a), a_1_1 = a_1.next(); !a_1_1.done; a_1_1 = a_1.next()) {
                    var _b = tslib_1.__read(a_1_1.value, 2), key = _b[0], val = _b[1];
                    if (!b.has(key) || !this.eq(val, b.get(key)))
                        return false;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (a_1_1 && !a_1_1.done && (_a = a_1.return))
                        _a.call(a_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return true;
        };
        Comparator.prototype.sets = function (a, b) {
            var e_2, _a;
            if (a.size != b.size)
                return false;
            try {
                for (var a_2 = tslib_1.__values(a), a_2_1 = a_2.next(); !a_2_1.done; a_2_1 = a_2.next()) {
                    var key = a_2_1.value;
                    if (!b.has(key))
                        return false;
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (a_2_1 && !a_2_1.done && (_a = a_2.return))
                        _a.call(a_2);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return true;
        };
        Comparator.prototype.objects = function (a, b) {
            var e_3, _a;
            var keys = Object.keys(a);
            if (keys.length != Object.keys(b).length)
                return false;
            try {
                for (var keys_1 = tslib_1.__values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                    var key = keys_1_1.value;
                    if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key]))
                        return false;
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
                        _a.call(keys_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return true;
        };
        Comparator.prototype.nodes = function (a, b) {
            if (a.nodeType != b.nodeType)
                return false;
            if (a.textContent != b.textContent)
                return false;
            if (!this.iterables(a.childNodes, b.childNodes))
                return false;
            return true;
        };
        return Comparator;
    }());
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    var abs = Math.abs;
    var SimilarComparator = /** @class */ (function (_super) {
        tslib_1.__extends(SimilarComparator, _super);
        function SimilarComparator(tolerance) {
            if (tolerance === void 0) {
                tolerance = 1e-4;
            }
            var _this = _super.call(this) || this;
            _this.tolerance = tolerance;
            return _this;
        }
        SimilarComparator.prototype.numbers = function (a, b) {
            return _super.prototype.numbers.call(this, a, b) || abs(a - b) < this.tolerance;
        };
        return SimilarComparator;
    }(Comparator));
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        var comparator = new Comparator();
        return comparator.eq(a, b);
    }
    exports.is_equal = is_equal;
    function is_similar(a, b, tolerance) {
        var comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
    exports.is_similar = is_similar;
    /** @deprecated */
    exports.isEqual = is_equal;
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    exports.is_windows = (function () {
        return navigator.appVersion.includes("Windows");
    })();
    exports.is_ie = (function () {
        var ua = navigator.userAgent;
        return ua.includes("MSIE") || ua.includes("Trident") || ua.includes("Edge");
    })();
    exports.is_mobile = (function () {
        return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (function () {
        var buf = new ArrayBuffer(4);
        var buf8 = new Uint8Array(buf);
        var buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        var little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        var e_1, _a;
        if (exports.is_little_endian) {
            var result = new Uint32Array(values.length);
            var view = new DataView(result.buffer);
            var j = 0;
            try {
                for (var values_1 = tslib_1.__values(values), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                    var color = values_1_1.value;
                    view.setUint32(j, color);
                    j += 4;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (values_1_1 && !values_1_1.done && (_a = values_1.return))
                        _a.call(values_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return result;
        }
        else
            return values;
    }
    exports.to_big_endian = to_big_endian;
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Settings = /** @class */ (function () {
        function Settings() {
            this._dev = false;
            this._wireframe = false;
        }
        Object.defineProperty(Settings.prototype, "dev", {
            get: function () {
                return this._dev;
            },
            set: function (dev) {
                this._dev = dev;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Settings.prototype, "wireframe", {
            get: function () {
                return this._wireframe;
            },
            set: function (wireframe) {
                this._wireframe = wireframe;
            },
            enumerable: false,
            configurable: true
        });
        return Settings;
    }());
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var _a, _b, _c, _d, _e, _f, _g, _h;
    var types_1 = require(123) /* ./types */;
    var assert_1 = require(126) /* ./assert */;
    var eq_1 = require(141) /* ./eq */;
    var serializer_1 = require(145) /* ../serializer */;
    var serialization_1 = require(146) /* ./serialization */;
    var __ndarray__ = Symbol("__ndarray__");
    var Uint8NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint8NDArray, _super);
        function Uint8NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_a] = true;
            _this.dtype = "uint8";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint8NDArray.prototype[(_a = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint8NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint8NDArray;
    }(Uint8Array));
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    var Int8NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int8NDArray, _super);
        function Int8NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_b] = true;
            _this.dtype = "int8";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int8NDArray.prototype[(_b = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int8NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int8NDArray;
    }(Int8Array));
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    var Uint16NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint16NDArray, _super);
        function Uint16NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_c] = true;
            _this.dtype = "uint16";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint16NDArray.prototype[(_c = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint16NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint16NDArray;
    }(Uint16Array));
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    var Int16NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int16NDArray, _super);
        function Int16NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_d] = true;
            _this.dtype = "int16";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int16NDArray.prototype[(_d = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int16NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int16NDArray;
    }(Int16Array));
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    var Uint32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint32NDArray, _super);
        function Uint32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_e] = true;
            _this.dtype = "uint32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint32NDArray.prototype[(_e = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint32NDArray;
    }(Uint32Array));
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    var Int32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int32NDArray, _super);
        function Int32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_f] = true;
            _this.dtype = "int32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int32NDArray.prototype[(_f = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int32NDArray;
    }(Int32Array));
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    var Float32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Float32NDArray, _super);
        function Float32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_g] = true;
            _this.dtype = "float32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Float32NDArray.prototype[(_g = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Float32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Float32NDArray;
    }(Float32Array));
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    var Float64NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Float64NDArray, _super);
        function Float64NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_h] = true;
            _this.dtype = "float64";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Float64NDArray.prototype[(_h = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Float64NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Float64NDArray;
    }(Float64Array));
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    function is_NDArray(v) {
        return types_1.isObject(v) && v[__ndarray__] !== undefined;
    }
    exports.is_NDArray = is_NDArray;
    function ndarray(array, options) {
        if (options === void 0) {
            options = {};
        }
        var dtype = options.dtype;
        if (dtype == null) {
            if (array instanceof ArrayBuffer || types_1.isArray(array)) {
                dtype = "float64";
            }
            else {
                dtype = (function () {
                    switch (true) {
                        case array instanceof Uint8Array: return "uint8";
                        case array instanceof Int8Array: return "int8";
                        case array instanceof Uint16Array: return "uint16";
                        case array instanceof Int16Array: return "int16";
                        case array instanceof Uint32Array: return "uint32";
                        case array instanceof Int32Array: return "int32";
                        case array instanceof Float32Array: return "float32";
                        case array instanceof Float64Array: return "float64";
                        default:
                            assert_1.unreachable();
                    }
                })();
            }
        }
        var shape = options.shape;
        switch (dtype) {
            case "uint8": return new Uint8NDArray(array, shape);
            case "int8": return new Int8NDArray(array, shape);
            case "uint16": return new Uint16NDArray(array, shape);
            case "int16": return new Int16NDArray(array, shape);
            case "uint32": return new Uint32NDArray(array, shape);
            case "int32": return new Int32NDArray(array, shape);
            case "float32": return new Float32NDArray(array, shape);
            case "float64": return new Float64NDArray(array, shape);
        }
    }
    exports.ndarray = ndarray;
},
/* core/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var assert_1 = require(126) /* ./util/assert */;
    var object_1 = require(128) /* ./util/object */;
    var types_1 = require(123) /* ./util/types */;
    //| Map<SerializableType, SerializableType>
    //| Set<SerializableType>
    //| ArrayBuffer
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return types_1.isObject(obj) && obj[exports.serialize] !== undefined;
    }
    var SerializationError = /** @class */ (function (_super) {
        tslib_1.__extends(SerializationError, _super);
        function SerializationError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SerializationError;
    }(Error));
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    var Serializer = /** @class */ (function () {
        function Serializer(options) {
            var _a;
            this._references = new Map();
            this._definitions = new Map();
            this._refmap = new Map();
            this.include_defaults = (_a = options === null || options === void 0 ? void 0 : options.include_defaults) !== null && _a !== void 0 ? _a : true;
        }
        Serializer.prototype.get_ref = function (obj) {
            return this._references.get(obj);
        };
        Serializer.prototype.add_ref = function (obj, ref) {
            assert_1.assert(!this._references.has(obj));
            this._references.set(obj, ref);
        };
        Serializer.prototype.add_def = function (obj, def) {
            var ref = this.get_ref(obj);
            assert_1.assert(ref != null);
            this._definitions.set(obj, def);
            this._refmap.set(ref, def);
        };
        Object.defineProperty(Serializer.prototype, "objects", {
            get: function () {
                return new Set(this._references.keys());
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Serializer.prototype, "references", {
            get: function () {
                return new Set(this._references.values());
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Serializer.prototype, "definitions", {
            get: function () {
                return new Set(this._definitions.values());
            },
            enumerable: false,
            configurable: true
        });
        Serializer.prototype.resolve_ref = function (ref) {
            return this._refmap.get(ref);
        };
        Serializer.prototype.remove_ref = function (obj) {
            return this._references.delete(obj);
        };
        Serializer.prototype.remove_def = function (obj) {
            return this._definitions.delete(obj);
        };
        Serializer.prototype.to_serializable = function (obj) {
            var e_1, _a;
            var ref = this.get_ref(obj);
            if (ref != null)
                return ref;
            else if (is_Serializable(obj))
                return obj[exports.serialize](this);
            else if (types_1.isArray(obj) || types_1.isTypedArray(obj)) {
                var n = obj.length;
                var result = new Array(n);
                for (var i = 0; i < n; i++) {
                    var value = obj[i];
                    result[i] = this.to_serializable(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], value = _d[1];
                        result[key] = this.to_serializable(value);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new SerializationError(Object.prototype.toString.call(obj) + " is not serializable");
        };
        return Serializer;
    }());
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/util/serialization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./types */;
    var platform_1 = require(142) /* ./platform */;
    var buffer_1 = require(147) /* ./buffer */;
    function is_NDArray_ref(v) {
        return types_1.isPlainObject(v) && ("__buffer__" in v || "__ndarray__" in v);
    }
    exports.is_NDArray_ref = is_NDArray_ref;
    function decode_NDArray(ref, buffers) {
        var shape = ref.shape, dtype = ref.dtype, order = ref.order;
        var bytes;
        if ("__buffer__" in ref) {
            var buffer = buffers.get(ref.__buffer__);
            if (buffer != null)
                bytes = buffer;
            else
                throw new Error("buffer for " + ref.__buffer__ + " not found");
        }
        else {
            bytes = buffer_1.base64_to_buffer(ref.__ndarray__);
        }
        if (order !== platform_1.BYTE_ORDER) {
            buffer_1.swap(bytes, dtype);
        }
        return { buffer: bytes, dtype: dtype, shape: shape };
    }
    exports.decode_NDArray = decode_NDArray;
    function encode_NDArray(array, buffers) {
        var data = {
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
        if (buffers != null) {
            var __buffer__ = "" + buffers.size;
            buffers.set(__buffer__, array.buffer);
            return tslib_1.__assign({ __buffer__: __buffer__ }, data);
        }
        else {
            var __ndarray__ = {
                toJSON: function () {
                    return buffer_1.buffer_to_base64(array.buffer);
                },
            };
            return tslib_1.__assign({ __ndarray__: __ndarray__ }, data);
        }
    }
    exports.encode_NDArray = encode_NDArray;
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function buffer_to_base64(buffer) {
        var bytes = new Uint8Array(buffer);
        var chars = Array.from(bytes).map(function (b) { return String.fromCharCode(b); });
        return btoa(chars.join(""));
    }
    exports.buffer_to_base64 = buffer_to_base64;
    function base64_to_buffer(base64) {
        var binary_string = atob(base64);
        var len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64_to_buffer = base64_to_buffer;
    // NOTE: swap{16,32,64} assume byteOffset == 0
    function swap16(buffer) {
        var x = new Uint8Array(buffer);
        for (var i = 0, end = x.length; i < end; i += 2) {
            var t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(buffer) {
        var x = new Uint8Array(buffer);
        for (var i = 0, end = x.length; i < end; i += 4) {
            var t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(buffer) {
        var x = new Uint8Array(buffer);
        for (var i = 0, end = x.length; i < end; i += 8) {
            var t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(buffer, dtype) {
        switch (dtype) {
            case "uint16":
            case "int16":
                swap16(buffer);
                break;
            case "uint32":
            case "int32":
            case "float32":
                swap32(buffer);
                break;
            case "float64":
                swap64(buffer);
                break;
        }
    }
    exports.swap = swap;
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var eq_1 = require(141) /* ./util/eq */;
    var Uniform = /** @class */ (function () {
        function Uniform() {
        }
        Uniform.prototype.is_Scalar = function () { return this.is_scalar; };
        Uniform.prototype.is_Vector = function () { return !this.is_scalar; };
        return Uniform;
    }());
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    var UniformScalar = /** @class */ (function (_super) {
        tslib_1.__extends(UniformScalar, _super);
        function UniformScalar(value, length) {
            var _this = _super.call(this) || this;
            _this.value = value;
            _this.length = length;
            _this.is_scalar = true;
            return _this;
        }
        UniformScalar.prototype.get = function (_i) {
            return this.value;
        };
        UniformScalar.prototype[Symbol.iterator] = function () {
            var _a, length, value, i;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, length = _a.length, value = _a.value;
                        i = 0;
                        _b.label = 1;
                    case 1:
                        if (!(i < length))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, value];
                    case 2:
                        _b.sent();
                        _b.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        };
        UniformScalar.prototype.select = function (indices) {
            return new UniformScalar(this.value, indices.count);
        };
        UniformScalar.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        };
        return UniformScalar;
    }(Uniform));
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    var UniformVector = /** @class */ (function (_super) {
        tslib_1.__extends(UniformVector, _super);
        function UniformVector(array) {
            var _this = _super.call(this) || this;
            _this.array = array;
            _this.is_scalar = false;
            _this.length = _this.array.length;
            return _this;
        }
        UniformVector.prototype.get = function (i) {
            return this.array[i];
        };
        UniformVector.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this.array)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        UniformVector.prototype.select = function (indices) {
            var array = indices.select(this.array);
            return new this.constructor(array);
        };
        UniformVector.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        };
        return UniformVector;
    }(Uniform));
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    var ColorUniformVector = /** @class */ (function (_super) {
        tslib_1.__extends(ColorUniformVector, _super);
        function ColorUniformVector(array) {
            var _this = _super.call(this, array) || this;
            _this.array = array;
            _this._view = new DataView(array.buffer);
            return _this;
        }
        ColorUniformVector.prototype.get = function (i) {
            return this._view.getUint32(4 * i);
        };
        ColorUniformVector.prototype[Symbol.iterator] = function () {
            var n, i;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        n = this.length;
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < n))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, this.get(i)];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        };
        return ColorUniformVector;
    }(UniformVector));
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var settings_1 = require(143) /* ../settings */;
    function startsWith(str, searchString, position) {
        if (position === void 0) {
            position = 0;
        }
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        var s = new Array(32);
        var hexDigits = "0123456789ABCDEF";
        for (var i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    var counter = 1000;
    function uniqueId(prefix) {
        var id = settings_1.settings.dev ? "j" + counter++ : uuid4();
        if (prefix != null)
            return prefix + "-" + id;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, function (ch) {
            switch (ch) {
                case "&": return "&amp;";
                case "<": return "&lt;";
                case ">": return "&gt;";
                case '"': return "&quot;";
                case "'": return "&#x27;";
                case "`": return "&#x60;";
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, function (_, entity) {
            switch (entity) {
                case "amp": return "&";
                case "lt": return "<";
                case "gt": return ">";
                case "quot": return '"';
                case "#x27": return "'";
                case "#x60": return "`";
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return "'use strict';\n" + code;
    }
    exports.use_strict = use_strict;
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    exports.to_fixed = to_fixed;
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var serializer_1 = require(145) /* ../core/serializer */;
    var DocumentEvent = /** @class */ (function () {
        function DocumentEvent(document) {
            this.document = document;
        }
        return DocumentEvent;
    }());
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    var DocumentEventBatch = /** @class */ (function (_super) {
        tslib_1.__extends(DocumentEventBatch, _super);
        function DocumentEventBatch(document, events, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.events = events;
            _this.setter_id = setter_id;
            return _this;
        }
        return DocumentEventBatch;
    }(DocumentEvent));
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    var DocumentChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(DocumentChangedEvent, _super);
        function DocumentChangedEvent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DocumentChangedEvent;
    }(DocumentEvent));
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    var MessageSentEvent = /** @class */ (function (_super) {
        tslib_1.__extends(MessageSentEvent, _super);
        function MessageSentEvent(document, msg_type, msg_data) {
            var _this = _super.call(this, document) || this;
            _this.msg_type = msg_type;
            _this.msg_data = msg_data;
            return _this;
        }
        MessageSentEvent.prototype[serializer_1.serialize] = function (serializer) {
            var value = this.msg_data;
            var value_serialized = serializer.to_serializable(value);
            return {
                kind: "MessageSent",
                msg_type: this.msg_type,
                msg_data: value_serialized,
            };
        };
        return MessageSentEvent;
    }(DocumentChangedEvent));
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    var ModelChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ModelChangedEvent, _super);
        function ModelChangedEvent(document, model, attr, old, new_, setter_id, hint) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.attr = attr;
            _this.old = old;
            _this.new_ = new_;
            _this.setter_id = setter_id;
            _this.hint = hint;
            return _this;
        }
        ModelChangedEvent.prototype[serializer_1.serialize] = function (serializer) {
            if (this.hint != null)
                return serializer.to_serializable(this.hint);
            var value = this.new_;
            var value_serialized = serializer.to_serializable(value);
            if (this.model != value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                serializer.remove_def(this.model);
            }
            return {
                kind: "ModelChanged",
                model: this.model.ref(),
                attr: this.attr,
                new: value_serialized,
            };
        };
        return ModelChangedEvent;
    }(DocumentChangedEvent));
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    var ColumnsPatchedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsPatchedEvent, _super);
        function ColumnsPatchedEvent(document, column_source, patches) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.patches = patches;
            return _this;
        }
        ColumnsPatchedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "ColumnsPatched",
                column_source: this.column_source,
                patches: this.patches,
            };
        };
        return ColumnsPatchedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    var ColumnsStreamedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsStreamedEvent, _super);
        function ColumnsStreamedEvent(document, column_source, data, rollover) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.data = data;
            _this.rollover = rollover;
            return _this;
        }
        ColumnsStreamedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "ColumnsStreamed",
                column_source: this.column_source,
                data: this.data,
                rollover: this.rollover,
            };
        };
        return ColumnsStreamedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    var TitleChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(TitleChangedEvent, _super);
        function TitleChangedEvent(document, title, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.title = title;
            _this.setter_id = setter_id;
            return _this;
        }
        TitleChangedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "TitleChanged",
                title: this.title,
            };
        };
        return TitleChangedEvent;
    }(DocumentChangedEvent));
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    var RootAddedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootAddedEvent, _super);
        function RootAddedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootAddedEvent.prototype[serializer_1.serialize] = function (serializer) {
            return {
                kind: "RootAdded",
                model: serializer.to_serializable(this.model),
            };
        };
        return RootAddedEvent;
    }(DocumentChangedEvent));
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    var RootRemovedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootRemovedEvent, _super);
        function RootRemovedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootRemovedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "RootRemoved",
                model: this.model.ref(),
            };
        };
        return RootRemovedEvent;
    }(DocumentChangedEvent));
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./types */;
    var object_1 = require(128) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return types_1.isObject(obj) && obj[exports.pretty] !== undefined;
    }
    var Printer = /** @class */ (function () {
        function Printer(options) {
            this.visited = new Set();
            this.precision = options === null || options === void 0 ? void 0 : options.precision;
        }
        Printer.prototype.to_string = function (obj) {
            if (types_1.isObject(obj)) {
                if (this.visited.has(obj))
                    return "<circular>";
                else
                    this.visited.add(obj);
            }
            if (is_Printable(obj))
                return obj[exports.pretty](this);
            else if (types_1.isBoolean(obj))
                return this.boolean(obj);
            else if (types_1.isNumber(obj))
                return this.number(obj);
            else if (types_1.isString(obj))
                return this.string(obj);
            else if (types_1.isArray(obj))
                return this.array(obj);
            else if (types_1.isIterable(obj))
                return this.iterable(obj);
            else if (types_1.isPlainObject(obj))
                return this.object(obj);
            else
                return "" + obj;
        };
        Printer.prototype.token = function (val) {
            return val;
        };
        Printer.prototype.boolean = function (val) {
            return "" + val;
        };
        Printer.prototype.number = function (val) {
            if (this.precision != null)
                return val.toFixed(this.precision);
            else
                return "" + val;
        };
        Printer.prototype.string = function (val) {
            return "\"" + val.replace(/'/g, "\\'") + "\""; // lgtm [js/incomplete-sanitization]
        };
        Printer.prototype.array = function (obj) {
            var e_1, _a;
            var T = this.token;
            var items = [];
            try {
                for (var obj_1 = tslib_1.__values(obj), obj_1_1 = obj_1.next(); !obj_1_1.done; obj_1_1 = obj_1.next()) {
                    var entry = obj_1_1.value;
                    items.push(this.to_string(entry));
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (obj_1_1 && !obj_1_1.done && (_a = obj_1.return))
                        _a.call(obj_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return "" + T("[") + items.join(T(",") + " ") + T("]");
        };
        Printer.prototype.iterable = function (obj) {
            var _a;
            var T = this.token;
            var tag = (_a = Object(obj)[Symbol.toStringTag]) !== null && _a !== void 0 ? _a : "Object";
            var items = this.array(obj);
            return "" + tag + T("(") + items + T(")");
        };
        Printer.prototype.object = function (obj) {
            var e_2, _a;
            var T = this.token;
            var items = [];
            try {
                for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), key = _d[0], val = _d[1];
                    items.push("" + key + T(":") + " " + this.to_string(val));
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return "" + T("{") + items.join(T(",") + " ") + T("}");
        };
        return Printer;
    }());
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        var printer = new Printer(options);
        return printer.to_string(obj);
    }
    exports.to_string = to_string;
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var object_1 = require(128) /* ./object */;
    var types_1 = require(123) /* ./types */;
    //| Map<CloneableType, CloneableType>
    //| Set<CloneableType>
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return types_1.isObject(obj) && obj[exports.clone] !== undefined;
    }
    exports.is_Cloneable = is_Cloneable;
    var CloningError = /** @class */ (function (_super) {
        tslib_1.__extends(CloningError, _super);
        function CloningError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CloningError;
    }(Error));
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    var Cloner = /** @class */ (function () {
        function Cloner() {
        }
        Cloner.prototype.clone = function (obj) {
            var e_1, _a;
            if (is_Cloneable(obj))
                return obj[exports.clone](this);
            else if (types_1.isArray(obj)) {
                var n = obj.length;
                var result = new Array(n);
                for (var i = 0; i < n; i++) {
                    var value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], value = _d[1];
                        result[key] = this.clone(value);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new CloningError(Object.prototype.toString.call(obj) + " is not cloneable");
        };
        return Cloner;
    }());
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(154) /* ./annotations */, exports);
    tslib_1.__exportStar(require(240) /* ./axes */, exports);
    tslib_1.__exportStar(require(354) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(358) /* ./canvas */, exports);
    tslib_1.__exportStar(require(373) /* ./expressions */, exports);
    tslib_1.__exportStar(require(382) /* ./filters */, exports);
    tslib_1.__exportStar(require(303) /* ./formatters */, exports);
    tslib_1.__exportStar(require(387) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(424) /* ./graphs */, exports);
    tslib_1.__exportStar(require(428) /* ./grids */, exports);
    tslib_1.__exportStar(require(430) /* ./layouts */, exports);
    tslib_1.__exportStar(require(307) /* ./mappers */, exports);
    tslib_1.__exportStar(require(443) /* ./transforms */, exports);
    tslib_1.__exportStar(require(451) /* ./plots */, exports);
    tslib_1.__exportStar(require(459) /* ./policies */, exports);
    tslib_1.__exportStar(require(317) /* ./ranges */, exports);
    tslib_1.__exportStar(require(460) /* ./renderers */, exports);
    tslib_1.__exportStar(require(315) /* ./scales */, exports);
    tslib_1.__exportStar(require(462) /* ./selections */, exports);
    tslib_1.__exportStar(require(463) /* ./sources */, exports);
    tslib_1.__exportStar(require(276) /* ./tickers */, exports);
    tslib_1.__exportStar(require(468) /* ./tiles */, exports);
    tslib_1.__exportStar(require(478) /* ./textures */, exports);
    tslib_1.__exportStar(require(482) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var annotation_1 = require(155) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(183) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(227) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(227) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(227) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(227) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(227) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var band_1 = require(229) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(231) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    var color_bar_1 = require(232) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var label_1 = require(323) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(324) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(325) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(326) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(328) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var slope_1 = require(329) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(330) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(234) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(233) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(331) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var tooltip_1 = require(351) /* ./tooltip */;
    __esExport("Tooltip", tooltip_1.Tooltip);
    var whisker_1 = require(353) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var renderer_1 = require(156) /* ../renderers/renderer */;
    var AnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(AnnotationView, _super);
        function AnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnotationView.prototype.get_size = function () {
            if (this.model.visible) {
                var _a = this._get_size(), width = _a.width, height = _a.height;
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        };
        AnnotationView.prototype._get_size = function () {
            throw new Error("not implemented");
        };
        AnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var p = this.model.properties;
            this.on_change(p.visible, function () {
                if (_this.layout != null) {
                    _this.layout.visible = _this.model.visible;
                    _this.plot_view.request_layout();
                }
            });
        };
        Object.defineProperty(AnnotationView.prototype, "needs_clip", {
            get: function () {
                return this.layout == null; // TODO: change this, when center layout is fully implemented
            },
            enumerable: false,
            configurable: true
        });
        AnnotationView.prototype.serializable_state = function () {
            var state = _super.prototype.serializable_state.call(this);
            return this.layout == null ? state : tslib_1.__assign(tslib_1.__assign({}, state), { bbox: this.layout.bbox.box });
        };
        return AnnotationView;
    }(renderer_1.RendererView));
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    var Annotation = /** @class */ (function (_super) {
        tslib_1.__extends(Annotation, _super);
        function Annotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        Annotation.init_Annotation = function () {
            this.override({
                level: "annotation",
            });
        };
        return Annotation;
    }(renderer_1.Renderer));
    exports.Annotation = Annotation;
    Annotation.__name__ = "Annotation";
    Annotation.init_Annotation();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var view_1 = require(157) /* ../../core/view */;
    var visuals = tslib_1.__importStar(require(160) /* ../../core/visuals */);
    var enums_1 = require(135) /* ../../core/enums */;
    var model_1 = require(168) /* ../../model */;
    var coordinates_1 = require(169) /* ../canvas/coordinates */;
    var RendererGroup = /** @class */ (function (_super) {
        tslib_1.__extends(RendererGroup, _super);
        function RendererGroup(attrs) {
            return _super.call(this, attrs) || this;
        }
        RendererGroup.init_RendererGroup = function () {
            this.define(function (_a) {
                var Boolean = _a.Boolean;
                return ({
                    visible: [Boolean, true],
                });
            });
        };
        return RendererGroup;
    }(model_1.Model));
    exports.RendererGroup = RendererGroup;
    RendererGroup.__name__ = "RendererGroup";
    RendererGroup.init_RendererGroup();
    var RendererView = /** @class */ (function (_super) {
        tslib_1.__extends(RendererView, _super);
        function RendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(RendererView.prototype, "coordinates", {
            get: function () {
                var _coordinates = this._coordinates;
                if (_coordinates != null)
                    return _coordinates;
                else
                    return this._coordinates = this._initialize_coordinates();
            },
            enumerable: false,
            configurable: true
        });
        RendererView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this);
            this.needs_webgl_blit = false;
        };
        RendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var _a = this.model.properties, x_range_name = _a.x_range_name, y_range_name = _a.y_range_name;
            this.on_change([x_range_name, y_range_name], function () { return _this._initialize_coordinates(); });
            var group = this.model.group;
            if (group != null) {
                this.on_change(group.properties.visible, function () {
                    _this.model.visible = group.visible;
                });
            }
        };
        RendererView.prototype._initialize_coordinates = function () {
            var coordinates = this.model.coordinates;
            var frame = this.plot_view.frame;
            if (coordinates != null) {
                return coordinates.get_transform(frame);
            }
            else {
                var _a = this.model, x_range_name = _a.x_range_name, y_range_name = _a.y_range_name;
                var x_scale = frame.x_scales.get(x_range_name);
                var y_scale = frame.y_scales.get(y_range_name);
                return new coordinates_1.CoordinateTransform(x_scale, y_scale);
            }
        };
        Object.defineProperty(RendererView.prototype, "plot_view", {
            get: function () {
                return this.parent;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "plot_model", {
            get: function () {
                return this.parent.model;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "layer", {
            get: function () {
                var _a = this.canvas, overlays = _a.overlays, primary = _a.primary;
                return this.model.level == "overlay" ? overlays : primary;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "canvas", {
            get: function () {
                return this.plot_view.canvas_view;
            },
            enumerable: false,
            configurable: true
        });
        RendererView.prototype.request_render = function () {
            this.request_paint();
        };
        RendererView.prototype.request_paint = function () {
            this.plot_view.request_paint(this);
        };
        RendererView.prototype.notify_finished = function () {
            this.plot_view.notify_finished();
        };
        Object.defineProperty(RendererView.prototype, "needs_clip", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "has_webgl", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        /*
        get visible(): boolean {
          const {visible, group} = this.model
          return !visible ? false : (group?.visible ?? true)
        }
        */
        RendererView.prototype.render = function () {
            if (this.model.visible) {
                this._render();
            }
            this._has_finished = true;
        };
        RendererView.prototype.renderer_view = function (_renderer) {
            return undefined;
        };
        return RendererView;
    }(view_1.View));
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    var Renderer = /** @class */ (function (_super) {
        tslib_1.__extends(Renderer, _super);
        function Renderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        Renderer.init_Renderer = function () {
            this.define(function (_a) {
                var Boolean = _a.Boolean, String = _a.String, Ref = _a.Ref, Nullable = _a.Nullable;
                return ({
                    group: [Nullable(Ref(RendererGroup)), null],
                    level: [enums_1.RenderLevel, "image"],
                    visible: [Boolean, true],
                    x_range_name: [String, "default"],
                    y_range_name: [String, "default"],
                    coordinates: [Nullable(Ref(coordinates_1.CoordinateMapping)), null],
                });
            });
        };
        return Renderer;
    }(model_1.Model));
    exports.Renderer = Renderer;
    Renderer.__name__ = "Renderer";
    Renderer.init_Renderer();
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var dom_1 = require(158) /* ./dom */;
    var types_1 = require(123) /* ./util/types */;
    var root_css_1 = tslib_1.__importDefault(require(159) /* ../styles/root.css */);
    var View = /** @class */ (function () {
        function View(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            this._idle_notified = false;
            var model = options.model, parent = options.parent;
            this.model = model;
            this.parent = parent;
            this.root = parent == null ? this : parent.root;
            this.removed.emit();
        }
        Object.defineProperty(View.prototype, "ready", {
            get: function () {
                return this._ready;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.connect = function (signal, slot) {
            var _this = this;
            var new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = function (args, sender) {
                    var promise = Promise.resolve(slot.call(_this, args, sender));
                    _this._ready = _this._ready.then(function () { return promise; });
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        };
        View.prototype.disconnect = function (signal, slot) {
            return signal.disconnect(slot, this);
        };
        View.prototype.initialize = function () {
            var e_1, _a;
            this._has_finished = false;
            if (this.is_root) {
                this._stylesheet = dom_1.stylesheet;
            }
            try {
                for (var _b = tslib_1.__values(this.styles()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var style = _c.value;
                    this.stylesheet.append(style);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        View.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                return tslib_1.__generator(this, function (_a) {
                    return [2 /*return*/];
                });
            });
        };
        View.prototype.remove = function () {
            this.disconnect_signals();
            this.removed.emit();
        };
        View.prototype.toString = function () {
            return this.model.type + "View(" + this.model.id + ")";
        };
        View.prototype.serializable_state = function () {
            return { type: this.model.type };
        };
        Object.defineProperty(View.prototype, "is_root", {
            get: function () {
                return this.parent == null;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.has_finished = function () {
            return this._has_finished;
        };
        Object.defineProperty(View.prototype, "is_idle", {
            get: function () {
                return this.has_finished();
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.connect_signals = function () { };
        View.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnect_receiver(this);
        };
        View.prototype.on_change = function (properties, fn) {
            var e_2, _a;
            try {
                for (var _b = tslib_1.__values(types_1.isArray(properties) ? properties : [properties]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var property = _c.value;
                    this.connect(property.change, fn);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        View.prototype.cursor = function (_sx, _sy) {
            return null;
        };
        Object.defineProperty(View.prototype, "stylesheet", {
            get: function () {
                if (this.is_root)
                    return this._stylesheet;
                else
                    return this.root.stylesheet;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.styles = function () {
            return [root_css_1.default];
        };
        View.prototype.notify_finished = function () {
            if (!this.is_root)
                this.root.notify_finished();
            else {
                if (!this._idle_notified && this.has_finished()) {
                    if (this.model.document != null) {
                        this._idle_notified = true;
                        this.model.document.notify_idle(this.model);
                    }
                }
            }
        };
        return View;
    }());
    exports.View = View;
    View.__name__ = "View";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./util/types */;
    var object_1 = require(128) /* ./util/object */;
    var _createElement = function (tag) {
        return function (attrs) {
            var e_1, _a, e_2, _b, e_3, _c, e_4, _d, e_5, _e, e_6, _f;
            if (attrs === void 0) {
                attrs = {};
            }
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var element = document.createElement(tag);
            element.classList.add("bk");
            if (!types_1.isPlainObject(attrs)) {
                children = tslib_1.__spreadArray([attrs], tslib_1.__read(children));
                attrs = {};
            }
            try {
                for (var _g = tslib_1.__values(object_1.entries(attrs)), _h = _g.next(); !_h.done; _h = _g.next()) {
                    var _j = tslib_1.__read(_h.value, 2), attr = _j[0], value = _j[1];
                    if (value == null || types_1.isBoolean(value) && !value)
                        continue;
                    if (attr === "class") {
                        if (types_1.isString(value))
                            value = value.split(/\s+/);
                        if (types_1.isArray(value)) {
                            try {
                                for (var value_1 = (e_2 = void 0, tslib_1.__values(value)), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
                                    var cls = value_1_1.value;
                                    if (cls != null)
                                        element.classList.add(cls);
                                }
                            }
                            catch (e_2_1) {
                                e_2 = { error: e_2_1 };
                            }
                            finally {
                                try {
                                    if (value_1_1 && !value_1_1.done && (_b = value_1.return))
                                        _b.call(value_1);
                                }
                                finally {
                                    if (e_2)
                                        throw e_2.error;
                                }
                            }
                            continue;
                        }
                    }
                    if (attr === "style" && types_1.isPlainObject(value)) {
                        try {
                            for (var _k = (e_3 = void 0, tslib_1.__values(object_1.entries(value))), _l = _k.next(); !_l.done; _l = _k.next()) {
                                var _m = tslib_1.__read(_l.value, 2), prop = _m[0], data = _m[1];
                                element.style[prop] = data;
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (_l && !_l.done && (_c = _k.return))
                                    _c.call(_k);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                        continue;
                    }
                    if (attr === "data" && types_1.isPlainObject(value)) {
                        try {
                            for (var _o = (e_4 = void 0, tslib_1.__values(object_1.entries(value))), _p = _o.next(); !_p.done; _p = _o.next()) {
                                var _q = tslib_1.__read(_p.value, 2), key = _q[0], data = _q[1];
                                element.dataset[key] = data; // XXX: attrs needs a better type
                            }
                        }
                        catch (e_4_1) {
                            e_4 = { error: e_4_1 };
                        }
                        finally {
                            try {
                                if (_p && !_p.done && (_d = _o.return))
                                    _d.call(_o);
                            }
                            finally {
                                if (e_4)
                                    throw e_4.error;
                            }
                        }
                        continue;
                    }
                    element.setAttribute(attr, value);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_h && !_h.done && (_a = _g.return))
                        _a.call(_g);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            function append(child) {
                var e_7, _a;
                if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child instanceof Node)
                    element.appendChild(child);
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    try {
                        for (var child_2 = tslib_1.__values(child), child_2_1 = child_2.next(); !child_2_1.done; child_2_1 = child_2.next()) {
                            var el = child_2_1.value;
                            element.appendChild(el);
                        }
                    }
                    catch (e_7_1) {
                        e_7 = { error: e_7_1 };
                    }
                    finally {
                        try {
                            if (child_2_1 && !child_2_1.done && (_a = child_2.return))
                                _a.call(child_2);
                        }
                        finally {
                            if (e_7)
                                throw e_7.error;
                        }
                    }
                }
                else if (child != null && child !== false)
                    throw new Error("expected a DOM element, string, false or null, got " + JSON.stringify(child));
            }
            try {
                for (var children_1 = tslib_1.__values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                    var child = children_1_1.value;
                    if (types_1.isArray(child)) {
                        try {
                            for (var child_1 = (e_6 = void 0, tslib_1.__values(child)), child_1_1 = child_1.next(); !child_1_1.done; child_1_1 = child_1.next()) {
                                var _child = child_1_1.value;
                                append(_child);
                            }
                        }
                        catch (e_6_1) {
                            e_6 = { error: e_6_1 };
                        }
                        finally {
                            try {
                                if (child_1_1 && !child_1_1.done && (_f = child_1.return))
                                    _f.call(child_1);
                            }
                            finally {
                                if (e_6)
                                    throw e_6.error;
                            }
                        }
                    }
                    else
                        append(child);
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (children_1_1 && !children_1_1.done && (_e = children_1.return))
                        _e.call(children_1);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return element;
        };
    };
    function createElement(tag, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        return _createElement(tag).apply(void 0, tslib_1.__spreadArray([attrs], tslib_1.__read(children)));
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function nbsp() {
        return document.createTextNode("\u00a0");
    }
    exports.nbsp = nbsp;
    function append(element) {
        var e_8, _a;
        var children = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            children[_i - 1] = arguments[_i];
        }
        try {
            for (var children_2 = tslib_1.__values(children), children_2_1 = children_2.next(); !children_2_1.done; children_2_1 = children_2.next()) {
                var child = children_2_1.value;
                element.appendChild(child);
            }
        }
        catch (e_8_1) {
            e_8 = { error: e_8_1 };
        }
        finally {
            try {
                if (children_2_1 && !children_2_1.done && (_a = children_2.return))
                    _a.call(children_2);
            }
            finally {
                if (e_8)
                    throw e_8.error;
            }
        }
    }
    exports.append = append;
    function remove(element) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.remove = remove;
    exports.removeElement = remove;
    function replaceWith(element, replacement) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element) {
        var e_9, _a;
        var nodes = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
        }
        var first = element.firstChild;
        try {
            for (var nodes_1 = tslib_1.__values(nodes), nodes_1_1 = nodes_1.next(); !nodes_1_1.done; nodes_1_1 = nodes_1.next()) {
                var node = nodes_1_1.value;
                element.insertBefore(node, first);
            }
        }
        catch (e_9_1) {
            e_9 = { error: e_9_1 };
        }
        finally {
            try {
                if (nodes_1_1 && !nodes_1_1.done && (_a = nodes_1.return))
                    _a.call(nodes_1);
            }
            finally {
                if (e_9)
                    throw e_9.error;
            }
        }
    }
    exports.prepend = prepend;
    function empty(node, attrs) {
        var e_10, _a;
        if (attrs === void 0) {
            attrs = false;
        }
        var child;
        while (child = node.firstChild) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            try {
                for (var _b = tslib_1.__values(node.attributes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    node.removeAttributeNode(attr);
                }
            }
            catch (e_10_1) {
                e_10 = { error: e_10_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_10)
                        throw e_10.error;
                }
            }
        }
    }
    exports.empty = empty;
    function display(element) {
        element.style.display = "";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset(element) {
        var rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var _a, _b, _c;
        var p = Element.prototype;
        var f = (_c = (_b = (_a = p.matches) !== null && _a !== void 0 ? _a : p.webkitMatchesSelector) !== null && _b !== void 0 ? _b : p.mozMatchesSelector) !== null && _c !== void 0 ? _c : p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        var node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        var style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        var rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        var _a = extents(el).margin, left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
        var _b = size(el), width = _b.width, height = _b.height;
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        var e_11, _a;
        var _b = el.getBoundingClientRect(), left = _b.left, top = _b.top;
        var padding = extents(el).padding;
        var width = 0;
        var height = 0;
        try {
            for (var _c = tslib_1.__values(el.children), _d = _c.next(); !_d.done; _d = _c.next()) {
                var child = _d.value;
                var rect = child.getBoundingClientRect();
                width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
                height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
            }
        }
        catch (e_11_1) {
            e_11 = { error: e_11_1 };
        }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return))
                    _a.call(_c);
            }
            finally {
                if (e_11)
                    throw e_11.error;
            }
        }
        return { width: width, height: height };
    }
    exports.content_size = content_size;
    function position(el, box, margin) {
        var style = el.style;
        style.left = box.x + "px";
        style.top = box.y + "px";
        style.width = box.width + "px";
        style.height = box.height + "px";
        if (margin == null)
            style.margin = "";
        else {
            var top = margin.top, right = margin.right, bottom = margin.bottom, left = margin.left;
            style.margin = top + "px " + right + "px " + bottom + "px " + left + "px";
        }
    }
    exports.position = position;
    function children(el) {
        return Array.from(el.children);
    }
    exports.children = children;
    var ClassList = /** @class */ (function () {
        function ClassList(el) {
            this.el = el;
            this.classList = el.classList;
        }
        Object.defineProperty(ClassList.prototype, "values", {
            get: function () {
                var values = [];
                for (var i_1 = 0; i_1 < this.classList.length; i_1++) {
                    var item = this.classList.item(i_1);
                    if (item != null)
                        values.push(item);
                }
                return values;
            },
            enumerable: false,
            configurable: true
        });
        ClassList.prototype.has = function (cls) {
            return this.classList.contains(cls);
        };
        ClassList.prototype.add = function () {
            var e_12, _a;
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            try {
                for (var classes_1 = tslib_1.__values(classes), classes_1_1 = classes_1.next(); !classes_1_1.done; classes_1_1 = classes_1.next()) {
                    var cls = classes_1_1.value;
                    this.classList.add(cls);
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (classes_1_1 && !classes_1_1.done && (_a = classes_1.return))
                        _a.call(classes_1);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
            return this;
        };
        ClassList.prototype.remove = function () {
            var e_13, _a;
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            try {
                for (var classes_2 = tslib_1.__values(classes), classes_2_1 = classes_2.next(); !classes_2_1.done; classes_2_1 = classes_2.next()) {
                    var cls = classes_2_1.value;
                    this.classList.remove(cls);
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (classes_2_1 && !classes_2_1.done && (_a = classes_2.return))
                        _a.call(classes_2);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            return this;
        };
        ClassList.prototype.clear = function () {
            var e_14, _a;
            try {
                for (var _b = tslib_1.__values(this.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var cls = _c.value;
                    if (cls != "bk")
                        this.classList.remove(cls);
                }
            }
            catch (e_14_1) {
                e_14 = { error: e_14_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_14)
                        throw e_14.error;
                }
            }
            return this;
        };
        ClassList.prototype.toggle = function (cls, activate) {
            var add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        };
        return ClassList;
    }());
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el);
    }
    exports.classes = classes;
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state)
            el.setAttribute(attr, "true");
        else
            el.removeAttribute(attr);
    }
    exports.toggle_attribute = toggle_attribute;
    (function (Keys) {
        Keys[Keys["Backspace"] = 8] = "Backspace";
        Keys[Keys["Tab"] = 9] = "Tab";
        Keys[Keys["Enter"] = 13] = "Enter";
        Keys[Keys["Esc"] = 27] = "Esc";
        Keys[Keys["PageUp"] = 33] = "PageUp";
        Keys[Keys["PageDown"] = 34] = "PageDown";
        Keys[Keys["Left"] = 37] = "Left";
        Keys[Keys["Up"] = 38] = "Up";
        Keys[Keys["Right"] = 39] = "Right";
        Keys[Keys["Down"] = 40] = "Down";
        Keys[Keys["Delete"] = 46] = "Delete";
    })(exports.Keys || (exports.Keys = {}));
    function undisplayed(el, fn) {
        var display = el.style.display;
        el.style.display = "none";
        try {
            return fn();
        }
        finally {
            el.style.display = display;
        }
    }
    exports.undisplayed = undisplayed;
    function unsized(el, fn) {
        return sized(el, {}, fn);
    }
    exports.unsized = unsized;
    function sized(el, size, fn) {
        var _a = el.style, width = _a.width, height = _a.height, position = _a.position, display = _a.display;
        el.style.position = "absolute";
        el.style.display = "";
        el.style.width = size.width != null && size.width != Infinity ? size.width + "px" : "auto";
        el.style.height = size.height != null && size.height != Infinity ? size.height + "px" : "auto";
        try {
            return fn();
        }
        finally {
            el.style.position = position;
            el.style.display = display;
            el.style.width = width;
            el.style.height = height;
        }
    }
    exports.sized = sized;
    var StyleSheet = /** @class */ (function () {
        function StyleSheet(root) {
            this.root = root;
            this.known = new Set();
            this.style = exports.style({ type: "text/css" });
            prepend(root, this.style);
        }
        StyleSheet.prototype.append = function (css) {
            if (!this.known.has(css)) {
                this.style.appendChild(document.createTextNode(css));
                this.known.add(css);
            }
        };
        return StyleSheet;
    }());
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    exports.stylesheet = new StyleSheet(document.head);
    function dom_ready() {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                if (document.readyState == "loading") {
                    return [2 /*return*/, new Promise(function (resolve, _reject) {
                            document.addEventListener("DOMContentLoaded", function () { return resolve(); }, { once: true });
                        })];
                }
                return [2 /*return*/];
            });
        });
    }
    exports.dom_ready = dom_ready;
},
/* styles/root.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.root = "bk-root";
    exports.default = ".bk-root{position:relative;width:auto;height:auto;z-index:0;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}";
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var line_1 = require(161) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    var fill_1 = require(164) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    var text_1 = require(165) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    var hatch_1 = require(166) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var visual_1 = require(162) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    var Visuals = /** @class */ (function () {
        function Visuals(view) {
            var e_1, _a;
            this._visuals = [];
            var _loop_1 = function (prefix, mixin) {
                var visual = (function () {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                this_1._visuals.push(visual);
                Object.defineProperty(this_1, prefix + visual.type, {
                    get: function () { return visual; },
                    configurable: false,
                    enumerable: true,
                });
            };
            var this_1 = this;
            try {
                for (var _b = tslib_1.__values(view.model._mixins), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), prefix = _d[0], mixin = _d[1];
                    _loop_1(prefix, mixin);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        }
        Visuals.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this._visuals)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        return Visuals;
    }());
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var types_1 = require(123) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if (types_1.isArray(line_dash))
            return line_dash;
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    exports.resolve_line_dash = resolve_line_dash;
    var Line = /** @class */ (function (_super) {
        tslib_1.__extends(Line, _super);
        function Line() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Line.prototype, "doit", {
            get: function () {
                var color = this.line_color.get_value();
                var alpha = this.line_alpha.get_value();
                var width = this.line_width.get_value();
                return !(color == null || alpha == 0 || width == 0);
            },
            enumerable: false,
            configurable: true
        });
        Line.prototype.apply = function (ctx) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        };
        Line.prototype.set_value = function (ctx) {
            var color = this.line_color.get_value();
            var alpha = this.line_alpha.get_value();
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = this.line_width.get_value();
            ctx.lineJoin = this.line_join.get_value();
            ctx.lineCap = this.line_cap.get_value();
            ctx.lineDash = resolve_line_dash(this.line_dash.get_value());
            ctx.lineDashOffset = this.line_dash_offset.get_value();
        };
        return Line;
    }(visual_1.VisualProperties));
    exports.Line = Line;
    Line.__name__ = "Line";
    var LineScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineScalar, _super);
        function LineScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LineScalar.prototype, "doit", {
            get: function () {
                var color = this.line_color.value;
                var alpha = this.line_alpha.value;
                var width = this.line_width.value;
                return !(color == 0 || alpha == 0 || width == 0);
            },
            enumerable: false,
            configurable: true
        });
        LineScalar.prototype.apply = function (ctx) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        };
        LineScalar.prototype.set_value = function (ctx) {
            var color = this.line_color.value;
            var alpha = this.line_alpha.value;
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.lineDash = resolve_line_dash(this.line_dash.value);
            ctx.lineDashOffset = this.line_dash_offset.value;
        };
        return LineScalar;
    }(visual_1.VisualUniforms));
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    var LineVector = /** @class */ (function (_super) {
        tslib_1.__extends(LineVector, _super);
        function LineVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LineVector.prototype, "doit", {
            get: function () {
                var line_color = this.line_color;
                if (line_color.is_Scalar() && line_color.value == 0)
                    return false;
                var line_alpha = this.line_alpha;
                if (line_alpha.is_Scalar() && line_alpha.value == 0)
                    return false;
                var line_width = this.line_width;
                if (line_width.is_Scalar() && line_width.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        LineVector.prototype.apply = function (ctx, i) {
            var doit = this.doit;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.stroke();
            }
            return doit;
        };
        LineVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.line_color.get(i);
            var alpha = this.line_alpha.get(i);
            var width = this.line_width.get(i);
            var join = this.line_join.get(i);
            var cap = this.line_cap.get(i);
            var dash = this.line_dash.get(i);
            var offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.lineDash = resolve_line_dash(dash);
            ctx.lineDashOffset = offset;
        };
        return LineVector;
    }(visual_1.VisualUniforms));
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var VisualProperties = /** @class */ (function () {
        function VisualProperties(obj, prefix) {
            var e_1, _a;
            var _this = this;
            if (prefix === void 0) {
                prefix = "";
            }
            this.obj = obj;
            this.prefix = prefix;
            var self = this;
            this._props = [];
            try {
                for (var _b = tslib_1.__values(this.attrs), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    var prop = obj.model.properties[prefix + attr];
                    prop.change.connect(function () { return _this.update(); });
                    self[attr] = prop;
                    this._props.push(prop);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.update();
        }
        VisualProperties.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this._props)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        VisualProperties.prototype.update = function () { };
        return VisualProperties;
    }());
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    var VisualUniforms = /** @class */ (function () {
        function VisualUniforms(obj, prefix) {
            var e_2, _a;
            if (prefix === void 0) {
                prefix = "";
            }
            this.obj = obj;
            this.prefix = prefix;
            var _loop_1 = function (attr) {
                Object.defineProperty(this_1, attr, {
                    get: function () {
                        return obj[prefix + attr];
                    },
                });
            };
            var this_1 = this;
            try {
                for (var _b = tslib_1.__values(this.attrs), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    _loop_1(attr);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        }
        VisualUniforms.prototype[Symbol.iterator] = function () {
            var _a, _b, attr, e_3_1;
            var e_3, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 5, 6, 7]);
                        _a = tslib_1.__values(this.attrs), _b = _a.next();
                        _d.label = 1;
                    case 1:
                        if (!!_b.done)
                            return [3 /*break*/, 4];
                        attr = _b.value;
                        return [4 /*yield*/, this.obj.model.properties[this.prefix + attr]];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 4: return [3 /*break*/, 7];
                    case 5:
                        e_3_1 = _d.sent();
                        e_3 = { error: e_3_1 };
                        return [3 /*break*/, 7];
                    case 6:
                        try {
                            if (_b && !_b.done && (_c = _a.return))
                                _c.call(_a);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/];
                }
            });
        };
        VisualUniforms.prototype.update = function () { };
        return VisualUniforms;
    }());
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var p = tslib_1.__importStar(require(133) /* ./properties */);
    var enums_1 = require(135) /* ./enums */;
    var k = tslib_1.__importStar(require(136) /* ./kinds */);
    var object_1 = require(128) /* ./util/object */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Number, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Number)), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Number, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.String)), null],
        hatch_weight: [k.Number, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}], // XXX: recursive imports
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, prefixed) {
        var e_1, _a;
        if (prefixed === void 0) {
            prefixed = false;
        }
        var attrs = {};
        try {
            for (var _b = tslib_1.__values(object_1.keys(mixin)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var attr = _c.value;
                var prefixed_attr = "" + prefix + attr;
                var value = model[prefixed_attr];
                attrs[prefixed ? prefixed_attr : attr] = value;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return attrs;
    }
    exports.attrs_of = attrs_of;
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var Fill = /** @class */ (function (_super) {
        tslib_1.__extends(Fill, _super);
        function Fill() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Fill.prototype, "doit", {
            get: function () {
                var color = this.fill_color.get_value();
                var alpha = this.fill_alpha.get_value();
                return !(color == null || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        Fill.prototype.apply = function (ctx, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        };
        Fill.prototype.set_value = function (ctx) {
            var color = this.fill_color.get_value();
            var alpha = this.fill_alpha.get_value();
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return Fill;
    }(visual_1.VisualProperties));
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    var FillScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FillScalar, _super);
        function FillScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FillScalar.prototype, "doit", {
            get: function () {
                var color = this.fill_color.value;
                var alpha = this.fill_alpha.value;
                return !(color == 0 || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        FillScalar.prototype.apply = function (ctx, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        };
        FillScalar.prototype.set_value = function (ctx) {
            var color = this.fill_color.value;
            var alpha = this.fill_alpha.value;
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return FillScalar;
    }(visual_1.VisualUniforms));
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    var FillVector = /** @class */ (function (_super) {
        tslib_1.__extends(FillVector, _super);
        function FillVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FillVector.prototype, "doit", {
            get: function () {
                var fill_color = this.fill_color;
                if (fill_color.is_Scalar() && fill_color.value == 0)
                    return false;
                var fill_alpha = this.fill_alpha;
                if (fill_alpha.is_Scalar() && fill_alpha.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        FillVector.prototype.apply = function (ctx, i, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.fill(rule);
            }
            return doit;
        };
        FillVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.fill_color.get(i);
            var alpha = this.fill_alpha.get(i);
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return FillVector;
    }(visual_1.VisualUniforms));
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var Text = /** @class */ (function (_super) {
        tslib_1.__extends(Text, _super);
        function Text() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Text.prototype, "doit", {
            get: function () {
                var color = this.text_color.get_value();
                var alpha = this.text_alpha.get_value();
                return !(color == null || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        Text.prototype.set_value = function (ctx) {
            var color = this.text_color.get_value();
            var alpha = this.text_alpha.get_value();
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = this.font_value();
            ctx.textAlign = this.text_align.get_value();
            ctx.textBaseline = this.text_baseline.get_value();
        };
        Text.prototype.font_value = function () {
            var style = this.text_font_style.get_value();
            var size = this.text_font_size.get_value();
            var face = this.text_font.get_value();
            return style + " " + size + " " + face;
        };
        return Text;
    }(visual_1.VisualProperties));
    exports.Text = Text;
    Text.__name__ = "Text";
    var TextScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextScalar, _super);
        function TextScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(TextScalar.prototype, "doit", {
            get: function () {
                var color = this.text_color.value;
                var alpha = this.text_alpha.value;
                return !(color == 0 || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        TextScalar.prototype.set_value = function (ctx) {
            var color = this.text_color.value;
            var alpha = this.text_alpha.value;
            var font = this.font_value();
            var align = this.text_align.value;
            var baseline = this.text_baseline.value;
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        };
        TextScalar.prototype.font_value = function () {
            var style = this.text_font_style.value;
            var size = this.text_font_size.value;
            var face = this.text_font.value;
            return style + " " + size + " " + face;
        };
        return TextScalar;
    }(visual_1.VisualUniforms));
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    var TextVector = /** @class */ (function (_super) {
        tslib_1.__extends(TextVector, _super);
        function TextVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(TextVector.prototype, "doit", {
            get: function () {
                var text_color = this.text_color;
                if (text_color.is_Scalar() && text_color.value == 0)
                    return false;
                var text_alpha = this.text_alpha;
                if (text_alpha.is_Scalar() && text_alpha.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        TextVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.text_color.get(i);
            var alpha = this.text_alpha.get(i);
            var font = this.font_value(i);
            var align = this.text_align.get(i);
            var baseline = this.text_baseline.get(i);
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        };
        TextVector.prototype.font_value = function (i) {
            var style = this.text_font_style.get(i);
            var size = this.text_font_size.get(i);
            var face = this.text_font.get(i);
            return style + " " + size + " " + face;
        };
        return TextVector;
    }(visual_1.VisualUniforms));
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var patterns_1 = require(167) /* ./patterns */;
    var p = tslib_1.__importStar(require(133) /* ../properties */);
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var Hatch = /** @class */ (function (_super) {
        tslib_1.__extends(Hatch, _super);
        function Hatch() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this._update_iteration = 0;
            return _this;
        }
        Hatch.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit)
                return;
            var color = this.hatch_color.get_value();
            var alpha = this.hatch_alpha.get_value();
            var scale = this.hatch_scale.get_value();
            var pattern = this.hatch_pattern.get_value();
            var weight = this.hatch_weight.get_value();
            var finalize = function (image) {
                _this._hatch_image = image;
            };
            var textures = this.hatch_extra.get_value();
            var texture = textures[pattern];
            if (texture != null) {
                var image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    var _update_iteration_1 = this._update_iteration;
                    image.then(function (image) {
                        if (_this._update_iteration == _update_iteration_1) {
                            finalize(image);
                            _this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                var layer = this.obj.canvas.create_layer();
                var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        };
        Object.defineProperty(Hatch.prototype, "doit", {
            get: function () {
                var color = this.hatch_color.get_value();
                var alpha = this.hatch_alpha.get_value();
                var pattern = this.hatch_pattern.get_value();
                return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
            },
            enumerable: false,
            configurable: true
        });
        Hatch.prototype.apply = function (ctx, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(function () { return ctx.fill(rule); });
            }
            return doit;
        };
        Hatch.prototype.set_value = function (ctx) {
            var pattern = this.pattern(ctx);
            ctx.fillStyle = pattern !== null && pattern !== void 0 ? pattern : "transparent";
        };
        Hatch.prototype.pattern = function (ctx) {
            var image = this._hatch_image;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        };
        Hatch.prototype.repetition = function () {
            var pattern = this.hatch_pattern.get_value();
            var texture = this.hatch_extra.get_value()[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return Hatch;
    }(visual_1.VisualProperties));
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    var HatchScalar = /** @class */ (function (_super) {
        tslib_1.__extends(HatchScalar, _super);
        function HatchScalar() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this._static_doit = false;
            _this._update_iteration = 0;
            return _this;
        }
        HatchScalar.prototype._compute_static_doit = function () {
            var color = this.hatch_color.value;
            var alpha = this.hatch_alpha.value;
            var pattern = this.hatch_pattern.value;
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        };
        HatchScalar.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            var n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            var color = this.hatch_color.value;
            var alpha = this.hatch_alpha.value;
            var scale = this.hatch_scale.value;
            var pattern = this.hatch_pattern.value;
            var weight = this.hatch_weight.value;
            var finalize = function (image) {
                _this._hatch_image = new p.UniformScalar(image, n);
            };
            var textures = this.hatch_extra.value;
            var texture = textures[pattern];
            if (texture != null) {
                var image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    var _update_iteration_2 = this._update_iteration;
                    image.then(function (image) {
                        if (_this._update_iteration == _update_iteration_2) {
                            finalize(image);
                            _this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                var layer = this.obj.canvas.create_layer();
                var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        };
        Object.defineProperty(HatchScalar.prototype, "doit", {
            get: function () {
                return this._static_doit;
            },
            enumerable: false,
            configurable: true
        });
        HatchScalar.prototype.apply = function (ctx, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(function () { return ctx.fill(rule); });
            }
            return doit;
        };
        HatchScalar.prototype.set_value = function (ctx) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx)) !== null && _a !== void 0 ? _a : "transparent";
        };
        HatchScalar.prototype.pattern = function (ctx) {
            var image = this._hatch_image.value;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        };
        HatchScalar.prototype.repetition = function () {
            var pattern = this.hatch_pattern.value;
            var texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return HatchScalar;
    }(visual_1.VisualUniforms));
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    var HatchVector = /** @class */ (function (_super) {
        tslib_1.__extends(HatchVector, _super);
        function HatchVector() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this._static_doit = false;
            _this._update_iteration = 0;
            return _this;
        }
        HatchVector.prototype._compute_static_doit = function () {
            var hatch_color = this.hatch_color;
            if (hatch_color.is_Scalar() && hatch_color.value == 0)
                return false;
            var hatch_alpha = this.hatch_alpha;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0)
                return false;
            var hatch_pattern = this.hatch_pattern;
            if (hatch_pattern.is_Scalar()) {
                var pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null)
                    return false;
            }
            return true;
        };
        HatchVector.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            var n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            var resolve_image = function (pattern, color, alpha, scale, weight, finalize) {
                var textures = _this.hatch_extra.value;
                var texture = textures[pattern];
                if (texture != null) {
                    var image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        var _update_iteration_3 = _this._update_iteration;
                        image.then(function (image) {
                            if (_this._update_iteration == _update_iteration_3) {
                                finalize(image);
                                _this.obj.request_render();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    var layer = _this.obj.canvas.create_layer();
                    var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                var color = this.hatch_color.value;
                var alpha = this.hatch_alpha.value;
                var scale = this.hatch_scale.value;
                var pattern = this.hatch_pattern.value;
                var weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, function (image) {
                    _this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                var images_1 = new Array(n);
                images_1.fill(null);
                this._hatch_image = new p.UniformVector(images_1);
                var _loop_1 = function (i) {
                    var color = this_1.hatch_color.get(i);
                    var alpha = this_1.hatch_alpha.get(i);
                    var scale = this_1.hatch_scale.get(i);
                    var pattern = this_1.hatch_pattern.get(i);
                    var weight = this_1.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, function (image) {
                        images_1[i] = image;
                    });
                };
                var this_1 = this;
                for (var i = 0; i < n; i++) {
                    _loop_1(i);
                }
            }
        };
        Object.defineProperty(HatchVector.prototype, "doit", {
            get: function () {
                return this._static_doit;
            },
            enumerable: false,
            configurable: true
        });
        HatchVector.prototype.apply = function (ctx, i, rule) {
            var doit = this.doit;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.layer.undo_transform(function () { return ctx.fill(rule); });
            }
            return doit;
        };
        HatchVector.prototype.set_vectorize = function (ctx, i) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx, i)) !== null && _a !== void 0 ? _a : "transparent";
        };
        HatchVector.prototype.pattern = function (ctx, i) {
            var image = this._hatch_image.get(i);
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition(i));
        };
        HatchVector.prototype.repetition = function (i) {
            var pattern = this.hatch_pattern.get(i);
            var texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return HatchVector;
    }(visual_1.VisualUniforms));
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var color_1 = require(137) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    exports.get_pattern = get_pattern;
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        var _a;
        var h = hatch_scale;
        var h2 = h / 2;
        var h4 = h2 / 2;
        var color = color_1.color2css(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch ((_a = exports.hatch_aliases[hatch_pattern]) !== null && _a !== void 0 ? _a : hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                var h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (var i = 0; i < 360; i++) {
                    var angle = 0.1 * i;
                    var x = h2 + (h30 * angle) * Math.cos(angle);
                    var y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
    }
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var has_props_1 = require(129) /* ./core/has_props */;
    var types_1 = require(123) /* ./core/util/types */;
    var object_1 = require(128) /* ./core/util/object */;
    var logging_1 = require(134) /* ./core/logging */;
    var Model = /** @class */ (function (_super) {
        tslib_1.__extends(Model, _super);
        function Model(attrs) {
            return _super.call(this, attrs) || this;
        }
        Object.defineProperty(Model.prototype, "is_syncable", {
            get: function () {
                return this.syncable;
            },
            enumerable: false,
            configurable: true
        });
        Model.init_Model = function () {
            this.define(function (_a) {
                var Any = _a.Any, Unknown = _a.Unknown, Boolean = _a.Boolean, String = _a.String, Array = _a.Array, Dict = _a.Dict, Nullable = _a.Nullable;
                return ({
                    tags: [Array(Unknown), []],
                    name: [Nullable(String), null],
                    js_property_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                    js_event_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                    subscribed_events: [Array(String), []],
                    syncable: [Boolean, true],
                });
            });
        };
        Model.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._js_callbacks = new Map();
        };
        Model.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, function () { return _this._update_property_callbacks(); });
            this.connect(this.properties.js_event_callbacks.change, function () { return _this._update_event_callbacks(); });
            this.connect(this.properties.subscribed_events.change, function () { return _this._update_event_callbacks(); });
        };
        /*protected*/ Model.prototype._process_event = function (event) {
            var e_1, _a;
            var _b;
            try {
                for (var _c = tslib_1.__values((_b = this.js_event_callbacks[event.event_name]) !== null && _b !== void 0 ? _b : []), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var callback = _d.value;
                    callback.execute(event);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (this.document != null && this.subscribed_events.some(function (m) { return m == event.event_name; }))
                this.document.event_manager.send_event(event);
        };
        Model.prototype.trigger_event = function (event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        };
        Model.prototype._update_event_callbacks = function () {
            if (this.document == null) {
                logging_1.logger.warn("WARNING: Document not defined for updating event callbacks");
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        };
        Model.prototype._update_property_callbacks = function () {
            var e_2, _a, e_3, _b, e_4, _c, e_5, _d;
            var _this = this;
            var signal_for = function (event) {
                var _a = tslib_1.__read(event.split(":"), 2), evt = _a[0], _b = _a[1], attr = _b === void 0 ? null : _b;
                return attr != null ? _this.properties[attr][evt] : _this[evt];
            };
            try {
                for (var _e = tslib_1.__values(this._js_callbacks), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var _g = tslib_1.__read(_f.value, 2), event = _g[0], callbacks = _g[1];
                    var signal = signal_for(event);
                    try {
                        for (var callbacks_1 = (e_3 = void 0, tslib_1.__values(callbacks)), callbacks_1_1 = callbacks_1.next(); !callbacks_1_1.done; callbacks_1_1 = callbacks_1.next()) {
                            var cb = callbacks_1_1.value;
                            this.disconnect(signal, cb);
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (callbacks_1_1 && !callbacks_1_1.done && (_b = callbacks_1.return))
                                _b.call(callbacks_1);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return))
                        _a.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            this._js_callbacks.clear();
            try {
                for (var _h = tslib_1.__values(object_1.entries(this.js_property_callbacks)), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var _k = tslib_1.__read(_j.value, 2), event = _k[0], callbacks = _k[1];
                    var wrappers = callbacks.map(function (cb) { return function () { return cb.execute(_this); }; });
                    this._js_callbacks.set(event, wrappers);
                    var signal = signal_for(event);
                    try {
                        for (var wrappers_1 = (e_5 = void 0, tslib_1.__values(wrappers)), wrappers_1_1 = wrappers_1.next(); !wrappers_1_1.done; wrappers_1_1 = wrappers_1.next()) {
                            var cb = wrappers_1_1.value;
                            this.connect(signal, cb);
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (wrappers_1_1 && !wrappers_1_1.done && (_d = wrappers_1.return))
                                _d.call(wrappers_1);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_c = _h.return))
                        _c.call(_h);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
        };
        Model.prototype._doc_attached = function () {
            if (!object_1.isEmpty(this.js_event_callbacks) || this.subscribed_events.length != 0)
                this._update_event_callbacks();
        };
        Model.prototype._doc_detached = function () {
            this.document.event_manager.subscribed_models.delete(this);
        };
        Model.prototype.select = function (selector) {
            if (types_1.isString(selector))
                return tslib_1.__spreadArray([], tslib_1.__read(this.references())).filter(function (ref) { return ref instanceof Model && ref.name === selector; });
            else if (selector.prototype instanceof has_props_1.HasProps)
                return tslib_1.__spreadArray([], tslib_1.__read(this.references())).filter(function (ref) { return ref instanceof selector; });
            else
                throw new Error("invalid selector");
        };
        Model.prototype.select_one = function (selector) {
            var result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        };
        return Model;
    }(has_props_1.HasProps));
    exports.Model = Model;
    Model.__name__ = "Model";
    Model.init_Model();
},
/* models/canvas/coordinates.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var model_1 = require(168) /* ../../model */;
    var scale_1 = require(170) /* ../scales/scale */;
    var linear_scale_1 = require(174) /* ../scales/linear_scale */;
    var log_scale_1 = require(176) /* ../scales/log_scale */;
    var categorical_scale_1 = require(177) /* ../scales/categorical_scale */;
    var range_1 = require(172) /* ../ranges/range */;
    var data_range1d_1 = require(178) /* ../ranges/data_range1d */;
    var factor_range_1 = require(182) /* ../ranges/factor_range */;
    var CoordinateTransform = /** @class */ (function () {
        function CoordinateTransform(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_source = this.x_scale.source_range;
            this.y_source = this.y_scale.source_range;
            this.ranges = [this.x_source, this.y_source];
            this.scales = [this.x_scale, this.y_scale];
        }
        CoordinateTransform.prototype.map_to_screen = function (xs, ys) {
            var sxs = this.x_scale.v_compute(xs);
            var sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        };
        CoordinateTransform.prototype.map_from_screen = function (sxs, sys) {
            var xs = this.x_scale.v_invert(sxs);
            var ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        };
        return CoordinateTransform;
    }());
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
    var CoordinateMapping = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateMapping, _super);
        function CoordinateMapping(attrs) {
            return _super.call(this, attrs) || this;
        }
        CoordinateMapping.init_CoordinateMapping = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    x_source: [Ref(range_1.Range), function () { return new data_range1d_1.DataRange1d(); }],
                    y_source: [Ref(range_1.Range), function () { return new data_range1d_1.DataRange1d(); }],
                    x_scale: [Ref(scale_1.Scale), function () { return new linear_scale_1.LinearScale(); }],
                    y_scale: [Ref(scale_1.Scale), function () { return new linear_scale_1.LinearScale(); }],
                    x_target: [Ref(range_1.Range)],
                    y_target: [Ref(range_1.Range)],
                });
            });
        };
        Object.defineProperty(CoordinateMapping.prototype, "x_ranges", {
            get: function () {
                return new Map([["default", this.x_source]]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoordinateMapping.prototype, "y_ranges", {
            get: function () {
                return new Map([["default", this.y_source]]);
            },
            enumerable: false,
            configurable: true
        });
        CoordinateMapping.prototype._get_scale = function (range, scale, target) {
            var factor_range = range instanceof factor_range_1.FactorRange;
            var categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
            if (factor_range != categorical_scale) {
                throw new Error("Range " + range.type + " is incompatible is Scale " + scale.type);
            }
            if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                range.scale_hint = "log";
            var derived_scale = scale.clone();
            derived_scale.setv({ source_range: range, target_range: target });
            return derived_scale;
        };
        CoordinateMapping.prototype.get_transform = function (frame) {
            var _a = this, x_source = _a.x_source, x_scale = _a.x_scale, x_target = _a.x_target;
            var x_source_scale = this._get_scale(x_source, x_scale, x_target);
            var _b = this, y_source = _b.y_source, y_scale = _b.y_scale, y_target = _b.y_target;
            var y_source_scale = this._get_scale(y_source, y_scale, y_target);
            var xscale = new CompositeScale({
                source_scale: x_source_scale, source_range: x_source_scale.source_range,
                target_scale: frame.x_scale, target_range: frame.x_target,
            });
            var yscale = new CompositeScale({
                source_scale: y_source_scale, source_range: y_source_scale.source_range,
                target_scale: frame.y_scale, target_range: frame.y_target,
            });
            return new CoordinateTransform(xscale, yscale);
        };
        return CoordinateMapping;
    }(model_1.Model));
    exports.CoordinateMapping = CoordinateMapping;
    CoordinateMapping.__name__ = "CoordinateMapping";
    CoordinateMapping.init_CoordinateMapping();
    var CompositeScale = /** @class */ (function (_super) {
        tslib_1.__extends(CompositeScale, _super);
        function CompositeScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        CompositeScale.init_CompositeScale = function () {
            this.internal(function (_a) {
                var Ref = _a.Ref;
                return ({
                    source_scale: [Ref(scale_1.Scale)],
                    target_scale: [Ref(scale_1.Scale)],
                });
            });
        };
        Object.defineProperty(CompositeScale.prototype, "s_compute", {
            get: function () {
                var source_compute = this.source_scale.s_compute;
                var target_compute = this.target_scale.s_compute;
                return function (x) { return target_compute(source_compute(x)); };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CompositeScale.prototype, "s_invert", {
            get: function () {
                var source_invert = this.source_scale.s_invert;
                var target_invert = this.target_scale.s_invert;
                return function (sx) { return source_invert(target_invert(sx)); };
            },
            enumerable: false,
            configurable: true
        });
        CompositeScale.prototype.compute = function (x) {
            return this.s_compute(x);
        };
        CompositeScale.prototype.v_compute = function (xs) {
            var s_compute = this.s_compute;
            return arrayable_1.map(xs, s_compute); // XXX
        };
        CompositeScale.prototype.invert = function (sx) {
            return this.s_invert(sx);
        };
        CompositeScale.prototype.v_invert = function (sxs) {
            var s_invert = this.s_invert;
            return arrayable_1.map(sxs, s_invert); // XXX
        };
        return CompositeScale;
    }(scale_1.Scale));
    exports.CompositeScale = CompositeScale;
    CompositeScale.__name__ = "CompositeScale";
    CompositeScale.init_CompositeScale();
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var transform_1 = require(171) /* ../transforms/transform */;
    var range_1 = require(172) /* ../ranges/range */;
    var range1d_1 = require(173) /* ../ranges/range1d */;
    var types_1 = require(139) /* ../../core/types */;
    var Scale = /** @class */ (function (_super) {
        tslib_1.__extends(Scale, _super);
        function Scale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Scale.init_Scale = function () {
            this.internal(function (_a) {
                var Ref = _a.Ref;
                return ({
                    source_range: [Ref(range_1.Range)],
                    target_range: [Ref(range1d_1.Range1d)],
                });
            });
        };
        Scale.prototype.compute = function (x) {
            return this.s_compute(x);
        };
        Scale.prototype.v_compute = function (xs) {
            var result = new types_1.ScreenArray(xs.length);
            var s_compute = this.s_compute;
            for (var i = 0; i < xs.length; i++) {
                result[i] = s_compute(xs[i]);
            }
            return result;
        };
        Scale.prototype.invert = function (sx) {
            return this.s_invert(sx);
        };
        Scale.prototype.v_invert = function (sxs) {
            var result = new Float64Array(sxs.length);
            var s_invert = this.s_invert;
            for (var i = 0; i < sxs.length; i++) {
                result[i] = s_invert(sxs[i]);
            }
            return result;
        };
        Scale.prototype.r_compute = function (x0, x1) {
            var s_compute = this.s_compute;
            if (this.target_range.is_reversed)
                return [s_compute(x1), s_compute(x0)];
            else
                return [s_compute(x0), s_compute(x1)];
        };
        Scale.prototype.r_invert = function (sx0, sx1) {
            var s_invert = this.s_invert;
            if (this.target_range.is_reversed)
                return [s_invert(sx1), s_invert(sx0)];
            else
                return [s_invert(sx0), s_invert(sx1)];
        };
        return Scale;
    }(transform_1.Transform));
    exports.Scale = Scale;
    Scale.__name__ = "Scale";
    Scale.init_Scale();
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Transform = /** @class */ (function (_super) {
        tslib_1.__extends(Transform, _super);
        function Transform(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Transform;
    }(model_1.Model));
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Range = /** @class */ (function (_super) {
        tslib_1.__extends(Range, _super);
        function Range(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.have_updated_interactively = false;
            return _this;
        }
        Range.init_Range = function () {
            this.define(function (_a) {
                var Number = _a.Number, Tuple = _a.Tuple, Or = _a.Or, Auto = _a.Auto, Nullable = _a.Nullable;
                return ({
                    bounds: [Nullable(Or(Tuple(Nullable(Number), Nullable(Number)), Auto)), null],
                    min_interval: [Nullable(Number), null],
                    max_interval: [Nullable(Number), null],
                });
            });
            this.internal(function (_a) {
                var Array = _a.Array, AnyRef = _a.AnyRef;
                return ({
                    plots: [Array(AnyRef()), []],
                });
            });
        };
        Object.defineProperty(Range.prototype, "is_reversed", {
            get: function () {
                return this.start > this.end;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Range.prototype, "is_valid", {
            get: function () {
                return isFinite(this.min) && isFinite(this.max);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Range.prototype, "span", {
            get: function () {
                return Math.abs(this.end - this.start);
            },
            enumerable: false,
            configurable: true
        });
        return Range;
    }(model_1.Model));
    exports.Range = Range;
    Range.__name__ = "Range";
    Range.init_Range();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var range_1 = require(172) /* ./range */;
    var Range1d = /** @class */ (function (_super) {
        tslib_1.__extends(Range1d, _super);
        function Range1d(attrs) {
            return _super.call(this, attrs) || this;
        }
        Range1d.init_Range1d = function () {
            this.define(function (_a) {
                var Number = _a.Number, Nullable = _a.Nullable;
                return ({
                    start: [Number, 0],
                    end: [Number, 1],
                    reset_start: [Nullable(Number), null, {
                            on_update: function (reset_start, self) {
                                self._reset_start = reset_start !== null && reset_start !== void 0 ? reset_start : self.start;
                            },
                        }],
                    reset_end: [Nullable(Number), null, {
                            on_update: function (reset_end, self) {
                                self._reset_end = reset_end !== null && reset_end !== void 0 ? reset_end : self.end;
                            },
                        }],
                });
            });
        };
        Range1d.prototype._set_auto_bounds = function () {
            if (this.bounds == "auto") {
                var min = Math.min(this._reset_start, this._reset_end);
                var max = Math.max(this._reset_start, this._reset_end);
                this.setv({ bounds: [min, max] }, { silent: true });
            }
        };
        Range1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._set_auto_bounds();
        };
        Object.defineProperty(Range1d.prototype, "min", {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, "max", {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: false,
            configurable: true
        });
        Range1d.prototype.reset = function () {
            this._set_auto_bounds();
            var _a = this, _reset_start = _a._reset_start, _reset_end = _a._reset_end;
            if (this.start != _reset_start || this.end != _reset_end)
                this.setv({ start: _reset_start, end: _reset_end });
            else
                this.change.emit();
        };
        Range1d.prototype.map = function (fn) {
            return new Range1d({ start: fn(this.start), end: fn(this.end) });
        };
        Range1d.prototype.widen = function (v) {
            var _a = this, start = _a.start, end = _a.end;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new Range1d({ start: start, end: end });
        };
        return Range1d;
    }(range_1.Range));
    exports.Range1d = Range1d;
    Range1d.__name__ = "Range1d";
    Range1d.init_Range1d();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var continuous_scale_1 = require(175) /* ./continuous_scale */;
    var LinearScale = /** @class */ (function (_super) {
        tslib_1.__extends(LinearScale, _super);
        function LinearScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Object.defineProperty(LinearScale.prototype, "s_compute", {
            get: function () {
                var _a = tslib_1.__read(this._linear_compute_state(), 2), factor = _a[0], offset = _a[1];
                return function (x) { return factor * x + offset; };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LinearScale.prototype, "s_invert", {
            get: function () {
                var _a = tslib_1.__read(this._linear_compute_state(), 2), factor = _a[0], offset = _a[1];
                return function (sx) { return (sx - offset) / factor; };
            },
            enumerable: false,
            configurable: true
        });
        /*protected*/ LinearScale.prototype._linear_compute_state = function () {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var factor = (target_end - target_start) / (source_end - source_start);
            var offset = -(factor * source_start) + target_start;
            return [factor, offset];
        };
        return LinearScale;
    }(continuous_scale_1.ContinuousScale));
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var scale_1 = require(170) /* ./scale */;
    var ContinuousScale = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousScale, _super);
        function ContinuousScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        return ContinuousScale;
    }(scale_1.Scale));
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var continuous_scale_1 = require(175) /* ./continuous_scale */;
    var LogScale = /** @class */ (function (_super) {
        tslib_1.__extends(LogScale, _super);
        function LogScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Object.defineProperty(LogScale.prototype, "s_compute", {
            get: function () {
                var _a = tslib_1.__read(this._compute_state(), 4), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
                return function (x) {
                    if (inter_factor == 0)
                        return 0;
                    else {
                        var _x = (Math.log(x) - inter_offset) / inter_factor;
                        return isFinite(_x) ? _x * factor + offset : NaN;
                    }
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LogScale.prototype, "s_invert", {
            get: function () {
                var _a = tslib_1.__read(this._compute_state(), 4), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
                return function (xprime) {
                    var value = (xprime - offset) / factor;
                    return Math.exp(inter_factor * value + inter_offset);
                };
            },
            enumerable: false,
            configurable: true
        });
        LogScale.prototype._get_safe_factor = function (orig_start, orig_end) {
            var _a;
            var start = orig_start < 0 ? 0 : orig_start;
            var end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    _a = tslib_1.__read([1, 10], 2), start = _a[0], end = _a[1];
                else {
                    var log_val = Math.log(start) / Math.log(10);
                    start = Math.pow(10, Math.floor(log_val));
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = Math.pow(10, Math.ceil(log_val));
                    else
                        end = Math.pow(10, (Math.ceil(log_val) + 1));
                }
            }
            return [start, end];
        };
        /*protected*/ LogScale.prototype._compute_state = function () {
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var screen_range = target_end - target_start;
            var _a = tslib_1.__read(this._get_safe_factor(source_start, source_end), 2), start = _a[0], end = _a[1];
            var inter_factor;
            var inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            var factor = screen_range;
            var offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        };
        return LogScale;
    }(continuous_scale_1.ContinuousScale));
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var scale_1 = require(170) /* ./scale */;
    var linear_scale_1 = require(174) /* ./linear_scale */;
    var _linear_compute_state = linear_scale_1.LinearScale.prototype._linear_compute_state;
    var CategoricalScale = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalScale, _super);
        function CategoricalScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Object.defineProperty(CategoricalScale.prototype, "s_compute", {
            get: function () {
                var _a = tslib_1.__read(_linear_compute_state.call(this), 2), factor = _a[0], offset = _a[1];
                var range = this.source_range;
                return function (x) { return factor * range.synthetic(x) + offset; };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CategoricalScale.prototype, "s_invert", {
            get: function () {
                var _a = tslib_1.__read(_linear_compute_state.call(this), 2), factor = _a[0], offset = _a[1];
                return function (sx) { return (sx - offset) / factor; };
            },
            enumerable: false,
            configurable: true
        });
        return CategoricalScale;
    }(scale_1.Scale));
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/ranges/data_range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_range_1 = require(179) /* ./data_range */;
    var enums_1 = require(135) /* ../../core/enums */;
    var array_1 = require(124) /* ../../core/util/array */;
    var logging_1 = require(134) /* ../../core/logging */;
    var bbox = tslib_1.__importStar(require(180) /* ../../core/util/bbox */);
    var util_1 = require(181) /* ../util */;
    var DataRange1d = /** @class */ (function (_super) {
        tslib_1.__extends(DataRange1d, _super);
        function DataRange1d(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.have_updated_interactively = false;
            return _this;
        }
        DataRange1d.init_DataRange1d = function () {
            this.define(function (_a) {
                var Boolean = _a.Boolean, Number = _a.Number, Nullable = _a.Nullable;
                return ({
                    start: [Number],
                    end: [Number],
                    range_padding: [Number, 0.1],
                    range_padding_units: [enums_1.PaddingUnits, "percent"],
                    flipped: [Boolean, false],
                    follow: [Nullable(enums_1.StartEnd), null],
                    follow_interval: [Nullable(Number), null],
                    default_span: [Number, 2.0],
                    only_visible: [Boolean, false],
                });
            });
            this.internal(function (_a) {
                var Enum = _a.Enum;
                return ({
                    scale_hint: [Enum("log", "auto"), "auto"],
                });
            });
        };
        DataRange1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
            this._plot_bounds = new Map();
        };
        Object.defineProperty(DataRange1d.prototype, "min", {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(DataRange1d.prototype, "max", {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: false,
            configurable: true
        });
        DataRange1d.prototype.computed_renderers = function () {
            // TODO (bev) check that renderers actually configured with this range
            var _a = this, renderers = _a.renderers, names = _a.names;
            var all_renderers = array_1.concat(this.plots.map(function (plot) { return plot.data_renderers; }));
            return util_1.compute_renderers(renderers.length == 0 ? "auto" : renderers, all_renderers, names);
        };
        /*protected*/ DataRange1d.prototype._compute_plot_bounds = function (renderers, bounds) {
            var e_1, _a;
            var result = bbox.empty();
            try {
                for (var renderers_1 = tslib_1.__values(renderers), renderers_1_1 = renderers_1.next(); !renderers_1_1.done; renderers_1_1 = renderers_1.next()) {
                    var r = renderers_1_1.value;
                    var rect = bounds.get(r);
                    if (rect != null && (r.visible || !this.only_visible)) {
                        result = bbox.union(result, rect);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (renderers_1_1 && !renderers_1_1.done && (_a = renderers_1.return))
                        _a.call(renderers_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return result;
        };
        DataRange1d.prototype.adjust_bounds_for_aspect = function (bounds, ratio) {
            var result = bbox.empty();
            var width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            var height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            var xcenter = 0.5 * (bounds.x1 + bounds.x0);
            var ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        };
        /*protected*/ DataRange1d.prototype._compute_min_max = function (plot_bounds, dimension) {
            var e_2, _a, _b, _c;
            var overall = bbox.empty();
            try {
                for (var plot_bounds_1 = tslib_1.__values(plot_bounds), plot_bounds_1_1 = plot_bounds_1.next(); !plot_bounds_1_1.done; plot_bounds_1_1 = plot_bounds_1.next()) {
                    var rect = plot_bounds_1_1.value;
                    overall = bbox.union(overall, rect);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (plot_bounds_1_1 && !plot_bounds_1_1.done && (_a = plot_bounds_1.return))
                        _a.call(plot_bounds_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var min, max;
            if (dimension == 0)
                _b = tslib_1.__read([overall.x0, overall.x1], 2), min = _b[0], max = _b[1];
            else
                _c = tslib_1.__read([overall.y0, overall.y1], 2), min = _c[0], max = _c[1];
            return [min, max];
        };
        /*protected*/ DataRange1d.prototype._compute_range = function (min, max) {
            var _a;
            var range_padding = this.range_padding; // XXX: ? 0
            var start, end;
            if (this._initial_start != null)
                min = this._initial_start;
            if (this._initial_end != null)
                max = this._initial_end;
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn("could not determine minimum data value for log axis, DataRange1d using value " + min);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn("could not determine maximum data value for log axis, DataRange1d using value " + max);
                }
                var center = void 0, span = void 0;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log(min) / Math.log(10);
                }
                else {
                    var log_min = void 0, log_max = void 0;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log(min) / Math.log(10);
                        log_max = Math.log(max) / Math.log(10);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log(min - range_padding) / Math.log(10);
                        log_max = Math.log(max + range_padding) / Math.log(10);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                start = Math.pow(10, (center - span / 2.0));
                end = Math.pow(10, (center + span / 2.0));
            }
            else {
                var span = void 0;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == "percent")
                        span = (max - min) * (1 + range_padding);
                    else
                        span = (max - min) + 2 * range_padding;
                }
                var center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            var follow_sign = +1;
            if (this.flipped) {
                _a = tslib_1.__read([end, start], 2), start = _a[0], end = _a[1];
                follow_sign = -1;
            }
            var follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == "start")
                    end = start + follow_sign * follow_interval;
                else if (this.follow == "end")
                    start = end - follow_sign * follow_interval;
            }
            return [start, end];
        };
        DataRange1d.prototype.update = function (bounds, dimension, plot, ratio) {
            if (this.have_updated_interactively)
                return;
            var renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            var total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds.set(plot, total_bounds);
            // compute the min/mix for our specified dimension
            var _a = tslib_1.__read(this._compute_min_max(this._plot_bounds.values(), dimension), 2), min = _a[0], max = _a[1];
            // derive start, end from bounds and data range config
            var _b = tslib_1.__read(this._compute_range(min, max), 2), start = _b[0], end = _b[1];
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                }
                else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                }
                else
                    end = this._initial_end;
            }
            var needs_emit = false;
            if (this.bounds == "auto") {
                this.setv({ bounds: [start, end] }, { silent: true });
                needs_emit = true;
            }
            // only trigger updates when there are changes
            var _c = tslib_1.__read([this.start, this.end], 2), _start = _c[0], _end = _c[1];
            if (start != _start || end != _end) {
                var new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
                needs_emit = false;
            }
            if (needs_emit)
                this.change.emit();
        };
        DataRange1d.prototype.reset = function () {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        };
        return DataRange1d;
    }(data_range_1.DataRange));
    exports.DataRange1d = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    DataRange1d.init_DataRange1d();
},
/* models/ranges/data_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var range_1 = require(172) /* ./range */;
    var DataRange = /** @class */ (function (_super) {
        tslib_1.__extends(DataRange, _super);
        function DataRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataRange.init_DataRange = function () {
            this.define(function (_a) {
                var String = _a.String, Array = _a.Array, AnyRef = _a.AnyRef;
                return ({
                    names: [Array(String), []],
                    renderers: [Array(AnyRef( /*DataRenderer*/)), []], // TODO: [] -> "auto"
                });
            });
        };
        return DataRange;
    }(range_1.Range));
    exports.DataRange = DataRange;
    DataRange.__name__ = "DataRange";
    DataRange.init_DataRange();
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(139) /* ../types */;
    var eq_1 = require(141) /* ./eq */;
    var min = Math.min, max = Math.max;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    var BBox = /** @class */ (function () {
        function BBox(box) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ("x0" in box) {
                var x0 = box.x0, y0 = box.y0, x1 = box.x1, y1 = box.y1;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error("invalid bbox {x0: " + x0 + ", y0: " + y0 + ", x1: " + x1 + ", y1: " + y1 + "}");
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                var x = box.x, y = box.y, width = box.width, height = box.height;
                if (!(width >= 0 && height >= 0))
                    throw new Error("invalid bbox {x: " + x + ", y: " + y + ", width: " + width + ", height: " + height + "}");
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                var left = void 0, right = void 0;
                var top = void 0, bottom = void 0;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        var w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        var h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (!(left <= right && top <= bottom))
                    throw new Error("invalid bbox {left: " + left + ", top: " + top + ", right: " + right + ", bottom: " + bottom + "}");
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        BBox.from_rect = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            return new BBox({
                x0: Math.min(left, right),
                y0: Math.min(top, bottom),
                x1: Math.max(left, right),
                y1: Math.max(top, bottom),
            });
        };
        BBox.prototype.equals = function (that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        };
        BBox.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        };
        BBox.prototype.toString = function () {
            return "BBox({left: " + this.left + ", top: " + this.top + ", width: " + this.width + ", height: " + this.height + "})";
        };
        Object.defineProperty(BBox.prototype, "left", {
            get: function () { return this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "top", {
            get: function () { return this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "right", {
            get: function () { return this.x1; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "bottom", {
            get: function () { return this.y1; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p0", {
            get: function () { return [this.x0, this.y0]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p1", {
            get: function () { return [this.x1, this.y1]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "x", {
            get: function () { return this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "y", {
            get: function () { return this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "width", {
            get: function () { return this.x1 - this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "height", {
            get: function () { return this.y1 - this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "size", {
            get: function () { return { width: this.width, height: this.height }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "rect", {
            get: function () {
                var _a = this, x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                return {
                    p0: { x: x0, y: y0 },
                    p1: { x: x1, y: y0 },
                    p2: { x: x1, y: y1 },
                    p3: { x: x0, y: y1 },
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "box", {
            get: function () {
                var _a = this, x = _a.x, y = _a.y, width = _a.width, height = _a.height;
                return { x: x, y: y, width: width, height: height };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "h_range", {
            get: function () { return { start: this.x0, end: this.x1 }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "v_range", {
            get: function () { return { start: this.y0, end: this.y1 }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "ranges", {
            get: function () { return [this.h_range, this.v_range]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "aspect", {
            get: function () { return this.width / this.height; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "hcenter", {
            get: function () { return (this.left + this.right) / 2; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "vcenter", {
            get: function () { return (this.top + this.bottom) / 2; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "area", {
            get: function () { return this.width * this.height; },
            enumerable: false,
            configurable: true
        });
        BBox.prototype.relative = function () {
            var _a = this, width = _a.width, height = _a.height;
            return new BBox({ x: 0, y: 0, width: width, height: height });
        };
        BBox.prototype.translate = function (tx, ty) {
            var _a = this, x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            return new BBox({ x: tx + x, y: ty + y, width: width, height: height });
        };
        BBox.prototype.relativize = function (x, y) {
            return [x - this.x, y - this.y];
        };
        BBox.prototype.contains = function (x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        };
        BBox.prototype.clip = function (x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        };
        BBox.prototype.grow_by = function (size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        };
        BBox.prototype.shrink_by = function (size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            });
        };
        BBox.prototype.union = function (that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        };
        BBox.prototype.intersection = function (that) {
            if (!this.intersects(that))
                return null;
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        };
        BBox.prototype.intersects = function (that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        };
        Object.defineProperty(BBox.prototype, "xview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (x) {
                        return _this.left + x;
                    },
                    v_compute: function (xx) {
                        var _xx = new types_1.ScreenArray(xx.length);
                        var left = _this.left;
                        for (var i = 0; i < xx.length; i++) {
                            _xx[i] = left + xx[i];
                        }
                        return _xx;
                    },
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "yview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (y) {
                        return _this.bottom - y;
                    },
                    v_compute: function (yy) {
                        var _yy = new types_1.ScreenArray(yy.length);
                        var bottom = _this.bottom;
                        for (var i = 0; i < yy.length; i++) {
                            _yy[i] = bottom - yy[i];
                        }
                        return _yy;
                    },
                };
            },
            enumerable: false,
            configurable: true
        });
        return BBox;
    }());
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* models/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var array_1 = require(124) /* ../core/util/array */;
    function compute_renderers(renderers, all_renderers, names) {
        if (renderers == null)
            return [];
        var result = renderers == "auto" ? all_renderers : renderers;
        if (names.length > 0)
            result = result.filter(function (r) { return array_1.includes(names, r.name); });
        return result;
    }
    exports.compute_renderers = compute_renderers;
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var range_1 = require(172) /* ./range */;
    var enums_1 = require(135) /* ../../core/enums */;
    var kinds_1 = require(136) /* ../../core/kinds */;
    var types_1 = require(139) /* ../../core/types */;
    var array_1 = require(124) /* ../../core/util/array */;
    var types_2 = require(123) /* ../../core/util/types */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    exports.Factor = kinds_1.Or(kinds_1.String, kinds_1.Tuple(kinds_1.String, kinds_1.String), kinds_1.Tuple(kinds_1.String, kinds_1.String, kinds_1.String));
    exports.FactorSeq = kinds_1.Or(kinds_1.Array(kinds_1.String), kinds_1.Array(kinds_1.Tuple(kinds_1.String, kinds_1.String)), kinds_1.Array(kinds_1.Tuple(kinds_1.String, kinds_1.String, kinds_1.String)));
    function map_one_level(factors, padding, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        for (var i = 0; i < factors.length; i++) {
            var factor = factors[i];
            if (!mapping.has(factor))
                mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
            else
                throw new Error("duplicate factor or subfactor: " + factor);
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset) {
        var e_1, _a, e_2, _b;
        var _c;
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        var tops = new Map();
        try {
            for (var factors_1 = tslib_1.__values(factors), factors_1_1 = factors_1.next(); !factors_1_1.done; factors_1_1 = factors_1.next()) {
                var _d = tslib_1.__read(factors_1_1.value, 2), f0 = _d[0], f1 = _d[1];
                var top = (_c = tops.get(f0)) !== null && _c !== void 0 ? _c : [];
                tops.set(f0, tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(top)), [f1]));
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (factors_1_1 && !factors_1_1.done && (_a = factors_1.return))
                    _a.call(factors_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_1 = function (f0, top) {
            var n = top.length;
            var _f = tslib_1.__read(map_one_level(top, factor_pad, suboffset), 2), submap = _f[0], subpad = _f[1];
            total_subpad += subpad;
            var subtot = array_1.sum(top.map(function (f1) { return submap.get(f1).value; }));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        };
        try {
            for (var tops_1 = tslib_1.__values(tops), tops_1_1 = tops_1.next(); !tops_1_1.done; tops_1_1 = tops_1.next()) {
                var _e = tslib_1.__read(tops_1_1.value, 2), f0 = _e[0], top = _e[1];
                _loop_1(f0, top);
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (tops_1_1 && !tops_1_1.done && (_b = tops_1.return))
                    _b.call(tops_1);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset) {
        var e_3, _a, e_4, _b;
        var _c;
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        var tops = new Map();
        try {
            for (var factors_2 = tslib_1.__values(factors), factors_2_1 = factors_2.next(); !factors_2_1.done; factors_2_1 = factors_2.next()) {
                var _d = tslib_1.__read(factors_2_1.value, 3), f0 = _d[0], f1 = _d[1], f2 = _d[2];
                var top = (_c = tops.get(f0)) !== null && _c !== void 0 ? _c : [];
                tops.set(f0, tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(top)), [[f1, f2]]));
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (factors_2_1 && !factors_2_1.done && (_a = factors_2.return))
                    _a.call(factors_2);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_2 = function (f0, top) {
            var n = top.length;
            var _f = tslib_1.__read(map_two_levels(top, inner_pad, factor_pad, suboffset), 2), submap = _f[0], subpad = _f[1];
            total_subpad += subpad;
            var subtot = array_1.sum(top.map(function (_a) {
                var _b = tslib_1.__read(_a, 1), f1 = _b[0];
                return submap.get(f1).value;
            }));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        };
        try {
            for (var tops_2 = tslib_1.__values(tops), tops_2_1 = tops_2.next(); !tops_2_1.done; tops_2_1 = tops_2.next()) {
                var _e = tslib_1.__read(tops_2_1.value, 2), f0 = _e[0], top = _e[1];
                _loop_2(f0, top);
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (tops_2_1 && !tops_2_1.done && (_b = tops_2.return))
                    _b.call(tops_2);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    var FactorRange = /** @class */ (function (_super) {
        tslib_1.__extends(FactorRange, _super);
        function FactorRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        FactorRange.init_FactorRange = function () {
            this.define(function (_a) {
                var Number = _a.Number;
                return ({
                    factors: [exports.FactorSeq, []],
                    factor_padding: [Number, 0],
                    subgroup_padding: [Number, 0.8],
                    group_padding: [Number, 1.4],
                    range_padding: [Number, 0],
                    range_padding_units: [enums_1.PaddingUnits, "percent"],
                    start: [Number],
                    end: [Number],
                });
            });
            this.internal(function (_a) {
                var Number = _a.Number, String = _a.String, Array = _a.Array, Tuple = _a.Tuple, Nullable = _a.Nullable;
                return ({
                    levels: [Number],
                    mids: [Nullable(Array(Tuple(String, String))), null],
                    tops: [Nullable(Array(String)), null], // top level factors (whether 2 or 3 total levels)
                });
            });
        };
        Object.defineProperty(FactorRange.prototype, "min", {
            get: function () {
                return this.start;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(FactorRange.prototype, "max", {
            get: function () {
                return this.end;
            },
            enumerable: false,
            configurable: true
        });
        FactorRange.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._init(true);
        };
        FactorRange.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.factors.change, function () { return _this.reset(); });
            this.connect(this.properties.factor_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.group_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.subgroup_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding_units.change, function () { return _this.reset(); });
        };
        FactorRange.prototype.reset = function () {
            this._init(false);
            this.change.emit();
        };
        FactorRange.prototype._lookup = function (x) {
            switch (x.length) {
                case 1: {
                    var _a = tslib_1.__read(x, 1), f0 = _a[0];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    return y0 != null ? y0.value : NaN;
                }
                case 2: {
                    var _b = tslib_1.__read(x, 2), f0 = _b[0], f1 = _b[1];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    if (y0 != null) {
                        var y1 = y0.mapping.get(f1);
                        if (y1 != null)
                            return y1.value;
                    }
                    return NaN;
                }
                case 3: {
                    var _c = tslib_1.__read(x, 3), f0 = _c[0], f1 = _c[1], f2 = _c[2];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    if (y0 != null) {
                        var y1 = y0.mapping.get(f1);
                        if (y1 != null) {
                            var y2 = y1.mapping.get(f2);
                            if (y2 != null)
                                return y2.value;
                        }
                    }
                    return NaN;
                }
                default:
                    assert_1.unreachable();
            }
        };
        // convert a string factor into a synthetic coordinate
        FactorRange.prototype.synthetic = function (x) {
            if (types_2.isNumber(x))
                return x;
            if (types_2.isString(x))
                return this._lookup([x]);
            var offset = 0;
            var off = x[x.length - 1];
            if (types_2.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        };
        // convert an array of string factors into synthetic coordinates
        FactorRange.prototype.v_synthetic = function (xs) {
            var n = xs.length;
            var array = new types_1.ScreenArray(n);
            for (var i = 0; i < n; i++) {
                array[i] = this.synthetic(xs[i]);
            }
            return array;
        };
        FactorRange.prototype._init = function (silent) {
            var _this = this;
            var _a = (function () {
                var e_5, _a, e_6, _b;
                if (array_1.every(_this.factors, types_2.isString)) {
                    var factors = _this.factors;
                    var _c = tslib_1.__read(map_one_level(factors, _this.factor_padding), 2), mapping_2 = _c[0], inside_padding_1 = _c[1];
                    var tops_3 = null;
                    var mids_1 = null;
                    return { levels: 1, mapping: mapping_2, tops: tops_3, mids: mids_1, inside_padding: inside_padding_1 };
                }
                else if (array_1.every(_this.factors, function (x) { return types_2.isArray(x) && x.length == 2 && types_2.isString(x[0]) && types_2.isString(x[1]); })) {
                    var factors = _this.factors;
                    var _d = tslib_1.__read(map_two_levels(factors, _this.group_padding, _this.factor_padding), 2), mapping_3 = _d[0], inside_padding_2 = _d[1];
                    var tops_4 = tslib_1.__spreadArray([], tslib_1.__read(mapping_3.keys()));
                    var mids_2 = null;
                    return { levels: 2, mapping: mapping_3, tops: tops_4, mids: mids_2, inside_padding: inside_padding_2 };
                }
                else if (array_1.every(_this.factors, function (x) { return types_2.isArray(x) && x.length == 3 && types_2.isString(x[0]) && types_2.isString(x[1]) && types_2.isString(x[2]); })) {
                    var factors = _this.factors;
                    var _e = tslib_1.__read(map_three_levels(factors, _this.group_padding, _this.subgroup_padding, _this.factor_padding), 2), mapping_4 = _e[0], inside_padding_3 = _e[1];
                    var tops_5 = tslib_1.__spreadArray([], tslib_1.__read(mapping_4.keys()));
                    var mids_3 = [];
                    try {
                        for (var mapping_1 = tslib_1.__values(mapping_4), mapping_1_1 = mapping_1.next(); !mapping_1_1.done; mapping_1_1 = mapping_1.next()) {
                            var _f = tslib_1.__read(mapping_1_1.value, 2), f0 = _f[0], L2 = _f[1];
                            try {
                                for (var _g = (e_6 = void 0, tslib_1.__values(L2.mapping.keys())), _h = _g.next(); !_h.done; _h = _g.next()) {
                                    var f1 = _h.value;
                                    mids_3.push([f0, f1]);
                                }
                            }
                            catch (e_6_1) {
                                e_6 = { error: e_6_1 };
                            }
                            finally {
                                try {
                                    if (_h && !_h.done && (_b = _g.return))
                                        _b.call(_g);
                                }
                                finally {
                                    if (e_6)
                                        throw e_6.error;
                                }
                            }
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (mapping_1_1 && !mapping_1_1.done && (_a = mapping_1.return))
                                _a.call(mapping_1);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                    return { levels: 3, mapping: mapping_4, tops: tops_5, mids: mids_3, inside_padding: inside_padding_3 };
                }
                else
                    assert_1.unreachable();
            })(), levels = _a.levels, mapping = _a.mapping, tops = _a.tops, mids = _a.mids, inside_padding = _a.inside_padding;
            this._mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            var start = 0;
            var end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                var half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start: start, end: end, levels: levels }, { silent: silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        };
        return FactorRange;
    }(range_1.Range));
    exports.FactorRange = FactorRange;
    FactorRange.__name__ = "FactorRange";
    FactorRange.init_FactorRange();
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_annotation_1 = require(184) /* ./data_annotation */;
    var arrow_head_1 = require(227) /* ./arrow_head */;
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var enums_1 = require(135) /* ../../core/enums */;
    var types_1 = require(139) /* ../../core/types */;
    var build_views_1 = require(228) /* ../../core/build_views */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var math_1 = require(125) /* ../../core/util/math */;
    var ArrowView = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowView, _super);
        function ArrowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowView.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var _a, start, end, _b, _c;
                return tslib_1.__generator(this, function (_d) {
                    switch (_d.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _d.sent();
                            _a = this.model, start = _a.start, end = _a.end;
                            if (!(start != null))
                                return [3 /*break*/, 3];
                            _b = this;
                            return [4 /*yield*/, build_views_1.build_view(start, { parent: this })];
                        case 2:
                            _b.start = _d.sent();
                            _d.label = 3;
                        case 3:
                            if (!(end != null))
                                return [3 /*break*/, 5];
                            _c = this;
                            return [4 /*yield*/, build_views_1.build_view(end, { parent: this })];
                        case 4:
                            _c.end = _d.sent();
                            _d.label = 5;
                        case 5: return [2 /*return*/];
                    }
                });
            });
        };
        ArrowView.prototype.set_data = function (source) {
            var _a, _b;
            _super.prototype.set_data.call(this, source);
            (_a = this.start) === null || _a === void 0 ? void 0 : _a.set_data(source);
            (_b = this.end) === null || _b === void 0 ? void 0 : _b.set_data(source);
        };
        ArrowView.prototype.remove = function () {
            var _a, _b;
            (_a = this.start) === null || _a === void 0 ? void 0 : _a.remove();
            (_b = this.end) === null || _b === void 0 ? void 0 : _b.remove();
            _super.prototype.remove.call(this);
        };
        ArrowView.prototype.map_data = function () {
            var frame = this.plot_view.frame;
            if (this.model.start_units == "data") {
                this._sx_start = this.coordinates.x_scale.v_compute(this._x_start);
                this._sy_start = this.coordinates.y_scale.v_compute(this._y_start);
            }
            else {
                this._sx_start = frame.bbox.xview.v_compute(this._x_start);
                this._sy_start = frame.bbox.yview.v_compute(this._y_start);
            }
            if (this.model.end_units == "data") {
                this._sx_end = this.coordinates.x_scale.v_compute(this._x_end);
                this._sy_end = this.coordinates.y_scale.v_compute(this._y_end);
            }
            else {
                this._sx_end = frame.bbox.xview.v_compute(this._x_end);
                this._sy_end = frame.bbox.yview.v_compute(this._y_end);
            }
            var _a = this, _sx_start = _a._sx_start, _sy_start = _a._sy_start, _sx_end = _a._sx_end, _sy_end = _a._sy_end;
            var n = _sx_start.length;
            var angles = this._angles = new types_1.ScreenArray(n);
            for (var i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + math_1.atan2([_sx_start[i], _sy_start[i]], [_sx_end[i], _sy_end[i]]);
            }
        };
        ArrowView.prototype.paint = function (ctx) {
            var _a = this, start = _a.start, end = _a.end;
            var _b = this, _sx_start = _b._sx_start, _sy_start = _b._sy_start, _sx_end = _b._sx_end, _sy_end = _b._sy_end, _angles = _b._angles;
            var _c = this.plot_view.frame.bbox, x = _c.x, y = _c.y, width = _c.width, height = _c.height;
            for (var i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.render(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.render(ctx, i);
                    ctx.restore();
                }
                if (this.visuals.line.doit) {
                    ctx.save();
                    if (start != null || end != null) {
                        ctx.beginPath();
                        ctx.rect(x, y, width, height);
                        if (end != null) {
                            ctx.save();
                            ctx.translate(_sx_end[i], _sy_end[i]);
                            ctx.rotate(_angles[i]);
                            end.clip(ctx, i);
                            ctx.restore();
                        }
                        if (start != null) {
                            ctx.save();
                            ctx.translate(_sx_start[i], _sy_start[i]);
                            ctx.rotate(_angles[i] + Math.PI);
                            start.clip(ctx, i);
                            ctx.restore();
                        }
                        ctx.closePath();
                        ctx.clip();
                    }
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(_sx_start[i], _sy_start[i]);
                    ctx.lineTo(_sx_end[i], _sy_end[i]);
                    ctx.stroke();
                    ctx.restore();
                }
            }
        };
        return ArrowView;
    }(data_annotation_1.DataAnnotationView));
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    var Arrow = /** @class */ (function (_super) {
        tslib_1.__extends(Arrow, _super);
        function Arrow(attrs) {
            return _super.call(this, attrs) || this;
        }
        Arrow.init_Arrow = function () {
            this.prototype.default_view = ArrowView;
            this.mixins(property_mixins_1.LineVector);
            this.define(function (_a) {
                var Ref = _a.Ref, Nullable = _a.Nullable;
                return ({
                    x_start: [p.XCoordinateSpec, { field: "x_start" }],
                    y_start: [p.YCoordinateSpec, { field: "y_start" }],
                    start_units: [enums_1.SpatialUnits, "data"],
                    start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
                    x_end: [p.XCoordinateSpec, { field: "x_end" }],
                    y_end: [p.YCoordinateSpec, { field: "y_end" }],
                    end_units: [enums_1.SpatialUnits, "data"],
                    end: [Nullable(Ref(arrow_head_1.ArrowHead)), function () { return new arrow_head_1.OpenHead(); }],
                });
            });
        };
        return Arrow;
    }(data_annotation_1.DataAnnotation));
    exports.Arrow = Arrow;
    Arrow.__name__ = "Arrow";
    Arrow.init_Arrow();
},
/* models/annotations/data_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var columnar_data_source_1 = require(185) /* ../sources/columnar_data_source */;
    var column_data_source_1 = require(190) /* ../sources/column_data_source */;
    var projections_1 = require(193) /* ../../core/util/projections */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var DataAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(DataAnnotationView, _super);
        function DataAnnotationView() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this._initial_set_data = false;
            return _this;
        }
        DataAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var update = function () {
                _this.set_data(_this.model.source);
                _this.request_render();
            };
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        };
        DataAnnotationView.prototype.set_data = function (source) {
            var e_1, _a, e_2, _b;
            var self = this;
            try {
                for (var _c = tslib_1.__values(this.model), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var prop = _d.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    if (prop instanceof p.BaseCoordinateSpec) {
                        var array = prop.array(source);
                        self["_" + prop.attr] = array;
                    }
                    else {
                        var uniform = prop.uniform(source);
                        self["" + prop.attr] = uniform;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (this.plot_model.use_map) {
                if (self._x != null)
                    projections_1.inplace.project_xy(self._x, self._y);
                if (self._xs != null)
                    projections_1.inplace.project_xsys(self._xs, self._ys);
            }
            try {
                for (var _e = tslib_1.__values(this.visuals), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var visual = _f.value;
                    visual.update();
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        DataAnnotationView.prototype._render = function () {
            if (!this._initial_set_data) {
                this.set_data(this.model.source);
                this._initial_set_data = true;
            }
            this.map_data();
            this.paint(this.layer.ctx);
        };
        return DataAnnotationView;
    }(annotation_1.AnnotationView));
    exports.DataAnnotationView = DataAnnotationView;
    DataAnnotationView.__name__ = "DataAnnotationView";
    var DataAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(DataAnnotation, _super);
        function DataAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataAnnotation.init_DataAnnotation = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    source: [Ref(columnar_data_source_1.ColumnarDataSource), function () { return new column_data_source_1.ColumnDataSource(); }],
                });
            });
        };
        return DataAnnotation;
    }(annotation_1.Annotation));
    exports.DataAnnotation = DataAnnotation;
    DataAnnotation.__name__ = "DataAnnotation";
    DataAnnotation.init_DataAnnotation();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_source_1 = require(186) /* ./data_source */;
    var signaling_1 = require(130) /* ../../core/signaling */;
    var logging_1 = require(134) /* ../../core/logging */;
    var selection_manager_1 = require(188) /* ../../core/selection_manager */;
    var types_1 = require(123) /* ../../core/util/types */;
    var array_1 = require(124) /* ../../core/util/array */;
    var object_1 = require(128) /* ../../core/util/object */;
    var selection_1 = require(187) /* ../selections/selection */;
    var interaction_policy_1 = require(189) /* ../selections/interaction_policy */;
    var ndarray_1 = require(144) /* ../../core/util/ndarray */;
    var ColumnarDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnarDataSource, _super);
        function ColumnarDataSource(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.selection_manager = new selection_manager_1.SelectionManager(_this);
            return _this;
        }
        ColumnarDataSource.prototype.get_array = function (key) {
            var column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!types_1.isArray(column))
                this.data[key] = column = Array.from(column);
            return column;
        };
        ColumnarDataSource.init_ColumnarDataSource = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    selection_policy: [Ref(interaction_policy_1.SelectionPolicy), function () { return new interaction_policy_1.UnionRenderers(); }],
                });
            });
            this.internal(function (_a) {
                var AnyRef = _a.AnyRef;
                return ({
                    inspected: [AnyRef(), function () { return new selection_1.Selection(); }],
                });
            });
        };
        ColumnarDataSource.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
        };
        ColumnarDataSource.prototype.get_column = function (colname) {
            var column = this.data[colname];
            return column != null ? column : null;
        };
        ColumnarDataSource.prototype.columns = function () {
            // return the column names in this data source
            return object_1.keys(this.data);
        };
        ColumnarDataSource.prototype.get_length = function (soft) {
            if (soft === void 0) {
                soft = true;
            }
            var lengths = array_1.uniq(object_1.values(this.data).map(function (v) { return ndarray_1.is_NDArray(v) ? v.shape[0] : v.length; }));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    var msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        };
        Object.defineProperty(ColumnarDataSource.prototype, "length", {
            get: function () {
                var _a;
                return (_a = this.get_length()) !== null && _a !== void 0 ? _a : 0;
            },
            enumerable: false,
            configurable: true
        });
        ColumnarDataSource.prototype.clear = function () {
            var e_1, _a;
            var empty = {};
            try {
                for (var _b = tslib_1.__values(this.columns()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var col = _c.value;
                    empty[col] = new this.data[col].constructor(0);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.data = empty;
        };
        return ColumnarDataSource;
    }(data_source_1.DataSource));
    exports.ColumnarDataSource = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    ColumnarDataSource.init_ColumnarDataSource();
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var selection_1 = require(187) /* ../selections/selection */;
    var DataSource = /** @class */ (function (_super) {
        tslib_1.__extends(DataSource, _super);
        function DataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataSource.init_DataSource = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    selected: [Ref(selection_1.Selection), function () { return new selection_1.Selection(); }],
                });
            });
        };
        return DataSource;
    }(model_1.Model));
    exports.DataSource = DataSource;
    DataSource.__name__ = "DataSource";
    DataSource.init_DataSource();
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var array_1 = require(124) /* ../../core/util/array */;
    var object_1 = require(128) /* ../../core/util/object */;
    var Selection = /** @class */ (function (_super) {
        tslib_1.__extends(Selection, _super);
        function Selection(attrs) {
            return _super.call(this, attrs) || this;
        }
        Selection.prototype.get_view = function () {
            return this.view;
        };
        Selection.init_Selection = function () {
            this.define(function (_a) {
                var Int = _a.Int, Array = _a.Array, Dict = _a.Dict;
                return ({
                    indices: [Array(Int), []],
                    line_indices: [Array(Int), []],
                    multiline_indices: [Dict(Array(Int)), {}],
                });
            });
            this.internal(function (_a) {
                var Int = _a.Int, Array = _a.Array, AnyRef = _a.AnyRef, Struct = _a.Struct, Nullable = _a.Nullable;
                return ({
                    selected_glyphs: [Array(AnyRef()), []],
                    view: [Nullable(AnyRef()), null],
                    // Used internally to support hover tool for now. Python API TBD
                    image_indices: [Array(Struct({ index: Int, dim1: Int, dim2: Int, flat_index: Int })), []],
                });
            });
        };
        Object.defineProperty(Selection.prototype, "selected_glyph", {
            get: function () {
                return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
            },
            enumerable: false,
            configurable: true
        });
        Selection.prototype.add_to_selected_glyphs = function (glyph) {
            this.selected_glyphs.push(glyph);
        };
        Selection.prototype.update = function (selection, _final, mode) {
            if (_final === void 0) {
                _final = true;
            }
            if (mode === void 0) {
                mode = "replace";
            }
            switch (mode) {
                case "replace": {
                    this.indices = selection.indices;
                    this.line_indices = selection.line_indices;
                    this.selected_glyphs = selection.selected_glyphs;
                    this.view = selection.view;
                    this.multiline_indices = selection.multiline_indices;
                    this.image_indices = selection.image_indices;
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
            }
        };
        Selection.prototype.clear = function () {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.view = null;
            this.selected_glyphs = [];
        };
        Selection.prototype.is_empty = function () {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        };
        Selection.prototype.update_through_union = function (other) {
            this.indices = array_1.union(this.indices, other.indices);
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_intersection = function (other) {
            this.indices = array_1.intersection(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_subtraction = function (other) {
            this.indices = array_1.difference(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        return Selection;
    }(model_1.Model));
    exports.Selection = Selection;
    Selection.__name__ = "Selection";
    Selection.init_Selection();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var selection_1 = require(187) /* ../models/selections/selection */;
    // XXX: this is needed to cut circular dependency between this, models/renderers/* and models/sources/*
    function is_GlyphRendererView(renderer_view) {
        return renderer_view.model.type == "GlyphRenderer";
    }
    function is_GraphRendererView(renderer_view) {
        return renderer_view.model.type == "GraphRenderer";
    }
    var SelectionManager = /** @class */ (function () {
        function SelectionManager(source) {
            this.source = source;
            this.inspectors = new Map();
        }
        SelectionManager.prototype.select = function (renderer_views, geometry, final, mode) {
            var e_1, _a, e_2, _b;
            if (mode === void 0) {
                mode = "replace";
            }
            // divide renderers into glyph_renderers or graph_renderers
            var glyph_renderer_views = [];
            var graph_renderer_views = [];
            try {
                for (var renderer_views_1 = tslib_1.__values(renderer_views), renderer_views_1_1 = renderer_views_1.next(); !renderer_views_1_1.done; renderer_views_1_1 = renderer_views_1.next()) {
                    var r = renderer_views_1_1.value;
                    if (is_GlyphRendererView(r))
                        glyph_renderer_views.push(r);
                    else if (is_GraphRendererView(r))
                        graph_renderer_views.push(r);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (renderer_views_1_1 && !renderer_views_1_1.done && (_a = renderer_views_1.return))
                        _a.call(renderer_views_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            var did_hit = false;
            try {
                // graph renderer case
                for (var graph_renderer_views_1 = tslib_1.__values(graph_renderer_views), graph_renderer_views_1_1 = graph_renderer_views_1.next(); !graph_renderer_views_1_1.done; graph_renderer_views_1_1 = graph_renderer_views_1.next()) {
                    var r = graph_renderer_views_1_1.value;
                    var hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                    did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (graph_renderer_views_1_1 && !graph_renderer_views_1_1.done && (_b = graph_renderer_views_1.return))
                        _b.call(graph_renderer_views_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                var hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        };
        SelectionManager.prototype.inspect = function (renderer_view, geometry) {
            var did_hit = false;
            if (is_GlyphRendererView(renderer_view)) {
                var hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    var inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry: geometry }]);
                }
            }
            else if (is_GraphRendererView(renderer_view)) {
                var hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        };
        SelectionManager.prototype.clear = function (rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        };
        SelectionManager.prototype.get_or_create_inspector = function (renderer) {
            var selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        };
        return SelectionManager;
    }());
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var SelectionPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(SelectionPolicy, _super);
        function SelectionPolicy() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionPolicy.prototype.do_selection = function (hit_test_result, source, final, mode) {
            if (hit_test_result == null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        };
        return SelectionPolicy;
    }(model_1.Model));
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    var IntersectRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(IntersectRenderers, _super);
        function IntersectRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        IntersectRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var e_1, _a, e_2, _b;
            var hit_test_result_renderers = [];
            try {
                for (var renderer_views_1 = tslib_1.__values(renderer_views), renderer_views_1_1 = renderer_views_1.next(); !renderer_views_1_1.done; renderer_views_1_1 = renderer_views_1.next()) {
                    var r = renderer_views_1_1.value;
                    var result = r.hit_test(geometry);
                    if (result != null)
                        hit_test_result_renderers.push(result);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (renderer_views_1_1 && !renderer_views_1_1.done && (_a = renderer_views_1.return))
                        _a.call(renderer_views_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                try {
                    for (var hit_test_result_renderers_1 = tslib_1.__values(hit_test_result_renderers), hit_test_result_renderers_1_1 = hit_test_result_renderers_1.next(); !hit_test_result_renderers_1_1.done; hit_test_result_renderers_1_1 = hit_test_result_renderers_1.next()) {
                        var hit_test_result_other = hit_test_result_renderers_1_1.value;
                        hit_test_result.update_through_intersection(hit_test_result_other);
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (hit_test_result_renderers_1_1 && !hit_test_result_renderers_1_1.done && (_b = hit_test_result_renderers_1.return))
                            _b.call(hit_test_result_renderers_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return IntersectRenderers;
    }(SelectionPolicy));
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    var UnionRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(UnionRenderers, _super);
        function UnionRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnionRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var e_3, _a, e_4, _b;
            var hit_test_result_renderers = [];
            try {
                for (var renderer_views_2 = tslib_1.__values(renderer_views), renderer_views_2_1 = renderer_views_2.next(); !renderer_views_2_1.done; renderer_views_2_1 = renderer_views_2.next()) {
                    var r = renderer_views_2_1.value;
                    var result = r.hit_test(geometry);
                    if (result != null)
                        hit_test_result_renderers.push(result);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (renderer_views_2_1 && !renderer_views_2_1.done && (_a = renderer_views_2.return))
                        _a.call(renderer_views_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                try {
                    for (var hit_test_result_renderers_2 = tslib_1.__values(hit_test_result_renderers), hit_test_result_renderers_2_1 = hit_test_result_renderers_2.next(); !hit_test_result_renderers_2_1.done; hit_test_result_renderers_2_1 = hit_test_result_renderers_2.next()) {
                        var hit_test_result_other = hit_test_result_renderers_2_1.value;
                        hit_test_result.update_through_union(hit_test_result_other);
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (hit_test_result_renderers_2_1 && !hit_test_result_renderers_2_1.done && (_b = hit_test_result_renderers_2.return))
                            _b.call(hit_test_result_renderers_2);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return UnionRenderers;
    }(SelectionPolicy));
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var columnar_data_source_1 = require(185) /* ./columnar_data_source */;
    var types_1 = require(123) /* ../../core/util/types */;
    var object_1 = require(128) /* ../../core/util/object */;
    var typed_array = tslib_1.__importStar(require(191) /* ../../core/util/typed_array */);
    var set_1 = require(192) /* ../../core/util/set */;
    var events_1 = require(150) /* ../../document/events */;
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if (types_1.isArray(col)) {
            var result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if (types_1.isTypedArray(col)) {
            var total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                var start = total_len - rollover;
                var end = col.length;
                // resize col if it is shorter than the rollover length
                var result = void 0;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (var i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (var i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                var tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        var start, step, stop;
        if (types_1.isNumber(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch) {
        var e_1, _a;
        var patched = new Set();
        var patched_range = false;
        try {
            for (var patch_1 = tslib_1.__values(patch), patch_1_1 = patch_1.next(); !patch_1_1.done; patch_1_1 = patch_1.next()) {
                var _b = tslib_1.__read(patch_1_1.value, 2), ind = _b[0], val = _b[1];
                // make the single index case look like the length-3 multi-index case
                var shape = void 0;
                var item = void 0;
                var index = void 0;
                var value = void 0;
                if (types_1.isArray(ind)) {
                    var _c = tslib_1.__read(ind, 1), i = _c[0];
                    patched.add(i);
                    shape = col[i].shape;
                    item = col[i];
                    value = val;
                    // this is basically like NumPy's "newaxis", inserting an empty dimension
                    // makes length 2 and 3 multi-index cases uniform, so that the same code
                    // can handle both
                    if (ind.length === 2) {
                        shape = [1, shape[0]];
                        index = [ind[0], 0, ind[1]];
                    }
                    else
                        index = ind;
                }
                else {
                    if (types_1.isNumber(ind)) {
                        value = [val];
                        patched.add(ind);
                    }
                    else {
                        value = val;
                        patched_range = true;
                    }
                    index = [0, 0, ind];
                    shape = [1, col.length];
                    item = col;
                }
                // now this one nested loop handles all cases
                var flat_index = 0;
                var _d = tslib_1.__read(slice(index[1], shape[0]), 3), istart = _d[0], istop = _d[1], istep = _d[2];
                var _e = tslib_1.__read(slice(index[2], shape[1]), 3), jstart = _e[0], jstop = _e[1], jstep = _e[2];
                for (var i = istart; i < istop; i += istep) {
                    for (var j = jstart; j < jstop; j += jstep) {
                        if (patched_range) {
                            patched.add(j);
                        }
                        item[i * shape[1] + j] = value[flat_index];
                        flat_index++;
                    }
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (patch_1_1 && !patch_1_1.done && (_a = patch_1.return))
                    _a.call(patch_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    var ColumnDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnDataSource, _super);
        function ColumnDataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColumnDataSource.init_ColumnDataSource = function () {
            this.define(function (_a) {
                var Dict = _a.Dict, Any = _a.Any /*Arrayable*/;
                return ({
                    data: [Dict(Any /*Arrayable*/), {}], // TODO: resolve ndarray refs earlier
                });
            });
        };
        ColumnDataSource.prototype.stream = function (new_data, rollover, setter_id) {
            var e_2, _a;
            var data = this.data;
            try {
                for (var _b = tslib_1.__values(object_1.entries(new_data)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], new_column = _d[1];
                    data[name] = stream_to_column(data[name], new_column, rollover);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            this.setv({ data: data }, { silent: true });
            this.streaming.emit();
            if (this.document != null) {
                var hint = new events_1.ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
                this.document._notify_change(this, "data", null, null, { setter_id: setter_id, hint: hint });
            }
        };
        ColumnDataSource.prototype.patch = function (patches, setter_id) {
            var e_3, _a;
            var data = this.data;
            var patched = new Set();
            try {
                for (var _b = tslib_1.__values(object_1.entries(patches)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), column = _d[0], patch = _d[1];
                    patched = set_1.union(patched, patch_to_column(data[column], patch)); // XXX
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            this.setv({ data: data }, { silent: true });
            this.patching.emit(tslib_1.__spreadArray([], tslib_1.__read(patched)));
            if (this.document != null) {
                var hint = new events_1.ColumnsPatchedEvent(this.document, this.ref(), patches);
                this.document._notify_change(this, "data", null, null, { setter_id: setter_id, hint: hint });
            }
        };
        return ColumnDataSource;
    }(columnar_data_source_1.ColumnarDataSource));
    exports.ColumnDataSource = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    ColumnDataSource.init_ColumnDataSource();
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    function concat(array0) {
        var e_1, _a, e_2, _b;
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var n = array0.length;
        try {
            for (var arrays_1 = tslib_1.__values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
                var array = arrays_1_1.value;
                n += array.length;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return))
                    _a.call(arrays_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        var result = new array0.constructor(n);
        result.set(array0, 0);
        var i = array0.length;
        try {
            for (var arrays_2 = tslib_1.__values(arrays), arrays_2_1 = arrays_2.next(); !arrays_2_1.done; arrays_2_1 = arrays_2.next()) {
                var array = arrays_2_1.value;
                result.set(array, i);
                i += array.length;
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (arrays_2_1 && !arrays_2_1.done && (_b = arrays_2.return))
                    _b.call(arrays_2);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return result;
    }
    exports.concat = concat;
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    function union() {
        var e_1, _a, e_2, _b;
        var sets = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sets[_i] = arguments[_i];
        }
        var result = new Set();
        try {
            for (var sets_1 = tslib_1.__values(sets), sets_1_1 = sets_1.next(); !sets_1_1.done; sets_1_1 = sets_1.next()) {
                var set = sets_1_1.value;
                try {
                    for (var set_1 = (e_2 = void 0, tslib_1.__values(set)), set_1_1 = set_1.next(); !set_1_1.done; set_1_1 = set_1.next()) {
                        var item = set_1_1.value;
                        result.add(item);
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (set_1_1 && !set_1_1.done && (_b = set_1.return))
                            _b.call(set_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (sets_1_1 && !sets_1_1.done && (_a = sets_1.return))
                    _a.call(sets_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return result;
    }
    exports.union = union;
    function intersection(set) {
        var e_3, _a, e_4, _b;
        var sets = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sets[_i - 1] = arguments[_i];
        }
        var result = new Set();
        try {
            top: for (var set_2 = tslib_1.__values(set), set_2_1 = set_2.next(); !set_2_1.done; set_2_1 = set_2.next()) {
                var item = set_2_1.value;
                try {
                    for (var sets_2 = (e_4 = void 0, tslib_1.__values(sets)), sets_2_1 = sets_2.next(); !sets_2_1.done; sets_2_1 = sets_2.next()) {
                        var other = sets_2_1.value;
                        if (!other.has(item))
                            continue top;
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (sets_2_1 && !sets_2_1.done && (_b = sets_2.return))
                            _b.call(sets_2);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                result.add(item);
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (set_2_1 && !set_2_1.done && (_a = set_2.return))
                    _a.call(set_2);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(set) {
        var e_5, _a;
        var sets = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sets[_i - 1] = arguments[_i];
        }
        var result = new Set(set);
        try {
            for (var _b = tslib_1.__values(union.apply(void 0, tslib_1.__spreadArray([], tslib_1.__read(sets)))), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                result.delete(item);
            }
        }
        catch (e_5_1) {
            e_5 = { error: e_5_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_5)
                    throw e_5.error;
            }
        }
        return result;
    }
    exports.difference = difference;
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var core_1 = tslib_1.__importDefault(require(194) /* proj4/lib/core */);
    var Proj_1 = tslib_1.__importDefault(require(195) /* proj4/lib/Proj */);
    var types_1 = require(139) /* ../types */;
    var mercator = new Proj_1.default("GOOGLE");
    var wgs84 = new Proj_1.default("WGS84");
    var _wgs84_mercator = core_1.default(wgs84, mercator);
    exports.wgs84_mercator = {
        compute: function (x, y) {
            if (isFinite(x) && isFinite(y))
                return _wgs84_mercator.forward([x, y]);
            else
                return [NaN, NaN];
        },
        invert: function (merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y))
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            else
                return [NaN, NaN];
        },
    };
    var mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    var latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    var min = Math.min, max = Math.max;
    function clip_mercator(low, high, dimension) {
        var _a = tslib_1.__read(mercator_bounds[dimension], 2), vmin = _a[0], vmax = _a[1];
        return [max(low, vmin), min(high, vmax)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        var _a = tslib_1.__read(latlon_bounds[dimension], 2), min = _a[0], max = _a[1];
        return min < value && value < max;
    }
    exports.in_bounds = in_bounds;
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            var n = min(x.length, y.length);
            merc_x = merc_x !== null && merc_x !== void 0 ? merc_x : x;
            merc_y = merc_y !== null && merc_y !== void 0 ? merc_y : y;
            for (var i = 0; i < n; i++) {
                var xi = x[i];
                var yi = y[i];
                var _a = tslib_1.__read(exports.wgs84_mercator.compute(xi, yi), 2), merc_xi = _a[0], merc_yi = _a[1];
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            var n = min(xs.length, ys.length);
            merc_xs = merc_xs !== null && merc_xs !== void 0 ? merc_xs : xs;
            merc_ys = merc_ys !== null && merc_ys !== void 0 ? merc_ys : ys;
            for (var i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        var n = min(x.length, y.length);
        var ArrayType = types_1.infer_type(x, y);
        var merc_x = new ArrayType(n);
        var merc_y = new ArrayType(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        var n = min(xs.length, ys.length);
        var merc_xs = new Array(n);
        var merc_ys = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = tslib_1.__read(project_xy(xs[i], ys[i]), 2), merc_x = _a[0], merc_y = _a[1];
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var Proj_1 = tslib_1.__importDefault(require(195) /* ./Proj */);
    var transform_1 = tslib_1.__importDefault(require(221) /* ./transform */);
    var wgs84 = Proj_1.default('WGS84');
    function transformer(from, to, coords) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = transform_1.default(from, to, coords) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = transform_1.default(from, to, coords);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return Proj_1.default(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords) {
                    return transformer(fromProj, toProj, coords);
                },
                inverse: function (coords) {
                    return transformer(toProj, fromProj, coords);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var parseCode_1 = tslib_1.__importDefault(require(196) /* ./parseCode */);
    var extend_1 = tslib_1.__importDefault(require(207) /* ./extend */);
    var projections_1 = tslib_1.__importDefault(require(208) /* ./projections */);
    var deriveConstants_1 = require(216) /* ./deriveConstants */;
    var Datum_1 = tslib_1.__importDefault(require(218) /* ./constants/Datum */);
    var datum_1 = tslib_1.__importDefault(require(219) /* ./datum */);
    var match_1 = tslib_1.__importDefault(require(203) /* ./match */);
    var nadgrid_1 = require(220) /* ./nadgrid */;
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = parseCode_1.default(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = match_1.default(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = json.datum_params || (datumDef.towgs84 ? datumDef.towgs84.split(',') : null);
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        json.lat1 = json.lat1 || json.lat0; // Lambert_Conformal_Conic_1SP, for example, needs this
        var sphere_ = deriveConstants_1.sphere(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = deriveConstants_1.eccentricity(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var nadgrids = nadgrid_1.getNadgrids(json.nadgrids);
        var datumObj = json.datum || datum_1.default(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2, nadgrids);
        extend_1.default(this, json); // transfer everything over from the projection because we don't know what we'll need
        extend_1.default(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calulated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var defs_1 = tslib_1.__importDefault(require(197) /* ./defs */);
    var wkt_parser_1 = tslib_1.__importDefault(require(204) /* wkt-parser */);
    var projString_1 = tslib_1.__importDefault(require(199) /* ./projString */);
    var match_1 = tslib_1.__importDefault(require(203) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = match_1.default(item, 'authority');
        if (!auth) {
            return;
        }
        var code = match_1.default(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = match_1.default(item, 'extension');
        if (!ext) {
            return;
        }
        return match_1.default(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = wkt_parser_1.default(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return projString_1.default(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return projString_1.default(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var global_1 = tslib_1.__importDefault(require(198) /* ./global */);
    var projString_1 = tslib_1.__importDefault(require(199) /* ./projString */);
    var wkt_parser_1 = tslib_1.__importDefault(require(204) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = projString_1.default(arguments[1]);
                }
                else {
                    defs[name] = wkt_parser_1.default(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    global_1.default(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
    exports.default = default_1;
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(200) /* ./constants/values */;
    var PrimeMeridian_1 = tslib_1.__importDefault(require(201) /* ./constants/PrimeMeridian */);
    var units_1 = tslib_1.__importDefault(require(202) /* ./constants/units */);
    var match_1 = tslib_1.__importDefault(require(203) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            gamma: function (v) {
                self.rectified_grid_angle = parseFloat(v);
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = match_1.default(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = match_1.default(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            },
            approx: function () {
                self.approx = true;
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
    exports.default = default_1;
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_GRIDSHIFT = 3;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SRS_WGS84_SEMIMAJOR = 6378137.0; // only used in grid shift transforms
    exports.SRS_WGS84_SEMIMINOR = 6356752.314; // only used in grid shift transforms
    exports.SRS_WGS84_ESQUARED = 0.0066943799901413165; // only used in grid shift transforms
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
    exports.default = match;
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    var parser_1 = tslib_1.__importDefault(require(205) /* ./parser */);
    var process_1 = require(206) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = wkt.AXIS[i];
                var descriptor = axis[0].toLowerCase();
                if (descriptor.indexOf('north') !== -1) {
                    axisOrder += 'n';
                }
                else if (descriptor.indexOf('south') !== -1) {
                    axisOrder += 's';
                }
                else if (descriptor.indexOf('east') !== -1) {
                    axisOrder += 'e';
                }
                else if (descriptor.indexOf('west') !== -1) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['false_easting', 'False_Easting'],
            ['false_northing', 'False_Northing'],
            ['central_meridian', 'Central_Meridian'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    function default_1(wkt) {
        var lisp = parser_1.default(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        process_1.sExpr(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
    exports.default = default_1;
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
    exports.sExpr = sExpr;
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
    exports.default = default_1;
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var merc_1 = tslib_1.__importDefault(require(209) /* ./projections/merc */);
    var longlat_1 = tslib_1.__importDefault(require(215) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    exports.get = get;
    function start() {
        projs.forEach(add);
    }
    exports.start = start;
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var msfnz_1 = tslib_1.__importDefault(require(210) /* ../common/msfnz */);
    var adjust_lon_1 = tslib_1.__importDefault(require(211) /* ../common/adjust_lon */);
    var tsfnz_1 = tslib_1.__importDefault(require(213) /* ../common/tsfnz */);
    var phi2z_1 = tslib_1.__importDefault(require(214) /* ../common/phi2z */);
    var values_1 = require(200) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = msfnz_1.default(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    exports.init = init;
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = tsfnz_1.default(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    exports.forward = forward;
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = phi2z_1.default(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = adjust_lon_1.default(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.inverse = inverse;
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
    exports.default = default_1;
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(200) /* ../constants/values */;
    var sign_1 = tslib_1.__importDefault(require(212) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - (sign_1.default(x) * values_1.TWO_PI));
    }
    exports.default = default_1;
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
    exports.default = default_1;
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(200) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
    exports.default = default_1;
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(200) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
    exports.default = default_1;
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function init() {
        //no-op for longlat
    }
    exports.init = init;
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(200) /* ./constants/values */;
    var Ellipsoid_1 = tslib_1.__importStar(require(217) /* ./constants/Ellipsoid */);
    var match_1 = tslib_1.__importDefault(require(203) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    exports.eccentricity = eccentricity;
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = match_1.default(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
    exports.sphere = sphere;
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "606.0,23.0,413.0",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "653.0,-212.0,449.0",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(200) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2, nadgrids) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        if (nadgrids) {
            out.datum_type = values_1.PJD_GRIDSHIFT;
            out.grids = nadgrids;
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/nadgrid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var loadedNadgrids = {};
    /**
     * Load a binary NTv2 file (.gsb) to a key that can be used in a proj string like +nadgrids=<key>. Pass the NTv2 file
     * as an ArrayBuffer.
     */
    function nadgrid(key, data) {
        var view = new DataView(data);
        var isLittleEndian = detectLittleEndian(view);
        var header = readHeader(view, isLittleEndian);
        if (header.nSubgrids > 1) {
            console.log('Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored');
        }
        var subgrids = readSubgrids(view, header, isLittleEndian);
        var nadgrid = { header: header, subgrids: subgrids };
        loadedNadgrids[key] = nadgrid;
        return nadgrid;
    }
    exports.default = nadgrid;
    /**
     * Given a proj4 value for nadgrids, return an array of loaded grids
     */
    function getNadgrids(nadgrids) {
        // Format details: http://proj.maptools.org/gen_parms.html
        if (nadgrids === undefined) {
            return null;
        }
        var grids = nadgrids.split(',');
        return grids.map(parseNadgridString);
    }
    exports.getNadgrids = getNadgrids;
    function parseNadgridString(value) {
        if (value.length === 0) {
            return null;
        }
        var optional = value[0] === '@';
        if (optional) {
            value = value.slice(1);
        }
        if (value === 'null') {
            return { name: 'null', mandatory: !optional, grid: null, isNull: true };
        }
        return {
            name: value,
            mandatory: !optional,
            grid: loadedNadgrids[value] || null,
            isNull: false
        };
    }
    function secondsToRadians(seconds) {
        return (seconds / 3600) * Math.PI / 180;
    }
    function detectLittleEndian(view) {
        var nFields = view.getInt32(8, false);
        if (nFields === 11) {
            return false;
        }
        nFields = view.getInt32(8, true);
        if (nFields !== 11) {
            console.warn('Failed to detect nadgrid endian-ness, defaulting to little-endian');
        }
        return true;
    }
    function readHeader(view, isLittleEndian) {
        return {
            nFields: view.getInt32(8, isLittleEndian),
            nSubgridFields: view.getInt32(24, isLittleEndian),
            nSubgrids: view.getInt32(40, isLittleEndian),
            shiftType: decodeString(view, 56, 56 + 8).trim(),
            fromSemiMajorAxis: view.getFloat64(120, isLittleEndian),
            fromSemiMinorAxis: view.getFloat64(136, isLittleEndian),
            toSemiMajorAxis: view.getFloat64(152, isLittleEndian),
            toSemiMinorAxis: view.getFloat64(168, isLittleEndian),
        };
    }
    function decodeString(view, start, end) {
        return String.fromCharCode.apply(null, new Uint8Array(view.buffer.slice(start, end)));
    }
    function readSubgrids(view, header, isLittleEndian) {
        var gridOffset = 176;
        var grids = [];
        for (var i = 0; i < header.nSubgrids; i++) {
            var subHeader = readGridHeader(view, gridOffset, isLittleEndian);
            var nodes = readGridNodes(view, gridOffset, subHeader, isLittleEndian);
            var lngColumnCount = Math.round(1 + (subHeader.upperLongitude - subHeader.lowerLongitude) / subHeader.longitudeInterval);
            var latColumnCount = Math.round(1 + (subHeader.upperLatitude - subHeader.lowerLatitude) / subHeader.latitudeInterval);
            // Proj4 operates on radians whereas the coordinates are in seconds in the grid
            grids.push({
                ll: [secondsToRadians(subHeader.lowerLongitude), secondsToRadians(subHeader.lowerLatitude)],
                del: [secondsToRadians(subHeader.longitudeInterval), secondsToRadians(subHeader.latitudeInterval)],
                lim: [lngColumnCount, latColumnCount],
                count: subHeader.gridNodeCount,
                cvs: mapNodes(nodes)
            });
        }
        return grids;
    }
    function mapNodes(nodes) {
        return nodes.map(function (r) { return [secondsToRadians(r.longitudeShift), secondsToRadians(r.latitudeShift)]; });
    }
    function readGridHeader(view, offset, isLittleEndian) {
        return {
            name: decodeString(view, offset + 8, offset + 16).trim(),
            parent: decodeString(view, offset + 24, offset + 24 + 8).trim(),
            lowerLatitude: view.getFloat64(offset + 72, isLittleEndian),
            upperLatitude: view.getFloat64(offset + 88, isLittleEndian),
            lowerLongitude: view.getFloat64(offset + 104, isLittleEndian),
            upperLongitude: view.getFloat64(offset + 120, isLittleEndian),
            latitudeInterval: view.getFloat64(offset + 136, isLittleEndian),
            longitudeInterval: view.getFloat64(offset + 152, isLittleEndian),
            gridNodeCount: view.getInt32(offset + 168, isLittleEndian)
        };
    }
    function readGridNodes(view, offset, gridHeader, isLittleEndian) {
        var nodesOffset = offset + 176;
        var gridRecordLength = 16;
        var gridShiftRecords = [];
        for (var i = 0; i < gridHeader.gridNodeCount; i++) {
            var record = {
                latitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength, isLittleEndian),
                longitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength + 4, isLittleEndian),
                latitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 8, isLittleEndian),
                longitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 12, isLittleEndian),
            };
            gridShiftRecords.push(record);
        }
        return gridShiftRecords;
    }
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(200) /* ./constants/values */;
    var datum_transform_1 = tslib_1.__importDefault(require(222) /* ./datum_transform */);
    var adjust_axis_1 = tslib_1.__importDefault(require(224) /* ./adjust_axis */);
    var Proj_1 = tslib_1.__importDefault(require(195) /* ./Proj */);
    var toPoint_1 = tslib_1.__importDefault(require(225) /* ./common/toPoint */);
    var checkSanity_1 = tslib_1.__importDefault(require(226) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point) {
        var wgs84;
        if (Array.isArray(point)) {
            point = toPoint_1.default(point);
        }
        checkSanity_1.default(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (source.axis !== 'enu') {
            point = adjust_axis_1.default(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = datum_transform_1.default(source.datum, dest.datum, point);
        if (!point) {
            return;
        }
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (dest.axis !== 'enu') {
            return adjust_axis_1.default(dest, true, point);
        }
        return point;
    }
    exports.default = transform;
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(200) /* ./constants/values */;
    var datumUtils_1 = require(223) /* ./datumUtils */;
    var adjust_lon_1 = tslib_1.__importDefault(require(211) /* ./common/adjust_lon */);
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if (datumUtils_1.compareDatums(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        var source_a = source.a;
        var source_es = source.es;
        if (source.datum_type === values_1.PJD_GRIDSHIFT) {
            var gridShiftCode = applyGridShift(source, false, point);
            if (gridShiftCode !== 0) {
                return undefined;
            }
            source_a = values_1.SRS_WGS84_SEMIMAJOR;
            source_es = values_1.SRS_WGS84_ESQUARED;
        }
        var dest_a = dest.a;
        var dest_b = dest.b;
        var dest_es = dest.es;
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            dest_a = values_1.SRS_WGS84_SEMIMAJOR;
            dest_b = values_1.SRS_WGS84_SEMIMINOR;
            dest_es = values_1.SRS_WGS84_ESQUARED;
        }
        // Do we need to go through geocentric coordinates?
        if (source_es === dest_es && source_a === dest_a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = datumUtils_1.geodeticToGeocentric(point, source_es, source_a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = datumUtils_1.geocentricToWgs84(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = datumUtils_1.geocentricFromWgs84(point, dest.datum_type, dest.datum_params);
        }
        point = datumUtils_1.geocentricToGeodetic(point, dest_es, dest_a, dest_b);
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            var destGridShiftResult = applyGridShift(dest, true, point);
            if (destGridShiftResult !== 0) {
                return undefined;
            }
        }
        return point;
    }
    exports.default = default_1;
    function applyGridShift(source, inverse, point) {
        if (source.grids === null || source.grids.length === 0) {
            console.log('Grid shift grids not found');
            return -1;
        }
        var input = { x: -point.x, y: point.y };
        var output = { x: Number.NaN, y: Number.NaN };
        var onlyMandatoryGrids = false;
        var attemptedGrids = [];
        for (var i = 0; i < source.grids.length; i++) {
            var grid = source.grids[i];
            attemptedGrids.push(grid.name);
            if (grid.isNull) {
                output = input;
                break;
            }
            onlyMandatoryGrids = grid.mandatory;
            if (grid.grid === null) {
                if (grid.mandatory) {
                    console.log("Unable to find mandatory grid '" + grid.name + "'");
                    return -1;
                }
                continue;
            }
            var subgrid = grid.grid.subgrids[0];
            // skip tables that don't match our point at all
            var epsilon = (Math.abs(subgrid.del[1]) + Math.abs(subgrid.del[0])) / 10000.0;
            var minX = subgrid.ll[0] - epsilon;
            var minY = subgrid.ll[1] - epsilon;
            var maxX = subgrid.ll[0] + (subgrid.lim[0] - 1) * subgrid.del[0] + epsilon;
            var maxY = subgrid.ll[1] + (subgrid.lim[1] - 1) * subgrid.del[1] + epsilon;
            if (minY > input.y || minX > input.x || maxY < input.y || maxX < input.x) {
                continue;
            }
            output = applySubgridShift(input, inverse, subgrid);
            if (!isNaN(output.x)) {
                break;
            }
        }
        if (isNaN(output.x)) {
            console.log("Failed to find a grid shift table for location '" +
                -input.x * values_1.R2D + " " + input.y * values_1.R2D + " tried: '" + attemptedGrids + "'");
            return -1;
        }
        point.x = -output.x;
        point.y = output.y;
        return 0;
    }
    exports.applyGridShift = applyGridShift;
    function applySubgridShift(pin, inverse, ct) {
        var val = { x: Number.NaN, y: Number.NaN };
        if (isNaN(pin.x)) {
            return val;
        }
        var tb = { x: pin.x, y: pin.y };
        tb.x -= ct.ll[0];
        tb.y -= ct.ll[1];
        tb.x = adjust_lon_1.default(tb.x - Math.PI) + Math.PI;
        var t = nadInterpolate(tb, ct);
        if (inverse) {
            if (isNaN(t.x)) {
                return val;
            }
            t.x = tb.x - t.x;
            t.y = tb.y - t.y;
            var i = 9, tol = 1e-12;
            var dif, del;
            do {
                del = nadInterpolate(t, ct);
                if (isNaN(del.x)) {
                    console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
                    break;
                }
                dif = { x: tb.x - (del.x + t.x), y: tb.y - (del.y + t.y) };
                t.x += dif.x;
                t.y += dif.y;
            } while (i-- && Math.abs(dif.x) > tol && Math.abs(dif.y) > tol);
            if (i < 0) {
                console.log("Inverse grid shift iterator failed to converge.");
                return val;
            }
            val.x = adjust_lon_1.default(t.x + ct.ll[0]);
            val.y = t.y + ct.ll[1];
        }
        else {
            if (!isNaN(t.x)) {
                val.x = pin.x + t.x;
                val.y = pin.y + t.y;
            }
        }
        return val;
    }
    function nadInterpolate(pin, ct) {
        var t = { x: pin.x / ct.del[0], y: pin.y / ct.del[1] };
        var indx = { x: Math.floor(t.x), y: Math.floor(t.y) };
        var frct = { x: t.x - 1.0 * indx.x, y: t.y - 1.0 * indx.y };
        var val = { x: Number.NaN, y: Number.NaN };
        var inx;
        if (indx.x < 0 || indx.x >= ct.lim[0]) {
            return val;
        }
        if (indx.y < 0 || indx.y >= ct.lim[1]) {
            return val;
        }
        inx = (indx.y * ct.lim[0]) + indx.x;
        var f00 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx++;
        var f10 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx += ct.lim[0];
        var f11 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx--;
        var f01 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        var m11 = frct.x * frct.y, m10 = frct.x * (1.0 - frct.y), m00 = (1.0 - frct.x) * (1.0 - frct.y), m01 = (1.0 - frct.x) * frct.y;
        val.x = (m00 * f00.x + m10 * f10.x + m01 * f01.x + m11 * f11.x);
        val.y = (m00 * f00.y + m10 * f10.y + m01 * f01.y + m11 * f11.y);
        return val;
    }
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(200) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    exports.compareDatums = compareDatums;
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    exports.geodeticToGeocentric = geodeticToGeocentric;
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    exports.geocentricToGeodetic = geocentricToGeodetic;
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    exports.geocentricToWgs84 = geocentricToWgs84;
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
    exports.geocentricFromWgs84 = geocentricFromWgs84;
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    exports.default = default_1;
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var view_1 = require(157) /* ../../core/view */;
    var visuals = tslib_1.__importStar(require(160) /* ../../core/visuals */);
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var ArrowHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowHeadView, _super);
        function ArrowHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowHeadView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this);
        };
        ArrowHeadView.prototype.request_render = function () {
            this.parent.request_render();
        };
        Object.defineProperty(ArrowHeadView.prototype, "canvas", {
            get: function () {
                return this.parent.canvas;
            },
            enumerable: false,
            configurable: true
        });
        ArrowHeadView.prototype.set_data = function (source) {
            var e_1, _a;
            var self = this;
            try {
                for (var _b = tslib_1.__values(this.model), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    var uniform = prop.uniform(source);
                    self["" + prop.attr] = uniform;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return ArrowHeadView;
    }(view_1.View));
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    var ArrowHead = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowHead, _super);
        function ArrowHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        ArrowHead.init_ArrowHead = function () {
            this.define(function () {
                return ({
                    size: [p.NumberSpec, 25],
                });
            });
        };
        return ArrowHead;
    }(model_1.Model));
    exports.ArrowHead = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    ArrowHead.init_ArrowHead();
    var OpenHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(OpenHeadView, _super);
        function OpenHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        OpenHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        OpenHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                var size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, size_i);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * size_i, size_i);
                ctx.stroke();
            }
        };
        return OpenHeadView;
    }(ArrowHeadView));
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    var OpenHead = /** @class */ (function (_super) {
        tslib_1.__extends(OpenHead, _super);
        function OpenHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenHead.init_OpenHead = function () {
            this.prototype.default_view = OpenHeadView;
            this.mixins(property_mixins_1.LineVector);
        };
        return OpenHead;
    }(ArrowHead));
    exports.OpenHead = OpenHead;
    OpenHead.__name__ = "OpenHead";
    OpenHead.init_OpenHead();
    var NormalHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(NormalHeadView, _super);
        function NormalHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NormalHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        NormalHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        };
        NormalHeadView.prototype._normal = function (ctx, i) {
            var size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.closePath();
        };
        return NormalHeadView;
    }(ArrowHeadView));
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    var NormalHead = /** @class */ (function (_super) {
        tslib_1.__extends(NormalHead, _super);
        function NormalHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        NormalHead.init_NormalHead = function () {
            this.prototype.default_view = NormalHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        };
        return NormalHead;
    }(ArrowHead));
    exports.NormalHead = NormalHead;
    NormalHead.__name__ = "NormalHead";
    NormalHead.init_NormalHead();
    var VeeHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(VeeHeadView, _super);
        function VeeHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VeeHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        VeeHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        };
        VeeHeadView.prototype._vee = function (ctx, i) {
            var size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.closePath();
        };
        return VeeHeadView;
    }(ArrowHeadView));
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    var VeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(VeeHead, _super);
        function VeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        VeeHead.init_VeeHead = function () {
            this.prototype.default_view = VeeHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        };
        return VeeHead;
    }(ArrowHead));
    exports.VeeHead = VeeHead;
    VeeHead.__name__ = "VeeHead";
    VeeHead.init_VeeHead();
    var TeeHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(TeeHeadView, _super);
        function TeeHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TeeHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                var size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, 0);
                ctx.lineTo(-0.5 * size_i, 0);
                ctx.stroke();
            }
        };
        TeeHeadView.prototype.clip = function (_ctx, _i) { };
        return TeeHeadView;
    }(ArrowHeadView));
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    var TeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(TeeHead, _super);
        function TeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        TeeHead.init_TeeHead = function () {
            this.prototype.default_view = TeeHeadView;
            this.mixins(property_mixins_1.LineVector);
        };
        return TeeHead;
    }(ArrowHead));
    exports.TeeHead = TeeHead;
    TeeHead.__name__ = "TeeHead";
    TeeHead.init_TeeHead();
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var array_1 = require(124) /* ./util/array */;
    function _build_view(view_cls, model, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = new view_cls(tslib_1.__assign(tslib_1.__assign({}, options), { model: model }));
                        view.initialize();
                        return [4 /*yield*/, view.lazy_initialize()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, view];
                }
            });
        });
    }
    function build_view(model, options, cls) {
        if (options === void 0) {
            options = { parent: null };
        }
        if (cls === void 0) {
            cls = function (model) { return model.default_view; };
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, _build_view(cls(model), model, options)];
                    case 1:
                        view = _a.sent();
                        view.connect_signals();
                        return [2 /*return*/, view];
                }
            });
        });
    }
    exports.build_view = build_view;
    function build_views(view_storage, models, options, cls) {
        if (options === void 0) {
            options = { parent: null };
        }
        if (cls === void 0) {
            cls = function (model) { return model.default_view; };
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var to_remove, to_remove_1, to_remove_1_1, model, created_views, new_models, new_models_1, new_models_1_1, model, view, e_1_1, created_views_1, created_views_1_1, view;
            var e_2, _a, e_1, _b, e_3, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        to_remove = array_1.difference(tslib_1.__spreadArray([], tslib_1.__read(view_storage.keys())), models);
                        try {
                            for (to_remove_1 = tslib_1.__values(to_remove), to_remove_1_1 = to_remove_1.next(); !to_remove_1_1.done; to_remove_1_1 = to_remove_1.next()) {
                                model = to_remove_1_1.value;
                                view_storage.get(model).remove();
                                view_storage.delete(model);
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (to_remove_1_1 && !to_remove_1_1.done && (_a = to_remove_1.return))
                                    _a.call(to_remove_1);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        created_views = [];
                        new_models = models.filter(function (model) { return !view_storage.has(model); });
                        _d.label = 1;
                    case 1:
                        _d.trys.push([1, 6, 7, 8]);
                        new_models_1 = tslib_1.__values(new_models), new_models_1_1 = new_models_1.next();
                        _d.label = 2;
                    case 2:
                        if (!!new_models_1_1.done)
                            return [3 /*break*/, 5];
                        model = new_models_1_1.value;
                        return [4 /*yield*/, _build_view(cls(model), model, options)];
                    case 3:
                        view = _d.sent();
                        view_storage.set(model, view);
                        created_views.push(view);
                        _d.label = 4;
                    case 4:
                        new_models_1_1 = new_models_1.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_1_1 = _d.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (new_models_1_1 && !new_models_1_1.done && (_b = new_models_1.return))
                                _b.call(new_models_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                        return [7 /*endfinally*/];
                    case 8:
                        try {
                            for (created_views_1 = tslib_1.__values(created_views), created_views_1_1 = created_views_1.next(); !created_views_1_1.done; created_views_1_1 = created_views_1.next()) {
                                view = created_views_1_1.value;
                                view.connect_signals();
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (created_views_1_1 && !created_views_1_1.done && (_c = created_views_1.return))
                                    _c.call(created_views_1);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                        return [2 /*return*/, created_views];
                }
            });
        });
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        var e_4, _a;
        try {
            for (var view_storage_1 = tslib_1.__values(view_storage), view_storage_1_1 = view_storage_1.next(); !view_storage_1_1.done; view_storage_1_1 = view_storage_1.next()) {
                var _b = tslib_1.__read(view_storage_1_1.value, 2), model = _b[0], view = _b[1];
                view.remove();
                view_storage.delete(model);
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (view_storage_1_1 && !view_storage_1_1.done && (_a = view_storage_1.return))
                    _a.call(view_storage_1);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
    }
    exports.remove_views = remove_views;
},
/* models/annotations/band.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var upper_lower_1 = require(230) /* ./upper_lower */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var BandView = /** @class */ (function (_super) {
        tslib_1.__extends(BandView, _super);
        function BandView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BandView.prototype.paint = function (ctx) {
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var i = this._upper_sx.length - 1; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            this.visuals.line.apply(ctx);
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            this.visuals.line.apply(ctx);
        };
        return BandView;
    }(upper_lower_1.UpperLowerView));
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    var Band = /** @class */ (function (_super) {
        tslib_1.__extends(Band, _super);
        function Band(attrs) {
            return _super.call(this, attrs) || this;
        }
        Band.init_Band = function () {
            this.prototype.default_view = BandView;
            this.mixins([mixins.Line, mixins.Fill]);
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        };
        return Band;
    }(upper_lower_1.UpperLower));
    exports.Band = Band;
    Band.__name__ = "Band";
    Band.init_Band();
},
/* models/annotations/upper_lower.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_annotation_1 = require(184) /* ./data_annotation */;
    var enums_1 = require(135) /* ../../core/enums */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var UpperLowerView = /** @class */ (function (_super) {
        tslib_1.__extends(UpperLowerView, _super);
        function UpperLowerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UpperLowerView.prototype.map_data = function () {
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = this.coordinates.x_scale;
            var yscale = this.coordinates.y_scale;
            var limit_scale = dim == "height" ? yscale : xscale;
            var base_scale = dim == "height" ? xscale : yscale;
            var limit_view = dim == "height" ? frame.bbox.yview : frame.bbox.xview;
            var base_view = dim == "height" ? frame.bbox.xview : frame.bbox.yview;
            var _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = tslib_1.__read(dim == "height" ? [1, 0] : [0, 1], 2), i = _a[0], j = _a[1];
            var _lower = [_lower_sx, _base_sx];
            var _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        return UpperLowerView;
    }(data_annotation_1.DataAnnotationView));
    exports.UpperLowerView = UpperLowerView;
    UpperLowerView.__name__ = "UpperLowerView";
    var XOrYCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XOrYCoordinateSpec, _super);
        function XOrYCoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(XOrYCoordinateSpec.prototype, "dimension", {
            get: function () {
                return this.obj.dimension == "width" ? "x" : "y";
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(XOrYCoordinateSpec.prototype, "units", {
            // XXX: a hack to make a coordinate & unit spec
            get: function () {
                var _a;
                return (_a = this.spec.units) !== null && _a !== void 0 ? _a : "data";
            },
            enumerable: false,
            configurable: true
        });
        return XOrYCoordinateSpec;
    }(p.CoordinateSpec));
    exports.XOrYCoordinateSpec = XOrYCoordinateSpec;
    XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
    var UpperLower = /** @class */ (function (_super) {
        tslib_1.__extends(UpperLower, _super);
        function UpperLower(attrs) {
            return _super.call(this, attrs) || this;
        }
        UpperLower.init_UpperLower = function () {
            this.define(function () {
                return ({
                    dimension: [enums_1.Dimension, "height"],
                    lower: [XOrYCoordinateSpec, { field: "lower" }],
                    upper: [XOrYCoordinateSpec, { field: "upper" }],
                    base: [XOrYCoordinateSpec, { field: "base" }],
                });
            });
        };
        return UpperLower;
    }(data_annotation_1.DataAnnotation));
    exports.UpperLower = UpperLower;
    UpperLower.__name__ = "UpperLower";
    UpperLower.init_UpperLower();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var enums_1 = require(135) /* ../../core/enums */;
    var bbox_1 = require(180) /* ../../core/util/bbox */;
    exports.EDGE_TOLERANCE = 2.5;
    var BoxAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotationView, _super);
        function BoxAnnotationView() {
            var _this = _super.apply(this, tslib_1.__spreadArray([], tslib_1.__read(arguments))) || this;
            _this.bbox = new bbox_1.BBox();
            return _this;
        }
        BoxAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.request_render(); });
        };
        BoxAnnotationView.prototype._render = function () {
            var _this = this;
            var _a = this.model, left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            // don't render if *all* position are null
            if (left == null && right == null && top == null && bottom == null)
                return;
            var frame = this.plot_view.frame;
            var xscale = this.coordinates.x_scale;
            var yscale = this.coordinates.y_scale;
            var _calc_dim = function (dim, dim_units, scale, view, frame_extrema) {
                var sdim;
                if (dim != null) {
                    if (_this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == "data")
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                }
                else
                    sdim = frame_extrema;
                return sdim;
            };
            this.bbox = bbox_1.BBox.from_rect({
                left: _calc_dim(left, this.model.left_units, xscale, frame.bbox.xview, frame.bbox.left),
                right: _calc_dim(right, this.model.right_units, xscale, frame.bbox.xview, frame.bbox.right),
                top: _calc_dim(top, this.model.top_units, yscale, frame.bbox.yview, frame.bbox.top),
                bottom: _calc_dim(bottom, this.model.bottom_units, yscale, frame.bbox.yview, frame.bbox.bottom),
            });
            this._paint_box();
        };
        BoxAnnotationView.prototype._paint_box = function () {
            var ctx = this.layer.ctx;
            ctx.save();
            var _a = this.bbox, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
            ctx.beginPath();
            ctx.rect(left, top, width, height);
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
            ctx.restore();
        };
        BoxAnnotationView.prototype.interactive_bbox = function () {
            var tolerance = this.model.line_width + exports.EDGE_TOLERANCE;
            return this.bbox.grow_by(tolerance);
        };
        BoxAnnotationView.prototype.interactive_hit = function (sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            var bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        };
        BoxAnnotationView.prototype.cursor = function (sx, sy) {
            var tol = 3;
            var _a = this.bbox, left = _a.left, right = _a.right, bottom = _a.bottom, top = _a.top;
            if (Math.abs(sx - left) < tol || Math.abs(sx - right) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - bottom) < tol || Math.abs(sy - top) < tol)
                return this.model.ns_cursor;
            else if (this.bbox.contains(sx, sy))
                return this.model.in_cursor;
            else
                return null;
        };
        return BoxAnnotationView;
    }(annotation_1.AnnotationView));
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    var BoxAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotation, _super);
        function BoxAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        BoxAnnotation.init_BoxAnnotation = function () {
            this.prototype.default_view = BoxAnnotationView;
            this.mixins([mixins.Line, mixins.Fill, mixins.Hatch]);
            this.define(function (_a) {
                var Number = _a.Number, Nullable = _a.Nullable;
                return ({
                    top: [Nullable(Number), null],
                    top_units: [enums_1.SpatialUnits, "data"],
                    bottom: [Nullable(Number), null],
                    bottom_units: [enums_1.SpatialUnits, "data"],
                    left: [Nullable(Number), null],
                    left_units: [enums_1.SpatialUnits, "data"],
                    right: [Nullable(Number), null],
                    right_units: [enums_1.SpatialUnits, "data"],
                    /** @deprecated */
                    render_mode: [enums_1.RenderMode, "canvas"],
                });
            });
            this.internal(function (_a) {
                var Boolean = _a.Boolean, String = _a.String, Nullable = _a.Nullable;
                return ({
                    screen: [Boolean, false],
                    ew_cursor: [Nullable(String), null],
                    ns_cursor: [Nullable(String), null],
                    in_cursor: [Nullable(String), null],
                });
            });
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        };
        BoxAnnotation.prototype.update = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            this.setv({ left: left, right: right, top: top, bottom: bottom, screen: true });
        };
        return BoxAnnotation;
    }(annotation_1.Annotation));
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    BoxAnnotation.init_BoxAnnotation();
},
/* models/annotations/color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var title_1 = require(233) /* ./title */;
    var cartesian_frame_1 = require(239) /* ../canvas/cartesian_frame */;
    var axes_1 = require(240) /* ../axes */;
    var ticker_1 = require(243) /* ../tickers/ticker */;
    var tickers_1 = require(276) /* ../tickers */;
    var tick_formatter_1 = require(244) /* ../formatters/tick_formatter */;
    var formatters_1 = require(303) /* ../formatters */;
    var labeling_1 = require(247) /* ../policies/labeling */;
    var color_mapper_1 = require(281) /* ../mappers/color_mapper */;
    var continuous_color_mapper_1 = require(280) /* ../mappers/continuous_color_mapper */;
    var mappers_1 = require(307) /* ../mappers */;
    var scales_1 = require(315) /* ../scales */;
    var ranges_1 = require(317) /* ../ranges */;
    var enums_1 = require(135) /* ../../core/enums */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var array_1 = require(124) /* ../../core/util/array */;
    var layout_1 = require(318) /* ../../core/layout */;
    var alignments_1 = require(319) /* ../../core/layout/alignments */;
    var border_1 = require(322) /* ../../core/layout/border */;
    var side_panel_1 = require(235) /* ../../core/layout/side_panel */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var build_views_1 = require(228) /* ../../core/build_views */;
    var types_1 = require(123) /* ../../core/util/types */;
    var MINOR_DIM = 25;
    var MAJOR_DIM_MIN_SCALAR = 0.3;
    var MAJOR_DIM_MAX_SCALAR = 0.8;
    var ColorBarView = /** @class */ (function (_super) {
        tslib_1.__extends(ColorBarView, _super);
        function ColorBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(ColorBarView.prototype, "orientation", {
            get: function () {
                return this._orientation;
            },
            enumerable: false,
            configurable: true
        });
        ColorBarView.prototype.initialize = function () {
            var _this = this;
            _super.prototype.initialize.call(this);
            var _a = this.model, ticker = _a.ticker, formatter = _a.formatter, color_mapper = _a.color_mapper;
            this._ticker = ticker != "auto" ? ticker : (function () {
                switch (true) {
                    case color_mapper instanceof mappers_1.LogColorMapper:
                        return new tickers_1.LogTicker();
                    case color_mapper instanceof mappers_1.ScanningColorMapper:
                        return new tickers_1.BinnedTicker({ mapper: color_mapper });
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new tickers_1.CategoricalTicker();
                    default:
                        return new tickers_1.BasicTicker();
                }
            })();
            this._formatter = formatter != "auto" ? formatter : (function () {
                switch (true) {
                    case _this._ticker instanceof tickers_1.LogTicker:
                        return new formatters_1.LogTickFormatter();
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new formatters_1.CategoricalTickFormatter();
                    default:
                        return new formatters_1.BasicTickFormatter();
                }
            })();
            /*
            Creates and returns a scale instance that maps the `color_mapper` range
            (low to high) to a screen space range equal to the length of the ColorBar's
            scale image. The scale is used to calculate the tick coordinates in screen
            coordinates for plotting purposes.
        
            Note: the type of color_mapper has to match the type of scale (i.e.
            a LinearColorMapper will require a corresponding LinearScale instance).
            */
            this._major_range = (function () {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    var factors = color_mapper.factors;
                    return new ranges_1.FactorRange({ factors: factors });
                }
                else if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper) {
                    var _a = color_mapper.metrics, min = _a.min, max = _a.max;
                    return new ranges_1.Range1d({ start: min, end: max });
                }
                else
                    assert_1.unreachable();
            })();
            this._major_scale = (function () {
                if (color_mapper instanceof mappers_1.LinearColorMapper)
                    return new scales_1.LinearScale();
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return new scales_1.LogScale();
                else if (color_mapper instanceof mappers_1.ScanningColorMapper) {
                    var binning = color_mapper.metrics.binning;
                    return new scales_1.LinearInterpolationScale({ binning: binning });
                }
                else if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    return new scales_1.CategoricalScale();
                }
                else
                    assert_1.unreachable();
            })();
            this._minor_range = new ranges_1.Range1d({ start: 0, end: 1 });
            this._minor_scale = new scales_1.LinearScale();
            var major_label_text = mixins.attrs_of(this.model, "major_label_", mixins.Text, true);
            var major_tick_line = mixins.attrs_of(this.model, "major_tick_", mixins.Line, true);
            var minor_tick_line = mixins.attrs_of(this.model, "minor_tick_", mixins.Line, true);
            var title_text = mixins.attrs_of(this.model, "title_", mixins.Text);
            var AxisCls = (function () {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper)
                    return axes_1.CategoricalAxis;
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return axes_1.LogAxis;
                else
                    return axes_1.LinearAxis;
            })();
            this._axis = new AxisCls(tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({ ticker: this._ticker, formatter: this._formatter, major_tick_in: this.model.major_tick_in, major_tick_out: this.model.major_tick_out, minor_tick_in: this.model.minor_tick_in, minor_tick_out: this.model.minor_tick_out, major_label_standoff: this.model.label_standoff, major_label_overrides: this.model.major_label_overrides, major_label_policy: this.model.major_label_policy, axis_line_color: null }, major_label_text), major_tick_line), minor_tick_line));
            var title = this.model.title;
            if (title) {
                this._title = new title_1.Title(tslib_1.__assign({ text: title, standoff: this.model.title_standoff }, title_text));
            }
        };
        ColorBarView.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var self, parent, _a, _b;
                return tslib_1.__generator(this, function (_c) {
                    switch (_c.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _c.sent();
                            self = this;
                            parent = {
                                get parent() {
                                    return self.parent;
                                },
                                get root() {
                                    return self.root;
                                },
                                get frame() {
                                    return self._frame;
                                },
                                get canvas_view() {
                                    return self.parent.canvas_view;
                                },
                                request_layout: function () {
                                    self.parent.request_layout();
                                },
                            };
                            _a = this;
                            return [4 /*yield*/, build_views_1.build_view(this._axis, { parent: parent })];
                        case 2:
                            _a._axis_view = _c.sent();
                            if (!(this._title != null))
                                return [3 /*break*/, 4];
                            _b = this;
                            return [4 /*yield*/, build_views_1.build_view(this._title, { parent: parent })];
                        case 3:
                            _b._title_view = _c.sent();
                            _c.label = 4;
                        case 4: return [2 /*return*/];
                    }
                });
            });
        };
        ColorBarView.prototype.remove = function () {
            var _a;
            (_a = this._title_view) === null || _a === void 0 ? void 0 : _a.remove();
            this._axis_view.remove();
            _super.prototype.remove.call(this);
        };
        ColorBarView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // TODO: this.connect(this.model.change, () => this.plot_view.invalidate_layout())
            this.connect(this._ticker.change, function () { return _this.request_render(); });
            this.connect(this._formatter.change, function () { return _this.request_render(); });
            this.connect(this.model.color_mapper.metrics_change, function () {
                var range = _this._major_range;
                var scale = _this._major_scale;
                var color_mapper = _this.model.color_mapper;
                if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper && range instanceof ranges_1.Range1d) {
                    var _a = color_mapper.metrics, min = _a.min, max = _a.max;
                    range.setv({ start: min, end: max });
                }
                if (color_mapper instanceof mappers_1.ScanningColorMapper && scale instanceof scales_1.LinearInterpolationScale) {
                    var binning = color_mapper.metrics.binning;
                    scale.binning = binning;
                }
                _this._set_canvas_image();
                _this.plot_view.request_layout(); // this.request_render()
            });
        };
        ColorBarView.prototype._set_canvas_image = function () {
            var _this = this;
            var orientation = this.orientation;
            var palette = (function () {
                var palette = _this.model.color_mapper.palette;
                if (orientation == "vertical")
                    return array_1.reversed(palette);
                else
                    return palette;
            })();
            var _a = tslib_1.__read((function () {
                if (orientation == "vertical")
                    return [1, palette.length];
                else
                    return [palette.length, 1];
            })(), 2), w = _a[0], h = _a[1];
            var canvas = this._image = document.createElement("canvas");
            canvas.width = w;
            canvas.height = h;
            var image_ctx = canvas.getContext("2d");
            var image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            var cmap = new mappers_1.LinearColorMapper({ palette: palette }).rgba_mapper;
            var buf8 = cmap.v_compute(array_1.range(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
        };
        ColorBarView.prototype.update_layout = function () {
            var _this = this;
            var _a = this.model, location = _a.location, w = _a.width, h = _a.height, padding = _a.padding, margin = _a.margin;
            var _b = tslib_1.__read((function () {
                if (types_1.isString(location)) {
                    switch (location) {
                        case "top_left":
                            return ["start", "start"];
                        case "top":
                        case "top_center":
                            return ["start", "center"];
                        case "top_right":
                            return ["start", "end"];
                        case "bottom_left":
                            return ["end", "start"];
                        case "bottom":
                        case "bottom_center":
                            return ["end", "center"];
                        case "bottom_right":
                            return ["end", "end"];
                        case "left":
                        case "center_left":
                            return ["center", "start"];
                        case "center":
                        case "center_center":
                            return ["center", "center"];
                        case "right":
                        case "center_right":
                            return ["center", "end"];
                    }
                }
                else
                    return ["end", "start"]; // "bottom_left"
            })(), 2), valign = _b[0], halign = _b[1];
            var orientation = this._orientation = (function () {
                var orientation = _this.model.orientation;
                if (orientation == "auto") {
                    if (_this.panel != null)
                        return _this.panel.is_horizontal ? "horizontal" : "vertical";
                    else {
                        if (halign == "start" || halign == "end" || (halign == "center" && valign == "center"))
                            return "vertical";
                        else
                            return "horizontal";
                    }
                }
                else
                    return orientation;
            })();
            var center_panel = new alignments_1.NodeLayout();
            var top_panel = new alignments_1.VStack();
            var bottom_panel = new alignments_1.VStack();
            var left_panel = new alignments_1.HStack();
            var right_panel = new alignments_1.HStack();
            center_panel.absolute = true;
            top_panel.absolute = true;
            bottom_panel.absolute = true;
            left_panel.absolute = true;
            right_panel.absolute = true;
            var _c = tslib_1.__read((function () {
                if (orientation == "horizontal")
                    return [_this._major_scale, _this._minor_scale, _this._major_range, _this._minor_range];
                else
                    return [_this._minor_scale, _this._major_scale, _this._minor_range, _this._major_range];
            })(), 4), x_scale = _c[0], y_scale = _c[1], x_range = _c[2], y_range = _c[3];
            this._frame = new cartesian_frame_1.CartesianFrame(x_scale, y_scale, x_range, y_range);
            center_panel.on_resize(function (bbox) { return _this._frame.set_geometry(bbox); });
            var layout = new border_1.BorderLayout();
            this._inner_layout = layout;
            layout.absolute = true;
            layout.center_panel = center_panel;
            layout.top_panel = top_panel;
            layout.bottom_panel = bottom_panel;
            layout.left_panel = left_panel;
            layout.right_panel = right_panel;
            var padding_box = { left: padding, right: padding, top: padding, bottom: padding };
            var margin_box = (function () {
                if (_this.panel == null) {
                    if (types_1.isString(location))
                        return { left: margin, right: margin, top: margin, bottom: margin };
                    else {
                        var _a = tslib_1.__read(location, 2), left = _a[0], bottom = _a[1];
                        return { left: left, right: margin, top: margin, bottom: bottom };
                    }
                }
                else {
                    if (types_1.isString(location))
                        return undefined;
                    else {
                        var _b = tslib_1.__read(location, 2), left = _b[0], bottom = _b[1];
                        return { left: left, right: 0, top: 0, bottom: bottom };
                    }
                }
            })();
            layout.padding = padding_box;
            var major_policy;
            var major_size;
            var min_major_size;
            var max_major_size;
            if (this.panel != null) {
                major_policy = "max";
                major_size = undefined;
                min_major_size = undefined;
                max_major_size = undefined;
            }
            else {
                if ((orientation == "horizontal" ? w : h) == "auto") {
                    major_policy = "fixed";
                    major_size = this.model.color_mapper.palette.length * MINOR_DIM;
                    min_major_size = { percent: MAJOR_DIM_MIN_SCALAR };
                    max_major_size = { percent: MAJOR_DIM_MAX_SCALAR };
                }
                else {
                    major_policy = "fit";
                    major_size = undefined;
                }
            }
            if (orientation == "horizontal") {
                var width = w == "auto" ? undefined : w;
                var height = h == "auto" ? MINOR_DIM : h;
                layout.set_sizing({
                    width_policy: major_policy, height_policy: "min",
                    width: major_size, min_width: min_major_size, max_width: max_major_size,
                    halign: halign, valign: valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: w == "auto" ? "fit" : "fixed", height_policy: "fixed", width: width, height: height });
            }
            else {
                var width = w == "auto" ? MINOR_DIM : w;
                var height = h == "auto" ? undefined : h;
                layout.set_sizing({
                    width_policy: "min", height_policy: major_policy,
                    height: major_size, min_height: min_major_size, max_height: max_major_size,
                    halign: halign, valign: valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: "fixed", height_policy: h == "auto" ? "fit" : "fixed", width: width, height: height });
            }
            top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            var _title_view = this._title_view;
            if (_title_view != null) {
                if (orientation == "horizontal") {
                    _title_view.panel = new side_panel_1.Panel("above");
                    _title_view.update_layout();
                    top_panel.children.push(_title_view.layout);
                }
                else {
                    _title_view.panel = new side_panel_1.Panel("left");
                    _title_view.update_layout();
                    left_panel.children.push(_title_view.layout);
                }
            }
            var panel = this.panel;
            var side = (function () {
                if (panel != null && orientation == panel.orientation)
                    return panel.side;
                else
                    return orientation == "horizontal" ? "below" : "right";
            })();
            var stack = (function () {
                switch (side) {
                    case "above":
                        return top_panel;
                    case "below":
                        return bottom_panel;
                    case "left":
                        return left_panel;
                    case "right":
                        return right_panel;
                }
            })();
            var _axis_view = this._axis_view;
            _axis_view.panel = new side_panel_1.Panel(side);
            _axis_view.update_layout();
            stack.children.push(_axis_view.layout);
            if (this.panel != null) {
                var outer = new layout_1.Grid([{ layout: layout, row: 0, col: 0 }]);
                outer.absolute = true;
                if (orientation == "horizontal") {
                    outer.set_sizing({ width_policy: "max", height_policy: "min" });
                }
                else {
                    outer.set_sizing({ width_policy: "min", height_policy: "max" });
                }
                this.layout = outer;
            }
            else {
                this.layout = this._inner_layout;
            }
            var visible = this.model.visible;
            this.layout.sizing.visible = visible;
            this._set_canvas_image();
        };
        ColorBarView.prototype._render = function () {
            var _a;
            var ctx = this.layer.ctx;
            ctx.save();
            this._paint_bbox(ctx, this._inner_layout.bbox);
            this._paint_image(ctx, this._inner_layout.center_panel.bbox);
            (_a = this._title_view) === null || _a === void 0 ? void 0 : _a.render();
            this._axis_view.render();
            ctx.restore();
        };
        ColorBarView.prototype._paint_bbox = function (ctx, bbox) {
            var x = bbox.x, y = bbox.y;
            var width = bbox.width, height = bbox.height;
            // XXX: shrink outline region by 1px to make right and bottom lines visible
            // if they are on the edge of the canvas.
            if (x + width >= this.parent.canvas_view.bbox.width) {
                width -= 1;
            }
            if (y + height >= this.parent.canvas_view.bbox.height) {
                height -= 1;
            }
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(x, y, width, height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(x, y, width, height);
            }
            ctx.restore();
        };
        ColorBarView.prototype._paint_image = function (ctx, bbox) {
            var x = bbox.x, y = bbox.y, width = bbox.width, height = bbox.height;
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this._image, x, y, width, height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(x, y, width, height);
            }
            ctx.restore();
        };
        ColorBarView.prototype.serializable_state = function () {
            var _a = _super.prototype.serializable_state.call(this), _b = _a.children, children = _b === void 0 ? [] : _b, state = tslib_1.__rest(_a, ["children"]);
            if (this._title_view != null)
                children.push(this._title_view.serializable_state());
            children.push(this._axis_view.serializable_state());
            return tslib_1.__assign(tslib_1.__assign({}, state), { children: children });
        };
        return ColorBarView;
    }(annotation_1.AnnotationView));
    exports.ColorBarView = ColorBarView;
    ColorBarView.__name__ = "ColorBarView";
    var ColorBar = /** @class */ (function (_super) {
        tslib_1.__extends(ColorBar, _super);
        function ColorBar(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColorBar.init_ColorBar = function () {
            this.prototype.default_view = ColorBarView;
            this.mixins([
                ["major_label_", mixins.Text],
                ["title_", mixins.Text],
                ["major_tick_", mixins.Line],
                ["minor_tick_", mixins.Line],
                ["border_", mixins.Line],
                ["bar_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(function (_a) {
                var Alpha = _a.Alpha, Number = _a.Number, String = _a.String, Tuple = _a.Tuple, Dict = _a.Dict, Or = _a.Or, Ref = _a.Ref, Auto = _a.Auto, Nullable = _a.Nullable;
                return ({
                    location: [Or(enums_1.Anchor, Tuple(Number, Number)), "top_right"],
                    orientation: [Or(enums_1.Orientation, Auto), "auto"],
                    title: [Nullable(String), null],
                    title_standoff: [Number, 2],
                    width: [Or(Number, Auto), "auto"],
                    height: [Or(Number, Auto), "auto"],
                    scale_alpha: [Alpha, 1.0],
                    ticker: [Or(Ref(ticker_1.Ticker), Auto), "auto"],
                    formatter: [Or(Ref(tick_formatter_1.TickFormatter), Auto), "auto"],
                    major_label_overrides: [Dict(String), {}],
                    major_label_policy: [Ref(labeling_1.LabelingPolicy), function () { return new labeling_1.NoOverlap(); }],
                    color_mapper: [Ref(color_mapper_1.ColorMapper)],
                    label_standoff: [Number, 5],
                    margin: [Number, 30],
                    padding: [Number, 10],
                    major_tick_in: [Number, 5],
                    major_tick_out: [Number, 0],
                    minor_tick_in: [Number, 0],
                    minor_tick_out: [Number, 0],
                });
            });
            this.override({
                background_fill_color: "#ffffff",
                background_fill_alpha: 0.95,
                bar_line_color: null,
                border_line_color: null,
                major_label_text_font_size: "11px",
                major_tick_line_color: "#ffffff",
                minor_tick_line_color: null,
                title_text_font_size: "13px",
                title_text_font_style: "italic",
            });
        };
        return ColorBar;
    }(annotation_1.Annotation));
    exports.ColorBar = ColorBar;
    ColorBar.__name__ = "ColorBar";
    ColorBar.init_ColorBar();
},
/* models/annotations/title.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var text_annotation_1 = require(234) /* ./text_annotation */;
    var enums_1 = require(135) /* ../../core/enums */;
    var text_1 = require(238) /* ../../core/util/text */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var TitleView = /** @class */ (function (_super) {
        tslib_1.__extends(TitleView, _super);
        function TitleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TitleView.prototype._get_location = function () {
            var hmargin = this.model.offset;
            var vmargin = this.model.standoff / 2;
            var sx, sy;
            var bbox = this.layout.bbox;
            switch (this.panel.side) {
                case "above":
                case "below": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sy = bbox.top + vmargin;
                            break;
                        case "middle":
                            sy = bbox.vcenter;
                            break;
                        case "bottom":
                            sy = bbox.bottom - vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sx = bbox.left + hmargin;
                            break;
                        case "center":
                            sx = bbox.hcenter;
                            break;
                        case "right":
                            sx = bbox.right - hmargin;
                            break;
                    }
                    break;
                }
                case "left": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sx = bbox.left + vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.right - vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sy = bbox.bottom - hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.top + hmargin;
                            break;
                    }
                    break;
                }
                case "right": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sx = bbox.right - vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.left + vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sy = bbox.top + hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.bottom - hmargin;
                            break;
                    }
                    break;
                }
            }
            return [sx, sy];
        };
        TitleView.prototype._render = function () {
            var text = this.model.text;
            if (text == null || text.length == 0)
                return;
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            var _a = tslib_1.__read(this._get_location(), 2), sx = _a[0], sy = _a[1];
            var angle = this.panel.get_label_angle_heuristic("parallel");
            var draw = this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.layer.ctx, text, sx, sy, angle);
        };
        TitleView.prototype._get_size = function () {
            var text = this.model.text;
            if (text == null || text.length == 0)
                return { width: 0, height: 0 };
            else {
                var ctx = this.layer.ctx;
                this.visuals.text.set_value(ctx);
                var width = this.layer.ctx.measureText(text).width;
                var height = text_1.font_metrics(ctx.font).height;
                // XXX: The magic 2px is for backwards compatibility. This will be removed at
                // some point, but currently there is no point breaking half of visual tests.
                return { width: width, height: 2 + height * this.model.text_line_height + this.model.standoff };
            }
        };
        return TitleView;
    }(text_annotation_1.TextAnnotationView));
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    var Title = /** @class */ (function (_super) {
        tslib_1.__extends(Title, _super);
        function Title(attrs) {
            return _super.call(this, attrs) || this;
        }
        Title.init_Title = function () {
            this.prototype.default_view = TitleView;
            this.mixins([
                mixins.Text,
                ["border_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(function (_a) {
                var Number = _a.Number, String = _a.String;
                return ({
                    text: [String, ""],
                    vertical_align: [enums_1.VerticalAlign, "bottom"],
                    align: [enums_1.TextAlign, "left"],
                    offset: [Number, 0],
                    standoff: [Number, 10],
                });
            });
            this.prototype._props.text_align.options.internal = true;
            this.prototype._props.text_baseline.options.internal = true;
            this.override({
                text_font_size: "13px",
                text_font_style: "bold",
                text_line_height: 1.0,
                background_fill_color: null,
                border_line_color: null,
            });
        };
        return Title;
    }(text_annotation_1.TextAnnotation));
    exports.Title = Title;
    Title.__name__ = "Title";
    Title.init_Title();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var dom_1 = require(158) /* ../../core/dom */;
    var enums_1 = require(135) /* ../../core/enums */;
    var side_panel_1 = require(235) /* ../../core/layout/side_panel */;
    var text_1 = require(238) /* ../../core/util/text */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var TextAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(TextAnnotationView, _super);
        function TextAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TextAnnotationView.prototype.update_layout = function () {
            var _this = this;
            var panel = this.panel;
            if (panel != null)
                this.layout = new side_panel_1.SideLayout(panel, function () { return _this.get_size(); }, true);
            else
                this.layout = undefined;
        };
        TextAnnotationView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.model.render_mode == "css") {
                this.el = dom_1.div();
                this.plot_view.canvas_view.add_overlay(this.el);
            }
        };
        TextAnnotationView.prototype.remove = function () {
            if (this.el != null)
                dom_1.remove(this.el);
            _super.prototype.remove.call(this);
        };
        TextAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode == "css") {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () { return _this.render(); });
            }
            else {
                this.connect(this.model.change, function () { return _this.request_render(); });
            }
        };
        TextAnnotationView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == "css")
                dom_1.undisplay(this.el);
            _super.prototype.render.call(this);
        };
        TextAnnotationView.prototype._calculate_text_dimensions = function (ctx, text) {
            var width = ctx.measureText(text).width;
            var height = text_1.font_metrics(this.visuals.text.font_value()).height;
            return [width, height];
        };
        TextAnnotationView.prototype._calculate_bounding_box_dimensions = function (ctx, text) {
            var _a = tslib_1.__read(this._calculate_text_dimensions(ctx, text), 2), width = _a[0], height = _a[1];
            var x_offset;
            switch (ctx.textAlign) {
                case "left":
                    x_offset = 0;
                    break;
                case "center":
                    x_offset = -width / 2;
                    break;
                case "right":
                    x_offset = -width;
                    break;
                default:
                    assert_1.unreachable();
            }
            // guestimated from https://www.w3.org/TR/2dcontext/#dom-context-2d-textbaseline
            var y_offset;
            switch (ctx.textBaseline) {
                case "top":
                    y_offset = 0.0;
                    break;
                case "middle":
                    y_offset = -0.5 * height;
                    break;
                case "bottom":
                    y_offset = -1.0 * height;
                    break;
                case "alphabetic":
                    y_offset = -0.8 * height;
                    break;
                case "hanging":
                    y_offset = -0.17 * height;
                    break;
                case "ideographic":
                    y_offset = -0.83 * height;
                    break;
                default:
                    assert_1.unreachable();
            }
            return [x_offset, y_offset, width, height];
        };
        TextAnnotationView.prototype._canvas_text = function (ctx, text, sx, sy, angle) {
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            if (angle)
                ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            this.visuals.background_fill.apply(ctx);
            this.visuals.border_line.apply(ctx);
            if (this.visuals.text.doit) {
                this.visuals.text.set_value(ctx);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        };
        TextAnnotationView.prototype._css_text = function (ctx, text, sx, sy, angle) {
            var el = this.el;
            assert_1.assert(el != null);
            dom_1.undisplay(el);
            this.visuals.text.set_value(ctx);
            var _a = tslib_1.__read(this._calculate_bounding_box_dimensions(ctx, text), 2), x = _a[0], y = _a[1];
            el.style.position = "absolute";
            el.style.left = sx + x + "px";
            el.style.top = sy + y + "px";
            el.style.color = ctx.fillStyle;
            el.style.font = ctx.font;
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = "rotate(" + angle + "rad)";
            }
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                el.style.backgroundColor = ctx.fillStyle;
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                // attempt to support vector-style ("8 4 8") line dashing for css mode
                el.style.borderStyle = ctx.lineDash.length < 2 ? "solid" : "dashed";
                el.style.borderWidth = ctx.lineWidth + "px";
                el.style.borderColor = ctx.strokeStyle;
            }
            el.textContent = text;
            dom_1.display(el);
        };
        return TextAnnotationView;
    }(annotation_1.AnnotationView));
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    var TextAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(TextAnnotation, _super);
        function TextAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        TextAnnotation.init_TextAnnotation = function () {
            this.define(function () {
                return ({
                    render_mode: [enums_1.RenderMode, "canvas"],
                });
            });
        };
        return TextAnnotation;
    }(annotation_1.Annotation));
    exports.TextAnnotation = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    TextAnnotation.init_TextAnnotation();
},
/* core/layout/side_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(236) /* ./types */;
    var layoutable_1 = require(237) /* ./layoutable */;
    var types_2 = require(123) /* ../util/types */;
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    var pi2 = Math.PI / 2;
    var _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2,
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2,
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2,
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2,
        },
    };
    var _vertical_align_lookup = {
        above: {
            parallel: "bottom",
            normal: "center",
            horizontal: "bottom",
            vertical: "center",
        },
        below: {
            parallel: "top",
            normal: "center",
            horizontal: "top",
            vertical: "center",
        },
        left: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
        right: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
    };
    var _align_lookup = {
        above: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        below: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        left: {
            parallel: "center",
            normal: "right",
            horizontal: "right",
            vertical: "center",
        },
        right: {
            parallel: "center",
            normal: "left",
            horizontal: "left",
            vertical: "center",
        },
    };
    var _align_lookup_negative = {
        above: "right",
        below: "left",
        left: "right",
        right: "left",
    };
    var _align_lookup_positive = {
        above: "left",
        below: "right",
        left: "right",
        right: "left",
    };
    var Panel = /** @class */ (function () {
        function Panel(side) {
            this.side = side;
        }
        Object.defineProperty(Panel.prototype, "dimension", {
            get: function () {
                return this.side == "above" || this.side == "below" ? 0 : 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Panel.prototype, "normals", {
            get: function () {
                switch (this.side) {
                    case "above": return [0, -1];
                    case "below": return [0, 1];
                    case "left": return [-1, 0];
                    case "right": return [1, 0];
                }
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Panel.prototype, "orientation", {
            get: function () {
                return this.is_horizontal ? "horizontal" : "vertical";
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Panel.prototype, "is_horizontal", {
            get: function () {
                return this.dimension == 0;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Panel.prototype, "is_vertical", {
            get: function () {
                return this.dimension == 1;
            },
            enumerable: false,
            configurable: true
        });
        Panel.prototype.get_label_text_heuristics = function (orient) {
            var side = this.side;
            if (types_2.isString(orient)) {
                return {
                    vertical_align: _vertical_align_lookup[side][orient],
                    align: _align_lookup[side][orient],
                };
            }
            else {
                return {
                    vertical_align: "center",
                    align: (orient < 0 ? _align_lookup_negative : _align_lookup_positive)[side],
                };
            }
        };
        Panel.prototype.get_label_angle_heuristic = function (orient) {
            if (types_2.isString(orient))
                return _angle_lookup[this.side][orient];
            else
                return -orient;
        };
        return Panel;
    }());
    exports.Panel = Panel;
    Panel.__name__ = "Panel";
    var SideLayout = /** @class */ (function (_super) {
        tslib_1.__extends(SideLayout, _super);
        function SideLayout(panel, get_size, rotate) {
            if (rotate === void 0) {
                rotate = false;
            }
            var _this = _super.call(this) || this;
            _this.panel = panel;
            _this.get_size = get_size;
            _this.rotate = rotate;
            if (_this.panel.is_horizontal)
                _this.set_sizing({ width_policy: "max", height_policy: "fixed" });
            else
                _this.set_sizing({ width_policy: "fixed", height_policy: "max" });
            return _this;
        }
        SideLayout.prototype._content_size = function () {
            var _a = this.get_size(), width = _a.width, height = _a.height;
            if (!this.rotate || this.panel.is_horizontal)
                return new types_1.Sizeable({ width: width, height: height });
            else
                return new types_1.Sizeable({ width: height, height: width });
        };
        SideLayout.prototype.has_size_changed = function () {
            var _a = this._content_size(), width = _a.width, height = _a.height;
            if (this.panel.is_horizontal)
                return this.bbox.height != height;
            else
                return this.bbox.width != width;
        };
        return SideLayout;
    }(layoutable_1.ContentLayoutable));
    exports.SideLayout = SideLayout;
    SideLayout.__name__ = "SideLayout";
},
/* core/layout/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var kinds_1 = require(136) /* ../kinds */;
    var min = Math.min, max = Math.max;
    var Sizeable = /** @class */ (function () {
        function Sizeable(size) {
            if (size === void 0) {
                size = {};
            }
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        Sizeable.prototype.bounded_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        };
        Sizeable.prototype.expanded_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        };
        Sizeable.prototype.expand_to = function (_a) {
            var width = _a.width, height = _a.height;
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        };
        Sizeable.prototype.narrowed_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        };
        Sizeable.prototype.narrow_to = function (_a) {
            var width = _a.width, height = _a.height;
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        };
        Sizeable.prototype.grow_by = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            var width = this.width + left + right;
            var height = this.height + top + bottom;
            return new Sizeable({ width: width, height: height });
        };
        Sizeable.prototype.shrink_by = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            var width = max(this.width - left - right, 0);
            var height = max(this.height - top - bottom, 0);
            return new Sizeable({ width: width, height: height });
        };
        Sizeable.prototype.map = function (w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        };
        return Sizeable;
    }());
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
    exports.SizingPolicy = kinds_1.Enum("fixed", "fit", "min", "max");
},
/* core/layout/layoutable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(236) /* ./types */;
    var bbox_1 = require(180) /* ../util/bbox */;
    var types_2 = require(123) /* ../util/types */;
    var min = Math.min, max = Math.max, round = Math.round;
    var Layoutable = /** @class */ (function () {
        function Layoutable() {
            this.absolute = false;
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            this._dirty = false;
            this._handlers = [];
        }
        Layoutable.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/];
            });
        };
        Object.defineProperty(Layoutable.prototype, "bbox", {
            get: function () {
                return this._bbox;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "inner_bbox", {
            get: function () {
                return this._inner_bbox;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "sizing", {
            get: function () {
                return this._sizing;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "visible", {
            set: function (visible) {
                this._sizing.visible = visible;
                this._dirty = true;
            },
            enumerable: false,
            configurable: true
        });
        Layoutable.prototype.set_sizing = function (sizing) {
            var _a, _b, _c, _d, _e;
            var width_policy = (_a = sizing.width_policy) !== null && _a !== void 0 ? _a : "fit";
            var width = sizing.width;
            var min_width = sizing.min_width;
            var max_width = sizing.max_width;
            var height_policy = (_b = sizing.height_policy) !== null && _b !== void 0 ? _b : "fit";
            var height = sizing.height;
            var min_height = sizing.min_height;
            var max_height = sizing.max_height;
            var aspect = sizing.aspect;
            var margin = (_c = sizing.margin) !== null && _c !== void 0 ? _c : { top: 0, right: 0, bottom: 0, left: 0 };
            var visible = sizing.visible !== false;
            var halign = (_d = sizing.halign) !== null && _d !== void 0 ? _d : "start";
            var valign = (_e = sizing.valign) !== null && _e !== void 0 ? _e : "start";
            this._sizing = {
                width_policy: width_policy, min_width: min_width, width: width, max_width: max_width,
                height_policy: height_policy, min_height: min_height, height: height, max_height: max_height,
                aspect: aspect,
                margin: margin,
                visible: visible,
                halign: halign,
                valign: valign,
                size: { width: width, height: height },
            };
            this._init();
        };
        Layoutable.prototype._init = function () { };
        Layoutable.prototype._set_geometry = function (outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        };
        Layoutable.prototype.set_geometry = function (outer, inner) {
            var e_1, _a;
            this._set_geometry(outer, inner !== null && inner !== void 0 ? inner : outer);
            try {
                for (var _b = tslib_1.__values(this._handlers), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var handler = _c.value;
                    handler(this._bbox, this._inner_bbox);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        Layoutable.prototype.on_resize = function (handler) {
            this._handlers.push(handler);
        };
        Layoutable.prototype.is_width_expanding = function () {
            return this.sizing.width_policy == "max";
        };
        Layoutable.prototype.is_height_expanding = function () {
            return this.sizing.height_policy == "max";
        };
        Layoutable.prototype.apply_aspect = function (viewport, _a) {
            var width = _a.width, height = _a.height;
            var aspect = this.sizing.aspect;
            if (aspect != null) {
                var _b = this.sizing, width_policy = _b.width_policy, height_policy = _b.height_policy;
                var gt = function (width, height) {
                    var policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        var w_width = width;
                        var w_height = round(width / aspect);
                        var h_width = round(height * aspect);
                        var h_height = height;
                        var w_diff = Math.abs(viewport.width - w_width) + Math.abs(viewport.height - w_height);
                        var h_diff = Math.abs(viewport.width - h_width) + Math.abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width: width, height: height };
        };
        Layoutable.prototype.measure = function (viewport_size) {
            var _this = this;
            if (!this.sizing.visible)
                return { width: 0, height: 0 };
            var exact_width = function (vw) {
                return vw == Infinity && _this.sizing.width_policy == "fixed" && _this.sizing.width != null ? _this.sizing.width : vw;
            };
            var exact_height = function (vh) {
                return vh == Infinity && _this.sizing.height_policy == "fixed" && _this.sizing.height != null ? _this.sizing.height : vh;
            };
            var viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            var computed = this._measure(viewport);
            var clipped = this.clip_size(computed, viewport);
            var size = this.apply_aspect(viewport, clipped);
            return tslib_1.__assign(tslib_1.__assign({}, computed), size);
        };
        Layoutable.prototype.compute = function (viewport) {
            if (viewport === void 0) {
                viewport = {};
            }
            var _viewport = {
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            };
            var size_hint = this.measure(_viewport);
            var width = size_hint.width, height = size_hint.height;
            var outer = new bbox_1.BBox({ left: 0, top: 0, width: width, height: height });
            var inner = undefined;
            if (size_hint.inner != null) {
                var _a = size_hint.inner, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom;
                inner = new bbox_1.BBox({ left: left, top: top, right: width - right, bottom: height - bottom });
            }
            this.set_geometry(outer, inner);
        };
        Object.defineProperty(Layoutable.prototype, "xview", {
            get: function () {
                return this.bbox.xview;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "yview", {
            get: function () {
                return this.bbox.yview;
            },
            enumerable: false,
            configurable: true
        });
        Layoutable.prototype.clip_size = function (size, viewport) {
            function clip(size, vsize, min_size, max_size) {
                if (min_size == null)
                    min_size = 0;
                else if (!types_2.isNumber(min_size))
                    min_size = Math.round(min_size.percent * vsize);
                if (max_size == null)
                    max_size = Infinity;
                else if (!types_2.isNumber(max_size))
                    max_size = Math.round(max_size.percent * vsize);
                return max(min_size, min(size, max_size));
            }
            return {
                width: clip(size.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
                height: clip(size.height, viewport.height, this.sizing.min_height, this.sizing.max_height),
            };
        };
        Layoutable.prototype.has_size_changed = function () {
            var _dirty = this._dirty;
            this._dirty = false;
            return _dirty;
        };
        return Layoutable;
    }());
    exports.Layoutable = Layoutable;
    Layoutable.__name__ = "Layoutable";
    var LayoutItem = /** @class */ (function (_super) {
        tslib_1.__extends(LayoutItem, _super);
        function LayoutItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LayoutItem.prototype._measure = function (viewport) {
            var _this = this;
            var _a = this.sizing, width_policy = _a.width_policy, height_policy = _a.height_policy;
            var width = (function () {
                var width = _this.sizing.width;
                if (viewport.width == Infinity) {
                    return width !== null && width !== void 0 ? width : 0;
                }
                else {
                    switch (width_policy) {
                        case "fixed": return width !== null && width !== void 0 ? width : 0;
                        case "min": return width != null ? min(viewport.width, width) : 0;
                        case "fit": return width != null ? min(viewport.width, width) : viewport.width;
                        case "max": return width != null ? max(viewport.width, width) : viewport.width;
                    }
                }
            })();
            var height = (function () {
                var height = _this.sizing.height;
                if (viewport.height == Infinity) {
                    return height !== null && height !== void 0 ? height : 0;
                }
                else {
                    switch (height_policy) {
                        case "fixed": return height !== null && height !== void 0 ? height : 0;
                        case "min": return height != null ? min(viewport.height, height) : 0;
                        case "fit": return height != null ? min(viewport.height, height) : viewport.height;
                        case "max": return height != null ? max(viewport.height, height) : viewport.height;
                    }
                }
            })();
            return { width: width, height: height };
        };
        return LayoutItem;
    }(Layoutable));
    exports.LayoutItem = LayoutItem;
    LayoutItem.__name__ = "LayoutItem";
    var ContentLayoutable = /** @class */ (function (_super) {
        tslib_1.__extends(ContentLayoutable, _super);
        function ContentLayoutable() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ContentLayoutable.prototype._measure = function (viewport) {
            var _this = this;
            var content_size = this._content_size();
            var bounds = viewport
                .bounded_to(this.sizing.size)
                .bounded_to(content_size);
            var width = (function () {
                switch (_this.sizing.width_policy) {
                    case "fixed":
                        return _this.sizing.width != null ? _this.sizing.width : content_size.width;
                    case "min":
                        return content_size.width;
                    case "fit":
                        return bounds.width;
                    case "max":
                        return Math.max(content_size.width, bounds.width);
                }
            })();
            var height = (function () {
                switch (_this.sizing.height_policy) {
                    case "fixed":
                        return _this.sizing.height != null ? _this.sizing.height : content_size.height;
                    case "min":
                        return content_size.height;
                    case "fit":
                        return bounds.height;
                    case "max":
                        return Math.max(content_size.height, bounds.height);
                }
            })();
            return { width: width, height: height };
        };
        return ContentLayoutable;
    }(Layoutable));
    exports.ContentLayoutable = ContentLayoutable;
    ContentLayoutable.__name__ = "ContentLayoutable";
},
/* core/util/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var assert_1 = require(126) /* ./assert */;
    var has_OffscreenCanvas = (function () {
        try {
            return typeof OffscreenCanvas !== "undefined" && new OffscreenCanvas(0, 0).getContext("2d") != null;
        }
        catch (_a) {
            return false;
        }
    })();
    var _offscreen_canvas = (function () {
        if (has_OffscreenCanvas)
            return function (w, h) { return new OffscreenCanvas(w, h); };
        else {
            return function (w, h) {
                var canvas = document.createElement("canvas");
                canvas.width = w;
                canvas.height = h;
                return canvas;
            };
        }
    })();
    var _native_font_metrics = (function () {
        var canvas = _offscreen_canvas(0, 0);
        var ctx = canvas.getContext("2d");
        return function (font) {
            ctx.font = font;
            var cap_metrics = ctx.measureText("M");
            var x_metrics = ctx.measureText("x");
            var metrics = ctx.measureText("ÅŚg|");
            var font_ascent = metrics.fontBoundingBoxAscent;
            var font_descent = metrics.fontBoundingBoxDescent;
            if (font_ascent != null && font_descent != null) {
                return {
                    height: font_ascent + font_descent,
                    ascent: font_ascent,
                    descent: font_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            var text_ascent = metrics.actualBoundingBoxAscent;
            var text_descent = metrics.actualBoundingBoxDescent;
            if (text_ascent != null && text_descent != null) {
                return {
                    height: text_ascent + text_descent,
                    ascent: text_ascent,
                    descent: text_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            assert_1.unreachable();
        };
    })();
    var _native_glyph_metrics = (function () {
        var canvas = _offscreen_canvas(0, 0);
        var ctx = canvas.getContext("2d");
        return function (glyph, font) {
            ctx.font = font;
            var metrics = ctx.measureText(glyph);
            var glyph_ascent = metrics.actualBoundingBoxAscent;
            var glyph_descent = metrics.actualBoundingBoxDescent;
            if (glyph_ascent != null && glyph_descent != null) {
                return {
                    width: metrics.width,
                    height: glyph_ascent + glyph_descent,
                    ascent: glyph_ascent,
                    descent: glyph_descent,
                };
            }
            assert_1.unreachable();
        };
    })();
    var _internal_font_metrics = (function () {
        var canvas = document.createElement("canvas");
        var ctx = canvas.getContext("2d");
        var cwidth = -1;
        var cheight = -1;
        return function (font, scale) {
            var e_1, _a, e_2, _b, e_3, _c;
            if (scale === void 0) {
                scale = 1;
            }
            ctx.font = font;
            var _em = ctx.measureText("M").width;
            var em = _em * scale;
            var width = Math.ceil(em);
            var height = Math.ceil(2.0 * em);
            var baseline = Math.ceil(1.5 * em);
            if (cwidth < width) {
                cwidth = width;
                canvas.width = width;
            }
            if (cheight < height) {
                cheight = height;
                canvas.height = height;
            }
            ctx.save();
            ctx.scale(scale, scale);
            ctx.fillStyle = "#f00";
            ctx.fillRect(0, 0, width, height);
            var measure_ascent = function (data) {
                var k = 0;
                for (var i = 0; i <= baseline; i++) {
                    for (var j = 0; j < width; j++, k += 4)
                        if (data[k] != 255)
                            return baseline - i;
                }
                return 0;
            };
            var measure_descent = function (data) {
                var k = data.length - 4;
                for (var i = height; i >= baseline; i--) {
                    for (var j = 0; j < width; j++, k -= 4)
                        if (data[k] != 255)
                            return i - baseline;
                }
                return 0;
            };
            ctx.font = font;
            ctx.fillStyle = "#000";
            try {
                for (var _d = tslib_1.__values("xa"), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var c = _e.value;
                    ctx.fillText(c, 0, baseline / scale);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            var data0 = ctx.getImageData(0, 0, width, height).data;
            var x_height = measure_ascent(data0) / scale;
            try {
                for (var _f = tslib_1.__values("ASQ"), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var c = _g.value;
                    ctx.fillText(c, 0, baseline / scale);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var data1 = ctx.getImageData(0, 0, width, height).data;
            var cap_height = measure_ascent(data1) / scale;
            try {
                for (var _h = tslib_1.__values("ÅŚgy"), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var c = _j.value;
                    ctx.fillText(c, 0, baseline / scale);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_c = _h.return))
                        _c.call(_h);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            var data2 = ctx.getImageData(0, 0, width, height).data;
            var ascent = measure_ascent(data2) / scale;
            var descent = measure_descent(data2) / scale;
            ctx.restore();
            return { height: ascent + descent, ascent: ascent, cap_height: cap_height, x_height: x_height, descent: descent };
        };
    })();
    var _internal_glyph_metrics = (function () {
        var canvas = document.createElement("canvas");
        var ctx = canvas.getContext("2d");
        var cwidth = -1;
        var cheight = -1;
        return function (glyph, font, scale) {
            if (scale === void 0) {
                scale = 1;
            }
            ctx.font = font;
            var _em = ctx.measureText("M").width;
            var em = _em * scale;
            var width = Math.ceil(em);
            var height = Math.ceil(2.0 * em);
            var baseline = Math.ceil(1.5 * em);
            if (cwidth < width || cheight < height) {
                cwidth = width;
                canvas.width = width;
                cheight = height;
                canvas.height = height;
            }
            ctx.save();
            ctx.scale(scale, scale);
            ctx.fillStyle = "#f00";
            ctx.fillRect(0, 0, width, height);
            var measure_ascent = function (data) {
                var k = 0;
                for (var i = 0; i <= baseline; i++) {
                    for (var j = 0; j < width; j++, k += 4)
                        if (data[k] != 255)
                            return baseline - i;
                }
                return 0;
            };
            var measure_descent = function (data) {
                var k = data.length - 4;
                for (var i = height; i >= baseline; i--) {
                    for (var j = 0; j < width; j++, k -= 4)
                        if (data[k] != 255)
                            return i - baseline;
                }
                return 0;
            };
            ctx.font = font;
            ctx.fillStyle = "#000";
            ctx.fillText(glyph, 0, baseline / scale);
            var size = ctx.measureText(glyph);
            var data = ctx.getImageData(0, 0, width, height).data;
            var ascent = measure_ascent(data) / scale;
            var descent = measure_descent(data) / scale;
            ctx.restore();
            return { width: size.width, height: ascent + descent, ascent: ascent, descent: descent };
        };
    })();
    var _font_metrics = (function () {
        try {
            _native_font_metrics("normal 10px sans-serif");
            return _native_font_metrics;
        }
        catch (_a) {
            return _internal_font_metrics;
        }
    })();
    var _glyph_metrics = (function () {
        try {
            _native_glyph_metrics("A", "normal 10px sans-serif");
            return _native_glyph_metrics;
        }
        catch (_a) {
            return _internal_glyph_metrics;
        }
    })();
    var _metrics_cache = new Map();
    function font_metrics(font) {
        var metrics = _metrics_cache.get(font);
        if (metrics == null) {
            // TODO: document.fonts.check(font)
            metrics = { font: _font_metrics(font), glyphs: new Map() };
            _metrics_cache.set(font, metrics);
        }
        return metrics.font;
    }
    exports.font_metrics = font_metrics;
    function glyph_metrics(glyph, font) {
        var metrics = _metrics_cache.get(font);
        if (metrics == null) {
            font_metrics(font);
            metrics = _metrics_cache.get(font);
        }
        var glyph_metrics = metrics.glyphs.get(glyph);
        if (glyph_metrics == null) {
            glyph_metrics = _glyph_metrics(glyph, font);
            metrics.glyphs.set(glyph, glyph_metrics);
        }
        return glyph_metrics;
    }
    exports.glyph_metrics = glyph_metrics;
},
/* models/canvas/cartesian_frame.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var categorical_scale_1 = require(177) /* ../scales/categorical_scale */;
    var log_scale_1 = require(176) /* ../scales/log_scale */;
    var range1d_1 = require(173) /* ../ranges/range1d */;
    var data_range1d_1 = require(178) /* ../ranges/data_range1d */;
    var factor_range_1 = require(182) /* ../ranges/factor_range */;
    var bbox_1 = require(180) /* ../../core/util/bbox */;
    var object_1 = require(128) /* ../../core/util/object */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var CartesianFrame = /** @class */ (function () {
        function CartesianFrame(in_x_scale, in_y_scale, x_range, y_range, extra_x_ranges, extra_y_ranges) {
            if (extra_x_ranges === void 0) {
                extra_x_ranges = {};
            }
            if (extra_y_ranges === void 0) {
                extra_y_ranges = {};
            }
            this.in_x_scale = in_x_scale;
            this.in_y_scale = in_y_scale;
            this.x_range = x_range;
            this.y_range = y_range;
            this.extra_x_ranges = extra_x_ranges;
            this.extra_y_ranges = extra_y_ranges;
            this._bbox = new bbox_1.BBox();
            assert_1.assert(in_x_scale.source_range == null && in_x_scale.target_range == null);
            assert_1.assert(in_y_scale.source_range == null && in_y_scale.target_range == null);
            this._configure_scales();
        }
        Object.defineProperty(CartesianFrame.prototype, "bbox", {
            get: function () {
                return this._bbox;
            },
            enumerable: false,
            configurable: true
        });
        CartesianFrame.prototype._get_ranges = function (range, extra_ranges) {
            return new Map(object_1.entries(tslib_1.__assign(tslib_1.__assign({}, extra_ranges), { default: range })));
        };
        /*protected*/ CartesianFrame.prototype._get_scales = function (scale, ranges, frame_range) {
            var e_1, _a;
            var scales = new Map();
            try {
                for (var ranges_1 = tslib_1.__values(ranges), ranges_1_1 = ranges_1.next(); !ranges_1_1.done; ranges_1_1 = ranges_1.next()) {
                    var _b = tslib_1.__read(ranges_1_1.value, 2), name = _b[0], range = _b[1];
                    var factor_range = range instanceof factor_range_1.FactorRange;
                    var categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
                    if (factor_range != categorical_scale) {
                        throw new Error("Range " + range.type + " is incompatible is Scale " + scale.type);
                    }
                    if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                        range.scale_hint = "log";
                    var derived_scale = scale.clone();
                    derived_scale.setv({ source_range: range, target_range: frame_range });
                    scales.set(name, derived_scale);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (ranges_1_1 && !ranges_1_1.done && (_a = ranges_1.return))
                        _a.call(ranges_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return scales;
        };
        CartesianFrame.prototype._configure_frame_ranges = function () {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            var bbox = this.bbox;
            this._x_target = new range1d_1.Range1d({ start: bbox.left, end: bbox.right });
            this._y_target = new range1d_1.Range1d({ start: bbox.bottom, end: bbox.top });
        };
        CartesianFrame.prototype._configure_scales = function () {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._x_scales = this._get_scales(this.in_x_scale, this._x_ranges, this._x_target);
            this._y_scales = this._get_scales(this.in_y_scale, this._y_ranges, this._y_target);
        };
        CartesianFrame.prototype._update_scales = function () {
            var e_2, _a, e_3, _b;
            this._configure_frame_ranges();
            try {
                for (var _c = tslib_1.__values(this._x_scales), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = tslib_1.__read(_d.value, 2), scale = _e[1];
                    scale.target_range = this._x_target;
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            try {
                for (var _f = tslib_1.__values(this._y_scales), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var _h = tslib_1.__read(_g.value, 2), scale = _h[1];
                    scale.target_range = this._y_target;
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        CartesianFrame.prototype.set_geometry = function (bbox) {
            this._bbox = bbox;
            this._update_scales();
        };
        Object.defineProperty(CartesianFrame.prototype, "x_target", {
            get: function () {
                return this._x_target;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "y_target", {
            get: function () {
                return this._y_target;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "x_ranges", {
            get: function () {
                return this._x_ranges;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "y_ranges", {
            get: function () {
                return this._y_ranges;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "x_scales", {
            get: function () {
                return this._x_scales;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "y_scales", {
            get: function () {
                return this._y_scales;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "x_scale", {
            get: function () {
                return this._x_scales.get("default");
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "y_scale", {
            get: function () {
                return this._y_scales.get("default");
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "xscales", {
            /** @deprecated */
            get: function () {
                return object_1.to_object(this.x_scales);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "yscales", {
            /** @deprecated */
            get: function () {
                return object_1.to_object(this.y_scales);
            },
            enumerable: false,
            configurable: true
        });
        return CartesianFrame;
    }());
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.__name__ = "CartesianFrame";
},
/* models/axes/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var axis_1 = require(241) /* ./axis */;
    __esExport("Axis", axis_1.Axis);
    var categorical_axis_1 = require(248) /* ./categorical_axis */;
    __esExport("CategoricalAxis", categorical_axis_1.CategoricalAxis);
    var continuous_axis_1 = require(251) /* ./continuous_axis */;
    __esExport("ContinuousAxis", continuous_axis_1.ContinuousAxis);
    var datetime_axis_1 = require(252) /* ./datetime_axis */;
    __esExport("DatetimeAxis", datetime_axis_1.DatetimeAxis);
    var linear_axis_1 = require(253) /* ./linear_axis */;
    __esExport("LinearAxis", linear_axis_1.LinearAxis);
    var log_axis_1 = require(270) /* ./log_axis */;
    __esExport("LogAxis", log_axis_1.LogAxis);
    var mercator_axis_1 = require(273) /* ./mercator_axis */;
    __esExport("MercatorAxis", mercator_axis_1.MercatorAxis);
},
/* models/axes/axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var guide_renderer_1 = require(242) /* ../renderers/guide_renderer */;
    var ticker_1 = require(243) /* ../tickers/ticker */;
    var tick_formatter_1 = require(244) /* ../formatters/tick_formatter */;
    var labeling_1 = require(247) /* ../policies/labeling */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var enums_1 = require(135) /* ../../core/enums */;
    var types_1 = require(139) /* ../../core/types */;
    var side_panel_1 = require(235) /* ../../core/layout/side_panel */;
    var array_1 = require(124) /* ../../core/util/array */;
    var types_2 = require(123) /* ../../core/util/types */;
    var graphics_1 = require(245) /* ../../core/graphics */;
    var factor_range_1 = require(182) /* ../ranges/factor_range */;
    var abs = Math.abs;
    var AxisView = /** @class */ (function (_super) {
        tslib_1.__extends(AxisView, _super);
        function AxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AxisView.prototype.update_layout = function () {
            var _this = this;
            this.layout = new side_panel_1.SideLayout(this.panel, function () { return _this.get_size(); }, true);
            this.layout.on_resize(function () { return _this._coordinates = undefined; });
        };
        AxisView.prototype.get_size = function () {
            var _a = this.model, visible = _a.visible, fixed_location = _a.fixed_location;
            if (visible && fixed_location == null && this.is_renderable) {
                var extents = this.extents;
                var height = Math.round(extents.tick + extents.tick_label + extents.axis_label);
                return { width: 0, height: height };
            }
            else
                return { width: 0, height: 0 };
        };
        Object.defineProperty(AxisView.prototype, "is_renderable", {
            get: function () {
                var _a = tslib_1.__read(this.ranges, 2), range = _a[0], cross_range = _a[1];
                return range.is_valid && cross_range.is_valid;
            },
            enumerable: false,
            configurable: true
        });
        AxisView.prototype._render = function () {
            var _a;
            if (!this.is_renderable)
                return;
            var _b = this, tick_coords = _b.tick_coords, extents = _b.extents;
            var ctx = this.layer.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            (_a = this._paint) === null || _a === void 0 ? void 0 : _a.call(this, ctx, extents, tick_coords);
            ctx.restore();
        };
        AxisView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.plot_view.request_layout(); });
        };
        Object.defineProperty(AxisView.prototype, "needs_clip", {
            get: function () {
                return this.model.fixed_location != null;
            },
            enumerable: false,
            configurable: true
        });
        // drawing sub functions -----------------------------------------------------
        AxisView.prototype._draw_rule = function (ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            var _a = tslib_1.__read(this.rule_coords, 2), xs = _a[0], ys = _a[1];
            var _b = tslib_1.__read(this.coordinates.map_to_screen(xs, ys), 2), sxs = _b[0], sys = _b[1];
            var _c = tslib_1.__read(this.normals, 2), nx = _c[0], ny = _c[1];
            var _d = tslib_1.__read(this.offsets, 2), xoff = _d[0], yoff = _d[1];
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            for (var i = 0; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nx * xoff);
                var sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        };
        AxisView.prototype._draw_major_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            var visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        };
        AxisView.prototype._draw_minor_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            var visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        };
        AxisView.prototype._draw_major_labels = function (ctx, extents, tick_coords) {
            var coords = tick_coords.major;
            var labels = this.compute_labels(coords[this.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = extents.tick + this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
        };
        AxisView.prototype._axis_label_extent = function () {
            var text = this.model.axis_label;
            if (!text)
                return 0;
            var axis_label = new graphics_1.TextBox({ text: text });
            axis_label.angle = this.panel.get_label_angle_heuristic("parallel");
            axis_label.visuals = this.visuals.axis_label_text;
            var size = axis_label.size();
            var extent = this.dimension == 0 ? size.height : size.width;
            var standoff = this.model.axis_label_standoff;
            var padding = 3;
            return extent > 0 ? standoff + extent + padding : 0;
        };
        AxisView.prototype._draw_axis_label = function (ctx, extents, _tick_coords) {
            var _this = this;
            var text = this.model.axis_label;
            if (!text || this.model.fixed_location != null)
                return;
            var axis_label = new graphics_1.TextBox({ text: text });
            axis_label.angle = this.panel.get_label_angle_heuristic("parallel");
            axis_label.visuals = this.visuals.axis_label_text;
            var _a = tslib_1.__read((function () {
                var bbox = _this.layout.bbox;
                switch (_this.panel.side) {
                    case "above":
                        return [bbox.hcenter, bbox.bottom];
                    case "below":
                        return [bbox.hcenter, bbox.top];
                    case "left":
                        return [bbox.right, bbox.vcenter];
                    case "right":
                        return [bbox.left, bbox.vcenter];
                }
            })(), 2), sx = _a[0], sy = _a[1];
            var _b = tslib_1.__read(this.normals, 2), nx = _b[0], ny = _b[1];
            var standoff = extents.tick + extents.tick_label + this.model.axis_label_standoff;
            var _c = this.panel.get_label_text_heuristics("parallel"), vertical_align = _c.vertical_align, align = _c.align;
            axis_label.position = {
                sx: sx + nx * standoff,
                sy: sy + ny * standoff,
                x_anchor: align,
                y_anchor: vertical_align,
            };
            axis_label.align = align;
            axis_label.paint(ctx);
        };
        AxisView.prototype._draw_ticks = function (ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            var _a = tslib_1.__read(coords, 2), x = _a[0], y = _a[1];
            var _b = tslib_1.__read(this.coordinates.map_to_screen(x, y), 2), sxs = _b[0], sys = _b[1];
            var _c = tslib_1.__read(this.normals, 2), nx = _c[0], ny = _c[1];
            var _d = tslib_1.__read(this.offsets, 2), xoff = _d[0], yoff = _d[1];
            var _e = tslib_1.__read([nx * (xoff - tin), ny * (yoff - tin)], 2), nxin = _e[0], nyin = _e[1];
            var _f = tslib_1.__read([nx * (xoff + tout), ny * (yoff + tout)], 2), nxout = _f[0], nyout = _f[1];
            visuals.set_value(ctx);
            ctx.beginPath();
            for (var i = 0; i < sxs.length; i++) {
                var sx0 = Math.round(sxs[i] + nxout);
                var sy0 = Math.round(sys[i] + nyout);
                var sx1 = Math.round(sxs[i] + nxin);
                var sy1 = Math.round(sys[i] + nyin);
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
            }
            ctx.stroke();
        };
        AxisView.prototype._draw_oriented_labels = function (ctx, labels, coords, orient, _side, standoff, visuals) {
            var e_1, _a;
            var _this = this;
            if (!visuals.doit || labels.length == 0)
                return;
            var _b = tslib_1.__read(coords, 2), dxs = _b[0], dys = _b[1];
            var _c = tslib_1.__read(this.coordinates.map_to_screen(dxs, dys), 2), sxs = _c[0], sys = _c[1];
            var _d = tslib_1.__read(this.offsets, 2), xoff = _d[0], yoff = _d[1];
            var _e = tslib_1.__read(this.normals, 2), nx = _e[0], ny = _e[1];
            var nxd = nx * (xoff + standoff);
            var nyd = ny * (yoff + standoff);
            var _f = this.panel.get_label_text_heuristics(orient), vertical_align = _f.vertical_align, align = _f.align;
            var angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals;
            labels.angle = angle;
            for (var i = 0; i < labels.length; i++) {
                var label = labels.items[i];
                label.position = {
                    sx: sxs[i] + nxd,
                    sy: sys[i] + nyd,
                    x_anchor: align,
                    y_anchor: vertical_align,
                };
                if (label instanceof graphics_1.TextBox)
                    label.align = align;
            }
            var n = labels.length;
            var indices = types_1.Indices.all_set(n);
            var items = labels.items;
            var bboxes = items.map(function (l) { return l.bbox(); });
            var dist = (function () {
                var _a = tslib_1.__read(_this.ranges, 1), range = _a[0];
                if (!range.is_reversed)
                    return _this.dimension == 0 ? function (i, j) { return bboxes[j].left - bboxes[i].right; }
                        : function (i, j) { return bboxes[i].top - bboxes[j].bottom; };
                else
                    return _this.dimension == 0 ? function (i, j) { return bboxes[i].left - bboxes[j].right; }
                        : function (i, j) { return bboxes[j].top - bboxes[i].bottom; };
            })();
            var major_label_policy = this.model.major_label_policy;
            var selected = major_label_policy.filter(indices, bboxes, dist);
            var ids = tslib_1.__spreadArray([], tslib_1.__read(selected.ones()));
            if (ids.length != 0) {
                var cbox_1 = this.parent.canvas_view.bbox;
                var correct_x = function (k) {
                    var bbox = bboxes[k];
                    if (bbox.left < 0) {
                        var offset = -bbox.left;
                        var position = items[k].position;
                        items[k].position = tslib_1.__assign(tslib_1.__assign({}, position), { sx: position.sx + offset });
                    }
                    else if (bbox.right > cbox_1.width) {
                        var offset = bbox.right - cbox_1.width;
                        var position = items[k].position;
                        items[k].position = tslib_1.__assign(tslib_1.__assign({}, position), { sx: position.sx - offset });
                    }
                };
                var correct_y = function (k) {
                    var bbox = bboxes[k];
                    if (bbox.top < 0) {
                        var offset = -bbox.top;
                        var position = items[k].position;
                        items[k].position = tslib_1.__assign(tslib_1.__assign({}, position), { sy: position.sy + offset });
                    }
                    else if (bbox.bottom > cbox_1.height) {
                        var offset = bbox.bottom - cbox_1.height;
                        var position = items[k].position;
                        items[k].position = tslib_1.__assign(tslib_1.__assign({}, position), { sy: position.sy - offset });
                    }
                };
                var i = ids[0];
                var j = ids[ids.length - 1];
                if (this.dimension == 0) {
                    correct_x(i);
                    correct_x(j);
                }
                else {
                    correct_y(i);
                    correct_y(j);
                }
            }
            try {
                for (var selected_1 = tslib_1.__values(selected), selected_1_1 = selected_1.next(); !selected_1_1.done; selected_1_1 = selected_1.next()) {
                    var i = selected_1_1.value;
                    var label = items[i];
                    label.paint(ctx);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (selected_1_1 && !selected_1_1.done && (_a = selected_1.return))
                        _a.call(selected_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        // extents sub functions -----------------------------------------------------
        /*protected*/ AxisView.prototype._tick_extent = function () {
            return this.model.major_tick_out;
        };
        AxisView.prototype._tick_label_extents = function () {
            var coords = this.tick_coords.major;
            var labels = this.compute_labels(coords[this.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, standoff, visuals)];
        };
        Object.defineProperty(AxisView.prototype, "extents", {
            get: function () {
                var tick_labels = this._tick_label_extents();
                return {
                    tick: this._tick_extent(),
                    tick_labels: tick_labels,
                    tick_label: array_1.sum(tick_labels),
                    axis_label: this._axis_label_extent(),
                };
            },
            enumerable: false,
            configurable: true
        });
        AxisView.prototype._oriented_labels_extent = function (labels, orient, standoff, visuals) {
            if (labels.length == 0 || !visuals.doit)
                return 0;
            var angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals;
            labels.angle = angle;
            var size = labels.max_size();
            var extent = this.dimension == 0 ? size.height : size.width;
            var padding = 3;
            return extent > 0 ? standoff + extent + padding : 0;
        };
        Object.defineProperty(AxisView.prototype, "normals", {
            // {{{ TODO: state
            get: function () {
                return this.panel.normals;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "dimension", {
            get: function () {
                return this.panel.dimension;
            },
            enumerable: false,
            configurable: true
        });
        AxisView.prototype.compute_labels = function (ticks) {
            var labels = this.model.formatter.format_graphics(ticks, this);
            var major_label_overrides = this.model.major_label_overrides;
            for (var i = 0; i < ticks.length; i++) {
                var override = major_label_overrides[ticks[i]];
                if (override != null)
                    labels[i] = new graphics_1.TextBox({ text: override });
            }
            return new graphics_1.GraphicsBoxes(labels);
        };
        Object.defineProperty(AxisView.prototype, "offsets", {
            get: function () {
                // If we have a fixed_position then we should respect that exactly and
                // not apply any offsets (https://github.com/bokeh/bokeh/issues/8552)
                if (this.model.fixed_location != null)
                    return [0, 0];
                var frame = this.plot_view.frame;
                var _a = tslib_1.__read([0, 0], 2), xoff = _a[0], yoff = _a[1];
                switch (this.panel.side) {
                    case "below":
                        yoff = abs(this.layout.bbox.top - frame.bbox.bottom);
                        break;
                    case "above":
                        yoff = abs(this.layout.bbox.bottom - frame.bbox.top);
                        break;
                    case "right":
                        xoff = abs(this.layout.bbox.left - frame.bbox.right);
                        break;
                    case "left":
                        xoff = abs(this.layout.bbox.right - frame.bbox.left);
                        break;
                }
                return [xoff, yoff];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "ranges", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var ranges = this.coordinates.ranges;
                return [ranges[i], ranges[j]];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "computed_bounds", {
            get: function () {
                var _a = tslib_1.__read(this.ranges, 1), range = _a[0];
                var user_bounds = this.model.bounds;
                var range_bounds = [range.min, range.max];
                if (user_bounds == "auto")
                    return [range.min, range.max];
                else {
                    var start = void 0;
                    var end = void 0;
                    var _b = tslib_1.__read(user_bounds, 2), user_start = _b[0], user_end = _b[1];
                    var _c = tslib_1.__read(range_bounds, 2), range_start = _c[0], range_end = _c[1];
                    var min = Math.min, max = Math.max;
                    if (abs(user_start - user_end) > abs(range_start - range_end)) {
                        start = max(min(user_start, user_end), range_start);
                        end = min(max(user_start, user_end), range_end);
                    }
                    else {
                        start = min(user_start, user_end);
                        end = max(user_start, user_end);
                    }
                    return [start, end];
                }
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "rule_coords", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var _a = tslib_1.__read(this.ranges, 1), range = _a[0];
                var _b = tslib_1.__read(this.computed_bounds, 2), start = _b[0], end = _b[1];
                var xs = new Array(2);
                var ys = new Array(2);
                var coords = [xs, ys];
                coords[i][0] = Math.max(start, range.min);
                coords[i][1] = Math.min(end, range.max);
                if (coords[i][0] > coords[i][1])
                    coords[i][0] = coords[i][1] = NaN;
                coords[j][0] = this.loc;
                coords[j][1] = this.loc;
                return coords;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "tick_coords", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var _a = tslib_1.__read(this.ranges, 1), range = _a[0];
                var _b = tslib_1.__read(this.computed_bounds, 2), start = _b[0], end = _b[1];
                var ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
                var majors = ticks.major;
                var minors = ticks.minor;
                var xs = [];
                var ys = [];
                var coords = [xs, ys];
                var minor_xs = [];
                var minor_ys = [];
                var minor_coords = [minor_xs, minor_ys];
                var _c = tslib_1.__read([range.min, range.max], 2), range_min = _c[0], range_max = _c[1];
                for (var ii = 0; ii < majors.length; ii++) {
                    if (majors[ii] < range_min || majors[ii] > range_max)
                        continue;
                    coords[i].push(majors[ii]);
                    coords[j].push(this.loc);
                }
                for (var ii = 0; ii < minors.length; ii++) {
                    if (minors[ii] < range_min || minors[ii] > range_max)
                        continue;
                    minor_coords[i].push(minors[ii]);
                    minor_coords[j].push(this.loc);
                }
                return {
                    major: coords,
                    minor: minor_coords,
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "loc", {
            get: function () {
                var fixed_location = this.model.fixed_location;
                if (fixed_location != null) {
                    if (types_2.isNumber(fixed_location))
                        return fixed_location;
                    var _a = tslib_1.__read(this.ranges, 2), cross_range_1 = _a[1];
                    if (cross_range_1 instanceof factor_range_1.FactorRange)
                        return cross_range_1.synthetic(fixed_location);
                    throw new Error("unexpected");
                }
                var _b = tslib_1.__read(this.ranges, 2), cross_range = _b[1];
                switch (this.panel.side) {
                    case "left":
                    case "below":
                        return cross_range.start;
                    case "right":
                    case "above":
                        return cross_range.end;
                }
            },
            enumerable: false,
            configurable: true
        });
        // }}}
        AxisView.prototype.serializable_state = function () {
            return tslib_1.__assign(tslib_1.__assign({}, _super.prototype.serializable_state.call(this)), { bbox: this.layout.bbox.box });
        };
        return AxisView;
    }(guide_renderer_1.GuideRendererView));
    exports.AxisView = AxisView;
    AxisView.__name__ = "AxisView";
    var Axis = /** @class */ (function (_super) {
        tslib_1.__extends(Axis, _super);
        function Axis(attrs) {
            return _super.call(this, attrs) || this;
        }
        Axis.init_Axis = function () {
            this.prototype.default_view = AxisView;
            this.mixins([
                ["axis_", mixins.Line],
                ["major_tick_", mixins.Line],
                ["minor_tick_", mixins.Line],
                ["major_label_", mixins.Text],
                ["axis_label_", mixins.Text],
            ]);
            this.define(function (_a) {
                var Any = _a.Any, Int = _a.Int, Number = _a.Number, String = _a.String, Ref = _a.Ref, Dict = _a.Dict, Tuple = _a.Tuple, Or = _a.Or, Nullable = _a.Nullable, Auto = _a.Auto;
                return ({
                    bounds: [Or(Tuple(Number, Number), Auto), "auto"],
                    ticker: [Ref(ticker_1.Ticker)],
                    formatter: [Ref(tick_formatter_1.TickFormatter)],
                    axis_label: [Nullable(String), ""],
                    axis_label_standoff: [Int, 5],
                    major_label_standoff: [Int, 5],
                    major_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "horizontal"],
                    major_label_overrides: [Dict(String), {}],
                    major_label_policy: [Ref(labeling_1.LabelingPolicy), function () { return new labeling_1.AllLabels(); }],
                    major_tick_in: [Number, 2],
                    major_tick_out: [Number, 6],
                    minor_tick_in: [Number, 0],
                    minor_tick_out: [Number, 4],
                    fixed_location: [Nullable(Or(Number, Any)), null],
                });
            });
            this.override({
                axis_line_color: "black",
                major_tick_line_color: "black",
                minor_tick_line_color: "black",
                major_label_text_font_size: "11px",
                major_label_text_align: "center",
                major_label_text_baseline: "alphabetic",
                axis_label_text_font_size: "13px",
                axis_label_text_font_style: "italic",
            });
        };
        return Axis;
    }(guide_renderer_1.GuideRenderer));
    exports.Axis = Axis;
    Axis.__name__ = "Axis";
    Axis.init_Axis();
},
/* models/renderers/guide_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var renderer_1 = require(156) /* ./renderer */;
    var GuideRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GuideRendererView, _super);
        function GuideRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GuideRendererView;
    }(renderer_1.RendererView));
    exports.GuideRendererView = GuideRendererView;
    GuideRendererView.__name__ = "GuideRendererView";
    var GuideRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GuideRenderer, _super);
        function GuideRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GuideRenderer.init_GuideRenderer = function () {
            this.override({
                level: "guide",
            });
        };
        return GuideRenderer;
    }(renderer_1.Renderer));
    exports.GuideRenderer = GuideRenderer;
    GuideRenderer.__name__ = "GuideRenderer";
    GuideRenderer.init_GuideRenderer();
},
/* models/tickers/ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Ticker = /** @class */ (function (_super) {
        tslib_1.__extends(Ticker, _super);
        function Ticker(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Ticker;
    }(model_1.Model));
    exports.Ticker = Ticker;
    Ticker.__name__ = "Ticker";
},
/* models/formatters/tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var graphics_1 = require(245) /* ../../core/graphics */;
    var TickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(TickFormatter, _super);
        function TickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        TickFormatter.prototype.format_graphics = function (ticks, opts) {
            return this.doFormat(ticks, opts).map(function (text) { return new graphics_1.TextBox({ text: text }); });
        };
        TickFormatter.prototype.compute = function (tick, opts) {
            return this.doFormat([tick], opts !== null && opts !== void 0 ? opts : { loc: 0 })[0];
        };
        TickFormatter.prototype.v_compute = function (tick, opts) {
            return this.doFormat(tick, opts !== null && opts !== void 0 ? opts : { loc: 0 });
        };
        return TickFormatter;
    }(model_1.Model));
    exports.TickFormatter = TickFormatter;
    TickFormatter.__name__ = "TickFormatter";
},
/* core/graphics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var bbox_1 = require(180) /* ./util/bbox */;
    var text_1 = require(238) /* ./util/text */;
    var array_1 = require(124) /* ./util/array */;
    var types_1 = require(123) /* ./util/types */;
    var affine_1 = require(246) /* ./util/affine */;
    var color_1 = require(137) /* ./util/color */;
    exports.text_width = (function () {
        var canvas = document.createElement("canvas");
        var ctx = canvas.getContext("2d");
        var current_font = "";
        return function (text, font) {
            if (font != current_font) {
                current_font = font;
                ctx.font = font;
            }
            return ctx.measureText(text).width;
        };
    })();
    var GraphicsBox = /** @class */ (function () {
        function GraphicsBox() {
            this._position = { sx: 0, sy: 0 };
            this.font_size_scale = 1.0;
        }
        Object.defineProperty(GraphicsBox.prototype, "position", {
            get: function () {
                return this._position;
            },
            set: function (p) {
                this._position = p;
            },
            enumerable: false,
            configurable: true
        });
        GraphicsBox.prototype.infer_text_height = function () {
            return "ascent_descent";
        };
        GraphicsBox.prototype.bbox = function () {
            var _a = this.rect(), p0 = _a.p0, p1 = _a.p1, p2 = _a.p2, p3 = _a.p3;
            var left = Math.min(p0.x, p1.x, p2.x, p3.x);
            var top = Math.min(p0.y, p1.y, p2.y, p3.y);
            var right = Math.max(p0.x, p1.x, p2.x, p3.x);
            var bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left: left, right: right, top: top, bottom: bottom });
        };
        GraphicsBox.prototype.size = function () {
            var _a = this._size(), width = _a.width, height = _a.height;
            var angle = this.angle;
            if (!angle)
                return { width: width, height: height };
            else {
                var c = Math.cos(Math.abs(angle));
                var s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        };
        GraphicsBox.prototype.rect = function () {
            var rect = this._rect();
            var angle = this.angle;
            if (!angle)
                return rect;
            else {
                var _a = this.position, sx = _a.sx, sy = _a.sy;
                var tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        };
        GraphicsBox.prototype.paint_rect = function (ctx) {
            var _a = this.rect(), p0 = _a.p0, p1 = _a.p1, p2 = _a.p2, p3 = _a.p3;
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            var round = Math.round;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        };
        GraphicsBox.prototype.paint_bbox = function (ctx) {
            var _a = this.bbox(), x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            var round = Math.round;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        };
        return GraphicsBox;
    }());
    exports.GraphicsBox = GraphicsBox;
    GraphicsBox.__name__ = "GraphicsBox";
    var TextBox = /** @class */ (function (_super) {
        tslib_1.__extends(TextBox, _super);
        function TextBox(_a) {
            var text = _a.text;
            var _this = _super.call(this) || this;
            _this.align = "left";
            _this.text = text;
            return _this;
        }
        Object.defineProperty(TextBox.prototype, "visuals", {
            //padding: Padding
            set: function (v) {
                var color = v.text_color.get_value();
                var alpha = v.text_alpha.get_value();
                var style = v.text_font_style.get_value();
                var size = v.text_font_size.get_value();
                var face = v.text_font.get_value();
                var font_size_scale = this.font_size_scale;
                if (font_size_scale != 1.0) {
                    var match = size.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);
                    if (match != null) {
                        var _a = tslib_1.__read(match, 4), value = _a[1], unit = _a[3];
                        var number = Number(value);
                        if (!isNaN(number))
                            size = "" + number * font_size_scale + unit;
                    }
                }
                var font = style + " " + size + " " + face;
                this.font = font;
                this.color = color_1.color2css(color, alpha);
                this.line_height = v.text_line_height.get_value();
            },
            enumerable: false,
            configurable: true
        });
        TextBox.prototype.infer_text_height = function () {
            if (this.text.includes("\n"))
                return "ascent_descent";
            else {
                function is_math_like(text) {
                    var e_1, _a;
                    try {
                        for (var _b = tslib_1.__values(new Set(text)), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var c = _c.value;
                            if ("0" <= c && c <= "9")
                                continue;
                            switch (c) {
                                case ",":
                                case ".":
                                case "+":
                                case "-":
                                case "\u2212":
                                case "e":
                                    continue;
                                default:
                                    return false;
                            }
                        }
                    }
                    catch (e_1_1) {
                        e_1 = { error: e_1_1 };
                    }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return))
                                _a.call(_b);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                    }
                    return true;
                }
                if (is_math_like(this.text))
                    return "cap";
                else
                    return "ascent_descent";
                /*
                const {font} = this
                const fmetrics = font_metrics(font)
          
                let max_ascent = 0
                let max_descent = 0
                for (const c of this.text) {
                  const metrics = glyph_metrics(c, font)
                  max_ascent = Math.max(metrics.ascent)
                  max_descent = Math.max(metrics.descent)
                }
          
                const ascent = (() => {
                  if (max_ascent > fmetrics.cap_height)
                    return "ascent"
                  else if (max_ascent > fmetrics.x_height)
                    return "cap"
                  else
                    return "x"
                })()
          
                return max_descent > 0 ? `${ascent}_descent` as const : ascent
                */
            }
        };
        TextBox.prototype._text_line = function (fmetrics) {
            var _a;
            var metric = (_a = this.text_height_metric) !== null && _a !== void 0 ? _a : this.infer_text_height();
            var ascent = (function () {
                switch (metric) {
                    case "x":
                    case "x_descent":
                        return fmetrics.x_height;
                    case "cap":
                    case "cap_descent":
                        return fmetrics.cap_height;
                    case "ascent":
                    case "ascent_descent":
                        return fmetrics.ascent;
                }
            })();
            var descent = (function () {
                switch (metric) {
                    case "x":
                    case "cap":
                    case "ascent":
                        return 0;
                    case "x_descent":
                    case "cap_descent":
                    case "ascent_descent":
                        return fmetrics.descent;
                }
            })();
            return { height: ascent + descent, ascent: ascent, descent: descent };
        };
        Object.defineProperty(TextBox.prototype, "nlines", {
            get: function () {
                var lines = this.text.split("\n");
                return lines.length;
            },
            enumerable: false,
            configurable: true
        });
        TextBox.prototype._size = function () {
            var _a, _b;
            var font = this.font;
            var fmetrics = text_1.font_metrics(font);
            var line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: max(trailing(L[n-1]), leading(L[n]))
            var empty = this.text == "";
            var lines = this.text.split("\n");
            var nlines = lines.length;
            var widths = lines.map(function (line) { return exports.text_width(line, font); });
            var text_line = this._text_line(fmetrics);
            var text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
        
            const text_height = sum(heights)
            */
            var w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            var h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            var width = array_1.max(widths) * w_scale;
            var height = empty ? 0 : (text_height + line_spacing * (nlines - 1)) * h_scale;
            return { width: width, height: height, metrics: fmetrics };
        };
        TextBox.prototype._computed_position = function (size, metrics, nlines) {
            var _this = this;
            var width = size.width, height = size.height;
            var _a = this.position, sx = _a.sx, sy = _a.sy, _b = _a.x_anchor, x_anchor = _b === void 0 ? "left" : _b, _c = _a.y_anchor, y_anchor = _c === void 0 ? "center" : _c;
            var x = sx - (function () {
                if (types_1.isNumber(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            var y = sy - (function () {
                var _a;
                if (types_1.isNumber(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": {
                            if (nlines == 1) {
                                var metric = (_a = _this.text_height_metric) !== null && _a !== void 0 ? _a : _this.infer_text_height();
                                switch (metric) {
                                    case "x":
                                    case "x_descent":
                                        return metrics.x_height;
                                    case "cap":
                                    case "cap_descent":
                                        return metrics.cap_height;
                                    case "ascent":
                                    case "ascent_descent":
                                        return metrics.ascent;
                                }
                            }
                            else
                                return 0.5 * height;
                        }
                    }
                }
            })();
            return { x: x, y: y };
        };
        TextBox.prototype._rect = function () {
            var _a = this._size(), width = _a.width, height = _a.height, metrics = _a.metrics;
            var nlines = this.text.split("\n").length;
            var _b = this._computed_position({ width: width, height: height }, metrics, nlines), x = _b.x, y = _b.y;
            var bbox = new bbox_1.BBox({ x: x, y: y, width: width, height: height });
            return bbox.rect;
        };
        TextBox.prototype.paint = function (ctx) {
            var _a, _b;
            var font = this.font;
            var fmetrics = text_1.font_metrics(font);
            var line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: see above
            var lines = this.text.split("\n");
            var nlines = lines.length;
            var widths = lines.map(function (line) { return exports.text_width(line, font); });
            var text_line = this._text_line(fmetrics);
            var text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
            */
            var w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            var h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            var width = array_1.max(widths) * w_scale;
            var height = (text_height + line_spacing * (nlines - 1)) * h_scale;
            ctx.save();
            ctx.fillStyle = this.color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            var _c = this.position, sx = _c.sx, sy = _c.sy;
            var align = this.align;
            var angle = this.angle;
            if (angle) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            var _d = this._computed_position({ width: width, height: height }, fmetrics, nlines), x = _d.x, y = _d.y;
            if (align == "justify") {
                for (var i = 0; i < nlines; i++) {
                    var xij = x;
                    var line = lines[i];
                    var words = line.split(" ");
                    var nwords = words.length;
                    var word_widths = words.map(function (word) { return exports.text_width(word, font); });
                    var word_spacing = (width - array_1.sum(word_widths)) / (nwords - 1);
                    for (var j = 0; j < nwords; j++) {
                        ctx.fillText(words[j], xij, y);
                        xij += word_widths[j] + word_spacing;
                    }
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            else {
                var _loop_1 = function (i) {
                    var xi = x + (function () {
                        switch (align) {
                            case "left": return 0;
                            case "center": return 0.5 * (width - widths[i]);
                            case "right": return width - widths[i];
                        }
                    })();
                    ctx.fillStyle = this_1.color;
                    ctx.fillText(lines[i], xi, y + /*ascents[i]*/ text_line.ascent);
                    y += /*heights[i]*/ text_line.height + line_spacing;
                };
                var this_1 = this;
                for (var i = 0; i < nlines; i++) {
                    _loop_1(i);
                }
            }
            ctx.restore();
        };
        return TextBox;
    }(GraphicsBox));
    exports.TextBox = TextBox;
    TextBox.__name__ = "TextBox";
    var BaseExpo = /** @class */ (function (_super) {
        tslib_1.__extends(BaseExpo, _super);
        function BaseExpo(base, expo) {
            var _this = _super.call(this) || this;
            _this.base = base;
            _this.expo = expo;
            return _this;
        }
        Object.defineProperty(BaseExpo.prototype, "children", {
            get: function () {
                return [this.base, this.expo];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseExpo.prototype, "position", {
            get: function () {
                return this._position;
            },
            set: function (p) {
                this._position = p;
                var bs = this.base.size();
                var es = this.expo.size();
                var shift = this._shift_scale() * bs.height;
                var height = Math.max(bs.height, shift + es.height);
                this.base.position = {
                    sx: 0, x_anchor: "left",
                    sy: height, y_anchor: "bottom",
                };
                this.expo.position = {
                    sx: bs.width, x_anchor: "left",
                    sy: shift, y_anchor: "bottom",
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseExpo.prototype, "visuals", {
            set: function (v) {
                this.expo.font_size_scale = 0.7;
                this.base.visuals = v;
                this.expo.visuals = v;
            },
            enumerable: false,
            configurable: true
        });
        BaseExpo.prototype._shift_scale = function () {
            if (this.base instanceof TextBox && this.base.nlines == 1) {
                var _a = text_1.font_metrics(this.base.font), x_height = _a.x_height, cap_height = _a.cap_height;
                return x_height / cap_height;
            }
            else {
                return 2 / 3;
            }
        };
        BaseExpo.prototype.infer_text_height = function () {
            return this.base.infer_text_height();
        };
        BaseExpo.prototype._rect = function () {
            var bb = this.base.bbox();
            var eb = this.expo.bbox();
            var bbox = bb.union(eb);
            var _a = this._computed_position(), x = _a.x, y = _a.y;
            return bbox.translate(x, y).rect;
        };
        BaseExpo.prototype._size = function () {
            var bs = this.base.size();
            var es = this.expo.size();
            return {
                width: bs.width + es.width,
                height: Math.max(bs.height, this._shift_scale() * bs.height + es.height),
            };
        };
        BaseExpo.prototype.paint = function (ctx) {
            ctx.save();
            var angle = this.angle;
            if (angle) {
                var _a = this.position, sx = _a.sx, sy = _a.sy;
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            var _b = this._computed_position(), x = _b.x, y = _b.y;
            ctx.translate(x, y);
            this.base.paint(ctx);
            this.expo.paint(ctx);
            ctx.restore();
        };
        // paint_rect ...
        BaseExpo.prototype.paint_bbox = function (ctx) {
            var e_2, _a;
            _super.prototype.paint_bbox.call(this, ctx);
            var _b = this._computed_position(), x = _b.x, y = _b.y;
            ctx.save();
            ctx.translate(x, y);
            try {
                for (var _c = tslib_1.__values(this.children), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var child = _d.value;
                    child.paint_bbox(ctx);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            ctx.restore();
        };
        BaseExpo.prototype._computed_position = function () {
            var _a = this._size(), width = _a.width, height = _a.height;
            var _b = this.position, sx = _b.sx, sy = _b.sy, _c = _b.x_anchor, x_anchor = _c === void 0 ? "left" : _c, _d = _b.y_anchor, y_anchor = _d === void 0 ? "center" : _d;
            var x = sx - (function () {
                if (types_1.isNumber(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            var y = sy - (function () {
                if (types_1.isNumber(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": return 0.5 * height; /* TODO */
                    }
                }
            })();
            return { x: x, y: y };
        };
        return BaseExpo;
    }(GraphicsBox));
    exports.BaseExpo = BaseExpo;
    BaseExpo.__name__ = "BaseExpo";
    var GraphicsBoxes = /** @class */ (function () {
        function GraphicsBoxes(items) {
            this.items = items;
        }
        Object.defineProperty(GraphicsBoxes.prototype, "length", {
            get: function () {
                return this.items.length;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(GraphicsBoxes.prototype, "visuals", {
            set: function (v) {
                var e_3, _a, e_4, _b;
                try {
                    for (var _c = tslib_1.__values(this.items), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var item = _d.value;
                        item.visuals = v;
                    }
                }
                catch (e_3_1) {
                    e_3 = { error: e_3_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_3)
                            throw e_3.error;
                    }
                }
                var metric_map = { x: 0, cap: 1, ascent: 2, x_descent: 3, cap_descent: 4, ascent_descent: 5 };
                var common = array_1.max_by(this.items.map(function (item) { return item.infer_text_height(); }), function (metric) { return metric_map[metric]; });
                try {
                    for (var _e = tslib_1.__values(this.items), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var item = _f.value;
                        item.text_height_metric = common;
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (_f && !_f.done && (_b = _e.return))
                            _b.call(_e);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(GraphicsBoxes.prototype, "angle", {
            set: function (a) {
                var e_5, _a;
                try {
                    for (var _b = tslib_1.__values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var item = _c.value;
                        item.angle = a;
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
            },
            enumerable: false,
            configurable: true
        });
        GraphicsBoxes.prototype.max_size = function () {
            var e_6, _a;
            var width = 0;
            var height = 0;
            try {
                for (var _b = tslib_1.__values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    var size = item.size();
                    width = Math.max(width, size.width);
                    height = Math.max(height, size.height);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            return { width: width, height: height };
        };
        return GraphicsBoxes;
    }());
    exports.GraphicsBoxes = GraphicsBoxes;
    GraphicsBoxes.__name__ = "GraphicsBoxes";
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var sin = Math.sin, cos = Math.cos;
    var AffineTransform = /** @class */ (function () {
        function AffineTransform(a, b, c, d, e, f) {
            if (a === void 0) {
                a = 1;
            }
            if (b === void 0) {
                b = 0;
            }
            if (c === void 0) {
                c = 0;
            }
            if (d === void 0) {
                d = 1;
            }
            if (e === void 0) {
                e = 0;
            }
            if (f === void 0) {
                f = 0;
            }
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        AffineTransform.prototype.toString = function () {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            return "matrix(" + a + ", " + b + ", " + c + ", " + d + ", " + e + ", " + f + ")";
        };
        AffineTransform.from_DOMMatrix = function (matrix) {
            var a = matrix.a, b = matrix.b, c = matrix.c, d = matrix.d, e = matrix.e, f = matrix.f;
            return new AffineTransform(a, b, c, d, e, f);
        };
        AffineTransform.prototype.to_DOMMatrix = function () {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            return new DOMMatrix([a, b, c, d, e, f]);
        };
        AffineTransform.prototype.clone = function () {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            return new AffineTransform(a, b, c, d, e, f);
        };
        Object.defineProperty(AffineTransform.prototype, "is_identity", {
            get: function () {
                var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
                return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
            },
            enumerable: false,
            configurable: true
        });
        AffineTransform.prototype.apply_point = function (p) {
            var _a = tslib_1.__read(this.apply(p.x, p.y), 2), x = _a[0], y = _a[1];
            return { x: x, y: y };
        };
        AffineTransform.prototype.apply_rect = function (rect) {
            var p0 = this.apply_point(rect.p0);
            var p1 = this.apply_point(rect.p1);
            var p2 = this.apply_point(rect.p2);
            var p3 = this.apply_point(rect.p3);
            return { p0: p0, p1: p1, p2: p2, p3: p3 };
        };
        AffineTransform.prototype.apply = function (x, y) {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        };
        AffineTransform.prototype.iv_apply = function (xs, ys) {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            var n = xs.length;
            for (var i = 0; i < n; i++) {
                var x = xs[i];
                var y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        };
        AffineTransform.prototype.transform = function (A, B, C, D, E, F) {
            var _a = this, a = _a.a, b = _a.b, c = _a.c, d = _a.d, e = _a.e, f = _a.f;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        };
        AffineTransform.prototype.translate = function (tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        };
        AffineTransform.prototype.scale = function (cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        };
        AffineTransform.prototype.skew = function (sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        };
        AffineTransform.prototype.rotate = function (angle) {
            var s = sin(angle);
            var c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        };
        AffineTransform.prototype.rotate_ccw = function (angle) {
            return this.rotate(-angle);
        };
        AffineTransform.prototype.translate_x = function (tx) {
            return this.translate(tx, 0);
        };
        AffineTransform.prototype.translate_y = function (ty) {
            return this.translate(0, ty);
        };
        AffineTransform.prototype.flip = function () {
            return this.scale(-1, -1);
        };
        AffineTransform.prototype.flip_x = function () {
            return this.scale(1, -1);
        };
        AffineTransform.prototype.flip_y = function () {
            return this.scale(-1, 1);
        };
        return AffineTransform;
    }());
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
},
/* models/policies/labeling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var object_1 = require(128) /* ../../core/util/object */;
    var string_1 = require(149) /* ../../core/util/string */;
    var types_1 = require(123) /* ../../core/util/types */;
    var types_2 = require(139) /* ../../core/types */;
    var LabelingPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(LabelingPolicy, _super);
        function LabelingPolicy(attrs) {
            return _super.call(this, attrs) || this;
        }
        return LabelingPolicy;
    }(model_1.Model));
    exports.LabelingPolicy = LabelingPolicy;
    LabelingPolicy.__name__ = "LabelingPolicy";
    var AllLabels = /** @class */ (function (_super) {
        tslib_1.__extends(AllLabels, _super);
        function AllLabels(attrs) {
            return _super.call(this, attrs) || this;
        }
        AllLabels.prototype.filter = function (indices, _bboxes, _distance) {
            return indices;
        };
        return AllLabels;
    }(LabelingPolicy));
    exports.AllLabels = AllLabels;
    AllLabels.__name__ = "AllLabels";
    var NoOverlap = /** @class */ (function (_super) {
        tslib_1.__extends(NoOverlap, _super);
        function NoOverlap(attrs) {
            return _super.call(this, attrs) || this;
        }
        NoOverlap.init_NoOverlap = function () {
            this.define(function (_a) {
                var Number = _a.Number;
                return ({
                    min_distance: [Number, 5],
                });
            });
        };
        NoOverlap.prototype.filter = function (indices, _bboxes, distance) {
            var e_1, _a;
            var min_distance = this.min_distance;
            var k = null;
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    if (k != null && distance(k, i) < min_distance)
                        indices.unset(i);
                    else
                        k = i;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return indices;
        };
        return NoOverlap;
    }(LabelingPolicy));
    exports.NoOverlap = NoOverlap;
    NoOverlap.__name__ = "NoOverlap";
    NoOverlap.init_NoOverlap();
    var CustomLabelingPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(CustomLabelingPolicy, _super);
        function CustomLabelingPolicy(attrs) {
            return _super.call(this, attrs) || this;
        }
        CustomLabelingPolicy.init_CustomLabelingPolicy = function () {
            this.define(function (_a) {
                var Unknown = _a.Unknown, String = _a.String, Dict = _a.Dict;
                return ({
                    args: [Dict(Unknown), {}],
                    code: [String, ""],
                });
            });
        };
        Object.defineProperty(CustomLabelingPolicy.prototype, "names", {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CustomLabelingPolicy.prototype, "values", {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CustomLabelingPolicy.prototype, "func", {
            get: function () {
                var code = string_1.use_strict(this.code);
                return new (types_2.GeneratorFunction.bind.apply(types_2.GeneratorFunction, tslib_1.__spreadArray(tslib_1.__spreadArray([void 0, "indices", "bboxes", "distance"], tslib_1.__read(this.names)), [code])))();
            },
            enumerable: false,
            configurable: true
        });
        CustomLabelingPolicy.prototype.filter = function (indices, bboxes, distance) {
            var _a;
            var obj = Object.create(null);
            var generator = (_a = this.func).call.apply(_a, tslib_1.__spreadArray([obj, indices, bboxes, distance], tslib_1.__read(this.values)));
            var result = generator.next();
            if (result.done && result.value !== undefined) {
                var value = result.value;
                if (value instanceof types_2.Indices)
                    return value;
                else if (value === undefined)
                    return indices;
                else if (types_1.isIterable(value))
                    return types_2.Indices.from_indices(indices.size, value);
                else
                    return types_2.Indices.all_unset(indices.size);
            }
            else {
                var array = [];
                do {
                    array.push(result.value);
                    result = generator.next();
                } while (!result.done);
                return types_2.Indices.from_indices(indices.size, array);
            }
        };
        return CustomLabelingPolicy;
    }(LabelingPolicy));
    exports.CustomLabelingPolicy = CustomLabelingPolicy;
    CustomLabelingPolicy.__name__ = "CustomLabelingPolicy";
    CustomLabelingPolicy.init_CustomLabelingPolicy();
},
/* models/axes/categorical_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var axis_1 = require(241) /* ./axis */;
    var categorical_ticker_1 = require(249) /* ../tickers/categorical_ticker */;
    var categorical_tick_formatter_1 = require(250) /* ../formatters/categorical_tick_formatter */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var enums_1 = require(135) /* ../../core/enums */;
    var graphics_1 = require(245) /* ../../core/graphics */;
    var types_1 = require(123) /* ../../core/util/types */;
    var CategoricalAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalAxisView, _super);
        function CategoricalAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CategoricalAxisView.prototype._paint = function (ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        };
        CategoricalAxisView.prototype._draw_group_separators = function (ctx, _extents, _tick_coords) {
            var _a;
            var _b = tslib_1.__read(this.ranges, 1), range = _b[0];
            var _c = tslib_1.__read(this.computed_bounds, 2), start = _c[0], end = _c[1];
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            var dim = this.dimension;
            var alt = (dim + 1) % 2;
            var coords = [[], []];
            var ind = 0;
            for (var i = 0; i < range.tops.length - 1; i++) {
                var first = void 0, last = void 0;
                for (var j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        _a = tslib_1.__read([range.factors[j - 1], range.factors[j]], 2), first = _a[0], last = _a[1];
                        ind = j;
                        break;
                    }
                }
                var pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.loc);
                }
            }
            var tex = this.extents.tick_label;
            this._draw_ticks(ctx, coords, -3, tex - 6, this.visuals.separator_line);
        };
        CategoricalAxisView.prototype._draw_major_labels = function (ctx, extents, _tick_coords) {
            var info = this._get_factor_info();
            var standoff = extents.tick + this.model.major_label_standoff;
            for (var i = 0; i < info.length; i++) {
                var _a = tslib_1.__read(info[i], 4), labels = _a[0], coords = _a[1], orient = _a[2], visuals = _a[3];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
                standoff += extents.tick_labels[i];
            }
        };
        CategoricalAxisView.prototype._tick_label_extents = function () {
            var e_1, _a;
            var info = this._get_factor_info();
            var extents = [];
            try {
                for (var info_1 = tslib_1.__values(info), info_1_1 = info_1.next(); !info_1_1.done; info_1_1 = info_1.next()) {
                    var _b = tslib_1.__read(info_1_1.value, 4), labels = _b[0], orient = _b[2], visuals = _b[3];
                    var extent = this._oriented_labels_extent(labels, orient, this.model.major_label_standoff, visuals);
                    extents.push(extent);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (info_1_1 && !info_1_1.done && (_a = info_1.return))
                        _a.call(info_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return extents;
        };
        CategoricalAxisView.prototype._get_factor_info = function () {
            var _this = this;
            var _a = tslib_1.__read(this.ranges, 1), range = _a[0];
            var _b = tslib_1.__read(this.computed_bounds, 2), start = _b[0], end = _b[1];
            var loc = this.loc;
            var ticks = this.model.ticker.get_ticks(start, end, range, loc);
            var coords = this.tick_coords;
            var info = [];
            var map = function (labels) {
                return new graphics_1.GraphicsBoxes(labels.map(function (label) { return types_1.isString(label) ? new graphics_1.TextBox({ text: label }) : label; }));
            };
            var format = function (ticks) {
                return map(_this.model.formatter.doFormat(ticks, _this));
            };
            if (range.levels == 1) {
                var major = ticks.major;
                var labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
            }
            else if (range.levels == 2) {
                var major = ticks.major.map(function (x) { return x[1]; });
                var labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            else if (range.levels == 3) {
                var major = ticks.major.map(function (x) { return x[2]; });
                var labels = format(major);
                var mid_labels = ticks.mids.map(function (x) { return x[1]; });
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(mid_labels), coords.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            return info;
        };
        Object.defineProperty(CategoricalAxisView.prototype, "tick_coords", {
            get: function () {
                var _this = this;
                var i = this.dimension;
                var j = (i + 1) % 2;
                var _a = tslib_1.__read(this.ranges, 1), range = _a[0];
                var _b = tslib_1.__read(this.computed_bounds, 2), start = _b[0], end = _b[1];
                var ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
                var coords = {
                    major: [[], []],
                    mids: [[], []],
                    tops: [[], []],
                    minor: [[], []],
                };
                coords.major[i] = ticks.major;
                coords.major[j] = ticks.major.map(function () { return _this.loc; });
                if (range.levels == 3) {
                    coords.mids[i] = ticks.mids;
                    coords.mids[j] = ticks.mids.map(function () { return _this.loc; });
                }
                if (range.levels > 1) {
                    coords.tops[i] = ticks.tops;
                    coords.tops[j] = ticks.tops.map(function () { return _this.loc; });
                }
                return coords;
            },
            enumerable: false,
            configurable: true
        });
        return CategoricalAxisView;
    }(axis_1.AxisView));
    exports.CategoricalAxisView = CategoricalAxisView;
    CategoricalAxisView.__name__ = "CategoricalAxisView";
    var CategoricalAxis = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalAxis, _super);
        function CategoricalAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalAxis.init_CategoricalAxis = function () {
            this.prototype.default_view = CategoricalAxisView;
            this.mixins([
                ["separator_", mixins.Line],
                ["group_", mixins.Text],
                ["subgroup_", mixins.Text],
            ]);
            this.define(function (_a) {
                var Number = _a.Number, Or = _a.Or;
                return ({
                    group_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
                    subgroup_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
                });
            });
            this.override({
                ticker: function () { return new categorical_ticker_1.CategoricalTicker(); },
                formatter: function () { return new categorical_tick_formatter_1.CategoricalTickFormatter(); },
                separator_line_color: "lightgrey",
                separator_line_width: 2,
                group_text_font_style: "bold",
                group_text_font_size: "11px",
                group_text_color: "grey",
                subgroup_text_font_style: "bold",
                subgroup_text_font_size: "11px",
            });
        };
        return CategoricalAxis;
    }(axis_1.Axis));
    exports.CategoricalAxis = CategoricalAxis;
    CategoricalAxis.__name__ = "CategoricalAxis";
    CategoricalAxis.init_CategoricalAxis();
},
/* models/tickers/categorical_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var ticker_1 = require(243) /* ./ticker */;
    var CategoricalTicker = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalTicker, _super);
        function CategoricalTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalTicker.prototype.get_ticks = function (start, end, range, _cross_loc) {
            var _a, _b;
            var majors = this._collect(range.factors, range, start, end);
            var tops = this._collect((_a = range.tops) !== null && _a !== void 0 ? _a : [], range, start, end);
            var mids = this._collect((_b = range.mids) !== null && _b !== void 0 ? _b : [], range, start, end);
            return {
                major: majors,
                minor: [],
                tops: tops,
                mids: mids,
            };
        };
        CategoricalTicker.prototype._collect = function (factors, range, start, end) {
            var e_1, _a;
            var result = [];
            try {
                for (var factors_1 = tslib_1.__values(factors), factors_1_1 = factors_1.next(); !factors_1_1.done; factors_1_1 = factors_1.next()) {
                    var factor = factors_1_1.value;
                    var coord = range.synthetic(factor);
                    if (coord > start && coord < end)
                        result.push(factor);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (factors_1_1 && !factors_1_1.done && (_a = factors_1.return))
                        _a.call(factors_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return result;
        };
        return CategoricalTicker;
    }(ticker_1.Ticker));
    exports.CategoricalTicker = CategoricalTicker;
    CategoricalTicker.__name__ = "CategoricalTicker";
},
/* models/formatters/categorical_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var tick_formatter_1 = require(244) /* ./tick_formatter */;
    var array_1 = require(124) /* ../../core/util/array */;
    var CategoricalTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalTickFormatter, _super);
        function CategoricalTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalTickFormatter.prototype.doFormat = function (ticks, _opts) {
            return array_1.copy(ticks);
        };
        return CategoricalTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
},
/* models/axes/continuous_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var axis_1 = require(241) /* ./axis */;
    var ContinuousAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousAxisView, _super);
        function ContinuousAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ContinuousAxisView;
    }(axis_1.AxisView));
    exports.ContinuousAxisView = ContinuousAxisView;
    ContinuousAxisView.__name__ = "ContinuousAxisView";
    var ContinuousAxis = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousAxis, _super);
        function ContinuousAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        return ContinuousAxis;
    }(axis_1.Axis));
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.__name__ = "ContinuousAxis";
},
/* models/axes/datetime_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var linear_axis_1 = require(253) /* ./linear_axis */;
    var datetime_tick_formatter_1 = require(258) /* ../formatters/datetime_tick_formatter */;
    var datetime_ticker_1 = require(263) /* ../tickers/datetime_ticker */;
    var DatetimeAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeAxisView, _super);
        function DatetimeAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DatetimeAxisView;
    }(linear_axis_1.LinearAxisView));
    exports.DatetimeAxisView = DatetimeAxisView;
    DatetimeAxisView.__name__ = "DatetimeAxisView";
    var DatetimeAxis = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeAxis, _super);
        function DatetimeAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        DatetimeAxis.init_DatetimeAxis = function () {
            this.prototype.default_view = DatetimeAxisView;
            this.override({
                ticker: function () { return new datetime_ticker_1.DatetimeTicker(); },
                formatter: function () { return new datetime_tick_formatter_1.DatetimeTickFormatter(); },
            });
        };
        return DatetimeAxis;
    }(linear_axis_1.LinearAxis));
    exports.DatetimeAxis = DatetimeAxis;
    DatetimeAxis.__name__ = "DatetimeAxis";
    DatetimeAxis.init_DatetimeAxis();
},
/* models/axes/linear_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var continuous_axis_1 = require(251) /* ./continuous_axis */;
    var basic_tick_formatter_1 = require(254) /* ../formatters/basic_tick_formatter */;
    var basic_ticker_1 = require(255) /* ../tickers/basic_ticker */;
    var LinearAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(LinearAxisView, _super);
        function LinearAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LinearAxisView;
    }(continuous_axis_1.ContinuousAxisView));
    exports.LinearAxisView = LinearAxisView;
    LinearAxisView.__name__ = "LinearAxisView";
    var LinearAxis = /** @class */ (function (_super) {
        tslib_1.__extends(LinearAxis, _super);
        function LinearAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearAxis.init_LinearAxis = function () {
            this.prototype.default_view = LinearAxisView;
            this.override({
                ticker: function () { return new basic_ticker_1.BasicTicker(); },
                formatter: function () { return new basic_tick_formatter_1.BasicTickFormatter(); },
            });
        };
        return LinearAxis;
    }(continuous_axis_1.ContinuousAxis));
    exports.LinearAxis = LinearAxis;
    LinearAxis.__name__ = "LinearAxis";
    LinearAxis.init_LinearAxis();
},
/* models/formatters/basic_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var tick_formatter_1 = require(244) /* ./tick_formatter */;
    var string_1 = require(149) /* ../../core/util/string */;
    function unicode_replace(input) {
        var e_1, _a;
        var output = "";
        try {
            for (var input_1 = tslib_1.__values(input), input_1_1 = input_1.next(); !input_1_1.done; input_1_1 = input_1.next()) {
                var c = input_1_1.value;
                if (c == "-")
                    output += "\u2212";
                else
                    output += c;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (input_1_1 && !input_1_1.done && (_a = input_1.return))
                    _a.call(input_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return output;
    }
    exports.unicode_replace = unicode_replace;
    var BasicTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(BasicTickFormatter, _super);
        function BasicTickFormatter(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.last_precision = 3;
            return _this;
        }
        BasicTickFormatter.init_BasicTickFormatter = function () {
            this.define(function (_a) {
                var Boolean = _a.Boolean, Int = _a.Int, Auto = _a.Auto, Or = _a.Or;
                return ({
                    precision: [Or(Int, Auto), "auto"],
                    use_scientific: [Boolean, true],
                    power_limit_high: [Int, 5],
                    power_limit_low: [Int, -3],
                });
            });
        };
        Object.defineProperty(BasicTickFormatter.prototype, "scientific_limit_low", {
            get: function () {
                return Math.pow(10.0, this.power_limit_low);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BasicTickFormatter.prototype, "scientific_limit_high", {
            get: function () {
                return Math.pow(10.0, this.power_limit_high);
            },
            enumerable: false,
            configurable: true
        });
        BasicTickFormatter.prototype._need_sci = function (ticks) {
            var e_2, _a;
            if (!this.use_scientific)
                return false;
            var scientific_limit_high = this.scientific_limit_high;
            var scientific_limit_low = this.scientific_limit_low;
            var zeroish = ticks.length < 2 ? 0 : Math.abs(ticks[1] - ticks[0]) / 10000;
            try {
                for (var ticks_1 = tslib_1.__values(ticks), ticks_1_1 = ticks_1.next(); !ticks_1_1.done; ticks_1_1 = ticks_1.next()) {
                    var tick = ticks_1_1.value;
                    var tick_abs = Math.abs(tick);
                    if (tick_abs <= zeroish)
                        continue;
                    if (tick_abs >= scientific_limit_high || tick_abs <= scientific_limit_low) {
                        return true;
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (ticks_1_1 && !ticks_1_1.done && (_a = ticks_1.return))
                        _a.call(ticks_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return false;
        };
        BasicTickFormatter.prototype._format_with_precision = function (ticks, need_sci, precision) {
            if (need_sci) {
                return ticks.map(function (tick) { return unicode_replace(tick.toExponential(precision)); });
            }
            else {
                return ticks.map(function (tick) { return unicode_replace(string_1.to_fixed(tick, precision)); });
            }
        };
        BasicTickFormatter.prototype._auto_precision = function (ticks, need_sci) {
            var labels = new Array(ticks.length);
            var asc = this.last_precision <= 15;
            outer: for (var x = this.last_precision; asc ? x <= 15 : x >= 1; asc ? x++ : x--) {
                if (need_sci) {
                    labels[0] = ticks[0].toExponential(x);
                    for (var i = 1; i < ticks.length; i++) {
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
                else {
                    labels[0] = string_1.to_fixed(ticks[0], x);
                    for (var i = 1; i < ticks.length; i++) {
                        labels[i] = string_1.to_fixed(ticks[i], x);
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
            }
            return this.last_precision;
        };
        BasicTickFormatter.prototype.doFormat = function (ticks, _opts) {
            if (ticks.length == 0)
                return [];
            var need_sci = this._need_sci(ticks);
            var precision = this.precision == "auto" ? this._auto_precision(ticks, need_sci) : this.precision;
            return this._format_with_precision(ticks, need_sci, precision);
        };
        return BasicTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.BasicTickFormatter = BasicTickFormatter;
    BasicTickFormatter.__name__ = "BasicTickFormatter";
    BasicTickFormatter.init_BasicTickFormatter();
},
/* models/tickers/basic_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var adaptive_ticker_1 = require(256) /* ./adaptive_ticker */;
    var BasicTicker = /** @class */ (function (_super) {
        tslib_1.__extends(BasicTicker, _super);
        function BasicTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        return BasicTicker;
    }(adaptive_ticker_1.AdaptiveTicker));
    exports.BasicTicker = BasicTicker;
    BasicTicker.__name__ = "BasicTicker";
},
/* models/tickers/adaptive_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var continuous_ticker_1 = require(257) /* ./continuous_ticker */;
    var array_1 = require(124) /* ../../core/util/array */;
    var math_1 = require(125) /* ../../core/util/math */;
    var AdaptiveTicker = /** @class */ (function (_super) {
        tslib_1.__extends(AdaptiveTicker, _super);
        function AdaptiveTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        AdaptiveTicker.init_AdaptiveTicker = function () {
            this.define(function (_a) {
                var Number = _a.Number, Array = _a.Array, Nullable = _a.Nullable;
                return ({
                    base: [Number, 10.0],
                    mantissas: [Array(Number), [1, 2, 5]],
                    min_interval: [Number, 0.0],
                    max_interval: [Nullable(Number), null],
                });
            });
        };
        AdaptiveTicker.prototype.get_min_interval = function () {
            return this.min_interval;
        };
        AdaptiveTicker.prototype.get_max_interval = function () {
            var _a;
            return (_a = this.max_interval) !== null && _a !== void 0 ? _a : Infinity;
        };
        // These arguments control the range of possible intervals.  The interval I
        // returned by get_interval() will be the one that most closely matches the
        // desired number of ticks, subject to the following constraints:
        // I = (M * B^N), where
        // M is a member of mantissas,
        // B is base,
        // and N is an integer;
        // and min_interval <= I <= max_interval.
        AdaptiveTicker.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var prefix_mantissa = array_1.nth(this.mantissas, -1) / this.base;
            var suffix_mantissa = array_1.nth(this.mantissas, 0) * this.base;
            this.extended_mantissas = tslib_1.__spreadArray(tslib_1.__spreadArray([prefix_mantissa], tslib_1.__read(this.mantissas)), [suffix_mantissa]);
            this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
        };
        AdaptiveTicker.prototype.get_interval = function (data_low, data_high, desired_n_ticks) {
            var data_range = data_high - data_low;
            var ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            var interval_exponent = Math.floor(math_1.log(ideal_interval / this.base_factor, this.base));
            var ideal_magnitude = Math.pow(this.base, interval_exponent) * this.base_factor;
            // An untested optimization.
            //   const ideal_mantissa = ideal_interval / ideal_magnitude
            //   index = sorted_index(this.extended_mantissas, ideal_mantissa)
            //   candidate_mantissas = this.extended_mantissas[index..index + 1]
            var candidate_mantissas = this.extended_mantissas;
            var errors = candidate_mantissas.map(function (mantissa) {
                return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
            });
            var best_mantissa = candidate_mantissas[array_1.argmin(errors)];
            var interval = best_mantissa * ideal_magnitude;
            return math_1.clamp(interval, this.get_min_interval(), this.get_max_interval());
        };
        return AdaptiveTicker;
    }(continuous_ticker_1.ContinuousTicker));
    exports.AdaptiveTicker = AdaptiveTicker;
    AdaptiveTicker.__name__ = "AdaptiveTicker";
    AdaptiveTicker.init_AdaptiveTicker();
},
/* models/tickers/continuous_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var ticker_1 = require(243) /* ./ticker */;
    var array_1 = require(124) /* ../../core/util/array */;
    var ContinuousTicker = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousTicker, _super);
        function ContinuousTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        ContinuousTicker.init_ContinuousTicker = function () {
            this.define(function (_a) {
                var Int = _a.Int;
                return ({
                    num_minor_ticks: [Int, 5],
                    desired_num_ticks: [Int, 6],
                });
            });
        };
        ContinuousTicker.prototype.get_ticks = function (data_low, data_high, _range, cross_loc) {
            return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
        };
        // The version of get_ticks() that does the work (and the version that
        // should be overridden in subclasses).
        ContinuousTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, _cross_loc, desired_n_ticks) {
            var e_1, _a, e_2, _b, e_3, _c;
            var interval = this.get_interval(data_low, data_high, desired_n_ticks);
            var start_factor = Math.floor(data_low / interval);
            var end_factor = Math.ceil(data_high / interval);
            var factors;
            if (!isFinite(start_factor) || !isFinite(end_factor))
                factors = [];
            else
                factors = array_1.range(start_factor, end_factor + 1);
            var ticks = factors
                .map(function (factor) { return factor * interval; })
                .filter(function (tick) { return data_low <= tick && tick <= data_high; });
            var num_minor_ticks = this.num_minor_ticks;
            var minor_ticks = [];
            if (num_minor_ticks > 0 && ticks.length > 0) {
                var minor_interval_1 = interval / num_minor_ticks;
                var minor_offsets = array_1.range(0, num_minor_ticks).map(function (i) { return i * minor_interval_1; });
                try {
                    for (var _d = tslib_1.__values(minor_offsets.slice(1)), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var x = _e.value;
                        var mt = ticks[0] - x;
                        if (data_low <= mt && mt <= data_high) {
                            minor_ticks.push(mt);
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_e && !_e.done && (_a = _d.return))
                            _a.call(_d);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                try {
                    for (var ticks_1 = tslib_1.__values(ticks), ticks_1_1 = ticks_1.next(); !ticks_1_1.done; ticks_1_1 = ticks_1.next()) {
                        var tick = ticks_1_1.value;
                        try {
                            for (var minor_offsets_1 = (e_3 = void 0, tslib_1.__values(minor_offsets)), minor_offsets_1_1 = minor_offsets_1.next(); !minor_offsets_1_1.done; minor_offsets_1_1 = minor_offsets_1.next()) {
                                var x = minor_offsets_1_1.value;
                                var mt = tick + x;
                                if (data_low <= mt && mt <= data_high) {
                                    minor_ticks.push(mt);
                                }
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (minor_offsets_1_1 && !minor_offsets_1_1.done && (_c = minor_offsets_1.return))
                                    _c.call(minor_offsets_1);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (ticks_1_1 && !ticks_1_1.done && (_b = ticks_1.return))
                            _b.call(ticks_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
            return {
                major: ticks,
                minor: minor_ticks,
            };
        };
        // Returns the interval size that would produce exactly the number of
        // desired ticks.  (In general we won't use exactly this interval, because
        // we want the ticks to be round numbers.)
        ContinuousTicker.prototype.get_ideal_interval = function (data_low, data_high, desired_n_ticks) {
            var data_range = data_high - data_low;
            return data_range / desired_n_ticks;
        };
        return ContinuousTicker;
    }(ticker_1.Ticker));
    exports.ContinuousTicker = ContinuousTicker;
    ContinuousTicker.__name__ = "ContinuousTicker";
    ContinuousTicker.init_ContinuousTicker();
},
/* models/f