"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDnsPolicyHelper = void 0;
const iam = require("@aws-cdk/aws-iam");
const AwsExternalDnsPolicy = [
    {
        Effect: 'Allow',
        Action: [
            'route53:ChangeResourceRecordSets',
        ],
        Resource: [
            'arn:aws:route53:::hostedzone/*',
        ],
    },
    {
        Effect: 'Allow',
        Action: [
            'route53:ListHostedZones',
            'route53:ListResourceRecordSets',
        ],
        Resource: [
            '*',
        ],
    },
];
/**
 * Aws External Dns Policy class ,help you add policy to your Iam Role for service account.
 */
class AwsExternalDnsPolicyHelper {
    static addPolicy(role) {
        AwsExternalDnsPolicy.forEach(e => {
            role.addToPolicy(iam.PolicyStatement.fromJson(e));
        });
        return role;
    }
}
exports.AwsExternalDnsPolicyHelper = AwsExternalDnsPolicyHelper;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3BvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBd0M7QUFFeEMsTUFBTSxvQkFBb0IsR0FBRztJQUMzQjtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sa0NBQWtDO1NBQ25DO1FBQ0QsUUFBUSxFQUFFO1lBQ1IsZ0NBQWdDO1NBQ2pDO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04seUJBQXlCO1lBQ3pCLGdDQUFnQztTQUNqQztRQUNELFFBQVEsRUFBRTtZQUNSLEdBQUc7U0FDSjtLQUNGO0NBQ0YsQ0FBQztBQUVGOztHQUVHO0FBQ0gsTUFBYSwwQkFBMEI7SUFDOUIsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFTO1FBQy9CLG9CQUFvQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUMvQixJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDcEQsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Q0FDRjtBQVBELGdFQU9DO0FBQUEsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcblxuY29uc3QgQXdzRXh0ZXJuYWxEbnNQb2xpY3kgPSBbXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAncm91dGU1MzpDaGFuZ2VSZXNvdXJjZVJlY29yZFNldHMnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6IFtcbiAgICAgICdhcm46YXdzOnJvdXRlNTM6Ojpob3N0ZWR6b25lLyonLFxuICAgIF0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAncm91dGU1MzpMaXN0SG9zdGVkWm9uZXMnLFxuICAgICAgJ3JvdXRlNTM6TGlzdFJlc291cmNlUmVjb3JkU2V0cycsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogW1xuICAgICAgJyonLFxuICAgIF0sXG4gIH0sXG5dO1xuXG4vKipcbiAqIEF3cyBFeHRlcm5hbCBEbnMgUG9saWN5IGNsYXNzICxoZWxwIHlvdSBhZGQgcG9saWN5IHRvIHlvdXIgSWFtIFJvbGUgZm9yIHNlcnZpY2UgYWNjb3VudC5cbiAqL1xuZXhwb3J0IGNsYXNzIEF3c0V4dGVybmFsRG5zUG9saWN5SGVscGVyIHtcbiAgcHVibGljIHN0YXRpYyBhZGRQb2xpY3kocm9sZTogYW55KSA6YW55IHtcbiAgICBBd3NFeHRlcm5hbERuc1BvbGljeS5mb3JFYWNoKGUgPT4ge1xuICAgICAgcm9sZS5hZGRUb1BvbGljeShpYW0uUG9saWN5U3RhdGVtZW50LmZyb21Kc29uKGUpKTtcbiAgICB9KTtcbiAgICByZXR1cm4gcm9sZTtcbiAgfVxufTsiXX0=