"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
/**
 * (experimental) Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @experimental
 */
class AwsExternalDns extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'external-dns';
        this.deploymentName = 'external-dns';
        this.namespace = (_c = options.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.image = (_d = options.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/external-dns/external-dns:v0.7.6';
        new cdk8s.ApiObject(this, 'external-dns-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRole',
            metadata: {
                name: 'external-dns',
            },
            rules: [
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'services',
                        'endpoints',
                        'pods',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        'extensions',
                        'networking.k8s.io',
                    ],
                    resources: [
                        'ingresses',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'nodes',
                    ],
                    verbs: [
                        'list',
                        'watch',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-cluster-role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRoleBinding',
            metadata: {
                name: 'external-dns-viewer',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'external-dns',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-deploy', {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                name: this.deploymentName,
                namespace: this.namespace,
            },
            spec: {
                strategy: {
                    type: 'Recreate',
                },
                selector: {
                    matchLabels: {
                        app: this.deploymentName,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: this.deploymentName,
                        },
                    },
                    spec: {
                        serviceAccountName: this.serviceAccountName,
                        containers: [
                            {
                                name: this.deploymentName,
                                image: this.image,
                                args: this.argsFunc(options.args),
                            },
                        ],
                        securityContext: {
                            fsGroup: 65534,
                        },
                    },
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--source=service', '--source=ingress', '--provider=aws', '--registry=txt', '--txt-owner-id=external-dns'];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
}
exports.AwsExternalDns = AwsExternalDns;
_a = JSII_RTTI_SYMBOL_1;
AwsExternalDns[_a] = { fqn: "@opencdk8s/cdk8s-external-dns-route53.AwsExternalDns", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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