# **********************************************************
# File generated by the HALCON-Compiler hcomp version 22.05
# Usage: Interface to Python
#
# Software by: MVTec Software GmbH, www.mvtec.com
# **********************************************************

# mypy: no-warn-unused-ignores

from typing import Sequence, Tuple, Optional, Union

from .ffi import (
    HalconOperator,
    HTupleElementType,
    HTupleType,
)

from .util import MaybeSequence
from .hhandle import HHandle
from .hobject import HObject


def abs_diff_image(
    image_1: HObject,
    image_2: HObject,
    mult: Union[int, float]
) -> HObject:
    """
    Calculate the absolute difference of two images.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    mult : Union[int, float]
           Scale factor.
           Value Suggestion: 1.0
           Assertion: Mult > 0

    Returns
    -------

    image_abs_diff : HObject
                     Absolute value of the difference of the input images.

    See Also
    --------
    add_image, scale_image, dyn_threshold

    Alternatives
    ------------
    sub_image

    Successors
    ----------
    threshold

    Notes
    -----
    Note that the acceleration gained by SIMD technology is highest on
    large, compact input regions. However, in rare cases, the execution of
    abs_diff_image might take significantly longer with SIMD technology
    than without, depending on the input region and the capabilities of
    the hardware. In these cases, the use of SIMD technology can be
    avoided by set_system(::'mmx_enable','false':).
    """
    with HalconOperator(1604) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_tuple(0, mult)
        proc.execute()
        image_abs_diff = HObject(proc.get_output_object_key(1))
        return image_abs_diff  # type: ignore


def abs_funct_1d(
    function: Sequence[Union[float, int]]
) -> Sequence[Union[float, int]]:
    """
    Absolute value of the y values.

    Parameters
    ----------

    function : Sequence[Union[float, int]]
               Input function.

    Returns
    -------

    function_absolute : Sequence[Union[float, int]]
                        Function with the absolute values of the y values.

    Predecessors
    ------------
    create_funct_1d_pairs, create_funct_1d_array
    """
    with HalconOperator(1384) as proc:
        proc.set_input_tuple(0, function)
        proc.init_oct(0)
        proc.execute()
        function_absolute = proc.get_output_tuple_m(0)
        return function_absolute  # type: ignore


def abs_image(image: HObject) -> HObject:
    """
    Calculate the absolute value (modulus) of an image.

    Parameters
    ----------

    image : HObject
            Image(s) for which the absolute gray values are to be
            calculated.

    Returns
    -------

    image_abs : HObject
                Result image(s).

    See Also
    --------
    convert_image_type, power_byte
    """
    with HalconOperator(1611) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        image_abs = HObject(proc.get_output_object_key(1))
        return image_abs  # type: ignore


def abs_matrix(matrix_id: HHandle) -> HHandle:
    """
    Compute the absolute values of the elements of a matrix.

    Parameters
    ----------

    matrix_id : HHandle
                Matrix handle of the input matrix.

    Returns
    -------

    matrix_abs_id : HHandle
                    Matrix handle with the absolute values of the input
                    matrix.

    Alternatives
    ------------
    abs_matrix_mod

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(868) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.init_oct(0)
        proc.execute()
        matrix_abs_id = proc.get_output_tuple_s(0)
        return matrix_abs_id  # type: ignore


def abs_matrix_mod(matrix_id: HHandle) -> None:
    """
    Compute the absolute values of the elements of a matrix.

    Parameters
    ----------

    matrix_id : HHandle
                Matrix handle of the input matrix.

    Alternatives
    ------------
    abs_matrix

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(867) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.execute()


def access_channel(
    multi_channel_image: HObject,
    channel: int
) -> HObject:
    """
    Access a channel of a multi-channel image.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    channel : int
              Index of channel to be accessed.
              Value Suggestion: 1

    Returns
    -------

    image : HObject
            One channel of MultiChannelImage.

    See Also
    --------
    count_channels

    Alternatives
    ------------
    decompose2, decompose3, decompose4, decompose5

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1135) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.set_input_tuple(0, channel)
        proc.execute()
        image = HObject(proc.get_output_object_key(1))
        return image  # type: ignore


def acos_image(image: HObject) -> HObject:
    """
    Calculate the arccosine of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    arccos_image : HObject
                   Output image.

    See Also
    --------
    asin_image, atan_image, atan2_image, tan_image, sin_image, cos_image

    Notes
    -----
    acos_image can be executed on OpenCL devices.
    """
    with HalconOperator(1599) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        arccos_image = HObject(proc.get_output_object_key(1))
        return arccos_image  # type: ignore


def activate_compute_device(device_handle: HHandle) -> None:
    """
    Activate a compute device.

    Parameters
    ----------

    device_handle : HHandle
                    Compute device handle.

    See Also
    --------
    deactivate_compute_device, deactivate_all_compute_devices

    Predecessors
    ------------
    open_compute_device
    """
    with HalconOperator(302) as proc:
        proc.set_input_tuple(0, device_handle)
        proc.execute()


def adapt_shape_model_high_noise(
    image_reduced: HObject,
    model_id: HHandle,
    gen_param: Sequence[str]
) -> HHandle:
    """
    Adapt a shape model's parameters for high noise images.

    Parameters
    ----------

    image_reduced : HObject
                    Sample search image with reduced domain.

    model_id : HHandle
               Handle of the shape model.

    gen_param : Sequence[str]
                Parameters to be estimated.
                Value Suggestion: all

    Returns
    -------

    result_dict : HHandle
                  Dictionary with the estimated parameter values.

    Predecessors
    ------------
    create_generic_shape_model

    Successors
    ----------
    find_generic_shape_model
    """
    with HalconOperator(2204) as proc:
        proc.set_input_object(1, image_reduced)
        proc.set_input_tuple(0, model_id)
        proc.set_input_tuple(1, gen_param)
        proc.init_oct(0)
        proc.execute()
        result_dict = proc.get_output_tuple_s(0)
        return result_dict  # type: ignore


def adapt_template(image: HObject, template_id: HHandle) -> None:
    """
    Adapting a template to the size of an image.

    Parameters
    ----------

    image : HObject
            Image which determines the size of the later matching.

    template_id : HHandle
                  Template number.

    Predecessors
    ------------
    create_template, create_template_rot, read_template

    Successors
    ----------
    set_reference_template, best_match, fast_match, fast_match_mg,
    set_offset_template, best_match_mg, best_match_pre_mg, best_match_rot,
    best_match_rot_mg

    Warnings
    --------
    adapt_template is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1498) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.execute()


def add_channels(regions: HObject, image: HObject) -> HObject:
    """
    Add gray values to regions.

    Parameters
    ----------

    regions : HObject
              Input regions (without pixel values).

    image : HObject
            Input image with pixel values for regions.

    Returns
    -------

    gray_regions : HObject
                   Output image(s) with regions and pixel values (one
                   image per input region).

    See Also
    --------
    full_domain, get_domain, intersection

    Alternatives
    ------------
    change_domain, reduce_domain

    Predecessors
    ------------
    threshold, regiongrowing, gen_circle, draw_region

    Successors
    ----------
    threshold, regiongrowing, get_domain
    """
    with HalconOperator(1144) as proc:
        proc.set_input_object(1, regions)
        proc.set_input_object(2, image)
        proc.execute()
        gray_regions = HObject(proc.get_output_object_key(1))
        return gray_regions  # type: ignore


def add_class_train_data_gmm(
    gmmhandle: HHandle,
    class_train_data_handle: HHandle
) -> None:
    """
    Add training data to a Gaussian Mixture Model (GMM).

    Parameters
    ----------

    gmmhandle : HHandle
                Handle of a GMM which receives the training data.

    class_train_data_handle : HHandle
                              Handle of training data for a classifier.

    See Also
    --------
    create_class_gmm

    Alternatives
    ------------
    add_sample_class_gmm

    Predecessors
    ------------
    create_class_gmm, create_class_train_data

    Successors
    ----------
    get_sample_class_gmm
    """
    with HalconOperator(1786) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, class_train_data_handle)
        proc.execute()


def add_class_train_data_knn(
    knnhandle: HHandle,
    class_train_data_handle: HHandle
) -> None:
    """
    Add training data to a k-nearest neighbors (k-NN) classifier.

    Parameters
    ----------

    knnhandle : HHandle
                Handle of a k-NN which receives the training data.

    class_train_data_handle : HHandle
                              Training data for a classifier.

    See Also
    --------
    create_class_knn

    Alternatives
    ------------
    add_sample_class_knn

    Predecessors
    ------------
    create_class_knn, create_class_train_data

    Successors
    ----------
    get_sample_class_knn
    """
    with HalconOperator(1790) as proc:
        proc.set_input_tuple(0, knnhandle)
        proc.set_input_tuple(1, class_train_data_handle)
        proc.execute()


def add_class_train_data_mlp(
    mlphandle: HHandle,
    class_train_data_handle: HHandle
) -> None:
    """
    Add training data to a multilayer perceptron (MLP).

    Parameters
    ----------

    mlphandle : HHandle
                MLP handle which receives the training data.

    class_train_data_handle : HHandle
                              Training data for a classifier.

    See Also
    --------
    create_class_mlp

    Alternatives
    ------------
    add_sample_class_mlp

    Predecessors
    ------------
    create_class_mlp, create_class_train_data

    Successors
    ----------
    get_sample_class_mlp
    """
    with HalconOperator(1788) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, class_train_data_handle)
        proc.execute()


def add_class_train_data_svm(
    svmhandle: HHandle,
    class_train_data_handle: HHandle
) -> None:
    """
    Add training data to a support vector machine (SVM).

    Parameters
    ----------

    svmhandle : HHandle
                Handle of a SVM which receives the training data.

    class_train_data_handle : HHandle
                              Training data for a classifier.

    See Also
    --------
    create_class_svm

    Alternatives
    ------------
    add_sample_class_svm

    Predecessors
    ------------
    create_class_svm, create_class_train_data

    Successors
    ----------
    get_sample_class_svm
    """
    with HalconOperator(1792) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.set_input_tuple(1, class_train_data_handle)
        proc.execute()


def add_deformable_surface_model_reference_point(
    deformable_surface_model: HHandle,
    reference_point_x: MaybeSequence[Union[float, int]],
    reference_point_y: MaybeSequence[Union[float, int]],
    reference_point_z: MaybeSequence[Union[float, int]]
) -> Sequence[int]:
    """
    Add a reference point to a deformable surface model.

    Parameters
    ----------

    deformable_surface_model : HHandle
                               Handle of the deformable surface model.

    reference_point_x : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    reference_point_y : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    reference_point_z : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    Returns
    -------

    reference_point_index : Sequence[int]
                            Index of the new reference point.

    See Also
    --------
    create_deformable_surface_model, find_deformable_surface_model,
    refine_deformable_surface_model

    Predecessors
    ------------
    create_deformable_surface_model, read_deformable_surface_model

    Successors
    ----------
    find_deformable_surface_model, refine_deformable_surface_model,
    write_deformable_surface_model
    """
    with HalconOperator(1029) as proc:
        proc.set_input_tuple(0, deformable_surface_model)
        proc.set_input_tuple(1, reference_point_x)
        proc.set_input_tuple(2, reference_point_y)
        proc.set_input_tuple(3, reference_point_z)
        proc.init_oct(0)
        proc.execute()
        reference_point_index = proc.get_output_tuple_m(0)
        return reference_point_index  # type: ignore


def add_deformable_surface_model_reference_point_s(
    deformable_surface_model: HHandle,
    reference_point_x: MaybeSequence[Union[float, int]],
    reference_point_y: MaybeSequence[Union[float, int]],
    reference_point_z: MaybeSequence[Union[float, int]]
) -> int:
    """
    Add a reference point to a deformable surface model.

    Parameters
    ----------

    deformable_surface_model : HHandle
                               Handle of the deformable surface model.

    reference_point_x : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    reference_point_y : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    reference_point_z : MaybeSequence[Union[float, int]]
                        x-coordinates of a reference point.

    Returns
    -------

    reference_point_index : int
                            Index of the new reference point.

    See Also
    --------
    create_deformable_surface_model, find_deformable_surface_model,
    refine_deformable_surface_model

    Predecessors
    ------------
    create_deformable_surface_model, read_deformable_surface_model

    Successors
    ----------
    find_deformable_surface_model, refine_deformable_surface_model,
    write_deformable_surface_model
    """
    with HalconOperator(1029) as proc:
        proc.set_input_tuple(0, deformable_surface_model)
        proc.set_input_tuple(1, reference_point_x)
        proc.set_input_tuple(2, reference_point_y)
        proc.set_input_tuple(3, reference_point_z)
        proc.init_oct(0)
        proc.execute()
        reference_point_index = proc.get_output_tuple_s(0)
        return reference_point_index  # type: ignore


def add_deformable_surface_model_sample(
    deformable_surface_model: HHandle,
    object_model_3d: MaybeSequence[HHandle]
) -> None:
    """
    Add a sample deformation to a deformable surface model

    Parameters
    ----------

    deformable_surface_model : HHandle
                               Handle of the deformable surface model.

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the deformed 3D object model.

    See Also
    --------
    find_deformable_surface_model, refine_deformable_surface_model,
    read_deformable_surface_model, create_deformable_surface_model,
    write_deformable_surface_model, clear_deformable_surface_model

    Alternatives
    ------------
    read_deformable_surface_model

    Predecessors
    ------------
    create_deformable_surface_model, find_deformable_surface_model,
    refine_deformable_surface_model

    Successors
    ----------
    find_deformable_surface_model, refine_deformable_surface_model,
    get_deformable_surface_model_param, write_deformable_surface_model,
    clear_deformable_surface_model
    """
    with HalconOperator(1030) as proc:
        proc.set_input_tuple(0, deformable_surface_model)
        proc.set_input_tuple(1, object_model_3d)
        proc.execute()


def add_dl_pruning_batch(
    dlmodel_handle_to_prune: HHandle,
    dlpruning_handle: HHandle,
    dlsample_batch: Sequence[HHandle]
) -> None:
    """
    Calculate scores to prune a deep learning model.

    Parameters
    ----------

    dlmodel_handle_to_prune : HHandle
                              Handle of a deep learning model to prune.

    dlpruning_handle : HHandle
                       Pruning data handle.

    dlsample_batch : Sequence[HHandle]
                     Tuple of dictionaries with input images.

    Predecessors
    ------------
    read_dl_model, create_dl_pruning, set_dl_pruning_param

    Successors
    ----------
    get_dl_pruning_param, gen_dl_pruned_model
    """
    with HalconOperator(2205) as proc:
        proc.set_input_tuple(0, dlmodel_handle_to_prune)
        proc.set_input_tuple(1, dlpruning_handle)
        proc.set_input_tuple(2, dlsample_batch)
        proc.execute()


def add_image(
    image_1: HObject,
    image_2: HObject,
    mult: Union[int, float],
    add: Union[int, float]
) -> HObject:
    """
    Add two images.

    Parameters
    ----------

    image_1 : HObject
              Image(s) 1.

    image_2 : HObject
              Image(s) 2.

    mult : Union[int, float]
           Factor for gray value adaption.
           Value Suggestion: 0.5

    add : Union[int, float]
          Value for gray value range adaption.
          Value Suggestion: 0

    Returns
    -------

    image_result : HObject
                   Result image(s) by the addition.

    See Also
    --------
    sub_image, mult_image

    Alternatives
    ------------
    sub_image, mult_image

    Notes
    -----
    Note that the acceleration gained by SIMD technology is highest on
    large, compact input regions. However, in rare cases, the execution of
    add_image might take significantly longer with SIMD technology than
    without, depending on the input region and the capabilities of the
    hardware. In these cases, the use of SIMD technology can be avoided by
    set_system(::'mmx_enable','false':).
    """
    with HalconOperator(1610) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_tuple(0, mult)
        proc.set_input_tuple(1, add)
        proc.execute()
        image_result = HObject(proc.get_output_object_key(1))
        return image_result  # type: ignore


def add_matrix(matrix_aid: HHandle, matrix_bid: HHandle) -> HHandle:
    """
    Add two matrices.

    Parameters
    ----------

    matrix_aid : HHandle
                 Matrix handle of the input matrix A.

    matrix_bid : HHandle
                 Matrix handle of the input matrix B.

    Returns
    -------

    matrix_sum_id : HHandle
                    Matrix handle with the sum of the input matrices.

    See Also
    --------
    sub_matrix, sub_matrix_mod

    Alternatives
    ------------
    add_matrix_mod

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(881) as proc:
        proc.set_input_tuple(0, matrix_aid)
        proc.set_input_tuple(1, matrix_bid)
        proc.init_oct(0)
        proc.execute()
        matrix_sum_id = proc.get_output_tuple_s(0)
        return matrix_sum_id  # type: ignore


def add_matrix_mod(matrix_aid: HHandle, matrix_bid: HHandle) -> None:
    """
    Add two matrices.

    Parameters
    ----------

    matrix_aid : HHandle
                 Matrix handle of the input matrix A.

    matrix_bid : HHandle
                 Matrix handle of the input matrix B.

    See Also
    --------
    sub_matrix, sub_matrix_mod

    Alternatives
    ------------
    add_matrix

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(880) as proc:
        proc.set_input_tuple(0, matrix_aid)
        proc.set_input_tuple(1, matrix_bid)
        proc.execute()


def add_metrology_object_circle_measure(
    metrology_handle: HHandle,
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    radius: MaybeSequence[Union[int, float]],
    measure_length_1: Union[int, float],
    measure_length_2: Union[int, float],
    measure_sigma: Union[int, float],
    measure_threshold: Union[int, float],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> int:
    """
    Add a circle or a circular arc to a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    row : MaybeSequence[Union[int, float]]
          Row coordinate (or Y) of the center of the circle or circular
          arc.

    column : MaybeSequence[Union[int, float]]
             Column (or X) coordinate of the center of the circle or
             circular arc.

    radius : MaybeSequence[Union[int, float]]
             Radius of the circle or circular arc.

    measure_length_1 : Union[int, float]
                       Half length of the measure regions perpendicular to
                       the boundary.
                       Value Suggestion: 20.0
                       Assertion: MeasureLength1 < Radius

    measure_length_2 : Union[int, float]
                       Half length of the measure regions tangential to
                       the boundary.
                       Value Suggestion: 5.0

    measure_sigma : Union[int, float]
                    Sigma of the Gaussian function for the smoothing.
                    Value Suggestion: 1.0
                    Assertion: 0.4 <= MeasureSigma && MeasureSigma <= 100

    measure_threshold : Union[int, float]
                        Minimum edge amplitude.
                        Value Suggestion: 30.0

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    index : int
            Index of the created metrology object.

    See Also
    --------
    get_metrology_object_model_contour, set_metrology_model_param,
    add_metrology_object_ellipse_measure,
    add_metrology_object_line_measure,
    add_metrology_object_rectangle2_measure

    Alternatives
    ------------
    add_metrology_object_generic

    Predecessors
    ------------
    set_metrology_model_image_size

    Successors
    ----------
    align_metrology_model, apply_metrology_model
    """
    with HalconOperator(815) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, radius)
        proc.set_input_tuple(4, measure_length_1)
        proc.set_input_tuple(5, measure_length_2)
        proc.set_input_tuple(6, measure_sigma)
        proc.set_input_tuple(7, measure_threshold)
        proc.set_input_tuple(8, gen_param_name)
        proc.set_input_tuple(9, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        index = proc.get_output_tuple_s(0)
        return index  # type: ignore


def add_metrology_object_ellipse_measure(
    metrology_handle: HHandle,
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    radius_1: MaybeSequence[Union[int, float]],
    radius_2: MaybeSequence[Union[int, float]],
    measure_length_1: Union[int, float],
    measure_length_2: Union[int, float],
    measure_sigma: Union[int, float],
    measure_threshold: Union[int, float],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> int:
    """
    Add an ellipse or an elliptic arc to a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    row : MaybeSequence[Union[int, float]]
          Row (or Y) coordinate of the center of the ellipse.

    column : MaybeSequence[Union[int, float]]
             Column (or X) coordinate of the center of the ellipse.

    phi : MaybeSequence[Union[int, float]]
          Orientation of the main axis [rad].

    radius_1 : MaybeSequence[Union[int, float]]
               Length of the larger half axis.

    radius_2 : MaybeSequence[Union[int, float]]
               Length of the smaller half axis.

    measure_length_1 : Union[int, float]
                       Half length of the measure regions perpendicular to
                       the boundary.
                       Value Suggestion: 20.0
                       Assertion: MeasureLength1 < Radius1 && MeasureLength1 < Radius2

    measure_length_2 : Union[int, float]
                       Half length of the measure regions tangential to
                       the boundary.
                       Value Suggestion: 5.0

    measure_sigma : Union[int, float]
                    Sigma of the Gaussian function for the smoothing.
                    Value Suggestion: 1.0
                    Assertion: 0.4 <= MeasureSigma && MeasureSigma <= 100

    measure_threshold : Union[int, float]
                        Minimum edge amplitude.
                        Value Suggestion: 30.0

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    index : int
            Index of the created metrology object.

    See Also
    --------
    get_metrology_object_model_contour, set_metrology_model_param,
    add_metrology_object_circle_measure,
    add_metrology_object_line_measure,
    add_metrology_object_rectangle2_measure

    Alternatives
    ------------
    add_metrology_object_generic

    Predecessors
    ------------
    set_metrology_model_image_size

    Successors
    ----------
    align_metrology_model, apply_metrology_model
    """
    with HalconOperator(814) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, phi)
        proc.set_input_tuple(4, radius_1)
        proc.set_input_tuple(5, radius_2)
        proc.set_input_tuple(6, measure_length_1)
        proc.set_input_tuple(7, measure_length_2)
        proc.set_input_tuple(8, measure_sigma)
        proc.set_input_tuple(9, measure_threshold)
        proc.set_input_tuple(10, gen_param_name)
        proc.set_input_tuple(11, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        index = proc.get_output_tuple_s(0)
        return index  # type: ignore


def add_metrology_object_generic(
    metrology_handle: HHandle,
    shape: MaybeSequence[str],
    shape_param: Sequence[Union[int, float]],
    measure_length_1: Union[int, float],
    measure_length_2: Union[int, float],
    measure_sigma: Union[int, float],
    measure_threshold: Union[int, float],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> int:
    """
    Add a metrology object to a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    shape : MaybeSequence[str]
            Type of the metrology object to be added.
            Value Suggestion: circle

    shape_param : Sequence[Union[int, float]]
                  Parameters of the metrology object to be added.

    measure_length_1 : Union[int, float]
                       Half length of the measure regions perpendicular to
                       the boundary.
                       Value Suggestion: 20.0

    measure_length_2 : Union[int, float]
                       Half length of the measure regions tangential to
                       the boundary.
                       Value Suggestion: 5.0

    measure_sigma : Union[int, float]
                    Sigma of the Gaussian function for the smoothing.
                    Value Suggestion: 1.0
                    Assertion: 0.4 <= MeasureSigma && MeasureSigma <= 100

    measure_threshold : Union[int, float]
                        Minimum edge amplitude.
                        Value Suggestion: 30.0

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    index : int
            Index of the created metrology object.

    See Also
    --------
    get_metrology_object_model_contour

    Predecessors
    ------------
    set_metrology_model_image_size, set_metrology_model_param

    Successors
    ----------
    align_metrology_model, apply_metrology_model, set_metrology_model_param
    """
    with HalconOperator(791) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, shape)
        proc.set_input_tuple(2, shape_param)
        proc.set_input_tuple(3, measure_length_1)
        proc.set_input_tuple(4, measure_length_2)
        proc.set_input_tuple(5, measure_sigma)
        proc.set_input_tuple(6, measure_threshold)
        proc.set_input_tuple(7, gen_param_name)
        proc.set_input_tuple(8, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        index = proc.get_output_tuple_s(0)
        return index  # type: ignore


def add_metrology_object_line_measure(
    metrology_handle: HHandle,
    row_begin: MaybeSequence[Union[int, float]],
    column_begin: MaybeSequence[Union[int, float]],
    row_end: MaybeSequence[Union[int, float]],
    column_end: MaybeSequence[Union[int, float]],
    measure_length_1: Union[int, float],
    measure_length_2: Union[int, float],
    measure_sigma: Union[int, float],
    measure_threshold: Union[int, float],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> int:
    """
    Add a line to a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    row_begin : MaybeSequence[Union[int, float]]
                Row (or Y) coordinate of the start of the line.

    column_begin : MaybeSequence[Union[int, float]]
                   Column (or X) coordinate of the start of the line.

    row_end : MaybeSequence[Union[int, float]]
              Row (or Y) coordinate of the end of the line.

    column_end : MaybeSequence[Union[int, float]]
                 Column (or X) coordinate of the end of the line.

    measure_length_1 : Union[int, float]
                       Half length of the measure regions perpendicular to
                       the boundary.
                       Value Suggestion: 20.0

    measure_length_2 : Union[int, float]
                       Half length of the measure regions tangential to
                       the boundary.
                       Value Suggestion: 5.0

    measure_sigma : Union[int, float]
                    Sigma of the Gaussian function for the smoothing.
                    Value Suggestion: 1.0
                    Assertion: 0.4 <= MeasureSigma && MeasureSigma <= 100

    measure_threshold : Union[int, float]
                        Minimum edge amplitude.
                        Value Suggestion: 30.0

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    index : int
            Index of the created metrology object.

    See Also
    --------
    get_metrology_object_model_contour, set_metrology_model_param,
    add_metrology_object_circle_measure,
    add_metrology_object_ellipse_measure,
    add_metrology_object_rectangle2_measure

    Alternatives
    ------------
    add_metrology_object_generic

    Predecessors
    ------------
    set_metrology_model_image_size

    Successors
    ----------
    align_metrology_model, apply_metrology_model
    """
    with HalconOperator(813) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, row_begin)
        proc.set_input_tuple(2, column_begin)
        proc.set_input_tuple(3, row_end)
        proc.set_input_tuple(4, column_end)
        proc.set_input_tuple(5, measure_length_1)
        proc.set_input_tuple(6, measure_length_2)
        proc.set_input_tuple(7, measure_sigma)
        proc.set_input_tuple(8, measure_threshold)
        proc.set_input_tuple(9, gen_param_name)
        proc.set_input_tuple(10, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        index = proc.get_output_tuple_s(0)
        return index  # type: ignore


def add_metrology_object_rectangle2_measure(
    metrology_handle: HHandle,
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    length_1: MaybeSequence[Union[int, float]],
    length_2: MaybeSequence[Union[int, float]],
    measure_length_1: Union[int, float],
    measure_length_2: Union[int, float],
    measure_sigma: Union[int, float],
    measure_threshold: Union[int, float],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> int:
    """
    Add a rectangle to a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    row : MaybeSequence[Union[int, float]]
          Row (or Y) coordinate of the center of the rectangle.

    column : MaybeSequence[Union[int, float]]
             Column (or X) coordinate of the center of the rectangle.

    phi : MaybeSequence[Union[int, float]]
          Orientation of the main axis [rad].

    length_1 : MaybeSequence[Union[int, float]]
               Length of the larger half edge of the rectangle.

    length_2 : MaybeSequence[Union[int, float]]
               Length of the smaller half edge of the rectangle.

    measure_length_1 : Union[int, float]
                       Half length of the measure regions perpendicular to
                       the boundary.
                       Value Suggestion: 20.0
                       Assertion: MeasureLength1 < Length1 && MeasureLength1 < Length2

    measure_length_2 : Union[int, float]
                       Half length of the measure regions tangential to
                       the boundary.
                       Value Suggestion: 5.0

    measure_sigma : Union[int, float]
                    Sigma of the Gaussian function for the smoothing.
                    Value Suggestion: 1.0
                    Assertion: 0.4 <= MeasureSigma && MeasureSigma <= 100

    measure_threshold : Union[int, float]
                        Minimum edge amplitude.
                        Value Suggestion: 30.0

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    index : int
            Index of the created metrology object.

    See Also
    --------
    get_metrology_object_model_contour, set_metrology_model_param,
    add_metrology_object_circle_measure,
    add_metrology_object_ellipse_measure, add_metrology_object_line_measure

    Alternatives
    ------------
    add_metrology_object_generic

    Predecessors
    ------------
    set_metrology_model_image_size

    Successors
    ----------
    align_metrology_model, apply_metrology_model
    """
    with HalconOperator(812) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, phi)
        proc.set_input_tuple(4, length_1)
        proc.set_input_tuple(5, length_2)
        proc.set_input_tuple(6, measure_length_1)
        proc.set_input_tuple(7, measure_length_2)
        proc.set_input_tuple(8, measure_sigma)
        proc.set_input_tuple(9, measure_threshold)
        proc.set_input_tuple(10, gen_param_name)
        proc.set_input_tuple(11, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        index = proc.get_output_tuple_s(0)
        return index  # type: ignore


def add_noise_distribution(
    image: HObject,
    distribution: Sequence[float]
) -> HObject:
    """
    Add noise to an image.

    Parameters
    ----------

    image : HObject
            Input image.

    distribution : Sequence[float]
                   Noise distribution.

    Returns
    -------

    image_noise : HObject
                  Noisy image.

    See Also
    --------
    sp_distribution, gauss_distribution, noise_distribution_mean,
    add_noise_white

    Alternatives
    ------------
    add_noise_white

    Predecessors
    ------------
    gauss_distribution, sp_distribution, noise_distribution_mean
    """
    with HalconOperator(1442) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, distribution)
        proc.execute()
        image_noise = HObject(proc.get_output_object_key(1))
        return image_noise  # type: ignore


def add_noise_white(image: HObject, amp: float) -> HObject:
    """
    Add noise to an image.

    Parameters
    ----------

    image : HObject
            Input image.

    amp : float
          Maximum noise amplitude.
          Value Suggestion: 60.0
          Assertion: Amp > 0

    Returns
    -------

    image_noise : HObject
                  Noisy image.

    See Also
    --------
    add_noise_distribution, noise_distribution_mean, gauss_distribution,
    sp_distribution

    Alternatives
    ------------
    add_noise_distribution
    """
    with HalconOperator(1441) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, amp)
        proc.execute()
        image_noise = HObject(proc.get_output_object_key(1))
        return image_noise  # type: ignore


def add_noise_white_contour_xld(
    contours: HObject,
    num_regr_points: int,
    amp: float
) -> HObject:
    """
    Add noise to XLD contours.

    Parameters
    ----------

    contours : HObject
               Original contours.

    num_regr_points : int
                      Number of points used to calculate the regression
                      line.
                      Value Suggestion: 5
                      Assertion: NumRegrPoints >= 3 && odd(NumRegrPoints)

    amp : float
          Maximum amplitude of the added noise (equally distributed in
          [-Amp,Amp]).
          Value Suggestion: 1.0
          Assertion: Amp > 0

    Returns
    -------

    noisy_contours : HObject
                     Noisy contours.

    See Also
    --------
    smooth_contours_xld, add_noise_white

    Predecessors
    ------------
    gen_contours_skeleton_xld, lines_gauss, lines_facet, edges_sub_pix,
    gen_ellipse_contour_xld

    Successors
    ----------
    smooth_contours_xld
    """
    with HalconOperator(36) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_regr_points)
        proc.set_input_tuple(1, amp)
        proc.execute()
        noisy_contours = HObject(proc.get_output_object_key(1))
        return noisy_contours  # type: ignore


def add_sample_class_gmm(
    gmmhandle: HHandle,
    features: Sequence[float],
    class_id: int,
    randomize: float
) -> None:
    """
    Add a training sample to the training data of a Gaussian Mixture Model.

    Parameters
    ----------

    gmmhandle : HHandle
                GMM handle.

    features : Sequence[float]
               Feature vector of the training sample to be stored.

    class_id : int
               Class of the training sample to be stored.

    randomize : float
                Standard deviation of the Gaussian noise added to the
                training data.
                Value Suggestion: 0.0
                Assertion: Randomize >= 0.0

    See Also
    --------
    clear_samples_class_gmm, get_sample_num_class_gmm, get_sample_class_gmm

    Alternatives
    ------------
    read_samples_class_gmm, add_samples_image_class_gmm

    Predecessors
    ------------
    create_class_gmm

    Successors
    ----------
    train_class_gmm, write_samples_class_gmm
    """
    with HalconOperator(1838) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, class_id)
        proc.set_input_tuple(3, randomize)
        proc.execute()


def add_sample_class_knn(
    knnhandle: HHandle,
    features: MaybeSequence[float],
    class_id: MaybeSequence[int]
) -> None:
    """
    Add a sample to a  k-nearest neighbors (k-NN) classifier.

    Parameters
    ----------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    features : MaybeSequence[float]
               List of features to add.

    class_id : MaybeSequence[int]
               Class IDs of the features.

    See Also
    --------
    create_class_knn, read_class_knn

    Predecessors
    ------------
    train_class_knn, read_class_knn
    """
    with HalconOperator(1815) as proc:
        proc.set_input_tuple(0, knnhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, class_id)
        proc.execute()


def add_sample_class_mlp(
    mlphandle: HHandle,
    features: Sequence[float],
    target: MaybeSequence[Union[int, float]]
) -> None:
    """
    Add a training sample to the training data of a multilayer perceptron.

    Parameters
    ----------

    mlphandle : HHandle
                MLP handle.

    features : Sequence[float]
               Feature vector of the training sample to be stored.

    target : MaybeSequence[Union[int, float]]
             Class or target vector of the training sample to be stored.

    See Also
    --------
    clear_samples_class_mlp, get_sample_num_class_mlp, get_sample_class_mlp

    Alternatives
    ------------
    read_samples_class_mlp

    Predecessors
    ------------
    create_class_mlp

    Successors
    ----------
    train_class_mlp, write_samples_class_mlp
    """
    with HalconOperator(1879) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, target)
        proc.execute()


def add_sample_class_svm(
    svmhandle: HHandle,
    features: Sequence[float],
    class_val: Union[int, float]
) -> None:
    """
    Add a training sample to the training data of a support vector machine.

    Parameters
    ----------

    svmhandle : HHandle
                SVM handle.

    features : Sequence[float]
               Feature vector of the training sample to be stored.

    class_val : Union[int, float]
                Class of the training sample to be stored.

    See Also
    --------
    clear_samples_class_svm, get_support_vector_class_svm

    Alternatives
    ------------
    read_samples_class_svm

    Predecessors
    ------------
    create_class_svm

    Successors
    ----------
    train_class_svm, write_samples_class_svm, get_sample_num_class_svm,
    get_sample_class_svm
    """
    with HalconOperator(1859) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, class_val)
        proc.execute()


def add_sample_class_train_data(
    class_train_data_handle: HHandle,
    order: str,
    features: Sequence[float],
    class_id: Sequence[int]
) -> None:
    """
    Add a training sample to training data.

    Parameters
    ----------

    class_train_data_handle : HHandle
                              Handle of the training data.

    order : str
            The order of the feature vector.
            Value Suggestion: row

    features : Sequence[float]
               Feature vector of the training sample.

    class_id : Sequence[int]
               Class of the training sample.

    See Also
    --------
    create_class_train_data

    Predecessors
    ------------
    create_class_train_data

    Successors
    ----------
    add_class_train_data_svm, add_class_train_data_knn,
    add_class_train_data_gmm, add_class_train_data_mlp
    """
    with HalconOperator(1797) as proc:
        proc.set_input_tuple(0, class_train_data_handle)
        proc.set_input_tuple(1, order)
        proc.set_input_tuple(2, features)
        proc.set_input_tuple(3, class_id)
        proc.execute()


def add_sample_identifier_preparation_data(
    sample_image: HObject,
    sample_identifier: HHandle,
    object_idx: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> int:
    """
    Add preparation data to an existing sample identifier.

    Parameters
    ----------

    sample_image : HObject
                   Image that shows an object.

    sample_identifier : HHandle
                        Handle of the sample identifier.

    object_idx : Union[int, str]
                 Index of the object visible in the SampleImage.
                 Value Suggestion: unknown

    gen_param_name : Sequence[str]
                     Generic parameter name.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Generic parameter value.
                      Value Suggestion: []

    Returns
    -------

    object_sample_idx : int
                        Index of the object sample.

    See Also
    --------
    add_sample_identifier_training_data, train_sample_identifier,
    apply_sample_identifier, set_sample_identifier_param,
    get_sample_identifier_param, get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, deserialize_sample_identifier,
    clear_sample_identifier, set_sample_identifier_object_info

    Alternatives
    ------------
    read_sample_identifier

    Predecessors
    ------------
    create_sample_identifier, read_sample_identifier

    Successors
    ----------
    prepare_sample_identifier
    """
    with HalconOperator(914) as proc:
        proc.set_input_object(1, sample_image)
        proc.set_input_tuple(0, sample_identifier)
        proc.set_input_tuple(1, object_idx)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        object_sample_idx = proc.get_output_tuple_s(0)
        return object_sample_idx  # type: ignore


def add_sample_identifier_training_data(
    sample_image: HObject,
    sample_identifier: HHandle,
    object_idx: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> int:
    """
    Add training data to an existing sample identifier.

    Parameters
    ----------

    sample_image : HObject
                   Image that shows an object.

    sample_identifier : HHandle
                        Handle of the sample identifier.

    object_idx : Union[int, str]
                 Index of the object visible in the SampleImage.

    gen_param_name : Sequence[str]
                     Generic parameter name.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Generic parameter value.
                      Value Suggestion: []

    Returns
    -------

    object_sample_idx : int
                        Index of the object sample.

    See Also
    --------
    create_sample_identifier, add_sample_identifier_preparation_data,
    apply_sample_identifier, set_sample_identifier_param,
    get_sample_identifier_param, get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, deserialize_sample_identifier,
    clear_sample_identifier, set_sample_identifier_object_info

    Alternatives
    ------------
    read_sample_identifier

    Predecessors
    ------------
    prepare_sample_identifier, read_sample_identifier

    Successors
    ----------
    train_sample_identifier
    """
    with HalconOperator(912) as proc:
        proc.set_input_object(1, sample_image)
        proc.set_input_tuple(0, sample_identifier)
        proc.set_input_tuple(1, object_idx)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        object_sample_idx = proc.get_output_tuple_s(0)
        return object_sample_idx  # type: ignore


def add_samples_image_class_gmm(
    image: HObject,
    class_regions: HObject,
    gmmhandle: HHandle,
    randomize: float
) -> None:
    """
    Add training samples from an image to the training data of a Gaussian
    Mixture Model.

    Parameters
    ----------

    image : HObject
            Training image.

    class_regions : HObject
                    Regions of the classes to be trained.

    gmmhandle : HHandle
                GMM handle.

    randomize : float
                Standard deviation of the Gaussian noise added to the
                training data.
                Value Suggestion: 0.0
                Assertion: Randomize >= 0.0

    See Also
    --------
    classify_image_class_gmm, add_sample_class_gmm,
    clear_samples_class_gmm, get_sample_num_class_gmm, get_sample_class_gmm

    Alternatives
    ------------
    read_samples_class_gmm

    Predecessors
    ------------
    create_class_gmm

    Successors
    ----------
    train_class_gmm, write_samples_class_gmm
    """
    with HalconOperator(432) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, class_regions)
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, randomize)
        proc.execute()


def add_samples_image_class_knn(
    image: HObject,
    class_regions: HObject,
    knnhandle: HHandle
) -> None:
    """
    Add training samples from an image to the training data of a
    k-Nearest-Neighbor classifier.

    Parameters
    ----------

    image : HObject
            Training image.

    class_regions : HObject
                    Regions of the classes to be trained.

    knnhandle : HHandle
                Handle of the k-NN classifier.

    See Also
    --------
    classify_image_class_knn, add_sample_class_knn,
    add_samples_image_class_svm

    Alternatives
    ------------
    add_sample_class_knn

    Predecessors
    ------------
    create_class_knn

    Successors
    ----------
    train_class_knn
    """
    with HalconOperator(430) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, class_regions)
        proc.set_input_tuple(0, knnhandle)
        proc.execute()


def add_samples_image_class_mlp(
    image: HObject,
    class_regions: HObject,
    mlphandle: HHandle
) -> None:
    """
    Add training samples from an image to the training data of a
    multilayer perceptron.

    Parameters
    ----------

    image : HObject
            Training image.

    class_regions : HObject
                    Regions of the classes to be trained.

    mlphandle : HHandle
                MLP handle.

    See Also
    --------
    classify_image_class_mlp, add_sample_class_mlp,
    clear_samples_class_mlp, get_sample_num_class_mlp,
    get_sample_class_mlp, add_samples_image_class_svm

    Alternatives
    ------------
    read_samples_class_mlp

    Predecessors
    ------------
    create_class_mlp

    Successors
    ----------
    train_class_mlp, write_samples_class_mlp
    """
    with HalconOperator(436) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, class_regions)
        proc.set_input_tuple(0, mlphandle)
        proc.execute()


def add_samples_image_class_svm(
    image: HObject,
    class_regions: HObject,
    svmhandle: HHandle
) -> None:
    """
    Add training samples from an image to the training data of a support
    vector machine.

    Parameters
    ----------

    image : HObject
            Training image.

    class_regions : HObject
                    Regions of the classes to be trained.

    svmhandle : HHandle
                SVM handle.

    See Also
    --------
    classify_image_class_svm, add_sample_class_svm,
    clear_samples_class_svm, get_sample_num_class_svm,
    get_sample_class_svm, add_samples_image_class_mlp

    Alternatives
    ------------
    read_samples_class_svm

    Predecessors
    ------------
    create_class_svm

    Successors
    ----------
    train_class_svm, write_samples_class_svm
    """
    with HalconOperator(434) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, class_regions)
        proc.set_input_tuple(0, svmhandle)
        proc.execute()


def add_scene_3d_camera(
    scene_3d: HHandle,
    camera_param: Sequence[Union[float, int, str]]
) -> int:
    """
    Add a camera to a 3D scene.

    Parameters
    ----------

    scene_3d : HHandle
               Handle of the 3D scene.

    camera_param : Sequence[Union[float, int, str]]
                   Parameters of the new camera.

    Returns
    -------

    camera_index : int
                   Index of the new camera in the 3D scene.

    Predecessors
    ------------
    create_scene_3d

    Successors
    ----------
    set_scene_3d_camera_pose, display_scene_3d

    Notes
    -----
    Cameras with hypercentric lenses are not supported. For displaying
    large faces (or primitives) with a non-zero distortion in CameraParam,
    note that the distortion is only applied to the points of the model.
    In the projection, these points are subsequently connected by straight
    lines. For a good approximation of the distorted lines, please use a
    triangulation with sufficiently small triangles.
    """
    with HalconOperator(1218) as proc:
        proc.set_input_tuple(0, scene_3d)
        proc.set_input_tuple(1, camera_param)
        proc.init_oct(0)
        proc.execute()
        camera_index = proc.get_output_tuple_s(0)
        return camera_index  # type: ignore


def add_scene_3d_instance(
    scene_3d: HHandle,
    object_model_3d: MaybeSequence[HHandle],
    pose: Sequence[Union[float, int]]
) -> int:
    """
    Add an instance of a 3D object model to a 3D scene.

    Parameters
    ----------

    scene_3d : HHandle
               Handle of the 3D scene.

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    pose : Sequence[Union[float, int]]
           Pose of the 3D object model.

    Returns
    -------

    instance_index : int
                     Index of the new instance in the 3D scene.

    See Also
    --------
    remove_scene_3d_instance

    Predecessors
    ------------
    create_scene_3d

    Successors
    ----------
    set_scene_3d_instance_param, set_scene_3d_instance_pose
    """
    with HalconOperator(1217) as proc:
        proc.set_input_tuple(0, scene_3d)
        proc.set_input_tuple(1, object_model_3d)
        proc.set_input_tuple(2, pose)
        proc.init_oct(0)
        proc.execute()
        instance_index = proc.get_output_tuple_s(0)
        return instance_index  # type: ignore


def add_scene_3d_label(
    scene_3d: HHandle,
    text: MaybeSequence[str],
    reference_point: Sequence[Union[float, int]],
    position: Sequence[Union[float, int, str]],
    relates_to: Sequence[str]
) -> int:
    """
    Add a text label to a 3D scene.

    Parameters
    ----------

    scene_3d : HHandle
               Handle of the 3D scene.

    text : MaybeSequence[str]
           Text of the label.
           Value Suggestion: label

    reference_point : Sequence[Union[float, int]]
                      Point of reference of the label.

    position : Sequence[Union[float, int, str]]
               Position of the label.
               Value Suggestion: 'top'

    relates_to : Sequence[str]
                 Indicates fixed or relative positioning.
                 Value Suggestion: 'point'

    Returns
    -------

    label_index : int
                  Index of the new label in the 3D scene.

    See Also
    --------
    remove_scene_3d_instance

    Predecessors
    ------------
    create_scene_3d

    Successors
    ----------
    set_scene_3d_label_param
    """
    with HalconOperator(2040) as proc:
        proc.set_input_tuple(0, scene_3d)
        proc.set_input_tuple(1, text)
        proc.set_input_tuple(2, reference_point)
        proc.set_input_tuple(3, position)
        proc.set_input_tuple(4, relates_to)
        proc.init_oct(0)
        proc.execute()
        label_index = proc.get_output_tuple_s(0)
        return label_index  # type: ignore


def add_scene_3d_light(
    scene_3d: HHandle,
    light_position: Sequence[Union[int, float]],
    light_kind: str
) -> int:
    """
    Add a light source to a 3D scene.

    Parameters
    ----------

    scene_3d : HHandle
               Handle of the 3D scene.

    light_position : Sequence[Union[int, float]]
                     Position of the new light source.
                     Value Suggestion: [-100.0,-100.0,0.0]

    light_kind : str
                 Type of the new light source.
                 Value Suggestion: 'point_light'

    Returns
    -------

    light_index : int
                  Index of the new light source in the 3D scene.

    See Also
    --------
    remove_scene_3d_light

    Predecessors
    ------------
    create_scene_3d

    Successors
    ----------
    set_scene_3d_light_param
    """
    with HalconOperator(1216) as proc:
        proc.set_input_tuple(0, scene_3d)
        proc.set_input_tuple(1, light_position)
        proc.set_input_tuple(2, light_kind)
        proc.init_oct(0)
        proc.execute()
        light_index = proc.get_output_tuple_s(0)
        return light_index  # type: ignore


def add_texture_inspection_model_image(
    image: HObject,
    texture_inspection_model: HHandle
) -> Sequence[int]:
    """
    Add training images to the texture inspection model.

    Parameters
    ----------

    image : HObject
            Image of flawless texture.

    texture_inspection_model : HHandle
                               Handle of the texture inspection model.

    Returns
    -------

    indices : Sequence[int]
              Indices of the images that have been added to the texture
              inspection model.

    Predecessors
    ------------
    create_texture_inspection_model, set_texture_inspection_model_param,
    get_texture_inspection_model_param

    Successors
    ----------
    train_texture_inspection_model, clear_texture_inspection_model,
    remove_texture_inspection_model_image,
    get_texture_inspection_model_image
    """
    with HalconOperator(2043) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, texture_inspection_model)
        proc.init_oct(0)
        proc.execute()
        indices = proc.get_output_tuple_m(0)
        return indices  # type: ignore


def add_texture_inspection_model_image_s(
    image: HObject,
    texture_inspection_model: HHandle
) -> int:
    """
    Add training images to the texture inspection model.

    Parameters
    ----------

    image : HObject
            Image of flawless texture.

    texture_inspection_model : HHandle
                               Handle of the texture inspection model.

    Returns
    -------

    indices : int
              Indices of the images that have been added to the texture
              inspection model.

    Predecessors
    ------------
    create_texture_inspection_model, set_texture_inspection_model_param,
    get_texture_inspection_model_param

    Successors
    ----------
    train_texture_inspection_model, clear_texture_inspection_model,
    remove_texture_inspection_model_image,
    get_texture_inspection_model_image
    """
    with HalconOperator(2043) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, texture_inspection_model)
        proc.init_oct(0)
        proc.execute()
        indices = proc.get_output_tuple_s(0)
        return indices  # type: ignore


def adjust_mosaic_images(
    images: HObject,
    from_val: Sequence[int],
    to: Sequence[int],
    reference_image: int,
    hom_matrices_2d: Sequence[float],
    estimation_method: str,
    estimate_parameters: MaybeSequence[str],
    oecfmodel: str
) -> HObject:
    """
    Apply an automatic color correction to panorama images.

    Parameters
    ----------

    images : HObject
             Input images.

    from_val : Sequence[int]
               List of source images.

    to : Sequence[int]
         List of destination images.

    reference_image : int
                      Reference image.

    hom_matrices_2d : Sequence[float]
                      Projective matrices.

    estimation_method : str
                        Estimation algorithm for the correction.
                        Value Suggestion: standard

    estimate_parameters : MaybeSequence[str]
                          Parameters to be estimated.
                          Value Suggestion: ['mult_gray']

    oecfmodel : str
                Model of OECF to be used.
                Value Suggestion: ['laguerre']

    Returns
    -------

    corrected_images : HObject
                       Output images.

    Predecessors
    ------------
    stationary_camera_self_calibration

    Successors
    ----------
    gen_spherical_mosaic
    """
    with HalconOperator(1615) as proc:
        proc.set_input_object(1, images)
        proc.set_input_tuple(0, from_val)
        proc.set_input_tuple(1, to)
        proc.set_input_tuple(2, reference_image)
        proc.set_input_tuple(3, hom_matrices_2d)
        proc.set_input_tuple(4, estimation_method)
        proc.set_input_tuple(5, estimate_parameters)
        proc.set_input_tuple(6, oecfmodel)
        proc.execute()
        corrected_images = HObject(proc.get_output_object_key(1))
        return corrected_images  # type: ignore


def affine_trans_contour_xld(
    contours: HObject,
    hom_mat_2d: Sequence[float]
) -> HObject:
    """
    Apply an arbitrary affine 2D transformation to XLD contours.

    Parameters
    ----------

    contours : HObject
               Input XLD contours.

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    Returns
    -------

    contours_affine_trans : HObject
                            Transformed XLD contours.

    See Also
    --------
    affine_trans_image, affine_trans_region

    Predecessors
    ------------
    hom_mat2d_identity, hom_mat2d_translate, hom_mat2d_rotate,
    hom_mat2d_scale, hom_mat2d_reflect

    Notes
    -----
    affine_trans_contour_xld does not use the HALCON standard coordinate
    system (with the origin in the center of the upper left pixel), but
    instead uses the same coordinate system as in affine_trans_pixel,
    i.e., the origin lies in the upper left corner of the upper left
    pixel.  Therefore, applying affine_trans_contour_xld corresponds to a
    chain of transformations (see affine_trans_pixel), which is applied to
    each point of the contour (input and output pixels as homogeneous
    vectors). As an effect, you might get unexpected results when creating
    affine transformations based on coordinates that are derived from the
    contour, e.g., by operators like area_center_xld. For example, if you
    use this operator to calculate the center of gravity of a rotationally
    symmetric XLD contour and then rotate the contour around this point
    using hom_mat2d_rotate, the resulting contour will not lie on the
    original one. In such a case, you can compensate this effect by
    applying the following translations to HomMat2D before using it in
    affine_trans_contour_xld:
    Table[layout]{l90} hom_mat2d_translate(HomMat2D, 0.5, 0.5,
    HomMat2DTmp)
    hom_mat2d_translate_local(HomMat2DTmp, -0.5, -0.5, HomMat2DAdapted)
    affine_trans_contour_xld(Contours, ContoursAffineTrans,
    HomMat2DAdapted) Table
    For an explanation of the different 2D coordinate systems used in -
    see the introduction of chapter Transformations, 2DTransformations.
    """
    with HalconOperator(49) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, hom_mat_2d)
        proc.execute()
        contours_affine_trans = HObject(proc.get_output_object_key(1))
        return contours_affine_trans  # type: ignore


def affine_trans_image(
    image: HObject,
    hom_mat_2d: Sequence[float],
    interpolation: str,
    adapt_image_size: str
) -> HObject:
    """
    Apply an arbitrary affine 2D transformation to images.

    Parameters
    ----------

    image : HObject
            Input image.

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    interpolation : str
                    Type of interpolation.
                    Value Suggestion: constant

    adapt_image_size : str
                       Adaption of size of result image.
                       Value Suggestion: false

    Returns
    -------

    image_affine_trans : HObject
                         Transformed image.

    See Also
    --------
    set_part_style

    Alternatives
    ------------
    affine_trans_image_size, zoom_image_size, zoom_image_factor,
    mirror_image, rotate_image, affine_trans_region

    Predecessors
    ------------
    hom_mat2d_identity, hom_mat2d_translate, hom_mat2d_rotate,
    hom_mat2d_scale, hom_mat2d_reflect

    Notes
    -----
    The region of the input image is ignored.
    affine_trans_image does not use the HALCON standard coordinate system
    (with the origin in the center of the first pixel), but instead uses
    the same coordinate system as in affine_trans_pixel, i.e., the origin
    lies in the upper left corner of the first pixel. Therefore, applying
    affine_trans_image corresponds to a chain of transformations (see
    affine_trans_pixel), which is applied to each point of the image
    (input and output pixels as homogeneous vectors). As an effect, you
    might get unexpected results when creating affine transformations
    based on coordinates that are derived from the image, e.g., by
    operators like area_center_gray. For example, if you use this operator
    to calculate the center of gravity of a rotationally symmetric image
    and then rotate the image around this point using hom_mat2d_rotate,
    the resulting image will not lie on the original one. In such a case,
    you can compensate this effect by applying the following translations
    to HomMat2D before using it in affine_trans_image:
    Table[layout]{l90} hom_mat2d_translate(HomMat2D, 0.5, 0.5,
    HomMat2DTmp)
    hom_mat2d_translate_local(HomMat2DTmp, -0.5, -0.5, HomMat2DAdapted)
    affine_trans_image(Image, ImageAffineTrans, HomMat2DAdapted,
    'constant', 'false') Table
    For an explanation of the different 2D coordinate systems used in -
    see the introduction of chapter Transformations, 2DTransformations.
    """
    with HalconOperator(1623) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, interpolation)
        proc.set_input_tuple(2, adapt_image_size)
        proc.execute()
        image_affine_trans = HObject(proc.get_output_object_key(1))
        return image_affine_trans  # type: ignore


def affine_trans_image_size(
    image: HObject,
    hom_mat_2d: Sequence[float],
    interpolation: str,
    width: int,
    height: int
) -> HObject:
    """
    Apply an arbitrary affine 2D transformation to an image and specify
    the output image size.

    Parameters
    ----------

    image : HObject
            Input image.

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    interpolation : str
                    Type of interpolation.
                    Value Suggestion: constant

    width : int
            Width of the output image.
            Value Suggestion: 640

    height : int
             Height of the output image.
             Value Suggestion: 480

    Returns
    -------

    image_affine_trans : HObject
                         Transformed image.

    See Also
    --------
    set_part_style

    Alternatives
    ------------
    affine_trans_image, zoom_image_size, zoom_image_factor, mirror_image,
    rotate_image, affine_trans_region

    Predecessors
    ------------
    hom_mat2d_identity, hom_mat2d_translate, hom_mat2d_rotate,
    hom_mat2d_scale, hom_mat2d_reflect

    Notes
    -----
    The region of the input image is ignored.
    affine_trans_image_size does not use the HALCON standard coordinate
    system (with the origin in the center of the upper left pixel), but
    instead uses the same coordinate system as in affine_trans_pixel,
    i.e., the origin lies in the upper left corner of the upper left
    pixel.  Therefore, applying affine_trans_image_size corresponds to a
    chain of transformations (see affine_trans_pixel), which is applied to
    each point of the image (input and output pixels as homogeneous
    vectors).  As an effect, you might get unexpected results when
    creating affine transformations based on coordinates that are derived
    from the image, e.g., by operators like area_center_gray. For example,
    if you use this operator to calculate the center of gravity of a
    rotationally symmetric image and then rotate the image around this
    point using hom_mat2d_rotate, the resulting image will not lie on the
    original one. In such a case, you can compensate this effect by
    applying the following translations to HomMat2D before using it in
    affine_trans_image_size:
    Table[layout]{l90} hom_mat2d_translate(HomMat2D, 0.5, 0.5,
    HomMat2DTmp)
    hom_mat2d_translate_local(HomMat2DTmp, -0.5, -0.5, HomMat2DAdapted)
    affine_trans_image_size(Image, ImageAffineTrans, HomMat2DAdapted,
    'constant', Width, Height) Table
    For an explanation of the different 2D coordinate systems used in -
    see the introduction of chapter Transformations, 2DTransformations.
    """
    with HalconOperator(1622) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, interpolation)
        proc.set_input_tuple(2, width)
        proc.set_input_tuple(3, height)
        proc.execute()
        image_affine_trans = HObject(proc.get_output_object_key(1))
        return image_affine_trans  # type: ignore


def affine_trans_object_model_3d(
    object_model_3d: MaybeSequence[HHandle],
    hom_mat_3d: Sequence[float]
) -> Sequence[HHandle]:
    """
    Apply an arbitrary affine 3D transformation to 3D object models.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handles of the 3D object models.

    hom_mat_3d : Sequence[float]
                 Transformation matrices.

    Returns
    -------

    object_model_3daffine_trans : Sequence[HHandle]
                                  Handles of the transformed 3D object
                                  models.

    See Also
    --------
    affine_trans_point_3d, rigid_trans_object_model_3d,
    projective_trans_object_model_3d

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d

    Successors
    ----------
    project_object_model_3d, object_model_3d_to_xyz

    Notes
    -----
    affine_trans_object_model_3d transforms the attributes of type 3D
    points, 3D point normals, and the prepared shape model for shape-based
    3D matching. All other attributes are copied without modification. To
    transform 3D primitives, the operator rigid_trans_object_model_3d must
    be used.
    """
    with HalconOperator(1098) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, hom_mat_3d)
        proc.init_oct(0)
        proc.execute()
        object_model_3daffine_trans = proc.get_output_tuple_m(0)
        return object_model_3daffine_trans  # type: ignore


def affine_trans_object_model_3d_s(
    object_model_3d: MaybeSequence[HHandle],
    hom_mat_3d: Sequence[float]
) -> HHandle:
    """
    Apply an arbitrary affine 3D transformation to 3D object models.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handles of the 3D object models.

    hom_mat_3d : Sequence[float]
                 Transformation matrices.

    Returns
    -------

    object_model_3daffine_trans : HHandle
                                  Handles of the transformed 3D object
                                  models.

    See Also
    --------
    affine_trans_point_3d, rigid_trans_object_model_3d,
    projective_trans_object_model_3d

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d

    Successors
    ----------
    project_object_model_3d, object_model_3d_to_xyz

    Notes
    -----
    affine_trans_object_model_3d transforms the attributes of type 3D
    points, 3D point normals, and the prepared shape model for shape-based
    3D matching. All other attributes are copied without modification. To
    transform 3D primitives, the operator rigid_trans_object_model_3d must
    be used.
    """
    with HalconOperator(1098) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, hom_mat_3d)
        proc.init_oct(0)
        proc.execute()
        object_model_3daffine_trans = proc.get_output_tuple_s(0)
        return object_model_3daffine_trans  # type: ignore


def affine_trans_pixel(
    hom_mat_2d: Sequence[float],
    row: MaybeSequence[Union[float, int]],
    col: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Apply an arbitrary affine 2D transformation to pixel coordinates.

    Parameters
    ----------

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    row : MaybeSequence[Union[float, int]]
          Input pixel(s) (row coordinate).
          Value Suggestion: 64

    col : MaybeSequence[Union[float, int]]
          Input pixel(s) (column coordinate).
          Value Suggestion: 64

    Returns
    -------

    row_trans : Sequence[float]
                Output pixel(s) (row coordinate).

    col_trans : Sequence[float]
                Output pixel(s) (column coordinate).

    Alternatives
    ------------
    affine_trans_point_2d

    Predecessors
    ------------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local
    """
    with HalconOperator(272) as proc:
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, col)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_trans
            proc.get_output_tuple_m(1)   # col_trans
        )  # type: ignore


def affine_trans_pixel_s(
    hom_mat_2d: Sequence[float],
    row: MaybeSequence[Union[float, int]],
    col: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Apply an arbitrary affine 2D transformation to pixel coordinates.

    Parameters
    ----------

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    row : MaybeSequence[Union[float, int]]
          Input pixel(s) (row coordinate).
          Value Suggestion: 64

    col : MaybeSequence[Union[float, int]]
          Input pixel(s) (column coordinate).
          Value Suggestion: 64

    Returns
    -------

    row_trans : float
                Output pixel(s) (row coordinate).

    col_trans : float
                Output pixel(s) (column coordinate).

    Alternatives
    ------------
    affine_trans_point_2d

    Predecessors
    ------------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local
    """
    with HalconOperator(272) as proc:
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, col)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row_trans
            proc.get_output_tuple_s(1)   # col_trans
        )  # type: ignore


def affine_trans_point_2d(
    hom_mat_2d: Sequence[float],
    px: MaybeSequence[Union[float, int]],
    py: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Apply an arbitrary affine 2D transformation to points.

    Parameters
    ----------

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    px : MaybeSequence[Union[float, int]]
         Input point(s) (x or row coordinate).
         Value Suggestion: 64

    py : MaybeSequence[Union[float, int]]
         Input point(s) (y or column coordinate).
         Value Suggestion: 64

    Returns
    -------

    qx : Sequence[float]
         Output point(s) (x or row coordinate).

    qy : Sequence[float]
         Output point(s) (y or column coordinate).

    Predecessors
    ------------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local

    Successors
    ----------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local
    """
    with HalconOperator(273) as proc:
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, px)
        proc.set_input_tuple(2, py)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # qx
            proc.get_output_tuple_m(1)   # qy
        )  # type: ignore


def affine_trans_point_2d_s(
    hom_mat_2d: Sequence[float],
    px: MaybeSequence[Union[float, int]],
    py: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Apply an arbitrary affine 2D transformation to points.

    Parameters
    ----------

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    px : MaybeSequence[Union[float, int]]
         Input point(s) (x or row coordinate).
         Value Suggestion: 64

    py : MaybeSequence[Union[float, int]]
         Input point(s) (y or column coordinate).
         Value Suggestion: 64

    Returns
    -------

    qx : float
         Output point(s) (x or row coordinate).

    qy : float
         Output point(s) (y or column coordinate).

    Predecessors
    ------------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local

    Successors
    ----------
    hom_mat2d_translate, hom_mat2d_translate_local, hom_mat2d_scale,
    hom_mat2d_scale_local, hom_mat2d_rotate, hom_mat2d_rotate_local,
    hom_mat2d_slant, hom_mat2d_slant_local, hom_mat2d_reflect,
    hom_mat2d_reflect_local
    """
    with HalconOperator(273) as proc:
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, px)
        proc.set_input_tuple(2, py)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # qx
            proc.get_output_tuple_s(1)   # qy
        )  # type: ignore


def affine_trans_point_3d(
    hom_mat_3d: Sequence[float],
    px: MaybeSequence[Union[float, int]],
    py: MaybeSequence[Union[float, int]],
    pz: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Apply an arbitrary affine 3D transformation to points.

    Parameters
    ----------

    hom_mat_3d : Sequence[float]
                 Input transformation matrix.

    px : MaybeSequence[Union[float, int]]
         Input point(s) (x coordinate).
         Value Suggestion: 64

    py : MaybeSequence[Union[float, int]]
         Input point(s) (y coordinate).
         Value Suggestion: 64

    pz : MaybeSequence[Union[float, int]]
         Input point(s) (z coordinate).
         Value Suggestion: 64

    Returns
    -------

    qx : Sequence[float]
         Output point(s) (x coordinate).

    qy : Sequence[float]
         Output point(s) (y coordinate).

    qz : Sequence[float]
         Output point(s) (z coordinate).

    Predecessors
    ------------
    hom_mat3d_translate, hom_mat3d_translate_local, hom_mat3d_scale,
    hom_mat3d_scale_local, hom_mat3d_rotate, hom_mat3d_rotate_local

    Successors
    ----------
    hom_mat3d_translate, hom_mat3d_translate_local, hom_mat3d_scale,
    hom_mat3d_scale_local, hom_mat3d_rotate, hom_mat3d_rotate_local
    """
    with HalconOperator(241) as proc:
        proc.set_input_tuple(0, hom_mat_3d)
        proc.set_input_tuple(1, px)
        proc.set_input_tuple(2, py)
        proc.set_input_tuple(3, pz)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # qx
            proc.get_output_tuple_m(1),  # qy
            proc.get_output_tuple_m(2)   # qz
        )  # type: ignore


def affine_trans_point_3d_s(
    hom_mat_3d: Sequence[float],
    px: MaybeSequence[Union[float, int]],
    py: MaybeSequence[Union[float, int]],
    pz: MaybeSequence[Union[float, int]]
) -> Tuple[float, float, float]:
    """
    Apply an arbitrary affine 3D transformation to points.

    Parameters
    ----------

    hom_mat_3d : Sequence[float]
                 Input transformation matrix.

    px : MaybeSequence[Union[float, int]]
         Input point(s) (x coordinate).
         Value Suggestion: 64

    py : MaybeSequence[Union[float, int]]
         Input point(s) (y coordinate).
         Value Suggestion: 64

    pz : MaybeSequence[Union[float, int]]
         Input point(s) (z coordinate).
         Value Suggestion: 64

    Returns
    -------

    qx : float
         Output point(s) (x coordinate).

    qy : float
         Output point(s) (y coordinate).

    qz : float
         Output point(s) (z coordinate).

    Predecessors
    ------------
    hom_mat3d_translate, hom_mat3d_translate_local, hom_mat3d_scale,
    hom_mat3d_scale_local, hom_mat3d_rotate, hom_mat3d_rotate_local

    Successors
    ----------
    hom_mat3d_translate, hom_mat3d_translate_local, hom_mat3d_scale,
    hom_mat3d_scale_local, hom_mat3d_rotate, hom_mat3d_rotate_local
    """
    with HalconOperator(241) as proc:
        proc.set_input_tuple(0, hom_mat_3d)
        proc.set_input_tuple(1, px)
        proc.set_input_tuple(2, py)
        proc.set_input_tuple(3, pz)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # qx
            proc.get_output_tuple_s(1),  # qy
            proc.get_output_tuple_s(2)   # qz
        )  # type: ignore


def affine_trans_polygon_xld(
    polygons: HObject,
    hom_mat_2d: Sequence[float]
) -> HObject:
    """
    Apply an arbitrary affine transformation to XLD polygons.

    Parameters
    ----------

    polygons : HObject
               Input XLD polygons.

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    Returns
    -------

    polygons_affine_trans : HObject
                            Transformed XLD polygons.

    See Also
    --------
    affine_trans_image, affine_trans_region, affine_trans_contour_xld

    Predecessors
    ------------
    hom_mat2d_identity, hom_mat2d_translate, hom_mat2d_rotate,
    hom_mat2d_scale, hom_mat2d_reflect

    Notes
    -----
    The XLD contours that are possibly referenced by Polygons are neither
    transformed nor stored with the output polygons, since this is
    generally impossible without creating inconsistencies for the
    attributes of the XLD contours.  Hence, operators that access the
    contours associated with a polygon, e.g., split_contours_xld will not
    work correctly.
    affine_trans_polygon_xld does not use the HALCON standard coordinate
    system (with the origin in the center of the upper left pixel), but
    instead uses the same coordinate system as in affine_trans_pixel,
    i.e., the origin lies in the upper left corner of the upper left
    pixel. Therefore, applying affine_trans_polygon_xld corresponds to a
    chain of transformations (see affine_trans_pixel), which is applied to
    each point of the polygon (input and output pixels as homogeneous
    vectors). As an effect, you might get unexpected results when creating
    affine transformations based on coordinates that are derived from the
    polygon, e.g., by operators like area_center_xld. For example, if you
    use this operator to calculate the center of gravity of a rotationally
    symmetric XLD polygon and then rotate the polygon around this point
    using hom_mat2d_rotate, the resulting polygon will not lie on the
    original one. In such a case, you can compensate this effect by
    applying the following translations to HomMat2D before using it in
    affine_trans_polygon_xld:
    Table[layout]{l90} hom_mat2d_translate(HomMat2D, 0.5, 0.5,
    HomMat2DTmp)
    hom_mat2d_translate_local(HomMat2DTmp, -0.5, -0.5, HomMat2DAdapted)
    affine_trans_polygon_xld(Polygons, PolygonsAffineTrans,
    HomMat2DAdapted) Table
    For an explanation of the different 2D coordinate systems used in -
    see the introduction of chapter Transformations, 2DTransformations.
    """
    with HalconOperator(48) as proc:
        proc.set_input_object(1, polygons)
        proc.set_input_tuple(0, hom_mat_2d)
        proc.execute()
        polygons_affine_trans = HObject(proc.get_output_object_key(1))
        return polygons_affine_trans  # type: ignore


def affine_trans_region(
    region: HObject,
    hom_mat_2d: Sequence[float],
    interpolate: str
) -> HObject:
    """
    Apply an arbitrary affine 2D transformation to regions.

    Parameters
    ----------

    region : HObject
             Region(s) to be rotated and scaled.

    hom_mat_2d : Sequence[float]
                 Input transformation matrix.

    interpolate : str
                  Should the transformation be done using interpolation?
                  Value Suggestion: nearest_neighbor

    Returns
    -------

    region_affine_trans : HObject
                          Transformed output region(s).

    See Also
    --------
    affine_trans_image

    Alternatives
    ------------
    move_region, mirror_region, zoom_region

    Predecessors
    ------------
    hom_mat2d_identity, hom_mat2d_scale, hom_mat2d_translate,
    hom_mat2d_invert, hom_mat2d_rotate, hom_mat2d_reflect

    Successors
    ----------
    select_shape

    Notes
    -----
    affine_trans_region in general is not reversible (clipping and
    discretization during rotation and scaling).
    affine_trans_region does not use the HALCON standard coordinate system
    (with the origin in the center of the upper left pixel), but instead
    uses the same coordinate system as in affine_trans_pixel, i.e., the
    origin lies in the upper left corner of the upper left pixel.
    Therefore, applying affine_trans_region corresponds to a chain of
    transformations (see affine_trans_pixel), which is applied to each
    point of the region (input and output pixels as homogeneous vectors).
    As an effect, you might get unexpected results when creating affine
    transformations based on coordinates that are derived from the region,
    e.g., by operators like area_center. For example, if you use this
    operator to calculate the center of gravity of a rotationally
    symmetric region and then rotate the region around this point using
    hom_mat2d_rotate, the resulting region will not lie on the original
    one. In such a case, you can compensate this effect by applying the
    following translations to HomMat2D before using it in
    affine_trans_region:
    Table[layout]{l90} hom_mat2d_translate(HomMat2D, 0.5, 0.5,
    HomMat2DTmp)
    hom_mat2d_translate_local(HomMat2DTmp, -0.5, -0.5, HomMat2DAdapted)
    affine_trans_region(Region, RegionAffineTrans, HomMat2DAdapted,
    'nearest_neighbor') Table
    For an explanation of the different 2D coordinate systems used in -
    see the introduction of chapter Transformations, 2DTransformations.
    """
    with HalconOperator(488) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, hom_mat_2d)
        proc.set_input_tuple(1, interpolate)
        proc.execute()
        region_affine_trans = HObject(proc.get_output_object_key(1))
        return region_affine_trans  # type: ignore


def align_metrology_model(
    metrology_handle: HHandle,
    row: Union[int, float],
    column: Union[int, float],
    angle: Union[int, float]
) -> None:
    """
    Alignment of a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    row : Union[int, float]
          Row coordinate of the alignment.
          Value Suggestion: 0

    column : Union[int, float]
             Column coordinate of the alignment.
             Value Suggestion: 0

    angle : Union[int, float]
            Rotation angle of the alignment.
            Value Suggestion: 0

    See Also
    --------
    get_metrology_object_model_contour

    Predecessors
    ------------
    set_metrology_model_param, add_metrology_object_generic

    Successors
    ----------
    apply_metrology_model
    """
    with HalconOperator(790) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, angle)
        proc.execute()


def angle_ll(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the angle between two lines.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the first line.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the first line.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the first line.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the first line.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the second line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the second line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the second line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the second line.

    Returns
    -------

    angle : Sequence[float]
            Angle between the lines [rad].

    Alternatives
    ------------
    angle_lx
    """
    with HalconOperator(1371) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.execute()
        angle = proc.get_output_tuple_m(0)
        return angle  # type: ignore


def angle_ll_s(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the angle between two lines.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the first line.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the first line.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the first line.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the first line.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the second line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the second line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the second line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the second line.

    Returns
    -------

    angle : float
            Angle between the lines [rad].

    Alternatives
    ------------
    angle_lx
    """
    with HalconOperator(1371) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.execute()
        angle = proc.get_output_tuple_s(0)
        return angle  # type: ignore


def angle_lx(
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the angle between one line and the horizontal axis.

    Parameters
    ----------

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    angle : Sequence[float]
            Angle between the line and the horizontal axis [rad].

    Alternatives
    ------------
    angle_ll
    """
    with HalconOperator(1370) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        angle = proc.get_output_tuple_m(0)
        return angle  # type: ignore


def angle_lx_s(
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the angle between one line and the horizontal axis.

    Parameters
    ----------

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    angle : float
            Angle between the line and the horizontal axis [rad].

    Alternatives
    ------------
    angle_ll
    """
    with HalconOperator(1370) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        angle = proc.get_output_tuple_s(0)
        return angle  # type: ignore


def anisotropic_diffusion(
    image: HObject,
    mode: str,
    contrast: float,
    theta: float,
    iterations: int
) -> HObject:
    """
    Perform an anisotropic diffusion of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    mode : str
           Diffusion coefficient as a function of the edge amplitude.
           Value Suggestion: weickert

    contrast : float
               Contrast parameter.
               Value Suggestion: 5.0
               Assertion: Contrast > 0

    theta : float
            Time step.
            Value Suggestion: 1.0
            Assertion: Theta > 0

    iterations : int
                 Number of iterations.
                 Value Suggestion: 10
                 Assertion: Iterations >= 1

    Returns
    -------

    image_aniso : HObject
                  Output image.

    Alternatives
    ------------
    bilateral_filter, guided_filter

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1406) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, contrast)
        proc.set_input_tuple(2, theta)
        proc.set_input_tuple(3, iterations)
        proc.execute()
        image_aniso = HObject(proc.get_output_object_key(1))
        return image_aniso  # type: ignore


def append_channel(
    multi_channel_image: HObject,
    image: HObject
) -> HObject:
    """
    Append additional matrices (channels) to the image.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    image : HObject
            Image to be appended.

    Returns
    -------

    image_extended : HObject
                     Image appended by Image.

    Alternatives
    ------------
    compose2, compose3, compose4, compose5

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1134) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.set_input_object(2, image)
        proc.execute()
        image_extended = HObject(proc.get_output_object_key(1))
        return image_extended  # type: ignore


def append_ocr_trainf(
    character: HObject,
    image: HObject,
    class_val: MaybeSequence[str],
    training_file: str
) -> None:
    """
    Add characters to a training file.

    Parameters
    ----------

    character : HObject
                Characters to be trained.

    image : HObject
            Gray values of the characters.

    class_val : MaybeSequence[str]
                Class (name) of the characters.

    training_file : str
                    Name of the training file.
                    Value Suggestion: 'train_ocr'

    Alternatives
    ------------
    write_ocr_trainf, write_ocr_trainf_image

    Predecessors
    ------------
    threshold, connection, read_ocr_trainf

    Successors
    ----------
    trainf_ocr_class_mlp, trainf_ocr_class_svm, write_ocr_trainf
    """
    with HalconOperator(730) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, class_val)
        proc.set_input_tuple(1, training_file)
        proc.execute()


def apply_bead_inspection_model(
    image: HObject,
    bead_inspection_model: HHandle
) -> Tuple[HObject, HObject, HObject, Sequence[str]]:
    """
    Inspect beads in an image, as defined by the bead inspection model.

    Parameters
    ----------

    image : HObject
            Image to apply bead inspection on.

    bead_inspection_model : HHandle
                            Handle of the bead inspection model to be used.

    Returns
    -------

    left_contour : HObject
                   The detected left contour of the beads.

    right_contour : HObject
                    The detected right contour of the beads.

    error_segment : HObject
                    Detected error segments

    error_type : Sequence[str]
                 Types of detected errors.

    See Also
    --------
    get_bead_inspection_param, create_bead_inspection_model,
    set_bead_inspection_param

    Predecessors
    ------------
    create_bead_inspection_model, set_bead_inspection_param

    Successors
    ----------
    set_bead_inspection_param, clear_bead_inspection_model
    """
    with HalconOperator(1983) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, bead_inspection_model)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # left_contour
            HObject(proc.get_output_object_key(2)),  # right_contour
            HObject(proc.get_output_object_key(3)),  # error_segment
            proc.get_output_tuple_m(0)   # error_type
        )  # type: ignore


def apply_color_trans_lut(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject,
    color_trans_luthandle: HHandle
) -> Tuple[HObject, HObject, HObject]:
    """
    Color space transformation using pre-generated look-up-table.

    Parameters
    ----------

    image_1 : HObject
              Input image (channel 1).

    image_2 : HObject
              Input image (channel 2).

    image_3 : HObject
              Input image (channel 3).

    color_trans_luthandle : HHandle
                            Handle of the look-up-table for the color
                            space transformation.

    Returns
    -------

    image_result_1 : HObject
                     Color-transformed output image (channel 1).

    image_result_2 : HObject
                     Color-transformed output image (channel 2).

    image_result_3 : HObject
                     Color-transformed output image (channel 3).

    See Also
    --------
    create_color_trans_lut, clear_color_trans_lut

    Alternatives
    ------------
    trans_from_rgb, trans_to_rgb

    Predecessors
    ------------
    create_color_trans_lut

    Successors
    ----------
    clear_color_trans_lut
    """
    with HalconOperator(1578) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.set_input_tuple(0, color_trans_luthandle)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_result_1
            HObject(proc.get_output_object_key(2)),  # image_result_2
            HObject(proc.get_output_object_key(3))   # image_result_3
        )  # type: ignore


def apply_deep_ocr(
    image: HObject,
    deep_ocr_handle: HHandle,
    mode: str
) -> Sequence[HHandle]:
    """
    Apply a Deep OCR model on a set of images for inference.

    Parameters
    ----------

    image : HObject
            Input image.

    deep_ocr_handle : HHandle
                      Handle of the Deep OCR model.

    mode : str
           Inference mode.
           Value Suggestion: []

    Returns
    -------

    deep_ocr_result : Sequence[HHandle]
                      Tuple of result dictionaries.

    Predecessors
    ------------
    get_deep_ocr_param, set_deep_ocr_param, create_deep_ocr

    Notes
    -----
    System requirements: To run this operator on GPU (see
    get_deep_ocr_param), cuDNN and cuBLAS are required. For further
    details, please refer to the ``Installation Guide'', paragraph
    ``Requirements for Deep Learning and Deep-Learning-Based Methods''.
    Alternatively, this operator can also be run on CPU.
    """
    with HalconOperator(2206) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, deep_ocr_handle)
        proc.set_input_tuple(1, mode)
        proc.init_oct(0)
        proc.execute()
        deep_ocr_result = proc.get_output_tuple_m(0)
        return deep_ocr_result  # type: ignore


def apply_deep_ocr_s(
    image: HObject,
    deep_ocr_handle: HHandle,
    mode: str
) -> HHandle:
    """
    Apply a Deep OCR model on a set of images for inference.

    Parameters
    ----------

    image : HObject
            Input image.

    deep_ocr_handle : HHandle
                      Handle of the Deep OCR model.

    mode : str
           Inference mode.
           Value Suggestion: []

    Returns
    -------

    deep_ocr_result : HHandle
                      Tuple of result dictionaries.

    Predecessors
    ------------
    get_deep_ocr_param, set_deep_ocr_param, create_deep_ocr

    Notes
    -----
    System requirements: To run this operator on GPU (see
    get_deep_ocr_param), cuDNN and cuBLAS are required. For further
    details, please refer to the ``Installation Guide'', paragraph
    ``Requirements for Deep Learning and Deep-Learning-Based Methods''.
    Alternatively, this operator can also be run on CPU.
    """
    with HalconOperator(2206) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, deep_ocr_handle)
        proc.set_input_tuple(1, mode)
        proc.init_oct(0)
        proc.execute()
        deep_ocr_result = proc.get_output_tuple_s(0)
        return deep_ocr_result  # type: ignore


def apply_distance_transform_xld(
    contour: HObject,
    distance_transform_id: HHandle
) -> HObject:
    """
    Determine the pointwise distance of two contours using an XLD distance
    transform.

    Parameters
    ----------

    contour : HObject
              Contour(s) for whose points the distances are calculated.

    distance_transform_id : HHandle
                            Handle of the XLD distance transform of the
                            reference contour.

    Returns
    -------

    contour_out : HObject
                  Copy of Contour containing the distances as an attribute.

    See Also
    --------
    get_contour_attrib_xld, set_distance_transform_xld_param,
    write_distance_transform_xld, serialize_distance_transform_xld,
    clear_distance_transform_xld

    Alternatives
    ------------
    distance_contours_xld

    Predecessors
    ------------
    create_distance_transform_xld, read_distance_transform_xld,
    deserialize_distance_transform_xld, set_distance_transform_xld_param

    Successors
    ----------
    get_contour_attrib_xld, segment_contour_attrib_xld
    """
    with HalconOperator(1352) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, distance_transform_id)
        proc.execute()
        contour_out = HObject(proc.get_output_object_key(1))
        return contour_out  # type: ignore


def apply_dl_classifier(
    images: HObject,
    dlclassifier_handle: HHandle
) -> HHandle:
    """
    Infer the class affiliations for a set of images using a
    deep-learning-based classifier.

    Parameters
    ----------

    images : HObject
             Tuple of input images.

    dlclassifier_handle : HHandle
                          Handle of the deep-learning-based classifier.

    Returns
    -------

    dlclassifier_result_handle : HHandle
                                 Handle of the deep learning
                                 classification results.

    Alternatives
    ------------
    apply_dl_model, classify_class_mlp, classify_class_svm

    Predecessors
    ------------
    read_dl_classifier, train_dl_classifier_batch, set_dl_classifier_param

    Successors
    ----------
    get_dl_classifier_result, clear_dl_classifier

    Warnings
    --------
    apply_dl_classifier is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the general
    CNN-based operator apply_dl_model instead.

    Notes
    -----
    To run this operator, cuDNN and cuBLAS are required when 'runtime' is
    set to 'gpu', see set_dl_classifier_param. For further details, please
    refer to the ``Installation Guide'', paragraph ``Requirements for Deep
    Learning and Deep-Learning-Based Methods''.
    """
    with HalconOperator(2102) as proc:
        proc.set_input_object(1, images)
        proc.set_input_tuple(0, dlclassifier_handle)
        proc.init_oct(0)
        proc.execute()
        dlclassifier_result_handle = proc.get_output_tuple_s(0)
        return dlclassifier_result_handle  # type: ignore


def apply_dl_model(
    dlmodel_handle: HHandle,
    dlsample_batch: Sequence[HHandle],
    outputs: Sequence[str]
) -> Sequence[HHandle]:
    """
    Apply a deep-learning-based network on a set of images for inference.

    Parameters
    ----------

    dlmodel_handle : HHandle
                     Handle of the deep learning model.

    dlsample_batch : Sequence[HHandle]
                     Input data.

    outputs : Sequence[str]
              Requested outputs.
              Value Suggestion: []

    Returns
    -------

    dlresult_batch : Sequence[HHandle]
                     Result data.

    Predecessors
    ------------
    read_dl_model, train_dl_model_batch, train_dl_model_anomaly_dataset,
    set_dl_model_param

    Notes
    -----
    System requirements: To run this operator on GPU by setting 'device'
    to 'gpu' (see get_dl_model_param), cuDNN and cuBLAS are required. For
    further details, please refer to the ``Installation Guide'', paragraph
    ``Requirements for Deep Learning and Deep-Learning-Based Methods''.
    """
    with HalconOperator(2146) as proc:
        proc.set_input_tuple(0, dlmodel_handle)
        proc.set_input_tuple(1, dlsample_batch)
        proc.set_input_tuple(2, outputs)
        proc.init_oct(0)
        proc.execute()
        dlresult_batch = proc.get_output_tuple_m(0)
        return dlresult_batch  # type: ignore


def apply_metrology_model(
    image: HObject,
    metrology_handle: HHandle
) -> None:
    """
    Measure and fit the geometric shapes of all metrology objects of a
    metrology model.

    Parameters
    ----------

    image : HObject
            Input image.

    metrology_handle : HHandle
                       Handle of the metrology model.

    See Also
    --------
    set_metrology_object_fuzzy_param, read_metrology_model,
    write_metrology_model

    Predecessors
    ------------
    add_metrology_object_generic, add_metrology_object_circle_measure,
    add_metrology_object_ellipse_measure,
    add_metrology_object_line_measure,
    add_metrology_object_rectangle2_measure, align_metrology_model,
    set_metrology_model_param, set_metrology_object_param

    Successors
    ----------
    get_metrology_object_result, get_metrology_object_result_contour,
    get_metrology_object_measures

    Notes
    -----
    Note that all measure regions of all metrology objects must be
    recomputed if the width or the height of the input Image is not equal
    to the width and height stored in the metrology object (e.g., set with
    set_metrology_model_image_size). This leads to longer execution times
    of the operator.
    Note further that apply_metrology_model ignores the domain of Image
    for efficiency reasons (see also measure_pos).
    """
    with HalconOperator(804) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, metrology_handle)
        proc.execute()


def apply_sample_identifier(
    image: HObject,
    sample_identifier: HHandle,
    num_results: int,
    rating_threshold: float,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> Tuple[Sequence[int], Sequence[float]]:
    """
    Identify objects with a sample identifier.

    Parameters
    ----------

    image : HObject
            Image showing the object to be identified.

    sample_identifier : HHandle
                        Handle of the sample identifier.

    num_results : int
                  Number of suggested object indices.
                  Value Suggestion: 1

    rating_threshold : float
                       Rating threshold.
                       Value Suggestion: 0.0

    gen_param_name : Sequence[str]
                     Generic parameter name.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Generic parameter value.
                      Value Suggestion: []

    Returns
    -------

    object_idx : Sequence[int]
                 Index of the identified object.

    rating : Sequence[float]
             Rating value of the identified object.

    See Also
    --------
    create_sample_identifier, add_sample_identifier_preparation_data,
    prepare_sample_identifier, set_sample_identifier_param,
    get_sample_identifier_param, get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, deserialize_sample_identifier,
    clear_sample_identifier, set_sample_identifier_object_info

    Predecessors
    ------------
    train_sample_identifier, read_sample_identifier

    Successors
    ----------
    add_sample_identifier_training_data
    """
    with HalconOperator(904) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sample_identifier)
        proc.set_input_tuple(1, num_results)
        proc.set_input_tuple(2, rating_threshold)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # object_idx
            proc.get_output_tuple_m(1)   # rating
        )  # type: ignore


def apply_sample_identifier_s(
    image: HObject,
    sample_identifier: HHandle,
    num_results: int,
    rating_threshold: float,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> Tuple[int, float]:
    """
    Identify objects with a sample identifier.

    Parameters
    ----------

    image : HObject
            Image showing the object to be identified.

    sample_identifier : HHandle
                        Handle of the sample identifier.

    num_results : int
                  Number of suggested object indices.
                  Value Suggestion: 1

    rating_threshold : float
                       Rating threshold.
                       Value Suggestion: 0.0

    gen_param_name : Sequence[str]
                     Generic parameter name.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Generic parameter value.
                      Value Suggestion: []

    Returns
    -------

    object_idx : int
                 Index of the identified object.

    rating : float
             Rating value of the identified object.

    See Also
    --------
    create_sample_identifier, add_sample_identifier_preparation_data,
    prepare_sample_identifier, set_sample_identifier_param,
    get_sample_identifier_param, get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, deserialize_sample_identifier,
    clear_sample_identifier, set_sample_identifier_object_info

    Predecessors
    ------------
    train_sample_identifier, read_sample_identifier

    Successors
    ----------
    add_sample_identifier_training_data
    """
    with HalconOperator(904) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sample_identifier)
        proc.set_input_tuple(1, num_results)
        proc.set_input_tuple(2, rating_threshold)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # object_idx
            proc.get_output_tuple_s(1)   # rating
        )  # type: ignore


def apply_sheet_of_light_calibration(
    disparity: HObject,
    sheet_of_light_model_id: HHandle
) -> None:
    """
    Apply the calibration transformations to the input disparity image.

    Parameters
    ----------

    disparity : HObject
                Height or range image to be calibrated.

    sheet_of_light_model_id : HHandle
                              Handle of the sheet-of-light model.

    Successors
    ----------
    get_sheet_of_light_result, get_sheet_of_light_result_object_model_3d
    """
    with HalconOperator(382) as proc:
        proc.set_input_object(1, disparity)
        proc.set_input_tuple(0, sheet_of_light_model_id)
        proc.execute()


def apply_texture_inspection_model(
    image: HObject,
    texture_inspection_model: HHandle
) -> Tuple[HObject, HHandle]:
    """
    Inspection of the texture within an image.

    Parameters
    ----------

    image : HObject
            Image of the texture to be inspected.

    texture_inspection_model : HHandle
                               Handle of the texture inspection model.

    Returns
    -------

    novelty_region : HObject
                     Novelty regions.

    texture_inspection_result_id : HHandle
                                   Handle of the inspection results.

    Predecessors
    ------------
    train_texture_inspection_model

    Successors
    ----------
    get_texture_inspection_result_object,
    get_texture_inspection_model_param, clear_texture_inspection_result,
    clear_texture_inspection_model
    """
    with HalconOperator(2044) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, texture_inspection_model)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # novelty_region
            proc.get_output_tuple_s(0)   # texture_inspection_result_id
        )  # type: ignore


def approx_chain(
    row: Sequence[int],
    column: Sequence[int],
    min_width_coord: float,
    max_width_coord: float,
    thresh_start: float,
    thresh_end: float,
    thresh_step: float,
    min_width_smooth: float,
    max_width_smooth: float,
    min_width_curve: int,
    max_width_curve: int,
    weight_1: float,
    weight_2: float,
    weight_3: float
) -> Tuple[Sequence[int], Sequence[int], Sequence[float], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int]]:
    """
    Approximate a contour by arcs and lines.

    Parameters
    ----------

    row : Sequence[int]
          Row of the contour.
          Value Suggestion: 32

    column : Sequence[int]
             Column of the contour.
             Value Suggestion: 32

    min_width_coord : float
                      Minimum width of Gauss operator for coordinate
                      smoothing ($>$ 0.4).
                      Value Suggestion: 0.5

    max_width_coord : float
                      Maximum width of Gauss operator for coordinate
                      smoothing ($>$ 0.4).
                      Value Suggestion: 2.4

    thresh_start : float
                   Minimum threshold value of the curvature for accepting
                   a corner (relative to the largest curvature present).
                   Value Suggestion: 0.3

    thresh_end : float
                 Maximum threshold value of the curvature for accepting a
                 corner (relative to the largest curvature present).
                 Value Suggestion: 0.9

    thresh_step : float
                  Step width for threshold increase.
                  Value Suggestion: 0.2

    min_width_smooth : float
                       Minimum width of Gauss operator for smoothing the
                       curvature function ($>$ 0.4).
                       Value Suggestion: 0.5

    max_width_smooth : float
                       Maximum width of Gauss operator for smoothing the
                       curvature function.
                       Value Suggestion: 2.4

    min_width_curve : int
                      Minimum width of curve area for curvature
                      determination ($>$ 0.4).
                      Value Suggestion: 2

    max_width_curve : int
                      Maximum width of curve area for curvature
                      determination.
                      Value Suggestion: 12

    weight_1 : float
               Weighting factor for approximation precision.
               Value Suggestion: 1.0

    weight_2 : float
               Weighting factor for large segments.
               Value Suggestion: 1.0

    weight_3 : float
               Weighting factor for small segments.
               Value Suggestion: 1.0

    Returns
    -------

    arc_center_row : Sequence[int]
                     Row of the center of an arc.

    arc_center_col : Sequence[int]
                     Column of the center of an arc.

    arc_angle : Sequence[float]
                Angle of an arc.

    arc_begin_row : Sequence[int]
                    Row of the starting point of an arc.

    arc_begin_col : Sequence[int]
                    Column of the starting point of an arc.

    line_begin_row : Sequence[int]
                     Row of the starting point of a line segment.

    line_begin_col : Sequence[int]
                     Column of the starting point of a line segment.

    line_end_row : Sequence[int]
                   Row of the ending point of a line segment.

    line_end_col : Sequence[int]
                   Column of the ending point of a line segment.

    order : Sequence[int]
            Sequence of line (value 0) and arc segments (value 1).

    See Also
    --------
    get_region_chain, smallest_circle, disp_circle, disp_line

    Alternatives
    ------------
    get_region_polygon, approx_chain_simple

    Predecessors
    ------------
    sobel_amp, edges_image, get_region_contour, threshold,
    hysteresis_threshold

    Successors
    ----------
    set_line_width, disp_arc, disp_line

    Warnings
    --------
    approx_chain is obsolete and is only provided for reasons of backward
    compatibility.

    Notes
    -----
    Contours which can possibly consist of only one segment should also be
    examined with a threshold maximum (ThreshEnd) $>$ 1.0, because
    otherwise at least one ``corner point'' is determined in any case.
    """
    with HalconOperator(1742) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, min_width_coord)
        proc.set_input_tuple(3, max_width_coord)
        proc.set_input_tuple(4, thresh_start)
        proc.set_input_tuple(5, thresh_end)
        proc.set_input_tuple(6, thresh_step)
        proc.set_input_tuple(7, min_width_smooth)
        proc.set_input_tuple(8, max_width_smooth)
        proc.set_input_tuple(9, min_width_curve)
        proc.set_input_tuple(10, max_width_curve)
        proc.set_input_tuple(11, weight_1)
        proc.set_input_tuple(12, weight_2)
        proc.set_input_tuple(13, weight_3)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.init_oct(6)
        proc.init_oct(7)
        proc.init_oct(8)
        proc.init_oct(9)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # arc_center_row
            proc.get_output_tuple_m(1),  # arc_center_col
            proc.get_output_tuple_m(2),  # arc_angle
            proc.get_output_tuple_m(3),  # arc_begin_row
            proc.get_output_tuple_m(4),  # arc_begin_col
            proc.get_output_tuple_m(5),  # line_begin_row
            proc.get_output_tuple_m(6),  # line_begin_col
            proc.get_output_tuple_m(7),  # line_end_row
            proc.get_output_tuple_m(8),  # line_end_col
            proc.get_output_tuple_m(9)   # order
        )  # type: ignore


def approx_chain_simple(
    row: Sequence[int],
    column: Sequence[int]
) -> Tuple[Sequence[int], Sequence[int], Sequence[float], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int]]:
    """
    Approximate a contour by arcs and lines.

    Parameters
    ----------

    row : Sequence[int]
          Row of the contour.
          Value Suggestion: 32

    column : Sequence[int]
             Column of the contour.
             Value Suggestion: 32

    Returns
    -------

    arc_center_row : Sequence[int]
                     Row of the center of an arc.

    arc_center_col : Sequence[int]
                     Column of the center of an arc.

    arc_angle : Sequence[float]
                Angle of an arc.

    arc_begin_row : Sequence[int]
                    Row of the starting point of an arc.

    arc_begin_col : Sequence[int]
                    Column of the starting point of an arc.

    line_begin_row : Sequence[int]
                     Row of the starting point of a line segment.

    line_begin_col : Sequence[int]
                     Column of the starting point of a line segment.

    line_end_row : Sequence[int]
                   Row of the ending point of a line segment.

    line_end_col : Sequence[int]
                   Column of the ending point of a line segment.

    order : Sequence[int]
            Sequence of line (value 0) and arc segments (value 1).

    See Also
    --------
    get_region_chain, smallest_circle, disp_circle, disp_line

    Alternatives
    ------------
    get_region_polygon, approx_chain

    Predecessors
    ------------
    sobel_amp, edges_image, get_region_contour, threshold,
    hysteresis_threshold

    Successors
    ----------
    set_line_width, disp_arc, disp_line

    Warnings
    --------
    approx_chain_simple is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(1741) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.init_oct(6)
        proc.init_oct(7)
        proc.init_oct(8)
        proc.init_oct(9)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # arc_center_row
            proc.get_output_tuple_m(1),  # arc_center_col
            proc.get_output_tuple_m(2),  # arc_angle
            proc.get_output_tuple_m(3),  # arc_begin_row
            proc.get_output_tuple_m(4),  # arc_begin_col
            proc.get_output_tuple_m(5),  # line_begin_row
            proc.get_output_tuple_m(6),  # line_begin_col
            proc.get_output_tuple_m(7),  # line_end_row
            proc.get_output_tuple_m(8),  # line_end_col
            proc.get_output_tuple_m(9)   # order
        )  # type: ignore


def area_center(
    regions: HObject
) -> Tuple[Sequence[int], Sequence[float], Sequence[float]]:
    """
    Area and center of regions.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    area : Sequence[int]
           Area of the region.

    row : Sequence[float]
          Line index of the center.

    column : Sequence[float]
             Column index of the center.

    See Also
    --------
    select_shape

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1731) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # area
            proc.get_output_tuple_m(1),  # row
            proc.get_output_tuple_m(2)   # column
        )  # type: ignore


def area_center_gray(
    regions: HObject,
    image: HObject
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Compute the area and center of gravity of a region in a gray value
    image.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    image : HObject
            Gray value image.

    Returns
    -------

    area : Sequence[float]
           Gray value volume of the region.

    row : Sequence[float]
          Row coordinate of the gray value center of gravity.

    column : Sequence[float]
             Column coordinate of the gray value center of gravity.

    See Also
    --------
    area_center_xld, elliptic_axis_gray

    Alternatives
    ------------
    area_center

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Note that the operator area_center_gray only considers the given
    Regions and ignores any previously set domain of the input image
    Image. area_center_gray can be executed on OpenCL devices if the
    device supports the  cl_khr_fp64 and cl_khr_int64_base_atomics OpenCL
    extensions.
    """
    with HalconOperator(1764) as proc:
        proc.set_input_object(1, regions)
        proc.set_input_object(2, image)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # area
            proc.get_output_tuple_m(1),  # row
            proc.get_output_tuple_m(2)   # column
        )  # type: ignore


def area_center_gray_s(
    regions: HObject,
    image: HObject
) -> Tuple[float, float, float]:
    """
    Compute the area and center of gravity of a region in a gray value
    image.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    image : HObject
            Gray value image.

    Returns
    -------

    area : float
           Gray value volume of the region.

    row : float
          Row coordinate of the gray value center of gravity.

    column : float
             Column coordinate of the gray value center of gravity.

    See Also
    --------
    area_center_xld, elliptic_axis_gray

    Alternatives
    ------------
    area_center

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Note that the operator area_center_gray only considers the given
    Regions and ignores any previously set domain of the input image
    Image. area_center_gray can be executed on OpenCL devices if the
    device supports the  cl_khr_fp64 and cl_khr_int64_base_atomics OpenCL
    extensions.
    """
    with HalconOperator(1764) as proc:
        proc.set_input_object(1, regions)
        proc.set_input_object(2, image)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # area
            proc.get_output_tuple_s(1),  # row
            proc.get_output_tuple_s(2)   # column
        )  # type: ignore


def area_center_points_xld(
    xld: HObject
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Area and center of gravity (centroid) of contours and polygons treated
    as point clouds.

    Parameters
    ----------

    xld : HObject
          Point clouds to be examined in form of contours or polygons.

    Returns
    -------

    area : Sequence[float]
           Area of the point cloud.

    row : Sequence[float]
          Row coordinate of the centroid.

    column : Sequence[float]
             Column coordinate of the centroid.

    See Also
    --------
    moments_points_xld, moments_any_points_xld, area_center,
    moments_region_2nd

    Alternatives
    ------------
    area_center_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, smooth_contours_xld, gen_polygons_xld

    Notes
    -----
    Even if the contour or polygon XLD is not intersecting itself, the
    result of area_center_points_xld significantly differs from the result
    of area_center_xld as it is calculated from the point cloud and not
    from the enclosed region.
    """
    with HalconOperator(1674) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # area
            proc.get_output_tuple_m(1),  # row
            proc.get_output_tuple_m(2)   # column
        )  # type: ignore


def area_center_points_xld_s(xld: HObject) -> Tuple[float, float, float]:
    """
    Area and center of gravity (centroid) of contours and polygons treated
    as point clouds.

    Parameters
    ----------

    xld : HObject
          Point clouds to be examined in form of contours or polygons.

    Returns
    -------

    area : float
           Area of the point cloud.

    row : float
          Row coordinate of the centroid.

    column : float
             Column coordinate of the centroid.

    See Also
    --------
    moments_points_xld, moments_any_points_xld, area_center,
    moments_region_2nd

    Alternatives
    ------------
    area_center_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, smooth_contours_xld, gen_polygons_xld

    Notes
    -----
    Even if the contour or polygon XLD is not intersecting itself, the
    result of area_center_points_xld significantly differs from the result
    of area_center_xld as it is calculated from the point cloud and not
    from the enclosed region.
    """
    with HalconOperator(1674) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # area
            proc.get_output_tuple_s(1),  # row
            proc.get_output_tuple_s(2)   # column
        )  # type: ignore


def area_center_s(regions: HObject) -> Tuple[int, float, float]:
    """
    Area and center of regions.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    area : int
           Area of the region.

    row : float
          Line index of the center.

    column : float
             Column index of the center.

    See Also
    --------
    select_shape

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1731) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # area
            proc.get_output_tuple_s(1),  # row
            proc.get_output_tuple_s(2)   # column
        )  # type: ignore


def area_center_xld(
    xld: HObject
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[str]]:
    """
    Area and center of gravity (centroid) of contours and polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    area : Sequence[float]
           Area enclosed by the contour or polygon.

    row : Sequence[float]
          Row coordinate of the centroid.

    column : Sequence[float]
             Column coordinate of the centroid.

    point_order : Sequence[str]
                  point order along the boundary ('positive'/'negative').

    See Also
    --------
    moments_xld, moments_any_xld, area_center, moments_region_2nd

    Alternatives
    ------------
    area_center_points_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, smooth_contours_xld, gen_polygons_xld
    """
    with HalconOperator(1693) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # area
            proc.get_output_tuple_m(1),  # row
            proc.get_output_tuple_m(2),  # column
            proc.get_output_tuple_m(3)   # point_order
        )  # type: ignore


def area_center_xld_s(xld: HObject) -> Tuple[float, float, float, str]:
    """
    Area and center of gravity (centroid) of contours and polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    area : float
           Area enclosed by the contour or polygon.

    row : float
          Row coordinate of the centroid.

    column : float
             Column coordinate of the centroid.

    point_order : str
                  point order along the boundary ('positive'/'negative').

    See Also
    --------
    moments_xld, moments_any_xld, area_center, moments_region_2nd

    Alternatives
    ------------
    area_center_points_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, smooth_contours_xld, gen_polygons_xld
    """
    with HalconOperator(1693) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # area
            proc.get_output_tuple_s(1),  # row
            proc.get_output_tuple_s(2),  # column
            proc.get_output_tuple_s(3)   # point_order
        )  # type: ignore


def area_holes(regions: HObject) -> Sequence[int]:
    """
    Compute the area of holes of regions.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    area : Sequence[int]
           Area(s) of holes of the region(s).

    See Also
    --------
    area_center, fill_up

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1730) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        area = proc.get_output_tuple_m(0)
        return area  # type: ignore


def area_holes_s(regions: HObject) -> int:
    """
    Compute the area of holes of regions.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    area : int
           Area(s) of holes of the region(s).

    See Also
    --------
    area_center, fill_up

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1730) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        area = proc.get_output_tuple_s(0)
        return area  # type: ignore


def area_intersection_rectangle2(
    rect_1row: Union[float, int],
    rect_1column: Union[float, int],
    rect_1phi: Union[float, int],
    rect_1length_1: Union[float, int],
    rect_1length_2: Union[float, int],
    rect_2row: MaybeSequence[Union[float, int]],
    rect_2column: MaybeSequence[Union[float, int]],
    rect_2phi: MaybeSequence[Union[float, int]],
    rect_2length_1: MaybeSequence[Union[float, int]],
    rect_2length_2: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the intersection area of oriented rectangles.

    Parameters
    ----------

    rect_1row : Union[float, int]
                Center row coordinate of the first rectangle.

    rect_1column : Union[float, int]
                   Center column coordinate of the first rectangle.

    rect_1phi : Union[float, int]
                Angle between the positive horizontal axis and the first
                edge of the first rectangle (in radians).

    rect_1length_1 : Union[float, int]
                     Half length of the first edge of the first rectangle.

    rect_1length_2 : Union[float, int]
                     Half length of the second edge of the first rectangle.

    rect_2row : MaybeSequence[Union[float, int]]
                Center row coordinate of the second rectangle.

    rect_2column : MaybeSequence[Union[float, int]]
                   Center column coordinate of the second rectangle.

    rect_2phi : MaybeSequence[Union[float, int]]
                Angle between the positive horizontal axis and the first
                edge of the second rectangle (in radians).

    rect_2length_1 : MaybeSequence[Union[float, int]]
                     Half length of the first edge of the second rectangle.

    rect_2length_2 : MaybeSequence[Union[float, int]]
                     Half length of the second edge of the second
                     rectangle.

    Returns
    -------

    area_intersection : Sequence[float]
                        Intersection area of the first rectangle with the
                        second rectangle.

    See Also
    --------
    gen_rectangle2, intersection_segments, intersection_segment_line,
    intersection_segment_contour_xld, intersection_line_contour_xld,
    intersection_contours_xld
    """
    with HalconOperator(2176) as proc:
        proc.set_input_tuple(0, rect_1row)
        proc.set_input_tuple(1, rect_1column)
        proc.set_input_tuple(2, rect_1phi)
        proc.set_input_tuple(3, rect_1length_1)
        proc.set_input_tuple(4, rect_1length_2)
        proc.set_input_tuple(5, rect_2row)
        proc.set_input_tuple(6, rect_2column)
        proc.set_input_tuple(7, rect_2phi)
        proc.set_input_tuple(8, rect_2length_1)
        proc.set_input_tuple(9, rect_2length_2)
        proc.init_oct(0)
        proc.execute()
        area_intersection = proc.get_output_tuple_m(0)
        return area_intersection  # type: ignore


def area_intersection_rectangle2_s(
    rect_1row: Union[float, int],
    rect_1column: Union[float, int],
    rect_1phi: Union[float, int],
    rect_1length_1: Union[float, int],
    rect_1length_2: Union[float, int],
    rect_2row: MaybeSequence[Union[float, int]],
    rect_2column: MaybeSequence[Union[float, int]],
    rect_2phi: MaybeSequence[Union[float, int]],
    rect_2length_1: MaybeSequence[Union[float, int]],
    rect_2length_2: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the intersection area of oriented rectangles.

    Parameters
    ----------

    rect_1row : Union[float, int]
                Center row coordinate of the first rectangle.

    rect_1column : Union[float, int]
                   Center column coordinate of the first rectangle.

    rect_1phi : Union[float, int]
                Angle between the positive horizontal axis and the first
                edge of the first rectangle (in radians).

    rect_1length_1 : Union[float, int]
                     Half length of the first edge of the first rectangle.

    rect_1length_2 : Union[float, int]
                     Half length of the second edge of the first rectangle.

    rect_2row : MaybeSequence[Union[float, int]]
                Center row coordinate of the second rectangle.

    rect_2column : MaybeSequence[Union[float, int]]
                   Center column coordinate of the second rectangle.

    rect_2phi : MaybeSequence[Union[float, int]]
                Angle between the positive horizontal axis and the first
                edge of the second rectangle (in radians).

    rect_2length_1 : MaybeSequence[Union[float, int]]
                     Half length of the first edge of the second rectangle.

    rect_2length_2 : MaybeSequence[Union[float, int]]
                     Half length of the second edge of the second
                     rectangle.

    Returns
    -------

    area_intersection : float
                        Intersection area of the first rectangle with the
                        second rectangle.

    See Also
    --------
    gen_rectangle2, intersection_segments, intersection_segment_line,
    intersection_segment_contour_xld, intersection_line_contour_xld,
    intersection_contours_xld
    """
    with HalconOperator(2176) as proc:
        proc.set_input_tuple(0, rect_1row)
        proc.set_input_tuple(1, rect_1column)
        proc.set_input_tuple(2, rect_1phi)
        proc.set_input_tuple(3, rect_1length_1)
        proc.set_input_tuple(4, rect_1length_2)
        proc.set_input_tuple(5, rect_2row)
        proc.set_input_tuple(6, rect_2column)
        proc.set_input_tuple(7, rect_2phi)
        proc.set_input_tuple(8, rect_2length_1)
        proc.set_input_tuple(9, rect_2length_2)
        proc.init_oct(0)
        proc.execute()
        area_intersection = proc.get_output_tuple_s(0)
        return area_intersection  # type: ignore


def area_object_model_3d(
    object_model_3d: MaybeSequence[HHandle]
) -> Sequence[float]:
    """
    Calculate the area of all faces of a 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    Returns
    -------

    area : Sequence[float]
           Calculated area.

    See Also
    --------
    volume_object_model_3d_relative_to_plane,
    max_diameter_object_model_3d, moments_object_model_3d

    Predecessors
    ------------
    connection_object_model_3d, select_points_object_model_3d,
    prepare_object_model_3d, convex_hull_object_model_3d

    Successors
    ----------
    select_object_model_3d
    """
    with HalconOperator(1080) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.init_oct(0)
        proc.execute()
        area = proc.get_output_tuple_m(0)
        return area  # type: ignore


def area_object_model_3d_s(
    object_model_3d: MaybeSequence[HHandle]
) -> float:
    """
    Calculate the area of all faces of a 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    Returns
    -------

    area : float
           Calculated area.

    See Also
    --------
    volume_object_model_3d_relative_to_plane,
    max_diameter_object_model_3d, moments_object_model_3d

    Predecessors
    ------------
    connection_object_model_3d, select_points_object_model_3d,
    prepare_object_model_3d, convex_hull_object_model_3d

    Successors
    ----------
    select_object_model_3d
    """
    with HalconOperator(1080) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.init_oct(0)
        proc.execute()
        area = proc.get_output_tuple_s(0)
        return area  # type: ignore


def asin_image(image: HObject) -> HObject:
    """
    Calculate the arcsine of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    arcsin_image : HObject
                   Output image.

    See Also
    --------
    acos_image, atan_image, atan2_image, tan_image, sin_image, cos_image

    Notes
    -----
    asin_image can be executed on OpenCL devices.
    """
    with HalconOperator(1600) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        arcsin_image = HObject(proc.get_output_object_key(1))
        return arcsin_image  # type: ignore


def atan2_image(image_y: HObject, image_x: HObject) -> HObject:
    """
    Calculate the arctangent of two images.

    Parameters
    ----------

    image_y : HObject
              Input image 1.

    image_x : HObject
              Input image 2.

    Returns
    -------

    arctan_image : HObject
                   Output image.

    See Also
    --------
    acos_image, asin_image, tan_image, sin_image, cos_image

    Alternatives
    ------------
    atan_image

    Notes
    -----
    atan2_image can be executed on an OpenCL device for int1, int2, int4,
    and real images. Note that the results of the OpenCL code may vary
    from the results produced by the CPU.
    """
    with HalconOperator(1597) as proc:
        proc.set_input_object(1, image_y)
        proc.set_input_object(2, image_x)
        proc.execute()
        arctan_image = HObject(proc.get_output_object_key(1))
        return arctan_image  # type: ignore


def atan_image(image: HObject) -> HObject:
    """
    Calculate the arctangent of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    arctan_image : HObject
                   Output image.

    See Also
    --------
    acos_image, asin_image, tan_image, sin_image, cos_image

    Alternatives
    ------------
    atan2_image

    Notes
    -----
    atan_image can be executed on OpenCL devices.
    """
    with HalconOperator(1598) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        arctan_image = HObject(proc.get_output_object_key(1))
        return arctan_image  # type: ignore


def attach_background_to_window(
    image: HObject,
    window_handle: HHandle
) -> None:
    """
    Attach a background image to a HALCON window.

    Parameters
    ----------

    image : HObject
            Background image.

    window_handle : HHandle
                    Window handle.

    Predecessors
    ------------
    open_window

    Successors
    ----------
    detach_background_from_window

    Notes
    -----
    Note that using any synchronous operator which actively probe the
    event queue, e.g., get_mbutton or read_char, will conflict with the
    interaction with the drawing objects. In case the state of the cursor
    has to be read, please refer to the documentation of your framework of
    choice for an appropriate, non-invasive alternative.
    Furthermore, the event based functionality should not be used together
    with the former blocking operators draw_rectangle1, draw_rectangle2,
    draw_region, draw_xld or draw_circle. They conflict with the event
    based functionality, since they actively fetch all events sent to the
    HALCON window.
    """
    with HalconOperator(1164) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def attach_drawing_object_to_window(
    window_handle: HHandle,
    draw_handle: HHandle
) -> None:
    """
    Attach an existing drawing object to a HALCON window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    draw_handle : HHandle
                  Handle of the drawing object.

    See Also
    --------
    set_drawing_object_callback, get_drawing_object_iconic,
    get_drawing_object_params

    Predecessors
    ------------
    create_drawing_object_rectangle1, create_drawing_object_xld,
    create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_ellipse,
    create_drawing_object_line, create_drawing_object_rectangle2,
    create_drawing_object_circle, create_drawing_object_text

    Successors
    ----------
    detach_drawing_object_from_window, get_drawing_object_params,
    get_drawing_object_iconic

    Notes
    -----
    Note that using any synchronous operator which actively probe the
    event queue, e.g., get_mbutton or read_char, will conflict with the
    interaction with the drawing objects. In case you need to read the
    state of the cursor, please refer to the documentation of your
    framework of choice for an appropriate, non-invasive alternative.
    Furthermore, the event based functionality should not be used together
    with the former blocking operators draw_rectangle1, draw_rectangle2,
    draw_region, draw_xld or draw_circle. They conflict with the event
    based functionality, since they actively fetch all events sent to the
    HALCON window.
    When working under UNIX/Linux it is necessary to turn on the support
    for multithreading in the Xlib. This is achieved by calling the
    function XInitThreads() before any other function of the Xlib library.
    This means that you need to call it before any other function or
    method of your graphical development environment of choice.  See the
    documentation of the function XInitThreads() in the corresponding
    manual page for further details.
    """
    with HalconOperator(1166) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, draw_handle)
        proc.execute()


def auto_threshold(image: HObject, sigma: Union[int, float]) -> HObject:
    """
    Segment an image using thresholds determined from its histogram.

    Parameters
    ----------

    image : HObject
            Input image.

    sigma : Union[int, float]
            Sigma for the Gaussian smoothing of the histogram.
            Value Suggestion: 2.0
            Assertion: Sigma >= 0.0

    Returns
    -------

    regions : HObject
              Regions with gray values within the automatically determined
              intervals.

    See Also
    --------
    gray_histo, gray_histo_abs, histo_to_thresh, smooth_funct_1d_gauss,
    threshold

    Alternatives
    ------------
    binary_threshold, char_threshold

    Predecessors
    ------------
    anisotropic_diffusion, median_image, illuminate

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(472) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sigma)
        proc.execute()
        regions = HObject(proc.get_output_object_key(1))
        return regions  # type: ignore


def axis_angle_to_quat(
    axis_x: Union[float, int],
    axis_y: Union[float, int],
    axis_z: Union[float, int],
    angle: Union[float, int]
) -> Sequence[Union[float, int]]:
    """
    Create a rotation quaternion.

    Parameters
    ----------

    axis_x : Union[float, int]
             X component of the rotation axis.

    axis_y : Union[float, int]
             Y component of the rotation axis.

    axis_z : Union[float, int]
             Z component of the rotation axis.

    angle : Union[float, int]
            Rotation angle in radians.

    Returns
    -------

    quaternion : Sequence[Union[float, int]]
                 Rotation quaternion.

    See Also
    --------
    quat_normalize, quat_conjugate, quat_interpolate, screw_to_dual_quat

    Successors
    ----------
    quat_to_hom_mat3d, quat_to_pose, quat_rotate_point_3d, quat_compose

    Notes
    -----
    The operator axis_angle_to_quat does not check whether the vector
    (AxisX, AxisY, AxisZ) is of unit length (i.e. of length 1). If this is
    not the case, Quaternion will be no valid rotation quaternion.
    """
    with HalconOperator(225) as proc:
        proc.set_input_tuple(0, axis_x)
        proc.set_input_tuple(1, axis_y)
        proc.set_input_tuple(2, axis_z)
        proc.set_input_tuple(3, angle)
        proc.init_oct(0)
        proc.execute()
        quaternion = proc.get_output_tuple_m(0)
        return quaternion  # type: ignore


def background_seg(foreground: HObject) -> HObject:
    """
    Determine the connected components of the background of given regions.

    Parameters
    ----------

    foreground : HObject
                 Input regions.

    Returns
    -------

    background_regions : HObject
                         Connected components of the background.

    See Also
    --------
    threshold, hysteresis_threshold, skeleton, expand_region, set_system,
    sobel_amp, edges_image, roberts, bandpass_image

    Alternatives
    ------------
    complement, connection

    Predecessors
    ------------
    threshold, connection, regiongrowing, pouring, class_ndim_norm

    Successors
    ----------
    select_shape
    """
    with HalconOperator(505) as proc:
        proc.set_input_object(1, foreground)
        proc.execute()
        background_regions = HObject(proc.get_output_object_key(1))
        return background_regions  # type: ignore


def bandpass_image(image: HObject, filter_type: str) -> HObject:
    """
    Edge extraction using bandpass filters.

    Parameters
    ----------

    image : HObject
            Input images.

    filter_type : str
                  Filter type: currently only 'lines' is supported.
                  Value Suggestion: lines

    Returns
    -------

    image_bandpass : HObject
                     Bandpass-filtered images.

    See Also
    --------
    highpass_image, gray_skeleton

    Alternatives
    ------------
    convol_image, topographic_sketch, texture_laws

    Successors
    ----------
    threshold, skeleton

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1510) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, filter_type)
        proc.execute()
        image_bandpass = HObject(proc.get_output_object_key(1))
        return image_bandpass  # type: ignore


def best_match(
    image: HObject,
    template_id: HHandle,
    max_error: float,
    sub_pixel: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Searching the best matching of a template and an image.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 20.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    Returns
    -------

    row : Sequence[float]
          Row position of the best match.

    column : Sequence[float]
             Column position of the best match.

    error : Sequence[float]
            Average divergence of the gray values of the best match.

    Alternatives
    ------------
    fast_match, fast_match_mg, best_match_mg, best_match_pre_mg,
    best_match_rot, best_match_rot_mg, exhaustive_match,
    exhaustive_match_mg

    Predecessors
    ------------
    create_template, read_template, set_offset_template,
    set_reference_template, adapt_template, draw_region, draw_rectangle1,
    reduce_domain

    Warnings
    --------
    best_match is obsolete and is only provided for reasons of backward
    compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1505) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, max_error)
        proc.set_input_tuple(2, sub_pixel)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row
            proc.get_output_tuple_m(1),  # column
            proc.get_output_tuple_m(2)   # error
        )  # type: ignore


def best_match_mg(
    image: HObject,
    template_id: HHandle,
    max_error: float,
    sub_pixel: str,
    num_levels: int,
    which_levels: Union[str, int]
) -> Tuple[float, float, float]:
    """
    Searching the best gray value matches in a pyramid.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    max_error : float
                Maximal average difference of the gray values.
                Value Suggestion: 30.0

    sub_pixel : str
                Exactness in subpixels in case of 'true'.
                Value Suggestion: false

    num_levels : int
                 Number of the used resolution levels.
                 Value Suggestion: 4

    which_levels : Union[str, int]
                   Resolution level up to which the method ``best match''
                   is used.
                   Value Suggestion: 2

    Returns
    -------

    row : float
          Row position of the best match.

    column : float
             Column position of the best match.

    error : float
            Average divergence of the gray values in the best match.

    Alternatives
    ------------
    fast_match, fast_match_mg, best_match, best_match_pre_mg,
    best_match_rot, best_match_rot_mg, exhaustive_match,
    exhaustive_match_mg

    Predecessors
    ------------
    create_template, read_template, adapt_template, draw_region,
    draw_rectangle1, reduce_domain, set_reference_template,
    set_offset_template

    Warnings
    --------
    best_match_mg is obsolete and is only provided for reasons of backward
    compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1501) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, max_error)
        proc.set_input_tuple(2, sub_pixel)
        proc.set_input_tuple(3, num_levels)
        proc.set_input_tuple(4, which_levels)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row
            proc.get_output_tuple_s(1),  # column
            proc.get_output_tuple_s(2)   # error
        )  # type: ignore


def best_match_pre_mg(
    image_pyramid: HObject,
    template_id: HHandle,
    max_error: float,
    sub_pixel: str,
    num_levels: int,
    which_levels: Union[str, int]
) -> Tuple[float, float, float]:
    """
    Searching the best gray value matches in a pre generated pyramid.

    Parameters
    ----------

    image_pyramid : HObject
                    Image pyramid inside of which the pattern has to be
                    found.

    template_id : HHandle
                  Template number.

    max_error : float
                Maximal average difference of the gray values.
                Value Suggestion: 30.0

    sub_pixel : str
                Exactness in subpixels in case of 'true'.
                Value Suggestion: false

    num_levels : int
                 Number of the used resolution levels.
                 Value Suggestion: 3

    which_levels : Union[str, int]
                   Resolution level up to which the method ``best match''
                   is used.
                   Value Suggestion: original

    Returns
    -------

    row : float
          Row position of the best match.

    column : float
             Column position of the best match.

    error : float
            Average divergence of the gray values in the best match.

    Alternatives
    ------------
    fast_match, fast_match_mg, exhaustive_match, exhaustive_match_mg

    Predecessors
    ------------
    gen_gauss_pyramid, create_template, read_template, adapt_template,
    draw_region, draw_rectangle1, reduce_domain, set_reference_template

    Warnings
    --------
    best_match_pre_mg is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1500) as proc:
        proc.set_input_object(1, image_pyramid)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, max_error)
        proc.set_input_tuple(2, sub_pixel)
        proc.set_input_tuple(3, num_levels)
        proc.set_input_tuple(4, which_levels)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row
            proc.get_output_tuple_s(1),  # column
            proc.get_output_tuple_s(2)   # error
        )  # type: ignore


def best_match_rot(
    image: HObject,
    template_id: HHandle,
    angle_start: float,
    angle_extend: float,
    max_error: float,
    sub_pixel: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Searching the best matching of a template and an image with rotation.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    angle_start : float
                  Smallest Rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extend : float
                   Maximum positive Extension of AngleStart.
                   Value Suggestion: 0.79
                   Assertion: AngleExtend > 0

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 30.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    Returns
    -------

    row : Sequence[float]
          Row position of the best match.

    column : Sequence[float]
             Column position of the best match.

    angle : Sequence[float]
            Rotation angle of pattern.

    error : Sequence[float]
            Average divergence of the gray values of the best match.

    See Also
    --------
    best_match, best_match_mg

    Alternatives
    ------------
    best_match_rot_mg

    Predecessors
    ------------
    create_template_rot, read_template, set_offset_template,
    set_reference_template, adapt_template, draw_region, draw_rectangle1,
    reduce_domain

    Warnings
    --------
    best_match_rot is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1504) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extend)
        proc.set_input_tuple(3, max_error)
        proc.set_input_tuple(4, sub_pixel)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row
            proc.get_output_tuple_m(1),  # column
            proc.get_output_tuple_m(2),  # angle
            proc.get_output_tuple_m(3)   # error
        )  # type: ignore


def best_match_rot_mg(
    image: HObject,
    template_id: HHandle,
    angle_start: float,
    angle_extend: float,
    max_error: float,
    sub_pixel: str,
    num_levels: int
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Searching the best matching of a template and a pyramid with rotation.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    angle_start : float
                  Smallest Rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extend : float
                   Maximum positive Extension of AngleStart.
                   Value Suggestion: 0.79
                   Assertion: AngleExtend > 0

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 40.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    num_levels : int
                 Number of the used resolution levels.
                 Value Suggestion: 3

    Returns
    -------

    row : Sequence[float]
          Row position of the best match.

    column : Sequence[float]
             Column position of the best match.

    angle : Sequence[float]
            Rotation angle of pattern.

    error : Sequence[float]
            Average divergence of the gray values of the best match.

    See Also
    --------
    fast_match

    Alternatives
    ------------
    best_match_rot, best_match_mg, find_ncc_model, find_ncc_models

    Predecessors
    ------------
    create_template_rot, set_reference_template, set_offset_template,
    adapt_template, draw_region, draw_rectangle1, reduce_domain

    Warnings
    --------
    best_match_rot_mg is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1503) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extend)
        proc.set_input_tuple(3, max_error)
        proc.set_input_tuple(4, sub_pixel)
        proc.set_input_tuple(5, num_levels)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row
            proc.get_output_tuple_m(1),  # column
            proc.get_output_tuple_m(2),  # angle
            proc.get_output_tuple_m(3)   # error
        )  # type: ignore


def best_match_rot_mg_s(
    image: HObject,
    template_id: HHandle,
    angle_start: float,
    angle_extend: float,
    max_error: float,
    sub_pixel: str,
    num_levels: int
) -> Tuple[float, float, float, float]:
    """
    Searching the best matching of a template and a pyramid with rotation.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    angle_start : float
                  Smallest Rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extend : float
                   Maximum positive Extension of AngleStart.
                   Value Suggestion: 0.79
                   Assertion: AngleExtend > 0

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 40.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    num_levels : int
                 Number of the used resolution levels.
                 Value Suggestion: 3

    Returns
    -------

    row : float
          Row position of the best match.

    column : float
             Column position of the best match.

    angle : float
            Rotation angle of pattern.

    error : float
            Average divergence of the gray values of the best match.

    See Also
    --------
    fast_match

    Alternatives
    ------------
    best_match_rot, best_match_mg, find_ncc_model, find_ncc_models

    Predecessors
    ------------
    create_template_rot, set_reference_template, set_offset_template,
    adapt_template, draw_region, draw_rectangle1, reduce_domain

    Warnings
    --------
    best_match_rot_mg is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1503) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extend)
        proc.set_input_tuple(3, max_error)
        proc.set_input_tuple(4, sub_pixel)
        proc.set_input_tuple(5, num_levels)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row
            proc.get_output_tuple_s(1),  # column
            proc.get_output_tuple_s(2),  # angle
            proc.get_output_tuple_s(3)   # error
        )  # type: ignore


def best_match_rot_s(
    image: HObject,
    template_id: HHandle,
    angle_start: float,
    angle_extend: float,
    max_error: float,
    sub_pixel: str
) -> Tuple[float, float, float, float]:
    """
    Searching the best matching of a template and an image with rotation.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    angle_start : float
                  Smallest Rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extend : float
                   Maximum positive Extension of AngleStart.
                   Value Suggestion: 0.79
                   Assertion: AngleExtend > 0

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 30.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    Returns
    -------

    row : float
          Row position of the best match.

    column : float
             Column position of the best match.

    angle : float
            Rotation angle of pattern.

    error : float
            Average divergence of the gray values of the best match.

    See Also
    --------
    best_match, best_match_mg

    Alternatives
    ------------
    best_match_rot_mg

    Predecessors
    ------------
    create_template_rot, read_template, set_offset_template,
    set_reference_template, adapt_template, draw_region, draw_rectangle1,
    reduce_domain

    Warnings
    --------
    best_match_rot is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1504) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extend)
        proc.set_input_tuple(3, max_error)
        proc.set_input_tuple(4, sub_pixel)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row
            proc.get_output_tuple_s(1),  # column
            proc.get_output_tuple_s(2),  # angle
            proc.get_output_tuple_s(3)   # error
        )  # type: ignore


def best_match_s(
    image: HObject,
    template_id: HHandle,
    max_error: float,
    sub_pixel: str
) -> Tuple[float, float, float]:
    """
    Searching the best matching of a template and an image.

    Parameters
    ----------

    image : HObject
            Input image inside of which the pattern has to be found.

    template_id : HHandle
                  Template number.

    max_error : float
                Maximum average difference of the gray values.
                Value Suggestion: 20.0

    sub_pixel : str
                Subpixel accuracy in case of 'true'.
                Value Suggestion: false

    Returns
    -------

    row : float
          Row position of the best match.

    column : float
             Column position of the best match.

    error : float
            Average divergence of the gray values of the best match.

    Alternatives
    ------------
    fast_match, fast_match_mg, best_match_mg, best_match_pre_mg,
    best_match_rot, best_match_rot_mg, exhaustive_match,
    exhaustive_match_mg

    Predecessors
    ------------
    create_template, read_template, set_offset_template,
    set_reference_template, adapt_template, draw_region, draw_rectangle1,
    reduce_domain

    Warnings
    --------
    best_match is obsolete and is only provided for reasons of backward
    compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1505) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, template_id)
        proc.set_input_tuple(1, max_error)
        proc.set_input_tuple(2, sub_pixel)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row
            proc.get_output_tuple_s(1),  # column
            proc.get_output_tuple_s(2)   # error
        )  # type: ignore


def bilateral_filter(
    image: HObject,
    image_joint: HObject,
    sigma_spatial: float,
    sigma_range: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HObject:
    """
    bilateral filtering of an image.

    Parameters
    ----------

    image : HObject
            Image to be filtered.

    image_joint : HObject
                  Joint image.

    sigma_spatial : float
                    Size of the Gaussian of the closeness function.
                    Value Suggestion: 3.0
                    Assertion: SigmaSpatial > 0.6

    sigma_range : float
                  Size of the Gaussian of the similarity function.
                  Value Suggestion: 20.0
                  Assertion: SigmaRange > 0.0001

    gen_param_name : MaybeSequence[str]
                     Generic parameter name.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic parameter value.
                      Value Suggestion: []

    Returns
    -------

    image_bilateral : HObject
                      Filtered output image.

    Alternatives
    ------------
    guided_filter, anisotropic_diffusion, median_image

    Predecessors
    ------------
    read_image

    Successors
    ----------
    threshold, dyn_threshold, var_threshold, regiongrowing
    """
    with HalconOperator(2045) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, image_joint)
        proc.set_input_tuple(0, sigma_spatial)
        proc.set_input_tuple(1, sigma_range)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.execute()
        image_bilateral = HObject(proc.get_output_object_key(1))
        return image_bilateral  # type: ignore


def bin_threshold(image: HObject) -> HObject:
    """
    Segment an image using an automatically determined threshold.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    region : HObject
             Dark regions of the image.

    Warnings
    --------
    bin_threshold is obsolete and is only provided for reasons of backward
    compatibility.  New applications should use the operator
    binary_threshold instead.
    """
    with HalconOperator(473) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        region = HObject(proc.get_output_object_key(1))
        return region  # type: ignore


def binary_threshold(
    image: HObject,
    method: str,
    light_dark: str
) -> Tuple[HObject, Sequence[Union[str, int]]]:
    """
    Segment an image using binary thresholding.

    Parameters
    ----------

    image : HObject
            Input Image.

    method : str
             Segmentation method.
             Value Suggestion: max_separability

    light_dark : str
                 Extract foreground or background?
                 Value Suggestion: dark

    Returns
    -------

    region : HObject
             Segmented output region.

    used_threshold : Sequence[Union[str, int]]
                     Used threshold.

    See Also
    --------
    gray_histo, threshold

    Alternatives
    ------------
    auto_threshold, char_threshold, local_threshold

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(449) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, method)
        proc.set_input_tuple(1, light_dark)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # region
            proc.get_output_tuple_m(0)   # used_threshold
        )  # type: ignore


def binary_threshold_s(
    image: HObject,
    method: str,
    light_dark: str
) -> Tuple[HObject, Union[str, int]]:
    """
    Segment an image using binary thresholding.

    Parameters
    ----------

    image : HObject
            Input Image.

    method : str
             Segmentation method.
             Value Suggestion: max_separability

    light_dark : str
                 Extract foreground or background?
                 Value Suggestion: dark

    Returns
    -------

    region : HObject
             Segmented output region.

    used_threshold : Union[str, int]
                     Used threshold.

    See Also
    --------
    gray_histo, threshold

    Alternatives
    ------------
    auto_threshold, char_threshold, local_threshold

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(449) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, method)
        proc.set_input_tuple(1, light_dark)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # region
            proc.get_output_tuple_s(0)   # used_threshold
        )  # type: ignore


def binocular_calibration(
    nx: Sequence[Union[float, int]],
    ny: Sequence[Union[float, int]],
    nz: Sequence[Union[float, int]],
    nrow_1: Sequence[Union[float, int]],
    ncol_1: Sequence[Union[float, int]],
    nrow_2: Sequence[Union[float, int]],
    ncol_2: Sequence[Union[float, int]],
    start_cam_param_1: Sequence[Union[float, int, str]],
    start_cam_param_2: Sequence[Union[float, int, str]],
    nstart_pose_1: Sequence[Union[float, int]],
    nstart_pose_2: Sequence[Union[float, int]],
    estimate_params: Sequence[str]
) -> Tuple[Sequence[Union[float, int, str]], Sequence[Union[float, int, str]], Sequence[Union[float, int]], Sequence[Union[float, int]], Sequence[Union[float, int]], Sequence[float]]:
    """
    Determine all camera parameters of a binocular stereo system.

    Parameters
    ----------

    nx : Sequence[Union[float, int]]
         Ordered Tuple with all X-coordinates of the calibration marks (in
         meters).

    ny : Sequence[Union[float, int]]
         Ordered Tuple with all Y-coordinates of the calibration marks (in
         meters).

    nz : Sequence[Union[float, int]]
         Ordered Tuple with all Z-coordinates of the calibration marks (in
         meters).

    nrow_1 : Sequence[Union[float, int]]
             Ordered Tuple with all row-coordinates of the extracted
             calibration marks of camera 1 (in pixels).

    ncol_1 : Sequence[Union[float, int]]
             Ordered Tuple with all column-coordinates of the extracted
             calibration marks of camera 1 (in pixels).

    nrow_2 : Sequence[Union[float, int]]
             Ordered Tuple with all row-coordinates of the extracted
             calibration marks of camera 2 (in pixels).

    ncol_2 : Sequence[Union[float, int]]
             Ordered Tuple with all column-coordinates of the extracted
             calibration marks of camera 2 (in pixels).

    start_cam_param_1 : Sequence[Union[float, int, str]]
                        Initial values for the internal parameters of
                        camera 1.

    start_cam_param_2 : Sequence[Union[float, int, str]]
                        Initial values for the internal parameters of
                        camera 2.

    nstart_pose_1 : Sequence[Union[float, int]]
                    Ordered tuple with all initial values for the poses of
                    the calibration model in relation to camera 1.

    nstart_pose_2 : Sequence[Union[float, int]]
                    Ordered tuple with all initial values for the poses of
                    the calibration model in relation to camera 2.

    estimate_params : Sequence[str]
                      Camera parameters to be estimated.
                      Value Suggestion: all

    Returns
    -------

    cam_param_1 : Sequence[Union[float, int, str]]
                  Internal parameters of camera 1.

    cam_param_2 : Sequence[Union[float, int, str]]
                  Internal parameters of camera 2.

    nfinal_pose_1 : Sequence[Union[float, int]]
                    Ordered tuple with all poses of the calibration model
                    in relation to camera 1.

    nfinal_pose_2 : Sequence[Union[float, int]]
                    Ordered tuple with all poses of the calibration model
                    in relation to camera 2.

    rel_pose : Sequence[Union[float, int]]
               Pose of camera 2 in relation to camera 1.

    errors : Sequence[float]
             Average error distances in pixels.

    See Also
    --------
    find_caltab, sim_caltab, read_cam_par, create_pose, convert_pose_type,
    read_pose, hom_mat3d_to_pose, create_caltab, binocular_disparity,
    binocular_distance

    Predecessors
    ------------
    find_marks_and_pose, caltab_points, read_cam_par

    Successors
    ----------
    write_pose, write_cam_par, pose_to_hom_mat3d, disp_caltab,
    gen_binocular_rectification_map

    Notes
    -----
    Stereo setups that contain cameras with and without hypercentric
    lenses at the same time are not supported.  Furthermore, stereo setups
    that contain area scan and line scan cameras at the same time are not
    supported.
    """
    with HalconOperator(370) as proc:
        proc.set_input_tuple(0, nx)
        proc.set_input_tuple(1, ny)
        proc.set_input_tuple(2, nz)
        proc.set_input_tuple(3, nrow_1)
        proc.set_input_tuple(4, ncol_1)
        proc.set_input_tuple(5, nrow_2)
        proc.set_input_tuple(6, ncol_2)
        proc.set_input_tuple(7, start_cam_param_1)
        proc.set_input_tuple(8, start_cam_param_2)
        proc.set_input_tuple(9, nstart_pose_1)
        proc.set_input_tuple(10, nstart_pose_2)
        proc.set_input_tuple(11, estimate_params)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # cam_param_1
            proc.get_output_tuple_m(1),  # cam_param_2
            proc.get_output_tuple_m(2),  # nfinal_pose_1
            proc.get_output_tuple_m(3),  # nfinal_pose_2
            proc.get_output_tuple_m(4),  # rel_pose
            proc.get_output_tuple_m(5)   # errors
        )  # type: ignore


def binocular_calibration_s(
    nx: Sequence[Union[float, int]],
    ny: Sequence[Union[float, int]],
    nz: Sequence[Union[float, int]],
    nrow_1: Sequence[Union[float, int]],
    ncol_1: Sequence[Union[float, int]],
    nrow_2: Sequence[Union[float, int]],
    ncol_2: Sequence[Union[float, int]],
    start_cam_param_1: Sequence[Union[float, int, str]],
    start_cam_param_2: Sequence[Union[float, int, str]],
    nstart_pose_1: Sequence[Union[float, int]],
    nstart_pose_2: Sequence[Union[float, int]],
    estimate_params: Sequence[str]
) -> Tuple[Sequence[Union[float, int, str]], Sequence[Union[float, int, str]], Sequence[Union[float, int]], Sequence[Union[float, int]], Sequence[Union[float, int]], float]:
    """
    Determine all camera parameters of a binocular stereo system.

    Parameters
    ----------

    nx : Sequence[Union[float, int]]
         Ordered Tuple with all X-coordinates of the calibration marks (in
         meters).

    ny : Sequence[Union[float, int]]
         Ordered Tuple with all Y-coordinates of the calibration marks (in
         meters).

    nz : Sequence[Union[float, int]]
         Ordered Tuple with all Z-coordinates of the calibration marks (in
         meters).

    nrow_1 : Sequence[Union[float, int]]
             Ordered Tuple with all row-coordinates of the extracted
             calibration marks of camera 1 (in pixels).

    ncol_1 : Sequence[Union[float, int]]
             Ordered Tuple with all column-coordinates of the extracted
             calibration marks of camera 1 (in pixels).

    nrow_2 : Sequence[Union[float, int]]
             Ordered Tuple with all row-coordinates of the extracted
             calibration marks of camera 2 (in pixels).

    ncol_2 : Sequence[Union[float, int]]
             Ordered Tuple with all column-coordinates of the extracted
             calibration marks of camera 2 (in pixels).

    start_cam_param_1 : Sequence[Union[float, int, str]]
                        Initial values for the internal parameters of
                        camera 1.

    start_cam_param_2 : Sequence[Union[float, int, str]]
                        Initial values for the internal parameters of
                        camera 2.

    nstart_pose_1 : Sequence[Union[float, int]]
                    Ordered tuple with all initial values for the poses of
                    the calibration model in relation to camera 1.

    nstart_pose_2 : Sequence[Union[float, int]]
                    Ordered tuple with all initial values for the poses of
                    the calibration model in relation to camera 2.

    estimate_params : Sequence[str]
                      Camera parameters to be estimated.
                      Value Suggestion: all

    Returns
    -------

    cam_param_1 : Sequence[Union[float, int, str]]
                  Internal parameters of camera 1.

    cam_param_2 : Sequence[Union[float, int, str]]
                  Internal parameters of camera 2.

    nfinal_pose_1 : Sequence[Union[float, int]]
                    Ordered tuple with all poses of the calibration model
                    in relation to camera 1.

    nfinal_pose_2 : Sequence[Union[float, int]]
                    Ordered tuple with all poses of the calibration model
                    in relation to camera 2.

    rel_pose : Sequence[Union[float, int]]
               Pose of camera 2 in relation to camera 1.

    errors : float
             Average error distances in pixels.

    See Also
    --------
    find_caltab, sim_caltab, read_cam_par, create_pose, convert_pose_type,
    read_pose, hom_mat3d_to_pose, create_caltab, binocular_disparity,
    binocular_distance

    Predecessors
    ------------
    find_marks_and_pose, caltab_points, read_cam_par

    Successors
    ----------
    write_pose, write_cam_par, pose_to_hom_mat3d, disp_caltab,
    gen_binocular_rectification_map

    Notes
    -----
    Stereo setups that contain cameras with and without hypercentric
    lenses at the same time are not supported.  Furthermore, stereo setups
    that contain area scan and line scan cameras at the same time are not
    supported.
    """
    with HalconOperator(370) as proc:
        proc.set_input_tuple(0, nx)
        proc.set_input_tuple(1, ny)
        proc.set_input_tuple(2, nz)
        proc.set_input_tuple(3, nrow_1)
        proc.set_input_tuple(4, ncol_1)
        proc.set_input_tuple(5, nrow_2)
        proc.set_input_tuple(6, ncol_2)
        proc.set_input_tuple(7, start_cam_param_1)
        proc.set_input_tuple(8, start_cam_param_2)
        proc.set_input_tuple(9, nstart_pose_1)
        proc.set_input_tuple(10, nstart_pose_2)
        proc.set_input_tuple(11, estimate_params)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # cam_param_1
            proc.get_output_tuple_m(1),  # cam_param_2
            proc.get_output_tuple_m(2),  # nfinal_pose_1
            proc.get_output_tuple_m(3),  # nfinal_pose_2
            proc.get_output_tuple_m(4),  # rel_pose
            proc.get_output_tuple_s(5)   # errors
        )  # type: ignore


def binocular_disparity(
    image_rect_1: HObject,
    image_rect_2: HObject,
    method: str,
    mask_width: int,
    mask_height: int,
    texture_thresh: Union[float, int],
    min_disparity: int,
    max_disparity: int,
    num_levels: int,
    score_thresh: Union[float, int],
    filter: MaybeSequence[str],
    sub_disparity: str
) -> Tuple[HObject, HObject]:
    """
    Compute the disparities of a rectified image pair using correlation
    techniques.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    method : str
             Matching function.
             Value Suggestion: ncc

    mask_width : int
                 Width of the correlation window.
                 Value Suggestion: 11
                 Assertion: 3 <= MaskWidth && odd(MaskWidth)

    mask_height : int
                  Height of the correlation window.
                  Value Suggestion: 11
                  Assertion: 3 <= MaskHeight && odd(MaskHeight)

    texture_thresh : Union[float, int]
                     Variance threshold of textured image regions.
                     Value Suggestion: 0.0
                     Assertion: 0.0 <= TextureThresh

    min_disparity : int
                    Minimum of the expected disparities.
                    Value Suggestion: -30

    max_disparity : int
                    Maximum of the expected disparities.
                    Value Suggestion: 30

    num_levels : int
                 Number of pyramid levels.
                 Value Suggestion: 1
                 Assertion: 1 <= NumLevels

    score_thresh : Union[float, int]
                   Threshold of the correlation function.
                   Value Suggestion: 0.5

    filter : MaybeSequence[str]
             Downstream filters.
             Value Suggestion: none

    sub_disparity : str
                    Subpixel interpolation of disparities.
                    Value Suggestion: none

    Returns
    -------

    disparity : HObject
                Disparity map.

    score : HObject
            Evaluation of the disparity values.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration

    Alternatives
    ------------
    binocular_disparity_mg, binocular_disparity_ms, binocular_distance,
    binocular_distance_mg, binocular_distance_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold, disparity_to_distance, disparity_image_to_xyz
    """
    with HalconOperator(363) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, method)
        proc.set_input_tuple(1, mask_width)
        proc.set_input_tuple(2, mask_height)
        proc.set_input_tuple(3, texture_thresh)
        proc.set_input_tuple(4, min_disparity)
        proc.set_input_tuple(5, max_disparity)
        proc.set_input_tuple(6, num_levels)
        proc.set_input_tuple(7, score_thresh)
        proc.set_input_tuple(8, filter)
        proc.set_input_tuple(9, sub_disparity)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # disparity
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binocular_disparity_mg(
    image_rect_1: HObject,
    image_rect_2: HObject,
    gray_constancy: float,
    gradient_constancy: float,
    smoothness: float,
    initial_guess: float,
    calculate_score: str,
    mgparam_name: MaybeSequence[str],
    mgparam_value: MaybeSequence[Union[str, float, int]]
) -> Tuple[HObject, HObject]:
    """
    Compute the disparities of a rectified stereo image pair using
    multigrid methods.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    gray_constancy : float
                     Weight of the gray value constancy in the data term.
                     Value Suggestion: 1.0
                     Assertion: GrayConstancy >= 0.0

    gradient_constancy : float
                         Weight of the gradient constancy in the data term.
                         Value Suggestion: 30.0
                         Assertion: GradientConstancy >= 0.0

    smoothness : float
                 Weight of the smoothness term in relation to the data
                 term.
                 Value Suggestion: 5.0
                 Assertion: Smoothness > 0.0

    initial_guess : float
                    Initial guess of the disparity.
                    Value Suggestion: 0.0

    calculate_score : str
                      Should the quality measure should be returned in
                      Score?
                      Value Suggestion: false

    mgparam_name : MaybeSequence[str]
                   Parameter name(s) for the multigrid algorithm.
                   Value Suggestion: default_parameters

    mgparam_value : MaybeSequence[Union[str, float, int]]
                    Parameter value(s) for the multigrid algorithm.
                    Value Suggestion: fast_accurate

    Returns
    -------

    disparity : HObject
                Disparity map.

    score : HObject
            Score of the calculated disparity if CalculateScore is set to
            'true'.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration

    Alternatives
    ------------
    binocular_disparity, binocular_disparity_ms, binocular_distance,
    binocular_distance_mg, binocular_distance_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold, disparity_to_distance, disparity_image_to_xyz
    """
    with HalconOperator(349) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, gray_constancy)
        proc.set_input_tuple(1, gradient_constancy)
        proc.set_input_tuple(2, smoothness)
        proc.set_input_tuple(3, initial_guess)
        proc.set_input_tuple(4, calculate_score)
        proc.set_input_tuple(5, mgparam_name)
        proc.set_input_tuple(6, mgparam_value)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # disparity
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binocular_disparity_ms(
    image_rect_1: HObject,
    image_rect_2: HObject,
    min_disparity: int,
    max_disparity: int,
    surface_smoothing: int,
    edge_smoothing: int,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[str]
) -> Tuple[HObject, HObject]:
    """
    Compute the disparities of a rectified stereo image pair using
    multi-scanline optimization.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    min_disparity : int
                    Minimum of the expected disparities.
                    Value Suggestion: -30

    max_disparity : int
                    Maximum of the expected disparities.
                    Value Suggestion: 30
                    Assertion: MinDisparity <= MaxDisparity

    surface_smoothing : int
                        Smoothing of surfaces.
                        Value Suggestion: 50
                        Assertion: SurfaceSmoothing >= 0

    edge_smoothing : int
                     Smoothing of edges.
                     Value Suggestion: 50
                     Assertion: EdgeSmoothing >= 0

    gen_param_name : MaybeSequence[str]
                     Parameter name(s) for the multi-scanline algorithm.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[str]
                      Parameter value(s) for the multi-scanline algorithm.
                      Value Suggestion: []

    Returns
    -------

    disparity : HObject
                Disparity map.

    score : HObject
            Score of the calculated disparity.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration

    Alternatives
    ------------
    binocular_disparity, binocular_disparity_mg, binocular_distance,
    binocular_distance_mg, binocular_distance_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold, disparity_to_distance, disparity_image_to_xyz
    """
    with HalconOperator(347) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, min_disparity)
        proc.set_input_tuple(1, max_disparity)
        proc.set_input_tuple(2, surface_smoothing)
        proc.set_input_tuple(3, edge_smoothing)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # disparity
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binocular_distance(
    image_rect_1: HObject,
    image_rect_2: HObject,
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    method: str,
    mask_width: int,
    mask_height: int,
    texture_thresh: Union[float, int],
    min_disparity: int,
    max_disparity: int,
    num_levels: int,
    score_thresh: Union[float, int],
    filter: MaybeSequence[str],
    sub_distance: MaybeSequence[str]
) -> Tuple[HObject, HObject]:
    """
    Compute the distance values for a rectified stereo image pair using
    correlation techniques.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    method : str
             Matching function.
             Value Suggestion: ncc

    mask_width : int
                 Width of the correlation window.
                 Value Suggestion: 11
                 Assertion: 3 <= MaskWidth && odd(MaskWidth)

    mask_height : int
                  Height of the correlation window.
                  Value Suggestion: 11
                  Assertion: 3 <= MaskHeight && odd(MaskHeight)

    texture_thresh : Union[float, int]
                     Variance threshold of textured image regions.
                     Value Suggestion: 0.0
                     Assertion: 0.0 <= TextureThresh

    min_disparity : int
                    Minimum of the expected disparities.
                    Value Suggestion: 0

    max_disparity : int
                    Maximum of the expected disparities.
                    Value Suggestion: 30

    num_levels : int
                 Number of pyramid levels.
                 Value Suggestion: 1
                 Assertion: 1 <= NumLevels

    score_thresh : Union[float, int]
                   Threshold of the correlation function.
                   Value Suggestion: 0.0

    filter : MaybeSequence[str]
             Downstream filters.
             Value Suggestion: none

    sub_distance : MaybeSequence[str]
                   Distance interpolation.
                   Value Suggestion: none

    Returns
    -------

    distance : HObject
               Distance image.

    score : HObject
            Evaluation of a distance value.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration,
    distance_to_disparity, disparity_to_distance, disparity_image_to_xyz

    Alternatives
    ------------
    binocular_distance_mg, binocular_distance_ms, binocular_disparity,
    binocular_disparity_mg, binocular_disparity_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For a stereo setup of mixed type (i.e., for a stereo setup in which
    one of the original cameras is a perspective camera and the other
    camera is a telecentric camera; see gen_binocular_rectification_map),
    the rectifying plane of the two cameras is in a position with respect
    to the object that would lead to very unintuitive distances.
    Therefore, binocular_distance does not support a stereo setup of mixed
    type.  For stereo setups of mixed type, please use
    reconstruct_surface_stereo, in which the reference coordinate system
    can be chosen arbitrarily.  Alternatively, binocular_disparity and
    disparity_image_to_xyz might be used.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(362) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, method)
        proc.set_input_tuple(4, mask_width)
        proc.set_input_tuple(5, mask_height)
        proc.set_input_tuple(6, texture_thresh)
        proc.set_input_tuple(7, min_disparity)
        proc.set_input_tuple(8, max_disparity)
        proc.set_input_tuple(9, num_levels)
        proc.set_input_tuple(10, score_thresh)
        proc.set_input_tuple(11, filter)
        proc.set_input_tuple(12, sub_distance)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # distance
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binocular_distance_mg(
    image_rect_1: HObject,
    image_rect_2: HObject,
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    gray_constancy: float,
    gradient_constancy: float,
    smoothness: float,
    initial_guess: float,
    calculate_score: str,
    mgparam_name: MaybeSequence[str],
    mgparam_value: MaybeSequence[Union[str, float, int]]
) -> Tuple[HObject, HObject]:
    """
    Compute the distance values for a rectified stereo image pair using
    multigrid methods.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    gray_constancy : float
                     Weight of the gray value constancy in the data term.
                     Value Suggestion: 1.0
                     Assertion: GrayConstancy >= 0.0

    gradient_constancy : float
                         Weight of the gradient constancy in the data term.
                         Value Suggestion: 30.0
                         Assertion: GradientConstancy >= 0.0

    smoothness : float
                 Weight of the smoothness term in relation to the data
                 term.
                 Value Suggestion: 5.0
                 Assertion: Smoothness > 0.0

    initial_guess : float
                    Initial guess of the disparity.
                    Value Suggestion: 0.0

    calculate_score : str
                      Should the quality measure be returned in Score?
                      Value Suggestion: false

    mgparam_name : MaybeSequence[str]
                   Parameter name(s) for the multigrid algorithm.
                   Value Suggestion: default_parameters

    mgparam_value : MaybeSequence[Union[str, float, int]]
                    Parameter value(s) for the multigrid algorithm.
                    Value Suggestion: fast_accurate

    Returns
    -------

    distance : HObject
               Distance image.

    score : HObject
            Score of the calculated disparity if CalculateScore is set to
            'true'.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration,
    disparity_to_distance, distance_to_disparity, disparity_image_to_xyz

    Alternatives
    ------------
    binocular_distance, binocular_distance_ms, binocular_disparity,
    binocular_disparity_mg, binocular_disparity_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For a stereo setup of mixed type (i.e., for a stereo setup in which
    one of the original cameras is a perspective camera and the other
    camera is a telecentric camera; see gen_binocular_rectification_map),
    the rectifying plane of the two cameras is in a position with respect
    to the object that would lead to very unintuitive distances.
    Therefore, binocular_distance_mg does not support a stereo setup of
    mixed type.  For stereo setups of mixed type, please use
    reconstruct_surface_stereo, in which the reference coordinate system
    can be chosen arbitrarily.  Alternatively, binocular_disparity_mg and
    disparity_image_to_xyz might be used.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(348) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, gray_constancy)
        proc.set_input_tuple(4, gradient_constancy)
        proc.set_input_tuple(5, smoothness)
        proc.set_input_tuple(6, initial_guess)
        proc.set_input_tuple(7, calculate_score)
        proc.set_input_tuple(8, mgparam_name)
        proc.set_input_tuple(9, mgparam_value)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # distance
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binocular_distance_ms(
    image_rect_1: HObject,
    image_rect_2: HObject,
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    min_disparity: int,
    max_disparity: int,
    surface_smoothing: int,
    edge_smoothing: int,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[str, int]]
) -> Tuple[HObject, HObject]:
    """
    Compute the distance values for a rectified stereo image pair using
    multi-scanline optimization.

    Parameters
    ----------

    image_rect_1 : HObject
                   Rectified image of camera 1.

    image_rect_2 : HObject
                   Rectified image of camera 2.

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    min_disparity : int
                    Minimum of the expected disparities.
                    Value Suggestion: -30

    max_disparity : int
                    Maximum of the expected disparities.
                    Value Suggestion: 30
                    Assertion: MinDisparity <= MaxDisparity

    surface_smoothing : int
                        Smoothing of surfaces.
                        Value Suggestion: 50
                        Assertion: SurfaceSmoothing >= 0

    edge_smoothing : int
                     Smoothing of edges.
                     Value Suggestion: 50
                     Assertion: EdgeSmoothing >= 0

    gen_param_name : MaybeSequence[str]
                     Parameter name(s) for the multi-scanline algorithm.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[str, int]]
                      Parameter value(s) for the multi-scanline algorithm.
                      Value Suggestion: []

    Returns
    -------

    distance : HObject
               Distance image.

    score : HObject
            Score of the calculated disparity.

    See Also
    --------
    map_image, gen_binocular_rectification_map, binocular_calibration,
    disparity_to_distance, distance_to_disparity, disparity_image_to_xyz

    Alternatives
    ------------
    binocular_distance, binocular_distance_mg, binocular_disparity,
    binocular_disparity_mg, binocular_disparity_ms

    Predecessors
    ------------
    map_image

    Successors
    ----------
    threshold

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For a stereo setup of mixed type (i.e., for a stereo setup in which
    one of the original cameras is a perspective camera and the other
    camera is a telecentric camera; see gen_binocular_rectification_map),
    the rectifying plane of the two cameras is in a position with respect
    to the object that would lead to very unintuitive distances.
    Therefore, binocular_distance_ms does not support a stereo setup of
    mixed type.  For stereo setups of mixed type, please use
    reconstruct_surface_stereo, in which the reference coordinate system
    can be chosen arbitrarily.  Alternatively, binocular_disparity_ms and
    disparity_image_to_xyz might be used.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(346) as proc:
        proc.set_input_object(1, image_rect_1)
        proc.set_input_object(2, image_rect_2)
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, min_disparity)
        proc.set_input_tuple(4, max_disparity)
        proc.set_input_tuple(5, surface_smoothing)
        proc.set_input_tuple(6, edge_smoothing)
        proc.set_input_tuple(7, gen_param_name)
        proc.set_input_tuple(8, gen_param_value)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # distance
            HObject(proc.get_output_object_key(2))   # score
        )  # type: ignore


def binomial_filter(
    image: HObject,
    mask_width: int,
    mask_height: int
) -> HObject:
    """
    Smooth an image using the binomial filter.

    Parameters
    ----------

    image : HObject
            Input image.

    mask_width : int
                 Filter width.
                 Value Suggestion: 5

    mask_height : int
                  Filter height.
                  Value Suggestion: 5

    Returns
    -------

    image_binomial : HObject
                     Smoothed image.

    See Also
    --------
    mean_image, anisotropic_diffusion, sigma_image, gen_lowpass

    Alternatives
    ------------
    gauss_filter, smooth_image, derivate_gauss, isotropic_diffusion

    Predecessors
    ------------
    read_image, grab_image

    Successors
    ----------
    regiongrowing, threshold, sub_image, dyn_threshold, auto_threshold

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1420) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, mask_width)
        proc.set_input_tuple(1, mask_height)
        proc.execute()
        image_binomial = HObject(proc.get_output_object_key(1))
        return image_binomial  # type: ignore


def bit_and(image_1: HObject, image_2: HObject) -> HObject:
    """
    Bit-by-bit AND of all pixels of the input images.

    Parameters
    ----------

    image_1 : HObject
              Input image(s) 1.

    image_2 : HObject
              Input image(s) 2.

    Returns
    -------

    image_and : HObject
                Result image(s) by AND-operation.

    See Also
    --------
    bit_mask, add_image, max_image

    Alternatives
    ------------
    bit_mask, add_image, max_image
    """
    with HalconOperator(1592) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.execute()
        image_and = HObject(proc.get_output_object_key(1))
        return image_and  # type: ignore


def bit_lshift(image: HObject, shift: int) -> HObject:
    """
    Left shift of all pixels of the image.

    Parameters
    ----------

    image : HObject
            Input image(s).

    shift : int
            Shift value.
            Value Suggestion: 3
            Assertion: Shift >= 1 && Shift <= 31

    Returns
    -------

    image_lshift : HObject
                   Result image(s) by shift operation.

    See Also
    --------
    bit_rshift

    Alternatives
    ------------
    scale_image
    """
    with HalconOperator(1588) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, shift)
        proc.execute()
        image_lshift = HObject(proc.get_output_object_key(1))
        return image_lshift  # type: ignore


def bit_mask(image: HObject, bit_mask: int) -> HObject:
    """
    Logical ``AND'' of each pixel using a bit mask.

    Parameters
    ----------

    image : HObject
            Input image(s).

    bit_mask : int
               Bit field
               Value Suggestion: 128

    Returns
    -------

    image_mask : HObject
                 Result image(s) by combination with mask.

    See Also
    --------
    bit_and, bit_lshift

    Alternatives
    ------------
    bit_slice

    Successors
    ----------
    threshold, bit_or
    """
    with HalconOperator(1585) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, bit_mask)
        proc.execute()
        image_mask = HObject(proc.get_output_object_key(1))
        return image_mask  # type: ignore


def bit_not(image: HObject) -> HObject:
    """
    Complement all bits of the pixels.

    Parameters
    ----------

    image : HObject
            Input image(s).

    Returns
    -------

    image_not : HObject
                Result image(s) by complement operation.

    See Also
    --------
    bit_slice, bit_mask

    Alternatives
    ------------
    bit_or, bit_and, add_image
    """
    with HalconOperator(1589) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        image_not = HObject(proc.get_output_object_key(1))
        return image_not  # type: ignore


def bit_or(image_1: HObject, image_2: HObject) -> HObject:
    """
    Bit-by-bit OR of all pixels of the input images.

    Parameters
    ----------

    image_1 : HObject
              Input image(s) 1.

    image_2 : HObject
              Input image(s) 2.

    Returns
    -------

    image_or : HObject
               Result image(s) by OR-operation.

    See Also
    --------
    bit_xor, bit_and

    Alternatives
    ------------
    bit_and, add_image
    """
    with HalconOperator(1591) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.execute()
        image_or = HObject(proc.get_output_object_key(1))
        return image_or  # type: ignore


def bit_rshift(image: HObject, shift: int) -> HObject:
    """
    Right shift of all pixels of the image.

    Parameters
    ----------

    image : HObject
            Input image(s).

    shift : int
            shift value
            Value Suggestion: 3
            Assertion: Shift >= 1 && Shift <= 31

    Returns
    -------

    image_rshift : HObject
                   Result image(s) by shift operation.

    See Also
    --------
    bit_lshift

    Alternatives
    ------------
    scale_image
    """
    with HalconOperator(1587) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, shift)
        proc.execute()
        image_rshift = HObject(proc.get_output_object_key(1))
        return image_rshift  # type: ignore


def bit_slice(image: HObject, bit: int) -> HObject:
    """
    Extract a bit from the pixels.

    Parameters
    ----------

    image : HObject
            Input image(s).

    bit : int
          Bit to be selected.
          Value Suggestion: 8
          Assertion: Bit >= 1 && Bit <= 32

    Returns
    -------

    image_slice : HObject
                  Result image(s) by extraction.

    See Also
    --------
    bit_and, bit_lshift

    Alternatives
    ------------
    bit_mask

    Successors
    ----------
    threshold, bit_or
    """
    with HalconOperator(1586) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, bit)
        proc.execute()
        image_slice = HObject(proc.get_output_object_key(1))
        return image_slice  # type: ignore


def bit_xor(image_1: HObject, image_2: HObject) -> HObject:
    """
    Bit-by-bit XOR of all pixels of the input images.

    Parameters
    ----------

    image_1 : HObject
              Input image(s) 1.

    image_2 : HObject
              Input image(s) 2.

    Returns
    -------

    image_xor : HObject
                Result image(s) by XOR-operation.

    See Also
    --------
    bit_or, bit_and

    Alternatives
    ------------
    bit_or, bit_and, add_image
    """
    with HalconOperator(1590) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.execute()
        image_xor = HObject(proc.get_output_object_key(1))
        return image_xor  # type: ignore


def bottom_hat(region: HObject, struct_element: HObject) -> HObject:
    """
    Compute the bottom hat of regions.

    Parameters
    ----------

    region : HObject
             Regions to be processed.

    struct_element : HObject
                     Structuring element (position independent).

    Returns
    -------

    region_bottom_hat : HObject
                        Result of the bottom hat operator.

    See Also
    --------
    top_hat, gray_bothat, opening

    Alternatives
    ------------
    closing, difference

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm, gen_circle, gen_ellipse, gen_rectangle1,
    gen_rectangle2, draw_region, gen_region_points,
    gen_region_polygon_filled

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection
    """
    with HalconOperator(753) as proc:
        proc.set_input_object(1, region)
        proc.set_input_object(2, struct_element)
        proc.execute()
        region_bottom_hat = HObject(proc.get_output_object_key(1))
        return region_bottom_hat  # type: ignore


def boundary(region: HObject, boundary_type: str) -> HObject:
    """
    Reduce a region to its boundary.

    Parameters
    ----------

    region : HObject
             Regions for which the boundary is to be computed.

    boundary_type : str
                    Boundary type.
                    Value Suggestion: inner

    Returns
    -------

    region_border : HObject
                    Resulting boundaries.

    See Also
    --------
    fill_up

    Alternatives
    ------------
    dilation_circle, erosion_circle, difference

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection
    """
    with HalconOperator(736) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, boundary_type)
        proc.execute()
        region_border = HObject(proc.get_output_object_key(1))
        return region_border  # type: ignore


def broadcast_condition(condition_handle: HHandle) -> None:
    """
    Signal a condition synchronization object.

    Parameters
    ----------

    condition_handle : HHandle
                       Condition synchronization object.

    See Also
    --------
    wait_condition, timed_wait_condition

    Predecessors
    ------------
    create_condition, wait_condition
    """
    with HalconOperator(544) as proc:
        proc.set_input_tuple(0, condition_handle)
        proc.execute()


def bundle_adjust_mosaic(
    num_images: int,
    reference_image: int,
    mapping_source: Sequence[int],
    mapping_dest: Sequence[int],
    hom_matrices_2d: Sequence[float],
    rows_1: Sequence[Union[float, int]],
    cols_1: Sequence[Union[float, int]],
    rows_2: Sequence[Union[float, int]],
    cols_2: Sequence[Union[float, int]],
    num_correspondences: Sequence[int],
    transformation: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Perform a bundle adjustment of an image mosaic.

    Parameters
    ----------

    num_images : int
                 Number of different images that are used for the
                 calibration.
                 Assertion: NumImages >= 2

    reference_image : int
                      Index of the reference image.

    mapping_source : Sequence[int]
                     Indices of the source images of the transformations.

    mapping_dest : Sequence[int]
                   Indices of the target images of the transformations.

    hom_matrices_2d : Sequence[float]
                      Array of $3- projective transformation matrices.

    rows_1 : Sequence[Union[float, int]]
             Row coordinates of corresponding points in the respective
             source images.

    cols_1 : Sequence[Union[float, int]]
             Column coordinates of corresponding points in the respective
             source images.

    rows_2 : Sequence[Union[float, int]]
             Row coordinates of corresponding points in the respective
             destination images.

    cols_2 : Sequence[Union[float, int]]
             Column coordinates of corresponding points in the respective
             destination images.

    num_correspondences : Sequence[int]
                          Number of point correspondences in the
                          respective image pair.

    transformation : str
                     Transformation class to be used.
                     Value Suggestion: projective

    Returns
    -------

    mosaic_matrices_2d : Sequence[float]
                         Array of $3- projective transformation matrices
                         that determine the position of the images in the
                         mosaic.

    rows : Sequence[float]
           Row coordinates of the points reconstructed by the bundle
           adjustment.

    cols : Sequence[float]
           Column coordinates of the points reconstructed by the bundle
           adjustment.

    error : Sequence[float]
            Average error per reconstructed point.

    See Also
    --------
    gen_projective_mosaic

    Predecessors
    ------------
    proj_match_points_ransac, proj_match_points_ransac_guided

    Successors
    ----------
    gen_bundle_adjusted_mosaic
    """
    with HalconOperator(255) as proc:
        proc.set_input_tuple(0, num_images)
        proc.set_input_tuple(1, reference_image)
        proc.set_input_tuple(2, mapping_source)
        proc.set_input_tuple(3, mapping_dest)
        proc.set_input_tuple(4, hom_matrices_2d)
        proc.set_input_tuple(5, rows_1)
        proc.set_input_tuple(6, cols_1)
        proc.set_input_tuple(7, rows_2)
        proc.set_input_tuple(8, cols_2)
        proc.set_input_tuple(9, num_correspondences)
        proc.set_input_tuple(10, transformation)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # mosaic_matrices_2d
            proc.get_output_tuple_m(1),  # rows
            proc.get_output_tuple_m(2),  # cols
            proc.get_output_tuple_m(3)   # error
        )  # type: ignore


def bundle_adjust_mosaic_s(
    num_images: int,
    reference_image: int,
    mapping_source: Sequence[int],
    mapping_dest: Sequence[int],
    hom_matrices_2d: Sequence[float],
    rows_1: Sequence[Union[float, int]],
    cols_1: Sequence[Union[float, int]],
    rows_2: Sequence[Union[float, int]],
    cols_2: Sequence[Union[float, int]],
    num_correspondences: Sequence[int],
    transformation: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], float]:
    """
    Perform a bundle adjustment of an image mosaic.

    Parameters
    ----------

    num_images : int
                 Number of different images that are used for the
                 calibration.
                 Assertion: NumImages >= 2

    reference_image : int
                      Index of the reference image.

    mapping_source : Sequence[int]
                     Indices of the source images of the transformations.

    mapping_dest : Sequence[int]
                   Indices of the target images of the transformations.

    hom_matrices_2d : Sequence[float]
                      Array of $3- projective transformation matrices.

    rows_1 : Sequence[Union[float, int]]
             Row coordinates of corresponding points in the respective
             source images.

    cols_1 : Sequence[Union[float, int]]
             Column coordinates of corresponding points in the respective
             source images.

    rows_2 : Sequence[Union[float, int]]
             Row coordinates of corresponding points in the respective
             destination images.

    cols_2 : Sequence[Union[float, int]]
             Column coordinates of corresponding points in the respective
             destination images.

    num_correspondences : Sequence[int]
                          Number of point correspondences in the
                          respective image pair.

    transformation : str
                     Transformation class to be used.
                     Value Suggestion: projective

    Returns
    -------

    mosaic_matrices_2d : Sequence[float]
                         Array of $3- projective transformation matrices
                         that determine the position of the images in the
                         mosaic.

    rows : Sequence[float]
           Row coordinates of the points reconstructed by the bundle
           adjustment.

    cols : Sequence[float]
           Column coordinates of the points reconstructed by the bundle
           adjustment.

    error : float
            Average error per reconstructed point.

    See Also
    --------
    gen_projective_mosaic

    Predecessors
    ------------
    proj_match_points_ransac, proj_match_points_ransac_guided

    Successors
    ----------
    gen_bundle_adjusted_mosaic
    """
    with HalconOperator(255) as proc:
        proc.set_input_tuple(0, num_images)
        proc.set_input_tuple(1, reference_image)
        proc.set_input_tuple(2, mapping_source)
        proc.set_input_tuple(3, mapping_dest)
        proc.set_input_tuple(4, hom_matrices_2d)
        proc.set_input_tuple(5, rows_1)
        proc.set_input_tuple(6, cols_1)
        proc.set_input_tuple(7, rows_2)
        proc.set_input_tuple(8, cols_2)
        proc.set_input_tuple(9, num_correspondences)
        proc.set_input_tuple(10, transformation)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # mosaic_matrices_2d
            proc.get_output_tuple_m(1),  # rows
            proc.get_output_tuple_m(2),  # cols
            proc.get_output_tuple_s(3)   # error
        )  # type: ignore


def calibrate_cameras(calib_data_id: HHandle) -> float:
    """
    Determine all camera parameters by a simultaneous minimization process.

    Parameters
    ----------

    calib_data_id : HHandle
                    Handle of a calibration data model.

    Returns
    -------

    error : float
            Back projection root mean square error (RMSE) of the
            optimization.

    Predecessors
    ------------
    create_calib_data, set_calib_data_cam_param,
    set_calib_data_calib_object, set_calib_data_observ_points,
    find_calib_object, set_calib_data, remove_calib_data_observ

    Successors
    ----------
    get_calib_data
    """
    with HalconOperator(1966) as proc:
        proc.set_input_tuple(0, calib_data_id)
        proc.init_oct(0)
        proc.execute()
        error = proc.get_output_tuple_s(0)
        return error  # type: ignore


def calibrate_hand_eye(calib_data_id: HHandle) -> Sequence[float]:
    """
    Perform a hand-eye calibration.

    Parameters
    ----------

    calib_data_id : HHandle
                    Handle of a calibration data model.

    Returns
    -------

    errors : Sequence[float]
             Average residual error of the optimization.

    Predecessors
    ------------
    create_calib_data, set_calib_data_cam_param,
    set_calib_data_calib_object, set_calib_data_observ_pose,
    find_calib_object, set_calib_data, remove_calib_data,
    remove_calib_data_observ

    Successors
    ----------
    get_calib_data
    """
    with HalconOperator(1965) as proc:
        proc.set_input_tuple(0, calib_data_id)
        proc.init_oct(0)
        proc.execute()
        errors = proc.get_output_tuple_m(0)
        return errors  # type: ignore


def calibrate_sheet_of_light(sheet_of_light_model_id: HHandle) -> float:
    """
    Calibrate a sheet-of-light setup with a 3D calibration object.

    Parameters
    ----------

    sheet_of_light_model_id : HHandle
                              Handle of the sheet-of-light model.

    Returns
    -------

    error : float
            Average back projection error of the optimization.

    Predecessors
    ------------
    create_sheet_of_light_model, set_sheet_of_light_param,
    set_profile_sheet_of_light, measure_profile_sheet_of_light

    Successors
    ----------
    set_profile_sheet_of_light, apply_sheet_of_light_calibration
    """
    with HalconOperator(379) as proc:
        proc.set_input_tuple(0, sheet_of_light_model_id)
        proc.init_oct(0)
        proc.execute()
        error = proc.get_output_tuple_s(0)
        return error  # type: ignore


def caltab_points(
    cal_plate_descr: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Read the mark center points from the calibration plate description
    file.

    Parameters
    ----------

    cal_plate_descr : str
                      File name of the calibration plate description.
                      Value Suggestion: calplate_320mm.cpd

    Returns
    -------

    x : Sequence[float]
        X coordinates of the mark center points in the coordinate system
        of the calibration plate.

    y : Sequence[float]
        Y coordinates of the mark center points in the coordinate system
        of the calibration plate.

    z : Sequence[float]
        Z coordinates of the mark center points in the coordinate system
        of the calibration plate.

    See Also
    --------
    find_caltab, find_marks_and_pose, camera_calibration, disp_caltab,
    sim_caltab, project_3d_point, get_line_of_sight, gen_caltab

    Successors
    ----------
    camera_calibration
    """
    with HalconOperator(1928) as proc:
        proc.set_input_tuple(0, cal_plate_descr)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # x
            proc.get_output_tuple_m(1),  # y
            proc.get_output_tuple_m(2)   # z
        )  # type: ignore


def cam_mat_to_cam_par(
    camera_matrix: Sequence[float],
    kappa: float,
    image_width: int,
    image_height: int
) -> Sequence[Union[int, float, str]]:
    """
    Compute the internal camera parameters from a camera matrix.

    Parameters
    ----------

    camera_matrix : Sequence[float]
                    $3- projective camera matrix that determines the
                    internal camera parameters.

    kappa : float
            Kappa.

    image_width : int
                  Width of the images that correspond to CameraMatrix.
                  Assertion: ImageWidth > 0

    image_height : int
                   Height of the images that correspond to CameraMatrix.
                   Assertion: ImageHeight > 0

    Returns
    -------

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    See Also
    --------
    camera_calibration, cam_par_to_cam_mat

    Predecessors
    ------------
    stationary_camera_self_calibration
    """
    with HalconOperator(1906) as proc:
        proc.set_input_tuple(0, camera_matrix)
        proc.set_input_tuple(1, kappa)
        proc.set_input_tuple(2, image_width)
        proc.set_input_tuple(3, image_height)
        proc.init_oct(0)
        proc.execute()
        camera_param = proc.get_output_tuple_m(0)
        return camera_param  # type: ignore


def cam_par_pose_to_hom_mat3d(
    camera_param: Sequence[Union[int, float, str]],
    pose: Sequence[Union[int, float]]
) -> Sequence[float]:
    """
    Convert internal camera parameters and a 3D pose into a 3×4
    projection matrix.

    Parameters
    ----------

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    pose : Sequence[Union[int, float]]
           3D pose.

    Returns
    -------

    hom_mat_3d : Sequence[float]
                 3×4 projection matrix.

    See Also
    --------
    create_pose, hom_mat3d_to_pose, project_3d_point, get_line_of_sight

    Predecessors
    ------------
    calibrate_cameras, change_radial_distortion_cam_par

    Successors
    ----------
    project_point_hom_mat3d, project_hom_point_hom_mat3d
    """
    with HalconOperator(1933) as proc:
        proc.set_input_tuple(0, camera_param)
        proc.set_input_tuple(1, pose)
        proc.init_oct(0)
        proc.execute()
        hom_mat_3d = proc.get_output_tuple_m(0)
        return hom_mat_3d  # type: ignore


def cam_par_to_cam_mat(
    camera_param: Sequence[Union[int, float, str]]
) -> Tuple[Sequence[float], int, int]:
    """
    Compute a camera matrix from internal camera parameters.

    Parameters
    ----------

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    Returns
    -------

    camera_matrix : Sequence[float]
                    $3- projective camera matrix that corresponds to
                    CameraParam.

    image_width : int
                  Width of the images that correspond to CameraMatrix.
                  Assertion: ImageWidth > 0

    image_height : int
                   Height of the images that correspond to CameraMatrix.
                   Assertion: ImageHeight > 0

    See Also
    --------
    stationary_camera_self_calibration, cam_mat_to_cam_par

    Predecessors
    ------------
    camera_calibration
    """
    with HalconOperator(1905) as proc:
        proc.set_input_tuple(0, camera_param)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # camera_matrix
            proc.get_output_tuple_s(1),  # image_width
            proc.get_output_tuple_s(2)   # image_height
        )  # type: ignore


def camera_calibration(
    nx: Sequence[Union[float, int]],
    ny: Sequence[Union[float, int]],
    nz: Sequence[Union[float, int]],
    nrow: Sequence[Union[float, int]],
    ncol: Sequence[Union[float, int]],
    start_cam_param: Sequence[Union[float, int, str]],
    nstart_pose: Sequence[Union[float, int]],
    estimate_params: Sequence[str]
) -> Tuple[Sequence[Union[float, int, str]], Sequence[Union[float, int]], Sequence[float]]:
    """
    Determine all camera parameters by a simultaneous minimization process.

    Parameters
    ----------

    nx : Sequence[Union[float, int]]
         Ordered tuple with all x coordinates of the calibration marks (in
         meters).

    ny : Sequence[Union[float, int]]
         Ordered tuple with all y coordinates of the calibration marks (in
         meters).

    nz : Sequence[Union[float, int]]
         Ordered tuple with all z coordinates of the calibration marks (in
         meters).

    nrow : Sequence[Union[float, int]]
           Ordered tuple with all row coordinates of the extracted
           calibration marks (in pixels).

    ncol : Sequence[Union[float, int]]
           Ordered tuple with all column coordinates of the extracted
           calibration marks (in pixels).

    start_cam_param : Sequence[Union[float, int, str]]
                      Initial values for the internal camera parameters.

    nstart_pose : Sequence[Union[float, int]]
                  Ordered tuple with all initial values for the external
                  camera parameters.

    estimate_params : Sequence[str]
                      Camera parameters to be estimated.
                      Value Suggestion: all

    Returns
    -------

    camera_param : Sequence[Union[float, int, str]]
                   Internal camera parameters.

    nfinal_pose : Sequence[Union[float, int]]
                  Ordered tuple with all external camera parameters.

    errors : Sequence[float]
             Average error distance in pixels.

    See Also
    --------
    find_caltab, find_marks_and_pose, disp_caltab, sim_caltab,
    write_cam_par, read_cam_par, create_pose, convert_pose_type,
    write_pose, read_pose, pose_to_hom_mat3d, hom_mat3d_to_pose,
    caltab_points, gen_caltab, calibrate_cameras

    Alternatives
    ------------
    calibrate_cameras

    Predecessors
    ------------
    find_marks_and_pose, caltab_points, read_cam_par

    Successors
    ----------
    write_pose, pose_to_hom_mat3d, disp_caltab, sim_caltab

    Notes
    -----
    The minimization process of the calibration depends on the initial
    values of the internal (StartCamParam) and external (NStartPose)
    camera parameters. The computed average errors Errors give an
    impression of the accuracy of the calibration. The errors (deviations
    in x- and y-coordinates) are measured in pixels.
    For line scan cameras, it is possible to set the start value for the
    internal camera parameter Sy to the value 0.0.  In this case, it is
    not possible to determine the position of the principal point in
    y-direction.  Therefore, EstimateParams must contain the term
    '~cy''126cy'}.  The effective distance of the principle point from the
    sensor line is then always pv = -Sy*Cy = 0.0$p_{v}$ = $S_{y} - C_{y} =
    0.0$. Further information can be found in the section ``Further
    Limitations Related to Specific Camera Types'' of Calibration.
    """
    with HalconOperator(1946) as proc:
        proc.set_input_tuple(0, nx)
        proc.set_input_tuple(1, ny)
        proc.set_input_tuple(2, nz)
        proc.set_input_tuple(3, nrow)
        proc.set_input_tuple(4, ncol)
        proc.set_input_tuple(5, start_cam_param)
        proc.set_input_tuple(6, nstart_pose)
        proc.set_input_tuple(7, estimate_params)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # camera_param
            proc.get_output_tuple_m(1),  # nfinal_pose
            proc.get_output_tuple_m(2)   # errors
        )  # type: ignore


def camera_calibration_s(
    nx: Sequence[Union[float, int]],
    ny: Sequence[Union[float, int]],
    nz: Sequence[Union[float, int]],
    nrow: Sequence[Union[float, int]],
    ncol: Sequence[Union[float, int]],
    start_cam_param: Sequence[Union[float, int, str]],
    nstart_pose: Sequence[Union[float, int]],
    estimate_params: Sequence[str]
) -> Tuple[Sequence[Union[float, int, str]], Sequence[Union[float, int]], float]:
    """
    Determine all camera parameters by a simultaneous minimization process.

    Parameters
    ----------

    nx : Sequence[Union[float, int]]
         Ordered tuple with all x coordinates of the calibration marks (in
         meters).

    ny : Sequence[Union[float, int]]
         Ordered tuple with all y coordinates of the calibration marks (in
         meters).

    nz : Sequence[Union[float, int]]
         Ordered tuple with all z coordinates of the calibration marks (in
         meters).

    nrow : Sequence[Union[float, int]]
           Ordered tuple with all row coordinates of the extracted
           calibration marks (in pixels).

    ncol : Sequence[Union[float, int]]
           Ordered tuple with all column coordinates of the extracted
           calibration marks (in pixels).

    start_cam_param : Sequence[Union[float, int, str]]
                      Initial values for the internal camera parameters.

    nstart_pose : Sequence[Union[float, int]]
                  Ordered tuple with all initial values for the external
                  camera parameters.

    estimate_params : Sequence[str]
                      Camera parameters to be estimated.
                      Value Suggestion: all

    Returns
    -------

    camera_param : Sequence[Union[float, int, str]]
                   Internal camera parameters.

    nfinal_pose : Sequence[Union[float, int]]
                  Ordered tuple with all external camera parameters.

    errors : float
             Average error distance in pixels.

    See Also
    --------
    find_caltab, find_marks_and_pose, disp_caltab, sim_caltab,
    write_cam_par, read_cam_par, create_pose, convert_pose_type,
    write_pose, read_pose, pose_to_hom_mat3d, hom_mat3d_to_pose,
    caltab_points, gen_caltab, calibrate_cameras

    Alternatives
    ------------
    calibrate_cameras

    Predecessors
    ------------
    find_marks_and_pose, caltab_points, read_cam_par

    Successors
    ----------
    write_pose, pose_to_hom_mat3d, disp_caltab, sim_caltab

    Notes
    -----
    The minimization process of the calibration depends on the initial
    values of the internal (StartCamParam) and external (NStartPose)
    camera parameters. The computed average errors Errors give an
    impression of the accuracy of the calibration. The errors (deviations
    in x- and y-coordinates) are measured in pixels.
    For line scan cameras, it is possible to set the start value for the
    internal camera parameter Sy to the value 0.0.  In this case, it is
    not possible to determine the position of the principal point in
    y-direction.  Therefore, EstimateParams must contain the term
    '~cy''126cy'}.  The effective distance of the principle point from the
    sensor line is then always pv = -Sy*Cy = 0.0$p_{v}$ = $S_{y} - C_{y} =
    0.0$. Further information can be found in the section ``Further
    Limitations Related to Specific Camera Types'' of Calibration.
    """
    with HalconOperator(1946) as proc:
        proc.set_input_tuple(0, nx)
        proc.set_input_tuple(1, ny)
        proc.set_input_tuple(2, nz)
        proc.set_input_tuple(3, nrow)
        proc.set_input_tuple(4, ncol)
        proc.set_input_tuple(5, start_cam_param)
        proc.set_input_tuple(6, nstart_pose)
        proc.set_input_tuple(7, estimate_params)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # camera_param
            proc.get_output_tuple_m(1),  # nfinal_pose
            proc.get_output_tuple_s(2)   # errors
        )  # type: ignore


def cfa_to_rgb(
    cfaimage: HObject,
    cfatype: str,
    interpolation: str
) -> HObject:
    """
    Convert a single-channel color filter array image into an RGB image.

    Parameters
    ----------

    cfaimage : HObject
               Input image.

    cfatype : str
              Color filter array type.
              Value Suggestion: bayer_gb

    interpolation : str
                    Interpolation type.
                    Value Suggestion: bilinear

    Returns
    -------

    rgbimage : HObject
               Output image.

    See Also
    --------
    trans_from_rgb

    Predecessors
    ------------
    gen_image1_extern, gen_image1, grab_image

    Successors
    ----------
    decompose3
    """
    with HalconOperator(1580) as proc:
        proc.set_input_object(1, cfaimage)
        proc.set_input_tuple(0, cfatype)
        proc.set_input_tuple(1, interpolation)
        proc.execute()
        rgbimage = HObject(proc.get_output_object_key(1))
        return rgbimage  # type: ignore


def change_domain(image: HObject, new_domain: HObject) -> HObject:
    """
    Change definition domain of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    new_domain : HObject
                 New definition domain.

    Returns
    -------

    image_new : HObject
                Image with new definition domain.

    See Also
    --------
    full_domain, get_domain, intersection

    Alternatives
    ------------
    reduce_domain

    Predecessors
    ------------
    get_domain

    Notes
    -----
    Due to running time the transferred region is not checked for
    consistency (i.e., whether it fits with the image matrix). Incorrect
    regions lead to system hang-ups during subsequent operations.
    """
    with HalconOperator(1143) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, new_domain)
        proc.execute()
        image_new = HObject(proc.get_output_object_key(1))
        return image_new  # type: ignore


def change_format(image: HObject, width: int, height: int) -> HObject:
    """
    Change image size.

    Parameters
    ----------

    image : HObject
            Input image.

    width : int
            Width of new image.
            Value Suggestion: 512

    height : int
             Height of new image.
             Value Suggestion: 512

    Returns
    -------

    image_part : HObject
                 Image with new format.

    See Also
    --------
    zoom_image_size, zoom_image_factor

    Alternatives
    ------------
    crop_part

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1142) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, height)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def change_radial_distortion_cam_par(
    mode: str,
    cam_param_in: Sequence[Union[int, float, str]],
    distortion_coeffs: MaybeSequence[Union[float, int]]
) -> Sequence[Union[int, float, str]]:
    """
    Determine new camera parameters in accordance to the specified radial
    distortion.

    Parameters
    ----------

    mode : str
           Mode
           Value Suggestion: adaptive

    cam_param_in : Sequence[Union[int, float, str]]
                   Internal camera parameters (original).

    distortion_coeffs : MaybeSequence[Union[float, int]]
                        Desired radial distortions.
                        Value Suggestion: 0.0

    Returns
    -------

    cam_param_out : Sequence[Union[int, float, str]]
                    Internal camera parameters (modified).

    See Also
    --------
    camera_calibration, read_cam_par, change_radial_distortion_image,
    change_radial_distortion_contours_xld, change_radial_distortion_points

    Predecessors
    ------------
    camera_calibration, read_cam_par

    Successors
    ----------
    change_radial_distortion_image, change_radial_distortion_contours_xld,
    gen_radial_distortion_map
    """
    with HalconOperator(1925) as proc:
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, cam_param_in)
        proc.set_input_tuple(2, distortion_coeffs)
        proc.init_oct(0)
        proc.execute()
        cam_param_out = proc.get_output_tuple_m(0)
        return cam_param_out  # type: ignore


def change_radial_distortion_contours_xld(
    contours: HObject,
    cam_param_in: Sequence[Union[int, float, str]],
    cam_param_out: Sequence[Union[int, float, str]]
) -> HObject:
    """
    Change the radial distortion of contours.

    Parameters
    ----------

    contours : HObject
               Original contours.

    cam_param_in : Sequence[Union[int, float, str]]
                   Internal camera parameter for Contours.

    cam_param_out : Sequence[Union[int, float, str]]
                    Internal camera parameter for ContoursRectified.

    Returns
    -------

    contours_rectified : HObject
                         Resulting contours with modified radial
                         distortion.

    See Also
    --------
    change_radial_distortion_cam_par, camera_calibration, read_cam_par,
    change_radial_distortion_image, change_radial_distortion_points

    Predecessors
    ------------
    change_radial_distortion_cam_par, gen_contours_skeleton_xld,
    edges_sub_pix, smooth_contours_xld

    Successors
    ----------
    gen_polygons_xld, smooth_contours_xld
    """
    with HalconOperator(1922) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, cam_param_in)
        proc.set_input_tuple(1, cam_param_out)
        proc.execute()
        contours_rectified = HObject(proc.get_output_object_key(1))
        return contours_rectified  # type: ignore


def change_radial_distortion_image(
    image: HObject,
    region: HObject,
    cam_param_in: Sequence[Union[int, float, str]],
    cam_param_out: Sequence[Union[int, float, str]]
) -> HObject:
    """
    Change the radial distortion of an image.

    Parameters
    ----------

    image : HObject
            Original image.

    region : HObject
             Region of interest in ImageRectified.

    cam_param_in : Sequence[Union[int, float, str]]
                   Internal camera parameter for Image.

    cam_param_out : Sequence[Union[int, float, str]]
                    Internal camera parameter for Image.

    Returns
    -------

    image_rectified : HObject
                      Resulting image with modified radial distortion.

    See Also
    --------
    change_radial_distortion_cam_par, camera_calibration, read_cam_par,
    change_radial_distortion_contours_xld, change_radial_distortion_points

    Predecessors
    ------------
    change_radial_distortion_cam_par, read_image, grab_image

    Successors
    ----------
    edges_image, threshold

    Notes
    -----
    change_radial_distortion_image can be executed on OpenCL devices if
    the input image does not exceed the maximum size of image objects of
    the selected device. As the OpenCL implementation uses single
    precision arithmetic, the results can differ from the CPU
    implementation.
    """
    with HalconOperator(1924) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, region)
        proc.set_input_tuple(0, cam_param_in)
        proc.set_input_tuple(1, cam_param_out)
        proc.execute()
        image_rectified = HObject(proc.get_output_object_key(1))
        return image_rectified  # type: ignore


def change_radial_distortion_points(
    row: Sequence[float],
    col: Sequence[float],
    cam_param_in: Sequence[Union[int, float, str]],
    cam_param_out: Sequence[Union[int, float, str]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Change the radial distortion of pixel coordinates.

    Parameters
    ----------

    row : Sequence[float]
          Original row component of pixel coordinates.

    col : Sequence[float]
          Original column component of pixel coordinates.

    cam_param_in : Sequence[Union[int, float, str]]
                   The inner camera parameters of the camera used to
                   create the input pixel coordinates.

    cam_param_out : Sequence[Union[int, float, str]]
                    The inner camera parameters of a camera.

    Returns
    -------

    row_changed : Sequence[float]
                  Row component of pixel coordinates after changing the
                  radial distortion.

    col_changed : Sequence[float]
                  Column component of pixel coordinates after changing the
                  radial distortion.

    See Also
    --------
    change_radial_distortion_cam_par, camera_calibration, read_cam_par,
    change_radial_distortion_contours_xld, change_radial_distortion_image
    """
    with HalconOperator(1923) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, col)
        proc.set_input_tuple(2, cam_param_in)
        proc.set_input_tuple(3, cam_param_out)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_changed
            proc.get_output_tuple_m(1)   # col_changed
        )  # type: ignore


def channels_to_image(images: HObject) -> HObject:
    """
    Convert one-channel images into a multi-channel image

    Parameters
    ----------

    images : HObject
             One-channel images to be combined into a one-channel image.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    image_to_channels

    Successors
    ----------
    count_channels, disp_image
    """
    with HalconOperator(1119) as proc:
        proc.set_input_object(1, images)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def char_threshold(
    image: HObject,
    histo_region: HObject,
    sigma: float,
    percent: Union[int, float]
) -> Tuple[HObject, Sequence[int]]:
    """
    Perform a threshold segmentation for extracting characters.

    Parameters
    ----------

    image : HObject
            Input image.

    histo_region : HObject
                   Region in which the histogram is computed.

    sigma : float
            Sigma for the Gaussian smoothing of the histogram.
            Value Suggestion: 2.0

    percent : Union[int, float]
              Percentage for the gray value difference.
              Value Suggestion: 95

    Returns
    -------

    characters : HObject
                 Dark regions (characters).

    threshold : Sequence[int]
                Calculated threshold.

    Alternatives
    ------------
    binary_threshold, auto_threshold, gray_histo, smooth_funct_1d_gauss,
    threshold

    Predecessors
    ------------
    anisotropic_diffusion, median_image, illuminate

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(444) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, histo_region)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, percent)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # characters
            proc.get_output_tuple_m(0)   # threshold
        )  # type: ignore


def char_threshold_s(
    image: HObject,
    histo_region: HObject,
    sigma: float,
    percent: Union[int, float]
) -> Tuple[HObject, int]:
    """
    Perform a threshold segmentation for extracting characters.

    Parameters
    ----------

    image : HObject
            Input image.

    histo_region : HObject
                   Region in which the histogram is computed.

    sigma : float
            Sigma for the Gaussian smoothing of the histogram.
            Value Suggestion: 2.0

    percent : Union[int, float]
              Percentage for the gray value difference.
              Value Suggestion: 95

    Returns
    -------

    characters : HObject
                 Dark regions (characters).

    threshold : int
                Calculated threshold.

    Alternatives
    ------------
    binary_threshold, auto_threshold, gray_histo, smooth_funct_1d_gauss,
    threshold

    Predecessors
    ------------
    anisotropic_diffusion, median_image, illuminate

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(444) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, histo_region)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, percent)
        proc.init_oct(0)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # characters
            proc.get_output_tuple_s(0)   # threshold
        )  # type: ignore


def check_difference(
    image: HObject,
    pattern: HObject,
    mode: str,
    diff_lower_bound: int,
    diff_upper_bound: int,
    gray_offset: int,
    add_row: int,
    add_col: int
) -> HObject:
    """
    Compare two images pixel by pixel.

    Parameters
    ----------

    image : HObject
            Input image.

    pattern : HObject
              Comparison image.

    mode : str
           Mode: return similar or different pixels.
           Value Suggestion: diff_outside

    diff_lower_bound : int
                       Lower bound of the tolerated gray value difference.
                       Value Suggestion: -5
                       Assertion: -255 <= DiffLowerBound && DiffLowerBound <= 255

    diff_upper_bound : int
                       Upper bound of the tolerated gray value difference.
                       Value Suggestion: 5
                       Assertion: -255 <= DiffUpperBound && DiffUpperBound <= 255

    gray_offset : int
                  Offset gray value subtracted from the input image.
                  Value Suggestion: 0
                  Assertion: -255 <= GrayOffset && GrayOffset <= 255

    add_row : int
              Row coordinate by which the comparison image is translated.
              Value Suggestion: 0

    add_col : int
              Column coordinate by which the comparison image is
              translated.
              Value Suggestion: 0

    Returns
    -------

    selected : HObject
               Points in which the two images are similar/different.

    Alternatives
    ------------
    sub_image, dyn_threshold

    Successors
    ----------
    connection, select_shape, reduce_domain, select_gray, rank_region,
    dilation1, opening
    """
    with HalconOperator(443) as proc:
        proc.set_input_object(1, image)
        proc.set_input_object(2, pattern)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, diff_lower_bound)
        proc.set_input_tuple(2, diff_upper_bound)
        proc.set_input_tuple(3, gray_offset)
        proc.set_input_tuple(4, add_row)
        proc.set_input_tuple(5, add_col)
        proc.execute()
        selected = HObject(proc.get_output_object_key(1))
        return selected  # type: ignore


def circularity(regions: HObject) -> Sequence[float]:
    """
    Shape factor for the circularity (similarity to a circle) of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    circularity : Sequence[float]
                  Circularity of the input region(s).
                  Assertion: 0 <= Circularity && Circularity <= 1.0

    See Also
    --------
    area_center, select_shape

    Alternatives
    ------------
    roundness, compactness, convexity, eccentricity

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1729) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        circularity = proc.get_output_tuple_m(0)
        return circularity  # type: ignore


def circularity_s(regions: HObject) -> float:
    """
    Shape factor for the circularity (similarity to a circle) of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    circularity : float
                  Circularity of the input region(s).
                  Assertion: 0 <= Circularity && Circularity <= 1.0

    See Also
    --------
    area_center, select_shape

    Alternatives
    ------------
    roundness, compactness, convexity, eccentricity

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1729) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        circularity = proc.get_output_tuple_s(0)
        return circularity  # type: ignore


def circularity_xld(xld: HObject) -> Sequence[float]:
    """
    Shape factor for the circularity (similarity to a circle) of contours
    or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    circularity : Sequence[float]
                  Roundness of the input contours or polygons.
                  Assertion: 0 <= Circularity && Circularity <= 1.0

    See Also
    --------
    area_center_xld, select_shape_xld

    Alternatives
    ------------
    compactness_xld, convexity_xld, eccentricity_xld, rectangularity_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1684) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        circularity = proc.get_output_tuple_m(0)
        return circularity  # type: ignore


def circularity_xld_s(xld: HObject) -> float:
    """
    Shape factor for the circularity (similarity to a circle) of contours
    or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    circularity : float
                  Roundness of the input contours or polygons.
                  Assertion: 0 <= Circularity && Circularity <= 1.0

    See Also
    --------
    area_center_xld, select_shape_xld

    Alternatives
    ------------
    compactness_xld, convexity_xld, eccentricity_xld, rectangularity_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1684) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        circularity = proc.get_output_tuple_s(0)
        return circularity  # type: ignore


def class_2dim_sup(
    image_col: HObject,
    image_row: HObject,
    feature_space: HObject
) -> HObject:
    """
    Segment an image using two-dimensional pixel classification.

    Parameters
    ----------

    image_col : HObject
                Input image (first channel).

    image_row : HObject
                Input image (second channel).

    feature_space : HObject
                    Region defining the feature space.

    Returns
    -------

    region_class_2dim : HObject
                        Classified regions.

    See Also
    --------
    histo_2dim

    Alternatives
    ------------
    class_ndim_norm, threshold

    Predecessors
    ------------
    histo_2dim, threshold, draw_region, dilation1, opening, shape_trans

    Successors
    ----------
    connection, select_shape, select_gray
    """
    with HalconOperator(441) as proc:
        proc.set_input_object(1, image_col)
        proc.set_input_object(2, image_row)
        proc.set_input_object(3, feature_space)
        proc.execute()
        region_class_2dim = HObject(proc.get_output_object_key(1))
        return region_class_2dim  # type: ignore


def class_2dim_unsup(
    image_1: HObject,
    image_2: HObject,
    threshold: int,
    num_classes: int
) -> HObject:
    """
    Segment two images by clustering.

    Parameters
    ----------

    image_1 : HObject
              First input image.

    image_2 : HObject
              Second input image.

    threshold : int
                Threshold (maximum distance to the cluster's center).
                Value Suggestion: 15

    num_classes : int
                  Number of classes (cluster centers).
                  Value Suggestion: 5

    Returns
    -------

    classes : HObject
              Classification result.

    Alternatives
    ------------
    threshold, histo_2dim, class_2dim_sup, class_ndim_norm

    Predecessors
    ------------
    decompose2, decompose3, median_image, anisotropic_diffusion,
    reduce_domain

    Successors
    ----------
    select_shape, select_gray, connection

    Notes
    -----
    Both input images must have the same size.
    """
    with HalconOperator(442) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_tuple(0, threshold)
        proc.set_input_tuple(1, num_classes)
        proc.execute()
        classes = HObject(proc.get_output_object_key(1))
        return classes  # type: ignore


def class_ndim_box(
    multi_channel_image: HObject,
    classif_handle: HHandle
) -> HObject:
    """
    Classify pixels using hyper-cuboids.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi channel input image.

    classif_handle : HHandle
                     Handle of the classifier.

    Returns
    -------

    regions : HObject
              Classification result.

    See Also
    --------
    descript_class_box

    Alternatives
    ------------
    class_ndim_norm, class_2dim_sup, class_2dim_unsup

    Predecessors
    ------------
    create_class_box, learn_class_box, median_image, compose2, compose3,
    compose4, compose5, compose6, compose7

    Warnings
    --------
    class_ndim_box is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(439) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.set_input_tuple(0, classif_handle)
        proc.execute()
        regions = HObject(proc.get_output_object_key(1))
        return regions  # type: ignore


def class_ndim_norm(
    multi_channel_image: HObject,
    metric: str,
    single_multiple: str,
    radius: MaybeSequence[Union[int, float]],
    center: MaybeSequence[Union[int, float]]
) -> HObject:
    """
    Classify pixels using hyper-spheres or hyper-cubes.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi channel input image.

    metric : str
             Metric to be used.
             Value Suggestion: euclid

    single_multiple : str
                      Return one region or one region for each cluster.
                      Value Suggestion: single

    radius : MaybeSequence[Union[int, float]]
             Cluster radii or half edge lengths (returned by
             learn_ndim_norm).

    center : MaybeSequence[Union[int, float]]
             Coordinates of the cluster centers (returned by
             learn_ndim_norm).

    Returns
    -------

    regions : HObject
              Classification result.

    Alternatives
    ------------
    class_2dim_sup, class_2dim_unsup

    Predecessors
    ------------
    learn_ndim_norm, compose2, compose3, compose4, compose5, compose6,
    compose7

    Successors
    ----------
    connection, select_shape, reduce_domain, select_gray
    """
    with HalconOperator(440) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.set_input_tuple(0, metric)
        proc.set_input_tuple(1, single_multiple)
        proc.set_input_tuple(2, radius)
        proc.set_input_tuple(3, center)
        proc.execute()
        regions = HObject(proc.get_output_object_key(1))
        return regions  # type: ignore


def classify_class_gmm(
    gmmhandle: HHandle,
    features: Sequence[float],
    num: int
) -> Tuple[Sequence[int], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Calculate the class of a feature vector by a Gaussian Mixture Model.

    Parameters
    ----------

    gmmhandle : HHandle
                GMM handle.

    features : Sequence[float]
               Feature vector.

    num : int
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_id : Sequence[int]
               Result of classifying the feature vector with the GMM.

    class_prob : Sequence[float]
                 A-posteriori probability of the classes.

    density : Sequence[float]
              Probability density of the feature vector.

    ksigma_prob : Sequence[float]
                  Normalized k-sigma-probability for the feature vector.

    See Also
    --------
    create_class_gmm

    Alternatives
    ------------
    evaluate_class_gmm

    Predecessors
    ------------
    train_class_gmm, read_class_gmm
    """
    with HalconOperator(1832) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_id
            proc.get_output_tuple_m(1),  # class_prob
            proc.get_output_tuple_m(2),  # density
            proc.get_output_tuple_m(3)   # ksigma_prob
        )  # type: ignore


def classify_class_gmm_s(
    gmmhandle: HHandle,
    features: Sequence[float],
    num: int
) -> Tuple[int, Sequence[float], Sequence[float], Sequence[float]]:
    """
    Calculate the class of a feature vector by a Gaussian Mixture Model.

    Parameters
    ----------

    gmmhandle : HHandle
                GMM handle.

    features : Sequence[float]
               Feature vector.

    num : int
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_id : int
               Result of classifying the feature vector with the GMM.

    class_prob : Sequence[float]
                 A-posteriori probability of the classes.

    density : Sequence[float]
              Probability density of the feature vector.

    ksigma_prob : Sequence[float]
                  Normalized k-sigma-probability for the feature vector.

    See Also
    --------
    create_class_gmm

    Alternatives
    ------------
    evaluate_class_gmm

    Predecessors
    ------------
    train_class_gmm, read_class_gmm
    """
    with HalconOperator(1832) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_id
            proc.get_output_tuple_m(1),  # class_prob
            proc.get_output_tuple_m(2),  # density
            proc.get_output_tuple_m(3)   # ksigma_prob
        )  # type: ignore


def classify_class_knn(
    knnhandle: HHandle,
    features: Sequence[float]
) -> Tuple[Sequence[int], Sequence[float]]:
    """
    Search for the next neighbors for a given feature vector.

    Parameters
    ----------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    features : Sequence[float]
               Features that should be classified.

    Returns
    -------

    result : Sequence[int]
             The classification result, either class IDs or sample indices.

    rating : Sequence[float]
             A rating for the results. This value contains either a
             distance, a frequency or a weighted frequency.

    See Also
    --------
    create_class_knn, read_class_knn

    Predecessors
    ------------
    train_class_knn, read_class_knn, set_params_class_knn

    Successors
    ----------
    clear_class_knn
    """
    with HalconOperator(1813) as proc:
        proc.set_input_tuple(0, knnhandle)
        proc.set_input_tuple(1, features)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # result
            proc.get_output_tuple_m(1)   # rating
        )  # type: ignore


def classify_class_mlp(
    mlphandle: HHandle,
    features: Sequence[float],
    num: Sequence[int]
) -> Tuple[Sequence[int], Sequence[float]]:
    """
    Calculate the class of a feature vector by a multilayer perceptron.

    Parameters
    ----------

    mlphandle : HHandle
                MLP handle.

    features : Sequence[float]
               Feature vector.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[int]
                Result of classifying the feature vector with the MLP.

    confidence : Sequence[float]
                 Confidence(s) of the class(es) of the feature vector.

    See Also
    --------
    create_class_mlp

    Alternatives
    ------------
    apply_dl_classifier, evaluate_class_mlp

    Predecessors
    ------------
    train_class_mlp, read_class_mlp
    """
    with HalconOperator(1871) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def classify_class_mlp_s(
    mlphandle: HHandle,
    features: Sequence[float],
    num: Sequence[int]
) -> Tuple[int, float]:
    """
    Calculate the class of a feature vector by a multilayer perceptron.

    Parameters
    ----------

    mlphandle : HHandle
                MLP handle.

    features : Sequence[float]
               Feature vector.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : int
                Result of classifying the feature vector with the MLP.

    confidence : float
                 Confidence(s) of the class(es) of the feature vector.

    See Also
    --------
    create_class_mlp

    Alternatives
    ------------
    apply_dl_classifier, evaluate_class_mlp

    Predecessors
    ------------
    train_class_mlp, read_class_mlp
    """
    with HalconOperator(1871) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def classify_class_svm(
    svmhandle: HHandle,
    features: Sequence[float],
    num: Sequence[int]
) -> Sequence[int]:
    """
    Classify a feature vector by a support vector machine.

    Parameters
    ----------

    svmhandle : HHandle
                SVM handle.

    features : Sequence[float]
               Feature vector.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[int]
                Result of classifying the feature vector with the SVM.

    See Also
    --------
    create_class_svm

    Alternatives
    ------------
    apply_dl_classifier

    Predecessors
    ------------
    train_class_svm, read_class_svm
    """
    with HalconOperator(1851) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_m(0)
        return class_val  # type: ignore


def classify_class_svm_s(
    svmhandle: HHandle,
    features: Sequence[float],
    num: Sequence[int]
) -> int:
    """
    Classify a feature vector by a support vector machine.

    Parameters
    ----------

    svmhandle : HHandle
                SVM handle.

    features : Sequence[float]
               Feature vector.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : int
                Result of classifying the feature vector with the SVM.

    See Also
    --------
    create_class_svm

    Alternatives
    ------------
    apply_dl_classifier

    Predecessors
    ------------
    train_class_svm, read_class_svm
    """
    with HalconOperator(1851) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.set_input_tuple(1, features)
        proc.set_input_tuple(2, num)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_s(0)
        return class_val  # type: ignore


def classify_image_class_gmm(
    image: HObject,
    gmmhandle: HHandle,
    rejection_threshold: float
) -> HObject:
    """
    Classify an image with a Gaussian Mixture Model.

    Parameters
    ----------

    image : HObject
            Input image.

    gmmhandle : HHandle
                GMM handle.

    rejection_threshold : float
                          Threshold for the rejection of the
                          classification.
                          Value Suggestion: 0.5
                          Assertion: RejectionThreshold >= 0.0 && RejectionThreshold <= 1.0

    Returns
    -------

    class_regions : HObject
                    Segmented classes.

    See Also
    --------
    add_samples_image_class_gmm, create_class_gmm

    Alternatives
    ------------
    classify_image_class_knn, classify_image_class_mlp,
    classify_image_class_svm, classify_image_class_lut, class_ndim_norm,
    class_2dim_sup

    Predecessors
    ------------
    train_class_gmm, read_class_gmm
    """
    with HalconOperator(431) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, rejection_threshold)
        proc.execute()
        class_regions = HObject(proc.get_output_object_key(1))
        return class_regions  # type: ignore


def classify_image_class_knn(
    image: HObject,
    knnhandle: HHandle,
    rejection_threshold: float
) -> Tuple[HObject, HObject]:
    """
    Classify an image with a k-Nearest-Neighbor classifier.

    Parameters
    ----------

    image : HObject
            Input image.

    knnhandle : HHandle
                Handle of the k-NN classifier.

    rejection_threshold : float
                          Threshold for the rejection of the
                          classification.
                          Value Suggestion: 0.5
                          Assertion: RejectionThreshold >= 0.0

    Returns
    -------

    class_regions : HObject
                    Segmented classes.

    distance_image : HObject
                     Distance of the pixel's nearest neighbor.

    See Also
    --------
    add_samples_image_class_knn, create_class_knn

    Alternatives
    ------------
    classify_image_class_svm, classify_image_class_mlp,
    classify_image_class_gmm, classify_image_class_lut, class_ndim_norm,
    class_2dim_sup

    Predecessors
    ------------
    train_class_knn, read_class_knn
    """
    with HalconOperator(429) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, knnhandle)
        proc.set_input_tuple(1, rejection_threshold)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # class_regions
            HObject(proc.get_output_object_key(2))   # distance_image
        )  # type: ignore


def classify_image_class_lut(
    image: HObject,
    class_luthandle: HHandle
) -> HObject:
    """
    Classify a byte image using a look-up table.

    Parameters
    ----------

    image : HObject
            Input image.

    class_luthandle : HHandle
                      Handle of the LUT classifier.

    Returns
    -------

    class_regions : HObject
                    Segmented classes.

    See Also
    --------
    create_class_lut_gmm, create_class_lut_knn, create_class_lut_mlp,
    create_class_lut_svm, create_class_lut_gmm

    Alternatives
    ------------
    classify_image_class_gmm, classify_image_class_knn,
    classify_image_class_mlp, classify_image_class_svm

    Predecessors
    ------------
    create_class_lut_gmm, create_class_lut_knn, create_class_lut_mlp,
    create_class_lut_svm
    """
    with HalconOperator(428) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, class_luthandle)
        proc.execute()
        class_regions = HObject(proc.get_output_object_key(1))
        return class_regions  # type: ignore


def classify_image_class_mlp(
    image: HObject,
    mlphandle: HHandle,
    rejection_threshold: float
) -> HObject:
    """
    Classify an image with a multilayer perceptron.

    Parameters
    ----------

    image : HObject
            Input image.

    mlphandle : HHandle
                MLP handle.

    rejection_threshold : float
                          Threshold for the rejection of the
                          classification.
                          Value Suggestion: 0.5
                          Assertion: RejectionThreshold >= 0.0 && RejectionThreshold <= 1.0

    Returns
    -------

    class_regions : HObject
                    Segmented classes.

    See Also
    --------
    add_samples_image_class_mlp, create_class_mlp

    Alternatives
    ------------
    classify_image_class_gmm, classify_image_class_knn,
    classify_image_class_svm, classify_image_class_lut, class_ndim_norm,
    class_2dim_sup

    Predecessors
    ------------
    train_class_mlp, read_class_mlp
    """
    with HalconOperator(435) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, rejection_threshold)
        proc.execute()
        class_regions = HObject(proc.get_output_object_key(1))
        return class_regions  # type: ignore


def classify_image_class_svm(
    image: HObject,
    svmhandle: HHandle
) -> HObject:
    """
    Classify an image with a support vector machine.

    Parameters
    ----------

    image : HObject
            Input image.

    svmhandle : HHandle
                SVM handle.

    Returns
    -------

    class_regions : HObject
                    Segmented classes.

    See Also
    --------
    add_samples_image_class_svm, create_class_svm

    Alternatives
    ------------
    classify_image_class_gmm, classify_image_class_knn,
    classify_image_class_mlp, classify_image_class_lut, class_ndim_norm,
    class_2dim_sup

    Predecessors
    ------------
    train_class_svm, read_class_svm, reduce_class_svm
    """
    with HalconOperator(433) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, svmhandle)
        proc.execute()
        class_regions = HObject(proc.get_output_object_key(1))
        return class_regions  # type: ignore


def clear_all_bar_code_models() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    bar code models and free the allocated memory

    Warnings
    --------
    clear_all_bar_code_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_bar_code_models, the operator will be removed
    in future versions.

    Notes
    -----
    clear_all_bar_code_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_bar_code_models must not be used in any application.
    """
    with HalconOperator(1999) as proc:
        proc.execute()


def clear_all_barriers() -> None:
    """
    This operator is inoperable. It had the following function: Destroy
    all barrier synchronization objects.

    Warnings
    --------
    clear_all_barriers is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_barriers, the operator will be removed in future versions.

    Notes
    -----
    clear_all_barriers exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_barriers must
    not be used in any application.
    """
    with HalconOperator(549) as proc:
        proc.execute()


def clear_all_calib_data() -> None:
    """
    Free the memory of all calibration data models.

    Warnings
    --------
    clear_all_calib_data is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_calib_data, the operator will be removed in future versions.

    Notes
    -----
    clear_all_calib_data exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_calib_data must
    not be used in any application.
    """
    with HalconOperator(1959) as proc:
        proc.execute()


def clear_all_camera_setup_models() -> None:
    """
    Free the memory of all camera setup models.

    Warnings
    --------
    clear_all_camera_setup_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility.  New applications
    should not use clear_all_camera_setup_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_camera_setup_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_camera_setup_models must not be used in any application.
    """
    with HalconOperator(1949) as proc:
        proc.execute()


def clear_all_class_gmm() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    Gaussian Mixture Models.

    Warnings
    --------
    clear_all_class_gmm is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_class_gmm, the operator will be removed in future versions.

    Notes
    -----
    clear_all_class_gmm exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_class_gmm must
    not be used in any application.
    """
    with HalconOperator(1823) as proc:
        proc.execute()


def clear_all_class_knn() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    k-NN classifiers.

    Warnings
    --------
    clear_all_class_knn is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_class_knn, the operator will be removed in future versions.

    Notes
    -----
    clear_all_class_knn exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_class_knn must
    not be used in any application.
    """
    with HalconOperator(1803) as proc:
        proc.execute()


def clear_all_class_lut() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    look-up table classifiers.

    Warnings
    --------
    clear_all_class_lut is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_class_lut, the operator will be removed in future versions.

    Notes
    -----
    clear_all_class_lut exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_class_lut must
    not be used in any application.
    """
    with HalconOperator(1817) as proc:
        proc.execute()


def clear_all_class_mlp() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    multilayer perceptrons.

    Warnings
    --------
    clear_all_class_mlp is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_class_mlp, the operator will be removed in future versions.

    Notes
    -----
    clear_all_class_mlp exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_class_mlp must
    not be used in any application.
    """
    with HalconOperator(1862) as proc:
        proc.execute()


def clear_all_class_svm() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    support vector machines.

    Warnings
    --------
    clear_all_class_svm is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_class_svm, the operator will be removed in future versions.

    Notes
    -----
    clear_all_class_svm exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_class_svm must
    not be used in any application.
    """
    with HalconOperator(1841) as proc:
        proc.execute()


def clear_all_class_train_data() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    training data for classifiers.

    Warnings
    --------
    clear_all_class_train_data is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_class_train_data, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_class_train_data exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    """
    with HalconOperator(1795) as proc:
        proc.execute()


def clear_all_color_trans_luts() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    look-up-tables of the color space transformation.

    Warnings
    --------
    clear_all_color_trans_luts is obsolete, inoperable,  and is only
    provided for reasons of backward compatibility.  New applications
    should not use clear_all_color_trans_luts, the operator will be
    removed in future versions.

    Notes
    -----
    After execution of clear_all_color_trans_luts all handles to
    look-up-tables become invalid. clear_all_color_trans_luts exists
    solely for the purpose of implementing the ``reset program''
    functionality in HDevelop. clear_all_color_trans_luts must not be used
    in any application.
    """
    with HalconOperator(1576) as proc:
        proc.execute()


def clear_all_component_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all component models.

    Warnings
    --------
    clear_all_component_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_component_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_component_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_component_models must not be used in any application.
    """
    with HalconOperator(996) as proc:
        proc.execute()


def clear_all_conditions() -> None:
    """
    This operator is inoperable. It had the following function: Destroy
    all condition synchronization objects.

    Warnings
    --------
    clear_all_conditions is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    close_all_framegrabbers, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_conditions exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_conditions must
    not be used in any application.
    """
    with HalconOperator(542) as proc:
        proc.execute()


def clear_all_data_code_2d_models() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    2D data code models and free the allocated memory.

    Warnings
    --------
    clear_all_data_code_2d_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility.  New applications
    should not use clear_all_data_code_2d_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_data_code_2d_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_data_code_2d_models must not be used in any application.
    """
    with HalconOperator(1776) as proc:
        proc.execute()


def clear_all_deformable_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all deformable models.

    Warnings
    --------
    clear_all_deformable_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_deformable_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_deformable_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_deformable_models must not be used in any application.
    """
    with HalconOperator(967) as proc:
        proc.execute()


def clear_all_descriptor_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all descriptor models in RAM.

    Warnings
    --------
    clear_all_descriptor_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_descriptor_models, the operator will be
    removed in future versions.
    """
    with HalconOperator(942) as proc:
        proc.execute()


def clear_all_events() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    event synchronization objects.

    Warnings
    --------
    clear_all_events is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_events, the operator will be removed in future versions.

    Notes
    -----
    clear_all_events exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_events must not
    be used in any application.
    """
    with HalconOperator(553) as proc:
        proc.execute()


def clear_all_lexica() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    lexica.

    Warnings
    --------
    clear_all_lexica is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_lexica, the operator will be removed in future versions.

    Notes
    -----
    clear_all_lexica exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_lexica must not
    be used in any application.
    """
    with HalconOperator(665) as proc:
        proc.execute()


def clear_all_matrices() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    matrices from memory.

    Warnings
    --------
    clear_all_matrices is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_matrices, the operator will be removed in future versions.

    Notes
    -----
    clear_all_matrices exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_matrices must
    not be used in any application.
    """
    with HalconOperator(895) as proc:
        proc.execute()


def clear_all_metrology_models() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    metrology models and free the allocated memory.

    Warnings
    --------
    clear_all_metrology_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_metrology_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_metrology_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_metrology_models must not be used in any application.
    """
    with HalconOperator(816) as proc:
        proc.execute()


def clear_all_mutexes() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    mutex synchronization objects.

    Warnings
    --------
    clear_all_mutexes is obsolete, inoperable. and is only provided for
    reasons of backward compatibility. New applications should not use
    clear_all_mutexes, the operator will be removed in future versions.

    Notes
    -----
    clear_all_mutexes exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_mutexes must
    not be used in any application.
    """
    with HalconOperator(559) as proc:
        proc.execute()


def clear_all_ncc_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all NCC models.

    Warnings
    --------
    clear_all_ncc_models is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_ncc_models, the operator will be removed in future versions.

    Notes
    -----
    clear_all_ncc_models exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_ncc_models must
    not be used in any application.
    """
    with HalconOperator(981) as proc:
        proc.execute()


def clear_all_object_model_3d() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all 3D object models.

    Warnings
    --------
    clear_all_object_model_3d is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_object_model_3d, the operator will be removed
    in future versions.

    Notes
    -----
    clear_all_object_model_3d exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_object_model_3d must not be used in any application.
    """
    with HalconOperator(1099) as proc:
        proc.execute()


def clear_all_ocr_class_knn() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    OCR classifiers.

    Warnings
    --------
    clear_all_ocr_class_knn is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_ocr_class_knn, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_ocr_class_knn exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_ocr_class_knn must not be used in any application.
    """
    with HalconOperator(652) as proc:
        proc.execute()


def clear_all_ocr_class_mlp() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    OCR classifiers.

    Warnings
    --------
    clear_all_ocr_class_mlp is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_ocr_class_mlp, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_ocr_class_mlp exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_ocr_class_mlp must not be used in any application.
    """
    with HalconOperator(690) as proc:
        proc.execute()


def clear_all_ocr_class_svm() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    SVM based OCR classifiers.

    Warnings
    --------
    clear_all_ocr_class_svm is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_ocr_class_svm, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_ocr_class_svm exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_ocr_class_svm must not be used in any application.
    """
    with HalconOperator(672) as proc:
        proc.execute()


def clear_all_sample_identifiers() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all sample identifiers.

    Warnings
    --------
    clear_all_sample_identifiers is obsolete, inoperable, and is only
    provided for reasons of backward compatibility.  New applications
    should not use clear_all_sample_identifiers, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_sample_identifiers exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_sample_identifiers must not be used in any application.
    """
    with HalconOperator(898) as proc:
        proc.execute()


def clear_all_scattered_data_interpolators() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    scattered data interpolators.

    Warnings
    --------
    clear_all_scattered_data_interpolators is obsolete, inoperable, and is
    only provided for reasons of backward compatibility. New applications
    should not use clear_all_scattered_data_interpolators, the operator
    will be removed in future versions.

    Notes
    -----
    clear_all_scattered_data_interpolators exists solely for the purpose
    of implementing the ``reset program'' functionality in HDevelop.
    clear_all_scattered_data_interpolators must not be used in any
    application.
    """
    with HalconOperator(289) as proc:
        proc.execute()


def clear_all_serialized_items() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    current existing serialized items.

    Warnings
    --------
    clear_all_serialized_items is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_serialized_items, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_serialized_items exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_serialized_items must not be used in any application.
    """
    with HalconOperator(407) as proc:
        proc.execute()


def clear_all_shape_model_3d() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all 3D shape models.

    Warnings
    --------
    clear_all_shape_model_3d is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_shape_model_3d, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_shape_model_3d exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_shape_model_3d must not be used in any application.
    """
    with HalconOperator(1048) as proc:
        proc.execute()


def clear_all_shape_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all shape models.

    Warnings
    --------
    clear_all_shape_models is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_shape_models, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_shape_models exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_shape_models must not be used in any application.
    """
    with HalconOperator(920) as proc:
        proc.execute()


def clear_all_sheet_of_light_models() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    sheet-of-light models and free the allocated memory.

    Warnings
    --------
    clear_all_sheet_of_light_models is obsolete, inoperable, and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_sheet_of_light_models, the operator will be
    removed in future versions..

    Notes
    -----
    clear_all_sheet_of_light_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_sheet_of_light_models must not be used in any application.
    """
    with HalconOperator(389) as proc:
        proc.execute()


def clear_all_stereo_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all stereo models.

    Warnings
    --------
    clear_all_stereo_models is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_stereo_models, the operator will be removed in future
    versions..

    Notes
    -----
    clear_all_stereo_models exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_stereo_models must not be used in any application.
    """
    with HalconOperator(518) as proc:
        proc.execute()


def clear_all_surface_matching_results() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all surface matching results.

    Warnings
    --------
    clear_all_surface_matching_results is obsolete, inoperable, and is
    only provided for reasons of backward compatibility. New applications
    should not use clear_all_surface_matching_results, the operator will
    be removed in future versions.

    Notes
    -----
    clear_all_surface_matching_results exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_surface_matching_results must not be used in any application.
    """
    with HalconOperator(1033) as proc:
        proc.execute()


def clear_all_surface_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all surface models.

    Warnings
    --------
    clear_all_surface_models is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_surface_models, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_surface_models exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_surface_models must not be used in any application.
    """
    with HalconOperator(1035) as proc:
        proc.execute()


def clear_all_templates() -> None:
    """
    This operator is inoperable. It had the following function:
    Deallocation of the memory of all templates.

    Warnings
    --------
    clear_all_templates is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    clear_all_templates, the operator will be removed in future versions.

    Notes
    -----
    clear_all_templates exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. clear_all_templates must
    not be used in any application.
    """
    with HalconOperator(1494) as proc:
        proc.execute()


def clear_all_text_models() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    text models.

    Warnings
    --------
    clear_all_text_models is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_text_models, the operator will be removed in future
    versions..

    Notes
    -----
    clear_all_text_models exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop. clear_all_text_models
    must not be used in any application.
    """
    with HalconOperator(420) as proc:
        proc.execute()


def clear_all_text_results() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    text results.

    Warnings
    --------
    clear_all_text_results is obsolete, inoperable, and is only provided
    for reasons of backward compatibility. New applications should not use
    clear_all_text_results, the operator will be removed in future
    versions.

    Notes
    -----
    clear_all_text_results exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    clear_all_text_results must not be used in any application.
    """
    with HalconOperator(413) as proc:
        proc.execute()


def clear_all_training_components() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all component training results.

    Warnings
    --------
    clear_all_training_components is obsolete, inoperable, and is only
    provided for reasons of backward compatibility.  New applications
    should not use clear_all_training_components, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_training_components exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_training_components must not be used in any application.
    """
    with HalconOperator(1006) as proc:
        proc.execute()


def clear_all_variation_models() -> None:
    """
    This operator is inoperable. It had the following function: Free the
    memory of all variation models.

    Warnings
    --------
    clear_all_variation_models is obsolete, inoperable and is only
    provided for reasons of backward compatibility. New applications
    should not use clear_all_variation_models, the operator will be
    removed in future versions.

    Notes
    -----
    clear_all_variation_models exists solely for the purpose of
    implementing the ``reset program'' functionality in HDevelop.
    clear_all_variation_models must not be used in any application.
    """
    with HalconOperator(92) as proc:
        proc.execute()


def clear_bar_code_model(bar_code_handle: MaybeSequence[HHandle]) -> None:
    """
    Delete a bar code model and free the allocated memory

    Parameters
    ----------

    bar_code_handle : MaybeSequence[HHandle]
                      Handle of the bar code model.

    See Also
    --------
    find_bar_code
    """
    with HalconOperator(2000) as proc:
        proc.set_input_tuple(0, bar_code_handle)
        proc.execute()


def clear_barrier(barrier_handle: HHandle) -> None:
    """
    Destroy a barrier synchronization object.

    Parameters
    ----------

    barrier_handle : HHandle
                     Barrier synchronization object.

    See Also
    --------
    create_barrier

    Predecessors
    ------------
    create_barrier
    """
    with HalconOperator(550) as proc:
        proc.set_input_tuple(0, barrier_handle)
        proc.execute()


def clear_bead_inspection_model(bead_inspection_model: HHandle) -> None:
    """
    Delete the bead inspection model and free the allocated memory.

    Parameters
    ----------

    bead_inspection_model : HHandle
                            Handle of the bead inspection model.

    See Also
    --------
    create_bead_inspection_model

    Predecessors
    ------------
    create_bead_inspection_model
    """
    with HalconOperator(1984) as proc:
        proc.set_input_tuple(0, bead_inspection_model)
        proc.execute()


def clear_calib_data(calib_data_id: HHandle) -> None:
    """
    Free the memory of a calibration data model.

    Parameters
    ----------

    calib_data_id : HHandle
                    Handle of a calibration data model.
    """
    with HalconOperator(1960) as proc:
        proc.set_input_tuple(0, calib_data_id)
        proc.execute()


def clear_camera_setup_model(camera_setup_model_id: HHandle) -> None:
    """
    Free the memory of a calibration setup model.

    Parameters
    ----------

    camera_setup_model_id : HHandle
                            Handle of the camera setup model.
    """
    with HalconOperator(1950) as proc:
        proc.set_input_tuple(0, camera_setup_model_id)
        proc.execute()


def clear_class_gmm(gmmhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear a Gaussian Mixture Model.

    Parameters
    ----------

    gmmhandle : MaybeSequence[HHandle]
                GMM handle.

    See Also
    --------
    create_class_gmm, read_class_gmm, write_class_gmm, train_class_gmm

    Predecessors
    ------------
    classify_class_gmm, evaluate_class_gmm
    """
    with HalconOperator(1824) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.execute()


def clear_class_knn(knnhandle: HHandle) -> None:
    """
    Clear a k-NN classifier.

    Parameters
    ----------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    See Also
    --------
    create_class_knn

    Predecessors
    ------------
    train_class_knn, read_class_knn
    """
    with HalconOperator(1804) as proc:
        proc.set_input_tuple(0, knnhandle)
        proc.execute()


def clear_class_lut(class_luthandle: MaybeSequence[HHandle]) -> None:
    """
    Clear a look-up table classifier.

    Parameters
    ----------

    class_luthandle : MaybeSequence[HHandle]
                      Handle of the LUT classifier.

    See Also
    --------
    create_class_lut_mlp, create_class_lut_svm, create_class_lut_gmm

    Predecessors
    ------------
    classify_image_class_lut
    """
    with HalconOperator(1818) as proc:
        proc.set_input_tuple(0, class_luthandle)
        proc.execute()


def clear_class_mlp(mlphandle: MaybeSequence[HHandle]) -> None:
    """
    Clear a multilayer perceptron.

    Parameters
    ----------

    mlphandle : MaybeSequence[HHandle]
                MLP handle.

    See Also
    --------
    create_class_mlp, read_class_mlp, write_class_mlp, train_class_mlp

    Predecessors
    ------------
    classify_class_mlp, evaluate_class_mlp
    """
    with HalconOperator(1863) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.execute()


def clear_class_svm(svmhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear a support vector machine.

    Parameters
    ----------

    svmhandle : MaybeSequence[HHandle]
                SVM handle.

    See Also
    --------
    create_class_svm, read_class_svm, write_class_svm, train_class_svm

    Predecessors
    ------------
    classify_class_svm
    """
    with HalconOperator(1842) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.execute()


def clear_class_train_data(class_train_data_handle: HHandle) -> None:
    """
    Clears training data for classifiers.

    Parameters
    ----------

    class_train_data_handle : HHandle
                              Handle of training data for a classifier.

    See Also
    --------
    create_class_train_data

    Predecessors
    ------------
    create_class_train_data
    """
    with HalconOperator(1796) as proc:
        proc.set_input_tuple(0, class_train_data_handle)
        proc.execute()


def clear_color_trans_lut(color_trans_luthandle: HHandle) -> None:
    """
    Release the look-up-table needed for color space transformation.

    Parameters
    ----------

    color_trans_luthandle : HHandle
                            Handle of the look-up-table handle for the
                            color space transformation.

    See Also
    --------
    create_color_trans_lut, apply_color_trans_lut

    Predecessors
    ------------
    create_color_trans_lut, apply_color_trans_lut
    """
    with HalconOperator(1577) as proc:
        proc.set_input_tuple(0, color_trans_luthandle)
        proc.execute()


def clear_component_model(component_model_id: HHandle) -> None:
    """
    Free the memory of a component model.

    Parameters
    ----------

    component_model_id : HHandle
                         Handle of the component model.

    Predecessors
    ------------
    create_component_model, create_trained_component_model,
    read_component_model, write_component_model
    """
    with HalconOperator(997) as proc:
        proc.set_input_tuple(0, component_model_id)
        proc.execute()


def clear_condition(condition_handle: HHandle) -> None:
    """
    Destroy a condition synchronization object.

    Parameters
    ----------

    condition_handle : HHandle
                       Condition synchronization object.

    See Also
    --------
    create_condition

    Predecessors
    ------------
    create_condition
    """
    with HalconOperator(543) as proc:
        proc.set_input_tuple(0, condition_handle)
        proc.execute()


def clear_data_code_2d_model(data_code_handle: HHandle) -> None:
    """
    Delete a 2D data code model and free the allocated memory.

    Parameters
    ----------

    data_code_handle : HHandle
                       Handle of the 2D data code model.

    See Also
    --------
    create_data_code_2d_model, read_data_code_2d_model
    """
    with HalconOperator(1777) as proc:
        proc.set_input_tuple(0, data_code_handle)
        proc.execute()


def clear_deformable_model(model_id: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a deformable model.

    Parameters
    ----------

    model_id : MaybeSequence[HHandle]
               Handle of the model.

    See Also
    --------
    create_planar_uncalib_deformable_model,
    create_planar_calib_deformable_model, create_local_deformable_model
    """
    with HalconOperator(968) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_deformable_surface_matching_result(
    deformable_surface_matching_result: MaybeSequence[HHandle]
) -> None:
    """
    Free the memory of a deformable surface matching result.

    Parameters
    ----------

    deformable_surface_matching_result : MaybeSequence[HHandle]
                                         Handle of the deformable surface
                                         matching result.

    See Also
    --------
    find_deformable_surface_model, refine_deformable_surface_model

    Predecessors
    ------------
    find_deformable_surface_model, refine_deformable_surface_model
    """
    with HalconOperator(1020) as proc:
        proc.set_input_tuple(0, deformable_surface_matching_result)
        proc.execute()


def clear_deformable_surface_model(
    deformable_surface_model: MaybeSequence[HHandle]
) -> None:
    """
    Free the memory of a deformable surface model.

    Parameters
    ----------

    deformable_surface_model : MaybeSequence[HHandle]
                               Handle of the deformable surface model.

    See Also
    --------
    read_deformable_surface_model, create_deformable_surface_model

    Predecessors
    ------------
    read_deformable_surface_model, create_deformable_surface_model
    """
    with HalconOperator(1021) as proc:
        proc.set_input_tuple(0, deformable_surface_model)
        proc.execute()


def clear_descriptor_model(model_id: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a descriptor model.

    Parameters
    ----------

    model_id : MaybeSequence[HHandle]
               Handle of the descriptor model.

    See Also
    --------
    create_uncalib_descriptor_model, create_calib_descriptor_model
    """
    with HalconOperator(943) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_distance_transform_xld(distance_transform_id: HHandle) -> None:
    """
    Clear a XLD distance transform.

    Parameters
    ----------

    distance_transform_id : HHandle
                            Handle of the XLD distance transform.

    See Also
    --------
    apply_distance_transform_xld, get_distance_transform_xld_contour,
    get_distance_transform_xld_param, set_distance_transform_xld_param,
    read_distance_transform_xld, deserialize_distance_transform_xld

    Predecessors
    ------------
    create_distance_transform_xld, write_distance_transform_xld,
    serialize_distance_transform_xld
    """
    with HalconOperator(1351) as proc:
        proc.set_input_tuple(0, distance_transform_id)
        proc.execute()


def clear_dl_classifier(
    dlclassifier_handle: MaybeSequence[HHandle]
) -> None:
    """
    Clear a deep-learning-based classifier.

    Parameters
    ----------

    dlclassifier_handle : MaybeSequence[HHandle]
                          Handle of the deep-learning-based classifier.

    Predecessors
    ------------
    read_dl_classifier, apply_dl_classifier, train_dl_classifier_batch

    Warnings
    --------
    clear_dl_classifier is obsolete and is only provided for reasons of
    backward compatibility.  New applications should use the common used
    CNN-based operator clear_dl_model instead.
    """
    with HalconOperator(2103) as proc:
        proc.set_input_tuple(0, dlclassifier_handle)
        proc.execute()


def clear_dl_classifier_result(
    dlclassifier_result_handle: MaybeSequence[HHandle]
) -> None:
    """
    Clear a handle containing the results of the deep-learning-based
    classification.

    Parameters
    ----------

    dlclassifier_result_handle : MaybeSequence[HHandle]
                                 Handle of the deep learning
                                 classification results.

    Predecessors
    ------------
    get_dl_classifier_result, apply_dl_classifier

    Warnings
    --------
    clear_dl_classifier_result is obsolete and is only provided for
    reasons of backward compatibility.
    """
    with HalconOperator(2104) as proc:
        proc.set_input_tuple(0, dlclassifier_result_handle)
        proc.execute()


def clear_dl_classifier_train_result(
    dlclassifier_train_result_handle: MaybeSequence[HHandle]
) -> None:
    """
    Clear the handle of a deep-learning-based classifier training result.

    Parameters
    ----------

    dlclassifier_train_result_handle : MaybeSequence[HHandle]
                                       Handle of the training results from
                                       the deep-learning-based classifier.

    Predecessors
    ------------
    train_dl_classifier_batch, get_dl_classifier_train_result

    Warnings
    --------
    clear_dl_classifier_train_result is obsolete and is only provided for
    reasons of backward compatibility.
    """
    with HalconOperator(2105) as proc:
        proc.set_input_tuple(0, dlclassifier_train_result_handle)
        proc.execute()


def clear_dl_model(dlmodel_handle: MaybeSequence[HHandle]) -> None:
    """
    Clear a deep learning model.

    Parameters
    ----------

    dlmodel_handle : MaybeSequence[HHandle]
                     Handle of the deep learning model.

    Predecessors
    ------------
    read_dl_model, apply_dl_model, train_dl_model_batch,
    train_dl_model_anomaly_dataset
    """
    with HalconOperator(2147) as proc:
        proc.set_input_tuple(0, dlmodel_handle)
        proc.execute()


def clear_drawing_object(draw_id: HHandle) -> None:
    """
    Delete drawing object.

    Parameters
    ----------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_xld,
    create_drawing_object_line, create_drawing_object_circle,
    create_drawing_object_text

    Predecessors
    ------------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_xld,
    create_drawing_object_line, create_drawing_object_circle,
    create_drawing_object_text, detach_drawing_object_from_window,
    attach_drawing_object_to_window

    Successors
    ----------
    clear_window, close_window
    """
    with HalconOperator(1303) as proc:
        proc.set_input_tuple(0, draw_id)
        proc.execute()


def clear_event(event_handle: HHandle) -> None:
    """
    Clear the event synchronization object.

    Parameters
    ----------

    event_handle : HHandle
                   Event synchronization object.

    See Also
    --------
    create_event

    Predecessors
    ------------
    create_event
    """
    with HalconOperator(554) as proc:
        proc.set_input_tuple(0, event_handle)
        proc.execute()


def clear_handle(handle: MaybeSequence[HHandle]) -> None:
    """
    Clear the content of a handle.

    Parameters
    ----------

    handle : MaybeSequence[HHandle]
             Handle to clear.

    See Also
    --------
    tuple_is_valid_handle
    """
    with HalconOperator(2134) as proc:
        proc.set_input_tuple(0, handle)
        proc.execute()


def clear_lexicon(lexicon_handle: HHandle) -> None:
    """
    Clear a lexicon.

    Parameters
    ----------

    lexicon_handle : HHandle
                     Handle of the lexicon.

    See Also
    --------
    create_lexicon
    """
    with HalconOperator(666) as proc:
        proc.set_input_tuple(0, lexicon_handle)
        proc.execute()


def clear_matrix(matrix_id: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a matrix.

    Parameters
    ----------

    matrix_id : MaybeSequence[HHandle]
                Matrix handle.

    Predecessors
    ------------
    create_matrix
    """
    with HalconOperator(896) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.execute()


def clear_message(message_handle: MaybeSequence[HHandle]) -> None:
    """
    Close a message handle and release all associated resources.

    Parameters
    ----------

    message_handle : MaybeSequence[HHandle]
                     Message handle(s) to be closed.
                     Assertion: MessageHandle != 0

    See Also
    --------
    create_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj, set_message_param, get_message_param,
    enqueue_message, dequeue_message

    Predecessors
    ------------
    create_message, dequeue_message

    Notes
    -----
    The handle(s) must not be used again after being invalidated using
    clear_message. Using an invalid handle results in undefined behavior.
    """
    with HalconOperator(540) as proc:
        proc.set_input_tuple(0, message_handle)
        proc.execute()


def clear_message_queue(queue_handle: MaybeSequence[HHandle]) -> None:
    """
    Close a message queue handle and release all associated resources.

    Parameters
    ----------

    queue_handle : MaybeSequence[HHandle]
                   Message queue handle(s) to be closed.
                   Assertion: QueueHandle != 0

    See Also
    --------
    create_message_queue, enqueue_message, dequeue_message,
    set_message_queue_param, get_message_queue_param, create_message,
    clear_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj

    Predecessors
    ------------
    create_message_queue, set_message_queue_param

    Notes
    -----
    The handle(s) must not be used again after being invalidated using
    clear_message_queue. Using an invalid handle results in undefined
    behavior. Operator clear_message_queue must not be called while the
    handle is used concurrently from other threads, because this would
    result in undefined behavior.
    """
    with HalconOperator(532) as proc:
        proc.set_input_tuple(0, queue_handle)
        proc.execute()


def clear_metrology_model(metrology_handle: HHandle) -> None:
    """
    Delete a metrology model and free the allocated memory.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    Predecessors
    ------------
    get_metrology_object_result, write_metrology_model
    """
    with HalconOperator(817) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.execute()


def clear_metrology_object(
    metrology_handle: HHandle,
    index: MaybeSequence[Union[str, int]]
) -> None:
    """
    Delete metrology objects and free the allocated memory.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    index : MaybeSequence[Union[str, int]]
            Index of the metrology objects.
            Value Suggestion: all
    """
    with HalconOperator(818) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, index)
        proc.execute()


def clear_mutex(mutex_handle: HHandle) -> None:
    """
    Clear the mutex synchronization object.

    Parameters
    ----------

    mutex_handle : HHandle
                   Mutex synchronization object.

    See Also
    --------
    create_mutex

    Predecessors
    ------------
    create_mutex
    """
    with HalconOperator(560) as proc:
        proc.set_input_tuple(0, mutex_handle)
        proc.execute()


def clear_ncc_model(model_id: HHandle) -> None:
    """
    Free the memory of an NCC model.

    Parameters
    ----------

    model_id : HHandle
               Handle of the model.

    Predecessors
    ------------
    create_ncc_model, read_ncc_model, write_ncc_model, find_ncc_model,
    find_ncc_models
    """
    with HalconOperator(982) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_obj(objects: HObject) -> None:
    """
    Delete an iconic object from the HALCON database.

    Parameters
    ----------

    objects : HObject
              Objects to be deleted.

    See Also
    --------
    set_check

    Alternatives
    ------------
    reset_obj_db

    Notes
    -----
    Regarding the use of local variables in HALCON/C: When exiting a
    subroutine, the local variables are deleted, but the HALCON database
    is not updated. To update the database and thus free the memory, you
    must explicitly clear the local objects from the database before
    exiting the subroutine.
    """
    with HalconOperator(585) as proc:
        proc.set_input_object(1, objects)
        proc.execute()


def clear_object_model_3d(object_model_3d: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d
    """
    with HalconOperator(1100) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.execute()


def clear_ocr_class_cnn(ocrhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear an CNN-based OCR classifier.

    Parameters
    ----------

    ocrhandle : MaybeSequence[HHandle]
                Handle of the OCR classifier.

    See Also
    --------
    read_ocr_class_cnn

    Predecessors
    ------------
    do_ocr_single_class_cnn, do_ocr_multi_class_cnn, do_ocr_word_cnn
    """
    with HalconOperator(2046) as proc:
        proc.set_input_tuple(0, ocrhandle)
        proc.execute()


def clear_ocr_class_knn(ocrhandle: HHandle) -> None:
    """
    Clear an OCR classifier.

    Parameters
    ----------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    create_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(653) as proc:
        proc.set_input_tuple(0, ocrhandle)
        proc.execute()


def clear_ocr_class_mlp(ocrhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear an OCR classifier.

    Parameters
    ----------

    ocrhandle : MaybeSequence[HHandle]
                Handle of the OCR classifier.

    See Also
    --------
    create_ocr_class_mlp, read_ocr_class_mlp, write_ocr_class_mlp,
    trainf_ocr_class_mlp

    Predecessors
    ------------
    do_ocr_single_class_mlp, do_ocr_multi_class_mlp
    """
    with HalconOperator(691) as proc:
        proc.set_input_tuple(0, ocrhandle)
        proc.execute()


def clear_ocr_class_svm(ocrhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear an SVM-based OCR classifier.

    Parameters
    ----------

    ocrhandle : MaybeSequence[HHandle]
                Handle of the OCR classifier.

    See Also
    --------
    create_ocr_class_svm, read_ocr_class_svm, write_ocr_class_svm,
    trainf_ocr_class_svm

    Predecessors
    ------------
    do_ocr_single_class_svm, do_ocr_multi_class_svm
    """
    with HalconOperator(673) as proc:
        proc.set_input_tuple(0, ocrhandle)
        proc.execute()


def clear_rectangle(
    window_handle: HHandle,
    row_1: MaybeSequence[int],
    column_1: MaybeSequence[int],
    row_2: MaybeSequence[int],
    column_2: MaybeSequence[int]
) -> None:
    """
    Delete a rectangle on the output window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_1 : MaybeSequence[int]
            Line index of upper left corner.
            Value Suggestion: 10

    column_1 : MaybeSequence[int]
               Column index of upper left corner.
               Value Suggestion: 10

    row_2 : MaybeSequence[int]
            Row index of lower right corner.
            Value Suggestion: 118
            Assertion: Row2 > Row1

    column_2 : MaybeSequence[int]
               Column index of lower right corner.
               Value Suggestion: 118
               Assertion: Column2 >= Column1

    See Also
    --------
    open_window

    Alternatives
    ------------
    clear_window, disp_rectangle1

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi, draw_rectangle1

    Warnings
    --------
    clear_rectangle is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(1189) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_1)
        proc.set_input_tuple(2, column_1)
        proc.set_input_tuple(3, row_2)
        proc.set_input_tuple(4, column_2)
        proc.execute()


def clear_sample_identifier(sample_identifier: HHandle) -> None:
    """
    Free the memory of a sample identifier.

    Parameters
    ----------

    sample_identifier : HHandle
                        Handle of the sample identifier.

    See Also
    --------
    create_sample_identifier, add_sample_identifier_preparation_data,
    prepare_sample_identifier, add_sample_identifier_training_data,
    train_sample_identifier, apply_sample_identifier,
    set_sample_identifier_param, get_sample_identifier_param,
    get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, read_sample_identifier,
    deserialize_sample_identifier, set_sample_identifier_object_info

    Predecessors
    ------------
    write_sample_identifier, serialize_sample_identifier
    """
    with HalconOperator(899) as proc:
        proc.set_input_tuple(0, sample_identifier)
        proc.execute()


def clear_samples_class_gmm(gmmhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear the training data of a Gaussian Mixture Model.

    Parameters
    ----------

    gmmhandle : MaybeSequence[HHandle]
                GMM handle.

    See Also
    --------
    create_class_gmm, clear_class_gmm, add_sample_class_gmm,
    read_samples_class_gmm

    Predecessors
    ------------
    train_class_gmm, write_samples_class_gmm
    """
    with HalconOperator(1825) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.execute()


def clear_samples_class_mlp(mlphandle: MaybeSequence[HHandle]) -> None:
    """
    Clear the training data of a multilayer perceptron.

    Parameters
    ----------

    mlphandle : MaybeSequence[HHandle]
                MLP handle.

    See Also
    --------
    create_class_mlp, clear_class_mlp, add_sample_class_mlp,
    read_samples_class_mlp

    Predecessors
    ------------
    train_class_mlp, write_samples_class_mlp
    """
    with HalconOperator(1864) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.execute()


def clear_samples_class_svm(svmhandle: MaybeSequence[HHandle]) -> None:
    """
    Clear the training data of a support vector machine.

    Parameters
    ----------

    svmhandle : MaybeSequence[HHandle]
                SVM handle.

    See Also
    --------
    create_class_svm, clear_class_svm, add_sample_class_svm,
    read_samples_class_svm

    Predecessors
    ------------
    train_class_svm, write_samples_class_svm
    """
    with HalconOperator(1843) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.execute()


def clear_sampset(samp_key: HHandle) -> None:
    """
    Free memory of a data set.

    Parameters
    ----------

    samp_key : HHandle
               Number of the data set.

    See Also
    --------
    test_sampset_box, learn_sampset_box, read_sampset

    Predecessors
    ------------
    create_class_box, enquire_class_box, learn_class_box, write_class_box

    Warnings
    --------
    clear_sampset is obsolete and is only provided for reasons of backward
    compatibility. New applications should use the MLP, SVM, KNN or GMM
    operators instead.
    """
    with HalconOperator(1893) as proc:
        proc.set_input_tuple(0, samp_key)
        proc.execute()


def clear_scattered_data_interpolator(
    scattered_data_interpolator_handle: MaybeSequence[HHandle]
) -> None:
    """
    Clear a scattered data interpolator.

    Parameters
    ----------

    scattered_data_interpolator_handle : MaybeSequence[HHandle]
                                         Handle of the scattered data
                                         interpolator

    Predecessors
    ------------
    create_scattered_data_interpolator, interpolate_scattered_data
    """
    with HalconOperator(290) as proc:
        proc.set_input_tuple(0, scattered_data_interpolator_handle)
        proc.execute()


def clear_scene_3d(scene_3d: MaybeSequence[HHandle]) -> None:
    """
    Delete a 3D scene and free all allocated memory.

    Parameters
    ----------

    scene_3d : MaybeSequence[HHandle]
               Handle of the 3D scene.

    Predecessors
    ------------
    display_scene_3d
    """
    with HalconOperator(1219) as proc:
        proc.set_input_tuple(0, scene_3d)
        proc.execute()


def clear_serial(serial_handle: HHandle, channel: str) -> None:
    """
    Clear the buffer of a serial connection.

    Parameters
    ----------

    serial_handle : HHandle
                    Serial interface handle.

    channel : str
              Buffer to be cleared.
              Value Suggestion: input

    See Also
    --------
    read_serial

    Predecessors
    ------------
    open_serial

    Successors
    ----------
    read_serial, write_serial
    """
    with HalconOperator(307) as proc:
        proc.set_input_tuple(0, serial_handle)
        proc.set_input_tuple(1, channel)
        proc.execute()


def clear_serialized_item(
    serialized_item_handle: MaybeSequence[HHandle]
) -> None:
    """
    Delete a serialized item.

    Parameters
    ----------

    serialized_item_handle : MaybeSequence[HHandle]
                             Handle of the serialized item.

    Predecessors
    ------------
    fwrite_serialized_item, receive_serialized_item
    """
    with HalconOperator(408) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()


def clear_shape_model(model_id: HHandle) -> None:
    """
    Free the memory of a shape model.

    Parameters
    ----------

    model_id : HHandle
               Handle of the model.

    Predecessors
    ------------
    create_generic_shape_model, write_shape_model
    """
    with HalconOperator(921) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_shape_model_3d(shape_model_3did: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a 3D shape model.

    Parameters
    ----------

    shape_model_3did : MaybeSequence[HHandle]
                       Handle of the 3D shape model.

    Predecessors
    ------------
    create_shape_model_3d, read_shape_model_3d, write_shape_model_3d
    """
    with HalconOperator(1049) as proc:
        proc.set_input_tuple(0, shape_model_3did)
        proc.execute()


def clear_sheet_of_light_model(sheet_of_light_model_id: HHandle) -> None:
    """
    Delete a sheet-of-light model and free the allocated memory.

    Parameters
    ----------

    sheet_of_light_model_id : HHandle
                              Handle of the sheet-of-light model.

    See Also
    --------
    create_sheet_of_light_model
    """
    with HalconOperator(390) as proc:
        proc.set_input_tuple(0, sheet_of_light_model_id)
        proc.execute()


def clear_stereo_model(stereo_model_id: HHandle) -> None:
    """
    Free the memory of a stereo model.

    Parameters
    ----------

    stereo_model_id : HHandle
                      Handle of the stereo model.
    """
    with HalconOperator(519) as proc:
        proc.set_input_tuple(0, stereo_model_id)
        proc.execute()


def clear_structured_light_model(
    structured_light_model: MaybeSequence[HHandle]
) -> None:
    """
    Clear a structured light model and free the allocated memory.

    Parameters
    ----------

    structured_light_model : MaybeSequence[HHandle]
                             Handle of the structured light model.

    See Also
    --------
    create_structured_light_model
    """
    with HalconOperator(2106) as proc:
        proc.set_input_tuple(0, structured_light_model)
        proc.execute()


def clear_surface_matching_result(
    surface_matching_result_id: MaybeSequence[HHandle]
) -> None:
    """
    Free the memory of a surface matching result.

    Parameters
    ----------

    surface_matching_result_id : MaybeSequence[HHandle]
                                 Handle of the surface matching result.

    See Also
    --------
    find_surface_model, refine_surface_model_pose

    Predecessors
    ------------
    find_surface_model, refine_surface_model_pose
    """
    with HalconOperator(1034) as proc:
        proc.set_input_tuple(0, surface_matching_result_id)
        proc.execute()


def clear_surface_model(surface_model_id: MaybeSequence[HHandle]) -> None:
    """
    Free the memory of a surface model.

    Parameters
    ----------

    surface_model_id : MaybeSequence[HHandle]
                       Handle of the surface model.

    See Also
    --------
    read_surface_model, create_surface_model

    Predecessors
    ------------
    read_surface_model, create_surface_model
    """
    with HalconOperator(1036) as proc:
        proc.set_input_tuple(0, surface_model_id)
        proc.execute()


def clear_template(template_id: HHandle) -> None:
    """
    Deallocation of the memory of a template.

    Parameters
    ----------

    template_id : HHandle
                  Template number.

    Predecessors
    ------------
    create_template, create_template_rot, read_template, write_template

    Warnings
    --------
    clear_template is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1495) as proc:
        proc.set_input_tuple(0, template_id)
        proc.execute()


def clear_text_model(text_model: MaybeSequence[HHandle]) -> None:
    """
    Clear a text model.

    Parameters
    ----------

    text_model : MaybeSequence[HHandle]
                 Text model to be cleared.

    See Also
    --------
    create_text_model_reader
    """
    with HalconOperator(421) as proc:
        proc.set_input_tuple(0, text_model)
        proc.execute()


def clear_text_result(text_result_id: MaybeSequence[HHandle]) -> None:
    """
    Clear a text result.

    Parameters
    ----------

    text_result_id : MaybeSequence[HHandle]
                     Text result to be cleared.
    """
    with HalconOperator(414) as proc:
        proc.set_input_tuple(0, text_result_id)
        proc.execute()


def clear_texture_inspection_model(
    texture_inspection_model: MaybeSequence[HHandle]
) -> None:
    """
    Clear a texture inspection model and free the allocated memory.

    Parameters
    ----------

    texture_inspection_model : MaybeSequence[HHandle]
                               Handle of the texture inspection model.

    See Also
    --------
    create_texture_inspection_model
    """
    with HalconOperator(2047) as proc:
        proc.set_input_tuple(0, texture_inspection_model)
        proc.execute()


def clear_texture_inspection_result(
    texture_inspection_result_id: MaybeSequence[HHandle]
) -> None:
    """
    Clear a texture inspection result handle and free the allocated
    memory.

    Parameters
    ----------

    texture_inspection_result_id : MaybeSequence[HHandle]
                                   Handle of the texture inspection
                                   results.

    Predecessors
    ------------
    apply_texture_inspection_model
    """
    with HalconOperator(2048) as proc:
        proc.set_input_tuple(0, texture_inspection_result_id)
        proc.execute()


def clear_train_data_variation_model(model_id: HHandle) -> None:
    """
    Free the memory of the training data of a variation model.

    Parameters
    ----------

    model_id : HHandle
               ID of the variation model.

    Predecessors
    ------------
    prepare_variation_model

    Successors
    ----------
    compare_variation_model, compare_ext_variation_model,
    write_variation_model
    """
    with HalconOperator(94) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_training_components(component_training_id: HHandle) -> None:
    """
    Free the memory of a component training result.

    Parameters
    ----------

    component_training_id : HHandle
                            Handle of the training result.

    Predecessors
    ------------
    train_model_components, write_training_components
    """
    with HalconOperator(1007) as proc:
        proc.set_input_tuple(0, component_training_id)
        proc.execute()


def clear_variation_model(model_id: HHandle) -> None:
    """
    Free the memory of a variation model.

    Parameters
    ----------

    model_id : HHandle
               ID of the variation model.

    Predecessors
    ------------
    create_variation_model
    """
    with HalconOperator(93) as proc:
        proc.set_input_tuple(0, model_id)
        proc.execute()


def clear_window(window_handle: HHandle) -> None:
    """
    Delete the contents of an output window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    open_window

    Alternatives
    ------------
    clear_rectangle, disp_rectangle1

    Predecessors
    ------------
    open_window
    """
    with HalconOperator(1188) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def clip_contours_xld(
    contours: HObject,
    row_1: int,
    column_1: int,
    row_2: int,
    column_2: int
) -> HObject:
    """
    Clip an XLD contour.

    Parameters
    ----------

    contours : HObject
               Contours to be clipped.

    row_1 : int
            Row coordinate of the upper left corner of the clip rectangle.
            Value Suggestion: 0

    column_1 : int
               Column coordinate of the upper left corner of the clip
               rectangle.
               Value Suggestion: 0

    row_2 : int
            Row coordinate of the lower right corner of the clip rectangle.
            Value Suggestion: 512

    column_2 : int
               Column coordinate of the lower right corner of the clip
               rectangle.
               Value Suggestion: 512

    Returns
    -------

    clipped_contours : HObject
                       Clipped contours.

    See Also
    --------
    clip_region, crop_part, crop_contours_xld

    Alternatives
    ------------
    crop_contours_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, lines_gauss, lines_facet, edges_sub_pix

    Successors
    ----------
    gen_polygons_xld
    """
    with HalconOperator(52) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.execute()
        clipped_contours = HObject(proc.get_output_object_key(1))
        return clipped_contours  # type: ignore


def clip_end_points_contours_xld(
    contours: HObject,
    mode: str,
    length: Union[int, float]
) -> HObject:
    """
    Clip the end points of an XLD contour.

    Parameters
    ----------

    contours : HObject
               Input contour

    mode : str
           Clipping mode.
           Value Suggestion: num_points

    length : Union[int, float]
             Clipping length in unit pixels (Mode $=$ 'length') or number
             (Mode $=$ 'num_points')
             Value Suggestion: 3

    Returns
    -------

    clipped_contours : HObject
                       Clipped contour

    See Also
    --------
    clip_contours_xld, crop_contours_xld

    Predecessors
    ------------
    segment_contours_xld
    """
    with HalconOperator(51) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, length)
        proc.execute()
        clipped_contours = HObject(proc.get_output_object_key(1))
        return clipped_contours  # type: ignore


def clip_region(
    region: HObject,
    row_1: int,
    column_1: int,
    row_2: int,
    column_2: int
) -> HObject:
    """
    Clip a region to a rectangle.

    Parameters
    ----------

    region : HObject
             Region to be clipped.

    row_1 : int
            Row coordinate of the upper left corner of the rectangle.
            Value Suggestion: 0

    column_1 : int
               Column coordinate of the upper left corner of the rectangle.
               Value Suggestion: 0

    row_2 : int
            Row coordinate of the lower right corner of the rectangle.
            Value Suggestion: 256

    column_2 : int
               Column coordinate of the lower right corner of the
               rectangle.
               Value Suggestion: 256

    Returns
    -------

    region_clipped : HObject
                     Clipped regions.

    Alternatives
    ------------
    intersection, gen_rectangle1, clip_region_rel

    Predecessors
    ------------
    threshold, connection, regiongrowing, pouring

    Successors
    ----------
    select_shape, disp_region
    """
    with HalconOperator(499) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.execute()
        region_clipped = HObject(proc.get_output_object_key(1))
        return region_clipped  # type: ignore


def clip_region_rel(
    region: HObject,
    top: int,
    bottom: int,
    left: int,
    right: int
) -> HObject:
    """
    Clip a region relative to its smallest surrounding rectangle.

    Parameters
    ----------

    region : HObject
             Regions to be clipped.

    top : int
          Number of rows clipped at the top.
          Value Suggestion: 1

    bottom : int
             Number of rows clipped at the bottom.
             Value Suggestion: 1

    left : int
           Number of columns clipped at the left.
           Value Suggestion: 1

    right : int
            Number of columns clipped at the right.
            Value Suggestion: 1

    Returns
    -------

    region_clipped : HObject
                     Clipped regions.

    Alternatives
    ------------
    smallest_rectangle1, intersection, gen_rectangle1, clip_region

    Predecessors
    ------------
    threshold, connection, regiongrowing, pouring

    Successors
    ----------
    select_shape, disp_region
    """
    with HalconOperator(498) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, top)
        proc.set_input_tuple(1, bottom)
        proc.set_input_tuple(2, left)
        proc.set_input_tuple(3, right)
        proc.execute()
        region_clipped = HObject(proc.get_output_object_key(1))
        return region_clipped  # type: ignore


def close_all_bg_esti() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    background estimation data sets.

    Warnings
    --------
    close_all_bg_esti is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    close_all_bg_esti, the operator will be removed in future versions.

    Notes
    -----
    close_all_bg_esti exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_bg_esti must
    not be used in any application.
    """
    with HalconOperator(2009) as proc:
        proc.execute()


def close_all_class_box() -> None:
    """
    This operator is inoperable. It had the following function: Destroy
    all classifiers.

    Warnings
    --------
    close_all_class_box is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    close_all_class_box, the operator will be removed in future version.

    Notes
    -----
    close_all_class_box exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_class_box must
    not be used in any application.
    """
    with HalconOperator(1900) as proc:
        proc.execute()


def close_all_files() -> None:
    """
    This operator is inoperable. It had the following function: Close all
    open files.

    Warnings
    --------
    close_all_files is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    close_all_files, the operator will be removed in future version.

    Notes
    -----
    close_all_files exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_files must not
    be used in any application.
    """
    with HalconOperator(1666) as proc:
        proc.execute()


def close_all_framegrabbers() -> None:
    """
    This operator is inoperable. It had the following function: Close all
    image acquisition devices.

    Warnings
    --------
    close_all_framegrabbers is obsolete, inoperable, and is only provided
    for reasons of backward compatibility.  New applications should not
    use close_all_framegrabbers, the operator will be removed in future
    versions.

    Notes
    -----
    close_all_framegrabbers exists solely for the purpose of implementing
    the ``reset program'' functionality in HDevelop.
    close_all_framegrabbers must not be used in any application.
    For a multithreaded application all image acquisition operators (as
    listed in open_framegrabber) are an own group in which
    info_framegrabber, open_framegrabber, close_framegrabber and
    close_all_framegrabbers are executed exclusively.
    Thus, info_framegrabber, open_framegrabber, close_framegrabber and
    close_all_framegrabbers block the concurrent execution of all other
    operators within this group, but run in parallel with all
    non-exclusive operators outside of this group.
    """
    with HalconOperator(2035) as proc:
        proc.execute()


def close_all_measures() -> None:
    """
    This operator is inoperable. It had the following function: Delete all
    measure objects.

    Warnings
    --------
    close_all_measures is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    close_all_measures, the operator will be removed in future versions.

    Notes
    -----
    close_all_measures exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_measures must
    not be used in any application.
    """
    with HalconOperator(826) as proc:
        proc.execute()


def close_all_ocrs() -> None:
    """
    This operator is inoperable. It had the following function: Destroy
    all OCR classifiers.

    Warnings
    --------
    close_all_ocrs is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    close_all_ocrs, the operator will be removed in future versions.

    Notes
    -----
    close_all_ocrs exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_ocrs must not
    be used in any application.
    """
    with HalconOperator(724) as proc:
        proc.execute()


def close_all_ocvs() -> None:
    """
    This operator is inoperable. It had the following function: Clear all
    OCV tools.

    Warnings
    --------
    close_all_ocvs is obsolete, inoperable, and is only provided for
    reasons of backward compatibility.  New applications should not use
    close_all_ocvs, the operator will be removed in future versions.

    Notes
    -----
    close_all_ocvs exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_ocvs must not
    be used in any application.
    """
    with HalconOperator(644) as proc:
        proc.execute()


def close_all_serials() -> None:
    """
    This operator is inoperable. It had the following function: Close all
    serial devices.

    Warnings
    --------
    close_all_serials is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    close_all_serials, the operator will be removed in future versions.

    Notes
    -----
    close_all_serials exists solely for the purpose of implementing the
    ``reset program'' functionality in HDevelop. close_all_serials must
    not be used in any application.
    """
    with HalconOperator(312) as proc:
        proc.execute()


def close_all_sockets() -> None:
    """
    This operator is inoperable. It had the following function: Close all
    opened sockets.

    Warnings
    --------
    close_all_sockets is obsolete, inoperable, and is only provided for
    reasons of backward compatibility. New applications should not use
    close_all_sockets, the operator will be removed in future versions.
    """
    with HalconOperator(339) as proc:
        proc.execute()


def close_bg_esti(bg_esti_handle: HHandle) -> None:
    """
    Delete the background estimation data set.

    Parameters
    ----------

    bg_esti_handle : HHandle
                     ID of the BgEsti data set.

    See Also
    --------
    create_bg_esti

    Predecessors
    ------------
    run_bg_esti
    """
    with HalconOperator(2002) as proc:
        proc.set_input_tuple(0, bg_esti_handle)
        proc.execute()


def close_class_box(classif_handle: HHandle) -> None:
    """
    Destroy the classifier.

    Parameters
    ----------

    classif_handle : HHandle
                     Handle of the classifier.

    See Also
    --------
    create_class_box, enquire_class_box, learn_class_box

    Predecessors
    ------------
    create_class_box, enquire_class_box, learn_class_box, write_class_box

    Warnings
    --------
    close_class_box is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the MLP, SVM, KNN
    or GMM operators instead.
    """
    with HalconOperator(1894) as proc:
        proc.set_input_tuple(0, classif_handle)
        proc.execute()


def close_contours_xld(contours: HObject) -> HObject:
    """
    Close an XLD contour.

    Parameters
    ----------

    contours : HObject
               Contours to be closed.

    Returns
    -------

    closed_contours : HObject
                      Closed contours.

    Predecessors
    ------------
    select_contours_xld

    Successors
    ----------
    area_center_xld, circularity_xld, compactness_xld, convexity_xld,
    eccentricity_xld, elliptic_axis_xld, moments_xld, moments_any_xld,
    orientation_xld, select_shape_xld, test_xld_point
    """
    with HalconOperator(50) as proc:
        proc.set_input_object(1, contours)
        proc.execute()
        closed_contours = HObject(proc.get_output_object_key(1))
        return closed_contours  # type: ignore


def close_edges(
    edges: HObject,
    edge_image: HObject,
    min_amplitude: int
) -> HObject:
    """
    Close edge gaps using the edge amplitude image.

    Parameters
    ----------

    edges : HObject
            Region containing one pixel thick edges.

    edge_image : HObject
                 Edge amplitude (gradient) image.

    min_amplitude : int
                    Minimum edge amplitude.
                    Value Suggestion: 16
                    Assertion: MinAmplitude >= 0

    Returns
    -------

    region_result : HObject
                    Region containing closed edges.

    See Also
    --------
    gray_skeleton

    Alternatives
    ------------
    close_edges_length, dilation1, closing

    Predecessors
    ------------
    edges_image, sobel_amp, threshold, skeleton

    Successors
    ----------
    skeleton

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1574) as proc:
        proc.set_input_object(1, edges)
        proc.set_input_object(2, edge_image)
        proc.set_input_tuple(0, min_amplitude)
        proc.execute()
        region_result = HObject(proc.get_output_object_key(1))
        return region_result  # type: ignore


def close_edges_length(
    edges: HObject,
    gradient: HObject,
    min_amplitude: int,
    max_gap_length: int
) -> HObject:
    """
    Close edge gaps using the edge amplitude image.

    Parameters
    ----------

    edges : HObject
            Region containing one pixel thick edges.

    gradient : HObject
               Edge amplitude (gradient) image.

    min_amplitude : int
                    Minimum edge amplitude.
                    Value Suggestion: 16
                    Assertion: MinAmplitude >= 0

    max_gap_length : int
                     Maximal number of points by which edges are extended.
                     Value Suggestion: 3
                     Assertion: MaxGapLength > 0 && MaxGapLength <= 127

    Returns
    -------

    closed_edges : HObject
                   Region containing closed edges.

    Alternatives
    ------------
    close_edges, dilation1, closing

    Predecessors
    ------------
    edges_image, sobel_amp, threshold, skeleton

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1573) as proc:
        proc.set_input_object(1, edges)
        proc.set_input_object(2, gradient)
        proc.set_input_tuple(0, min_amplitude)
        proc.set_input_tuple(1, max_gap_length)
        proc.execute()
        closed_edges = HObject(proc.get_output_object_key(1))
        return closed_edges  # type: ignore


def close_file(file_handle: MaybeSequence[HHandle]) -> None:
    """
    Closing a text file.

    Parameters
    ----------

    file_handle : MaybeSequence[HHandle]
                  File handle.

    See Also
    --------
    open_file

    Predecessors
    ------------
    open_file
    """
    with HalconOperator(1665) as proc:
        proc.set_input_tuple(0, file_handle)
        proc.execute()


def close_framegrabber(acq_handle: HHandle) -> None:
    """
    Close specified image acquisition device.

    Parameters
    ----------

    acq_handle : HHandle
                 Handle of the image acquisition device to be closed.

    See Also
    --------
    open_framegrabber

    Predecessors
    ------------
    grab_image, grab_image_async

    Notes
    -----
    For a multithreaded application all image acquisition operators (as
    listed in open_framegrabber) are an own group in which
    info_framegrabber, open_framegrabber, close_framegrabber and
    close_all_framegrabbers are executed exclusively.
    Thus, info_framegrabber, open_framegrabber, close_framegrabber and
    close_all_framegrabbers block the concurrent execution of all other
    operators within this group, but run in parallel with all
    non-exclusive operators outside of this group.
    """
    with HalconOperator(2036) as proc:
        proc.set_input_tuple(0, acq_handle)
        proc.execute()


def close_io_channel(iochannel_handle: MaybeSequence[HHandle]) -> None:
    """
    Close I/O channels.

    Parameters
    ----------

    iochannel_handle : MaybeSequence[HHandle]
                       Handles of the opened I/O channels.

    Predecessors
    ------------
    open_io_channel

    Successors
    ----------
    close_io_device
    """
    with HalconOperator(2015) as proc:
        proc.set_input_tuple(0, iochannel_handle)
        proc.execute()


def close_io_device(iodevice_handle: HHandle) -> None:
    """
    Close the specified I/O device.

    Parameters
    ----------

    iodevice_handle : HHandle
                      Handle of the opened I/O device.

    Predecessors
    ------------
    open_io_device
    """
    with HalconOperator(2021) as proc:
        proc.set_input_tuple(0, iodevice_handle)
        proc.execute()


def close_measure(measure_handle: HHandle) -> None:
    """
    Delete a measure object.

    Parameters
    ----------

    measure_handle : HHandle
                     Measure object handle.

    See Also
    --------
    clear_handle

    Alternatives
    ------------
    clear_handle

    Predecessors
    ------------
    gen_measure_rectangle2, gen_measure_arc, measure_pos, measure_pairs
    """
    with HalconOperator(827) as proc:
        proc.set_input_tuple(0, measure_handle)
        proc.execute()


def close_ocr(ocr_handle: HHandle) -> None:
    """
    Deallocation of the memory of an OCR classifier.

    Parameters
    ----------

    ocr_handle : HHandle
                 ID of the OCR classifier to be deleted.

    Predecessors
    ------------
    write_ocr_trainf

    Successors
    ----------
    read_ocr

    Warnings
    --------
    close_ocr is obsolete and is only provided for reasons of backward
    compatibility.  New applications should use the MLP, SVM or CNN based
    operators instead.

    Notes
    -----
    All data of the classifier will be deleted in main memory (not on the
    hard disk).
    """
    with HalconOperator(722) as proc:
        proc.set_input_tuple(0, ocr_handle)
        proc.execute()


def close_ocv(ocvhandle: HHandle) -> None:
    """
    Clear an OCV tool.

    Parameters
    ----------

    ocvhandle : HHandle
                Handle of the OCV tool which has to be freed.

    See Also
    --------
    close_ocr

    Predecessors
    ------------
    read_ocv, create_ocv_proj
    """
    with HalconOperator(645) as proc:
        proc.set_input_tuple(0, ocvhandle)
        proc.execute()


def close_serial(serial_handle: HHandle) -> None:
    """
    Close a serial device.

    Parameters
    ----------

    serial_handle : HHandle
                    Serial interface handle.

    See Also
    --------
    open_serial, close_file

    Predecessors
    ------------
    open_serial
    """
    with HalconOperator(313) as proc:
        proc.set_input_tuple(0, serial_handle)
        proc.execute()


def close_socket(socket: HHandle) -> None:
    """
    Close a socket.

    Parameters
    ----------

    socket : HHandle
             Socket number.

    Predecessors
    ------------
    open_socket_accept, open_socket_connect, socket_accept_connect
    """
    with HalconOperator(340) as proc:
        proc.set_input_tuple(0, socket)
        proc.execute()


def close_window(window_handle: MaybeSequence[HHandle]) -> None:
    """
    Close an output window.

    Parameters
    ----------

    window_handle : MaybeSequence[HHandle]
                    Window handle.

    See Also
    --------
    open_window

    Predecessors
    ------------
    open_window
    """
    with HalconOperator(1187) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def closest_point_transform(
    region: HObject,
    metric: str,
    foreground: str,
    closest_point_mode: str,
    width: int,
    height: int
) -> Tuple[HObject, HObject]:
    """
    Compute the closest-point transformation of a region.

    Parameters
    ----------

    region : HObject
             Region for which the distance to the border is computed.

    metric : str
             Type of metric to be used for the closest-point
             transformation.
             Value Suggestion: city-block

    foreground : str
                 Compute the distance for pixels inside (true) or outside
                 (false) the input region.
                 Value Suggestion: true

    closest_point_mode : str
                         Mode in which the coordinates of the closest
                         points are returned.
                         Value Suggestion: absolute

    width : int
            Width of the output images.
            Value Suggestion: 640

    height : int
             Height of the output images.
             Value Suggestion: 480

    Returns
    -------

    distances : HObject
                Image containing the distance information.

    closest_points : HObject
                     Image containing the coordinates of the closest
                     points.

    See Also
    --------
    skeleton

    Alternatives
    ------------
    distance_transform

    Predecessors
    ------------
    threshold, dyn_threshold, regiongrowing

    Successors
    ----------
    threshold, vector_field_to_real

    Notes
    -----
    It should be noted that the closest points are usually not unique,
    i.e., for each pixel in the image Distances, there usually exist
    several points on the outer border of the region that have the
    respective distance to that pixel.  For example, all points on the
    skeleton of the region in the chosen metric have the same distance to
    at least two distinct points on the outer border of the region.
    closest_point_transform returns one of these points that is determined
    by the implementation of the algorithm.  In particular, invariances
    with respect to rotation or mirroring of the region should not be
    expected.
    Furthermore, it should be noted that for Foreground $=$ 'true', point
    coordinates that lie outside the image defined by Width and Height are
    returned if the input region Region touches the border of this image,
    since in this case the outside border of the region lies one pixel
    outside of the image.  If the returned coordinates should be used for
    a direct access to an image, a suitable border treatment must be
    implemented.
    """
    with HalconOperator(484) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, metric)
        proc.set_input_tuple(1, foreground)
        proc.set_input_tuple(2, closest_point_mode)
        proc.set_input_tuple(3, width)
        proc.set_input_tuple(4, height)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # distances
            HObject(proc.get_output_object_key(2))   # closest_points
        )  # type: ignore


def closing(region: HObject, struct_element: HObject) -> HObject:
    """
    Close a region.

    Parameters
    ----------

    region : HObject
             Regions to be closed.

    struct_element : HObject
                     Structuring element (position-invariant).

    Returns
    -------

    region_closing : HObject
                     Closed regions.

    See Also
    --------
    dilation1, erosion1, opening, minkowski_sub1

    Alternatives
    ------------
    closing_circle

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm, gen_circle, gen_ellipse, gen_rectangle1,
    gen_rectangle2, draw_region, gen_region_points,
    gen_region_polygon_filled

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Notes
    -----
    closing is applied to each input region separately.  If gaps between
    different regions are to be closed, union1 or union2 has to be called
    first.
    """
    with HalconOperator(762) as proc:
        proc.set_input_object(1, region)
        proc.set_input_object(2, struct_element)
        proc.execute()
        region_closing = HObject(proc.get_output_object_key(1))
        return region_closing  # type: ignore


def closing_circle(
    region: HObject,
    radius: Union[float, int]
) -> HObject:
    """
    Close a region with a circular structuring element.

    Parameters
    ----------

    region : HObject
             Regions to be closed.

    radius : Union[float, int]
             Radius of the circular structuring element.
             Value Suggestion: 3.5

    Returns
    -------

    region_closing : HObject
                     Closed regions.

    See Also
    --------
    dilation1, minkowski_sub1, erosion1, opening

    Alternatives
    ------------
    rank_region, fill_up, closing

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Notes
    -----
    closing_circle is applied to each input region separately.  If gaps
    between different regions are to be closed, union1 or union2 has to be
    called first.
    """
    with HalconOperator(761) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, radius)
        proc.execute()
        region_closing = HObject(proc.get_output_object_key(1))
        return region_closing  # type: ignore


def closing_golay(
    region: HObject,
    golay_element: str,
    rotation: int
) -> HObject:
    """
    Close a region with an element from the Golay alphabet.

    Parameters
    ----------

    region : HObject
             Regions to be closed.

    golay_element : str
                    Structuring element from the Golay alphabet.
                    Value Suggestion: h

    rotation : int
               Rotation of the Golay element. Depending on the element,
               not all rotations are valid.
               Value Suggestion: 0

    Returns
    -------

    region_closing : HObject
                     Closed regions.

    See Also
    --------
    erosion_golay, dilation_golay, opening_golay, hit_or_miss_golay,
    thinning_golay, thickening_golay, golay_elements

    Alternatives
    ------------
    closing

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Warnings
    --------
    closing_golay is obsolete and is only provided for reasons of backward
    compatibility.

    Notes
    -----
    Not all values of Rotation are valid for any Golay element.  For some
    of the values of Rotation, the resulting regions are identical to the
    input regions.
    """
    with HalconOperator(760) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, golay_element)
        proc.set_input_tuple(1, rotation)
        proc.execute()
        region_closing = HObject(proc.get_output_object_key(1))
        return region_closing  # type: ignore


def closing_rectangle1(
    region: HObject,
    width: int,
    height: int
) -> HObject:
    """
    Close a region with a rectangular structuring element.

    Parameters
    ----------

    region : HObject
             Regions to be closed.

    width : int
            Width of the structuring rectangle.
            Value Suggestion: 10

    height : int
             Height of the structuring rectangle.
             Value Suggestion: 10

    Returns
    -------

    region_closing : HObject
                     Closed regions.

    See Also
    --------
    dilation_rectangle1, erosion_rectangle1, opening_rectangle1,
    gen_rectangle1

    Alternatives
    ------------
    closing

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Notes
    -----
    closing_rectangle1 is applied to each input region separately.  If
    gaps between different regions are to be closed, union1 or union2 has
    to be called first.
    """
    with HalconOperator(759) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, height)
        proc.execute()
        region_closing = HObject(proc.get_output_object_key(1))
        return region_closing  # type: ignore


def cluster_model_components(
    training_images: HObject,
    component_training_id: HHandle,
    ambiguity_criterion: str,
    max_contour_overlap: float,
    cluster_threshold: float
) -> HObject:
    """
    Adopt new parameters that are used to create the model components into
    the training result.

    Parameters
    ----------

    training_images : HObject
                      Training images that were used for training the
                      model components.

    component_training_id : HHandle
                            Handle of the training result.

    ambiguity_criterion : str
                          Criterion for solving the ambiguities.
                          Value Suggestion: rigidity

    max_contour_overlap : float
                          Maximum contour overlap of the found initial
                          components.
                          Value Suggestion: 0.2
                          Assertion: 0 <= MaxContourOverlap && MaxContourOverlap <= 1

    cluster_threshold : float
                        Threshold for clustering the initial components.
                        Value Suggestion: 0.5
                        Assertion: 0 <= ClusterThreshold && ClusterThreshold <= 1

    Returns
    -------

    model_components : HObject
                       Contour regions of rigid model components.

    Predecessors
    ------------
    train_model_components, inspect_clustered_components

    Successors
    ----------
    get_training_components, create_trained_component_model,
    modify_component_relations, write_training_components,
    get_component_relations, clear_training_components
    """
    with HalconOperator(1015) as proc:
        proc.set_input_object(1, training_images)
        proc.set_input_tuple(0, component_training_id)
        proc.set_input_tuple(1, ambiguity_criterion)
        proc.set_input_tuple(2, max_contour_overlap)
        proc.set_input_tuple(3, cluster_threshold)
        proc.execute()
        model_components = HObject(proc.get_output_object_key(1))
        return model_components  # type: ignore


def coherence_enhancing_diff(
    image: HObject,
    sigma: float,
    rho: float,
    theta: float,
    iterations: int
) -> HObject:
    """
    Perform a coherence enhancing diffusion of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    sigma : float
            Smoothing for derivative operator.
            Value Suggestion: 0.5
            Assertion: Sigma >= 0

    rho : float
          Smoothing for diffusion coefficients.
          Value Suggestion: 3.0
          Assertion: Rho >= 0

    theta : float
            Time step.
            Value Suggestion: 0.5
            Assertion: 0 < Theta <= 0.5

    iterations : int
                 Number of iterations.
                 Value Suggestion: 10
                 Assertion: Iterations >= 1

    Returns
    -------

    image_ced : HObject
                Output image.

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1547) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, rho)
        proc.set_input_tuple(2, theta)
        proc.set_input_tuple(3, iterations)
        proc.execute()
        image_ced = HObject(proc.get_output_object_key(1))
        return image_ced  # type: ignore


def combine_roads_xld(
    edge_polygons: HObject,
    mod_parallels: HObject,
    ext_parallels: HObject,
    center_lines: HObject,
    max_angle_parallel: Union[float, int],
    max_angle_colinear: Union[float, int],
    max_distance_parallel: Union[float, int],
    max_distance_colinear: Union[float, int]
) -> HObject:
    """
    Combine road hypotheses from two resolution levels.

    Parameters
    ----------

    edge_polygons : HObject
                    XLD polygons to be examined.

    mod_parallels : HObject
                    Modified parallels obtained from EdgePolygons.

    ext_parallels : HObject
                    Extended parallels obtained from EdgePolygons.

    center_lines : HObject
                   Road-center-line polygons to be examined.

    max_angle_parallel : Union[float, int]
                         Maximum angle between two parallel line segments.
                         Value Suggestion: 0.523598775598
                         Assertion: 0 <= MaxAngleParallel <= pi / 2

    max_angle_colinear : Union[float, int]
                         Maximum angle between two collinear line segments.
                         Value Suggestion: 0.261799387799
                         Assertion: 0 <= MaxAngleColinear <= pi / 2

    max_distance_parallel : Union[float, int]
                            Maximum distance between two parallel line
                            segments.
                            Value Suggestion: 40
                            Assertion: MaxDistanceParallel > 0

    max_distance_colinear : Union[float, int]
                            Maximum distance between two collinear line
                            segments.
                            Value Suggestion: 40
                            Assertion: MaxDistanceColinear > 0

    Returns
    -------

    road_sides : HObject
                 Roadsides found.

    See Also
    --------
    lines_gauss, lines_facet, get_channel_info, edges_sub_pix

    Predecessors
    ------------
    mod_parallels_xld, gen_polygons_xld, affine_trans_contour_xld

    Successors
    ----------
    get_polygon_xld, get_lines_xld
    """
    with HalconOperator(37) as proc:
        proc.set_input_object(1, edge_polygons)
        proc.set_input_object(2, mod_parallels)
        proc.set_input_object(3, ext_parallels)
        proc.set_input_object(4, center_lines)
        proc.set_input_tuple(0, max_angle_parallel)
        proc.set_input_tuple(1, max_angle_colinear)
        proc.set_input_tuple(2, max_distance_parallel)
        proc.set_input_tuple(3, max_distance_colinear)
        proc.execute()
        road_sides = HObject(proc.get_output_object_key(1))
        return road_sides  # type: ignore


def compactness(regions: HObject) -> Sequence[float]:
    """
    Shape factor for the compactness of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    compactness : Sequence[float]
                  Compactness of the input region(s).
                  Assertion: Compactness >= 1.0 || Compactness == 0

    See Also
    --------
    contlength, area_center, select_shape

    Alternatives
    ------------
    convexity, eccentricity

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1728) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        compactness = proc.get_output_tuple_m(0)
        return compactness  # type: ignore


def compactness_s(regions: HObject) -> float:
    """
    Shape factor for the compactness of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    compactness : float
                  Compactness of the input region(s).
                  Assertion: Compactness >= 1.0 || Compactness == 0

    See Also
    --------
    contlength, area_center, select_shape

    Alternatives
    ------------
    convexity, eccentricity

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1728) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        compactness = proc.get_output_tuple_s(0)
        return compactness  # type: ignore


def compactness_xld(xld: HObject) -> Sequence[float]:
    """
    Shape factor for the compactness of contours or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    compactness : Sequence[float]
                  Compactness of the input contours or polygons.
                  Assertion: Compactness >= 1.0 || Compactness == 0

    See Also
    --------
    area_center_xld, select_shape_xld

    Alternatives
    ------------
    circularity_xld, convexity_xld, eccentricity_xld, rectangularity_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1681) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        compactness = proc.get_output_tuple_m(0)
        return compactness  # type: ignore


def compactness_xld_s(xld: HObject) -> float:
    """
    Shape factor for the compactness of contours or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    compactness : float
                  Compactness of the input contours or polygons.
                  Assertion: Compactness >= 1.0 || Compactness == 0

    See Also
    --------
    area_center_xld, select_shape_xld

    Alternatives
    ------------
    circularity_xld, convexity_xld, eccentricity_xld, rectangularity_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1681) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        compactness = proc.get_output_tuple_s(0)
        return compactness  # type: ignore


def compare_ext_variation_model(
    image: HObject,
    model_id: HHandle,
    mode: str
) -> HObject:
    """
    Compare an image to a variation model.

    Parameters
    ----------

    image : HObject
            Image of the object to be compared.

    model_id : HHandle
               ID of the variation model.

    mode : str
           Method used for comparing the variation model.
           Value Suggestion: absolute

    Returns
    -------

    region : HObject
             Region containing the points that differ substantially from
             the model.

    See Also
    --------
    get_thresh_images_variation_model

    Alternatives
    ------------
    compare_variation_model, dyn_threshold

    Predecessors
    ------------
    prepare_variation_model, prepare_direct_variation_model

    Successors
    ----------
    select_obj, connection
    """
    with HalconOperator(87) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, model_id)
        proc.set_input_tuple(1, mode)
        proc.execute()
        region = HObject(proc.get_output_object_key(1))
        return region  # type: ignore


def compare_obj(
    objects_1: HObject,
    objects_2: HObject,
    epsilon: Union[float, int]
) -> int:
    """
    Compare iconic objects regarding equality.

    Parameters
    ----------

    objects_1 : HObject
                Reference objects.

    objects_2 : HObject
                Test objects.

    epsilon : Union[float, int]
              Maximum allowed difference between two gray values or
              coordinates etc.
              Value Suggestion: 0.0

    Returns
    -------

    is_equal : int
               Boolean result value.

    See Also
    --------
    test_equal_obj, test_equal_region
    """
    with HalconOperator(588) as proc:
        proc.set_input_object(1, objects_1)
        proc.set_input_object(2, objects_2)
        proc.set_input_tuple(0, epsilon)
        proc.init_oct(0)
        proc.execute()
        is_equal = proc.get_output_tuple_s(0)
        return is_equal  # type: ignore


def compare_variation_model(
    image: HObject,
    model_id: HHandle
) -> HObject:
    """
    Compare an image to a variation model.

    Parameters
    ----------

    image : HObject
            Image of the object to be compared.

    model_id : HHandle
               ID of the variation model.

    Returns
    -------

    region : HObject
             Region containing the points that differ substantially from
             the model.

    See Also
    --------
    get_thresh_images_variation_model

    Alternatives
    ------------
    compare_ext_variation_model, dyn_threshold

    Predecessors
    ------------
    prepare_variation_model, prepare_direct_variation_model

    Successors
    ----------
    connection
    """
    with HalconOperator(88) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, model_id)
        proc.execute()
        region = HObject(proc.get_output_object_key(1))
        return region  # type: ignore


def complement(region: HObject) -> HObject:
    """
    Return the complement of a region.

    Parameters
    ----------

    region : HObject
             Input region(s).

    Returns
    -------

    region_complement : HObject
                        Complemented regions.

    See Also
    --------
    difference, union1, union2, intersection, reset_obj_db, set_system

    Predecessors
    ------------
    threshold, connection, regiongrowing, pouring, class_ndim_norm

    Successors
    ----------
    select_shape
    """
    with HalconOperator(504) as proc:
        proc.set_input_object(1, region)
        proc.execute()
        region_complement = HObject(proc.get_output_object_key(1))
        return region_complement  # type: ignore


def complex_to_real(
    image_complex: HObject
) -> Tuple[HObject, HObject]:
    """
    Convert a complex image into two real images.

    Parameters
    ----------

    image_complex : HObject
                    Complex image.

    Returns
    -------

    image_real : HObject
                 Real part.

    image_imaginary : HObject
                      Imaginary part.

    See Also
    --------
    real_to_complex
    """
    with HalconOperator(1475) as proc:
        proc.set_input_object(1, image_complex)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_real
            HObject(proc.get_output_object_key(2))   # image_imaginary
        )  # type: ignore


def compose2(image_1: HObject, image_2: HObject) -> HObject:
    """
    Convert two images into a two-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose2

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1126) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose3(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject
) -> HObject:
    """
    Convert 3 images into a three-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    image_3 : HObject
              Input image 3.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose3

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1125) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose4(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject,
    image_4: HObject
) -> HObject:
    """
    Convert 4 images into a four-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    image_3 : HObject
              Input image 3.

    image_4 : HObject
              Input image 4.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose4

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1124) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.set_input_object(4, image_4)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose5(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject,
    image_4: HObject,
    image_5: HObject
) -> HObject:
    """
    Convert 5 images into a five-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    image_3 : HObject
              Input image 3.

    image_4 : HObject
              Input image 4.

    image_5 : HObject
              Input image 5.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose5

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1123) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.set_input_object(4, image_4)
        proc.set_input_object(5, image_5)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose6(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject,
    image_4: HObject,
    image_5: HObject,
    image_6: HObject
) -> HObject:
    """
    Convert 6 images into a six-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    image_3 : HObject
              Input image 3.

    image_4 : HObject
              Input image 4.

    image_5 : HObject
              Input image 5.

    image_6 : HObject
              Input image 6.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose6

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1122) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.set_input_object(4, image_4)
        proc.set_input_object(5, image_5)
        proc.set_input_object(6, image_6)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose7(
    image_1: HObject,
    image_2: HObject,
    image_3: HObject,
    image_4: HObject,
    image_5: HObject,
    image_6: HObject,
    image_7: HObject
) -> HObject:
    """
    Convert 7 images into a seven-channel image.

    Parameters
    ----------

    image_1 : HObject
              Input image 1.

    image_2 : HObject
              Input image 2.

    image_3 : HObject
              Input image 3.

    image_4 : HObject
              Input image 4.

    image_5 : HObject
              Input image 5.

    image_6 : HObject
              Input image 6.

    image_7 : HObject
              Input image 7.

    Returns
    -------

    multi_channel_image : HObject
                          Multi-channel image.

    See Also
    --------
    decompose7

    Alternatives
    ------------
    append_channel

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1121) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_object(3, image_3)
        proc.set_input_object(4, image_4)
        proc.set_input_object(5, image_5)
        proc.set_input_object(6, image_6)
        proc.set_input_object(7, image_7)
        proc.execute()
        multi_channel_image = HObject(proc.get_output_object_key(1))
        return multi_channel_image  # type: ignore


def compose_funct_1d(
    function_1: Sequence[Union[float, int]],
    function_2: Sequence[Union[float, int]],
    border: str
) -> Sequence[Union[float, int]]:
    """
    Compose two functions.

    Parameters
    ----------

    function_1 : Sequence[Union[float, int]]
                 Input function 1.

    function_2 : Sequence[Union[float, int]]
                 Input function 2.

    border : str
             Border treatment for the input functions.
             Value Suggestion: constant

    Returns
    -------

    composed_function : Sequence[Union[float, int]]
                        Composed function.

    Predecessors
    ------------
    create_funct_1d_pairs, create_funct_1d_array
    """
    with HalconOperator(1377) as proc:
        proc.set_input_tuple(0, function_1)
        proc.set_input_tuple(1, function_2)
        proc.set_input_tuple(2, border)
        proc.init_oct(0)
        proc.execute()
        composed_function = proc.get_output_tuple_m(0)
        return composed_function  # type: ignore


def concat_obj(objects_1: HObject, objects_2: HObject) -> HObject:
    """
    Concatenate two iconic object tuples.

    Parameters
    ----------

    objects_1 : HObject
                Object tuple 1.

    objects_2 : HObject
                Object tuple 2.

    Returns
    -------

    objects_concat : HObject
                     Concatenated objects.

    See Also
    --------
    count_obj, copy_obj, select_obj, disp_obj
    """
    with HalconOperator(584) as proc:
        proc.set_input_object(1, objects_1)
        proc.set_input_object(2, objects_2)
        proc.execute()
        objects_concat = HObject(proc.get_output_object_key(1))
        return objects_concat  # type: ignore


def concat_ocr_trainf(
    single_files: MaybeSequence[str],
    composed_file: str
) -> None:
    """
    Concat training files.

    Parameters
    ----------

    single_files : MaybeSequence[str]
                   Names of the single training files.
                   Value Suggestion: ''

    composed_file : str
                    Name of the composed training file.
                    Value Suggestion: all_characters

    Predecessors
    ------------
    write_ocr_trainf, append_ocr_trainf

    Successors
    ----------
    trainf_ocr_class_mlp, trainf_ocr_class_svm, write_ocr_trainf
    """
    with HalconOperator(728) as proc:
        proc.set_input_tuple(0, single_files)
        proc.set_input_tuple(1, composed_file)
        proc.execute()


def connect_and_holes(
    regions: HObject
) -> Tuple[Sequence[int], Sequence[int]]:
    """
    Number of connection components and holes

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    num_connected : Sequence[int]
                    Number of connection components of a region.

    num_holes : Sequence[int]
                Number of holes of a region.

    See Also
    --------
    connection, fill_up, fill_up_shape, union1

    Alternatives
    ------------
    euler_number

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1726) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # num_connected
            proc.get_output_tuple_m(1)   # num_holes
        )  # type: ignore


def connect_and_holes_s(regions: HObject) -> Tuple[int, int]:
    """
    Number of connection components and holes

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    num_connected : int
                    Number of connection components of a region.

    num_holes : int
                Number of holes of a region.

    See Also
    --------
    connection, fill_up, fill_up_shape, union1

    Alternatives
    ------------
    euler_number

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1726) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # num_connected
            proc.get_output_tuple_s(1)   # num_holes
        )  # type: ignore


def connect_grid_points(
    image: HObject,
    row: Sequence[float],
    column: Sequence[float],
    sigma: MaybeSequence[Union[float, int]],
    max_dist: Union[float, int]
) -> HObject:
    """
    Establish connections between the grid points of the rectification
    grid.

    Parameters
    ----------

    image : HObject
            Input image.

    row : Sequence[float]
          Row coordinates of the grid points.

    column : Sequence[float]
             Column coordinates of the grid points.
             Assertion: number(Column) == number(Row)

    sigma : MaybeSequence[Union[float, int]]
            Size of the applied Gaussians.
            Value Suggestion: 0.9
            Assertion: 0.7 <= Sigma

    max_dist : Union[float, int]
               Maximum distance of the connecting lines from the grid
               points.
               Value Suggestion: 5.5
               Assertion: 0.0 <= MaxDist

    Returns
    -------

    connecting_lines : HObject
                       Output contours.

    Predecessors
    ------------
    saddle_points_sub_pix

    Successors
    ----------
    gen_grid_rectification_map

    Notes
    -----
    For a reliable determination of the type of bright-dark transition as
    well as for the following rectification, it is necessary that each
    connecting line has at least three contour points. Therefore,
    connecting lines with only two contour points are not returned. Note,
    that the parameter MaxDist has a substantial influence on the length
    of the returned connecting lines, because all contour points of a
    possible connecting line that are closer than MaxDist to a grid point
    are replaced by one single contour point. If MaxDist is too big, some
    of the connecting lines might get lost.
    """
    with HalconOperator(1158) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, sigma)
        proc.set_input_tuple(3, max_dist)
        proc.execute()
        connecting_lines = HObject(proc.get_output_object_key(1))
        return connecting_lines  # type: ignore


def connection(region: HObject) -> HObject:
    """
    Compute connected components of a region.

    Parameters
    ----------

    region : HObject
             Input region.

    Returns
    -------

    connected_regions : HObject
                        Connected components.

    See Also
    --------
    set_system, union1

    Alternatives
    ------------
    background_seg

    Predecessors
    ------------
    auto_threshold, threshold, dyn_threshold, erosion1

    Successors
    ----------
    select_shape, select_gray, shape_trans, set_colored, dilation1,
    count_obj, reduce_domain, add_channels
    """
    with HalconOperator(501) as proc:
        proc.set_input_object(1, region)
        proc.execute()
        connected_regions = HObject(proc.get_output_object_key(1))
        return connected_regions  # type: ignore


def connection_object_model_3d(
    object_model_3d: MaybeSequence[HHandle],
    feature: MaybeSequence[str],
    value: MaybeSequence[Union[int, float]]
) -> Sequence[HHandle]:
    """
    Determine the connected components of the 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    feature : MaybeSequence[str]
              Attribute used to calculate the connected components.
              Value Suggestion: 'distance_3d'

    value : MaybeSequence[Union[int, float]]
            Maximum value for the distance between two connected
            components.
            Value Suggestion: 1.0

    Returns
    -------

    object_model_3dconnected : Sequence[HHandle]
                               Handle of the 3D object models that
                               represent the connected components.

    See Also
    --------
    select_object_model_3d, select_points_object_model_3d

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d,
    select_points_object_model_3d

    Successors
    ----------
    project_object_model_3d, object_model_3d_to_xyz
    """
    with HalconOperator(1085) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, feature)
        proc.set_input_tuple(2, value)
        proc.init_oct(0)
        proc.execute()
        object_model_3dconnected = proc.get_output_tuple_m(0)
        return object_model_3dconnected  # type: ignore


def contlength(regions: HObject) -> Sequence[float]:
    """
    Contour length of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    cont_length : Sequence[float]
                  Contour length of the input region(s).
                  Assertion: ContLength >= 0

    See Also
    --------
    area_center, get_region_contour

    Alternatives
    ------------
    compactness

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Successors
    ----------
    get_region_contour

    Notes
    -----
    The contour of holes is not calculated.
    """
    with HalconOperator(1725) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        cont_length = proc.get_output_tuple_m(0)
        return cont_length  # type: ignore


def contlength_s(regions: HObject) -> float:
    """
    Contour length of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    cont_length : float
                  Contour length of the input region(s).
                  Assertion: ContLength >= 0

    See Also
    --------
    area_center, get_region_contour

    Alternatives
    ------------
    compactness

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Successors
    ----------
    get_region_contour

    Notes
    -----
    The contour of holes is not calculated.
    """
    with HalconOperator(1725) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        cont_length = proc.get_output_tuple_s(0)
        return cont_length  # type: ignore


def contour_point_num_xld(contour: HObject) -> Sequence[int]:
    """
    Return the number of points in an XLD contour.

    Parameters
    ----------

    contour : HObject
              Input XLD contour.

    Returns
    -------

    length : Sequence[int]
             Number of contour points.

    See Also
    --------
    query_contour_attribs_xld

    Alternatives
    ------------
    get_regress_params_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, lines_gauss, lines_facet, edges_sub_pix

    Successors
    ----------
    get_contour_xld, get_contour_attrib_xld
    """
    with HalconOperator(64) as proc:
        proc.set_input_object(1, contour)
        proc.init_oct(0)
        proc.execute()
        length = proc.get_output_tuple_m(0)
        return length  # type: ignore


def contour_point_num_xld_s(contour: HObject) -> int:
    """
    Return the number of points in an XLD contour.

    Parameters
    ----------

    contour : HObject
              Input XLD contour.

    Returns
    -------

    length : int
             Number of contour points.

    See Also
    --------
    query_contour_attribs_xld

    Alternatives
    ------------
    get_regress_params_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, lines_gauss, lines_facet, edges_sub_pix

    Successors
    ----------
    get_contour_xld, get_contour_attrib_xld
    """
    with HalconOperator(64) as proc:
        proc.set_input_object(1, contour)
        proc.init_oct(0)
        proc.execute()
        length = proc.get_output_tuple_s(0)
        return length  # type: ignore


def contour_to_world_plane_xld(
    contours: HObject,
    camera_param: Sequence[Union[int, float, str]],
    world_pose: Sequence[Union[int, float]],
    scale: Union[int, float, str]
) -> HObject:
    """
    Transform an XLD contour into the plane z=0 of a world coordinate
    system.

    Parameters
    ----------

    contours : HObject
               Input XLD contours to be transformed in image coordinates.

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    world_pose : Sequence[Union[int, float]]
                 3D pose of the world coordinate system in camera
                 coordinates.

    scale : Union[int, float, str]
            Scale or dimension
            Value Suggestion: m
            Assertion: Scale > 0

    Returns
    -------

    contours_trans : HObject
                     Transformed XLD contours in world coordinates.

    See Also
    --------
    image_points_to_world_plane

    Predecessors
    ------------
    create_pose, hom_mat3d_to_pose, camera_calibration,
    hand_eye_calibration, set_origin_pose
    """
    with HalconOperator(1915) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, camera_param)
        proc.set_input_tuple(1, world_pose)
        proc.set_input_tuple(2, scale)
        proc.execute()
        contours_trans = HObject(proc.get_output_object_key(1))
        return contours_trans  # type: ignore


def control_io_channel(
    iochannel_handle: MaybeSequence[HHandle],
    action: str,
    argument: Sequence[Union[int, float, str]]
) -> Sequence[Union[int, float, str]]:
    """
    Perform an action on I/O channels.

    Parameters
    ----------

    iochannel_handle : MaybeSequence[HHandle]
                       Handles of the opened I/O channels.

    action : str
             Name of the action to perform.

    argument : Sequence[Union[int, float, str]]
               List of arguments for the action.
               Value Suggestion: []

    Returns
    -------

    result : Sequence[Union[int, float, str]]
             List of values returned by the action.

    Predecessors
    ------------
    open_io_channel
    """
    with HalconOperator(2010) as proc:
        proc.set_input_tuple(0, iochannel_handle)
        proc.set_input_tuple(1, action)
        proc.set_input_tuple(2, argument)
        proc.init_oct(0)
        proc.execute()
        result = proc.get_output_tuple_m(0)
        return result  # type: ignore


def control_io_device(
    iodevice_handle: HHandle,
    action: str,
    argument: MaybeSequence[Union[int, float, str]]
) -> Sequence[Union[int, float, str]]:
    """
    Perform an action on the I/O device.

    Parameters
    ----------

    iodevice_handle : HHandle
                      Handle of the opened I/O device.

    action : str
             Name of the action to perform.

    argument : MaybeSequence[Union[int, float, str]]
               List of arguments for the action.
               Value Suggestion: []

    Returns
    -------

    result : Sequence[Union[int, float, str]]
             List of result values returned by the action.

    Predecessors
    ------------
    open_io_device
    """
    with HalconOperator(2018) as proc:
        proc.set_input_tuple(0, iodevice_handle)
        proc.set_input_tuple(1, action)
        proc.set_input_tuple(2, argument)
        proc.init_oct(0)
        proc.execute()
        result = proc.get_output_tuple_m(0)
        return result  # type: ignore


def control_io_interface(
    iointerface_name: str,
    action: str,
    argument: MaybeSequence[Union[int, float, str]]
) -> Sequence[Union[int, float, str]]:
    """
    Perform an action on the I/O interface.

    Parameters
    ----------

    iointerface_name : str
                       HALCON I/O interface name.
                       Value Suggestion: []

    action : str
             Name of the action to perform.

    argument : MaybeSequence[Union[int, float, str]]
               List of arguments for the action.
               Value Suggestion: []

    Returns
    -------

    result : Sequence[Union[int, float, str]]
             List of results returned by the action.

    See Also
    --------
    query_io_interface

    Notes
    -----
    On Windows Systems, error dialog boxes from the operating system can
    occur when dependency modules of the interface are not found, e.g.,
    the according SDK was not installed. The occurrence of the error boxes
    can be controlled by setting Windows' Error Mode. Please refer to the
    description of SetErrorMode within the Windows MSDN documentation.
    """
    with HalconOperator(2023) as proc:
        proc.set_input_tuple(0, iointerface_name)
        proc.set_input_tuple(1, action)
        proc.set_input_tuple(2, argument)
        proc.init_oct(0)
        proc.execute()
        result = proc.get_output_tuple_m(0)
        return result  # type: ignore


def convert_coordinates_image_to_window(
    window_handle: HHandle,
    row_image: MaybeSequence[float],
    column_image: MaybeSequence[float]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Convert image coordinates to window coordinates

    Parameters
    ----------

    window_handle : HHandle
                    Window handle

    row_image : MaybeSequence[float]
                Row in image coordinates.

    column_image : MaybeSequence[float]
                   Column in image coordinates.

    Returns
    -------

    row_window : Sequence[float]
                 Row (Y) in window coordinates.

    column_window : Sequence[float]
                    Column (X) in window coordinates.

    See Also
    --------
    convert_coordinates_window_to_image

    Predecessors
    ------------
    set_window_extents, set_part
    """
    with HalconOperator(2049) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_image)
        proc.set_input_tuple(2, column_image)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_window
            proc.get_output_tuple_m(1)   # column_window
        )  # type: ignore


def convert_coordinates_image_to_window_s(
    window_handle: HHandle,
    row_image: MaybeSequence[float],
    column_image: MaybeSequence[float]
) -> Tuple[float, float]:
    """
    Convert image coordinates to window coordinates

    Parameters
    ----------

    window_handle : HHandle
                    Window handle

    row_image : MaybeSequence[float]
                Row in image coordinates.

    column_image : MaybeSequence[float]
                   Column in image coordinates.

    Returns
    -------

    row_window : float
                 Row (Y) in window coordinates.

    column_window : float
                    Column (X) in window coordinates.

    See Also
    --------
    convert_coordinates_window_to_image

    Predecessors
    ------------
    set_window_extents, set_part
    """
    with HalconOperator(2049) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_image)
        proc.set_input_tuple(2, column_image)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row_window
            proc.get_output_tuple_s(1)   # column_window
        )  # type: ignore


def convert_coordinates_window_to_image(
    window_handle: HHandle,
    row_window: MaybeSequence[float],
    column_window: MaybeSequence[float]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Convert window coordinates to image coordinates

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_window : MaybeSequence[float]
                 Row (Y) in window coordinates.

    column_window : MaybeSequence[float]
                    Column (X) in window coordinates.

    Returns
    -------

    row_image : Sequence[float]
                Row in image coordinates.

    column_image : Sequence[float]
                   Column in image coordinates.

    See Also
    --------
    convert_coordinates_image_to_window

    Predecessors
    ------------
    set_window_extents, set_part
    """
    with HalconOperator(2050) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_window)
        proc.set_input_tuple(2, column_window)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_image
            proc.get_output_tuple_m(1)   # column_image
        )  # type: ignore


def convert_coordinates_window_to_image_s(
    window_handle: HHandle,
    row_window: MaybeSequence[float],
    column_window: MaybeSequence[float]
) -> Tuple[float, float]:
    """
    Convert window coordinates to image coordinates

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_window : MaybeSequence[float]
                 Row (Y) in window coordinates.

    column_window : MaybeSequence[float]
                    Column (X) in window coordinates.

    Returns
    -------

    row_image : float
                Row in image coordinates.

    column_image : float
                   Column in image coordinates.

    See Also
    --------
    convert_coordinates_image_to_window

    Predecessors
    ------------
    set_window_extents, set_part
    """
    with HalconOperator(2050) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_window)
        proc.set_input_tuple(2, column_window)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row_image
            proc.get_output_tuple_s(1)   # column_image
        )  # type: ignore


def convert_image_type(image: HObject, new_type: str) -> HObject:
    """
    Convert the type of an image.

    Parameters
    ----------

    image : HObject
            Image whose image type is to be changed.

    new_type : str
               Desired image type (i.e., type of the gray values).
               Value Suggestion: byte

    Returns
    -------

    image_converted : HObject
                      Converted image.

    See Also
    --------
    scale_image, abs_image

    Predecessors
    ------------
    scale_image

    Notes
    -----
    The conversion to the 'int8' image format is only available on 64 bit
    systems! If the source and destination image type are identical, no
    new image matrix is allocated.
    """
    with HalconOperator(1471) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, new_type)
        proc.execute()
        image_converted = HObject(proc.get_output_object_key(1))
        return image_converted  # type: ignore


def convert_map_type(
    map: HObject,
    new_type: str,
    image_width: Union[int, str]
) -> HObject:
    """
    Convert image maps into other map types.

    Parameters
    ----------

    map : HObject
          Input map.

    new_type : str
               Type of MapConverted.
               Value Suggestion: 'coord_map_sub_pix'

    image_width : Union[int, str]
                  Width of images to be mapped.
                  Value Suggestion: 'map_width'

    Returns
    -------

    map_converted : HObject
                    Converted map.

    Predecessors
    ------------
    gen_image_to_world_plane_map, gen_radial_distortion_map,
    gen_arbitrary_distortion_map, gen_grid_rectification_map,
    find_local_deformable_model

    Successors
    ----------
    map_image
    """
    with HalconOperator(1901) as proc:
        proc.set_input_object(1, map)
        proc.set_input_tuple(0, new_type)
        proc.set_input_tuple(1, image_width)
        proc.execute()
        map_converted = HObject(proc.get_output_object_key(1))
        return map_converted  # type: ignore


def convert_point_3d_cart_to_spher(
    x: MaybeSequence[float],
    y: MaybeSequence[float],
    z: MaybeSequence[float],
    equat_plane_normal: str,
    zero_meridian: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Convert Cartesian coordinates of a 3D point to spherical coordinates.

    Parameters
    ----------

    x : MaybeSequence[float]
        X coordinate of the 3D point.

    y : MaybeSequence[float]
        Y coordinate of the 3D point.

    z : MaybeSequence[float]
        Z coordinate of the 3D point.

    equat_plane_normal : str
                         Normal vector of the equatorial plane (points to
                         the north pole).
                         Value Suggestion: -y

    zero_meridian : str
                    Coordinate axis in the equatorial plane that points to
                    the zero meridian.
                    Value Suggestion: -z

    Returns
    -------

    longitude : Sequence[float]
                Longitude of the 3D point.

    latitude : Sequence[float]
               Latitude of the 3D point.

    radius : Sequence[float]
             Radius of the 3D point.

    See Also
    --------
    convert_point_3d_spher_to_cart

    Successors
    ----------
    create_shape_model_3d, find_shape_model_3d
    """
    with HalconOperator(1047) as proc:
        proc.set_input_tuple(0, x)
        proc.set_input_tuple(1, y)
        proc.set_input_tuple(2, z)
        proc.set_input_tuple(3, equat_plane_normal)
        proc.set_input_tuple(4, zero_meridian)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # longitude
            proc.get_output_tuple_m(1),  # latitude
            proc.get_output_tuple_m(2)   # radius
        )  # type: ignore


def convert_point_3d_cart_to_spher_s(
    x: MaybeSequence[float],
    y: MaybeSequence[float],
    z: MaybeSequence[float],
    equat_plane_normal: str,
    zero_meridian: str
) -> Tuple[float, float, float]:
    """
    Convert Cartesian coordinates of a 3D point to spherical coordinates.

    Parameters
    ----------

    x : MaybeSequence[float]
        X coordinate of the 3D point.

    y : MaybeSequence[float]
        Y coordinate of the 3D point.

    z : MaybeSequence[float]
        Z coordinate of the 3D point.

    equat_plane_normal : str
                         Normal vector of the equatorial plane (points to
                         the north pole).
                         Value Suggestion: -y

    zero_meridian : str
                    Coordinate axis in the equatorial plane that points to
                    the zero meridian.
                    Value Suggestion: -z

    Returns
    -------

    longitude : float
                Longitude of the 3D point.

    latitude : float
               Latitude of the 3D point.

    radius : float
             Radius of the 3D point.

    See Also
    --------
    convert_point_3d_spher_to_cart

    Successors
    ----------
    create_shape_model_3d, find_shape_model_3d
    """
    with HalconOperator(1047) as proc:
        proc.set_input_tuple(0, x)
        proc.set_input_tuple(1, y)
        proc.set_input_tuple(2, z)
        proc.set_input_tuple(3, equat_plane_normal)
        proc.set_input_tuple(4, zero_meridian)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # longitude
            proc.get_output_tuple_s(1),  # latitude
            proc.get_output_tuple_s(2)   # radius
        )  # type: ignore


def convert_point_3d_spher_to_cart(
    longitude: MaybeSequence[float],
    latitude: MaybeSequence[float],
    radius: MaybeSequence[float],
    equat_plane_normal: str,
    zero_meridian: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Convert spherical coordinates of a 3D point to Cartesian coordinates.

    Parameters
    ----------

    longitude : MaybeSequence[float]
                Longitude of the 3D point.

    latitude : MaybeSequence[float]
               Latitude of the 3D point.
               Assertion: - pi / 2 <= Latitude && Latitude <= pi / 2

    radius : MaybeSequence[float]
             Radius of the 3D point.

    equat_plane_normal : str
                         Normal vector of the equatorial plane (points to
                         the north pole).
                         Value Suggestion: -y

    zero_meridian : str
                    Coordinate axis in the equatorial plane that points to
                    the zero meridian.
                    Value Suggestion: -z

    Returns
    -------

    x : Sequence[float]
        X coordinate of the 3D point.

    y : Sequence[float]
        Y coordinate of the 3D point.

    z : Sequence[float]
        Z coordinate of the 3D point.

    See Also
    --------
    convert_point_3d_cart_to_spher

    Predecessors
    ------------
    get_shape_model_3d_params
    """
    with HalconOperator(1046) as proc:
        proc.set_input_tuple(0, longitude)
        proc.set_input_tuple(1, latitude)
        proc.set_input_tuple(2, radius)
        proc.set_input_tuple(3, equat_plane_normal)
        proc.set_input_tuple(4, zero_meridian)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # x
            proc.get_output_tuple_m(1),  # y
            proc.get_output_tuple_m(2)   # z
        )  # type: ignore


def convert_point_3d_spher_to_cart_s(
    longitude: MaybeSequence[float],
    latitude: MaybeSequence[float],
    radius: MaybeSequence[float],
    equat_plane_normal: str,
    zero_meridian: str
) -> Tuple[float, float, float]:
    """
    Convert spherical coordinates of a 3D point to Cartesian coordinates.

    Parameters
    ----------

    longitude : MaybeSequence[float]
                Longitude of the 3D point.

    latitude : MaybeSequence[float]
               Latitude of the 3D point.
               Assertion: - pi / 2 <= Latitude && Latitude <= pi / 2

    radius : MaybeSequence[float]
             Radius of the 3D point.

    equat_plane_normal : str
                         Normal vector of the equatorial plane (points to
                         the north pole).
                         Value Suggestion: -y

    zero_meridian : str
                    Coordinate axis in the equatorial plane that points to
                    the zero meridian.
                    Value Suggestion: -z

    Returns
    -------

    x : float
        X coordinate of the 3D point.

    y : float
        Y coordinate of the 3D point.

    z : float
        Z coordinate of the 3D point.

    See Also
    --------
    convert_point_3d_cart_to_spher

    Predecessors
    ------------
    get_shape_model_3d_params
    """
    with HalconOperator(1046) as proc:
        proc.set_input_tuple(0, longitude)
        proc.set_input_tuple(1, latitude)
        proc.set_input_tuple(2, radius)
        proc.set_input_tuple(3, equat_plane_normal)
        proc.set_input_tuple(4, zero_meridian)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # x
            proc.get_output_tuple_s(1),  # y
            proc.get_output_tuple_s(2)   # z
        )  # type: ignore


def convert_pose_type(
    pose_in: Sequence[Union[int, float]],
    order_of_transform: str,
    order_of_rotation: str,
    view_of_transform: str
) -> Sequence[Union[int, float]]:
    """
    Change the representation type of a 3D pose.

    Parameters
    ----------

    pose_in : Sequence[Union[int, float]]
              Original 3D pose.

    order_of_transform : str
                         Order of rotation and translation.
                         Value Suggestion: 'Rp+T'

    order_of_rotation : str
                        Meaning of the rotation values.
                        Value Suggestion: 'gba'

    view_of_transform : str
                        View of transformation.
                        Value Suggestion: 'point'

    Returns
    -------

    pose_out : Sequence[Union[int, float]]
               3D transformation.

    See Also
    --------
    create_pose, get_pose_type, write_pose, read_pose

    Predecessors
    ------------
    create_pose, hom_mat3d_to_pose, camera_calibration,
    hand_eye_calibration

    Successors
    ----------
    write_pose
    """
    with HalconOperator(1920) as proc:
        proc.set_input_tuple(0, pose_in)
        proc.set_input_tuple(1, order_of_transform)
        proc.set_input_tuple(2, order_of_rotation)
        proc.set_input_tuple(3, view_of_transform)
        proc.init_oct(0)
        proc.execute()
        pose_out = proc.get_output_tuple_m(0)
        return pose_out  # type: ignore


def convex_hull_object_model_3d(
    object_model_3d: MaybeSequence[HHandle]
) -> Sequence[HHandle]:
    """
    Calculate the convex hull of a 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    Returns
    -------

    object_model_3dconvex_hull : Sequence[HHandle]
                                 Handle of the 3D object model that
                                 describes the convex hull.

    Predecessors
    ------------
    read_object_model_3d, connection_object_model_3d,
    select_points_object_model_3d

    Successors
    ----------
    project_object_model_3d
    """
    with HalconOperator(1078) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.init_oct(0)
        proc.execute()
        object_model_3dconvex_hull = proc.get_output_tuple_m(0)
        return object_model_3dconvex_hull  # type: ignore


def convex_hull_object_model_3d_s(
    object_model_3d: MaybeSequence[HHandle]
) -> HHandle:
    """
    Calculate the convex hull of a 3D object model.

    Parameters
    ----------

    object_model_3d : MaybeSequence[HHandle]
                      Handle of the 3D object model.

    Returns
    -------

    object_model_3dconvex_hull : HHandle
                                 Handle of the 3D object model that
                                 describes the convex hull.

    Predecessors
    ------------
    read_object_model_3d, connection_object_model_3d,
    select_points_object_model_3d

    Successors
    ----------
    project_object_model_3d
    """
    with HalconOperator(1078) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.init_oct(0)
        proc.execute()
        object_model_3dconvex_hull = proc.get_output_tuple_s(0)
        return object_model_3dconvex_hull  # type: ignore


def convexity(regions: HObject) -> Sequence[float]:
    """
    Shape factor for the convexity of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    convexity : Sequence[float]
                Convexity of the input region(s).
                Assertion: Convexity <= 1

    See Also
    --------
    select_shape, area_center, shape_trans

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1724) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        convexity = proc.get_output_tuple_m(0)
        return convexity  # type: ignore


def convexity_s(regions: HObject) -> float:
    """
    Shape factor for the convexity of a region.

    Parameters
    ----------

    regions : HObject
              Region(s) to be examined.

    Returns
    -------

    convexity : float
                Convexity of the input region(s).
                Assertion: Convexity <= 1

    See Also
    --------
    select_shape, area_center, shape_trans

    Predecessors
    ------------
    threshold, regiongrowing, connection
    """
    with HalconOperator(1724) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.execute()
        convexity = proc.get_output_tuple_s(0)
        return convexity  # type: ignore


def convexity_xld(xld: HObject) -> Sequence[float]:
    """
    Shape factor for the convexity of contours or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    convexity : Sequence[float]
                Convexity of the input contours or polygons.
                Assertion: Convexity <= 1

    See Also
    --------
    area_center_xld, select_shape_xld, shape_trans_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1683) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        convexity = proc.get_output_tuple_m(0)
        return convexity  # type: ignore


def convexity_xld_s(xld: HObject) -> float:
    """
    Shape factor for the convexity of contours or polygons.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    convexity : float
                Convexity of the input contours or polygons.
                Assertion: Convexity <= 1

    See Also
    --------
    area_center_xld, select_shape_xld, shape_trans_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld
    """
    with HalconOperator(1683) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.execute()
        convexity = proc.get_output_tuple_s(0)
        return convexity  # type: ignore


def convol_fft(image_fft: HObject, image_filter: HObject) -> HObject:
    """
    Convolve an image with a filter in the frequency domain.

    Parameters
    ----------

    image_fft : HObject
                Complex input image.

    image_filter : HObject
                   Filter in frequency domain.

    Returns
    -------

    image_convol : HObject
                   Result of applying the filter.

    See Also
    --------
    gen_gabor, gen_highpass, gen_lowpass, gen_bandpass, convol_gabor,
    fft_image_inv

    Alternatives
    ------------
    convol_gabor

    Predecessors
    ------------
    fft_image, fft_generic, rft_generic, gen_highpass, gen_lowpass,
    gen_bandpass, gen_bandfilter

    Successors
    ----------
    power_byte, power_real, power_ln, fft_image_inv, fft_generic,
    rft_generic

    Notes
    -----
    The filtering is always done on the entire image, i.e., the domain of
    the image is ignored.
    """
    with HalconOperator(1534) as proc:
        proc.set_input_object(1, image_fft)
        proc.set_input_object(2, image_filter)
        proc.execute()
        image_convol = HObject(proc.get_output_object_key(1))
        return image_convol  # type: ignore


def convol_gabor(
    image_fft: HObject,
    gabor_filter: HObject
) -> Tuple[HObject, HObject]:
    """
    Convolve an image with a Gabor filter in the frequency domain.

    Parameters
    ----------

    image_fft : HObject
                Input image.

    gabor_filter : HObject
                   Gabor/Hilbert-Filter.

    Returns
    -------

    image_result_gabor : HObject
                         Result of the Gabor filter.

    image_result_hilbert : HObject
                           Result of the Hilbert filter.

    See Also
    --------
    convol_image

    Alternatives
    ------------
    convol_fft

    Predecessors
    ------------
    fft_image, fft_generic, gen_gabor

    Successors
    ----------
    power_byte, power_real, power_ln, fft_image_inv, fft_generic

    Notes
    -----
    The filtering is always done on the entire image, i.e., the domain of
    the image is ignored.
    """
    with HalconOperator(1530) as proc:
        proc.set_input_object(1, image_fft)
        proc.set_input_object(2, gabor_filter)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_result_gabor
            HObject(proc.get_output_object_key(2))   # image_result_hilbert
        )  # type: ignore


def convol_image(
    image: HObject,
    filter_mask: MaybeSequence[Union[int, float, str]],
    margin: Union[int, float, str]
) -> HObject:
    """
    Calculate the correlation between an image and an arbitrary filter mask

    Parameters
    ----------

    image : HObject
            Images for which the correlation will be calculated.

    filter_mask : MaybeSequence[Union[int, float, str]]
                  Filter mask as file name or tuple.
                  Value Suggestion: sobel

    margin : Union[int, float, str]
             Border treatment.
             Value Suggestion: mirrored

    Returns
    -------

    image_result : HObject
                   Result of the correlation.

    Notes
    -----
    Note that convol_image does not compute a convolution of the image
    with the given filter mask but a correlation, i.e., it uses the given
    filter mask directly, not a mirrored version of the filter mask.
    When using a 3x3 or 5x5 rectangular filter mask and the border
    treatment mirrored, convol_image can be executed on OpenCL devices.
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1470) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, filter_mask)
        proc.set_input_tuple(1, margin)
        proc.execute()
        image_result = HObject(proc.get_output_object_key(1))
        return image_result  # type: ignore


def cooc_feature_image(
    regions: HObject,
    image: HObject,
    ld_gray: int,
    direction: Union[int, str]
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Calculate a co-occurrence matrix and derive gray value features
    thereof.

    Parameters
    ----------

    regions : HObject
              Region to be examined.

    image : HObject
            Corresponding gray values.

    ld_gray : int
              Number of gray values to be distinguished
              (2^LdGray$2^{LdGray}$).
              Value Suggestion: 6

    direction : Union[int, str]
                Direction in which the matrix is to be calculated.
                Value Suggestion: 0

    Returns
    -------

    energy : Sequence[float]
             Gray value energy.

    correlation : Sequence[float]
                  Correlation of gray values.

    homogeneity : Sequence[float]
                  Local homogeneity of gray values.

    contrast : Sequence[float]
               Gray value contrast.

    See Also
    --------
    intensity, min_max_gray, entropy_gray, select_gray

    Alternatives
    ------------
    cooc_feature_matrix

    Predecessors
    ------------
    gen_cooc_matrix

    Notes
    -----
    Note that the operator cooc_feature_image only considers the given
    Regions and ignores any previously set domain of the input image Image.
    """
    with HalconOperator(1759) as proc:
        proc.set_input_object(1, regions)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ld_gray)
        proc.set_input_tuple(1, direction)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # energy
            proc.get_output_tuple_m(1),  # correlation
            proc.get_output_tuple_m(2),  # homogeneity
            proc.get_output_tuple_m(3)   # contrast
        )  # type: ignore


def cooc_feature_image_s(
    regions: HObject,
    image: HObject,
    ld_gray: int,
    direction: Union[int, str]
) -> Tuple[float, float, float, float]:
    """
    Calculate a co-occurrence matrix and derive gray value features
    thereof.

    Parameters
    ----------

    regions : HObject
              Region to be examined.

    image : HObject
            Corresponding gray values.

    ld_gray : int
              Number of gray values to be distinguished
              (2^LdGray$2^{LdGray}$).
              Value Suggestion: 6

    direction : Union[int, str]
                Direction in which the matrix is to be calculated.
                Value Suggestion: 0

    Returns
    -------

    energy : float
             Gray value energy.

    correlation : float
                  Correlation of gray values.

    homogeneity : float
                  Local homogeneity of gray values.

    contrast : float
               Gray value contrast.

    See Also
    --------
    intensity, min_max_gray, entropy_gray, select_gray

    Alternatives
    ------------
    cooc_feature_matrix

    Predecessors
    ------------
    gen_cooc_matrix

    Notes
    -----
    Note that the operator cooc_feature_image only considers the given
    Regions and ignores any previously set domain of the input image Image.
    """
    with HalconOperator(1759) as proc:
        proc.set_input_object(1, regions)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ld_gray)
        proc.set_input_tuple(1, direction)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # energy
            proc.get_output_tuple_s(1),  # correlation
            proc.get_output_tuple_s(2),  # homogeneity
            proc.get_output_tuple_s(3)   # contrast
        )  # type: ignore


def cooc_feature_matrix(
    cooc_matrix: HObject
) -> Tuple[float, float, float, float]:
    """
    Calculate gray value features from a co-occurrence matrix.

    Parameters
    ----------

    cooc_matrix : HObject
                  Co-occurrence matrix.

    Returns
    -------

    energy : float
             Homogeneity of the gray values.

    correlation : float
                  Correlation of gray values.

    homogeneity : float
                  Local homogeneity of gray values.

    contrast : float
               Gray value contrast.

    See Also
    --------
    intensity, min_max_gray, entropy_gray, select_gray

    Alternatives
    ------------
    cooc_feature_image

    Predecessors
    ------------
    gen_cooc_matrix

    Notes
    -----
    The region of the input image is disregarded.
    """
    with HalconOperator(1758) as proc:
        proc.set_input_object(1, cooc_matrix)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # energy
            proc.get_output_tuple_s(1),  # correlation
            proc.get_output_tuple_s(2),  # homogeneity
            proc.get_output_tuple_s(3)   # contrast
        )  # type: ignore


def copy_dict(
    dict_handle: HHandle,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Copy a dictionary.

    Parameters
    ----------

    dict_handle : HHandle
                  Dictionary handle.

    gen_param_name : MaybeSequence[str]
                     Name of the generic parameter.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Value of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    copied_dict_handle : HHandle
                         Copied dictionary handle.

    See Also
    --------
    read_dict, write_dict, serialize_handle, deserialize_handle

    Predecessors
    ------------
    read_dict, deserialize_handle, create_dict

    Successors
    ----------
    write_dict
    """
    with HalconOperator(2148) as proc:
        proc.set_input_tuple(0, dict_handle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        copied_dict_handle = proc.get_output_tuple_s(0)
        return copied_dict_handle  # type: ignore


def copy_file(source_file: str, destination_file: str) -> None:
    """
    Copy a file to a new location.

    Parameters
    ----------

    source_file : str
                  File to be copied.

    destination_file : str
                       Target location.
    """
    with HalconOperator(1638) as proc:
        proc.set_input_tuple(0, source_file)
        proc.set_input_tuple(1, destination_file)
        proc.execute()


def copy_image(image: HObject) -> HObject:
    """
    Copy an image and allocate new memory for it.

    Parameters
    ----------

    image : HObject
            Image to be copied.

    Returns
    -------

    dup_image : HObject
                Copied image.

    See Also
    --------
    get_image_pointer1

    Alternatives
    ------------
    set_grayval, paint_gray, gen_image_const, gen_image_proto

    Predecessors
    ------------
    read_image, gen_image_const

    Successors
    ----------
    set_grayval, get_image_pointer1
    """
    with HalconOperator(586) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        dup_image = HObject(proc.get_output_object_key(1))
        return dup_image  # type: ignore


def copy_matrix(matrix_id: HHandle) -> HHandle:
    """
    Copy a matrix.

    Parameters
    ----------

    matrix_id : HHandle
                Matrix handle of the input matrix.

    Returns
    -------

    matrix_copy_id : HHandle
                     Matrix handle of the copied matrix.

    Alternatives
    ------------
    repeat_matrix

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(886) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.init_oct(0)
        proc.execute()
        matrix_copy_id = proc.get_output_tuple_s(0)
        return matrix_copy_id  # type: ignore


def copy_metrology_model(
    metrology_handle: HHandle,
    index: MaybeSequence[Union[str, int]]
) -> int:
    """
    Copy a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    index : MaybeSequence[Union[str, int]]
            Index of the metrology objects.
            Value Suggestion: all

    Returns
    -------

    copied_metrology_handle : int
                              Handle of the copied metrology model.
    """
    with HalconOperator(799) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, index)
        proc.init_oct(0)
        proc.execute()
        copied_metrology_handle = proc.get_output_tuple_s(0)
        return copied_metrology_handle  # type: ignore


def copy_metrology_object(
    metrology_handle: HHandle,
    index: MaybeSequence[Union[str, int]]
) -> Sequence[int]:
    """
    Copy metrology metrology objects of a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    index : MaybeSequence[Union[str, int]]
            Index of the metrology objects.
            Value Suggestion: all

    Returns
    -------

    copied_indices : Sequence[int]
                     Indices of the copied metrology objects.

    Warnings
    --------
    copy_metrology_object is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(800) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, index)
        proc.init_oct(0)
        proc.execute()
        copied_indices = proc.get_output_tuple_m(0)
        return copied_indices  # type: ignore


def copy_metrology_object_s(
    metrology_handle: HHandle,
    index: MaybeSequence[Union[str, int]]
) -> int:
    """
    Copy metrology metrology objects of a metrology model.

    Parameters
    ----------

    metrology_handle : HHandle
                       Handle of the metrology model.

    index : MaybeSequence[Union[str, int]]
            Index of the metrology objects.
            Value Suggestion: all

    Returns
    -------

    copied_indices : int
                     Indices of the copied metrology objects.

    Warnings
    --------
    copy_metrology_object is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(800) as proc:
        proc.set_input_tuple(0, metrology_handle)
        proc.set_input_tuple(1, index)
        proc.init_oct(0)
        proc.execute()
        copied_indices = proc.get_output_tuple_s(0)
        return copied_indices  # type: ignore


def copy_obj(objects: HObject, index: int, num_obj: int) -> HObject:
    """
    Copy an iconic object in the HALCON database.

    Parameters
    ----------

    objects : HObject
              Objects to be copied.

    index : int
            Starting index of the objects to be copied.
            Value Suggestion: 1
            Assertion: Index <= number(Objects)

    num_obj : int
              Number of objects to be copied or -1.
              Value Suggestion: 1
              Assertion: NumObj + Index - 1 <= number(Objects) && NumObj != 0

    Returns
    -------

    objects_selected : HObject
                       Copied objects.

    See Also
    --------
    count_obj, concat_obj, obj_to_integer, copy_image

    Alternatives
    ------------
    select_obj

    Predecessors
    ------------
    count_obj
    """
    with HalconOperator(583) as proc:
        proc.set_input_object(1, objects)
        proc.set_input_tuple(0, index)
        proc.set_input_tuple(1, num_obj)
        proc.execute()
        objects_selected = HObject(proc.get_output_object_key(1))
        return objects_selected  # type: ignore


def copy_object_model_3d(
    object_model_3d: HHandle,
    attributes: MaybeSequence[Union[str, float, int]]
) -> HHandle:
    """
    Copy a 3D object model.

    Parameters
    ----------

    object_model_3d : HHandle
                      Handle of the input 3D object model.

    attributes : MaybeSequence[Union[str, float, int]]
                 Attributes to be copied.
                 Value Suggestion: all

    Returns
    -------

    copied_object_model_3d : HHandle
                             Handle of the copied 3D object model.

    See Also
    --------
    remove_object_model_3d_attrib, set_object_model_3d_attrib

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d

    Successors
    ----------
    get_object_model_3d_params
    """
    with HalconOperator(1090) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, attributes)
        proc.init_oct(0)
        proc.execute()
        copied_object_model_3d = proc.get_output_tuple_s(0)
        return copied_object_model_3d  # type: ignore


def copy_rectangle(
    window_handle_source: HHandle,
    window_handle_destination: HHandle,
    row_1: MaybeSequence[int],
    column_1: MaybeSequence[int],
    row_2: MaybeSequence[int],
    column_2: MaybeSequence[int],
    dest_row: MaybeSequence[int],
    dest_column: MaybeSequence[int]
) -> None:
    """
    Copy all pixels within rectangles between output windows.

    Parameters
    ----------

    window_handle_source : HHandle
                           Source window handle.

    window_handle_destination : HHandle
                                Destination window handle.

    row_1 : MaybeSequence[int]
            Row index of upper left corner in the source window.
            Value Suggestion: 0

    column_1 : MaybeSequence[int]
               Column index of upper left corner in the source window.
               Value Suggestion: 0

    row_2 : MaybeSequence[int]
            Row index of lower right corner in the source window.
            Value Suggestion: 128
            Assertion: Row2 >= Row1

    column_2 : MaybeSequence[int]
               Column index of lower right corner in the source window.
               Value Suggestion: 128
               Assertion: Column2 >= Column1

    dest_row : MaybeSequence[int]
               Row index of upper left corner in the target window.
               Value Suggestion: 0

    dest_column : MaybeSequence[int]
                  Column index of upper left corner in the target window.
                  Value Suggestion: 0

    See Also
    --------
    open_window

    Alternatives
    ------------
    move_rectangle, slide_image

    Predecessors
    ------------
    open_window

    Successors
    ----------
    close_window

    Notes
    -----
    Both windows have to reside on the same display.
    """
    with HalconOperator(1186) as proc:
        proc.set_input_tuple(0, window_handle_source)
        proc.set_input_tuple(1, window_handle_destination)
        proc.set_input_tuple(2, row_1)
        proc.set_input_tuple(3, column_1)
        proc.set_input_tuple(4, row_2)
        proc.set_input_tuple(5, column_2)
        proc.set_input_tuple(6, dest_row)
        proc.set_input_tuple(7, dest_column)
        proc.execute()


def corner_response(
    image: HObject,
    size: int,
    weight: float
) -> HObject:
    """
    Searching corners in images.

    Parameters
    ----------

    image : HObject
            Input image.

    size : int
           Desired filtersize of the graymask.
           Value Suggestion: 3

    weight : float
             Weighting.
             Value Suggestion: 0.04

    Returns
    -------

    image_corner : HObject
                   Result of the filtering.

    See Also
    --------
    gauss_filter, sobel_amp, convert_image_type

    Successors
    ----------
    local_max, threshold

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1507) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, size)
        proc.set_input_tuple(1, weight)
        proc.execute()
        image_corner = HObject(proc.get_output_object_key(1))
        return image_corner  # type: ignore


def correlation_fft(
    image_fft1: HObject,
    image_fft2: HObject
) -> HObject:
    """
    Compute the correlation of two images in the frequency domain.

    Parameters
    ----------

    image_fft1 : HObject
                 Fourier-transformed input image 1.

    image_fft2 : HObject
                 Fourier-transformed input image 2.

    Returns
    -------

    image_correlation : HObject
                        Correlation of the input images in the frequency
                        domain.

    Alternatives
    ------------
    phase_correlation_fft

    Predecessors
    ------------
    fft_generic, fft_image, rft_generic

    Successors
    ----------
    fft_generic, fft_image_inv, rft_generic

    Notes
    -----
    The filtering is always performed on the entire image, i.e., the
    domain of the image is ignored.
    """
    with HalconOperator(1533) as proc:
        proc.set_input_object(1, image_fft1)
        proc.set_input_object(2, image_fft2)
        proc.execute()
        image_correlation = HObject(proc.get_output_object_key(1))
        return image_correlation  # type: ignore


def cos_image(image: HObject) -> HObject:
    """
    Calculate the cosine of an image.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    cos_image : HObject
                Output image.

    See Also
    --------
    sin_image, tan_image, asin_image, acos_image, atan_image, atan2_image

    Notes
    -----
    cos_image can be executed on OpenCL devices.
    """
    with HalconOperator(1602) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        cos_image = HObject(proc.get_output_object_key(1))
        return cos_image  # type: ignore


def count_channels(multi_channel_image: HObject) -> Sequence[int]:
    """
    Count channels of image.

    Parameters
    ----------

    multi_channel_image : HObject
                          One- or multi-channel image.

    Returns
    -------

    channels : Sequence[int]
               Number of channels.

    See Also
    --------
    append_channel, access_channel

    Successors
    ----------
    access_channel, append_channel, disp_image
    """
    with HalconOperator(1133) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.init_oct(0)
        proc.execute()
        channels = proc.get_output_tuple_m(0)
        return channels  # type: ignore


def count_channels_s(multi_channel_image: HObject) -> int:
    """
    Count channels of image.

    Parameters
    ----------

    multi_channel_image : HObject
                          One- or multi-channel image.

    Returns
    -------

    channels : int
               Number of channels.

    See Also
    --------
    append_channel, access_channel

    Successors
    ----------
    access_channel, append_channel, disp_image
    """
    with HalconOperator(1133) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.init_oct(0)
        proc.execute()
        channels = proc.get_output_tuple_s(0)
        return channels  # type: ignore


def count_obj(objects: HObject) -> int:
    """
    Number of objects in a tuple.

    Parameters
    ----------

    objects : HObject
              Objects to be examined.

    Returns
    -------

    number : int
             Number of objects in the tuple Objects.

    See Also
    --------
    copy_obj, obj_to_integer, connection, set_system
    """
    with HalconOperator(592) as proc:
        proc.set_input_object(1, objects)
        proc.init_oct(0)
        proc.execute()
        number = proc.get_output_tuple_s(0)
        return number  # type: ignore


def count_relation(relation_name: str) -> int:
    """
    Number of entries in the HALCON database.

    Parameters
    ----------

    relation_name : str
                    Relation of interest of the HALCON database.
                    Value Suggestion: object

    Returns
    -------

    num_of_tuples : int
                    Number of tuples in the relation.

    See Also
    --------
    clear_obj

    Predecessors
    ------------
    reset_obj_db

    Successors
    ----------
    set_system

    Notes
    -----
    Collecting database information is not threadsafe when passing iconic
    objects between threads, meaning when deleting objects in a different
    thread than generating them.
    """
    with HalconOperator(324) as proc:
        proc.set_input_tuple(0, relation_name)
        proc.init_oct(0)
        proc.execute()
        num_of_tuples = proc.get_output_tuple_s(0)
        return num_of_tuples  # type: ignore


def count_seconds() -> float:
    """
    Passed Time.

    Returns
    -------

    seconds : float
              Process time since the program start.

    See Also
    --------
    set_system

    Notes
    -----
    The time measurement is not exact and depends on the load of the
    computer.
    """
    with HalconOperator(323) as proc:
        proc.init_oct(0)
        proc.execute()
        seconds = proc.get_output_tuple_s(0)
        return seconds  # type: ignore


def create_aniso_shape_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: float,
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: float,
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: MaybeSequence[Union[int, str]],
    min_contrast: Union[int, str]
) -> HHandle:
    """
    Prepare an anisotropically scaled shape model for matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    scale_rmin : float
                 Minimum scale of the pattern in the row direction.
                 Value Suggestion: 0.9
                 Assertion: ScaleRMin > 0

    scale_rmax : float
                 Maximum scale of the pattern in the row direction.
                 Value Suggestion: 1.1
                 Assertion: ScaleRMax >= ScaleRMin

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in the row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep >= 0

    scale_cmin : float
                 Minimum scale of the pattern in the column direction.
                 Value Suggestion: 0.9
                 Assertion: ScaleCMin > 0

    scale_cmax : float
                 Maximum scale of the pattern in the column direction.
                 Value Suggestion: 1.1
                 Assertion: ScaleCMax >= ScaleCMin

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in the column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : MaybeSequence[Union[int, str]]
               Threshold or hysteresis thresholds for the contrast of the
               object in the template image and optionally minimum size of
               the object parts.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    find_aniso_shape_model, find_aniso_shape_models,
    get_shape_model_params, clear_shape_model, write_shape_model,
    set_shape_model_origin, set_shape_model_clutter
    """
    with HalconOperator(938) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, contrast)
        proc.set_input_tuple(13, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_aniso_shape_model_xld(
    contours: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: float,
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: float,
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int
) -> HHandle:
    """
    Prepare an anisotropically scaled shape model for matching from XLD
    contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    scale_rmin : float
                 Minimum scale of the pattern in the row direction.
                 Value Suggestion: 0.9
                 Assertion: ScaleRMin > 0

    scale_rmax : float
                 Maximum scale of the pattern in the row direction.
                 Value Suggestion: 1.1
                 Assertion: ScaleRMax >= ScaleRMin

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in the row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep >= 0

    scale_cmin : float
                 Minimum scale of the pattern in the column direction.
                 Value Suggestion: 0.9
                 Assertion: ScaleCMin > 0

    scale_cmax : float
                 Maximum scale of the pattern in the column direction.
                 Value Suggestion: 1.1
                 Assertion: ScaleCMax >= ScaleCMin

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in the column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_aniso_shape_model, find_aniso_shape_models,
    get_shape_model_params, clear_shape_model, write_shape_model,
    set_shape_model_origin, set_shape_model_param, set_shape_model_metric,
    set_shape_model_clutter

    Notes
    -----
    The XLD contours passed in Contours should have been scaled to
    approximately the average size of the object in the search images.
    This means that the products $ScaleRMin
    arRef{ScaleRMax}$ScaleRMin*ScaleRMax and $ScaleCMin
    arRef{ScaleCMax}$ScaleCMin*ScaleCMax should be approximately equal to
    1.
    Note that, in contrast to the operator create_aniso_shape_model, it is
    not possible to specify a minimum size of the model components. To
    avoid small model components in the shape model, short contours can be
    eliminated before calling create_aniso_shape_model_xld with the
    operator select_contours_xld.
    """
    with HalconOperator(935) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_bar_code_model(
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[float, int, str]]
) -> HHandle:
    """
    Create a model of a bar code reader.

    Parameters
    ----------

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters that can be adjusted
                     for the bar code model.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[float, int, str]]
                      Values of the generic parameters that can be
                      adjusted for the bar code model.
                      Value Suggestion: []

    Returns
    -------

    bar_code_handle : HHandle
                      Handle for using and accessing the bar code model.

    See Also
    --------
    clear_bar_code_model

    Successors
    ----------
    find_bar_code
    """
    with HalconOperator(2001) as proc:
        proc.set_input_tuple(0, gen_param_name)
        proc.set_input_tuple(1, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        bar_code_handle = proc.get_output_tuple_s(0)
        return bar_code_handle  # type: ignore


def create_barrier(
    attrib_name: MaybeSequence[Union[int, float, str]],
    attrib_value: MaybeSequence[Union[int, float, str]],
    team_size: int
) -> HHandle:
    """
    Create a barrier synchronization object.

    Parameters
    ----------

    attrib_name : MaybeSequence[Union[int, float, str]]
                  Barrier attribute.
                  Value Suggestion: []

    attrib_value : MaybeSequence[Union[int, float, str]]
                   Barrier attribute value.
                   Value Suggestion: []

    team_size : int
                Barrier team size.
                Value Suggestion: 1

    Returns
    -------

    barrier_handle : HHandle
                     Barrier synchronization object.

    Successors
    ----------
    wait_barrier, clear_barrier
    """
    with HalconOperator(552) as proc:
        proc.set_input_tuple(0, attrib_name)
        proc.set_input_tuple(1, attrib_value)
        proc.set_input_tuple(2, team_size)
        proc.init_oct(0)
        proc.execute()
        barrier_handle = proc.get_output_tuple_s(0)
        return barrier_handle  # type: ignore


def create_bead_inspection_model(
    bead_contour: HObject,
    target_thickness: Union[int, float],
    thickness_tolerance: Union[int, float],
    position_tolerance: Union[int, float],
    polarity: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a model to inspect beads or adhesive in images.

    Parameters
    ----------

    bead_contour : HObject
                   XLD contour specifying the expected bead's shape and
                   position.

    target_thickness : Union[int, float]
                       Optimal bead thickness.
                       Value Suggestion: 50

    thickness_tolerance : Union[int, float]
                          Tolerance of bead's thickness with respect to
                          TargetThickness.
                          Value Suggestion: 15

    position_tolerance : Union[int, float]
                         Tolerance of the bead's center position.
                         Value Suggestion: 15

    polarity : str
               The bead's polarity.
               Value Suggestion: light

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters that can be adjusted
                     for the bead inspection model.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Values of the generic parameters that can be
                      adjusted for the bead inspection model.
                      Value Suggestion: []

    Returns
    -------

    bead_inspection_model : HHandle
                            Handle for using and accessing the bead
                            inspection model.

    See Also
    --------
    clear_bead_inspection_model

    Predecessors
    ------------
    gen_contour_nurbs_xld, gen_contour_polygon_xld

    Successors
    ----------
    apply_bead_inspection_model, set_bead_inspection_param
    """
    with HalconOperator(1985) as proc:
        proc.set_input_object(1, bead_contour)
        proc.set_input_tuple(0, target_thickness)
        proc.set_input_tuple(1, thickness_tolerance)
        proc.set_input_tuple(2, position_tolerance)
        proc.set_input_tuple(3, polarity)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        bead_inspection_model = proc.get_output_tuple_s(0)
        return bead_inspection_model  # type: ignore


def create_bg_esti(
    initialize_image: HObject,
    syspar_1: float,
    syspar_2: float,
    gain_mode: str,
    gain_1: float,
    gain_2: float,
    adapt_mode: str,
    min_diff: float,
    stat_num: int,
    confidence_c: float,
    time_c: float
) -> HHandle:
    """
    Generate and initialize a data set for the background estimation.

    Parameters
    ----------

    initialize_image : HObject
                       initialization image.

    syspar_1 : float
               1. system matrix parameter.
               Value Suggestion: 0.7

    syspar_2 : float
               2. system matrix parameter.
               Value Suggestion: 0.7

    gain_mode : str
                Gain type.
                Value Suggestion: fixed

    gain_1 : float
             Kalman gain / foreground adaptation time.
             Value Suggestion: 0.002
             Assertion: 0.0 <= Gain1

    gain_2 : float
             Kalman gain / background adaptation time.
             Value Suggestion: 0.02
             Assertion: 0.0 <= Gain2

    adapt_mode : str
                 Threshold adaptation.
                 Value Suggestion: on

    min_diff : float
               Foreground/background threshold.
               Value Suggestion: 7.0

    stat_num : int
               Number of statistic data sets.
               Value Suggestion: 10

    confidence_c : float
                   Confidence constant.
                   Value Suggestion: 3.25
                   Assertion: 0.0 < ConfidenceC

    time_c : float
             Constant for decay time.
             Value Suggestion: 15.0
             Assertion: 0.0 < TimeC

    Returns
    -------

    bg_esti_handle : HHandle
                     ID of the BgEsti data set.

    See Also
    --------
    set_bg_esti_params, close_bg_esti

    Successors
    ----------
    run_bg_esti

    Notes
    -----
    If GainMode was set to 'frame', the run-time can be extremely long for
    large values of Gain1 or Gain2, because the values for the gains'
    table are determined by a simple binary search.
    """
    with HalconOperator(2008) as proc:
        proc.set_input_object(1, initialize_image)
        proc.set_input_tuple(0, syspar_1)
        proc.set_input_tuple(1, syspar_2)
        proc.set_input_tuple(2, gain_mode)
        proc.set_input_tuple(3, gain_1)
        proc.set_input_tuple(4, gain_2)
        proc.set_input_tuple(5, adapt_mode)
        proc.set_input_tuple(6, min_diff)
        proc.set_input_tuple(7, stat_num)
        proc.set_input_tuple(8, confidence_c)
        proc.set_input_tuple(9, time_c)
        proc.init_oct(0)
        proc.execute()
        bg_esti_handle = proc.get_output_tuple_s(0)
        return bg_esti_handle  # type: ignore


def create_calib_data(
    calib_setup: str,
    num_cameras: int,
    num_calib_objects: int
) -> HHandle:
    """
    Create a HALCON calibration data model.

    Parameters
    ----------

    calib_setup : str
                  Type of the calibration setup.
                  Value Suggestion: calibration_object

    num_cameras : int
                  Number of cameras in the calibration setup.
                  Value Suggestion: 1
                  Assertion: NumCameras >= 0

    num_calib_objects : int
                        Number of calibration objects.
                        Value Suggestion: 1
                        Assertion: NumCalibObjects >= 0

    Returns
    -------

    calib_data_id : HHandle
                    Handle of the created calibration data model.

    Successors
    ----------
    set_calib_data_cam_param, set_calib_data_calib_object
    """
    with HalconOperator(1980) as proc:
        proc.set_input_tuple(0, calib_setup)
        proc.set_input_tuple(1, num_cameras)
        proc.set_input_tuple(2, num_calib_objects)
        proc.init_oct(0)
        proc.execute()
        calib_data_id = proc.get_output_tuple_s(0)
        return calib_data_id  # type: ignore


def create_calib_descriptor_model(
    template: HObject,
    cam_param: Sequence[Union[float, int, str]],
    reference_pose: Sequence[Union[float, int]],
    detector_type: str,
    detector_param_name: Sequence[str],
    detector_param_value: Sequence[Union[int, float, str]],
    descriptor_param_name: Sequence[str],
    descriptor_param_value: Sequence[Union[int, float, str]],
    seed: int
) -> HHandle:
    """
    Create a descriptor model for calibrated perspective matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    cam_param : Sequence[Union[float, int, str]]
                The parameters of the internal orientation of the camera.

    reference_pose : Sequence[Union[float, int]]
                     The reference pose of the object in the reference
                     image.

    detector_type : str
                    The type of the detector.
                    Value Suggestion: lepetit

    detector_param_name : Sequence[str]
                          The detector's parameter names.
                          Value Suggestion: []

    detector_param_value : Sequence[Union[int, float, str]]
                           Values of the detector's parameters.
                           Value Suggestion: []

    descriptor_param_name : Sequence[str]
                            The descriptor's parameter names.
                            Value Suggestion: []

    descriptor_param_value : Sequence[Union[int, float, str]]
                             Values of the descriptor's parameters.
                             Value Suggestion: []

    seed : int
           The seed for the random number generator.
           Value Suggestion: 42

    Returns
    -------

    model_id : HHandle
               The handle to the descriptor model.

    See Also
    --------
    get_descriptor_model_params, find_calib_descriptor_model

    Predecessors
    ------------
    points_lepetit, points_harris, reduce_domain

    Successors
    ----------
    get_descriptor_model_params, find_calib_descriptor_model
    """
    with HalconOperator(952) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, cam_param)
        proc.set_input_tuple(1, reference_pose)
        proc.set_input_tuple(2, detector_type)
        proc.set_input_tuple(3, detector_param_name)
        proc.set_input_tuple(4, detector_param_value)
        proc.set_input_tuple(5, descriptor_param_name)
        proc.set_input_tuple(6, descriptor_param_value)
        proc.set_input_tuple(7, seed)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_caltab(
    num_rows: int,
    marks_per_row: int,
    diameter: float,
    finder_row: MaybeSequence[int],
    finder_column: MaybeSequence[int],
    polarity: str,
    cal_plate_descr: str,
    cal_plate_psfile: str
) -> None:
    """
    Generate a calibration plate description file and a corresponding
    PostScript file for a calibration plate with hexagonally arranged
    marks.

    Parameters
    ----------

    num_rows : int
               Number of rows.
               Value Suggestion: 27
               Assertion: NumRows > 2

    marks_per_row : int
                    Number of marks per row.
                    Value Suggestion: 31
                    Assertion: MarksPerRow > 2

    diameter : float
               Diameter of the marks.
               Value Suggestion: 0.00258065

    finder_row : MaybeSequence[int]
                 Row indices of the finder patterns.
                 Value Suggestion: [13,6,6,20,20]

    finder_column : MaybeSequence[int]
                    Column indices of the finder patterns.
                    Value Suggestion: [15,6,24,6,24]

    polarity : str
               Polarity of the marks
               Value Suggestion: 'light_on_dark'

    cal_plate_descr : str
                      File name of the calibration plate description.
                      Value Suggestion: calplate.cpd

    cal_plate_psfile : str
                       File name of the PostScript file.
                       Value Suggestion: calplate.ps

    See Also
    --------
    find_caltab, find_marks_and_pose, camera_calibration, disp_caltab,
    sim_caltab

    Alternatives
    ------------
    gen_caltab

    Successors
    ----------
    read_cam_par, caltab_points

    Notes
    -----
    Depending on the accuracy of the used output device (e.g., laser
    printer), a printed calibration plate may not match the values in the
    calibration plate description file CalPlateDescr exactly. Thus, the
    coordinates of the calibration marks in the calibration plate
    description file may have to be corrected!
    For purchased calibration plates it is recommended to use the specific
    calibration description file that is supplied with your calibration
    plate.
    """
    with HalconOperator(1927) as proc:
        proc.set_input_tuple(0, num_rows)
        proc.set_input_tuple(1, marks_per_row)
        proc.set_input_tuple(2, diameter)
        proc.set_input_tuple(3, finder_row)
        proc.set_input_tuple(4, finder_column)
        proc.set_input_tuple(5, polarity)
        proc.set_input_tuple(6, cal_plate_descr)
        proc.set_input_tuple(7, cal_plate_psfile)
        proc.execute()


def create_cam_pose_look_at_point(
    cam_pos_x: MaybeSequence[float],
    cam_pos_y: MaybeSequence[float],
    cam_pos_z: MaybeSequence[float],
    look_at_x: MaybeSequence[float],
    look_at_y: MaybeSequence[float],
    look_at_z: MaybeSequence[float],
    ref_plane_normal: Sequence[Union[str, float]],
    cam_roll: MaybeSequence[float]
) -> Sequence[Union[int, float]]:
    """
    Create a 3D camera pose from camera center and viewing direction.

    Parameters
    ----------

    cam_pos_x : MaybeSequence[float]
                X coordinate of the optical center of the camera.

    cam_pos_y : MaybeSequence[float]
                Y coordinate of the optical center of the camera.

    cam_pos_z : MaybeSequence[float]
                Z coordinate of the optical center of the camera.

    look_at_x : MaybeSequence[float]
                X coordinate of the 3D point to which the camera is
                directed.

    look_at_y : MaybeSequence[float]
                Y coordinate of the 3D point to which the camera is
                directed.

    look_at_z : MaybeSequence[float]
                Z coordinate of the 3D point to which the camera is
                directed.

    ref_plane_normal : Sequence[Union[str, float]]
                       Normal vector of the reference plane (points up).
                       Value Suggestion: -y

    cam_roll : MaybeSequence[float]
               Camera roll angle.
               Value Suggestion: 0

    Returns
    -------

    cam_pose : Sequence[Union[int, float]]
               3D camera pose.

    Alternatives
    ------------
    create_pose

    Predecessors
    ------------
    convert_point_3d_spher_to_cart
    """
    with HalconOperator(1045) as proc:
        proc.set_input_tuple(0, cam_pos_x)
        proc.set_input_tuple(1, cam_pos_y)
        proc.set_input_tuple(2, cam_pos_z)
        proc.set_input_tuple(3, look_at_x)
        proc.set_input_tuple(4, look_at_y)
        proc.set_input_tuple(5, look_at_z)
        proc.set_input_tuple(6, ref_plane_normal)
        proc.set_input_tuple(7, cam_roll)
        proc.init_oct(0)
        proc.execute()
        cam_pose = proc.get_output_tuple_m(0)
        return cam_pose  # type: ignore


def create_camera_setup_model(num_cameras: int) -> HHandle:
    """
    Create a model for a setup of calibrated cameras.

    Parameters
    ----------

    num_cameras : int
                  Number of cameras in the setup.
                  Value Suggestion: 2
                  Assertion: NumCameras >= 1

    Returns
    -------

    camera_setup_model_id : HHandle
                            Handle to the camera setup model.

    Successors
    ----------
    set_camera_setup_param
    """
    with HalconOperator(1958) as proc:
        proc.set_input_tuple(0, num_cameras)
        proc.init_oct(0)
        proc.execute()
        camera_setup_model_id = proc.get_output_tuple_s(0)
        return camera_setup_model_id  # type: ignore


def create_class_box() -> HHandle:
    """
    Create a new classifier.

    Returns
    -------

    classif_handle : HHandle
                     Handle of the classifier.

    See Also
    --------
    learn_class_box, enquire_class_box, close_class_box

    Successors
    ----------
    learn_class_box, enquire_class_box, write_class_box, close_class_box,
    clear_sampset

    Warnings
    --------
    create_class_box is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the MLP, SVM, KNN
    or GMM operators instead.
    """
    with HalconOperator(1895) as proc:
        proc.init_oct(0)
        proc.execute()
        classif_handle = proc.get_output_tuple_s(0)
        return classif_handle  # type: ignore


def create_class_gmm(
    num_dim: int,
    num_classes: int,
    num_centers: MaybeSequence[int],
    covar_type: str,
    preprocessing: str,
    num_components: int,
    rand_seed: int
) -> HHandle:
    """
    Create a Gaussian Mixture Model for classification

    Parameters
    ----------

    num_dim : int
              Number of dimensions of the feature space.
              Value Suggestion: 3
              Assertion: NumDim >= 1

    num_classes : int
                  Number of classes of the GMM.
                  Value Suggestion: 5
                  Assertion: NumClasses >= 1

    num_centers : MaybeSequence[int]
                  Number of centers per class.
                  Value Suggestion: 1
                  Assertion: NumClasses >= 1

    covar_type : str
                 Type of the covariance matrices.
                 Value Suggestion: spherical

    preprocessing : str
                    Type of preprocessing used to transform the feature
                    vectors.
                    Value Suggestion: normalization

    num_components : int
                     Preprocessing parameter: Number of transformed
                     features (ignored for Preprocessing $=$ 'none' and
                     Preprocessing $=$ 'normalization').
                     Value Suggestion: 10
                     Assertion: NumComponents >= 1

    rand_seed : int
                Seed value of the random number generator that is used to
                initialize the GMM with random values.
                Value Suggestion: 42

    Returns
    -------

    gmmhandle : HHandle
                GMM handle.

    See Also
    --------
    clear_class_gmm, train_class_gmm, classify_class_gmm,
    evaluate_class_gmm, classify_image_class_gmm

    Alternatives
    ------------
    create_class_mlp, create_class_svm

    Successors
    ----------
    add_sample_class_gmm, add_samples_image_class_gmm
    """
    with HalconOperator(1840) as proc:
        proc.set_input_tuple(0, num_dim)
        proc.set_input_tuple(1, num_classes)
        proc.set_input_tuple(2, num_centers)
        proc.set_input_tuple(3, covar_type)
        proc.set_input_tuple(4, preprocessing)
        proc.set_input_tuple(5, num_components)
        proc.set_input_tuple(6, rand_seed)
        proc.init_oct(0)
        proc.execute()
        gmmhandle = proc.get_output_tuple_s(0)
        return gmmhandle  # type: ignore


def create_class_knn(num_dim: Sequence[int]) -> HHandle:
    """
    Create a k-nearest neighbors (k-NN) classifier.

    Parameters
    ----------

    num_dim : Sequence[int]
              Number of dimensions of the feature.
              Value Suggestion: 10

    Returns
    -------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    See Also
    --------
    select_feature_set_knn, read_class_knn

    Alternatives
    ------------
    create_class_svm, create_class_mlp

    Successors
    ----------
    add_sample_class_knn, train_class_knn
    """
    with HalconOperator(1816) as proc:
        proc.set_input_tuple(0, num_dim)
        proc.init_oct(0)
        proc.execute()
        knnhandle = proc.get_output_tuple_s(0)
        return knnhandle  # type: ignore


def create_class_lut_gmm(
    gmmhandle: HHandle,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> HHandle:
    """
    Create a look-up table using a gaussian mixture model to classify byte
    images.

    Parameters
    ----------

    gmmhandle : HHandle
                GMM handle.

    gen_param_name : Sequence[str]
                     Names of the generic parameters that can be adjusted
                     for the LUT classifier creation.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Values of the generic parameters that can be
                      adjusted for the LUT classifier creation.
                      Value Suggestion: []

    Returns
    -------

    class_luthandle : HHandle
                      Handle of the LUT classifier.

    See Also
    --------
    classify_image_class_lut, clear_class_lut

    Alternatives
    ------------
    create_class_lut_knn, create_class_lut_mlp, create_class_lut_svm

    Predecessors
    ------------
    train_class_gmm, read_class_gmm

    Successors
    ----------
    classify_image_class_lut
    """
    with HalconOperator(1820) as proc:
        proc.set_input_tuple(0, gmmhandle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        class_luthandle = proc.get_output_tuple_s(0)
        return class_luthandle  # type: ignore


def create_class_lut_knn(
    knnhandle: HHandle,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> HHandle:
    """
    Create a look-up table using a k-nearest neighbors classifier (k-NN)
    to classify byte images.

    Parameters
    ----------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    gen_param_name : Sequence[str]
                     Names of the generic parameters that can be adjusted
                     for the LUT classifier creation.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Values of the generic parameters that can be
                      adjusted for the LUT classifier creation.
                      Value Suggestion: []

    Returns
    -------

    class_luthandle : HHandle
                      Handle of the LUT classifier.

    See Also
    --------
    classify_image_class_lut, clear_class_lut

    Alternatives
    ------------
    create_class_lut_svm, create_class_lut_gmm, create_class_lut_mlp

    Predecessors
    ------------
    train_class_knn, read_class_knn

    Successors
    ----------
    classify_image_class_lut
    """
    with HalconOperator(1819) as proc:
        proc.set_input_tuple(0, knnhandle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        class_luthandle = proc.get_output_tuple_s(0)
        return class_luthandle  # type: ignore


def create_class_lut_mlp(
    mlphandle: HHandle,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> HHandle:
    """
    Create a look-up table using a multi-layer perceptron to classify byte
    images.

    Parameters
    ----------

    mlphandle : HHandle
                MLP handle.

    gen_param_name : Sequence[str]
                     Names of the generic parameters that can be adjusted
                     for the LUT classifier creation.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Values of the generic parameters that can be
                      adjusted for the LUT classifier creation.
                      Value Suggestion: []

    Returns
    -------

    class_luthandle : HHandle
                      Handle of the LUT classifier.

    See Also
    --------
    classify_image_class_lut, clear_class_lut

    Alternatives
    ------------
    create_class_lut_gmm, create_class_lut_knn, create_class_lut_svm

    Predecessors
    ------------
    train_class_mlp, read_class_mlp

    Successors
    ----------
    classify_image_class_lut
    """
    with HalconOperator(1822) as proc:
        proc.set_input_tuple(0, mlphandle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        class_luthandle = proc.get_output_tuple_s(0)
        return class_luthandle  # type: ignore


def create_class_lut_svm(
    svmhandle: HHandle,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int]]
) -> HHandle:
    """
    Create a look-up table using a Support-Vector-Machine to classify byte
    images.

    Parameters
    ----------

    svmhandle : HHandle
                SVM handle.

    gen_param_name : Sequence[str]
                     Names of the generic parameters that can be adjusted
                     for the LUT classifier creation.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int]]
                      Values of the generic parameters that can be
                      adjusted for the LUT classifier creation.
                      Value Suggestion: []

    Returns
    -------

    class_luthandle : HHandle
                      Handle of the LUT classifier.

    See Also
    --------
    classify_image_class_lut, clear_class_lut

    Alternatives
    ------------
    create_class_lut_gmm, create_class_lut_knn, create_class_lut_mlp

    Predecessors
    ------------
    train_class_svm, read_class_svm

    Successors
    ----------
    classify_image_class_lut
    """
    with HalconOperator(1821) as proc:
        proc.set_input_tuple(0, svmhandle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        class_luthandle = proc.get_output_tuple_s(0)
        return class_luthandle  # type: ignore


def create_class_mlp(
    num_input: int,
    num_hidden: int,
    num_output: int,
    output_function: str,
    preprocessing: str,
    num_components: int,
    rand_seed: int
) -> HHandle:
    """
    Create a multilayer perceptron for classification or regression.

    Parameters
    ----------

    num_input : int
                Number of input variables (features) of the MLP.
                Value Suggestion: 20
                Assertion: NumInput >= 1

    num_hidden : int
                 Number of hidden units of the MLP.
                 Value Suggestion: 10
                 Assertion: NumHidden >= 1

    num_output : int
                 Number of output variables (classes) of the MLP.
                 Value Suggestion: 5
                 Assertion: NumOutput >= 1

    output_function : str
                      Type of the activation function in the output layer
                      of the MLP.
                      Value Suggestion: softmax

    preprocessing : str
                    Type of preprocessing used to transform the feature
                    vectors.
                    Value Suggestion: normalization

    num_components : int
                     Preprocessing parameter: Number of transformed
                     features (ignored for Preprocessing $=$ 'none' and
                     Preprocessing $=$ 'normalization').
                     Value Suggestion: 10
                     Assertion: NumComponents >= 1

    rand_seed : int
                Seed value of the random number generator that is used to
                initialize the MLP with random values.
                Value Suggestion: 42

    Returns
    -------

    mlphandle : HHandle
                MLP handle.

    See Also
    --------
    clear_class_mlp, train_class_mlp, classify_class_mlp,
    evaluate_class_mlp

    Alternatives
    ------------
    read_dl_classifier, create_class_svm, create_class_gmm

    Successors
    ----------
    add_sample_class_mlp, set_regularization_params_class_mlp,
    set_rejection_params_class_mlp
    """
    with HalconOperator(1883) as proc:
        proc.set_input_tuple(0, num_input)
        proc.set_input_tuple(1, num_hidden)
        proc.set_input_tuple(2, num_output)
        proc.set_input_tuple(3, output_function)
        proc.set_input_tuple(4, preprocessing)
        proc.set_input_tuple(5, num_components)
        proc.set_input_tuple(6, rand_seed)
        proc.init_oct(0)
        proc.execute()
        mlphandle = proc.get_output_tuple_s(0)
        return mlphandle  # type: ignore


def create_class_svm(
    num_features: int,
    kernel_type: str,
    kernel_param: float,
    nu: float,
    num_classes: int,
    mode: str,
    preprocessing: str,
    num_components: int
) -> HHandle:
    """
    Create a support vector machine for pattern classification.

    Parameters
    ----------

    num_features : int
                   Number of input variables (features) of the SVM.
                   Value Suggestion: 10
                   Assertion: NumFeatures >= 1

    kernel_type : str
                  The kernel type.
                  Value Suggestion: rbf

    kernel_param : float
                   Additional parameter for the kernel function. In case
                   of RBF kernel the value for gamma$- For polynomial
                   kernel the degree
                   Value Suggestion: 0.02

    nu : float
         Regularization constant of the SVM.
         Value Suggestion: 0.05
         Assertion: Nu > 0.0 && Nu < 1.0

    num_classes : int
                  Number of classes.
                  Value Suggestion: 5
                  Assertion: NumClasses >= 1

    mode : str
           The mode of the SVM.
           Value Suggestion: one-versus-one

    preprocessing : str
                    Type of preprocessing used to transform the feature
                    vectors.
                    Value Suggestion: normalization

    num_components : int
                     Preprocessing parameter: Number of transformed
                     features (ignored for Preprocessing $=$ 'none' and
                     Preprocessing $=$ 'normalization').
                     Value Suggestion: 10
                     Assertion: NumComponents >= 1

    Returns
    -------

    svmhandle : HHandle
                SVM handle.

    See Also
    --------
    clear_class_svm, train_class_svm, classify_class_svm

    Alternatives
    ------------
    read_dl_classifier, create_class_mlp, create_class_gmm

    Successors
    ----------
    add_sample_class_svm
    """
    with HalconOperator(1861) as proc:
        proc.set_input_tuple(0, num_features)
        proc.set_input_tuple(1, kernel_type)
        proc.set_input_tuple(2, kernel_param)
        proc.set_input_tuple(3, nu)
        proc.set_input_tuple(4, num_classes)
        proc.set_input_tuple(5, mode)
        proc.set_input_tuple(6, preprocessing)
        proc.set_input_tuple(7, num_components)
        proc.init_oct(0)
        proc.execute()
        svmhandle = proc.get_output_tuple_s(0)
        return svmhandle  # type: ignore


def create_class_train_data(num_dim: int) -> HHandle:
    """
    Create a handle for training data for classifiers.

    Parameters
    ----------

    num_dim : int
              Number of dimensions of the feature vector.
              Value Suggestion: 10

    Returns
    -------

    class_train_data_handle : HHandle
                              Handle of the training data.

    See Also
    --------
    select_feature_set_knn, read_class_knn

    Alternatives
    ------------
    create_class_svm, create_class_mlp

    Successors
    ----------
    add_sample_class_knn, train_class_knn
    """
    with HalconOperator(1798) as proc:
        proc.set_input_tuple(0, num_dim)
        proc.init_oct(0)
        proc.execute()
        class_train_data_handle = proc.get_output_tuple_s(0)
        return class_train_data_handle  # type: ignore


def create_color_trans_lut(
    color_space: str,
    trans_direction: str,
    num_bits: int
) -> HHandle:
    """
    Creates the look-up-table for transformation of an image from the RGB
    color space to an arbitrary color space.

    Parameters
    ----------

    color_space : str
                  Color space of the output image.
                  Value Suggestion: hsv

    trans_direction : str
                      Direction of color space transformation.
                      Value Suggestion: from_rgb

    num_bits : int
               Number of bits of the input image.
               Value Suggestion: 8

    Returns
    -------

    color_trans_luthandle : HHandle
                            Handle of the look-up-table for color space
                            transformation.

    See Also
    --------
    apply_color_trans_lut, clear_color_trans_lut

    Successors
    ----------
    apply_color_trans_lut
    """
    with HalconOperator(1579) as proc:
        proc.set_input_tuple(0, color_space)
        proc.set_input_tuple(1, trans_direction)
        proc.set_input_tuple(2, num_bits)
        proc.init_oct(0)
        proc.execute()
        color_trans_luthandle = proc.get_output_tuple_s(0)
        return color_trans_luthandle  # type: ignore


def create_component_model(
    model_image: HObject,
    component_regions: HObject,
    variation_row: MaybeSequence[int],
    variation_column: MaybeSequence[int],
    variation_angle: MaybeSequence[float],
    angle_start: float,
    angle_extent: float,
    contrast_low_comp: MaybeSequence[Union[int, str]],
    contrast_high_comp: MaybeSequence[Union[int, str]],
    min_size_comp: MaybeSequence[Union[int, str]],
    min_contrast_comp: MaybeSequence[Union[int, str]],
    min_score_comp: MaybeSequence[float],
    num_levels_comp: MaybeSequence[Union[int, str]],
    angle_step_comp: MaybeSequence[Union[float, str]],
    optimization_comp: str,
    metric_comp: MaybeSequence[str],
    pregeneration_comp: MaybeSequence[str]
) -> Tuple[HHandle, Sequence[int]]:
    """
    Prepare a component model for matching based on explicitly specified
    components and relations.

    Parameters
    ----------

    model_image : HObject
                  Input image from which the shape models of the model
                  components should be created.

    component_regions : HObject
                        Input regions from which the shape models of the
                        model components should be created.

    variation_row : MaybeSequence[int]
                    Variation of the model components in row direction.
                    Assertion: VariationRow >= 0

    variation_column : MaybeSequence[int]
                       Variation of the model components in column
                       direction.
                       Assertion: VariationColumn >= 0

    variation_angle : MaybeSequence[float]
                      Angle variation of the model components.
                      Assertion: VariationAngle >= 0

    angle_start : float
                  Smallest rotation of the component model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation of the component model.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    contrast_low_comp : MaybeSequence[Union[int, str]]
                        Lower hysteresis threshold for the contrast of the
                        components in the model image.
                        Value Suggestion: auto
                        Assertion: ContrastLowComp > 0

    contrast_high_comp : MaybeSequence[Union[int, str]]
                         Upper hysteresis threshold for the contrast of
                         the components in the model image.
                         Value Suggestion: auto
                         Assertion: ContrastHighComp > 0 && ContrastHighComp >= ContrastLowComp

    min_size_comp : MaybeSequence[Union[int, str]]
                    Minimum size of the contour regions in the model.
                    Value Suggestion: auto
                    Assertion: MinSizeComp >= 0

    min_contrast_comp : MaybeSequence[Union[int, str]]
                        Minimum contrast of the components in the search
                        images.
                        Value Suggestion: auto
                        Assertion: MinContrastComp <= ContrastLowComp && MinContrastComp >= 0

    min_score_comp : MaybeSequence[float]
                     Minimum score of the instances of the components to
                     be found.
                     Value Suggestion: 0.5
                     Assertion: 0 <= MinScoreComp && MinScoreComp <= 1

    num_levels_comp : MaybeSequence[Union[int, str]]
                      Maximum number of pyramid levels for the components.
                      Value Suggestion: auto

    angle_step_comp : MaybeSequence[Union[float, str]]
                      Step length of the angles (resolution) for the
                      components.
                      Value Suggestion: auto
                      Assertion: AngleStepComp >= 0

    optimization_comp : str
                        Kind of optimization for the components.
                        Value Suggestion: auto

    metric_comp : MaybeSequence[str]
                  Match metric used for the components.
                  Value Suggestion: use_polarity

    pregeneration_comp : MaybeSequence[str]
                         Complete pregeneration of the shape models for
                         the components if equal to 'true'.
                         Value Suggestion: false

    Returns
    -------

    component_model_id : HHandle
                         Handle of the component model.

    root_ranking : Sequence[int]
                   Ranking of the model components expressing the
                   suitability to act as the root component.

    Alternatives
    ------------
    create_trained_component_model

    Predecessors
    ------------
    draw_region, concat_obj

    Successors
    ----------
    find_component_model
    """
    with HalconOperator(1004) as proc:
        proc.set_input_object(1, model_image)
        proc.set_input_object(2, component_regions)
        proc.set_input_tuple(0, variation_row)
        proc.set_input_tuple(1, variation_column)
        proc.set_input_tuple(2, variation_angle)
        proc.set_input_tuple(3, angle_start)
        proc.set_input_tuple(4, angle_extent)
        proc.set_input_tuple(5, contrast_low_comp)
        proc.set_input_tuple(6, contrast_high_comp)
        proc.set_input_tuple(7, min_size_comp)
        proc.set_input_tuple(8, min_contrast_comp)
        proc.set_input_tuple(9, min_score_comp)
        proc.set_input_tuple(10, num_levels_comp)
        proc.set_input_tuple(11, angle_step_comp)
        proc.set_input_tuple(12, optimization_comp)
        proc.set_input_tuple(13, metric_comp)
        proc.set_input_tuple(14, pregeneration_comp)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # component_model_id
            proc.get_output_tuple_m(1)   # root_ranking
        )  # type: ignore


def create_component_model_s(
    model_image: HObject,
    component_regions: HObject,
    variation_row: MaybeSequence[int],
    variation_column: MaybeSequence[int],
    variation_angle: MaybeSequence[float],
    angle_start: float,
    angle_extent: float,
    contrast_low_comp: MaybeSequence[Union[int, str]],
    contrast_high_comp: MaybeSequence[Union[int, str]],
    min_size_comp: MaybeSequence[Union[int, str]],
    min_contrast_comp: MaybeSequence[Union[int, str]],
    min_score_comp: MaybeSequence[float],
    num_levels_comp: MaybeSequence[Union[int, str]],
    angle_step_comp: MaybeSequence[Union[float, str]],
    optimization_comp: str,
    metric_comp: MaybeSequence[str],
    pregeneration_comp: MaybeSequence[str]
) -> Tuple[HHandle, int]:
    """
    Prepare a component model for matching based on explicitly specified
    components and relations.

    Parameters
    ----------

    model_image : HObject
                  Input image from which the shape models of the model
                  components should be created.

    component_regions : HObject
                        Input regions from which the shape models of the
                        model components should be created.

    variation_row : MaybeSequence[int]
                    Variation of the model components in row direction.
                    Assertion: VariationRow >= 0

    variation_column : MaybeSequence[int]
                       Variation of the model components in column
                       direction.
                       Assertion: VariationColumn >= 0

    variation_angle : MaybeSequence[float]
                      Angle variation of the model components.
                      Assertion: VariationAngle >= 0

    angle_start : float
                  Smallest rotation of the component model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation of the component model.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    contrast_low_comp : MaybeSequence[Union[int, str]]
                        Lower hysteresis threshold for the contrast of the
                        components in the model image.
                        Value Suggestion: auto
                        Assertion: ContrastLowComp > 0

    contrast_high_comp : MaybeSequence[Union[int, str]]
                         Upper hysteresis threshold for the contrast of
                         the components in the model image.
                         Value Suggestion: auto
                         Assertion: ContrastHighComp > 0 && ContrastHighComp >= ContrastLowComp

    min_size_comp : MaybeSequence[Union[int, str]]
                    Minimum size of the contour regions in the model.
                    Value Suggestion: auto
                    Assertion: MinSizeComp >= 0

    min_contrast_comp : MaybeSequence[Union[int, str]]
                        Minimum contrast of the components in the search
                        images.
                        Value Suggestion: auto
                        Assertion: MinContrastComp <= ContrastLowComp && MinContrastComp >= 0

    min_score_comp : MaybeSequence[float]
                     Minimum score of the instances of the components to
                     be found.
                     Value Suggestion: 0.5
                     Assertion: 0 <= MinScoreComp && MinScoreComp <= 1

    num_levels_comp : MaybeSequence[Union[int, str]]
                      Maximum number of pyramid levels for the components.
                      Value Suggestion: auto

    angle_step_comp : MaybeSequence[Union[float, str]]
                      Step length of the angles (resolution) for the
                      components.
                      Value Suggestion: auto
                      Assertion: AngleStepComp >= 0

    optimization_comp : str
                        Kind of optimization for the components.
                        Value Suggestion: auto

    metric_comp : MaybeSequence[str]
                  Match metric used for the components.
                  Value Suggestion: use_polarity

    pregeneration_comp : MaybeSequence[str]
                         Complete pregeneration of the shape models for
                         the components if equal to 'true'.
                         Value Suggestion: false

    Returns
    -------

    component_model_id : HHandle
                         Handle of the component model.

    root_ranking : int
                   Ranking of the model components expressing the
                   suitability to act as the root component.

    Alternatives
    ------------
    create_trained_component_model

    Predecessors
    ------------
    draw_region, concat_obj

    Successors
    ----------
    find_component_model
    """
    with HalconOperator(1004) as proc:
        proc.set_input_object(1, model_image)
        proc.set_input_object(2, component_regions)
        proc.set_input_tuple(0, variation_row)
        proc.set_input_tuple(1, variation_column)
        proc.set_input_tuple(2, variation_angle)
        proc.set_input_tuple(3, angle_start)
        proc.set_input_tuple(4, angle_extent)
        proc.set_input_tuple(5, contrast_low_comp)
        proc.set_input_tuple(6, contrast_high_comp)
        proc.set_input_tuple(7, min_size_comp)
        proc.set_input_tuple(8, min_contrast_comp)
        proc.set_input_tuple(9, min_score_comp)
        proc.set_input_tuple(10, num_levels_comp)
        proc.set_input_tuple(11, angle_step_comp)
        proc.set_input_tuple(12, optimization_comp)
        proc.set_input_tuple(13, metric_comp)
        proc.set_input_tuple(14, pregeneration_comp)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # component_model_id
            proc.get_output_tuple_s(1)   # root_ranking
        )  # type: ignore


def create_condition(
    attrib_name: MaybeSequence[Union[int, float, str]],
    attrib_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a condition variable synchronization object.

    Parameters
    ----------

    attrib_name : MaybeSequence[Union[int, float, str]]
                  Mutex attribute.
                  Value Suggestion: []

    attrib_value : MaybeSequence[Union[int, float, str]]
                   Mutex attribute value.
                   Value Suggestion: []

    Returns
    -------

    condition_handle : HHandle
                       Condition synchronization object.

    See Also
    --------
    clear_condition

    Successors
    ----------
    wait_condition, timed_wait_condition, signal_condition
    """
    with HalconOperator(548) as proc:
        proc.set_input_tuple(0, attrib_name)
        proc.set_input_tuple(1, attrib_value)
        proc.init_oct(0)
        proc.execute()
        condition_handle = proc.get_output_tuple_s(0)
        return condition_handle  # type: ignore


def create_data_code_2d_model(
    symbol_type: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, str, float]]
) -> HHandle:
    """
    Create a model of a 2D data code class.

    Parameters
    ----------

    symbol_type : str
                  Type of the 2D data code.
                  Value Suggestion: 'Data Matrix ECC 200'

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters that can be adjusted
                     for the 2D data code model.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, str, float]]
                      Values of the generic parameters that can be
                      adjusted for the 2D data code model.
                      Value Suggestion: []

    Returns
    -------

    data_code_handle : HHandle
                       Handle for using and accessing the 2D data code
                       model.

    See Also
    --------
    clear_data_code_2d_model

    Alternatives
    ------------
    read_data_code_2d_model

    Successors
    ----------
    set_data_code_2d_param, find_data_code_2d
    """
    with HalconOperator(1778) as proc:
        proc.set_input_tuple(0, symbol_type)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        data_code_handle = proc.get_output_tuple_s(0)
        return data_code_handle  # type: ignore


def create_deep_ocr(
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a Deep OCR model.

    Parameters
    ----------

    gen_param_name : MaybeSequence[str]
                     Name of the generic parameter.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Value of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    deep_ocr_handle : HHandle
                      Handle of the Deep OCR model.

    Successors
    ----------
    write_deep_ocr, apply_deep_ocr, get_deep_ocr_param, set_deep_ocr_param
    """
    with HalconOperator(2207) as proc:
        proc.set_input_tuple(0, gen_param_name)
        proc.set_input_tuple(1, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        deep_ocr_handle = proc.get_output_tuple_s(0)
        return deep_ocr_handle  # type: ignore


def create_deformable_surface_model(
    object_model_3d: HHandle,
    rel_sampling_distance: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[str, float, int]]
) -> HHandle:
    """
    Create the data structure needed to perform deformable surface-based
    matching.

    Parameters
    ----------

    object_model_3d : HHandle
                      Handle of the 3D object model.

    rel_sampling_distance : float
                            Sampling distance relative to the object's
                            diameter
                            Value Suggestion: 0.05
                            Assertion: 0 < RelSamplingDistance < 1

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[str, float, int]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    deformable_surface_model : HHandle
                               Handle of the deformable surface model.

    See Also
    --------
    find_deformable_surface_model, refine_deformable_surface_model,
    read_deformable_surface_model, add_deformable_surface_model_sample,
    add_deformable_surface_model_reference_point,
    write_deformable_surface_model, clear_deformable_surface_model

    Alternatives
    ------------
    read_deformable_surface_model

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d,
    get_object_model_3d_params

    Successors
    ----------
    add_deformable_surface_model_sample,
    add_deformable_surface_model_reference_point,
    find_deformable_surface_model, refine_deformable_surface_model,
    get_deformable_surface_model_param, write_deformable_surface_model,
    clear_deformable_surface_model
    """
    with HalconOperator(1031) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, rel_sampling_distance)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        deformable_surface_model = proc.get_output_tuple_s(0)
        return deformable_surface_model  # type: ignore


def create_dict() -> HHandle:
    """
    Create a new empty dictionary.

    Returns
    -------

    dict_handle : HHandle
                  Handle of the newly created dictionary.

    See Also
    --------
    set_dict_tuple, get_dict_tuple, set_dict_object, get_dict_object,
    get_dict_param

    Successors
    ----------
    set_dict_tuple, set_dict_object
    """
    with HalconOperator(2149) as proc:
        proc.init_oct(0)
        proc.execute()
        dict_handle = proc.get_output_tuple_s(0)
        return dict_handle  # type: ignore


def create_distance_transform_xld(
    contour: HObject,
    mode: str,
    max_distance: Union[int, float]
) -> HHandle:
    """
    Create the XLD distance transform.

    Parameters
    ----------

    contour : HObject
              Reference contour(s).

    mode : str
           Compute the distance to points ('point_to_point') or entire
           segments ('point_to_segment').
           Value Suggestion: point_to_point

    max_distance : Union[int, float]
                   Maximum distance of interest.
                   Value Suggestion: 20.0

    Returns
    -------

    distance_transform_id : HHandle
                            Handle of the XLD distance transform.

    See Also
    --------
    distance_contours_xld, get_distance_transform_xld_contour,
    read_distance_transform_xld, deserialize_distance_transform_xld,
    get_distance_transform_xld_param, set_distance_transform_xld_param

    Successors
    ----------
    apply_distance_transform_xld, write_distance_transform_xld,
    serialize_distance_transform_xld, clear_distance_transform_xld
    """
    with HalconOperator(1360) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, max_distance)
        proc.init_oct(0)
        proc.execute()
        distance_transform_id = proc.get_output_tuple_s(0)
        return distance_transform_id  # type: ignore


def create_dl_layer_activation(
    dllayer_input: HHandle,
    layer_name: str,
    activation_type: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create an activation layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    activation_type : str
                      Activation type.
                      Value Suggestion: 'relu'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_activation : HHandle
                         Activation layer.
    """
    with HalconOperator(2221) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, activation_type)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_activation = proc.get_output_tuple_s(0)
        return dllayer_activation  # type: ignore


def create_dl_layer_batch_normalization(
    dllayer_input: HHandle,
    layer_name: str,
    momentum: Union[float, str],
    epsilon: float,
    activation: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a batch normalization layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    momentum : Union[float, str]
               Momentum.
               Value Suggestion: 'auto'

    epsilon : float
              Variance offset.
              Value Suggestion: 0.0001

    activation : str
                 Optional activation function.
                 Value Suggestion: 'none'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_batch_norm : HHandle
                         Batch normalization layer.

    Predecessors
    ------------
    create_dl_layer_convolution

    Successors
    ----------
    create_dl_layer_activation, create_dl_layer_convolution
    """
    with HalconOperator(2222) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, momentum)
        proc.set_input_tuple(3, epsilon)
        proc.set_input_tuple(4, activation)
        proc.set_input_tuple(5, gen_param_name)
        proc.set_input_tuple(6, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_batch_norm = proc.get_output_tuple_s(0)
        return dllayer_batch_norm  # type: ignore


def create_dl_layer_class_id_conversion(
    dllayer_input: HHandle,
    layer_name: str,
    conversion_mode: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a class ID conversion layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    conversion_mode : str
                      Direction of the class ID conversion.
                      Value Suggestion: 'from_class_id'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_class_id_conversion : HHandle
                                  Class IDs conversion layer.
    """
    with HalconOperator(2223) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, conversion_mode)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_class_id_conversion = proc.get_output_tuple_s(0)
        return dllayer_class_id_conversion  # type: ignore


def create_dl_layer_concat(
    dllayer_inputs: MaybeSequence[HHandle],
    layer_name: str,
    axis: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a concatenation layer.

    Parameters
    ----------

    dllayer_inputs : MaybeSequence[HHandle]
                     Feeding input layers.

    layer_name : str
                 Name of the output layer.

    axis : str
           Dimension along which the input layers are concatenated.
           Value Suggestion: depth

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_concat : HHandle
                     Concatenation layer.
    """
    with HalconOperator(2224) as proc:
        proc.set_input_tuple(0, dllayer_inputs)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, axis)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_concat = proc.get_output_tuple_s(0)
        return dllayer_concat  # type: ignore


def create_dl_layer_convolution(
    dllayer_input: HHandle,
    layer_name: str,
    kernel_size: MaybeSequence[int],
    dilation: MaybeSequence[int],
    stride: MaybeSequence[int],
    num_kernel: int,
    groups: int,
    padding: MaybeSequence[Union[str, int]],
    activation: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a convolutional layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    kernel_size : MaybeSequence[int]
                  Width and height of the filter kernels.
                  Value Suggestion: 3

    dilation : MaybeSequence[int]
               Amount of filter dilation for width and height.
               Value Suggestion: 1

    stride : MaybeSequence[int]
             Amount of filter shift in width and height direction.
             Value Suggestion: 1

    num_kernel : int
                 Number of filter kernels.
                 Value Suggestion: 64

    groups : int
             Number of filter groups.
             Value Suggestion: 1

    padding : MaybeSequence[Union[str, int]]
              Padding type or specific padding size.
              Value Suggestion: 'none'

    activation : str
                 Enable optional ReLU or sigmoid activations.
                 Value Suggestion: 'none'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_convolution : HHandle
                          Convolutional layer.
    """
    with HalconOperator(2225) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, kernel_size)
        proc.set_input_tuple(3, dilation)
        proc.set_input_tuple(4, stride)
        proc.set_input_tuple(5, num_kernel)
        proc.set_input_tuple(6, groups)
        proc.set_input_tuple(7, padding)
        proc.set_input_tuple(8, activation)
        proc.set_input_tuple(9, gen_param_name)
        proc.set_input_tuple(10, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_convolution = proc.get_output_tuple_s(0)
        return dllayer_convolution  # type: ignore


def create_dl_layer_dense(
    dllayer_input: HHandle,
    layer_name: str,
    num_out: int,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a dense layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    num_out : int
              Number of output neurons.
              Value Suggestion: 100

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_dense : HHandle
                    Dense layer.
    """
    with HalconOperator(2226) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, num_out)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_dense = proc.get_output_tuple_s(0)
        return dllayer_dense  # type: ignore


def create_dl_layer_depth_max(
    dllayer_input: HHandle,
    layer_name: str,
    depth_max_mode: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> Tuple[Sequence[HHandle], Sequence[HHandle]]:
    """
    Create a depth max layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    depth_max_mode : str
                     Mode to indicate type of return value.
                     Value Suggestion: 'argmax'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_depth_max_arg : Sequence[HHandle]
                            Optional, depth max layer with mode 'argmax'.

    dllayer_depth_max_value : Sequence[HHandle]
                              Optional, depth max layer with mode 'value'.
    """
    with HalconOperator(2227) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, depth_max_mode)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # dllayer_depth_max_arg
            proc.get_output_tuple_m(1)   # dllayer_depth_max_value
        )  # type: ignore


def create_dl_layer_depth_max_s(
    dllayer_input: HHandle,
    layer_name: str,
    depth_max_mode: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> Tuple[HHandle, HHandle]:
    """
    Create a depth max layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    depth_max_mode : str
                     Mode to indicate type of return value.
                     Value Suggestion: 'argmax'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_depth_max_arg : HHandle
                            Optional, depth max layer with mode 'argmax'.

    dllayer_depth_max_value : HHandle
                              Optional, depth max layer with mode 'value'.
    """
    with HalconOperator(2227) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, depth_max_mode)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # dllayer_depth_max_arg
            proc.get_output_tuple_s(1)   # dllayer_depth_max_value
        )  # type: ignore


def create_dl_layer_dropout(
    dllayer_input: HHandle,
    layer_name: str,
    probability: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a DropOut layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    probability : float
                  Probability.
                  Value Suggestion: 0.5

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_drop_out : HHandle
                       DropOut layer.
    """
    with HalconOperator(2228) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, probability)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_drop_out = proc.get_output_tuple_s(0)
        return dllayer_drop_out  # type: ignore


def create_dl_layer_elementwise(
    dllayer_inputs: MaybeSequence[HHandle],
    layer_name: str,
    operation: str,
    coefficients: MaybeSequence[float],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create an elementwise layer.

    Parameters
    ----------

    dllayer_inputs : MaybeSequence[HHandle]
                     Feeding input layers.

    layer_name : str
                 Name of the output layer.

    operation : str
                Element-wise operations.
                Value Suggestion: 'sum'

    coefficients : MaybeSequence[float]
                   Optional input tensor coefficients.
                   Value Suggestion: []

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_element_wise : HHandle
                           Elementwise layer.
    """
    with HalconOperator(2229) as proc:
        proc.set_input_tuple(0, dllayer_inputs)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, operation)
        proc.set_input_tuple(3, coefficients)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_element_wise = proc.get_output_tuple_s(0)
        return dllayer_element_wise  # type: ignore


def create_dl_layer_input(
    layer_name: str,
    shape: Sequence[int],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create an input layer.

    Parameters
    ----------

    layer_name : str
                 Name of the output layer.

    shape : Sequence[int]
            Dimensions of the input (width, height, depth).
            Value Suggestion: [224,224,3]

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_input : HHandle
                    Input layer.

    Successors
    ----------
    create_dl_layer_activation, create_dl_layer_batch_normalization,
    create_dl_layer_class_id_conversion,
    create_dl_layer_class_id_conversion, create_dl_layer_concat,
    create_dl_layer_convolution, create_dl_layer_dense,
    create_dl_layer_depth_max, create_dl_layer_dropout,
    create_dl_layer_elementwise, create_dl_layer_loss_cross_entropy,
    create_dl_layer_loss_ctc, create_dl_layer_loss_distance,
    create_dl_layer_loss_focal, create_dl_layer_loss_huber,
    create_dl_layer_lrn, create_dl_layer_pooling, create_dl_layer_reshape,
    create_dl_layer_softmax, create_dl_layer_transposed_convolution,
    create_dl_layer_zoom_factor, create_dl_layer_zoom_size,
    create_dl_layer_zoom_to_layer_size
    """
    with HalconOperator(2230) as proc:
        proc.set_input_tuple(0, layer_name)
        proc.set_input_tuple(1, shape)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_input = proc.get_output_tuple_s(0)
        return dllayer_input  # type: ignore


def create_dl_layer_loss_cross_entropy(
    dllayer_input: HHandle,
    dllayer_target: HHandle,
    dllayer_weights: HHandle,
    layer_name: str,
    loss_weight: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a cross entropy loss layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Input layer.

    dllayer_target : HHandle
                     Target layer.

    dllayer_weights : HHandle
                      Weights layer.

    layer_name : str
                 Name of the output layer.

    loss_weight : float
                  Overall loss weight if there are multiple losses in the
                  network.
                  Value Suggestion: 1.0

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_loss_cross_entropy : HHandle
                                 Cross entropy loss layer.
    """
    with HalconOperator(2231) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_target)
        proc.set_input_tuple(2, dllayer_weights)
        proc.set_input_tuple(3, layer_name)
        proc.set_input_tuple(4, loss_weight)
        proc.set_input_tuple(5, gen_param_name)
        proc.set_input_tuple(6, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_loss_cross_entropy = proc.get_output_tuple_s(0)
        return dllayer_loss_cross_entropy  # type: ignore


def create_dl_layer_loss_ctc(
    dllayer_input: HHandle,
    dllayer_input_lengths: HHandle,
    dllayer_target: HHandle,
    dllayer_target_lengths: HHandle,
    layer_name: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a CTC loss layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Input layer with network predictions.

    dllayer_input_lengths : HHandle
                            Input layer which specifies the input sequence
                            length of each item in the batch.

    dllayer_target : HHandle
                     Input layer which specifies the target sequences. If
                     the input dimensions of the CNN are changed the width
                     of this layer is automatically resized to the same
                     width as the DLLayerInput layer.

    dllayer_target_lengths : HHandle
                             Input layer which specifies the target
                             sequence length of each item in the batch.

    layer_name : str
                 Name of the output layer.

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_loss_ctc : HHandle
                       CTC loss layer.
    """
    with HalconOperator(2232) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_input_lengths)
        proc.set_input_tuple(2, dllayer_target)
        proc.set_input_tuple(3, dllayer_target_lengths)
        proc.set_input_tuple(4, layer_name)
        proc.set_input_tuple(5, gen_param_name)
        proc.set_input_tuple(6, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_loss_ctc = proc.get_output_tuple_s(0)
        return dllayer_loss_ctc  # type: ignore


def create_dl_layer_loss_distance(
    dllayer_input: HHandle,
    dllayer_target: HHandle,
    dllayer_weights: HHandle,
    layer_name: str,
    distance_type: str,
    loss_weight: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[str]
) -> HHandle:
    """
    Create a distance loss layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Input layer.

    dllayer_target : HHandle
                     Target layer.

    dllayer_weights : HHandle
                      Weights layer.

    layer_name : str
                 Name of the output layer.

    distance_type : str
                    Type of distance.
                    Value Suggestion: 'l2'

    loss_weight : float
                  Loss weigtht. Applies to all losses, if several losses
                  occur in the network.
                  Value Suggestion: 1.0

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[str]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_loss_distance : HHandle
                            Distance loss layer.
    """
    with HalconOperator(2233) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_target)
        proc.set_input_tuple(2, dllayer_weights)
        proc.set_input_tuple(3, layer_name)
        proc.set_input_tuple(4, distance_type)
        proc.set_input_tuple(5, loss_weight)
        proc.set_input_tuple(6, gen_param_name)
        proc.set_input_tuple(7, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_loss_distance = proc.get_output_tuple_s(0)
        return dllayer_loss_distance  # type: ignore


def create_dl_layer_loss_focal(
    dllayer_input: HHandle,
    dllayer_target: HHandle,
    dllayer_weights: HHandle,
    dllayer_normalization: HHandle,
    layer_name: str,
    loss_weight: Union[int, float],
    gamma: Union[int, float],
    class_weights: MaybeSequence[Union[int, float]],
    type: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[str]
) -> HHandle:
    """
    Create a focal loss layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Input layer.

    dllayer_target : HHandle
                     Target layer.

    dllayer_weights : HHandle
                      Weights layer.

    dllayer_normalization : HHandle
                            Normalization layer.
                            Value Suggestion: []

    layer_name : str
                 Name of the output layer.

    loss_weight : Union[int, float]
                  Overall loss weight if there are multiple losses in the
                  network.
                  Value Suggestion: 1.0

    gamma : Union[int, float]
            Exponent of the focal factor.
            Value Suggestion: 2.0

    class_weights : MaybeSequence[Union[int, float]]
                    Class specific weight.
                    Value Suggestion: []

    type : str
           Focal loss type.
           Value Suggestion: focal_binary

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[str]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_loss_focal : HHandle
                         Focal loss layer.
    """
    with HalconOperator(2234) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_target)
        proc.set_input_tuple(2, dllayer_weights)
        proc.set_input_tuple(3, dllayer_normalization)
        proc.set_input_tuple(4, layer_name)
        proc.set_input_tuple(5, loss_weight)
        proc.set_input_tuple(6, gamma)
        proc.set_input_tuple(7, class_weights)
        proc.set_input_tuple(8, type)
        proc.set_input_tuple(9, gen_param_name)
        proc.set_input_tuple(10, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_loss_focal = proc.get_output_tuple_s(0)
        return dllayer_loss_focal  # type: ignore


def create_dl_layer_loss_huber(
    dllayer_input: HHandle,
    dllayer_target: HHandle,
    dllayer_weights: HHandle,
    dllayer_normalization: HHandle,
    layer_name: str,
    loss_weight: float,
    beta: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a Huber loss layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Input layer.

    dllayer_target : HHandle
                     Target layer.

    dllayer_weights : HHandle
                      Weights layer.

    dllayer_normalization : HHandle
                            Normalization layer.
                            Value Suggestion: []

    layer_name : str
                 Name of the output layer.

    loss_weight : float
                  Scalar weight factor.
                  Value Suggestion: 1.0

    beta : float
           Beta value in the loss-defining formula.
           Value Suggestion: 1.1
           Assertion: Beta >= 0

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_loss_huber : HHandle
                         Huber loss layer.
    """
    with HalconOperator(2235) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_target)
        proc.set_input_tuple(2, dllayer_weights)
        proc.set_input_tuple(3, dllayer_normalization)
        proc.set_input_tuple(4, layer_name)
        proc.set_input_tuple(5, loss_weight)
        proc.set_input_tuple(6, beta)
        proc.set_input_tuple(7, gen_param_name)
        proc.set_input_tuple(8, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_loss_huber = proc.get_output_tuple_s(0)
        return dllayer_loss_huber  # type: ignore


def create_dl_layer_lrn(
    dllayer_input: HHandle,
    layer_name: str,
    local_size: int,
    alpha: float,
    beta: float,
    k: float,
    norm_region: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a LRN layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    local_size : int
                 Size of the local window.
                 Value Suggestion: 5

    alpha : float
            Scaling factor in the LRN formula.
            Value Suggestion: 0.0001

    beta : float
           Exponent in the LRN formula.
           Value Suggestion: 0.75

    k : float
        Constant summand in the LRN formula.
        Value Suggestion: 1.0

    norm_region : str
                  Normalization dimension.
                  Value Suggestion: 'across_channels'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_lrn : HHandle
                  LRN layer.
    """
    with HalconOperator(2236) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, local_size)
        proc.set_input_tuple(3, alpha)
        proc.set_input_tuple(4, beta)
        proc.set_input_tuple(5, k)
        proc.set_input_tuple(6, norm_region)
        proc.set_input_tuple(7, gen_param_name)
        proc.set_input_tuple(8, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_lrn = proc.get_output_tuple_s(0)
        return dllayer_lrn  # type: ignore


def create_dl_layer_permutation(
    dllayer_input: HHandle,
    layer_name: str,
    permutation: Sequence[int],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a permutation layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    permutation : Sequence[int]
                  Order of the permuted axes.
                  Value Suggestion: [0,1,2,3]

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_permutation : HHandle
                          Permutation layer.

    See Also
    --------
    create_dl_layer_reshape

    Predecessors
    ------------
    create_dl_layer_input, create_dl_layer_concat, create_dl_layer_reshape

    Successors
    ----------
    create_dl_layer_convolution, create_dl_layer_dense,
    create_dl_layer_reshape
    """
    with HalconOperator(2273) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, permutation)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_permutation = proc.get_output_tuple_s(0)
        return dllayer_permutation  # type: ignore


def create_dl_layer_pooling(
    dllayer_input: HHandle,
    layer_name: str,
    kernel_size: Sequence[int],
    stride: Sequence[int],
    padding: MaybeSequence[Union[str, int]],
    mode: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a pooling layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    kernel_size : Sequence[int]
                  Width and height of the filter kernels.
                  Value Suggestion: [2,2]

    stride : Sequence[int]
             Bi-dimensional amount of filter shift.
             Value Suggestion: [2,2]

    padding : MaybeSequence[Union[str, int]]
              Padding type or specific padding size.
              Value Suggestion: 'none'

    mode : str
           Mode of pooling operation.
           Value Suggestion: 'maximum'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_pooling : HHandle
                      Pooling layer.
    """
    with HalconOperator(2237) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, kernel_size)
        proc.set_input_tuple(3, stride)
        proc.set_input_tuple(4, padding)
        proc.set_input_tuple(5, mode)
        proc.set_input_tuple(6, gen_param_name)
        proc.set_input_tuple(7, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_pooling = proc.get_output_tuple_s(0)
        return dllayer_pooling  # type: ignore


def create_dl_layer_reshape(
    dllayer_input: HHandle,
    layer_name: str,
    shape: Sequence[int],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a reshape layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    shape : Sequence[int]
            Shape of the output graph layer data.
            Value Suggestion: [224,224,3]

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_reshape : HHandle
                      Reshape layer.

    Predecessors
    ------------
    create_dl_layer_input, create_dl_layer_concat

    Successors
    ----------
    create_dl_layer_convolution, create_dl_layer_dense
    """
    with HalconOperator(2238) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, shape)
        proc.set_input_tuple(3, gen_param_name)
        proc.set_input_tuple(4, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_reshape = proc.get_output_tuple_s(0)
        return dllayer_reshape  # type: ignore


def create_dl_layer_softmax(
    dllayer_input: HHandle,
    layer_name: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a softmax layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_soft_max : HHandle
                       Softmax layer.
    """
    with HalconOperator(2239) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_soft_max = proc.get_output_tuple_s(0)
        return dllayer_soft_max  # type: ignore


def create_dl_layer_transposed_convolution(
    dllayer_input: HHandle,
    layer_name: str,
    kernel_size: int,
    stride: int,
    kernel_depth: int,
    groups: int,
    padding: MaybeSequence[Union[str, int]],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a transposed convolution layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    kernel_size : int
                  Width and height of the filter kernels.
                  Value Suggestion: 3

    stride : int
             Amount of filter shift.
             Value Suggestion: 1

    kernel_depth : int
                   Depth of filter kernels.
                   Value Suggestion: 64

    groups : int
             Number of filter groups.
             Value Suggestion: 1

    padding : MaybeSequence[Union[str, int]]
              Type of the padding.
              Value Suggestion: 'none'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_transposed_convolution : HHandle
                                     Transposed convolutional layer.

    Notes
    -----
    This layer cannot be run by setting 'runtime' to 'cpu' for training.
    It is only applicable for training with a GPU by setting 'runtime' to
    'gpu'.
    """
    with HalconOperator(2240) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, kernel_size)
        proc.set_input_tuple(3, stride)
        proc.set_input_tuple(4, kernel_depth)
        proc.set_input_tuple(5, groups)
        proc.set_input_tuple(6, padding)
        proc.set_input_tuple(7, gen_param_name)
        proc.set_input_tuple(8, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_transposed_convolution = proc.get_output_tuple_s(0)
        return dllayer_transposed_convolution  # type: ignore


def create_dl_layer_zoom_factor(
    dllayer_input: HHandle,
    layer_name: str,
    scale_width: Union[int, float],
    scale_height: Union[int, float],
    interpolation: str,
    align_corners: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a zoom layer using size factors.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    scale_width : Union[int, float]
                  Ratio output/input width of the layer.
                  Value Suggestion: 2.0

    scale_height : Union[int, float]
                   Ratio output/input height of the layer.
                   Value Suggestion: 2.0

    interpolation : str
                    Mode of interpolation.
                    Value Suggestion: 'bilinear'

    align_corners : str
                    Type of coordinate transformation between output/input
                    images.
                    Value Suggestion: 'false'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_zoom : HHandle
                   Zoom layer.

    Alternatives
    ------------
    create_dl_layer_zoom_size, create_dl_layer_zoom_to_layer_size
    """
    with HalconOperator(2241) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, scale_width)
        proc.set_input_tuple(3, scale_height)
        proc.set_input_tuple(4, interpolation)
        proc.set_input_tuple(5, align_corners)
        proc.set_input_tuple(6, gen_param_name)
        proc.set_input_tuple(7, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_zoom = proc.get_output_tuple_s(0)
        return dllayer_zoom  # type: ignore


def create_dl_layer_zoom_size(
    dllayer_input: HHandle,
    layer_name: str,
    width: int,
    height: int,
    interpolation: str,
    align_corners: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a zoom layer using an absolute output size.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    layer_name : str
                 Name of the output layer.

    width : int
            Absolute width of the output layer.
            Value Suggestion: 100

    height : int
             Absolute height of the output layer.
             Value Suggestion: 100

    interpolation : str
                    Mode of interpolation.
                    Value Suggestion: 'bilinear'

    align_corners : str
                    Type of coordinate transformation between output/input
                    images.
                    Value Suggestion: 'false'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_zoom : HHandle
                   Zoom layer.

    Alternatives
    ------------
    create_dl_layer_zoom_factor, create_dl_layer_zoom_to_layer_size
    """
    with HalconOperator(2242) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, layer_name)
        proc.set_input_tuple(2, width)
        proc.set_input_tuple(3, height)
        proc.set_input_tuple(4, interpolation)
        proc.set_input_tuple(5, align_corners)
        proc.set_input_tuple(6, gen_param_name)
        proc.set_input_tuple(7, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_zoom = proc.get_output_tuple_s(0)
        return dllayer_zoom  # type: ignore


def create_dl_layer_zoom_to_layer_size(
    dllayer_input: HHandle,
    dllayer_reference: HHandle,
    layer_name: str,
    interpolation: str,
    align_corners: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a zoom layer using the output size of a reference layer.

    Parameters
    ----------

    dllayer_input : HHandle
                    Feeding layer.

    dllayer_reference : HHandle
                        Reference layer to define the output size.

    layer_name : str
                 Name of the output layer.

    interpolation : str
                    Mode of interpolation.
                    Value Suggestion: 'bilinear'

    align_corners : str
                    Type of coordinate transformation between output/input
                    images.
                    Value Suggestion: 'false'

    gen_param_name : MaybeSequence[str]
                     Generic input parameter names.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Generic input parameter values.
                      Value Suggestion: []

    Returns
    -------

    dllayer_zoom : HHandle
                   Zoom layer.

    Alternatives
    ------------
    create_dl_layer_zoom_size, create_dl_layer_zoom_factor
    """
    with HalconOperator(2243) as proc:
        proc.set_input_tuple(0, dllayer_input)
        proc.set_input_tuple(1, dllayer_reference)
        proc.set_input_tuple(2, layer_name)
        proc.set_input_tuple(3, interpolation)
        proc.set_input_tuple(4, align_corners)
        proc.set_input_tuple(5, gen_param_name)
        proc.set_input_tuple(6, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        dllayer_zoom = proc.get_output_tuple_s(0)
        return dllayer_zoom  # type: ignore


def create_dl_model(output_layers: MaybeSequence[HHandle]) -> HHandle:
    """
    Create a deep learning model.

    Parameters
    ----------

    output_layers : MaybeSequence[HHandle]
                    Output layers of the graph.

    Returns
    -------

    dlmodel_handle : HHandle
                     Handle of the deep learning model.

    Predecessors
    ------------
    create_dl_layer_softmax, create_dl_layer_loss_cross_entropy,
    create_dl_layer_loss_focal, create_dl_layer_loss_huber

    Successors
    ----------
    set_dl_model_param
    """
    with HalconOperator(2244) as proc:
        proc.set_input_tuple(0, output_layers)
        proc.init_oct(0)
        proc.execute()
        dlmodel_handle = proc.get_output_tuple_s(0)
        return dlmodel_handle  # type: ignore


def create_dl_model_detection(
    backbone: str,
    num_classes: int,
    dlmodel_detection_param: HHandle
) -> HHandle:
    """
    Create a deep learning network for object detection or instance
    segmentation.

    Parameters
    ----------

    backbone : str
               Deep learning classifier, used as backbone network.
               Value Suggestion: pretrained_dl_classifier_compact.hdl

    num_classes : int
                  Number of classes.
                  Value Suggestion: 3

    dlmodel_detection_param : HHandle
                              Parameters for the object detection model.
                              Value Suggestion: []

    Returns
    -------

    dlmodel_handle : HHandle
                     Deep learning model for object detection.

    Alternatives
    ------------
    read_dl_model

    Successors
    ----------
    set_dl_model_param, get_dl_model_param, apply_dl_model,
    train_dl_model_batch

    Notes
    -----
    To successfully set 'gpu' parameters, cuDNN and cuBLAS are required,
    i.e., to set the parameter GenParamName 'runtime' to 'gpu'. For
    further details, please refer to the ``Installation Guide'', paragraph
    ``Requirements for Deep Learning and Deep-Learning-Based Methods''.
    """
    with HalconOperator(2150) as proc:
        proc.set_input_tuple(0, backbone)
        proc.set_input_tuple(1, num_classes)
        proc.set_input_tuple(2, dlmodel_detection_param)
        proc.init_oct(0)
        proc.execute()
        dlmodel_handle = proc.get_output_tuple_s(0)
        return dlmodel_handle  # type: ignore


def create_dl_pruning(
    dlmodel_handle: HHandle,
    mode: str,
    gen_param: HHandle
) -> HHandle:
    """
    Create a pruning data handle.

    Parameters
    ----------

    dlmodel_handle : HHandle
                     Handle of a deep learning model.

    mode : str
           Pruning method.
           Value Suggestion: oracle

    gen_param : HHandle
                Dictionary with generic parameters.
                Value Suggestion: []

    Returns
    -------

    dlpruning_handle : HHandle
                       Pruning data handle.

    Predecessors
    ------------
    read_dl_model

    Successors
    ----------
    get_dl_pruning_param, set_dl_model_param
    """
    with HalconOperator(2208) as proc:
        proc.set_input_tuple(0, dlmodel_handle)
        proc.set_input_tuple(1, mode)
        proc.set_input_tuple(2, gen_param)
        proc.init_oct(0)
        proc.execute()
        dlpruning_handle = proc.get_output_tuple_s(0)
        return dlpruning_handle  # type: ignore


def create_drawing_object_circle(
    row: float,
    column: float,
    radius: float
) -> HHandle:
    """
    Create a circle which can be modified interactively.

    Parameters
    ----------

    row : float
          Row coordinate of the center.
          Value Suggestion: 100

    column : float
             Column coordinate of the center.
             Value Suggestion: 100

    radius : float
             Radius of the circle.
             Value Suggestion: 80

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_xld

    Alternatives
    ------------
    draw_circle, draw_region, create_drawing_object_circle_sector,
    create_drawing_object_ellipse, create_drawing_object_ellipse_sector

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    get_drawing_object_iconic
    """
    with HalconOperator(1311) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, radius)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_circle_sector(
    row: float,
    column: float,
    radius: float,
    start_angle: float,
    end_angle: float
) -> HHandle:
    """
    Create a circle sector which can be modified interactively.

    Parameters
    ----------

    row : float
          Row coordinate of the center.
          Value Suggestion: 100

    column : float
             Column coordinate of the center.
             Value Suggestion: 100

    radius : float
             Radius of the circle.
             Value Suggestion: 80

    start_angle : float
                  Start angle of the arc.
                  Value Suggestion: 0

    end_angle : float
                End angle of the arc.
                Value Suggestion: 3.14159

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle,
    create_drawing_object_ellipse_sector, create_drawing_object_xld,
    create_drawing_object_line

    Alternatives
    ------------
    draw_rectangle1_mod, draw_rectangle2, draw_region,
    create_drawing_object_circle, create_drawing_object_ellipse_sector

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    get_drawing_object_iconic
    """
    with HalconOperator(1308) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, radius)
        proc.set_input_tuple(3, start_angle)
        proc.set_input_tuple(4, end_angle)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_ellipse(
    row: float,
    column: float,
    phi: float,
    radius_1: float,
    radius_2: float
) -> HHandle:
    """
    Create an ellipse which can be modified interactively.

    Parameters
    ----------

    row : float
          Row index of the center.
          Value Suggestion: 200

    column : float
             Column index of the center.
             Value Suggestion: 200

    phi : float
          Orientation of the first half axis in radians.
          Value Suggestion: 0

    radius_1 : float
               First half axis.
               Value Suggestion: 100

    radius_2 : float
               Second half axis.
               Value Suggestion: 60

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    gen_ellipse, draw_circle, draw_rectangle2, set_insert

    Alternatives
    ------------
    draw_ellipse_mod, draw_ellipse, draw_region

    Predecessors
    ------------
    open_window

    Successors
    ----------
    disp_region, set_colored, set_line_width, set_draw, set_insert,
    attach_drawing_object_to_window
    """
    with HalconOperator(1312) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, phi)
        proc.set_input_tuple(3, radius_1)
        proc.set_input_tuple(4, radius_2)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_ellipse_sector(
    row: float,
    column: float,
    phi: float,
    radius_1: float,
    radius_2: float,
    start_angle: float,
    end_angle: float
) -> HHandle:
    """
    Create an elliptic sector which can be modified interactively.

    Parameters
    ----------

    row : float
          Row index of the center.
          Value Suggestion: 200

    column : float
             Column index of the center.
             Value Suggestion: 200

    phi : float
          Orientation of the first half axis in radians.
          Value Suggestion: 0

    radius_1 : float
               First half axis.
               Value Suggestion: 100

    radius_2 : float
               Second half axis.
               Value Suggestion: 60

    start_angle : float
                  Start angle of the arc.
                  Value Suggestion: 0

    end_angle : float
                End angle of the arc.
                Value Suggestion: 3.14159

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    gen_ellipse_contour_xld, create_drawing_object_rectangle1,
    create_drawing_object_rectangle2, create_drawing_object_ellipse,
    create_drawing_object_xld, create_drawing_object_line,
    create_drawing_object_circle

    Alternatives
    ------------
    draw_ellipse_mod, draw_ellipse, draw_region,
    create_drawing_object_ellipse

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    get_drawing_object_iconic
    """
    with HalconOperator(1309) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, phi)
        proc.set_input_tuple(3, radius_1)
        proc.set_input_tuple(4, radius_2)
        proc.set_input_tuple(5, start_angle)
        proc.set_input_tuple(6, end_angle)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_line(
    row_1: float,
    column_1: float,
    row_2: float,
    column_2: float
) -> HHandle:
    """
    Create a line which can be modified interactively.

    Parameters
    ----------

    row_1 : float
            Row coordinate of the first line point.
            Value Suggestion: 100

    column_1 : float
               Column coordinate of the first line point.
               Value Suggestion: 100

    row_2 : float
            Row coordinate of the second line point.
            Value Suggestion: 200

    column_2 : float
               Column coordinate of the second line point.
               Value Suggestion: 200

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_xld

    Alternatives
    ------------
    draw_line, draw_line_mod, create_drawing_object_xld

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    get_drawing_object_iconic
    """
    with HalconOperator(1310) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_rectangle1(
    row_1: float,
    column_1: float,
    row_2: float,
    column_2: float
) -> HHandle:
    """
    Create a rectangle parallel to the coordinate axis which can be
    modified interactively.

    Parameters
    ----------

    row_1 : float
            Row coordinate of the upper left corner.
            Value Suggestion: 100

    column_1 : float
               Column coordinate of the upper left corner.
               Value Suggestion: 100

    row_2 : float
            Row coordinate of the lower right corner.
            Value Suggestion: 200

    column_2 : float
               Column coordinate of the lower right corner.
               Value Suggestion: 200

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    gen_rectangle1, draw_circle, draw_ellipse, set_insert

    Alternatives
    ------------
    draw_rectangle1_mod, draw_rectangle2, draw_region

    Predecessors
    ------------
    open_window

    Successors
    ----------
    disp_region, set_colored, set_line_width, set_draw, set_insert,
    attach_drawing_object_to_window
    """
    with HalconOperator(1314) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_rectangle2(
    row: float,
    column: float,
    phi: float,
    length_1: float,
    length_2: float
) -> HHandle:
    """
    Create a rectangle of any orientation which can be modified
    interactively.

    Parameters
    ----------

    row : float
          Row coordinate of the center.
          Value Suggestion: 150

    column : float
             Column coordinate of the center.
             Value Suggestion: 150

    phi : float
          Orientation of the first half axis in radians.
          Value Suggestion: 0

    length_1 : float
               First half axis.
               Value Suggestion: 100

    length_2 : float
               Second half axis.
               Value Suggestion: 100

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    gen_rectangle2, draw_circle, draw_ellipse, set_insert

    Alternatives
    ------------
    draw_rectangle2_mod, draw_rectangle2, draw_region

    Predecessors
    ------------
    open_window

    Successors
    ----------
    disp_region, set_colored, set_line_width, set_draw, set_insert,
    attach_drawing_object_to_window
    """
    with HalconOperator(1313) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, phi)
        proc.set_input_tuple(3, length_1)
        proc.set_input_tuple(4, length_2)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_text(
    row: int,
    column: int,
    string: str
) -> HHandle:
    """
    Create a text object which can be moved interactively.

    Parameters
    ----------

    row : int
          Row coordinate of the text position.
          Value Suggestion: 12

    column : int
             Column coordinate of the text position.
             Value Suggestion: 12

    string : str
             Character string to be displayed.
             Value Suggestion: Text

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    write_string, attach_drawing_object_to_window

    Alternatives
    ------------
    write_string

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    set_drawing_object_params
    """
    with HalconOperator(1301) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, string)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_drawing_object_xld(
    row: Sequence[Union[float, int]],
    column: Sequence[Union[float, int]]
) -> HHandle:
    """
    Create a XLD contour which can be modified interactively.

    Parameters
    ----------

    row : Sequence[Union[float, int]]
          Row coordinates of the polygon.
          Value Suggestion: [100,200,200,100]

    column : Sequence[Union[float, int]]
             Column coordinates of the polygon.
             Value Suggestion: [100,100,200,200]

    Returns
    -------

    draw_id : HHandle
              Handle of the drawing object.

    See Also
    --------
    create_drawing_object_rectangle1, create_drawing_object_rectangle2,
    create_drawing_object_ellipse, create_drawing_object_circle_sector,
    create_drawing_object_ellipse_sector, create_drawing_object_line,
    create_drawing_object_circle

    Alternatives
    ------------
    draw_xld, draw_xld_mod, draw_region

    Predecessors
    ------------
    open_window

    Successors
    ----------
    attach_drawing_object_to_window, get_drawing_object_params,
    get_drawing_object_iconic, set_drawing_object_xld
    """
    with HalconOperator(1307) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.execute()
        draw_id = proc.get_output_tuple_s(0)
        return draw_id  # type: ignore


def create_event(
    attrib_name: MaybeSequence[Union[int, float, str]],
    attrib_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create an event synchronization object.

    Parameters
    ----------

    attrib_name : MaybeSequence[Union[int, float, str]]
                  Mutex attribute.
                  Value Suggestion: []

    attrib_value : MaybeSequence[Union[int, float, str]]
                   Mutex attribute value.
                   Value Suggestion: []

    Returns
    -------

    event_handle : HHandle
                   Event synchronization object.

    See Also
    --------
    clear_event

    Successors
    ----------
    wait_event, signal_event, clear_event
    """
    with HalconOperator(558) as proc:
        proc.set_input_tuple(0, attrib_name)
        proc.set_input_tuple(1, attrib_value)
        proc.init_oct(0)
        proc.execute()
        event_handle = proc.get_output_tuple_s(0)
        return event_handle  # type: ignore


def create_funct_1d_array(
    yvalues: MaybeSequence[Union[float, int]]
) -> Sequence[Union[float, int]]:
    """
    Create a function from a sequence of y values.

    Parameters
    ----------

    yvalues : MaybeSequence[Union[float, int]]
              X value for function points.

    Returns
    -------

    function : Sequence[Union[float, int]]
               Created function.

    See Also
    --------
    funct_1d_to_pairs

    Alternatives
    ------------
    create_funct_1d_pairs, read_funct_1d

    Successors
    ----------
    write_funct_1d, y_range_funct_1d, get_pair_funct_1d, transform_funct_1d
    """
    with HalconOperator(1399) as proc:
        proc.set_input_tuple(0, yvalues)
        proc.init_oct(0)
        proc.execute()
        function = proc.get_output_tuple_m(0)
        return function  # type: ignore


def create_funct_1d_pairs(
    xvalues: MaybeSequence[Union[float, int]],
    yvalues: MaybeSequence[Union[float, int]]
) -> Sequence[Union[float, int]]:
    """
    Create a function from a set of (x,y) pairs.

    Parameters
    ----------

    xvalues : MaybeSequence[Union[float, int]]
              X value for function points.

    yvalues : MaybeSequence[Union[float, int]]
              Y value for function points.

    Returns
    -------

    function : Sequence[Union[float, int]]
               Created function.

    See Also
    --------
    funct_1d_to_pairs

    Alternatives
    ------------
    create_funct_1d_array, read_funct_1d

    Successors
    ----------
    write_funct_1d, y_range_funct_1d, get_pair_funct_1d

    Notes
    -----
    create_funct_1d_pairs examines whether the x values of type 'double'
    are ascending. Some other operators apply the same check but use the
    type 'float' instead of 'double'. If such an operator is called as
    successor, it might happen that two consecutive x values seem to be
    equal for the 'float' variant, although they were ascending in the
    'double' variant. If this happens, an error is thrown.
    """
    with HalconOperator(1400) as proc:
        proc.set_input_tuple(0, xvalues)
        proc.set_input_tuple(1, yvalues)
        proc.init_oct(0)
        proc.execute()
        function = proc.get_output_tuple_m(0)
        return function  # type: ignore


def create_generic_shape_model() -> HHandle:
    """
    Create a shape model.

    Returns
    -------

    model_id : HHandle
               Handle of the shape model.

    Successors
    ----------
    set_generic_shape_model_param, train_generic_shape_model,
    write_shape_model, set_shape_model_origin
    """
    with HalconOperator(2245) as proc:
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_lexicon(name: str, words: Sequence[str]) -> HHandle:
    """
    Create a lexicon from a tuple of words.

    Parameters
    ----------

    name : str
           Unique name for the new lexicon.
           Value Suggestion: 'lex1'

    words : Sequence[str]
            Word list for the new lexicon.
            Value Suggestion: ['word1','word2','word3']

    Returns
    -------

    lexicon_handle : HHandle
                     Handle of the lexicon.

    See Also
    --------
    lookup_lexicon, suggest_lexicon

    Alternatives
    ------------
    import_lexicon

    Successors
    ----------
    do_ocr_word_mlp, do_ocr_word_svm
    """
    with HalconOperator(671) as proc:
        proc.set_input_tuple(0, name)
        proc.set_input_tuple(1, words)
        proc.init_oct(0)
        proc.execute()
        lexicon_handle = proc.get_output_tuple_s(0)
        return lexicon_handle  # type: ignore


def create_local_deformable_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: Sequence[Union[int, str]],
    min_contrast: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Creates a deformable model for local, deformable matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep >= 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: none

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : Sequence[Union[int, str]]
               Thresholds or hysteresis thresholds for the contrast of the
               object in the template image.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    gen_param_name : Sequence[str]
                     The generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_planar_uncalib_deformable_model,
    create_planar_calib_deformable_model

    Alternatives
    ------------
    read_deformable_model

    Predecessors
    ------------
    determine_deformable_model_params

    Successors
    ----------
    set_deformable_model_origin, set_deformable_model_param,
    get_deformable_model_contours, find_local_deformable_model,
    get_deformable_model_params, write_deformable_model,
    clear_deformable_model
    """
    with HalconOperator(978) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, contrast)
        proc.set_input_tuple(13, min_contrast)
        proc.set_input_tuple(14, gen_param_name)
        proc.set_input_tuple(15, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_local_deformable_model_xld(
    contours: HObject,
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Prepare a deformable model for local deformable matching from XLD
    contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep > 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep > 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    gen_param_name : Sequence[str]
                     The generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_local_deformable_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_local_deformable_model

    Notes
    -----
    Note that, in contrast to the operator create_local_deformable_model,
    it is not possible to specify a minimum size of the model components.
    To avoid small model components in the model, short contours can be
    eliminated with the operator select_contours_xld before calling
    create_local_deformable_model_xld.
    """
    with HalconOperator(975) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, min_contrast)
        proc.set_input_tuple(13, gen_param_name)
        proc.set_input_tuple(14, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_matrix(
    rows: int,
    columns: int,
    value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a matrix.

    Parameters
    ----------

    rows : int
           Number of rows of the matrix.
           Value Suggestion: 3
           Assertion: Rows >= 1

    columns : int
              Number of columns of the matrix.
              Value Suggestion: 3
              Assertion: Columns >= 1

    value : MaybeSequence[Union[int, float, str]]
            Values for initializing the elements of the matrix.
            Value Suggestion: 0

    Returns
    -------

    matrix_id : HHandle
                Matrix handle.

    Successors
    ----------
    set_full_matrix, clear_matrix
    """
    with HalconOperator(897) as proc:
        proc.set_input_tuple(0, rows)
        proc.set_input_tuple(1, columns)
        proc.set_input_tuple(2, value)
        proc.init_oct(0)
        proc.execute()
        matrix_id = proc.get_output_tuple_s(0)
        return matrix_id  # type: ignore


def create_message() -> HHandle:
    """
    Create a new empty message.

    Returns
    -------

    message_handle : HHandle
                     Handle of the newly created message.
                     Assertion: MessageHandle != 0

    See Also
    --------
    clear_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj, set_message_param, get_message_param,
    enqueue_message, dequeue_message

    Alternatives
    ------------
    create_dict

    Successors
    ----------
    set_message_tuple, set_message_obj
    """
    with HalconOperator(541) as proc:
        proc.init_oct(0)
        proc.execute()
        message_handle = proc.get_output_tuple_s(0)
        return message_handle  # type: ignore


def create_message_queue() -> HHandle:
    """
    Create a new empty message queue.

    Returns
    -------

    queue_handle : HHandle
                   Handle of the newly created message queue.
                   Assertion: QueueHandle != 0

    See Also
    --------
    clear_message_queue, enqueue_message, dequeue_message,
    set_message_queue_param, get_message_queue_param, create_message,
    clear_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj

    Successors
    ----------
    enqueue_message, dequeue_message
    """
    with HalconOperator(533) as proc:
        proc.init_oct(0)
        proc.execute()
        queue_handle = proc.get_output_tuple_s(0)
        return queue_handle  # type: ignore


def create_metrology_model() -> HHandle:
    """
    Create the data structure that is needed to measure geometric shapes.

    Returns
    -------

    metrology_handle : HHandle
                       Handle of the metrology model.

    Successors
    ----------
    set_metrology_model_image_size

    Notes
    -----
    Note, that after calling the operator create_metrology_model the
    operator set_metrology_model_image_size should be called for
    efficiency reasons.
    """
    with HalconOperator(820) as proc:
        proc.init_oct(0)
        proc.execute()
        metrology_handle = proc.get_output_tuple_s(0)
        return metrology_handle  # type: ignore


def create_mutex(
    attrib_name: MaybeSequence[Union[int, float, str]],
    attrib_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a mutual exclusion synchronization object.

    Parameters
    ----------

    attrib_name : MaybeSequence[Union[int, float, str]]
                  Mutex attribute class.
                  Value Suggestion: []

    attrib_value : MaybeSequence[Union[int, float, str]]
                   Mutex attribute kind.
                   Value Suggestion: []

    Returns
    -------

    mutex_handle : HHandle
                   Mutex synchronization object.

    See Also
    --------
    clear_mutex

    Successors
    ----------
    lock_mutex, clear_mutex
    """
    with HalconOperator(564) as proc:
        proc.set_input_tuple(0, attrib_name)
        proc.set_input_tuple(1, attrib_value)
        proc.init_oct(0)
        proc.execute()
        mutex_handle = proc.get_output_tuple_s(0)
        return mutex_handle  # type: ignore


def create_ncc_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    metric: str
) -> HHandle:
    """
    Prepare an NCC model for matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 16

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    find_ncc_model, get_ncc_model_params, clear_ncc_model,
    write_ncc_model, set_ncc_model_origin, set_ncc_model_param,
    find_ncc_models
    """
    with HalconOperator(993) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, metric)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_ocr_class_box(
    width_pattern: int,
    height_pattern: int,
    interpolation: int,
    features: MaybeSequence[str],
    character: Sequence[str]
) -> HHandle:
    """
    Create a new OCR-classifier.

    Parameters
    ----------

    width_pattern : int
                    Width of the input layer of the network.
                    Value Suggestion: 8

    height_pattern : int
                     Height of the input layer of the network.
                     Value Suggestion: 10

    interpolation : int
                    Interpolation mode concerning scaling of characters.
                    Value Suggestion: 1

    features : MaybeSequence[str]
               Additional features.
               Value Suggestion: default

    character : Sequence[str]
                All characters of a set.
                Value Suggestion: ['a','b','c']

    Returns
    -------

    ocr_handle : HHandle
                 ID of the created OCR classifier.

    See Also
    --------
    affine_trans_image, ocr_change_char, moments_region_2nd_invar,
    moments_region_2nd_rel_invar, moments_region_3rd_invar,
    moments_region_central

    Alternatives
    ------------
    create_ocr_class_mlp, create_ocr_class_svm

    Predecessors
    ------------
    reset_obj_db

    Successors
    ----------
    traind_ocr_class_box, trainf_ocr_class_box, info_ocr_class_box,
    write_ocr, ocr_change_char

    Warnings
    --------
    create_ocr_class_box is obsolete and is only provided for reasons of
    backward compatibility.  New applications should use the MLP, SVM or
    CNN based operators instead.
    """
    with HalconOperator(716) as proc:
        proc.set_input_tuple(0, width_pattern)
        proc.set_input_tuple(1, height_pattern)
        proc.set_input_tuple(2, interpolation)
        proc.set_input_tuple(3, features)
        proc.set_input_tuple(4, character)
        proc.init_oct(0)
        proc.execute()
        ocr_handle = proc.get_output_tuple_s(0)
        return ocr_handle  # type: ignore


def create_ocr_class_knn(
    width_character: int,
    height_character: int,
    interpolation: str,
    features: MaybeSequence[str],
    characters: Sequence[str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, str]]
) -> HHandle:
    """
    Create an OCR classifier using a k-Nearest Neighbor (k-NN) classifier.

    Parameters
    ----------

    width_character : int
                      Width of the rectangle to which the gray values of
                      the segmented character are zoomed.
                      Value Suggestion: 8

    height_character : int
                       Height of the rectangle to which the gray values of
                       the segmented character are zoomed.
                       Value Suggestion: 10

    interpolation : str
                    Interpolation mode for the zooming of the characters.
                    Value Suggestion: constant

    features : MaybeSequence[str]
               Features to be used for classification.
               Value Suggestion: default

    characters : Sequence[str]
                 All characters of the character set to be read.
                 Value Suggestion: ['0','1','2','3','4','5','6','7','8','9']

    gen_param_name : Sequence[str]
                     This parameter is not yet supported.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, str]]
                      This parameter is not yet supported.
                      Value Suggestion: []

    Returns
    -------

    ocrhandle : HHandle
                Handle of the k-NN classifier.

    See Also
    --------
    do_ocr_single_class_knn, do_ocr_multi_class_knn, clear_class_knn,
    create_class_knn, trainf_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    create_ocr_class_svm

    Successors
    ----------
    trainf_ocr_class_knn
    """
    with HalconOperator(654) as proc:
        proc.set_input_tuple(0, width_character)
        proc.set_input_tuple(1, height_character)
        proc.set_input_tuple(2, interpolation)
        proc.set_input_tuple(3, features)
        proc.set_input_tuple(4, characters)
        proc.set_input_tuple(5, gen_param_name)
        proc.set_input_tuple(6, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def create_ocr_class_mlp(
    width_character: int,
    height_character: int,
    interpolation: str,
    features: MaybeSequence[str],
    characters: Sequence[str],
    num_hidden: int,
    preprocessing: str,
    num_components: int,
    rand_seed: int
) -> HHandle:
    """
    Create an OCR classifier using a multilayer perceptron.

    Parameters
    ----------

    width_character : int
                      Width of the rectangle to which the gray values of
                      the segmented character are zoomed.
                      Value Suggestion: 8

    height_character : int
                       Height of the rectangle to which the gray values of
                       the segmented character are zoomed.
                       Value Suggestion: 10

    interpolation : str
                    Interpolation mode for the zooming of the characters.
                    Value Suggestion: constant

    features : MaybeSequence[str]
               Features to be used for classification.
               Value Suggestion: default

    characters : Sequence[str]
                 All characters of the character set to be read.
                 Value Suggestion: ['0','1','2','3','4','5','6','7','8','9']

    num_hidden : int
                 Number of hidden units of the MLP.
                 Value Suggestion: 80
                 Assertion: NumHidden >= 1

    preprocessing : str
                    Type of preprocessing used to transform the feature
                    vectors.
                    Value Suggestion: none

    num_components : int
                     Preprocessing parameter: Number of transformed
                     features (ignored for Preprocessing $=$ 'none' and
                     Preprocessing $=$ 'normalization').
                     Value Suggestion: 10
                     Assertion: NumComponents >= 1

    rand_seed : int
                Seed value of the random number generator that is used to
                initialize the MLP with random values.
                Value Suggestion: 42

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    do_ocr_single_class_mlp, do_ocr_multi_class_mlp, clear_ocr_class_mlp,
    create_class_mlp, train_class_mlp, classify_class_mlp

    Alternatives
    ------------
    create_ocr_class_svm

    Successors
    ----------
    trainf_ocr_class_mlp, set_regularization_params_ocr_class_mlp,
    set_rejection_params_ocr_class_mlp
    """
    with HalconOperator(708) as proc:
        proc.set_input_tuple(0, width_character)
        proc.set_input_tuple(1, height_character)
        proc.set_input_tuple(2, interpolation)
        proc.set_input_tuple(3, features)
        proc.set_input_tuple(4, characters)
        proc.set_input_tuple(5, num_hidden)
        proc.set_input_tuple(6, preprocessing)
        proc.set_input_tuple(7, num_components)
        proc.set_input_tuple(8, rand_seed)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def create_ocr_class_svm(
    width_character: int,
    height_character: int,
    interpolation: str,
    features: MaybeSequence[str],
    characters: Sequence[str],
    kernel_type: str,
    kernel_param: float,
    nu: float,
    mode: str,
    preprocessing: str,
    num_components: int
) -> HHandle:
    """
    Create an OCR classifier using a support vector machine.

    Parameters
    ----------

    width_character : int
                      Width of the rectangle to which the gray values of
                      the segmented character are zoomed.
                      Value Suggestion: 8

    height_character : int
                       Height of the rectangle to which the gray values of
                       the segmented character are zoomed.
                       Value Suggestion: 10

    interpolation : str
                    Interpolation mode for the zooming of the characters.
                    Value Suggestion: constant

    features : MaybeSequence[str]
               Features to be used for classification.
               Value Suggestion: default

    characters : Sequence[str]
                 All characters of the character set to be read.
                 Value Suggestion: ['0','1','2','3','4','5','6','7','8','9']

    kernel_type : str
                  The kernel type.
                  Value Suggestion: rbf

    kernel_param : float
                   Additional parameter for the kernel function.
                   Value Suggestion: 0.02

    nu : float
         Regularization constant of the SVM.
         Value Suggestion: 0.05
         Assertion: Nu > 0.0 && Nu < 1.0

    mode : str
           The mode of the SVM.
           Value Suggestion: one-versus-one

    preprocessing : str
                    Type of preprocessing used to transform the feature
                    vectors.
                    Value Suggestion: normalization

    num_components : int
                     Preprocessing parameter: Number of transformed
                     features (ignored for Preprocessing $=$ 'none' and
                     Preprocessing $=$ 'normalization').
                     Value Suggestion: 10
                     Assertion: NumComponents >= 1

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    do_ocr_single_class_svm, do_ocr_multi_class_svm, clear_ocr_class_svm,
    create_class_svm, train_class_svm, classify_class_svm

    Alternatives
    ------------
    create_ocr_class_mlp

    Successors
    ----------
    trainf_ocr_class_svm
    """
    with HalconOperator(689) as proc:
        proc.set_input_tuple(0, width_character)
        proc.set_input_tuple(1, height_character)
        proc.set_input_tuple(2, interpolation)
        proc.set_input_tuple(3, features)
        proc.set_input_tuple(4, characters)
        proc.set_input_tuple(5, kernel_type)
        proc.set_input_tuple(6, kernel_param)
        proc.set_input_tuple(7, nu)
        proc.set_input_tuple(8, mode)
        proc.set_input_tuple(9, preprocessing)
        proc.set_input_tuple(10, num_components)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def create_ocv_proj(pattern_names: MaybeSequence[str]) -> HHandle:
    """
    Create a new OCV tool based on gray value projections.

    Parameters
    ----------

    pattern_names : MaybeSequence[str]
                    List of names for patterns to be trained.
                    Value Suggestion: 'a'

    Returns
    -------

    ocvhandle : HHandle
                Handle of the created OCV tool.

    See Also
    --------
    create_ocr_class_box

    Alternatives
    ------------
    read_ocv

    Successors
    ----------
    traind_ocv_proj, write_ocv, close_ocv
    """
    with HalconOperator(646) as proc:
        proc.set_input_tuple(0, pattern_names)
        proc.init_oct(0)
        proc.execute()
        ocvhandle = proc.get_output_tuple_s(0)
        return ocvhandle  # type: ignore


def create_planar_calib_deformable_model(
    template: HObject,
    cam_param: Sequence[Union[float, int, str]],
    reference_pose: Sequence[Union[float, int]],
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: Sequence[Union[int, str]],
    min_contrast: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a deformable model for calibrated perspective matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    cam_param : Sequence[Union[float, int, str]]
                The parameters of the internal orientation of the camera.

    reference_pose : Sequence[Union[float, int]]
                     The reference pose of the object in the reference
                     image.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep >= 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in the column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: none

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : Sequence[Union[int, str]]
               Thresholds or hysteresis thresholds for the contrast of the
               object in the template image.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    gen_param_name : Sequence[str]
                     The parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the parameters.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_planar_uncalib_deformable_model

    Alternatives
    ------------
    read_deformable_model

    Predecessors
    ------------
    determine_deformable_model_params

    Successors
    ----------
    set_deformable_model_origin, set_deformable_model_param,
    get_deformable_model_contours, find_planar_calib_deformable_model,
    get_deformable_model_params, write_deformable_model,
    clear_deformable_model
    """
    with HalconOperator(979) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, cam_param)
        proc.set_input_tuple(1, reference_pose)
        proc.set_input_tuple(2, num_levels)
        proc.set_input_tuple(3, angle_start)
        proc.set_input_tuple(4, angle_extent)
        proc.set_input_tuple(5, angle_step)
        proc.set_input_tuple(6, scale_rmin)
        proc.set_input_tuple(7, scale_rmax)
        proc.set_input_tuple(8, scale_rstep)
        proc.set_input_tuple(9, scale_cmin)
        proc.set_input_tuple(10, scale_cmax)
        proc.set_input_tuple(11, scale_cstep)
        proc.set_input_tuple(12, optimization)
        proc.set_input_tuple(13, metric)
        proc.set_input_tuple(14, contrast)
        proc.set_input_tuple(15, min_contrast)
        proc.set_input_tuple(16, gen_param_name)
        proc.set_input_tuple(17, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_planar_calib_deformable_model_xld(
    contours: HObject,
    cam_param: Sequence[Union[float, int, str]],
    reference_pose: Sequence[Union[float, int]],
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Prepare a deformable model for planar calibrated matching from XLD
    contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    cam_param : Sequence[Union[float, int, str]]
                The parameters of the internal orientation of the camera.

    reference_pose : Sequence[Union[float, int]]
                     The reference pose of the object.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep > 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in the column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep > 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    gen_param_name : Sequence[str]
                     The generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_planar_calib_deformable_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_planar_calib_deformable_model

    Notes
    -----
    Note that, in contrast to the operator
    create_planar_calib_deformable_model, it is not possible to specify a
    minimum size of the model components. To avoid small model components
    in the model, short contours can be eliminated before calling
    create_planar_calib_deformable_model_xld with the operator
    select_contours_xld.
    """
    with HalconOperator(976) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, cam_param)
        proc.set_input_tuple(1, reference_pose)
        proc.set_input_tuple(2, num_levels)
        proc.set_input_tuple(3, angle_start)
        proc.set_input_tuple(4, angle_extent)
        proc.set_input_tuple(5, angle_step)
        proc.set_input_tuple(6, scale_rmin)
        proc.set_input_tuple(7, scale_rmax)
        proc.set_input_tuple(8, scale_rstep)
        proc.set_input_tuple(9, scale_cmin)
        proc.set_input_tuple(10, scale_cmax)
        proc.set_input_tuple(11, scale_cstep)
        proc.set_input_tuple(12, optimization)
        proc.set_input_tuple(13, metric)
        proc.set_input_tuple(14, min_contrast)
        proc.set_input_tuple(15, gen_param_name)
        proc.set_input_tuple(16, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_planar_uncalib_deformable_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: Sequence[Union[int, str]],
    min_contrast: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Creates a deformable model for uncalibrated, perspective matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep >= 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: none

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : Sequence[Union[int, str]]
               Thresholds or hysteresis thresholds for the contrast of the
               object in the template image.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    gen_param_name : Sequence[str]
                     The generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    Alternatives
    ------------
    read_deformable_model

    Predecessors
    ------------
    determine_deformable_model_params

    Successors
    ----------
    set_deformable_model_origin, set_deformable_model_param,
    get_deformable_model_contours, find_planar_uncalib_deformable_model,
    get_deformable_model_params, write_deformable_model,
    clear_deformable_model
    """
    with HalconOperator(980) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, contrast)
        proc.set_input_tuple(13, min_contrast)
        proc.set_input_tuple(14, gen_param_name)
        proc.set_input_tuple(15, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_planar_uncalib_deformable_model_xld(
    contours: HObject,
    num_levels: Union[int, str],
    angle_start: Sequence[float],
    angle_extent: Sequence[float],
    angle_step: Union[float, str],
    scale_rmin: float,
    scale_rmax: Sequence[float],
    scale_rstep: Union[float, str],
    scale_cmin: float,
    scale_cmax: Sequence[float],
    scale_cstep: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int,
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]]
) -> HHandle:
    """
    Prepare a deformable model for planar uncalibrated matching from XLD
    contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : Sequence[float]
                  This parameter is not used.
                  Value Suggestion: []

    angle_extent : Sequence[float]
                   This parameter is not used.
                   Value Suggestion: []

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep > 0 && AngleStep <= pi / 16

    scale_rmin : float
                 Minimum scale of the pattern in row direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleRMin > 0

    scale_rmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_rstep : Union[float, str]
                  Scale step length (resolution) in row direction.
                  Value Suggestion: auto
                  Assertion: ScaleRStep > 0

    scale_cmin : float
                 Minimum scale of the pattern in column direction.
                 Value Suggestion: 1.0
                 Assertion: ScaleCMin > 0

    scale_cmax : Sequence[float]
                 This parameter is not used.
                 Value Suggestion: []

    scale_cstep : Union[float, str]
                  Scale step length (resolution) in the column direction.
                  Value Suggestion: auto
                  Assertion: ScaleCStep > 0

    optimization : MaybeSequence[str]
                   Kind of optimization used for generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    gen_param_name : Sequence[str]
                     The generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_planar_uncalib_deformable_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_planar_uncalib_deformable_model

    Notes
    -----
    Note that, in contrast to the operator
    create_planar_uncalib_deformable_model, it is not possible to specify
    a minimum size of the model components. To avoid small model
    components in the model, short contours can be eliminated before
    calling create_planar_uncalib_deformable_model_xld with the operator
    select_contours_xld.
    """
    with HalconOperator(977) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_rmin)
        proc.set_input_tuple(5, scale_rmax)
        proc.set_input_tuple(6, scale_rstep)
        proc.set_input_tuple(7, scale_cmin)
        proc.set_input_tuple(8, scale_cmax)
        proc.set_input_tuple(9, scale_cstep)
        proc.set_input_tuple(10, optimization)
        proc.set_input_tuple(11, metric)
        proc.set_input_tuple(12, min_contrast)
        proc.set_input_tuple(13, gen_param_name)
        proc.set_input_tuple(14, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_pose(
    trans_x: float,
    trans_y: float,
    trans_z: float,
    rot_x: float,
    rot_y: float,
    rot_z: float,
    order_of_transform: str,
    order_of_rotation: str,
    view_of_transform: str
) -> Sequence[Union[int, float]]:
    """
    Create a 3D pose.

    Parameters
    ----------

    trans_x : float
              Translation along the x-axis (in [m]).
              Value Suggestion: 0.1

    trans_y : float
              Translation along the y-axis (in [m]).
              Value Suggestion: 0.1

    trans_z : float
              Translation along the z-axis (in [m]).
              Value Suggestion: 0.1

    rot_x : float
            Rotation around x-axis or x component of the Rodriguez vector
            (in [°] or without unit).
            Value Suggestion: 90.0

    rot_y : float
            Rotation around y-axis or y component of the Rodriguez vector
            (in [°] or without unit).
            Value Suggestion: 90.0

    rot_z : float
            Rotation around z-axis or z component of the Rodriguez vector
            (in [°] or without unit).
            Value Suggestion: 90.0

    order_of_transform : str
                         Order of rotation and translation.
                         Value Suggestion: 'Rp+T'

    order_of_rotation : str
                        Meaning of the rotation values.
                        Value Suggestion: 'gba'

    view_of_transform : str
                        View of transformation.
                        Value Suggestion: 'point'

    Returns
    -------

    pose : Sequence[Union[int, float]]
           3D pose.

    See Also
    --------
    hom_mat3d_rotate, hom_mat3d_translate, convert_pose_type,
    get_pose_type, hom_mat3d_to_pose, pose_to_hom_mat3d, write_pose,
    read_pose

    Alternatives
    ------------
    read_pose, hom_mat3d_to_pose

    Successors
    ----------
    pose_to_hom_mat3d, write_pose, camera_calibration, hand_eye_calibration
    """
    with HalconOperator(1921) as proc:
        proc.set_input_tuple(0, trans_x)
        proc.set_input_tuple(1, trans_y)
        proc.set_input_tuple(2, trans_z)
        proc.set_input_tuple(3, rot_x)
        proc.set_input_tuple(4, rot_y)
        proc.set_input_tuple(5, rot_z)
        proc.set_input_tuple(6, order_of_transform)
        proc.set_input_tuple(7, order_of_rotation)
        proc.set_input_tuple(8, view_of_transform)
        proc.init_oct(0)
        proc.execute()
        pose = proc.get_output_tuple_m(0)
        return pose  # type: ignore


def create_rectification_grid(
    width: float,
    num_squares: int,
    grid_file: str
) -> None:
    """
    Generate a PostScript file, which describes the rectification grid.

    Parameters
    ----------

    width : float
            Width of the checkered pattern in meters (without the two
            frames).
            Value Suggestion: 0.17
            Assertion: 0.0 < Width

    num_squares : int
                  Number of squares per row and column.
                  Value Suggestion: 17
                  Assertion: 2 <= NumSquares

    grid_file : str
                File name of the PostScript file.
                Value Suggestion: rectification_grid.ps

    See Also
    --------
    find_rectification_grid, saddle_points_sub_pix, connect_grid_points,
    gen_grid_rectification_map
    """
    with HalconOperator(1157) as proc:
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, num_squares)
        proc.set_input_tuple(2, grid_file)
        proc.execute()


def create_sample_identifier(
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, float, int]]
) -> HHandle:
    """
    Create a new sample identifier.

    Parameters
    ----------

    gen_param_name : Sequence[str]
                     Parameter name.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, float, int]]
                      Parameter value.
                      Value Suggestion: []

    Returns
    -------

    sample_identifier : HHandle
                        Handle of the sample identifier.

    See Also
    --------
    prepare_sample_identifier, add_sample_identifier_training_data,
    train_sample_identifier, apply_sample_identifier,
    get_sample_identifier_param, get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, deserialize_sample_identifier,
    clear_sample_identifier, set_sample_identifier_object_info

    Alternatives
    ------------
    read_sample_identifier

    Successors
    ----------
    add_sample_identifier_preparation_data, set_sample_identifier_param
    """
    with HalconOperator(915) as proc:
        proc.set_input_tuple(0, gen_param_name)
        proc.set_input_tuple(1, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        sample_identifier = proc.get_output_tuple_s(0)
        return sample_identifier  # type: ignore


def create_scaled_shape_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    scale_min: float,
    scale_max: float,
    scale_step: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: MaybeSequence[Union[int, str]],
    min_contrast: Union[int, str]
) -> HHandle:
    """
    Prepare an isotropically scaled shape model for matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    scale_min : float
                Minimum scale of the pattern.
                Value Suggestion: 0.9
                Assertion: ScaleMin > 0

    scale_max : float
                Maximum scale of the pattern.
                Value Suggestion: 1.1
                Assertion: ScaleMax >= ScaleMin

    scale_step : Union[float, str]
                 Scale step length (resolution).
                 Value Suggestion: auto
                 Assertion: ScaleStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : MaybeSequence[Union[int, str]]
               Threshold or hysteresis thresholds for the contrast of the
               object in the template image and optionally minimum size of
               the object parts.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    find_scaled_shape_model, find_scaled_shape_models,
    get_shape_model_params, clear_shape_model, write_shape_model,
    set_shape_model_origin, set_shape_model_clutter
    """
    with HalconOperator(939) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_min)
        proc.set_input_tuple(5, scale_max)
        proc.set_input_tuple(6, scale_step)
        proc.set_input_tuple(7, optimization)
        proc.set_input_tuple(8, metric)
        proc.set_input_tuple(9, contrast)
        proc.set_input_tuple(10, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_scaled_shape_model_xld(
    contours: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    scale_min: float,
    scale_max: float,
    scale_step: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int
) -> HHandle:
    """
    Prepare an isotropically scaled shape model for matching from XLD
    contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    scale_min : float
                Minimum scale of the pattern.
                Value Suggestion: 0.9
                Assertion: ScaleMin > 0

    scale_max : float
                Maximum scale of the pattern.
                Value Suggestion: 1.1
                Assertion: ScaleMax >= ScaleMin

    scale_step : Union[float, str]
                 Scale step length (resolution).
                 Value Suggestion: auto
                 Assertion: ScaleStep >= 0

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_scaled_shape_model, find_scaled_shape_models,
    get_shape_model_params, clear_shape_model, write_shape_model,
    set_shape_model_origin, set_shape_model_param, set_shape_model_metric,
    set_shape_model_clutter

    Notes
    -----
    The XLD contours passed in Contours should have been scaled to
    approximately the average size of the object in the search images.
    This means that the product $ScaleMin
    arRef{ScaleMax}$ScaleMin*ScaleMax should be approximately equal to 1.
    Note that, in contrast to the operator create_scaled_shape_model, it
    is not possible to specify a minimum size of the model components. To
    avoid small model components in the shape model, short contours can be
    eliminated before calling create_scaled_shape_model_xld with the
    operator select_contours_xld.
    """
    with HalconOperator(936) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, scale_min)
        proc.set_input_tuple(5, scale_max)
        proc.set_input_tuple(6, scale_step)
        proc.set_input_tuple(7, optimization)
        proc.set_input_tuple(8, metric)
        proc.set_input_tuple(9, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_scattered_data_interpolator(
    method: str,
    rows: Sequence[Union[float, int]],
    columns: Sequence[Union[float, int]],
    values: Sequence[Union[float, int]],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> HHandle:
    """
    Creates an interpolator for the interpolation of scattered data.

    Parameters
    ----------

    method : str
             Method for the interpolation
             Value Suggestion: 'thin_plate_splines'

    rows : Sequence[Union[float, int]]
           Row coordinates of the points used for the interpolation

    columns : Sequence[Union[float, int]]
              Column coordinates of the points used for the interpolation

    values : Sequence[Union[float, int]]
             Values of the points used for the interpolation

    gen_param_name : Sequence[str]
                     Names of the generic parameters that can be adjusted
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Values of the generic parameters that can be adjusted
                      Value Suggestion: []

    Returns
    -------

    scattered_data_interpolator_handle : HHandle
                                         Handle of the scattered data
                                         interpolator

    Successors
    ----------
    interpolate_scattered_data
    """
    with HalconOperator(292) as proc:
        proc.set_input_tuple(0, method)
        proc.set_input_tuple(1, rows)
        proc.set_input_tuple(2, columns)
        proc.set_input_tuple(3, values)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        scattered_data_interpolator_handle = proc.get_output_tuple_s(0)
        return scattered_data_interpolator_handle  # type: ignore


def create_scene_3d() -> HHandle:
    """
    Create the data structure that is needed to visualize collections of
    3D objects.

    Returns
    -------

    scene_3d : HHandle
               Handle of the 3D scene.

    See Also
    --------
    clear_scene_3d

    Successors
    ----------
    add_scene_3d_instance, add_scene_3d_light, add_scene_3d_camera,
    set_scene_3d_param
    """
    with HalconOperator(1220) as proc:
        proc.init_oct(0)
        proc.execute()
        scene_3d = proc.get_output_tuple_s(0)
        return scene_3d  # type: ignore


def create_serialized_item_ptr(
    pointer: int,
    size: int,
    copy: str
) -> HHandle:
    """
    Create a serialized item.

    Parameters
    ----------

    pointer : int
              Data pointer of the serialized item.

    size : int
           Size of the serialized item.

    copy : str
           Copy mode of the serialized item.
           Value Suggestion: true

    Returns
    -------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Successors
    ----------
    get_serialized_item_ptr

    Warnings
    --------
    It is not recommended to use the operator create_serialized_item_ptr
    in HDevelop.

    Notes
    -----
    If the parameter Copy is set to 'false', the data pointer of the
    serialized item must not be deleted during using the new serialized
    item.
    """
    with HalconOperator(410) as proc:
        proc.set_input_tuple(0, pointer)
        proc.set_input_tuple(1, size)
        proc.set_input_tuple(2, copy)
        proc.init_oct(0)
        proc.execute()
        serialized_item_handle = proc.get_output_tuple_s(0)
        return serialized_item_handle  # type: ignore


def create_shape_model(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    contrast: MaybeSequence[Union[int, str]],
    min_contrast: Union[int, str]
) -> HHandle:
    """
    Prepare a shape model for matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : MaybeSequence[Union[int, str]]
               Threshold or hysteresis thresholds for the contrast of the
               object in the template image and optionally minimum size of
               the object parts.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    find_shape_model, find_shape_models, get_shape_model_params,
    clear_shape_model, write_shape_model, set_shape_model_origin,
    set_shape_model_clutter
    """
    with HalconOperator(940) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, optimization)
        proc.set_input_tuple(5, metric)
        proc.set_input_tuple(6, contrast)
        proc.set_input_tuple(7, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_shape_model_3d(
    object_model_3d: HHandle,
    cam_param: Sequence[Union[int, float, str]],
    ref_rot_x: float,
    ref_rot_y: float,
    ref_rot_z: float,
    order_of_rotation: str,
    longitude_min: float,
    longitude_max: float,
    latitude_min: float,
    latitude_max: float,
    cam_roll_min: float,
    cam_roll_max: float,
    dist_min: float,
    dist_max: float,
    min_contrast: int,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Prepare a 3D object model for matching.

    Parameters
    ----------

    object_model_3d : HHandle
                      Handle of the 3D object model.

    cam_param : Sequence[Union[int, float, str]]
                Internal camera parameters.

    ref_rot_x : float
                Reference orientation: Rotation around x-axis or x
                component of the Rodriguez vector (in radians or without
                unit).
                Value Suggestion: 0

    ref_rot_y : float
                Reference orientation: Rotation around y-axis or y
                component of the Rodriguez vector (in radians or without
                unit).
                Value Suggestion: 0

    ref_rot_z : float
                Reference orientation: Rotation around z-axis or z
                component of the Rodriguez vector (in radians or without
                unit).
                Value Suggestion: 0

    order_of_rotation : str
                        Meaning of the rotation values of the reference
                        orientation.
                        Value Suggestion: 'gba'

    longitude_min : float
                    Minimum longitude of the model views.
                    Value Suggestion: -0.35

    longitude_max : float
                    Maximum longitude of the model views.
                    Value Suggestion: 0.35
                    Assertion: LongitudeMax >= LongitudeMin

    latitude_min : float
                   Minimum latitude of the model views.
                   Value Suggestion: -0.35
                   Assertion: - pi / 2 <= LatitudeMin && LatitudeMin <= pi / 2

    latitude_max : float
                   Maximum latitude of the model views.
                   Value Suggestion: 0.35
                   Assertion: - pi / 2 <= LatitudeMax && LatitudeMax <= pi / 2 && LatitudeMax >= LatitudeMin

    cam_roll_min : float
                   Minimum camera roll angle of the model views.
                   Value Suggestion: -3.1416

    cam_roll_max : float
                   Maximum camera roll angle of the model views.
                   Value Suggestion: 3.1416
                   Assertion: CamRollMax >= CamRollMin

    dist_min : float
               Minimum camera-object-distance of the model views.
               Value Suggestion: 0.3
               Assertion: DistMin > 0

    dist_max : float
               Maximum camera-object-distance of the model views.
               Value Suggestion: 0.4
               Assertion: DistMax >= DistMin

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 10

    gen_param_name : MaybeSequence[str]
                     Names of (optional) parameters for controlling the
                     behavior of the operator.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Values of the optional generic parameters.
                      Value Suggestion: []

    Returns
    -------

    shape_model_3did : HHandle
                       Handle of the 3D shape model.

    See Also
    --------
    convert_point_3d_cart_to_spher, convert_point_3d_spher_to_cart,
    create_cam_pose_look_at_point, trans_pose_shape_model_3d

    Predecessors
    ------------
    read_object_model_3d, project_object_model_3d,
    get_object_model_3d_params

    Successors
    ----------
    find_shape_model_3d, write_shape_model_3d, project_shape_model_3d,
    get_shape_model_3d_params, get_shape_model_3d_contours
    """
    with HalconOperator(1059) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, cam_param)
        proc.set_input_tuple(2, ref_rot_x)
        proc.set_input_tuple(3, ref_rot_y)
        proc.set_input_tuple(4, ref_rot_z)
        proc.set_input_tuple(5, order_of_rotation)
        proc.set_input_tuple(6, longitude_min)
        proc.set_input_tuple(7, longitude_max)
        proc.set_input_tuple(8, latitude_min)
        proc.set_input_tuple(9, latitude_max)
        proc.set_input_tuple(10, cam_roll_min)
        proc.set_input_tuple(11, cam_roll_max)
        proc.set_input_tuple(12, dist_min)
        proc.set_input_tuple(13, dist_max)
        proc.set_input_tuple(14, min_contrast)
        proc.set_input_tuple(15, gen_param_name)
        proc.set_input_tuple(16, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        shape_model_3did = proc.get_output_tuple_s(0)
        return shape_model_3did  # type: ignore


def create_shape_model_xld(
    contours: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    angle_step: Union[float, str],
    optimization: MaybeSequence[str],
    metric: str,
    min_contrast: int
) -> HHandle:
    """
    Prepare a shape model for matching from XLD contours.

    Parameters
    ----------

    contours : HObject
               Input contours that will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    angle_step : Union[float, str]
                 Step length of the angles (resolution).
                 Value Suggestion: auto
                 Assertion: AngleStep >= 0 && AngleStep <= pi / 2

    optimization : MaybeSequence[str]
                   Kind of optimization and optionally method used for
                   generating the model.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: ignore_local_polarity

    min_contrast : int
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: 5

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    set_system, get_system

    Alternatives
    ------------
    create_generic_shape_model

    Predecessors
    ------------
    read_contour_xld_dxf, edges_sub_pix, select_contours_xld

    Successors
    ----------
    find_shape_model, find_shape_models, get_shape_model_params,
    clear_shape_model, write_shape_model, set_shape_model_origin,
    set_shape_model_param, set_shape_model_metric, set_shape_model_clutter

    Notes
    -----
    Note that, in contrast to the operator create_shape_model, it is not
    possible to specify a minimum size of the model components. To avoid
    small model components in the shape model, short contours can be
    eliminated before calling create_shape_model_xld with the operator
    select_contours_xld.
    """
    with HalconOperator(937) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, optimization)
        proc.set_input_tuple(5, metric)
        proc.set_input_tuple(6, min_contrast)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_sheet_of_light_calib_object(
    width: float,
    length: float,
    height_min: float,
    height_max: float,
    file_name: str
) -> None:
    """
    Create a calibration object for sheet-of-light calibration.

    Parameters
    ----------

    width : float
            Width of the object.
            Value Suggestion: 0.1

    length : float
             Length of the object.
             Value Suggestion: 0.15

    height_min : float
                 Minimum height of the ramp.
                 Value Suggestion: 0.005

    height_max : float
                 Maximum height of the ramp.
                 Value Suggestion: 0.04

    file_name : str
                Filename of the model of the calibration object.
                Value Suggestion: 'calib_object.dxf'
    """
    with HalconOperator(378) as proc:
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, length)
        proc.set_input_tuple(2, height_min)
        proc.set_input_tuple(3, height_max)
        proc.set_input_tuple(4, file_name)
        proc.execute()


def create_sheet_of_light_model(
    profile_region: HObject,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Create a model to perform 3D-measurements using the sheet-of-light
    technique.

    Parameters
    ----------

    profile_region : HObject
                     Region of the images containing the profiles to be
                     processed. If the provided region is not rectangular,
                     its smallest enclosing rectangle will be used.

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters that can be adjusted
                     for the sheet-of-light model.
                     Value Suggestion: min_gray

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Values of the generic parameters that can be
                      adjusted for the sheet-of-light model.
                      Value Suggestion: 50

    Returns
    -------

    sheet_of_light_model_id : HHandle
                              Handle for using and accessing the
                              sheet-of-light model.

    See Also
    --------
    clear_sheet_of_light_model, calibrate_sheet_of_light

    Predecessors
    ------------
    gen_rectangle1

    Successors
    ----------
    set_sheet_of_light_param, measure_profile_sheet_of_light
    """
    with HalconOperator(391) as proc:
        proc.set_input_object(1, profile_region)
        proc.set_input_tuple(0, gen_param_name)
        proc.set_input_tuple(1, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        sheet_of_light_model_id = proc.get_output_tuple_s(0)
        return sheet_of_light_model_id  # type: ignore


def create_stereo_model(
    camera_setup_model_id: HHandle,
    method: str,
    gen_param_name: MaybeSequence[str],
    gen_param_value: Sequence[Union[float, int, str]]
) -> HHandle:
    """
    Create a HALCON stereo model.

    Parameters
    ----------

    camera_setup_model_id : HHandle
                            Handle to the camera setup model.

    method : str
             Reconstruction method.
             Value Suggestion: surface_pairwise

    gen_param_name : MaybeSequence[str]
                     Name of the model parameter to be set.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[float, int, str]]
                      Value of the model parameter to be set.
                      Value Suggestion: []

    Returns
    -------

    stereo_model_id : HHandle
                      Handle of the stereo model.

    Successors
    ----------
    set_stereo_model_param, set_stereo_model_image_pairs,
    reconstruct_surface_stereo, reconstruct_points_stereo
    """
    with HalconOperator(527) as proc:
        proc.set_input_tuple(0, camera_setup_model_id)
        proc.set_input_tuple(1, method)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        stereo_model_id = proc.get_output_tuple_s(0)
        return stereo_model_id  # type: ignore


def create_structured_light_model(model_type: str) -> HHandle:
    """
    Create a structured light model.

    Parameters
    ----------

    model_type : str
                 The type of the created structured light model.
                 Value Suggestion: deflectometry

    Returns
    -------

    structured_light_model : HHandle
                             Handle for using and accessing the structured
                             light model.

    Successors
    ----------
    set_structured_light_model_param, get_structured_light_model_param
    """
    with HalconOperator(2107) as proc:
        proc.set_input_tuple(0, model_type)
        proc.init_oct(0)
        proc.execute()
        structured_light_model = proc.get_output_tuple_s(0)
        return structured_light_model  # type: ignore


def create_surface_model(
    object_model_3d: HHandle,
    rel_sampling_distance: float,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[str, float, int]]
) -> HHandle:
    """
    Create the data structure needed to perform surface-based matching.

    Parameters
    ----------

    object_model_3d : HHandle
                      Handle of the 3D object model.

    rel_sampling_distance : float
                            Sampling distance relative to the object's
                            diameter
                            Value Suggestion: 0.03
                            Assertion: 0 < RelSamplingDistance < 1

    gen_param_name : MaybeSequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[str, float, int]]
                      Values of the generic parameters.
                      Value Suggestion: []

    Returns
    -------

    surface_model_id : HHandle
                       Handle of the surface model.

    See Also
    --------
    find_surface_model, refine_surface_model_pose, read_surface_model,
    write_surface_model, clear_surface_model, set_surface_model_param

    Alternatives
    ------------
    read_surface_model

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d,
    get_object_model_3d_params, surface_normals_object_model_3d

    Successors
    ----------
    find_surface_model, refine_surface_model_pose,
    get_surface_model_param, write_surface_model, clear_surface_model,
    set_surface_model_param
    """
    with HalconOperator(1044) as proc:
        proc.set_input_tuple(0, object_model_3d)
        proc.set_input_tuple(1, rel_sampling_distance)
        proc.set_input_tuple(2, gen_param_name)
        proc.set_input_tuple(3, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        surface_model_id = proc.get_output_tuple_s(0)
        return surface_model_id  # type: ignore


def create_template(
    template: HObject,
    first_error: int,
    num_level: int,
    optimize: str,
    gray_values: str
) -> HHandle:
    """
    Preparing a pattern for template matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be processed for the pattern
               matching.

    first_error : int
                  Not yet in use.
                  Value Suggestion: 255

    num_level : int
                Maximal number of pyramid levels.
                Value Suggestion: 4

    optimize : str
               Kind of optimizing.
               Value Suggestion: sort

    gray_values : str
                  Kind of gray values.
                  Value Suggestion: original

    Returns
    -------

    template_id : HHandle
                  Template number.

    Alternatives
    ------------
    create_ncc_model, create_template_rot, read_template

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    adapt_template, set_reference_template, clear_template,
    write_template, set_offset_template, best_match, best_match_mg,
    fast_match, fast_match_mg

    Warnings
    --------
    create_template is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1489) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, first_error)
        proc.set_input_tuple(1, num_level)
        proc.set_input_tuple(2, optimize)
        proc.set_input_tuple(3, gray_values)
        proc.init_oct(0)
        proc.execute()
        template_id = proc.get_output_tuple_s(0)
        return template_id  # type: ignore


def create_template_rot(
    template: HObject,
    num_level: int,
    angle_start: float,
    angle_extend: float,
    angle_step: float,
    optimize: str,
    gray_values: str
) -> HHandle:
    """
    Preparing a pattern for template matching with rotation.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be processed for the pattern
               matching.

    num_level : int
                Maximal number of pyramid levels.
                Value Suggestion: 4

    angle_start : float
                  Smallest Rotation of the pattern.
                  Value Suggestion: -0.39

    angle_extend : float
                   Maximum positive Extension of AngleStart.
                   Value Suggestion: 0.79
                   Assertion: AngleExtend > 0

    angle_step : float
                 Step rate (angle precision) of matching.
                 Value Suggestion: 0.0982
                 Assertion: AngleStep > 0

    optimize : str
               Kind of optimizing.
               Value Suggestion: sort

    gray_values : str
                  Kind of gray values.
                  Value Suggestion: original

    Returns
    -------

    template_id : HHandle
                  Template number.

    Alternatives
    ------------
    create_ncc_model, create_template

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    best_match_rot, best_match_rot_mg, adapt_template,
    set_reference_template, clear_template, set_offset_template,
    write_template

    Warnings
    --------
    create_template_rot is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.

    Notes
    -----
    You have to be aware, that depending on the resolution a large number
    of pre calculated patterns have to be created which might result in a
    large amount of memory needed.
    """
    with HalconOperator(1488) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_level)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extend)
        proc.set_input_tuple(3, angle_step)
        proc.set_input_tuple(4, optimize)
        proc.set_input_tuple(5, gray_values)
        proc.init_oct(0)
        proc.execute()
        template_id = proc.get_output_tuple_s(0)
        return template_id  # type: ignore


def create_text_model() -> HHandle:
    """
    Create a text model.

    Returns
    -------

    text_model : HHandle
                 New text model.

    Warnings
    --------
    create_text_model is obsolete and is only provided for reasons of
    backward compatibility. New applications should use
    create_text_model_reader instead.
    """
    with HalconOperator(423) as proc:
        proc.init_oct(0)
        proc.execute()
        text_model = proc.get_output_tuple_s(0)
        return text_model  # type: ignore


def create_text_model_reader(
    mode: str,
    ocrclassifier: Union[int, str]
) -> HHandle:
    """
    Create a text model.

    Parameters
    ----------

    mode : str
           The Mode of the text model.
           Value Suggestion: auto

    ocrclassifier : Union[int, str]
                    OCR Classifier.
                    Value Suggestion: Universal_Rej.occ

    Returns
    -------

    text_model : HHandle
                 New text model.

    See Also
    --------
    clear_text_model

    Successors
    ----------
    set_text_model_param, get_text_model_param, find_text
    """
    with HalconOperator(422) as proc:
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, ocrclassifier)
        proc.init_oct(0)
        proc.execute()
        text_model = proc.get_output_tuple_s(0)
        return text_model  # type: ignore


def create_texture_inspection_model(model_type: str) -> HHandle:
    """
    Create a texture inspection model.

    Parameters
    ----------

    model_type : str
                 The type of the created texture inspection model.
                 Value Suggestion: basic

    Returns
    -------

    texture_inspection_model : HHandle
                               Handle for using and accessing the texture
                               inspection model.

    Successors
    ----------
    set_texture_inspection_model_param,
    get_texture_inspection_model_param, add_texture_inspection_model_image
    """
    with HalconOperator(2051) as proc:
        proc.set_input_tuple(0, model_type)
        proc.init_oct(0)
        proc.execute()
        texture_inspection_model = proc.get_output_tuple_s(0)
        return texture_inspection_model  # type: ignore


def create_trained_component_model(
    component_training_id: HHandle,
    angle_start: float,
    angle_extent: float,
    min_contrast_comp: MaybeSequence[Union[int, str]],
    min_score_comp: MaybeSequence[float],
    num_levels_comp: MaybeSequence[Union[int, str]],
    angle_step_comp: MaybeSequence[Union[float, str]],
    optimization_comp: str,
    metric_comp: MaybeSequence[str],
    pregeneration_comp: MaybeSequence[str]
) -> Tuple[HHandle, Sequence[int]]:
    """
    Prepare a component model for matching based on trained components.

    Parameters
    ----------

    component_training_id : HHandle
                            Handle of the training result.

    angle_start : float
                  Smallest rotation of the component model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation of the component model.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    min_contrast_comp : MaybeSequence[Union[int, str]]
                        Minimum contrast of the components in the search
                        images.
                        Value Suggestion: auto
                        Assertion: MinContrastComp >= 0

    min_score_comp : MaybeSequence[float]
                     Minimum score of the instances of the components to
                     be found.
                     Value Suggestion: 0.5
                     Assertion: 0 <= MinScoreComp && MinScoreComp <= 1

    num_levels_comp : MaybeSequence[Union[int, str]]
                      Maximum number of pyramid levels for the components.
                      Value Suggestion: auto

    angle_step_comp : MaybeSequence[Union[float, str]]
                      Step length of the angles (resolution) for the
                      components.
                      Value Suggestion: auto
                      Assertion: AngleStepComp >= 0

    optimization_comp : str
                        Kind of optimization for the components.
                        Value Suggestion: auto

    metric_comp : MaybeSequence[str]
                  Match metric used for the components.
                  Value Suggestion: use_polarity

    pregeneration_comp : MaybeSequence[str]
                         Complete pregeneration of the shape models for
                         the components if equal to 'true'.
                         Value Suggestion: false

    Returns
    -------

    component_model_id : HHandle
                         Handle of the component model.

    root_ranking : Sequence[int]
                   Ranking of the model components expressing the
                   suitability to act as the root component.

    Alternatives
    ------------
    create_component_model

    Predecessors
    ------------
    train_model_components, read_training_components

    Successors
    ----------
    find_component_model
    """
    with HalconOperator(1005) as proc:
        proc.set_input_tuple(0, component_training_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, min_contrast_comp)
        proc.set_input_tuple(4, min_score_comp)
        proc.set_input_tuple(5, num_levels_comp)
        proc.set_input_tuple(6, angle_step_comp)
        proc.set_input_tuple(7, optimization_comp)
        proc.set_input_tuple(8, metric_comp)
        proc.set_input_tuple(9, pregeneration_comp)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # component_model_id
            proc.get_output_tuple_m(1)   # root_ranking
        )  # type: ignore


def create_trained_component_model_s(
    component_training_id: HHandle,
    angle_start: float,
    angle_extent: float,
    min_contrast_comp: MaybeSequence[Union[int, str]],
    min_score_comp: MaybeSequence[float],
    num_levels_comp: MaybeSequence[Union[int, str]],
    angle_step_comp: MaybeSequence[Union[float, str]],
    optimization_comp: str,
    metric_comp: MaybeSequence[str],
    pregeneration_comp: MaybeSequence[str]
) -> Tuple[HHandle, int]:
    """
    Prepare a component model for matching based on trained components.

    Parameters
    ----------

    component_training_id : HHandle
                            Handle of the training result.

    angle_start : float
                  Smallest rotation of the component model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation of the component model.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    min_contrast_comp : MaybeSequence[Union[int, str]]
                        Minimum contrast of the components in the search
                        images.
                        Value Suggestion: auto
                        Assertion: MinContrastComp >= 0

    min_score_comp : MaybeSequence[float]
                     Minimum score of the instances of the components to
                     be found.
                     Value Suggestion: 0.5
                     Assertion: 0 <= MinScoreComp && MinScoreComp <= 1

    num_levels_comp : MaybeSequence[Union[int, str]]
                      Maximum number of pyramid levels for the components.
                      Value Suggestion: auto

    angle_step_comp : MaybeSequence[Union[float, str]]
                      Step length of the angles (resolution) for the
                      components.
                      Value Suggestion: auto
                      Assertion: AngleStepComp >= 0

    optimization_comp : str
                        Kind of optimization for the components.
                        Value Suggestion: auto

    metric_comp : MaybeSequence[str]
                  Match metric used for the components.
                  Value Suggestion: use_polarity

    pregeneration_comp : MaybeSequence[str]
                         Complete pregeneration of the shape models for
                         the components if equal to 'true'.
                         Value Suggestion: false

    Returns
    -------

    component_model_id : HHandle
                         Handle of the component model.

    root_ranking : int
                   Ranking of the model components expressing the
                   suitability to act as the root component.

    Alternatives
    ------------
    create_component_model

    Predecessors
    ------------
    train_model_components, read_training_components

    Successors
    ----------
    find_component_model
    """
    with HalconOperator(1005) as proc:
        proc.set_input_tuple(0, component_training_id)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, min_contrast_comp)
        proc.set_input_tuple(4, min_score_comp)
        proc.set_input_tuple(5, num_levels_comp)
        proc.set_input_tuple(6, angle_step_comp)
        proc.set_input_tuple(7, optimization_comp)
        proc.set_input_tuple(8, metric_comp)
        proc.set_input_tuple(9, pregeneration_comp)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # component_model_id
            proc.get_output_tuple_s(1)   # root_ranking
        )  # type: ignore


def create_uncalib_descriptor_model(
    template: HObject,
    detector_type: str,
    detector_param_name: Sequence[str],
    detector_param_value: Sequence[Union[int, float, str]],
    descriptor_param_name: Sequence[str],
    descriptor_param_value: Sequence[Union[int, float, str]],
    seed: int
) -> HHandle:
    """
    Prepare a descriptor model for interest point matching.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    detector_type : str
                    The type of the detector.
                    Value Suggestion: lepetit

    detector_param_name : Sequence[str]
                          The detector's parameter names.
                          Value Suggestion: []

    detector_param_value : Sequence[Union[int, float, str]]
                           Values of the detector's parameters.
                           Value Suggestion: []

    descriptor_param_name : Sequence[str]
                            The descriptor's parameter names.
                            Value Suggestion: []

    descriptor_param_value : Sequence[Union[int, float, str]]
                             Values of the descriptor's parameters.
                             Value Suggestion: []

    seed : int
           The seed for the random number generator.
           Value Suggestion: 42

    Returns
    -------

    model_id : HHandle
               The handle to the descriptor model.

    See Also
    --------
    get_descriptor_model_params, find_uncalib_descriptor_model

    Predecessors
    ------------
    points_lepetit, points_harris, reduce_domain

    Successors
    ----------
    get_descriptor_model_params, find_uncalib_descriptor_model
    """
    with HalconOperator(953) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, detector_type)
        proc.set_input_tuple(1, detector_param_name)
        proc.set_input_tuple(2, detector_param_value)
        proc.set_input_tuple(3, descriptor_param_name)
        proc.set_input_tuple(4, descriptor_param_value)
        proc.set_input_tuple(5, seed)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def create_variation_model(
    width: int,
    height: int,
    type: str,
    mode: str
) -> HHandle:
    """
    Create a variation model for image comparison.

    Parameters
    ----------

    width : int
            Width of the images to be compared.
            Value Suggestion: 640

    height : int
             Height of the images to be compared.
             Value Suggestion: 480

    type : str
           Type of the images to be compared.
           Value Suggestion: byte

    mode : str
           Method used for computing the variation model.
           Value Suggestion: standard

    Returns
    -------

    model_id : HHandle
               ID of the variation model.

    See Also
    --------
    prepare_variation_model, clear_variation_model,
    clear_train_data_variation_model, find_generic_shape_model,
    affine_trans_image

    Successors
    ----------
    train_variation_model, prepare_direct_variation_model
    """
    with HalconOperator(95) as proc:
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, height)
        proc.set_input_tuple(2, type)
        proc.set_input_tuple(3, mode)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def critical_points_sub_pix(
    image: HObject,
    filter: str,
    sigma: float,
    threshold: float
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Subpixel precise detection of critical points in an image.

    Parameters
    ----------

    image : HObject
            Input image.

    filter : str
             Method for the calculation of the partial derivatives.
             Value Suggestion: facet

    sigma : float
            Sigma of the Gaussian. If Filter is 'facet', Sigma may be 0.0
            to avoid the smoothing of the input image.
            Assertion: Sigma >= 0.0

    threshold : float
                Minimum absolute value of the eigenvalues of the Hessian
                matrix.
                Value Suggestion: 5.0
                Assertion: Threshold >= 0.0

    Returns
    -------

    row_min : Sequence[float]
              Row coordinates of the detected minima.

    column_min : Sequence[float]
                 Column coordinates of the detected minima.

    row_max : Sequence[float]
              Row coordinates of the detected maxima.

    column_max : Sequence[float]
                 Column coordinates of the detected maxima.

    row_saddle : Sequence[float]
                 Row coordinates of the detected saddle points.

    column_saddle : Sequence[float]
                    Column coordinates of the detected saddle points.

    See Also
    --------
    local_min, local_max, plateaus, plateaus_center, lowlands,
    lowlands_center

    Alternatives
    ------------
    local_min_sub_pix, local_max_sub_pix, saddle_points_sub_pix

    Successors
    ----------
    gen_cross_contour_xld, disp_cross

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1434) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, filter)
        proc.set_input_tuple(1, sigma)
        proc.set_input_tuple(2, threshold)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_min
            proc.get_output_tuple_m(1),  # column_min
            proc.get_output_tuple_m(2),  # row_max
            proc.get_output_tuple_m(3),  # column_max
            proc.get_output_tuple_m(4),  # row_saddle
            proc.get_output_tuple_m(5)   # column_saddle
        )  # type: ignore


def crop_contours_xld(
    contours: HObject,
    row_1: Union[float, int],
    col_1: Union[float, int],
    row_2: Union[float, int],
    col_2: Union[float, int],
    close_contours: str
) -> HObject:
    """
    Crop an XLD contour.

    Parameters
    ----------

    contours : HObject
               Input contours.

    row_1 : Union[float, int]
            Upper border of the cropping rectangle.
            Value Suggestion: 0

    col_1 : Union[float, int]
            Left border of the cropping rectangle.
            Value Suggestion: 0

    row_2 : Union[float, int]
            Lower border of the cropping rectangle.
            Value Suggestion: 512

    col_2 : Union[float, int]
            Right border of the cropping rectangle.
            Value Suggestion: 512

    close_contours : str
                     Should closed contours produce closed output contours?
                     Value Suggestion: true

    Returns
    -------

    cropped_contours : HObject
                       Output contours.

    See Also
    --------
    clip_region, crop_part, clip_contours_xld

    Alternatives
    ------------
    clip_contours_xld
    """
    with HalconOperator(14) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, col_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, col_2)
        proc.set_input_tuple(4, close_contours)
        proc.execute()
        cropped_contours = HObject(proc.get_output_object_key(1))
        return cropped_contours  # type: ignore


def crop_domain(image: HObject) -> HObject:
    """
    Cut out of defined gray values.

    Parameters
    ----------

    image : HObject
            Input image.

    Returns
    -------

    image_part : HObject
                 Image area.

    See Also
    --------
    zoom_image_size, zoom_image_factor

    Alternatives
    ------------
    crop_part, crop_rectangle1, change_format, reduce_domain

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1139) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def crop_domain_rel(
    image: HObject,
    top: int,
    left: int,
    bottom: int,
    right: int
) -> HObject:
    """
    Cut out an image area relative to the domain.

    Parameters
    ----------

    image : HObject
            Input image.

    top : int
          Number of rows clipped at the top.
          Value Suggestion: -1

    left : int
           Number of columns clipped at the left.
           Value Suggestion: -1

    bottom : int
             Number of rows clipped at the bottom.
             Value Suggestion: -1

    right : int
            Number of columns clipped at the right.
            Value Suggestion: -1

    Returns
    -------

    image_part : HObject
                 Image area.

    See Also
    --------
    smallest_rectangle1, intersection, gen_rectangle1, clip_region

    Alternatives
    ------------
    crop_domain, crop_rectangle1

    Predecessors
    ------------
    reduce_domain, threshold, connection, regiongrowing, pouring
    """
    with HalconOperator(726) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, top)
        proc.set_input_tuple(1, left)
        proc.set_input_tuple(2, bottom)
        proc.set_input_tuple(3, right)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def crop_part(
    image: HObject,
    row: MaybeSequence[int],
    column: MaybeSequence[int],
    width: MaybeSequence[int],
    height: MaybeSequence[int]
) -> HObject:
    """
    Cut out one or more rectangular image areas.

    Parameters
    ----------

    image : HObject
            Input image.

    row : MaybeSequence[int]
          Line index of upper left corner of image area.
          Value Suggestion: 100

    column : MaybeSequence[int]
             Column index of upper left corner of image area.
             Value Suggestion: 100

    width : MaybeSequence[int]
            Width of new image.
            Value Suggestion: 128

    height : MaybeSequence[int]
             Height of new image.
             Value Suggestion: 128

    Returns
    -------

    image_part : HObject
                 Image area.

    See Also
    --------
    zoom_image_size, zoom_image_factor

    Alternatives
    ------------
    crop_rectangle1, crop_domain, change_format, reduce_domain

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1141) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, width)
        proc.set_input_tuple(3, height)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def crop_rectangle1(
    image: HObject,
    row_1: MaybeSequence[int],
    column_1: MaybeSequence[int],
    row_2: MaybeSequence[int],
    column_2: MaybeSequence[int]
) -> HObject:
    """
    Cut out one or more rectangular image areas.

    Parameters
    ----------

    image : HObject
            Input image.

    row_1 : MaybeSequence[int]
            Line index of upper left corner of image area.
            Value Suggestion: 100

    column_1 : MaybeSequence[int]
               Column index of upper left corner of image area.
               Value Suggestion: 100

    row_2 : MaybeSequence[int]
            Line index of lower right corner of image area.
            Value Suggestion: 200

    column_2 : MaybeSequence[int]
               Column index of lower right corner of image area.
               Value Suggestion: 200

    Returns
    -------

    image_part : HObject
                 Image area.

    See Also
    --------
    zoom_image_size, zoom_image_factor

    Alternatives
    ------------
    crop_part, crop_domain, change_format, reduce_domain

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1140) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def crop_rectangle2(
    image: HObject,
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    length_1: MaybeSequence[Union[int, float]],
    length_2: MaybeSequence[Union[int, float]],
    align_to_axis: str,
    interpolation: str
) -> HObject:
    """
    Cut out one or more arbitrarily oriented rectangular image areas.

    Parameters
    ----------

    image : HObject
            Input image(s).

    row : MaybeSequence[Union[int, float]]
          Row index of the image crop center.
          Value Suggestion: 300.0

    column : MaybeSequence[Union[int, float]]
             Column index of the image crop center.
             Value Suggestion: 200.0

    phi : MaybeSequence[Union[int, float]]
          Orientation of the rectangle (arc measure).
          Value Suggestion: 0.0

    length_1 : MaybeSequence[Union[int, float]]
               First half edge length of the rectangle.
               Value Suggestion: 100.0

    length_2 : MaybeSequence[Union[int, float]]
               Second half edge length of the rectangle.
               Value Suggestion: 20.0

    align_to_axis : str
                    Determines whether the cropped image part is aligned
                    with the coordinate axes.
                    Value Suggestion: true

    interpolation : str
                    Interpolation method.
                    Value Suggestion: constant

    Returns
    -------

    image_part : HObject
                 Cropped image part(s).

    See Also
    --------
    zoom_image_size, zoom_image_factor

    Alternatives
    ------------
    crop_domain, crop_rectangle1, crop_part, change_format, reduce_domain

    Successors
    ----------
    disp_image
    """
    with HalconOperator(2209) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, phi)
        proc.set_input_tuple(3, length_1)
        proc.set_input_tuple(4, length_2)
        proc.set_input_tuple(5, align_to_axis)
        proc.set_input_tuple(6, interpolation)
        proc.execute()
        image_part = HObject(proc.get_output_object_key(1))
        return image_part  # type: ignore


def deactivate_all_compute_devices() -> None:
    """
    Deactivate all compute devices.

    See Also
    --------
    activate_compute_device, deactivate_compute_device
    """
    with HalconOperator(300) as proc:
        proc.execute()


def deactivate_compute_device(device_handle: HHandle) -> None:
    """
    Deactivate a compute device.

    Parameters
    ----------

    device_handle : HHandle
                    Compute device handle.

    See Also
    --------
    deactivate_all_compute_devices

    Predecessors
    ------------
    activate_compute_device
    """
    with HalconOperator(301) as proc:
        proc.set_input_tuple(0, device_handle)
        proc.execute()


def decode_bar_code_rectangle2(
    image: HObject,
    bar_code_handle: HHandle,
    code_type: MaybeSequence[str],
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    length_1: MaybeSequence[Union[int, float]],
    length_2: MaybeSequence[Union[int, float]]
) -> Sequence[str]:
    """
    Decode bar code symbols within a rectangle.

    Parameters
    ----------

    image : HObject
            Input image.

    bar_code_handle : HHandle
                      Handle of the bar code model.

    code_type : MaybeSequence[str]
                Type of the searched bar code.
                Value Suggestion: 'EAN-13'

    row : MaybeSequence[Union[int, float]]
          Row index of the center.
          Value Suggestion: 50.0

    column : MaybeSequence[Union[int, float]]
             Column index of the center.
             Value Suggestion: 100.0

    phi : MaybeSequence[Union[int, float]]
          Orientation of rectangle in radians.
          Value Suggestion: 0.0

    length_1 : MaybeSequence[Union[int, float]]
               Half of the length of the rectangle along the reading
               direction of the bar code.
               Value Suggestion: 200.0

    length_2 : MaybeSequence[Union[int, float]]
               Half of the length of the rectangle perpendicular to the
               reading direction of the bar code.
               Value Suggestion: 100.0

    Returns
    -------

    decoded_data_strings : Sequence[str]
                           Data strings of all successfully decoded bar
                           codes.

    See Also
    --------
    gen_rectangle2

    Alternatives
    ------------
    find_bar_code

    Predecessors
    ------------
    create_bar_code_model, set_bar_code_param, smallest_rectangle2

    Successors
    ----------
    get_bar_code_result, get_bar_code_object, clear_bar_code_model
    """
    with HalconOperator(1992) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, bar_code_handle)
        proc.set_input_tuple(1, code_type)
        proc.set_input_tuple(2, row)
        proc.set_input_tuple(3, column)
        proc.set_input_tuple(4, phi)
        proc.set_input_tuple(5, length_1)
        proc.set_input_tuple(6, length_2)
        proc.init_oct(0)
        proc.execute()
        decoded_data_strings = proc.get_output_tuple_m(0)
        return decoded_data_strings  # type: ignore


def decode_bar_code_rectangle2_s(
    image: HObject,
    bar_code_handle: HHandle,
    code_type: MaybeSequence[str],
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    length_1: MaybeSequence[Union[int, float]],
    length_2: MaybeSequence[Union[int, float]]
) -> str:
    """
    Decode bar code symbols within a rectangle.

    Parameters
    ----------

    image : HObject
            Input image.

    bar_code_handle : HHandle
                      Handle of the bar code model.

    code_type : MaybeSequence[str]
                Type of the searched bar code.
                Value Suggestion: 'EAN-13'

    row : MaybeSequence[Union[int, float]]
          Row index of the center.
          Value Suggestion: 50.0

    column : MaybeSequence[Union[int, float]]
             Column index of the center.
             Value Suggestion: 100.0

    phi : MaybeSequence[Union[int, float]]
          Orientation of rectangle in radians.
          Value Suggestion: 0.0

    length_1 : MaybeSequence[Union[int, float]]
               Half of the length of the rectangle along the reading
               direction of the bar code.
               Value Suggestion: 200.0

    length_2 : MaybeSequence[Union[int, float]]
               Half of the length of the rectangle perpendicular to the
               reading direction of the bar code.
               Value Suggestion: 100.0

    Returns
    -------

    decoded_data_strings : str
                           Data strings of all successfully decoded bar
                           codes.

    See Also
    --------
    gen_rectangle2

    Alternatives
    ------------
    find_bar_code

    Predecessors
    ------------
    create_bar_code_model, set_bar_code_param, smallest_rectangle2

    Successors
    ----------
    get_bar_code_result, get_bar_code_object, clear_bar_code_model
    """
    with HalconOperator(1992) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, bar_code_handle)
        proc.set_input_tuple(1, code_type)
        proc.set_input_tuple(2, row)
        proc.set_input_tuple(3, column)
        proc.set_input_tuple(4, phi)
        proc.set_input_tuple(5, length_1)
        proc.set_input_tuple(6, length_2)
        proc.init_oct(0)
        proc.execute()
        decoded_data_strings = proc.get_output_tuple_s(0)
        return decoded_data_strings  # type: ignore


def decode_structured_light_pattern(
    camera_images: HObject,
    structured_light_model: HHandle
) -> None:
    """
    Decode the camera images acquired with a structured light setup.

    Parameters
    ----------

    camera_images : HObject
                    Acquired camera images.

    structured_light_model : HHandle
                             Handle of the structured light model.

    See Also
    --------
    create_structured_light_model, set_structured_light_model_param

    Predecessors
    ------------
    gen_structured_light_pattern

    Successors
    ----------
    get_structured_light_object
    """
    with HalconOperator(2108) as proc:
        proc.set_input_object(1, camera_images)
        proc.set_input_tuple(0, structured_light_model)
        proc.execute()


def decompose2(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject]:
    """
    Convert a two-channel image into two images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    See Also
    --------
    compose2

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1132) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2))   # image_2
        )  # type: ignore


def decompose3(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject, HObject]:
    """
    Convert a three-channel image into three images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    image_3 : HObject
              Output image 3.

    See Also
    --------
    compose3

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1131) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2)),  # image_2
            HObject(proc.get_output_object_key(3))   # image_3
        )  # type: ignore


def decompose4(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject, HObject, HObject]:
    """
    Convert a four-channel image into four images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    image_3 : HObject
              Output image 3.

    image_4 : HObject
              Output image 4.

    See Also
    --------
    compose4

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1130) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2)),  # image_2
            HObject(proc.get_output_object_key(3)),  # image_3
            HObject(proc.get_output_object_key(4))   # image_4
        )  # type: ignore


def decompose5(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject, HObject, HObject, HObject]:
    """
    Convert a five-channel image into five images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    image_3 : HObject
              Output image 3.

    image_4 : HObject
              Output image 4.

    image_5 : HObject
              Output image 5.

    See Also
    --------
    compose5

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1129) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2)),  # image_2
            HObject(proc.get_output_object_key(3)),  # image_3
            HObject(proc.get_output_object_key(4)),  # image_4
            HObject(proc.get_output_object_key(5))   # image_5
        )  # type: ignore


def decompose6(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject, HObject, HObject, HObject, HObject]:
    """
    Convert a six-channel image into six images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    image_3 : HObject
              Output image 3.

    image_4 : HObject
              Output image 4.

    image_5 : HObject
              Output image 5.

    image_6 : HObject
              Output image 6.

    See Also
    --------
    compose6

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1128) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2)),  # image_2
            HObject(proc.get_output_object_key(3)),  # image_3
            HObject(proc.get_output_object_key(4)),  # image_4
            HObject(proc.get_output_object_key(5)),  # image_5
            HObject(proc.get_output_object_key(6))   # image_6
        )  # type: ignore


def decompose7(
    multi_channel_image: HObject
) -> Tuple[HObject, HObject, HObject, HObject, HObject, HObject, HObject]:
    """
    Convert a seven-channel image into seven images.

    Parameters
    ----------

    multi_channel_image : HObject
                          Multi-channel image.

    Returns
    -------

    image_1 : HObject
              Output image 1.

    image_2 : HObject
              Output image 2.

    image_3 : HObject
              Output image 3.

    image_4 : HObject
              Output image 4.

    image_5 : HObject
              Output image 5.

    image_6 : HObject
              Output image 6.

    image_7 : HObject
              Output image 7.

    See Also
    --------
    compose7

    Alternatives
    ------------
    access_channel, image_to_channels

    Predecessors
    ------------
    count_channels

    Successors
    ----------
    disp_image
    """
    with HalconOperator(1127) as proc:
        proc.set_input_object(1, multi_channel_image)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # image_1
            HObject(proc.get_output_object_key(2)),  # image_2
            HObject(proc.get_output_object_key(3)),  # image_3
            HObject(proc.get_output_object_key(4)),  # image_4
            HObject(proc.get_output_object_key(5)),  # image_5
            HObject(proc.get_output_object_key(6)),  # image_6
            HObject(proc.get_output_object_key(7))   # image_7
        )  # type: ignore


def decompose_matrix(
    matrix_id: HHandle,
    matrix_type: str
) -> Tuple[HHandle, HHandle]:
    """
    Decompose a matrix.

    Parameters
    ----------

    matrix_id : HHandle
                Matrix handle of the input matrix.

    matrix_type : str
                  Type of the input matrix.
                  Value Suggestion: general

    Returns
    -------

    matrix_1id : HHandle
                 Matrix handle with the output matrix 1.

    matrix_2id : HHandle
                 Matrix handle with the output matrix 2.

    Alternatives
    ------------
    orthogonal_decompose_matrix, solve_matrix

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix

    Notes
    -----
    For MatrixType = 'symmetric' or 'positive_definite', the upper
    triangular part of the input Matrix must contain the relevant
    information of the matrix. The strictly lower triangular part of the
    matrix is not referenced. For MatrixType = 'tridiagonal', only the
    main diagonal, the superdiagonal, and the subdiagonal of the input
    Matrix are used.  The other parts of the matrix are not referenced.
    If the referenced part of the input Matrix is not of the specified
    type, an exception is raised.
    """
    with HalconOperator(845) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.set_input_tuple(1, matrix_type)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # matrix_1id
            proc.get_output_tuple_s(1)   # matrix_2id
        )  # type: ignore


def delete_file(file_name: str) -> None:
    """
    Delete a file.

    Parameters
    ----------

    file_name : str
                File to be deleted.
    """
    with HalconOperator(1644) as proc:
        proc.set_input_tuple(0, file_name)
        proc.execute()


def depth_from_focus(
    multi_focus_image: HObject,
    filter: MaybeSequence[Union[str, int]],
    selection: MaybeSequence[str]
) -> Tuple[HObject, HObject]:
    """
    Extract depth using multiple focus levels.

    Parameters
    ----------

    multi_focus_image : HObject
                        Multichannel gray image consisting of multiple
                        focus levels.

    filter : MaybeSequence[Union[str, int]]
             Filter used to find sharp pixels.
             Value Suggestion: highpass

    selection : MaybeSequence[str]
                Method used to find sharp pixels.
                Value Suggestion: next_maximum

    Returns
    -------

    depth : HObject
            Depth image.

    confidence : HObject
                 Confidence of depth estimation.

    See Also
    --------
    count_channels

    Predecessors
    ------------
    compose2, compose3, compose4, add_channels, read_image, read_sequence

    Successors
    ----------
    select_grayvalues_from_channels, mean_image, binomial_filter,
    gauss_filter, threshold

    Notes
    -----
    If MultiFocusImage contains more than 255 channels (focus levels),
    Depth is clipped at 255, i.e. depth values higher than 255 are
    ignored.
    If the filter mask for Filter is specified with even values, the
    routine uses the next larger odd values instead (this way the center
    of the filter mask is always explicitly determined).
    If Selection is set to 'local' and Filter is set to 'highpass' or
    'bandpass', depth_from_focus can be executed on OpenCL devices. If
    smoothing is enabled, the same restrictions and limitations as for
    mean_image apply.
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1480) as proc:
        proc.set_input_object(1, multi_focus_image)
        proc.set_input_tuple(0, filter)
        proc.set_input_tuple(1, selection)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # depth
            HObject(proc.get_output_object_key(2))   # confidence
        )  # type: ignore


def dequeue_message(
    queue_handle: HHandle,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> Sequence[HHandle]:
    """
    Receive one or more messages from the message queue.

    Parameters
    ----------

    queue_handle : HHandle
                   Message queue handle.
                   Assertion: QueueHandle != 0

    gen_param_name : MaybeSequence[str]
                     Names of optional generic parameters
                     Value Suggestion: timeout

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Values of optional generic parameters
                      Value Suggestion: infinite

    Returns
    -------

    message_handle : Sequence[HHandle]
                     Handle(s) of the dequeued message(s).
                     Assertion: MessageHandle != 0

    See Also
    --------
    create_message_queue, clear_message_queue, enqueue_message,
    set_message_queue_param, get_message_queue_param, create_message,
    clear_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj

    Successors
    ----------
    get_message_tuple, get_message_obj, get_message_param
    """
    with HalconOperator(530) as proc:
        proc.set_input_tuple(0, queue_handle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        message_handle = proc.get_output_tuple_m(0)
        return message_handle  # type: ignore


def dequeue_message_s(
    queue_handle: HHandle,
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> HHandle:
    """
    Receive one or more messages from the message queue.

    Parameters
    ----------

    queue_handle : HHandle
                   Message queue handle.
                   Assertion: QueueHandle != 0

    gen_param_name : MaybeSequence[str]
                     Names of optional generic parameters
                     Value Suggestion: timeout

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Values of optional generic parameters
                      Value Suggestion: infinite

    Returns
    -------

    message_handle : HHandle
                     Handle(s) of the dequeued message(s).
                     Assertion: MessageHandle != 0

    See Also
    --------
    create_message_queue, clear_message_queue, enqueue_message,
    set_message_queue_param, get_message_queue_param, create_message,
    clear_message, set_message_tuple, get_message_tuple, set_message_obj,
    get_message_obj

    Successors
    ----------
    get_message_tuple, get_message_obj, get_message_param
    """
    with HalconOperator(530) as proc:
        proc.set_input_tuple(0, queue_handle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        message_handle = proc.get_output_tuple_s(0)
        return message_handle  # type: ignore


def derivate_funct_1d(
    function: Sequence[Union[float, int]],
    mode: str
) -> Sequence[Union[float, int]]:
    """
    Calculate the derivatives of a function.

    Parameters
    ----------

    function : Sequence[Union[float, int]]
               Input function

    mode : str
           Type of derivative
           Value Suggestion: first

    Returns
    -------

    derivative : Sequence[Union[float, int]]
                 Derivative of the input function

    Predecessors
    ------------
    create_funct_1d_pairs, create_funct_1d_array, smooth_funct_1d_gauss,
    smooth_funct_1d_mean
    """
    with HalconOperator(1379) as proc:
        proc.set_input_tuple(0, function)
        proc.set_input_tuple(1, mode)
        proc.init_oct(0)
        proc.execute()
        derivative = proc.get_output_tuple_m(0)
        return derivative  # type: ignore


def derivate_gauss(
    image: HObject,
    sigma: MaybeSequence[float],
    component: str
) -> HObject:
    """
    Convolve an image with derivatives of the Gaussian.

    Parameters
    ----------

    image : HObject
            Input images.

    sigma : MaybeSequence[float]
            Sigma of the Gaussian.
            Value Suggestion: 1.0
            Assertion: 0.01 <= Sigma <= 50.0

    component : str
                Derivative or feature to be calculated.
                Value Suggestion: x

    Returns
    -------

    deriv_gauss : HObject
                  Filtered result images.

    See Also
    --------
    zero_crossing, dual_threshold

    Alternatives
    ------------
    laplace, laplace_of_gauss, binomial_filter, gauss_filter,
    smooth_image, isotropic_diffusion

    Successors
    ----------
    zero_crossing, dual_threshold

    Notes
    -----
    Besides the pure C version there are specific implementations of
    derivate_gauss for speed up. Such an optimization is applied in case
    it is supported by the system and the respective system parameter
    *_enable is set to 'true', see set_system. The following optimizations
    are supported (listed according to their priority): itemize - using
    AVX512f instructions ('avx512f_enable') - using AVX instructions
    ('avx_enable') - using SSE2 instructions ('sse2_enable') itemize These
    implementations are slightly inaccurate compared to the pure C version
    due to numerical issues. For example, using SSE2 instructions the
    inaccuracy is in order of magnitude of $1.0e-5$ for 'byte' images and
    Component set to 'none', 'x', or 'y'.
    In case accuracy is preferred over performance, set all corresponding
    system parameter to 'false' (using set_system) before calling
    derivate_gauss. This way derivate_gauss does not use the
    accelerations. Do not forget to set the parameter back to 'true'
    afterwards.
    derivate_gauss is only executed on an OpenCL device if Sigma induces a
    filter width respectively height of up to 129 pixels. This corresponds
    to a Sigma of less than $20.7$ for Component = 'none'. The OpenCL
    implementation is slightly inaccurate compared to the pure C version
    due to numerical issues.
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1570) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, component)
        proc.execute()
        deriv_gauss = HObject(proc.get_output_object_key(1))
        return deriv_gauss  # type: ignore


def derivate_vector_field(
    vector_field: HObject,
    sigma: MaybeSequence[float],
    component: str
) -> HObject:
    """
    Convolve a vector field with derivatives of the Gaussian.

    Parameters
    ----------

    vector_field : HObject
                   Input vector field.

    sigma : MaybeSequence[float]
            Sigma of the Gaussian.
            Value Suggestion: 1.0
            Assertion: 0.01 <= Sigma <= 50.0

    component : str
                Component to be calculated.
                Value Suggestion: mean_curvature

    Returns
    -------

    result : HObject
             Filtered result images.

    Predecessors
    ------------
    optical_flow_mg, photometric_stereo

    Successors
    ----------
    threshold
    """
    with HalconOperator(1484) as proc:
        proc.set_input_object(1, vector_field)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, component)
        proc.execute()
        result = HObject(proc.get_output_object_key(1))
        return result  # type: ignore


def descript_class_box(
    classif_handle: HHandle,
    dimensions: int
) -> Tuple[Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[int]]:
    """
    Describe the classes of a box classifier.

    Parameters
    ----------

    classif_handle : HHandle
                     Handle of the classifier.

    dimensions : int
                 Highest dimension for output.
                 Value Suggestion: 3

    Returns
    -------

    class_idx : Sequence[int]
                Indices of the classes.

    box_idx : Sequence[int]
              Indices of the boxes.

    box_lower_bound : Sequence[int]
                      Lower bounds of the boxes (for each dimension).

    box_higher_bound : Sequence[int]
                       Higher bounds of the boxes (for each dimension).

    box_num_samples_train : Sequence[int]
                            Number of training samples that were used to
                            define this box (for each dimension).

    box_num_samples_wrong : Sequence[int]
                            Number of training samples that were assigned
                            incorrectly to the box.

    See Also
    --------
    create_class_box, enquire_class_box, learn_class_box, read_class_box,
    write_class_box

    Predecessors
    ------------
    create_class_box, learn_class_box, set_class_box_param

    Successors
    ----------
    enquire_class_box, learn_class_box, write_class_box, close_class_box

    Warnings
    --------
    descript_class_box is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the MLP, SVM, KNN
    or GMM operators instead.
    """
    with HalconOperator(1896) as proc:
        proc.set_input_tuple(0, classif_handle)
        proc.set_input_tuple(1, dimensions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_idx
            proc.get_output_tuple_m(1),  # box_idx
            proc.get_output_tuple_m(2),  # box_lower_bound
            proc.get_output_tuple_m(3),  # box_higher_bound
            proc.get_output_tuple_m(4),  # box_num_samples_train
            proc.get_output_tuple_m(5)   # box_num_samples_wrong
        )  # type: ignore


def descript_class_box_s(
    classif_handle: HHandle,
    dimensions: int
) -> Tuple[int, int, int, int, int, int]:
    """
    Describe the classes of a box classifier.

    Parameters
    ----------

    classif_handle : HHandle
                     Handle of the classifier.

    dimensions : int
                 Highest dimension for output.
                 Value Suggestion: 3

    Returns
    -------

    class_idx : int
                Indices of the classes.

    box_idx : int
              Indices of the boxes.

    box_lower_bound : int
                      Lower bounds of the boxes (for each dimension).

    box_higher_bound : int
                       Higher bounds of the boxes (for each dimension).

    box_num_samples_train : int
                            Number of training samples that were used to
                            define this box (for each dimension).

    box_num_samples_wrong : int
                            Number of training samples that were assigned
                            incorrectly to the box.

    See Also
    --------
    create_class_box, enquire_class_box, learn_class_box, read_class_box,
    write_class_box

    Predecessors
    ------------
    create_class_box, learn_class_box, set_class_box_param

    Successors
    ----------
    enquire_class_box, learn_class_box, write_class_box, close_class_box

    Warnings
    --------
    descript_class_box is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the MLP, SVM, KNN
    or GMM operators instead.
    """
    with HalconOperator(1896) as proc:
        proc.set_input_tuple(0, classif_handle)
        proc.set_input_tuple(1, dimensions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.init_oct(5)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_idx
            proc.get_output_tuple_s(1),  # box_idx
            proc.get_output_tuple_s(2),  # box_lower_bound
            proc.get_output_tuple_s(3),  # box_higher_bound
            proc.get_output_tuple_s(4),  # box_num_samples_train
            proc.get_output_tuple_s(5)   # box_num_samples_wrong
        )  # type: ignore


def deserialize_bar_code_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a bar code model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    bar_code_handle : HHandle
                      Handle of the bar code model.

    See Also
    --------
    serialize_bar_code_model, clear_bar_code_model

    Alternatives
    ------------
    create_bar_code_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_bar_code_model

    Successors
    ----------
    find_bar_code
    """
    with HalconOperator(1986) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        bar_code_handle = proc.get_output_tuple_s(0)
        return bar_code_handle  # type: ignore


def deserialize_calib_data(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized calibration data model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    calib_data_id : HHandle
                    Handle of a calibration data model.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_calib_data
    """
    with HalconOperator(1961) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        calib_data_id = proc.get_output_tuple_s(0)
        return calib_data_id  # type: ignore


def deserialize_cam_par(
    serialized_item_handle: HHandle
) -> Sequence[Union[int, float, str]]:
    """
    Deserialize the serialized internal camera parameters.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_cam_par
    """
    with HalconOperator(1936) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        camera_param = proc.get_output_tuple_m(0)
        return camera_param  # type: ignore


def deserialize_camera_setup_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized camera setup model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    camera_setup_model_id : HHandle
                            Handle to the camera setup model.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_camera_setup_model
    """
    with HalconOperator(1952) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        camera_setup_model_id = proc.get_output_tuple_s(0)
        return camera_setup_model_id  # type: ignore


def deserialize_class_box(
    classif_handle: HHandle,
    serialized_item_handle: HHandle
) -> None:
    """
    Deserialize a serialized classifier.

    Parameters
    ----------

    classif_handle : HHandle
                     Handle of the classifier.

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    See Also
    --------
    create_class_box, serialize_class_box

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_class_box,
    create_class_box

    Successors
    ----------
    test_sampset_box, enquire_class_box, write_class_box, close_class_box,
    clear_sampset

    Warnings
    --------
    deserialize_class_box is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the MLP, SVM, KNN
    or GMM operators instead.

    Notes
    -----
    All values of the classifier are going to be overwritten.
    """
    with HalconOperator(1884) as proc:
        proc.set_input_tuple(0, classif_handle)
        proc.set_input_tuple(1, serialized_item_handle)
        proc.execute()


def deserialize_class_gmm(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized Gaussian Mixture Model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    gmmhandle : HHandle
                GMM handle.

    See Also
    --------
    create_class_gmm, write_class_gmm, serialize_class_gmm

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_class_gmm

    Successors
    ----------
    classify_class_gmm, evaluate_class_gmm, create_class_lut_gmm
    """
    with HalconOperator(1826) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        gmmhandle = proc.get_output_tuple_s(0)
        return gmmhandle  # type: ignore


def deserialize_class_knn(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized k-NN classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    knnhandle : HHandle
                Handle of the k-NN classifier.

    See Also
    --------
    create_class_knn

    Alternatives
    ------------
    serialize_class_knn

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_class_knn

    Successors
    ----------
    classify_class_knn
    """
    with HalconOperator(1807) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        knnhandle = proc.get_output_tuple_s(0)
        return knnhandle  # type: ignore


def deserialize_class_mlp(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized multilayer perceptron.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    mlphandle : HHandle
                MLP handle.

    See Also
    --------
    create_class_mlp, write_class_mlp, serialize_class_mlp

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_class_mlp

    Successors
    ----------
    classify_class_mlp, evaluate_class_mlp, create_class_lut_mlp
    """
    with HalconOperator(1865) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        mlphandle = proc.get_output_tuple_s(0)
        return mlphandle  # type: ignore


def deserialize_class_svm(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized support vector machine (SVM).

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    svmhandle : HHandle
                SVM handle.

    See Also
    --------
    create_class_svm, write_class_svm, serialize_class_svm

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_class_svm

    Successors
    ----------
    classify_class_svm, create_class_lut_svm
    """
    with HalconOperator(1844) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        svmhandle = proc.get_output_tuple_s(0)
        return svmhandle  # type: ignore


def deserialize_class_train_data(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize serialized training data for classifiers.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    class_train_data_handle : HHandle
                              Handle of the training data.

    See Also
    --------
    create_class_train_data

    Predecessors
    ------------
    serialize_class_train_data

    Successors
    ----------
    fwrite_serialized_item
    """
    with HalconOperator(1779) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        class_train_data_handle = proc.get_output_tuple_s(0)
        return class_train_data_handle  # type: ignore


def deserialize_component_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized component model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    component_model_id : HHandle
                         Handle of the component model.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_component_model

    Successors
    ----------
    find_component_model
    """
    with HalconOperator(1000) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        component_model_id = proc.get_output_tuple_s(0)
        return component_model_id  # type: ignore


def deserialize_data_code_2d_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized 2D data code model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    data_code_handle : HHandle
                       Handle of the 2D data code model.

    See Also
    --------
    serialize_data_code_2d_model, clear_data_code_2d_model

    Alternatives
    ------------
    create_data_code_2d_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_data_code_2d_model

    Successors
    ----------
    find_data_code_2d
    """
    with HalconOperator(1772) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        data_code_handle = proc.get_output_tuple_s(0)
        return data_code_handle  # type: ignore


def deserialize_deformable_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a deformable model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_planar_uncalib_deformable_model,
    create_planar_calib_deformable_model, create_local_deformable_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_deformable_model

    Successors
    ----------
    find_planar_uncalib_deformable_model,
    find_planar_calib_deformable_model, find_local_deformable_model
    """
    with HalconOperator(963) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def deserialize_deformable_surface_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a deformable surface model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    deformable_surface_model : HHandle
                               Handle of the deformable surface model.

    See Also
    --------
    create_deformable_surface_model, read_deformable_surface_model,
    write_deformable_surface_model, serialize_deformable_surface_model

    Alternatives
    ------------
    create_deformable_surface_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_deformable_surface_model

    Successors
    ----------
    find_deformable_surface_model, refine_deformable_surface_model,
    get_deformable_surface_model_param, clear_deformable_surface_model
    """
    with HalconOperator(1022) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        deformable_surface_model = proc.get_output_tuple_s(0)
        return deformable_surface_model  # type: ignore


def deserialize_descriptor_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a descriptor model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_calib_descriptor_model, create_uncalib_descriptor_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_descriptor_model

    Successors
    ----------
    find_uncalib_descriptor_model, find_calib_descriptor_model
    """
    with HalconOperator(944) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def deserialize_distance_transform_xld(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize an XLD distance transform.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized XLD distance
                             transform.

    Returns
    -------

    distance_transform_id : HHandle
                            Handle of the deserialized XLD distance
                            transform.

    See Also
    --------
    serialize_distance_transform_xld, write_distance_transform_xld,
    read_distance_transform_xld, create_distance_transform_xld,
    set_distance_transform_xld_param, clear_distance_transform_xld

    Successors
    ----------
    apply_distance_transform_xld, get_distance_transform_xld_contour,
    get_distance_transform_xld_param
    """
    with HalconOperator(1354) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        distance_transform_id = proc.get_output_tuple_s(0)
        return distance_transform_id  # type: ignore


def deserialize_dl_classifier(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a deep-learning-based classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    dlclassifier_handle : HHandle
                          Handle of the deep-learning-based classifier.

    See Also
    --------
    serialize_dl_classifier

    Alternatives
    ------------
    deserialize_dl_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_dl_classifier

    Successors
    ----------
    apply_dl_classifier, train_dl_classifier_batch,
    set_dl_classifier_param, get_dl_classifier_param

    Warnings
    --------
    deserialize_dl_classifier is obsolete and is only provided for reasons
    of backward compatibility.  New applications should use the common
    CNN-based operator deserialize_dl_model.
    """
    with HalconOperator(2109) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        dlclassifier_handle = proc.get_output_tuple_s(0)
        return dlclassifier_handle  # type: ignore


def deserialize_dl_model(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a deep learning model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    dlmodel_handle : HHandle
                     Handle of the deep learning model.

    See Also
    --------
    serialize_dl_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_dl_model

    Successors
    ----------
    apply_dl_model, train_dl_model_batch, train_dl_model_anomaly_dataset,
    set_dl_model_param, get_dl_model_param
    """
    with HalconOperator(2151) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        dlmodel_handle = proc.get_output_tuple_s(0)
        return dlmodel_handle  # type: ignore


def deserialize_dual_quat(
    serialized_item_handle: HHandle
) -> Sequence[Union[float, int]]:
    """
    Deserialize a serialized dual quaternion.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    dual_quaternion : Sequence[Union[float, int]]
                      Dual quaternion.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_quat

    Successors
    ----------
    dual_quat_to_hom_mat3d, dual_quat_to_pose, dual_quat_compose
    """
    with HalconOperator(2052) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        dual_quaternion = proc.get_output_tuple_m(0)
        return dual_quaternion  # type: ignore


def deserialize_fft_optimization_data(
    serialized_item_handle: HHandle
) -> None:
    """
    Deserialize FFT speed optimization data.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    See Also
    --------
    serialize_fft_optimization_data

    Alternatives
    ------------
    optimize_fft_speed, optimize_rft_speed

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_fft_optimization_data

    Successors
    ----------
    fft_generic, fft_image, fft_image_inv, rft_generic, wiener_filter,
    wiener_filter_ni, photometric_stereo, sfs_pentland, sfs_mod_lr,
    sfs_orig_lr
    """
    with HalconOperator(1535) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()


def deserialize_handle(serialized_item: HHandle) -> HHandle:
    """
    Deserialize a serialized item.

    Parameters
    ----------

    serialized_item : HHandle
                      Handle containing the serialized item to be
                      deserialized.

    Returns
    -------

    handle : HHandle
             Handle containing the deserialized item.

    Predecessors
    ------------
    serialize_handle, fread_serialized_item, receive_serialized_item
    """
    with HalconOperator(2135) as proc:
        proc.set_input_tuple(0, serialized_item)
        proc.init_oct(0)
        proc.execute()
        handle = proc.get_output_tuple_s(0)
        return handle  # type: ignore


def deserialize_hom_mat2d(
    serialized_item_handle: HHandle
) -> Sequence[float]:
    """
    Deserialize a serialized homogeneous 2D transformation matrix.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    hom_mat_2d : Sequence[float]
                 Transformation matrix.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_hom_mat2d
    """
    with HalconOperator(235) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        hom_mat_2d = proc.get_output_tuple_m(0)
        return hom_mat_2d  # type: ignore


def deserialize_hom_mat3d(
    serialized_item_handle: HHandle
) -> Sequence[float]:
    """
    Deserialize a serialized homogeneous 3D transformation matrix.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    hom_mat_3d : Sequence[float]
                 Transformation matrix.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_hom_mat3d
    """
    with HalconOperator(233) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        hom_mat_3d = proc.get_output_tuple_m(0)
        return hom_mat_3d  # type: ignore


def deserialize_image(serialized_item_handle: HHandle) -> HObject:
    """
    Deserialize a serialized image object.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    image : HObject
            Image object.

    See Also
    --------
    serialize_image

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_image

    Successors
    ----------
    disp_image, threshold, regiongrowing, count_channels, decompose3,
    class_ndim_norm, gauss_filter, fill_interlace, zoom_image_size,
    zoom_image_factor, crop_part, write_image, rgb1_to_gray
    """
    with HalconOperator(1650) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()
        image = HObject(proc.get_output_object_key(1))
        return image  # type: ignore


def deserialize_matrix(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized matrix.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    matrix_id : HHandle
                Matrix handle.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_matrix

    Successors
    ----------
    get_full_matrix
    """
    with HalconOperator(840) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        matrix_id = proc.get_output_tuple_s(0)
        return matrix_id  # type: ignore


def deserialize_measure(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized measure object.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    measure_handle : HHandle
                     Measure object handle.

    See Also
    --------
    read_measure, write_measure

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_measure

    Successors
    ----------
    measure_pos, measure_pairs
    """
    with HalconOperator(822) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        measure_handle = proc.get_output_tuple_s(0)
        return measure_handle  # type: ignore


def deserialize_metrology_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized metrology model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    metrology_handle : HHandle
                       Handle of the metrology model.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_metrology_model

    Successors
    ----------
    get_metrology_object_param, get_metrology_object_fuzzy_param,
    apply_metrology_model
    """
    with HalconOperator(794) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        metrology_handle = proc.get_output_tuple_s(0)
        return metrology_handle  # type: ignore


def deserialize_ncc_model(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize an NCC model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    See Also
    --------
    create_ncc_model, clear_ncc_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ncc_model

    Successors
    ----------
    find_ncc_model
    """
    with HalconOperator(983) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def deserialize_object(serialized_item_handle: HHandle) -> HObject:
    """
    Deserialize a serialized iconic object.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    object : HObject
             Iconic object.

    See Also
    --------
    serialize_object

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_object
    """
    with HalconOperator(1648) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()
        object = HObject(proc.get_output_object_key(1))
        return object  # type: ignore


def deserialize_object_model_3d(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized 3D object model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    object_model_3d : HHandle
                      Handle of the 3D object model.

    See Also
    --------
    write_object_model_3d, clear_object_model_3d

    Alternatives
    ------------
    xyz_to_object_model_3d

    Predecessors
    ------------
    write_object_model_3d, fread_serialized_item, receive_serialized_item,
    serialize_object_model_3d

    Successors
    ----------
    affine_trans_object_model_3d, object_model_3d_to_xyz,
    prepare_object_model_3d
    """
    with HalconOperator(1102) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        object_model_3d = proc.get_output_tuple_s(0)
        return object_model_3d  # type: ignore


def deserialize_ocr(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized OCR classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocr_handle : HHandle
                 ID of the OCR classifier.

    See Also
    --------
    serialize_ocr, do_ocr_multi, traind_ocr_class_box, trainf_ocr_class_box

    Predecessors
    ------------
    reset_obj_db, fread_serialized_item, receive_serialized_item,
    serialize_ocr

    Successors
    ----------
    do_ocr_multi, do_ocr_single, traind_ocr_class_box, trainf_ocr_class_box

    Warnings
    --------
    deserialize_ocr is obsolete and is only provided for reasons of
    backward compatibility.  New applications should use the MLP, SVM or
    CNN based operators instead.
    """
    with HalconOperator(710) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocr_handle = proc.get_output_tuple_s(0)
        return ocr_handle  # type: ignore


def deserialize_ocr_class_cnn(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized CNN-based OCR classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ocr_class_cnn

    Successors
    ----------
    do_ocr_single_class_cnn, do_ocr_multi_class_cnn
    """
    with HalconOperator(2053) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def deserialize_ocr_class_knn(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized k-NN-based OCR classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    create_ocr_class_knn, serialize_ocr_class_knn

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ocr_class_knn

    Successors
    ----------
    classify_class_knn
    """
    with HalconOperator(648) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def deserialize_ocr_class_mlp(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized MLP-based OCR classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    create_ocr_class_mlp, write_ocr_class_mlp, read_class_mlp,
    write_class_mlp, serialize_ocr_class_mlp

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ocr_class_mlp

    Successors
    ----------
    do_ocr_single_class_mlp, do_ocr_multi_class_mlp
    """
    with HalconOperator(692) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def deserialize_ocr_class_svm(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized SVM-based OCR classifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocrhandle : HHandle
                Handle of the OCR classifier.

    See Also
    --------
    create_ocr_class_svm, write_ocr_class_svm, read_class_svm,
    write_class_svm, serialize_ocr_class_svm

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ocr_class_svm

    Successors
    ----------
    do_ocr_single_class_svm, do_ocr_multi_class_svm
    """
    with HalconOperator(674) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocrhandle = proc.get_output_tuple_s(0)
        return ocrhandle  # type: ignore


def deserialize_ocv(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized OCV tool.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    ocvhandle : HHandle
                Handle of the OCV tool.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_ocv

    Successors
    ----------
    do_ocv_simple, close_ocv
    """
    with HalconOperator(640) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        ocvhandle = proc.get_output_tuple_s(0)
        return ocvhandle  # type: ignore


def deserialize_pose(
    serialized_item_handle: HHandle
) -> Sequence[Union[int, float]]:
    """
    Deserialize a serialized pose.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    pose : Sequence[Union[int, float]]
           3D pose.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_pose
    """
    with HalconOperator(1938) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        pose = proc.get_output_tuple_m(0)
        return pose  # type: ignore


def deserialize_quat(
    serialized_item_handle: HHandle
) -> Sequence[Union[float, int]]:
    """
    Deserialize a serialized quaternion.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    quaternion : Sequence[Union[float, int]]
                 Quaternion.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_quat

    Successors
    ----------
    quat_to_hom_mat3d, quat_to_pose, quat_rotate_point_3d, quat_compose
    """
    with HalconOperator(237) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        quaternion = proc.get_output_tuple_m(0)
        return quaternion  # type: ignore


def deserialize_region(serialized_item_handle: HHandle) -> HObject:
    """
    Deserialize a serialized region.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    region : HObject
             Region.

    See Also
    --------
    serialize_region

    Predecessors
    ------------
    read_image, fread_serialized_item, receive_serialized_item,
    serialize_region

    Successors
    ----------
    reduce_domain, disp_region
    """
    with HalconOperator(1652) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()
        region = HObject(proc.get_output_object_key(1))
        return region  # type: ignore


def deserialize_sample_identifier(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized sample identifier.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    sample_identifier : HHandle
                        Handle of the sample identifier.

    See Also
    --------
    create_sample_identifier, add_sample_identifier_preparation_data,
    prepare_sample_identifier, train_sample_identifier,
    set_sample_identifier_param, get_sample_identifier_param,
    get_sample_identifier_object_info,
    remove_sample_identifier_preparation_data,
    remove_sample_identifier_training_data, write_sample_identifier,
    serialize_sample_identifier, clear_sample_identifier,
    set_sample_identifier_object_info

    Alternatives
    ------------
    read_sample_identifier

    Successors
    ----------
    apply_sample_identifier, add_sample_identifier_training_data
    """
    with HalconOperator(900) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        sample_identifier = proc.get_output_tuple_s(0)
        return sample_identifier  # type: ignore


def deserialize_shape_model(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized shape model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    model_id : HHandle
               Handle of the model.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_shape_model

    Successors
    ----------
    find_generic_shape_model
    """
    with HalconOperator(916) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def deserialize_shape_model_3d(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized 3D shape model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    shape_model_3did : HHandle
                       Handle of the 3D shape model.

    See Also
    --------
    create_shape_model_3d, clear_shape_model_3d

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_shape_model_3d

    Successors
    ----------
    find_shape_model_3d, get_shape_model_3d_params
    """
    with HalconOperator(1050) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        shape_model_3did = proc.get_output_tuple_s(0)
        return shape_model_3did  # type: ignore


def deserialize_sheet_of_light_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a sheet-of-light model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    sheet_of_light_model_id : HHandle
                              Handle of the sheet-of-light model.

    See Also
    --------
    serialize_sheet_of_light_model

    Alternatives
    ------------
    create_sheet_of_light_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_sheet_of_light_model

    Successors
    ----------
    measure_profile_sheet_of_light
    """
    with HalconOperator(376) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        sheet_of_light_model_id = proc.get_output_tuple_s(0)
        return sheet_of_light_model_id  # type: ignore


def deserialize_structured_light_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a structured light model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    structured_light_model : HHandle
                             Handle of the structured light model.

    See Also
    --------
    create_structured_light_model, write_structured_light_model,
    serialize_structured_light_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_structured_light_model
    """
    with HalconOperator(2110) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        structured_light_model = proc.get_output_tuple_s(0)
        return structured_light_model  # type: ignore


def deserialize_surface_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a surface model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    surface_model_id : HHandle
                       Handle of the surface model.

    See Also
    --------
    create_surface_model, read_surface_model, write_surface_model

    Alternatives
    ------------
    create_surface_model

    Predecessors
    ------------
    read_object_model_3d, xyz_to_object_model_3d, fread_serialized_item,
    receive_serialized_item, serialize_surface_model

    Successors
    ----------
    find_surface_model, refine_surface_model_pose,
    get_surface_model_param, clear_surface_model,
    find_surface_model_image, refine_surface_model_pose_image
    """
    with HalconOperator(1037) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        surface_model_id = proc.get_output_tuple_s(0)
        return surface_model_id  # type: ignore


def deserialize_template(serialized_item_handle: HHandle) -> HHandle:
    """
    Deserialize a serialized template.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    template_id : HHandle
                  Template number.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_template

    Successors
    ----------
    adapt_template, set_reference_template, set_offset_template,
    best_match, fast_match, best_match_rot

    Warnings
    --------
    deserialize_template is obsolete and is only provided for reasons of
    backward compatibility. New applications should use the shape-based or
    NCC-based operators instead.
    """
    with HalconOperator(1491) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        template_id = proc.get_output_tuple_s(0)
        return template_id  # type: ignore


def deserialize_texture_inspection_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a serialized texture inspection model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    texture_inspection_model : HHandle
                               Handle of the texture inspection model.

    See Also
    --------
    create_texture_inspection_model, write_texture_inspection_model,
    serialize_texture_inspection_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_texture_inspection_model

    Successors
    ----------
    apply_texture_inspection_model
    """
    with HalconOperator(2054) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        texture_inspection_model = proc.get_output_tuple_s(0)
        return texture_inspection_model  # type: ignore


def deserialize_training_components(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a component training result.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    component_training_id : HHandle
                            Handle of the training result.

    See Also
    --------
    train_model_components, clear_training_components

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_training_components

    Successors
    ----------
    create_trained_component_model
    """
    with HalconOperator(1011) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        component_training_id = proc.get_output_tuple_s(0)
        return component_training_id  # type: ignore


def deserialize_tuple(
    serialized_item_handle: HHandle
) -> Sequence[HTupleElementType]:
    """
    Deserialize a serialized tuple.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    tuple : Sequence[HTupleElementType]
            Tuple.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_tuple
    """
    with HalconOperator(217) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        tuple = proc.get_output_tuple_m(0)
        return tuple  # type: ignore


def deserialize_tuple_s(
    serialized_item_handle: HHandle
) -> HTupleElementType:
    """
    Deserialize a serialized tuple.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    tuple : HTupleElementType
            Tuple.

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item, serialize_tuple
    """
    with HalconOperator(217) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        tuple = proc.get_output_tuple_s(0)
        return tuple  # type: ignore


def deserialize_variation_model(
    serialized_item_handle: HHandle
) -> HHandle:
    """
    Deserialize a variation model.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    model_id : HHandle
               ID of the variation model.

    See Also
    --------
    read_variation_model, write_variation_model

    Predecessors
    ------------
    fread_serialized_item, receive_serialized_item,
    serialize_variation_model

    Successors
    ----------
    compare_variation_model, compare_ext_variation_model
    """
    with HalconOperator(81) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.init_oct(0)
        proc.execute()
        model_id = proc.get_output_tuple_s(0)
        return model_id  # type: ignore


def deserialize_xld(serialized_item_handle: HHandle) -> HObject:
    """
    Deserialize a serialized XLD object.

    Parameters
    ----------

    serialized_item_handle : HHandle
                             Handle of the serialized item.

    Returns
    -------

    xld : HObject
          XLD object.

    See Also
    --------
    serialize_xld

    Predecessors
    ------------
    read_image, fread_serialized_item, receive_serialized_item,
    serialize_xld

    Successors
    ----------
    clip_contours_xld, split_contours_xld
    """
    with HalconOperator(1632) as proc:
        proc.set_input_tuple(0, serialized_item_handle)
        proc.execute()
        xld = HObject(proc.get_output_object_key(1))
        return xld  # type: ignore


def detach_background_from_window(window_handle: HHandle) -> None:
    """
    Detach the background image from a HALCON window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    Predecessors
    ------------
    attach_background_to_window
    """
    with HalconOperator(1163) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def detach_drawing_object_from_window(
    window_handle: HHandle,
    draw_handle: HHandle
) -> None:
    """
    Detach an existing drawing object from a HALCON window.

    Parameters
    ----------

    window_handle : HHandle
                    Window Handle.

    draw_handle : HHandle
                  Handle of the drawing object.

    See Also
    --------
    attach_drawing_object_to_window

    Predecessors
    ------------
    attach_drawing_object_to_window, get_drawing_object_iconic,
    get_drawing_object_params

    Successors
    ----------
    close_window, clear_drawing_object
    """
    with HalconOperator(1165) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, draw_handle)
        proc.execute()


def detect_edge_segments(
    image: HObject,
    sobel_size: int,
    min_amplitude: int,
    max_distance: int,
    min_length: int
) -> Tuple[Sequence[int], Sequence[int], Sequence[int], Sequence[int]]:
    """
    Detect straight edge segments.

    Parameters
    ----------

    image : HObject
            Input image.

    sobel_size : int
                 Mask size of the Sobel operator.
                 Value Suggestion: 5

    min_amplitude : int
                    Minimum edge strength.
                    Value Suggestion: 32
                    Assertion: MinAmplitude >= 0

    max_distance : int
                   Maximum distance of the approximating line to its
                   original edge.
                   Value Suggestion: 3
                   Assertion: MaxDistance >= 0

    min_length : int
                 Minimum length of to resulting line segments.
                 Value Suggestion: 10
                 Assertion: MinLength >= 0

    Returns
    -------

    begin_row : Sequence[int]
                Row coordinate of the line segments' start points.

    begin_col : Sequence[int]
                Column coordinate of the line segments' start points.

    end_row : Sequence[int]
              Row coordinate of the line segments' end points.

    end_col : Sequence[int]
              Column coordinate of the line segments' end points.

    Alternatives
    ------------
    sobel_amp, threshold, skeleton

    Predecessors
    ------------
    sigma_image, median_image

    Successors
    ----------
    partition_lines, line_position, line_orientation

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1575) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sobel_size)
        proc.set_input_tuple(1, min_amplitude)
        proc.set_input_tuple(2, max_distance)
        proc.set_input_tuple(3, min_length)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # begin_row
            proc.get_output_tuple_m(1),  # begin_col
            proc.get_output_tuple_m(2),  # end_row
            proc.get_output_tuple_m(3)   # end_col
        )  # type: ignore


def determinant_matrix(matrix_id: HHandle, matrix_type: str) -> float:
    """
    Compute the determinant of a matrix.

    Parameters
    ----------

    matrix_id : HHandle
                Matrix handle of the input matrix.

    matrix_type : str
                  The type of the input matrix.
                  Value Suggestion: general

    Returns
    -------

    value : float
            Determinant of the input matrix.

    Predecessors
    ------------
    create_matrix

    Notes
    -----
    For MatrixType = 'symmetric', 'positive_definite', or
    'upper_triangular' the upper triangular part of the input Matrix must
    contain the relevant information of the matrix.  The strictly lower
    triangular part of the matrix is not referenced.  For MatrixType =
    'lower_triangular' the lower triangular part of the input Matrix must
    contain the relevant information of the matrix.  The strictly upper
    triangular part of the matrix is not referenced.  For MatrixType =
    'tridiagonal', only the main diagonal, the superdiagonal, and the
    subdiagonal of the input Matrix are used.  The other parts of the
    matrix are not referenced.  If the referenced part of the input Matrix
    is not of the specified type, an exception is raised.
    """
    with HalconOperator(852) as proc:
        proc.set_input_tuple(0, matrix_id)
        proc.set_input_tuple(1, matrix_type)
        proc.init_oct(0)
        proc.execute()
        value = proc.get_output_tuple_s(0)
        return value  # type: ignore


def determine_deformable_model_params(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    scale_min: MaybeSequence[float],
    scale_max: MaybeSequence[float],
    optimization: str,
    metric: str,
    contrast: MaybeSequence[Union[int, str]],
    min_contrast: Union[int, str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[int, float, str]],
    parameters: MaybeSequence[str]
) -> Tuple[Sequence[str], Sequence[Union[int, float]]]:
    """
    Determine the parameters of a deformable model.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    scale_min : MaybeSequence[float]
                Minimum scale of the model.
                Value Suggestion: 0.9
                Assertion: ScaleMin > 0

    scale_max : MaybeSequence[float]
                Maximum scale of the model.
                Value Suggestion: 1.1
                Assertion: ScaleMax >= ScaleMin

    optimization : str
                   Kind of optimization.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : MaybeSequence[Union[int, str]]
               Threshold or hysteresis thresholds for the contrast of the
               object in the template image and optionally minimum size of
               the object parts.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    gen_param_name : Sequence[str]
                     The general parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[int, float, str]]
                      Values of the general parameter.
                      Value Suggestion: []

    parameters : MaybeSequence[str]
                 Parameters to be determined automatically.
                 Value Suggestion: all

    Returns
    -------

    parameter_name : Sequence[str]
                     Name of the automatically determined parameter.

    parameter_value : Sequence[Union[int, float]]
                      Value of the automatically determined parameter.

    See Also
    --------
    find_planar_uncalib_deformable_model,
    find_planar_calib_deformable_model

    Successors
    ----------
    create_planar_uncalib_deformable_model,
    create_planar_calib_deformable_model, create_local_deformable_model
    """
    with HalconOperator(962) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, scale_min)
        proc.set_input_tuple(4, scale_max)
        proc.set_input_tuple(5, optimization)
        proc.set_input_tuple(6, metric)
        proc.set_input_tuple(7, contrast)
        proc.set_input_tuple(8, min_contrast)
        proc.set_input_tuple(9, gen_param_name)
        proc.set_input_tuple(10, gen_param_value)
        proc.set_input_tuple(11, parameters)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # parameter_name
            proc.get_output_tuple_m(1)   # parameter_value
        )  # type: ignore


def determine_ncc_model_params(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    metric: str,
    parameters: MaybeSequence[str]
) -> Tuple[Sequence[str], Sequence[Union[int, float]]]:
    """
    Determine the parameters of an NCC model.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    parameters : MaybeSequence[str]
                 Parameters to be determined automatically.
                 Value Suggestion: all

    Returns
    -------

    parameter_name : Sequence[str]
                     Name of the automatically determined parameter.

    parameter_value : Sequence[Union[int, float]]
                      Value of the automatically determined parameter.

    See Also
    --------
    find_ncc_model

    Successors
    ----------
    create_ncc_model
    """
    with HalconOperator(987) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, metric)
        proc.set_input_tuple(4, parameters)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # parameter_name
            proc.get_output_tuple_m(1)   # parameter_value
        )  # type: ignore


def determine_shape_model_params(
    template: HObject,
    num_levels: Union[int, str],
    angle_start: float,
    angle_extent: float,
    scale_min: MaybeSequence[float],
    scale_max: MaybeSequence[float],
    optimization: str,
    metric: str,
    contrast: MaybeSequence[Union[int, str]],
    min_contrast: Union[int, str],
    parameters: MaybeSequence[str]
) -> Tuple[Sequence[str], Sequence[Union[int, float]]]:
    """
    Determine the parameters of a shape model.

    Parameters
    ----------

    template : HObject
               Input image whose domain will be used to create the model.

    num_levels : Union[int, str]
                 Maximum number of pyramid levels.
                 Value Suggestion: auto

    angle_start : float
                  Smallest rotation of the model.
                  Value Suggestion: -0.39

    angle_extent : float
                   Extent of the rotation angles.
                   Value Suggestion: 0.79
                   Assertion: AngleExtent >= 0

    scale_min : MaybeSequence[float]
                Minimum scale of the model.
                Value Suggestion: 0.9
                Assertion: ScaleMin > 0

    scale_max : MaybeSequence[float]
                Maximum scale of the model.
                Value Suggestion: 1.1
                Assertion: ScaleMax >= ScaleMin

    optimization : str
                   Kind of optimization.
                   Value Suggestion: auto

    metric : str
             Match metric.
             Value Suggestion: use_polarity

    contrast : MaybeSequence[Union[int, str]]
               Threshold or hysteresis thresholds for the contrast of the
               object in the template image and optionally minimum size of
               the object parts.
               Value Suggestion: auto

    min_contrast : Union[int, str]
                   Minimum contrast of the objects in the search images.
                   Value Suggestion: auto
                   Assertion: MinContrast < Contrast

    parameters : MaybeSequence[str]
                 Parameters to be determined automatically.
                 Value Suggestion: all

    Returns
    -------

    parameter_name : Sequence[str]
                     Name of the automatically determined parameter.

    parameter_value : Sequence[Union[int, float]]
                      Value of the automatically determined parameter.

    Predecessors
    ------------
    draw_region, reduce_domain, threshold

    Successors
    ----------
    create_generic_shape_model

    Notes
    -----
    In some cases, the maximum number of pyramid levels that is returned
    by determine_shape_model_params is higher than the number of levels
    that are actually used in the shape model.  The latter can be queried
    by using get_shape_model_params after creating the model. This might
    happen if the model is created by using create_scaled_shape_model or
    create_aniso_shape_model and ScaleMin, ScaleRMin, or ScaleCMin is
    below 1.0.
    """
    with HalconOperator(923) as proc:
        proc.set_input_object(1, template)
        proc.set_input_tuple(0, num_levels)
        proc.set_input_tuple(1, angle_start)
        proc.set_input_tuple(2, angle_extent)
        proc.set_input_tuple(3, scale_min)
        proc.set_input_tuple(4, scale_max)
        proc.set_input_tuple(5, optimization)
        proc.set_input_tuple(6, metric)
        proc.set_input_tuple(7, contrast)
        proc.set_input_tuple(8, min_contrast)
        proc.set_input_tuple(9, parameters)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # parameter_name
            proc.get_output_tuple_m(1)   # parameter_value
        )  # type: ignore


def deviation_image(image: HObject, width: int, height: int) -> HObject:
    """
    Calculate the standard deviation of gray values within rectangular
    windows.

    Parameters
    ----------

    image : HObject
            Image for which the standard deviation is to be calculated.

    width : int
            Width of the mask in which the standard deviation is
            calculated.
            Value Suggestion: 11
            Assertion: 3 <= Width && odd(Width) && Width < width(Image) * 2

    height : int
             Height of the mask in which the standard deviation is
             calculated.
             Value Suggestion: 11
             Assertion: 3 <= Height && odd(Height) && Height < height(Image) * 2

    Returns
    -------

    image_deviation : HObject
                      Image containing the standard deviation.

    See Also
    --------
    convol_image, texture_laws, intensity

    Alternatives
    ------------
    entropy_image, entropy_gray

    Successors
    ----------
    disp_image

    Notes
    -----
    deviation_image can be executed on OpenCL devices. As the same OpenCL
    code is used, the same limitations as for mean_image apply. Since
    deviation_image uses single precision floating point arithmetic
    internally, the results may differ slightly from the CPU version.
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1403) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, height)
        proc.execute()
        image_deviation = HObject(proc.get_output_object_key(1))
        return image_deviation  # type: ignore


def deviation_n(image: HObject) -> HObject:
    """
    Calculate standard deviation over several channels.

    Parameters
    ----------

    image : HObject
            Multichannel gray image.

    Returns
    -------

    image_deviation : HObject
                      Result of calculation.

    See Also
    --------
    mean_n

    Predecessors
    ------------
    compose2, compose3, compose4, compose5, add_channels

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1445) as proc:
        proc.set_input_object(1, image)
        proc.execute()
        image_deviation = HObject(proc.get_output_object_key(1))
        return image_deviation  # type: ignore


def diameter_region(
    regions: HObject
) -> Tuple[Sequence[int], Sequence[int], Sequence[int], Sequence[int], Sequence[float]]:
    """
    Maximal distance between two boundary points of a region.

    Parameters
    ----------

    regions : HObject
              Regions to be examined.

    Returns
    -------

    row_1 : Sequence[int]
            Row index of the first extreme point.

    column_1 : Sequence[int]
               Column index of the first extreme point.

    row_2 : Sequence[int]
            Row index of the second extreme point.

    column_2 : Sequence[int]
               Column index of the second extreme point.

    diameter : Sequence[float]
               Distance of the two extreme points.

    Alternatives
    ------------
    smallest_rectangle2

    Predecessors
    ------------
    threshold, regiongrowing, connection, runlength_features

    Successors
    ----------
    disp_line

    Notes
    -----
    If the region is empty, the results of Row1, Column1, Row2 and Column2
    (all of them = 0) may lead to confusion.
    """
    with HalconOperator(1711) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_1
            proc.get_output_tuple_m(1),  # column_1
            proc.get_output_tuple_m(2),  # row_2
            proc.get_output_tuple_m(3),  # column_2
            proc.get_output_tuple_m(4)   # diameter
        )  # type: ignore


def diameter_region_s(
    regions: HObject
) -> Tuple[int, int, int, int, float]:
    """
    Maximal distance between two boundary points of a region.

    Parameters
    ----------

    regions : HObject
              Regions to be examined.

    Returns
    -------

    row_1 : int
            Row index of the first extreme point.

    column_1 : int
               Column index of the first extreme point.

    row_2 : int
            Row index of the second extreme point.

    column_2 : int
               Column index of the second extreme point.

    diameter : float
               Distance of the two extreme points.

    Alternatives
    ------------
    smallest_rectangle2

    Predecessors
    ------------
    threshold, regiongrowing, connection, runlength_features

    Successors
    ----------
    disp_line

    Notes
    -----
    If the region is empty, the results of Row1, Column1, Row2 and Column2
    (all of them = 0) may lead to confusion.
    """
    with HalconOperator(1711) as proc:
        proc.set_input_object(1, regions)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row_1
            proc.get_output_tuple_s(1),  # column_1
            proc.get_output_tuple_s(2),  # row_2
            proc.get_output_tuple_s(3),  # column_2
            proc.get_output_tuple_s(4)   # diameter
        )  # type: ignore


def diameter_xld(
    xld: HObject
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Maximum distance between two contour or polygon points.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    row_1 : Sequence[float]
            Row coordinate of the first extreme point of the contours or
            polygons.

    column_1 : Sequence[float]
               Column coordinate of the first extreme point of the
               contours or polygons.

    row_2 : Sequence[float]
            Row coordinate of the second extreme point of the contour or
            polygons.

    column_2 : Sequence[float]
               Column coordinate of the second extreme point of the
               contours or polygons.

    diameter : Sequence[float]
               Distance of the two extreme points of the contours or
               polygons.

    See Also
    --------
    area_center_xld

    Alternatives
    ------------
    smallest_rectangle2_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld

    Notes
    -----
    If the contour or polygon is empty, the results of Row1, Column1, Row2
    and Column2 (all of them = 0) may lead to confusion.
    """
    with HalconOperator(1682) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # row_1
            proc.get_output_tuple_m(1),  # column_1
            proc.get_output_tuple_m(2),  # row_2
            proc.get_output_tuple_m(3),  # column_2
            proc.get_output_tuple_m(4)   # diameter
        )  # type: ignore


def diameter_xld_s(
    xld: HObject
) -> Tuple[float, float, float, float, float]:
    """
    Maximum distance between two contour or polygon points.

    Parameters
    ----------

    xld : HObject
          Contours or polygons to be examined.

    Returns
    -------

    row_1 : float
            Row coordinate of the first extreme point of the contours or
            polygons.

    column_1 : float
               Column coordinate of the first extreme point of the
               contours or polygons.

    row_2 : float
            Row coordinate of the second extreme point of the contour or
            polygons.

    column_2 : float
               Column coordinate of the second extreme point of the
               contours or polygons.

    diameter : float
               Distance of the two extreme points of the contours or
               polygons.

    See Also
    --------
    area_center_xld

    Alternatives
    ------------
    smallest_rectangle2_xld

    Predecessors
    ------------
    gen_contours_skeleton_xld, edges_sub_pix, threshold_sub_pix,
    gen_contour_polygon_xld, test_self_intersection_xld

    Notes
    -----
    If the contour or polygon is empty, the results of Row1, Column1, Row2
    and Column2 (all of them = 0) may lead to confusion.
    """
    with HalconOperator(1682) as proc:
        proc.set_input_object(1, xld)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # row_1
            proc.get_output_tuple_s(1),  # column_1
            proc.get_output_tuple_s(2),  # row_2
            proc.get_output_tuple_s(3),  # column_2
            proc.get_output_tuple_s(4)   # diameter
        )  # type: ignore


def dict_to_json(
    dict_handle: MaybeSequence[HHandle],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> Sequence[str]:
    """
    Transform a dictionary into a JSON string.

    Parameters
    ----------

    dict_handle : MaybeSequence[HHandle]
                  Dictionary handle.

    gen_param_name : MaybeSequence[str]
                     Name of the generic parameter.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Value of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    json_string : Sequence[str]
                  String in JSON format.

    See Also
    --------
    json_to_dict, read_dict, write_dict, serialize_handle,
    deserialize_handle, copy_dict

    Alternatives
    ------------
    read_dict, create_dict

    Predecessors
    ------------
    create_dict, read_dict, json_to_dict

    Successors
    ----------
    json_to_dict
    """
    with HalconOperator(2262) as proc:
        proc.set_input_tuple(0, dict_handle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        json_string = proc.get_output_tuple_m(0)
        return json_string  # type: ignore


def dict_to_json_s(
    dict_handle: MaybeSequence[HHandle],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, float, str]]
) -> str:
    """
    Transform a dictionary into a JSON string.

    Parameters
    ----------

    dict_handle : MaybeSequence[HHandle]
                  Dictionary handle.

    gen_param_name : MaybeSequence[str]
                     Name of the generic parameter.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, float, str]]
                      Value of the generic parameter.
                      Value Suggestion: []

    Returns
    -------

    json_string : str
                  String in JSON format.

    See Also
    --------
    json_to_dict, read_dict, write_dict, serialize_handle,
    deserialize_handle, copy_dict

    Alternatives
    ------------
    read_dict, create_dict

    Predecessors
    ------------
    create_dict, read_dict, json_to_dict

    Successors
    ----------
    json_to_dict
    """
    with HalconOperator(2262) as proc:
        proc.set_input_tuple(0, dict_handle)
        proc.set_input_tuple(1, gen_param_name)
        proc.set_input_tuple(2, gen_param_value)
        proc.init_oct(0)
        proc.execute()
        json_string = proc.get_output_tuple_s(0)
        return json_string  # type: ignore


def diff_of_gauss(
    image: HObject,
    sigma: float,
    sig_factor: float
) -> HObject:
    """
    Approximate the LoG operator (Laplace of Gaussian).

    Parameters
    ----------

    image : HObject
            Input image

    sigma : float
            Smoothing parameter of the Laplace operator to approximate.
            Value Suggestion: 3.0
            Assertion: Sigma > 0.0

    sig_factor : float
                 Ratio of the standard deviations used (Marr recommends
                 1.6).
                 Value Suggestion: 1.6
                 Assertion: SigFactor > 0.0

    Returns
    -------

    diff_of_gauss : HObject
                    LoG image.

    Alternatives
    ------------
    laplace, derivate_gauss

    Successors
    ----------
    zero_crossing, dual_threshold

    Notes
    -----
    Note that filter operators may return unexpected results if an image
    with a reduced domain is used as input. Please refer to the chapter
    Filters.
    """
    with HalconOperator(1572) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, sigma)
        proc.set_input_tuple(1, sig_factor)
        proc.execute()
        diff_of_gauss = HObject(proc.get_output_object_key(1))
        return diff_of_gauss  # type: ignore


def difference(region: HObject, sub: HObject) -> HObject:
    """
    Calculate the difference of two regions.

    Parameters
    ----------

    region : HObject
             Regions to be processed.

    sub : HObject
          The union of these regions is subtracted from Region.

    Returns
    -------

    region_difference : HObject
                        Resulting region.

    See Also
    --------
    intersection, union1, union2, complement, symm_difference

    Predecessors
    ------------
    threshold, connection, regiongrowing, pouring, class_ndim_norm

    Successors
    ----------
    select_shape, disp_region

    Notes
    -----
    Empty regions are valid for both parameters.  On output, empty regions
    may result.  The value of the system flag 'store_empty_region'
    determines the behavior in this case.
    """
    with HalconOperator(503) as proc:
        proc.set_input_object(1, region)
        proc.set_input_object(2, sub)
        proc.execute()
        region_difference = HObject(proc.get_output_object_key(1))
        return region_difference  # type: ignore


def difference_closed_contours_xld(
    contours: HObject,
    sub: HObject
) -> HObject:
    """
    Compute the difference of closed contours.

    Parameters
    ----------

    contours : HObject
               Contours enclosing the region from which the second region
               is subtracted.

    sub : HObject
          Contours enclosing the region that is subtracted from the first
          region.

    Returns
    -------

    contours_difference : HObject
                          Contours enclosing the difference.

    See Also
    --------
    intersection_closed_contours_xld, symm_difference_closed_contours_xld,
    union2_closed_contours_xld, difference_closed_polygons_xld

    Alternatives
    ------------
    difference

    Predecessors
    ------------
    gen_contour_region_xld, zero_crossing_sub_pix, threshold_sub_pix
    """
    with HalconOperator(10) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_object(2, sub)
        proc.execute()
        contours_difference = HObject(proc.get_output_object_key(1))
        return contours_difference  # type: ignore


def difference_closed_polygons_xld(
    polygons: HObject,
    sub: HObject
) -> HObject:
    """
    Compute the difference of closed polygons.

    Parameters
    ----------

    polygons : HObject
               Polygons enclosing the region from which the second region
               is subtracted.

    sub : HObject
          Polygons enclosing the region that is subtracted from the first
          region.

    Returns
    -------

    polygons_difference : HObject
                          Polygons enclosing the difference.

    See Also
    --------
    intersection_closed_polygons_xld, symm_difference_closed_polygons_xld,
    union2_closed_polygons_xld, difference_closed_contours_xld

    Alternatives
    ------------
    difference

    Predecessors
    ------------
    gen_polygons_xld

    Notes
    -----
    The resulting polygons PolygonsDifference contain no references to the
    XLD contours that are possibly referenced by Polygons and Sub. Hence,
    operators that access the contours associated with a polygon, e.g.,
    split_contours_xld will not work correctly.
    """
    with HalconOperator(9) as proc:
        proc.set_input_object(1, polygons)
        proc.set_input_object(2, sub)
        proc.execute()
        polygons_difference = HObject(proc.get_output_object_key(1))
        return polygons_difference  # type: ignore


def dilation1(
    region: HObject,
    struct_element: HObject,
    iterations: int
) -> HObject:
    """
    Dilate a region.

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    struct_element : HObject
                     Structuring element.

    iterations : int
                 Number of iterations.
                 Value Suggestion: 1

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    erosion1, erosion2, opening, closing

    Alternatives
    ------------
    minkowski_add1, minkowski_add2, dilation2

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm, gen_circle, gen_ellipse, gen_rectangle1,
    gen_rectangle2, draw_region, gen_region_points,
    gen_region_polygon_filled

    Successors
    ----------
    reduce_domain, add_channels, select_shape, area_center, connection

    Notes
    -----
    A dilation always results in enlarged regions.  Closely spaced regions
    which may touch or overlap as a result of the dilation are still
    treated as two separate regions.  If the desired behavior is to merge
    them into one region, the operator union1 has to be called first.
    """
    with HalconOperator(779) as proc:
        proc.set_input_object(1, region)
        proc.set_input_object(2, struct_element)
        proc.set_input_tuple(0, iterations)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def dilation2(
    region: HObject,
    struct_element: HObject,
    row: int,
    column: int,
    iterations: int
) -> HObject:
    """
    Dilate a region (using a reference point).

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    struct_element : HObject
                     Structuring element.

    row : int
          Row coordinate of the reference point.
          Value Suggestion: 0

    column : int
             Column coordinate of the reference point.
             Value Suggestion: 0

    iterations : int
                 Number of iterations.
                 Value Suggestion: 1

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    erosion1, erosion2, opening, closing

    Alternatives
    ------------
    minkowski_add1, minkowski_add2, dilation1

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm, gen_circle, gen_ellipse, gen_rectangle1,
    gen_rectangle2, draw_region, gen_region_points,
    gen_region_polygon_filled

    Successors
    ----------
    reduce_domain, add_channels, select_shape, area_center, connection

    Notes
    -----
    A dilation always results in enlarged regions.  Closely spaced regions
    which may touch or overlap as a result of the dilation are still
    treated as two separate regions.  If the desired behavior is to merge
    them into one region, the operator union1 has to be called first.
    """
    with HalconOperator(778) as proc:
        proc.set_input_object(1, region)
        proc.set_input_object(2, struct_element)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, iterations)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def dilation_circle(
    region: HObject,
    radius: Union[float, int]
) -> HObject:
    """
    Dilate a region with a circular structuring element.

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    radius : Union[float, int]
             Radius of the circular structuring element.
             Value Suggestion: 3.5

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    gen_circle, erosion_circle, closing_circle, opening_circle

    Alternatives
    ------------
    minkowski_add1, minkowski_add2, expand_region, dilation1, dilation2,
    dilation_rectangle1

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Notes
    -----
    dilation_circle is applied to each input region separately.  If gaps
    between different regions are to be closed, union1 or union2 has to be
    called first.
    """
    with HalconOperator(777) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, radius)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def dilation_golay(
    region: HObject,
    golay_element: str,
    iterations: int,
    rotation: int
) -> HObject:
    """
    Dilate a region with an element from the Golay alphabet.

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    golay_element : str
                    Structuring element from the Golay alphabet.
                    Value Suggestion: h

    iterations : int
                 Number of iterations.
                 Value Suggestion: 1

    rotation : int
               Rotation of the Golay element. Depending on the element,
               not all rotations are valid.
               Value Suggestion: 0

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    erosion_golay, opening_golay, closing_golay, hit_or_miss_golay,
    thinning_golay, thickening_golay, golay_elements

    Alternatives
    ------------
    dilation1, dilation2, dilation_seq

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Warnings
    --------
    dilation_golay is obsolete and is only provided for reasons of
    backward compatibility.

    Notes
    -----
    Not all values of Rotation are valid for any Golay element.  For some
    of the values of Rotation, the resulting regions are identical to the
    input regions.
    """
    with HalconOperator(775) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, golay_element)
        proc.set_input_tuple(1, iterations)
        proc.set_input_tuple(2, rotation)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def dilation_rectangle1(
    region: HObject,
    width: int,
    height: int
) -> HObject:
    """
    Dilate a region with a rectangular structuring element.

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    width : int
            Width of the structuring rectangle.
            Value Suggestion: 11

    height : int
             Height of the structuring rectangle.
             Value Suggestion: 11

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    gen_rectangle1, gen_region_polygon_filled

    Alternatives
    ------------
    minkowski_add1, minkowski_add2, expand_region, dilation1, dilation2,
    dilation_circle

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Notes
    -----
    dilation_rectangle1 is applied to each input region separately.  If
    gaps between different regions are to be closed, union1 or union2 has
    to be called first.
    To enlarge a region by the same amount in all directions, Width and
    Height must be odd. If this is not the case, the region is dilated by
    a larger amount at the right or at the bottom, respectively, than at
    the left or at the top.
    """
    with HalconOperator(776) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, width)
        proc.set_input_tuple(1, height)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def dilation_seq(
    region: HObject,
    golay_element: str,
    iterations: int
) -> HObject:
    """
    Dilate a region sequentially.

    Parameters
    ----------

    region : HObject
             Regions to be dilated.

    golay_element : str
                    Structuring element from the Golay alphabet.
                    Value Suggestion: h

    iterations : int
                 Number of iterations.
                 Value Suggestion: 1

    Returns
    -------

    region_dilation : HObject
                      Dilated regions.

    See Also
    --------
    erosion_seq, hit_or_miss_seq, thinning_seq

    Alternatives
    ------------
    dilation1, dilation2, dilation_golay

    Predecessors
    ------------
    threshold, regiongrowing, connection, union1, watersheds,
    class_ndim_norm

    Successors
    ----------
    reduce_domain, select_shape, area_center, connection

    Warnings
    --------
    dilation_seq is obsolete and is only provided for reasons of backward
    compatibility.
    """
    with HalconOperator(774) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, golay_element)
        proc.set_input_tuple(1, iterations)
        proc.execute()
        region_dilation = HObject(proc.get_output_object_key(1))
        return region_dilation  # type: ignore


def disp_arc(
    window_handle: HHandle,
    center_row: Union[int, float],
    center_col: Union[int, float],
    angle: Union[int, float],
    begin_row: MaybeSequence[Union[int, float]],
    begin_col: MaybeSequence[Union[int, float]]
) -> None:
    """
    Displays circular arcs in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    center_row : Union[int, float]
                 Row coordinate of center point.
                 Value Suggestion: 64

    center_col : Union[int, float]
                 Column coordinate of center point.
                 Value Suggestion: 64

    angle : Union[int, float]
            Angle between start and end of the arc (in radians).
            Value Suggestion: 3.1415926
            Assertion: Angle > 0.0

    begin_row : MaybeSequence[Union[int, float]]
                Row coordinate of the start of the arc.
                Value Suggestion: 32

    begin_col : MaybeSequence[Union[int, float]]
                Column coordinate of the start of the arc.
                Value Suggestion: 32

    See Also
    --------
    open_window, set_color, set_draw, set_rgb, set_hsi

    Alternatives
    ------------
    disp_circle, disp_ellipse, disp_region, gen_circle, gen_ellipse

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi

    Notes
    -----
    The center point has to be within the window. The radius of the arc
    has be at least 2 pixel.
    """
    with HalconOperator(1275) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, center_row)
        proc.set_input_tuple(2, center_col)
        proc.set_input_tuple(3, angle)
        proc.set_input_tuple(4, begin_row)
        proc.set_input_tuple(5, begin_col)
        proc.execute()


def disp_arrow(
    window_handle: HHandle,
    row_1: MaybeSequence[Union[int, float]],
    column_1: MaybeSequence[Union[int, float]],
    row_2: MaybeSequence[Union[int, float]],
    column_2: MaybeSequence[Union[int, float]],
    size: Union[int, float]
) -> None:
    """
    Displays arrows in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_1 : MaybeSequence[Union[int, float]]
            Row index of the start.
            Value Suggestion: 10.0

    column_1 : MaybeSequence[Union[int, float]]
               Column index of the start.
               Value Suggestion: 10.0

    row_2 : MaybeSequence[Union[int, float]]
            Row index of the end.
            Value Suggestion: 118.0

    column_2 : MaybeSequence[Union[int, float]]
               Column index of the end.
               Value Suggestion: 118.0

    size : Union[int, float]
           Size of the arrowhead.
           Value Suggestion: 1.0
           Assertion: Size > 0.0

    See Also
    --------
    open_window, set_color, set_draw, set_line_width

    Alternatives
    ------------
    disp_line, gen_region_polygon, disp_region

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi

    Notes
    -----
    The start and the end of the arrows must fall within the window.
    """
    with HalconOperator(1274) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_1)
        proc.set_input_tuple(2, column_1)
        proc.set_input_tuple(3, row_2)
        proc.set_input_tuple(4, column_2)
        proc.set_input_tuple(5, size)
        proc.execute()


def disp_caltab(
    window_handle: HHandle,
    cal_plate_descr: str,
    camera_param: Sequence[Union[int, float, str]],
    cal_plate_pose: Sequence[Union[int, float]],
    scale_fac: float
) -> None:
    """
    Project and visualize the 3D model of the calibration plate in the
    image.

    Parameters
    ----------

    window_handle : HHandle
                    Window in which the calibration plate should be
                    visualized.

    cal_plate_descr : str
                      File name of the calibration plate description.
                      Value Suggestion: calplate_320.cpd

    camera_param : Sequence[Union[int, float, str]]
                   Internal camera parameters.

    cal_plate_pose : Sequence[Union[int, float]]
                     External camera parameters (3D pose of the
                     calibration plate in camera coordinates).

    scale_fac : float
                Scaling factor for the visualization.
                Value Suggestion: 1.0
                Assertion: 0.0 < ScaleFac

    See Also
    --------
    find_marks_and_pose, camera_calibration, sim_caltab, write_cam_par,
    read_cam_par, create_pose, write_pose, read_pose, project_3d_point,
    get_line_of_sight

    Predecessors
    ------------
    camera_calibration, read_cam_par, read_pose
    """
    with HalconOperator(1945) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, cal_plate_descr)
        proc.set_input_tuple(2, camera_param)
        proc.set_input_tuple(3, cal_plate_pose)
        proc.set_input_tuple(4, scale_fac)
        proc.execute()


def disp_channel(
    multichannel_image: HObject,
    window_handle: HHandle,
    channel: MaybeSequence[int]
) -> None:
    """
    Displays images with several channels.

    Parameters
    ----------

    multichannel_image : HObject
                         Multichannel images to be displayed.

    window_handle : HHandle
                    Window handle.

    channel : MaybeSequence[int]
              Number of channel or the numbers of the RGB-channels
              Value Suggestion: 1

    See Also
    --------
    open_window, reset_obj_db, set_lut, dump_window

    Alternatives
    ------------
    disp_image, disp_color

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi
    """
    with HalconOperator(1269) as proc:
        proc.set_input_object(1, multichannel_image)
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, channel)
        proc.execute()


def disp_circle(
    window_handle: HHandle,
    row: MaybeSequence[Union[int, float]],
    column: MaybeSequence[Union[int, float]],
    radius: MaybeSequence[Union[int, float]]
) -> None:
    """
    Displays circles in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row : MaybeSequence[Union[int, float]]
          Row index of the center.
          Value Suggestion: 64

    column : MaybeSequence[Union[int, float]]
             Column index of the center.
             Value Suggestion: 64

    radius : MaybeSequence[Union[int, float]]
             Radius of the circle.
             Value Suggestion: 64
             Assertion: Radius > 0.0

    See Also
    --------
    open_window, set_color, set_draw, set_rgb, set_hsi

    Alternatives
    ------------
    disp_ellipse, disp_region, gen_circle, gen_ellipse

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi

    Notes
    -----
    The center of the circle must be within the window.
    """
    with HalconOperator(1273) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, radius)
        proc.execute()


def disp_color(color_image: HObject, window_handle: HHandle) -> None:
    """
    Displays a color (RGB) image

    Parameters
    ----------

    color_image : HObject
                  Color image to display.

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    disp_image, open_window, reset_obj_db, set_lut, dump_window

    Alternatives
    ------------
    disp_channel, disp_obj

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi

    Notes
    -----
    Due to the restricted number of available colors the color appearance
    is usually different from the original.
    """
    with HalconOperator(1270) as proc:
        proc.set_input_object(1, color_image)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def disp_cross(
    window_handle: HHandle,
    row: MaybeSequence[float],
    column: MaybeSequence[float],
    size: float,
    angle: float
) -> None:
    """
    Displays crosses in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row : MaybeSequence[float]
          Row coordinate of the center.
          Value Suggestion: 32.0

    column : MaybeSequence[float]
             Column coordinate of the center.
             Value Suggestion: 32.0

    size : float
           Length of the bars.
           Value Suggestion: 6.0

    angle : float
            Orientation.
            Value Suggestion: 0.0

    See Also
    --------
    open_window, set_color, set_rgb, set_hsi, set_insert, set_line_width

    Alternatives
    ------------
    disp_arrow, disp_rectangle1, disp_rectangle2, disp_circle

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_draw, set_color,
    set_colored, set_line_width
    """
    with HalconOperator(1267) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, size)
        proc.set_input_tuple(4, angle)
        proc.execute()


def disp_distribution(
    window_handle: HHandle,
    distribution: Sequence[float],
    row: int,
    column: int,
    scale: int
) -> None:
    """
    Displays a noise distribution.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    distribution : Sequence[float]
                   Gray value distribution (513 values).

    row : int
          Row index of center.
          Value Suggestion: 256

    column : int
             Column index of center.
             Value Suggestion: 256

    scale : int
            Size of display.
            Value Suggestion: 1

    See Also
    --------
    gen_region_histo, gauss_distribution, noise_distribution_mean

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi, noise_distribution_mean, gauss_distribution

    Warnings
    --------
    disp_distribution is obsolete and is only provided for reasons of
    backward compatibility.
    """
    with HalconOperator(1272) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, distribution)
        proc.set_input_tuple(2, row)
        proc.set_input_tuple(3, column)
        proc.set_input_tuple(4, scale)
        proc.execute()


def disp_ellipse(
    window_handle: HHandle,
    center_row: MaybeSequence[int],
    center_col: MaybeSequence[int],
    phi: MaybeSequence[Union[int, float]],
    radius_1: MaybeSequence[Union[int, float]],
    radius_2: MaybeSequence[Union[int, float]]
) -> None:
    """
    Displays ellipses.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    center_row : MaybeSequence[int]
                 Row index of center.
                 Value Suggestion: 64

    center_col : MaybeSequence[int]
                 Column index of center.
                 Value Suggestion: 64

    phi : MaybeSequence[Union[int, float]]
          Orientation of the ellipse in radians
          Value Suggestion: 0.0

    radius_1 : MaybeSequence[Union[int, float]]
               Radius of major axis.
               Value Suggestion: 24.0

    radius_2 : MaybeSequence[Union[int, float]]
               Radius of minor axis.
               Value Suggestion: 14.0

    See Also
    --------
    open_window, set_color, set_rgb, set_hsi, set_draw, set_line_width

    Alternatives
    ------------
    disp_circle, disp_region, gen_ellipse, gen_circle

    Predecessors
    ------------
    open_window, set_draw, set_color, set_colored, set_line_width,
    set_rgb, set_hsi, elliptic_axis, area_center

    Notes
    -----
    The center of the ellipse must be within the window.
    """
    with HalconOperator(1271) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, center_row)
        proc.set_input_tuple(2, center_col)
        proc.set_input_tuple(3, phi)
        proc.set_input_tuple(4, radius_1)
        proc.set_input_tuple(5, radius_2)
        proc.execute()


def disp_image(image: HObject, window_handle: HHandle) -> None:
    """
    Displays gray value images.

    Parameters
    ----------

    image : HObject
            Gray value image to display.

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    open_window, reset_obj_db, set_paint, set_lut, paint_gray,
    scale_image, convert_image_type, dump_window

    Alternatives
    ------------
    disp_obj, disp_color

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, scale_image,
    convert_image_type, min_max_gray

    Notes
    -----
    If a wrong output mode was set by set_paint, the error will be
    reported when disp_image is used.
    """
    with HalconOperator(1268) as proc:
        proc.set_input_object(1, image)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def disp_line(
    window_handle: HHandle,
    row_1: MaybeSequence[float],
    column_1: MaybeSequence[float],
    row_2: MaybeSequence[float],
    column_2: MaybeSequence[float]
) -> None:
    """
    Draws lines in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_1 : MaybeSequence[float]
            Row index of the start.
            Value Suggestion: 32.0

    column_1 : MaybeSequence[float]
               Column index of the start.
               Value Suggestion: 32.0

    row_2 : MaybeSequence[float]
            Row index of end.
            Value Suggestion: 64.0

    column_2 : MaybeSequence[float]
               Column index of end.
               Value Suggestion: 64.0

    See Also
    --------
    open_window, set_color, set_rgb, set_hsi, set_insert, set_line_width

    Alternatives
    ------------
    disp_arrow, disp_rectangle1, disp_rectangle2, disp_region,
    gen_region_polygon, gen_region_points

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_draw, set_color,
    set_colored, set_line_width

    Notes
    -----
    The starting points and the ending points of the lines must be in the
    window.
    """
    with HalconOperator(1266) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_1)
        proc.set_input_tuple(2, column_1)
        proc.set_input_tuple(3, row_2)
        proc.set_input_tuple(4, column_2)
        proc.execute()


def disp_lut(
    window_handle: HHandle,
    row: int,
    column: int,
    scale: int
) -> None:
    """
    Graphical view of the look-up-table (lut).

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row : int
          Row of center of the graphic.
          Value Suggestion: 128

    column : int
             Column of center of the graphic.
             Value Suggestion: 128

    scale : int
            Scaling of the graphic.
            Value Suggestion: 1

    See Also
    --------
    open_window, set_lut, set_fix, set_pixel, write_lut, get_lut, set_color

    Predecessors
    ------------
    set_lut

    Warnings
    --------
    disp_lut is obsolete and is only provided for reasons of backward
    compatibility.
    """
    with HalconOperator(1285) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, scale)
        proc.execute()


def disp_obj(object: HObject, window_handle: HHandle) -> None:
    """
    Displays image objects (image, region, XLD).

    Parameters
    ----------

    object : HObject
             Image object to be displayed.

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    open_window, reset_obj_db, set_paint, set_lut, paint_gray,
    scale_image, convert_image_type, dump_window

    Alternatives
    ------------
    disp_color, disp_image, disp_xld, disp_region

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, scale_image,
    convert_image_type, min_max_gray
    """
    with HalconOperator(1276) as proc:
        proc.set_input_object(1, object)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def disp_object_model_3d(
    window_handle: HHandle,
    object_model_3d: MaybeSequence[HHandle],
    cam_param: Sequence[Union[int, float, str]],
    pose: Sequence[Union[int, float]],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> None:
    """
    Display 3D object models.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    object_model_3d : MaybeSequence[HHandle]
                      Handles of the 3D object models.

    cam_param : Sequence[Union[int, float, str]]
                Camera parameters of the scene.
                Value Suggestion: []

    pose : Sequence[Union[int, float]]
           3D poses of the objects.
           Value Suggestion: []

    gen_param_name : Sequence[str]
                     Names of the generic parameters.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Values of the generic parameters.
                      Value Suggestion: []

    See Also
    --------
    render_object_model_3d, project_object_model_3d,
    project_shape_model_3d, object_model_3d_to_xyz

    Predecessors
    ------------
    find_surface_model, fit_primitives_object_model_3d,
    read_object_model_3d, segment_object_model_3d

    Successors
    ----------
    get_disp_object_model_3d_info

    Notes
    -----
    Cameras with hypercentric lenses are not supported. For displaying
    large faces (or primitives) with a non-zero distortion in CamParam,
    note that the distortion is only applied to the points of the model.
    In the projection, these points are subsequently connected by straight
    lines. For a good approximation of the distorted lines, please use a
    triangulation with sufficiently small triangles.
    """
    with HalconOperator(1089) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, object_model_3d)
        proc.set_input_tuple(2, cam_param)
        proc.set_input_tuple(3, pose)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.execute()


def disp_polygon(
    window_handle: HHandle,
    row: Sequence[Union[int, float]],
    column: Sequence[Union[int, float]]
) -> None:
    """
    Displays a polyline.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row : Sequence[Union[int, float]]
          Row index
          Value Suggestion: [16,80,80]

    column : Sequence[Union[int, float]]
             Column index
             Value Suggestion: [48,16,80]

    See Also
    --------
    open_window, set_color, set_rgb, set_hsi, set_insert, set_line_width

    Alternatives
    ------------
    disp_line, gen_region_polygon, disp_region

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_draw, set_color,
    set_colored, set_line_width

    Notes
    -----
    The given coordinates must lie within the window.
    """
    with HalconOperator(1265) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.execute()


def disp_rectangle1(
    window_handle: HHandle,
    row_1: MaybeSequence[Union[int, float]],
    column_1: MaybeSequence[Union[int, float]],
    row_2: MaybeSequence[Union[int, float]],
    column_2: MaybeSequence[Union[int, float]]
) -> None:
    """
    Display of rectangles aligned to the coordinate axes.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    row_1 : MaybeSequence[Union[int, float]]
            Row index of the upper left corner.
            Value Suggestion: 16

    column_1 : MaybeSequence[Union[int, float]]
               Column index of the upper left corner.
               Value Suggestion: 16

    row_2 : MaybeSequence[Union[int, float]]
            Row index of the lower right corner.
            Value Suggestion: 48
            Assertion: Row2 >= Row1

    column_2 : MaybeSequence[Union[int, float]]
               Column index of the lower right corner.
               Value Suggestion: 80
               Assertion: Column2 >= Column1

    See Also
    --------
    open_window, set_color, set_draw, set_line_width

    Alternatives
    ------------
    disp_rectangle2, gen_rectangle1, disp_region, disp_line, set_shape

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_draw, set_color,
    set_colored, set_line_width
    """
    with HalconOperator(1264) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, row_1)
        proc.set_input_tuple(2, column_1)
        proc.set_input_tuple(3, row_2)
        proc.set_input_tuple(4, column_2)
        proc.execute()


def disp_rectangle2(
    window_handle: HHandle,
    center_row: MaybeSequence[Union[int, float]],
    center_col: MaybeSequence[Union[int, float]],
    phi: MaybeSequence[Union[int, float]],
    length_1: MaybeSequence[Union[int, float]],
    length_2: MaybeSequence[Union[int, float]]
) -> None:
    """
    Displays arbitrarily oriented rectangles.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    center_row : MaybeSequence[Union[int, float]]
                 Row index of the center.
                 Value Suggestion: 48

    center_col : MaybeSequence[Union[int, float]]
                 Column index of the center.
                 Value Suggestion: 64

    phi : MaybeSequence[Union[int, float]]
          Orientation of rectangle in radians.
          Value Suggestion: 0.0

    length_1 : MaybeSequence[Union[int, float]]
               Half of the length of the longer side.
               Value Suggestion: 48

    length_2 : MaybeSequence[Union[int, float]]
               Half of the length of the shorter side.
               Value Suggestion: 32
               Assertion: Length2 < Length1

    See Also
    --------
    open_window, disp_region, set_color, set_draw, set_line_width

    Alternatives
    ------------
    disp_region, gen_rectangle2, disp_rectangle1, set_shape

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_draw, set_color,
    set_colored, set_line_width

    Notes
    -----
    The center must lie within the window boundaries.
    """
    with HalconOperator(1263) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, center_row)
        proc.set_input_tuple(2, center_col)
        proc.set_input_tuple(3, phi)
        proc.set_input_tuple(4, length_1)
        proc.set_input_tuple(5, length_2)
        proc.execute()


def disp_region(disp_regions: HObject, window_handle: HHandle) -> None:
    """
    Displays regions in a window.

    Parameters
    ----------

    disp_regions : HObject
                   Regions to display.

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    open_window, set_color, set_colored, set_draw, set_shape, set_paint,
    set_gray, set_rgb, set_hsi, set_line_width, set_line_style,
    set_insert, paint_region, dump_window

    Alternatives
    ------------
    disp_obj, disp_arrow, disp_line, disp_circle, disp_rectangle1,
    disp_rectangle2, disp_ellipse

    Predecessors
    ------------
    open_window, set_rgb, set_lut, set_hsi, set_shape, set_line_style,
    set_insert, set_draw, set_color, set_colored, set_line_width
    """
    with HalconOperator(1262) as proc:
        proc.set_input_object(1, disp_regions)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def disp_text(
    window_handle: HHandle,
    string: MaybeSequence[str],
    coord_system: str,
    row: MaybeSequence[Union[int, float, str]],
    column: MaybeSequence[Union[int, float, str]],
    color: MaybeSequence[str],
    gen_param_name: Sequence[str],
    gen_param_value: Sequence[Union[str, int, float]]
) -> None:
    """
    Display text in a window.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    string : MaybeSequence[str]
             A tuple of strings containing the text message to be
             displayed. Each value of the tuple will be displayed in a
             single line.
             Value Suggestion: hello

    coord_system : str
                   If set to 'window', the text position is given with
                   respect to the window coordinate system. If set to
                   'image', image coordinates are used (this may be useful
                   in zoomed images).
                   Value Suggestion: window

    row : MaybeSequence[Union[int, float, str]]
          The vertical text alignment or the row coordinate of the desired
          text position.
          Value Suggestion: 12

    column : MaybeSequence[Union[int, float, str]]
             The horizontal text alignment or the column coordinate of the
             desired text position.
             Value Suggestion: 12

    color : MaybeSequence[str]
            A tuple of strings defining the colors of the texts.
            Value Suggestion: black

    gen_param_name : Sequence[str]
                     Generic parameter names.
                     Value Suggestion: []

    gen_param_value : Sequence[Union[str, int, float]]
                      Generic parameter values.
                      Value Suggestion: []

    See Also
    --------
    get_string_extents, set_font

    Alternatives
    ------------
    write_string

    Predecessors
    ------------
    open_window, set_font, get_string_extents

    Notes
    -----
    disp_text depends on the library libcanvas, which might not be
    available on embedded systems.
    """
    with HalconOperator(2055) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, string)
        proc.set_input_tuple(2, coord_system)
        proc.set_input_tuple(3, row)
        proc.set_input_tuple(4, column)
        proc.set_input_tuple(5, color)
        proc.set_input_tuple(6, gen_param_name)
        proc.set_input_tuple(7, gen_param_value)
        proc.execute()


def disp_xld(xldobject: HObject, window_handle: HHandle) -> None:
    """
    Display an XLD object.

    Parameters
    ----------

    xldobject : HObject
                XLD object to display.

    window_handle : HHandle
                    Window handle.

    See Also
    --------
    disp_image, disp_region, disp_channel, disp_color, disp_line, disp_arc
    """
    with HalconOperator(74) as proc:
        proc.set_input_object(1, xldobject)
        proc.set_input_tuple(0, window_handle)
        proc.execute()


def disparity_image_to_xyz(
    disparity: HObject,
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]]
) -> Tuple[HObject, HObject, HObject]:
    """
    Transform a disparity image into 3D points in a rectified stereo
    system.

    Parameters
    ----------

    disparity : HObject
                Disparity image.

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Internal camera parameters of the rectified camera
                       2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Pose of the rectified camera 2 in relation to the
                    rectified camera 1.

    Returns
    -------

    x : HObject
        X coordinates of the points in the rectified camera system 1.

    y : HObject
        Y coordinates of the points in the rectified camera system 1.

    z : HObject
        Z coordinates of the points in the rectified camera system 1.

    See Also
    --------
    binocular_calibration, gen_binocular_rectification_map,
    intersect_lines_of_sight

    Alternatives
    ------------
    disparity_to_point_3d, binocular_distance

    Predecessors
    ------------
    binocular_disparity

    Successors
    ----------
    threshold, write_image

    Notes
    -----
    Stereo setups that contain cameras with and without hypercentric
    lenses at the same time are not supported.
    """
    with HalconOperator(365) as proc:
        proc.set_input_object(1, disparity)
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.execute()
        return (
            HObject(proc.get_output_object_key(1)),  # x
            HObject(proc.get_output_object_key(2)),  # y
            HObject(proc.get_output_object_key(3))   # z
        )  # type: ignore


def disparity_to_distance(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    disparity: MaybeSequence[Union[int, float]]
) -> Sequence[float]:
    """
    Transform a disparity value into a distance value in a rectified
    binocular stereo system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    disparity : MaybeSequence[Union[int, float]]
                Disparity between the images of the world point.

    Returns
    -------

    distance : Sequence[float]
               Distance of a world point to the rectified camera system.

    See Also
    --------
    distance_to_disparity, disparity_to_point_3d

    Alternatives
    ------------
    binocular_distance

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map, map_image,
    binocular_disparity

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For a stereo setup of mixed type (i.e., for a stereo setup in which
    one of the original cameras is a perspective camera and the other
    camera is a telecentric camera; see gen_binocular_rectification_map),
    the rectifying plane of the two cameras is in a position with respect
    to the object that would lead to very unintuitive distances.
    Therefore, disparity_to_distance does not support stereo setups of
    mixed type.  For stereo setups of mixed type, disparity_to_point_3d
    should be used instead.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(367) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, disparity)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def disparity_to_distance_s(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    disparity: MaybeSequence[Union[int, float]]
) -> float:
    """
    Transform a disparity value into a distance value in a rectified
    binocular stereo system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    disparity : MaybeSequence[Union[int, float]]
                Disparity between the images of the world point.

    Returns
    -------

    distance : float
               Distance of a world point to the rectified camera system.

    See Also
    --------
    distance_to_disparity, disparity_to_point_3d

    Alternatives
    ------------
    binocular_distance

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map, map_image,
    binocular_disparity

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For a stereo setup of mixed type (i.e., for a stereo setup in which
    one of the original cameras is a perspective camera and the other
    camera is a telecentric camera; see gen_binocular_rectification_map),
    the rectifying plane of the two cameras is in a position with respect
    to the object that would lead to very unintuitive distances.
    Therefore, disparity_to_distance does not support stereo setups of
    mixed type.  For stereo setups of mixed type, disparity_to_point_3d
    should be used instead.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(367) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, disparity)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_s(0)
        return distance  # type: ignore


def disparity_to_point_3d(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    row_1: MaybeSequence[Union[int, float]],
    col_1: MaybeSequence[Union[int, float]],
    disparity: MaybeSequence[Union[int, float]]
) -> Tuple[Sequence[float], Sequence[float], Sequence[float]]:
    """
    Transform an image point and its disparity into a 3D point in a
    rectified stereo system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Pose of the rectified camera 2 in relation to the
                    rectified camera 1.

    row_1 : MaybeSequence[Union[int, float]]
            Row coordinate of a point in the rectified image 1.

    col_1 : MaybeSequence[Union[int, float]]
            Column coordinate of a point in the rectified image 1.

    disparity : MaybeSequence[Union[int, float]]
                Disparity of the images of the world point.

    Returns
    -------

    x : Sequence[float]
        X coordinate of the 3D point.

    y : Sequence[float]
        Y coordinate of the 3D point.

    z : Sequence[float]
        Z coordinate of the 3D point.

    See Also
    --------
    binocular_disparity, binocular_distance, intersect_lines_of_sight

    Alternatives
    ------------
    disparity_image_to_xyz

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map

    Notes
    -----
    Stereo setups that contain cameras with and without hypercentric
    lenses at the same time are not supported.
    """
    with HalconOperator(366) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, row_1)
        proc.set_input_tuple(4, col_1)
        proc.set_input_tuple(5, disparity)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # x
            proc.get_output_tuple_m(1),  # y
            proc.get_output_tuple_m(2)   # z
        )  # type: ignore


def disparity_to_point_3d_s(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    row_1: MaybeSequence[Union[int, float]],
    col_1: MaybeSequence[Union[int, float]],
    disparity: MaybeSequence[Union[int, float]]
) -> Tuple[float, float, float]:
    """
    Transform an image point and its disparity into a 3D point in a
    rectified stereo system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Pose of the rectified camera 2 in relation to the
                    rectified camera 1.

    row_1 : MaybeSequence[Union[int, float]]
            Row coordinate of a point in the rectified image 1.

    col_1 : MaybeSequence[Union[int, float]]
            Column coordinate of a point in the rectified image 1.

    disparity : MaybeSequence[Union[int, float]]
                Disparity of the images of the world point.

    Returns
    -------

    x : float
        X coordinate of the 3D point.

    y : float
        Y coordinate of the 3D point.

    z : float
        Z coordinate of the 3D point.

    See Also
    --------
    binocular_disparity, binocular_distance, intersect_lines_of_sight

    Alternatives
    ------------
    disparity_image_to_xyz

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map

    Notes
    -----
    Stereo setups that contain cameras with and without hypercentric
    lenses at the same time are not supported.
    """
    with HalconOperator(366) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, row_1)
        proc.set_input_tuple(4, col_1)
        proc.set_input_tuple(5, disparity)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # x
            proc.get_output_tuple_s(1),  # y
            proc.get_output_tuple_s(2)   # z
        )  # type: ignore


def display_scene_3d(
    window_handle: HHandle,
    scene_3d: HHandle,
    camera_index: Union[int, str]
) -> None:
    """
    Display a 3D scene.

    Parameters
    ----------

    window_handle : HHandle
                    Window handle.

    scene_3d : HHandle
               Handle of the 3D scene.

    camera_index : Union[int, str]
                   Index of the camera used to display the scene.

    See Also
    --------
    create_scene_3d, render_scene_3d
    """
    with HalconOperator(1215) as proc:
        proc.set_input_tuple(0, window_handle)
        proc.set_input_tuple(1, scene_3d)
        proc.set_input_tuple(2, camera_index)
        proc.execute()


def dist_ellipse_contour_points_xld(
    contour: HObject,
    distance_mode: str,
    clipping_end_points: int,
    row: float,
    column: float,
    phi: float,
    radius_1: float,
    radius_2: float
) -> Sequence[float]:
    """
    Compute the distances of all contour points to an ellipse.

    Parameters
    ----------

    contour : HObject
              Input contours.

    distance_mode : str
                    Mode for unsigned or signed distance values.
                    Value Suggestion: unsigned

    clipping_end_points : int
                          Number of points at the beginning and the end of
                          the contours to be ignored for the computation
                          of distances.
                          Value Suggestion: 0
                          Assertion: ClippingEndPoints >= 0

    row : float
          Row coordinate of the center of the ellipse.

    column : float
             Column coordinate of the center of the ellipse.

    phi : float
          Orientation of the main axis in radian.
          Assertion: Phi >= 0 && Phi <= 6.283185307

    radius_1 : float
               Length of the larger half axis.
               Assertion: Radius1 > 0

    radius_2 : float
               Length of the smaller half axis.
               Assertion: Radius2 >= 0 && Radius2 <= Radius1

    Returns
    -------

    distances : Sequence[float]
                Distances of the contour points to the ellipse.

    Alternatives
    ------------
    dist_ellipse_contour_xld

    Predecessors
    ------------
    fit_ellipse_contour_xld
    """
    with HalconOperator(31) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, distance_mode)
        proc.set_input_tuple(1, clipping_end_points)
        proc.set_input_tuple(2, row)
        proc.set_input_tuple(3, column)
        proc.set_input_tuple(4, phi)
        proc.set_input_tuple(5, radius_1)
        proc.set_input_tuple(6, radius_2)
        proc.init_oct(0)
        proc.execute()
        distances = proc.get_output_tuple_m(0)
        return distances  # type: ignore


def dist_ellipse_contour_xld(
    contours: HObject,
    mode: str,
    max_num_points: int,
    clipping_end_points: int,
    row: float,
    column: float,
    phi: float,
    radius_1: float,
    radius_2: float
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Compute the distance of contours to an ellipse.

    Parameters
    ----------

    contours : HObject
               Input contours.

    mode : str
           Method for the determination of the distances.
           Value Suggestion: geometric

    max_num_points : int
                     Maximum number of contour points used for the
                     computation (-1 for all points).
                     Value Suggestion: -1
                     Assertion: MaxNumPoints >= 3

    clipping_end_points : int
                          Number of points at the beginning and the end of
                          the contours to be ignored for the computation
                          of distances.
                          Value Suggestion: 0
                          Assertion: ClippingEndPoints >= 0

    row : float
          Row coordinate of the center of the ellipse.

    column : float
             Column coordinate of the center of the ellipse.

    phi : float
          Orientation of the main axis in radian.
          Assertion: Phi >= 0 && Phi <= 6.283185307

    radius_1 : float
               Length of the larger half axis.
               Assertion: Radius1 > 0

    radius_2 : float
               Length of the smaller half axis.
               Assertion: Radius2 >= 0 && Radius2 <= Radius1

    Returns
    -------

    min_dist : Sequence[float]
               Minimum distance.

    max_dist : Sequence[float]
               Maximum distance.

    avg_dist : Sequence[float]
               Mean distance.

    sigma_dist : Sequence[float]
                 Standard deviation of the distance.

    Alternatives
    ------------
    dist_ellipse_contour_points_xld

    Predecessors
    ------------
    fit_ellipse_contour_xld
    """
    with HalconOperator(32) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, max_num_points)
        proc.set_input_tuple(2, clipping_end_points)
        proc.set_input_tuple(3, row)
        proc.set_input_tuple(4, column)
        proc.set_input_tuple(5, phi)
        proc.set_input_tuple(6, radius_1)
        proc.set_input_tuple(7, radius_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # min_dist
            proc.get_output_tuple_m(1),  # max_dist
            proc.get_output_tuple_m(2),  # avg_dist
            proc.get_output_tuple_m(3)   # sigma_dist
        )  # type: ignore


def dist_ellipse_contour_xld_s(
    contours: HObject,
    mode: str,
    max_num_points: int,
    clipping_end_points: int,
    row: float,
    column: float,
    phi: float,
    radius_1: float,
    radius_2: float
) -> Tuple[float, float, float, float]:
    """
    Compute the distance of contours to an ellipse.

    Parameters
    ----------

    contours : HObject
               Input contours.

    mode : str
           Method for the determination of the distances.
           Value Suggestion: geometric

    max_num_points : int
                     Maximum number of contour points used for the
                     computation (-1 for all points).
                     Value Suggestion: -1
                     Assertion: MaxNumPoints >= 3

    clipping_end_points : int
                          Number of points at the beginning and the end of
                          the contours to be ignored for the computation
                          of distances.
                          Value Suggestion: 0
                          Assertion: ClippingEndPoints >= 0

    row : float
          Row coordinate of the center of the ellipse.

    column : float
             Column coordinate of the center of the ellipse.

    phi : float
          Orientation of the main axis in radian.
          Assertion: Phi >= 0 && Phi <= 6.283185307

    radius_1 : float
               Length of the larger half axis.
               Assertion: Radius1 > 0

    radius_2 : float
               Length of the smaller half axis.
               Assertion: Radius2 >= 0 && Radius2 <= Radius1

    Returns
    -------

    min_dist : float
               Minimum distance.

    max_dist : float
               Maximum distance.

    avg_dist : float
               Mean distance.

    sigma_dist : float
                 Standard deviation of the distance.

    Alternatives
    ------------
    dist_ellipse_contour_points_xld

    Predecessors
    ------------
    fit_ellipse_contour_xld
    """
    with HalconOperator(32) as proc:
        proc.set_input_object(1, contours)
        proc.set_input_tuple(0, mode)
        proc.set_input_tuple(1, max_num_points)
        proc.set_input_tuple(2, clipping_end_points)
        proc.set_input_tuple(3, row)
        proc.set_input_tuple(4, column)
        proc.set_input_tuple(5, phi)
        proc.set_input_tuple(6, radius_1)
        proc.set_input_tuple(7, radius_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # min_dist
            proc.get_output_tuple_s(1),  # max_dist
            proc.get_output_tuple_s(2),  # avg_dist
            proc.get_output_tuple_s(3)   # sigma_dist
        )  # type: ignore


def dist_rectangle2_contour_points_xld(
    contour: HObject,
    clipping_end_points: int,
    row: float,
    column: float,
    phi: float,
    length_1: float,
    length_2: float
) -> Sequence[float]:
    """
    Compute the distances of all contour points to a rectangle.

    Parameters
    ----------

    contour : HObject
              Input contour.

    clipping_end_points : int
                          Number of points at the beginning and the end of
                          the contours to be ignored for the computation
                          of distances.
                          Value Suggestion: 0
                          Assertion: ClippingEndPoints >= 0

    row : float
          Row coordinate of the center of the rectangle.

    column : float
             Column coordinate of the center of the rectangle.

    phi : float
          Orientation of the main axis of the rectangle [rad].

    length_1 : float
               First radius (half length) of the rectangle.
               Assertion: Length1 > 0

    length_2 : float
               Second radius (half width) of the rectangle.
               Assertion: Length2 >= 0

    Returns
    -------

    distances : Sequence[float]
                Distances of the contour points to the rectangle.

    Predecessors
    ------------
    fit_rectangle2_contour_xld
    """
    with HalconOperator(25) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, clipping_end_points)
        proc.set_input_tuple(1, row)
        proc.set_input_tuple(2, column)
        proc.set_input_tuple(3, phi)
        proc.set_input_tuple(4, length_1)
        proc.set_input_tuple(5, length_2)
        proc.init_oct(0)
        proc.execute()
        distances = proc.get_output_tuple_m(0)
        return distances  # type: ignore


def distance_cc(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between two contours.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: point_to_point

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between both contours.

    distance_max : Sequence[float]
                   Maximum distance between both contours.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc_min, distance_contours_xld

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(1363) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_cc_min(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> Sequence[float]:
    """
    Calculate the minimum distance between two contours.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: fast_point_to_segment

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the two contours.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc, distance_contours_xld

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(1362) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.execute()
        distance_min = proc.get_output_tuple_m(0)
        return distance_min  # type: ignore


def distance_cc_min_points(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> Tuple[Sequence[float], Sequence[float], Sequence[float], Sequence[float], Sequence[float]]:
    """
    Calculate the minimum distance between two contours and the points
    used for the calculation.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: fast_point_to_segment

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the two contours.

    row_1 : Sequence[float]
            Row coordinate of the point on Contour1.

    column_1 : Sequence[float]
               Column coordinate of the point on Contour1.

    row_2 : Sequence[float]
            Row coordinate of the point on Contour2.

    column_2 : Sequence[float]
               Column coordinate of the point on Contour2.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc, distance_contours_xld,
    distance_cc_min

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(2111) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1),  # row_1
            proc.get_output_tuple_m(2),  # column_1
            proc.get_output_tuple_m(3),  # row_2
            proc.get_output_tuple_m(4)   # column_2
        )  # type: ignore


def distance_cc_min_points_s(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> Tuple[float, float, float, float, float]:
    """
    Calculate the minimum distance between two contours and the points
    used for the calculation.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: fast_point_to_segment

    Returns
    -------

    distance_min : float
                   Minimum distance between the two contours.

    row_1 : float
            Row coordinate of the point on Contour1.

    column_1 : float
               Column coordinate of the point on Contour1.

    row_2 : float
            Row coordinate of the point on Contour2.

    column_2 : float
               Column coordinate of the point on Contour2.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc, distance_contours_xld,
    distance_cc_min

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(2111) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1),  # row_1
            proc.get_output_tuple_s(2),  # column_1
            proc.get_output_tuple_s(3),  # row_2
            proc.get_output_tuple_s(4)   # column_2
        )  # type: ignore


def distance_cc_min_s(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> float:
    """
    Calculate the minimum distance between two contours.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: fast_point_to_segment

    Returns
    -------

    distance_min : float
                   Minimum distance between the two contours.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc, distance_contours_xld

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(1362) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.execute()
        distance_min = proc.get_output_tuple_s(0)
        return distance_min  # type: ignore


def distance_cc_s(
    contour_1: HObject,
    contour_2: HObject,
    mode: str
) -> Tuple[float, float]:
    """
    Calculate the distance between two contours.

    Parameters
    ----------

    contour_1 : HObject
                First input contour.

    contour_2 : HObject
                Second input contour.

    mode : str
           Distance calculation mode.
           Value Suggestion: point_to_point

    Returns
    -------

    distance_min : float
                   Minimum distance between both contours.

    distance_max : float
                   Maximum distance between both contours.

    See Also
    --------
    distance_sr, distance_pr

    Alternatives
    ------------
    distance_sc, distance_pc, distance_cc_min, distance_contours_xld

    Notes
    -----
    Both iconic input parameters must contain the same number of contours.
    """
    with HalconOperator(1363) as proc:
        proc.set_input_object(1, contour_1)
        proc.set_input_object(2, contour_2)
        proc.set_input_tuple(0, mode)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_contours_xld(
    contour_from: HObject,
    contour_to: HObject,
    mode: str
) -> HObject:
    """
    Calculate the pointwise distance from one contour to another.

    Parameters
    ----------

    contour_from : HObject
                   Contours for whose points the distances are calculated.

    contour_to : HObject
                 Contours to which the distances are calculated to.

    mode : str
           Compute the distance to points ('point_to_point') or to entire
           segments ('point_to_segment').
           Value Suggestion: point_to_point

    Returns
    -------

    contour_out : HObject
                  Copy of ContourFrom containing the distances as an
                  attribute.

    Alternatives
    ------------
    apply_distance_transform_xld, distance_cc, distance_cc_min

    Successors
    ----------
    get_contour_attrib_xld, segment_contour_attrib_xld
    """
    with HalconOperator(1361) as proc:
        proc.set_input_object(1, contour_from)
        proc.set_input_object(2, contour_to)
        proc.set_input_tuple(0, mode)
        proc.execute()
        contour_out = HObject(proc.get_output_object_key(1))
        return contour_out  # type: ignore


def distance_funct_1d(
    function_1: Sequence[Union[float, int]],
    function_2: Sequence[Union[float, int]],
    mode: MaybeSequence[str],
    sigma: MaybeSequence[float]
) -> Sequence[Union[float, int]]:
    """
    Compute the distance of two functions.

    Parameters
    ----------

    function_1 : Sequence[Union[float, int]]
                 Input function 1.

    function_2 : Sequence[Union[float, int]]
                 Input function 2.

    mode : MaybeSequence[str]
           Modes of invariants.
           Value Suggestion: length

    sigma : MaybeSequence[float]
            Variance of the optional smoothing with a Gaussian filter.
            Value Suggestion: 0.0

    Returns
    -------

    distance : Sequence[Union[float, int]]
               Distance of the functions.
    """
    with HalconOperator(1394) as proc:
        proc.set_input_tuple(0, function_1)
        proc.set_input_tuple(1, function_2)
        proc.set_input_tuple(2, mode)
        proc.set_input_tuple(3, sigma)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def distance_lc(
    contour: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a line and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line and the contour.

    distance_max : Sequence[float]
                   Maximum distance between the line and the contour.

    See Also
    --------
    distance_lr, distance_pr, distance_sr

    Alternatives
    ------------
    distance_pc, distance_sc, distance_cc, distance_cc_min
    """
    with HalconOperator(1365) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_lc_s(
    contour: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a line and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line and the contour.

    distance_max : float
                   Maximum distance between the line and the contour.

    See Also
    --------
    distance_lr, distance_pr, distance_sr

    Alternatives
    ------------
    distance_pc, distance_sc, distance_cc, distance_cc_min
    """
    with HalconOperator(1365) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_lr(
    region: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a line and a region.

    Parameters
    ----------

    region : HObject
             Input region.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line and the region

    distance_max : Sequence[float]
                   Maximum distance between the line and the region

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_lc, distance_pr, distance_sr, diameter_region

    Notes
    -----
    Due to efficiency of distance_lr holes are ignored.
    """
    with HalconOperator(1368) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_lr_s(
    region: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a line and a region.

    Parameters
    ----------

    region : HObject
             Input region.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line and the region

    distance_max : float
                   Maximum distance between the line and the region

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_lc, distance_pr, distance_sr, diameter_region

    Notes
    -----
    Due to efficiency of distance_lr holes are ignored.
    """
    with HalconOperator(1368) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_object_model_3d(
    object_model_3dfrom: HHandle,
    object_model_3dto: HHandle,
    pose: Sequence[Union[float, int]],
    max_distance: Union[float, int],
    gen_param_name: MaybeSequence[str],
    gen_param_value: MaybeSequence[Union[int, str, float]]
) -> None:
    """
    Compute the distances of the points of one 3D object model to another
    3D object model.

    Parameters
    ----------

    object_model_3dfrom : HHandle
                          Handle of the source 3D object model.

    object_model_3dto : HHandle
                        Handle of the target 3D object model.

    pose : Sequence[Union[float, int]]
           Pose of the source 3D object model in the target 3D object
           model.
           Value Suggestion: []

    max_distance : Union[float, int]
                   Maximum distance of interest.
                   Value Suggestion: 0

    gen_param_name : MaybeSequence[str]
                     Names of the generic input parameters.
                     Value Suggestion: []

    gen_param_value : MaybeSequence[Union[int, str, float]]
                      Values of the generic input parameters.
                      Value Suggestion: []

    See Also
    --------
    prepare_object_model_3d

    Predecessors
    ------------
    prepare_object_model_3d, read_object_model_3d, find_surface_model,
    xyz_to_object_model_3d

    Successors
    ----------
    get_object_model_3d_params, render_object_model_3d,
    disp_object_model_3d, clear_object_model_3d
    """
    with HalconOperator(1061) as proc:
        proc.set_input_tuple(0, object_model_3dfrom)
        proc.set_input_tuple(1, object_model_3dto)
        proc.set_input_tuple(2, pose)
        proc.set_input_tuple(3, max_distance)
        proc.set_input_tuple(4, gen_param_name)
        proc.set_input_tuple(5, gen_param_value)
        proc.execute()


def distance_pc(
    contour: HObject,
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a point and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the point.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the point and the contour.

    distance_max : Sequence[float]
                   Maximum distance between the point and the contour.

    See Also
    --------
    distance_pr, distance_lr, distance_sr, hamming_distance,
    select_xld_point, test_xld_point

    Alternatives
    ------------
    distance_lc, distance_sc, distance_cc, distance_cc_min
    """
    with HalconOperator(1366) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_pc_s(
    contour: HObject,
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a point and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the point.

    Returns
    -------

    distance_min : float
                   Minimum distance between the point and the contour.

    distance_max : float
                   Maximum distance between the point and the contour.

    See Also
    --------
    distance_pr, distance_lr, distance_sr, hamming_distance,
    select_xld_point, test_xld_point

    Alternatives
    ------------
    distance_lc, distance_sc, distance_cc, distance_cc_min
    """
    with HalconOperator(1366) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_pl(
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]],
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the distance between one point and one line.

    Parameters
    ----------

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column of the point.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance : Sequence[float]
               Distance between the points.

    See Also
    --------
    distance_pp, distance_pr

    Alternatives
    ------------
    distance_ps
    """
    with HalconOperator(1375) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, row_1)
        proc.set_input_tuple(3, column_1)
        proc.set_input_tuple(4, row_2)
        proc.set_input_tuple(5, column_2)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def distance_pl_s(
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]],
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the distance between one point and one line.

    Parameters
    ----------

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column of the point.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line.

    Returns
    -------

    distance : float
               Distance between the points.

    See Also
    --------
    distance_pp, distance_pr

    Alternatives
    ------------
    distance_ps
    """
    with HalconOperator(1375) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, row_1)
        proc.set_input_tuple(3, column_1)
        proc.set_input_tuple(4, row_2)
        proc.set_input_tuple(5, column_2)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_s(0)
        return distance  # type: ignore


def distance_point_line(
    point_x: MaybeSequence[float],
    point_y: MaybeSequence[float],
    point_z: MaybeSequence[float],
    point_1x: MaybeSequence[Union[float, int]],
    point_1y: MaybeSequence[Union[float, int]],
    point_1z: MaybeSequence[Union[float, int]],
    point_2x: MaybeSequence[Union[float, int]],
    point_2y: MaybeSequence[Union[float, int]],
    point_2z: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the distance between a 3D point and a 3D line given by two
    points on the line.

    Parameters
    ----------

    point_x : MaybeSequence[float]
              X coordinate of the original points.

    point_y : MaybeSequence[float]
              Y coordinate of the original points.

    point_z : MaybeSequence[float]
              Z coordinate of the original points.

    point_1x : MaybeSequence[Union[float, int]]
               X coordinate of the first point on the line.

    point_1y : MaybeSequence[Union[float, int]]
               Y coordinate of the first point on the line.

    point_1z : MaybeSequence[Union[float, int]]
               Z coordinate of the first point on the line.

    point_2x : MaybeSequence[Union[float, int]]
               X coordinate of the second point on the line.

    point_2y : MaybeSequence[Union[float, int]]
               Y coordinate of the second point on the line.

    point_2z : MaybeSequence[Union[float, int]]
               Z coordinate of the second point on the line.

    Returns
    -------

    distance : Sequence[float]
               Distance between the points and the lines.

    See Also
    --------
    point_pluecker_line_to_hom_mat3d

    Alternatives
    ------------
    distance_point_pluecker_line

    Predecessors
    ------------
    get_line_of_sight
    """
    with HalconOperator(2263) as proc:
        proc.set_input_tuple(0, point_x)
        proc.set_input_tuple(1, point_y)
        proc.set_input_tuple(2, point_z)
        proc.set_input_tuple(3, point_1x)
        proc.set_input_tuple(4, point_1y)
        proc.set_input_tuple(5, point_1z)
        proc.set_input_tuple(6, point_2x)
        proc.set_input_tuple(7, point_2y)
        proc.set_input_tuple(8, point_2z)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def distance_point_line_s(
    point_x: MaybeSequence[float],
    point_y: MaybeSequence[float],
    point_z: MaybeSequence[float],
    point_1x: MaybeSequence[Union[float, int]],
    point_1y: MaybeSequence[Union[float, int]],
    point_1z: MaybeSequence[Union[float, int]],
    point_2x: MaybeSequence[Union[float, int]],
    point_2y: MaybeSequence[Union[float, int]],
    point_2z: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the distance between a 3D point and a 3D line given by two
    points on the line.

    Parameters
    ----------

    point_x : MaybeSequence[float]
              X coordinate of the original points.

    point_y : MaybeSequence[float]
              Y coordinate of the original points.

    point_z : MaybeSequence[float]
              Z coordinate of the original points.

    point_1x : MaybeSequence[Union[float, int]]
               X coordinate of the first point on the line.

    point_1y : MaybeSequence[Union[float, int]]
               Y coordinate of the first point on the line.

    point_1z : MaybeSequence[Union[float, int]]
               Z coordinate of the first point on the line.

    point_2x : MaybeSequence[Union[float, int]]
               X coordinate of the second point on the line.

    point_2y : MaybeSequence[Union[float, int]]
               Y coordinate of the second point on the line.

    point_2z : MaybeSequence[Union[float, int]]
               Z coordinate of the second point on the line.

    Returns
    -------

    distance : float
               Distance between the points and the lines.

    See Also
    --------
    point_pluecker_line_to_hom_mat3d

    Alternatives
    ------------
    distance_point_pluecker_line

    Predecessors
    ------------
    get_line_of_sight
    """
    with HalconOperator(2263) as proc:
        proc.set_input_tuple(0, point_x)
        proc.set_input_tuple(1, point_y)
        proc.set_input_tuple(2, point_z)
        proc.set_input_tuple(3, point_1x)
        proc.set_input_tuple(4, point_1y)
        proc.set_input_tuple(5, point_1z)
        proc.set_input_tuple(6, point_2x)
        proc.set_input_tuple(7, point_2y)
        proc.set_input_tuple(8, point_2z)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_s(0)
        return distance  # type: ignore


def distance_point_pluecker_line(
    point_x: MaybeSequence[float],
    point_y: MaybeSequence[float],
    point_z: MaybeSequence[float],
    line_direction_x: MaybeSequence[Union[float, int]],
    line_direction_y: MaybeSequence[Union[float, int]],
    line_direction_z: MaybeSequence[Union[float, int]],
    line_moment_x: MaybeSequence[Union[float, int]],
    line_moment_y: MaybeSequence[Union[float, int]],
    line_moment_z: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the distance between a 3D point and a 3D line given by
    Plücker coordinates.

    Parameters
    ----------

    point_x : MaybeSequence[float]
              X coordinates of the original points.

    point_y : MaybeSequence[float]
              Y coordinates of the original points.

    point_z : MaybeSequence[float]
              Z coordinates of the original points.

    line_direction_x : MaybeSequence[Union[float, int]]
                       X component of the direction vector of the
                       corresponding line.

    line_direction_y : MaybeSequence[Union[float, int]]
                       Y component of the direction vector of the
                       corresponding line.

    line_direction_z : MaybeSequence[Union[float, int]]
                       Z component of the direction vector of the
                       corresponding line.

    line_moment_x : MaybeSequence[Union[float, int]]
                    X component of the moment vector of the corresponding
                    line.

    line_moment_y : MaybeSequence[Union[float, int]]
                    Y component of the moment vector of the corresponding
                    line.

    line_moment_z : MaybeSequence[Union[float, int]]
                    Z component of the moment vector of the corresponding
                    line.

    Returns
    -------

    distance : Sequence[float]
               Distance between the points and the lines.

    See Also
    --------
    point_pluecker_line_to_hom_mat3d

    Alternatives
    ------------
    distance_point_line

    Predecessors
    ------------
    points_to_pluecker_line, point_direction_to_pluecker_line
    """
    with HalconOperator(2264) as proc:
        proc.set_input_tuple(0, point_x)
        proc.set_input_tuple(1, point_y)
        proc.set_input_tuple(2, point_z)
        proc.set_input_tuple(3, line_direction_x)
        proc.set_input_tuple(4, line_direction_y)
        proc.set_input_tuple(5, line_direction_z)
        proc.set_input_tuple(6, line_moment_x)
        proc.set_input_tuple(7, line_moment_y)
        proc.set_input_tuple(8, line_moment_z)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def distance_point_pluecker_line_s(
    point_x: MaybeSequence[float],
    point_y: MaybeSequence[float],
    point_z: MaybeSequence[float],
    line_direction_x: MaybeSequence[Union[float, int]],
    line_direction_y: MaybeSequence[Union[float, int]],
    line_direction_z: MaybeSequence[Union[float, int]],
    line_moment_x: MaybeSequence[Union[float, int]],
    line_moment_y: MaybeSequence[Union[float, int]],
    line_moment_z: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the distance between a 3D point and a 3D line given by
    Plücker coordinates.

    Parameters
    ----------

    point_x : MaybeSequence[float]
              X coordinates of the original points.

    point_y : MaybeSequence[float]
              Y coordinates of the original points.

    point_z : MaybeSequence[float]
              Z coordinates of the original points.

    line_direction_x : MaybeSequence[Union[float, int]]
                       X component of the direction vector of the
                       corresponding line.

    line_direction_y : MaybeSequence[Union[float, int]]
                       Y component of the direction vector of the
                       corresponding line.

    line_direction_z : MaybeSequence[Union[float, int]]
                       Z component of the direction vector of the
                       corresponding line.

    line_moment_x : MaybeSequence[Union[float, int]]
                    X component of the moment vector of the corresponding
                    line.

    line_moment_y : MaybeSequence[Union[float, int]]
                    Y component of the moment vector of the corresponding
                    line.

    line_moment_z : MaybeSequence[Union[float, int]]
                    Z component of the moment vector of the corresponding
                    line.

    Returns
    -------

    distance : float
               Distance between the points and the lines.

    See Also
    --------
    point_pluecker_line_to_hom_mat3d

    Alternatives
    ------------
    distance_point_line

    Predecessors
    ------------
    points_to_pluecker_line, point_direction_to_pluecker_line
    """
    with HalconOperator(2264) as proc:
        proc.set_input_tuple(0, point_x)
        proc.set_input_tuple(1, point_y)
        proc.set_input_tuple(2, point_z)
        proc.set_input_tuple(3, line_direction_x)
        proc.set_input_tuple(4, line_direction_y)
        proc.set_input_tuple(5, line_direction_z)
        proc.set_input_tuple(6, line_moment_x)
        proc.set_input_tuple(7, line_moment_y)
        proc.set_input_tuple(8, line_moment_z)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_s(0)
        return distance  # type: ignore


def distance_pp(
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Sequence[float]:
    """
    Calculate the distance between two points.

    Parameters
    ----------

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point.

    Returns
    -------

    distance : Sequence[float]
               Distance between the points.

    See Also
    --------
    distance_pl, distance_pr

    Alternatives
    ------------
    distance_ps
    """
    with HalconOperator(1376) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_m(0)
        return distance  # type: ignore


def distance_pp_s(
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> float:
    """
    Calculate the distance between two points.

    Parameters
    ----------

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point.

    Returns
    -------

    distance : float
               Distance between the points.

    See Also
    --------
    distance_pl, distance_pr

    Alternatives
    ------------
    distance_ps
    """
    with HalconOperator(1376) as proc:
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.execute()
        distance = proc.get_output_tuple_s(0)
        return distance  # type: ignore


def distance_pr(
    region: HObject,
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a point and a region.

    Parameters
    ----------

    region : HObject
             Input region.

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the point.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the point and the region.

    distance_max : Sequence[float]
                   Maximum distance between the point and the region.

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_pc, distance_lr, distance_sr, diameter_region
    """
    with HalconOperator(1369) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_pr_s(
    region: HObject,
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a point and a region.

    Parameters
    ----------

    region : HObject
             Input region.

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the point.

    Returns
    -------

    distance_min : float
                   Minimum distance between the point and the region.

    distance_max : float
                   Maximum distance between the point and the region.

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_pc, distance_lr, distance_sr, diameter_region
    """
    with HalconOperator(1369) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_ps(
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]],
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distances between a point and a line segment.

    Parameters
    ----------

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the first point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the first point.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the point and the line segment.

    distance_max : Sequence[float]
                   Maximum distance between the point and the line segment.

    See Also
    --------
    distance_pp, distance_pr

    Alternatives
    ------------
    distance_pl
    """
    with HalconOperator(1374) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, row_1)
        proc.set_input_tuple(3, column_1)
        proc.set_input_tuple(4, row_2)
        proc.set_input_tuple(5, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_ps_s(
    row: MaybeSequence[Union[float, int]],
    column: MaybeSequence[Union[float, int]],
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distances between a point and a line segment.

    Parameters
    ----------

    row : MaybeSequence[Union[float, int]]
          Row coordinate of the first point.

    column : MaybeSequence[Union[float, int]]
             Column coordinate of the first point.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : float
                   Minimum distance between the point and the line segment.

    distance_max : float
                   Maximum distance between the point and the line segment.

    See Also
    --------
    distance_pp, distance_pr

    Alternatives
    ------------
    distance_pl
    """
    with HalconOperator(1374) as proc:
        proc.set_input_tuple(0, row)
        proc.set_input_tuple(1, column)
        proc.set_input_tuple(2, row_1)
        proc.set_input_tuple(3, column_1)
        proc.set_input_tuple(4, row_2)
        proc.set_input_tuple(5, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_rr_min(
    regions_1: HObject,
    regions_2: HObject
) -> Tuple[Sequence[float], Sequence[int], Sequence[int], Sequence[int], Sequence[int]]:
    """
    Minimum distance between the contour pixels of two regions each.

    Parameters
    ----------

    regions_1 : HObject
                Regions to be examined.

    regions_2 : HObject
                Regions to be examined.

    Returns
    -------

    min_distance : Sequence[float]
                   Minimum distance between contours of the regions.
                   Assertion: 0 <= MinDistance

    row_1 : Sequence[int]
            Line index on contour in Regions1.

    column_1 : Sequence[int]
               Column index on contour in Regions1.

    row_2 : Sequence[int]
            Line index on contour in Regions2.

    column_2 : Sequence[int]
               Column index on contour in Regions2.

    Alternatives
    ------------
    distance_rr_min_dil, dilation1, intersection

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Both input parameters must contain the same number of regions.  The
    regions must not be empty.
    """
    with HalconOperator(1709) as proc:
        proc.set_input_object(1, regions_1)
        proc.set_input_object(2, regions_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # min_distance
            proc.get_output_tuple_m(1),  # row_1
            proc.get_output_tuple_m(2),  # column_1
            proc.get_output_tuple_m(3),  # row_2
            proc.get_output_tuple_m(4)   # column_2
        )  # type: ignore


def distance_rr_min_dil(
    regions_1: HObject,
    regions_2: HObject
) -> Sequence[int]:
    """
    Minimum distance between two regions with the help of dilation.

    Parameters
    ----------

    regions_1 : HObject
                Regions to be examined.

    regions_2 : HObject
                Regions to be examined.

    Returns
    -------

    min_distance : Sequence[int]
                   Minimum distances of the regions.
                   Assertion: -1 <= MinDistance

    Alternatives
    ------------
    distance_rr_min, dilation1, intersection

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Both parameters must contain the same number of regions. The regions
    must not be empty.
    """
    with HalconOperator(1710) as proc:
        proc.set_input_object(1, regions_1)
        proc.set_input_object(2, regions_2)
        proc.init_oct(0)
        proc.execute()
        min_distance = proc.get_output_tuple_m(0)
        return min_distance  # type: ignore


def distance_rr_min_dil_s(
    regions_1: HObject,
    regions_2: HObject
) -> int:
    """
    Minimum distance between two regions with the help of dilation.

    Parameters
    ----------

    regions_1 : HObject
                Regions to be examined.

    regions_2 : HObject
                Regions to be examined.

    Returns
    -------

    min_distance : int
                   Minimum distances of the regions.
                   Assertion: -1 <= MinDistance

    Alternatives
    ------------
    distance_rr_min, dilation1, intersection

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Both parameters must contain the same number of regions. The regions
    must not be empty.
    """
    with HalconOperator(1710) as proc:
        proc.set_input_object(1, regions_1)
        proc.set_input_object(2, regions_2)
        proc.init_oct(0)
        proc.execute()
        min_distance = proc.get_output_tuple_s(0)
        return min_distance  # type: ignore


def distance_rr_min_s(
    regions_1: HObject,
    regions_2: HObject
) -> Tuple[float, int, int, int, int]:
    """
    Minimum distance between the contour pixels of two regions each.

    Parameters
    ----------

    regions_1 : HObject
                Regions to be examined.

    regions_2 : HObject
                Regions to be examined.

    Returns
    -------

    min_distance : float
                   Minimum distance between contours of the regions.
                   Assertion: 0 <= MinDistance

    row_1 : int
            Line index on contour in Regions1.

    column_1 : int
               Column index on contour in Regions1.

    row_2 : int
            Line index on contour in Regions2.

    column_2 : int
               Column index on contour in Regions2.

    Alternatives
    ------------
    distance_rr_min_dil, dilation1, intersection

    Predecessors
    ------------
    threshold, regiongrowing, connection

    Notes
    -----
    Both input parameters must contain the same number of regions.  The
    regions must not be empty.
    """
    with HalconOperator(1709) as proc:
        proc.set_input_object(1, regions_1)
        proc.set_input_object(2, regions_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.init_oct(4)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # min_distance
            proc.get_output_tuple_s(1),  # row_1
            proc.get_output_tuple_s(2),  # column_1
            proc.get_output_tuple_s(3),  # row_2
            proc.get_output_tuple_s(4)   # column_2
        )  # type: ignore


def distance_sc(
    contour: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a line segment and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line segment and the
                   contour.

    distance_max : Sequence[float]
                   Maximum distance between the line segment and the
                   contour.

    See Also
    --------
    distance_sr, distance_lr, distance_pr, select_xld_point, test_xld_point

    Alternatives
    ------------
    distance_lc, distance_pc, distance_cc, distance_cc_min
    """
    with HalconOperator(1364) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_sc_s(
    contour: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a line segment and one contour.

    Parameters
    ----------

    contour : HObject
              Input contour.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line segment and the
                   contour.

    distance_max : float
                   Maximum distance between the line segment and the
                   contour.

    See Also
    --------
    distance_sr, distance_lr, distance_pr, select_xld_point, test_xld_point

    Alternatives
    ------------
    distance_lc, distance_pc, distance_cc, distance_cc_min
    """
    with HalconOperator(1364) as proc:
        proc.set_input_object(1, contour)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_sl(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distances between a line segment and a line.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line segment.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line segment.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line segment.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line segment.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line segment and the line.

    distance_max : Sequence[float]
                   Maximum distance between the line segment and the line.

    See Also
    --------
    distance_ps, distance_pp

    Alternatives
    ------------
    distance_pl
    """
    with HalconOperator(1372) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_sl_s(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distances between a line segment and a line.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line segment.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line segment.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line segment.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line segment.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line segment and the line.

    distance_max : float
                   Maximum distance between the line segment and the line.

    See Also
    --------
    distance_ps, distance_pp

    Alternatives
    ------------
    distance_pl
    """
    with HalconOperator(1372) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_sr(
    region: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distance between a line segment and one region.

    Parameters
    ----------

    region : HObject
             Input region.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line segment and the
                   region.

    distance_max : Sequence[float]
                   Maximum distance between the line segment and the
                   region.

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_sc, distance_lr, distance_pr, diameter_region

    Notes
    -----
    To enhance distance_sr, holes are ignored.
    """
    with HalconOperator(1367) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_sr_s(
    region: HObject,
    row_1: MaybeSequence[Union[float, int]],
    column_1: MaybeSequence[Union[float, int]],
    row_2: MaybeSequence[Union[float, int]],
    column_2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distance between a line segment and one region.

    Parameters
    ----------

    region : HObject
             Input region.

    row_1 : MaybeSequence[Union[float, int]]
            Row coordinate of the first point of the line segment.

    column_1 : MaybeSequence[Union[float, int]]
               Column coordinate of the first point of the line segment.

    row_2 : MaybeSequence[Union[float, int]]
            Row coordinate of the second point of the line segment.

    column_2 : MaybeSequence[Union[float, int]]
               Column coordinate of the second point of the line segment.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line segment and the
                   region.

    distance_max : float
                   Maximum distance between the line segment and the
                   region.

    See Also
    --------
    hamming_distance, select_region_point, test_region_point,
    smallest_rectangle2

    Alternatives
    ------------
    distance_sc, distance_lr, distance_pr, diameter_region

    Notes
    -----
    To enhance distance_sr, holes are ignored.
    """
    with HalconOperator(1367) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, row_1)
        proc.set_input_tuple(1, column_1)
        proc.set_input_tuple(2, row_2)
        proc.set_input_tuple(3, column_2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_ss(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> Tuple[Sequence[float], Sequence[float]]:
    """
    Calculate the distances between two line segments.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line segment.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line segment.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line segment.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line segment.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column of the first point of the line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : Sequence[float]
                   Minimum distance between the line segments.

    distance_max : Sequence[float]
                   Maximum distance between the line segments.

    See Also
    --------
    distance_pl, distance_ps

    Alternatives
    ------------
    distance_pp
    """
    with HalconOperator(1373) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # distance_min
            proc.get_output_tuple_m(1)   # distance_max
        )  # type: ignore


def distance_ss_s(
    row_a1: MaybeSequence[Union[float, int]],
    column_a1: MaybeSequence[Union[float, int]],
    row_a2: MaybeSequence[Union[float, int]],
    column_a2: MaybeSequence[Union[float, int]],
    row_b1: MaybeSequence[Union[float, int]],
    column_b1: MaybeSequence[Union[float, int]],
    row_b2: MaybeSequence[Union[float, int]],
    column_b2: MaybeSequence[Union[float, int]]
) -> Tuple[float, float]:
    """
    Calculate the distances between two line segments.

    Parameters
    ----------

    row_a1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line segment.

    column_a1 : MaybeSequence[Union[float, int]]
                Column coordinate of the first point of the line segment.

    row_a2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line segment.

    column_a2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line segment.

    row_b1 : MaybeSequence[Union[float, int]]
             Row coordinate of the first point of the line.

    column_b1 : MaybeSequence[Union[float, int]]
                Column of the first point of the line.

    row_b2 : MaybeSequence[Union[float, int]]
             Row coordinate of the second point of the line.

    column_b2 : MaybeSequence[Union[float, int]]
                Column coordinate of the second point of the line.

    Returns
    -------

    distance_min : float
                   Minimum distance between the line segments.

    distance_max : float
                   Maximum distance between the line segments.

    See Also
    --------
    distance_pl, distance_ps

    Alternatives
    ------------
    distance_pp
    """
    with HalconOperator(1373) as proc:
        proc.set_input_tuple(0, row_a1)
        proc.set_input_tuple(1, column_a1)
        proc.set_input_tuple(2, row_a2)
        proc.set_input_tuple(3, column_a2)
        proc.set_input_tuple(4, row_b1)
        proc.set_input_tuple(5, column_b1)
        proc.set_input_tuple(6, row_b2)
        proc.set_input_tuple(7, column_b2)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # distance_min
            proc.get_output_tuple_s(1)   # distance_max
        )  # type: ignore


def distance_to_disparity(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    distance: MaybeSequence[float]
) -> Sequence[Union[int, float]]:
    """
    Transform a distance value into a disparity in a rectified stereo
    system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    distance : MaybeSequence[float]
               Distance of a world point to camera 1.

    Returns
    -------

    disparity : Sequence[Union[int, float]]
                Disparity between the images of the point.

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map

    Successors
    ----------
    binocular_disparity

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For stereo setups of mixed type (i.e., for a stereo setup in which one
    of the original cameras is a perspective camera and the other camera
    is a telecentric camera; see gen_binocular_rectification_map), the
    rectifying plane of the two cameras is in a position with respect to
    the object that would lead to very unintuitive distances.  Therefore,
    distance_to_disparity does not support stereo setups of mixed type.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(368) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, distance)
        proc.init_oct(0)
        proc.execute()
        disparity = proc.get_output_tuple_m(0)
        return disparity  # type: ignore


def distance_to_disparity_s(
    cam_param_rect_1: Sequence[Union[int, float, str]],
    cam_param_rect_2: Sequence[Union[int, float, str]],
    rel_pose_rect: Sequence[Union[int, float]],
    distance: MaybeSequence[float]
) -> Union[int, float]:
    """
    Transform a distance value into a disparity in a rectified stereo
    system.

    Parameters
    ----------

    cam_param_rect_1 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 1.

    cam_param_rect_2 : Sequence[Union[int, float, str]]
                       Rectified internal camera parameters of camera 2.

    rel_pose_rect : Sequence[Union[int, float]]
                    Point transformation from the rectified camera 2 to
                    the rectified camera 1.

    distance : MaybeSequence[float]
               Distance of a world point to camera 1.

    Returns
    -------

    disparity : Union[int, float]
                Disparity between the images of the point.

    Predecessors
    ------------
    binocular_calibration, gen_binocular_rectification_map

    Successors
    ----------
    binocular_disparity

    Notes
    -----
    If using cameras with telecentric lenses, the Distance is not defined
    as the distance of a point to the camera but as the distance from the
    point to the plane, defined by the y-axes of both cameras and their
    baseline (see gen_binocular_rectification_map).
    For stereo setups of mixed type (i.e., for a stereo setup in which one
    of the original cameras is a perspective camera and the other camera
    is a telecentric camera; see gen_binocular_rectification_map), the
    rectifying plane of the two cameras is in a position with respect to
    the object that would lead to very unintuitive distances.  Therefore,
    distance_to_disparity does not support stereo setups of mixed type.
    Additionally, stereo setups that contain cameras with and without
    hypercentric lenses at the same time are not supported.
    """
    with HalconOperator(368) as proc:
        proc.set_input_tuple(0, cam_param_rect_1)
        proc.set_input_tuple(1, cam_param_rect_2)
        proc.set_input_tuple(2, rel_pose_rect)
        proc.set_input_tuple(3, distance)
        proc.init_oct(0)
        proc.execute()
        disparity = proc.get_output_tuple_s(0)
        return disparity  # type: ignore


def distance_transform(
    region: HObject,
    metric: str,
    foreground: str,
    width: int,
    height: int
) -> HObject:
    """
    Compute the distance transformation of a region.

    Parameters
    ----------

    region : HObject
             Region for which the distance to the border is computed.

    metric : str
             Type of metric to be used for the distance transformation.
             Value Suggestion: 'city-block'

    foreground : str
                 Compute the distance for pixels inside (true) or outside
                 (false) the input region.
                 Value Suggestion: true

    width : int
            Width of the output image.
            Value Suggestion: 640

    height : int
             Height of the output image.
             Value Suggestion: 480

    Returns
    -------

    distance_image : HObject
                     Image containing the distance information.

    See Also
    --------
    skeleton

    Alternatives
    ------------
    closest_point_transform

    Predecessors
    ------------
    threshold, dyn_threshold, regiongrowing

    Successors
    ----------
    threshold
    """
    with HalconOperator(485) as proc:
        proc.set_input_object(1, region)
        proc.set_input_tuple(0, metric)
        proc.set_input_tuple(1, foreground)
        proc.set_input_tuple(2, width)
        proc.set_input_tuple(3, height)
        proc.execute()
        distance_image = HObject(proc.get_output_object_key(1))
        return distance_image  # type: ignore


def div_element_matrix(
    matrix_aid: HHandle,
    matrix_bid: HHandle
) -> HHandle:
    """
    Divide matrices element-by-element.

    Parameters
    ----------

    matrix_aid : HHandle
                 Matrix handle of the input matrix A.

    matrix_bid : HHandle
                 Matrix handle of the input matrix B.

    Returns
    -------

    matrix_div_id : HHandle
                    Matrix handle with the divided values of input
                    matrices.

    See Also
    --------
    mult_element_matrix, mult_element_matrix_mod, scale_matrix,
    scale_matrix_mod

    Alternatives
    ------------
    div_element_matrix_mod

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(873) as proc:
        proc.set_input_tuple(0, matrix_aid)
        proc.set_input_tuple(1, matrix_bid)
        proc.init_oct(0)
        proc.execute()
        matrix_div_id = proc.get_output_tuple_s(0)
        return matrix_div_id  # type: ignore


def div_element_matrix_mod(
    matrix_aid: HHandle,
    matrix_bid: HHandle
) -> None:
    """
    Divide matrices element-by-element.

    Parameters
    ----------

    matrix_aid : HHandle
                 Matrix handle of the input matrix A.

    matrix_bid : HHandle
                 Matrix handle of the input matrix B.

    See Also
    --------
    mult_element_matrix, mult_element_matrix_mod, scale_matrix,
    scale_matrix_mod

    Alternatives
    ------------
    div_element_matrix

    Predecessors
    ------------
    create_matrix

    Successors
    ----------
    get_full_matrix, get_value_matrix
    """
    with HalconOperator(872) as proc:
        proc.set_input_tuple(0, matrix_aid)
        proc.set_input_tuple(1, matrix_bid)
        proc.execute()


def div_image(
    image_1: HObject,
    image_2: HObject,
    mult: Union[int, float],
    add: Union[int, float]
) -> HObject:
    """
    Divide two images.

    Parameters
    ----------

    image_1 : HObject
              Image(s) 1.

    image_2 : HObject
              Image(s) 2.

    mult : Union[int, float]
           Factor for gray range adaption.
           Value Suggestion: 255

    add : Union[int, float]
          Value for gray range adaption.
          Value Suggestion: 0

    Returns
    -------

    image_result : HObject
                   Result image(s) by the division.

    See Also
    --------
    add_image, sub_image, mult_image

    Alternatives
    ------------
    add_image, sub_image, mult_image
    """
    with HalconOperator(1608) as proc:
        proc.set_input_object(1, image_1)
        proc.set_input_object(2, image_2)
        proc.set_input_tuple(0, mult)
        proc.set_input_tuple(1, add)
        proc.execute()
        image_result = HObject(proc.get_output_object_key(1))
        return image_result  # type: ignore


def do_ocr_multi(
    character: HObject,
    image: HObject,
    ocr_handle: HHandle
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify characters.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values for the characters.

    ocr_handle : HHandle
                 ID of the OCR classifier.

    Returns
    -------

    class_val : Sequence[str]
                Class (name) of the characters.

    confidence : Sequence[float]
                 Confidence values of the characters.

    See Also
    --------
    write_ocr

    Alternatives
    ------------
    do_ocr_single

    Predecessors
    ------------
    traind_ocr_class_box, trainf_ocr_class_box, read_ocr, connection,
    sort_region

    Warnings
    --------
    do_ocr_multi is obsolete and is only provided for reasons of backward
    compatibility.  New applications should use the MLP, SVM or CNN based
    operators instead.
    """
    with HalconOperator(714) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocr_handle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_cnn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify multiple characters with an CNN-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the CNN.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    Alternatives
    ------------
    do_ocr_word_cnn, do_ocr_single_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2056) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_cnn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[str, float]:
    """
    Classify multiple characters with an CNN-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : str
                Result of classifying the characters with the CNN.

    confidence : float
                 Confidence of the class of the characters.

    Alternatives
    ------------
    do_ocr_word_cnn, do_ocr_single_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2056) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_knn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify multiple characters with an k-NN classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the k-NN classifier.

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the k-NN.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_single_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(658) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_knn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[str, float]:
    """
    Classify multiple characters with an k-NN classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the k-NN classifier.

    Returns
    -------

    class_val : str
                Result of classifying the characters with the k-NN.

    confidence : float
                 Confidence of the class of the characters.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_single_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(658) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_mlp(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify multiple characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the MLP.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_word_mlp, do_ocr_single_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(698) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_mlp_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Tuple[str, float]:
    """
    Classify multiple characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : str
                Result of classifying the characters with the MLP.

    confidence : float
                 Confidence of the class of the characters.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_word_mlp, do_ocr_single_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(698) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_multi_class_svm(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> Sequence[str]:
    """
    Classify multiple characters with an SVM-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the SVM.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_single_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(680) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_m(0)
        return class_val  # type: ignore


def do_ocr_multi_class_svm_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle
) -> str:
    """
    Classify multiple characters with an SVM-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    Returns
    -------

    class_val : str
                Result of classifying the characters with the SVM.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_single_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(680) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_s(0)
        return class_val  # type: ignore


def do_ocr_multi_s(
    character: HObject,
    image: HObject,
    ocr_handle: HHandle
) -> Tuple[str, float]:
    """
    Classify characters.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values for the characters.

    ocr_handle : HHandle
                 ID of the OCR classifier.

    Returns
    -------

    class_val : str
                Class (name) of the characters.

    confidence : float
                 Confidence values of the characters.

    See Also
    --------
    write_ocr

    Alternatives
    ------------
    do_ocr_single

    Predecessors
    ------------
    traind_ocr_class_box, trainf_ocr_class_box, read_ocr, connection,
    sort_region

    Warnings
    --------
    do_ocr_multi is obsolete and is only provided for reasons of backward
    compatibility.  New applications should use the MLP, SVM or CNN based
    operators instead.
    """
    with HalconOperator(714) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocr_handle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_single(
    character: HObject,
    image: HObject,
    ocr_handle: HHandle
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify one character.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the characters.

    ocr_handle : HHandle
                 ID of the OCR classifier.

    Returns
    -------

    classes : Sequence[str]
              Classes (names) of the characters.

    confidences : Sequence[float]
                  Confidence values of the characters.

    See Also
    --------
    write_ocr

    Alternatives
    ------------
    do_ocr_multi

    Predecessors
    ------------
    traind_ocr_class_box, trainf_ocr_class_box, read_ocr, connection,
    sort_region

    Warnings
    --------
    do_ocr_single is obsolete and is only provided for reasons of backward
    compatibility.  New applications should use the MLP, SVM or CNN based
    operators instead.
    """
    with HalconOperator(713) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocr_handle)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # classes
            proc.get_output_tuple_m(1)   # confidences
        )  # type: ignore


def do_ocr_single_class_cnn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify a single character with an CNN-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the character with the CNN.

    confidence : Sequence[float]
                 Confidence(s) of the class(es) of the character.

    Alternatives
    ------------
    do_ocr_multi_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2057) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_cnn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> Tuple[str, float]:
    """
    Classify a single character with an CNN-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : str
                Result of classifying the character with the CNN.

    confidence : float
                 Confidence(s) of the class(es) of the character.

    Alternatives
    ------------
    do_ocr_multi_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2057) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_knn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num_classes: Sequence[int],
    num_neighbors: Sequence[int]
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify a single character with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the k-NN classifier.

    num_classes : Sequence[int]
                  Number of maximal classes to determine.
                  Value Suggestion: 1

    num_neighbors : Sequence[int]
                    Number of neighbors to consider.
                    Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[str]
                Results of classifying the character with the k-NN.

    confidence : Sequence[float]
                 Confidence(s) of the class(es) of the character.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_multi_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(659) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num_classes)
        proc.set_input_tuple(2, num_neighbors)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_knn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num_classes: Sequence[int],
    num_neighbors: Sequence[int]
) -> Tuple[str, float]:
    """
    Classify a single character with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the k-NN classifier.

    num_classes : Sequence[int]
                  Number of maximal classes to determine.
                  Value Suggestion: 1

    num_neighbors : Sequence[int]
                    Number of neighbors to consider.
                    Value Suggestion: 1

    Returns
    -------

    class_val : str
                Results of classifying the character with the k-NN.

    confidence : float
                 Confidence(s) of the class(es) of the character.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_multi_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(659) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num_classes)
        proc.set_input_tuple(2, num_neighbors)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_mlp(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> Tuple[Sequence[str], Sequence[float]]:
    """
    Classify a single character with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the character with the MLP.

    confidence : Sequence[float]
                 Confidence(s) of the class(es) of the character.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_multi_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(699) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_mlp_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> Tuple[str, float]:
    """
    Classify a single character with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : str
                Result of classifying the character with the MLP.

    confidence : float
                 Confidence(s) of the class(es) of the character.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_multi_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(699) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1)   # confidence
        )  # type: ignore


def do_ocr_single_class_svm(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> Sequence[str]:
    """
    Classify a single character with an SVM-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the character with the SVM.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_multi_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(681) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_m(0)
        return class_val  # type: ignore


def do_ocr_single_class_svm_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    num: Sequence[int]
) -> str:
    """
    Classify a single character with an SVM-based OCR classifier.

    Parameters
    ----------

    character : HObject
                Character to be recognized.

    image : HObject
            Gray values of the character.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    num : Sequence[int]
          Number of best classes to determine.
          Value Suggestion: 1

    Returns
    -------

    class_val : str
                Result of classifying the character with the SVM.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_multi_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(681) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, num)
        proc.init_oct(0)
        proc.execute()
        class_val = proc.get_output_tuple_s(0)
        return class_val  # type: ignore


def do_ocr_word_cnn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[Sequence[str], Sequence[float], str, float]:
    """
    Classify a related group of characters with an CNN-based OCR
    classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the CNN.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    Alternatives
    ------------
    do_ocr_multi_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2058) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_cnn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[str, float, str, float]:
    """
    Classify a related group of characters with an CNN-based OCR
    classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : str
                Result of classifying the characters with the CNN.

    confidence : float
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    Alternatives
    ------------
    do_ocr_multi_class_cnn

    Predecessors
    ------------
    read_ocr_class_cnn
    """
    with HalconOperator(2058) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_knn(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[Sequence[str], Sequence[float], str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the k-NN.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_multi_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(647) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_knn_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[str, float, str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : str
                Result of classifying the characters with the k-NN.

    confidence : float
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_knn, classify_class_knn

    Alternatives
    ------------
    do_ocr_multi_class_knn

    Predecessors
    ------------
    trainf_ocr_class_knn, read_ocr_class_knn
    """
    with HalconOperator(647) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_mlp(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[Sequence[str], Sequence[float], str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the MLP.

    confidence : Sequence[float]
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_multi_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(697) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_m(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_mlp_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[str, float, str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : str
                Result of classifying the characters with the MLP.

    confidence : float
                 Confidence of the class of the characters.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_mlp, classify_class_mlp

    Alternatives
    ------------
    do_ocr_multi_class_mlp

    Predecessors
    ------------
    trainf_ocr_class_mlp, read_ocr_class_mlp
    """
    with HalconOperator(697) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.init_oct(3)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1),  # confidence
            proc.get_output_tuple_s(2),  # word
            proc.get_output_tuple_s(3)   # score
        )  # type: ignore


def do_ocr_word_svm(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[Sequence[str], str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : Sequence[str]
                Result of classifying the characters with the SVM.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_multi_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(679) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_m(0),  # class_val
            proc.get_output_tuple_s(1),  # word
            proc.get_output_tuple_s(2)   # score
        )  # type: ignore


def do_ocr_word_svm_s(
    character: HObject,
    image: HObject,
    ocrhandle: HHandle,
    expression: str,
    num_alternatives: int,
    num_corrections: int
) -> Tuple[str, str, float]:
    """
    Classify a related group of characters with an OCR classifier.

    Parameters
    ----------

    character : HObject
                Characters to be recognized.

    image : HObject
            Gray values of the characters.

    ocrhandle : HHandle
                Handle of the OCR classifier.

    expression : str
                 Expression describing the allowed word structure.

    num_alternatives : int
                       Number of classes per character considered for the
                       internal word correction.
                       Value Suggestion: 3

    num_corrections : int
                      Maximum number of corrected characters.
                      Value Suggestion: 2

    Returns
    -------

    class_val : str
                Result of classifying the characters with the SVM.

    word : str
           Word text after classification and correction.

    score : float
            Measure of similarity between corrected word and uncorrected
            classification results.

    See Also
    --------
    create_ocr_class_svm, classify_class_svm

    Alternatives
    ------------
    do_ocr_multi_class_svm

    Predecessors
    ------------
    trainf_ocr_class_svm, read_ocr_class_svm
    """
    with HalconOperator(679) as proc:
        proc.set_input_object(1, character)
        proc.set_input_object(2, image)
        proc.set_input_tuple(0, ocrhandle)
        proc.set_input_tuple(1, expression)
        proc.set_input_tuple(2, num_alternatives)
        proc.set_input_tuple(3, num_corrections)
        proc.init_oct(0)
        proc.init_oct(1)
        proc.init_oct(2)
        proc.execute()
        return (
            proc.get_output_tuple_s(0),  # class_val
            proc.get_output_tuple_s(1),  # word
            proc.get_output_tuple_s(2)   # score
        )  # type: ignore


def do_ocv_simple(
    pattern: HObject,
    ocvhandle: HHandle,
    pattern_name: MaybeSequence[str],
    adapt_pos: str,
    adapt_size: str,
    adapt_angle: str,
    adapt_gray: str,
    threshold: float
) -> Sequence[float]:
    """
    Verification of a pattern using an OCV tool.

    Parameters
    ----------

    pattern : HObject
              Characters to be v