# coding: utf-8

"""
    PocketSmith

    The public PocketSmith API  # noqa: E501

    The version of the OpenAPI document: 2.0
    Contact: api@pocketsmith.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pocketsmith.configuration import Configuration


class Category(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'children': 'list[Category]',
        'colour': 'str',
        'created_at': 'datetime',
        'id': 'int',
        'is_transfer': 'bool',
        'parent_id': 'int',
        'title': 'str',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'children': 'children',
        'colour': 'colour',
        'created_at': 'created_at',
        'id': 'id',
        'is_transfer': 'is_transfer',
        'parent_id': 'parent_id',
        'title': 'title',
        'updated_at': 'updated_at'
    }

    def __init__(self, children=None, colour=None, created_at=None, id=None, is_transfer=None, parent_id=None, title=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Category - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._children = None
        self._colour = None
        self._created_at = None
        self._id = None
        self._is_transfer = None
        self._parent_id = None
        self._title = None
        self._updated_at = None
        self.discriminator = None

        if children is not None:
            self.children = children
        if colour is not None:
            self.colour = colour
        if created_at is not None:
            self.created_at = created_at
        if id is not None:
            self.id = id
        if is_transfer is not None:
            self.is_transfer = is_transfer
        if parent_id is not None:
            self.parent_id = parent_id
        if title is not None:
            self.title = title
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def children(self):
        """Gets the children of this Category.  # noqa: E501

        The category's child categories.  # noqa: E501

        :return: The children of this Category.  # noqa: E501
        :rtype: list[Category]
        """
        return self._children

    @children.setter
    def children(self, children):
        """Sets the children of this Category.

        The category's child categories.  # noqa: E501

        :param children: The children of this Category.  # noqa: E501
        :type: list[Category]
        """

        self._children = children

    @property
    def colour(self):
        """Gets the colour of this Category.  # noqa: E501

        The colour for the category.  # noqa: E501

        :return: The colour of this Category.  # noqa: E501
        :rtype: str
        """
        return self._colour

    @colour.setter
    def colour(self, colour):
        """Sets the colour of this Category.

        The colour for the category.  # noqa: E501

        :param colour: The colour of this Category.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                colour is not None and not re.search(r'^#[0-9a-fA-F]{6}', colour)):  # noqa: E501
            raise ValueError(r"Invalid value for `colour`, must be a follow pattern or equal to `/^#[0-9a-fA-F]{6}/`")  # noqa: E501

        self._colour = colour

    @property
    def created_at(self):
        """Gets the created_at of this Category.  # noqa: E501

        When the category was created.  # noqa: E501

        :return: The created_at of this Category.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Category.

        When the category was created.  # noqa: E501

        :param created_at: The created_at of this Category.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def id(self):
        """Gets the id of this Category.  # noqa: E501

        The unique identifier of the category.  # noqa: E501

        :return: The id of this Category.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Category.

        The unique identifier of the category.  # noqa: E501

        :param id: The id of this Category.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def is_transfer(self):
        """Gets the is_transfer of this Category.  # noqa: E501

        Whether this category has been marked as a transfer category.  # noqa: E501

        :return: The is_transfer of this Category.  # noqa: E501
        :rtype: bool
        """
        return self._is_transfer

    @is_transfer.setter
    def is_transfer(self, is_transfer):
        """Sets the is_transfer of this Category.

        Whether this category has been marked as a transfer category.  # noqa: E501

        :param is_transfer: The is_transfer of this Category.  # noqa: E501
        :type: bool
        """

        self._is_transfer = is_transfer

    @property
    def parent_id(self):
        """Gets the parent_id of this Category.  # noqa: E501

        The unique identifier of the parent category of this category, or null if this category has no parent (i.e. is a top-level category)  # noqa: E501

        :return: The parent_id of this Category.  # noqa: E501
        :rtype: int
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this Category.

        The unique identifier of the parent category of this category, or null if this category has no parent (i.e. is a top-level category)  # noqa: E501

        :param parent_id: The parent_id of this Category.  # noqa: E501
        :type: int
        """

        self._parent_id = parent_id

    @property
    def title(self):
        """Gets the title of this Category.  # noqa: E501

        The title of the category.  # noqa: E501

        :return: The title of this Category.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Category.

        The title of the category.  # noqa: E501

        :param title: The title of this Category.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def updated_at(self):
        """Gets the updated_at of this Category.  # noqa: E501

        When the category was last updated.  # noqa: E501

        :return: The updated_at of this Category.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Category.

        When the category was last updated.  # noqa: E501

        :param updated_at: The updated_at of this Category.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Category):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Category):
            return True

        return self.to_dict() != other.to_dict()
