#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_python.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
#
from __future__ import absolute_import, division, print_function, unicode_literals

import ast
import json
import warnings

import h2o
from h2o.base import Keyed
from h2o.grid import H2OGridSearch
from h2o.utils.shared_utils import quoted
from h2o.utils.typechecks import is_type
from h2o.estimators.estimator_base import H2OEstimator
from h2o.exceptions import H2OValueError
from h2o.frame import H2OFrame
from h2o.utils.typechecks import assert_is_type, Enum, numeric


class H2OStackedEnsembleEstimator(H2OEstimator):
    """
    Stacked Ensemble

    Builds a stacked ensemble (aka "super learner") machine learning method that uses two
    or more H2O learning algorithms to improve predictive performance. It is a loss-based
    supervised learning method that finds the optimal combination of a collection of prediction
    algorithms.This method supports regression and binary classification.

    :examples:

    >>> import h2o
    >>> h2o.init()
    >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
    >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
    >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
    >>> col_types = ["numeric", "numeric", "numeric", "enum",
    ...              "enum", "numeric", "numeric", "numeric", "numeric"]
    >>> data = h2o.import_file("http://h2o-public-test-data.s3.amazonaws.com/smalldata/prostate/prostate.csv", col_types=col_types)
    >>> train, test = data.split_frame(ratios=[.8], seed=1)
    >>> x = ["CAPSULE","GLEASON","RACE","DPROS","DCAPS","PSA","VOL"]
    >>> y = "AGE"
    >>> nfolds = 5
    >>> gbm = H2OGradientBoostingEstimator(nfolds=nfolds,
    ...                                    fold_assignment="Modulo",
    ...                                    keep_cross_validation_predictions=True)
    >>> gbm.train(x=x, y=y, training_frame=train)
    >>> rf = H2ORandomForestEstimator(nfolds=nfolds,
    ...                               fold_assignment="Modulo",
    ...                               keep_cross_validation_predictions=True)
    >>> rf.train(x=x, y=y, training_frame=train)
    >>> stack = H2OStackedEnsembleEstimator(model_id="ensemble",
    ...                                     training_frame=train,
    ...                                     validation_frame=test,
    ...                                     base_models=[gbm.model_id, rf.model_id])
    >>> stack.train(x=x, y=y, training_frame=train, validation_frame=test)
    >>> stack.model_performance()
    """

    algo = "stackedensemble"
    param_names = {"model_id", "training_frame", "response_column", "validation_frame", "blending_frame", "base_models",
                   "metalearner_algorithm", "metalearner_nfolds", "metalearner_fold_assignment",
                   "metalearner_fold_column", "metalearner_params", "seed", "keep_levelone_frame",
                   "export_checkpoints_dir"}

    def __init__(self, **kwargs):
        super(H2OStackedEnsembleEstimator, self).__init__()
        self._parms = {}
        for pname, pvalue in kwargs.items():
            if pname == 'model_id':
                self._id = pvalue
                self._parms["model_id"] = pvalue
            elif pname in self.param_names:
                # Using setattr(...) will invoke type-checking of the arguments
                setattr(self, pname, pvalue)
            else:
                raise H2OValueError("Unknown parameter %s = %r" % (pname, pvalue))
        self._parms["_rest_version"] = 99

    @property
    def training_frame(self):
        """
        Id of the training data frame.

        Type: ``H2OFrame``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, valid = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_fold_assignment="Random")
        >>> stack_blend.train(x=x, y=y, training_frame=train, validation_frame=valid)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("training_frame")

    @training_frame.setter
    def training_frame(self, training_frame):
        self._parms["training_frame"] = H2OFrame._validate(training_frame, 'training_frame')


    @property
    def response_column(self):
        """
        Response variable column.

        Type: ``str``.
        """
        return self._parms.get("response_column")

    @response_column.setter
    def response_column(self, response_column):
        assert_is_type(response_column, None, str)
        self._parms["response_column"] = response_column


    @property
    def validation_frame(self):
        """
        Id of the validation data frame.

        Type: ``H2OFrame``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, valid = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3 
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_fold_assignment="Random")
        >>> stack_blend.train(x=x, y=y, training_frame=train, validation_frame=valid)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("validation_frame")

    @validation_frame.setter
    def validation_frame(self, validation_frame):
        self._parms["validation_frame"] = H2OFrame._validate(validation_frame, 'validation_frame')


    @property
    def blending_frame(self):
        """
        Frame used to compute the predictions that serve as the training frame for the metalearner (triggers blending
        mode if provided)

        Type: ``H2OFrame``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=10,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("blending_frame")

    @blending_frame.setter
    def blending_frame(self, blending_frame):
        self._parms["blending_frame"] = H2OFrame._validate(blending_frame, 'blending_frame')


    @property
    def base_models(self):
        """
        List of models or grids (or their ids) to ensemble/stack together. Grids are expanded to individual models. If
        not using blending frame, then models must have been cross-validated using nfolds > 1, and folds must be
        identical across models.

        Type: ``List[str]``  (default: ``[]``).

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> col_types = ["numeric", "numeric", "numeric", "enum",
        ...              "enum", "numeric", "numeric", "numeric", "numeric"]
        >>> data = h2o.import_file("http://h2o-public-test-data.s3.amazonaws.com/smalldata/prostate/prostate.csv", col_types=col_types)
        >>> train, test = data.split_frame(ratios=[.8], seed=1)
        >>> x = ["CAPSULE","GLEASON","RACE","DPROS","DCAPS","PSA","VOL"]
        >>> y = "AGE"
        >>> nfolds = 5
        >>> gbm = H2OGradientBoostingEstimator(nfolds=nfolds,
        ...                                    fold_assignment="Modulo",
        ...                                    keep_cross_validation_predictions=True)
        >>> gbm.train(x=x, y=y, training_frame=train)
        >>> rf = H2ORandomForestEstimator(nfolds=nfolds,
        ...                               fold_assignment="Modulo",
        ...                               keep_cross_validation_predictions=True)
        >>> rf.train(x=x, y=y, training_frame=train)
        >>> stack = H2OStackedEnsembleEstimator(model_id="ensemble",
        ...                                     training_frame=train,
        ...                                     validation_frame=test,
        ...                                     base_models=[gbm.model_id, rf.model_id])
        >>> stack.train(x=x, y=y, training_frame=train, validation_frame=test)
        >>> stack.model_performance()
        """
        base_models = self.actual_params.get("base_models", [])
        base_models = [base_model["name"] for base_model in base_models]
        if len(base_models) == 0:
            base_models = self._parms.get("base_models")
        return base_models

    @base_models.setter
    def base_models(self, base_models):
        def _get_id(something):
            if isinstance(something, Keyed):
                return something.key
            return something

        if not is_type(base_models, list):
            base_models = [base_models]
        if is_type(base_models, [H2OEstimator, H2OGridSearch, str]):
            base_models = [_get_id(b) for b in base_models]
            self._parms["base_models"] = base_models
        else:
            assert_is_type(base_models, None)


    @property
    def metalearner_algorithm(self):
        """
        Type of algorithm to use as the metalearner. Options include 'AUTO' (GLM with non negative weights; if
        validation_frame is present, a lambda search is performed), 'deeplearning' (Deep Learning with default
        parameters), 'drf' (Random Forest with default parameters), 'gbm' (GBM with default parameters), 'glm' (GLM with
        default parameters), 'naivebayes' (NaiveBayes with default parameters), or 'xgboost' (if available, XGBoost with
        default parameters).

        One of: ``"auto"``, ``"deeplearning"``, ``"drf"``, ``"gbm"``, ``"glm"``, ``"naivebayes"``, ``"xgboost"``
        (default: ``"auto"``).

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_algorithm="gbm")
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("metalearner_algorithm")

    @metalearner_algorithm.setter
    def metalearner_algorithm(self, metalearner_algorithm):
        assert_is_type(metalearner_algorithm, None, Enum("auto", "deeplearning", "drf", "gbm", "glm", "naivebayes", "xgboost"))
        self._parms["metalearner_algorithm"] = metalearner_algorithm


    @property
    def metalearner_nfolds(self):
        """
        Number of folds for K-fold cross-validation of the metalearner algorithm (0 to disable or >= 2).

        Type: ``int``  (default: ``0``).

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_nfolds=3)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("metalearner_nfolds")

    @metalearner_nfolds.setter
    def metalearner_nfolds(self, metalearner_nfolds):
        assert_is_type(metalearner_nfolds, None, int)
        self._parms["metalearner_nfolds"] = metalearner_nfolds


    @property
    def metalearner_fold_assignment(self):
        """
        Cross-validation fold assignment scheme for metalearner cross-validation.  Defaults to AUTO (which is currently
        set to Random). The 'Stratified' option will stratify the folds based on the response variable, for
        classification problems.

        One of: ``"auto"``, ``"random"``, ``"modulo"``, ``"stratified"``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_fold_assignment="Random")
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("metalearner_fold_assignment")

    @metalearner_fold_assignment.setter
    def metalearner_fold_assignment(self, metalearner_fold_assignment):
        assert_is_type(metalearner_fold_assignment, None, Enum("auto", "random", "modulo", "stratified"))
        self._parms["metalearner_fold_assignment"] = metalearner_fold_assignment


    @property
    def metalearner_fold_column(self):
        """
        Column with cross-validation fold index assignment per observation for cross-validation of the metalearner.

        Type: ``str``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> train = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> test = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_test_5k.csv")
        >>> fold_column = "fold_id"
        >>> train[fold_column] = train.kfold_column(n_folds=3, seed=1)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> x.remove(fold_column)
        >>> train[y] = train[y].asfactor()
        >>> test[y] = test[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=10,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                     metalearner_fold_column=fold_column,
        ...                                     metalearner_params=dict(keep_cross_validation_models=True))
        >>> stack.train(x=x, y=y, training_frame=train)
        >>> stack.model_performance().auc()
        """
        return self._parms.get("metalearner_fold_column")

    @metalearner_fold_column.setter
    def metalearner_fold_column(self, metalearner_fold_column):
        assert_is_type(metalearner_fold_column, None, str)
        self._parms["metalearner_fold_column"] = metalearner_fold_column


    @property
    def metalearner_params(self):
        """
        Parameters for metalearner algorithm

        Type: ``dict``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> gbm_params = {"ntrees" : 100, "max_depth" : 6}
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           metalearner_algorithm="gbm",
        ...                                           metalearner_params=gbm_params)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        if self._parms.get("metalearner_params") != None:
            metalearner_params_dict =  ast.literal_eval(self._parms.get("metalearner_params"))
            for k in metalearner_params_dict:
                if len(metalearner_params_dict[k]) == 1: #single parameter
                    metalearner_params_dict[k] = metalearner_params_dict[k][0]
            return metalearner_params_dict
        else:
            return self._parms.get("metalearner_params")

    @metalearner_params.setter
    def metalearner_params(self, metalearner_params):
        assert_is_type(metalearner_params, None, dict)
        if metalearner_params is not None and metalearner_params != "":
            for k in metalearner_params:
                if ("[" and "]") not in str(metalearner_params[k]):
                    metalearner_params[k] = [metalearner_params[k]]
            self._parms["metalearner_params"] = str(json.dumps(metalearner_params))
        else:
            self._parms["metalearner_params"] = None


    @property
    def seed(self):
        """
        Seed for random numbers; passed through to the metalearner algorithm. Defaults to -1 (time-based random number)

        Type: ``int``  (default: ``-1``).

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           metalearner_fold_assignment="Random")
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("seed")

    @seed.setter
    def seed(self, seed):
        assert_is_type(seed, None, int)
        self._parms["seed"] = seed


    @property
    def keep_levelone_frame(self):
        """
        Keep level one frame used for metalearner training.

        Type: ``bool``  (default: ``False``).

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=1,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           keep_levelone_frame=True)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.model_performance(blend).auc()
        """
        return self._parms.get("keep_levelone_frame")

    @keep_levelone_frame.setter
    def keep_levelone_frame(self, keep_levelone_frame):
        assert_is_type(keep_levelone_frame, None, bool)
        self._parms["keep_levelone_frame"] = keep_levelone_frame


    @property
    def export_checkpoints_dir(self):
        """
        Automatically export generated models to this directory.

        Type: ``str``.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> import tempfile
        >>> from os import listdir
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> checkpoints_dir = tempfile.mkdtemp()
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=10,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           export_checkpoints_dir=checkpoints_dir)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> len(listdir(checkpoints_dir))
        """
        return self._parms.get("export_checkpoints_dir")

    @export_checkpoints_dir.setter
    def export_checkpoints_dir(self, export_checkpoints_dir):
        assert_is_type(export_checkpoints_dir, None, str)
        self._parms["export_checkpoints_dir"] = export_checkpoints_dir


    def metalearner(self):
        """Print the metalearner of an H2OStackedEnsembleEstimator.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=10,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           keep_levelone_frame=True)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.metalearner()
        """
        def _get_item(self, key):
            warnings.warn(
                "The usage of stacked_ensemble.metalearner()['name'] will be deprecated. "
                "Metalearner now returns the metalearner object. If you need to get the "
                "'name' please use stacked_ensemble.metalearner().model_id",
                DeprecationWarning
            )
            if key == "name":
                return self.model_id
            raise NotImplementedError

        model = self._model_json["output"]
        if "metalearner" in model and model["metalearner"] is not None:
            metalearner = h2o.get_model(model["metalearner"]["name"])
            metalearner.__class__.__getitem__ = _get_item
            return metalearner
        print("No metalearner for this model")

    def levelone_frame_id(self):
        """Fetch the levelone_frame_id for an H2OStackedEnsembleEstimator.

        :examples:

        >>> from h2o.estimators.random_forest import H2ORandomForestEstimator
        >>> from h2o.estimators.gbm import H2OGradientBoostingEstimator
        >>> from h2o.estimators.stackedensemble import H2OStackedEnsembleEstimator
        >>> higgs = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/testng/higgs_train_5k.csv")
        >>> train, blend = higgs.split_frame(ratios = [.8], seed = 1234)
        >>> x = train.columns
        >>> y = "response"
        >>> x.remove(y)
        >>> train[y] = train[y].asfactor()
        >>> blend[y] = blend[y].asfactor()
        >>> nfolds = 3
        >>> my_gbm = H2OGradientBoostingEstimator(distribution="bernoulli",
        ...                                       ntrees=10,
        ...                                       nfolds=nfolds,
        ...                                       fold_assignment="Modulo",
        ...                                       keep_cross_validation_predictions=True,
        ...                                       seed=1)
        >>> my_gbm.train(x=x, y=y, training_frame=train)
        >>> my_rf = H2ORandomForestEstimator(ntrees=50,
        ...                                  nfolds=nfolds,
        ...                                  fold_assignment="Modulo",
        ...                                  keep_cross_validation_predictions=True,
        ...                                  seed=1)
        >>> my_rf.train(x=x, y=y, training_frame=train)
        >>> stack_blend = H2OStackedEnsembleEstimator(base_models=[my_gbm, my_rf],
        ...                                           seed=1,
        ...                                           keep_levelone_frame=True)
        >>> stack_blend.train(x=x, y=y, training_frame=train, blending_frame=blend)
        >>> stack_blend.levelone_frame_id()
        """
        model = self._model_json["output"]
        if "levelone_frame_id" in model and model["levelone_frame_id"] is not None:
            return model["levelone_frame_id"]
        print("No levelone_frame_id for this model")

    def stacking_strategy(self):
        model = self._model_json["output"]
        if "stacking_strategy" in model and model["stacking_strategy"] is not None:
            return model["stacking_strategy"]
        print("No stacking strategy for this model")

    # Override train method to support blending
    def train(self, x=None, y=None, training_frame=None, blending_frame=None, **kwargs):
        has_training_frame = training_frame is not None or self.training_frame is not None
        blending_frame = H2OFrame._validate(blending_frame, 'blending_frame', required=not has_training_frame)

        if not has_training_frame:
            training_frame = blending_frame  # used to bypass default checks in super class and backend and to guarantee default metrics

        def extend_parms(parms):
            if blending_frame is not None:
                parms['blending_frame'] = blending_frame
            if self.metalearner_fold_column is not None:
                parms['ignored_columns'].remove(quoted(self.metalearner_fold_column))

        super(self.__class__, self)._train(x, y, training_frame,
                                           extend_parms_fn=extend_parms,
                                           **kwargs)
