IF (ROCSPARSE_LIBRARY_DIRS AND ROCSPARSE_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(ROCSPARSE INTERFACE LIBRARIES ${ROCSPARSE_LIBRARIES} LIBRARY_PATHS ${ROCSPARSE_LIBRARY_DIRS})
ELSEIF (ROCSPARSE_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(ROCSPARSE INTERFACE LIBRARIES ${ROCSPARSE_LIBRARIES})
ELSEIF (ROCSPARSE_LIBRARY_DIRS)
  KOKKOSKERNELS_FIND_IMPORTED(ROCSPARSE INTERFACE LIBRARIES rocsparse LIBRARY_PATHS ${ROCSPARSE_LIBRARY_DIRS})
ELSEIF (KokkosKernels_ROCSPARSE_ROOT)
  KOKKOSKERNELS_FIND_IMPORTED(ROCSPARSE INTERFACE
    LIBRARIES
      rocsparse
    LIBRARY_PATHS
      ${KokkosKernels_ROCSPARSE_ROOT}/lib
    HEADERS
      rocsparse.h
    HEADER_PATHS
      ${KokkosKernels_ROCSPARSE_ROOT}/include
  )
ELSEIF (DEFINED ENV{ROCM_PATH})
  MESSAGE(STATUS "Detected ROCM_PATH: ENV{ROCM_PATH}")
  SET(ROCSPARSE_ROOT "$ENV{ROCM_PATH}/rocsparse")
  KOKKOSKERNELS_FIND_IMPORTED(ROCSPARSE INTERFACE
    LIBRARIES
      rocsparse
    LIBRARY_PATHS
      ${ROCSPARSE_ROOT}/lib
    HEADERS
      rocsparse.h
    HEADER_PATHS
      ${ROCSPARSE_ROOT}/include
  )
ELSE()
  MESSAGE(ERROR "rocSPARSE was not detected properly, please disable it or provide sufficient information at configure time.")
  # Todo: figure out how to use the target defined during rocsparse installation
  # FIND_PACKAGE(ROCSPARSE REQUIRED)
  # KOKKOSKERNELS_CREATE_IMPORTED_TPL(ROCSPARSE INTERFACE LINK_LIBRARIES ${ROCSPARSE_LIBRARIES})
  # GET_TARGET_PROPERTY(ROCSPARSE_LINK_LIBRARIES ${ROCSPARSE_LIBRARIES} IMPORTED_LINK_INTERFACE_LIBRARIES)
ENDIF()