"""
    Apideck

    The Apideck OpenAPI Spec: SDK Optimized  # noqa: E501

    The version of the OpenAPI document: 8.85.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apideck.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from apideck.exceptions import ApiAttributeError


def lazy_import():
    from apideck.model.auth_type import AuthType
    from apideck.model.connection_configuration import ConnectionConfiguration
    from apideck.model.connection_state import ConnectionState
    from apideck.model.form_field import FormField
    from apideck.model.o_auth_grant_type import OAuthGrantType
    from apideck.model.webhook_subscription import WebhookSubscription
    globals()['AuthType'] = AuthType
    globals()['ConnectionConfiguration'] = ConnectionConfiguration
    globals()['ConnectionState'] = ConnectionState
    globals()['FormField'] = FormField
    globals()['OAuthGrantType'] = OAuthGrantType
    globals()['WebhookSubscription'] = WebhookSubscription


class Connection(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'LIVE': "live",
            'UPCOMING': "upcoming",
            'REQUESTED': "requested",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'service_id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'tag_line': (str,),  # noqa: E501
            'unified_api': (str,),  # noqa: E501
            'state': (ConnectionState,),  # noqa: E501
            'auth_type': (AuthType,),  # noqa: E501
            'oauth_grant_type': (OAuthGrantType,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'website': (str,),  # noqa: E501
            'icon': (str,),  # noqa: E501
            'logo': (str,),  # noqa: E501
            'authorize_url': (str, none_type,),  # noqa: E501
            'revoke_url': (str, none_type,),  # noqa: E501
            'settings': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'form_fields': ([FormField],),  # noqa: E501
            'configuration': ([ConnectionConfiguration],),  # noqa: E501
            'configurable_resources': ([str],),  # noqa: E501
            'resource_schema_support': ([str],),  # noqa: E501
            'resource_settings_support': ([str],),  # noqa: E501
            'settings_required_for_authorization': ([str],),  # noqa: E501
            'subscriptions': ([WebhookSubscription],),  # noqa: E501
            'has_guide': (bool,),  # noqa: E501
            'created_at': (float,),  # noqa: E501
            'updated_at': (float, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'service_id': 'service_id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'tag_line': 'tag_line',  # noqa: E501
        'unified_api': 'unified_api',  # noqa: E501
        'state': 'state',  # noqa: E501
        'auth_type': 'auth_type',  # noqa: E501
        'oauth_grant_type': 'oauth_grant_type',  # noqa: E501
        'status': 'status',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'website': 'website',  # noqa: E501
        'icon': 'icon',  # noqa: E501
        'logo': 'logo',  # noqa: E501
        'authorize_url': 'authorize_url',  # noqa: E501
        'revoke_url': 'revoke_url',  # noqa: E501
        'settings': 'settings',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'form_fields': 'form_fields',  # noqa: E501
        'configuration': 'configuration',  # noqa: E501
        'configurable_resources': 'configurable_resources',  # noqa: E501
        'resource_schema_support': 'resource_schema_support',  # noqa: E501
        'resource_settings_support': 'resource_settings_support',  # noqa: E501
        'settings_required_for_authorization': 'settings_required_for_authorization',  # noqa: E501
        'subscriptions': 'subscriptions',  # noqa: E501
        'has_guide': 'has_guide',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'service_id',  # noqa: E501
        'name',  # noqa: E501
        'tag_line',  # noqa: E501
        'unified_api',  # noqa: E501
        'status',  # noqa: E501
        'website',  # noqa: E501
        'icon',  # noqa: E501
        'logo',  # noqa: E501
        'authorize_url',  # noqa: E501
        'revoke_url',  # noqa: E501
        'form_fields',  # noqa: E501
        'configurable_resources',  # noqa: E501
        'resource_schema_support',  # noqa: E501
        'resource_settings_support',  # noqa: E501
        'settings_required_for_authorization',  # noqa: E501
        'subscriptions',  # noqa: E501
        'has_guide',  # noqa: E501
        'created_at',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Connection - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The unique identifier of the connection.. [optional]  # noqa: E501
            service_id (str): The ID of the service this connection belongs to.. [optional]  # noqa: E501
            name (str): The name of the connection. [optional]  # noqa: E501
            tag_line (str): [optional]  # noqa: E501
            unified_api (str): The unified API category where the connection belongs to.. [optional]  # noqa: E501
            state (ConnectionState): [optional]  # noqa: E501
            auth_type (AuthType): [optional]  # noqa: E501
            oauth_grant_type (OAuthGrantType): [optional]  # noqa: E501
            status (str): Status of the connection.. [optional]  # noqa: E501
            enabled (bool): Whether the connection is enabled or not. You can enable or disable a connection using the Update Connection API.. [optional]  # noqa: E501
            website (str): The website URL of the connection. [optional]  # noqa: E501
            icon (str): A visual icon of the connection, that will be shown in the Vault. [optional]  # noqa: E501
            logo (str): The logo of the connection, that will be shown in the Vault. [optional]  # noqa: E501
            authorize_url (str, none_type): The OAuth redirect URI. Redirect your users to this URI to let them authorize your app in the connector's UI. Before you can use this URI, you must add `redirect_uri` as a query parameter. Your users will be redirected to this `redirect_uri` after they granted access to your app in the connector's UI.. [optional]  # noqa: E501
            revoke_url (str, none_type): The OAuth revoke URI. Redirect your users to this URI to revoke this connection. Before you can use this URI, you must add `redirect_uri` as a query parameter. Your users will be redirected to this `redirect_uri` after they granted access to your app in the connector's UI.. [optional]  # noqa: E501
            settings ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Connection settings. Values will persist to `form_fields` with corresponding id. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Attach your own consumer specific metadata. [optional]  # noqa: E501
            form_fields ([FormField]): The settings that are wanted to create a connection.. [optional]  # noqa: E501
            configuration ([ConnectionConfiguration]): [optional]  # noqa: E501
            configurable_resources ([str]): [optional]  # noqa: E501
            resource_schema_support ([str]): [optional]  # noqa: E501
            resource_settings_support ([str]): [optional]  # noqa: E501
            settings_required_for_authorization ([str]): List of settings that are required to be configured on integration before authorization can occur. [optional]  # noqa: E501
            subscriptions ([WebhookSubscription]): [optional]  # noqa: E501
            has_guide (bool): Whether the connector has a guide available in the developer docs or not (https://docs.apideck.com/connectors/{service_id}/docs/consumer+connection).. [optional]  # noqa: E501
            created_at (float): [optional]  # noqa: E501
            updated_at (float, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Connection - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The unique identifier of the connection.. [optional]  # noqa: E501
            service_id (str): The ID of the service this connection belongs to.. [optional]  # noqa: E501
            name (str): The name of the connection. [optional]  # noqa: E501
            tag_line (str): [optional]  # noqa: E501
            unified_api (str): The unified API category where the connection belongs to.. [optional]  # noqa: E501
            state (ConnectionState): [optional]  # noqa: E501
            auth_type (AuthType): [optional]  # noqa: E501
            oauth_grant_type (OAuthGrantType): [optional]  # noqa: E501
            status (str): Status of the connection.. [optional]  # noqa: E501
            enabled (bool): Whether the connection is enabled or not. You can enable or disable a connection using the Update Connection API.. [optional]  # noqa: E501
            website (str): The website URL of the connection. [optional]  # noqa: E501
            icon (str): A visual icon of the connection, that will be shown in the Vault. [optional]  # noqa: E501
            logo (str): The logo of the connection, that will be shown in the Vault. [optional]  # noqa: E501
            authorize_url (str, none_type): The OAuth redirect URI. Redirect your users to this URI to let them authorize your app in the connector's UI. Before you can use this URI, you must add `redirect_uri` as a query parameter. Your users will be redirected to this `redirect_uri` after they granted access to your app in the connector's UI.. [optional]  # noqa: E501
            revoke_url (str, none_type): The OAuth revoke URI. Redirect your users to this URI to revoke this connection. Before you can use this URI, you must add `redirect_uri` as a query parameter. Your users will be redirected to this `redirect_uri` after they granted access to your app in the connector's UI.. [optional]  # noqa: E501
            settings ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Connection settings. Values will persist to `form_fields` with corresponding id. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Attach your own consumer specific metadata. [optional]  # noqa: E501
            form_fields ([FormField]): The settings that are wanted to create a connection.. [optional]  # noqa: E501
            configuration ([ConnectionConfiguration]): [optional]  # noqa: E501
            configurable_resources ([str]): [optional]  # noqa: E501
            resource_schema_support ([str]): [optional]  # noqa: E501
            resource_settings_support ([str]): [optional]  # noqa: E501
            settings_required_for_authorization ([str]): List of settings that are required to be configured on integration before authorization can occur. [optional]  # noqa: E501
            subscriptions ([WebhookSubscription]): [optional]  # noqa: E501
            has_guide (bool): Whether the connector has a guide available in the developer docs or not (https://docs.apideck.com/connectors/{service_id}/docs/consumer+connection).. [optional]  # noqa: E501
            created_at (float): [optional]  # noqa: E501
            updated_at (float, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
