"""
    Apideck

    The Apideck OpenAPI Spec: SDK Optimized  # noqa: E501

    The version of the OpenAPI document: 8.85.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apideck.api_client import ApiClient, Endpoint as _Endpoint
from apideck.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from apideck.model.bad_request_response import BadRequestResponse
from apideck.model.copy_folder_request import CopyFolderRequest
from apideck.model.create_drive_group_response import CreateDriveGroupResponse
from apideck.model.create_drive_response import CreateDriveResponse
from apideck.model.create_folder_request import CreateFolderRequest
from apideck.model.create_folder_response import CreateFolderResponse
from apideck.model.create_shared_link_response import CreateSharedLinkResponse
from apideck.model.create_upload_session_request import CreateUploadSessionRequest
from apideck.model.create_upload_session_response import CreateUploadSessionResponse
from apideck.model.delete_drive_group_response import DeleteDriveGroupResponse
from apideck.model.delete_drive_response import DeleteDriveResponse
from apideck.model.delete_file_response import DeleteFileResponse
from apideck.model.delete_folder_response import DeleteFolderResponse
from apideck.model.delete_shared_link_response import DeleteSharedLinkResponse
from apideck.model.delete_upload_session_response import DeleteUploadSessionResponse
from apideck.model.drive import Drive
from apideck.model.drive_group import DriveGroup
from apideck.model.drive_groups_filter import DriveGroupsFilter
from apideck.model.drives_filter import DrivesFilter
from apideck.model.files_filter import FilesFilter
from apideck.model.files_search import FilesSearch
from apideck.model.files_sort import FilesSort
from apideck.model.get_drive_group_response import GetDriveGroupResponse
from apideck.model.get_drive_groups_response import GetDriveGroupsResponse
from apideck.model.get_drive_response import GetDriveResponse
from apideck.model.get_drives_response import GetDrivesResponse
from apideck.model.get_file_response import GetFileResponse
from apideck.model.get_files_response import GetFilesResponse
from apideck.model.get_folder_response import GetFolderResponse
from apideck.model.get_shared_link_response import GetSharedLinkResponse
from apideck.model.get_shared_links_response import GetSharedLinksResponse
from apideck.model.get_upload_session_response import GetUploadSessionResponse
from apideck.model.not_found_response import NotFoundResponse
from apideck.model.payment_required_response import PaymentRequiredResponse
from apideck.model.shared_link import SharedLink
from apideck.model.unauthorized_response import UnauthorizedResponse
from apideck.model.unexpected_error_response import UnexpectedErrorResponse
from apideck.model.unprocessable_response import UnprocessableResponse
from apideck.model.update_drive_group_response import UpdateDriveGroupResponse
from apideck.model.update_drive_response import UpdateDriveResponse
from apideck.model.update_folder_request import UpdateFolderRequest
from apideck.model.update_folder_response import UpdateFolderResponse
from apideck.model.update_shared_link_response import UpdateSharedLinkResponse


class FileStorageApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.drive_groups_add_endpoint = _Endpoint(
            settings={
                'response_type': (CreateDriveGroupResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drive-groups',
                'operation_id': 'drive_groups_add',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'drive_group',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'drive_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'drive_group':
                        (DriveGroup,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'drive_group': 'body',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.drive_groups_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetDriveGroupsResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drive-groups',
                'operation_id': 'drive_groups_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'cursor',
                    'limit',
                    'filter',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                    'filter':
                        (DriveGroupsFilter,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'cursor': 'cursor',
                    'limit': 'limit',
                    'filter': 'filter',
                },
                'location_map': {
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'cursor': 'query',
                    'limit': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drive_groups_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteDriveGroupResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drive-groups/{id}',
                'operation_id': 'drive_groups_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drive_groups_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetDriveGroupResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drive-groups/{id}',
                'operation_id': 'drive_groups_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drive_groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateDriveGroupResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drive-groups/{id}',
                'operation_id': 'drive_groups_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'drive_group',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                    'drive_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'drive_group':
                        (DriveGroup,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'drive_group': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.drives_add_endpoint = _Endpoint(
            settings={
                'response_type': (CreateDriveResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drives',
                'operation_id': 'drives_add',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'drive',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'drive',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'drive':
                        (Drive,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'drive': 'body',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.drives_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetDrivesResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drives',
                'operation_id': 'drives_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'cursor',
                    'limit',
                    'filter',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                    'filter':
                        (DrivesFilter,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'cursor': 'cursor',
                    'limit': 'limit',
                    'filter': 'filter',
                },
                'location_map': {
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'cursor': 'query',
                    'limit': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drives_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteDriveResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drives/{id}',
                'operation_id': 'drives_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drives_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetDriveResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drives/{id}',
                'operation_id': 'drives_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.drives_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateDriveResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/drives/{id}',
                'operation_id': 'drives_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'drive',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                    'drive',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'drive':
                        (Drive,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'drive': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.files_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetFilesResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/files',
                'operation_id': 'files_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'cursor',
                    'limit',
                    'filter',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                    'filter':
                        (FilesFilter,),
                    'sort':
                        (FilesSort,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'cursor': 'cursor',
                    'limit': 'limit',
                    'filter': 'filter',
                    'sort': 'sort',
                },
                'location_map': {
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'cursor': 'query',
                    'limit': 'query',
                    'filter': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.files_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteFileResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/files/{id}',
                'operation_id': 'files_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.files_download_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/files/{id}/download',
                'operation_id': 'files_download',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.files_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetFileResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/files/{id}',
                'operation_id': 'files_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.files_search_endpoint = _Endpoint(
            settings={
                'response_type': (GetFilesResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/files/search',
                'operation_id': 'files_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'files_search',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'files_search',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'files_search':
                        (FilesSearch,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'files_search': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.folders_add_endpoint = _Endpoint(
            settings={
                'response_type': (CreateFolderResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/folders',
                'operation_id': 'folders_add',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_folder_request',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'create_folder_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_folder_request':
                        (CreateFolderRequest,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'create_folder_request': 'body',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.folders_copy_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateFolderResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/folders/{id}/copy',
                'operation_id': 'folders_copy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'copy_folder_request',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                    'copy_folder_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'copy_folder_request':
                        (CopyFolderRequest,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'copy_folder_request': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.folders_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteFolderResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/folders/{id}',
                'operation_id': 'folders_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.folders_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetFolderResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/folders/{id}',
                'operation_id': 'folders_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.folders_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateFolderResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/folders/{id}',
                'operation_id': 'folders_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'update_folder_request',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                    'update_folder_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'update_folder_request':
                        (UpdateFolderRequest,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'update_folder_request': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.shared_links_add_endpoint = _Endpoint(
            settings={
                'response_type': (CreateSharedLinkResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/shared-links',
                'operation_id': 'shared_links_add',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'shared_link',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'shared_link',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shared_link':
                        (SharedLink,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'shared_link': 'body',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.shared_links_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetSharedLinksResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/shared-links',
                'operation_id': 'shared_links_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'cursor',
                    'limit',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'cursor': 'cursor',
                    'limit': 'limit',
                },
                'location_map': {
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'cursor': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.shared_links_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteSharedLinkResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/shared-links/{id}',
                'operation_id': 'shared_links_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.shared_links_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetSharedLinkResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/shared-links/{id}',
                'operation_id': 'shared_links_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.shared_links_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateSharedLinkResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/shared-links/{id}',
                'operation_id': 'shared_links_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'shared_link',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                    'shared_link',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'shared_link':
                        (SharedLink,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'shared_link': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.upload_sessions_add_endpoint = _Endpoint(
            settings={
                'response_type': (CreateUploadSessionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/upload-sessions',
                'operation_id': 'upload_sessions_add',
                'http_method': 'POST',
                'servers': [
                    {
                        'url': "https://upload.apideck.com",
                        'description': "No description provided",
                    },
                ]
            },
            params_map={
                'all': [
                    'create_upload_session_request',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                ],
                'required': [
                    'create_upload_session_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_upload_session_request':
                        (CreateUploadSessionRequest,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                },
                'location_map': {
                    'create_upload_session_request': 'body',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.upload_sessions_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteUploadSessionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/upload-sessions/{id}',
                'operation_id': 'upload_sessions_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.upload_sessions_finish_endpoint = _Endpoint(
            settings={
                'response_type': (GetFileResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/upload-sessions/{id}/finish',
                'operation_id': 'upload_sessions_finish',
                'http_method': 'POST',
                'servers': [
                    {
                        'url': "https://upload.apideck.com",
                        'description': "No description provided",
                    },
                ]
            },
            params_map={
                'all': [
                    'id',
                    'raw',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'digest',
                    'body',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'raw':
                        (bool,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'digest':
                        (str,),
                    'body':
                        (dict,),
                },
                'attribute_map': {
                    'id': 'id',
                    'raw': 'raw',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'digest': 'digest',
                },
                'location_map': {
                    'id': 'path',
                    'raw': 'query',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'digest': 'header',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.upload_sessions_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetUploadSessionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/file-storage/upload-sessions/{id}',
                'operation_id': 'upload_sessions_one',
                'http_method': 'GET',
                'servers': [
                    {
                        'url': "https://upload.apideck.com",
                        'description': "No description provided",
                    },
                ]
            },
            params_map={
                'all': [
                    'id',
                    'consumer_id',
                    'app_id',
                    'service_id',
                    'raw',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'service_id':
                        (str,),
                    'raw':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'service_id': 'x-apideck-service-id',
                    'raw': 'raw',
                },
                'location_map': {
                    'id': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'service_id': 'header',
                    'raw': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def drive_groups_add(
        self,
        drive_group,
        **kwargs
    ):
        """Create DriveGroup  # noqa: E501

        Create DriveGroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drive_groups_add(drive_group, async_req=True)
        >>> result = thread.get()

        Args:
            drive_group (DriveGroup):

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateDriveGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['drive_group'] = \
            drive_group
        return self.drive_groups_add_endpoint.call_with_http_info(**kwargs)

    def drive_groups_all(
        self,
        **kwargs
    ):
        """List DriveGroups  # noqa: E501

        List DriveGroups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drive_groups_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            filter (DriveGroupsFilter): Apply filters. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetDriveGroupsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.drive_groups_all_endpoint.call_with_http_info(**kwargs)

    def drive_groups_delete(
        self,
        id,
        **kwargs
    ):
        """Delete DriveGroup  # noqa: E501

        Delete DriveGroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drive_groups_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteDriveGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.drive_groups_delete_endpoint.call_with_http_info(**kwargs)

    def drive_groups_one(
        self,
        id,
        **kwargs
    ):
        """Get DriveGroup  # noqa: E501

        Get DriveGroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drive_groups_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetDriveGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.drive_groups_one_endpoint.call_with_http_info(**kwargs)

    def drive_groups_update(
        self,
        id,
        drive_group,
        **kwargs
    ):
        """Update DriveGroup  # noqa: E501

        Update DriveGroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drive_groups_update(id, drive_group, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.
            drive_group (DriveGroup):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateDriveGroupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['drive_group'] = \
            drive_group
        return self.drive_groups_update_endpoint.call_with_http_info(**kwargs)

    def drives_add(
        self,
        drive,
        **kwargs
    ):
        """Create Drive  # noqa: E501

        Create Drive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drives_add(drive, async_req=True)
        >>> result = thread.get()

        Args:
            drive (Drive):

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateDriveResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['drive'] = \
            drive
        return self.drives_add_endpoint.call_with_http_info(**kwargs)

    def drives_all(
        self,
        **kwargs
    ):
        """List Drives  # noqa: E501

        List Drives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drives_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            filter (DrivesFilter): Apply filters. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetDrivesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.drives_all_endpoint.call_with_http_info(**kwargs)

    def drives_delete(
        self,
        id,
        **kwargs
    ):
        """Delete Drive  # noqa: E501

        Delete Drive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drives_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteDriveResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.drives_delete_endpoint.call_with_http_info(**kwargs)

    def drives_one(
        self,
        id,
        **kwargs
    ):
        """Get Drive  # noqa: E501

        Get Drive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drives_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetDriveResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.drives_one_endpoint.call_with_http_info(**kwargs)

    def drives_update(
        self,
        id,
        drive,
        **kwargs
    ):
        """Update Drive  # noqa: E501

        Update Drive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drives_update(id, drive, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.
            drive (Drive):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateDriveResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['drive'] = \
            drive
        return self.drives_update_endpoint.call_with_http_info(**kwargs)

    def files_all(
        self,
        **kwargs
    ):
        """List Files  # noqa: E501

        List Files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.files_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            filter (FilesFilter): Apply filters. [optional]
            sort (FilesSort): Apply sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFilesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.files_all_endpoint.call_with_http_info(**kwargs)

    def files_delete(
        self,
        id,
        **kwargs
    ):
        """Delete File  # noqa: E501

        Delete File  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.files_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteFileResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.files_delete_endpoint.call_with_http_info(**kwargs)

    def files_download(
        self,
        id,
        **kwargs
    ):
        """Download File  # noqa: E501

        Download File  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.files_download(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.files_download_endpoint.call_with_http_info(**kwargs)

    def files_one(
        self,
        id,
        **kwargs
    ):
        """Get File  # noqa: E501

        Get File  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.files_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFileResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.files_one_endpoint.call_with_http_info(**kwargs)

    def files_search(
        self,
        files_search,
        **kwargs
    ):
        """Search Files  # noqa: E501

        Search Files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.files_search(files_search, async_req=True)
        >>> result = thread.get()

        Args:
            files_search (FilesSearch):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFilesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['files_search'] = \
            files_search
        return self.files_search_endpoint.call_with_http_info(**kwargs)

    def folders_add(
        self,
        create_folder_request,
        **kwargs
    ):
        """Create Folder  # noqa: E501

        Create Folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.folders_add(create_folder_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_folder_request (CreateFolderRequest):

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateFolderResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['create_folder_request'] = \
            create_folder_request
        return self.folders_add_endpoint.call_with_http_info(**kwargs)

    def folders_copy(
        self,
        id,
        copy_folder_request,
        **kwargs
    ):
        """Copy Folder  # noqa: E501

        Copy Folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.folders_copy(id, copy_folder_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.
            copy_folder_request (CopyFolderRequest):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateFolderResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['copy_folder_request'] = \
            copy_folder_request
        return self.folders_copy_endpoint.call_with_http_info(**kwargs)

    def folders_delete(
        self,
        id,
        **kwargs
    ):
        """Delete Folder  # noqa: E501

        Delete Folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.folders_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteFolderResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.folders_delete_endpoint.call_with_http_info(**kwargs)

    def folders_one(
        self,
        id,
        **kwargs
    ):
        """Get Folder  # noqa: E501

        Get Folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.folders_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFolderResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.folders_one_endpoint.call_with_http_info(**kwargs)

    def folders_update(
        self,
        id,
        update_folder_request,
        **kwargs
    ):
        """Rename or move Folder  # noqa: E501

        Rename or move Folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.folders_update(id, update_folder_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.
            update_folder_request (UpdateFolderRequest):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateFolderResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['update_folder_request'] = \
            update_folder_request
        return self.folders_update_endpoint.call_with_http_info(**kwargs)

    def shared_links_add(
        self,
        shared_link,
        **kwargs
    ):
        """Create Shared Link  # noqa: E501

        Create Shared Link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shared_links_add(shared_link, async_req=True)
        >>> result = thread.get()

        Args:
            shared_link (SharedLink):

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateSharedLinkResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['shared_link'] = \
            shared_link
        return self.shared_links_add_endpoint.call_with_http_info(**kwargs)

    def shared_links_all(
        self,
        **kwargs
    ):
        """List SharedLinks  # noqa: E501

        List SharedLinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shared_links_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetSharedLinksResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.shared_links_all_endpoint.call_with_http_info(**kwargs)

    def shared_links_delete(
        self,
        id,
        **kwargs
    ):
        """Delete Shared Link  # noqa: E501

        Delete Shared Link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shared_links_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteSharedLinkResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.shared_links_delete_endpoint.call_with_http_info(**kwargs)

    def shared_links_one(
        self,
        id,
        **kwargs
    ):
        """Get Shared Link  # noqa: E501

        Get Shared Link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shared_links_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetSharedLinkResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.shared_links_one_endpoint.call_with_http_info(**kwargs)

    def shared_links_update(
        self,
        id,
        shared_link,
        **kwargs
    ):
        """Update Shared Link  # noqa: E501

        Update Shared Link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shared_links_update(id, shared_link, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.
            shared_link (SharedLink):

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateSharedLinkResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['shared_link'] = \
            shared_link
        return self.shared_links_update_endpoint.call_with_http_info(**kwargs)

    def upload_sessions_add(
        self,
        create_upload_session_request,
        **kwargs
    ):
        """Start Upload Session  # noqa: E501

        Start an Upload Session. Upload sessions are used to upload large files, use the [Upload File](#operation/filesUpload) endpoint to upload smaller files (up to 100MB).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_sessions_add(create_upload_session_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_upload_session_request (CreateUploadSessionRequest):

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateUploadSessionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['create_upload_session_request'] = \
            create_upload_session_request
        return self.upload_sessions_add_endpoint.call_with_http_info(**kwargs)

    def upload_sessions_delete(
        self,
        id,
        **kwargs
    ):
        """Abort Upload Session  # noqa: E501

        Abort Upload Session  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_sessions_delete(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteUploadSessionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.upload_sessions_delete_endpoint.call_with_http_info(**kwargs)

    def upload_sessions_finish(
        self,
        id,
        **kwargs
    ):
        """Finish Upload Session  # noqa: E501

        Finish Upload Session. Only call this endpoint after all File parts have been uploaded to [Upload part of File](#operation/uploadSessionsUpload).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_sessions_finish(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            digest (str): The RFC3230 message digest of the uploaded part. Only required for the Box connector. More information on the Box API docs [here](https://developer.box.com/reference/put-files-upload-sessions-id/#param-digest). [optional]
            body (dict): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFileResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.upload_sessions_finish_endpoint.call_with_http_info(**kwargs)

    def upload_sessions_one(
        self,
        id,
        **kwargs
    ):
        """Get Upload Session  # noqa: E501

        Get Upload Session. Use the `part_size` to split your file into parts. Upload the parts to the [Upload part of File](#operation/uploadSessionsUpload) endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_sessions_one(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the record you are acting upon.

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            service_id (str): Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.. [optional]
            raw (bool): Include raw response. Mostly used for debugging purposes. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUploadSessionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.upload_sessions_one_endpoint.call_with_http_info(**kwargs)

