# Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

from libc.stdint cimport uint8_t, uint16_t, uint32_t, uint64_t, uintptr_t, int64_t
from nautilus_trader.core.rust.core cimport CVec, UUID4_t

cdef extern from "../includes/model.h":

    const uintptr_t DEPTH10_LEN # = 10

    # The maximum length of ASCII characters for a `TradeId` string value (including null terminator).
    const uintptr_t TRADE_ID_LEN # = 37

    # The maximum fixed-point precision.
    const uint8_t FIXED_PRECISION # = 9

    # The scalar value corresponding to the maximum precision (10^9).
    const double FIXED_SCALAR # = 1000000000.0

    # The maximum valid money amount which can be represented.
    const double MONEY_MAX # = 9223372036.0

    # The minimum valid money amount which can be represented.
    const double MONEY_MIN # = -9223372036.0

    # The sentinel value for an unset or null price.
    const int64_t PRICE_UNDEF # = INT64_MAX

    # The sentinel value for an error or invalid price.
    const int64_t PRICE_ERROR # = INT64_MIN

    # The maximum valid price value which can be represented.
    const double PRICE_MAX # = 9223372036.0

    # The minimum valid price value which can be represented.
    const double PRICE_MIN # = -9223372036.0

    # The sentinel value for an unset or null quantity.
    const uint64_t QUANTITY_UNDEF # = UINT64_MAX

    # The maximum valid quantity value which can be represented.
    const double QUANTITY_MAX # = 18446744073.0

    # The minimum valid quantity value which can be represented.
    const double QUANTITY_MIN # = 0.0

    # An account type provided by a trading venue or broker.
    cpdef enum AccountType:
        # An account with unleveraged cash assets only.
        CASH # = 1,
        # An account which facilitates trading on margin, using account assets as collateral.
        MARGIN # = 2,
        # An account specific to betting markets.
        BETTING # = 3,

    # An aggregation source for derived data.
    cpdef enum AggregationSource:
        # The data is externally aggregated (outside the Nautilus system boundary).
        EXTERNAL # = 1,
        # The data is internally aggregated (inside the Nautilus system boundary).
        INTERNAL # = 2,

    # The side for the aggressing order of a trade in a market.
    cpdef enum AggressorSide:
        # There was no specific aggressor for the trade.
        NO_AGGRESSOR # = 0,
        # The BUY order was the aggressor for the trade.
        BUYER # = 1,
        # The SELL order was the aggressor for the trade.
        SELLER # = 2,

    # A broad financial market asset class.
    cpdef enum AssetClass:
        # Foreign exchange (FOREX) assets.
        FX # = 1,
        # Equity / stock assets.
        EQUITY # = 2,
        # Commodity assets.
        COMMODITY # = 3,
        # Debt based assets.
        DEBT # = 4,
        # Index based assets (baskets).
        INDEX # = 5,
        # Cryptocurrency or crypto token assets.
        CRYPTOCURRENCY # = 6,
        # Alternative assets.
        ALTERNATIVE # = 7,

    # The type of order book action for an order book event.
    cpdef enum BookAction:
        # An order is added to the book.
        ADD # = 1,
        # An existing order in the book is updated/modified.
        UPDATE # = 2,
        # An existing order in the book is deleted/canceled.
        DELETE # = 3,
        # The state of the order book is cleared.
        CLEAR # = 4,

    # The order book type, representing the type of levels granularity and delta updating heuristics.
    cpdef enum BookType:
        # Top-of-book best bid/ask, one level per side.
        L1_MBP # = 1,
        # Market by price, one order per level (aggregated).
        L2_MBP # = 2,
        # Market by order, multiple orders per level (full granularity).
        L3_MBO # = 3,

    # The order contigency type which specifies the behavior of linked orders.
    #
    # [FIX 5.0 SP2 : ContingencyType <1385> field](https://www.onixs.biz/fix-dictionary/5.0.sp2/tagnum_1385.html).
    cpdef enum ContingencyType:
        # Not a contingent order.
        NO_CONTINGENCY # = 0,
        # One-Cancels-the-Other.
        OCO # = 1,
        # One-Triggers-the-Other.
        OTO # = 2,
        # One-Updates-the-Other (by proportional quantity).
        OUO # = 3,

    # The broad currency type.
    cpdef enum CurrencyType:
        # A type of cryptocurrency or crypto token.
        CRYPTO # = 1,
        # A type of currency issued by governments which is not backed by a commodity.
        FIAT # = 2,
        # A type of currency that is based on the value of an underlying commodity.
        COMMODITY_BACKED # = 3,

    # The instrument class.
    cpdef enum InstrumentClass:
        # A spot market instrument class. The current market price of an instrument that is bought or sold for immediate delivery and payment.
        SPOT # = 1,
        # A swap instrument class. A derivative contract through which two parties exchange the cash flows or liabilities from two different financial instruments.
        SWAP # = 2,
        # A futures contract instrument class. A legal agreement to buy or sell an asset at a predetermined price at a specified time in the future.
        FUTURE # = 3,
        # A futures spread instrument class. A strategy involving the use of futures contracts to take advantage of price differentials between different contract months, underlying assets, or marketplaces.
        FUTURE_SPREAD # = 4,
        # A forward derivative instrument class. A customized contract between two parties to buy or sell an asset at a specified price on a future date.
        FORWARD # = 5,
        # A contract-for-difference (CFD) instrument class. A contract between an investor and a CFD broker to exchange the difference in the value of a financial product between the time the contract opens and closes.
        CFD # = 6,
        # A bond instrument class. A type of debt investment where an investor loans money to an entity (typically corporate or governmental) which borrows the funds for a defined period of time at a variable or fixed interest rate.
        BOND # = 7,
        # An options contract instrument class. A type of derivative that gives the holder the right, but not the obligation, to buy or sell an underlying asset at a predetermined price before or at a certain future date.
        OPTION # = 8,
        # An option spread instrument class. A strategy involving the purchase and/or sale of options on the same underlying asset with different strike prices or expiration dates to capitalize on expected market moves in a controlled cost environment.
        OPTION_SPREAD # = 9,
        # A warrant instrument class. A derivative that gives the holder the right, but not the obligation, to buy or sell a security—most commonly an equity—at a certain price before expiration.
        WARRANT # = 10,
        # A warrant instrument class. A derivative that gives the holder the right, but not the obligation, to buy or sell a security—most commonly an equity—at a certain price before expiration.
        SPORTS_BETTING # = 11,
        # A binary option instrument class. A type of derivative where the payoff is either a fixed monetary amount or nothing, based on a yes/no proposition about an underlying event.
        BINARY_OPTION # = 12,

    # The type of event for an instrument close.
    cpdef enum InstrumentCloseType:
        # When the market session ended.
        END_OF_SESSION # = 1,
        # When the instrument expiration was reached.
        CONTRACT_EXPIRED # = 2,

    # The liqudity side for a trade.
    cpdef enum LiquiditySide:
        # No liquidity side specified.
        NO_LIQUIDITY_SIDE # = 0,
        # The order passively provided liqudity to the market to complete the trade (made a market).
        MAKER # = 1,
        # The order aggressively took liqudity from the market to complete the trade.
        TAKER # = 2,

    # The status of an individual market on a trading venue.
    cpdef enum MarketStatus:
        # The instrument is trading.
        OPEN # = 1,
        # The instrument is in a pre-open period.
        CLOSED # = 2,
        # Trading in the instrument has been paused.
        PAUSED # = 3,
        # Trading in the instrument has been halted.
        # Trading in the instrument has been suspended.
        SUSPENDED # = 5,
        # Trading in the instrument is not available.
        NOT_AVAILABLE # = 6,

    # An action affecting the status of an individual market on a trading venue.
    cpdef enum MarketStatusAction:
        # No change.
        NONE # = 0,
        # The instrument is in a pre-open period.
        PRE_OPEN # = 1,
        # The instrument is in a pre-cross period.
        PRE_CROSS # = 2,
        # The instrument is quoting but not trading.
        QUOTING # = 3,
        # The instrument is in a cross/auction.
        CROSS # = 4,
        # The instrument is being opened through a trading rotation.
        ROTATION # = 5,
        # A new price indication is available for the instrument.
        NEW_PRICE_INDICATION # = 6,
        # The instrument is trading.
        TRADING # = 7,
        # Trading in the instrument has been halted.
        HALT # = 8,
        # Trading in the instrument has been paused.
        PAUSE # = 9,
        # Trading in the instrument has been suspended.
        SUSPEND # = 10,
        # The instrument is in a pre-close period.
        PRE_CLOSE # = 11,
        # Trading in the instrument has closed.
        CLOSE # = 12,
        # The instrument is in a post-close period.
        POST_CLOSE # = 13,
        # A change in short-selling restrictions.
        SHORT_SELL_RESTRICTION_CHANGE # = 14,
        # The instrument is not available for trading, either trading has closed or been halted.
        NOT_AVAILABLE_FOR_TRADING # = 15,

    # The order management system (OMS) type for a trading venue or trading strategy.
    cpdef enum OmsType:
        # There is no specific type of order management specified (will defer to the venue OMS).
        UNSPECIFIED # = 0,
        # The netting type where there is one position per instrument.
        NETTING # = 1,
        # The hedging type where there can be multiple positions per instrument.
        # This can be in LONG/SHORT directions, by position/ticket ID, or tracked virtually by
        # Nautilus.
        HEDGING # = 2,

    # The kind of options contract.
    cpdef enum OptionKind:
        # A Call option gives the holder the right, but not the obligation, to buy an underlying asset at a specified strike price within a specified period of time.
        CALL # = 1,
        # A Put option gives the holder the right, but not the obligation, to sell an underlying asset at a specified strike price within a specified period of time.
        PUT # = 2,

    # The order side for a specific order, or action related to orders.
    cpdef enum OrderSide:
        # No order side is specified.
        NO_ORDER_SIDE # = 0,
        # The order is a BUY.
        BUY # = 1,
        # The order is a SELL.
        SELL # = 2,

    # The status for a specific order.
    #
    # An order is considered _open_ for the following status:
    #  - `ACCEPTED`
    #  - `TRIGGERED`
    #  - `PENDING_UPDATE`
    #  - `PENDING_CANCEL`
    #  - `PARTIALLY_FILLED`
    #
    # An order is considered _in-flight_ for the following status:
    #  - `SUBMITTED`
    #  - `PENDING_UPDATE`
    #  - `PENDING_CANCEL`
    #
    # An order is considered _closed_ for the following status:
    #  - `DENIED`
    #  - `REJECTED`
    #  - `CANCELED`
    #  - `EXPIRED`
    #  - `FILLED`
    cpdef enum OrderStatus:
        # The order is initialized (instantiated) within the Nautilus system.
        INITIALIZED # = 1,
        # The order was denied by the Nautilus system, either for being invalid, unprocessable or exceeding a risk limit.
        DENIED # = 2,
        # The order became emulated by the Nautilus system in the `OrderEmulator` component.
        EMULATED # = 3,
        # The order was released by the Nautilus system from the `OrderEmulator` component.
        RELEASED # = 4,
        # The order was submitted by the Nautilus system to the external service or trading venue (awaiting acknowledgement).
        SUBMITTED # = 5,
        # The order was acknowledged by the trading venue as being received and valid (may now be working).
        ACCEPTED # = 6,
        # The order was rejected by the trading venue.
        REJECTED # = 7,
        # The order was canceled (closed/done).
        CANCELED # = 8,
        # The order reached a GTD expiration (closed/done).
        EXPIRED # = 9,
        # The order STOP price was triggered on a trading venue.
        TRIGGERED # = 10,
        # The order is currently pending a request to modify on a trading venue.
        PENDING_UPDATE # = 11,
        # The order is currently pending a request to cancel on a trading venue.
        PENDING_CANCEL # = 12,
        # The order has been partially filled on a trading venue.
        PARTIALLY_FILLED # = 13,
        # The order has been completely filled on a trading venue (closed/done).
        FILLED # = 14,

    # The type of order.
    cpdef enum OrderType:
        # A market order to buy or sell at the best available price in the current market.
        MARKET # = 1,
        # A limit order to buy or sell at a specific price or better.
        LIMIT # = 2,
        # A stop market order to buy or sell once the price reaches the specified stop/trigger price. When the stop price is reached, the order effectively becomes a market order.
        STOP_MARKET # = 3,
        # A stop limit order to buy or sell which combines the features of a stop order and a limit order. Once the stop/trigger price is reached, a stop-limit order effectively becomes a limit order.
        STOP_LIMIT # = 4,
        # A market-to-limit order is a market order that is to be executed as a limit order at the current best market price after reaching the market.
        MARKET_TO_LIMIT # = 5,
        # A market-if-touched order effectively becomes a market order when the specified trigger price is reached.
        MARKET_IF_TOUCHED # = 6,
        # A limit-if-touched order effectively becomes a limit order when the specified trigger price is reached.
        LIMIT_IF_TOUCHED # = 7,
        # A trailing stop market order sets the stop/trigger price at a fixed "trailing offset" amount from the market.
        TRAILING_STOP_MARKET # = 8,
        # A trailing stop limit order combines the features of a trailing stop order with those of a limit order.
        TRAILING_STOP_LIMIT # = 9,

    # The market side for a specific position, or action related to positions.
    cpdef enum PositionSide:
        # No position side is specified (only valid in the context of a filter for actions involving positions).
        NO_POSITION_SIDE # = 0,
        # A neural/flat position, where no position is currently held in the market.
        FLAT # = 1,
        # A long position in the market, typically acquired through one or many BUY orders.
        LONG # = 2,
        # A short position in the market, typically acquired through one or many SELL orders.
        SHORT # = 3,

    # The type of price for an instrument in a market.
    cpdef enum PriceType:
        # A quoted order price where a buyer is willing to buy a quantity of an instrument.
        BID # = 1,
        # A quoted order price where a seller is willing to sell a quantity of an instrument.
        ASK # = 2,
        # The midpoint between the best bid and best ask prices.
        MID # = 3,
        # The last price at which a trade was made for an instrument.
        LAST # = 4,

    # A record flag bit field, indicating event end and data information.
    cpdef enum RecordFlag:
        # Last message in the book event or packet from the venue for a given `instrument_id`.
        F_LAST # = (1 << 7),
        # Top-of-book message, not an individual order.
        F_TOB # = (1 << 6),
        # Message sourced from a replay, such as a snapshot server.
        F_SNAPSHOT # = (1 << 5),
        # Aggregated price level message, not an individual order.
        F_MBP # = (1 << 4),
        # Reserved for future use.
        RESERVED_2 # = (1 << 3),
        # Reserved for future use.
        RESERVED_1 # = (1 << 2),

    # The 'Time in Force' instruction for an order.
    cpdef enum TimeInForce:
        # Good-Till-Canceled (GTC) - the order remains active until canceled.
        GTC # = 1,
        # Immediate-Or-Cancel (IOC) - the order is filled as much as possible, the rest is canceled.
        IOC # = 2,
        # Fill-Or-Kill (FOK) - the order must be executed in full immediately, or it is canceled.
        FOK # = 3,
        # Good-Till-Date/Time (GTD) - the order is active until a specified date or time.
        GTD # = 4,
        # Day - the order is active until the end of the current trading session.
        DAY # = 5,
        # At the Opening (ATO) - the order is scheduled to be executed at the market's opening.
        AT_THE_OPEN # = 6,
        # At the Closing (ATC) - the order is scheduled to be executed at the market's closing.
        AT_THE_CLOSE # = 7,

    # The trading state for a node.
    cpdef enum TradingState:
        # Normal trading operations.
        ACTIVE # = 1,
        # Trading is completely halted, no new order commands will be emitted.
        HALTED # = 2,
        # Only order commands which would cancel order, or reduce position sizes are permitted.
        REDUCING # = 3,

    # The trailing offset type for an order type which specifies a trailing stop/trigger or limit price.
    cpdef enum TrailingOffsetType:
        # No trailing offset type is specified (invalid for trailing type orders).
        NO_TRAILING_OFFSET # = 0,
        # The trailing offset is based on a market price.
        PRICE # = 1,
        # The trailing offset is based on a percentage represented in basis points, of a market price.
        BASIS_POINTS # = 2,
        # The trailing offset is based on the number of ticks from a market price.
        TICKS # = 3,
        # The trailing offset is based on a price tier set by a specific trading venue.
        PRICE_TIER # = 4,

    # The trigger type for the stop/trigger price of an order.
    cpdef enum TriggerType:
        # No trigger type is specified (invalid for orders with a trigger).
        NO_TRIGGER # = 0,
        # The default trigger type set by the trading venue.
        DEFAULT # = 1,
        # Based on the last traded price for the instrument.
        LAST_PRICE # = 2,
        # Based on the mark price for the instrument.
        MARK_PRICE # = 3,
        # Based on the index price for the instrument.
        INDEX_PRICE # = 4,
        # Based on the top-of-book quoted prices for the instrument.
        BID_ASK # = 5,
        # Based on a 'double match' of the last traded price for the instrument
        DOUBLE_LAST # = 6,
        # Based on a 'double match' of the bid/ask price for the instrument
        DOUBLE_BID_ASK # = 7,
        # Based on both the [`TriggerType::LastTrade`] and [`TriggerType::BidAsk`].
        LAST_OR_BID_ASK # = 8,
        # Based on the mid-point of the [`TriggerType::BidAsk`].
        MID_POINT # = 9,

    # Represents a discrete price level in an order book.
    #
    # The level maintains a collection of orders as well as tracking insertion order
    # to preserve FIFO queue dynamics.
    cdef struct BookLevel:
        pass

    # Provides a high-performance, versatile order book.
    #
    # Maintains buy (bid) and sell (ask) orders in price-time priority, supporting multiple
    # market data formats:
    # - L3 (MBO): Market By Order - tracks individual orders with unique IDs.
    # - L2 (MBP): Market By Price - aggregates orders at each price level.
    # - L1 (MBP): Top-of-Book - maintains only the best bid and ask prices.
    cdef struct OrderBook:
        pass

    # Represents a grouped batch of `OrderBookDelta` updates for an `OrderBook`.
    #
    # This type cannot be `repr(C)` due to the `deltas` vec.
    cdef struct OrderBookDeltas_t:
        pass

    # Represents a synthetic instrument with prices derived from component instruments using a
    # formula.
    #
    # The `id` for the synthetic will become `{symbol}.{SYNTH}`.
    cdef struct SyntheticInstrument:
        pass

    # Represents a valid ticker symbol ID for a tradable instrument.
    cdef struct Symbol_t:
        char* _0;

    # Represents a valid trading venue ID.
    cdef struct Venue_t:
        char* _0;

    # Represents a valid instrument ID.
    #
    # The symbol and venue combination should uniquely identify the instrument.
    cdef struct InstrumentId_t:
        # The instruments ticker symbol.
        Symbol_t symbol;
        # The instruments trading venue.
        Venue_t venue;

    # Represents a price in a market.
    #
    # The number of decimal places may vary. For certain asset classes, prices may
    # have negative values. For example, prices for options instruments can be
    # negative under certain conditions.
    #
    # Handles up to 9 decimals of precision.
    #
    #  - `PRICE_MAX` = 9_223_372_036
    #  - `PRICE_MIN` = -9_223_372_036
    cdef struct Price_t:
        # The raw price as a signed 64-bit integer.
        # Represents the unscaled value, with `precision` defining the number of decimal places.
        int64_t raw;
        # The number of decimal places, with a maximum precision of 9.
        uint8_t precision;

    # Represents a quantity with a non-negative value.
    #
    # Capable of storing either a whole number (no decimal places) of 'contracts'
    # or 'shares' (instruments denominated in whole units) or a decimal value
    # containing decimal places for instruments denominated in fractional units.
    #
    # Handles up to 9 decimals of precision.
    #
    # - `QUANTITY_MAX` = 18_446_744_073
    # - `QUANTITY_MIN` = 0
    cdef struct Quantity_t:
        # The raw quantity as an unsigned 64-bit integer.
        # Represents the unscaled value, with `precision` defining the number of decimal places.
        uint64_t raw;
        # The number of decimal places, with a maximum precision of 9.
        uint8_t precision;

    # Represents an order in a book.
    cdef struct BookOrder_t:
        # The order side.
        OrderSide side;
        # The order price.
        Price_t price;
        # The order size.
        Quantity_t size;
        # The order ID.
        uint64_t order_id;

    # Represents a single change/delta in an order book.
    cdef struct OrderBookDelta_t:
        # The instrument ID for the book.
        InstrumentId_t instrument_id;
        # The order book delta action.
        BookAction action;
        # The order to apply.
        BookOrder_t order;
        # The record flags bit field indicating event end and data information.
        uint8_t flags;
        # The message sequence number assigned at the venue.
        uint64_t sequence;
        # UNIX timestamp (nanoseconds) when the book event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the struct was initialized.
        uint64_t ts_init;

    # C compatible Foreign Function Interface (FFI) for an underlying [`OrderBookDeltas`].
    #
    # This struct wraps `OrderBookDeltas` in a way that makes it compatible with C function
    # calls, enabling interaction with `OrderBookDeltas` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `OrderBookDeltas_API` to be
    # dereferenced to `OrderBookDeltas`, providing access to `OrderBookDeltas`'s methods without
    # having to manually access the underlying `OrderBookDeltas` instance.
    cdef struct OrderBookDeltas_API:
        OrderBookDeltas_t *_0;

    # Represents a aggregated order book update with a fixed depth of 10 levels per side.
    #
    # This structure is specifically designed for scenarios where a snapshot of the top 10 bid and
    # ask levels in an order book is needed. It differs from `OrderBookDelta` or `OrderBookDeltas`
    # in its fixed-depth nature and is optimized for cases where a full depth representation is not
    # required or practical.
    #
    # Note: This type is not compatible with `OrderBookDelta` or `OrderBookDeltas` due to
    # its specialized structure and limited depth use case.
    cdef struct OrderBookDepth10_t:
        # The instrument ID for the book.
        InstrumentId_t instrument_id;
        # The bid orders for the depth update.
        BookOrder_t bids[DEPTH10_LEN];
        # The ask orders for the depth update.
        BookOrder_t asks[DEPTH10_LEN];
        # The count of bid orders per level for the depth update.
        uint32_t bid_counts[DEPTH10_LEN];
        # The count of ask orders per level for the depth update.
        uint32_t ask_counts[DEPTH10_LEN];
        # The record flags bit field, indicating event end and data information.
        uint8_t flags;
        # The message sequence number assigned at the venue.
        uint64_t sequence;
        # UNIX timestamp (nanoseconds) when the book event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the struct was initialized.
        uint64_t ts_init;

    # Represents a single quote tick in a market.
    cdef struct QuoteTick_t:
        # The quotes instrument ID.
        InstrumentId_t instrument_id;
        # The top-of-book bid price.
        Price_t bid_price;
        # The top-of-book ask price.
        Price_t ask_price;
        # The top-of-book bid size.
        Quantity_t bid_size;
        # The top-of-book ask size.
        Quantity_t ask_size;
        # UNIX timestamp (nanoseconds) when the quote event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the struct was initialized.
        uint64_t ts_init;

    # Represents a valid trade match ID (assigned by a trading venue).
    #
    # The unique ID assigned to the trade entity once it is received or matched by
    # the venue or central counterparty.
    #
    # Can correspond to the `TradeID <1003> field` of the FIX protocol.
    #
    # Maximum length is 36 characters.
    cdef struct TradeId_t:
        # The trade match ID value as a fixed-length C string byte array (includes null terminator).
        uint8_t value[TRADE_ID_LEN];

    # Represents a single trade tick in a market.
    cdef struct TradeTick_t:
        # The trade instrument ID.
        InstrumentId_t instrument_id;
        # The traded price.
        Price_t price;
        # The traded size.
        Quantity_t size;
        # The trade aggressor side.
        AggressorSide aggressor_side;
        # The trade match ID (assigned by the venue).
        TradeId_t trade_id;
        # UNIX timestamp (nanoseconds) when the trade event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the struct was initialized.
        uint64_t ts_init;

    # Represents a bar aggregation specification including a step, aggregation
    # method/rule and price type.
    cdef struct BarSpecification_t:
        # The step for binning samples for bar aggregation.
        uintptr_t step;
        # The type of bar aggregation.
        uint8_t aggregation;
        # The price type to use for aggregation.
        PriceType price_type;

    # Represents a bar type including the instrument ID, bar specification and
    # aggregation source.
    cpdef enum BarType_t_Tag:
        STANDARD,
        COMPOSITE,

    cdef struct Standard_Body:
        # The bar type's instrument ID.
        InstrumentId_t instrument_id;
        # The bar type's specification.
        BarSpecification_t spec;
        # The bar type's aggregation source.
        AggregationSource aggregation_source;

    cdef struct Composite_Body:
        # The bar type's instrument ID.
        InstrumentId_t instrument_id;
        # The bar type's specification.
        BarSpecification_t spec;
        # The bar type's aggregation source.
        AggregationSource aggregation_source;
        # The composite step for binning samples for bar aggregation.
        uintptr_t composite_step;
        # The composite type of bar aggregation.
        uint8_t composite_aggregation;
        # The composite bar type's aggregation source.
        AggregationSource composite_aggregation_source;

    cdef struct BarType_t:
        BarType_t_Tag tag;
        Standard_Body STANDARD;
        Composite_Body COMPOSITE;

    # Represents an aggregated bar.
    cdef struct Bar_t:
        # The bar type for this bar.
        BarType_t bar_type;
        # The bars open price.
        Price_t open;
        # The bars high price.
        Price_t high;
        # The bars low price.
        Price_t low;
        # The bars close price.
        Price_t close;
        # The bars volume.
        Quantity_t volume;
        # UNIX timestamp (nanoseconds) when the data event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the struct was initialized.
        uint64_t ts_init;

    # A built-in Nautilus data type.
    #
    # Not recommended for storing large amounts of data, as the largest variant is significantly
    # larger (10x) than the smallest.
    cpdef enum Data_t_Tag:
        DELTA,
        DELTAS,
        DEPTH10,
        QUOTE,
        TRADE,
        BAR,

    cdef struct Data_t:
        Data_t_Tag tag;
        OrderBookDelta_t delta;
        OrderBookDeltas_API deltas;
        OrderBookDepth10_t depth10;
        QuoteTick_t quote;
        TradeTick_t trade;
        Bar_t bar;

    # Represents a valid trader ID.
    cdef struct TraderId_t:
        char* _0;

    # Represents a valid strategy ID.
    cdef struct StrategyId_t:
        char* _0;

    # Represents a valid client order ID (assigned by the Nautilus system).
    cdef struct ClientOrderId_t:
        char* _0;

    cdef struct OrderDenied_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        char* reason;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;

    cdef struct OrderEmulated_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;

    cdef struct OrderReleased_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        Price_t released_price;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;

    # Represents a valid account ID.
    cdef struct AccountId_t:
        char* _0;

    cdef struct OrderSubmitted_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        AccountId_t account_id;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;

    # Represents a valid venue order ID (assigned by a trading venue).
    cdef struct VenueOrderId_t:
        char* _0;

    cdef struct OrderAccepted_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        VenueOrderId_t venue_order_id;
        AccountId_t account_id;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;
        uint8_t reconciliation;

    cdef struct OrderRejected_t:
        TraderId_t trader_id;
        StrategyId_t strategy_id;
        InstrumentId_t instrument_id;
        ClientOrderId_t client_order_id;
        AccountId_t account_id;
        char* reason;
        UUID4_t event_id;
        uint64_t ts_event;
        uint64_t ts_init;
        uint8_t reconciliation;

    # Represents a system client ID.
    cdef struct ClientId_t:
        char* _0;

    # Represents a valid component ID.
    cdef struct ComponentId_t:
        char* _0;

    # Represents a valid execution algorithm ID.
    cdef struct ExecAlgorithmId_t:
        char* _0;

    # Represents a valid order list ID (assigned by the Nautilus system).
    cdef struct OrderListId_t:
        char* _0;

    # Represents a valid position ID.
    cdef struct PositionId_t:
        char* _0;

    # C compatible Foreign Function Interface (FFI) for an underlying
    # [`SyntheticInstrument`].
    #
    # This struct wraps `SyntheticInstrument` in a way that makes it compatible with C function
    # calls, enabling interaction with `SyntheticInstrument` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `SyntheticInstrument_API` to be
    # dereferenced to `SyntheticInstrument`, providing access to `SyntheticInstruments`'s methods without
    # having to manually access the underlying instance.
    cdef struct SyntheticInstrument_API:
        SyntheticInstrument *_0;

    # C compatible Foreign Function Interface (FFI) for an underlying `OrderBook`.
    #
    # This struct wraps `OrderBook` in a way that makes it compatible with C function
    # calls, enabling interaction with `OrderBook` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `OrderBook_API` to be
    # dereferenced to `OrderBook`, providing access to `OrderBook`'s methods without
    # having to manually access the underlying `OrderBook` instance.
    cdef struct OrderBook_API:
        OrderBook *_0;

    # C compatible Foreign Function Interface (FFI) for an underlying order book[`Level`].
    #
    # This struct wraps `Level` in a way that makes it compatible with C function
    # calls, enabling interaction with `Level` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `Level_API` to be
    # dereferenced to `Level`, providing access to `Level`'s methods without
    # having to manually acce wss the underlying `Level` instance.
    cdef struct BookLevel_API:
        BookLevel *_0;

    # Represents a medium of exchange in a specified denomination with a fixed decimal precision.
    #
    # Handles up to 9 decimals of precision.
    cdef struct Currency_t:
        # The currency code as an alpha-3 string (e.g., "USD", "EUR").
        char* code;
        # The currency decimal precision.
        uint8_t precision;
        # The currency code (ISO 4217).
        uint16_t iso4217;
        # The full name of the currency.
        char* name;
        # The currency type, indicating its category (e.g. Fiat, Crypto).
        CurrencyType currency_type;

    # Represents an amount of money in a specified currency denomination.
    #
    # - `MONEY_MAX` = 9_223_372_036
    # - `MONEY_MIN` = -9_223_372_036
    cdef struct Money_t:
        # The raw monetary amount as a signed 64-bit integer.
        # Represents the unscaled amount, with `currency.precision` defining the number of decimal places.
        int64_t raw;
        # The currency denomination associated with the monetary amount.
        Currency_t currency;

    # Represents a NULL book order (used with the `Clear` action or where an order is not specified).
    const BookOrder_t NULL_ORDER # = <BookOrder_t>{ OrderSide_NoOrderSide, <Price_t>{ 0, 0 }, <Quantity_t>{ 0, 0 }, 0 }

    # The sentinel `Price` representing errors (this will be removed when Cython is gone).
    const Price_t ERROR_PRICE # = <Price_t>{ PRICE_ERROR, 0 }

    Data_t data_clone(const Data_t *data);

    void interned_string_stats();

    BarSpecification_t bar_specification_new(uintptr_t step,
                                             uint8_t aggregation,
                                             uint8_t price_type);

    # Returns a [`BarSpecification`] as a C string pointer.
    const char *bar_specification_to_cstr(const BarSpecification_t *bar_spec);

    uint64_t bar_specification_hash(const BarSpecification_t *bar_spec);

    uint8_t bar_specification_eq(const BarSpecification_t *lhs, const BarSpecification_t *rhs);

    uint8_t bar_specification_lt(const BarSpecification_t *lhs, const BarSpecification_t *rhs);

    uint8_t bar_specification_le(const BarSpecification_t *lhs, const BarSpecification_t *rhs);

    uint8_t bar_specification_gt(const BarSpecification_t *lhs, const BarSpecification_t *rhs);

    uint8_t bar_specification_ge(const BarSpecification_t *lhs, const BarSpecification_t *rhs);

    BarType_t bar_type_new(InstrumentId_t instrument_id,
                           BarSpecification_t spec,
                           uint8_t aggregation_source);

    BarType_t bar_type_new_composite(InstrumentId_t instrument_id,
                                     BarSpecification_t spec,
                                     AggregationSource aggregation_source,
                                     uintptr_t composite_step,
                                     uint8_t composite_aggregation,
                                     AggregationSource composite_aggregation_source);

    uint8_t bar_type_is_standard(const BarType_t *bar_type);

    uint8_t bar_type_is_composite(const BarType_t *bar_type);

    BarType_t bar_type_standard(const BarType_t *bar_type);

    BarType_t bar_type_composite(const BarType_t *bar_type);

    InstrumentId_t bar_type_instrument_id(const BarType_t *bar_type);

    BarSpecification_t bar_type_spec(const BarType_t *bar_type);

    AggregationSource bar_type_aggregation_source(const BarType_t *bar_type);

    # Returns any [`BarType`] parsing error from the provided C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    const char *bar_type_check_parsing(const char *ptr);

    # Returns a [`BarType`] from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    BarType_t bar_type_from_cstr(const char *ptr);

    uint8_t bar_type_eq(const BarType_t *lhs, const BarType_t *rhs);

    uint8_t bar_type_lt(const BarType_t *lhs, const BarType_t *rhs);

    uint8_t bar_type_le(const BarType_t *lhs, const BarType_t *rhs);

    uint8_t bar_type_gt(const BarType_t *lhs, const BarType_t *rhs);

    uint8_t bar_type_ge(const BarType_t *lhs, const BarType_t *rhs);

    uint64_t bar_type_hash(const BarType_t *bar_type);

    # Returns a [`BarType`] as a C string pointer.
    const char *bar_type_to_cstr(const BarType_t *bar_type);

    Bar_t bar_new(BarType_t bar_type,
                  Price_t open,
                  Price_t high,
                  Price_t low,
                  Price_t close,
                  Quantity_t volume,
                  uint64_t ts_event,
                  uint64_t ts_init);

    Bar_t bar_new_from_raw(BarType_t bar_type,
                           int64_t open,
                           int64_t high,
                           int64_t low,
                           int64_t close,
                           uint8_t price_prec,
                           uint64_t volume,
                           uint8_t size_prec,
                           uint64_t ts_event,
                           uint64_t ts_init);

    uint8_t bar_eq(const Bar_t *lhs, const Bar_t *rhs);

    uint64_t bar_hash(const Bar_t *bar);

    # Returns a [`Bar`] as a C string.
    const char *bar_to_cstr(const Bar_t *bar);

    OrderBookDelta_t orderbook_delta_new(InstrumentId_t instrument_id,
                                         BookAction action,
                                         BookOrder_t order,
                                         uint8_t flags,
                                         uint64_t sequence,
                                         uint64_t ts_event,
                                         uint64_t ts_init);

    uint8_t orderbook_delta_eq(const OrderBookDelta_t *lhs, const OrderBookDelta_t *rhs);

    uint64_t orderbook_delta_hash(const OrderBookDelta_t *delta);

    # Creates a new `OrderBookDeltas` instance from a `CVec` of `OrderBookDelta`.
    #
    # # Safety
    # - The `deltas` must be a valid pointer to a `CVec` containing `OrderBookDelta` objects
    # - This function clones the data pointed to by `deltas` into Rust-managed memory, then forgets the original `Vec` to prevent Rust from auto-deallocating it
    # - The caller is responsible for managing the memory of `deltas` (including its deallocation) to avoid memory leaks
    OrderBookDeltas_API orderbook_deltas_new(InstrumentId_t instrument_id,
                                             const CVec *deltas);

    void orderbook_deltas_drop(OrderBookDeltas_API deltas);

    OrderBookDeltas_API orderbook_deltas_clone(const OrderBookDeltas_API *deltas);

    InstrumentId_t orderbook_deltas_instrument_id(const OrderBookDeltas_API *deltas);

    CVec orderbook_deltas_vec_deltas(const OrderBookDeltas_API *deltas);

    uint8_t orderbook_deltas_is_snapshot(const OrderBookDeltas_API *deltas);

    uint8_t orderbook_deltas_flags(const OrderBookDeltas_API *deltas);

    uint64_t orderbook_deltas_sequence(const OrderBookDeltas_API *deltas);

    uint64_t orderbook_deltas_ts_event(const OrderBookDeltas_API *deltas);

    uint64_t orderbook_deltas_ts_init(const OrderBookDeltas_API *deltas);

    void orderbook_deltas_vec_drop(CVec v);

    # # Safety
    #
    # - Assumes `bids` and `asks` are valid pointers to arrays of `BookOrder` of length 10.
    # - Assumes `bid_counts` and `ask_counts` are valid pointers to arrays of `u32` of length 10.
    OrderBookDepth10_t orderbook_depth10_new(InstrumentId_t instrument_id,
                                             const BookOrder_t *bids_ptr,
                                             const BookOrder_t *asks_ptr,
                                             const uint32_t *bid_counts_ptr,
                                             const uint32_t *ask_counts_ptr,
                                             uint8_t flags,
                                             uint64_t sequence,
                                             uint64_t ts_event,
                                             uint64_t ts_init);

    uint8_t orderbook_depth10_eq(const OrderBookDepth10_t *lhs, const OrderBookDepth10_t *rhs);

    uint64_t orderbook_depth10_hash(const OrderBookDepth10_t *delta);

    const BookOrder_t *orderbook_depth10_bids_array(const OrderBookDepth10_t *depth);

    const BookOrder_t *orderbook_depth10_asks_array(const OrderBookDepth10_t *depth);

    const uint32_t *orderbook_depth10_bid_counts_array(const OrderBookDepth10_t *depth);

    const uint32_t *orderbook_depth10_ask_counts_array(const OrderBookDepth10_t *depth);

    BookOrder_t book_order_from_raw(OrderSide order_side,
                                    int64_t price_raw,
                                    uint8_t price_prec,
                                    uint64_t size_raw,
                                    uint8_t size_prec,
                                    uint64_t order_id);

    uint8_t book_order_eq(const BookOrder_t *lhs, const BookOrder_t *rhs);

    uint64_t book_order_hash(const BookOrder_t *order);

    double book_order_exposure(const BookOrder_t *order);

    double book_order_signed_size(const BookOrder_t *order);

    # Returns a [`BookOrder`] display string as a C string pointer.
    const char *book_order_display_to_cstr(const BookOrder_t *order);

    # Returns a [`BookOrder`] debug string as a C string pointer.
    const char *book_order_debug_to_cstr(const BookOrder_t *order);

    QuoteTick_t quote_tick_new(InstrumentId_t instrument_id,
                               int64_t bid_price_raw,
                               int64_t ask_price_raw,
                               uint8_t bid_price_prec,
                               uint8_t ask_price_prec,
                               uint64_t bid_size_raw,
                               uint64_t ask_size_raw,
                               uint8_t bid_size_prec,
                               uint8_t ask_size_prec,
                               uint64_t ts_event,
                               uint64_t ts_init);

    uint8_t quote_tick_eq(const QuoteTick_t *lhs, const QuoteTick_t *rhs);

    uint64_t quote_tick_hash(const QuoteTick_t *delta);

    # Returns a [`QuoteTick`] as a C string pointer.
    const char *quote_tick_to_cstr(const QuoteTick_t *quote);

    TradeTick_t trade_tick_new(InstrumentId_t instrument_id,
                               int64_t price_raw,
                               uint8_t price_prec,
                               uint64_t size_raw,
                               uint8_t size_prec,
                               AggressorSide aggressor_side,
                               TradeId_t trade_id,
                               uint64_t ts_event,
                               uint64_t ts_init);

    uint8_t trade_tick_eq(const TradeTick_t *lhs, const TradeTick_t *rhs);

    uint64_t trade_tick_hash(const TradeTick_t *delta);

    # Returns a [`TradeTick`] as a C string pointer.
    const char *trade_tick_to_cstr(const TradeTick_t *trade);

    const char *account_type_to_cstr(AccountType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    AccountType account_type_from_cstr(const char *ptr);

    const char *aggregation_source_to_cstr(AggregationSource value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    AggregationSource aggregation_source_from_cstr(const char *ptr);

    const char *aggressor_side_to_cstr(AggressorSide value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    AggressorSide aggressor_side_from_cstr(const char *ptr);

    const char *asset_class_to_cstr(AssetClass value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    AssetClass asset_class_from_cstr(const char *ptr);

    const char *instrument_class_to_cstr(InstrumentClass value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    InstrumentClass instrument_class_from_cstr(const char *ptr);

    const char *bar_aggregation_to_cstr(uint8_t value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    uint8_t bar_aggregation_from_cstr(const char *ptr);

    const char *book_action_to_cstr(BookAction value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    BookAction book_action_from_cstr(const char *ptr);

    const char *book_type_to_cstr(BookType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    BookType book_type_from_cstr(const char *ptr);

    const char *contingency_type_to_cstr(ContingencyType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    ContingencyType contingency_type_from_cstr(const char *ptr);

    const char *currency_type_to_cstr(CurrencyType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    CurrencyType currency_type_from_cstr(const char *ptr);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    InstrumentCloseType instrument_close_type_from_cstr(const char *ptr);

    const char *instrument_close_type_to_cstr(InstrumentCloseType value);

    const char *liquidity_side_to_cstr(LiquiditySide value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    LiquiditySide liquidity_side_from_cstr(const char *ptr);

    const char *market_status_to_cstr(MarketStatus value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    MarketStatus market_status_from_cstr(const char *ptr);

    const char *market_status_action_to_cstr(MarketStatusAction value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    MarketStatusAction market_status_action_from_cstr(const char *ptr);

    const char *oms_type_to_cstr(OmsType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OmsType oms_type_from_cstr(const char *ptr);

    const char *option_kind_to_cstr(OptionKind value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OptionKind option_kind_from_cstr(const char *ptr);

    const char *order_side_to_cstr(OrderSide value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OrderSide order_side_from_cstr(const char *ptr);

    const char *order_status_to_cstr(OrderStatus value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OrderStatus order_status_from_cstr(const char *ptr);

    const char *order_type_to_cstr(OrderType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OrderType order_type_from_cstr(const char *ptr);

    const char *position_side_to_cstr(PositionSide value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    PositionSide position_side_from_cstr(const char *ptr);

    const char *price_type_to_cstr(PriceType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    PriceType price_type_from_cstr(const char *ptr);

    const char *record_flag_to_cstr(RecordFlag value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    RecordFlag record_flag_from_cstr(const char *ptr);

    const char *time_in_force_to_cstr(TimeInForce value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TimeInForce time_in_force_from_cstr(const char *ptr);

    const char *trading_state_to_cstr(TradingState value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TradingState trading_state_from_cstr(const char *ptr);

    const char *trailing_offset_type_to_cstr(TrailingOffsetType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TrailingOffsetType trailing_offset_type_from_cstr(const char *ptr);

    const char *trigger_type_to_cstr(TriggerType value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TriggerType trigger_type_from_cstr(const char *ptr);

    # # Safety
    #
    # - Assumes `reason_ptr` is a valid C string pointer.
    OrderDenied_t order_denied_new(TraderId_t trader_id,
                                   StrategyId_t strategy_id,
                                   InstrumentId_t instrument_id,
                                   ClientOrderId_t client_order_id,
                                   const char *reason_ptr,
                                   UUID4_t event_id,
                                   uint64_t ts_event,
                                   uint64_t ts_init);

    OrderEmulated_t order_emulated_new(TraderId_t trader_id,
                                       StrategyId_t strategy_id,
                                       InstrumentId_t instrument_id,
                                       ClientOrderId_t client_order_id,
                                       UUID4_t event_id,
                                       uint64_t ts_event,
                                       uint64_t ts_init);

    OrderReleased_t order_released_new(TraderId_t trader_id,
                                       StrategyId_t strategy_id,
                                       InstrumentId_t instrument_id,
                                       ClientOrderId_t client_order_id,
                                       Price_t released_price,
                                       UUID4_t event_id,
                                       uint64_t ts_event,
                                       uint64_t ts_init);

    OrderSubmitted_t order_submitted_new(TraderId_t trader_id,
                                         StrategyId_t strategy_id,
                                         InstrumentId_t instrument_id,
                                         ClientOrderId_t client_order_id,
                                         AccountId_t account_id,
                                         UUID4_t event_id,
                                         uint64_t ts_event,
                                         uint64_t ts_init);

    OrderAccepted_t order_accepted_new(TraderId_t trader_id,
                                       StrategyId_t strategy_id,
                                       InstrumentId_t instrument_id,
                                       ClientOrderId_t client_order_id,
                                       VenueOrderId_t venue_order_id,
                                       AccountId_t account_id,
                                       UUID4_t event_id,
                                       uint64_t ts_event,
                                       uint64_t ts_init,
                                       uint8_t reconciliation);

    # # Safety
    #
    # - Assumes `reason_ptr` is a valid C string pointer.
    OrderRejected_t order_rejected_new(TraderId_t trader_id,
                                       StrategyId_t strategy_id,
                                       InstrumentId_t instrument_id,
                                       ClientOrderId_t client_order_id,
                                       AccountId_t account_id,
                                       const char *reason_ptr,
                                       UUID4_t event_id,
                                       uint64_t ts_event,
                                       uint64_t ts_init,
                                       uint8_t reconciliation);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    AccountId_t account_id_new(const char *ptr);

    uint64_t account_id_hash(const AccountId_t *id);

    # Returns a Nautilus identifier from C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    ClientId_t client_id_new(const char *ptr);

    uint64_t client_id_hash(const ClientId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    ClientOrderId_t client_order_id_new(const char *ptr);

    uint64_t client_order_id_hash(const ClientOrderId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    ComponentId_t component_id_new(const char *ptr);

    uint64_t component_id_hash(const ComponentId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    ExecAlgorithmId_t exec_algorithm_id_new(const char *ptr);

    uint64_t exec_algorithm_id_hash(const ExecAlgorithmId_t *id);

    InstrumentId_t instrument_id_new(Symbol_t symbol, Venue_t venue);

    # Returns any [`InstrumentId`] parsing error from the provided C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    const char *instrument_id_check_parsing(const char *ptr);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    InstrumentId_t instrument_id_from_cstr(const char *ptr);

    # Returns an [`InstrumentId`] as a C string pointer.
    const char *instrument_id_to_cstr(const InstrumentId_t *instrument_id);

    uint64_t instrument_id_hash(const InstrumentId_t *instrument_id);

    uint8_t instrument_id_is_synthetic(const InstrumentId_t *instrument_id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    OrderListId_t order_list_id_new(const char *ptr);

    uint64_t order_list_id_hash(const OrderListId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    PositionId_t position_id_new(const char *ptr);

    uint64_t position_id_hash(const PositionId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    StrategyId_t strategy_id_new(const char *ptr);

    uint64_t strategy_id_hash(const StrategyId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    Symbol_t symbol_new(const char *ptr);

    uint64_t symbol_hash(const Symbol_t *id);

    uint8_t symbol_is_composite(const Symbol_t *id);

    const char *symbol_root(const Symbol_t *id);

    const char *symbol_topic(const Symbol_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TradeId_t trade_id_new(const char *ptr);

    uint64_t trade_id_hash(const TradeId_t *id);

    const char *trade_id_to_cstr(const TradeId_t *trade_id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    TraderId_t trader_id_new(const char *ptr);

    uint64_t trader_id_hash(const TraderId_t *id);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    Venue_t venue_new(const char *ptr);

    uint64_t venue_hash(const Venue_t *id);

    uint8_t venue_is_synthetic(const Venue_t *venue);

    # # Safety
    #
    # - Assumes `code_ptr` is borrowed from a valid Python UTF-8 `str`.
    uint8_t venue_code_exists(const char *code_ptr);

    # # Safety
    #
    # - Assumes `code_ptr` is borrowed from a valid Python UTF-8 `str`.
    Venue_t venue_from_cstr_code(const char *code_ptr);

    # Returns a Nautilus identifier from a C string pointer.
    #
    # # Safety
    #
    # - Assumes `ptr` is a valid C string pointer.
    VenueOrderId_t venue_order_id_new(const char *ptr);

    uint64_t venue_order_id_hash(const VenueOrderId_t *id);

    # # Safety
    #
    # - Assumes `components_ptr` is a valid C string pointer of a JSON format list of strings.
    # - Assumes `formula_ptr` is a valid C string pointer.
    SyntheticInstrument_API synthetic_instrument_new(Symbol_t symbol,
                                                     uint8_t price_precision,
                                                     const char *components_ptr,
                                                     const char *formula_ptr,
                                                     uint64_t ts_event,
                                                     uint64_t ts_init);

    void synthetic_instrument_drop(SyntheticInstrument_API synth);

    InstrumentId_t synthetic_instrument_id(const SyntheticInstrument_API *synth);

    uint8_t synthetic_instrument_price_precision(const SyntheticInstrument_API *synth);

    Price_t synthetic_instrument_price_increment(const SyntheticInstrument_API *synth);

    const char *synthetic_instrument_formula_to_cstr(const SyntheticInstrument_API *synth);

    const char *synthetic_instrument_components_to_cstr(const SyntheticInstrument_API *synth);

    uintptr_t synthetic_instrument_components_count(const SyntheticInstrument_API *synth);

    uint64_t synthetic_instrument_ts_event(const SyntheticInstrument_API *synth);

    uint64_t synthetic_instrument_ts_init(const SyntheticInstrument_API *synth);

    # # Safety
    #
    # - Assumes `formula_ptr` is a valid C string pointer.
    uint8_t synthetic_instrument_is_valid_formula(const SyntheticInstrument_API *synth,
                                                  const char *formula_ptr);

    # # Safety
    #
    # - Assumes `formula_ptr` is a valid C string pointer.
    void synthetic_instrument_change_formula(SyntheticInstrument_API *synth,
                                             const char *formula_ptr);

    Price_t synthetic_instrument_calculate(SyntheticInstrument_API *synth, const CVec *inputs_ptr);

    OrderBook_API orderbook_new(InstrumentId_t instrument_id, BookType book_type);

    void orderbook_drop(OrderBook_API book);

    void orderbook_reset(OrderBook_API *book);

    InstrumentId_t orderbook_instrument_id(const OrderBook_API *book);

    BookType orderbook_book_type(const OrderBook_API *book);

    uint64_t orderbook_sequence(const OrderBook_API *book);

    uint64_t orderbook_ts_last(const OrderBook_API *book);

    uint64_t orderbook_count(const OrderBook_API *book);

    void orderbook_add(OrderBook_API *book,
                       BookOrder_t order,
                       uint8_t flags,
                       uint64_t sequence,
                       uint64_t ts_event);

    void orderbook_update(OrderBook_API *book,
                          BookOrder_t order,
                          uint8_t flags,
                          uint64_t sequence,
                          uint64_t ts_event);

    void orderbook_delete(OrderBook_API *book,
                          BookOrder_t order,
                          uint8_t flags,
                          uint64_t sequence,
                          uint64_t ts_event);

    void orderbook_clear(OrderBook_API *book, uint64_t sequence, uint64_t ts_event);

    void orderbook_clear_bids(OrderBook_API *book, uint64_t sequence, uint64_t ts_event);

    void orderbook_clear_asks(OrderBook_API *book, uint64_t sequence, uint64_t ts_event);

    void orderbook_apply_delta(OrderBook_API *book, const OrderBookDelta_t *delta);

    void orderbook_apply_deltas(OrderBook_API *book, const OrderBookDeltas_API *deltas);

    void orderbook_apply_depth(OrderBook_API *book, const OrderBookDepth10_t *depth);

    CVec orderbook_bids(OrderBook_API *book);

    CVec orderbook_asks(OrderBook_API *book);

    uint8_t orderbook_has_bid(OrderBook_API *book);

    uint8_t orderbook_has_ask(OrderBook_API *book);

    Price_t orderbook_best_bid_price(OrderBook_API *book);

    Price_t orderbook_best_ask_price(OrderBook_API *book);

    Quantity_t orderbook_best_bid_size(OrderBook_API *book);

    Quantity_t orderbook_best_ask_size(OrderBook_API *book);

    double orderbook_spread(OrderBook_API *book);

    double orderbook_midpoint(OrderBook_API *book);

    double orderbook_get_avg_px_for_quantity(OrderBook_API *book,
                                             Quantity_t qty,
                                             OrderSide order_side);

    double orderbook_get_quantity_for_price(OrderBook_API *book,
                                            Price_t price,
                                            OrderSide order_side);

    # Updates the order book with a quote tick.
    #
    # # Panics
    #
    # This function panics:
    # - If book type is not `L1_MBP`.
    void orderbook_update_quote_tick(OrderBook_API *book, const QuoteTick_t *quote);

    # Updates the order book with a trade tick.
    #
    # # Panics
    #
    # This function panics:
    # - If book type is not `L1_MBP`.
    void orderbook_update_trade_tick(OrderBook_API *book, const TradeTick_t *trade);

    CVec orderbook_simulate_fills(const OrderBook_API *book, BookOrder_t order);

    uint8_t orderbook_check_integrity(const OrderBook_API *book);

    void vec_fills_drop(CVec v);

    # Returns a pretty printed `OrderBook` number of levels per side, as a C string pointer.
    const char *orderbook_pprint_to_cstr(const OrderBook_API *book, uintptr_t num_levels);

    BookLevel_API level_new(OrderSide order_side, Price_t price, CVec orders);

    void level_drop(BookLevel_API level);

    BookLevel_API level_clone(const BookLevel_API *level);

    Price_t level_price(const BookLevel_API *level);

    CVec level_orders(const BookLevel_API *level);

    double level_size(const BookLevel_API *level);

    double level_exposure(const BookLevel_API *level);

    void vec_levels_drop(CVec v);

    void vec_orders_drop(CVec v);

    # Returns a [`Currency`] from pointers and primitives.
    #
    # # Safety
    #
    # - Assumes `code_ptr` is a valid C string pointer.
    # - Assumes `name_ptr` is a valid C string pointer.
    Currency_t currency_from_py(const char *code_ptr,
                                uint8_t precision,
                                uint16_t iso4217,
                                const char *name_ptr,
                                CurrencyType currency_type);

    const char *currency_to_cstr(const Currency_t *currency);

    const char *currency_code_to_cstr(const Currency_t *currency);

    const char *currency_name_to_cstr(const Currency_t *currency);

    uint64_t currency_hash(const Currency_t *currency);

    void currency_register(Currency_t currency);

    # # Safety
    #
    # - Assumes `code_ptr` is borrowed from a valid Python UTF-8 `str`.
    uint8_t currency_exists(const char *code_ptr);

    # # Safety
    #
    # - Assumes `code_ptr` is borrowed from a valid Python UTF-8 `str`.
    Currency_t currency_from_cstr(const char *code_ptr);

    Money_t money_new(double amount, Currency_t currency);

    Money_t money_from_raw(int64_t raw, Currency_t currency);

    double money_as_f64(const Money_t *money);

    void money_add_assign(Money_t a, Money_t b);

    void money_sub_assign(Money_t a, Money_t b);

    Price_t price_new(double value, uint8_t precision);

    Price_t price_from_raw(int64_t raw, uint8_t precision);

    double price_as_f64(const Price_t *price);

    void price_add_assign(Price_t a, Price_t b);

    void price_sub_assign(Price_t a, Price_t b);

    Quantity_t quantity_new(double value, uint8_t precision);

    Quantity_t quantity_from_raw(uint64_t raw, uint8_t precision);

    double quantity_as_f64(const Quantity_t *qty);

    void quantity_add_assign(Quantity_t a, Quantity_t b);

    void quantity_add_assign_u64(Quantity_t a, uint64_t b);

    void quantity_sub_assign(Quantity_t a, Quantity_t b);

    void quantity_sub_assign_u64(Quantity_t a, uint64_t b);
