from convertunits.utils import is_none, Base

class Volume(Base):
    def __init__(self, us_liquid_gallon = None, us_liquid_quart = None, us_liquid_pint = None, us_legal_cup = None, us_fluid_ounce = None, us_tablespoon = None, us_teaspoon = None, cubic_meter = None, liter = None, milliliter = None, imperial_gallon = None, imperial_quart = None, imperial_pint = None, imperial_cup = None, imperial_fluid_ounce = None, imperial_tablespoon = None, imperial_teaspoon = None, cubic_foot = None, cubic_inch = None):
        if not is_none(us_liquid_gallon):
            self.us_liquid_gallon = us_liquid_gallon
            self.us_liquid_quart = us_liquid_gallon * 4
            self.us_liquid_pint = us_liquid_gallon * 8
            self.us_legal_cup = us_liquid_gallon * 15.773
            self.us_fluid_ounce = us_liquid_gallon * 128
            self.us_tablespoon = us_liquid_gallon * 256
            self.us_teaspoon = us_liquid_gallon * 768
            self.cubic_meter = us_liquid_gallon / 264
            self.liter = us_liquid_gallon * 3.785
            self.milliliter = us_liquid_gallon * 3785
            self.imperial_gallon = us_liquid_gallon / 1.201
            self.imperial_quart = us_liquid_gallon * 3.331
            self.imperial_pint = us_liquid_gallon * 6.661
            self.imperial_cup = us_liquid_gallon * 13.323
            self.imperial_fluid_ounce = us_liquid_gallon * 133
            self.imperial_tablespoon = us_liquid_gallon * 213
            self.imperial_teaspoon = us_liquid_gallon * 639
            self.cubic_foot = us_liquid_gallon / 7.481
            self.cubic_inch = us_liquid_gallon * 231
        elif not is_none(us_liquid_quart):
            self.us_liquid_gallon = us_liquid_quart / 4
            self.us_liquid_quart = us_liquid_quart
            self.us_liquid_pint = us_liquid_quart * 2
            self.us_legal_cup = us_liquid_quart * 3.943
            self.us_fluid_ounce = us_liquid_quart * 32
            self.us_tablespoon = us_liquid_quart * 64
            self.us_teaspoon = us_liquid_quart * 192
            self.cubic_meter = us_liquid_quart / 1057
            self.liter = us_liquid_quart / 1.057
            self.milliliter = us_liquid_quart * 946
            self.imperial_gallon = us_liquid_quart / 4.804
            self.imperial_quart = us_liquid_quart / 1.201
            self.imperial_pint = us_liquid_quart * 1.665
            self.imperial_cup = us_liquid_quart * 3.331
            self.imperial_fluid_ounce = us_liquid_quart * 33.307
            self.imperial_tablespoon = us_liquid_quart * 53.291
            self.imperial_teaspoon = us_liquid_quart * 160
            self.cubic_foot = us_liquid_quart / 29.922
            self.cubic_inch = us_liquid_quart * 57.75
        elif not is_none(us_liquid_pint):
            self.us_liquid_gallon = us_liquid_pint / 8
            self.us_liquid_quart = us_liquid_pint / 2
            self.us_liquid_pint = us_liquid_pint
            self.us_legal_cup = us_liquid_pint * 1.972
            self.us_fluid_ounce = us_liquid_pint * 16
            self.us_tablespoon = us_liquid_pint * 32
            self.us_teaspoon = us_liquid_pint * 96
            self.cubic_meter = us_liquid_pint / 2113
            self.liter = us_liquid_pint / 2.113
            self.milliliter = us_liquid_pint * 473
            self.imperial_gallon = us_liquid_pint / 9.608
            self.imperial_quart = us_liquid_pint / 2.402
            self.imperial_pint = us_liquid_pint / 1.201
            self.imperial_cup = us_liquid_pint * 1.665
            self.imperial_fluid_ounce = us_liquid_pint * 16.653
            self.imperial_tablespoon = us_liquid_pint * 26.646
            self.imperial_teaspoon = us_liquid_pint * 79.937
            self.cubic_foot = us_liquid_pint / 59.844
            self.cubic_inch = us_liquid_pint * 28.875
        elif not is_none(us_legal_cup):
            self.us_liquid_gallon = us_legal_cup / 15.773
            self.us_liquid_quart = us_legal_cup / 3.943
            self.us_liquid_pint = us_legal_cup / 1.972
            self.us_legal_cup = us_legal_cup
            self.us_fluid_ounce = us_legal_cup * 8.115
            self.us_tablespoon = us_legal_cup * 16.231
            self.us_teaspoon = us_legal_cup * 48.692
            self.cubic_meter = us_legal_cup / 4167
            self.liter = us_legal_cup / 4.167
            self.milliliter = us_legal_cup * 240
            self.imperial_gallon = us_legal_cup / 18.942
            self.imperial_quart = us_legal_cup / 4.736
            self.imperial_pint = us_legal_cup / 2.368
            self.imperial_cup = us_legal_cup / 1.184
            self.imperial_fluid_ounce = us_legal_cup * 8.447
            self.imperial_tablespoon = us_legal_cup * 13.515
            self.imperial_teaspoon = us_legal_cup * 40.545
            self.cubic_foot = us_legal_cup / 118
            self.cubic_inch = us_legal_cup * 14.646
        elif not is_none(us_fluid_ounce):
            self.us_liquid_gallon = us_fluid_ounce / 128
            self.us_liquid_quart = us_fluid_ounce / 32
            self.us_liquid_pint = us_fluid_ounce / 16
            self.us_legal_cup = us_fluid_ounce / 8.115
            self.us_fluid_ounce = us_fluid_ounce
            self.us_tablespoon = us_fluid_ounce * 2
            self.us_teaspoon = us_fluid_ounce * 6
            self.cubic_meter = us_fluid_ounce / 33814
            self.liter = us_fluid_ounce / 33.814
            self.milliliter = us_fluid_ounce * 29.574
            self.imperial_gallon = us_fluid_ounce / 154
            self.imperial_quart = us_fluid_ounce / 38.43
            self.imperial_pint = us_fluid_ounce / 19.215
            self.imperial_cup = us_fluid_ounce / 9.608
            self.imperial_fluid_ounce = us_fluid_ounce * 1.041
            self.imperial_tablespoon = us_fluid_ounce * 1.665
            self.imperial_teaspoon = us_fluid_ounce * 4.996
            self.cubic_foot = us_fluid_ounce / 958
            self.cubic_inch = us_fluid_ounce * 1.805
        elif not is_none(us_tablespoon):
            self.us_liquid_gallon = us_tablespoon / 256
            self.us_liquid_quart = us_tablespoon / 64
            self.us_liquid_pint = us_tablespoon / 32
            self.us_legal_cup = us_tablespoon / 16.231
            self.us_fluid_ounce = us_tablespoon / 2
            self.us_tablespoon = us_tablespoon
            self.us_teaspoon = us_tablespoon * 3
            self.cubic_meter = us_tablespoon / 67628
            self.liter = us_tablespoon / 67.628
            self.milliliter = us_tablespoon * 14.787
            self.imperial_gallon = us_tablespoon / 307
            self.imperial_quart = us_tablespoon / 76.861
            self.imperial_pint = us_tablespoon / 38.43
            self.imperial_cup = us_tablespoon / 19.215
            self.imperial_fluid_ounce = us_tablespoon / 1.922
            self.imperial_tablespoon = us_tablespoon / 1.201
            self.imperial_teaspoon = us_tablespoon * 2.498
            self.cubic_foot = us_tablespoon / 1915
            self.cubic_inch = us_tablespoon / 1.108
        elif not is_none(us_teaspoon):
            self.us_liquid_gallon = us_teaspoon / 768
            self.us_liquid_quart = us_teaspoon / 192
            self.us_liquid_pint = us_teaspoon / 96
            self.us_legal_cup = us_teaspoon / 48.692
            self.us_fluid_ounce = us_teaspoon / 6
            self.us_tablespoon = us_teaspoon / 3
            self.us_teaspoon = us_teaspoon
            self.cubic_meter = us_teaspoon / 202884
            self.liter = us_teaspoon / 203
            self.milliliter = us_teaspoon * 4.929
            self.imperial_gallon = us_teaspoon / 922
            self.imperial_quart = us_teaspoon / 231
            self.imperial_pint = us_teaspoon / 115
            self.imperial_cup = us_teaspoon / 57.646
            self.imperial_fluid_ounce = us_teaspoon / 5.765
            self.imperial_tablespoon = us_teaspoon / 3.603
            self.imperial_teaspoon = us_teaspoon / 1.201
            self.cubic_foot = us_teaspoon / 5745
            self.cubic_inch = us_teaspoon / 3.325
        elif not is_none(cubic_meter):
            self.us_liquid_gallon = cubic_meter * 264
            self.us_liquid_quart = cubic_meter * 1057
            self.us_liquid_pint = cubic_meter * 2113
            self.us_legal_cup = cubic_meter * 4167
            self.us_fluid_ounce = cubic_meter * 33814
            self.us_tablespoon = cubic_meter * 67628
            self.us_teaspoon = cubic_meter * 202884
            self.cubic_meter = cubic_meter
            self.liter = cubic_meter * 1000
            self.milliliter = cubic_meter * 1e+6
            self.imperial_gallon = cubic_meter * 220
            self.imperial_quart = cubic_meter * 880
            self.imperial_pint = cubic_meter * 1760
            self.imperial_cup = cubic_meter * 3520
            self.imperial_fluid_ounce = cubic_meter * 35195
            self.imperial_tablespoon = cubic_meter * 56312
            self.imperial_teaspoon = cubic_meter * 168936
            self.cubic_foot = cubic_meter * 35.315
            self.cubic_inch = cubic_meter * 61024
        elif not is_none(liter):
            self.us_liquid_gallon = liter / 3.785
            self.us_liquid_quart = liter * 1.057
            self.us_liquid_pint = liter * 2.113
            self.us_legal_cup = liter * 4.167
            self.us_fluid_ounce = liter * 33.814
            self.us_tablespoon = liter * 67.628
            self.us_teaspoon = liter * 203
            self.cubic_meter = liter / 1000
            self.liter = liter
            self.milliliter = liter * 1000
            self.imperial_gallon = liter / 4.546
            self.imperial_quart = liter / 1.137
            self.imperial_pint = liter * 1.76
            self.imperial_cup = liter * 3.52
            self.imperial_fluid_ounce = liter * 35.195
            self.imperial_tablespoon = liter * 56.312
            self.imperial_teaspoon = liter * 169
            self.cubic_foot = liter / 28.317
            self.cubic_inch = liter * 61.024
        elif not is_none(milliliter):
            self.us_liquid_gallon = milliliter / 3785
            self.us_liquid_quart = milliliter / 946
            self.us_liquid_pint = milliliter / 473
            self.us_legal_cup = milliliter / 240
            self.us_fluid_ounce = milliliter / 29.574
            self.us_tablespoon = milliliter / 14.787
            self.us_teaspoon = milliliter / 4.929
            self.cubic_meter = milliliter / 1e+6
            self.liter = milliliter / 1000
            self.milliliter = milliliter
            self.imperial_gallon = milliliter / 4546
            self.imperial_quart = milliliter / 1137
            self.imperial_pint = milliliter / 568
            self.imperial_cup = milliliter / 284
            self.imperial_fluid_ounce = milliliter / 28.413
            self.imperial_tablespoon = milliliter / 17.758
            self.imperial_teaspoon = milliliter / 5.919
            self.cubic_foot = milliliter / 28317
            self.cubic_inch = milliliter / 16.387
        elif not is_none(imperial_gallon):
            self.us_liquid_gallon = imperial_gallon * 1.201
            self.us_liquid_quart = imperial_gallon * 4.804
            self.us_liquid_pint = imperial_gallon * 9.608
            self.us_legal_cup = imperial_gallon * 18.942
            self.us_fluid_ounce = imperial_gallon * 154
            self.us_tablespoon = imperial_gallon * 307
            self.us_teaspoon = imperial_gallon * 922
            self.cubic_meter = imperial_gallon / 220
            self.liter = imperial_gallon * 4.546
            self.milliliter = imperial_gallon * 4546
            self.imperial_gallon = imperial_gallon
            self.imperial_quart = imperial_gallon * 4
            self.imperial_pint = imperial_gallon * 8
            self.imperial_cup = imperial_gallon * 16
            self.imperial_fluid_ounce = imperial_gallon * 160
            self.imperial_tablespoon = imperial_gallon * 256
            self.imperial_teaspoon = imperial_gallon * 768
            self.cubic_foot = imperial_gallon / 6.229
            self.cubic_inch = imperial_gallon * 277
        elif not is_none(imperial_quart):
            self.us_liquid_gallon = imperial_quart / 3.331
            self.us_liquid_quart = imperial_quart * 1.201
            self.us_liquid_pint = imperial_quart * 2.402
            self.us_legal_cup = imperial_quart * 4.736
            self.us_fluid_ounce = imperial_quart * 38.43
            self.us_tablespoon = imperial_quart * 76.861
            self.us_teaspoon = imperial_quart * 231
            self.cubic_meter = imperial_quart / 880
            self.liter = imperial_quart * 1.137
            self.milliliter = imperial_quart * 1137
            self.imperial_gallon = imperial_quart / 4
            self.imperial_quart = imperial_quart
            self.imperial_pint = imperial_quart * 2
            self.imperial_cup = imperial_quart * 4
            self.imperial_fluid_ounce = imperial_quart * 40
            self.imperial_tablespoon = imperial_quart * 64
            self.imperial_teaspoon = imperial_quart * 192
            self.cubic_foot = imperial_quart / 24.915
            self.cubic_inch = imperial_quart * 69.355
        elif not is_none(imperial_pint):
            self.us_liquid_gallon = imperial_pint / 6.661
            self.us_liquid_quart = imperial_pint / 1.665
            self.us_liquid_pint = imperial_pint * 1.201
            self.us_legal_cup = imperial_pint * 2.368
            self.us_fluid_ounce = imperial_pint * 19.215
            self.us_tablespoon = imperial_pint * 38.43
            self.us_teaspoon = imperial_pint * 115
            self.cubic_meter = imperial_pint / 1760
            self.liter = imperial_pint / 1.76
            self.milliliter = imperial_pint * 568
            self.imperial_gallon = imperial_pint / 8
            self.imperial_quart = imperial_pint / 2
            self.imperial_pint = imperial_pint
            self.imperial_cup = imperial_pint * 2
            self.imperial_fluid_ounce = imperial_pint * 20
            self.imperial_tablespoon = imperial_pint * 32
            self.imperial_teaspoon = imperial_pint * 96
            self.cubic_foot = imperial_pint / 49.831
            self.cubic_inch = imperial_pint * 34.677
        elif not is_none(imperial_cup):
            self.us_liquid_gallon = imperial_cup / 13.323
            self.us_liquid_quart = imperial_cup / 3.331
            self.us_liquid_pint = imperial_cup / 1.665
            self.us_legal_cup = imperial_cup * 1.184
            self.us_fluid_ounce = imperial_cup * 9.608
            self.us_tablespoon = imperial_cup * 19.215
            self.us_teaspoon = imperial_cup * 57.646
            self.cubic_meter = imperial_cup / 3520
            self.liter = imperial_cup / 3.52
            self.milliliter = imperial_cup * 284
            self.imperial_gallon = imperial_cup / 16
            self.imperial_quart = imperial_cup / 4
            self.imperial_pint = imperial_cup / 2
            self.imperial_cup = imperial_cup
            self.imperial_fluid_ounce = imperial_cup * 10
            self.imperial_tablespoon = imperial_cup * 16
            self.imperial_teaspoon = imperial_cup * 48
            self.cubic_foot = imperial_cup / 99.661
            self.cubic_inch = imperial_cup * 17.339
        elif not is_none(imperial_fluid_ounce):
            self.us_liquid_gallon = imperial_fluid_ounce / 133
            self.us_liquid_quart = imperial_fluid_ounce / 33.307
            self.us_liquid_pint = imperial_fluid_ounce / 16.653
            self.us_legal_cup = imperial_fluid_ounce / 8.447
            self.us_fluid_ounce = imperial_fluid_ounce / 1.041
            self.us_tablespoon = imperial_fluid_ounce * 1.922
            self.us_teaspoon = imperial_fluid_ounce * 5.765
            self.cubic_meter = imperial_fluid_ounce / 35195
            self.liter = imperial_fluid_ounce / 35.195
            self.milliliter = imperial_fluid_ounce * 28.413
            self.imperial_gallon = imperial_fluid_ounce / 160
            self.imperial_quart = imperial_fluid_ounce / 40
            self.imperial_pint = imperial_fluid_ounce / 20
            self.imperial_cup = imperial_fluid_ounce / 10
            self.imperial_fluid_ounce = imperial_fluid_ounce
            self.imperial_tablespoon = imperial_fluid_ounce * 1.6
            self.imperial_teaspoon = imperial_fluid_ounce * 4.8
            self.cubic_foot = imperial_fluid_ounce / 997
            self.cubic_inch = imperial_fluid_ounce * 1.734
        elif not is_none(imperial_tablespoon):
            self.us_liquid_gallon = imperial_tablespoon / 213
            self.us_liquid_quart = imperial_tablespoon / 53.291
            self.us_liquid_pint = imperial_tablespoon / 26.646
            self.us_legal_cup = imperial_tablespoon / 13.515
            self.us_fluid_ounce = imperial_tablespoon / 1.665
            self.us_tablespoon = imperial_tablespoon * 1.201
            self.us_teaspoon = imperial_tablespoon * 3.603
            self.cubic_meter = imperial_tablespoon / 56312
            self.liter = imperial_tablespoon / 56.312
            self.milliliter = imperial_tablespoon * 17.758
            self.imperial_gallon = imperial_tablespoon / 256
            self.imperial_quart = imperial_tablespoon / 64
            self.imperial_pint = imperial_tablespoon / 32
            self.imperial_cup = imperial_tablespoon / 16
            self.imperial_fluid_ounce = imperial_tablespoon / 1.6
            self.imperial_tablespoon = imperial_tablespoon
            self.imperial_teaspoon = imperial_tablespoon * 3
            self.cubic_foot = imperial_tablespoon / 1595
            self.cubic_inch = imperial_tablespoon * 1.084
        elif not is_none(imperial_teaspoon):
            self.us_liquid_gallon = imperial_teaspoon / 639
            self.us_liquid_quart = imperial_teaspoon / 160
            self.us_liquid_pint = imperial_teaspoon / 79.937
            self.us_legal_cup = imperial_teaspoon / 40.545
            self.us_fluid_ounce = imperial_teaspoon / 4.996
            self.us_tablespoon = imperial_teaspoon / 2.498
            self.us_teaspoon = imperial_teaspoon * 1.201
            self.cubic_meter = imperial_teaspoon / 168936
            self.liter = imperial_teaspoon / 169
            self.milliliter = imperial_teaspoon * 5.919
            self.imperial_gallon = imperial_teaspoon / 768
            self.imperial_quart = imperial_teaspoon / 192
            self.imperial_pint = imperial_teaspoon / 96
            self.imperial_cup = imperial_teaspoon / 48
            self.imperial_fluid_ounce = imperial_teaspoon / 4.8
            self.imperial_tablespoon = imperial_teaspoon / 3
            self.imperial_teaspoon = imperial_teaspoon
            self.cubic_foot = imperial_teaspoon / 4784
            self.cubic_inch = imperial_teaspoon / 2.768
        elif not is_none(cubic_foot):
            self.us_liquid_gallon = cubic_foot * 7.481
            self.us_liquid_quart = cubic_foot * 29.922
            self.us_liquid_pint = cubic_foot * 59.844
            self.us_legal_cup = cubic_foot * 118
            self.us_fluid_ounce = cubic_foot * 958
            self.us_tablespoon = cubic_foot * 1915
            self.us_teaspoon = cubic_foot * 5745
            self.cubic_meter = cubic_foot / 35.315
            self.liter = cubic_foot * 28.317
            self.milliliter = cubic_foot * 28317
            self.imperial_gallon = cubic_foot * 6.229
            self.imperial_quart = cubic_foot * 24.915
            self.imperial_pint = cubic_foot * 49.831
            self.imperial_cup = cubic_foot * 99.661
            self.imperial_fluid_ounce = cubic_foot * 997
            self.imperial_tablespoon = cubic_foot * 1595
            self.imperial_teaspoon = cubic_foot * 4784
            self.cubic_foot = cubic_foot
            self.cubic_inch = cubic_foot * 1728
        elif not is_none(cubic_inch):
            self.us_liquid_gallon = cubic_inch / 231
            self.us_liquid_quart = cubic_inch / 57.75
            self.us_liquid_pint = cubic_inch / 28.875
            self.us_legal_cup = cubic_inch / 14.646
            self.us_fluid_ounce = cubic_inch / 1.805
            self.us_tablespoon = cubic_inch * 1.108
            self.us_teaspoon = cubic_inch * 3.325
            self.cubic_meter = cubic_inch / 61024
            self.liter = cubic_inch / 61.024
            self.milliliter = cubic_inch * 16.387
            self.imperial_gallon = cubic_inch / 277
            self.imperial_quart = cubic_inch / 69.355
            self.imperial_pint = cubic_inch / 34.677
            self.imperial_cup = cubic_inch / 17.339
            self.imperial_fluid_ounce = cubic_inch / 1.734
            self.imperial_tablespoon = cubic_inch / 1.084
            self.imperial_teaspoon = cubic_inch * 2.768
            self.cubic_foot = cubic_inch / 1728
            self.cubic_inch = cubic_inch
        else:
            raise TypeError(f"{self.__class__.__name__} expected 1 argument.")
    