"""empty message

Revision ID: 70402b468400
Revises: b2d74d4c0e01
Create Date: 2019-10-05 23:01:57.199337

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.sql import table, select


# revision identifiers, used by Alembic.
revision = '70402b468400'
down_revision = 'b2d74d4c0e01'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    menuitems_table = op.create_table(
        'menuitems',
        sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
        sa.Column('parent_id', sa.Integer(), nullable=True),
        sa.Column('slug', sa.String(length=255), nullable=False),
        sa.Column('title', sa.String(length=255), nullable=False),
        sa.Column('url', sa.String(length=255), nullable=False),
        sa.Column('weight', sa.Integer(), nullable=True),
        sa.Column('is_enabled', sa.Boolean(), nullable=True),
        sa.Column('can_edit', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['parent_id'], ['menuitems.id']),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('slug')
    )
    connection = op.get_bind()
    menulinks_table = table(
        'menulinks',
        sa.Column('slug', sa.VARCHAR(length=255), nullable=False),
        sa.Column('title', sa.VARCHAR(length=255), nullable=False),
        sa.Column('url', sa.VARCHAR(length=255), nullable=False),
        sa.Column('weight', sa.INTEGER(), nullable=True),
        sa.Column('is_enabled', sa.BOOLEAN(), nullable=True),
        sa.Column('can_edit', sa.BOOLEAN(), nullable=True)
    )
    result = connection.execute(select([menulinks_table]))
    rows = [dict(row) for row in result.fetchall()]
    op.bulk_insert(menuitems_table, rows)
    op.drop_table('menulinks')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    menulinks_table = op.create_table(
        'menulinks',
        sa.Column('id', sa.INTEGER(), nullable=False, autoincrement=True),
        sa.Column('slug', sa.VARCHAR(length=255), nullable=False),
        sa.Column('title', sa.VARCHAR(length=255), nullable=False),
        sa.Column('url', sa.VARCHAR(length=255), nullable=False),
        sa.Column('weight', sa.INTEGER(), nullable=True),
        sa.Column('is_enabled', sa.BOOLEAN(), nullable=True),
        sa.Column('can_edit', sa.BOOLEAN(), nullable=True),
        sa.CheckConstraint('can_edit IN (0, 1)'),
        sa.CheckConstraint('is_enabled IN (0, 1)'),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('slug')
    )
    connection = op.get_bind()
    menuitems_table = table('menuitems')
    result = connection.execute(select([
        menuitems_table.c.slug,
        menuitems_table.c.title,
        menuitems_table.c.url,
        menuitems_table.c.weight,
        menuitems_table.c.is_enabled,
        menuitems_table.c.can_edit
    ]))
    rows = [dict(row) for row in result.fetchall()]
    op.bulk_insert(menulinks_table, rows)
    op.drop_table('menuitems')
    # ### end Alembic commands ###
