/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import junit.framework.Assert;
import no.priv.garshol.duke.utils.CommandLineParser;
import no.priv.garshol.duke.utils.StringUtilsTest;
import org.junit.Before;
import org.junit.Test;

public class CommandLineParserTest {
    private CommandLineParser parser;

    @Before
    public void setup() {
        this.parser = new CommandLineParser();
    }

    @Test
    public void testEmpty() {
        String[] args = this.parser.parse(new String[0]);
        Assert.assertEquals((int)0, (int)args.length);
    }

    @Test
    public void testEmpty2() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.BooleanOption("test", 't'));
        String[] args = this.parser.parse(new String[0]);
        Assert.assertEquals((boolean)false, (boolean)this.parser.getOptionState("test"));
        Assert.assertEquals((int)0, (int)args.length);
    }

    @Test
    public void testSingleArgument() {
        String[] args = this.parser.parse(new String[]{"foo"});
        StringUtilsTest.assertEqual(new String[]{"foo"}, args);
    }

    @Test
    public void testSingleBooleanOption() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.BooleanOption("test", 't'));
        String[] args = this.parser.parse(new String[]{"--test", "foo"});
        Assert.assertEquals((boolean)true, (boolean)this.parser.getOptionState("test"));
        StringUtilsTest.assertEqual(new String[]{"foo"}, args);
    }

    @Test
    public void testSingleBooleanShortOption() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.BooleanOption("test", 't'));
        String[] args = this.parser.parse(new String[]{"-t", "foo"});
        Assert.assertEquals((boolean)true, (boolean)this.parser.getOptionState("test"));
        StringUtilsTest.assertEqual(new String[]{"foo"}, args);
    }

    @Test
    public void testSingleStringOption() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.StringOption("test", 't'));
        String[] args = this.parser.parse(new String[]{"--test=bar", "foo"});
        Assert.assertEquals((String)"bar", (String)this.parser.getOptionValue("test"));
        StringUtilsTest.assertEqual(new String[]{"foo"}, args);
    }

    @Test
    public void testSingleStringShortOption() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.StringOption("test", 't'));
        String[] args = this.parser.parse(new String[]{"-t=bar", "foo"});
        Assert.assertEquals((String)"bar", (String)this.parser.getOptionValue("test"));
        StringUtilsTest.assertEqual(new String[]{"foo"}, args);
    }

    @Test
    public void testUnknownOption() {
        try {
            this.parser.parse(new String[]{"-t", "foo"});
            Assert.fail((String)"didn't catch unregistered option");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testNotEnoughArguments() {
        this.parser.setMinimumArguments(1);
        try {
            this.parser.parse(new String[0]);
            Assert.fail((String)"didn't catch required missing argument");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testNotEnoughArguments2() {
        this.parser.setMinimumArguments(1);
        try {
            this.parser.parse(new String[]{"-t"});
            Assert.fail((String)"didn't catch required missing argument");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testNoValue() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.StringOption("test", 't'));
        try {
            this.parser.parse(new String[]{"-t"});
            Assert.fail((String)"didn't catch required missing value");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testLongShortConfusion() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.BooleanOption("test", 't'));
        try {
            this.parser.parse(new String[]{"-to"});
            Assert.fail((String)"didn't catch long name for short option");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testParamsAfterFile() {
        this.parser.registerOption((CommandLineParser.Option)new CommandLineParser.BooleanOption("test", 't'));
        try {
            this.parser.parse(new String[]{"config", "--test"});
            Assert.fail((String)"didn't catch parameter after file parameter");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }

    @Test
    public void testTooManyArguments() {
        this.parser.setMaximumArguments(1);
        try {
            this.parser.parse(new String[]{"foo", "bar"});
            Assert.fail((String)"didn't catch too many arguments");
        }
        catch (CommandLineParser.CommandLineParserException commandLineParserException) {
            // empty catch block
        }
    }
}

