/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import no.priv.garshol.duke.ConfigLoader;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.comparators.WeightedLevenshtein;
import no.priv.garshol.duke.databases.InMemoryDatabase;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ConfigLoaderTest {
    @Test
    public void testEmpty() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-empty.xml");
        Assert.assertTrue((boolean)config.getDataSources().isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.4);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.0);
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
    }

    @Test
    public void testString() throws IOException, SAXException {
        String cfg = "<duke><schema><threshold>0.4</threshold></schema></duke>";
        Configuration config = ConfigLoader.loadFromString((String)cfg);
        Assert.assertTrue((boolean)config.getDataSources().isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.4);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.0);
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
    }

    @Test
    public void testSingleGroup() throws IOException, SAXException {
        try {
            ConfigLoader.load((String)"classpath:config-single-group.xml");
            Assert.fail((String)"Config file with a single group was accepted");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultProbs() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-default-probs.xml");
        Property prop = config.getPropertyByName("FIRSTNAME");
        Assert.assertEquals((Object)0.5, (Object)prop.getHighProbability());
        Assert.assertEquals((Object)0.5, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)Property.Lookup.DEFAULT, (Object)prop.getLookupBehaviour());
    }

    @Test
    public void testDefaultComparator() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-no-comparator.xml");
        Property prop = config.getPropertyByName("LASTNAME");
        Assert.assertEquals(null, (Object)prop.getComparator());
        Assert.assertEquals((Object)Property.Lookup.DEFAULT, (Object)prop.getLookupBehaviour());
    }

    @Test
    public void testLookup() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-lookup.xml");
        Property prop = config.getPropertyByName("FIRSTNAME");
        Assert.assertEquals((Object)Property.Lookup.REQUIRED, (Object)prop.getLookupBehaviour());
        prop = config.getPropertyByName("LASTNAME");
        Assert.assertEquals((Object)Property.Lookup.DEFAULT, (Object)prop.getLookupBehaviour());
    }

    @Test
    public void testParameterOfNothing() throws IOException, SAXException {
        try {
            ConfigLoader.load((String)"classpath:config-no-object.xml");
            Assert.fail((String)"Config file setting parameters of nothing was accepted");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testCustomComparator() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-custom-comparator.xml");
        List comparators = config.getCustomComparators();
        Assert.assertEquals((int)1, (int)comparators.size());
    }

    @Test
    public void testCustomEstimator() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-custom-estimator.xml");
        List comparators = config.getCustomComparators();
        Assert.assertEquals((int)1, (int)comparators.size());
        WeightedLevenshtein wl = (WeightedLevenshtein)comparators.get(0);
        WeightedLevenshtein.DefaultWeightEstimator est = (WeightedLevenshtein.DefaultWeightEstimator)wl.getEstimator();
        Assert.assertEquals((Object)3.8, (Object)est.getDigitWeight());
    }

    @Test
    public void testDatabaseDefault() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-database.xml");
        Database db = config.getDatabase(false);
        Assert.assertTrue((boolean)(db instanceof InMemoryDatabase));
    }
}

