/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.util.Collection;
import junit.framework.Assert;
import no.priv.garshol.duke.EquivalenceClassDatabase;
import org.junit.Before;
import org.junit.Test;

public abstract class ClassDatabaseTest {
    private EquivalenceClassDatabase classdb;

    @Before
    public void setup() {
        this.classdb = this.createDatabase();
    }

    public abstract EquivalenceClassDatabase createDatabase();

    @Test
    public void testEmpty() {
        Assert.assertTrue((String)"nothing's happened, so there should be no links", (boolean)this.classdb.getClass("id1").isEmpty());
    }

    @Test
    public void testSingle() {
        this.classdb.addLink("id1", "id2");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id3").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2");
    }

    @Test
    public void testSingleSymmetric() {
        this.classdb.addLink("id1", "id2");
        this.classdb.addLink("id2", "id1");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id3").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2");
    }

    @Test
    public void testDouble() {
        this.classdb.addLink("id1", "id2");
        this.classdb.addLink("id3", "id4");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id5").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2");
        this.checkClass(this.classdb.getClass("id3"), "id3", "id4");
        this.checkClass(this.classdb.getClass("id4"), "id3", "id4");
    }

    @Test
    public void testDoubleMerge() {
        this.classdb.addLink("id1", "id2");
        this.classdb.addLink("id3", "id4");
        this.classdb.addLink("id1", "id3");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id5").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id3"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id4"), "id1", "id2", "id3", "id4");
    }

    @Test
    public void testFourOneByOne() {
        this.classdb.addLink("id1", "id2");
        this.classdb.addLink("id1", "id3");
        this.classdb.addLink("id1", "id4");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id5").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id3"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id4"), "id1", "id2", "id3", "id4");
    }

    @Test
    public void testFourOneByOne2() {
        this.classdb.addLink("id2", "id1");
        this.classdb.addLink("id1", "id3");
        this.classdb.addLink("id4", "id1");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id5").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id3"), "id1", "id2", "id3", "id4");
        this.checkClass(this.classdb.getClass("id4"), "id1", "id2", "id3", "id4");
    }

    @Test
    public void testBiggerIntoSmaller() {
        this.classdb.addLink("id1", "id2");
        this.classdb.addLink("id3", "id4");
        this.classdb.addLink("id5", "id6");
        this.classdb.addLink("id4", "id5");
        this.classdb.addLink("id1", "id3");
        this.classdb.commit();
        Assert.assertTrue((String)"unknown ID should have no class", (boolean)this.classdb.getClass("id7").isEmpty());
        this.checkClass(this.classdb.getClass("id1"), "id1", "id2", "id3", "id4", "id5", "id6");
        this.checkClass(this.classdb.getClass("id2"), "id1", "id2", "id3", "id4", "id5", "id6");
        this.checkClass(this.classdb.getClass("id3"), "id1", "id2", "id3", "id4", "id5", "id6");
        this.checkClass(this.classdb.getClass("id4"), "id1", "id2", "id3", "id4", "id5", "id6");
        this.checkClass(this.classdb.getClass("id5"), "id1", "id2", "id3", "id4", "id5", "id6");
        this.checkClass(this.classdb.getClass("id6"), "id1", "id2", "id3", "id4", "id5", "id6");
    }

    private void checkClass(Collection<String> klass, String ... ids) {
        Assert.assertEquals((String)"wrong size of class", (int)klass.size(), (int)ids.length);
        for (String id : ids) {
            Assert.assertTrue((String)("class must contain " + id), (boolean)klass.contains(id));
        }
    }
}

