/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.comparators.Levenshtein;
import no.priv.garshol.duke.comparators.WeightedLevenshtein;
import no.priv.garshol.duke.genetic.GeneticConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeneticConfigurationTest {
    private Configuration config1;

    @Before
    public void setup() {
        Levenshtein lev = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.3, 0.8));
        this.config1 = new ConfigurationImpl();
        ((ConfigurationImpl)this.config1).setProperties(props);
        ((ConfigurationImpl)this.config1).setThreshold(0.85);
    }

    @Test
    public void testMakeRandomCopy() {
        GeneticConfiguration conf = new GeneticConfiguration(this.config1);
        GeneticConfiguration confrand = conf.makeRandomCopy();
        Configuration rand = confrand.getConfiguration();
        Assert.assertTrue((String)"shouldn't have a parent", (conf.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"wrong parent", (confrand.getParent() == conf ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong number of properties", (long)rand.getProperties().size(), (long)3L);
        int aspects = 1 + 3 * (this.config1.getProperties().size() - 1);
        int differences = this.countDifferences(this.config1, rand);
        Assert.assertTrue((String)("Not enough differences: " + differences), (differences > 3 ? 1 : 0) != 0);
    }

    private int countDifferences(Configuration config, Configuration rand) {
        int differences = 0;
        if (rand.getThreshold() != config.getThreshold()) {
            ++differences;
        }
        Property prop = rand.getPropertyByName("ID");
        Assert.assertTrue((String)"ID property lost", (boolean)prop.isIdProperty());
        differences += this.checkProperty("NAME", config, rand);
        return differences += this.checkProperty("EMAIL", config, rand);
    }

    private int checkProperty(String name, Configuration config, Configuration rand) {
        Property prop = rand.getPropertyByName(name);
        Property orig = config.getPropertyByName(name);
        int differences = 0;
        if (!prop.getComparator().equals(orig.getComparator())) {
            ++differences;
        }
        if (prop.getHighProbability() != orig.getHighProbability()) {
            ++differences;
        }
        if (prop.getLowProbability() != orig.getLowProbability()) {
            ++differences;
        }
        return differences;
    }

    @Test
    public void testMutate() {
        GeneticConfiguration conf = new GeneticConfiguration(this.config1.copy());
        conf.mutate();
        Configuration rand = conf.getConfiguration();
        int diffs = this.countDifferences(this.config1, rand);
        if (diffs == 0) {
            conf.mutate();
            diffs = this.countDifferences(this.config1, rand);
            if (diffs == 0) {
                conf.mutate();
                diffs = this.countDifferences(this.config1, rand);
            }
        }
        Assert.assertEquals((String)"wrong number of differences", (long)1L, (long)diffs);
    }

    @Test
    public void testMate() {
        WeightedLevenshtein lev = new WeightedLevenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.2, 0.9));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.2, 0.9));
        ConfigurationImpl other = new ConfigurationImpl();
        other.setProperties(props);
        other.setThreshold(0.75);
        GeneticConfiguration g_other = new GeneticConfiguration((Configuration)other);
        GeneticConfiguration conf = new GeneticConfiguration(this.config1.copy());
        conf.mateWith(g_other);
        Configuration rand = conf.getConfiguration();
        Assert.assertEquals((String)"wrong number of differences", (long)7L, (long)(this.countDifferences(this.config1, rand) + this.countDifferences((Configuration)other, rand)));
    }
}

