/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleaner;
import no.priv.garshol.duke.datasources.CSVDataSource;
import no.priv.garshol.duke.datasources.Column;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CSVDataSourceTest {
    private CSVDataSource source;

    @Before
    public void setup() {
        this.source = new CSVDataSource();
    }

    @Test
    public void testEmpty() throws IOException {
        RecordIterator it = this.read("");
        Assert.assertTrue((!it.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testSingleRecord() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na,b,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testSingleRecordWithComment() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        this.source.setSkipLines(1);
        RecordIterator it = this.read("# this is a comment\nF1,F2,F3\na,b,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testSingleRecordWithoutHeader() throws IOException {
        this.source.addColumn(new Column("1", "F1", null, null));
        this.source.addColumn(new Column("2", "F2", null, null));
        this.source.addColumn(new Column("3", "F3", null, null));
        this.source.setHeaderLine(false);
        RecordIterator it = this.read("a,b,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testSingleRecordWithoutHeaderExtraColumn() throws IOException {
        this.source.addColumn(new Column("1", "F1", null, null));
        this.source.addColumn(new Column("2", "F2", null, null));
        this.source.addColumn(new Column("3", "F3", null, null));
        this.source.setHeaderLine(false);
        RecordIterator it = this.read("a,b,c,d");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testSingleRecordWithoutHeaderSkipColumn() throws IOException {
        this.source.addColumn(new Column("1", "F1", null, null));
        this.source.addColumn(new Column("3", "F3", null, null));
        this.source.setHeaderLine(false);
        RecordIterator it = this.read("a,b,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals(null, (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testColumnNotInHeader() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        this.source.addColumn(new Column("F4", null, null, null));
        try {
            RecordIterator it = this.read("F1,F2,F3\na,b,c");
            Record r = (Record)it.next();
            Assert.fail((String)"Didn't catch missing column F4");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaderNotInConfig() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        this.source.addColumn(new Column("F4", null, null, null));
        try {
            RecordIterator it = this.read("F5,F2,F3\na,b,c");
            Record r = (Record)it.next();
            Assert.fail((String)"Didn't catch unknown column F5");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testSplitting() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        Column c = new Column("F2", null, null, null);
        c.setSplitOn(";");
        this.source.addColumn(c);
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na,b;d;e,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
        Collection values = r.getValues("F2");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("b"));
        Assert.assertTrue((boolean)values.contains("d"));
        Assert.assertTrue((boolean)values.contains("e"));
    }

    @Test
    public void testSplittingCleaning() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        Column c = new Column("F2", null, null, (Cleaner)new LowerCaseNormalizeCleaner());
        c.setSplitOn(";");
        this.source.addColumn(c);
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na, b ; d ; e ,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
        Collection values = r.getValues("F2");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("b"));
        Assert.assertTrue((boolean)values.contains("d"));
        Assert.assertTrue((boolean)values.contains("e"));
    }

    @Test
    public void testNoValueForEmpty() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na,b,");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)r.getValue("F3"), null);
    }

    @Test
    public void testNoValueForEmptySplit() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        Column c = new Column("F2", null, null, null);
        c.setSplitOn(";");
        this.source.addColumn(c);
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na,b;;e,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
        Collection values = r.getValues("F2");
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("b"));
        Assert.assertTrue((boolean)values.contains("e"));
    }

    @Test
    public void testSeparator() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1;F2;F3\na;b;c", ';');
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    @Test
    public void testMissingHeader() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", null, null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        try {
            RecordIterator it = this.read("", ';');
            Assert.fail((String)"accepted file with no header");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testUseColumnTwice() throws IOException {
        this.source.addColumn(new Column("F1", null, null, null));
        this.source.addColumn(new Column("F2", "F2a", null, (Cleaner)new LowerCaseNormalizeCleaner()));
        this.source.addColumn(new Column("F2", "F2b", null, null));
        this.source.addColumn(new Column("F3", null, null, null));
        RecordIterator it = this.read("F1,F2,F3\na,B,c");
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"a", (Object)r.getValue("F1"));
        Assert.assertEquals((Object)"b", (Object)r.getValue("F2a"));
        Assert.assertEquals((Object)"B", (Object)r.getValue("F2b"));
        Assert.assertEquals((Object)"c", (Object)r.getValue("F3"));
    }

    private RecordIterator read(String csvdata) {
        return this.read(csvdata, ',');
    }

    private RecordIterator read(String csvdata, char separator) {
        this.source.setReader((Reader)new StringReader(csvdata));
        this.source.setSeparator(separator);
        return this.source.getRecords();
    }
}

